Ext.define('SpecificTestConfiguration.view.EgNutConfig', {
	extend: 'Ext.window.Window',
	alias: 'widget.egnutconfig',

	id : 'nutconfig',
	title: nutTitle,
	width: 580,
	//height: 320,
	modal: true,
	padding:'5 10 10 10',

	listeners : {
		close : function()
		{
			var compTypeVal = Ext.getCmp('componentType').getValue();
			var strTestName = publicJson['testName'];
			Ext.Ajax.request({
				url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+compTypeVal+'&componentType='+compTypeVal+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
				method:'POST'
			});
		}
	},

	dockedItems: [{
		dock: 'bottom',
		layout:{
			type:'hbox',
			align:'stretch',
			pack:'center'
		},
		border:false,
		padding : '10 0 0 0',
		items: [
			{
				xtype: 'button',
				cls: 'quickMenuWhiteButton',
				text: Update,
				id: 'UpdateBTN',
				width: 80
			},
			{
				xtype: 'button',
				cls: 'quickMenuWhiteButton',
				text: Clear,
				margin: '0 0 0 10',
				id: 'ClearBTN',
				width: 80
			}
		]
	}],

	items:[
		{
			xtype: 'container',
			layout: {
				type: 'vbox',
				align: 'center',
				pack: 'center'
			},
			defaults: {
				labelSeparator: ' ',
				margin: 5,
				width: 500,
				labelWidth: 250
			},
			margin: 5,
			items: [
				{
					xtype: 'textfield',
					cls: 'textbox',
					fieldLabel: nutIdLabel,
					value: 'None',
					id: 'vCenterIP'
				},
				{
					xtype: 'scrollcombo',
					cls: 'dropdown',
					id : 'SslVc',
					name: 'SslVc',
					fieldLabel : nutSSlLabel,
					fieldName: 'SslVc',
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local',
					value: 'true',
					editable: false,
					forceSelection: false,
					parent:this,
					store:new Ext.data.Store({
						fields: ['displayField','valueField'],
						data: [
							{'displayField':'Yes','valueField':'true'},
							{'displayField':'No','valueField':'false'}
						]
					})
				},
				{
					xtype: 'textfield',
					cls: 'textbox',
					fieldLabel: nutwebLabel,
					value: 9440,
					id: 'WebPort'
				},
				{
					xtype: 'scrollcombo',
					cls: 'dropdown',
					id : 'DiscVc',
					name: 'DiscVc',
					fieldLabel : nutDiscoverLabel,
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local',
					value: 'No',
					editable: false,
					forceSelection: false,
					parent:this,
					store:new Ext.data.Store({
						fields: ['displayField','valueField'],
						data: [
							{'displayField':'Yes','valueField':'Yes'},
							{'displayField':'No','valueField':'No'}
						]
					})
				},
				{
					xtype: 'textfield',
					cls: 'textbox',
					fieldLabel: nutUnmeLabel,
					value: '$unconfigured',
					id: 'UsrVc'
				},
				{
					xtype: 'textfield',
					cls: 'textbox',
					fieldLabel: nutPwdLabel,
					inputType: 'password',
					//value: '$unconfigured',
					id: 'PwdVc',
					backupValue: '$unconfigured',
					listeners:{
						afterrender: function () {
							this.setValue(this.backupValue);
						},
						change: function() {
							var changeValue = this.getValue();
							if (!Ext.isEmpty(changeValue))
							{
								this.backupValue = changeValue;
							}
						},
						blur :function()
						{
							var passObj = this;
							if (passObj.getValue() !== undefined || passObj.getValue() != "")
							{
								var backupValue = this.backupValue;
								passObj.setValue(backupValue);
							}
						},
						focus:function()
						{
							this.setValue("");
						}
					}
				},
				{
					xtype: 'textfield',
					cls: 'textbox',
					fieldLabel: nutCPwdLabel,
					inputType: 'password',
					//value: '$unconfigured',
					id: 'ConfPwdVc',
					backupValue: '$unconfigured',
					listeners:{
						afterrender: function () {
							this.setValue(this.backupValue);
						},
						change: function() {
							var changeValue = this.getValue();
							if (!Ext.isEmpty(changeValue))
							{
								this.backupValue = changeValue;
							}
						},
						blur :function()
						{
							var passObj = this;
							if (passObj.getValue() !== undefined || passObj.getValue() != "")
							{
								var backupValue = this.backupValue;
								passObj.setValue(backupValue);
							}
						},
						focus:function()
						{
							this.setValue("");
						}
					}
				}
			]
		}
	]
});



