Ext.define('SpecificTestConfiguration.view.EgRhevConfig', {
	extend: 'Ext.window.Window',
	alias: 'widget.egrhevconfig',

	id : 'rhevconfig',
	title: rhevTitle,
	width: 630,
	//height: 370,
	padding:'5 10 10 10',
	modal: true,

	listeners : {
		close : function()
		{
			var compTypeVal = Ext.getCmp('componentType').getValue();
			var strTestName = publicJson['testName'];
			Ext.Ajax.request({
				url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+compTypeVal+'&componentType='+compTypeVal+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
				method:'POST'
			});
		}
	},

	dockedItems: [
		{
			dock: 'bottom',
			layout:{
				type:'hbox',
				align:'stretch',
				pack:'center'
			},
			border:false,
			padding : '10 0 0 0',
			items: [
				{
					xtype: 'button',
					cls: 'quickMenuWhiteButton',
					text: Update,
					id: 'UpdateBTN',
					width: 80
				},
				{
					xtype: 'button',
					cls: 'quickMenuWhiteButton',
					text: Clear,
					margin: '0 0 0 10',
					id: 'ClearBTN',
					width: 80
				}
			]
		}
	],

	items:[
		{
			xtype: 'container',
			layout: {
				type: 'vbox',
				align: 'center',
				pack: 'center'
			},
			defaults: {
				labelSeparator: ' ',
				margin: 5,
				width: 580,
				labelWidth: 330
			},
			margin: 5,
			items: [
				{
					xtype: 'textfield',
					cls: 'textbox',
					fieldLabel: rhevIPLabel,
					value: 'None',
					id: 'RhevMgrId'
				},
				{
					xtype: 'scrollcombo',
					cls: 'dropdown',
					id : 'SslRhev',
					name: 'SslRhev',
					fieldLabel : rhevSSLLabel,
					fieldName: 'SslRhev',
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local',
					value: 'Yes',
					editable: false,
					forceSelection: false,
					parent:this,
					store:new Ext.data.Store({
						fields: ['displayField','valueField'],
						data: [
							{'displayField':'Yes','valueField':'True'},
							{'displayField':'No','valueField':'False'}
						]
					})
				},
				{
					xtype: 'textfield',
					cls: 'textbox',
					fieldLabel: rhevMgrPortLabel,
					value: 443,
					id: 'MgrPort'
				},
				{
					xtype: 'scrollcombo',
					cls: 'dropdown',
					id : 'DiscRhev',
					name: 'DiscRhev',
					fieldLabel : rhevDiscLabel,
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local',
					value: 'Yes',
					editable: false,
					forceSelection: false,
					parent:this,
					store:new Ext.data.Store({
						fields: ['displayField','valueField'],
						data: [
							{'displayField':'Yes','valueField':'Yes'},
							{'displayField':'No','valueField':'No'}
						]
					})
				},
				{
					xtype: 'textfield',
					cls: 'textbox',
					fieldLabel: rhevUnmeLabel,
					value: '$unconfigured',
					id: 'UsrRhev'
				},
				{
					xtype: 'textfield',
					cls: 'textbox',
					fieldLabel: rhevPwdLabel,
					inputType: 'password',
					//value: '$unconfigured',
					id: 'PwdRhev',
					backupValue: '$unconfigured',
					listeners:{
						afterrender: function () {
							this.setValue(this.backupValue);
						},
						change: function() {
							var changeValue = this.getValue();
							if (!Ext.isEmpty(changeValue))
							{
								this.backupValue = changeValue;
							}
						},
						blur :function()
						{
							var passObj = this;
							if (passObj.getValue() !== undefined || passObj.getValue() != "")
							{
								var backupValue = this.backupValue;
								passObj.setValue(backupValue);
							}
						},
						focus:function()
						{
							this.setValue("");
						}
					}
				},
				{
					xtype: 'textfield',
					cls: 'textbox',
					fieldLabel: rhevCPwdLabel,
					inputType: 'password',
					//value: '$unconfigured',
					id: 'ConfPwdRhev',
					backupValue: '$unconfigured',
					listeners:{
						afterrender: function () {
							this.setValue(this.backupValue);
						},
						change: function() {
							var changeValue = this.getValue();
							if (!Ext.isEmpty(changeValue))
							{
								this.backupValue = changeValue;
							}
						},
						blur :function()
						{
							var passObj = this;
							if (passObj.getValue() !== undefined || passObj.getValue() != "")
							{
								var backupValue = this.backupValue;
								passObj.setValue(backupValue);
							}
						},
						focus:function()
						{
							this.setValue("");
						}
					}
				},
				{
					xtype: 'textfield',
					cls: 'textbox',
					fieldLabel: rhevDnmeLabel,
					id: 'DomainRhev',
					value: 'internal'
				}
			]
		}
	]
});



