Ext.define('SpecificTestConfiguration.view.EgVcConfig', {
	extend: 'Ext.window.Window',
	alias: 'widget.egvcconfig',

	id : 'vcconfig',
	title: vcTitle,
	width: 580,
	//height: 320,
	modal: true,
	padding:'5 10 10 10',

	listeners : {
		close : function()
		{
			var compTypeVal = Ext.getCmp('componentType').getValue();
			var strTestName = publicJson['testName'];
			Ext.Ajax.request({
				url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+compTypeVal+'&componentType='+compTypeVal+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
				method:'POST'
			});
		}
	},

	dockedItems: [{
		dock: 'bottom',
		layout:{
			type:'hbox',
			align:'stretch',
			pack:'center'
		},
		border:false,
		padding : '10 0 0 0',
		items: [
			{
				xtype: 'button',
				cls: 'quickMenuWhiteButton',
				text: Update,
				id: 'UpdateBTN',
				width: 80
			},
			{
				xtype: 'button',
				cls: 'quickMenuWhiteButton',
				text: Clear,
				margin: '0 0 0 10',
				id: 'ClearBTN',
				width: 80
			}
		]
	}],

	items:[
		{
			xtype: 'container',
			layout: {
				type: 'vbox',
				align: 'center',
				pack: 'center'
			},
			defaults: {
				labelSeparator: ' ',
				margin: 5,
				width: 500,
				labelWidth: 250
			},
			margin: 5,
			items: [
				{
					xtype: 'textfield',
					cls: 'textbox',
					fieldLabel: vcIdLabel,
					value: 'None',
					id: 'vCenterIP'
				},
				{
					xtype: 'scrollcombo',
					cls: 'dropdown',
					id : 'SslVc',
					name: 'SslVc',
					fieldLabel : vcSSlLabel,
					fieldName: 'SslVc',
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local',
					value: 'Yes',
					editable: false,
					forceSelection: false,
					parent:this,
					store:new Ext.data.Store({
						fields: ['displayField','valueField'],
						data: [
							{'displayField':'Yes','valueField':'True'},
							{'displayField':'No','valueField':'False'}
						]
					})
				},
				{
					xtype: 'textfield',
					cls: 'textbox',
					fieldLabel: vcwebLabel,
					value: 443,
					id: 'WebPort'
				},
				{
					xtype: 'scrollcombo',
					cls: 'dropdown',
					id : 'DiscVc',
					name: 'DiscVc',
					fieldLabel : vcDiscoverLabel,
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local',
					value: 'Yes',
					editable: false,
					forceSelection: false,
					parent:this,
					store:new Ext.data.Store({
						fields: ['displayField','valueField'],
						data: [
							{'displayField':'Yes','valueField':'Yes'},
							{'displayField':'No','valueField':'No'}
						]
					})
				},
				/*{
					xtype: 'scrollcombo',
					cls: 'dropdown',
					id : 'ServerTypeVc',
					name: 'ServerTypeVc',
					fieldLabel : 'Type of VMs running on ESX host',
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local',
					value: 'ServerVMs',
					editable: false,
					forceSelection: false,
					parent:this,
					store:new Ext.data.Store({
						fields: ['displayField','valueField'],
						data: [
							{'displayField':'Desktop VMs','valueField':'DesktopVMs'},
							{'displayField':'Server VMs','valueField':'ServerVMs'},
							{'displayField':'Desktop and Server VMs','valueField':'DesktopandServer'}
						]
					})
				},*/
				{
					xtype: 'textfield',
					cls: 'textbox',
					fieldLabel: vcUnmeLabel,
					value: '$unconfigured',
					id: 'UsrVc'
				},
				{
					xtype: 'textfield',
					cls: 'textbox',
					fieldLabel: vcPwdLabel,
					inputType: 'password',
					//value: '$unconfigured',
					id: 'PwdVc',
					backupValue: '$unconfigured',
					listeners:{
						afterrender: function () {
							this.setValue(this.backupValue);
						},
						change: function() {
							var changeValue = this.getValue();
							if (!Ext.isEmpty(changeValue))
							{
								this.backupValue = changeValue;
							}
						},
						blur :function()
						{
							var passObj = this;
							if (passObj.getValue() !== undefined || passObj.getValue() != "")
							{
								var backupValue = this.backupValue;
								passObj.setValue(backupValue);
							}
						},
						focus:function()
						{
							this.setValue("");
						}
					}
				},
				{
					xtype: 'textfield',
					cls: 'textbox',
					fieldLabel: vcCPwdLabel,
					inputType: 'password',
					//value: '$unconfigured',
					id: 'ConfPwdVc',
					backupValue: '$unconfigured',
					listeners:{
						afterrender: function () {
							this.setValue(this.backupValue);
						},
						change: function() {
							var changeValue = this.getValue();
							if (!Ext.isEmpty(changeValue))
							{
								this.backupValue = changeValue;
							}
						},
						blur :function()
						{
							var passObj = this;
							if (passObj.getValue() !== undefined || passObj.getValue() != "")
							{
								var backupValue = this.backupValue;
								passObj.setValue(backupValue);
							}
						},
						focus:function()
						{
							this.setValue("");
						}
					}
				}
			]
		}
	]
});



