Ext.define('SpecificTestConfiguration.view.EgVmLogDisplay', {
	extend: 'Ext.window.Window',
	alias: 'widget.egvmlogdisplay',

	width: 850,
	height: 480,
	padding:'5 10 10 10',
	id: 'egvmlogdisplay',
	title: vmTitle,
	modal: true,
	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	listeners : {
		close : function()
		{
			var compTypeVal = Ext.getCmp('componentType').getValue();
			var strTestName = publicJson['testName'];
			Ext.Ajax.request({
				url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+compTypeVal+'&componentType='+compTypeVal+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
				method:'POST'
			});
		}
	},

	items: [
		{
			xtype: 'container',
			id: 'noVmDetailsContainer',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			hidden: true,
			items: [
				{
					xtype: 'label',
					id: 'noVmDetailsLabel',
					html: '<table align="center"><tr><td align="center" height="400"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+noVmDetails+'.</td></tr></table></td></tr></table>'
				}
			]
		},
		{
			xtype: 'grid',
			cls: 'gridSkin',
			id: 'esxComponentViewGrid',
			hidden: true,
			scroll : true,
			autoScroll : true,
			//height: 350,
			flex : 1,
			store:new Ext.data.Store({
				fields: ['vm', 'vmIp', 'dns', 'connectionState', 'powerState', 'os', 'vmToolsState'],
				data: []
			}),
			columns: {
				defaults: {
					sortable: false,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: true,
					isCheckerHd: false
				},
				items: [
					{
						text: vmLabel_1,
						dataIndex: 'vm',
						id: 'esx1',
						width: 250
					},
					{
						text: vmLabel_2,
						dataIndex: 'vmIp',
						id: 'esx2',
						width: 250
					},
					{
						text: vmLabel_3,
						dataIndex: 'dns',
						id: 'esx3',
						width: 250
					},
					{
						text: vmLabel_4,
						dataIndex: 'connectionState',
						id: 'esx4',
						width: 250
					},
					{
						text: vmLabel_5,
						dataIndex: 'powerState',
						id: 'esx5',
						width: 250
					},
					{
						text: vmLabel_6,
						dataIndex: 'os',
						id: 'esx6',
						width: 250
					},
					{
						text: vmLabel_7,
						dataIndex: 'vmToolsState',
						id: 'esx7',
						width: 200
					}
				]
			},
			margin: 10
		},
		{
			xtype: 'grid',
			cls: 'gridSkin',
			id: 'xenComponentViewGrid',
			scroll : true,
			autoScroll : true,
			//height: 350,
			flex : 1,
			store:new Ext.data.Store({
				fields: ['vm', 'vmIp', 'os', 'powerState', 'xenToolsState'],
				data: []
			}),
			hidden: true,
			columns: {
				defaults: {
					sortable: false,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: true,
					isCheckerHd: false
				},
				items: [
					{
						text: vmLabel_1,
						dataIndex: 'vm',
						id: 'xen1',
						flex: 1
					},
					{
						text: vmLabel_2,
						dataIndex: 'vmIp',
						id: 'xen2',
						flex: 1
					},
					{
						text: vmLabel_6,
						dataIndex: 'os',
						id: 'xen3',
						flex: 1
					},
					{
						text: vmLabel_5,
						dataIndex: 'powerState',
						id: 'xen4',
						flex: 1
					},
					{
						text: xenLabel_1,
						dataIndex: 'xenToolsState',
						id: 'xen5',
						flex: 1
					}
				]
			},
			margin: 10
		},
		{
			xtype: 'grid',
			cls: 'gridSkin',
			id: 'hyperComponentViewGrid',
			scroll : true,
			autoScroll : true,
			//height: 350,
			flex : 1,
			store:new Ext.data.Store({
				fields: ['vm', 'vmIp', 'os','powerState'],
				data: []
			}),
			hidden: true,
			columns: {
				defaults: {
					sortable: false,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: true,
					isCheckerHd: false
				},
				items: [
					{
						text: vmLabel_1,
						dataIndex: 'vm',
						id: 'hyper1',
						flex: 1
					},
					{
						text: vmLabel_2,
						dataIndex: 'vmIp',
						id: 'hyper2',
						flex: 1
					},
					{
						text: vmLabel_6,
						dataIndex: 'os',
						id: 'hyper3',
						flex: 1
					},
					{
						text: vmLabel_5,
						dataIndex: 'powerState',
						id: 'hyper4',
						flex: 1
					}
				]
			},
			margin: 10
		}
	]

});



