Ext.define('SpecificTestConfiguration.view.EgWebServiceConfiguration', {
	extend: 'Ext.window.Window',
	alias: 'widget.egwebserviceconfiguration',

	title: webServiceTitle,
	id: 'egwebserviceconfiguration',
	width: 800,
	height: 500,
	padding:'5 10 10 10',

	requires: [
		'Ext.ux.OptGroup.OptGroupItemSelectorSs',
		'Ext.ux.form.ItemSelectorSI'
	],

	layout: {
		type: 'vbox',
		align:'stretch'
	},

	listeners : {
		close : function()
		{
			var compTypeVal = Ext.getCmp('componentType').getValue();
			var strTestName = publicJson['testName'];
			Ext.Ajax.request({
				url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+compTypeVal+'&componentType='+compTypeVal+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
				method:'POST'
			});
		}
	},

	dockedItems: [
		{
			dock: 'bottom',
			layout:{
				type:'hbox',
				align:'stretch',
				pack:'center'
			},
			border:false,
			padding : '10 0 0 0',
			id: 'saveAndConfigContainer',
			name: 'saveAndConfigContainer',
			hidden: true,
			items: [
				{
					xtype: 'button',
					cls: 'quickMenuWhiteButton',
					text: saveconfig,
					id: 'save',
					name: 'save',
					width: 170
				},
				{
					xtype: 'button',
					cls: 'quickMenuWhiteButton',
					text: sendReq,
					id: 'sendReq',
					width: 100,
					margin: '0 0 0 10'
				}
			]
		}
	],

	items: [
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'start'
			},
			margin: '10 10 5 10',
			items: [
				{
					xtype: 'scrollcombo',
					cls: 'dropdown',
					id : 'agentListObj',
					name: 'agentListObj',
					fieldLabel: manageragentConfig,
					fieldName : 'agentListObj',
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local',
					editable: false,
					width: 480,
					labelWidth: 230,
					labelSeparator: '',
					parent:this,
					store:new Ext.data.Store({
						fields: ['displayField','valueField'],
						data: []
					})
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'start'
			},
			margin: '5 10 5 10',
			items: [
				{
					xtype: 'scrollcombo',
					cls: 'dropdown',
					id : 'wsdlUrl',
					name: 'wsdlUrl',
					fieldLabel: wsdlUrl,
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local',
					value: 'Select URL',
					editable: false,
					width: 730,
					labelWidth: 230,
					labelSeparator: '',
					parent:this,
					store:new Ext.data.Store({
						fields: ['displayField','valueField'],
						data: []
					})
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'start'
			},
			margin: '5 10 0 10',
			items: [
				{
					xtype: 'scrollcombo',
					cls: 'dropdown',
					id : 'wsdlService',
					name: 'wsdlService',
					fieldLabel: servicesLbl,
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local',
					editable: false,
					value: 'Select Service',
					width: 480,
					labelWidth: 230,
					labelSeparator: '',
					parent:this,
					store:new Ext.data.Store({
						fields: ['displayField','valueField'],
						data: []
					})
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			margin: 10,
			items: [
				{
					xtype: 'optgroupitemselectorSs',
					cls: 'multiselect',
					name: 'wsdlOperation',
					fieldName: 'wsdlOperation',
					id: 'wsdlOperation',
					createList: function(title){
						var me = this;

						return Ext.create('Ext.ux.OptGroup.OptGroupMultiSelectSs', {
							submitValue: false,
							flex: 1,
							//dragGroup: me.ddGroup,
							//dropGroup: me.ddGroup,
							title: title,
							store: {
								model: me.store.model,
								data: []
							},
							displayField: me.displayField,
							groupField : me.groupField,
							disabled: me.disabled,
							listeners: {
								boundList: {
									scope: me,
									itemdblclick: me.onItemDblClick,
									select: me.getSelectedValue,
									drop: me.syncValue
								}
							}
						});
					},
					buttons: ['add','remove'],
					buttonsText: {
						add: disabledMsg,
						remove: enabledMsg,
					},
					store: new Ext.data.Store(
					{
						fields: ['displayField','valueField','groupField'],
						data: []
					}),
					displayField: 'displayField',
					valueField: 'valueField',
					groupField: 'groupField',
					height: 150,
					flex: 1,
					fromTitle: monitoredLbl,
					toTitle: definedLbl,
					listConfig: {
						//multiSelect: false,
						tpl: Ext.create('Ext.XTemplate',
						  '<ul><tpl for=".">',
						  '<tpl if="xindex == 1 || this.getGroupLabel(parent[xindex - 2]) != this.getGroupLabel(values)">',
						  '<li class="x-combo-list-group"><b>{[this.getGroupLabel(values)]}</b></li>',
						  '</tpl>',
						  '<li role="option" class="x-boundlist-item" style="<tpl if="xindex != 0">padding-left: 12px</tpl>">{displayField}</li>',
						  '</tpl>' +
						  '</ul>',
						  {
							getGroupLabel: function (values) {
							  return values.groupField
							}
						  }
						)
					},
					getSelectedValue: function( data, record, eOpts )
					{
						var fromFieldData = Ext.getCmp('wsdlOperation').fromField.getSelected();
						if (!Ext.isEmpty(fromFieldData) && fromFieldData != undefined)
						{
							appDesc.changeButtonLabel(record);
						}
					},
					moveRec: function(add, recs) {
						var me = this,
						fromField = me.fromField,
						toField   = me.toField,
						fromStore = add ? fromField.store : toField.store,
						toStore   = add ? toField.store   : fromField.store;
						if (Ext.getCmp('wsdlService').getValue() == 'Select Service')
						{
							Ext.Msg.show({
								title: pageName,
								msg: alertWebMsg3,
								buttons: Ext.Msg.OK,
								icon: Ext.MessageBox.WARNING
							});
							return;
						}
						if(add)
						{
							if(fromField.store.getCount()==0)
							{
								Ext.Msg.show({
									title: pageName,
									msg: operationToDis,
									buttons: Ext.Msg.OK,
									icon: Ext.MessageBox.WARNING
								});
								return;
							}
							if(fromField.getSelected().length == 0)
							{
								Ext.Msg.show({
									title: pageName,
									msg: operationToDis,
									buttons: Ext.Msg.OK,
									icon: Ext.MessageBox.WARNING
								});
								return;
							}
						}
						else
						{
							if(toField.store.getCount()==0)
							{
								Ext.Msg.show({
									title: pageName,
									msg: operationToAss,
									buttons: Ext.MessageBox.OK,
									icon: Ext.MessageBox.WARNING
								 });
								return;
							}
							if(toField.getSelected().length == 0)
							{
								Ext.Msg.show({
									title: pageName,
									msg: operationToAss,
									buttons: Ext.MessageBox.OK,
									icon: Ext.MessageBox.WARNING
								 });
								return;
							}
						}
						fromStore.suspendEvents();
						toStore.suspendEvents();
						fromStore.remove(recs);
						toStore.add(recs);
						fromStore.resumeEvents();
						toStore.resumeEvents();
						fromField.boundList.refresh();
						toField.boundList.refresh();
						me.syncValue();
					}
				}
			]
		},
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			margin: '0 10 10 10',
			items: [
				{
					xtype: 'button',
					cls: 'button20',
					text: label21,
					id: 'ConfigureBTN',
					name: 'ConfigureBTN',
					width: 80
				}
			]
		},
		{
			xtype: 'tabpanel',
			cls: 'tablayout',
			id: 'xmlandhtmlview',
			name: 'xmlandhtmlview',
			tabPosition: 'top',
			flex: 1,
			margin: '0 10 10 10',
			disabled: true,
			items: [
				{
					title: xmlView,
					itemId: 'xmlview',
					layout: {
						type: 'vbox',
						align: 'stretch'
					},
					items : [
						{
							xtype: 'container',
							flex: 1,
							id: 'xmlTable',
							name: 'xmlTable',
							align: 'center',
							itemId: 'xmlTable',
							padding:10,
							scroll:true,
							autoScroll: true,
							html: ''
						}
					]
				},
				{
					title: htmlView,
					itemId: 'htmlview',
					scroll:true,
					autoScroll: true,
					items : [
						{
							xtype: 'container',
							id: 'htmlviewer',
							name: 'htmlviewer',
							flex: 1,
							layout: {
								type: 'vbox',
								align: 'stretch',
								pack:'center'
							},
							items: [
								{
									xtype: 'container',
									flex: 1,
									id: 'inputTable',
									name: 'inputTable',
									align: 'center',
									itemId: 'inputTable',
									padding: '10 15 10 10',
									scroll:true,
									autoScroll: true,
									html: ''
								}
							]
						}
					]
				}
			]
		}
	]
});



