Ext.define('SpecificTestConfiguration.view.EgXMSConfig', {
	extend: 'Ext.window.Window',
	alias: 'widget.egxmsconfig',

	id : 'egxmsconfig',
	title: XMSTitle,
	width: 580,
	//height: 320,
	modal: true,
	padding:'5 10 10 10',

	listeners : {
		close : function()
		{
			var compTypeVal = Ext.getCmp('componentType').getValue();
			var strTestName = publicJson['testName'];
			Ext.Ajax.request({
				url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+compTypeVal+'&componentType='+compTypeVal+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
				method:'POST'
			});
		}
	},

	dockedItems: [{
		dock: 'bottom',
		layout:{
			type:'hbox',
			align:'stretch',
			pack:'center'
		},
		border:false,
		padding : '10 0 0 0',
		items: [
			{
				xtype: 'button',
				cls: 'quickMenuWhiteButton',
				text: Update,
				id: 'UpdateBTN',
				width: 80,
				handler: function(){
					me.updateXMSIP();
				}
			},
			{
				xtype: 'button',
				cls: 'quickMenuWhiteButton',
				text: Clear,
				margin: '0 0 0 10',
				id: 'ClearBTN',
				width: 80,
				handler: function(){
					me.clearXMSIP();
				}
			}
		]
	}],

	items:[
		{
			xtype: 'container',
			layout: {
				type: 'vbox',
				align: 'center',
				pack: 'center'
			},
			defaults: {
				labelSeparator: ' ',
				margin: 5,
				width: 500,
				labelWidth: 250
			},
			margin: 5,
			items: [
				{
					xtype: 'textfield',
					cls: 'textbox',
					fieldLabel: xmsIdLabel,
					value: 'None',
					id: 'xmsIP'
				},
				{
					xtype: 'scrollcombo',
					cls: 'dropdown',
					id : 'SslXMSIP',
					name: 'SslXMSIP',
					fieldLabel : xmsSSlLabel,
					fieldName: 'SslVc',
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local',
					value: 'Yes',
					editable: false,
					forceSelection: false,
					parent:this,
					store:new Ext.data.Store({
						fields: ['displayField','valueField'],
						data: [
							{'displayField':'Yes','valueField':'yes'},
							{'displayField':'No','valueField':'no'}
						]
					})
				},
				{
					xtype: 'scrollcombo',
					cls: 'dropdown',
					id : 'DiscXMSIP',
					name: 'DiscXMSIP',
					fieldLabel : xmsDiscoverLabel,
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local',
					value: 'Yes',
					editable: false,
					forceSelection: false,
					parent:this,
					store:new Ext.data.Store({
						fields: ['displayField','valueField'],
						data: [
							{'displayField':'Yes','valueField':'Yes'},
							{'displayField':'No','valueField':'No'}
						]
					})
				},
				{
					xtype: 'textfield',
					cls: 'textbox',
					fieldLabel: xmsUnmeLabel,
					value: '$unconfigured',
					id: 'UsrXMSIP'
				},
				{
					xtype: 'textfield',
					cls: 'textbox',
					fieldLabel: xmsPwdLabel,
					inputType: 'password',
					//value: '$unconfigured',
					id: 'PwdXMSIP',
					backupValue: '$unconfigured',
					listeners:{
						afterrender: function () {
							this.setValue(this.backupValue);
						},
						change: function() {
							var changeValue = this.getValue();
							if (!Ext.isEmpty(changeValue))
							{
								this.backupValue = changeValue;
							}
						},
						blur :function()
						{
							var passObj = this;
							if (passObj.getValue() !== undefined || passObj.getValue() != "")
							{
								var backupValue = this.backupValue;
								passObj.setValue(backupValue);
							}
						},
						focus:function()
						{
							this.setValue("");
						}
					}
				},
				{
					xtype: 'textfield',
					cls: 'textbox',
					fieldLabel: xmsCPwdLabel,
					inputType: 'password',
					//value: '$unconfigured',
					id: 'ConfPwdXMSIP',
					backupValue: '$unconfigured',
					listeners:{
						afterrender: function () {
							this.setValue(this.backupValue);
						},
						change: function() {
							var changeValue = this.getValue();
							if (!Ext.isEmpty(changeValue))
							{
								this.backupValue = changeValue;
							}
						},
						blur :function()
						{
							var passObj = this;
							if (passObj.getValue() !== undefined || passObj.getValue() != "")
							{
								var backupValue = this.backupValue;
								passObj.setValue(backupValue);
							}
						},
						focus:function()
						{
							this.setValue("");
						}
					}
				}
			]
		}
	]
});



