Ext.define('SpecificTestConfiguration.view.ExcludeInterfaces',{
	extend: 'Ext.window.Window',
	alias: 'widget.excludeinterfaces',

	border: false,
	title: "EXCLUDE INTERFACES",
	id: 'excludeinterfaces',
	padding:'5 5 10 10',
	autoScroll: true,
	modal: true,

	requires: [
		'Ext.ux.form.ItemSelector',
		'Ext.ux.OptGroupItemSelectorSm',
		'Ext.ux.OptGroup.OptGroupMultiSelect'
	],

	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	dockedItems: [
		{
			dock: 'bottom',
			layout:{
				type:'hbox',
				align:'stretch',
				pack:'center'
			},
			border:false,
			padding : '10 0 0 0',
			items: [
				{
					xtype: 'button',
					cls: 'quickMenuWhiteButton',
					text: 'Get Interfaces',
					width: 110,
					id: 'getExcludInf'
				},
				{
					xtype: 'button',
					cls: 'quickMenuWhiteButton',
					text: Update,
					width: 80,
					id: 'addExcludInf',
					margin: '0 0 0 10'
				}
			]
		}
	],

	listeners : {
		close : function()
		{
			var compTypeVal = Ext.getCmp('componentType').getValue();
			var strTestName = publicJson['testName'];
			Ext.Ajax.request({
				url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+compTypeVal+'&componentType='+compTypeVal+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
				method:'POST'
			});
		}
	},

	items:[
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'end'
			},
			margin: '10 10 0 10',
			items: [
				{
					xtype: 'trigger',
					id: 'getInfacDetailSearch',
					name: 'getInfacDetailSearch',
					trigger1Cls: 'x-form-clear-trigger',
					trigger2Cls: 'x-form-search-trigger',
					cls: 'whitedropdown_search',
					//margin: '1 5 1 0',
					emptyText: 'Search Available Interfaces',
					getTriggerMarkup: function() {
						var func = this,
						i = 0,
						hideTrigger = (func.readOnly || func.hideTrigger),
						triggerCls,
						triggerBaseCls = func.triggerBaseCls,
						triggerConfigs = [],
						unselectableCls = Ext.dom.Element.unselectableCls,
						style = 'width:' + func.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
						cls = func.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
						// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
						// single triggerCls config. Should rethink this, perhaps something more structured like a list of
						// trigger config objects that hold cls, handler, etc.
						// triggerCls is a synonym for trigger1Cls, so copy it.
						if (!func.trigger1Cls) {
							func.trigger1Cls = func.triggerCls;
						}
						// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
						for (i = 0; (triggerCls = func['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
							if (i == 0)
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style + "display:none;",
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
							else
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style,
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
						}
						triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
						return Ext.DomHelper.markup(triggerConfigs);
					},
					onTrigger1Click: function()
					{
						this.reset();
					},
					onTrigger2Click: function()
					{
						func.getexInfacsSearch();
					}
				}
			]
		},
		{
			xtype: "container",
			layout: {
				type: "vbox",
				pack: "center",
				align: "stretch"
			},
			flex: 1,
			margin: '10 10 5 10',
			items: [
				{
					xtype: "optgroupitemselectorsm",
					cls: "multiselect",
					name: "exInfitemselect",
					fieldName: "itemselectTests",
					id: "exInfitemselect",
					buttons: ["add", "remove"],
					buttonsText: {
						add: "Remove from Exclude Interfaces",
						remove: "Add to Exclude Interfaces"
					},
					store: new Ext.data.Store({
						fields: ["displayField", "valueField","groupField"],
						data: []
					}),
					groupField: "groupField",
					displayField: "displayField",
					valueField: "valueField",
					height: 350,
					width: 650,
					fromTitle: "Excluded Interfaces",
					toTitle: "Available Interfaces",
					createList: function(title) {
						var func = this;
						return Ext.create('Ext.ux.OptGroup.OptGroupMultiSelect', {
							// We don't want the multiselects themselves to act like fields,
							// so override these methods to prevent them from including
							// any of their values
							submitValue: false,
							getSubmitData: function(){
								return null;
							},
							getModelData: function(){
								return null;
							},
							flex: 1,
							dragGroup: func.ddGroup,
							dropGroup: func.ddGroup,
							title: title,
							store: {
								model: func.store.model,
								data: []
							},
							displayField: func.displayField,
							valueField: func.valueField,
							groupField : func.groupField,
							disabled: func.disabled,
							listeners: {
								boundList: {
									scope: func,
									itemdblclick: func.onItemDblClick,
									drop: func.syncValue
								}
							}
						});
					},
					onItemDblClick: function(view, rec) {
						this.moveRec(view === this.fromField.boundList, rec);
						this.groupFromFieldItems();
					}
				}
			]
		}
	]
});



