Ext.define('SpecificTestConfiguration.view.SiteDetailedConfiguration', {
	extend: 'Ext.window.Window',
	alias: 'widget.sitedetailedconfiguration',
	title: 'Site Information',
	cls:'outerpanel',
	header:{cls:'textUpper'},
	margin :'8 8 0 8',
	id: 'sitedetailedconfiguration',
	border:true,
	frame:true,
	closable: true,
	listeners : {
		close : function()
		{
			var compTypeVal = Ext.getCmp('componentType').getValue();
			var strTestName = publicJson['testName'];
			Ext.Ajax.request({
				url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+compTypeVal+'&componentType='+compTypeVal+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
				method:'POST'
			});
		}
	},
	doClose: function() {
		this.destroy();
	},
	layout: {
		type: 'vbox',
		align: 'stretch'
	},
	items: [
		{
			xtype: 'container',
			id: 'testjames',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			id:'sitenameContainer',
			margin: 10,
			items: [
				{
					xtype: 'scrollcombo',
					cls:'dropdown',
					fieldLabel: 'Website name',
					name: 'sitename_popup',
					id:"sitename_popup",
					labelSeparator: '',
					width: 400,
					labelWidth: 100,
					//editable: false,
					queryMode: 'local',
					displayField:'displayField',
					valueField:'valueField',
					store:new Ext.data.Store({
						fields: ['displayField','valueField'],
						data: []
					})
				},
				{
					xtype:'container',
					id:'buttonContainer',
					layout: {
						type:'hbox',
						pack:'center'
					},
					margin: '0 0 0 20',
					items: [
						{
							xtype: 'button',
							text: 'Update',
							name: 'sitename_update',
							id:'sitename_update',
							cls:'button20'
						}
					]
				}
			]
		}
	]

});



