Ext.define('SpecificTestConfiguration.view.WinServicesConfiguration',{
	extend: 'Ext.window.Window',
	alias: 'widget.winservicesconfiguration',

	border: false,
	title: winServTitle,
	id: 'winservicesconfiguration',
	width: 850,
	height: 480,
	padding:'5 10 10 10',
	modal: true,

	layout: {
		type: 'vbox',
		pack: 'start',
		align: 'stretch'
	},

	requires : [
		'utilities.CustomGrid'
	],

	close: function()
	{
		var serviceNames = Ext.getCmp('serviceName').getValue();
		serviceNames = serviceNames == '$unconfigured' || serviceNames.toLowerCase() == '$servicename'?'':serviceNames;
		var isChanges = serviceNames != serviceNamesArray.toString();
		if (isChanges && this.fireEvent('beforeclose', this) !== false) 
		{
			testInterViews.showResultWindow(winServTitle,'service');
		}
		else
		{
			this.doClose();
		}
		var compTypeVal = Ext.getCmp('componentType').getValue();
		var strTestName = publicJson['testName'];
		Ext.Ajax.request({
			url:'SpecificTestConfiguration/data/EgConfigureComponentTestsJson.jsp?cType_HelpPage='+compTypeVal+'&componentType='+compTypeVal+'&tName_HelpPage='+strTestName+'&testName='+strTestName,
			method:'POST'
		});
	},
	dockedItems: [
		{
			layout:{
				type:'hbox',
				align:'stretch',
				pack:'center'
			},
			dock: 'bottom',
			padding : '10 0 0 0',
			items:[
				{
					xtype: 'button',
					cls: 'quickMenuWhiteButton',
					text: Update,
					id: 'updateService',
					width: 100
				}
			]
		}
	],
	items: [
		{
			xtype: 'customgrid',
			cls: 'gridSkin',
			id: 'serviceNamesGrid',
			name: 'serviceNamesGrid',
			flex: 1,
			store:new Ext.data.Store({
				fields: ['serviceName','Modify','Delete','isDisabled'],
				data: []
			}),
			selModel: {
				selType: 'checkboxmodel',
				mode: 'MULTI',
				checkOnly: true
			},
			viewConfig: {
				deferEmptyText: true
			},
			emptyText: '<table align="center"><tr><td align="center" height="309"><table><tr><td align="center"><img src="/final/images/spacer.gif" class="iconInformation"></td></tr><tr><td align="center" class="commonErrorMsgText">'+noconfServices+'</td></tr></table></td></tr></table>',
			scroll : true,
			autoScroll : false,
			flex: 1,
			columns: {
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: false,
					isCheckerHd: false,
				},
				items: [
					{
						text: 'Service Name',
						dataIndex: 'serviceName',
						flex: 1
					},
					{
						xtype: 'actioncolumn',
						width: 36,
						id: 'EditOver',
						iconCls: 'iconModify',
						sortable: false,
						handler:  function(grid, rowIndex, colIndex, column, e) {
							var isModifyLink = "testInterViews.modifyServices(\'"+rowIndex+"\')";
							if (!Ext.isEmpty(isModifyLink))
							{
								testInterViews.editService(rowIndex);
							}
							else
							{
								return false;
							}
						},
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							var serviceName = record.get('serviceName');
							var isModifyLink = "testInterViews.modifyServices(\'"+serviceName+"\')";
							metaData.tdAttr = "data-qtip='"+label6+"' data-qclass='yellowTip'";
							if (!Ext.isEmpty(isModifyLink))
							{
								//return "<div style='cursor:pointer' onclick=\"javascript:"+isModifyLink+"\" class='iconModify'></div>";
							}
							else
							{
								metaData.style = "filter:alpha(opacity=20);opacity:.2;cursor:hand;";
							}
						}
					},
					{
						header : '<div class="iconDeleteAll" data-qtip="Delete Selected" data-qclass="yellowTip"></div>',
						xtype: 'actioncolumn',
						width: 36,
						id: 'DeleteOver',
						sortable: false,
						listeners: {
							headerclick: function(g, index, ev) {
								testInterViews.removeSeletedServices();
							}
						},
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							var serviceName = record.get('serviceName');
							var isDeleteLink = "testInterViews.removeSeletedServices(\'"+serviceName+"\')";
							var isDisabled = record.get('isDisabled');
							metaData.tdAttr = "data-qtip='"+label9+"' data-qclass='yellowTip'";
							if (isDisabled)
							{
								return '<div class="iconDeleteDisabled"></div>';
							}
							else
							{
								return "<div style='cursor:pointer' onclick=\"javascript:"+isDeleteLink+"\" class='iconDelete'></div>";
							}
						}
					}
				],
			},
			margin: 10,
			tbar: [
				{
					xtype:'tbfill',
				},
				{
					xtype: 'trigger',
					name: 'winServiceSearchTrigger',
					id: 'winServiceSearchTrigger',
					trigger1Cls: 'x-form-clear-trigger',
					trigger2Cls: 'x-form-search-trigger',
					cls: 'whitedropdown_search',
					//margin: '1 5 1 0',
					emptyText: 'Search Service Name',
					getTriggerMarkup: function() {
						var me = this,
						i = 0,
						hideTrigger = (me.readOnly || me.hideTrigger),
						triggerCls,
						triggerBaseCls = me.triggerBaseCls,
						triggerConfigs = [],
						unselectableCls = Ext.dom.Element.unselectableCls,
						style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
						cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
						// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
						// single triggerCls config. Should rethink this, perhaps something more structured like a list of
						// trigger config objects that hold cls, handler, etc.
						// triggerCls is a synonym for trigger1Cls, so copy it.
						if (!me.trigger1Cls) {
							me.trigger1Cls = me.triggerCls;
						}
						// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
						for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++)
						{
							if (i == 0)
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style + "display:none;",
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
							else
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style,
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								 });
							}
						}
						triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
						return Ext.DomHelper.markup(triggerConfigs);
					},
					onTrigger1Click: function()
					{
						//firstClick = true;
						this.reset();
						me.winServiceSearch();
					},
					onTrigger2Click: function()
					{
						me.winServiceSearch();
					}
				},
				{
					xtype: 'toolbar',
					ui: 'footer',
					items: [
						{
							xtype: 'button',
							cls: 'button20',
							text: getServiceLabel,
							id: 'getService',
							width: 100
						},
						{
							xtype: 'button',
							cls: 'button20',
							id: 'addServiceConfbtn',
							width: 80,
							text: addLabel,
							margin: '0 6 0 2'
						}
					]
				}
			]
		}
	]
});



