<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="java.util.*" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import = "egurkha.EgDbAdapterUI" %>
<%@ page import = "com.eg.EgDbAdapterTypeUI" %>
<%@ page import = "egurkha.*" %>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "net.sf.json.*"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "net.sf.json.*"%>
<%
	JSONObject rootJson =  new JSONObject();
	
	String apmFile = "eg_apm.ini";
	String apmGuidFile = "eg_apmGuid.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir() + "/manager/config/";

	Map subjectTestName = new HashMap();
	subjectTestName.put("BusinessTransTest","BT");
	subjectTestName.put("KBusinessTransTest","KBT");
	
	String testName = request.getParameter("testName");
	String serverType = request.getParameter("compType");
	String componentName = request.getParameter("compName");
	String operation = request.getParameter("crud");
	String subject = "CUSTOM_PATTERN_CONFIGURATION_"+(String)subjectTestName.get(testName);
	String variable = request.getParameter("variable");
	String compHost = request.getParameter("compHost");

	IniFile apmIniFile = EgConfigFilesSync.getInstance((s_iniFile_dir + apmFile));
	IniFile apmIniGuidFile = EgConfigFilesSync.getInstance((s_iniFile_dir + apmGuidFile));
	
	if(operation.equalsIgnoreCase("create")){
		String value = request.getParameter("data");
		
		rootJson.put("ruleCreated",createRule(apmIniFile, apmIniGuidFile, subject, serverType, componentName, compHost, value));
		out.println(rootJson.toString());
	}else if(operation.equalsIgnoreCase("Delete")){
		deleteRule(apmIniFile, subject, variable);
		}
	else if(operation.equalsIgnoreCase("Update")){
		String value = request.getParameter("data");
		updateRule(apmIniFile, subject, variable, value);

	}else{
		JSONArray cpcArray = getRules(apmIniFile,apmIniGuidFile, subject, compHost, serverType, componentName);
		rootJson.put("BTValues",cpcArray);
		out.println(rootJson.toString());

	}
	EgConfigFilesSync.releaseInstance(apmIniFile);
	EgConfigFilesSync.releaseInstance(apmIniGuidFile);
	
%>

<%!
	public void updateRule(IniFile apmIniFile, String subject, String variable,String value){
		apmIniFile.setValue(subject,variable, value);
		apmIniFile.saveFile();
	}

	public boolean createRule(IniFile apmIniFile, IniFile apmIniGuidFile, String subject, String serverType, String componentName, String compHost, String value){
		Integer maxCpcCount = 0;
		Integer CPCLength = 3;
		String searchVar = serverType+":"+compHost+":"+componentName;
		String newVariable = apmIniGuidFile.getValue("APM_GUID_MAPPING_WITH_NICK",searchVar);
		if (newVariable.length()<0){
			return false;
		}
		Map variableMap = getVariableMap(apmIniFile, subject);
		
		if(variableMap.containsKey(newVariable)){
			Iterator itr = ((Set)variableMap.get(newVariable)).iterator();
			while(itr.hasNext()){
				String cpc = (String) itr.next();
				Integer currentCpcCount = Integer.parseInt(cpc.substring(CPCLength,cpc.length()));
				if(currentCpcCount > maxCpcCount) maxCpcCount = currentCpcCount;
			}
		}
		Integer finalCpcCount = maxCpcCount+1;
		String variable = newVariable+":"+"CPC"+finalCpcCount;
		boolean ruleCreated = false;
		if(newVariable.length()>1){
			ruleCreated = apmIniFile.setValue(subject,variable, value);
		}
		apmIniFile.saveFile();
		return ruleCreated;
	}

	public void deleteRule(IniFile apmIniFile, String subject, String deleteVariable){
		if(deleteVariable.indexOf(",") != -1){
			String[] splitVars = deleteVariable.split(",");
			for(int varIndx=0; varIndx < splitVars.length; varIndx++){
				apmIniFile.deleteValue(subject,splitVars[varIndx].trim());
			}
		}else apmIniFile.deleteValue(subject,deleteVariable);
		apmIniFile.saveFile();
		//renameTrailingVariable(apmIniFile, subject, deleteVariable);
	}

	public JSONArray getRules(IniFile apmIniFile, IniFile apmIniGuidFile, String subject, String hostName, String serverType, String componentName){
		List variableList = getVariableList(apmIniFile, apmIniGuidFile, subject, hostName, serverType, componentName);
		JSONArray cpcArray = new JSONArray();
		if(variableList!=null){
			for(int variableIndx =0;variableIndx<variableList.size();variableIndx++){
				String variable = (String) variableList.get(variableIndx);
				String value = apmIniFile.getValue(subject,variable);
				JSONObject cpcValues = new JSONObject();
				cpcValues.put("variable",variable);
				if(value.split("~#~").length>1){
					cpcValues.put("Matching_URL_Pattern",value.split("~#~")[0]);
					cpcValues.put("Rule_Name",(value.split("~#~")[1].split("~!~").length>1)?value.split("~#~")[1].split("~!~")[0]:"");
					cpcValues.put("Rule_Details",(value.split("~#~")[1].split("~!~").length>1)?value.split("~#~")[1].split("~!~")[1]:"");					
				}
				cpcArray.add(cpcValues);
			}
		}
		return cpcArray;
	}

	private List getVariableList(IniFile apmIniFile, IniFile apmIniGuidFile, String subject, String hostName, String serverType, String componentName){
		Map variableMap = getVariableMap(apmIniFile, subject);
		List variableList = new ArrayList();
		String compGuid = apmIniGuidFile.getValue("APM_GUID_MAPPING_WITH_NICK",serverType+":"+hostName+":"+componentName);
		if(variableMap.containsKey(compGuid)&& variableMap!=null){
			Iterator itr = ((Set)variableMap.get(compGuid)).iterator();
			while(itr.hasNext()){
				String cpc = (String) itr.next();
				variableList.add(compGuid+":"+cpc);
			}
		}
		return variableList;
	}

	private Map getVariableMap(IniFile apmIniFile, String subject){
		Map variableMap = new HashMap();
		
		Vector iniVariables = apmIniFile.getVariables(subject,true);
		
		if(iniVariables!=null){
			for(int variableIndx =0; variableIndx<iniVariables.size(); variableIndx++){
				String iniVariable = (String)iniVariables.get(variableIndx);
				String variableKey = iniVariable.substring(0, iniVariable.lastIndexOf(":"));
				String cpc = (iniVariable.substring(iniVariable.lastIndexOf(":")+1,iniVariable.length())).trim();
				
				if(variableMap.containsKey(variableKey)) ((TreeSet)variableMap.get(variableKey)).add(cpc);
				else  variableMap.put(variableKey, new TreeSet(Arrays.asList(cpc)));
			}
		}
		return variableMap;
	}
	
%>
























