<%
/**
 *	Name		:	EgConfigCompositeJson.jsp
 *	Version		:	1.0
 */
%>
<%@ include file = "../../EgTrackerAJSON.jsp" %>
<%@ page import="java.util.*" %>
<%@ page import = "com.eg.EgDbAdapterTypeUI" %>
<%@ page import ="egurkha.EgDbAdapterUI"%>
<%@ page import="java.sql.*" %>
<%@ page import="com.eg.EgCompositeInfo"%>
<%@ page import="com.egurkha.util.*"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "net.sf.json.*"%>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	String test = request.getParameter("test");
	String comp = request.getParameter("comp");
	String server = request.getParameter("server");

	String details[] = StringUtils.getTokens(comp,":");
	String compNick = details[0];
	String port = details[1];
	String displayComp = comp;
	if(!server.equals("Oracle_server") && port.equals("NULL"))
	{
		displayComp = compNick;
	}
	rootJson.put("dispComp",displayComp);
	rootJson.put("composite_test_desc",_mapping.getTestDescription(test));

	EgTablesInfo tablesInfo = new EgTablesInfo("manager");
	ArrayList layersForCompType = tablesInfo.getLayersForComponent(server);
	ArrayList layersForHostSystem = tablesInfo.getLayersForComponent("Host_system");
	if(layersForHostSystem == null)
	{
		layersForHostSystem=new ArrayList();
	}
	EgCompositeInfo compInfo = new EgCompositeInfo("manager");
	String masterInfoTest = compInfo.getMasterInfosTest(test);
	if(masterInfoTest != null && (masterInfoTest=masterInfoTest.trim()).length()>0)
	{
		rootJson.put("masterInfoTest",masterInfoTest);
		rootJson.put("masterInfoTestFound",true);
		rootJson.put("masterInfoTestDisplay",_mapping.getTestDescription(masterInfoTest));
	}
	else
	{
		rootJson.put("masterInfoTestFound",false);
	}
	Hashtable includeInfosPerTest_all = new Hashtable();
	Hashtable excludeInfosPerTest_all = new Hashtable();
	Vector compositeMeasureList = compInfo.getUxMeasureNames(test);
	if(compositeMeasureList != null && !compositeMeasureList.isEmpty())
	{
		Hashtable includeInfosPerMeasure = compInfo.getIncludeInfosPerMeasure(test);
		Hashtable excludeInfosPerMeasure = compInfo.getExcludeInfosPerMeasure(test);
		for(int i=0;i<compositeMeasureList.size();i++)
		{
			String compTestMeasure = test + ":" + (String)compositeMeasureList.get(i);
			if(includeInfosPerMeasure != null && includeInfosPerMeasure.containsKey(compTestMeasure))
			{
				Hashtable includeInfosPerTest = (Hashtable)includeInfosPerMeasure.get(compTestMeasure);
				if(includeInfosPerTest != null)
				{
					Iterator itr = includeInfosPerTest.keySet().iterator();
					while(itr.hasNext())
					{
						String mainTest = (String)itr.next();
						ArrayList infoList = (ArrayList)includeInfosPerTest.get(mainTest);
						if(includeInfosPerTest_all.containsKey(mainTest))
						{
							ArrayList eInfoList = (ArrayList)includeInfosPerTest_all.get(mainTest);
							eInfoList.addAll(infoList);
						}
						else
						{
							ArrayList nlist = new ArrayList();
							nlist.addAll(infoList);
							includeInfosPerTest_all.put(mainTest,nlist);
						}
					}
				}
			}
			if(excludeInfosPerMeasure != null && excludeInfosPerMeasure.containsKey(compTestMeasure))
			{
				Hashtable excludeInfosPerTest = (Hashtable)excludeInfosPerMeasure.get(compTestMeasure);
				if(excludeInfosPerTest != null)
				{
					Iterator itr = excludeInfosPerTest.keySet().iterator();
					while(itr.hasNext())
					{
						String mainTest = (String)itr.next();
						ArrayList infoList = (ArrayList)excludeInfosPerTest.get(mainTest);
						if(excludeInfosPerTest_all.containsKey(mainTest))
						{
							ArrayList eInfoList = (ArrayList)excludeInfosPerTest_all.get(mainTest);
							eInfoList.addAll(infoList);
						}
						else
						{
							ArrayList nlist = new ArrayList();
							nlist.addAll(infoList);
							excludeInfosPerTest_all.put(mainTest,nlist);
						}
					}
				}
			}
		}
	}

	ArrayList al_managed = null;
	ArrayList al_managed_WithDescriptors = null;

	ArrayList al_unmanaged = null;
	ArrayList al_unmanaged_WithDescriptors = null;

	ArrayList al_temp = new ArrayList();
	ArrayList al_temp_WithDescriptors = new ArrayList();

	EgDbAdapterUI egDb = EgDbAdapterTypeUI.getObject();
	String status = egDb.setConnection();
	ResultSet rs = null;

	ArrayList excludeTestInfosDisplay = new ArrayList();
	ArrayList excludeTestInfosActual = new ArrayList();
	try
	{
		if(status != null && status.equals("CONNECTED"))
		{
			Vector associatedTests = compInfo.getAssociatedTests(test);
			for(int i=0;i<associatedTests.size();i++)
			{
				String s_test = (String)associatedTests.get(i);
				String displayname = _mapping.getTestDescription(s_test);
				ArrayList included_infos = null;
				ArrayList excluded_infos = null;
				ArrayList include_infos_endsWith_for_this_test = null;
				if(includeInfosPerTest_all != null && includeInfosPerTest_all.containsKey(s_test))
				{
					included_infos = (ArrayList)includeInfosPerTest_all.get(s_test);
				}
				if(excludeInfosPerTest_all != null && excludeInfosPerTest_all.containsKey(s_test))
				{
					excluded_infos = (ArrayList)excludeInfosPerTest_all.get(s_test);
				}

				boolean isHostSystemTest = false;
				String nickToQuery = null;
				String layersStr = tablesInfo.getLayerForTest(s_test);
				if(layersStr != null && !layersStr.equalsIgnoreCase("null"))
				{
					String allLayers[] = StringUtils.getTokens(layersStr,",");
					for(int j=0;j<allLayers.length;j++)
					{
						String layer = allLayers[j];
						if(layersForCompType.contains(layer) && layersForHostSystem.contains(layer))
						{
							isHostSystemTest=true;
							break;
						}
					}
				}
				if(isHostSystemTest)
				{
					nickToQuery = "'"+compNick+":NULL'";
				}
				else
				{
					nickToQuery = "'"+compNick+":"+port+"'";
				}
				rs = egDb.getDetailedMeasuresForAggregateTest(s_test,"1",nickToQuery);
				while(rs.next())
				{
					String trgt_host = rs.getString(1);
					String port_no = rs.getString(2);
					String site_name = rs.getString(3);
					String info = rs.getString(4);
					if(info.equals("++") || info.endsWith("++"))
						continue;
					boolean addExcludeTestInfos = false;
					if(!info.equals("+"))
					{
						String testInfo = info.substring(info.indexOf("+")+1);
						if(included_infos !=null)
						{
							boolean include_this = false;
							for(int x=0;x<included_infos.size();x++)
							{
								String selectedConfiguredInfo = (String)included_infos.get(x);
								if(testInfo.equals(selectedConfiguredInfo) || EgUtilities.isMatch(testInfo, selectedConfiguredInfo))
								{
									include_this=true;
									break;
								}
								else if(selectedConfiguredInfo.endsWith("#endsWith"))
								{
									selectedConfiguredInfo = selectedConfiguredInfo.substring(0,selectedConfiguredInfo.lastIndexOf("#"));
									if(testInfo.endsWith(selectedConfiguredInfo))
									{
										include_this=true;
										break;
									}
								}
							}
							if(!include_this)
							{
								addExcludeTestInfos=true;
								//continue;
							}
						}
						if(excluded_infos !=null)
						{
							boolean exclude_this = false;
							for(int x=0;x<excluded_infos.size();x++)
							{
								String selectedConfiguredInfo = (String)excluded_infos.get(x);
								if(testInfo.equals(selectedConfiguredInfo) || EgUtilities.isMatch(testInfo, selectedConfiguredInfo))
								{
									exclude_this=true;
									break;
								}
								else if(selectedConfiguredInfo.endsWith("#endsWith"))
								{
									selectedConfiguredInfo = selectedConfiguredInfo.substring(0,selectedConfiguredInfo.lastIndexOf("#"));
									if(testInfo.endsWith(selectedConfiguredInfo))
									{
										exclude_this=true;
										break;
									}
								}
							}
							if(exclude_this)
							{
								addExcludeTestInfos=true;
								//continue;
							}
						}
					}
					if (info.startsWith("+"))
					{
						if (info.equals("+"))
						{
							al_temp.add(displayname + ":NONE");
							al_temp_WithDescriptors.add(s_test + ":" + trgt_host + ":" + port_no + ":" + site_name + ":" + info);
							if(addExcludeTestInfos)
							{
								excludeTestInfosDisplay.add(displayname + ":NONE");
								excludeTestInfosActual.add(s_test + ":" + trgt_host + ":" + port_no + ":" + site_name + ":" + info);
							}
						}
						else
						{
							al_temp.add(displayname + ":" + info.substring(1,info.length()));
							al_temp_WithDescriptors.add(s_test + ":" + trgt_host + ":" + port_no + ":" + site_name + ":" + info);
							if(addExcludeTestInfos)
							{
								excludeTestInfosDisplay.add(displayname + ":" + info.substring(1,info.length()));
								excludeTestInfosActual.add(s_test + ":" + trgt_host + ":" + port_no + ":" + site_name + ":" + info);
							}
						}
					}
					else
					{
						if (info.endsWith("+"))
						{
							al_temp.add(displayname + ":" + info.substring(0,info.indexOf('+')));
							al_temp_WithDescriptors.add(s_test + ":" + trgt_host + ":" + port_no + ":" + site_name + ":" + info);
							if(addExcludeTestInfos)
							{
								excludeTestInfosDisplay.add(displayname + ":" + info.substring(0,info.indexOf('+')));
								excludeTestInfosActual.add(s_test + ":" + trgt_host + ":" + port_no + ":" + site_name + ":" + info);
							}
						}
						else
						{
							al_temp.add(displayname + ":" + info.substring(0,info.indexOf('+')) + ":" + info.substring(info.indexOf('+')+1,info.length()));
							al_temp_WithDescriptors.add(s_test + ":" + trgt_host + ":" + port_no + ":" + site_name + ":" + info);
							if(addExcludeTestInfos)
							{
								excludeTestInfosDisplay.add(displayname + ":" + info.substring(0,info.indexOf('+')) + ":" + info.substring(info.indexOf('+')+1,info.length()));
								excludeTestInfosActual.add(s_test + ":" + trgt_host + ":" + port_no + ":" + site_name + ":" + info);
							}
						}
					}
				}
			}
			if (rs != null)
			{
				rs.close();
			}
		}
		egDb.releaseConnection(false);
	}
	catch(Exception e)
	{
		egDb.releaseConnection(true);
		e.printStackTrace();
	}
	EgDbAdapterTypeUI.releaseObject(egDb);

	boolean defaultExcludeInfosSet = true;
	al_unmanaged = new ArrayList();
	al_unmanaged_WithDescriptors = new ArrayList();

	String[] variables = compInfo.getVariables("COMPOSITE_TEST_INFOS_EXCLUDED");

	if ((variables != null) && (variables.length > 0))
	{
		for(int j=0;j<variables.length;j++)
		{
			String var = variables[j];
			if (var.startsWith(test+":"+server+":"+comp))
			{
				defaultExcludeInfosSet=false;
				String s1 = var.substring(var.indexOf("#")+1,var.length());
				boolean infoEndsWithColon = false;
				if(s1.endsWith(":"))
					infoEndsWithColon = true;
				StringTokenizer st = new StringTokenizer(s1,":");
				String s_test = st.nextToken();
				String trgt_host = st.nextToken();
				String port_no = st.nextToken();
				String site_name = st.nextToken();
				String info ="";
				while(st.hasMoreTokens())
				{
					if(info.equals(""))
						info = st.nextToken();
					else
						info = info+":"+st.nextToken();
				}
				if(infoEndsWithColon)
					info = info+":";
				String displayname = _mapping.getTestDescription(s_test);
				if (info.startsWith("+"))
				{
					if (info.equals("+"))
					{
						al_unmanaged.add(displayname + ":NONE");
						al_unmanaged_WithDescriptors.add(s_test + ":" + trgt_host + ":" + port_no + ":" + site_name + ":" + info);
					}
					else
					{
						al_unmanaged.add(displayname + ":" + info.substring(1,info.length()));
						al_unmanaged_WithDescriptors.add(s_test + ":" + trgt_host + ":" + port_no + ":" + site_name + ":" + info);
					}
				}
				else
				{
					if (info.endsWith("+"))
					{
						al_unmanaged.add(displayname + ":" + info.substring(0,info.indexOf('+')));
						al_unmanaged_WithDescriptors.add(s_test + ":" + trgt_host + ":" + port_no + ":" + site_name + ":" + info);
					}
					else
					{
						al_unmanaged.add(displayname + ":" + info.substring(0,info.indexOf('+')) + ":" + info.substring(info.indexOf('+')+1,info.length()));
						al_unmanaged_WithDescriptors.add(s_test + ":" + trgt_host + ":" + port_no + ":" + site_name + ":" + info);
					}
				}
			}
		}
	}
	if(defaultExcludeInfosSet)
	{
		al_managed = new ArrayList();
		al_managed_WithDescriptors = new ArrayList();
		for(int i=0;i<al_temp_WithDescriptors.size();i++)
		{
			Object temp = al_temp_WithDescriptors.get(i);
			if(excludeTestInfosActual.contains(temp))
			{
				al_unmanaged.add(al_temp.get(i));
				al_unmanaged_WithDescriptors.add(temp);
			}
			else
			{
				al_managed.add(al_temp.get(i));
				al_managed_WithDescriptors.add(al_temp_WithDescriptors.get(i));
			}
		}
	}
	else if (al_unmanaged.size() == 0)
	{
		al_managed = al_temp;
		al_managed_WithDescriptors = al_temp_WithDescriptors;
	}
	else
	{
		al_managed = new ArrayList();
		al_managed_WithDescriptors = new ArrayList();

		for(int i=0;i<al_temp.size();i++)
		{
			Object temp = al_temp.get(i);
			if (!al_unmanaged.contains(temp))
			{
				al_managed.add(temp);
				al_managed_WithDescriptors.add(al_temp_WithDescriptors.get(i));
			}
		}
	}
	String previousIncludedDescriptors = null;
	String previousIncludedMasterTestDescriptors = null;
	JSONArray enabledTestsArr = new JSONArray();
	JSONObject enabledTests = new JSONObject();
	JSONArray commonTests = new JSONArray();
	JSONObject commonObject = new JSONObject();

	for(int i=0;i<al_managed.size();i++)
	{
		String mStr = (String) al_managed_WithDescriptors.get(i);	

		if(test != null && mStr.startsWith(masterInfoTest+":"))
		{
			if(previousIncludedMasterTestDescriptors==null)
				previousIncludedMasterTestDescriptors = mStr;
			else
				previousIncludedMasterTestDescriptors += "," + mStr;
		}

		if(mStr.indexOf("+") != -1)
		{
			mStr = StringUtils.replace(mStr,"+","");
		}
		if(mStr.indexOf(":NULL") != mStr.lastIndexOf(":NULL"))
		{
			int idx = mStr.lastIndexOf(":NULL");
			mStr = new StringBuffer(mStr).replace(idx+1,idx+5,"None").toString();
		}

		if(i==0)
			previousIncludedDescriptors = mStr;
		else
			previousIncludedDescriptors += "," + mStr;


		commonObject.put("displayField",deleteNull((String)al_managed.get(i)));
		commonObject.put("valueField",(String)al_managed_WithDescriptors.get(i));
		commonTests.add(commonObject);

		enabledTests.put("displayField",deleteNull((String)al_managed.get(i)));
		enabledTests.put("valueField",(String)al_managed_WithDescriptors.get(i));
		enabledTestsArr.add(enabledTests);
	}

	JSONArray disableTestsArr = new JSONArray();
	JSONObject disableTests = new JSONObject();

	for(int i=0;i<al_unmanaged.size();i++)
	{
		commonObject.put("displayField",deleteNull((String)al_unmanaged.get(i)));
		commonObject.put("valueField",(String)al_unmanaged_WithDescriptors.get(i));
		commonTests.add(commonObject);
		disableTests.put("displayField",deleteNull((String)al_unmanaged.get(i)));
		disableTests.put("valueField",(String)al_unmanaged_WithDescriptors.get(i));
		disableTestsArr.add(disableTests);
	}

	if (previousIncludedDescriptors == null)
	{
		rootJson.put("previousIncludedDescriptors","null");
	}
	else
	{
		rootJson.put("previousIncludedDescriptors",previousIncludedDescriptors);
	}
	if (previousIncludedMasterTestDescriptors == null)
	{
		rootJson.put("previousIncludedMasterTestDescriptors","null");
	}
	else
	{
		rootJson.put("previousIncludedMasterTestDescriptors",previousIncludedMasterTestDescriptors);
	}
	rootJson.put("itemSelectorValue",commonTests);
	rootJson.put("disableTests",disableTestsArr);
	rootJson.put("enabledTests",enabledTestsArr);
	out.println(rootJson.toString());
%>

<%!
	private String deleteNull(String desc)
	{
		int nullIndex =  desc.indexOf(":NULL:");
		if(nullIndex != -1)
		{
			return desc.substring(0,nullIndex)+desc.substring(nullIndex+5);
		}
		return desc;
	}
%>



