<%
/*
 *   File		:	EgConfigureComponentTests.jsp
 *   Purpose	:	To view and configure tests for components
 *   Author		:	S.Anand (2008)
 *   UI Design	:	Jaiwin & Krishnamurthi
*/
%>

<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import="java.util.*" %>
<%@ page import="java.io.File" %>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import="com.egurkha.util.*" %>
<%@ page import="java.net.URLDecoder" %>
<%@ page import = "com.egurkha.util.EgStackForBackButton"%>
<%@ page import ="com.egurkha.admin.EgTestSpecification"%>
<%@ page import = "net.sf.json.*"%>
<%@ page import = "egurkha.EgTestParamBean"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject hiddenObj = new JSONObject();
	
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	//String ua = request.getHeader( "User-Agent" );
	//boolean isMSIE6 = ( ua != null && ua.indexOf( "MSIE 6.0" ) != -1 );
%>
<%!

	private JSONArray getAgentsForSNMPUtility(EgSpecsInfo spec)
	{
		JSONArray resultAgentsArr = new JSONArray();
		JSONObject resultAgentObj = new JSONObject();

		String egServer = spec.getEGServer();
		if (!StringUtils.isNull(egServer))
		{
			resultAgentObj.put("displayField",egServer+" (Default)");
			resultAgentObj.put("valueField",egServer);
			resultAgentsArr.add(resultAgentObj);
		}

		String iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/"; 
		String extAgentConfig = "eg_external.ini"; 
		IniFile extAgentConfigIni = new IniFile(iniFile_dir + extAgentConfig);  
		Object [] extAgentKey = extAgentConfigIni.getVariables("Eg_External_Agents");

		if(extAgentKey != null)
		{
			List extAgtsList = new ArrayList(Arrays.asList(extAgentKey));
			extAgtsList.remove(egServer);

			if (extAgtsList != null)
			{
				for(int i=0; i<extAgtsList.size(); i++)
				{
					resultAgentObj = new JSONObject();

					String strKey = (String) extAgtsList.get(i);
					String extAgent = extAgentConfigIni.getValue("Eg_External_Agents",strKey); 
					StringTokenizer st = new StringTokenizer(extAgent,",");
					String ipAddr = st.nextToken();
					String nickVal = st.nextToken();

					resultAgentObj.put("displayField",nickVal);
					resultAgentObj.put("valueField",ipAddr);
					resultAgentsArr.add(resultAgentObj);
				}
			}
		}
		return resultAgentsArr;
	}


	private void changeModeParamPosToSNMPRelevantTests(ArrayList aResultant, ArrayList aListResultantTempInLowerCase,String portCase,String timeOutCase,String modeCase, int timeOutIdx)
	{

		String moveJmxOptionParam = null;
		String moveJmxOptionValue = null;
		String moveJmxDisplayControl = null;

		boolean jmxOption = aListResultantTempInLowerCase.contains("-metric_collection_type");
		int jmxOptionIdx = aListResultantTempInLowerCase.indexOf("-metric_collection_type");
		String jmxOptionCase = null;
		int tempJmxOptionIdx = -1;

		if(jmxOption)
		{
			if (jmxOptionIdx != -1)
			{
				jmxOptionCase = (String)aResultant.get(jmxOptionIdx);
			}
			tempJmxOptionIdx = aResultant.indexOf(jmxOptionCase);
			moveJmxOptionParam = (String)aResultant.remove(tempJmxOptionIdx);
			moveJmxOptionValue = (String)aResultant.remove(tempJmxOptionIdx);
			moveJmxDisplayControl = (String)aResultant.remove(tempJmxOptionIdx);
		}

		if (timeOutIdx == -1)
		{
			//put mode after port
			//-host,-port,-mode
			int tempModeIdx = aResultant.indexOf(modeCase);
			
			String moveModeParam = (String)aResultant.remove(tempModeIdx);
			String moveModeValue = (String)aResultant.remove(tempModeIdx);
			String moveModeDisplayControl = (String)aResultant.remove(tempModeIdx);

			int tempPortIdx = aResultant.indexOf(portCase);
			if(jmxOption)
			{
				aResultant.add(tempPortIdx+3,moveJmxOptionParam);
				aResultant.add(tempPortIdx+4,moveJmxOptionValue);
				aResultant.add(tempPortIdx+5,moveJmxDisplayControl);
				aResultant.add(tempPortIdx+6,moveModeParam);
				aResultant.add(tempPortIdx+7,moveModeValue);
				aResultant.add(tempPortIdx+8,moveModeDisplayControl);
			}
			else
			{
				aResultant.add(tempPortIdx+3,moveModeParam);
				aResultant.add(tempPortIdx+4,moveModeValue);
				aResultant.add(tempPortIdx+5,moveModeDisplayControl);
			}
		}
		else
		{
			int tempTimeOutCaseIdx = aResultant.indexOf(timeOutCase);
			String moveTimeOutParam = (String)aResultant.remove(tempTimeOutCaseIdx);
			String moveTimeOutValue = (String)aResultant.remove(tempTimeOutCaseIdx);
			String moveTimeOutDisplayControl = (String)aResultant.remove(tempTimeOutCaseIdx);

			//-host,-port,-timeout,-mode
			//put timeout after port
			int tempPortIdx = aResultant.indexOf(portCase);
			aResultant.add(tempPortIdx+3,moveTimeOutParam);
			aResultant.add(tempPortIdx+4,moveTimeOutValue);
			aResultant.add(tempPortIdx+5,moveTimeOutDisplayControl);

			int tempModeCaseIdx = aResultant.indexOf(modeCase);
			
			String moveModeParam = (String)aResultant.remove(tempModeCaseIdx);
			String moveModeValue = (String)aResultant.remove(tempModeCaseIdx);
			String moveModeDisplayControl = (String)aResultant.remove(tempModeCaseIdx);

			//put mode after timeout
			int tempTimeOutCaseIdx1 = aResultant.indexOf(timeOutCase);
			if(jmxOption)
			{
				aResultant.add(tempTimeOutCaseIdx1+3,moveJmxOptionParam);
				aResultant.add(tempTimeOutCaseIdx1+4,moveJmxOptionValue);
				aResultant.add(tempTimeOutCaseIdx1+5,moveJmxDisplayControl);
				aResultant.add(tempTimeOutCaseIdx1+6,moveModeParam);
				aResultant.add(tempTimeOutCaseIdx1+7,moveModeValue);
				aResultant.add(tempTimeOutCaseIdx1+8,moveModeDisplayControl);
			}
			else
			{
				aResultant.add(tempTimeOutCaseIdx1+3,moveModeParam);
				aResultant.add(tempTimeOutCaseIdx1+4,moveModeValue);
				aResultant.add(tempTimeOutCaseIdx1+5,moveModeDisplayControl);
			}
		}
	}

	private void changeMeasureModeParamPosition(ArrayList aResultant,ArrayList aListResultantTempInLowerCase)
	{
		int portIdx = aListResultantTempInLowerCase.indexOf("-port");
		String portCase = null;
		if (portIdx != -1)
		{
			portCase = (String)aResultant.get(portIdx);
		}

		int modeIdx = aListResultantTempInLowerCase.indexOf("-measure_mode");
		String modeCase = null;
		if (modeIdx != -1)
		{
			modeCase = (String)aResultant.get(modeIdx);
		}
		String moveJmxOptionParam = null;
		String moveJmxOptionValue = null;
		String moveJmxDisplayControl = null;
		boolean jmxOption = aListResultantTempInLowerCase.contains("-metric_collection_type");
		int jmxOptionIdx = aListResultantTempInLowerCase.indexOf("-metric_collection_type");
		String jmxOptionCase = null;
		int tempJmxOptionIdx = -1;
		if(jmxOption)
		{
			if (jmxOptionIdx != -1)
			{
				jmxOptionCase = (String)aResultant.get(jmxOptionIdx);
			}
			tempJmxOptionIdx = aResultant.indexOf(jmxOptionCase);
			moveJmxOptionParam = (String)aResultant.remove(tempJmxOptionIdx);
			moveJmxOptionValue = (String)aResultant.remove(tempJmxOptionIdx);
			moveJmxDisplayControl = (String)aResultant.remove(tempJmxOptionIdx);
		}

		//put measure_mode after port
		//-host,-port,-measure_mode
		int tempModeIdx = aResultant.indexOf(modeCase);
		String moveModeParam = (String)aResultant.remove(tempModeIdx);
		String moveModeValue = (String)aResultant.remove(tempModeIdx);
		String moveModeDisplayControl = (String)aResultant.remove(tempModeIdx);

		int tempPortIdx = aResultant.indexOf(portCase);
		if(jmxOption)
		{
			aResultant.add(tempPortIdx+3,moveJmxOptionParam);
			aResultant.add(tempPortIdx+4,moveJmxOptionValue);
			aResultant.add(tempPortIdx+5,moveJmxDisplayControl);
			aResultant.add(tempPortIdx+6,moveModeParam);
			aResultant.add(tempPortIdx+7,moveModeValue);
			aResultant.add(tempPortIdx+8,moveModeDisplayControl);
		}
		else
		{
			aResultant.add(tempPortIdx+3,moveModeParam);
			aResultant.add(tempPortIdx+4,moveModeValue);
			aResultant.add(tempPortIdx+5,moveModeDisplayControl);
		}
	}

	private String getRequiredParamNames(String componentType, String testName, IniFile egTestParamIni)
	{
		String requiredParamNames = "";
		requiredParamNames = egTestParamIni.getValue("VALIDATIONS_FIELDS",componentType+":Default");
		String specificValidationFieldsForTest=egTestParamIni.getValue("VALIDATIONS_FIELDS",testName);
		if(specificValidationFieldsForTest!=null && (!specificValidationFieldsForTest.equals("") && !specificValidationFieldsForTest.equalsIgnoreCase("null")))
		{
			requiredParamNames=requiredParamNames+","+specificValidationFieldsForTest;
		}
		StringBuffer sbreqValsForValidation=new StringBuffer(256);
		if(requiredParamNames!=null && !requiredParamNames.equals(""))
		{
			StringTokenizer stkvFields=new StringTokenizer(requiredParamNames,",");
			while(stkvFields.hasMoreTokens())
			{
				String fieldName=stkvFields.nextToken();
				fieldName=fieldName.toLowerCase();
				sbreqValsForValidation.append(fieldName+",");
			}
		}
		requiredParamNames=sbreqValsForValidation.toString()+"componentcredentialsneededtodovalidation";
		if(requiredParamNames!=null && requiredParamNames.endsWith(","))
		{
			requiredParamNames=requiredParamNames.substring(0,(requiredParamNames.length()-1));
		}
		return requiredParamNames;
	}


	private Hashtable getPolicyFilterParamsDetails(HttpServletRequest request, ArrayList aListResultantTempInLowerCase, ArrayList aResultant, String testName)
	{
		Hashtable resultSet = new Hashtable();
		IniFile testsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_tests.ini");
		String testParam[] = testsIni.getVariables("EVENTLOG_POLICIES");
		ArrayList aPolicyFilter = new ArrayList();
		String tPolicyFilter = "";
		boolean isPolicyParamExists = (aListResultantTempInLowerCase.contains("-policyfilter") && aListResultantTempInLowerCase.contains("-filter"));

		resultSet.put("isPolicyParamExists",isPolicyParamExists);
		
		String tLogType = "";
		int tLogTypeIdx = aListResultantTempInLowerCase.indexOf("-logtype");
		if (tLogTypeIdx > -1)
		{
			tLogType = (String) aResultant.get(tLogTypeIdx+1);
		}
		tLogType = (tLogType != null && tLogType.length() > 0)?tLogType:"";

		int tPolicyFilterIdx = aListResultantTempInLowerCase.indexOf("-policyfilter");
		if (tPolicyFilterIdx > -1)
		{
			tPolicyFilter = request.getParameter(((String)aResultant.get(tPolicyFilterIdx)).substring(1));
		}
		tPolicyFilter = (tPolicyFilter != null && tPolicyFilter.length() > 0)?tPolicyFilter:"";
		resultSet.put("tPolicyFilter",tPolicyFilter);

		if (isPolicyParamExists)
		{
			int policyFilterIdx = aListResultantTempInLowerCase.indexOf("-policyfilter");
			String policyFilterValue = (String)aResultant.get(policyFilterIdx+1);

			String strPolTrue = ""; 
			if ((policyFilterValue.equalsIgnoreCase("true") && 
				(tPolicyFilter.length()==0 || tPolicyFilter.equalsIgnoreCase("true"))) || 
				tPolicyFilter.equalsIgnoreCase("true"))
			{
				for(int i = 0;i<testParam.length;i++)
				{
					String strTestParamVars = testParam[i];
					String strTestParamTest = strTestParamVars.substring(0,strTestParamVars.indexOf(":"));
					strTestParamVars = strTestParamVars.substring(strTestParamVars.indexOf(":")+1);
					String strTestParamLogType = strTestParamVars.substring(0,strTestParamVars.indexOf(":"));

					if(!(strTestParamTest+":"+strTestParamLogType).equalsIgnoreCase(testName+":"+tLogType))
					{
						continue;
					}

					String str = testParam[i].substring(testParam[i].lastIndexOf(":")+1,testParam[i].length());
					if (aPolicyFilter != null && !aPolicyFilter.contains(str))
					{
						aPolicyFilter.add(str);
					}
				}

				if (aPolicyFilter != null && aPolicyFilter.size() > 0)
				{
					strPolTrue = StringUtils.getString(aPolicyFilter);
				}
				resultSet.put("isPolicyFilterTrue",strPolTrue);
			}

			if(tPolicyFilter.equalsIgnoreCase("false"))
			{
				ArrayList aListPolicy = new ArrayList();
				int filterIdx = aListResultantTempInLowerCase.indexOf("-filter");
				String filterValue = (String)aResultant.get(filterIdx+1);
				if(filterValue.indexOf(":") > -1)
				{
					if(filterValue.indexOf(";") > -1)
					{
						StringTokenizer policyTokens = new StringTokenizer(filterValue,";");
						while(policyTokens.hasMoreTokens())
						{
							String tempPolicy = policyTokens.nextToken();
							tempPolicy = tempPolicy.substring(0,tempPolicy.indexOf(":"));
							aListPolicy.add(tempPolicy);
						}
					}
					else
					{
						aListPolicy.add(filterValue.substring(0,filterValue.indexOf(":")));
					}
				}
				else
				{
					if(filterValue.indexOf(";")>-1)
					{
						//more than one policy name i.e -filter IISEvents;CitrixEvents;XchgEvents
						StringTokenizer policyTokens = new StringTokenizer(filterValue,";");
						while(policyTokens.hasMoreTokens())
						{
							aListPolicy.add(policyTokens.nextToken());
						}
					}
					else
					{
						//one policy name i.e -filter IISEvents
						aListPolicy.add(filterValue);
					}
				}

				for(int c=0;c<aListPolicy.size();c++)
				{
					String pattern = testName+":"+tLogType+":"+aListPolicy.get(c);
					String strVal = testsIni.getValue("EVENTLOG_POLICIES",pattern);
					if (!StringUtils.isNull(strVal))
					{
						strVal = (aListPolicy.get(c)).toString()+":"+strVal;
						aPolicyFilter.add(strVal);
					}
				}
			}

			if (aPolicyFilter != null && (aPolicyFilter.isEmpty() || !aPolicyFilter.contains("all")))
			{
				aPolicyFilter.add("all");
				IniFile egTestsIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_tests.ini");
				String strEvtPolVar = testName+":"+tLogType.toLowerCase()+":all";
				String strEvtPolVal = "all:none:all:none:all:none";
				egTestsIni.setValue("EVENTLOG_POLICIES",strEvtPolVar,strEvtPolVal);
				egTestsIni.saveFile();
				EgConfigFilesSync.releaseInstance(egTestsIni);
			}

			if (aPolicyFilter.size() > 0)
			{
				if (aPolicyFilter.contains("all"))
				{
					aPolicyFilter.remove("all");
					Collections.sort(aPolicyFilter,String.CASE_INSENSITIVE_ORDER);
					aPolicyFilter.add(0,"all");
				}
				else
				{
					Collections.sort(aPolicyFilter,String.CASE_INSENSITIVE_ORDER);
				}
			}
		}

		resultSet.put("aPolicyFilter",aPolicyFilter);
		if (isPolicyParamExists)
		{
			String strPolTrue = "";
			String jsonLogType = "";
			for (int i=0;i< aListResultantTempInLowerCase.size();i++)
			{
				String tempLogType = (String) aListResultantTempInLowerCase.get(i);
				if (!StringUtils.isNull(tempLogType) && tempLogType.equals("-logtype"))
				{
					jsonLogType = (String) aListResultantTempInLowerCase.get(i+1);
					break;
				}
			}

			ArrayList jsonPolicyFilter = new ArrayList();
			ArrayList specificTestsEventLogPolicyList = new ArrayList();

			for(int i = 0;i<testParam.length;i++)
			{
				String strTestParamVars = testParam[i];
				String strTestParamTest = strTestParamVars.substring(0,strTestParamVars.indexOf(":"));
				strTestParamVars = strTestParamVars.substring(strTestParamVars.indexOf(":")+1);
				String strTestParamLogType = strTestParamVars.substring(0,strTestParamVars.indexOf(":"));
				if(!((strTestParamTest+":"+strTestParamLogType).equalsIgnoreCase(testName+":"+jsonLogType)))
				{
					continue;
				}
				String str = testParam[i].substring(testParam[i].lastIndexOf(":")+1,testParam[i].length());
				jsonPolicyFilter.add(str);
				specificTestsEventLogPolicyList.add(testParam[i]);
			}

			if (jsonPolicyFilter.size() > 0)
			{
				if (jsonPolicyFilter.contains("all"))
				{
					jsonPolicyFilter.remove("all");
					Collections.sort(jsonPolicyFilter,String.CASE_INSENSITIVE_ORDER);
					jsonPolicyFilter.add(0,"all");
				}
				else
				{
					Collections.sort(jsonPolicyFilter,String.CASE_INSENSITIVE_ORDER);
					jsonPolicyFilter.add(0,"all");
				}
			}
			else
			{
				jsonPolicyFilter.add("all");
			}

			if (jsonPolicyFilter != null && jsonPolicyFilter.size() > 0)
			{
				strPolTrue = StringUtils.getString(jsonPolicyFilter);
			}
			resultSet.put("isPolicyFilterTrue",strPolTrue);


			jsonPolicyFilter = new ArrayList();
			ArrayList tmpAListPolicy = new ArrayList();
			int filterIdx = aListResultantTempInLowerCase.indexOf("-filter");
			String filterValue = (String)aResultant.get(filterIdx+1);
			if(filterValue.indexOf(":") > -1)
			{
				if(filterValue.indexOf(";") > -1)
				{
					StringTokenizer policyTokens = new StringTokenizer(filterValue,";");
					while(policyTokens.hasMoreTokens())
					{
						String tempPolicy = policyTokens.nextToken();
						tempPolicy = tempPolicy.substring(0,tempPolicy.indexOf(":"));
						tmpAListPolicy.add(tempPolicy);
					}
				}
				else
				{
					tmpAListPolicy.add(filterValue.substring(0,filterValue.indexOf(":")));
				}
			}
			else
			{
				if(filterValue.indexOf(";")>-1)
				{
					//more than one policy name i.e -filter IISEvents;CitrixEvents;XchgEvents
					StringTokenizer policyTokens = new StringTokenizer(filterValue,";");
					while(policyTokens.hasMoreTokens())
					{
						tmpAListPolicy.add(policyTokens.nextToken());
					}
				}
				else
				{
					//one policy name i.e -filter IISEvents
					tmpAListPolicy.add(filterValue);
				}
			}

			for(int c=0;c<tmpAListPolicy.size();c++)
			{
				String pattern = testName+":"+jsonLogType+":"+tmpAListPolicy.get(c);
				if (specificTestsEventLogPolicyList != null && !specificTestsEventLogPolicyList.isEmpty())
				{
					for (int j=0;j<specificTestsEventLogPolicyList.size();j++)
					{
						String strCorrectVariable = (String) specificTestsEventLogPolicyList.get(j);
						
						if (!com.egurkha.util.StringUtils.isNull(strCorrectVariable) && strCorrectVariable.equalsIgnoreCase(pattern))
						{
							pattern= strCorrectVariable;
							break;
						}
					}
				}

				String strVal = testsIni.getValue("EVENTLOG_POLICIES",pattern);
				if (!StringUtils.isNull(strVal))
				{
					strVal = (tmpAListPolicy.get(c)).toString()+":"+strVal;
					jsonPolicyFilter.add(strVal);
				}
				else
				{
					//all:all:none:all:none:all:none
					String polFilterName = tmpAListPolicy.get(c).toString();
					if (polFilterName.equals("all") && StringUtils.isNull(strVal))
					{
						strVal = "all:all:none:all:none:all:none";
						jsonPolicyFilter.add(strVal);
					}
				}
			}

			String strPolFalse = "";
			if (jsonPolicyFilter != null && jsonPolicyFilter.size() > 0)
			{
				if (jsonPolicyFilter.size() == 1)
				{
					strPolFalse = jsonPolicyFilter.get(0).toString();
				}
				else
				{
					for (int p=0;p<jsonPolicyFilter.size();p++)
					{
						String strPolicyDetails = jsonPolicyFilter.get(p).toString();
						strPolFalse += ";" + strPolicyDetails;
					}

					if (strPolFalse.startsWith(";"))
					{
						strPolFalse = strPolFalse.substring(1);
					}
				}
			}
			resultSet.put("isPolicyFilterFalse",strPolFalse);
		}

		return resultSet;
	}

	private JSONObject getExcludeTestForAllComponents(String componentType, ArrayList listOfComponents, ArrayList aListEnabledTestForCompType, EgTestParamBean prgBean)
	{
		ArrayList tmpList = new ArrayList();
		JSONObject excludeTestForAllCompObj = new JSONObject();
		//EgTestParamBean prgBean = new EgTestParamBean();

		//prgBean.createFile("eg_disable.ini");

		for (int j=0;j<listOfComponents.size();j++)
		{
			String strTempPattern = (String)listOfComponents.get(j);
			String tempComponent = strTempPattern.substring(strTempPattern.indexOf(":")+1);
			String compNick = tempComponent;
			if (!StringUtils.isNull(tempComponent) && tempComponent.indexOf(":") != -1)
			{
				compNick = tempComponent.substring(0,tempComponent.indexOf(":"));
			}

			String excludedTestForOtherComp = prgBean.getStrValue(componentType,componentType+":"+tempComponent);

			if (!StringUtils.isNull(excludedTestForOtherComp))
			{
				StringTokenizer excludedTestCompTokens = new StringTokenizer(excludedTestForOtherComp,",");
				while (excludedTestCompTokens.hasMoreElements())
				{
					String excludeTestOtherComp = (String)excludedTestCompTokens.nextElement();
					boolean isCompHost = aListEnabledTestForCompType.contains(excludeTestOtherComp);
					if (isCompHost)
					{
						if (!tmpList.contains(excludeTestOtherComp))
						{
							tmpList.add(excludeTestOtherComp);
							excludeTestForAllCompObj.put(excludeTestOtherComp,isCompHost);
							continue;
						}
					}
				}
			}

			String excludedTestForOtherHost = prgBean.getStrValue("Default_server","Default_server"+":"+compNick);
			if (excludedTestForOtherHost != null && !excludedTestForOtherHost.equals(""))
			{
				StringTokenizer excludedTestOtherTokens = new StringTokenizer(excludedTestForOtherHost,",");
				while (excludedTestOtherTokens.hasMoreElements())
				{
					String excludeOtherTest = (String)excludedTestOtherTokens.nextElement();
					boolean isComptypeTest = aListEnabledTestForCompType.contains(excludeOtherTest);
					if (isComptypeTest)
					{
						if (!tmpList.contains(excludeOtherTest))
						{
							tmpList.add(excludeOtherTest);
							excludeTestForAllCompObj.put(excludeOtherTest,isComptypeTest);
							continue;
						}
					}
				}
			}
		}
		return excludeTestForAllCompObj;
	}

	private JSONObject getIncludeTestForAllComponents(String componentType, ArrayList listOfComponents, ArrayList excludedTestList, EgTestParamBean prgBean)
	{
		JSONObject includeTestForAllCompObj = new JSONObject();
		EgSpecsInfo egSpecs = new EgSpecsInfo("manager");

		for (int i=0;i<excludedTestList.size();i++)
		{
			String strIncTest = (String)excludedTestList.get(i);
			ArrayList aListStrExcludedComponents = null;
			ArrayList aListStrMainComponent = null;

			boolean isPortRelevantForStrTest = egSpecs.isPortRelevantForTest(strIncTest);
			String strSubject = "";
			if (isPortRelevantForStrTest)
			{
				strSubject = componentType;
			}
			else
			{
				strSubject = "Default_server";
			}
			boolean hasMoreThanOneCompToIncl = false;
			int compCount=0;
			int prevCompIdx=-1;

			for (int j=0;j<listOfComponents.size();j++)
			{
				String strIncludeTestPattern = (String)listOfComponents.get(j);
				String includeTestComponent = strIncludeTestPattern.substring(strIncludeTestPattern.indexOf(":")+1);
				String searchVariable = "";

				if (isPortRelevantForStrTest)
				{
					searchVariable = componentType + ":" + includeTestComponent;
				}
				else
				{
					searchVariable = "Default_server" + ":" + includeTestComponent.substring(0,includeTestComponent.indexOf(":"));
				}

				String strValue = prgBean.getStrValue(strSubject,searchVariable);
				ArrayList aListResultantTest = getArrayList(strValue,",");
				if (aListResultantTest.contains(strIncTest))
				{
					if (!hasMoreThanOneCompToIncl)
					{
						if (prevCompIdx == -1)
						{
							compCount++;
						}
						else
						{
							if (j != prevCompIdx)
							{
								compCount++;
							}
						}
						prevCompIdx=j;

						if (compCount > 1)
						{
							hasMoreThanOneCompToIncl = true;
						}
					}
				}
			}
			includeTestForAllCompObj.put(strIncTest,hasMoreThanOneCompToIncl);
		}
		return includeTestForAllCompObj;
	}

	private Hashtable getCredentialParamsDetails(HttpServletRequest request, ArrayList aListResultantTempInLowerCase, ArrayList aResultant, String testName, ArrayList aListParamsWithDoubleQuotes, ArrayList aListTcKeywordsLowerCase)
	{
		Hashtable resultSet = new Hashtable();
		ArrayList aUrlCredentialVal = new ArrayList();
		ArrayList aListSystemPropKeys = new ArrayList();
		ArrayList aListSystemPropValues = new ArrayList();
		ArrayList aListContentValues = new ArrayList();
		ArrayList aListEncodingValues = new ArrayList();
		ArrayList aListFilePathValues = new ArrayList();
		ArrayList aTempUrl = new ArrayList();

		String moreUrl = request.getParameter("moreurl");
		moreUrl = (moreUrl!=null)?moreUrl:"";

		//if (isCredentialParamExist)
		boolean isUrlParamExist = aListResultantTempInLowerCase.contains("-url");
		boolean isWsdlUrlExist = aListResultantTempInLowerCase.contains("-wsdl_url");
		boolean isPrivateKeyParamExist = aListResultantTempInLowerCase.contains("-privatekey");
		boolean isSystemPropKeyParamExist = aListResultantTempInLowerCase.contains("-systempropertykey");
		String previousUrl = null;

		int urlIdx=0;
		if (isUrlParamExist)
		{
			urlIdx = aListResultantTempInLowerCase.indexOf("-url");
		}
		else if(isWsdlUrlExist)
		{
			urlIdx = aListResultantTempInLowerCase.indexOf("-wsdl_url");
		}

		String urls = aResultant.get(urlIdx+1).toString();
		previousUrl = urls;

		StringTokenizer urlTokens = new StringTokenizer(urls,"|");
		int urlCount = urlTokens.countTokens();
		int credentialIdx = aListResultantTempInLowerCase.indexOf("-credentials");
		String credentialValues = aResultant.get(credentialIdx+1).toString();
		StringTokenizer credentialValuesTokens = new StringTokenizer(credentialValues,"|");
		int credentialTokens = credentialValuesTokens.countTokens();

		int contentIdx = aListResultantTempInLowerCase.indexOf("-content");
		String contentValues = aResultant.get(contentIdx+1).toString();
		if (aListParamsWithDoubleQuotes != null && aListParamsWithDoubleQuotes.contains("content"))
		{
			if (contentValues.startsWith("\"") && contentValues.endsWith("\""))
			{
				contentValues = contentValues.substring(1,contentValues.length()-1);
			}
		}

		StringTokenizer contentValuesTokens = new StringTokenizer(contentValues,"|");
		int contentTokens = contentValuesTokens.countTokens();

		int encodingIdx = aListResultantTempInLowerCase.indexOf("-encoding");
		String encodingValues = aResultant.get(encodingIdx+1).toString();
		StringTokenizer encodingValuesTokens = new StringTokenizer(encodingValues,"|");
		int encodingTokens = encodingValuesTokens.countTokens();

		//will encounter when urlCount exceeds credentialTokens and vice versa
		//This case will be encountered in apply to other component case
		if (urlCount != credentialTokens)
		{
			if (urlCount > credentialTokens)
			{
				int difference = urlCount - credentialTokens;
				String tempPassword = EgCrypt.encrypt("none");
				for (int i=0;i<difference;i++)
				{
					credentialValues = credentialValues + "|" + "none" + ":" +tempPassword;
				}
			}
			if (urlCount < credentialTokens)
			{
				int difference = credentialTokens - urlCount;
				for (int i=0;i<difference;i++)
				{
					credentialValues = credentialValues.substring(0,credentialValues.lastIndexOf("|"));
				}
			}
			credentialValuesTokens = new StringTokenizer(credentialValues,"|");
		}

		if (urlCount != contentTokens)
		{
			if (urlCount > contentTokens)
			{
				int difference = urlCount - contentTokens;
				for (int i=0;i<difference;i++)
				{
					contentValues = contentValues + "|" + "none:none";
				}
			}
			if (urlCount < contentTokens)
			{
				int difference = contentTokens - urlCount;
				for (int i=0;i<difference;i++)
				{
					contentValues = contentValues.substring(0,contentValues.lastIndexOf("|"));
				}
			}
			contentValuesTokens = new StringTokenizer(contentValues,"|");
		}

		if (urlCount != encodingTokens)
		{
			if (urlCount > encodingTokens)
			{
				int difference = urlCount - encodingTokens;
				for (int i=0;i<difference;i++)
				{
					encodingValues = encodingValues + "|" + "none";
				}
			}
			if (urlCount < encodingTokens)
			{
				int difference = encodingTokens - urlCount;
				for (int i=0;i<difference;i++)
				{
					encodingValues = encodingValues.substring(0,encodingValues.lastIndexOf("|"));
				}
			}
			encodingValuesTokens = new StringTokenizer(encodingValues,"|");
		}


		String systemPropKeys = "";
		StringTokenizer systemPropKeyTokens = null;
		int propKeyTokens = 0;

		String systemPropValues = "";
		StringTokenizer systemPropValuesTokens = null;
		int propValTokens = 0;

		if (isSystemPropKeyParamExist)
		{

			int systemPropKeyIdx = aListResultantTempInLowerCase.indexOf("-systempropertykey");
			systemPropKeys = aResultant.get(systemPropKeyIdx+1).toString();
			systemPropKeyTokens = new StringTokenizer(systemPropKeys,"|");
			propKeyTokens = systemPropKeyTokens.countTokens();

			int systemPropValIdx = aListResultantTempInLowerCase.indexOf("-systempropertyvalue");
			systemPropValues = aResultant.get(systemPropValIdx+1).toString();
			systemPropValuesTokens = new StringTokenizer(systemPropValues,"|");
			propValTokens = systemPropValuesTokens.countTokens();


			if (urlCount != propKeyTokens)
			{
				if (urlCount > propKeyTokens)
				{
					int difference = urlCount - propKeyTokens;
					for (int i=0;i<difference;i++)
					{
						systemPropKeys = systemPropKeys + "|" + "none";
					}
				}
				if (urlCount < propKeyTokens)
				{
					int difference = propKeyTokens - urlCount;
					for (int i=0;i<difference;i++)
					{
						systemPropKeys = systemPropKeys.substring(0,systemPropKeys.lastIndexOf("|"));
					}
				}
				systemPropKeyTokens = new StringTokenizer(systemPropKeys,"|");
			}

			if (urlCount != propValTokens)
			{
				if (urlCount > propValTokens)
				{
					int difference = urlCount - propValTokens;
					for (int i=0;i<difference;i++)
					{
						systemPropValues = systemPropValues + "|" + "none";
					}
				}
				if (urlCount < propValTokens)
				{
					int difference = propValTokens - urlCount;
					for (int i=0;i<difference;i++)
					{
						systemPropValues = systemPropValues.substring(0,systemPropValues.lastIndexOf("|"));
					}
				}
				systemPropValuesTokens = new StringTokenizer(systemPropValues,"|");
			}
		}


		String filePathValues ="";
		StringTokenizer filePathValuesTokens =null;
		int filePathTokens =0;
		if(isPrivateKeyParamExist)
		{
			int filePathIdx = aListResultantTempInLowerCase.indexOf("-privatekey");
			filePathValues = aResultant.get(filePathIdx+1).toString();
			filePathValuesTokens = new StringTokenizer(filePathValues,"|");
			filePathTokens = filePathValuesTokens.countTokens();
			if (urlCount != filePathTokens)
			{
				if (urlCount > filePathTokens)
				{
					int difference = urlCount - filePathTokens;
					String tempPassword = EgCrypt.encrypt("none");
					for (int i=0;i<difference;i++)
					{
						filePathValues = filePathValues + "|" + "none" + ":" +tempPassword;
					}
				}
				if (urlCount < filePathTokens)
				{
					int difference = filePathTokens - urlCount;
					for (int i=0;i<difference;i++)
					{
						filePathValues = filePathValues.substring(0,filePathValues.lastIndexOf("|"));
					}
				}
				filePathValuesTokens = new StringTokenizer(filePathValues,"|");
			}
		}

		while(urlTokens.hasMoreTokens())
		{
			String s = urlTokens.nextToken();
			if (s.indexOf(":") > -1) //URL Format->$name:$url
			{
				aUrlCredentialVal.add(s.substring(0,s.indexOf(":")));
				String s1 = credentialValuesTokens.nextElement().toString();
				aUrlCredentialVal.add(s1.substring(0,s1.indexOf(":")));
				//decrypting the password
				String s2 = s1.substring(s1.indexOf(":")+1);
				s2 = EgCrypt.decrypt(s2);
				if (!aListTcKeywordsLowerCase.contains(s2.toLowerCase()))
				{
					s2 += "~EG~"; // salt for pwd
					s2 = EgCrypt.encrypt(s2); 
				}

				aUrlCredentialVal.add(s2);

				String s3 = contentValuesTokens.nextElement().toString();
				aListContentValues.add(s3);
				String s4 = encodingValuesTokens.nextElement().toString();
				aListEncodingValues.add(s4);
				
				if(isPrivateKeyParamExist)
				{
					String s5 = filePathValuesTokens.nextElement().toString();
					if(s5 != null && s5.startsWith("none"))
					{
						if(s5.indexOf(":")>-1)
						{
							aListFilePathValues.add(s5.substring(0,s5.indexOf(":")));
							//decrypting the password
							String s6 = s5.substring(s5.indexOf(":")+1);
							s6 = EgCrypt.decrypt(s6);
							if (!aListTcKeywordsLowerCase.contains(s6.toLowerCase()))
							{
								s6 += "~EG~"; // salt for pwd
								s6 = EgCrypt.encrypt(s6); 
							}
							aListFilePathValues.add(s6);

						}
					}
					else
					{
						if(s5.indexOf(":")>-1)
						{
							String start = s5.substring(0,s5.indexOf(":"));
							String remaining = s5.substring(s5.indexOf(":")+1);
							String end = "";
							String passStr = "";
							if(s5.indexOf(":/")> -1 || s5.indexOf(":\\")> -1)
							{
								end = remaining.substring(0, remaining.indexOf(":"));
								passStr = remaining.substring(remaining.indexOf(":")+1);
							}
							else
							{
								passStr = remaining;
							}
							if(end.length() > 0)
							{
								aListFilePathValues.add(start+":"+end);
							}
							else
							{
								aListFilePathValues.add(start);
							}

							//decrypting the password

							passStr = EgCrypt.decrypt(passStr);
							if (!aListTcKeywordsLowerCase.contains(passStr.toLowerCase()))
							{
								passStr += "~EG~"; // salt for pwd
								passStr = EgCrypt.encrypt(passStr); 
							}
							aListFilePathValues.add(passStr);
						}
					}
				}

				if (isSystemPropKeyParamExist)
				{
					String s6 = systemPropKeyTokens.nextElement().toString();
					aListSystemPropKeys.add(s6);

					String s7 = systemPropValuesTokens.nextElement().toString();
					aListSystemPropValues.add(s7);
				}
			}
			else //URL Format->$unconfigured
			{
				aUrlCredentialVal.add("$unconfigured");
				aUrlCredentialVal.add("none");
				aUrlCredentialVal.add("none");

				aListContentValues.add("none:none");
				aListEncodingValues.add("none");
				
				if(isPrivateKeyParamExist)
				{
					aListFilePathValues.add("none");
					aListFilePathValues.add("none");
				}

				if (isSystemPropKeyParamExist)
				{
					aListSystemPropKeys.add("none");
					aListSystemPropValues.add("none");
				}
			}
		}

		if (moreUrl.equals("true"))
		{
			String reqUrlVal = "";
			if(isUrlParamExist)
				reqUrlVal = request.getParameter("url");
			else if(isWsdlUrlExist)
				reqUrlVal = request.getParameter("WSDL_URL");

			StringTokenizer reqUrlTokens = new StringTokenizer(reqUrlVal,",");
			while (reqUrlTokens.hasMoreTokens())
			{
				String s3 = reqUrlTokens.nextToken();
				String s4 = s3.substring(0,s3.indexOf(":"));
				aTempUrl.add(s4);
				boolean urlExist = aUrlCredentialVal.contains(s4);
				if(urlExist)
				{
					int urlIndex = aUrlCredentialVal.indexOf(s4);
					String urlUsername = (String)aUrlCredentialVal.get(urlIndex+1);
					String urlUserpass = (String)aUrlCredentialVal.get(urlIndex+2);
					aTempUrl.add(urlUsername);
					aTempUrl.add(urlUserpass);
				}
				else
				{
					aTempUrl.add("none");
					aTempUrl.add("none");
				}
			}
			aUrlCredentialVal = aTempUrl;
		}

		resultSet.put("previousUrl",previousUrl);
		resultSet.put("aUrlCredentialVal",aUrlCredentialVal);
		resultSet.put("aListSystemPropKeys",aListSystemPropKeys);
		resultSet.put("aListSystemPropValues",aListSystemPropValues);
		resultSet.put("aListContentValues",aListContentValues);
		resultSet.put("aListEncodingValues",aListEncodingValues);
		resultSet.put("aListFilePathValues",aListFilePathValues);

		return resultSet;
	}

	private Hashtable getDDRelatedDetails(String componentType, String componentName, String componentNickName, String testName, boolean isPortRelevantForTest)
	{
		Hashtable resultTable = new Hashtable();
		com.eg.IniFile formatObj = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_format.ini");
		boolean allowDetailedDiagnosis = false;
		boolean isTestDetailedDiagnosisDisabledGlobally = false;
		String detailedDiagnosisOn = "";
		String detailedDiagnosisOff = "";

		String[] detailedDiagnosisVariable = formatObj.getVariables("FORMAT");
		ArrayList aListDetailedDiagnosisTest = new ArrayList();
		for(int i=0;i<detailedDiagnosisVariable.length ;i++)
		{
			String detailedDiagnosisTest = detailedDiagnosisVariable[i].substring(0,detailedDiagnosisVariable[i].indexOf(":"));
			if (!aListDetailedDiagnosisTest.contains(detailedDiagnosisTest))
			{
				aListDetailedDiagnosisTest.add(detailedDiagnosisTest);
			}
		}

		ArrayList aListDisabledDetailedDiagnosisTest = new ArrayList();
		if (testName != null && aListDetailedDiagnosisTest.contains(testName))
		{
			allowDetailedDiagnosis = true;

			//Default
			com.eg.IniFile testInfoObj = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_testinfo.ini");

			String[] disableDDVariables = testInfoObj.getVariables("Disable_DD");
			for(int i=0;i<disableDDVariables.length;i++)
			{
				if(!aListDisabledDetailedDiagnosisTest.contains(disableDDVariables[i]))
				{
					aListDisabledDetailedDiagnosisTest.add(disableDDVariables[i]);
				}
			}

			//Specific
			Hashtable hashDDSpecficVariablesValues = new Hashtable();
			String[] disableSpecficDDVariables1 = testInfoObj.getVariables("Disable_Specific_DD");
			for(int i=0;i<disableSpecficDDVariables1.length;i++)
			{
				String str = testInfoObj.getValue("Disable_Specific_DD",disableSpecficDDVariables1[i]);
				hashDDSpecficVariablesValues.put(disableSpecficDDVariables1[i],str);
			}

			boolean specificDDCheck = false;
			String ddSpecficTest = "";
			if (isPortRelevantForTest)
			{
				ddSpecficTest = (String)hashDDSpecficVariablesValues.get(componentName);
			}
			else
			{
				ddSpecficTest = (String)hashDDSpecficVariablesValues.get(componentNickName+":NULL");
			}
		
			ddSpecficTest = (ddSpecficTest != null)?ddSpecficTest:"";
			StringTokenizer sTokens = new StringTokenizer(ddSpecficTest,",");
			while (sTokens.hasMoreTokens())
			{
				String eachTest  = sTokens.nextToken();
				if (eachTest.equals(testName))
				{
					specificDDCheck = true;
					break;
				}
			}

			if (aListDisabledDetailedDiagnosisTest.contains(testName) || specificDDCheck)
			{
				detailedDiagnosisOff = "checked";
			}
			else
			{
				detailedDiagnosisOn = "checked";
			}

			if (aListDisabledDetailedDiagnosisTest.contains(testName))
			{
				isTestDetailedDiagnosisDisabledGlobally = true;
			}
		}

		resultTable.put("allowDetailedDiagnosis",allowDetailedDiagnosis);
		resultTable.put("isTestDetailedDiagnosisDisabledGlobally",isTestDetailedDiagnosisDisabledGlobally);
		resultTable.put("detailedDiagnosisOn",detailedDiagnosisOn);
		resultTable.put("detailedDiagnosisOff",detailedDiagnosisOff);
		return resultTable;
	}

	private int getAggregateMinTestperiod(String componentType, String componentName, String componentNickName, String testName, boolean isAggregateTest)
	{
		int minimumTestPeriod = -1;
		EgExternalInfo egExternalInfo = new EgExternalInfo("manager");
		if (EgInstallInfo.isAggSupported && isAggregateTest)
		{
			ArrayList aListAggComp = new ArrayList();
			IniFile  aggIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_aggregate.ini");
			String variables[] = aggIni.getVariables("AGGREGATE_COMPONENTS");
			if (variables != null && variables.length>0)
			{
				String temp = componentType + ":" + componentNickName + ":";
				for(int i=0;i<variables.length;i++)
				{
					if (!variables[i].startsWith(temp)) continue;
					aListAggComp.add(variables[i].substring(variables[i].indexOf("#")+1));
				}
			}
			IniFile agentsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini");
			String testSelected = aggIni.getValue("AGGREGATE_TEST",testName);

			for(int i=0;i<aListAggComp.size();i++)
			{
				String str = (String) aListAggComp.get(i);
				String tempCompType = str.substring(0,str.indexOf(":"));
				String tempCompName = str.substring(str.indexOf(":")+1,str.length());
				List agentNames = egExternalInfo.getAgentsFor(testSelected, tempCompType,tempCompName.substring(0,tempCompName.indexOf(":")));
				for(int k=0; k<agentNames.size(); k++)
				{
					String agentName = (String)agentNames.get(k);
					String tempVariables[] = agentsIni.getVariables(agentName);
					String specificPattern_A = testSelected + ":" + tempCompType + ":" + tempCompName;
					String specificPattern_B = testSelected + ":" + tempCompType + ":" + tempCompName.substring(0,tempCompName.indexOf(":"));
					String defaultPattern_A = testSelected + "::" + tempCompName;
					String defaultPattern_B = testSelected + "::" + tempCompName.substring(0,tempCompName.indexOf(":"));

					String s_temp  = "";
					List aListTempVariables = Arrays.asList(tempVariables);
					if (aListTempVariables.contains(specificPattern_A))
					{
						s_temp = specificPattern_A;
					}
					else if (aListTempVariables.contains(specificPattern_B))
					{
						s_temp = specificPattern_B;
					}
					else if (aListTempVariables.contains(defaultPattern_A))
					{
						s_temp = defaultPattern_A;
					}
					else if (aListTempVariables.contains(defaultPattern_B))
					{
						s_temp = defaultPattern_B;
					}

					if (s_temp.equalsIgnoreCase("")) continue;

					String iniValue = agentsIni.getValue(agentName,s_temp);
					String timePeriod = iniValue.substring(iniValue.lastIndexOf(EgConstants.COMMA)+1).trim();
					int intValue = Integer.parseInt(timePeriod);
					if (intValue > minimumTestPeriod) 
					{
						minimumTestPeriod = intValue;
					}
				}
			}
		}

		return minimumTestPeriod;
	}

	private ArrayList getOtherComponents(ArrayList listOfComponents, String componentType, String componentName, String testName, boolean isPortRelevantForTest)
	{
		ArrayList aListConfigureComponentsClone = new ArrayList();
		ArrayList aListConfigureComponents = new ArrayList(listOfComponents);
			String currentConfigComponent = componentType + ":" + componentName;
			if (aListConfigureComponents.contains(currentConfigComponent))
			{
				aListConfigureComponents.remove(currentConfigComponent);
			}
			if (aListConfigureComponents.size() > 0)
			{
				com.eg.IniFile prgBean = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_disable.ini");

				aListConfigureComponentsClone = (ArrayList)aListConfigureComponents.clone();
				for (int i=0;i<aListConfigureComponents.size();i++)
				{
					String strComp = (String)aListConfigureComponents.get(i);
					strComp = strComp.substring(strComp.indexOf(":")+1,strComp.length());
					String tempComp = new String(strComp);
					String excludedTestForComponent = "";
					if (isPortRelevantForTest)
					{
						excludedTestForComponent = prgBean.getValue(componentType,componentType+":"+strComp);
					}
					else
					{
						strComp = strComp.substring(0,strComp.indexOf(":"));
						excludedTestForComponent = prgBean.getValue("Default_server","Default_server"+":"+strComp);
					}

					if (excludedTestForComponent.equals("")) continue;

					StringTokenizer stComp = new StringTokenizer(excludedTestForComponent,",");
					while(stComp.hasMoreTokens())
					{
						String strTest = stComp.nextToken();
						if (strTest.equals(testName))
						{
							aListConfigureComponentsClone.remove(componentType+":"+tempComp);
							break;
						}
					}
				}
			}
		return aListConfigureComponentsClone;
	}

	private Hashtable getWebportAndVCenterDetails (HttpServletRequest request, IniFile servicesIniFile, ArrayList aListResultantTempInLowerCase,ArrayList aResultant,String testName,String previousTestName)
	{
		Hashtable result = new Hashtable();
		if (aListResultantTempInLowerCase.contains("-virtual_center"))
		{
			//To configure value for virtual centers - starts
			int tempVirtual_centerIdx = aListResultantTempInLowerCase.indexOf("-virtual_center");
			String tempVirtual_centerValue = ((String)aResultant.get(tempVirtual_centerIdx+1)).trim();

			String[] virtualCenters = servicesIniFile.getVariables("VIRTUAL_CENTER");

			String selectedVirtualCenter = "";
			if (testName.equals(previousTestName))
			{
				selectedVirtualCenter = request.getParameter("virtual_center");
				selectedVirtualCenter = (selectedVirtualCenter != null)?selectedVirtualCenter:"";
			}
			result.put("selectedVirtualCenter",selectedVirtualCenter);

			if (!selectedVirtualCenter.equals(""))
			{
				String sslValue = "";
				String esx_UserValue = "";
				String esx_PassWord = "";
				String webPort = "";
				String selectedVirtualCenterValue = "";
				if (selectedVirtualCenter.equalsIgnoreCase("none"))
				{
					if (tempVirtual_centerValue.equalsIgnoreCase("none"))
					{
						int tempIdx = aListResultantTempInLowerCase.indexOf("-esx_user");
						esx_UserValue = ((String)aResultant.get(tempIdx+1)).trim();

						tempIdx = aListResultantTempInLowerCase.indexOf("-esx_password");
						esx_PassWord = ((String)aResultant.get(tempIdx+1)).trim();

						tempIdx = aListResultantTempInLowerCase.indexOf("-ssl");
						sslValue = ((String)aResultant.get(tempIdx+1)).trim();

						tempIdx = aListResultantTempInLowerCase.indexOf("-webport");
						webPort = ((String)aResultant.get(tempIdx+1)).trim();

						if (webPort.equalsIgnoreCase("default"))
						{
							if (sslValue.equalsIgnoreCase("true") || 
							sslValue.equalsIgnoreCase("yes"))
							{
								webPort = "443";
							}
							else
							{
								webPort = "80";
							}
						}
					}
					else
					{
						esx_UserValue = "$unconfigured";
						esx_PassWord = "$unconfigured";
						sslValue = "true";
						webPort = "443";
					}
				}
				else if (selectedVirtualCenter.equalsIgnoreCase("other"))
				{
					esx_UserValue = "none";
					esx_PassWord = "none";
					sslValue = "true";
					webPort = "443";
				}
				else
				{
					selectedVirtualCenterValue = servicesIniFile.getValue("VIRTUAL_CENTER",selectedVirtualCenter);
					selectedVirtualCenterValue = (selectedVirtualCenterValue != null)?selectedVirtualCenterValue:"";
					if (!selectedVirtualCenterValue.equals(""))
					{
						StringTokenizer stVirtualCenterTokens = null;
						stVirtualCenterTokens = new StringTokenizer(selectedVirtualCenterValue,"#");
						sslValue = stVirtualCenterTokens.nextToken();
						esx_UserValue = stVirtualCenterTokens.nextToken();
						esx_PassWord = stVirtualCenterTokens.nextToken();
						stVirtualCenterTokens.nextToken();
						webPort = stVirtualCenterTokens.nextToken();
					}
				}

				result.put("selectedVirtualCenter",selectedVirtualCenter);
				result.put("sslValue",sslValue);
				result.put("esx_UserValue",esx_UserValue);
				result.put("esx_PassWord",esx_PassWord);
				result.put("webPort",webPort);
			}
			else
			{
				boolean isNeedtoChangeWebport = false;
				ArrayList aListTempVirtualCenters = null;
				boolean hasVirtualCenters = false;
				if (virtualCenters != null && virtualCenters.length > 0)
				{
					aListTempVirtualCenters = new ArrayList(Arrays.asList(virtualCenters));
					hasVirtualCenters = true;
				}

				if (tempVirtual_centerValue.equalsIgnoreCase("none"))
				{
					int tempIdx = aListResultantTempInLowerCase.indexOf("-webport");
					String webPort = ((String)aResultant.get(tempIdx+1)).trim();
					if (webPort.equalsIgnoreCase("default"))
					{
						isNeedtoChangeWebport = true;
						tempIdx = aListResultantTempInLowerCase.indexOf("-ssl");
						String sslValue = ((String)aResultant.get(tempIdx+1)).trim();
						if (sslValue.equalsIgnoreCase("true") || sslValue.equalsIgnoreCase("yes"))
						{
							webPort = "443";
						}
						else
						{
							webPort = "80";
						}
						result.put("webPort",webPort);
					}
				}
				else if ((aListTempVirtualCenters == null) || (hasVirtualCenters && !aListTempVirtualCenters.contains(tempVirtual_centerValue)))
				{
					//upgrade issue
					int tempIdx = aListResultantTempInLowerCase.indexOf("-webport");
					String webPort = ((String)aResultant.get(tempIdx+1)).trim();
					if (webPort.equalsIgnoreCase("default"))
					{
						isNeedtoChangeWebport = true;
						tempIdx = aListResultantTempInLowerCase.indexOf("-ssl");
						String sslValue = ((String)aResultant.get(tempIdx+1)).trim();
						if (sslValue.equalsIgnoreCase("true") || sslValue.equalsIgnoreCase("yes"))
						{
							webPort = "443";
						}
						else
						{
							webPort = "80";
						}
						result.put("webPort",webPort);
					}
				}
				result.put("isNeedtoChangeWebport",isNeedtoChangeWebport);
			}
		//To configure value for virtual centers - ends
		}
		else if (aListResultantTempInLowerCase.contains("-prism_ip"))
		{
			//To configure value for virtual centers - starts
			int tempCVM_IPIdx = aListResultantTempInLowerCase.indexOf("-prism_ip");
			String tempCVM_IPValue = ((String)aResultant.get(tempCVM_IPIdx+1)).trim();
			result.put("tempCVM_IPValue",tempCVM_IPValue);

			String[] nutanixPrisms = servicesIniFile.getVariables("NUTANIX");
			//result.put("nutanixPrisms",nutanixPrisms);

			String selectedCVMIP = "";
			if (testName.equals(previousTestName))
			{
				selectedCVMIP = request.getParameter("Prism_IP");
				selectedCVMIP = (selectedCVMIP != null)?selectedCVMIP:"";
			}

			result.put("selectedCVMIP",selectedCVMIP);

			if (!selectedCVMIP.equals(""))
			{
				String sslValue = "";
				String cvm_UserValue = "";
				String cvm_PassWord = "";
				String webPort = "";
				String selectedCVMIPValue = "";
				if (selectedCVMIP.equalsIgnoreCase("none"))
				{
					if (tempCVM_IPValue.equalsIgnoreCase("none"))
					{
						int tempIdx = aListResultantTempInLowerCase.indexOf("-prism_user");
						cvm_UserValue = ((String)aResultant.get(tempIdx+1)).trim();

						tempIdx = aListResultantTempInLowerCase.indexOf("-prism_password");
						cvm_PassWord = ((String)aResultant.get(tempIdx+1)).trim();

						tempIdx = aListResultantTempInLowerCase.indexOf("-ssl");
						sslValue = ((String)aResultant.get(tempIdx+1)).trim();

						tempIdx = aListResultantTempInLowerCase.indexOf("-webport");
						webPort = ((String)aResultant.get(tempIdx+1)).trim();

						if (webPort.equalsIgnoreCase("default"))
						{
							webPort = "9440";
						}
					}
					else
					{
						cvm_UserValue = "$unconfigured";
						cvm_PassWord = "$unconfigured";
						sslValue = "true";
						webPort = "9440";
					}
				}
				else if (selectedCVMIP.equalsIgnoreCase("other"))
				{
					cvm_UserValue = "none";
					cvm_PassWord = "none";
					sslValue = "true";
					webPort = "9440";
				}
				else
				{
					selectedCVMIPValue = servicesIniFile.getValue("NUTANIX",selectedCVMIP);
					selectedCVMIPValue = (selectedCVMIPValue != null)?selectedCVMIPValue:"";
					if (!selectedCVMIPValue.equals(""))
					{
						StringTokenizer stCVMTokens = null;
						stCVMTokens = new StringTokenizer(selectedCVMIPValue,"#");
						sslValue = stCVMTokens.nextToken();
						cvm_UserValue = stCVMTokens.nextToken();
						cvm_PassWord = stCVMTokens.nextToken();
						stCVMTokens.nextToken();
						webPort = stCVMTokens.nextToken();
					}
				}

				result.put("selectedCVMIP",selectedCVMIP);
				result.put("sslValue",sslValue);
				result.put("cvm_UserValue",cvm_UserValue);
				result.put("cvm_PassWord",cvm_PassWord);
				result.put("webPort",webPort);
			}
			else
			{
				boolean isNeedtoChangeWebport = false;

				ArrayList aListTempNutanixPrisms = null;
				boolean hasNutanixPrisms = false;
				if (nutanixPrisms != null && nutanixPrisms.length > 0)
				{
					aListTempNutanixPrisms = new ArrayList(Arrays.asList(nutanixPrisms));
					hasNutanixPrisms = true;
				}

				if (tempCVM_IPValue.equalsIgnoreCase("none"))
				{
					int tempIdx = aListResultantTempInLowerCase.indexOf("-webport");
					String webPort = ((String)aResultant.get(tempIdx+1)).trim();
					if (webPort.equalsIgnoreCase("default"))
					{
						isNeedtoChangeWebport = true;
						webPort = "9440";
						result.put("webPort",webPort);
					}
				}
				else if ((aListTempNutanixPrisms == null) || (hasNutanixPrisms && !aListTempNutanixPrisms.contains(tempCVM_IPValue)))
				{
					//upgrade issue
					int tempIdx = aListResultantTempInLowerCase.indexOf("-webport");
					String webPort = ((String)aResultant.get(tempIdx+1)).trim();
					if (webPort.equalsIgnoreCase("default"))
					{
						isNeedtoChangeWebport = true;
						webPort = "9440";
						result.put("webPort",webPort);
					}
				}
				result.put("isNeedtoChangeWebport",isNeedtoChangeWebport);
			}
			//To configure value for nutanix prisms - ends
		}
		else
		{
			int webPortIdx = aListResultantTempInLowerCase.indexOf("-webport");
			String webPort = ((String)aResultant.get(webPortIdx+1)).trim();

			boolean isNeedtoChangeWebport = false;
			if (webPort.equalsIgnoreCase("default"))
			{
				isNeedtoChangeWebport = true;
				int sslIdx = aListResultantTempInLowerCase.indexOf("-ssl");
				String tempSslValue = (String)aResultant.get(sslIdx+1);
				if (tempSslValue.equalsIgnoreCase("true") || tempSslValue.equalsIgnoreCase("yes"))
				{
					webPort = "443";
				}
				else
				{
					webPort = "80";
				}
				result.put("webPort",webPort);
			}
			result.put("isNeedtoChangeWebport",isNeedtoChangeWebport);

		}
		return result;
	}

	private Hashtable getHMCAndMgmtServerDetails(HttpServletRequest request, IniFile servicesIniFile, ArrayList aListResultantTempInLowerCase,ArrayList aResultant,String testName,String previousTestName)
	{
		Hashtable resultTable = new Hashtable();
		String resIsManagedByValue = "";
		if (testName.equals(previousTestName))
		{
			String strIsManagedByChanged = request.getParameter("isManagedByChanged");
			if (strIsManagedByChanged == null)
			{
				String hmcMgmtServer = request.getParameter("management_server");
				if (hmcMgmtServer == null)
				{
					hmcMgmtServer = "none";
				}

				//resultTable.put("hmcMgmtServer",hmcMgmtServer);
				String strMgmtUser = "";
				String strMgmtPassword = "";
				if (hmcMgmtServer.equalsIgnoreCase("none"))
				{
					strMgmtUser = "$unconfigured";
					strMgmtPassword = "$unconfigured";
				}
				else
				{
					String strTemp = servicesIniFile.getValue("HMC",hmcMgmtServer);
					strTemp = strTemp.substring(strTemp.indexOf("#")+1);

					strMgmtUser = strTemp.substring(0,strTemp.indexOf("#"));
					strTemp = strTemp.substring(strTemp.indexOf("#")+1);

					strMgmtPassword = strTemp.substring(0,strTemp.indexOf("#"));
					strMgmtPassword = EgCrypt.decrypt(strMgmtPassword);
				}
				resultTable.put("strMgmtUser",strMgmtUser);
				resultTable.put("strMgmtPassword",strMgmtPassword);
			}
			else
			{
				String tempManagedBy = request.getParameter("is_managed_by");
				resultTable.put("tempManagedBy",tempManagedBy);
			}

			resIsManagedByValue = request.getParameter("is_managed_by");
		}
		else
		{
			int isManagedByIdx = aListResultantTempInLowerCase.indexOf("-is_managed_by");
			resIsManagedByValue = (String)aResultant.get(isManagedByIdx+1);
		}

		resultTable.put("resIsManagedByValue",resIsManagedByValue);
		return resultTable;
	}
	private Hashtable getRHEVMgrHostDetails(HttpServletRequest request, IniFile servicesIniFile, ArrayList aListTcKeywordsLowerCase, String testName,String previousTestName)
	{
		Hashtable resultTable = new Hashtable();
		if (testName.equals(previousTestName))
		{
			String rhevManager = request.getParameter("Rhel_mgr_host");
			if (rhevManager == null)
			{
				rhevManager = "none";
			}
		
			String strRhevUser = "";
			String strRhevPassword = "";
			String strRhevPort = "";
			String strRhevDomain = "";
			String strSSL = "";
			if (rhevManager.equalsIgnoreCase("none"))
			{
				strRhevUser = "$unconfigured";
				strRhevPassword = "$unconfigured";
				strRhevPort = "8443";
				strRhevDomain = "internal";
				strSSL = "false";
			}
			else
			{
				String strTemp = servicesIniFile.getValue("RHEV",rhevManager);
				strSSL = strTemp.substring(0,strTemp.indexOf("#"));
				strTemp = strTemp.substring(strTemp.indexOf("#")+1);

				strRhevUser = strTemp.substring(0,strTemp.indexOf("#"));
				strTemp = strTemp.substring(strTemp.indexOf("#")+1);

				strRhevPassword = strTemp.substring(0,strTemp.indexOf("#"));
				strRhevPassword = EgCrypt.decrypt(strRhevPassword);
				if (!aListTcKeywordsLowerCase.contains(strRhevPassword.toLowerCase()))
				{
					strRhevPassword += "~EG~"; // salt for pwd
					strRhevPassword = EgCrypt.encrypt(strRhevPassword); 
				}

				strTemp = strTemp.substring(strTemp.indexOf("#")+1);
				strTemp = strTemp.substring(strTemp.indexOf("#")+1);
				strRhevPort = strTemp.substring(0,strTemp.indexOf("#"));
				strTemp = strTemp.substring(strTemp.indexOf("#")+1);
				strRhevDomain = strTemp;
			}
			resultTable.put("strRhevUser",strRhevUser);
			resultTable.put("strRhevPassword",strRhevPassword);
			resultTable.put("strRhevPort",strRhevPort);
			resultTable.put("strRhevDomain",strRhevDomain);
			resultTable.put("strSSL",strSSL);
		}
		return resultTable;
	}

	private Hashtable getEMCXtremIODetails(HttpServletRequest request, IniFile servicesIniFile, ArrayList aListTcKeywordsLowerCase, String testName,String previousTestName)
	{
		Hashtable resultTable = new Hashtable();
		boolean isChangeRequires = false;

		if (testName.equals(previousTestName))
		{
			isChangeRequires = true;
			String xmsIP = request.getParameter("xms_ip");
			if (xmsIP == null)
			{
				xmsIP = "none";
			}
	
			String strEmcIOUser = "";
			String strEmcIOPassword = "";
			String strSSL = "";
			
			if (xmsIP.equalsIgnoreCase("none"))
			{
				strEmcIOUser = "$unconfigured";
				strEmcIOPassword = "$unconfigured";
				strSSL = "false";
			}
			else
			{
				String strTemp = servicesIniFile.getValue("EMC_XtremIO_4x",xmsIP);
				strSSL = strTemp.substring(0,strTemp.indexOf("#"));
				strTemp = strTemp.substring(strTemp.indexOf("#")+1);

				strEmcIOUser = strTemp.substring(0,strTemp.indexOf("#"));
				strTemp = strTemp.substring(strTemp.indexOf("#")+1);

				strEmcIOPassword = strTemp.substring(0,strTemp.indexOf("#"));
				strEmcIOPassword = EgCrypt.decrypt(strEmcIOPassword);
				if (!aListTcKeywordsLowerCase.contains(strEmcIOPassword.toLowerCase()))
				{
					strEmcIOPassword += "~EG~"; // salt for pwd
					strEmcIOPassword = EgCrypt.encrypt(strEmcIOPassword); 
				}
			}
			resultTable.put("strEmcIOUser",strEmcIOUser);
			resultTable.put("strEmcIOPassword",strEmcIOPassword);
			resultTable.put("strSSL",strSSL);
		}
		resultTable.put("isChangeRequires",isChangeRequires);
		
		return resultTable;
	}

	private JSONArray getCorrectiveScriptOSFiles(String agentOS, String testName)
	{
		JSONArray correctiveScriptArr = new JSONArray();
		JSONObject correctiveScriptObj = new JSONObject();
		String installDir  = EgInstallInfo.getInstallDir() + "/bin/AutoCorrect";

		if (!StringUtils.isNull(agentOS))
		{
			File osFolder = new File(installDir+"/"+agentOS);
			if (osFolder.exists())
			{
				String[] fileList = osFolder.list();
				if (fileList != null && fileList.length > 0)
				{
					boolean hasExactTestFile = false;
					for (int os=0;os<fileList.length;os++)
					{
						correctiveScriptObj = new JSONObject();
						String strFileName = fileList[os];
						if (!StringUtils.isNull(strFileName) && strFileName.startsWith(testName))
						{
							correctiveScriptObj.put("displayField",strFileName);
							correctiveScriptObj.put("valueField",strFileName);
							hasExactTestFile = true;
							correctiveScriptArr.add(correctiveScriptObj);
						}
					}
					if (hasExactTestFile == false)
					{
						correctiveScriptObj.put("displayField","None");
						correctiveScriptObj.put("valueField","none");
						correctiveScriptArr.add(correctiveScriptObj);
					}
				}
				else
				{
					correctiveScriptObj.put("displayField","None");
					correctiveScriptObj.put("valueField","none");
					correctiveScriptArr.add(correctiveScriptObj);
				}
			}
			else
			{
				correctiveScriptObj.put("displayField","None");
				correctiveScriptObj.put("valueField","none");
				correctiveScriptArr.add(correctiveScriptObj);
			}
		}
		else
		{
			correctiveScriptObj.put("displayField","None");
			correctiveScriptObj.put("valueField","none");
			correctiveScriptArr.add(correctiveScriptObj);
		}
		return correctiveScriptArr;
	}

	private String getWinShareParamsValue(String paramName, String paramValue, String displayControl, ArrayList aListTcKeywordsLowerCase)
	{
		if (displayControl.equalsIgnoreCase("password"))
		{
			if (paramValue.indexOf("|") > -1)
			{
				String tempStr = "";
				StringTokenizer st1 = new StringTokenizer(paramValue,"|");
				while(st1.hasMoreTokens())
				{
					String pwdWinShareAndSome = EgCrypt.decrypt(st1.nextToken());

					if (pwdWinShareAndSome.indexOf("@") != -1)
					{
						String strTokenGetDomain =  pwdWinShareAndSome.substring(0,pwdWinShareAndSome.indexOf("@"));
						String strTokenGetPass =  pwdWinShareAndSome.substring(pwdWinShareAndSome.indexOf("@")+1);
						if (strTokenGetPass.indexOf("~EG~") != -1)
						{
							strTokenGetPass = strTokenGetPass.substring(0,strTokenGetPass.indexOf("~EG~"));
						}

						if (!aListTcKeywordsLowerCase.contains(strTokenGetPass.toLowerCase()))
						{
							strTokenGetPass += "~EG~"; // salt for pwd
							strTokenGetPass = EgCrypt.encrypt(strTokenGetPass); 
						}

						pwdWinShareAndSome = strTokenGetDomain + "@" +  strTokenGetPass;
					}
					else
					{
						if(!aListTcKeywordsLowerCase.contains(pwdWinShareAndSome.toLowerCase()))
						{
							pwdWinShareAndSome += "~EG~"; // salt for pwd
							pwdWinShareAndSome = EgCrypt.encrypt(pwdWinShareAndSome); 
						}
					}
					tempStr += pwdWinShareAndSome + "#~#";
				}
				paramValue = tempStr.substring(0, tempStr.length()-3);
			}
			else
			{
				paramValue = EgCrypt.decrypt(paramValue);
				if (paramValue.indexOf("@") != -1)
				{
					//paramValue =  paramValue.substring(paramValue.indexOf("@")+1);
					String strSingleTokenGetDomain =  paramValue.substring(0,paramValue.indexOf("@"));
					String strSingleTokenGetPass =  paramValue.substring(paramValue.indexOf("@")+1);
					if (strSingleTokenGetPass.indexOf("~EG~") != -1)
					{
						strSingleTokenGetPass = strSingleTokenGetPass.substring(0,strSingleTokenGetPass.indexOf("~EG~"));
					}

					if (!aListTcKeywordsLowerCase.contains(strSingleTokenGetPass.toLowerCase()))
					{
						strSingleTokenGetPass += "~EG~"; // salt for pwd
						strSingleTokenGetPass = EgCrypt.encrypt(strSingleTokenGetPass); 
					}
					paramValue = strSingleTokenGetDomain + "@" +  strSingleTokenGetPass;
				}
				else
				{
					if (!aListTcKeywordsLowerCase.contains(paramValue.toLowerCase()))
					{
						paramValue += "~EG~"; // salt for pwd
						paramValue = EgCrypt.encrypt(paramValue); 
					}
				}
			}
		}
		else
		{
			if (paramValue.indexOf("|") > -1)
			{
				paramValue = StringUtils.replace(paramValue,"|",",");
			}
		}
		return paramValue;
	}

	private JSONArray getEncodeParamList()
	{
		JSONArray encodeParamArr = new JSONArray();
		IniFile testParamFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_testParam.ini");
		String[] encodeParamList = testParamFile.getVariables("TC_SECURITY_SUSPICIOUS_PARAMS");
		if(encodeParamList != null && encodeParamList.length >0)
		{
			for(int i=0;i<encodeParamList.length;i++)
			{
				String paramName = encodeParamList[i];
				encodeParamArr.add(paramName);
			}
		}
		return encodeParamArr;
	}
%>
<jsp:useBean id="testlist" scope ="page" class ="egurkha.TestConfigSpecsBean"/>
<jsp:useBean id="TestConfig" scope="page" class="egurkha.TestsNotConfigured"/>
<jsp:useBean id="prgBean" scope="page" class="egurkha.EgTestParamBean"/>

<%

	String selectedCompType = "";

	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	//tells information about the corresponding authenticated user
	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	boolean allCompAccess = ri.hasAllComponentAccess();
	rootJson.put("allCompAccess",allCompAccess);

	//ensure whether the user is configuration management enabled
	EgUserRole userRole = _user.getUserRole();
	boolean hasAdminTab = userRole.hasAnyAdminRole(EgUserPermission.ADMIN);
	boolean hasSpecificTestConfiguration = userRole.hasAnyAdminRole(EgUserPermission.AGENT_TEST_CONFIG);
	boolean isCompletedUserRole = userRole.hasAllComponentAccess();
	boolean isAdmin = _user.isAdmin();
	boolean enableDisableCsLink = false;
	if (isAdmin)
	{
		enableDisableCsLink = true;
	}
	else if (hasAdminTab && hasSpecificTestConfiguration && isCompletedUserRole)
	{
		enableDisableCsLink = true;
	}
	rootJson.put("enableDisableCsLink", enableDisableCsLink);
	rootJson.put("hasSpecificTestConfiguration", hasSpecificTestConfiguration);
	rootJson.put("isCompletedUserRole", isCompletedUserRole);


	List listComponentTypes = Arrays.asList(ri.getServerTypes());
	listComponentTypes = sorter.getSortedCompTypeList(listComponentTypes);


	String componentType = request.getParameter("componentType");
	componentType = (componentType == null)?"":componentType;

	String componentName = request.getParameter("componentName");
	componentName = (componentName == null)?"":componentName;
	String testName = request.getParameter("testName");
	testName = (testName == null)?"":testName;

	Object encodeParamObj= session.getAttribute("encodeParamJsonList");
	if(encodeParamObj == null)
	{
		JSONArray encodeParamArr = new JSONArray();
		//IniFile testParamFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_testParam.ini");
		//String[] encodeParamList = testParamFile.getVariables("TC_SECURITY_SUSPICIOUS_PARAMS");
		//if(encodeParamList != null && encodeParamList.length >0)
		//{
			//for(int i=0;i<encodeParamList.length;i++)
			//{
				//String paramName = encodeParamList[i];
				//encodeParamArr.add(paramName);
			//}
		//}
		encodeParamArr = getEncodeParamList();
		session.setAttribute("encodeParamJsonList",encodeParamArr);
		rootJson.put("encodeParamList",encodeParamArr);
	}
	else
	{
		rootJson.put("encodeParamList",(JSONArray)encodeParamObj);
	}

	Hashtable auditLogHt = new Hashtable();
	Hashtable httpTestAuditData = new Hashtable();
	boolean isConfigSupported = EgInstallInfo.isConfigSupported;
	EgUsersInfo usersInfo = new EgUsersInfo();
	boolean userBasedLicense = usersInfo.isUserBasedLicense();
	EgServicesInfo servicesInfo = new EgServicesInfo("manager");
	boolean isAllowHostName = servicesInfo.isAllowHostNames();
	boolean remoteControlEnabled = new EgMemCheck().isRemoteControlEnabled();
	IniFile egTestParamIni = null;
	com.eg.IniFile servicesIniFile = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
	IniFile pwdProfileIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_pwdprofile.ini");

	rootJson.put("isAllowHostName",isAllowHostName);

	EgCorrectiveScripts correctiveScript = new EgCorrectiveScripts();
	com.eg.IniFile egMgrMiscIni = new com.eg.IniFile (EgInstallInfo.getInstallDir()+"/manager/config/eg_mgrmisc.ini");
	String componentsLimit = egMgrMiscIni.getValue("MISC_ARGS","IncludeExcludeComponentsLimit");
	int componentsAllowedLimit = 100;
	if (!StringUtils.isNull(componentsLimit))
	{
		componentsAllowedLimit = Integer.parseInt(componentsLimit);
	}

	//String allowQualifiedHostNames = servicesIniFile.getValue("MISC_ARGS","AllowQualifiedHostNames");
	//allowQualifiedHostNames = StringUtils.isNull(allowQualifiedHostNames)?"yes":allowQualifiedHostNames.trim();

	int limit = 15;
	IniFile egUI = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_ui.ini");
	String strLimit = egUI.getValue("MISC_ARGS","SEARCHBOX_ENABLE_LIMIT");
	Vector defaultTestPeriods = egUI.getAllValues("TEST_FREQUENCY");
	if (!StringUtils.isNull(strLimit))
	{
		try
		{
			limit = Integer.parseInt(strLimit);
		}
		catch(Exception ee)
		{
			limit = 15;
		}
	}

	TreeMap tmapUnconfigComponents = new TreeMap(); 
	String showUnconfigCompType = request.getParameter("showUnconfigCompType");
	showUnconfigCompType = (showUnconfigCompType == null)?"false":showUnconfigCompType;
	if (!StringUtils.isNull(showUnconfigCompType) && showUnconfigCompType.equals("true"))
	{
		EgTestSpecification egTestSpecification = null;
		List listUnconfiguredComponents = ri.getAllServers();
		boolean hasManagedComponents = listUnconfiguredComponents!=null && listUnconfiguredComponents.size() > 0 ? true:false;
		boolean hasUnConfiguredTests = false;
		ArrayList filterUnconfigServers = new ArrayList();
		if (hasManagedComponents)
		{
			egTestSpecification = new EgTestSpecification(listUnconfiguredComponents);
			if (_user != null && EgInstallInfo.isConfigSupported)
			{
				egTestSpecification.setConfigSupported(isConfigSupported);
			}
			TreeMap tmapUnConfigTests = egTestSpecification.getUnconfiguredTest();
			Iterator itrUnConfigTests = tmapUnConfigTests.keySet().iterator();
			for(int i=0; i<tmapUnConfigTests.size(); i++)
			{
				String tempCompType=(String)itrUnConfigTests.next();
				TreeMap tmapTempCompUnconfigTests = (TreeMap)tmapUnConfigTests.get(tempCompType);
				if (tmapTempCompUnconfigTests != null && !tmapTempCompUnconfigTests.isEmpty())
				{
					ArrayList unconfigComponentList = new ArrayList();
					filterUnconfigServers.add(tempCompType);
					Iterator itrUnConfigCompsItr = tmapTempCompUnconfigTests.keySet().iterator();
					for(int j=0; j<tmapTempCompUnconfigTests.size(); j++)
					{
						String strUnconfigComp = (String) itrUnConfigCompsItr.next();

						if (!StringUtils.isNull(strUnconfigComp))
						{
							unconfigComponentList.add(tempCompType+":"+strUnconfigComp);
						}
					}
					tmapUnconfigComponents.put(tempCompType,unconfigComponentList);
				}
			}

			List removeServerList = new ArrayList();
			for (int j=0; j<listComponentTypes.size(); j++)
			{
				EgName nameObj = (EgName)listComponentTypes.get(j);
				String actualname = nameObj.getActualName();
				if (filterUnconfigServers != null && !filterUnconfigServers.isEmpty() && filterUnconfigServers.contains(actualname))
				{
					removeServerList.add(nameObj);
				}
			}

			listComponentTypes = new ArrayList();
			if (removeServerList != null && !removeServerList.isEmpty())
			{
				listComponentTypes.addAll(removeServerList);
			}
		}
	}
	
	String testType = request.getParameter("testType");
	testType = (testType == null)?"PerformanceTest":testType;

	if (_user != null && isConfigSupported)
	{
		isConfigSupported = userRole.hasAnyConfigRole(EgUserPermission.CONFIG);
	}
	rootJson.put("isConfigSupported",isConfigSupported);

	if (isConfigSupported)
	{
		rootJson.put("testTypeCombo",true);
		rootJson.put("selectedTestType",testType);
	}
	else
	{
		rootJson.put("testTypeCombo",false);
	}

	JSONObject compTypeObj = new JSONObject();
	JSONArray compTypeArr = new JSONArray();
	if (listComponentTypes.size() > 0)
	{
		compTypeObj.put("valueField","-1");
		compTypeObj.put("displayField",_mapping.getTextDescription("admin.common.Choose a component type"));
		compTypeArr.add(compTypeObj);
	}
	else
	{
		compTypeObj.put("valueField","-1");
		compTypeObj.put("displayField",_mapping.getTextDescription("admin.common.Not Applicable"));
		compTypeArr.add(compTypeObj);
	}

	//EgName class is used to hold name and its localised name.
	for (int j=0; j<listComponentTypes.size(); j++)
	{
		EgName nameObj = (EgName)listComponentTypes.get(j);
		String actualname = nameObj.getActualName();
		String localname = nameObj.getLocalName();
		compTypeObj.put("valueField",actualname);
		compTypeObj.put("displayField",localname);
		compTypeArr.add(compTypeObj);
		if (actualname.equals(componentType))
		{
			selectedCompType = localname;
			rootJson.put("selectedCompType",actualname);
		}
		
	}
	rootJson.put("compTypeArr",compTypeArr);

	JSONObject compNameObj = new JSONObject();
	JSONArray compNameArr = new JSONArray();

	if (StringUtils.isNull(componentType))
	{
		compNameObj.put("valueField","-1");
		compNameObj.put("displayField",_mapping.getTextDescription("admin.common.Not applicable"));
		compNameArr.add(compNameObj);
		rootJson.put("compNameArr",compNameArr);


		out.println(rootJson.toString());
		return;
	}

	String layerName = request.getParameter("layerName");
	if (!StringUtils.isNull(layerName))
	{
		rootJson.put("layerName",layerName);
	}

	//String testType = request.getParameter("testType");
	String clickedFrom = request.getParameter("clickedFrom");
	clickedFrom = (clickedFrom == null)?"":clickedFrom;
	if (!StringUtils.isNull(clickedFrom))
	{
		rootJson.put("clickedFrom",clickedFrom);
		session.setAttribute("clickedFrom",clickedFrom);
	}
	//testType = (testType == null)?"PerformanceTest":testType;

	rootJson.put("isNeedEditableComboBox",new Boolean(false));
	int enableConfTestSize = 0;

	String previousTestName = request.getParameter("previousTestName");
	previousTestName = (previousTestName != null)?previousTestName:"";
	boolean isAutoConfiguration = false;
	boolean allowAggregateOperation = true;
	rootJson.put("componentType",componentType);
	rootJson.put("componentName",componentName);
	rootJson.put("testName",testName);
	rootJson.put("displayTestName",_mapping.getTestDescription(testName));
	rootJson.put("showUnconfigCompType",showUnconfigCompType);
	rootJson.put("previousTestName",previousTestName);
	rootJson.put("oidForComponentType", getComponentTypeOID(componentType));//OID for ComponentType

	pr_test=(testName.endsWith("_rx"))?testName:"";
	//added by pravat - Start
	String[] xenStr = {"XDMActionTest","XDMAppsTest","XDMDevicesTest","XDMUsersTest","XDMPackagesTest"};
	ArrayList xenList = new ArrayList(Arrays.asList(xenStr));
	boolean isXDMGetDevicesInfo = false;
	if (componentType.equalsIgnoreCase("XenMobileMDM") && xenList.indexOf(testName) > -1)
	{
		isXDMGetDevicesInfo = true;
	}
	else
	{
		isXDMGetDevicesInfo = false;
	}
	rootJson.put("isXDMGetDevicesInfo",isXDMGetDevicesInfo);
	//added by pravat - End

	//User license  starts
	String usrBasedTests = "";
	if (userBasedLicense)
	{
		if(!componentType.equals(""))
		{
			ArrayList userBasedTests = usersInfo.getUserBasedTests(componentType);
			for (int i=0; i<userBasedTests.size(); i++)
			{
				String test = userBasedTests.get(i).toString();
				if(usrBasedTests.equals(""))
				{
					usrBasedTests += test;
				}
				else
				{
					usrBasedTests += ","+test;
				}
			}
			rootJson.put("usrBasedTests",usrBasedTests);
		}
	}
	//User license  ends

	String componentNickName = null;
	String testperiod = "";
	String adminUsers = "";
	String hostEditableMode = "";
	String portEditableMode = "";
	String[] componentsList = null;
	Hashtable ht_AgentsList = new Hashtable();
	List listAgents = null;
	ArrayList aListPasswordParameters = null;
	String allowedParams = "";
	String[] tcKeywords = new String[0];
	String[] tcKeywordswoSplChar = new String[0];
	ArrayList aListTcKeywordsLowerCase = new ArrayList();
	String strTcKeywords = "";
	ArrayList aListDefaultPasswordParameters = null;
	ArrayList aListParamsWithDoubleQuotes = null;
	String strDoubleQuotesParams = "";
	String strDelimiter = "";
	String strDelimiterMask = "";
	String paramForDisplayingValidateButton="";

	//contains enabled test for a component type
	ArrayList aListEnabledTestForCompType = new ArrayList();

	ArrayList unconfiguredTestList = new ArrayList();
	ArrayList defaultconfiguredTestList = new ArrayList();
	ArrayList userconfiguredTestList = new ArrayList();
	ArrayList excludedTestList = new ArrayList();

	ArrayList aResultant = new ArrayList();
	//lowercase in unordered format of aResultant
	ArrayList aListResultantTempInLowerCase = new ArrayList();
	//lowercase in ordered format of aResultant
	ArrayList aListResultantInLowerCase = new ArrayList();

	//apply to other components
	ArrayList aListConfigureComponents = new ArrayList();
	ArrayList aListConfigureComponentsClone = null;

	//password profile params
	EgPwdProfile pwdProf = new EgPwdProfile();
	boolean isEnablePwdProfile = false;
	ArrayList pwdProfileParamList = new ArrayList();
	TreeMap pwdProfileParamMap = new TreeMap();
	Hashtable selectedParamsSet = new Hashtable();
	JSONObject pwdParamSetList = new JSONObject(); // final selected list json object


	//For SNMP - Start
	String[] versions = {"v1","v2","v3"};
	String[] authTypes = {"MD5","SHA"};
	String[] encryptTypes = {"DES","AES","AES128","AES192","AES256"};
	boolean isSnmp = false;
	boolean isLogFile = false;
	boolean isWarFile = false;
	boolean isSnmpV1V2 = false;
	boolean donotShowParamForSnmpV3 = false;
	boolean isSnmpV3 = false;
	boolean isOldSnmp = false;
	String encryptValue = "";
	String encryptFlag = "";
	String snmpVer = "";
	//String tempSnmpVersion = "";
	//For SNMP - End

	boolean isRemote = false;
	boolean isUrlParamExist = false;
	boolean isPortRelevantForTest = false;
	//boolean isInfoRelevantForTest = false;
	boolean isAggregateTest = false;
	boolean isCompositeTest = false;
	boolean isModeParamExist =false;
	boolean isMeasureModeParamExist =false;
	boolean isMeasurementModeParamExist =false;
	//for tests which is mutiple user enabled
	boolean isTargetWthSysProps = false;
	boolean multiUserMode = false;
	boolean multiNamePatternMode = false;
	boolean multiOidsMode = false;
	boolean isCredentialParamExist = false;
	boolean isWsdlUrlExist=false;
	boolean isPrivateKeyParamExist = false;
	boolean isSystemPropKeyParamExist = false;

	boolean isTestConfigurable = true;//Scenario : The test is disabled.
	boolean isComponentConfigurable = true;//Scenario : The component is either unmanaged or deleted.

	//tell whether _cf test enabled or not
	//boolean isAutoSelected = false;

	//policy filter start
	boolean isPolicyParamExists = false;
	ArrayList aPolicyFilter = new ArrayList();
	String tPolicyFilter = "";
	//policy filter end

	//show_alias_and_interface_name - starts
	boolean hasShowAliasParam = false;
	String useAliasValue = "";
	String strFromReConfig = "";
	//show_alias_and_interface_name - ends

	//ejbtest start
	boolean isEjbGroupingRequired = false;
	String pageNameForEjbGrouping = "";
	//ejbtest end

	//Detailed diagnosis - starts
	boolean detailedDiagnosisOptionEnabled = true;
	boolean allowDetailedDiagnosis = false;
	boolean isTestDetailedDiagnosisDisabledGlobally = false;
	String detailedDiagnosisOn = "";
	String detailedDiagnosisOff = "";
	//Detailed diagnosis - ends

	//contains multiple user enabled test - starts
	List listMultipleUserSupportTest = null;
	//contains multiple user enabled test - starts

	//intimate to user - no enabled tests found for a component type - starts
	boolean isAtleastOneTestEnabled = true;
	//intimate to user - no enabled tests found for a component type - ends

	//set the test period value defaultly to -1
	int minimumTestPeriod = -1;

	//EMC_XtremIO_4x
	String[] emcXMSIPs = null;

	//virtual center
	String[] virtualCenters = null;

	//nutanix server
	String[] nutanixPrisms = null;

	//HMC
	String[] hmcs = null;
	boolean isHMC = false;
	String resIsManagedByValue = "";

	//RHEV
	String[] rhevs = null;

	//Oracle Database
	boolean isOracleDatabaseCompType = false;

	//url parameter(Http or HttpPost Test)
	String previousUrl = null;

	String remoteAgent="";

	ArrayList listOfComponents = new ArrayList();
	ArrayList aUrlCredentialVal = new ArrayList();
	ArrayList aListParamNamesValues = new ArrayList();
	ArrayList aListDisplay = new ArrayList();
	ArrayList aListDescriptorParam=new ArrayList();
	ArrayList aListContentValues = new ArrayList();
	ArrayList aListEncodingValues = new ArrayList();
	ArrayList aListSystemPropKeys = new ArrayList();
	ArrayList aListSystemPropValues = new ArrayList();
	ArrayList aListFilePathValues = new ArrayList();
	//for Targets start
	ArrayList aListTgtSysPropKeys = new ArrayList();
	ArrayList aListTgtSysPropValues = new ArrayList();

	//showAllOnly - starts
	boolean hasShowAllOnlyParam = false;
	String showAllEventsValue = "";
	//showAllOnly - ends

	//Report_only_total - starts
	boolean hasReportOnlyTotalParam = false;
	String reportTotalValue = "";
	//Report_only_total - ends

	TreeMap periodMap = new TreeMap();

	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
	Hashtable internalAgentMap = egExternalInfo.getInternalAgentMap();
	EgAgentInfo agentInfo = new EgAgentInfo("manager");
	//used for getting agent os for internal agent mapping
	AgentConfig agentconfig =  AgentConfig.getAgentConfig();
	EgDiscInfo egDisc = new EgDiscInfo("manager");

	List testSpecsVarList = Arrays.asList(egSpecs.getTestSpecVar());
	
	//String tmpUrl = "listSearch.jsp?title=AGENTS - TESTS - SPECIFIC CONFIGURATION&subtitle=false";
	String fromUnconfigTest = request.getParameter("reqfrom");
	fromUnconfigTest = (fromUnconfigTest == null)?"":fromUnconfigTest;
	rootJson.put("fromUnconfigTest",fromUnconfigTest);

	if (!StringUtils.isNull(componentType) && !componentType.equals("-1"))
	{
		componentsList = ri.getAllServersOfType(componentType);
		listOfComponents = new ArrayList(Arrays.asList(componentsList));

		if (!StringUtils.isNull(showUnconfigCompType) && showUnconfigCompType.equals("true"))
		{
			ArrayList tempUnconfigComponentList = (ArrayList) tmapUnconfigComponents.get(componentType);
			if (tempUnconfigComponentList != null && !tempUnconfigComponentList.isEmpty())
			{
				//listOfComponents.removeAll(tempUnconfigComponentList);
				session.setAttribute("unconfigCompList",tempUnconfigComponentList);
				listOfComponents = new ArrayList(tempUnconfigComponentList);
			}
		}
		else
		{
			session.removeAttribute("unconfigCompList");
		}

		boolean isNeedEditableComboBox = (listOfComponents != null && listOfComponents.size() >= limit);
		if (isNeedEditableComboBox)
		{
			rootJson.put("isNeedEditableComboBox",new Boolean(true));
		}

		if (testType.equalsIgnoreCase("PerformanceTest"))
		{
			aListEnabledTestForCompType = egSpecs.getEnabledTests(componentType,false);
		}
		else
		{
			aListEnabledTestForCompType = egSpecs.getEnabledTests(componentType,true);
		}

		if (aListEnabledTestForCompType.isEmpty())
		{
			isAtleastOneTestEnabled = false;
		}
	}

	boolean viewAccessOnly = false;

	boolean isSystemPropertyParamTests = false; // for system property works

	String validationURL="/final/admin/validateApplicationServerCredentails.jsp";
	String validationService = "/final/admin/validateWebServiceURL.jsp";
	String validationUrlForMDM = "/final/admin/validateMDMURL.jsp";
	String validationUrlForWebservice = "";
	//added by pravat ---start
	if(!isXDMGetDevicesInfo)
	{
		validationUrlForWebservice = validationService;
	}
	else
	{
		validationUrlForWebservice  = validationUrlForMDM;
	}
	//--end

	String paramsForValidationURL="test="+EgURLEncoder.encode(testName,"UTF-8")+"&action=pickAgentToValidate&taskName="+EgURLEncoder.encode(componentType,"UTF-8")+"&compName="+EgURLEncoder.encode(componentName,"UTF-8")+"&componentType="+componentType+"&configurationType=specificConfiguration"+"&allowHostName="+isAllowHostName;
	String validationTitle=_mapping.getTextDescription("admin.common.Validating monitoring settings for")+" ";
	String requiredParamNames="";
	if (componentType != null && !componentType.equals("") && componentName != null && !componentName.equals("-1") && !componentName.equals(""))
	{
		egTestParamIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_testparam.ini");
		requiredParamNames = getRequiredParamNames(componentType,testName,egTestParamIni);

		paramForDisplayingValidateButton=egTestParamIni.getValue("VALIDATION_BUTTON_LOCATION",testName);
		if(paramForDisplayingValidateButton!=null && (paramForDisplayingValidateButton.equals("") || paramForDisplayingValidateButton.equalsIgnoreCase("null")))
		{
			paramForDisplayingValidateButton=egTestParamIni.getValue("VALIDATION_BUTTON_LOCATION",componentType+":Default");
		}
		rootJson.put("paramForDisplayingValidateButton",paramForDisplayingValidateButton);
		boolean hasPasswordParameters = false;
		String[] passwordTests = egTestParamIni.getVariables("PASSWORD");
		List listPasswordTests = Arrays.asList(passwordTests);
		for (int i=0;i<aListEnabledTestForCompType.size();i++)
		{
			String strTest = (String)aListEnabledTestForCompType.get(i);
			if (listPasswordTests.contains(strTest))
			{
				String strPasswordParams = egTestParamIni.getValue("PASSWORD",strTest);
				StringTokenizer stPasswordParams = new StringTokenizer(strPasswordParams,",");
				while (stPasswordParams.hasMoreTokens())
				{
					String tempParam = stPasswordParams.nextToken();
					tempParam = "-" + tempParam;
					if (aListPasswordParameters == null)
					{
						aListPasswordParameters = new ArrayList();
						hasPasswordParameters = true;
					}

					if (aListPasswordParameters.contains(tempParam)) continue;
					aListPasswordParameters.add(tempParam);
				}
			}
		}
		rootJson.put("hasPasswordParameters",hasPasswordParameters);

		allowedParams = egTestParamIni.getValue("SPECIAL_CHARACTERS","Parameters");
		tcKeywords=egTestParamIni.getVariables("TEST_CONFIGURATION_PARAM_VALUE_KEYWORDS");
		tcKeywordswoSplChar = tcKeywords;
		String searchString = "(EG_RUNTIME)";
		if (ArrayUtils.contains(tcKeywordswoSplChar, searchString)) {
			for(int p=0;p<tcKeywordswoSplChar.length;p++){
				if(tcKeywordswoSplChar[p].contains("(EG_RUNTIME)"))
					tcKeywordswoSplChar[p] = StringUtils.replace(tcKeywordswoSplChar[p],"(EG_RUNTIME)","|lbr|EG_RUNTIME|rbr|");
			}
		}
		List listTcKeywords = Arrays.asList(tcKeywords);
		List listTcKeywordswsplChr = Arrays.asList(tcKeywordswoSplChar);
		strTcKeywords = listTcKeywordswsplChr.toString();
		strTcKeywords = strTcKeywords.substring(1,strTcKeywords.length()-1);
		strTcKeywords = StringUtils.replace(strTcKeywords,", ",",");
		for (int i=0;i<listTcKeywords.size();i++)
		{
			String strKeyword = (String)listTcKeywords.get(i);
			strKeyword = strKeyword.trim();
			strKeyword = strKeyword.toLowerCase();
			aListTcKeywordsLowerCase.add(strKeyword);
		}

		String[] defaultControl = egTestParamIni.getVariables("PARAM-CONTROL");
		if (defaultControl != null && defaultControl.length > 0)
		{
			for (int i=0;i<defaultControl.length;i++)
			{
				String tempParamName = defaultControl[i];
				String tempParamValue = egTestParamIni.getValue("PARAM-CONTROL",tempParamName);
				if (tempParamValue.equalsIgnoreCase("password"))
				{
					if (aListDefaultPasswordParameters == null)
					{
						aListDefaultPasswordParameters = new ArrayList();
					}

					aListDefaultPasswordParameters.add("-"+tempParamName.toLowerCase());
				}
			}
		}

		//String[] paramsWithDoubleQuotes = egTestParamIni.getVariables("ENCLOSE_WITH_DOUBLEQUOTES");
		String[] paramsWithDoubleQuotes = null;
		if (paramsWithDoubleQuotes != null && paramsWithDoubleQuotes.length > 0)
		{
			for (int i=0;i<paramsWithDoubleQuotes.length;i++)
			{
				String tempParamName = paramsWithDoubleQuotes[i];
				if (aListParamsWithDoubleQuotes == null)
				{
					aListParamsWithDoubleQuotes = new ArrayList();
				}
				aListParamsWithDoubleQuotes.add(tempParamName.toLowerCase());
			}

			strDoubleQuotesParams = aListParamsWithDoubleQuotes.toString();
			strDoubleQuotesParams = strDoubleQuotesParams.substring(1,strDoubleQuotesParams.length()-1);
			strDoubleQuotesParams = StringUtils.replace(strDoubleQuotesParams,", ",",");
		}

		isOracleDatabaseCompType = componentType.equals("Oracle_server");
		listAgents = getAgents(componentName);
		ht_AgentsList = getAgentsList(componentType,componentName);
		componentNickName = componentName.substring(0,componentName.indexOf(":"));
		isRemote = egExternalInfo.isRemoteBased(componentNickName);
		rootJson.put("isRemote",isRemote);
		if (!listOfComponents.contains(componentType+":"+componentName))
		{
			isComponentConfigurable = false;
		}
		
		if ((listOfComponents.size() == 1 && listOfComponents.contains(componentType + ":" + componentName)) || (listOfComponents.size() > componentsAllowedLimit))
		{
			rootJson.put("hasMoreComponents",false);
		}
		else
		{
			rootJson.put("hasMoreComponents",true);
		}

		rootJson.put("isComponentConfigurable",isComponentConfigurable);
		//Scenario : The component is either unmanaged or deleted
		if (!isComponentConfigurable)
		{
			rootJson.put("componentDisableMsg",_mapping.getTextDescription("admin.test.This component is currently not available for configuration")+". "+_mapping.getTextDescription("admin.test.Please wait for the system configurations to be updated and try again after a few minutes")+".");
			Vector sess_vec = new Vector();
			sess_vec.addElement(_mapping.getTextDescription("admin.test.Configure Test"));
			sess_vec.addElement("EgConfigureComponentTests.jsp?&server="+componentType);
			sess_vec.addElement("Component not configurable");
			sess_vec.addElement(_mapping.getTextDescription("admin.test.This component is currently not available for configuration")+". ");
			sess_vec.addElement(_mapping.getTextDescription("admin.test.Please wait for the system configurations to be updated and try again after a few minutes")+".");
			session.setAttribute("vec_Errors",sess_vec);

			//forward error page checking is needed
		}

		//To fetch excluded tests - Start
		prgBean.createFile("eg_disable.ini");

		String excludedTestForComp = prgBean.getStrValue(componentType,componentType+":"+componentName);
		if (excludedTestForComp != null && !excludedTestForComp.equals(""))
		{
			StringTokenizer excludedTestTokens = new StringTokenizer(excludedTestForComp,",");
			while (excludedTestTokens.hasMoreElements())
			{
				String excludeTestComp = (String)excludedTestTokens.nextElement();
				boolean isCompHost = aListEnabledTestForCompType.contains(excludeTestComp);
				if (isCompHost)
				{
					if (excludedTestList != null && !excludedTestList.contains(excludeTestComp))
					{
						excludedTestList.add(excludeTestComp);
					}
				}
			}
		}

		String excludedTestForHost = prgBean.getStrValue("Default_server","Default_server"+":"+componentNickName);
		if (excludedTestForHost != null && !excludedTestForHost.equals(""))
		{
			StringTokenizer excludedTestTokens = new StringTokenizer(excludedTestForHost,",");
			while (excludedTestTokens.hasMoreElements())
			{
				String excludeTest = (String)excludedTestTokens.nextElement();
				boolean isComptypeTest = aListEnabledTestForCompType.contains(excludeTest);
				if (isComptypeTest)
				{
					if (excludedTestList != null && !excludedTestList.contains(excludeTest))
					{
						excludedTestList.add(excludeTest);
					}
				}
			}
		}

		JSONObject excludeTestForAllCompObj = new JSONObject();
		excludeTestForAllCompObj = getExcludeTestForAllComponents(componentType,listOfComponents,aListEnabledTestForCompType,prgBean);
		if (excludeTestForAllCompObj != null && !excludeTestForAllCompObj.isEmpty())
		{
			rootJson.put("excludeTestForAllCompObj",excludeTestForAllCompObj);
		}
		
		JSONObject includeTestForAllCompObj = new JSONObject();
		includeTestForAllCompObj = getIncludeTestForAllComponents(componentType,listOfComponents,excludedTestList,prgBean);
		rootJson.put("includeTestForAllCompObj",includeTestForAllCompObj);
		// new task ends...

		//To fetch excluded tests - End
		rootJson.put("excludedTestList",excludedTestList);
		//Will contain only running tests after the removeAll operation
		aListEnabledTestForCompType.removeAll(excludedTestList);
		prgBean.createFile("eg_agents.ini");

		ArrayList unconfiguredConfTestList = new ArrayList();
		ArrayList defaultconfiguredConfTestList = new ArrayList();
		ArrayList userconfiguredConfTestList = new ArrayList();
		if (isConfigSupported)
		{
			ArrayList aListEnabledConfTestForCompType = null;
			if (!componentType.equals("") && !componentType.equals("-1"))
			{
				if (testType.equals("PerformanceTest"))
				{
					aListEnabledConfTestForCompType = egSpecs.getEnabledTests(componentType,true);
					for (int i=0;i<aListEnabledConfTestForCompType.size();i++)
					{
						String strEnabledConfTest = (String)aListEnabledConfTestForCompType.get(i);
						String tempConfAgentName = getAgentNickName(componentType,strEnabledConfTest,listAgents);
						
						if (tempConfAgentName == null) continue;

						String[] testConfVariables = prgBean.getVariables(tempConfAgentName);
						String resultantConfPattern = getResultantPattern(componentType,componentName,strEnabledConfTest,testConfVariables);
						if (resultantConfPattern == null) continue;

						String tempConfTestValue = prgBean.getStrValue(tempConfAgentName,resultantConfPattern);
						String tempTestConfConfigurationStatus = tempConfTestValue.substring(0,tempConfTestValue.indexOf(","));
						tempTestConfConfigurationStatus = tempTestConfConfigurationStatus.trim();

						if (tempTestConfConfigurationStatus.equalsIgnoreCase("-auto"))
						{
							if (tempConfTestValue.indexOf(" $") > -1 && hasUnConfiguredParam(tempConfTestValue,hasPasswordParameters,aListPasswordParameters,aListTcKeywordsLowerCase,aListDefaultPasswordParameters))
							{
								unconfiguredConfTestList.add(strEnabledConfTest);
							}
							else
							{
								defaultconfiguredConfTestList.add(strEnabledConfTest);
							}
						}
						else
						{
							userconfiguredConfTestList.add(strEnabledConfTest);
						}
					}
				}
			}
		}
		if(defaultconfiguredConfTestList != null && defaultconfiguredConfTestList.size() > 0)
		{
			enableConfTestSize = defaultconfiguredConfTestList.size();
		}
		rootJson.put("enableConfTestSize",enableConfTestSize);
		for (int i=0;i<aListEnabledTestForCompType.size();i++)
		{
			String strEnabledTest = (String)aListEnabledTestForCompType.get(i);
			String tempAgentName = getAgentNickName(componentType,strEnabledTest,listAgents);
			if (tempAgentName == null) continue;

			String[] testVariables = prgBean.getVariables(tempAgentName);
			String resultantPattern = getResultantPattern(componentType,componentName,strEnabledTest,testVariables);

			if (resultantPattern == null) continue;

			String tempTestValue = prgBean.getStrValue(tempAgentName,resultantPattern);
			String tempTestConfigurationStatus = tempTestValue.substring(0,tempTestValue.indexOf(","));
			tempTestConfigurationStatus = tempTestConfigurationStatus.trim();
			if (tempTestConfigurationStatus.equalsIgnoreCase("-auto"))
			{
				if (tempTestValue.indexOf(" $") > -1 && hasUnConfiguredParam(tempTestValue,hasPasswordParameters,aListPasswordParameters,aListTcKeywordsLowerCase,aListDefaultPasswordParameters))
				{
					unconfiguredTestList.add(strEnabledTest);
				}
				else
				{
					defaultconfiguredTestList.add(strEnabledTest);
				}
			}
			else
			{
				userconfiguredTestList.add(strEnabledTest);
			}
		}

		unconfiguredTestList = sorter.getSortedTestList(unconfiguredTestList);
		defaultconfiguredTestList = sorter.getSortedTestList(defaultconfiguredTestList);
		userconfiguredTestList = sorter.getSortedTestList(userconfiguredTestList);
		excludedTestList = sorter.getSortedTestList(excludedTestList);

		ArrayList aListDesktopInfrastructures = usersInfo.getAllUserBasedCompTypes();
		if (userBasedLicense && aListDesktopInfrastructures != null && aListDesktopInfrastructures.contains(componentType))
		{
			viewAccessOnly = true;
		}
		rootJson.put("viewAccessOnly",viewAccessOnly);
		if (testName != null && !testName.equals(""))
		{
			isPortRelevantForTest = egSpecs.isPortRelevantForTest(testName);
			prgBean.createFile("eg_agents.ini");
			//fetch the exact agent
			String tempAgentName = getAgentNickName(componentType,testName,listAgents);
			tempAgentName = tempAgentName!=null?tempAgentName:"";
			String[] testVariables = prgBean.getVariables(tempAgentName);
			rootJson.put("tempAgentName",tempAgentName);
			rootJson.put("isPortRelevantForTest",isPortRelevantForTest);
			String resultantPattern = getResultantPattern(componentType,componentName,testName,testVariables);
			resultantPattern = resultantPattern!=null?resultantPattern:"";
			rootJson.put("resultantPattern",resultantPattern);

			String tempTestValue = prgBean.getStrValue(tempAgentName,resultantPattern);

			if (!StringUtils.isNull(tempTestValue) && tempTestValue.indexOf(",") != -1)
			{
				String tempTestConfiguration = tempTestValue.substring(0,tempTestValue.indexOf(","));
				tempTestConfiguration = tempTestConfiguration.trim();
				if (tempTestConfiguration.equalsIgnoreCase("-auto"))
				{
					isAutoConfiguration = true;
				}

				rootJson.put("resultantPatternValue",tempTestValue);
				rootJson.put("isAutoConfiguration",isAutoConfiguration);

				_mappingInfo = _mapping;
				prMeasureObject.clear();
				prMeasureArray.clear();
				prMeasureDispnameArray.clear();
	
				aResultant = getTestValuesWithControl(tempTestValue,testName,egTestParamIni);
				if(prMeasureObject.size()>0)
				{
					rootJson.put("prMeasureObject",prMeasureObject);
					rootJson.put("prMeasureArray",prMeasureArray);
					rootJson.put("prMeasureDispnameArray",prMeasureDispnameArray);
				}
				testperiod = tempTestValue.substring(tempTestValue.lastIndexOf(EgConstants.COMMA)+1).trim();
				auditLogHt.put("testPeriod",testperiod);
			}


			int wsdlIdx = aResultant.indexOf("-WSDL_URL");
			String wsdlCase = null;
			if (wsdlIdx != -1)
			{
				wsdlCase = (String)aResultant.get(wsdlIdx+1);
			}
			rootJson.put("wsdlCase",wsdlCase);

			int operaIdx = aResultant.indexOf("-Operations");
			String operations = null;
			if (operaIdx != -1)
			{
				operations = (String)aResultant.get(operaIdx+1);
			}
			rootJson.put("operations",operations);

			int credenIdx = aResultant.indexOf("-credentials");
			String credentials = null;
			if (credenIdx != -1)
			{
				credentials = (String)aResultant.get(credenIdx+1);
			}
			rootJson.put("credentials",credentials);


			rootJson.put("aResultant",aResultant);
			rootJson.put("testperiod",testperiod);
			if (aResultant.isEmpty())
			{
				isTestConfigurable = false;
			}
			rootJson.put("isTestConfigurable",isTestConfigurable);

			//Scenario : The test is disabled.
			if (!isTestConfigurable)
			{
				rootJson.put("TestDisabledMsg",_mapping.getTextDescription("admin.test.This test is currently not available for configuration")+". "+_mapping.getTextDescription("admin.test.Please wait for the system configurations to be updated and try again after a few minutes")+".");
				Vector sess_vec = new Vector();
				sess_vec.addElement(_mapping.getTextDescription("admin.test.Configure Test"));
				sess_vec.addElement("EgConfigureComponentTests.jsp?&server="+componentType);
				sess_vec.addElement("Test not configurable");
				sess_vec.addElement(_mapping.getTextDescription("admin.test.This test is currently not available for configuration")+". ");
				sess_vec.addElement(_mapping.getTextDescription("admin.test.Please wait for the system configurations to be updated and try again after a few minutes")+".");
				session.setAttribute("vec_Errors",sess_vec);

				//forward error page checking is needed here
			}

			// filter test period for BTM test starts here...
			boolean hasFilterTestPeriod = false;
			ArrayList filterTestPeriodList = new ArrayList();
			String[] testPeriodTestVars = egMgrMiscIni.getVariables("Test_Period_Filter");
			String startTimePeriod = "";
			ArrayList testPeriodFinalList = new ArrayList();
			if (testPeriodTestVars != null && testPeriodTestVars.length > 0)
			{
				ArrayList testPeriodFilterTests = new ArrayList(Arrays.asList(testPeriodTestVars));
				if (testPeriodFilterTests != null && testPeriodFilterTests.contains(testName))
				{
					startTimePeriod = egMgrMiscIni.getValue("Test_Period_Filter",testName);

					if (!StringUtils.isNull(startTimePeriod) && defaultTestPeriods != null && defaultTestPeriods.size() > 0 && defaultTestPeriods.contains(startTimePeriod))
					{
						hasFilterTestPeriod = true;
						for (int t=0;t<defaultTestPeriods.size();t++)
						{
							String strTestPeriod = (String) defaultTestPeriods.get(t);
							if (startTimePeriod != null && startTimePeriod.equals(strTestPeriod))
							{
								break;
							}
							filterTestPeriodList.add(strTestPeriod);
						}
					}
				}
			}
			// filter test period for BTM test ends here...

			IniFile uiIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
			String[] testFormatPeriod = uiIni.getVariables("TEST_FREQUENCY");
			if (!EgUtils.isNull((Object)testFormatPeriod))
			{
				for (int i=0;i<testFormatPeriod.length;i++)
				{
					String prdStr = uiIni.getValue("TEST_FREQUENCY",testFormatPeriod[i]);
					if (hasFilterTestPeriod && filterTestPeriodList != null && filterTestPeriodList.contains(prdStr))
					{
						continue;
					}
					testPeriodFinalList.add(prdStr);
					long lngVal = Long.parseLong(prdStr);
					periodMap.put(new Long(lngVal),testFormatPeriod[i]);
				}
				if (testPeriodFinalList != null && !testPeriodFinalList.contains(testperiod))
				{
					testperiod = startTimePeriod;
				}
			}

			hostEditableMode = uiIni.getValue("TEST_CONFIG_CONTROLS","hostEditable");
			portEditableMode = uiIni.getValue("TEST_CONFIG_CONTROLS","portEditable");

			//snmp work starts here
			for (int i=0;i<aResultant.size();i++)
			{
				String strResult = aResultant.get(i).toString();
				aListResultantTempInLowerCase.add(strResult.toLowerCase());
			}

			ArrayList pwdProfileList = pwdProf.getPwdProfiles();
			if (pwdProfileList != null && pwdProfileList.size() > 0)
			{
				ArrayList specificParamSets = pwdProf.getSpecificParamSets(componentType);
				if (specificParamSets != null && specificParamSets.size() > 0)
				{
					int paramSize = specificParamSets.size();
					for (int p=0;p<paramSize;p++)
					{
						String pwdProfileParams = (String) specificParamSets.get(p);
						StringTokenizer st = new StringTokenizer(pwdProfileParams,",");
						int totalPwdParams = st.countTokens();
						int paramCnt = 0;
						while(st.hasMoreTokens())
						{
							String token = (String) st.nextToken();
							int tokenIdx = aResultant.indexOf("-"+token);
							if (tokenIdx != -1)
							{
								paramCnt++;
							}
						}

						if (paramCnt == totalPwdParams)
						{
							if (testName.equals("EsxGPUStatsTest") && pwdProfileParams.indexOf("console_user") != -1)
							{
								continue;
							}

							isEnablePwdProfile = true;

							if (!com.egurkha.util.StringUtils.isNull(pwdProfileParams))
							{
								ArrayList tmpList = com.egurkha.util.StringUtils.egTokenizer(pwdProfileParams,",");
								tmpList = arrangeKeyAgentIniOrder(tmpList,aListResultantTempInLowerCase);
								pwdProfileParams = com.egurkha.util.StringUtils.getString(tmpList);
							}

							String startParamPosition = pwdProfileParams.substring(0,pwdProfileParams.indexOf(","));
							selectedParamsSet.put(startParamPosition,pwdProfileParams);
						}
					}
				}
			}

			// for system property params works - starts...
			IniFile testsIniObj = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_tests.ini");
			String systemPropTest = testsIniObj.getValue("SYSTEM_PROPERTY_PARAM_TESTS",testName);
			if (!StringUtils.isNull(systemPropTest) && systemPropTest.equalsIgnoreCase("true"))
			{
				isSystemPropertyParamTests = true;
			}
			rootJson.put("isSystemPropertyParamTests",isSystemPropertyParamTests);
			// for system property params works - ends...

			rootJson.put("isEnablePwdProfile",isEnablePwdProfile);
			if (isEnablePwdProfile)
			{
				JSONArray pwdProfileArr = new JSONArray();
				JSONObject pwdProfileObj = new JSONObject();
				if (pwdProfileList.size() > 0)
				{
					pwdProfileObj.put("valueField","none");
					pwdProfileObj.put("displayField",_mapping.getTextDescription("admin.common.Choose a password profile"));
					pwdProfileArr.add(pwdProfileObj);
				}
				else
				{
					pwdProfileObj.put("valueField","none");
					pwdProfileObj.put("displayField",_mapping.getTextDescription("admin.common.Not Applicable"));
					pwdProfileArr.add(pwdProfileObj);
				}

				JSONObject pwdProfileIniVal = new JSONObject();
				Collections.sort(pwdProfileList,String.CASE_INSENSITIVE_ORDER);
				for (int p=0; p<pwdProfileList.size(); p++)
				{
					String actualname = (String) pwdProfileList.get(p);
					String profileValue = pwdProfileIni.getValue("Password_Profiles",actualname);
					if (!com.egurkha.util.StringUtils.isNull(profileValue)) 
					{
						String profUserName = null;
						String profPwd = null;
						String profDomName = null;


						if ( profileValue.indexOf("|") != -1)
						{
							ArrayList multiEntryProfile = StringUtils.egTokenizer(profileValue,"|");
							int tokens = multiEntryProfile.size();
							if (multiEntryProfile != null && multiEntryProfile.size() > 0)
							{
								ArrayList tmpProfValList = new ArrayList();
								for (int m=0;m<multiEntryProfile.size();m++)
								{
									String strValue = (String) multiEntryProfile.get(m);
									if (com.egurkha.util.StringUtils.isNull(strValue))
									{
										continue;
									}

									ArrayList profileDatas = StringUtils.egTokenizer(strValue,"~Hash~");
									int toknsSize = profileDatas.size();
									if (!StringUtils.isNull(profUserName))
									{
										profUserName = profUserName +","+ profileDatas.get(0).toString();
									}
									else
									{
										profUserName = profileDatas.get(0).toString();
									}
									String password = "none";
									String domainName = "none";
									
									if (toknsSize > 1)
									{
										password = EgCrypt.decrypt(profileDatas.get(1).toString());
										if (!aListTcKeywordsLowerCase.contains(password.toLowerCase()))
										{
											password += "~EG~"; 
											password = EgCrypt.encrypt(password); 
										}
									}

									if (!StringUtils.isNull(profPwd))
									{
										profPwd = profPwd +"#~#"+ password;
									}
									else
									{
										profPwd = password;
									}

									if (toknsSize > 2)
									{
										domainName = profileDatas.get(2).toString();
									}

									if (!StringUtils.isNull(profDomName))
									{
										profDomName = profDomName +","+ domainName;
									}
									else
									{
										profDomName = domainName;
									}
								}
								profileValue = profUserName+"~Hash~"+profPwd+"~Hash~"+profDomName;
							}
						}
						else
						{
							ArrayList profileEntry = StringUtils.egTokenizer(profileValue,"~Hash~");
							int toknsSize = profileEntry.size();
							profUserName = profileEntry.get(0).toString();
							profPwd = "none";
							profDomName = "none";
							// A profile may not have all 3(user name, pwd, domain) values
							if (toknsSize > 1)
							{
								profPwd = EgCrypt.decrypt(profileEntry.get(1).toString());
								if (!aListTcKeywordsLowerCase.contains(profPwd.toLowerCase()))
								{
									profPwd += "~EG~"; 
									profPwd = EgCrypt.encrypt(profPwd); 
								}
							}
							if (toknsSize > 2)
							{
								profDomName = profileEntry.get(2).toString();
							}

							profileValue = profUserName+"~Hash~"+profPwd+"~Hash~"+profDomName;
						}

						pwdProfileIniVal.put(actualname,profileValue);
					}
					pwdProfileObj.put("valueField",actualname);
					pwdProfileObj.put("displayField",actualname);
					pwdProfileArr.add(pwdProfileObj);
				}

				rootJson.put("pwdProfileArr",pwdProfileArr);
				rootJson.put("pwdProfileIniVal",pwdProfileIniVal);
				if (selectedParamsSet != null)
				{
					Set paramSetKeysSet = selectedParamsSet.keySet();
					ArrayList paramSetKeys = new ArrayList();
					paramSetKeys.addAll(paramSetKeysSet);

					if (paramSetKeys != null && paramSetKeys.size() > 1)
					{
						paramSetKeys = arrangeKeyAgentIniOrder(paramSetKeys,aListResultantTempInLowerCase);
					}

					ArrayList updatedParamList = new ArrayList(aListResultantTempInLowerCase);
					ArrayList strHiddenProfileList = getHiddenPwdProfile(updatedParamList);
					String strHiddenProfileParam = "";
					String strHiddenProfile = "";
					JSONArray pwdProfileSelectedList = new JSONArray();
					JSONArray pwdProfileAllList = new JSONArray();
					JSONObject pwdProfileProperties = new JSONObject();

					if (paramSetKeys.size() == 1)
					{
						if (strHiddenProfileList != null && strHiddenProfileList.size() > 0)
						{
							strHiddenProfileParam = strHiddenProfileList.get(0).toString();
							strHiddenProfile = strHiddenProfileList.get(1).toString();
						}
						String strFirstParamOfSet = paramSetKeys.get(0).toString();
						String strSelectedParamSet = (String) selectedParamsSet.get(strFirstParamOfSet);
						int pwdProfBeforeParamIdx = updatedParamList.indexOf("-"+strFirstParamOfSet.toLowerCase());
						String findPosition = null;
						if (pwdProfBeforeParamIdx != -1)
						{
							findPosition = (String)aResultant.get(pwdProfBeforeParamIdx);
						}

						String mergeString = componentType+":"+componentName+"#^#"+strSelectedParamSet;
						String defaultMergeStr = componentType+"#^#"+strSelectedParamSet;
						if (findPosition != null)
						{
							String strPwdProfKey = "-password_profile"+0;
							int tempPositionIdx = aResultant.indexOf(findPosition);
							aResultant.add(tempPositionIdx,strPwdProfKey);
							aResultant.add(tempPositionIdx+1,"none");
							aResultant.add(tempPositionIdx+2,"select");

							pwdParamSetList.put(strPwdProfKey.substring(1),strSelectedParamSet);
							String strGetProfValue = pwdProf.getProfNameForSpecificConfiguration(mergeString,testName);
							if (StringUtils.isNull(strGetProfValue))
							{
								strGetProfValue = pwdProf.getProfNameForDefaultConfiguration(defaultMergeStr,testName);

								if (StringUtils.isNull(strGetProfValue)) //for default(::common tests) profile check 
								{
									defaultMergeStr = testName+"#^#"+strSelectedParamSet;
									strGetProfValue = pwdProf.getProfNameForDefaultConfiguration(defaultMergeStr);
								}
							}

							ArrayList pwdProfileParamSetList = StringUtils.egTokenizer(strSelectedParamSet,",");
							rootJson.put("password_profile"+0+"_totalPwdParams",pwdProfileParamSetList.size());
							if(!StringUtils.isNull(strGetProfValue) && !strGetProfValue.equals("none"))
							{
								ArrayList selectProfList = pwdProf.getProfileMultiValues(strGetProfValue);
								if (selectProfList != null && selectProfList.size() > 0)
								{
									for(int s=0;s< pwdProfileParamSetList.size();s++)
									{
										String profileUsingParamName = pwdProfileParamSetList.get(s).toString();
										String profileUsingParamValue = "";
										if (!StringUtils.isNull(profileUsingParamName))
										{
											if(checkParamIsUserField(profileUsingParamName))
											{
												profileUsingParamValue = selectProfList.get(0).toString();
											}
											else if(checkParamIsPasswordField(profileUsingParamName))
											{
												profileUsingParamValue = selectProfList.get(1).toString();
											}
											else if(checkParamIsDomainField(profileUsingParamName))
											{
												profileUsingParamValue = selectProfList.get(2).toString();
											}
										}

										if (!StringUtils.isNull(profileUsingParamName))
										{
											pwdProfileParamMap.put(profileUsingParamName,profileUsingParamValue);
										}
									}
								}
							}

							if (!StringUtils.isNull(strHiddenProfile))
							{
								if (strHiddenProfile.equals(strFirstParamOfSet))
								{
									pwdProfileSelectedList.add(strPwdProfKey.substring(1));
									pwdProfileProperties.put(strPwdProfKey.substring(1)+"_isShow",true);
								}
								else
								{
									pwdProfileAllList.add(strPwdProfKey.substring(1));
									pwdProfileProperties.put(strPwdProfKey.substring(1)+"_isShow",false);
								}
							}
							
							JSONArray paramsArray = new JSONArray();
							for(int a=0;a< pwdProfileParamSetList.size();a++)
							{
								String strParams = (String) pwdProfileParamSetList.get(a);
								JSONObject paramsObj = new JSONObject();
								paramsObj.put("profileParams"+a,strParams);
								paramsArray.add(paramsObj);
							}
							rootJson.put("password_profile"+0+"_paramsArray",paramsArray);
							updatedParamList = getUpdatedResultantListInLowercase(aResultant);
						}
					}
					else
					{
						if (strHiddenProfileList != null && strHiddenProfileList.size() > 0)
						{
							strHiddenProfileParam = strHiddenProfileList.get(0).toString();
							strHiddenProfile = strHiddenProfileList.get(1).toString();
						}

						for (int key=0;key<paramSetKeys.size();key++)
						{
							String strFirstParamOfSet = paramSetKeys.get(key).toString();
							String strSelectedParamSet = (String) selectedParamsSet.get(strFirstParamOfSet);
							int pwdProfBeforeParamIdx = updatedParamList.indexOf("-"+strFirstParamOfSet.toLowerCase());
							String findPosition = null;
							if (pwdProfBeforeParamIdx != -1)
							{
								findPosition = (String)aResultant.get(pwdProfBeforeParamIdx);
							}

							String mergeString = componentType+":"+componentName+"#^#"+strSelectedParamSet;
							String defaultMergeStr = componentType+"#^#"+strSelectedParamSet;
							if (findPosition != null)
							{
								String strPwdProfKey = "-password_profile"+key;
								int tempPositionIdx = aResultant.indexOf(findPosition);
								aResultant.add(tempPositionIdx,strPwdProfKey);
								aResultant.add(tempPositionIdx+1,"none");
								aResultant.add(tempPositionIdx+2,"select");

								pwdParamSetList.put(strPwdProfKey.substring(1),strSelectedParamSet);
								String strGetProfValue = pwdProf.getProfNameForSpecificConfiguration(mergeString,testName);
								if (StringUtils.isNull(strGetProfValue))
								{
									strGetProfValue = pwdProf.getProfNameForDefaultConfiguration(defaultMergeStr,testName);
									if (StringUtils.isNull(strGetProfValue))
									{
										defaultMergeStr = testName+"#^#"+strSelectedParamSet;
										strGetProfValue = pwdProf.getProfNameForDefaultConfiguration(defaultMergeStr);
									}
								}

								if (!StringUtils.isNull(strHiddenProfile))
								{
									if (strHiddenProfile.equals(strFirstParamOfSet))
									{
										pwdProfileSelectedList.add(strPwdProfKey.substring(1));
										pwdProfileProperties.put(strPwdProfKey.substring(1)+"_isShow",true);
									}
									else
									{
										pwdProfileAllList.add(strPwdProfKey.substring(1));
										pwdProfileProperties.put(strPwdProfKey.substring(1)+"_isShow",false);
									}
								}

								ArrayList pwdProfileParamSetList = StringUtils.egTokenizer(strSelectedParamSet,",");
								rootJson.put("password_profile"+key+"_totalPwdParams",pwdProfileParamSetList.size());
								if(!StringUtils.isNull(strGetProfValue) && !strGetProfValue.equals("none"))
								{
									ArrayList selectProfList = pwdProf.getProfileMultiValues(strGetProfValue);
									if (selectProfList != null && selectProfList.size() > 0)
									{
										for(int s=0;s< pwdProfileParamSetList.size();s++)
										{
											String profileUsingParamName = pwdProfileParamSetList.get(s).toString();
											String profileUsingParamValue = "";
											if (!StringUtils.isNull(profileUsingParamName))
											{
												if(checkParamIsUserField(profileUsingParamName))
												{
													profileUsingParamValue = selectProfList.get(0).toString();
												}
												else if(checkParamIsPasswordField(profileUsingParamName))
												{
													profileUsingParamValue = selectProfList.get(1).toString();
												}
												else if(checkParamIsDomainField(profileUsingParamName))
												{
													profileUsingParamValue = selectProfList.get(2).toString();
												}
											}

											if (!StringUtils.isNull(profileUsingParamValue))
											{
												pwdProfileParamMap.put(profileUsingParamName,profileUsingParamValue);
											}
										}
									}
								}

								JSONArray paramsArray = new JSONArray();
								for(int a=0;a< pwdProfileParamSetList.size();a++)
								{
									String strParams = (String) pwdProfileParamSetList.get(a);
									JSONObject paramsObj = new JSONObject();
									paramsObj.put("profileParams"+a,strParams);
									paramsArray.add(paramsObj);
								}
								rootJson.put("password_profile"+key+"_paramsArray",paramsArray);
								updatedParamList = getUpdatedResultantListInLowercase(aResultant);
							}
						}
					}

					if (!StringUtils.isNull(strHiddenProfileParam))
					{
						if (strHiddenProfileParam.endsWith("true"))
						{
							rootJson.put("showPwdParams",pwdProfileSelectedList);
							rootJson.put("hidePwdParams",pwdProfileAllList);
						}
						else
						{
							rootJson.put("showPwdParams",pwdProfileAllList);
							rootJson.put("hidePwdParams",pwdProfileSelectedList);
						}

					}
					rootJson.put("pwdProfileProperties",pwdProfileProperties);
					rootJson.put("pwdParamSetList",pwdParamSetList);
					session.setAttribute("pwdParamSetList",pwdParamSetList);
					aListResultantTempInLowerCase = new ArrayList(updatedParamList);

				}
			}

			if (aListResultantTempInLowerCase.contains("-usealias") && 
				aListResultantTempInLowerCase.contains("-show_alias_and_interface_name"))
			{
				hasShowAliasParam = true;
				int useAliasIdx = aListResultantTempInLowerCase.indexOf("-usealias");
				strFromReConfig = request.getParameter("fromReConfigure");
				rootJson.put("fromReConfigure",strFromReConfig);
				String useAliasCase = (String)aResultant.get(useAliasIdx);
				useAliasCase = useAliasCase.substring(1);
				if (StringUtils.isNull(strFromReConfig))
				{
					useAliasValue = request.getParameter(useAliasCase);
				}
				if (useAliasValue == null || useAliasValue.length() == 0)
				{
					useAliasValue = (String)aResultant.get(useAliasIdx+1);
				}
				rootJson.put("useAliasValue",useAliasValue);
			}
			rootJson.put("hasShowAliasParam",hasShowAliasParam);
			isSnmp = aListResultantTempInLowerCase.contains("-snmpport");
			rootJson.put("isSnmp",isSnmp);

			boolean isSNMPValidation = false;
			if (isSnmp && (testName!=null && !testName.equalsIgnoreCase("networktraptest")))
			{
				isSNMPValidation=true;

				//getAgentsForSNMPUtility(egServer);
				rootJson.put("agentsListForSNMPUtil",getAgentsForSNMPUtility(egSpecs));
			}
			rootJson.put("isSNMPValidation",isSNMPValidation);

			isLogFile = (aListResultantTempInLowerCase.contains("-jrehome") && 
				aListResultantTempInLowerCase.contains("-logfilename"));
			rootJson.put("isLogFile",isLogFile);
			isWarFile = (aListResultantTempInLowerCase.contains("-ssl") && 
				aListResultantTempInLowerCase.contains("-url"));
			rootJson.put("isWarFile",isWarFile);

			if(isSnmp)
			{
				if (aListResultantTempInLowerCase.contains("-mode"))
				{
					if(aListResultantTempInLowerCase.contains("-jmx_remote_port") || aListResultantTempInLowerCase.contains("-service_url_path"))
					{
						isModeParamExist = true;
					}
				}
				 
			}
			rootJson.put("isModeParamExist",isModeParamExist);
			if(isLogFile)
			{
				if (aListResultantTempInLowerCase.contains("-measure_mode"))
				{
					if(aListResultantTempInLowerCase.contains("-jmx_remote_port") || aListResultantTempInLowerCase.contains("-service_url_path"))
					{
						isMeasureModeParamExist = true;
					}
				}
				 
			}
			rootJson.put("isMeasureModeParamExist",isMeasureModeParamExist);
			isMeasurementModeParamExist = (isWarFile && 
								aListResultantTempInLowerCase.contains("-measurement_mode") && 
								aListResultantTempInLowerCase.contains("-jmx_remote_port"));
			rootJson.put("isMeasurementModeParamExist",isMeasurementModeParamExist);

			if (aListResultantTempInLowerCase.contains("-showallevents") && 
				aListResultantTempInLowerCase.contains("-showallonly"))
			{
				hasShowAllOnlyParam = true;
				strFromReConfig = request.getParameter("fromReConfigure");
				rootJson.put("fromReConfigure",strFromReConfig);
				int showAllEventsIdx = aListResultantTempInLowerCase.indexOf("-showallevents");
				String showAllEventsCase = (String)aResultant.get(showAllEventsIdx);
				showAllEventsCase = showAllEventsCase.substring(1);
				if (StringUtils.isNull(strFromReConfig))
				{
					showAllEventsValue = request.getParameter(showAllEventsCase);
				}
				if (showAllEventsValue == null || showAllEventsValue.length() == 0)
				{
					showAllEventsValue = (String)aResultant.get(showAllEventsIdx+1);
				}
				rootJson.put("showAllEventsValue",showAllEventsValue);
			}
			rootJson.put("hasShowAllOnlyParam",hasShowAllOnlyParam);
			if (aListResultantTempInLowerCase.contains("-report_total") && 
				aListResultantTempInLowerCase.contains("-report_only_total"))
			{
				hasReportOnlyTotalParam = true;
				strFromReConfig = request.getParameter("fromReConfigure");
				rootJson.put("fromReConfigure",strFromReConfig);
				int reportTotalIdx = aListResultantTempInLowerCase.indexOf("-report_total");
				String reportTotalCase = (String)aResultant.get(reportTotalIdx);
				reportTotalCase = reportTotalCase.substring(1);
				if (StringUtils.isNull(strFromReConfig))
				{
					reportTotalValue = request.getParameter(reportTotalCase);
				}
				if (reportTotalValue == null || reportTotalValue.length() == 0)
				{
					reportTotalValue = (String)aResultant.get(reportTotalIdx+1);
				}
				rootJson.put("reportTotalValue",reportTotalValue);
			}
			rootJson.put("hasReportOnlyTotalParam",hasReportOnlyTotalParam);
			if (isMeasurementModeParamExist)
			{
				int portIdx = aListResultantTempInLowerCase.indexOf("-port");
				String portCase = null;
				if (portIdx != -1)
				{
					portCase = (String)aResultant.get(portIdx);
				}

				int modeIdx = aListResultantTempInLowerCase.indexOf("-measurement_mode");
				String modeCase = null;
				if (modeIdx != -1)
				{
					modeCase = (String)aResultant.get(modeIdx);
				}

				//put measure_mode after port
				//-host,-port,-measure_mode
				int tempModeIdx = aResultant.indexOf(modeCase);
				String moveModeParam = (String)aResultant.remove(tempModeIdx);
				String moveModeValue = (String)aResultant.remove(tempModeIdx);
				String moveModeDisplayControl = (String)aResultant.remove(tempModeIdx);

				int tempPortIdx = aResultant.indexOf(portCase);
				aResultant.add(tempPortIdx+3,moveModeParam);
				aResultant.add(tempPortIdx+4,moveModeValue);
				aResultant.add(tempPortIdx+5,moveModeDisplayControl);
			}

			if (isMeasureModeParamExist)
			{
				/*int portIdx = aListResultantTempInLowerCase.indexOf("-port");
				String portCase = null;
				if (portIdx != -1)
				{
					portCase = (String)aResultant.get(portIdx);
				}

				int modeIdx = aListResultantTempInLowerCase.indexOf("-measure_mode");
				String modeCase = null;
				if (modeIdx != -1)
				{
					modeCase = (String)aResultant.get(modeIdx);
				}
				String moveJmxOptionParam = null;
				String moveJmxOptionValue = null;
				String moveJmxDisplayControl = null;
				boolean jmxOption = aListResultantTempInLowerCase.contains("-metric_collection_type");
				int jmxOptionIdx = aListResultantTempInLowerCase.indexOf("-metric_collection_type");
				String jmxOptionCase = null;
				int tempJmxOptionIdx = -1;
				if(jmxOption)
				{
					if (jmxOptionIdx != -1)
					{
						jmxOptionCase = (String)aResultant.get(jmxOptionIdx);
					}
					tempJmxOptionIdx = aResultant.indexOf(jmxOptionCase);
					moveJmxOptionParam = (String)aResultant.remove(tempJmxOptionIdx);
					moveJmxOptionValue = (String)aResultant.remove(tempJmxOptionIdx);
					moveJmxDisplayControl = (String)aResultant.remove(tempJmxOptionIdx);
				}
				//put measure_mode after port
				//-host,-port,-measure_mode
				int tempModeIdx = aResultant.indexOf(modeCase);
				String moveModeParam = (String)aResultant.remove(tempModeIdx);
				String moveModeValue = (String)aResultant.remove(tempModeIdx);
				String moveModeDisplayControl = (String)aResultant.remove(tempModeIdx);

				int tempPortIdx = aResultant.indexOf(portCase);
				if(jmxOption)
				{
					aResultant.add(tempPortIdx+3,moveJmxOptionParam);
					aResultant.add(tempPortIdx+4,moveJmxOptionValue);
					aResultant.add(tempPortIdx+5,moveJmxDisplayControl);
					aResultant.add(tempPortIdx+6,moveModeParam);
					aResultant.add(tempPortIdx+7,moveModeValue);
					aResultant.add(tempPortIdx+8,moveModeDisplayControl);
				}
				else
				{
					aResultant.add(tempPortIdx+3,moveModeParam);
					aResultant.add(tempPortIdx+4,moveModeValue);
					aResultant.add(tempPortIdx+5,moveModeDisplayControl);
				}*/

				changeMeasureModeParamPosition(aResultant,aListResultantTempInLowerCase);
			}
			if (isSnmp)
			{
				int portIdx = aListResultantTempInLowerCase.indexOf("-port");
				String portCase = null;
				if (portIdx != -1)
				{
					portCase = (String)aResultant.get(portIdx);
				}

				int timeOutIdx = aListResultantTempInLowerCase.indexOf("-timeout");
				String timeOutCase = null;
				if (timeOutIdx != -1)
				{
					timeOutCase = (String)aResultant.get(timeOutIdx);
				}

				int modeIdx = aListResultantTempInLowerCase.indexOf("-mode");
				String modeCase = null;
				if (modeIdx != -1)
				{
					modeCase = (String)aResultant.get(modeIdx);
				}

				int snmpComIdx=aListResultantTempInLowerCase.indexOf("-snmpcommunity");

				//for older version of snmp not having snmpversion
				String selectToAdd = "";
				if (!aListResultantTempInLowerCase.contains("-snmpversion"))
				{
					aResultant.add(snmpComIdx+3,"-snmpversion");
					aResultant.add(snmpComIdx+4,"v1");
					aResultant.add(snmpComIdx+5,"select");

					aListResultantTempInLowerCase.add(snmpComIdx+3,"-snmpversion");
					aListResultantTempInLowerCase.add(snmpComIdx+4,"v1");
					aListResultantTempInLowerCase.add(snmpComIdx+5,"select");

					selectToAdd = selectToAdd + ",snmpversion";
					isOldSnmp = true;

					String[] tmpVersions = {"v1","v2"};
					versions = tmpVersions;
				}

				if (aListResultantTempInLowerCase.contains("-snmpversion") && !aListResultantTempInLowerCase.contains("-authtype") && !aListResultantTempInLowerCase.contains("-encrypttype"))
				{
					isOldSnmp = true;

					String[] tmpVersions = {"v1","v2"};
					versions = tmpVersions;
				}

				if (selectToAdd.length() > 0)
				{
					IniFile egTestParamIniSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_testparam.ini");
					egTestParamIniSync.setValue("SELECT",testName,selectToAdd.substring(1));
					egTestParamIniSync.saveFile();
					EgConfigFilesSync.releaseInstance(egTestParamIniSync);
				}

				int snmpVerIdx = aListResultantTempInLowerCase.indexOf("-snmpversion");

				String originalSnmpParam = ((String)aResultant.get(snmpVerIdx)).substring(1);
				if (testName.equals(previousTestName))
				{
					snmpVer = request.getParameter(originalSnmpParam);
					snmpVer = (snmpVer!=null)?snmpVer:"";
				}

				if (snmpVer.equals(""))
				{
					isSnmpV1V2 = (aListResultantTempInLowerCase.contains("v1") || aListResultantTempInLowerCase.contains("v2"))?true:false;
				}
				else
				{
					isSnmpV1V2 = (snmpVer.equalsIgnoreCase("v1") || snmpVer.equalsIgnoreCase("v2"))?true:false;
				}
				rootJson.put("snmpVer",snmpVer);
				rootJson.put("isSnmpV1V2",isSnmpV1V2);
				if(!isSnmpV1V2)
				{
					encryptValue = (String)aResultant.get(aListResultantTempInLowerCase.indexOf("-encryptflag")+1);
				}
				rootJson.put("encryptValue",encryptValue);
				//displaying snmp community afer snmp version
				String moveSnmpCommParam = (String)aResultant.remove(snmpComIdx);
				String moveSnmpCommValue = (String)aResultant.remove(snmpComIdx);
				String moveSnmpCommDisplayControl = (String)aResultant.remove(snmpComIdx);

				int tempSnmpVerIdx = aResultant.indexOf("-"+originalSnmpParam);
				aResultant.add(tempSnmpVerIdx+3,moveSnmpCommParam);
				aResultant.add(tempSnmpVerIdx+4,moveSnmpCommValue);
				aResultant.add(tempSnmpVerIdx+5,moveSnmpCommDisplayControl);

				int encryptFlagIdx = aListResultantTempInLowerCase.indexOf("-encryptflag");
				if (encryptFlagIdx > -1)
				{
					encryptFlag = request.getParameter(((String)aResultant.get(encryptFlagIdx)).substring(1));
				}
				encryptFlag = (encryptFlag!=null)?encryptFlag:"";
				rootJson.put("encryptFlag",encryptFlag);

				if (isModeParamExist)
				{
					/*String moveJmxOptionParam = null;
					String moveJmxOptionValue = null;
					String moveJmxDisplayControl = null;
					boolean jmxOption = aListResultantTempInLowerCase.contains("-metric_collection_type");
					int jmxOptionIdx = aListResultantTempInLowerCase.indexOf("-metric_collection_type");
					String jmxOptionCase = null;
					int tempJmxOptionIdx = -1;
					if(jmxOption)
					{
						if (jmxOptionIdx != -1)
						{
							jmxOptionCase = (String)aResultant.get(jmxOptionIdx);
						}
						tempJmxOptionIdx = aResultant.indexOf(jmxOptionCase);
						moveJmxOptionParam = (String)aResultant.remove(tempJmxOptionIdx);
						moveJmxOptionValue = (String)aResultant.remove(tempJmxOptionIdx);
						moveJmxDisplayControl = (String)aResultant.remove(tempJmxOptionIdx);
					}
					if (timeOutIdx == -1)
					{
						//put mode after port
						//-host,-port,-mode
						int tempModeIdx = aResultant.indexOf(modeCase);
						
						String moveModeParam = (String)aResultant.remove(tempModeIdx);
						String moveModeValue = (String)aResultant.remove(tempModeIdx);
						String moveModeDisplayControl = (String)aResultant.remove(tempModeIdx);

						int tempPortIdx = aResultant.indexOf(portCase);
						if(jmxOption)
						{
							aResultant.add(tempPortIdx+3,moveJmxOptionParam);
							aResultant.add(tempPortIdx+4,moveJmxOptionValue);
							aResultant.add(tempPortIdx+5,moveJmxDisplayControl);
							aResultant.add(tempPortIdx+6,moveModeParam);
							aResultant.add(tempPortIdx+7,moveModeValue);
							aResultant.add(tempPortIdx+8,moveModeDisplayControl);
						}
						else
						{
							aResultant.add(tempPortIdx+3,moveModeParam);
							aResultant.add(tempPortIdx+4,moveModeValue);
							aResultant.add(tempPortIdx+5,moveModeDisplayControl);
						}
					}
					else
					{
						int tempTimeOutCaseIdx = aResultant.indexOf(timeOutCase);
						String moveTimeOutParam = (String)aResultant.remove(tempTimeOutCaseIdx);
						String moveTimeOutValue = (String)aResultant.remove(tempTimeOutCaseIdx);
						String moveTimeOutDisplayControl = (String)aResultant.remove(tempTimeOutCaseIdx);

						//-host,-port,-timeout,-mode
						//put timeout after port
						int tempPortIdx = aResultant.indexOf(portCase);
						aResultant.add(tempPortIdx+3,moveTimeOutParam);
						aResultant.add(tempPortIdx+4,moveTimeOutValue);
						aResultant.add(tempPortIdx+5,moveTimeOutDisplayControl);

						int tempModeCaseIdx = aResultant.indexOf(modeCase);
						
						String moveModeParam = (String)aResultant.remove(tempModeCaseIdx);
						String moveModeValue = (String)aResultant.remove(tempModeCaseIdx);
						String moveModeDisplayControl = (String)aResultant.remove(tempModeCaseIdx);

						//put mode after timeout
						int tempTimeOutCaseIdx1 = aResultant.indexOf(timeOutCase);
						if(jmxOption)
						{
							aResultant.add(tempTimeOutCaseIdx1+3,moveJmxOptionParam);
							aResultant.add(tempTimeOutCaseIdx1+4,moveJmxOptionValue);
							aResultant.add(tempTimeOutCaseIdx1+5,moveJmxDisplayControl);
							aResultant.add(tempTimeOutCaseIdx1+6,moveModeParam);
							aResultant.add(tempTimeOutCaseIdx1+7,moveModeValue);
							aResultant.add(tempTimeOutCaseIdx1+8,moveModeDisplayControl);
						}
						else
						{
							aResultant.add(tempTimeOutCaseIdx1+3,moveModeParam);
							aResultant.add(tempTimeOutCaseIdx1+4,moveModeValue);
							aResultant.add(tempTimeOutCaseIdx1+5,moveModeDisplayControl);
						}
					}*/

					changeModeParamPosToSNMPRelevantTests(aResultant,aListResultantTempInLowerCase,portCase,timeOutCase,modeCase,timeOutIdx);
				}
			}
			//snmp work end here

			//policy filter work starts here
			Hashtable policyFilterParamsDetails = new Hashtable();
			policyFilterParamsDetails = getPolicyFilterParamsDetails(request, aListResultantTempInLowerCase, aResultant, testName);

			if (policyFilterParamsDetails != null && !policyFilterParamsDetails.isEmpty())
			{
				isPolicyParamExists = ((Boolean) policyFilterParamsDetails.get("isPolicyParamExists")).booleanValue();
				tPolicyFilter = policyFilterParamsDetails.get("tPolicyFilter").toString();
				rootJson.put("isPolicyParamExists",isPolicyParamExists);

				if (isPolicyParamExists)
				{
					String strPolTrue = policyFilterParamsDetails.get("isPolicyFilterTrue").toString();
					if (!com.egurkha.util.StringUtils.isNull(strPolTrue))
					{
						rootJson.put("isPolicyFilterTrue",strPolTrue);
					}

					aPolicyFilter = (ArrayList) policyFilterParamsDetails.get("aPolicyFilter");

					String strPolFalse = policyFilterParamsDetails.get("isPolicyFilterFalse").toString();
					if (!com.egurkha.util.StringUtils.isNull(strPolFalse))
					{
						rootJson.put("isPolicyFilterFalse",strPolFalse);
					}
				}
			}
			//policy filter work ends here

			//credential work starts here(http test)
			String moreUrl = request.getParameter("moreurl");
			moreUrl = (moreUrl!=null)?moreUrl:"";
			rootJson.put("moreUrl",moreUrl);

			isCredentialParamExist = aListResultantTempInLowerCase.contains("-credentials");
			isUrlParamExist = aListResultantTempInLowerCase.contains("-url");
			isWsdlUrlExist = aListResultantTempInLowerCase.contains("-wsdl_url");
			isPrivateKeyParamExist = aListResultantTempInLowerCase.contains("-privatekey");
			isSystemPropKeyParamExist = aListResultantTempInLowerCase.contains("-systempropertykey");
			rootJson.put("isUrlParamExist",isUrlParamExist);
			rootJson.put("isWsdlUrlExist",isWsdlUrlExist);
			rootJson.put("isPrivateKeyParamExist",isPrivateKeyParamExist);
			rootJson.put("isCredentialParamExist",isCredentialParamExist);
			rootJson.put("isSystemPropKeyParamExist",isSystemPropKeyParamExist);

			//Targets start
			isTargetWthSysProps = (aListResultantTempInLowerCase.contains("-targets") &&  aListResultantTempInLowerCase.contains("-systempropsvalue") &&  aListResultantTempInLowerCase.contains("-systempropskey")) ? true : false;
			rootJson.put("isTargetWthSysProps",isTargetWthSysProps);
			if(isTargetWthSysProps)
			{
				Hashtable trgtSysPropertyData = getTargetSysPropertyData(aResultant,aListResultantTempInLowerCase);
				if (trgtSysPropertyData != null && trgtSysPropertyData.size() > 0)
				{
					aListTgtSysPropKeys = (ArrayList) trgtSysPropertyData.get("trgtSysPropKeys");
					aListTgtSysPropValues = (ArrayList) trgtSysPropertyData.get("trgtSysPropVals");
				}
			}
			//Targets end

			if (isCredentialParamExist)
			{
				Hashtable credentialParams = getCredentialParamsDetails(request, aListResultantTempInLowerCase, aResultant, testName, aListParamsWithDoubleQuotes, aListTcKeywordsLowerCase);
				aUrlCredentialVal = (ArrayList) credentialParams.get("aUrlCredentialVal");
				previousUrl = credentialParams.get("previousUrl").toString();

				aListContentValues = (ArrayList) credentialParams.get("aListContentValues");
				aListEncodingValues = (ArrayList) credentialParams.get("aListEncodingValues");
				aListFilePathValues = (ArrayList) credentialParams.get("aListFilePathValues");
				aListSystemPropKeys = (ArrayList) credentialParams.get("aListSystemPropKeys");
				aListSystemPropValues = (ArrayList) credentialParams.get("aListSystemPropValues");
			}
			//credential work ends here

			//ejb test - starts
			String ejbValues = egSpecs.getTestsInGroup("EgConfigInfos.jsp");
			String[] values = StringUtils.getTokens(ejbValues,EgConstants.COMMA);
			ArrayList aListEjbValues = new ArrayList(Arrays.asList(values));
			if (aListEjbValues.contains(testName))
			{
				isEjbGroupingRequired = true;
				pageNameForEjbGrouping = "EgConfigInfos.jsp";
			}

			ejbValues = egSpecs.getTestsInGroup("EgConfigEjb.jsp");
			values = StringUtils.getTokens(ejbValues,EgConstants.COMMA);
			aListEjbValues = new ArrayList(Arrays.asList(values));
			if (aListEjbValues.contains(testName))
			{
				isEjbGroupingRequired = true;
				pageNameForEjbGrouping = "EgConfigEjb.jsp";
			}
			//ejb test - ends

			prgBean.createFile("eg_tests.ini");

			//contains multiple user enabled test
			listMultipleUserSupportTest = Arrays.asList(prgBean.getVariables("MULTIPLE_USERS"));

			//Detailed diagnosis - starts
			//Initial check for DD frequency from eg_tests.ini [FREQUENCY_MAPPING]
			//if normal and bad = 0 no dd option
			String normalFrequency = prgBean.getStrValue("FREQUENCY_MAPPING","Normal_frequency");
			String badFrequency = prgBean.getStrValue("FREQUENCY_MAPPING","Bad_frequency");
			if (normalFrequency.equalsIgnoreCase("0") && badFrequency.equalsIgnoreCase("0"))
			{
				detailedDiagnosisOptionEnabled = false;
			}

			if (detailedDiagnosisOptionEnabled)
			{
				Hashtable ddFunctionValues = getDDRelatedDetails(componentType, componentName, componentNickName, testName, isPortRelevantForTest);

				allowDetailedDiagnosis = ((Boolean) ddFunctionValues.get("allowDetailedDiagnosis")).booleanValue();
				isTestDetailedDiagnosisDisabledGlobally = ((Boolean) ddFunctionValues.get("isTestDetailedDiagnosisDisabledGlobally")).booleanValue();
				detailedDiagnosisOn = (String) ddFunctionValues.get("detailedDiagnosisOn");
				detailedDiagnosisOff = (String) ddFunctionValues.get("detailedDiagnosisOff");
			}
			//Detailed diagnosis - ends

			//egruntime - starts
			if ((aListResultantTempInLowerCase.contains("-process") || 
				aListResultantTempInLowerCase.contains("-servicename")) && 
				aListResultantTempInLowerCase.contains("(eg_runtime)"))
			{
				String hostOS = "";
				String pattern = "";
				if (isRemote)
				{
					hostOS = ((String)aResultant.get(aListResultantTempInLowerCase.indexOf("-os")+1)).trim();
					if (!StringUtils.isNull(hostOS))
					{
						hostOS = getRemoteAgentOS(hostOS);
					}
				}
				else
				{
					hostOS = agentconfig.getAgentOS((String)listAgents.get(0));
				}
				if (hostOS != null)
				{
					prgBean.createFile("eg_tests.ini");
					pattern = prgBean.getStrValue("OS_PROCESSPATTERN",hostOS+":"+componentType+":"+testName);
					pattern = (!pattern.equals(""))?pattern:"(EG_RUNTIME)";
					pattern = StringUtils.replace(pattern,"#",EgConstants.COMMA);
					int processIdx = aListResultantTempInLowerCase.indexOf("-process");
					int serviceIdx = aListResultantTempInLowerCase.indexOf("-servicename");
					if ((((String)aResultant.get(processIdx+1)).equals("(EG_RUNTIME)")) || (((String)aResultant.get(serviceIdx+1)).equals("(EG_RUNTIME)")))
					{
						if (componentType != null && componentType.equals("Oracle_server") && pattern != null && pattern.indexOf("$sid") != -1)
						{

							String sidInstance = componentName.substring(componentName.indexOf(":")+1);
							if (sidInstance != null && sidInstance.indexOf(":") != -1)
							{
								sidInstance = sidInstance.substring(sidInstance.indexOf(":")+1);
							}
							else
							{
								sidInstance = "$sid";
							}
							pattern = StringUtils.replace(pattern,"$sid",sidInstance);
						}
						
						if (processIdx != -1)
						{
							aResultant.remove(processIdx+1);
							aResultant.add(processIdx+1,pattern);
						}
						else
						{
							aResultant.remove(serviceIdx+1);
							aResultant.add(serviceIdx+1,pattern);
						}
					}
				}
			}
			//egruntime - ends

			//eghomedir starts
			if (aListResultantTempInLowerCase.contains("-alertfile"))
			{
				if (testName.equalsIgnoreCase("EgErrorLogTest") || 
					testName.equalsIgnoreCase("EgThreshLogTest") || 
					testName.equalsIgnoreCase("EgTrendLogTest"))
				{
					int logFileIndex = aListResultantTempInLowerCase.indexOf("-alertfile");
					String strValue = (String)aResultant.get(logFileIndex+1);
					if (strValue.indexOf("|") != -1)
					{
						String strUpdatedParamValue = "";
						StringTokenizer strTokens = new StringTokenizer(strValue,"|");
						while (strTokens.hasMoreTokens())
						{
							String strToken = strTokens.nextToken();
							strUpdatedParamValue = strUpdatedParamValue + strToken.substring(strToken.indexOf("(EG_HOME_DIR)")+13) + "|";
						}
						strValue = strUpdatedParamValue.substring(0,strUpdatedParamValue.length()-1);
					}
					else
					{
						strValue = strValue.substring(strValue.indexOf("(EG_HOME_DIR)")+13);
					}
					aResultant.remove(logFileIndex+1);
					aResultant.add(logFileIndex+1,strValue);
				}
			}
			//eghomedir ends

			//aggregate specific - starts
			EgAggregateInfo egAggInfo = new EgAggregateInfo("manager");
			isAggregateTest = (testName.endsWith("_ag") || testName.endsWith("_agx"));
			rootJson.put("isAggregateTest",isAggregateTest);
			isCompositeTest = testName.endsWith("_rx")?true:false;
			rootJson.put("isCompositeTest",isCompositeTest);
			if (allowAggregateOperation)
			{
				minimumTestPeriod = getAggregateMinTestperiod(componentType, componentName, componentNickName, testName, isAggregateTest);
			}
			//aggregate specific - ends

			//To configure value for specific Descriptor - starts
			com.eg.IniFile specIniFile = new com.eg.IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_specs.ini");
			String descriptorDetail =specIniFile.getValue("DESCRIPTOR_DETAILS",testName);
			StringTokenizer st = new StringTokenizer(descriptorDetail,",");
			while (st.hasMoreTokens())
			{
				aListDescriptorParam.add(st.nextToken());
			}
			//To configure value for specific Descriptor - ends

			//To do the following
			//1.Configure value for virtual centers 
			//2.Change webport value,when its value is default - starts
			if (aListResultantTempInLowerCase.contains("-webport") && 
				aListResultantTempInLowerCase.contains("-ssl"))
			{
				Hashtable vCenterDetails = getWebportAndVCenterDetails(request, servicesIniFile, aListResultantTempInLowerCase, aResultant, testName, previousTestName);
				if (aListResultantTempInLowerCase.contains("-virtual_center"))
				{
					//To configure value for virtual centers - starts
					//int tempVirtual_centerIdx = aListResultantTempInLowerCase.indexOf("-virtual_center");
					//String tempVirtual_centerValue = ((String)aResultant.get(tempVirtual_centerIdx+1)).trim();

					virtualCenters = servicesIniFile.getVariables("VIRTUAL_CENTER");
					String selectedVirtualCenter = vCenterDetails.get("selectedVirtualCenter").toString();
					//if (testName.equals(previousTestName))
					//{
						//selectedVirtualCenter = request.getParameter("virtual_center");
						//selectedVirtualCenter = (selectedVirtualCenter != null)?selectedVirtualCenter:"";
					//}

					if (!selectedVirtualCenter.equals(""))
					{
						String sslValue = vCenterDetails.get("sslValue").toString();
						String esx_UserValue = vCenterDetails.get("esx_UserValue").toString();
						String esx_PassWord = vCenterDetails.get("esx_PassWord").toString();
						String webPort = vCenterDetails.get("webPort").toString();
						String selectedVirtualCenterValue = vCenterDetails.get("selectedVirtualCenterValue").toString();
						/*if (selectedVirtualCenter.equalsIgnoreCase("none"))
						{
							if (tempVirtual_centerValue.equalsIgnoreCase("none"))
							{
								int tempIdx = aListResultantTempInLowerCase.indexOf("-esx_user");
								esx_UserValue = ((String)aResultant.get(tempIdx+1)).trim();

								tempIdx = aListResultantTempInLowerCase.indexOf("-esx_password");
								esx_PassWord = ((String)aResultant.get(tempIdx+1)).trim();

								tempIdx = aListResultantTempInLowerCase.indexOf("-ssl");
								sslValue = ((String)aResultant.get(tempIdx+1)).trim();

								tempIdx = aListResultantTempInLowerCase.indexOf("-webport");
								webPort = ((String)aResultant.get(tempIdx+1)).trim();

								if (webPort.equalsIgnoreCase("default"))
								{
									if (sslValue.equalsIgnoreCase("true") || 
									sslValue.equalsIgnoreCase("yes"))
									{
										webPort = "443";
									}
									else
									{
										webPort = "80";
									}
								}
							}
							else
							{
								esx_UserValue = "$unconfigured";
								esx_PassWord = "$unconfigured";
								sslValue = "true";
								webPort = "443";
							}
						}
						else if (selectedVirtualCenter.equalsIgnoreCase("other"))
						{
							esx_UserValue = "none";
							esx_PassWord = "none";
							sslValue = "true";
							webPort = "443";
						}
						else
						{ 
							selectedVirtualCenterValue = servicesIniFile.getValue("VIRTUAL_CENTER",selectedVirtualCenter);
							selectedVirtualCenterValue = (selectedVirtualCenterValue != null)?selectedVirtualCenterValue:"";
							if (!selectedVirtualCenterValue.equals(""))
							{
								StringTokenizer stVirtualCenterTokens = null;
								stVirtualCenterTokens = new StringTokenizer(selectedVirtualCenterValue,"#");
								sslValue = stVirtualCenterTokens.nextToken();
								esx_UserValue = stVirtualCenterTokens.nextToken();
								esx_PassWord = stVirtualCenterTokens.nextToken();
								stVirtualCenterTokens.nextToken();
								webPort = stVirtualCenterTokens.nextToken();
							}
						}*/

						int virtual_centerIdx = aListResultantTempInLowerCase.indexOf("-virtual_center");
						aResultant.remove(virtual_centerIdx+1);
						aResultant.add(virtual_centerIdx+1,selectedVirtualCenter);

						int sslIdx = aListResultantTempInLowerCase.indexOf("-ssl");
						aResultant.remove(sslIdx+1);
						aResultant.add(sslIdx+1,sslValue.toLowerCase());

						int esx_userIdx = aListResultantTempInLowerCase.indexOf("-esx_user");
						aResultant.remove(esx_userIdx+1);
						aResultant.add(esx_userIdx+1,esx_UserValue);

						int esx_PassWordIdx = aListResultantTempInLowerCase.indexOf("-esx_password");
						aResultant.remove(esx_PassWordIdx+1);
						aResultant.add(esx_PassWordIdx+1,esx_PassWord);

						int webPortIdx = aListResultantTempInLowerCase.indexOf("-webport");
						aResultant.remove(webPortIdx+1);
						aResultant.add(webPortIdx+1,webPort);
					}
					else
					{
						boolean isNeedtoChangeWebport = ((Boolean) vCenterDetails.get("isNeedtoChangeWebport")).booleanValue();
						if (isNeedtoChangeWebport)
						{
							String webPort = (String) vCenterDetails.get("webPort");
							int webPortIdx = aListResultantTempInLowerCase.indexOf("-webport");
							aResultant.remove(webPortIdx+1);
							aResultant.add(webPortIdx+1,webPort);
						}

						/*ArrayList aListTempVirtualCenters = null;
						boolean hasVirtualCenters = false;
						if (virtualCenters != null && virtualCenters.length > 0)
						{
							aListTempVirtualCenters = new ArrayList(Arrays.asList(virtualCenters));
							hasVirtualCenters = true;
						}

						if (tempVirtual_centerValue.equalsIgnoreCase("none"))
						{
							int tempIdx = aListResultantTempInLowerCase.indexOf("-webport");
							String webPort = ((String)aResultant.get(tempIdx+1)).trim();
							if (webPort.equalsIgnoreCase("default"))
							{
								tempIdx = aListResultantTempInLowerCase.indexOf("-ssl");
								String sslValue = ((String)aResultant.get(tempIdx+1)).trim();
								if (sslValue.equalsIgnoreCase("true") || 
									sslValue.equalsIgnoreCase("yes"))
								{
									webPort = "443";
								}
								else
								{
									webPort = "80";
								}

								int webPortIdx = aListResultantTempInLowerCase.indexOf("-webport");
								aResultant.remove(webPortIdx+1);
								aResultant.add(webPortIdx+1,webPort);
							}
						}
						else if ((aListTempVirtualCenters == null) || (hasVirtualCenters && !aListTempVirtualCenters.contains(tempVirtual_centerValue)))
						{
							//upgrade issue
							int tempIdx = aListResultantTempInLowerCase.indexOf("-webport");
							String webPort = ((String)aResultant.get(tempIdx+1)).trim();
							if (webPort.equalsIgnoreCase("default"))
							{
								tempIdx = aListResultantTempInLowerCase.indexOf("-ssl");
								String sslValue = ((String)aResultant.get(tempIdx+1)).trim();
								if (sslValue.equalsIgnoreCase("true") || 
									sslValue.equalsIgnoreCase("yes"))
								{
									webPort = "443";
								}
								else
								{
									webPort = "80";
								}

								int webPortIdx = aListResultantTempInLowerCase.indexOf("-webport");
								aResultant.remove(webPortIdx+1);
								aResultant.add(webPortIdx+1,webPort);
							}
						}*/
					}
					//To configure value for virtual centers - ends
				}
				else if (aListResultantTempInLowerCase.contains("-prism_ip"))
				{
					//To configure value for virtual centers - starts
					int tempCVM_IPIdx = aListResultantTempInLowerCase.indexOf("-prism_ip");
					String tempCVM_IPValue = ((String)aResultant.get(tempCVM_IPIdx+1)).trim();

					nutanixPrisms = servicesIniFile.getVariables("NUTANIX");
					String selectedCVMIP = (String) vCenterDetails.get("selectedCVMIP");
					//if (testName.equals(previousTestName))
					//{
						//selectedCVMIP = request.getParameter("Prism_IP");
						//selectedCVMIP = (selectedCVMIP != null)?selectedCVMIP:"";
					//}


					if (!selectedCVMIP.equals(""))
					{
						String sslValue = (String) vCenterDetails.get("selectedCVMIP");
						String cvm_UserValue = (String) vCenterDetails.get("selectedCVMIP");
						String cvm_PassWord = (String) vCenterDetails.get("selectedCVMIP");
						String webPort = (String) vCenterDetails.get("selectedCVMIP");
						String selectedCVMIPValue = (String) vCenterDetails.get("selectedCVMIP");
						
						/*if (selectedCVMIP.equalsIgnoreCase("none"))
						{
							if (tempCVM_IPValue.equalsIgnoreCase("none"))
							{
								int tempIdx = aListResultantTempInLowerCase.indexOf("-prism_user");
								cvm_UserValue = ((String)aResultant.get(tempIdx+1)).trim();

								tempIdx = aListResultantTempInLowerCase.indexOf("-prism_password");
								cvm_PassWord = ((String)aResultant.get(tempIdx+1)).trim();

								tempIdx = aListResultantTempInLowerCase.indexOf("-ssl");
								sslValue = ((String)aResultant.get(tempIdx+1)).trim();

								tempIdx = aListResultantTempInLowerCase.indexOf("-webport");
								webPort = ((String)aResultant.get(tempIdx+1)).trim();

								if (webPort.equalsIgnoreCase("default"))
								{
									webPort = "9440";
								}
							}
							else
							{
								cvm_UserValue = "$unconfigured";
								cvm_PassWord = "$unconfigured";
								sslValue = "true";
								webPort = "9440";
							}
						}
						else if (selectedCVMIP.equalsIgnoreCase("other"))
						{
							cvm_UserValue = "none";
							cvm_PassWord = "none";
							sslValue = "true";
							webPort = "9440";
						}
						else
						{
							selectedCVMIPValue = servicesIniFile.getValue("NUTANIX",selectedCVMIP);
							selectedCVMIPValue = (selectedCVMIPValue != null)?selectedCVMIPValue:"";
							if (!selectedCVMIPValue.equals(""))
							{
								StringTokenizer stCVMTokens = null;
								stCVMTokens = new StringTokenizer(selectedCVMIPValue,"#");
								sslValue = stCVMTokens.nextToken();
								cvm_UserValue = stCVMTokens.nextToken();
								cvm_PassWord = stCVMTokens.nextToken();
								stCVMTokens.nextToken();
								webPort = stCVMTokens.nextToken();
							}
						}*/

						int cvm_ipIdx = aListResultantTempInLowerCase.indexOf("-prism_ip");
						aResultant.remove(cvm_ipIdx+1);
						aResultant.add(cvm_ipIdx+1,selectedCVMIP);

						int sslIdx = aListResultantTempInLowerCase.indexOf("-ssl");
						aResultant.remove(sslIdx+1);
						aResultant.add(sslIdx+1,sslValue.toLowerCase());

						int esx_userIdx = aListResultantTempInLowerCase.indexOf("-prism_user");
						aResultant.remove(esx_userIdx+1);
						aResultant.add(esx_userIdx+1,cvm_UserValue);

						int esx_PassWordIdx = aListResultantTempInLowerCase.indexOf("-prism_password");
						aResultant.remove(esx_PassWordIdx+1);
						aResultant.add(esx_PassWordIdx+1,cvm_PassWord);

						int webPortIdx = aListResultantTempInLowerCase.indexOf("-webport");
						aResultant.remove(webPortIdx+1);
						aResultant.add(webPortIdx+1,webPort);
					}
					else
					{
						/*ArrayList aListTempNutanixPrisms = null;
						boolean hasNutanixPrisms = false;
						if (nutanixPrisms != null && nutanixPrisms.length > 0)
						{
							aListTempNutanixPrisms = new ArrayList(Arrays.asList(nutanixPrisms));
							hasNutanixPrisms = true;
						}

						if (tempCVM_IPValue.equalsIgnoreCase("none"))
						{
							int tempIdx = aListResultantTempInLowerCase.indexOf("-webport");
							String webPort = ((String)aResultant.get(tempIdx+1)).trim();
							if (webPort.equalsIgnoreCase("default"))
							{
								tempIdx = aListResultantTempInLowerCase.indexOf("-ssl");
								String sslValue = ((String)aResultant.get(tempIdx+1)).trim();
								webPort = "9440";

								int webPortIdx = aListResultantTempInLowerCase.indexOf("-webport");
								aResultant.remove(webPortIdx+1);
								aResultant.add(webPortIdx+1,webPort);
							}
						}
						else if ((aListTempNutanixPrisms == null) || (hasNutanixPrisms && !aListTempNutanixPrisms.contains(tempCVM_IPValue)))
						{
							//upgrade issue
							int tempIdx = aListResultantTempInLowerCase.indexOf("-webport");
							String webPort = ((String)aResultant.get(tempIdx+1)).trim();
							if (webPort.equalsIgnoreCase("default"))
							{
								webPort = "9440";

								int webPortIdx = aListResultantTempInLowerCase.indexOf("-webport");
								aResultant.remove(webPortIdx+1);
								aResultant.add(webPortIdx+1,webPort);
							}
						}*/

						boolean isNeedtoChangeWebport = ((Boolean) vCenterDetails.get("isNeedtoChangeWebport")).booleanValue();
						if (isNeedtoChangeWebport)
						{
							String webPort = (String) vCenterDetails.get("webPort");
							int webPortIdx = aListResultantTempInLowerCase.indexOf("-webport");
							aResultant.remove(webPortIdx+1);
							aResultant.add(webPortIdx+1,webPort);
						}

					}
					//To configure value for nutanix prisms - ends
				}
				else
				{
					boolean isNeedtoChangeWebport = ((Boolean) vCenterDetails.get("isNeedtoChangeWebport")).booleanValue();
					int webPortIdx = aListResultantTempInLowerCase.indexOf("-webport");
					if (isNeedtoChangeWebport)
					{
						String webPort = (String) vCenterDetails.get("webPort");
						aResultant.remove(webPortIdx+1);
						aResultant.add(webPortIdx+1,webPort);
					}
				}
			}
			//ends

			//To do the following
			//1.Configure value for HMCs
			if (aListResultantTempInLowerCase.contains("-is_managed_by") && 
				aListResultantTempInLowerCase.contains("-management_server"))
			{
				hmcs = servicesIniFile.getVariables("HMC");
				Hashtable hmcAndMgmtDetails = getHMCAndMgmtServerDetails(request, servicesIniFile,  aListResultantTempInLowerCase, aResultant, testName, previousTestName);

				if (testName.equals(previousTestName))
				{
					String strIsManagedByChanged = request.getParameter("isManagedByChanged");
					if (strIsManagedByChanged == null)
					{
						//String hmcMgmtServer = request.getParameter("management_server");
						//if (hmcMgmtServer == null)
						//{
							//hmcMgmtServer = "none";
						//}

						String strMgmtUser = hmcAndMgmtDetails.get("strMgmtUser").toString();
						String strMgmtPassword = hmcAndMgmtDetails.get("strMgmtPassword").toString();

						/*if (hmcMgmtServer.equalsIgnoreCase("none"))
						{
							strMgmtUser = "$unconfigured";
							strMgmtPassword = "$unconfigured";
						}
						else
						{
							String strTemp = servicesIniFile.getValue("HMC",hmcMgmtServer);
							strTemp = strTemp.substring(strTemp.indexOf("#")+1);

							strMgmtUser = strTemp.substring(0,strTemp.indexOf("#"));
							strTemp = strTemp.substring(strTemp.indexOf("#")+1);

							strMgmtPassword = strTemp.substring(0,strTemp.indexOf("#"));
							strMgmtPassword = EgCrypt.decrypt(strMgmtPassword);
						}*/

						int managementUserIdx = aListResultantTempInLowerCase.indexOf("-management_user");
						aResultant.remove(managementUserIdx+1);
						aResultant.add(managementUserIdx+1,strMgmtUser);

						int managementPasswordIdx = aListResultantTempInLowerCase.indexOf("-management_password");
						aResultant.remove(managementPasswordIdx+1);
						aResultant.add(managementPasswordIdx+1,strMgmtPassword);
					}
					else
					{
						String tempManagedBy = hmcAndMgmtDetails.get("tempManagedBy").toString();
						if (tempManagedBy != null && tempManagedBy.equalsIgnoreCase("hmc"))
						{
							request.setAttribute("management_server","none");
							request.setAttribute("management_user","none");
							request.setAttribute("management_password","none");
						}
						else if (tempManagedBy != null && tempManagedBy.equalsIgnoreCase("ivm"))
						{
							request.setAttribute("management_server","$unconfigured");
							request.setAttribute("management_user","$unconfigured");
							request.setAttribute("management_password","$unconfigured");
						}
					}

					//resIsManagedByValue = request.getParameter("is_managed_by");
				}
				//else
				//{
					//int isManagedByIdx = aListResultantTempInLowerCase.indexOf("-is_managed_by");
					//resIsManagedByValue = (String)aResultant.get(isManagedByIdx+1);
				//}

				resIsManagedByValue = hmcAndMgmtDetails.get("resIsManagedByValue").toString();
			}

			//RHEV- Code Starts
			if (aListResultantTempInLowerCase.contains("-rhel_mgr_host"))
			{
				rhevs = servicesIniFile.getVariables("RHEV");
				Hashtable rhevMgrHostDetails = getRHEVMgrHostDetails(request, servicesIniFile, aListTcKeywordsLowerCase, testName, previousTestName);

				if (testName.equals(previousTestName))
				{
					//String rhevManager = request.getParameter("Rhel_mgr_host");
					//if (rhevManager == null)
					//{
					//	rhevManager = "none";
					//}
		
					String strRhevUser = rhevMgrHostDetails.get("strRhevUser").toString();
					String strRhevPassword = rhevMgrHostDetails.get("strRhevPassword").toString();
					String strRhevPort = rhevMgrHostDetails.get("strRhevPort").toString();
					String strRhevDomain = rhevMgrHostDetails.get("strRhevDomain").toString();
					String strSSL = rhevMgrHostDetails.get("strSSL").toString();
					/*if (rhevManager.equalsIgnoreCase("none"))
					{
						strRhevUser = "$unconfigured";
						strRhevPassword = "$unconfigured";
						strRhevPort = "8443";
						strRhevDomain = "internal";
						strSSL = "false";
					}
					else
					{
						String strTemp = servicesIniFile.getValue("RHEV",rhevManager);
						strSSL = strTemp.substring(0,strTemp.indexOf("#"));
						strTemp = strTemp.substring(strTemp.indexOf("#")+1);

						strRhevUser = strTemp.substring(0,strTemp.indexOf("#"));
						strTemp = strTemp.substring(strTemp.indexOf("#")+1);

						strRhevPassword = strTemp.substring(0,strTemp.indexOf("#"));
						strRhevPassword = EgCrypt.decrypt(strRhevPassword);
						if (!aListTcKeywordsLowerCase.contains(strRhevPassword.toLowerCase()))
						{
							strRhevPassword += "~EG~"; // salt for pwd
							strRhevPassword = EgCrypt.encrypt(strRhevPassword); 
						}

						strTemp = strTemp.substring(strTemp.indexOf("#")+1);
						strTemp = strTemp.substring(strTemp.indexOf("#")+1);
						strRhevPort = strTemp.substring(0,strTemp.indexOf("#"));
						strTemp = strTemp.substring(strTemp.indexOf("#")+1);
						strRhevDomain = strTemp;

					}*/

					int userIdx = aListResultantTempInLowerCase.indexOf("-rhel_mgr_user");
					aResultant.remove(userIdx+1);
					aResultant.add(userIdx+1,strRhevUser);

					int pwdIndex = aListResultantTempInLowerCase.indexOf("-rhel_mgr_password");
					aResultant.remove(pwdIndex+1);
					aResultant.add(pwdIndex+1,strRhevPassword);

					int portIndex = aListResultantTempInLowerCase.indexOf("-rhel_mgr_port");
					aResultant.remove(portIndex+1);
					aResultant.add(portIndex+1,strRhevPort);

					int domainIndex = aListResultantTempInLowerCase.indexOf("-rhel_mgr_domain");
					aResultant.remove(domainIndex+1);
					aResultant.add(domainIndex+1,strRhevDomain);

					int sslIndex = aListResultantTempInLowerCase.indexOf("-ssl");
					aResultant.remove(sslIndex+1);
					aResultant.add(sslIndex+1,strSSL);
				}
			}
			//RHEV - Code Ends

			//EMC_XtremIO_4x- Code Starts
			if (aListResultantTempInLowerCase.contains("-xms_ip"))
			{
				emcXMSIPs = servicesIniFile.getVariables("EMC_XtremIO_4x");
				Hashtable emcXtrimDetails = getEMCXtremIODetails(request, servicesIniFile, aListTcKeywordsLowerCase, testName, previousTestName);

				boolean isChangeRequires = ((Boolean) emcXtrimDetails.get("isChangeRequires")).booleanValue();
				if (isChangeRequires)
				{
					/*String xmsIP = request.getParameter("xms_ip");
					if (xmsIP == null)
					{
						xmsIP = "none";
					}
		
					String strEmcIOUser = "";
					String strEmcIOPassword = "";
					String strSSL = "";
					if (xmsIP.equalsIgnoreCase("none"))
					{
						strEmcIOUser = "$unconfigured";
						strEmcIOPassword = "$unconfigured";
						strSSL = "false";
					}
					else
					{
						String strTemp = servicesIniFile.getValue("EMC_XtremIO_4x",xmsIP);
						strSSL = strTemp.substring(0,strTemp.indexOf("#"));
						strTemp = strTemp.substring(strTemp.indexOf("#")+1);

						strEmcIOUser = strTemp.substring(0,strTemp.indexOf("#"));
						strTemp = strTemp.substring(strTemp.indexOf("#")+1);

						strEmcIOPassword = strTemp.substring(0,strTemp.indexOf("#"));
						strEmcIOPassword = EgCrypt.decrypt(strEmcIOPassword);
						if (!aListTcKeywordsLowerCase.contains(strEmcIOPassword.toLowerCase()))
						{
							strEmcIOPassword += "~EG~"; // salt for pwd
							strEmcIOPassword = EgCrypt.encrypt(strEmcIOPassword); 
						}
					}*/

					String strEmcIOUser = emcXtrimDetails.get("strEmcIOUser").toString();
					String strEmcIOPassword = emcXtrimDetails.get("strEmcIOPassword").toString();
					String strSSL = emcXtrimDetails.get("strSSL").toString();

					int userIdx = aListResultantTempInLowerCase.indexOf("-XtremIO_user");
					aResultant.remove(userIdx+1);
					aResultant.add(userIdx+1,strEmcIOUser);

					int pwdIndex = aListResultantTempInLowerCase.indexOf("-XtremIO_password");
					aResultant.remove(pwdIndex+1);
					aResultant.add(pwdIndex+1,strEmcIOPassword);

					int sslIndex = aListResultantTempInLowerCase.indexOf("-ssl");
					aResultant.remove(sslIndex+1);
					aResultant.add(sslIndex+1,strSSL);
				}
			}
			//EMC_XtremIO_4x - Code Ends

			//apply to other components - starts

			aListConfigureComponentsClone = getOtherComponents(listOfComponents,componentType,componentName,testName,isPortRelevantForTest);

			//apply to other components - ends

			ArrayList specificTestList = correctiveScript.getSpecificTestList(componentType);
			rootJson.put("specificTestArr",specificTestList);
		}
	}

%>

<%!
	String pr_test = null;
	JSONObject prMeasureObject = new JSONObject();
	JSONArray prMeasureArray = new JSONArray();
	JSONArray prMeasureDispnameArray = new JSONArray();
	EgMappingInfo _mappingInfo = null;

	EgExternalInfo egExternalInfo = new EgExternalInfo("manager");
	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");

	String[] getAllExternalServerTypes = egSpecs.getAllExternalServerTypes();
	List listExternalServerTypes = Arrays.asList(getAllExternalServerTypes);

	// dependency params for restrict to password profile option
	String[] dependsParamsForPwdProfile = {"virtual_center","management_server","rhel_mgr_host","prism_ip","xms_ip","inside_view_using"};


	//param to continue globally
	String[] paramToContinue = {"mCount","rptName","agentless","Hyperv","remotePort","isLdoms","server_type_name","serverType"};

	//process paramters to be continued in remote based monitoring
	String[] processParamremoteContinue = {"agentless","aluser","alpassword","correct","almode","os","sshPort","alencrypt","alkeyfile","KVM"};

	//param to be continued for snmpV1 and snmpV2
	String[] snmpV1V2ParamToContinue = {"username","authpass","authtype","encryptflag","encrypttype","encryptpassword"};

	//param to be continued in snmpV3 when encrypt param is false
	String[] snmpV3ParamToContinue = {"encrypttype","encryptpassword"};

	//param to set in read-only mode when the test is set to have muti-user enabled
	String[] multiUserReadOnlyParam = {"user","admin_user","domain","password","admin_password","published_resources","User_name","Password","Domain_name","Connection_server_name"};
	String[] multiNameReadOnlyParam = {"name","pattern","threshold_value"};
	String[] multiOidsReadOnlyParam = {"measure_oid"};

	//param to continue when mode is true.(applicable to java application component type)
	String[] modeTrueToContinue = {"Jmx_Remote_Port","Jndi_Name","Jmx_user","Jmx_password","user","password"};

	//param to continue when mode is false.(applicable to java application component type)
	String[] modeFalseToContinue = {"snmpversion","snmpcommunity","snmpPort","authtype","authpass","username","encryptflag","encryptpassword","encrypttype"};

	//param to continue when measure mode is true.(applicable to JvmMemPoolGCTest alone)
	String[] measureModeTrueToContinue = {"Jmx_Remote_Port","Jndi_Name","Jmx_user","Jmx_password","user","password"};

	//param to continue when measure mode is false.(applicable to JvmMemPoolGCTest alone)
	String[] measureModeFalseToContinue = {"JREHome","LogFileName"};

	//param to continue when measure mode is true.(applicable to java application Tomcat & JBoss component types)
	String[] measurementModeTrueToContinue = {"Jmx_Remote_Port","Jndi_Name","Jmx_user","Jmx_password"};

	//param to continue when measure mode is false.(applicable to java application Tomcat & JBoss component types)
	String[] measurementModeFalseToContinue = {"ssl","url","username","password","encryptPass"};

	String[] targetDiskIORateLabel = {"Equals","Less Than","Less Than or Equal To","Greater Than","Greater Than or Equal To"};

	String[] paramsNeededToDoValidation={"agentless","almode","aluser","alpassword","info","sshPort","os","rptname"};

	String[] targetDiskIORateValue = {"EQ","LT","LE","GT","GE"};

	ArrayList aListDynamicSelectOptionNameAndValue = null;
	ArrayList aListDynamicRadioOptionNameAndValue = null;

	ArrayList aListPages = new ArrayList();
	public ArrayList getTestValuesWithControl(String testValues,String testName,IniFile egTestParamIni)
	{
		ArrayList aResultant = new ArrayList();
		String temp = "";
		HashMap hmapTestParamDetails = new HashMap();

		aListDynamicSelectOptionNameAndValue = new ArrayList();
		aListDynamicRadioOptionNameAndValue = new ArrayList();

		StringTokenizer testVal = new StringTokenizer(testValues,",");
		testVal.nextToken();
		String reqTestVal = testVal.nextToken();

		//radio
		String testRadioValue = egTestParamIni.getValue("RADIO",testName);
		if(testName.endsWith("_ag") || testName.endsWith("_agx"))
		{
			testRadioValue = "action_on_descriptors,aggregateDescriptor";
		}
		StringTokenizer radioTokens = new StringTokenizer(testRadioValue,",");
		while (radioTokens.hasMoreTokens())
		{
			String eachRadioToken = radioTokens.nextToken();
			if (eachRadioToken.indexOf("(") > -1 && eachRadioToken.indexOf(")") > -1)
			{
				String tempStrs = eachRadioToken.substring(eachRadioToken.indexOf("(")+1,eachRadioToken.indexOf(")"));
				eachRadioToken = eachRadioToken.substring(0,eachRadioToken.indexOf("("));
				if (!aListDynamicRadioOptionNameAndValue.contains(eachRadioToken))
				{
					aListDynamicRadioOptionNameAndValue.add(eachRadioToken);//param name
					aListDynamicRadioOptionNameAndValue.add(tempStrs);//param value
				}
			}
			hmapTestParamDetails.put(eachRadioToken.toLowerCase(),"radio");
		}

		//select
		String testSelectValue = egTestParamIni.getValue("SELECT",testName);
		StringTokenizer selectTokens = new StringTokenizer(testSelectValue,",");
		while (selectTokens.hasMoreTokens())
		{
			String eachSelectToken = selectTokens.nextToken();
			if (eachSelectToken.indexOf("(") > -1 && eachSelectToken.indexOf(")") > -1)
			{
				String tempStrs = eachSelectToken.substring(eachSelectToken.indexOf("(")+1,eachSelectToken.lastIndexOf(")"));
				eachSelectToken = eachSelectToken.substring(0,eachSelectToken.indexOf("("));
				if (!aListDynamicSelectOptionNameAndValue.contains(eachSelectToken))
				{
					aListDynamicSelectOptionNameAndValue.add(eachSelectToken);//param name
					aListDynamicSelectOptionNameAndValue.add(tempStrs);//param value
				}
			}
			hmapTestParamDetails.put(eachSelectToken.toLowerCase(),"select");
		}

		//password
		String testPwdValue = egTestParamIni.getValue("PASSWORD",testName);
		StringTokenizer pwdTokens = new StringTokenizer(testPwdValue,",");
		while (pwdTokens.hasMoreTokens())
		{
			String eachPwdToken = pwdTokens.nextToken();
			hmapTestParamDetails.put(eachPwdToken.toLowerCase(),"password");
		}

		//textarea
		String testTextAreaValue = egTestParamIni.getValue("TEXTAREA",testName);
		if(testName.endsWith("_rx"))
		{
			testTextAreaValue = "min_max_values";
		}
		StringTokenizer txtAreaTokens = new StringTokenizer(testTextAreaValue,",");
		while (txtAreaTokens.hasMoreTokens())
		{
			String eachTxtAreaCount = txtAreaTokens.nextToken();
			hmapTestParamDetails.put(eachTxtAreaCount.toLowerCase(),"textarea");
		}

		String[] defaultControl = egTestParamIni.getVariables("PARAM-CONTROL");
		List listDefaultControls = new ArrayList();
		if (defaultControl != null && defaultControl.length > 0)
		{
			for (int i=0;i<defaultControl.length;i++)
			{
				String strControls = (defaultControl[i]).toLowerCase();
				listDefaultControls.add(strControls);
			}
		}

		ArrayList aListTemp = getParameterList(reqTestVal,false);
		for (int i=0;i<aListTemp.size();i=i+2)
		{
			String strParamName = (String)aListTemp.get(i);
			String strSearch = strParamName.substring(1);
			strSearch = strSearch.toLowerCase();
			String strParamValue = (String)aListTemp.get(i+1);
			String controlName = null;

			boolean isParamExist = hmapTestParamDetails.containsKey(strSearch);
			if (isParamExist)
			{
				controlName = hmapTestParamDetails.get(strSearch).toString();
			}
			else if (listDefaultControls.contains(strSearch))
			{
				String tempName = strParamName.substring(1);
				controlName = egTestParamIni.getValue("PARAM-CONTROL",tempName.toLowerCase());
				if (controlName.indexOf("(") > -1 && controlName.indexOf(")") > -1)
				{
					String tempStrs = controlName.substring(controlName.indexOf("(")+1,controlName.length()-1);
					controlName = controlName.substring(0,controlName.indexOf("("));
					if (controlName.equals("select") && 
						!aListDynamicSelectOptionNameAndValue.contains(tempName))
					{
						aListDynamicSelectOptionNameAndValue.add(tempName);
						aListDynamicSelectOptionNameAndValue.add(tempStrs);
					}
					if (controlName.equals("radio") && 
						!aListDynamicRadioOptionNameAndValue.contains(tempName))
					{
						aListDynamicRadioOptionNameAndValue.add(strParamName.substring(1));
						aListDynamicRadioOptionNameAndValue.add(tempStrs);
					}
				}
			}
			else
			{
				controlName = "text";
			}

			aResultant.add(strParamName);
			aResultant.add(strParamValue);
			aResultant.add(controlName);
		}

		return aResultant;
	}

	private ArrayList getParameterList(String str,boolean needLowerCaseKey)
	{
		String delimiter = " -";
		ArrayList aListResultant = new ArrayList();
		String prevKey = "";

		str = str.substring(str.indexOf("-"));
		int spaceHyphenIdx = str.indexOf(delimiter);
		while (spaceHyphenIdx != -1)
		{
			String cutString = str.substring(0,spaceHyphenIdx);

			//This check will be carried out when the cutString contains only the key
			//for e.g.:-
			//str : -admin_password -103:98:88:90:79:76:81:-110:52 -ssl false
			//cutString : -admin_password
			if (cutString.trim().indexOf(" ") == -1)
			{
				String strPart1 = str.substring(cutString.length()+1);
				String strPart2 = strPart1.substring(0,strPart1.indexOf(delimiter));
				cutString = cutString+" "+strPart2;
				spaceHyphenIdx = cutString.length();
			}

			if (cutString.indexOf("\"") != -1)
			{
				String strAfterDoubleQuotes = str.substring(spaceHyphenIdx);
				String remainingPiece = strAfterDoubleQuotes.substring(0,strAfterDoubleQuotes.indexOf("\"")+1);
				cutString = cutString + remainingPiece;
				String key = cutString.substring(0,cutString.indexOf(" "));
				String value = cutString.substring(cutString.indexOf(" ")+1);
				if (needLowerCaseKey)
				{
					aListResultant.add(key.trim().toLowerCase());
				}
				else
				{
					aListResultant.add(key.trim());
				}
				aListResultant.add(value.trim());

				String remainingString = strAfterDoubleQuotes.substring(strAfterDoubleQuotes.indexOf("\"")+1);
				str = remainingString.trim();
				if (str.length() == 0)
				{
					spaceHyphenIdx = -1;
				}
				else
				{
					spaceHyphenIdx = str.indexOf(delimiter);
				}
			}
			else
			{
				if (cutString.startsWith("- "))
				{
					int idx = aListResultant.indexOf(prevKey);
					String strValue = (String)aListResultant.get(idx+1);
					strValue = strValue + " " + cutString;
					aListResultant.remove(idx+1);
					aListResultant.add(strValue);

					str = str.substring(cutString.length()+1);
				}
				else
				{
					String key = cutString.substring(0,cutString.indexOf(" "));
					String value = cutString.substring(cutString.indexOf(" ")+1);
					if(key.equals("-min_max_values"))
					{
						EgTablesInfo tablesInfo = new EgTablesInfo("manager");
						EgCompositeInfo compInfo = new EgCompositeInfo("manager");
						Hashtable ht = compInfo.getThresholdsForMeasures(pr_test);
						if(ht != null && !ht.isEmpty())
						{
							String new_value_rx = "";
							if(value.equalsIgnoreCase("none"))
							{
								ArrayList measureList = new ArrayList();
								measureList.addAll(ht.keySet());
								Collections.sort(measureList,String.CASE_INSENSITIVE_ORDER);
								Iterator itr = measureList.iterator();
								while(itr.hasNext())
								{
									JSONArray lowerRowDataArray = new JSONArray();
									String compMeasure = (String)itr.next();
									prMeasureArray.add(compMeasure);
									prMeasureDispnameArray.add(_mappingInfo.getMeasureDescription(pr_test,compMeasure));
									Hashtable ht1 = (Hashtable)ht.get(compMeasure);
									Iterator itr1 = ht1.keySet().iterator();
									while(itr1.hasNext())
									{
										JSONObject lowerRowData = new JSONObject();
										String tm = (String)itr1.next();
										int idx = tm.indexOf(":");
										String t = tm.substring(0,idx);									
										String m = tm.substring(idx+1);
										String thresholds = (String)ht1.get(tm);
										idx = thresholds.indexOf(":");
										String min = thresholds.substring(0,idx);
										String max = thresholds.substring(idx+1);

										new_value_rx+="~~"+compMeasure+"~"+t+"~"+m+"~"+min+"~"+max;

										lowerRowData.put("pr_measure_name",compMeasure);										
										lowerRowData.put("associated_test_name",t);
										lowerRowData.put("associated_test_description",_mappingInfo.getTestDescription(t));
										lowerRowData.put("associated_measure_name",m);
										lowerRowData.put("associated_measure_description",_mappingInfo.getMeasureDescription(t,m) +" ("+tablesInfo.getUnitForMeasure(t,m)+")");
										if(min.equals("-1"))
										{
											lowerRowData.put("associated_measure_min_threshold","None");
										}
										else
										{
											lowerRowData.put("associated_measure_min_threshold",min);
										}
										if(max.equals("-1"))
										{
											lowerRowData.put("associated_measure_max_threshold","None");
										}
										else
										{
											lowerRowData.put("associated_measure_max_threshold",max);
										}
										lowerRowDataArray.add(lowerRowData);
									}
									prMeasureObject.put(compMeasure,lowerRowDataArray);
								}
							}
							else
							{
								String arrayOut[] = StringUtils.getTokens(value.trim(),"~~");
								for(int i=0;i<arrayOut.length;i++)
								{
									String str1 = arrayOut[i].trim();
									String array[] = StringUtils.getTokens(str1,"~");
									if(array != null && array.length==5)
									{
										String prm = array[0].trim();
										String t = array[1].trim();
										String m = array[2].trim();
										String min = array[3].trim();
										String max = array[4].trim();
										if(min.equals("-1"))
											min="None";
										if(max.equals("-1"))
											max="None";
										if(ht.containsKey(prm))
										{
											Hashtable ht1 = (Hashtable)ht.get(prm);
											ht1.put((t+":"+m),min+":"+max);
										}
									}
								}
								ArrayList measureList = new ArrayList();
								measureList.addAll(ht.keySet());
								Collections.sort(measureList,String.CASE_INSENSITIVE_ORDER);
								Iterator itr = measureList.iterator();
								while(itr.hasNext())
								{
									JSONArray lowerRowDataArray = new JSONArray();
									String compMeasure = (String)itr.next();
									prMeasureArray.add(compMeasure);
									prMeasureDispnameArray.add(_mappingInfo.getMeasureDescription(pr_test,compMeasure));
									Hashtable ht1 = (Hashtable)ht.get(compMeasure);
									Iterator itr1 = ht1.keySet().iterator();
									while(itr1.hasNext())
									{
										JSONObject lowerRowData = new JSONObject();
										String tm = (String)itr1.next();
										int idx = tm.indexOf(":");
										String t = tm.substring(0,idx);									
										String m = tm.substring(idx+1);
										String thresholds = (String)ht1.get(tm);
										idx = thresholds.indexOf(":");
										String min = thresholds.substring(0,idx);
										String max = thresholds.substring(idx+1);

										new_value_rx+="~~"+compMeasure+"~"+t+"~"+m+"~"+min+"~"+max;

										lowerRowData.put("pr_measure_name",compMeasure);										
										lowerRowData.put("associated_test_name",t);
										lowerRowData.put("associated_test_description",_mappingInfo.getTestDescription(t));
										lowerRowData.put("associated_measure_name",m);
										lowerRowData.put("associated_measure_description",_mappingInfo.getMeasureDescription(t,m) +" ("+tablesInfo.getUnitForMeasure(t,m)+")");
										if(min.equals("-1")) {
											lowerRowData.put("associated_measure_min_threshold","None");
										}
										else {
											lowerRowData.put("associated_measure_min_threshold",min);
										}
										if(max.equals("-1")) {
											lowerRowData.put("associated_measure_max_threshold","None");
										}
										else {
											lowerRowData.put("associated_measure_max_threshold",max);
										}
										lowerRowDataArray.add(lowerRowData);
									}
									prMeasureObject.put(compMeasure,lowerRowDataArray);
								}
							}
							if(new_value_rx.startsWith("~~"))
							{
								value = new_value_rx.substring(2);
							}
						}
					}
					if (needLowerCaseKey)
					{
						aListResultant.add(key.trim().toLowerCase());
						prevKey = key.trim().toLowerCase();
					}
					else
					{
						aListResultant.add(key.trim());
						prevKey = key.trim();
					}
					aListResultant.add(value.trim());

					str = str.substring(spaceHyphenIdx+1);
				}
				spaceHyphenIdx = str.indexOf(delimiter);
			}
		}

		if (str.length() > 0)
		{
			if (str.startsWith("- "))
			{
				int idx = aListResultant.indexOf(prevKey);
				String strValue = (String)aListResultant.get(idx+1);
				strValue = strValue + " " + str;
				aListResultant.remove(idx+1);
				aListResultant.add(strValue);
			}
			else
			{
				String lastKey = str.substring(0,str.indexOf(" "));
				String lastValue = str.substring(str.indexOf(" ")+1);
				if (needLowerCaseKey)
				{
					aListResultant.add(lastKey.trim().toLowerCase());
				}
				else
				{
					aListResultant.add(lastKey.trim());
				}
				aListResultant.add(lastValue.trim());
			}
		}
		return aListResultant;
	}

	public String removeNull(String componentName)
	{
		if (componentName != null && componentName.length()>0)
		{
			return (componentName.endsWith(":NULL"))?componentName.substring(0,componentName.indexOf(":NULL")):componentName;
		}
		else
		{
			return "";
		}
	}

	//provide a set of agents(internal or remote agent,external agent(s)) for a component
	private List getAgents(String componentName)
	{
		List agentsList = new ArrayList();

		Hashtable internalAgentMap = egExternalInfo.getInternalAgentMap();
		String componentNickName = componentName.substring(0,componentName.indexOf(":"));
		String agentNickName = "";
		boolean isRemote = false;

		//To fetch the exact agent for the selected component - start
		isRemote = egExternalInfo.isRemoteBased(componentNickName);
		if (isRemote)
		{
			//Agentless
			agentNickName = egExternalInfo.getRemoteAgentForHost(componentNickName);
		}
		else
		{
			//Auto or Manual
			String agentName = egExternalInfo.getAgentFor(componentNickName);

			if (agentName != null) //Manual
			{
				if (internalAgentMap != null && internalAgentMap.containsKey(agentName))
				{
					agentNickName = (String)internalAgentMap.get(agentName);
				}
				else
				{
					agentNickName = agentName;
				}
			}
			else //Auto
			{
				agentNickName = componentNickName;
			}
		}

		//adding an internal agent (or) a remote agent
		agentsList.add(agentNickName);
		//To fetch the exact agent for the selected component - end

		//To fetch the external agent for the selected component type - starts
		boolean hasExternalAgent = egExternalInfo.hasExternalAgent(componentNickName);
		if (hasExternalAgent)
		{
			String extAgents[] = egExternalInfo.getExternalAgentsForHost(componentNickName);
			//adding one or more external agent(s)
			agentsList.addAll(Arrays.asList(extAgents));
		}
		//To fetch the external agent for the selected component type - ends

		return agentsList;
	}

	//provide a set of agents (internal or remote agent,external agent(s)) for a component
	private Hashtable getAgentsList(String componentType,String componentName)
	{
		Hashtable ht_agentsList = new Hashtable();

		boolean compNamehasOnlyExternalAgents = listExternalServerTypes.contains(componentType);

		Hashtable internalAgentMap = egExternalInfo.getInternalAgentMap();
		String componentNickName = componentName.substring(0,componentName.indexOf(":"));
		String agentNickName = "";

		if (!compNamehasOnlyExternalAgents)
		{
			boolean isRemote = false;
			//To fetch the exact agent for the selected component - start
			isRemote = egExternalInfo.isRemoteBased(componentNickName);
			if (isRemote)
			{
				//Agentless
				agentNickName = egExternalInfo.getRemoteAgentForHost(componentNickName);
				ht_agentsList.put("REMOTE AGENT",agentNickName);
			}
			else
			{
				//Auto or Manual
				String agentName = egExternalInfo.getAgentFor(componentNickName);
				if (agentName != null) //Manual
				{
					if (internalAgentMap != null && internalAgentMap.containsKey(agentName))
					{
						agentNickName = (String)internalAgentMap.get(agentName);
					}
					else
					{
						agentNickName = agentName;
					}
				}
				else //Auto
				{
					agentNickName = componentNickName;
				}
				ht_agentsList.put("INTERNAL AGENT",agentNickName);
			}
			//To fetch the exact agent for the selected component - end
		}

		//To fetch the external agent for the selected component type - starts
		boolean hasExternalAgent = egExternalInfo.hasExternalAgent(componentNickName);
		if (hasExternalAgent)
		{
			String extAgents[] = egExternalInfo.getExternalAgentsForHost(componentNickName);
			//adding one or more external agent(s)
			ArrayList aListExtAgents = new ArrayList(Arrays.asList(extAgents));
			String strExtAgents = aListExtAgents.toString();
			strExtAgents = strExtAgents.substring(1,strExtAgents.length()-1);
			ht_agentsList.put("EXTERNAL AGENT",strExtAgents);
		}
		//To fetch the external agent for the selected component type - ends

		return ht_agentsList;
	}

	//Will provide the right agent (subject) for a component and its test
	private String getAgentNickName(String componentType,String testName,List listAgents)
	{
		boolean isExternalTest = egSpecs.isExternalTest(testName,componentType);
		String agentName = null;
		if (isExternalTest)
		{
			//external agent for external test
			if (listAgents != null && listAgents.size() > 0 )
			{
				agentName = (String)listAgents.get(1);
			}
		}
		else
		{
			//internal agent or remote agent for host level test and application level test.
			if (listAgents != null && listAgents.size() > 0 )
			{
				agentName = (String)listAgents.get(0);
			}
		}

		return agentName;
	}

	//Will provide the right pattern (variable) for a component
	private String getResultantPattern(String componentType,String componentName,String testName,String[] testVariables)
	{
		String tempResultantPattern = null;
		String componentNickName = componentName.substring(0,componentName.indexOf(":"));
		String specificPattern_A = testName + ":" + componentType + ":" + componentName;
		String specificPattern_B = testName + ":" + componentType + ":" + componentNickName;
		String defaultPattern_A = testName + "::" + componentName;
		String defaultPattern_B = testName + "::" + componentNickName;

		List listTestVariables = Arrays.asList(testVariables);
		if(listTestVariables.contains(specificPattern_A))
		{
			tempResultantPattern = specificPattern_A;
		}
		else if(listTestVariables.contains(specificPattern_B))
		{
			tempResultantPattern = specificPattern_B;
		}
		else if(listTestVariables.contains(defaultPattern_A))
		{
			tempResultantPattern = defaultPattern_A;
		}
		else if(listTestVariables.contains(defaultPattern_B))
		{
			tempResultantPattern = defaultPattern_B;
		}

		return tempResultantPattern;
	}

	public boolean hasUnConfiguredParam(String paramValue,boolean hasPasswordParam,ArrayList aListPasswordParameters,ArrayList aListTcKeywordsLowerCase,ArrayList aListDefaultPasswordParameters)
	{
		boolean hasUnconfiguredParam = false;
		StringTokenizer st = new StringTokenizer(paramValue,",");
		st.nextToken();
		ArrayList aListParamNameValue = getParameterList(st.nextToken(),true);

		String snmpVersion = null;
		boolean isSnmp = aListParamNameValue.contains("-snmpversion");

		if (isSnmp)
		{
			//put snmp version before snmp community.
			int snmpCommunityIdx = aListParamNameValue.indexOf("-snmpcommunity");
			String snmpCommunityVal = (String)aListParamNameValue.get(snmpCommunityIdx+1);
			aListParamNameValue.remove(snmpCommunityIdx);
			aListParamNameValue.remove(snmpCommunityIdx);

			int snmpVerIdx = aListParamNameValue.indexOf("-snmpversion");
			snmpVersion = (String)aListParamNameValue.get(snmpVerIdx+1);

			aListParamNameValue.add(snmpVerIdx+2,"-snmpcommunity");
			aListParamNameValue.add(snmpVerIdx+3,snmpCommunityVal);
		}

		for (int i=0;i<aListParamNameValue.size();i=i+2)
		{
			String strParamName = (String)aListParamNameValue.get(i);
			String strParamValue = (String)aListParamNameValue.get(i+1);

			if (hasPasswordParam)
			{
				if (aListPasswordParameters.contains(strParamName))
				{
					continue;
				}
			}
			else if (aListDefaultPasswordParameters != null && aListDefaultPasswordParameters.contains(strParamName.toLowerCase()))
			{
				continue;
			}

			if (isSnmp && snmpVersion != null)
			{
				if (snmpVersion.equalsIgnoreCase("v3"))
				{
					if (strParamName.equalsIgnoreCase("-snmpcommunity"))
					{
						continue;
					}
				}
			}

			strParamValue = strParamValue.trim();
			if (strParamValue.startsWith("$") && aListTcKeywordsLowerCase.contains(strParamValue.toLowerCase()))
			{
				hasUnconfiguredParam = true;
				break;
			}
		}

		return hasUnconfiguredParam;
	}

	public boolean isParameter(String encryptParam)
	{
		String decryptParam = EgCrypt.decrypt(encryptParam);
		if (decryptParam.equals(encryptParam)) // not password
		{
			return (true);
		}
		return false;
	}

	//private boolean isItemExists(List searchList, String compValue)
	//{
		//Iterator i = searchList.iterator();
		//while (i.hasNext())
		//{
			//String nextStr = (String) i.next();
			//if(compValue.indexOf(nextStr) != -1 || (compValue.toUpperCase().indexOf(nextStr.toUpperCase())) != -1)
			//{
				//return true;
			//}
		//}
		//return false;
	//}
%>

<%
	List tmpParamContinue1 = Arrays.asList(processParamremoteContinue);
	String strprocessParamremoteContinue1 = StringUtils.getString(tmpParamContinue1);
	rootJson.put("processParamremoteContinue",strprocessParamremoteContinue1);

	List tmpParamContinue2 = Arrays.asList(snmpV1V2ParamToContinue);
	String snmpV1V2ParamToContinue2 = StringUtils.getString(tmpParamContinue2);
	rootJson.put("snmpV1V2ParamToContinue",snmpV1V2ParamToContinue2);

	List tmpParamContinue3 = Arrays.asList(snmpV3ParamToContinue);
	String snmpV3ParamToContinue3 = StringUtils.getString(tmpParamContinue3);
	rootJson.put("snmpV3ParamToContinue",snmpV3ParamToContinue3);

	List tmpParamContinue4 = Arrays.asList(multiUserReadOnlyParam);
	String multiUserReadOnlyParam4 = StringUtils.getString(tmpParamContinue4);
	rootJson.put("multiUserReadOnlyParam",multiUserReadOnlyParam4);
	
	List tmpParamContinue5 = Arrays.asList(multiNameReadOnlyParam);
	String multiNameReadOnlyParam5 = StringUtils.getString(tmpParamContinue5);
	rootJson.put("multiNameReadOnlyParam",multiNameReadOnlyParam5);

	List tmpParamContinue6 = Arrays.asList(modeTrueToContinue);
	String modeTrueToContinue6 = StringUtils.getString(tmpParamContinue6);
	rootJson.put("modeTrueToContinue",modeTrueToContinue6);
	
	List tmpParamContinue7 = Arrays.asList(modeFalseToContinue);
	String modeFalseToContinue7 = StringUtils.getString(tmpParamContinue7);
	rootJson.put("modeFalseToContinue",modeFalseToContinue7);

	List tmpParamContinue8 = Arrays.asList(measureModeTrueToContinue);
	String measureModeTrueToContinue8 = StringUtils.getString(tmpParamContinue8);
	rootJson.put("measureModeTrueToContinue",measureModeTrueToContinue8);

	List tmpParamContinue9 = Arrays.asList(measureModeFalseToContinue);
	String measureModeFalseToContinue9 = StringUtils.getString(tmpParamContinue9);
	rootJson.put("measureModeFalseToContinue",measureModeFalseToContinue9);
	
	List tmpParamContinue10 = Arrays.asList(measurementModeTrueToContinue);
	String measurementModeTrueToContinue10 = StringUtils.getString(tmpParamContinue10);
	rootJson.put("measurementModeTrueToContinue",measurementModeTrueToContinue10);

	List tmpParamContinue11 = Arrays.asList(measurementModeFalseToContinue);
	String measurementModeFalseToContinue11 = StringUtils.getString(tmpParamContinue11);
	rootJson.put("measurementModeFalseToContinue",measurementModeFalseToContinue11);

	List tmpParamContinue12 = Arrays.asList(targetDiskIORateLabel);
	String targetDiskIORateLabel12 = StringUtils.getString(tmpParamContinue12);
	rootJson.put("targetDiskIORateLabel",targetDiskIORateLabel12);

	List tmpParamContinue13 = Arrays.asList(paramsNeededToDoValidation);
	String paramsNeededToDoValidation13 = StringUtils.getString(tmpParamContinue13);
	rootJson.put("paramsNeededToDoValidation",paramsNeededToDoValidation13);

	List tmpParamContinue14 = Arrays.asList(targetDiskIORateValue);
	String targetDiskIORateValue14 = StringUtils.getString(tmpParamContinue14);
	rootJson.put("targetDiskIORateValue",targetDiskIORateValue14);

	List tmpParamContinue15 = Arrays.asList(multiOidsReadOnlyParam);
	String multiNameReadOnlyParam15 = StringUtils.getString(tmpParamContinue15);
	rootJson.put("multiOidsReadOnlyParam",multiNameReadOnlyParam15);

	List tmpParamContinue = Arrays.asList(paramToContinue);
	String strParamContinue = StringUtils.getString(tmpParamContinue);
	rootJson.put("paramToContinue",strParamContinue);

	if(remoteControlEnabled)
	{
		String displayNick = componentName;
		if(componentName.indexOf(":")>0)
		{
			displayNick = displayNick.substring(0,displayNick.indexOf(":"));
		}
		Hashtable ht = egDisc.getNickIpMap();
		String agentIP = "";
		if(ht != null && ht.size()>0)
		{
			agentIP = (String)ht.get(displayNick);
		}
	}

	//String popup_topright = isMSIE6?"popup_topright_noshade":"popup_topright";
	//String popup_rightbg = isMSIE6?"popup_rightbg_noshade":"popup_rightbg";
	//String popup_bottomleft = isMSIE6?"popup_bottomleft_noshade":"popup_bottomleft";
	//String popup_bottombg = isMSIE6?"popup_bottombg_noshade":"popup_bottombg";
	//String popup_bottomright = isMSIE6?"popup_bottomright_noshade":"popup_bottomright";

	if (componentType!=null && !componentType.equals("") && !componentType.equals("-1"))
	{
		String edUrl = "";
		if (componentName!=null && !componentName.equals("") && !componentName.equals("-1"))
		{
			String labelMsg = "<table width='100%' height='15px'><tr><td align='right' valign='bottom' class='font_normal11'><a class='eg_monlink' href='javascript:me.goToEnableDisableTestpage();' style='text-decoration:none;'><span class='font_bold11'>Click here</span>&nbsp;<img src='/final/images/spacer.gif' class='iconClickHere' border='0'>&nbsp;</a><span>"+_mapping.getTextDescription("admin.test.to enable and disable performance tests for")+"&nbsp;"+_mapping.getComponentTypeDescription(componentType)+"</span> </td></tr></table>";
			edUrl = "/final/admin/EgEnableDisableTests.jsp?componentType="+componentType+"&testType="+testType+"&showBackButton=true&componentName="+EgURLEncoder.encode(componentName,"UTF-8")+"&from=SpecificTestConfig&clickedFrom="+clickedFrom+"&showUnconfigCompType="+showUnconfigCompType;
			rootJson.put("enableDisableTestPageLink",edUrl);
			rootJson.put("enableDisableTestPageLabel",labelMsg);
		}
		else
		{
			String labelMsg = "<table width='100%' height='15px'><tr><td align='right' valign='bottom' class='font_normal11'><a class='eg_monlink' href='javascript:me.goToEnableDisableTestpage();' style='text-decoration:none;'><span class='font_bold11'>Click here</span>&nbsp;<img src='/final/images/spacer.gif' class='iconClickHere' border='0'></a>&nbsp;<span>"+_mapping.getTextDescription("admin.test.to enable and disable performance tests")+"</span> </td></tr></table>";

			edUrl = "/final/admin/EgEnableDisableTests.jsp?componentType="+componentType+"&testType="+testType+"&showBackButton=true&from=SpecificTestConfig&clickedFrom="+clickedFrom+"&showUnconfigCompType="+showUnconfigCompType;
			rootJson.put("enableDisableTestPageLink",edUrl);
			rootJson.put("enableDisableTestPageLabel",labelMsg);
		}

		String tempLbl = "";
		if (isConfigSupported)
		{
			if (testType.equalsIgnoreCase("PerformanceTest"))
			{
				tempLbl = "<table width='100%' height='15px'><tr><td align='right' valign='bottom' class='font_normal11'><a class='eg_monlink' href='javascript:me.goToEnableDisableTestpage();' style='text-decoration:none;'><span class='font_bold11'>Click here</span>&nbsp;<img src='/final/images/spacer.gif' class='iconClickHere' border='0'></a>&nbsp;<span>"+_mapping.getTextDescription("admin.test.to enable and disable performance tests for")+"&nbsp;"+_mapping.getComponentTypeDescription(componentType)+"</span></td></tr></table>";

				rootJson.put("enableDisableTestPageLabel",tempLbl);
			}
			else
			{
				tempLbl = "<table width='100%' height='15px'><tr><td align='right' valign='bottom' class='font_normal11'><a class='eg_monlink' href='javascript:me.goToEnableDisableTestpage();' style='text-decoration:none;'><span class='font_bold11'>Click here</span>&nbsp;<img src='/final/images/spacer.gif' class='iconClickHere' border='0'></a>&nbsp;<span>"+_mapping.getTextDescription("admin.test.to enable and disable configuration tests for")+"&nbsp;"+_mapping.getComponentTypeDescription(componentType)+"</span></td></tr></table>";
				rootJson.put("enableDisableTestPageLabel",tempLbl);
			}
		}
		else
		{
			tempLbl = "<table width='100%' height='15px'><tr><td align='right' valign='bottom' class='font_normal11'><a class='eg_monlink' href='javascript:me.goToEnableDisableTestpage();' style='text-decoration:none;'><span class='font_bold11'>Click here</span>&nbsp;<img src='/final/images/spacer.gif' class='iconClickHere' border='0'></a>&nbsp;<span>"+_mapping.getTextDescription("admin.test.to enable and disable tests for")+"&nbsp;"+_mapping.getComponentTypeDescription(componentType)+"</span></td></tr></table>";
			rootJson.put("enableDisableTestPageLabel",tempLbl);
		}
	}
	else
	{
		if (isConfigSupported)
		{
			if (testType.equalsIgnoreCase("PerformanceTest"))
			{
				String labelMsg = "<table width='100%' height='15px'><tr><td align='right' valign='bottom' class='font_normal11'><a class='eg_monlink' href='javascript:me.goToEnableDisableTestpage();' style='text-decoration:none;'><span class='font_bold11'>Click here</span>&nbsp;<img src='/final/images/spacer.gif' class='iconClickHere' border='0'></a>&nbsp;<span>"+_mapping.getTextDescription("admin.test.to enable and disable performance tests")+"</span> </td></tr></table>";

				rootJson.put("enableDisableTestPageLink","/final/admin/EgEnableDisableTests.jsp?testType=PerformanceTest&showBackButton=true&from=SpecificTestConfig&clickedFrom="+clickedFrom+"&showUnconfigCompType="+showUnconfigCompType);
				rootJson.put("enableDisableTestPageLabel",labelMsg);
			}
			else
			{
				String labelMsg = "<table width='100%' height='15px'><tr><td align='right' valign='bottom' class='font_normal11'><a class='eg_monlink' href='javascript:me.goToEnableDisableTestpage();' style='text-decoration:none;'><span class='font_bold11'>Click here</span>&nbsp;<img src='/final/images/spacer.gif' class='iconClickHere' border='0'></a>&nbsp;<span>"+_mapping.getTextDescription("admin.test.to enable and disable configuration tests")+"</span> </td></tr></table>";

				rootJson.put("enableDisableTestPageLink","/final/admin/EgEnableDisableTests.jsp?testType=ConfigurationTest&showBackButton=true&from=SpecificTestConfig&clickedFrom="+clickedFrom+"&showUnconfigCompType="+showUnconfigCompType);
				rootJson.put("enableDisableTestPageLabel",labelMsg);
			}
		}
		else
		{
			String labelMsg = "<table width='100%' height='15px'><tr><td align='right' valign='bottom' class='font_normal11'><a class='eg_monlink' href='javascript:me.goToEnableDisableTestpage();' style='text-decoration:none;'><span class='font_bold11'>Click here</span>&nbsp;<img src='/final/images/spacer.gif' class='iconClickHere' border='0'></a>&nbsp;<span>"+_mapping.getTextDescription("admin.test.to enable and disable tests")+"</span> </td></tr></table>";

			rootJson.put("enableDisableTestPageLink","/final/admin/EgEnableDisableTests.jsp?showBackButton=true&from=SpecificTestConfig&clickedFrom="+clickedFrom+"&showUnconfigCompType="+showUnconfigCompType);
			rootJson.put("enableDisableTestPageLabel",labelMsg);
		}
	}

	if (componentType!=null && !componentType.equals("-1") && egSpecs.getTestsForServer(componentType) == null)
	{
		isAtleastOneTestEnabled = false;
	}
	rootJson.put("isAtleastOneTestEnabled",isAtleastOneTestEnabled);

	//JSONObject compNameObj = new JSONObject();
	//JSONArray compNameArr = new JSONArray();
	if (listOfComponents != null && listOfComponents.size() > 0)
	{
		//if (strSearch ==null || strSearch.equalsIgnoreCase("") ||strSearch.equalsIgnoreCase("Search") )
		{
			compNameObj.put("valueField","-1");
			compNameObj.put("displayField",_mapping.getTextDescription("admin.common.Choose a component"));
			compNameArr.add(compNameObj);
		}
	}
	else
	{
		compNameObj.put("valueField","-1");
		compNameObj.put("displayField",_mapping.getTextDescription("admin.common.Not Applicable"));
		compNameArr.add(compNameObj);
	}

	//get the list of components for the particular component type
	if (componentType != null && componentType.length() > 0)
	{
		String tempComponentName = "";
		//int checkSearchItem = -1;
		//int checkComponentSearchItem = 0;
		String component = request.getParameter("componentName");
		for (int i=0; i<listOfComponents.size(); i++)
		{
			String eachComp = (String)listOfComponents.get(i);
			String port = eachComp.substring(eachComp.lastIndexOf(":")+1,eachComp.length());
			String compValue = eachComp.substring(eachComp.indexOf(":") + 1);

			if (isOracleDatabaseCompType)
			{
				tempComponentName = eachComp.substring(eachComp.indexOf(":")+1,eachComp.length());
			}
			else
			{
				if (port.equalsIgnoreCase("NULL"))
				{
					tempComponentName = eachComp.substring(eachComp.indexOf(":") + 1, eachComp.lastIndexOf(":"));
				}
				else
				{
					tempComponentName = eachComp.substring(eachComp.indexOf(":") + 1);
				}
			}

			//if (searchList != null && searchList.size() > 0)
			//{
				//if (isItemExists(searchList,compValue))
				//{
					//if (checkSearchItem == -1)
					//{
						//compNameObj.put("valueField","-1");
						//compNameObj.put("displayField",_mapping.getTextDescription("admin.common.Choose a component"));
						//compNameArr.add(compNameObj);
					//}
					//checkSearchItem = 1;
					//checkComponentSearchItem = 1;
					//compNameObj.put("valueField",compValue);
					//compNameObj.put("displayField",tempComponentName);
					//compNameArr.add(compNameObj);

					//if (compValue.equals(component))
					//{
						//rootJson.put("selectedCompName",compValue);
					//}
				//}
			//}
			//else
			{
				compNameObj.put("valueField",compValue);
				compNameObj.put("displayField",tempComponentName);
				compNameArr.add(compNameObj);
				if (compValue.equals(component))
				{
					rootJson.put("selectedCompName",compValue);
				}
			}
		}
	}

	rootJson.put("compNameArr",compNameArr);
	

	//boolean isUnconfiguredTestPopupEnabled = false;
	//String strPopup = null;
	//if (servicesIniFile != null)
	//{
		//strPopup = servicesIniFile.getValue("MISC_ARGS","ShowUnconfiguredTestsInPopup");
	//}

	//if (strPopup != null && strPopup.equalsIgnoreCase("true"))
	//{
		//isUnconfiguredTestPopupEnabled = true;
	//}

	//if (isUnconfiguredTestPopupEnabled)
	//{
		//EgTestSpecification egTestSpecification = null;
		//List listUnconfiguredComponents = ri.getAllServers();
		//boolean hasManagedComponents = listUnconfiguredComponents!=null && listUnconfiguredComponents.size() > 0 ? true:false;
		//boolean hasUnConfiguredTests = false;
		//int unConfiguredTestsCount = 0;
		//if (hasManagedComponents)
		//{
			//egTestSpecification = new EgTestSpecification(listUnconfiguredComponents);
			//if (_user != null && EgInstallInfo.isConfigSupported)
			//{
				//egTestSpecification.setConfigSupported(isConfigSupported);
			//}
			//TreeMap tmapUnConfigTests = egTestSpecification.getUnconfiguredTest();
			//unConfiguredTestsCount = egTestSpecification.getTotalUnconfiguredTestsCount();
			//hasUnConfiguredTests = (unConfiguredTestsCount > 0)?true:false;
		//}

		//if (hasUnConfiguredTests)
		//{
			//String showPopup = request.getParameter("showPopup");
			//if (showPopup == null)
			//{
				//showPopup = "true";
			//}
		//}
	//}

	if (!ht_AgentsList.isEmpty())
	{
		EgTesterInfo testerInfo = new EgTesterInfo("manager");
		boolean externalAgentRunsAllAggTests = testerInfo.externalAgentRunsAllAggTests();
		String agentType = "";
		String mainAgent = "";
		String externalAgents = (String)ht_AgentsList.get("EXTERNAL AGENT");
		if (externalAgents.length() > 110)
		{
			StringTokenizer st = new StringTokenizer(externalAgents,",");
			String str = "";
			int count = 0;
			while (st.hasMoreTokens())
			{
				count++;
				String temp = st.nextToken();
				temp = temp + ",";
				if (count%7 == 0)
				{
					temp = temp + "\n";
				}
				str = str + temp;
			}
			externalAgents = str.substring(0,str.length()-2);
		}
		if (ht_AgentsList.containsKey("INTERNAL AGENT"))
		{
			agentType = "INTERNAL AGENT";
			mainAgent = (String)ht_AgentsList.get(agentType);
		}
		else if (ht_AgentsList.containsKey("REMOTE AGENT"))
		{
			agentType = "REMOTE AGENT";
			mainAgent = (String)ht_AgentsList.get(agentType);
		}
		JSONObject agentDetailsObj = new JSONObject();
		JSONArray agentDetailsArr = new JSONArray();
		if(componentType.startsWith("Agg_"))
		{
			if (agentType.equals("REMOTE AGENT"))
			{
				agentDetailsObj.put("AgentType",_mapping.getTextDescription("admin.test.REMOTE AGENT"));
				remoteAgent = mainAgent;
				agentDetailsObj.put("AgentsName",mainAgent);
				agentDetailsArr.add(agentDetailsObj);
			}
			else
			{
				agentDetailsObj.put("AgentType",_mapping.getTextDescription("admin.test.EXTERNAL AGENT"));
				agentDetailsObj.put("AgentsName",externalAgents);
				agentDetailsArr.add(agentDetailsObj);
			}
		}
		else
		{
			if (agentType.equals("INTERNAL AGENT") || agentType.equals("REMOTE AGENT"))
			{
				if (agentType.equals("INTERNAL AGENT"))
				{
					agentDetailsObj.put("AgentType",_mapping.getTextDescription("admin.test.INTERNAL AGENT"));
				}
				else
				{
					agentDetailsObj.put("AgentType",_mapping.getTextDescription("admin.test.REMOTE AGENT"));
				}
				remoteAgent = mainAgent;
				agentDetailsObj.put("AgentsName",mainAgent);
				agentDetailsArr.add(agentDetailsObj);
			}

			if (!StringUtils.isNull(componentType) && !componentType.equals("Real_user_monitor") && !componentType.startsWith("Agg_"))
			{
				agentDetailsObj.put("AgentType",_mapping.getTextDescription("admin.test.EXTERNAL AGENT(S)"));
				agentDetailsObj.put("AgentsName",externalAgents);
				agentDetailsArr.add(agentDetailsObj);
			}
		}
		rootJson.put("remoteAgent",remoteAgent);
		rootJson.put("agentDetailsArr",agentDetailsArr);
	}

	if (isAtleastOneTestEnabled)
	{
		String tempMsg = "";
		//This condition will be fired only when the component is managed in an agentless manner
		if (componentType != null && !componentType.equals("") && componentName != null && !componentName.equals("-1") && !componentName.equals(""))
		{
			if (unconfiguredTestList != null && unconfiguredTestList.isEmpty() && 
				defaultconfiguredTestList != null && defaultconfiguredTestList.isEmpty() && 
				userconfiguredTestList != null && userconfiguredTestList.isEmpty() && 
				excludedTestList != null && excludedTestList.isEmpty())
			{
				if (isConfigSupported)
				{
					if (ht_AgentsList != null && ht_AgentsList.containsKey("REMOTE AGENT"))
					{
						if (testType.equalsIgnoreCase("PerformanceTest"))
						{
							tempMsg = "<table align='center'><tr><td align='center' height='50'><table><tr><td align='center'><img src='/final/admin/eg_images/spacer.gif' class='iconInformation'></td></tr><tr><td align='center' class='commonErrorMsgText'>"+removeNull(componentName)+"&nbsp;"+_mapping.getTextDescription("admin.test.is managed in an agentless manner")+".&nbsp;"+_mapping.getTextDescription("admin.test.No agentless performance tests are currently available for this component")+".</td></tr></table></td></tr></table>";
							//rootJson.put("NoAgentMsg",removeNull(componentName)+"&nbsp;"+_mapping.getTextDescription("admin.test.is managed in an agentless manner")+".&nbsp;"+_mapping.getTextDescription("admin.test.No agentless performance tests are currently available for this component")+".");
							rootJson.put("NoAgentMsg",tempMsg);
						}
						else
						{
							tempMsg = "<table align='center'><tr><td align='center' height='50'><table><tr><td align='center'><img src='/final/admin/eg_images/spacer.gif' class='iconInformation'></td></tr><tr><td align='center' class='commonErrorMsgText'>"+removeNull(componentName)+"&nbsp;"+_mapping.getTextDescription("admin.test.is managed in an agentless manner")+".&nbsp;"+_mapping.getTextDescription("admin.test.No agentless configuration tests are currently available for this component")+".</td></tr></table></td></tr></table>";
							//rootJson.put("NoAgentMsg",removeNull(componentName)+"&nbsp;"+_mapping.getTextDescription("admin.test.is managed in an agentless manner")+".&nbsp;"+_mapping.getTextDescription("admin.test.No agentless configuration tests are currently available for this component")+".");
							rootJson.put("NoAgentMsg",tempMsg);
						}
					}
					else
					{
						if (testType.equalsIgnoreCase("PerformanceTest"))
						{
							tempMsg = "<table align='center'><tr><td align='center' height='50'><table><tr><td align='center'><img src='/final/admin/eg_images/spacer.gif' class='iconInformation'></td></tr><tr><td align='center' class='commonErrorMsgText'>'"+_mapping.getTextDescription("admin.test.Performance test(s) is/are currently not available for configuration for")+"&nbsp;"+removeNull(componentName)+".&nbsp;"+_mapping.getTextDescription("admin.test.Please wait for the system configurations to be updated and try again after a few minutes")+".</td></tr></table></td></tr></table>";
							rootJson.put("NoAgentMsg",tempMsg);
						}
						else
						{
							tempMsg = "<table align='center'><tr><td align='center' height='50'><table><tr><td align='center'><img src='/final/admin/eg_images/spacer.gif' class='iconInformation'></td></tr><tr><td align='center' class='commonErrorMsgText'>"+_mapping.getTextDescription("admin.test.Configuration test(s) is/are currently not available for configuration for")+"&nbsp;"+removeNull(componentName)+".&nbsp;"+_mapping.getTextDescription("admin.test.Please wait for the system configurations to be updated and try again after a few minutes")+".</td></tr></table></td></tr></table>";
							rootJson.put("NoAgentMsg",tempMsg);
						}
					}
				}
				else
				{
					if (ht_AgentsList != null && ht_AgentsList.containsKey("REMOTE AGENT"))
					{
						tempMsg = "<table align='center'><tr><td align='center' height='50'><table><tr><td align='center'><img src='/final/admin/eg_images/spacer.gif' class='iconInformation'></td></tr><tr><td align='center' class='commonErrorMsgText'>"+removeNull(componentName)+"&nbsp;"+_mapping.getTextDescription("admin.test.is managed in an agentless manner")+".&nbsp;"+_mapping.getTextDescription("admin.test.No agentless tests are currently available for this component")+".</td></tr></table></td></tr></table>";
						rootJson.put("NoAgentMsg",tempMsg);
					}
					else
					{
						tempMsg = "<table align='center'><tr><td align='center' height='50'><table><tr><td align='center'><img src='/final/admin/eg_images/spacer.gif' class='iconInformation'></td></tr><tr><td align='center' class='commonErrorMsgText'>"+_mapping.getTextDescription("admin.test.Test(s) is/are currently not available for configuration for")+"&nbsp;"+removeNull(componentName)+".&nbsp;"+_mapping.getTextDescription("admin.test.Please wait for the system configurations to be updated and try again after a few minutes")+".</td></tr></table></td></tr></table>";
						rootJson.put("NoAgentMsg",tempMsg);
					}
				}
			}
		}
	}
	else
	{
		String tempMsg = "";
		if (selectedCompType != null  && !selectedCompType.equals(""))
		{
			if (isConfigSupported)
			{
				if(testType.equalsIgnoreCase("PerformanceTest"))
				{
					tempMsg = "<table align='center'><tr><td align='center' height='50'><table><tr><td align='center'><img src='/final/admin/eg_images/spacer.gif' class='iconInformation'></td></tr><tr><td align='center' class='commonErrorMsgText'>"+_mapping.getTextDescription("admin.test.No performance test(s) are enabled for")+"&nbsp;"+_mapping.getComponentTypeDescription(selectedCompType)+".&nbsp;"+_mapping.getTextDescription("admin.test.Please enable atleast one performance test for configuration")+".</td></tr></table></td></tr></table>";
					rootJson.put("NoAgentMsg",tempMsg);
				}
				else
				{
					tempMsg = "<table align='center'><tr><td align='center' height='50'><table><tr><td align='center'><img src='/final/admin/eg_images/spacer.gif' class='iconInformation'></td></tr><tr><td align='center' class='commonErrorMsgText'>"+_mapping.getTextDescription("admin.test.No configuration test(s) are enabled for")+"&nbsp;"+_mapping.getComponentTypeDescription(selectedCompType)+".&nbsp;"+_mapping.getTextDescription("admin.test.Please enable atleast one configuration test for configuration")+".</td></tr></table></td></tr></table>";
					rootJson.put("NoAgentMsg",tempMsg);
				}
			}
			else
			{
				 tempMsg = "<table align='center'><tr><td align='center' height='50'><table><tr><td align='center'><img src='/final/admin/eg_images/spacer.gif' class='iconInformation'></td></tr><tr><td align='center' class='commonErrorMsgText'>"+_mapping.getTextDescription("admin.test.No test(s) are enabled for")+"&nbsp;"+_mapping.getComponentTypeDescription(selectedCompType)+".&nbsp;"+_mapping.getTextDescription("admin.test.Please enable atleast one test for configuration")+".</td></tr></table></td></tr></table>";
				rootJson.put("NoAgentMsg",tempMsg);
			}
		}
	}



	if (componentName != null && !componentName.equals("-1") && !componentName.equals(""))
	{
		JSONObject unconfigTestsObj = new JSONObject();
		JSONArray unconfigTestsArr = new JSONArray();
		for (int i=0; i<unconfiguredTestList.size(); i++)
		{
			EgName nameObj = (EgName)unconfiguredTestList.get(i);
			String strTestName = nameObj.getActualName();
			String strTestDisplayValue = nameObj.getLocalName();
			unconfigTestsObj.put("valueField",strTestName);
			unconfigTestsObj.put("displayField",strTestDisplayValue);
			unconfigTestsArr.add(unconfigTestsObj);
			if (testName != null && strTestName.equals(testName))
			{
				rootJson.put("selectedUnconfigTest",strTestName);
			}
		}
		rootJson.put("unconfigTestsArr",unconfigTestsArr);
		JSONObject userConfigTestsObj = new JSONObject();
		JSONArray userConfigTestsArr = new JSONArray();
		for (int i=0; i<userconfiguredTestList.size(); i++)
		{
			EgName nameObj = (EgName)userconfiguredTestList.get(i);
			String strTestName = nameObj.getActualName();
			String strTestDisplayValue = nameObj.getLocalName();
			userConfigTestsObj.put("valueField",strTestName);
			userConfigTestsObj.put("displayField",strTestDisplayValue);
			userConfigTestsObj.put("groupField",_mapping.getTextDescription("admin.test.Tests with specific configuration"));
			userConfigTestsArr.add(userConfigTestsObj);
			
			if (testName != null && strTestName.equals(testName))
			{
				rootJson.put("selectedUserConfigTest",strTestName);
			}
		}

		for (int i=0; i<defaultconfiguredTestList.size(); i++)
		{
			EgName nameObj = (EgName)defaultconfiguredTestList.get(i);
			String strTestName = nameObj.getActualName();
			String strTestDisplayValue = nameObj.getLocalName();
			userConfigTestsObj.put("valueField",strTestName);
			userConfigTestsObj.put("displayField",strTestDisplayValue);
			userConfigTestsObj.put("groupField",_mapping.getTextDescription("admin.test.Tests with default configuration"));
			userConfigTestsArr.add(userConfigTestsObj);
			if (testName != null && strTestName.equals(testName))
			{
				rootJson.put("selectedUserConfigTest",strTestName);
			}
		}
		rootJson.put("userConfigTestsArr",userConfigTestsArr);

		JSONObject excludeTestsObj = new JSONObject();
		JSONArray excludeTestsArr = new JSONArray();
		for (int i=0;i<excludedTestList.size();i++)
		{
			EgName nameObj = (EgName)excludedTestList.get(i);
			String strTestName = nameObj.getActualName();
			String strTestDisplayValue = nameObj.getLocalName();
			excludeTestsObj.put("valueField",strTestName);
			excludeTestsObj.put("displayField",strTestDisplayValue);
			excludeTestsArr.add(excludeTestsObj);
		}
		rootJson.put("excludeTestsArr",excludeTestsArr);
	}


	String componentCredentialsNeededToDoValidation="";
	if (componentType != null && !componentType.equals("") && 
		componentName != null && !componentName.equals("-1") && !componentName.equals("") && 
		testName != null && !testName.equals(""))
	{
		session.removeAttribute("auditLogHt");
		httpTestAuditData = getHttpTestAuditData(aResultant);
		for (int i=0;i<aResultant.size();i++)
		{
			aListResultantInLowerCase.add(aResultant.get(i).toString().toLowerCase());
		}
		rootJson.put("configuredTestTitle",_mapping.getTestDescription(testName)+"&nbsp;"+_mapping.getTextDescription("admin.test.parameters to be configured for")+"&nbsp;"+removeNull(componentName)+"&nbsp;("+_mapping.getComponentTypeDescription(componentType)+")");
		String enabled = "";
		String disabled = "";
		if (testName.indexOf("Vmg") > -1 && !isAggregateTest)
		{
			String mappingType = "hyper";
			if ( componentType.equals("VmEsx_i_server") || componentType.equals("VmVdi_i_server") )
				mappingType = "esx";
			else if ( componentType.equals("Xen_virtual_server") || componentType.equals("Xen_desktop_server"))
				mappingType = "xen";
			String strVmLink = "'EgVmLogDisplay.jsp?phyServer="+componentNickName+"&type="+mappingType+"','from=testconfig','"+remoteAgent+"','eg_vm.ini',event";
			String tempLabel = "<table width='100%' height='15px'><tr><td align='right' valign='bottom' class='font_normal11'><a href='javascript:void(0)' onclick='me.clickToVmLogDisplay();' class='eg_monlink' style='text-decoration:none;'><span class='font_bold11'>Click here</span>&nbsp;<img src='/final/images/spacer.gif' class='iconClickHere' border='0'></a>&nbsp;"+_mapping.getTextDescription("admin.test.to view details of VMs on this host")+"</td></tr></table>";
			rootJson.put("viewVmLink",strVmLink);
			rootJson.put("vmType",mappingType);
			rootJson.put("externalPageLabel",tempLabel);
		}

		if (!isCompositeTest && isOracleDatabaseCompType && 
			isPortRelevantForTest && 
			egSpecs.isInfoRelevantForTest(testName))
		{
			String compwithcompTypeandPort = componentType+":"+componentName;
			compwithcompTypeandPort = compwithcompTypeandPort.trim();
			String[] valArr = egDisc.getFieldValuesForServer(componentType,compwithcompTypeandPort);
			String hostportlisName = valArr[1] + "^" + valArr[3] + "^" + valArr[5];
			hostportlisName = hostportlisName.trim();
			if (hostportlisName == null)
			{
				hostportlisName = componentName;
			}
			
			//boolean canOpenDbPage = true;
			StringTokenizer strToekn = new StringTokenizer(hostportlisName,"^");
			Vector sess_vec = new Vector();
			String hostIP = strToekn.nextToken();
			int portNo = Integer.parseInt(strToekn.nextToken());
			PortDiscovery pd = new PortDiscovery();
			pd.setSocketTimeout(2000);
			if(!pd.doesSocketExist(hostIP,portNo))
			{
				boolean isAggregateLink = false;
				boolean siteTick = false;
				boolean allExternalTests = true;
				if(EgInstallInfo.isAggregationSupported())
				{
					EgAggregateInfo egAggInfo = new EgAggregateInfo("manager");
					if(egAggInfo.getAggregateTypes().contains(componentType))
					{
						isAggregateLink = true;
					}
				}

				IniFile aggIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_aggregate.ini");
				String siteValue = aggIni.getValue("SITE_SUPPORT",componentType + ":" + componentName);
				if(siteValue.equals("yes"))
				{
					siteTick = true;
				}

				EgSpecsInfo egSpecsInfo = new EgSpecsInfo("manager");
				String[] testsForServer = egSpecsInfo.getTestsForServer(componentType);
				if (testsForServer != null)
				{
					for (int a=0; a<testsForServer.length; a++)
					{
						if (!egSpecsInfo.isTestExternal(testsForServer[a]))
						{
							allExternalTests = false;
							break;
						}
					}
				}

				String tempComp = null;
				if (componentType.equalsIgnoreCase("Oracle_server"))
				{
					tempComp = componentName.substring(0,componentName.lastIndexOf(":"));
				}
				else
				{
					tempComp = componentName;
				}

				sess_vec.removeAllElements();
				sess_vec.addElement(_mapping.getTextDescription("admin.error.Configure Oracle Database"));
				sess_vec.addElement("EgNewServer.jsp?for=testConfiguration&serverType="+EgURLEncoder.encode(componentType,"UTF-8")+"&componentName="+componentName+"&testType="+testType+"&testName="+testName+"&server="+EgURLEncoder.encode(tempComp,"UTF-8")+"&isAggregateLink="+isAggregateLink+"&modifyserver=true&siteSupport="+siteTick+"&allExternalTests="+allExternalTests);
				sess_vec.addElement(_mapping.getTextDescription("admin.error.Connection Error"));
				sess_vec.addElement(_mapping.getTextDescription("admin.error.Connection could not be established to the specific database server")+". ");
				sess_vec.addElement(_mapping.getTextDescription("admin.error.Please ensure that the database server is accessible from the eG manager")+".");
				session.putValue("vec_Errors",sess_vec);

				rootJson.put("cantopenDbUserCreation","true");
				//canOpenDbPage = false;
			}
			String dbUserLink = "EgDbUserCreation.jsp?comptype="+componentType+"&compname="+hostportlisName+"&qctr=1&rctr=0&t_name="+testName+"&server="+componentType+"&c_name="+componentName+"&version=null&requestFrom=EgConfigureComponentTests.jsp&testType="+testType;
			rootJson.put("isOracleDatabaseCompType","true");
			rootJson.put("externalPageLink",dbUserLink);
		}
		else if (isPolicyParamExists)
		{
			int logTypeIdx = aListResultantInLowerCase.indexOf("-logtype");
			String logTypeVal = (String)aResultant.get(logTypeIdx+1);
			int policyFilterIdx = aListResultantInLowerCase.indexOf("-policyfilter");
			String policyFilterVal = (String)aResultant.get(policyFilterIdx+1);

			if ((policyFilterVal.equalsIgnoreCase("true") && tPolicyFilter.length() == 0) || 
				tPolicyFilter.equalsIgnoreCase("true"))
			{
				rootJson.put("viewPolicy","true");
			}
			String strPolicyLink = "SpecificTestConfiguration/data/ViewPolicyJson.jsp?server="+componentType+"&test="+testName+"&port="+isPortRelevantForTest+"&showAll=no&logtype="+logTypeVal+"&requestFrom=EgConfigureComponentTests.jsp&componentName="+componentName+"&testType="+testType;
			rootJson.put("externalPageLink",strPolicyLink);
		}
		else if (listMultipleUserSupportTest != null && 
				listMultipleUserSupportTest.contains(testName))
		{
			multiUserMode = true;
			String strUserConfigLink = "'./VmgUsers.jsp?server="+componentType+"&test="+testName+"&port="+isPortRelevantForTest+"&compname="+EgURLEncoder.encode(removeNull(componentName),"UTF-8")+"','','scrollbars=yes,width=900,height=380,top=150,left=50'";
			rootJson.put("externalPageLink",strUserConfigLink);
			rootJson.put("vmgUsersPage","true");
		}
		else if (testName.equalsIgnoreCase("SlowTransTest"))
		{
			multiNamePatternMode = true;
			String strUrlPatternLink = "'./EgConfigureNamePattern.jsp?server="+componentType+"&test="+testName+"&port="+isPortRelevantForTest+"&compname="+EgURLEncoder.encode(removeNull(componentName),"UTF-8")+"','','scrollbars=yes,width=900,height=380,top=150,left=50'";
			rootJson.put("externalPageLink",strUrlPatternLink);
			rootJson.put("configurenamePattern","true");
		}
		else if (testName.equalsIgnoreCase("SnmpNonInfoTest") || testName.equalsIgnoreCase("SnmpInfoTest"))
		{
			multiOidsMode=true;
		}
		else if (testName.equalsIgnoreCase("CtxAuthTest") || 
				testName.equalsIgnoreCase("WinAuthTest") || 
				testName.equalsIgnoreCase("TermAuthTest"))
		{
			multiUserMode = true;
			String strUserConfigLink = "'./EgConfigureMultipleUsers.jsp?server="+componentType+"&test="+testName+"&port="+isPortRelevantForTest+"&compname="+EgURLEncoder.encode(removeNull(componentName),"UTF-8")+"','','scrollbars=yes,width=900,height=380,top=150,left=50'";
			rootJson.put("externalPageLink",strUserConfigLink);
		}
		else if (isEjbGroupingRequired)
		{
			boolean autoDiscovery = false;
			if (aListResultantInLowerCase.contains("-autodiscovery"))
			{
				String autoDiscoveryValue = aResultant.get(aListResultantInLowerCase.indexOf("-autodiscovery")+1).toString().trim();
				autoDiscovery = autoDiscoveryValue.equalsIgnoreCase("true")?true:autoDiscovery;
			}

			if (!autoDiscovery)
			{
				session.setAttribute("sName",componentType);
				String strModifyGrpLink = pageNameForEjbGrouping+"?comp="+EgURLEncoder.encode(componentName,"UTF-8")+"&test="+testName+"&server="+EgURLEncoder.encode(componentType,"UTF-8")+"&requestFrom=EgConfigureComponentTests.jsp";
				rootJson.put("externalPageLink",strModifyGrpLink);
				String tempLabel = "<table width='100%' height='5px'><tr><td  align='right' valign='bottom' class='font_normal11'><a href='javascript:void(0)' onclick='me.clickToExternalPage();' style='text-decoration:none;'><span class='font_bold11'>Click here</span>&nbsp;<img src='/final/images/spacer.gif' class='iconClickHere' border='0'></a>&nbsp;"+_mapping.getTextDescription("admin.test.to add/modify groups")+"</td></tr></table>";
				rootJson.put("externalPageLabel",tempLabel);
				rootJson.put("isEjbGroup",pageNameForEjbGrouping);
			}
		}
		else if (isAggregateTest)
		{
			String strModifyAggGrpLink = "EgConfigAggregate.jsp?comp="+EgURLEncoder.encode(componentName,"UTF-8")+"&test="+testName+"&server="+componentType+"&requestFrom=EgConfigureComponentTests.jsp";
			rootJson.put("externalPageLink",strModifyAggGrpLink);
			String tempLabel = "<table width='100%' height='5px'><tr><td  align='right' valign='bottom' class='font_normal11'><a href='javascript:void(0)' onclick='me.clickToExternalPage();' style='text-decoration:none;'><span class='font_bold11'>Click here</span>&nbsp;<img src='/final/images/spacer.gif' class='iconClickHere' border='0'></a>&nbsp;"+_mapping.getTextDescription("admin.test.to include/exclude descriptors of associated tests of aggregate test")+"</td></tr></table>";
			rootJson.put("isAggregateTest","true");
			rootJson.put("externalPageLabel",tempLabel);
		}
		else if (isCompositeTest)
		{
			String strModifyAggGrpLink = "EgConfigComposite.jsp?comp="+EgURLEncoder.encode(componentName,"UTF-8")+"&test="+testName+"&server="+componentType+"&requestFrom=EgConfigureComponentTests.jsp";
			rootJson.put("externalPageLink",strModifyAggGrpLink);
			String tempLabel = "<table width='100%' height='5px'><tr><td  align='right' valign='bottom' class='font_normal11'><a href='javascript:void(0)' onclick='me.clickToExternalPage();' style='text-decoration:none;'><span class='font_bold11'>Click here</span>&nbsp;<img src='/final/images/spacer.gif' class='iconClickHere' border='0'></a>&nbsp;"+_mapping.getTextDescription("admin.test.to include/exclude descriptors of associated tests of performance rating test")+"</td></tr></table>";
			rootJson.put("isCompositeTest","true");
			rootJson.put("externalPageLabel",tempLabel);
		}
		else if (testName.equalsIgnoreCase("VCTaskEvtTest"))
		{
			String strTaskLink = "/final/admin/EgConfigureVCTasks.jsp?fromPage=TestConfiguration&componentType="+componentType+"&componentName="+EgURLEncoder.encode(componentName,"UTF-8")+"&testName="+testName+"&requestFrom=EgConfigureComponentTests.jsp";
			rootJson.put("externalPageLink",strTaskLink);
			String tempLabel = "<table width='100%' height='5px'><tr><td  align='right' valign='bottom' class='font_normal11'><a href='javascript:void(0)' onclick='me.clickToExternalPage();' style='text-decoration:none;'><span class='font_bold11'>Click here</span>&nbsp;<img src='/final/images/spacer.gif' class='iconClickHere' border='0'></a>&nbsp;"+_mapping.getTextDescription("admin.test.to configure tasks for this test")+"</td></tr></table>";
			rootJson.put("externalPageLabel",tempLabel);
			rootJson.put("VcTasks","true");
		}
		else if (testName.equalsIgnoreCase("VCEventsTest"))
		{
			String strEventLink = "/final/admin/EgConfigureVCEvents.jsp?fromPage=TestConfiguration&componentType="+componentType+"&componentName="+EgURLEncoder.encode(componentName,"UTF-8")+"&testName="+testName+"&requestFrom=EgConfigureComponentTests.jsp";
			rootJson.put("externalPageLink",strEventLink);
			String tempLabel = "<table width='100%' height='5px'><tr><td  align='right' valign='bottom' class='font_normal11'><a href='javascript:void(0)' onclick='me.clickToExternalPage();' style='text-decoration:none;'><span class='font_bold11'>Click here</span>&nbsp;<img src='/final/images/spacer.gif' class='iconClickHere' border='0'></a>&nbsp;"+_mapping.getTextDescription("admin.test.to configure events for this test")+"</td></tr></table>";
			rootJson.put("externalPageLabel",tempLabel);
			rootJson.put("VcEvents","true");
		}
		else if (isUrlParamExist && isCredentialParamExist)
		{
			String strViewUrlCredentialLink = "'./EgConfigureUrlAndCredentials.jsp?server="+componentType+"&test="+testName+"&port="+isPortRelevantForTest+"&compname="+EgURLEncoder.encode(removeNull(componentName),"UTF-8")+"&isPrivateKeyParamExist="+isPrivateKeyParamExist+"&isSystemPropKeyParamExist="+isSystemPropKeyParamExist+"','','scrollbars=yes,width=900,height=500,top=150,left=50'";
			rootJson.put("externalPageLink",strViewUrlCredentialLink);
			rootJson.put("configurlcredentials","true");
		}

		rootJson.put("multiNamePatternMode",multiNamePatternMode);
		rootJson.put("multiOidsMode",multiOidsMode);
		rootJson.put("multiUserMode",multiUserMode);
		String testPeriodVal = "";
		String reqCorrectValue = "";
		if (testName.equals(previousTestName))
		{
			testPeriodVal = request.getParameter("testPeriod");
			testPeriodVal = (testPeriodVal != null)?testPeriodVal:"";

			reqCorrectValue = request.getParameter("correct");
			reqCorrectValue = (reqCorrectValue != null)?reqCorrectValue:"";
		}
		rootJson.put("componentNickName",componentNickName);
		rootJson.put("testPeriodLabel",_mapping.getTextDescription("admin.test.TEST PERIOD"));

		JSONArray testPeriodArr = new JSONArray();
		JSONObject testPeriodObj = new JSONObject();
		boolean b = true;
		Iterator itr = periodMap.keySet().iterator();
		for (int i=0; i<periodMap.size(); i++)
		{
			Long lngperiod = (Long)itr.next();
			String periodVal = lngperiod.toString();
			String periodStr = (String)periodMap.get(lngperiod);

			/* aggregate test frequency should be greater than or equals to its member's test frequency */
			/* starts */
			if(EgInstallInfo.isAggSupported && allowAggregateOperation)
			{
				if(minimumTestPeriod>-1 && (Integer.parseInt(periodVal))<minimumTestPeriod) continue;
			}
			/* ends */

			testPeriodObj.put("displayField",periodStr);
			testPeriodObj.put("valueField",periodVal);
			if (periodVal.equals(testPeriodVal))
			{
				//out.println("<option value = '" + periodVal + "' selected>" + periodStr + "</option>");
				b = false;
				rootJson.put("selectedTimePeriod",testPeriodVal);
			}
			else if (periodVal.equals(testperiod) && b)
			{
				rootJson.put("selectedTimePeriod",testperiod);
				//out.println("<option value = '" + periodVal + "' selected>" + periodStr + "</option>");
			}
			else
			{
				//out.println("<option value = '" + periodVal + "'>" + periodStr + "</option>");
			}
			testPeriodArr.add(testPeriodObj);
		}
		rootJson.put("testPeriodArr",testPeriodArr);
		boolean isCorrectParamExist = (aListResultantInLowerCase.contains("-correct") && aListResultantInLowerCase.contains("-alarmtype") && aListResultantInLowerCase.contains("-userparams") && aListResultantInLowerCase.contains("-correctivescript"));

		boolean isCorrectiveScriptEnabled = false;
		if (isCorrectParamExist)
		{
			String configureCorrecriveScriptURL = "/final/admin/EgCorrectiveScripts.jsp?backBtn=true&from=testconfig&componentType="+componentType+"&testType="+testType+"&testName="+testName+"&componentName="+EgURLEncoder.encode(componentName,"UTF-8")+"&clickedFrom="+EgURLEncoder.encode(clickedFrom,"UTF-8");
			rootJson.put("configureCorrecriveScriptURL",configureCorrecriveScriptURL);
			int correctiveIdx = aListResultantInLowerCase.indexOf("-correct");
			String correctVal = (String)aResultant.get(correctiveIdx+1);
			if (reqCorrectValue.length() == 0)
			{
				if (correctVal.equals("true"))
				{
					isCorrectiveScriptEnabled = true;
				}
			}
			else
			{
				if (reqCorrectValue.equals("true"))
				{
					isCorrectiveScriptEnabled = true;
				}
			}
			String disableCsLabel = "<table width='100%' height='5px'><tr><td  align='right' valign='bottom' class='font_normal11'><a href='javascript:void(0)' onclick='me.clickToDisableCorrectiveScripts();' style='text-decoration:none;'><span class='font_bold11'>Click here</span>&nbsp;<img src='/final/images/spacer.gif' class='iconClickHere' border='0'></a>&nbsp;"+_mapping.getTextDescription("admin.test.to disable corrective script")+"</td></tr></table>";
			rootJson.put("disableCsLabel",disableCsLabel);
		}
		rootJson.put("isCorrectParamExist",isCorrectParamExist);
		rootJson.put("isCorrectiveScriptEnabled",isCorrectiveScriptEnabled);
		if (!isCorrectParamExist)
		{
			String enableCsLabel = "<table width='100%' height='5px'><tr><td  align='right' valign='bottom' class='font_normal11'><a href='javascript:void(0)' onclick='me.clickToEnableCorrectiveScripts();' style='text-decoration:none;'><span class='font_bold11'>Click here</span>&nbsp;<img src='/final/images/spacer.gif' class='iconClickHere' border='0'></a>&nbsp;"+_mapping.getTextDescription("admin.test.to enable corrective script")+"</td></tr></table>";
			rootJson.put("enableCsLabel",enableCsLabel);
		}
		//start here for retrieving agent os
		String agentOS = "";
		boolean isPortParamExist = aListResultantInLowerCase.contains("-host");
		if (isPortParamExist)
		{
			boolean isCompAgentless = agentInfo.isAgentlessServer(componentNickName,componentType);
			boolean isInternalTest = egSpecs.isTestInternal(testName, componentType);
			String agentName = "";
			if (isInternalTest)
			{
				String interAgentMappingName = (String)internalAgentMap.get(componentNickName);
				if (interAgentMappingName == null)
				{
					agentName = componentNickName;
				}
				else
				{
					agentName = interAgentMappingName;
				}
			}
			else
			{
				String mappingName[] = egExternalInfo.getExternalAgentsForHost(componentNickName);
				String agentExternalName = mappingName[0];
				agentName = agentExternalName;
			}
			agentOS = agentconfig.getAgentOS(agentName);
			hiddenObj.put("agentOS",agentOS);
		}

		if (isCorrectParamExist)
		{
			boolean hasAgentSettingsEnabled = userRole.hasAnyAdminRole(EgUserPermission.AGENT_SETTINGS);
			//boolean isCompletedUserRole = userRole.hasAllComponentAccess();
			//boolean isAdmin = _user.isAdmin();

			boolean isAdminLinkEnabled = false;
			boolean isSecondaryManager = false;

			EgManagersIniForManager mi = null;
			if (EgInstallInfo.isClusterSupported)
			{
				mi = EgManagersIniForManager.getInstance();
				if (mi != null && !mi.isPrimaryManager())
				{
					hasAdminTab = false;
					isSecondaryManager = true;
				}
			}

			if (!EgInstallInfo.isSuperManager && !isSecondaryManager)
			{
				if (isAdmin)
				{
					isAdminLinkEnabled = true;
				}
				else if (isCompletedUserRole && hasAdminTab && hasAgentSettingsEnabled)
				{
					isAdminLinkEnabled = true;
				}
				//else if (!isCompletedUserRole && hasAdminTab && hasAgentSettingsEnabled)
				//{
					//isAdminLinkEnabled = true;
				//}
			}

			rootJson.put("isAdminLinkEnabled",isAdminLinkEnabled);

			JSONArray correctiveScriptArr = getCorrectiveScriptOSFiles(agentOS,testName);
			rootJson.put("correctiveScriptArr",correctiveScriptArr);
		}

		Arrays.sort(paramToContinue, String.CASE_INSENSITIVE_ORDER);
		Arrays.sort(processParamremoteContinue, String.CASE_INSENSITIVE_ORDER);
		Arrays.sort(snmpV1V2ParamToContinue, String.CASE_INSENSITIVE_ORDER);
		Arrays.sort(snmpV3ParamToContinue, String.CASE_INSENSITIVE_ORDER);
		Arrays.sort(multiUserReadOnlyParam, String.CASE_INSENSITIVE_ORDER);
		Arrays.sort(multiNameReadOnlyParam, String.CASE_INSENSITIVE_ORDER);
		Arrays.sort(multiOidsReadOnlyParam, String.CASE_INSENSITIVE_ORDER);
		Arrays.sort(modeTrueToContinue, String.CASE_INSENSITIVE_ORDER);
		Arrays.sort(modeFalseToContinue, String.CASE_INSENSITIVE_ORDER);
		Arrays.sort(measureModeTrueToContinue, String.CASE_INSENSITIVE_ORDER);
		Arrays.sort(measureModeFalseToContinue, String.CASE_INSENSITIVE_ORDER);
		Arrays.sort(measurementModeTrueToContinue, String.CASE_INSENSITIVE_ORDER);
		Arrays.sort(measurementModeFalseToContinue, String.CASE_INSENSITIVE_ORDER);
		Arrays.sort(paramsNeededToDoValidation, String.CASE_INSENSITIVE_ORDER);

		String testInfoDelimiter = egSpecs.getTestInfoDelimiter(testName);
		if (testInfoDelimiter.trim().length() == 0)
		{
			testInfoDelimiter = "#";
		}
		strDelimiter = testInfoDelimiter;
		rootJson.put("testInfoDelimiter",testInfoDelimiter);
		IniFile testsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_tests.ini");
		String[] infoDelilimterMasksArr  = testsIni.getVariables("TEST_INFO_DELIMITER_MASK");
		ArrayList infoDelilimterMasksList = new ArrayList();
		if (infoDelilimterMasksArr != null && infoDelilimterMasksArr.length > 0)
		{
			infoDelilimterMasksList = new ArrayList(Arrays.asList(infoDelilimterMasksArr));
			String tmpInfoDelilimterMasksList = StringUtils.getString(infoDelilimterMasksList);
			rootJson.put("infoDelilimterMasksList",tmpInfoDelilimterMasksList);
		}

		boolean hasMultipleUsers = false;
		boolean hasMultipleNames = false;
		boolean hasMultipleOid = false;

		// code starts to form component credentials for Validation - Rajesh
		StringBuffer sbValForValidation=new StringBuffer(256);
		if(aListResultantTempInLowerCase!=null && !aListResultantTempInLowerCase.isEmpty())
		{
			Iterator itrAListResultant=aListResultantTempInLowerCase.iterator();
			for(int p=0;p<aListResultantTempInLowerCase.size();p=p+3)
			{
				String aListParam=(String)aListResultantTempInLowerCase.get(p);
				if(aListParam!=null)
				{
					aListParam=aListParam.substring(1,aListParam.length());
					aListParam=aListParam.toLowerCase();
					int validateParamIdx = Arrays.binarySearch(paramsNeededToDoValidation,aListParam,String.CASE_INSENSITIVE_ORDER);
					if(validateParamIdx>-1)
					{
						String aListValue=(String)aListResultantTempInLowerCase.get(p+1);
						if(aListValue!=null && (!aListValue.equals("") && !aListValue.equalsIgnoreCase("null")))
						{
							sbValForValidation.append("-"+aListParam+":"+aListValue+"|#|");
						}
					}
					//if (isSnmp)
					//{
						//if (!isSnmpV1V2)
						//{
							//int snmpV3ParamIdx = Arrays.binarySearch(snmpV3ParamToContinue,aListParam,String.CASE_INSENSITIVE_ORDER);
							//if(snmpV3ParamIdx>-1)
							//{
								//String aListValue=(String)aListResultantTempInLowerCase.get(p+1);
								//if(aListValue!=null && (!aListValue.equals("") && !aListValue.equalsIgnoreCase("null")))
								//{
									//sbValForValidation.append("-"+aListParam+":"+aListValue+"|#|");
								//}
							//}
						//}
					//}
				}
			}

			if(componentType!=null && componentType.equalsIgnoreCase("ms_sql_server"))
			{
				if(aListResultantTempInLowerCase!=null && aListResultantTempInLowerCase.contains("-isntlmv2"))
				{
					paramForDisplayingValidateButton="isntlmv2";
				}
			}
			else if(componentType!=null && (componentType.equalsIgnoreCase("network_node") || componentType.toLowerCase().indexOf("cisco")>-1))
			{
				if(paramForDisplayingValidateButton!=null && (!paramForDisplayingValidateButton.equals("") && !paramForDisplayingValidateButton.equalsIgnoreCase("null"))) // This condition is to make sure that validation settings are configured for componenttype.bcoz  validation button must be placed on specific location only when validation settings are configured for the componenttype.
				{
					if (isSnmp)
					{
						if (!isSnmpV1V2)
						{
							if(aListResultantTempInLowerCase!=null && aListResultantTempInLowerCase.contains("-encryptflag"))
							{
								paramForDisplayingValidateButton="encryptflag";
							}
						}
					}
				}
			}
		}
		if(sbValForValidation!=null)
		{
			componentCredentialsNeededToDoValidation=sbValForValidation.toString();
		}
		paramsForValidationURL=paramsForValidationURL+"&isSNMP="+isSnmp;
		// code ends to form component credentials for Validation  

		//added by pravat --start
		if (isXDMGetDevicesInfo)
		{
			paramsForValidationURL = "test="+EgURLEncoder.encode(testName,"UTF-8")+"&action=pickAgentToValidate&taskName=WebServiceValidity"+"&compName="+EgURLEncoder.encode(componentName,"UTF-8")+"&componentType="+componentType+"&configurationType=specificConfiguration"+"&allowHostName="+isAllowHostName;
			requiredParamNames = requiredParamNames+",passwordconfirmpassword";
			int userNameIdx = aListResultantInLowerCase.indexOf("-username");
			String userName = (String)aResultant.get(userNameIdx+1);
			int passwordIdx = aListResultantInLowerCase.indexOf("-password");
			String passWord = (String)aResultant.get(passwordIdx+1);
			passWord = EgCrypt.decrypt(passWord);

			if (!aListTcKeywordsLowerCase.contains(passWord.toLowerCase()))
			{
				passWord += "~EG~"; // salt for pwd
				passWord = EgCrypt.encrypt(passWord);
			}
			paramsForValidationURL = paramsForValidationURL+"&xenMobileUserName="+userName+"&xenMobilePassword="+passWord;
		}
		//added by pravat -- end

		JSONObject paramNameObj = new JSONObject();
		JSONObject originalParamNameObj = new JSONObject();
		if (!StringUtils.isNull(componentType) && !StringUtils.isNull(componentNickName) && (listAgents != null && listAgents.size() > 0))
		{
			boolean isAgentInstalledAndRunningCs = false;
			if ( !agentInfo.isAgentlessServer(componentNickName,componentType))
			{
				com.eg.EgServerList serverList = new com.eg.EgServerList();
				ArrayList aList_A = new ArrayList();
				aList_A.add((String)listAgents.get(0));
				ArrayList aList_B = serverList.getAgentList(aList_A);
				if (aList_B != null && !aList_B.isEmpty())
				{
					String agentStatus = (String)aList_B.get(1);
					if (agentStatus.equalsIgnoreCase("Installed-Running"))
					{
						isAgentInstalledAndRunningCs = true;
					}
				}
			}
			rootJson.put("isAgentInstalledAndRunningCs",isAgentInstalledAndRunningCs);
		}

		if (!StringUtils.isNull(componentType) && !StringUtils.isNull(componentNickName))
		{
			boolean isAgentBasedComponent = false;
			if (!agentInfo.isAgentlessServer(componentNickName,componentType))
			{
				if (!componentType.startsWith("Agg_"))
				{
					isAgentBasedComponent = true;
				}
			}
			rootJson.put("isAgentBasedComponent",isAgentBasedComponent);
		}

		if (!StringUtils.isNull(componentType) && !StringUtils.isNull(testName))
		{
			boolean isExternalTestCS = egSpecs.isExternalTest(testName, componentType);
			rootJson.put("isExternalTest",isExternalTestCS);
		}

		if (aResultant != null && aResultant.size() > 0)
		{
			String straResultant = getString(aResultant);
			rootJson.put("componentCredentialsNeededToDoValidation",componentCredentialsNeededToDoValidation);
			rootJson.put("paramForDisplayingValidateButton",paramForDisplayingValidateButton);
			rootJson.put("aResultant",straResultant);
		}

		rootJson.put("isExecutionTimeParam",false);

		for (int i=0;i<aResultant.size();i=i+3)
		{
			String paramName = (String)aResultant.get(i);

			aListParamNamesValues.add(paramName);

			paramName = paramName.substring(1).trim();

			if (infoDelilimterMasksList.contains(testName+":"+paramName+":"+testInfoDelimiter))
			{
				strDelimiterMask = testsIni.getValue("TEST_INFO_DELIMITER_MASK",testName+":"+paramName+":"+testInfoDelimiter);
				if (strDelimiterMask.trim().length() == 0)
				{
					strDelimiterMask = "0egHash1";
				}
			}
			String paramValue = (String)aResultant.get(i+1);
			if(paramName.toUpperCase().equals("AGGREGATEDESCRIPTOR") && (testName.endsWith("_ag") || testName.endsWith("_agx")))
			{
				hiddenObj.put("AGGREGATEDESCRIPTOR_previous",paramValue);
			}

			String displayControl = (String)aResultant.get(i+2);
			displayControl = displayControl.trim();

			//if (aListParamsWithDoubleQuotes != null && !aListParamsWithDoubleQuotes.contains(paramName.toLowerCase()) && !displayControl.equalsIgnoreCase("password"))
			if (!displayControl.equalsIgnoreCase("password"))
			{
				paramValue = paramValue.trim();

				if (paramValue.startsWith("\"") && paramValue.endsWith("\""))
				{
					paramValue = paramValue.substring(1,paramValue.length()-1);
				}
			}
			aListParamNamesValues.add(paramValue);

			//if(componentType.equals("Client_desktop") && (testName.equals("ClientServiceTest") || testName.equals("ClientTcpTest")))
			//{
				//rootJson.put("isAutoSelected", isAutoSelected);
				//if(paramName.equalsIgnoreCase("adapter_device_selection"))
				//{
					//String paramValue_new = request.getParameter("adapter_device_selection");
					//rootJson.put("paramValueNew",paramValue_new);
					//if(paramValue_new != null && (paramValue_new=paramValue_new.trim()).length() > 0 && !paramValue_new.equalsIgnoreCase("null"))
					//{
						//paramValue = paramValue_new;
					//}
					//if(paramValue.equalsIgnoreCase("automatic"))
					//{
						//isAutoSelected = true;
					//}
				//}
				//if((paramName.equalsIgnoreCase("device_name") || paramName.equalsIgnoreCase("device_id")) && isAutoSelected)
				//{
					//hiddenObj.put(paramName,"default");
					//continue;
				//}
			//}

			int elementIdx = Arrays.binarySearch(paramToContinue,paramName,String.CASE_INSENSITIVE_ORDER);
			if (elementIdx > -1) continue;
			if (testName.equalsIgnoreCase("SecurityLogTest"))
			{
				if (paramName.equalsIgnoreCase("users") || paramName.equalsIgnoreCase("eventids"))
				{
					continue;
				}
			}

			if (isSnmp)
			{
				if (isModeParamExist)
				{
					int heapAnalysisIdx = aListResultantInLowerCase.indexOf("-heap_analysis");
					rootJson.put("heapAnalysisIdx",heapAnalysisIdx);
					if (heapAnalysisIdx > -1)
					{
						String heapAnalysisValue = ((String)aResultant.get(heapAnalysisIdx+1)).trim();

						String requestHeapAnalysisValue = "";
						if (testName.equals(previousTestName))
						{
							requestHeapAnalysisValue = request.getParameter(((String)aResultant.get(heapAnalysisIdx)).substring(1));
							requestHeapAnalysisValue = (requestHeapAnalysisValue == null)?"":requestHeapAnalysisValue;
						}

						if (!requestHeapAnalysisValue.equals("")) 
						{
							heapAnalysisValue = requestHeapAnalysisValue;
						}
						rootJson.put("heapAnalysisValue",heapAnalysisValue);
					}
				}
			}

			//for remote based monitoring continuing the process parameters
			int remProcessParamIdx = Arrays.binarySearch(processParamremoteContinue,paramName,String.CASE_INSENSITIVE_ORDER);
			if(remProcessParamIdx > -1 && isRemote) continue;

			//parameter value comes only for component type called "web" for the parameter "site"
			if (paramValue.equalsIgnoreCase("noteditable")) continue;

			//hide the parameter info
			if (!componentType.equals("Oracle_cluster_service") && paramName.equalsIgnoreCase("info"))
			{
				continue;
			}

			int readOnlyParamIdx = Arrays.binarySearch(multiUserReadOnlyParam,paramName,String.CASE_INSENSITIVE_ORDER);
			if(readOnlyParamIdx <= -1)
			{
				readOnlyParamIdx = Arrays.binarySearch(multiNameReadOnlyParam,paramName,String.CASE_INSENSITIVE_ORDER);
			}
			if(readOnlyParamIdx <= -1)
			{
				readOnlyParamIdx = Arrays.binarySearch(multiOidsReadOnlyParam,paramName,String.CASE_INSENSITIVE_ORDER);
			}
			rootJson.put("readOnlyParamIdx",readOnlyParamIdx);
			if (readOnlyParamIdx > -1)
			{
				if (paramName.equalsIgnoreCase("domain") || 
					paramName.equalsIgnoreCase("user") || 
					paramName.equalsIgnoreCase("published_resources") || 
					paramName.equalsIgnoreCase("admin_user"))
				{
					if (paramValue.indexOf("|") > -1)
					{
						hasMultipleUsers = true;
					}
				}
				else if (paramName.equalsIgnoreCase("name") || 
					paramName.equalsIgnoreCase("pattern") || 
					paramName.equalsIgnoreCase("threshold_value"))
				{
					if (paramValue.indexOf("|") > -1)
					{
						hasMultipleNames = true;
					}
				}
				else if (paramName.equalsIgnoreCase("measure_oid"))
				{
					if (paramValue.indexOf("|") > -1)
					{
						hasMultipleOid = true;
					}
				}
			}
			if (isAggregateTest)
			{
				if (paramName.equalsIgnoreCase("host") || 
					paramName.equalsIgnoreCase("port"))
				{
					continue;
				}
			}
			else if (componentType.startsWith("Agg_") && isCompositeTest)
			{
				if (paramName.equalsIgnoreCase("host") || 
					paramName.equalsIgnoreCase("port"))
				{
					continue;
				}
			}

			String readOnly = "";
			String descriptorButton = "";
			rootJson.put("isButtonDescription",aListDescriptorParam.contains(paramName));
			if (aListDescriptorParam.contains(paramName))
			{
				descriptorButton = "<img src=\"/final/admin/eg_images/descriptor-1.gif\" title=\"Click here to configure value for specfic descriptor\" class=\"leftmouse\" onClick=\"openDescriptorDetails(\'this.event\',\'EgDetailsTest.jsp?t_name="+testName+"&c_name="+componentName+"&p_value="+paramValue+"&p_name="+paramName+"\')\">";
				readOnly = "readOnly";
				rootJson.put("descriptorButton"+paramName,descriptorButton);
			}

			//By default both the fields (host,port) are expected to be read-only
			if (paramName.equalsIgnoreCase("host") && hostEditableMode.equalsIgnoreCase("false"))
			{
				rootJson.put("hostEditableMode",hostEditableMode);
				readOnly = "readOnly";
			}
			if (paramName.equalsIgnoreCase("port") && portEditableMode.equalsIgnoreCase("false"))
			{
				rootJson.put("portEditableMode",portEditableMode);
				readOnly = "readOnly";
			}
			//By default both the fields(host,port) are expected to be read-only

			if (paramName.equalsIgnoreCase("credentials"))
			{
				StringBuffer strBuffer = new StringBuffer();
				for (int k=0;k<aUrlCredentialVal.size();k=k+3)
				{
					if (k >= 3)
					{
						strBuffer.append(",");
					}
					strBuffer.append(aUrlCredentialVal.get(k+1));
					strBuffer.append(":");
					strBuffer.append(aUrlCredentialVal.get(k+2));
				}
				hiddenObj.put(paramName,strBuffer.toString());
				continue;
			}

			if (paramName.equalsIgnoreCase("content"))
			{
				StringBuffer strBuffer = new StringBuffer();
				for (int k=0;k<aListContentValues.size();k++)
				{
					if (k >= 1)
					{
						strBuffer.append(",");
					}
					strBuffer.append(aListContentValues.get(k));
				}
				hiddenObj.put(paramName,strBuffer.toString());
				continue;
			}

			if (paramName.equalsIgnoreCase("encoding"))
			{
				StringBuffer strBuffer = new StringBuffer();
				for (int k=0;k<aListEncodingValues.size();k++)
				{
					if (k >= 1)
					{
						strBuffer.append(",");
					}
					strBuffer.append(aListEncodingValues.get(k));
				}
				hiddenObj.put(paramName,strBuffer.toString());
				continue;
			}
			
			if (paramName.equalsIgnoreCase("privateKey"))
			{
				StringBuffer strBuffer = new StringBuffer();
				for (int k=0;k<aListFilePathValues.size();k=k+2)
				{
					if (k >= 2)
					{
						strBuffer.append(",");
					}					
					strBuffer.append(aListFilePathValues.get(k));
					strBuffer.append("#~~#");
					strBuffer.append(aListFilePathValues.get(k+1));
				}
				hiddenObj.put(paramName,strBuffer.toString());
				continue;
			}
			//targets start
			if (paramName.equalsIgnoreCase("systempropskey"))
			{
				if (aListTgtSysPropKeys != null && !aListTgtSysPropKeys.isEmpty())
				{
					hiddenObj.put(paramName,StringUtils.getString(aListTgtSysPropKeys));
				}
				//StringBuffer strBuffer = new StringBuffer();
				//for (int k=0;k<aListTgtSysPropKeys.size();k++)
				//{
					//if (k >= 1)
					//{
						//strBuffer.append(",");
					//}
					//strBuffer.append(aListTgtSysPropKeys.get(k));
				//}
				//hiddenObj.put(paramName,strBuffer.toString());
				continue;
			}

			if (paramName.equalsIgnoreCase("systempropsvalue"))
			{
				if (aListTgtSysPropValues != null && !aListTgtSysPropValues.isEmpty())
				{
					hiddenObj.put(paramName,StringUtils.getString(aListTgtSysPropValues));
				}


				//StringBuffer strBuffer = new StringBuffer();
				//for (int k=0;k<aListTgtSysPropValues.size();k++)
				//{
					//if (k >= 1)
					//{
						//strBuffer.append(",");
					//}
					//strBuffer.append(aListTgtSysPropValues.get(k));
				//}
				//hiddenObj.put(paramName,strBuffer.toString());
				continue;
			}
			//targets end

			if (paramName.equalsIgnoreCase("systempropertykey"))
			{
				StringBuffer strBuffer = new StringBuffer();
				for (int k=0;k<aListSystemPropKeys.size();k++)
				{
					if (k >= 1)
					{
						strBuffer.append(",");
					}
					strBuffer.append(aListSystemPropKeys.get(k));
				}
				hiddenObj.put(paramName,strBuffer.toString());
				continue;
			}

			if (paramName.equalsIgnoreCase("systempropertyvalue"))
			{
				StringBuffer strBuffer = new StringBuffer();
				for (int k=0;k<aListSystemPropValues.size();k++)
				{
					if (k >= 1)
					{
						strBuffer.append(",");
					}
					strBuffer.append(aListSystemPropValues.get(k));
				}
				hiddenObj.put(paramName,strBuffer.toString());
				continue;
			}

			if ((testName.equalsIgnoreCase("WindowshareTest") || testName.equalsIgnoreCase("UNCCheckTest")) && 
				(paramName.equalsIgnoreCase("domainname") || 
				paramName.equalsIgnoreCase("shareusername") || 
				paramName.equalsIgnoreCase("password")))
			{
				paramValue = getWinShareParamsValue(paramName,paramValue,displayControl,aListTcKeywordsLowerCase);
				hiddenObj.put(paramName,paramValue);
			}

			boolean showStar = false;
			if (isAutoConfiguration && paramValue.startsWith("$") && aListTcKeywordsLowerCase.contains(paramValue.toLowerCase()))
			{
				showStar = true;
				String tempNewValue = null;
				if (testName.equals(previousTestName))
				{
					tempNewValue = request.getParameter(paramName);
					if (tempNewValue != null)
					{
						tempNewValue = tempNewValue.toLowerCase();
						if (!aListTcKeywordsLowerCase.contains(tempNewValue))
						{
							showStar = false;
						}
					}
				}

				if (showStar)
				{
					paramNameObj.put(paramName,"*&nbsp;"+_mapping.getTextDescription("admin.test."+paramName.toUpperCase()));
					originalParamNameObj.put(paramName.toUpperCase(),paramName);
				}
				else
				{
					paramNameObj.put(paramName,_mapping.getTextDescription("admin.test."+paramName.toUpperCase()));
					originalParamNameObj.put(paramName.toUpperCase(),paramName);
				}
			}
			else
			{
				if((paramName.equalsIgnoreCase("aggregateDescriptor") && (testName.endsWith("_ag") || testName.endsWith("_agx"))))
				{
					paramNameObj.put(paramName,_mapping.getTextDescription("admin.test.Report by descriptors"));
				}
				else
				{
					paramNameObj.put(paramName,_mapping.getTextDescription("admin.test."+paramName.toUpperCase()));
				}
				originalParamNameObj.put(paramName.toUpperCase(),paramName);
			}

			if(isEnablePwdProfile)
			{
				if (pwdProfileParamMap != null && pwdProfileParamMap.size() > 0)
				{
					String tmpParamValue = (String) pwdProfileParamMap.get(paramName);
					if (!StringUtils.isNull(tmpParamValue))
					{
						paramValue = tmpParamValue;
						rootJson.put(paramName+"isPwdProfile",true);
					}
				}
			}

			if(paramValue.startsWith("\"") && paramValue.endsWith("\""))
			{
				auditLogHt.put(paramName,paramValue.substring(1,paramValue.length()-1));
			}
			else if(paramValue.indexOf("|")>0)
			{
				auditLogHt.put(paramName,StringUtils.replace(paramValue,"|",","));
			}
			else
			{
				if(paramName.equalsIgnoreCase("authtype") || paramName.equalsIgnoreCase("encrypttype"))
				{
					auditLogHt.put(paramName,paramValue.toUpperCase());
				}
				else
				{
					auditLogHt.put(paramName,paramValue);
				}
			}
			if (displayControl.equalsIgnoreCase("radio"))
			{
				//Dependent Parameter - Having relationship with other parameters
				//For e.g., correct which has relations with alarmtype,userparams,correctivescript
				//Independent Parameter - Does not have relationship with other parameters
				//For e.g., isPassive
				//ProcessTest=wide(Yes:true#No:false) - Independent param
				//parameter value definition = (Yes:true#No:false)
				//Independent parameter having values true (or) false,yes (or) no,y (or) n doesnt 
				//need to define parameter value definition.
				//so ProcessTest=wide(Yes:true#No:false) can also be called as ProcessTest=wide
				//This will be handled in else block
				boolean isIndependentParam = aListDynamicRadioOptionNameAndValue.contains(paramName);
				rootJson.put("isIndependentParam"+paramName,isIndependentParam);
				if (isIndependentParam)
				{
					//block fires when the user put corresponding value to the isolated
					//radio parameter.
					int paramIdx = aListDynamicRadioOptionNameAndValue.indexOf(paramName);
					String tempParamValue = (String)aListDynamicRadioOptionNameAndValue.get(paramIdx+1);
					StringTokenizer st = new StringTokenizer(tempParamValue,"#");
					String tempParam = st.nextToken();
					String tempName1 = tempParam.substring(0,tempParam.indexOf(":"));
					String tempValue1 = tempParam.substring(tempParam.indexOf(":")+1,tempParam.length());
					String tempParam1 = st.nextToken();
					String tempName2 = tempParam1.substring(0,tempParam1.indexOf(":"));
					String tempValue2 = tempParam1.substring(tempParam1.indexOf(":")+1,tempParam1.length());
					boolean isIndependentParamEnabled = false;
					boolean isIndependentParamDisabled = false;
					String selectedParamValue = "";
					if (testName.equals(previousTestName))
					{
						selectedParamValue = request.getParameter(paramName);
						selectedParamValue = (selectedParamValue!=null)?selectedParamValue:"";
					}

					if (paramValue.equalsIgnoreCase("yes"))
					{
						paramValue = "true";
					}
					else if (paramValue.equalsIgnoreCase("no"))
					{
						paramValue = "false";
					}

					if (selectedParamValue.equalsIgnoreCase("") && 
						tempValue1.equalsIgnoreCase(paramValue))
					{
						enabled = "checked";
						disabled = "";
						isIndependentParamEnabled = true;
						isIndependentParamDisabled = false;
					}
					else if (selectedParamValue.equalsIgnoreCase("") && 
						tempValue2.equalsIgnoreCase(paramValue))
					{
						enabled = "";
						disabled = "checked";
						isIndependentParamEnabled = false;
						isIndependentParamDisabled = true;
					}
					else if (selectedParamValue.equalsIgnoreCase(tempValue1))
					{
						enabled = "checked";
						disabled = "";
						isIndependentParamEnabled = true;
						isIndependentParamDisabled = false;
					}
					else if (selectedParamValue.equalsIgnoreCase(tempValue2))
					{
						enabled = "";
						disabled = "checked";
						isIndependentParamEnabled = false;
						isIndependentParamDisabled = true;
					}
					rootJson.put("enabled"+paramName,isIndependentParamEnabled);
					rootJson.put("disabled"+paramName,isIndependentParamDisabled);
					rootJson.put("independentParamName"+paramName+"1",tempName1);
					rootJson.put("independentParamName"+paramName+"2",tempName2);
					rootJson.put("independentParamValue"+paramName+"1",tempValue1);
					rootJson.put("independentParamValue"+paramName+"2",tempValue2);
					aListDisplay.add(paramName+"#"+tempValue1);
					aListDisplay.add(tempName1);
					aListDisplay.add(paramName+"#"+tempValue2);
					aListDisplay.add(tempName2);

					if (paramName.equalsIgnoreCase("isembedded"))
					{
						boolean isEnabled = true;
						boolean isDisabled = true;
						String firstTimeStr = "";
						if(paramValue == null ||  paramValue.equalsIgnoreCase("false"))
						{
							isEnabled = false;
							firstTimeStr = "false";
						}
						else
						{
							isDisabled = false;
							firstTimeStr = "true";
						}
						rootJson.put("isEmbeddedFirstTime",firstTimeStr);
						rootJson.put("enabled"+paramName,isEnabled);
						rootJson.put("disabled"+paramName,isDisabled);
						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("True");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("False");
					}	
					else if (componentType!=null && componentType.equalsIgnoreCase("STORAGE_RAID") && paramName.equalsIgnoreCase("ssl"))
					{
						boolean isEnabled = true;
						boolean isDisabled = true;
						String firstTimeStr = "";
						if(paramValue == null ||  paramValue.equalsIgnoreCase("true"))
						{
							isDisabled = false;
							firstTimeStr = "true";
						}
						else
						{
							isEnabled = false;
							firstTimeStr = "false";
						}
						rootJson.put("isSslFirstTime",firstTimeStr);
						rootJson.put("enabled"+paramName,isEnabled);
						rootJson.put("disabled"+paramName,isDisabled);
						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("True");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("False");
					}	
					if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
					{
						rootJson.put("isValidateBtn",true);
						String methodLink = "javascript:setAppServerValidationTitle('"+validationTitle+"','"+removeNull(componentName)+"');javascript:validateAppServerCredentails('specificConfiguration','"+validationURL+"%','"+paramsForValidationURL+"','pickAgentToValidate','"+componentType+"','"+testName+"','false','"+isAllowHostName+"','"+requiredParamNames+"','testConfig',event);";
						rootJson.put("methodLink",methodLink);
						requiredParamNames=requiredParamNames+",passwordconfirmpassword";
					}
				}
				else
				{
					if (paramName.equalsIgnoreCase("encryptflag") && isSnmp)
					{
						String encryptFlagVal = "";
						boolean isEncryptEnabled = false;
						boolean isEncryptDisabled = false;
						if (testName.equals(previousTestName))
						{
							encryptFlagVal = request.getParameter(paramName);
							encryptFlagVal = (encryptFlagVal!=null)?encryptFlagVal:"";
						}

						if (paramValue.equalsIgnoreCase("true") && encryptFlagVal.length()==0)
						{
							enabled = "checked";
							disabled = "";
							isEncryptEnabled = true;
							isEncryptDisabled = false;
						}
						else if (paramValue.equalsIgnoreCase("false") && encryptFlagVal.length()==0)
						{
							enabled = "";
							disabled = "checked";
							isEncryptEnabled = false;
							isEncryptDisabled = true;
						}
						else if (encryptFlagVal.equalsIgnoreCase("true"))
						{
							enabled = "checked";
							disabled = "";
							isEncryptEnabled = true;
							isEncryptDisabled = false;
						}
						else if (encryptFlagVal.equalsIgnoreCase("false"))
						{
							enabled = "";
							disabled = "checked";
							isEncryptEnabled = false;
							isEncryptDisabled = true;
						}
						rootJson.put("enabledEncryptFlag",isEncryptEnabled);
						rootJson.put("disabledEncryptFlag",isEncryptDisabled);
						if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
						{
							rootJson.put("isValidateBtn",true);
							requiredParamNames=requiredParamNames+",passwordconfirmpassword";
						}
					}
					else if (paramName.equalsIgnoreCase("policyfilter") && isPolicyParamExists)
					{
						String policyFilterValue = "";
						boolean policyFilterEnabled = false;
						boolean policyFilterDisabled = false;
						if (testName.equals(previousTestName))
						{
							policyFilterValue = request.getParameter(paramName);
							policyFilterValue = (policyFilterValue != null && policyFilterValue.length() > 0)?policyFilterValue:"";
						}

						if (paramValue.equalsIgnoreCase("true") && policyFilterValue.length()==0)
						{
							enabled = "checked";
							disabled = "";
							policyFilterEnabled = true;
							policyFilterDisabled = false;
						}
						if (paramValue.equalsIgnoreCase("false") && policyFilterValue.length()==0)
						{
							enabled = "";
							disabled = "checked";
							policyFilterEnabled = false;
							policyFilterDisabled = true;
						}
						else if(policyFilterValue.equalsIgnoreCase("true"))
						{
							enabled = "checked";
							disabled = "";
							policyFilterEnabled = true;
							policyFilterDisabled = false;
						}
						else if(policyFilterValue.equalsIgnoreCase("false"))
						{
							enabled = "";
							disabled = "checked";
							policyFilterEnabled = false;
							policyFilterDisabled = true;

						}
						rootJson.put("enabled"+paramName,policyFilterEnabled);
						rootJson.put("disabled"+paramName,policyFilterDisabled);
						if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
						{
							rootJson.put("isValidateBtn",true);
							requiredParamNames=requiredParamNames+",passwordconfirmpassword";
						}
					}
					else if (paramName.equalsIgnoreCase("correct") && !isRemote && isCorrectParamExist)
					{
						String correctVal = "";
						boolean isEnabled = false;
						boolean isDisabled = false;

						if (testName.equals(previousTestName))
						{
							correctVal = request.getParameter(paramName);
							correctVal = (correctVal != null && correctVal.length() > 0)?correctVal:"";
						}

						if(paramValue.equalsIgnoreCase("false") && correctVal.length()==0)
						{
							enabled = "";
							disabled = "checked";
							isDisabled = true;
						}
						else if(paramValue.equalsIgnoreCase("true") && correctVal.length()==0)
						{
							enabled = "checked";
							disabled = "";
							isEnabled = true;
						}
						else if(correctVal.equalsIgnoreCase("true"))
						{
							enabled = "checked";
							disabled = "";
							isEnabled = true;
						}
						else if(correctVal.equalsIgnoreCase("false"))
						{
							enabled = "";
							disabled = "checked";
							isDisabled = true;
						}
						rootJson.put("enabled"+paramName,isEnabled);
						rootJson.put("disabled"+paramName,isDisabled);
						if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
						{
							rootJson.put("isValidateBtn",true);
							requiredParamNames=requiredParamNames+",passwordconfirmpassword";
						}
					}
					else if(paramName.equalsIgnoreCase("metric_collection_type"))
					{
						String jmxOptionsShow = "";
						String jmxOptionsHide = "";
						String optionsTempVal = new String(paramValue);
						boolean isEnabled = false;
						boolean isDisabled = false;

						String requestModeValue = "";
						if (testName.equals(previousTestName))
						{
							requestModeValue = request.getParameter(paramName);
							requestModeValue = (requestModeValue==null)?"":requestModeValue;
						}

						if (!requestModeValue.equals(""))
						{
							optionsTempVal = requestModeValue;
						}

						if (optionsTempVal.equalsIgnoreCase("true"))
						{
							jmxOptionsShow = "checked";
							isEnabled = true;
						}
						else
						{
							jmxOptionsHide = "checked";
							isDisabled = true;
						}
						rootJson.put("jmxOptionsShow",isEnabled);
						rootJson.put("jmxOptionsHide",isDisabled);
						String lableString = "Others";
						if(testName.equalsIgnoreCase("jvmfiledescriptortest") || testName.equalsIgnoreCase("jmxconnectortest")){
							lableString = "JMX";
						}
						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add(lableString);
						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("JAR");
						rootJson.put(paramName+"#"+"false" , "JAR");
						rootJson.put(paramName+"#"+"true" , lableString);
					}
					else if(paramName.equalsIgnoreCase("mode") && isModeParamExist)
					{
						String snmpSelected = "";
						String jmxSelected = "";
						String modeTempVal = new String(paramValue);
						boolean isEnabled = false;
						boolean isDisabled = false;

						String requestModeValue = "";
						if (testName.equals(previousTestName))
						{
							requestModeValue = request.getParameter(paramName);
							requestModeValue = (requestModeValue==null)?"":requestModeValue;
						}

						if (!requestModeValue.equals(""))
						{
							modeTempVal = requestModeValue;
						}

						if (modeTempVal.equalsIgnoreCase("true"))
						{
							snmpSelected = "checked";
							isEnabled = true;
						}
						else
						{
							jmxSelected = "checked";
							isDisabled = true;
						}
						rootJson.put("modeEnabled",isEnabled);
						rootJson.put("modeDisabled",isDisabled);
						if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
						{
							rootJson.put("isValidateBtn",true);
							requiredParamNames=requiredParamNames+",passwordconfirmpassword";
						}
						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("SNMP");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("JMX");
					}
					else if(paramName.equalsIgnoreCase("measure_mode") && isMeasureModeParamExist)
					{
						String logFileSelected = "";
						String jmxSelected = "";
						String modeTempVal = new String(paramValue);
						boolean isEnabled = false;
						boolean isDisabled = false;
						String requestModeValue = "";
						if (testName.equals(previousTestName))
						{
							requestModeValue = request.getParameter(paramName);
							requestModeValue = (requestModeValue==null)?"":requestModeValue;
						}

						if (!requestModeValue.equals(""))
						{
							modeTempVal = requestModeValue;
						}

						if (modeTempVal.equalsIgnoreCase("true"))
						{
							logFileSelected = "checked";
							isEnabled = true;
						}
						else
						{
							jmxSelected = "checked";
							isDisabled = true;
						}
						rootJson.put("enabled"+paramName,isEnabled);
						rootJson.put("disabled"+paramName,isDisabled);
						if (paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
						{
							rootJson.put("isValidateBtn",true);
							requiredParamNames=requiredParamNames+",passwordconfirmpassword";
						}
						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("Log File");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("JMX");
					}
					else if(paramName.equalsIgnoreCase("measurement_mode") && isMeasurementModeParamExist)
					{
						String warFileSelected = "";
						String jmxSelected = "";
						String modeTempVal = new String(paramValue);
						boolean isEnabled = false;
						boolean isDisabled = false;
						String requestModeValue = "";
						if (testName.equals(previousTestName))
						{
							requestModeValue = request.getParameter(paramName);
							requestModeValue = (requestModeValue==null)?"":requestModeValue;
						}

						if (!requestModeValue.equals(""))
						{
							modeTempVal = requestModeValue;
						}

						if (modeTempVal.equalsIgnoreCase("true"))
						{
							warFileSelected = "checked";
							isEnabled = true;
						}
						else
						{
							jmxSelected = "checked";
							isDisabled = true;
						}
						rootJson.put("enabled"+paramName,isEnabled);
						rootJson.put("disabled"+paramName,isDisabled);
						if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
						{
							rootJson.put("isValidateBtn",true);
							requiredParamNames=requiredParamNames+",passwordconfirmpassword";
						}
						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("War File");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("JMX");
					}
					//else if(paramName.equalsIgnoreCase("profiler") && isModeParamExist)
					//{
						//String profilerOn = "";
						//String profilerOff = "";
						//String profilerValue = new String(paramValue);
						//boolean isEnabled = false;
						//boolean isDisabled = false;

						//String requestProfilerValue = "";
						//if (testName.equals(previousTestName))
						//{
							//requestProfilerValue = request.getParameter(paramName);
							//requestProfilerValue = (requestProfilerValue==null)?"":requestProfilerValue;
						//}

						//if (!requestProfilerValue.equals(""))
						//{
							//profilerValue = requestProfilerValue;
						//}

						//if (profilerValue.equalsIgnoreCase("true"))
						//{
							//profilerOn = "checked";
							//isEnabled = true;
						//}
						//else
						//{
							//profilerOff = "checked";
							//isDisabled = true;
						//}
						//rootJson.put("enabled",isEnabled);
						//rootJson.put("disabled",isDisabled);

					//if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
					//{
								//requiredParamNames=requiredParamNames+",passwordconfirmpassword";


					//}
					//else
					//{
					//}

						//aListDisplay.add(paramName+"#"+"true");
						//aListDisplay.add("On");

						//aListDisplay.add(paramName+"#"+"false");
						//aListDisplay.add("Off");
					//}
					else if(paramName.equalsIgnoreCase("heap_analysis") && isModeParamExist)
					{
						String heapAnalysisYes = "";
						String heapAnalysisNo = "";
						String heapAnalysisValue = new String(paramValue);
						boolean isEnabled = false;
						boolean isDisabled = false;

						String requestHeapAnalysisValue = "";
						if (testName.equals(previousTestName))
						{
							requestHeapAnalysisValue = request.getParameter(paramName);
							requestHeapAnalysisValue = (requestHeapAnalysisValue==null)?"":requestHeapAnalysisValue;
						}

						if (!requestHeapAnalysisValue.equals(""))
						{
							heapAnalysisValue = requestHeapAnalysisValue;
						}

						if (heapAnalysisValue.equalsIgnoreCase("true"))
						{
							heapAnalysisYes = "checked";
							isEnabled = true;
						}
						else
						{
							heapAnalysisNo = "checked";
							isDisabled = true;
						}
						rootJson.put("enabledHeapAnalysis",isEnabled);
						rootJson.put("disabledHeapAnalysis",isDisabled);
						if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
						{
							rootJson.put("isValidateBtn",true);
							requiredParamNames=requiredParamNames+",passwordconfirmpassword";
						}
						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("Yes");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("No");
					}
					else if(paramName.equalsIgnoreCase("useAlias") && hasShowAliasParam)
					{
						String usealiasYes = "";
						String usealiasNo = "";
						String usealiasValue = new String(paramValue);
						boolean isEnabled = false;
						boolean isDisabled = false;

						String requestusealiasValue = "";
						if (testName.equals(previousTestName))
						{
							requestusealiasValue = request.getParameter(paramName);
							requestusealiasValue = (requestusealiasValue==null)?"":requestusealiasValue;
						}

						if (!requestusealiasValue.equals(""))
						{
							usealiasValue = requestusealiasValue;
						}
						if (usealiasValue.equalsIgnoreCase("true") || usealiasValue.equalsIgnoreCase("yes"))
						{
							usealiasYes = "checked";
							isEnabled = true;
						}
						else
						{
							usealiasNo = "checked";
							isDisabled = true;
						}
						rootJson.put("enabled"+paramName,isEnabled);
						rootJson.put("disabled"+paramName,isDisabled);

						if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
						{
							rootJson.put("isValidateBtn",true);
							requiredParamNames=requiredParamNames+",passwordconfirmpassword";
						}

						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("Yes");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("No");
					}
					else if (paramName.equalsIgnoreCase("showAllEvents") && hasShowAllOnlyParam)
					{
						String showalleventsYes = "";
						String showalleventsNo = "";
						String showalleventsValue = new String(paramValue);
						boolean isEnabled = false;
						boolean isDisabled = false;

						String requestshowalleventsValue = "";
						if (testName.equals(previousTestName))
						{
							requestshowalleventsValue = request.getParameter(paramName);
							requestshowalleventsValue = (requestshowalleventsValue==null)?"":requestshowalleventsValue;
						}

						if (!requestshowalleventsValue.equals(""))
						{
							showalleventsValue = requestshowalleventsValue;
						}
						if (showalleventsValue.equalsIgnoreCase("true") || showalleventsValue.equalsIgnoreCase("yes"))
						{
							showalleventsYes = "checked";
							isEnabled = true;
						}
						else
						{
							showalleventsNo = "checked";
							isDisabled = true;
						}
						rootJson.put("enabled"+paramName,isEnabled);
						rootJson.put("disabled"+paramName,isDisabled);
						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("Yes");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("No");
					}
					else if (paramName.equalsIgnoreCase("Report_total") && hasReportOnlyTotalParam)
					{
						String reporttotalYes = "";
						String reporttotalNo = "";
						String reporttotalValue = new String(paramValue);
						boolean isEnabled = false;
						boolean isDisabled = false;

						String requestreporttotalValue = "";
						if (testName.equals(previousTestName))
						{
							requestreporttotalValue = request.getParameter(paramName);
							requestreporttotalValue = (requestreporttotalValue==null)?"":requestreporttotalValue;
						}

						if (!requestreporttotalValue.equals(""))
						{
							reporttotalValue = requestreporttotalValue;
						}
						if (reporttotalValue.equalsIgnoreCase("true") || reporttotalValue.equalsIgnoreCase("yes"))
						{
							reporttotalYes = "checked";
							isEnabled = true;
						}
						else
						{
							reporttotalNo = "checked";
							isDisabled = true;
						}
						rootJson.put("enabled"+paramName,isEnabled);
						rootJson.put("disabled"+paramName,isDisabled);

						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("Yes");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("No");
					}
					else if (paramName.equalsIgnoreCase("adapter_device_selection"))
					{
						String automaticChecked = "checked";
						String manualChecked = "checked";
						boolean isEnabled = true;
						boolean isDisabled = true;

						if(paramValue == null ||  paramValue.equalsIgnoreCase("automatic"))
						{
							manualChecked = "";
							isDisabled = false;
						}
						else
						{
							automaticChecked = "";
							isEnabled = false;
						}
						rootJson.put("enabled"+paramName,isEnabled);
						rootJson.put("disabled"+paramName,isDisabled);
						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("Automatic");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("Manual");
					}
					else if (paramName.equalsIgnoreCase("action_on_descriptors"))
					{
						String automaticChecked = "checked";
						String manualChecked = "checked";
						boolean isEnabled = true;
						boolean isDisabled = true;

						if(paramValue == null ||  paramValue.equalsIgnoreCase("include"))
						{
							manualChecked = "";
							isDisabled = false;
						}
						else
						{
							automaticChecked = "";
							isEnabled = false;
						}
						rootJson.put("enabled"+paramName,isEnabled);
						rootJson.put("disabled"+paramName,isDisabled);
						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("Include");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("Exclude");
					}
					else if (paramName.equalsIgnoreCase("URL_Pattern_Discovery_Mode"))
					{
						String automaticChecked = "checked";
						String manualChecked = "checked";
						boolean isEnabled = true;
						boolean isDisabled = true;

						if(paramValue == null ||  paramValue.equalsIgnoreCase("true"))
						{
							manualChecked = "";
							isDisabled = false;
						}
						else
						{
							automaticChecked = "";
							isEnabled = false;
						}
						rootJson.put("enabled"+paramName,isEnabled);
						rootJson.put("disabled"+paramName,isDisabled);
						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("Automatic");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("Manual");
					}
					else if (paramName.equalsIgnoreCase("Is_Trail"))
					{
						boolean isEnabled = true;
						boolean isDisabled = true;

						if(paramValue == null ||  paramValue.equalsIgnoreCase("true"))
						{
							isDisabled = false;
						}
						else
						{
							isEnabled = false;
						}
						rootJson.put("enabled"+paramName,isEnabled);
						rootJson.put("disabled"+paramName,isDisabled);
						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("Yes");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("No");
					}
					else if (paramName.equalsIgnoreCase("use_sapcontrol"))
					{
						boolean isEnabled = true;
						boolean isDisabled = true;

						if(paramValue == null ||  paramValue.equalsIgnoreCase("true"))
						{
							isDisabled = false;
						}
						else
						{
							isEnabled = false;
						}
						rootJson.put("enabled"+paramName,isEnabled);
						rootJson.put("disabled"+paramName,isDisabled);
						aListDisplay.add(paramName+"#"+"true");
						aListDisplay.add("Yes");

						aListDisplay.add(paramName+"#"+"false");
						aListDisplay.add("No");
					}
					else
					{
						//handling independent parameter for radio - starts
						//handled yes,no,true,false,y and n only
						//block fires when the user forgets to put corresponding value
						//to the isolated radio parameter.Parameter are handled to their
						//default values.
						String value1 = "";
						String value2 = "";
						boolean isIndepParamEnabled = false;
						boolean isIndepParamDisabled = false;

						if (paramValue.equalsIgnoreCase("yes") || 
							paramValue.equalsIgnoreCase("no"))
						{
							value1 = "yes";
							value2 = "no";
						}
						else if (paramValue.equalsIgnoreCase("true") || 
							paramValue.equalsIgnoreCase("false"))
						{
							value1 = "true";
							value2 = "false";
							if(paramName.equalsIgnoreCase("aggregateDescriptor") && (testName.endsWith("_ag") || testName.endsWith("_agx")))
							{
								// touch me not if you don't know what i am doing
								// descriptors for aggregate test is needed when value1 is false
								// descriptors for aggregate test is not needed when value1 is true
								value1 = "false";
								value2 = "true";
							}
						}
						else
						{
							value1 = "y";
							value2 = "n";
						}

						String selectedParamValue = "";
						if (testName.equals(previousTestName))
						{
							selectedParamValue = request.getParameter(paramName);
							selectedParamValue = (selectedParamValue!=null)?selectedParamValue:"";
						}

						if (selectedParamValue.equals(""))
						{
							if(paramName.equalsIgnoreCase("aggregateDescriptor") && (testName.endsWith("_ag") || testName.endsWith("_agx")))
							{
								// touch me not if you don't know what i am doing
								if(paramValue.equalsIgnoreCase("false"))
								{
									enabled = "checked";
									disabled = "";
									isIndepParamEnabled = true;
									isIndepParamDisabled = false;
								}
								else
								{
									enabled = "";
									disabled = "checked";
									isIndepParamEnabled = false;
									isIndepParamDisabled = true;
								}
							}
							else
							{
								if (paramValue.equalsIgnoreCase("n") || 
									paramValue.equalsIgnoreCase("no") || 
									paramValue.equalsIgnoreCase("false"))
								{
									enabled = "";
									disabled = "checked";
									isIndepParamEnabled = false;
									isIndepParamDisabled = true;
								}
								else
								{
									enabled = "checked";
									disabled = "";
									isIndepParamEnabled = true;
									isIndepParamDisabled = false;
								}
							}
						}
						else
						{
							if(paramName.equalsIgnoreCase("aggregateDescriptor"))
							{
								// touch me not if you don't know what i am doing
								if(selectedParamValue.equalsIgnoreCase("false"))
								{
									enabled = "checked";
									disabled = "";
									isIndepParamEnabled = true;
									isIndepParamDisabled = false;
								}
								else
								{
									enabled = "";
									disabled = "checked";
									isIndepParamEnabled = false;
									isIndepParamDisabled = true;
								}
							}
							else if (selectedParamValue.equalsIgnoreCase("n") || 
								selectedParamValue.equalsIgnoreCase("no") || 
								selectedParamValue.equalsIgnoreCase("false"))
							{
								enabled = "";
								disabled = "checked";
								isIndepParamEnabled = false;
								isIndepParamDisabled = true;
							}
							else
							{
								enabled = "checked";
								disabled = "";
								isIndepParamEnabled = true;
								isIndepParamDisabled = false;
							}
						}
						rootJson.put("enabled"+paramName,isIndepParamEnabled);
						rootJson.put("disabled"+paramName,isIndepParamDisabled);
						rootJson.put("value1"+paramName,value1);
						rootJson.put("value2"+paramName,value2);
						if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
						{
							rootJson.put("isValidateBtn",true);
							requiredParamNames=requiredParamNames+",passwordconfirmpassword";
						}
						//handling independent parameter for radio - ends
					}
				}
			}
			else if (displayControl.equalsIgnoreCase("select"))
			{
				//Dependent Parameter - Having relationship with other parameters
				//For e.g., snmpVersion which has relations with snmpCommunity,AuthType,AuthPass,EncryptType,EncryptPass
				//Independent Parameter - Does not have relationship with other parameters
				//For e.g., alarmtype
				boolean isIndependentParam = aListDynamicSelectOptionNameAndValue.contains(paramName);
				rootJson.put("isIndependentParam"+paramName,isIndependentParam);
				if (isIndependentParam)
				{
					JSONArray independentParamArr = new JSONArray();
					JSONObject independentParamObj = new JSONObject();

					int strParamIdx = aListDynamicSelectOptionNameAndValue.indexOf(paramName);
					String strParamValue = (String)aListDynamicSelectOptionNameAndValue.get(strParamIdx+1);

					String selectedParamValue = "";
					if (testName.equals(previousTestName))
					{
						selectedParamValue = request.getParameter(paramName);
						selectedParamValue = (selectedParamValue != null)?selectedParamValue:"";
					}

					StringTokenizer st = new StringTokenizer(strParamValue,"#");
					while (st.hasMoreTokens())
					{
						String s = st.nextToken();
						String strText = s.substring(0,s.indexOf(":"));
						String strValue = s.substring(s.indexOf(":")+1,s.length());
						independentParamObj.put("displayField",strText);
						independentParamObj.put("valueField",strValue);
						aListDisplay.add(paramName+"#"+strValue);
						aListDisplay.add(strText);
						if (paramValue.equals(strValue))
						{
							rootJson.put("selectedIndParamValue"+paramName, paramValue);
						}
						else if (selectedParamValue.equals(strValue))
						{
							rootJson.put("selectedIndParamValue"+paramName, selectedParamValue);
						}
						independentParamArr.add(independentParamObj);
					}

					if (paramName.equalsIgnoreCase("pageTypesToBeincludedindashboard"))
					{
						if (paramValue.indexOf("~#~") > -1)
						{
							paramValue = StringUtils.replace(paramValue,"~#~",",");
						}

						rootJson.put("selectedIndParamValue"+paramName, paramValue);
						rootJson.put("fieldLabel"+paramName,_mapping.getTextDescription("admin.test."+paramName));
					}
					rootJson.put("independentParamArr"+paramName,independentParamArr);
				}
				else
				{
					if (paramName.startsWith("password_profile") && isEnablePwdProfile)
					{
						String temp = paramValue;
						String strVal = "";
						if (testName.equals(previousTestName))
						{
							strVal = request.getParameter(paramName);
						}
						paramValue = (strVal == null || strVal.equals(""))?temp:strVal;

						String selectedPwdProfile = getSelectedPwdProfile(componentType, componentName,  testName, paramName, pwdParamSetList, pwdProf);
						rootJson.put("selectedProfile"+paramName,selectedPwdProfile);

						String[] checkMultiUserParams = {"Published_resources","Connection_server_name"};
						if (isMultiUserParamExists(aResultant,checkMultiUserParams))
						{
							rootJson.put("isMultiUserParamExists",true);
						}
					}
					else if (paramName.equalsIgnoreCase("snmpversion") && isSnmp)
					{
						JSONArray snmpVersionArr = new JSONArray();
						JSONObject snmpVersionObj = new JSONObject();

						String temp = paramValue;
						String strVal = "";
						if (testName.equals(previousTestName))
						{
							strVal = request.getParameter(paramName);
						}

						paramValue = (strVal == null || strVal.equals(""))?temp:strVal;
						for(int k=0;k<versions.length;k++)
						{
							if(versions[k].equalsIgnoreCase(paramValue))
							{
								rootJson.put("selectedSnmpVersion",paramValue);
							}
							
							snmpVersionObj.put("displayField",versions[k]);
							snmpVersionObj.put("valueField",versions[k]);
							snmpVersionArr.add(snmpVersionObj);
						}
						rootJson.put("snmpVersionArr",snmpVersionArr);
					}
					else if (paramName.equalsIgnoreCase("authtype") && isSnmp)
					{
						JSONArray snmpAuthTypeArr = new JSONArray();
						JSONObject snmpAuthTypeObj = new JSONObject();

						String authTypeVal = paramValue;
						if (testName.equals(previousTestName))
						{
							authTypeVal = request.getParameter(paramName);
						}

						authTypeVal = (authTypeVal!=null)?authTypeVal:paramValue;
						for(int k=0;k<authTypes.length;k++)
						{
							if(authTypeVal.equals(authTypes[k]))
							{
								rootJson.put("selectedSnmpAuthType",authTypeVal);
							}
							
							snmpAuthTypeObj.put("displayField",authTypes[k]);
							snmpAuthTypeObj.put("valueField",authTypes[k]);
							snmpAuthTypeArr.add(snmpAuthTypeObj);
						}
						rootJson.put("snmpAuthTypeArr",snmpAuthTypeArr);
					}
					else if (paramName.equalsIgnoreCase("encrypttype") && isSnmp)
					{
						JSONArray snmpEncTypeArr = new JSONArray();
						JSONObject snmpEncTypeObj = new JSONObject();
						String encryptTypeVal = paramValue;
						if (testName.equals(previousTestName))
						{
							encryptTypeVal = request.getParameter(paramName);
						}

						encryptTypeVal = (encryptTypeVal!=null)?encryptTypeVal:paramValue;
						for(int k=0;k<encryptTypes.length;k++)
						{
							if(encryptTypeVal.equals(encryptTypes[k]))
							{
								rootJson.put("selectedSnmpEncType",encryptTypeVal);
							}
							
							snmpEncTypeObj.put("displayField",encryptTypes[k]);
							snmpEncTypeObj.put("valueField",encryptTypes[k]);
							snmpEncTypeArr.add(snmpEncTypeObj);
						}
						rootJson.put("snmpEncTypeArr",snmpEncTypeArr);
					}
					else if(paramName.equalsIgnoreCase("filter") && isPolicyParamExists)
					{
						int policyFilterIdx = aListResultantInLowerCase.indexOf("-policyfilter");
						//String jsonAPolicyFilter = StringUtils.getString(aPolicyFilter);
						//rootJson.put("aPolicyFilter",jsonAPolicyFilter);
						String policyFilterValue = "";
						if (testName.equals(previousTestName))
						{
							policyFilterValue = request.getParameter(((String)aResultant.get(policyFilterIdx)).substring(1));
							policyFilterValue = (policyFilterValue != null && policyFilterValue.length() > 0)?policyFilterValue:"";
						}
						if (policyFilterValue.equalsIgnoreCase("true"))
						{
							JSONArray filterArr = new JSONArray();
							JSONObject filterObj = new JSONObject();
							rootJson.put("isPolicyFilterValue","combo");
							ArrayList aListPolicy = new ArrayList();
							String select = "";
							String filterName = paramValue;
							if(filterName.indexOf(":") > -1)
							{
								if(filterName.indexOf(";") > -1)
								{
									StringTokenizer policyTokens = new StringTokenizer(filterName,";");
									while(policyTokens.hasMoreTokens())
									{
										String tempPolicy = policyTokens.nextToken();
										tempPolicy = tempPolicy.substring(0,tempPolicy.indexOf(":"));
										aListPolicy.add(tempPolicy);
									}
								}
								else
								{
									aListPolicy.add(filterName.substring(0,filterName.indexOf(":")));
								}
							}
							else if (filterName.indexOf(";") > -1)
							{
								StringTokenizer policyTokens = new StringTokenizer(filterName,";");
								while(policyTokens.hasMoreTokens())
								{
									String tempPolicy = policyTokens.nextToken();
									aListPolicy.add(tempPolicy);
								}
							}
							else
							{
								aListPolicy.add(filterName);
							}
							String audit_filters = "";
							String selectedPolicyFilter = "";
							for(int k=0;k<aPolicyFilter.size();k++)
							{
								audit_filters+=","+(String)aPolicyFilter.get(k);
								filterObj.put("displayField",aPolicyFilter.get(k));
								filterObj.put("valueField",aPolicyFilter.get(k));
								filterArr.add(filterObj);
								if(aListPolicy.contains(aPolicyFilter.get(k)))
								{
									selectedPolicyFilter += ","+aPolicyFilter.get(k);
								}
							}
							if(audit_filters.length()>0)
							{
								auditLogHt.put("filter",audit_filters.substring(1));
							}
							if (!StringUtils.isNull(selectedPolicyFilter))
							{
								selectedPolicyFilter = selectedPolicyFilter.substring(1);
							}
							rootJson.put("selectedPolicyFilter",selectedPolicyFilter);
							rootJson.put("filterArr",filterArr);
							rootJson.put("policyFilterValue",paramValue);
						}
						else if(policyFilterValue.length()==0 && paramValue.indexOf(":") > -1)
						{
							rootJson.put("isPolicyFilterValue","fieldContainer");
							//called while loading the page when policy filter value is "no"
							paramValue = StringUtils.replace(paramValue,"|",",");
							rootJson.put("policyFilterValue",paramValue);
							rootJson.put("btnLabel",_mapping.getTextDescription("admin.common.View"));
							if(paramValue.length()>0)
							{
								auditLogHt.put("filter",paramValue);
							}
						}
						else if(policyFilterValue.length()==0 && paramValue.indexOf(":") == -1)
						{
							rootJson.put("isPolicyFilterValue","combo");
							JSONArray filterArr = new JSONArray();
							JSONObject filterObj = new JSONObject();

							ArrayList aTemp = new ArrayList();
							if (paramValue.indexOf(";") > -1)
							{
								StringTokenizer st = new StringTokenizer(paramValue,";");
								while (st.hasMoreTokens())
								{
									aTemp.add(st.nextToken().trim());
								}
							}
							else
							{
								aTemp.add(paramValue);
							}
							String audit_filters="";
							String selectedPolicyFilter = "";
							for(int k=0;k<aPolicyFilter.size();k++)
							{
								audit_filters+=","+(String)aPolicyFilter.get(k);
								filterObj.put("displayField",aPolicyFilter.get(k));
								filterObj.put("valueField",aPolicyFilter.get(k));
								filterArr.add(filterObj);

								if(aTemp.contains((String)aPolicyFilter.get(k)))
								{
									selectedPolicyFilter += ","+aPolicyFilter.get(k);
								}
							}
							if (!StringUtils.isNull(selectedPolicyFilter))
							{
								selectedPolicyFilter = selectedPolicyFilter.substring(1);
							}
							if(audit_filters.length()>0)
							{
								auditLogHt.put("filter",audit_filters.substring(1));
							}
							rootJson.put("selectedPolicyFilter",selectedPolicyFilter);
							rootJson.put("filterArr",filterArr);
							rootJson.put("policyFilterValue",paramValue);
						}
						else if (policyFilterValue.equalsIgnoreCase("false"))//special case
						{
							rootJson.put("isPolicyFilterValue","fieldContainer");
							String tempPolicyFilterValue = "";
							for(int z=0;z<aPolicyFilter.size();z++)
							{
								if (z > 0)
								{
									tempPolicyFilterValue = tempPolicyFilterValue + ";";
								}

								tempPolicyFilterValue = tempPolicyFilterValue + (aPolicyFilter.get(z)).toString();
							}
							rootJson.put("policyFilterValue",tempPolicyFilterValue);
							rootJson.put("btnLabel",_mapping.getTextDescription("admin.common.View"));
						}
					}
					else if (paramName.equalsIgnoreCase("virtual_center"))
					{
						JSONArray virtualCenterArr = new JSONArray();
						JSONObject virtualCenterObj = new JSONObject();
						JSONObject virtualComboObj = new JSONObject();
						String selectedVirtualCenter = paramValue;
						if (testName.equals(previousTestName))
						{
							selectedVirtualCenter = request.getParameter(paramName);
						}
						selectedVirtualCenter = (selectedVirtualCenter!=null)?selectedVirtualCenter:paramValue;
						if (selectedVirtualCenter.equalsIgnoreCase("none"))
						{
							rootJson.put("selectedVirtualCenter","None");
						}
						else if (selectedVirtualCenter.equalsIgnoreCase("other"))
						{
							rootJson.put("selectedVirtualCenter","Other");
						}
						virtualCenterObj.put("displayField",_mapping.getTextDescription("admin.test.None"));
						virtualCenterObj.put("valueField","None");
						virtualCenterArr.add(virtualCenterObj);

						if (virtualCenters != null && virtualCenters.length > 0)
						{
							for (int k=0;k<virtualCenters.length;k++)
							{
								String eachVirtualCenter=virtualCenters[k];
								if (selectedVirtualCenter.equalsIgnoreCase(eachVirtualCenter))
								{
									rootJson.put("selectedVirtualCenter",selectedVirtualCenter);
								}
								virtualCenterObj.put("displayField",eachVirtualCenter);
								virtualCenterObj.put("valueField",eachVirtualCenter);
								virtualCenterArr.add(virtualCenterObj);
								String vCenterValue = servicesIniFile.getValue("VIRTUAL_CENTER",eachVirtualCenter);
								ArrayList tmpVCenterList  = StringUtils.egTokenizer(vCenterValue,"#");
								if (tmpVCenterList != null && !tmpVCenterList.isEmpty())
								{
									String replaceVCenterStr = "";
									for (int v = 0; v< tmpVCenterList.size();v++)
									{
										String tmpVCenListStr = (String) tmpVCenterList.get(v);
										if (v == 2)
										{
											if (!tmpVCenListStr.equals("$unconfigured"))
											{
												tmpVCenListStr = EgCrypt.decrypt(tmpVCenListStr);
												if (!aListTcKeywordsLowerCase.contains(tmpVCenListStr.toLowerCase()))
												{
													tmpVCenListStr += "~EG~"; // salt for pwd
													tmpVCenListStr = EgCrypt.encrypt(tmpVCenListStr); 
												}


												if (!StringUtils.isNull(tmpVCenListStr) && tmpVCenListStr.indexOf("#") != -1)
												{
													tmpVCenListStr = StringUtils.replace(tmpVCenListStr, EgConstants.HASH, "~HASH~");
												}
											}

										}
										replaceVCenterStr += tmpVCenListStr +"#";
									}
									if (replaceVCenterStr.endsWith("#"))
									{
										vCenterValue = replaceVCenterStr.substring(0,replaceVCenterStr.lastIndexOf("#"));
									}
								}
								virtualComboObj.put(eachVirtualCenter,vCenterValue);
							}
						}
						else
						{
							if (!selectedVirtualCenter.equalsIgnoreCase("none") && !selectedVirtualCenter.equalsIgnoreCase("other"))
							{
								virtualCenterObj.put("displayField",selectedVirtualCenter);
								virtualCenterObj.put("valueField",selectedVirtualCenter);
								virtualCenterArr.add(virtualCenterObj);
								rootJson.put("selectedVirtualCenter",selectedVirtualCenter);
								String vCenterValue = servicesIniFile.getValue("VIRTUAL_CENTER",selectedVirtualCenter);
								ArrayList tmpVCenterList  = StringUtils.egTokenizer(vCenterValue,"#");
								if (tmpVCenterList != null && !tmpVCenterList.isEmpty())
								{
									String replaceVCenterStr = "";
									for (int j = 0; j< tmpVCenterList.size();j++)
									{
										String tmpVCenListStr = (String) tmpVCenterList.get(j);
										if (j == 2)
										{
											if (!tmpVCenListStr.equals("$unconfigured"))
											{
												tmpVCenListStr = EgCrypt.decrypt(tmpVCenListStr);
												if (!aListTcKeywordsLowerCase.contains(tmpVCenListStr.toLowerCase()))
												{
													tmpVCenListStr += "~EG~"; // salt for pwd
													tmpVCenListStr = EgCrypt.encrypt(tmpVCenListStr); 
												}

												if (!StringUtils.isNull(tmpVCenListStr) && tmpVCenListStr.indexOf("#") != -1)
												{
													tmpVCenListStr = StringUtils.replace(tmpVCenListStr, EgConstants.HASH, "~HASH~");
												}
											}
										}
										replaceVCenterStr += tmpVCenListStr +"#";
									}
									if (replaceVCenterStr.endsWith("#"))
									{
										vCenterValue = replaceVCenterStr.substring(0,replaceVCenterStr.lastIndexOf("#"));
									}
								}
								virtualComboObj.put(selectedVirtualCenter,vCenterValue);
							}
						}
						virtualCenterObj.put("displayField",_mapping.getTextDescription("admin.test.Other"));
						virtualCenterObj.put("valueField","Other");
						virtualCenterArr.add(virtualCenterObj);

						rootJson.put("virtualComboObj",virtualComboObj);
						rootJson.put("virtualCenterArr",virtualCenterArr);
					}
					else if (paramName.equalsIgnoreCase("xms_ip"))
					{
						JSONArray xmsIPArr = new JSONArray();
						JSONObject xmsIPObj = new JSONObject();
						JSONObject xmsIPComboObj = new JSONObject();
						String selectedXMSIP = paramValue;
						if (testName.equals(previousTestName))
						{
							selectedXMSIP = request.getParameter(paramName);
						}
						selectedXMSIP = (selectedXMSIP!=null)?selectedXMSIP:paramValue;
						if (selectedXMSIP.equalsIgnoreCase("none"))
						{
							rootJson.put("selectedXMSIP","None");
						}
						else if (selectedXMSIP.equalsIgnoreCase("other"))
						{
							rootJson.put("selectedXMSIP","Other");
						}
						xmsIPObj.put("displayField",_mapping.getTextDescription("admin.test.None"));
						xmsIPObj.put("valueField","None");
						xmsIPArr.add(xmsIPObj);

						if (emcXMSIPs != null && emcXMSIPs.length > 0)
						{
							for (int k=0;k<emcXMSIPs.length;k++)
							{
								String eachVirtualCenter=emcXMSIPs[k];
								if (selectedXMSIP.equalsIgnoreCase(eachVirtualCenter))
								{
									rootJson.put("selectedXMSIP",selectedXMSIP);
								}
								xmsIPObj.put("displayField",eachVirtualCenter);
								xmsIPObj.put("valueField",eachVirtualCenter);
								xmsIPArr.add(xmsIPObj);
								String vCenterValue = servicesIniFile.getValue("EMC_XtremIO_4x",eachVirtualCenter);
								ArrayList tmpVCenterList  = StringUtils.egTokenizer(vCenterValue,"#");
								if (tmpVCenterList != null && !tmpVCenterList.isEmpty())
								{
									String replaceVCenterStr = "";
									for (int v = 0; v< tmpVCenterList.size();v++)
									{
										String tmpVCenListStr = (String) tmpVCenterList.get(v);
										if (v == 2)
										{
											if (!tmpVCenListStr.equals("$unconfigured"))
											{
												tmpVCenListStr = EgCrypt.decrypt(tmpVCenListStr);
												if (!aListTcKeywordsLowerCase.contains(tmpVCenListStr.toLowerCase()))
												{
													tmpVCenListStr += "~EG~"; // salt for pwd
													tmpVCenListStr = EgCrypt.encrypt(tmpVCenListStr); 
												}

												if (!StringUtils.isNull(tmpVCenListStr) && tmpVCenListStr.indexOf("#") != -1)
												{
													tmpVCenListStr = StringUtils.replace(tmpVCenListStr, EgConstants.HASH, "~HASH~");
												}
											}

										}
										replaceVCenterStr += tmpVCenListStr +"#";
									}
									if (replaceVCenterStr.endsWith("#"))
									{
										vCenterValue = replaceVCenterStr.substring(0,replaceVCenterStr.lastIndexOf("#"));
									}
								}
								xmsIPComboObj.put(eachVirtualCenter,vCenterValue);
							}
						}
						else
						{
							if (!selectedXMSIP.equalsIgnoreCase("none") && !selectedXMSIP.equalsIgnoreCase("other"))
							{
								xmsIPObj.put("displayField",selectedXMSIP);
								xmsIPObj.put("valueField",selectedXMSIP);
								xmsIPArr.add(xmsIPObj);
								rootJson.put("selectedXMSIP",selectedXMSIP);
								String vCenterValue = servicesIniFile.getValue("EMC_XtremIO_4x",selectedXMSIP);
								ArrayList tmpVCenterList  = StringUtils.egTokenizer(vCenterValue,"#");
								if (tmpVCenterList != null && !tmpVCenterList.isEmpty())
								{
									String replaceVCenterStr = "";
									for (int j = 0; j< tmpVCenterList.size();j++)
									{
										String tmpVCenListStr = (String) tmpVCenterList.get(j);
										if (j == 2)
										{
											if (!tmpVCenListStr.equals("$unconfigured"))
											{
												tmpVCenListStr = EgCrypt.decrypt(tmpVCenListStr);
												if (!aListTcKeywordsLowerCase.contains(tmpVCenListStr.toLowerCase()))
												{
													tmpVCenListStr += "~EG~"; // salt for pwd
													tmpVCenListStr = EgCrypt.encrypt(tmpVCenListStr); 
												}

												if (!StringUtils.isNull(tmpVCenListStr) && tmpVCenListStr.indexOf("#") != -1)
												{
													tmpVCenListStr = StringUtils.replace(tmpVCenListStr, EgConstants.HASH, "~HASH~");
												}
											}
										}
										replaceVCenterStr += tmpVCenListStr +"#";
									}
									if (replaceVCenterStr.endsWith("#"))
									{
										vCenterValue = replaceVCenterStr.substring(0,replaceVCenterStr.lastIndexOf("#"));
									}
								}
								xmsIPComboObj.put(selectedXMSIP,vCenterValue);
							}
						}
						xmsIPObj.put("displayField",_mapping.getTextDescription("admin.test.Other"));
						xmsIPObj.put("valueField","Other");
						xmsIPArr.add(xmsIPObj);

						rootJson.put("xmsIPComboObj",xmsIPComboObj);
						rootJson.put("xmsIPArr",xmsIPArr);
					}
					else if (paramName.equalsIgnoreCase("prism_ip"))
					{
						JSONArray prismArr = new JSONArray();
						JSONObject virtualCenterObj = new JSONObject();
						JSONObject virtualComboObj = new JSONObject();
						String selectedPrism = paramValue;
						if (testName.equals(previousTestName))
						{
							selectedPrism = request.getParameter(paramName);
						}
						selectedPrism = (selectedPrism!=null)?selectedPrism:paramValue;
						if (selectedPrism.equalsIgnoreCase("none"))
						{
							rootJson.put("selectedPrism","None");
						}
						else if (selectedPrism.equalsIgnoreCase("other"))
						{
							rootJson.put("selectedPrism","Other");
						}
						virtualCenterObj.put("displayField",_mapping.getTextDescription("admin.test.None"));
						virtualCenterObj.put("valueField","None");
						prismArr.add(virtualCenterObj);

						if (nutanixPrisms != null && nutanixPrisms.length > 0)
						{
							for (int k=0;k<nutanixPrisms.length;k++)
							{
								String eachVirtualCenter=nutanixPrisms[k];
								if (selectedPrism.equalsIgnoreCase(eachVirtualCenter))
								{
									rootJson.put("selectedPrism",selectedPrism);
								}
								virtualCenterObj.put("displayField",eachVirtualCenter);
								virtualCenterObj.put("valueField",eachVirtualCenter);
								prismArr.add(virtualCenterObj);
								String vCenterValue = servicesIniFile.getValue("NUTANIX",eachVirtualCenter);
								ArrayList tmpVCenterList  = StringUtils.egTokenizer(vCenterValue,"#");
								if (tmpVCenterList != null && !tmpVCenterList.isEmpty())
								{
									String replaceVCenterStr = "";
									for (int v = 0; v< tmpVCenterList.size();v++)
									{
										String tmpVCenListStr = (String) tmpVCenterList.get(v);
										if (v == 2)
										{
											if (!tmpVCenListStr.equals("$unconfigured"))
											{
												tmpVCenListStr = EgCrypt.decrypt(tmpVCenListStr);
												if (!aListTcKeywordsLowerCase.contains(tmpVCenListStr.toLowerCase()))
												{
													tmpVCenListStr += "~EG~"; // salt for pwd
													tmpVCenListStr = EgCrypt.encrypt(tmpVCenListStr); 
												}

												if (!StringUtils.isNull(tmpVCenListStr) && tmpVCenListStr.indexOf("#") != -1)
												{
													tmpVCenListStr = StringUtils.replace(tmpVCenListStr, EgConstants.HASH, "~HASH~");
												}
											}
										}
										replaceVCenterStr += tmpVCenListStr +"#";
									}
									if (replaceVCenterStr.endsWith("#"))
									{
										vCenterValue = replaceVCenterStr.substring(0,replaceVCenterStr.lastIndexOf("#"));
									}
								}
								virtualComboObj.put(eachVirtualCenter,vCenterValue);
							}
						}
						else
						{
							if (!selectedPrism.equalsIgnoreCase("none") && !selectedPrism.equalsIgnoreCase("other"))
							{
								virtualCenterObj.put("displayField",selectedPrism);
								virtualCenterObj.put("valueField",selectedPrism);
								prismArr.add(virtualCenterObj);
								rootJson.put("selectedPrism",selectedPrism);
								String vCenterValue = servicesIniFile.getValue("NUTANIX",selectedPrism);
								ArrayList tmpVCenterList  = StringUtils.egTokenizer(vCenterValue,"#");
								if (tmpVCenterList != null && !tmpVCenterList.isEmpty())
								{
									String replaceVCenterStr = "";
									for (int j = 0; j< tmpVCenterList.size();j++)
									{
										String tmpVCenListStr = (String) tmpVCenterList.get(j);
										if (j == 2)
										{
											if (!tmpVCenListStr.equals("$unconfigured"))
											{
												tmpVCenListStr = EgCrypt.decrypt(tmpVCenListStr);
												if (!aListTcKeywordsLowerCase.contains(tmpVCenListStr.toLowerCase()))
												{
													tmpVCenListStr += "~EG~"; // salt for pwd
													tmpVCenListStr = EgCrypt.encrypt(tmpVCenListStr); 
												}

												if (!StringUtils.isNull(tmpVCenListStr) && tmpVCenListStr.indexOf("#") != -1)
												{
													tmpVCenListStr = StringUtils.replace(tmpVCenListStr, EgConstants.HASH, "~HASH~");
												}
											}
										}
										replaceVCenterStr += tmpVCenListStr +"#";
									}
									if (replaceVCenterStr.endsWith("#"))
									{
										vCenterValue = replaceVCenterStr.substring(0,replaceVCenterStr.lastIndexOf("#"));
									}
								}
								virtualComboObj.put(selectedPrism,vCenterValue);
							}
						}
						virtualCenterObj.put("displayField",_mapping.getTextDescription("admin.test.Other"));
						virtualCenterObj.put("valueField","Other");
						prismArr.add(virtualCenterObj);

						rootJson.put("virtualComboObj",virtualComboObj);
						rootJson.put("prismArr",prismArr);
					}
					/////////////////////// RHEV Code Starts
					else if (paramName.equalsIgnoreCase("Rhel_mgr_host"))
					{
						JSONArray rhelMgrHostArr = new JSONArray();
						JSONObject rhelMgrHostObj = new JSONObject();
						JSONObject rhevComboObj = new JSONObject();

						String selectedRhevMgr = paramValue;//rhevManager
						if (testName.equals(previousTestName))
						{
							selectedRhevMgr = request.getParameter(paramName);
						}
						selectedRhevMgr = (selectedRhevMgr!=null)?selectedRhevMgr:paramValue;
						if (selectedRhevMgr.equalsIgnoreCase("$unconfigured"))
						{
							selectedRhevMgr = "None";
						}
						if (selectedRhevMgr.equalsIgnoreCase("none"))
						{
							rootJson.put("selectedRhelMgrHost","None");
						}
						else if (selectedRhevMgr.equalsIgnoreCase("other"))
						{
							rootJson.put("selectedRhelMgrHost","Other");
						}
						rootJson.put("selectedRhelMgrHost",selectedRhevMgr);
						rhelMgrHostObj.put("displayField",_mapping.getTextDescription("admin.test.Choose an RHEV Manager"));
						rhelMgrHostObj.put("valueField","None");
						rhelMgrHostArr.add(rhelMgrHostObj);
						if (rhevs != null && rhevs.length > 0)
						{
							for (int k=0;k<rhevs.length;k++)
							{
								String eachRhev=rhevs[k];
								if (selectedRhevMgr.equalsIgnoreCase(eachRhev))
								{
									rootJson.put("selectedRhelMgrHost",selectedRhevMgr);
								}
								rhelMgrHostObj.put("displayField",eachRhev);
								rhelMgrHostObj.put("valueField",eachRhev);
								rhelMgrHostArr.add(rhelMgrHostObj);
								String rhevValue = servicesIniFile.getValue("RHEV",eachRhev);
								ArrayList tmpRHEVList  = StringUtils.egTokenizer(rhevValue,"#");
								if (tmpRHEVList != null && !tmpRHEVList.isEmpty())
								{
									String replaceRHEVStr = "";
									for (int v = 0; v< tmpRHEVList.size();v++)
									{
										String tmpRHEVListStr = (String) tmpRHEVList.get(v);
										if (v == 2)
										{
											if (!tmpRHEVListStr.equals("$unconfigured"))
											{
												tmpRHEVListStr = EgCrypt.decrypt(tmpRHEVListStr);
												if (!aListTcKeywordsLowerCase.contains(tmpRHEVListStr.toLowerCase()))
												{
													tmpRHEVListStr += "~EG~"; // salt for pwd
													tmpRHEVListStr = EgCrypt.encrypt(tmpRHEVListStr); 
												}

												if (!StringUtils.isNull(tmpRHEVListStr) && tmpRHEVListStr.indexOf("#") != -1)
												{
													tmpRHEVListStr = StringUtils.replace(tmpRHEVListStr, EgConstants.HASH, "~HASH~");
												}
											}
										}
										replaceRHEVStr += tmpRHEVListStr +"#";
									}
									if (replaceRHEVStr.endsWith("#"))
									{
										rhevValue = replaceRHEVStr.substring(0,replaceRHEVStr.lastIndexOf("#"));
									}
								}
								rhevComboObj.put(eachRhev,rhevValue);
							}
						}
						else
						{
							if (!selectedRhevMgr.equalsIgnoreCase("none") && !selectedRhevMgr.equalsIgnoreCase("other"))
							{
								rhelMgrHostObj.put("displayField",selectedRhevMgr);
								rhelMgrHostObj.put("valueField",selectedRhevMgr);
								rhelMgrHostArr.add(rhelMgrHostObj);
								rootJson.put("selectedRhelMgrHost",selectedRhevMgr);
								String rhevValue = servicesIniFile.getValue("RHEV",selectedRhevMgr);
								ArrayList tmpRHEVList  = StringUtils.egTokenizer(rhevValue,"#");
								if (tmpRHEVList != null && !tmpRHEVList.isEmpty())
								{
									String replaceRHEVStr = "";
									for (int v = 0; v< tmpRHEVList.size();v++)
									{
										String tmpRHEVListStr = (String) tmpRHEVList.get(v);
										if (v == 2)
										{
											if (!tmpRHEVListStr.equals("$unconfigured"))
											{
												tmpRHEVListStr = EgCrypt.decrypt(tmpRHEVListStr);
												if (!aListTcKeywordsLowerCase.contains(tmpRHEVListStr.toLowerCase()))
												{
													tmpRHEVListStr += "~EG~"; // salt for pwd
													tmpRHEVListStr = EgCrypt.encrypt(tmpRHEVListStr); 
												}

												if (!StringUtils.isNull(tmpRHEVListStr) && tmpRHEVListStr.indexOf("#") != -1)
												{
													tmpRHEVListStr = StringUtils.replace(tmpRHEVListStr, EgConstants.HASH, "~HASH~");
												}
											}

										}
										replaceRHEVStr += tmpRHEVListStr +"#";
									}
									if (replaceRHEVStr.endsWith("#"))
									{
										rhevValue = replaceRHEVStr.substring(0,replaceRHEVStr.lastIndexOf("#"));
									}
								}
								rhevComboObj.put(selectedRhevMgr,rhevValue);
							}
						}
						rhelMgrHostObj.put("displayField",_mapping.getTextDescription("admin.test.Other"));
						rhelMgrHostObj.put("valueField","Other");
						rhelMgrHostArr.add(rhelMgrHostObj);
						rootJson.put("rhelMgrHostArr",rhelMgrHostArr);
						rootJson.put("rhevComboObj",rhevComboObj);
					}
					//////////////// RHEV code ends
					else if (paramName.equalsIgnoreCase("management_server"))
					{
						String selectedHMC = paramValue;
						if (testName.equals(previousTestName))
						{
							selectedHMC = request.getParameter(paramName);
						}
						selectedHMC = (selectedHMC!=null)?selectedHMC:paramValue;

						boolean showTextBox = false;
						String strIsManagedByChanged = request.getParameter("isManagedByChanged");
						if (strIsManagedByChanged == null)
						{
							if (resIsManagedByValue.equalsIgnoreCase("ivm"))
							{
								showTextBox = true;
							}
						}
						else if (strIsManagedByChanged != null && strIsManagedByChanged.equalsIgnoreCase("true"))
						{
							String tempManagedBy = request.getParameter("is_managed_by");
							String tempMgmtServerVal = (String)request.getAttribute("management_server");
							if (tempMgmtServerVal != null)
							{
								paramValue = tempMgmtServerVal;
							}

							if (tempManagedBy != null && tempManagedBy.equalsIgnoreCase("ivm"))
							{
								showTextBox = true;
							}
						}
						rootJson.put("showTextBox"+paramName,showTextBox);
						//if (showTextBox)
						{
							rootJson.put("mgmtTextValue",paramValue);
						}
						//else
						{
							JSONArray mgmtServerArr = new JSONArray();
							JSONObject mgmtServerObj = new JSONObject();
							JSONObject hmcComboObj = new JSONObject();

							if (selectedHMC.equalsIgnoreCase("none"))
							{
								rootJson.put("selectedHMC","None");
							}
							else if (selectedHMC.equalsIgnoreCase("other"))
							{
								rootJson.put("selectedHMC","Other");
							}
							mgmtServerObj.put("displayField",_mapping.getTextDescription("admin.test.None"));
							mgmtServerObj.put("valueField","None");
							mgmtServerArr.add(mgmtServerObj);

							if (hmcs != null && hmcs.length > 0)
							{
								for (int k=0;k<hmcs.length;k++)
								{
									String eachHMC=hmcs[k];
									if (selectedHMC.equalsIgnoreCase(eachHMC))
									{
										rootJson.put("selectedHMC",eachHMC);
									}

									String hmcValue = servicesIniFile.getValue("HMC",eachHMC);
									ArrayList tmpHMCList  = StringUtils.egTokenizer(hmcValue,"#");
									if (tmpHMCList != null && !tmpHMCList.isEmpty())
									{
										String replaceHMCStr = "";
										for (int v = 0; v< tmpHMCList.size();v++)
										{
											String tmpHMCListStr = (String) tmpHMCList.get(v);
											if (v == 2)
											{
												if (!tmpHMCListStr.equals("$unconfigured"))
												{
													tmpHMCListStr = EgCrypt.decrypt(tmpHMCListStr);
													if (!aListTcKeywordsLowerCase.contains(tmpHMCListStr.toLowerCase()))
													{
														tmpHMCListStr += "~EG~"; // salt for pwd
														tmpHMCListStr = EgCrypt.encrypt(tmpHMCListStr); 
													}

													if (!StringUtils.isNull(tmpHMCListStr) && tmpHMCListStr.indexOf("#") != -1)
													{
														tmpHMCListStr = StringUtils.replace(tmpHMCListStr, EgConstants.HASH, "~HASH~");
													}
												}

											}
											replaceHMCStr += tmpHMCListStr +"#";
										}
										if (replaceHMCStr.endsWith("#"))
										{
											hmcValue = replaceHMCStr.substring(0,replaceHMCStr.lastIndexOf("#"));
										}
									}

									hmcComboObj.put(eachHMC,hmcValue);
									if (eachHMC.equals("None") || eachHMC.equals("Other"))
									{
										continue;
									}
									mgmtServerObj.put("displayField",eachHMC);
									mgmtServerObj.put("valueField",eachHMC);
									mgmtServerArr.add(mgmtServerObj);
								}
							}
							else
							{
								if (!selectedHMC.equalsIgnoreCase("none") && !selectedHMC.equalsIgnoreCase("other"))
								{
									mgmtServerObj.put("displayField",selectedHMC);
									mgmtServerObj.put("valueField",selectedHMC);
									mgmtServerArr.add(mgmtServerObj);
									rootJson.put("selectedHMC",selectedHMC);
									String hmcValue = servicesIniFile.getValue("HMC",selectedHMC);
									ArrayList tmpHMCList  = StringUtils.egTokenizer(hmcValue,"#");
									if (tmpHMCList != null && !tmpHMCList.isEmpty())
									{
										String replaceHMCStr = "";
										for (int v = 0; v< tmpHMCList.size();v++)
										{
											String tmpHMCListStr = (String) tmpHMCList.get(v);
											if (v == 2)
											{
												if (!tmpHMCListStr.equals("$unconfigured"))
												{
													tmpHMCListStr = EgCrypt.decrypt(tmpHMCListStr);
													
													if (!aListTcKeywordsLowerCase.contains(tmpHMCListStr.toLowerCase()))
													{
														tmpHMCListStr += "~EG~"; // salt for pwd
														tmpHMCListStr = EgCrypt.encrypt(tmpHMCListStr); 
													}

													if (!StringUtils.isNull(tmpHMCListStr) && tmpHMCListStr.indexOf("#") != -1)
													{
														tmpHMCListStr = StringUtils.replace(tmpHMCListStr, EgConstants.HASH, "~HASH~");
													}
												}

											}
											replaceHMCStr += tmpHMCListStr +"#";
										}
										if (replaceHMCStr.endsWith("#"))
										{
											hmcValue = replaceHMCStr.substring(0,replaceHMCStr.lastIndexOf("#"));
										}
									}
									hmcComboObj.put(selectedHMC,hmcValue);
								}
							}
							mgmtServerObj.put("displayField",_mapping.getTextDescription("admin.test.Other"));
							mgmtServerObj.put("valueField","Other");
							mgmtServerArr.add(mgmtServerObj);
							rootJson.put("mgmtServerArr",mgmtServerArr);
							rootJson.put("hmcComboObj",hmcComboObj);
						}
					}
					else if (paramName.equalsIgnoreCase("executiontime"))
					{
						JSONArray execTimeArr = new JSONArray();
						JSONObject execTimeObj = new JSONObject();

						rootJson.put("isExecutionTimeParam",true);
						String selectedOption = "";
						if (testName.equals(previousTestName))
						{
							selectedOption = request.getParameter(paramName);
							selectedOption = (selectedOption != null && selectedOption.length() > 0)?selectedOption:"";
						}

						boolean isTimeComboHide = false;
						String hourlySelected = "";
						String dailySelected = "";
						if (selectedOption.equals("") && paramValue.equalsIgnoreCase("hourly"))
						{
							hourlySelected = "selected";
							rootJson.put("selectedExecTime","hourly");
							isTimeComboHide = true;
						}
						else if(!selectedOption.equals("") && selectedOption.equalsIgnoreCase("hourly"))
						{
							hourlySelected = "selected";
							rootJson.put("selectedExecTime","hourly");
							isTimeComboHide = true;
						}
						else
						{
							dailySelected = "selected";
							rootJson.put("selectedExecTime","daily");
							isTimeComboHide = false;
						}

						ArrayList hours = new ArrayList();
						for (int m=0;m<24;m++)
						{
							if (m < 10)
							{
								hours.add("0"+String.valueOf(m));
							}
							else
							{
								hours.add(String.valueOf(m));
							}
						}

						ArrayList minutes = new ArrayList();
						for (int m=0;m<60;m++)
						{
							if (m < 10)
							{
								minutes.add("0"+String.valueOf(m));
							}
							else
							{
								minutes.add(String.valueOf(m));
							}
						}
						execTimeObj.put("displayField",_mapping.getTextDescription("admin.test.Hourly"));
						execTimeObj.put("valueField","hourly");
						execTimeArr.add(execTimeObj);
						execTimeObj.put("displayField",_mapping.getTextDescription("admin.test.Daily"));
						execTimeObj.put("valueField","daily");
						execTimeArr.add(execTimeObj);
						rootJson.put("execTimeArr",execTimeArr);
						rootJson.put("dailySelected",dailySelected);
						rootJson.put("isTimeComboHide",isTimeComboHide);
						if (true)//dailySelected.equals("selected"))
						{
							JSONArray execTimeHrsArr = new JSONArray();
							JSONObject execTimeHrsObj = new JSONObject();
							JSONArray execTimeMinsArr = new JSONArray();
							JSONObject execTimeMinsObj = new JSONObject();

							if (!(paramValue.indexOf(":")>-1)) paramValue="00:00";
							String selectedHr = paramValue.substring(0,paramValue.indexOf(":"));
							String selectedMin = paramValue.substring(paramValue.indexOf(":")+1,paramValue.length());

							for (int m=0;m<hours.size();m++)
							{
								String hrs = ((String)hours.get(m)).trim();
								execTimeHrsObj.put("displayField",hrs);
								execTimeHrsObj.put("valueField",hrs);
								execTimeHrsArr.add(execTimeHrsObj);
								if (selectedHr.equals(hrs))
								{
									rootJson.put("selectedHrs",hrs);
								}
							}
							rootJson.put("execTimeHrsArr",execTimeHrsArr);
							for (int m=0;m<minutes.size();m++)
							{
								String mins = ((String)minutes.get(m)).trim();
								execTimeMinsObj.put("displayField",mins);
								execTimeMinsObj.put("valueField",mins);
								execTimeMinsArr.add(execTimeMinsObj);

								if (selectedMin.equals(mins))
								{
									rootJson.put("selectedMins",mins);
								}
							}
							rootJson.put("execTimeMinsArr",execTimeMinsArr);
						}
					}
					else if (paramName.equalsIgnoreCase("Inside_view_using"))
					{
						JSONArray insideViewUsingArr = new JSONArray();
						JSONObject insideViewUsingObj = new JSONObject();

						String exeSelected = "";
						String tcpSelected = "";
						if (paramValue.equalsIgnoreCase("exe"))
						{
							exeSelected = "selected";
						}
						else if(paramValue.equalsIgnoreCase("tcp") || paramValue.equalsIgnoreCase("wmi"))
						{
							tcpSelected = "selected";
						}
						rootJson.put("selectedInsideViewUsing",paramValue);
						insideViewUsingObj.put("displayField",_mapping.getTextDescription("admin.test.Netbios (Windows)"));
						insideViewUsingObj.put("valueField","exe");
						insideViewUsingArr.add(insideViewUsingObj);
						insideViewUsingObj.put("displayField",_mapping.getTextDescription("admin.test.TCP/WMI (Windows)"));
						insideViewUsingObj.put("valueField","tcp");
						insideViewUsingArr.add(insideViewUsingObj);
						rootJson.put("insideViewUsingArr",insideViewUsingArr);
					}
					else if (paramName.equalsIgnoreCase("is_managed_by"))
					{
						JSONArray managedByArr = new JSONArray();
						JSONObject managedByObj = new JSONObject();
						String hmcSelected = "";
						String ivmSelected = "";
						if (testName.equals(previousTestName))
						{
							String strManagedBy = request.getParameter(paramName);
							if (strManagedBy != null)
							{
								paramValue = strManagedBy;
							}
						}

						if (paramValue.equalsIgnoreCase("hmc"))
						{
							hmcSelected = "selected";
						}
						else if(paramValue.equalsIgnoreCase("ivm"))
						{
							ivmSelected = "selected";
						}
						rootJson.put("selectedIsManagedBy",paramValue);
						managedByObj.put("displayField",_mapping.getTextDescription("admin.test.HMC"));
						managedByObj.put("valueField","HMC");
						managedByArr.add(managedByObj);
						managedByObj.put("displayField",_mapping.getTextDescription("admin.test.IVM"));
						managedByObj.put("valueField","IVM");
						managedByArr.add(managedByObj);
						rootJson.put("managedByArr",managedByArr);
					}
					else if(paramName.equalsIgnoreCase("device_name"))
					{
						JSONArray deviceNameArr = new JSONArray();
						JSONObject deviceNameObj = new JSONObject();
						if(paramValue.equalsIgnoreCase("Default"))
						{
							deviceNameObj.put("displayField",paramValue);
							deviceNameObj.put("valueField",paramValue);
							deviceNameArr.add(deviceNameObj);
						}
						else
						{
							deviceNameObj.put("displayField",paramValue);
							deviceNameObj.put("valueField",paramValue);
							deviceNameArr.add(deviceNameObj);
							rootJson.put("selectedDeviceName",paramValue);
						}
						rootJson.put("discoverBtnLabel",_mapping.getTextDescription("admin.common.Discover"));
						rootJson.put("discoverBtnLink","javascript:loadAdapters()");
						rootJson.put("deviceNameArr",deviceNameArr);
					}
					else
					{
						JSONArray lastComboArr = new JSONArray();
						JSONObject lastComboObj = new JSONObject();
						lastComboObj.put("displayField",paramValue);
						lastComboObj.put("valueField",paramValue);
						lastComboArr.add(lastComboObj);
						rootJson.put("selectedLastCombo",paramValue);
						rootJson.put("lastComboArr",lastComboArr);
					}
				}
			}
			else if (displayControl.equalsIgnoreCase("password") )
			{
				boolean isEditable = false;
				if (isSnmp)
				{
					String temp = paramValue;
					String strVal = null;
					if (testName.equals(previousTestName))
					{
						strVal = request.getParameter(paramName);
					}
					paramValue = (strVal==null)?temp:strVal;
					if (paramName.equals("authpass") || paramName.equals("encryptpassword"))
					{
						requiredParamNames=requiredParamNames+","+paramName+"confirmpassword";
					}
				}
				else if (paramName.equalsIgnoreCase("management_password"))
				{
					String strIsManagedByChanged = request.getParameter("isManagedByChanged");
					if (strIsManagedByChanged != null && strIsManagedByChanged.equals("true"))
					{
						String tempPassValue = (String)request.getAttribute("management_password");
						if (tempPassValue != null)
						{
							paramValue = tempPassValue;
							rootJson.put("isStrMangedByChanged",true);
						}
					}
					rootJson.put("tempPassValue",EgCrypt.decrypt(paramValue));
				}

				if(paramValue.indexOf("|") > -1)
				{
					String tempStr = "";
					StringTokenizer st1 = new StringTokenizer(paramValue,"|");
					while(st1.hasMoreTokens())
					{
						String tmpPwd =  EgCrypt.decrypt(st1.nextToken());

						if (!aListTcKeywordsLowerCase.contains(tmpPwd.toLowerCase()))
						{
							tmpPwd += "~EG~"; 
							tmpPwd = EgCrypt.encrypt(tmpPwd); 
						}
						tempStr += tmpPwd + "#~#";

					}
					paramValue = tempStr.substring(0, tempStr.length()-3);
					//rootJson.put("tempPipeParamValue",paramValue);
				}
				else
				{
					paramValue = EgCrypt.decrypt(paramValue);
					//rootJson.put("tempPipeParamValue",paramValue);


					if(paramValue.indexOf("#~#") > -1)
					{
						String tempStr = "";
						ArrayList st1 = StringUtils.myTokenizer(paramValue, "#~#");
						for(int m=0;m<st1.size();m++)
						{
							String tmpPwd =  EgCrypt.decrypt(st1.get(m).toString());

							if (paramName.equals("Two_factor_auth_password") && tmpPwd.equalsIgnoreCase("none"))
							{
								tmpPwd = tmpPwd.toLowerCase();
							}

							//if (!aListTcKeywordsLowerCase.contains(tmpPwd.toLowerCase()))
							{
								tmpPwd += "~EG~"; 
								tmpPwd = EgCrypt.encrypt(tmpPwd); 
							}
							tempStr += tmpPwd + "#~#";
						}
						paramValue = tempStr.substring(0, tempStr.length()-3);
						//rootJson.put("tempPipeParamValue",paramValue);
					}
					else if (!aListTcKeywordsLowerCase.contains(paramValue.toLowerCase()))
					{
						if (paramName.equals("Two_factor_auth_password") && paramValue.equalsIgnoreCase("none"))
						{
							paramValue = paramValue.toLowerCase();
						}
						paramValue += "~EG~"; 
						paramValue = EgCrypt.encrypt(paramValue); 
					}
				}

		//		if (paramValue.indexOf("\"") > -1)
		//		{
		//			paramValue = StringUtils.replace(paramValue,"\"","&#34;");
					//rootJson.put("doubleQuoteParamValue",paramValue);
		//		}

				if (readOnlyParamIdx > -1 && multiUserMode && hasMultipleUsers)
				{
					readOnly = "readOnly";
					isEditable = true;
				}
				if (readOnlyParamIdx > -1 && multiNamePatternMode && hasMultipleNames)
				{
					readOnly = "readOnly";
					isEditable = true;
				}
				if (readOnlyParamIdx > -1 && multiOidsMode && hasMultipleOid)
				{
					readOnly = "readOnly";
					isEditable = true;
				}
				if(paramValue != null && paramValue.equalsIgnoreCase("none"))
				{
					auditLogHt.put(paramName,EgCrypt.encrypt(paramValue));
				}
				rootJson.put("password"+paramName,paramValue);
				rootJson.put("isEditable"+paramName,isEditable);
				
				String confirmPassLabel=egTestParamIni.getValue("CONFIRM_PASSWORD_LABEL",paramName);
				String confPassTxt = _mapping.getTextDescription("CONFIRM PASSWORD");
				if (!StringUtils.isNull(confirmPassLabel) && confirmPassLabel.length() > 0)
				{
					confPassTxt = confirmPassLabel;
				}

				if (!readOnly.equals("readOnly"))
				{
					if (showStar)
					{
						paramNameObj.put(paramName+"confirmpassword","*&nbsp;"+confPassTxt);
						originalParamNameObj.put(paramName.toUpperCase()+"CONFIRMPASSWORD",paramName+"confirmpassword");
					}
					else
					{
						paramNameObj.put(paramName+"confirmpassword",confPassTxt);
						originalParamNameObj.put(paramName.toUpperCase()+"CONFIRMPASSWORD",paramName+"confirmpassword");
					}
					boolean isParamExists = false;
					if(paramForDisplayingValidateButton != null && paramForDisplayingValidateButton.indexOf(",") > 0)
					{
						StringTokenizer validateParamTokens = new StringTokenizer(paramForDisplayingValidateButton, ",");
						while(validateParamTokens.hasMoreTokens())
						{
							String tempParam = validateParamTokens.nextToken();
							if(tempParam.equalsIgnoreCase(paramName))
							{
								isParamExists = true;
							}
						}
					}
					if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName)|| isParamExists)
					{
						rootJson.put("isValidateBtn",true);
						requiredParamNames=requiredParamNames+",passwordconfirmpassword";
					}
					else
					{
						if (isXDMGetDevicesInfo)
						{
							rootJson.put("isValidateBtn",true);
						}
					}
				}
				else
				{
					paramNameObj.put(paramName+"confirmpassword",confPassTxt);
					originalParamNameObj.put(paramName.toUpperCase()+"CONFIRMPASSWORD",paramName+"confirmpassword");
				}
			}
			else if (displayControl.equalsIgnoreCase("textarea"))
			{
				String temp = paramValue;
				String strVal = null;
				if (testName.equals(previousTestName))
				{
					strVal = request.getParameter(paramName);
				}
				paramValue = (strVal==null)?temp:strVal;

				if (paramValue.indexOf(EgConstants.PIPE) > -1)
				{
					paramValue = StringUtils.replace(paramValue, EgConstants.PIPE, EgConstants.COMMA);
					rootJson.put("pipeParamValue",paramValue);
				}
				boolean tmpBoolean = agentInfo.isAgentlessServer(componentNickName,componentType);
				rootJson.put("isCompAgentless", tmpBoolean);
				boolean isAgentInstalledAndRunning = false;
				if((paramName.equalsIgnoreCase("serviceName") 
					|| paramName.equalsIgnoreCase("process")) 
					&& !agentInfo.isAgentlessServer(componentNickName,componentType))
				{
					com.eg.EgServerList serverList = new com.eg.EgServerList();
					ArrayList aList_A = new ArrayList();
					aList_A.add((String)listAgents.get(0));
					ArrayList aList_B = serverList.getAgentList(aList_A);
					if (aList_B != null && !aList_B.isEmpty())
					{
						String agentStatus = (String)aList_B.get(1);
						if (agentStatus.equalsIgnoreCase("Installed-Running"))
						{
							isAgentInstalledAndRunning = true;
						}
					}
				}
				rootJson.put("isAgentInstalledAndRunning",isAgentInstalledAndRunning);
				if(paramName.equalsIgnoreCase("serviceName") 
					&& !agentInfo.isAgentlessServer(componentNickName,componentType) 
					&& isAgentInstalledAndRunning)
				{
					if(paramValue.indexOf(testInfoDelimiter) > -1)
					{
						paramValue = StringUtils.replace(paramValue, testInfoDelimiter, EgConstants.COMMA);
						rootJson.put("testInfoDelimParamValue",paramValue);
					}
					if (strDelimiterMask.length() > 0 && paramValue.indexOf(strDelimiterMask) != -1)
					{
						paramValue = StringUtils.replace(paramValue,strDelimiterMask,testInfoDelimiter);
						rootJson.put("strDelimiterMaskParamValue",paramValue);
					}
					session.setAttribute("paramValue",paramValue);
					session.removeAttribute("winServicesList");
					rootJson.put("winServiceConfig","true");
					rootJson.put("viewLabel",_mapping.getTextDescription("admin.common.View/Configure services"));
					rootJson.put("viewLink","windows_services_popup('dummy')");
				}
				else if(paramName.equalsIgnoreCase("process") 
					&& !agentInfo.isAgentlessServer(componentNickName,componentType) 
					&& isAgentInstalledAndRunning)
				{
					if(paramValue.indexOf(testInfoDelimiter) > -1)
					{
						paramValue = StringUtils.replace(paramValue, testInfoDelimiter, EgConstants.COMMA);
						rootJson.put("testInfoDelimParamValue",paramValue);
					}
					session.removeAttribute("keyList");
					session.removeAttribute("valueList");
					session.removeAttribute("now");
					session.setAttribute("paramValue",paramValue);

					rootJson.put("viewLabel",_mapping.getTextDescription("admin.common.View/Configure processes"));
					rootJson.put("viewLink","process_popup('dummy')");
					hiddenObj.put("hiddenValues",EgURLEncoder.encode(paramValue,"UTF-8"));

				}
				else if(paramName.equalsIgnoreCase("exclude") || 
					paramName.equalsIgnoreCase("serviceName") || 
					paramName.equalsIgnoreCase("process") || 
					paramName.equalsIgnoreCase("searchPattern"))
				{
					if(paramValue.indexOf(testInfoDelimiter) > -1)
					{
						paramValue = StringUtils.replace(paramValue, testInfoDelimiter, EgConstants.COMMA);
						rootJson.put("testDelimParamValue",paramValue);
					}
					if (strDelimiterMask.length() > 0 && paramValue.indexOf(strDelimiterMask) != -1)
					{
						paramValue = StringUtils.replace(paramValue,strDelimiterMask,testInfoDelimiter);
						rootJson.put("strDelimiterMaskParamValue",paramValue);
					}
					rootJson.put("viewLabel",_mapping.getTextDescription("admin.common.View"));
					rootJson.put("viewLink","javascript:openSmallWindow('"+paramName+"')");
				}
				else if(paramName.equalsIgnoreCase("min_max_values"))
				{
					if(paramValue.indexOf(testInfoDelimiter) > -1)
					{
						paramValue = StringUtils.replace(paramValue, testInfoDelimiter, EgConstants.COMMA);
						rootJson.put("testInfoDelimParamValue",paramValue);
					}
					if (strDelimiterMask.length() > 0 && paramValue.indexOf(strDelimiterMask) != -1)
					{
						paramValue = StringUtils.replace(paramValue,strDelimiterMask,testInfoDelimiter);
						rootJson.put("strDelimiterMaskParamValue",paramValue);
					}
					rootJson.put("viewLabel",_mapping.getTextDescription("admin.common.Configure Minimum and Maximum values for computing performance rating"));
				}
				else if(paramName.equalsIgnoreCase("dynamic_servers") || 
					paramName.equalsIgnoreCase("remote_servers") || 
					paramName.equalsIgnoreCase("target_ports"))
				{
					if(paramValue.indexOf(testInfoDelimiter) > -1)
					{
						paramValue = StringUtils.replace(paramValue, testInfoDelimiter, EgConstants.COMMA);
					}
					if (strDelimiterMask.length() > 0 && paramValue.indexOf(strDelimiterMask) != -1)
					{
						paramValue = StringUtils.replace(paramValue,strDelimiterMask,testInfoDelimiter);
					}
					rootJson.put("paramValue"+paramName,paramValue);
				}
				auditLogHt.put(paramName,paramValue);
			}
			else //text
			{
				if (isSnmp || isPolicyParamExists || isCorrectParamExist || isUrlParamExist || isWsdlUrlExist || paramName.equalsIgnoreCase("real_ServerName"))
				{
					String temp = paramValue;
					String strVal = null;
					if (testName.equals(previousTestName))
					{
						strVal = request.getParameter(paramName);
					}
					paramValue = (strVal==null)?temp:strVal;
				}

				if(paramName.equalsIgnoreCase("correctivescript"))
				{
					if(paramValue.indexOf("#") > -1)
					{
						paramValue = StringUtils.replace(paramValue,"#",",");
					}
					if(paramValue.indexOf("|") > -1)
					{
						paramValue = StringUtils.replace(paramValue,"|",",");
					}
					rootJson.put("correctiveScriptParamValue",paramValue);
					if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
					{
						rootJson.put("isValidateBtn",true);
						String tmpValidate = "javascript:setAppServerValidationTitle('"+validationTitle+"','"+removeNull(componentName)+"');javascript:validateAppServerCredentails('specificConfiguration','"+validationURL+"','"+paramsForValidationURL+"','pickAgentToValidate','"+componentType+"','"+testName+"','false','"+isAllowHostName+"','"+requiredParamNames+"','testConfig',event)";
						rootJson.put("cScriptValidate",tmpValidate);
					}
					auditLogHt.put(paramName,paramValue);
				}
				//site url config starts
				else if (paramName.equalsIgnoreCase("site_URL(S)"))
				{
					if (paramValue.indexOf(EgConstants.PIPE) > -1)
					{
						paramValue = StringUtils.replace(paramValue, EgConstants.PIPE, EgConstants.COMMA);
						rootJson.put("pipeParamValue",paramValue);
					}
					auditLogHt.put(paramName,paramValue);
					session.setAttribute("paramValue",paramValue);
					session.removeAttribute("siteURLsList");
					rootJson.put("siteUrlConfig","true");
					rootJson.put("viewLabel",_mapping.getTextDescription("admin.common.View/Configure services"));
					rootJson.put("viewLink","windows_services_popup('dummy')");
					hiddenObj.put("hiddenSiteURL",paramValue);
				}
				//site url config ends	
				else if (paramName.equalsIgnoreCase("management_user"))
				{
					String strIsManagedByChanged = request.getParameter("isManagedByChanged");
					rootJson.put("isManagedByChanged",strIsManagedByChanged);
					if (strIsManagedByChanged == null)
					{
						if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
						{
							rootJson.put("isValidateBtn",true);
							String tmpValidate = "javascript:setAppServerValidationTitle('"+validationTitle+"','"+removeNull(componentName)+"');javascript:validateAppServerCredentails('specificConfiguration','"+validationURL+"','"+paramsForValidationURL+"','pickAgentToValidate','"+componentType+"','"+testName+"','false','"+isAllowHostName+"','"+requiredParamNames+"','testConfig',event);";
							rootJson.put("mgmtUserValidateLink",tmpValidate);
						}
					}
					else
					{
						String tempUser = (String)request.getAttribute("management_user");
						if (tempUser != null)
						{
							paramValue = tempUser;
						}
						if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
						{
							rootJson.put("isValidateBtn",true);
							String tmpValidate = "javascript:setAppServerValidationTitle('"+validationTitle+"','"+removeNull(componentName)+"');javascript:validateAppServerCredentails('specificConfiguration','"+validationURL+"','"+paramsForValidationURL+"','pickAgentToValidate','"+componentType+"','"+testName+"','false','"+isAllowHostName+"','"+requiredParamNames+"','testConfig',event);";
							rootJson.put("mgmtUserValidateLink",tmpValidate);
						}
					}
					rootJson.put("tempUser",paramValue);
					auditLogHt.put(paramName,paramValue);
				}
				//targets start
				else if(paramName.equalsIgnoreCase("targets") && isTargetWthSysProps)
				{
					String tgtParamValue=paramValue.trim().replace("|",",");
					rootJson.put("tgtParamValue",tgtParamValue);
				}
				//targets end
				else if(paramName.equalsIgnoreCase("url"))
				{
					String fullURLValue = "";
					if (isCredentialParamExist)
					{
						fullURLValue = paramValue.trim();
						previousUrl = (previousUrl == null)?"":previousUrl;
						if (previousUrl.equals(paramValue))
						{
							paramValue = paramValue.trim();
							if (paramValue.indexOf("|") > -1)
							{
								String decodedUrl = "";
								String strUrlName = "";
								StringTokenizer st12 = new StringTokenizer(paramValue,"|");
								String tempUrl = "";
								while (st12.hasMoreTokens())
								{
									tempUrl = st12.nextToken();
									if (tempUrl.indexOf("?") > -1)
									{
										int urlIndex = tempUrl.indexOf("?");
										tempUrl = tempUrl.substring(0, urlIndex) + "?" + URLDecoder.decode(tempUrl.substring(urlIndex + 1));
									}
									if (decodedUrl != null && !decodedUrl.equals(""))
									{
										decodedUrl = decodedUrl + "|" + tempUrl;
									}
									else
									{
										decodedUrl = tempUrl;
									}
									
									if (strUrlName != null && !strUrlName.equals(""))
									{
										strUrlName = strUrlName + "|" + tempUrl.substring(0,tempUrl.indexOf(":"));
									}
									else
									{
										strUrlName = tempUrl.substring(0,tempUrl.indexOf(":"));
									}
								}
								//paramValue = decodedUrl;

								if (testName.equals("HttpTest") || 
									testName.equals("HttpPostTest") || 
									testName.equals("SMHttpTest") || 
									testName.equals("AzureWebAcsTest") || 
									testName.equals("DownSpeedTest"))
								{
									paramValue = strUrlName;
								}
								else
								{
									paramValue = decodedUrl;
								}
							}
							else
							{
								if (paramValue.indexOf("?") > -1)
								{
									int vecValIndex = paramValue.indexOf("?");
									paramValue = paramValue.substring(0, vecValIndex) + "?" + URLDecoder.decode(paramValue.substring(vecValIndex + 1));
								}

								if (testName.equals("HttpTest") || 
									testName.equals("HttpPostTest") || 
									testName.equals("SMHttpTest") || 
									testName.equals("AzureWebAcsTest") || 
									testName.equals("DownSpeedTest"))
								{
									paramValue = paramValue.substring(0, paramValue.indexOf(":"));
								}
							}
						}

						if(paramValue.indexOf("|") > -1)
						{
							paramValue = StringUtils.replace(paramValue,"|",",");
						}

						if (paramValue.indexOf("~egHash~") > -1)
						{
							paramValue = StringUtils.replace(paramValue,"~egHash~","#");
						}
						hiddenObj.put("hiddenURLs",EgURLDecoder.decode(fullURLValue,"UTF-8"));

						rootJson.put("urlParamValue",paramValue);
						String tmpValidate = "config_popup('./EgConfigureUrlAndCredentials.jsp?server="+componentType+"&test="+testName+"&port="+isPortRelevantForTest+"&compname="+EgURLEncoder.encode(removeNull(componentName),"UTF-8")+"&isPrivateKeyParamExist="+isPrivateKeyParamExist+"&isSystemPropKeyParamExist="+isSystemPropKeyParamExist+"','','scrollbars=yes,width=900,height=500,top=150,left=50')";
						rootJson.put("urlValidateLink",tmpValidate);
						rootJson.put("imageTitle",_mapping.getTextDescription("admin.test.Click here to view/configure URL and credentials"));
						rootJson.put("configurlcredentials","true");
						rootJson.put("isHiddenUrls",false);
						if (testName.equals("HttpTest") || 
						testName.equals("HttpPostTest") || 
						testName.equals("SMHttpTest") || 
						testName.equals("AzureWebAcsTest") ||
						testName.equals("DownSpeedTest"))
						{
							rootJson.put("isHiddenUrls",true);
						}
					}
					else
					{
						if (paramValue.trim().indexOf("?") > -1)
						{
							int vecValIndex = paramValue.indexOf("?");
							paramValue = paramValue.substring(0, vecValIndex) + "?" + URLDecoder.decode(paramValue.substring(vecValIndex + 1));
						}
						rootJson.put("urlParamValue",paramValue);
						if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
						{
							rootJson.put("isValidateBtn",true);
							String tmpValidate = "javascript:setAppServerValidationTitle('"+validationTitle+"','"+removeNull(componentName)+"');javascript:validateAppServerCredentails('specificConfiguration','"+validationURL+"','"+paramsForValidationURL+"','pickAgentToValidate','"+componentType+"','"+testName+"','false','"+isAllowHostName+"','"+requiredParamNames+"','testConfig',event);";
							rootJson.put("urlValidateLink",tmpValidate);
						}
						else
						{
							String tmpValidate = "javascript:openSmallWindow('"+paramName+"')";
							rootJson.put("urlValidateLink",tmpValidate);
						}
					}
				}
				else if(paramName.equalsIgnoreCase("WSDL_URL"))
				{
					if (!isXDMGetDevicesInfo)
					{
						paramsForValidationURL = "test="+EgURLEncoder.encode(testName,"UTF-8")+"&action=pickAgentToValidate&taskName=WebServiceValidity"+"&compName="+EgURLEncoder.encode(componentName,"UTF-8")+"&componentType="+componentType+"&configurationType=specificConfiguration"+"&allowHostName="+isAllowHostName;
						requiredParamNames = requiredParamNames+",passwordconfirmpassword";
						updateWebServiceIniFile(previousUrl,componentName);
						paramsForValidationURL = paramsForValidationURL+"&xenMobileUserName="+""+"&xenMobilePassword="+"";
					}
					//paramsForValidationURL="test="+EgURLEncoder.encode(testName,"UTF-8")+"&action=pickAgentToValidate&taskName=WebServiceValidity"+"&compName="+EgURLEncoder.encode(componentName,"UTF-8")+"&componentType="+componentType+"&configurationType=specificConfiguration"+"&allowHostName="+isAllowHostName;
					//requiredParamNames=requiredParamNames+",passwordconfirmpassword";
					//updateWebServiceIniFile(previousUrl , componentName );

					if (isCredentialParamExist)
					{
						previousUrl = (previousUrl == null)?"":previousUrl;
						if (previousUrl.equals(paramValue))
						{
							paramValue = EgURLDecoder.decode(paramValue.trim(),"UTF-8");
						}

						if(paramValue.indexOf("|") > -1)
						{
							paramValue = StringUtils.replace(paramValue,"|",",");
						}

						if (paramValue.indexOf("~egHash~") > -1)
						{
							paramValue = StringUtils.replace(paramValue,"~egHash~","#");
						}
						rootJson.put("wsdlUrlParamValue",paramValue);
						rootJson.put("wsdlUrlImgTitle",_mapping.getTextDescription("amin.test.Click here to view/configure URL and credentials"));
						String tmpValidate = "config_popup('./EgConfigureWsdlUrlAndCredentials.jsp?server="+componentType+"&test="+testName+"&port="+isPortRelevantForTest+"&compname="+EgURLEncoder.encode(removeNull(componentName),"UTF-8")+"','','scrollbars=yes,width=900,height=500,top=150,left=50')";
						String tmpValidate1 = "javascript:setAppServerValidationTitle('"+validationTitle+"','"+removeNull(componentName)+"');javascript:validateAppServerCredentails('specificConfiguration','"+validationUrlForWebservice+"','"+paramsForValidationURL+"','pickAgentToValidate','"+componentType+"','"+testName+"','false','"+isAllowHostName+"','"+requiredParamNames+"','testConfig',event);";
						rootJson.put("isValidateBtn",true);
						rootJson.put("wsdlValidateLink1",tmpValidate);
						rootJson.put("wsdlValidateLink2",tmpValidate1);
					}
					else
					{
						paramValue = EgURLDecoder.decode(paramValue.trim(),"UTF-8");
						rootJson.put("wsdlUrlParamValue",paramValue);
						if (!isXDMGetDevicesInfo)
						{
							if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
							{
								rootJson.put("isValidateBtn",true);
								String tmpValidate = "javascript:setAppServerValidationTitle('"+validationTitle+"','"+removeNull(componentName)+"');javascript:validateAppServerCredentails('specificConfiguration','"+validationUrlForWebservice+"','"+paramsForValidationURL+"','pickAgentToValidate','"+componentType+"','"+testName+"','false','"+isAllowHostName+"','"+requiredParamNames+"','testConfig',event);";
								rootJson.put("wsdlValidateLink",tmpValidate);
							}
						}
					}
				}
				else if(paramName.equalsIgnoreCase("Operations"))
				{
					String tmpValidate = "javascript:openWebServiceDiv('"+componentName+"');";
					rootJson.put("operationsLink",tmpValidate);
				}
				else if(paramName.equalsIgnoreCase("Target_DiskIO_Rate"))
				{
					String tempTargetDiskIORate = "";
					String tempTargetDiskIORateValue = "";

					if (paramValue.equalsIgnoreCase("$unconfigured"))
					{
						tempTargetDiskIORateValue = paramValue;
					}
					else
					{
						tempTargetDiskIORate = paramValue.substring(0,paramValue.indexOf("_"));
						tempTargetDiskIORateValue = paramValue.substring(paramValue.indexOf("_")+1,paramValue.length());
						paramValue = tempTargetDiskIORateValue;
					}
					rootJson.put("targetDiskIOParamValue",paramValue);
					if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
					{
						rootJson.put("isValidateBtn",true);
						String tmpValidate = "javascript:setAppServerValidationTitle('"+validationTitle+"','"+removeNull(componentName)+"');javascript:validateAppServerCredentails('specificConfiguration','"+validationURL+"','"+paramsForValidationURL+"','pickAgentToValidate','"+componentType+"','"+testName+"','"+multiUserMode+"','"+isAllowHostName+"','"+requiredParamNames+"','testConfig',event);";
						rootJson.put("targetDiskIORateLink",tmpValidate);

						JSONArray targetDiskIORateLabelArr = new JSONArray();
						JSONObject targetDiskIORateLabelObj = new JSONObject();
						for (int k=0;k<targetDiskIORateLabel.length;k++)
						{
							String strTargetDiskIORateLabel = targetDiskIORateLabel[k];
							String strTargetDiskIORateValue = targetDiskIORateValue[k];
							targetDiskIORateLabelObj.put("displayField",strTargetDiskIORateLabel);
							targetDiskIORateLabelObj.put("valueField",strTargetDiskIORateValue);
							if (strTargetDiskIORateValue.equalsIgnoreCase(tempTargetDiskIORate))
							{
								rootJson.put("targetDiskIORateSelect",tempTargetDiskIORate);
							}
							targetDiskIORateLabelArr.add(targetDiskIORateLabelObj);
						}
						rootJson.put("targetDiskIORateLabelArr",targetDiskIORateLabelArr);
					}
					else
					{
						JSONArray targetDiskIORateLabelArr = new JSONArray();
						JSONObject targetDiskIORateLabelObj = new JSONObject();

						for (int k=0;k<targetDiskIORateLabel.length;k++)
						{
							String strTargetDiskIORateLabel = targetDiskIORateLabel[k];
							String strTargetDiskIORateValue = targetDiskIORateValue[k];
							targetDiskIORateLabelObj.put("displayField",strTargetDiskIORateLabel);
							targetDiskIORateLabelObj.put("valueField",strTargetDiskIORateValue);

							if (strTargetDiskIORateValue.equalsIgnoreCase(tempTargetDiskIORate))
							{
								rootJson.put("targetDiskIORateSelect",tempTargetDiskIORate);
							}
							targetDiskIORateLabelArr.add(targetDiskIORateLabelObj);
						}
						rootJson.put("targetDiskIORateLabelArr",targetDiskIORateLabelArr);
					}
				}
				else if ((testName.equalsIgnoreCase("WindowshareTest") || testName.equalsIgnoreCase("UNCCheckTest")) && 
					paramName.equalsIgnoreCase("sharename"))
				{
					rootJson.put("compNameWithoutNull",removeNull(componentName));
					if (paramValue.indexOf("|") > -1)
					{
						paramValue = StringUtils.replace(paramValue,"|",",");
					}
					rootJson.put("shareNameParamValue",paramValue);
					String tmpValidate = "config_popup('./EgConfigureWinSharedFolders.jsp?server="+componentType+"&test="+testName+"&port="+isPortRelevantForTest+"&compname="+EgURLEncoder.encode(removeNull(componentName),"UTF-8")+"','','scrollbars=yes,width=900,height=500,top=150,left=50')";
					rootJson.put("btnLabel"+paramName,_mapping.getTextDescription("admin.test.To view/configure shared folders for monitoring")+",&nbsp;"+_mapping.getTextDescription("admin.common.click here"));

					rootJson.put("shareNameLink",tmpValidate);
					hiddenObj.put(paramName,paramValue);
				}
				else if (isSystemPropertyParamTests && (paramName.equalsIgnoreCase("system_property_key") || paramName.equalsIgnoreCase("system_property_value")))
				{
					if (paramValue.indexOf("|") > -1)
					{
						paramValue = StringUtils.replace(paramValue,"|",",");
					}
					if (paramName.equalsIgnoreCase("system_property_key"))
					{
						rootJson.put("sysPropKey",paramValue);
					}
					else if (paramName.equalsIgnoreCase("system_property_value"))
					{
						hiddenObj.put(paramName,paramValue);
					}
				}
				else
				{
					//for remote based monitoring continuing the process parameters
					if (remProcessParamIdx > -1 && isRemote) continue;

					String destinationPage = "";
					String plusButton = "";
					String onBlurStr  = "";
					String onFocusStr = "";
					String onChangeStr = "";

					if (multiUserMode && readOnlyParamIdx>-1)
					{
						if (hasMultipleUsers)
						{
							readOnly = "readOnly";
						}
						if (paramName.equalsIgnoreCase("user"))
						{
							destinationPage = "EgConfigureMultipleUsers.jsp";
						}
						else
						{
							destinationPage = "VmgUsers.jsp";
						}

						if (paramName.equalsIgnoreCase("admin_user") || paramName.equalsIgnoreCase("user") || paramName.equalsIgnoreCase("connection_server_name"))
						{
							rootJson.put("destinationPage",destinationPage);
							plusButton = "<img src=\"/final/admin/eg_images/plus.gif\" title=\"Click here to configure user(s)\" class=\"leftmouse\" onClick=\"config_popup(\'./"+destinationPage+"?server="+componentType+"&test="+testName+"&port="+isPortRelevantForTest+"&compname="+EgURLEncoder.encode(removeNull(componentName),"UTF-8")+"\',\'\',\'scrollbars=yes,width=900,height=380,top=150,left=50\')\">";

						}
						onBlurStr =  "javascript:checkMultipleUser('"+paramName+"','"+paramValue+"')";
						onFocusStr = "javascript:getUserValue('"+paramName+"')"; 
						onChangeStr = "javascript:getUserChangedValue('"+paramName+"')";

						if (paramName.equalsIgnoreCase("published_resources"))
						{
							hiddenObj.put("hiddenPublishedResource",paramValue);
						}
					}

					if (multiNamePatternMode && readOnlyParamIdx>-1)
					{
						if (hasMultipleNames)
						{
							readOnly = "readOnly";
						}
						if (paramName.equalsIgnoreCase("name"))
						{
							rootJson.put("destinationPage",destinationPage);
							destinationPage = "EgConfigureNamePattern.jsp";
							plusButton = "<img src=\"/final/admin/eg_images/plus.gif\" title=\"Click here to configure url pattern(s)\" class=\"leftmouse\" onClick=\"config_popup(\'./"+destinationPage+"?server="+componentType+"&test="+testName+"&port="+isPortRelevantForTest+"&compname="+EgURLEncoder.encode(removeNull(componentName),"UTF-8")+"\',\'\',\'scrollbars=yes,width=900,height=380,top=150,left=50\')\">";
						}
						if (paramName.equalsIgnoreCase("measure_oid"))
						{
							destinationPage = "EgOidsValue.jsp";
							plusButton = "<img src=\"/final/admin/eg_images/plus.gif\" title=\"Click here to configure url pattern(s)\" class=\"leftmouse\" onClick=\"config_popup(\'./"+destinationPage+"?server="+componentType+"&test="+testName+"&port="+isPortRelevantForTest+"&compname="+EgURLEncoder.encode(removeNull(componentName),"UTF-8")+"\',\'\',\'scrollbars=yes,width=900,height=380,top=150,left=50\')\">";
							rootJson.put("destinationPage",destinationPage);
						}
						onBlurStr =  "javascript:checkMultipleNamePattern('"+paramName+"','"+paramValue+"')";
						onFocusStr = "javascript:getNamePatternValue('"+paramName+"')"; 
						onChangeStr = "javascript:getNamePatternChangedValue('"+paramName+"')";
					}
					if (multiOidsMode && readOnlyParamIdx>-1)
					{
						if (hasMultipleOid)
						{
							readOnly = "readOnly";
						}
						if (paramName.equalsIgnoreCase("measure_oid"))
						{
							destinationPage = "EgOidsValue.jsp";
							plusButton = "<img src=\"/final/admin/eg_images/plus.gif\" title=\"Click here to configure url pattern(s)\" class=\"leftmouse\" onClick=\"config_popup(\'./"+destinationPage+"?server="+componentType+"&test="+testName+"&port="+isPortRelevantForTest+"&compname="+EgURLEncoder.encode(removeNull(componentName),"UTF-8")+"\',\'\',\'scrollbars=yes,width=900,height=380,top=150,left=50\')\">";
							rootJson.put("destinationPage",destinationPage);
						}
						onBlurStr =  "javascript:checkMultipleNamePattern('"+paramName+"','"+paramValue+"')";
						onFocusStr = "javascript:getNamePatternValue('"+paramName+"')"; 
						onChangeStr = "javascript:getNamePatternChangedValue('"+paramName+"')";
					}

					if (paramValue.indexOf("|") > -1)
					{
						paramValue = StringUtils.replace(paramValue,"|",",");
					}
					if (paramValue.indexOf("~#~") > -1)
					{
						paramValue = StringUtils.replace(paramValue,"~#~",";");
					}

					if (paramName.equalsIgnoreCase("published_resources") && paramValue.indexOf(";") != -1)
					{
						paramValue = StringUtils.replace(paramValue,";",",");
					}

					boolean isReadOnly = false;
					if (!StringUtils.isNull(readOnly) && readOnly.equals(readOnly))
					{
						isReadOnly = true;
					}
					rootJson.put("readOnly"+paramName,isReadOnly);
					if (multiUserMode || multiNamePatternMode || multiOidsMode)
					{
						if (readOnlyParamIdx > -1)
						{
							rootJson.put("multiUserOrNameParamValue"+paramName,paramValue);
							rootJson.put("onBlurStr"+paramName,onBlurStr);
							rootJson.put("onFocusStr"+paramName,onFocusStr);
							rootJson.put("onChangeStr"+paramName,onChangeStr);
							rootJson.put("plusButton"+paramName,plusButton);
						}
						else
						{
							rootJson.put("multiUserOrNameParamValue"+paramName,paramValue);
							if (paramValue.length() > 20 && readOnly.equals(""))
							{
								String tmpViewLink = "javascript:openSmallWindow('"+paramName+"')";
								rootJson.put("viewBtnLink",tmpViewLink);
							}
						}
						if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName))
						{
							rootJson.put("isValidateBtn",true);
							String tmpValidate = "javascript:setAppServerValidationTitle('"+validationTitle+"','"+removeNull(componentName)+"');javascript:validateAppServerCredentails('specificConfiguration','"+validationURL+"','"+paramsForValidationURL+"','pickAgentToValidate','"+componentType+"','"+testName+"','"+multiUserMode+"','"+isAllowHostName+"','"+requiredParamNames+"','testConfig',event);";
							rootJson.put("multiUserValidateLink",tmpValidate);
						}
					}
					else
					{
						if (paramValue.indexOf(EgConstants.PIPE) > -1)
						{
							paramValue = StringUtils.replace(paramValue, EgConstants.PIPE, EgConstants.COMMA);
						}
						else if ((testName.equalsIgnoreCase("ProcessTest") || testName.equalsIgnoreCase("AppProcessTest")) && 
								paramName.equalsIgnoreCase("user") && 
								paramValue.indexOf("#") != -1)
						{
							paramValue = StringUtils.replace(paramValue,"#",",");
						}

						boolean isParamNameExists = false;
						if(paramForDisplayingValidateButton != null && paramForDisplayingValidateButton.indexOf(",") > 0)
						{
							StringTokenizer validateParamTokens = new StringTokenizer(paramForDisplayingValidateButton, ",");
							while(validateParamTokens.hasMoreTokens())
							{
								String tempParam = validateParamTokens.nextToken();
								
								if(tempParam.equalsIgnoreCase(paramName))
								{
									isParamNameExists = true;
								}
							}
						}
						if(paramForDisplayingValidateButton!=null && paramForDisplayingValidateButton.equalsIgnoreCase(paramName) || isParamNameExists)
						{
							rootJson.put("isValidateBtn",true);
							String tmpValidate = "javascript:setAppServerValidationTitle('"+validationTitle+"','"+removeNull(componentName)+"');javascript:validateAppServerCredentails('specificConfiguration','"+validationURL+"','"+paramsForValidationURL+"','pickAgentToValidate','"+componentType+"','"+testName+"','"+multiUserMode+"','"+isAllowHostName+"','"+requiredParamNames+"','testConfig',event);";
							rootJson.put("multiUserValidateLink",tmpValidate);

							if (paramValue.length() > 20 && readOnly.equals(""))
							{
								rootJson.put("viewLink","javascript:openSmallWindow('"+paramName+"')" );
							}
							if (paramValue.equals("null"))
							{
								paramValue = "(null)";//paramValue.toString()
							}
							rootJson.put("remainParamValue"+paramName,paramValue.toString());
						}
						else if(paramName.equals("device_id"))
						{
							rootJson.put("deviceIdParamValue",paramValue);
							rootJson.put("readOnly",true);
						}
						else if(paramName.equals("include_descriptors") || paramName.equals("excludeDescriptor"))
						{
							if (paramValue.indexOf("|") > -1)
							{
								paramValue = StringUtils.replace(paramValue,"|",",");
							}
							rootJson.put(paramName+"Value",paramValue);

						}
						else if(paramName.equalsIgnoreCase("url_patterns"))
						{
							rootJson.put("URLPatternsParamValue",paramValue);
						}
						else if(paramName.equalsIgnoreCase("Max_URL_Segments"))
						{
							rootJson.put("MaxURLSegmentsParamValue",paramValue);
						}
						else if(paramName.equalsIgnoreCase("CIM_Server_Port"))
						{
							rootJson.put("CIMServerPortParamValue",paramValue);
						}
						else if(paramName.equalsIgnoreCase("serialNumber"))
						{
							rootJson.put("serialNumberParamValue",paramValue);
						}
						else
						{
							if (paramValue.equals("null"))
							{
								paramValue = "(null)";//paramValue.toString()
							}
							rootJson.put("remainParamValue"+paramName,paramValue.toString());
							//boolean isReadOnly = false;
							//if (!StringUtils.isNull(readOnly) && readOnly.equals(readOnly))
							//{
								//isReadOnly = true;
							//}
							//rootJson.put("readOnly",isReadOnly);
							rootJson.put("descriptorButton"+paramName,descriptorButton);
							if (paramValue.length() > 20 && readOnly.equals(""))
							{
								rootJson.put("viewLink","javascript:openSmallWindow('"+paramName+"')" );
							}
						}
					}
				}
			}
		}
		rootJson.put("requiredParamNames",requiredParamNames);
		rootJson.put("paramNameObj",paramNameObj);
		rootJson.put("originalParamNameObj",originalParamNameObj);
		rootJson.put("allowDetailedDiagnosis",allowDetailedDiagnosis);
		if (allowDetailedDiagnosis)
		{
			rootJson.put("DDLabel",_mapping.getTextDescription("admin.test.DETAILED DIAGNOSIS"));
			rootJson.put("isTestDetailedDiagnosisDisabledGlobally",isTestDetailedDiagnosisDisabledGlobally);

			if (isTestDetailedDiagnosisDisabledGlobally)
			{
				hiddenObj.put("detaileddiagnosis","Off");
				auditLogHt.put("detaileddiagnosis","Off");
				rootJson.put("isDisabledGlobalValue",_mapping.getTextDescription("admin.common.Off"));
			}
			else
			{
				if(detailedDiagnosisOn != null  && detailedDiagnosisOn.equalsIgnoreCase("checked"))
				{
					auditLogHt.put("detaileddiagnosis","On");
				}
				else if(detailedDiagnosisOff != null  && detailedDiagnosisOff.equalsIgnoreCase("checked"))
				{
					auditLogHt.put("detaileddiagnosis","Off");
				}
				rootJson.put("DDEnabled",detailedDiagnosisOn);
				rootJson.put("DDDisabled",detailedDiagnosisOff);
			}
		}

		if (aListConfigureComponentsClone != null && aListConfigureComponentsClone.size() > 0)
		{
			rootJson.put("isApplyAllComponents",true);
		}else
		{
			rootJson.put("isApplyAllComponents",false);
		}
		//apply to other components - starts
		if (aListConfigureComponentsClone != null && aListConfigureComponentsClone.size() > 0)
		{
			rootJson.put("applyAllLabel",_mapping.getTextDescription("admin.test.APPLY TO OTHER COMPONENTS"));
		}
		//apply to other components - ends
%>

<%
		hiddenObj.put("showUnconfigCompType",showUnconfigCompType);
		hiddenObj.put("testChoosenToConfigure",testName);
		hiddenObj.put("allowedParams",allowedParams);
		hiddenObj.put("strTcKeywords",strTcKeywords);
		hiddenObj.put("strDoubleQuotesParams",strDoubleQuotesParams);

		session.setAttribute("aListParamNamesValues",aListParamNamesValues);
		session.setAttribute("aListDisplay",aListDisplay);
		session.setAttribute("specialCharactersAllowedParameter",allowedParams);
		session.setAttribute("tcKeywords",tcKeywords);
		session.setAttribute("aListPasswordParameters",aListPasswordParameters);
		session.setAttribute("aListDefaultPasswordParameters",aListDefaultPasswordParameters);
		session.setAttribute("aListParamsWithDoubleQuotes",aListParamsWithDoubleQuotes);
		session.setAttribute("isOldSnmp",new Boolean(isOldSnmp));
		if(httpTestAuditData != null && !httpTestAuditData.isEmpty())
		{
			auditLogHt.putAll(httpTestAuditData);
		}
		session.setAttribute("auditLogHt",auditLogHt);
	}

		//session.setAttribute("adminLastAccessedURL","/final/admin/EgSpecificTestConfiguration.jsp?componentType="+EgURLEncoder.encode(componentType,"UTF-8")+"&componentName="+EgURLEncoder.encode(componentName,"UTF-8")+"&testType="+testType+"&testName="+EgURLEncoder.encode(testName,"UTF-8")+"&showUnconfigCompType="+EgURLEncoder.encode(showUnconfigCompType,"UTF-8")+"&clickedFrom="+EgURLEncoder.encode(clickedFrom,"UTF-8")+"&reqfrom="+EgURLEncoder.encode(fromUnconfigTest,"UTF-8"));

	//used for help page support.when data.jsp is clicked
	aListPages.add("/final/admin/EgSpecificTestConfiguration.jsp?componentType="+EgURLEncoder.encode(componentType,"UTF-8")+"&componentName="+EgURLEncoder.encode(componentName,"UTF-8")+"&testType="+testType+"&testName="+EgURLEncoder.encode(testName,"UTF-8")+"&showUnconfigCompType="+EgURLEncoder.encode(showUnconfigCompType,"UTF-8")+"&clickedFrom="+EgURLEncoder.encode(clickedFrom,"UTF-8"));
	if (aListPages.size() > 2)
	{
		aListPages.remove(0);
	}
	session.setAttribute("aListPages",aListPages);
	hiddenObj.put("testName",testName);
	hiddenObj.put("componentcredentialsneededtodovalidation",componentCredentialsNeededToDoValidation);
	hiddenObj.put("previousTestName",previousTestName);
	hiddenObj.put("isCredentialParamExist",isCredentialParamExist);
	hiddenObj.put("delimiter",strDelimiter);
	hiddenObj.put("delimiterMask",strDelimiterMask);

	rootJson.put("hiddenObj",hiddenObj);
	out.println(rootJson.toString());
%>

<%!
	private ArrayList getArrayList(String strValue,String delimiter)
	{
		ArrayList aL = new ArrayList();
		StringTokenizer stTempTokens = new StringTokenizer(strValue,delimiter);
		while (stTempTokens.hasMoreTokens())
		{
			String str = stTempTokens.nextToken().trim();
			aL.add(str);
		}
		return aL;
	}

	boolean isAgentReporting(String nick)
	{
		if(EgInstallInfo.isClusterSupported)
		{
			com.eg.EgManagersIniForManager mi = com.eg.EgManagersIniForManager.getInstance();
			Vector reportingAgentIPs= mi.getReportingAgentsFor(mi.getManagerIP());
			if(reportingAgentIPs != null && reportingAgentIPs.size() > 0)
			{
				EgDiscInfo discInfo = new EgDiscInfo("manager");
				Hashtable nickIpMap = discInfo.getNickIpMap();
				if(nickIpMap != null && nickIpMap.size()>0)
				{
					String agentIP =(String) nickIpMap.get(nick);
					if(!StringUtils.isNull(agentIP) && reportingAgentIPs.contains(agentIP))
					{
						return true;
					}
				}
			}
			return false;
		}
		else
			return true;
	}

	public void updateWebServiceIniFile(String previousUrl , String componentName)
	{
		String iniFileName = EgInstallInfo.getInstallDir()+"/manager/config/eg_webservices.ini";
		IniFile webServiceIni  = EgConfigFilesSync.getInstance(iniFileName,true);
		if(previousUrl.indexOf("$unconfigured")>-1)
		{
			String ConfigVariables[] = webServiceIni.getVariables("CONFIGURED_OPERATIONS");
			if(ConfigVariables!=null && ConfigVariables.length >0)
			{
				Vector configOprDel = new Vector();
				Vector configSoapDel = new Vector();
				for(int v=0;v<ConfigVariables.length;v++)
				{
					String variable = (String)ConfigVariables[v];
					String varComp = variable.substring(0,variable.lastIndexOf(":"));
					if(varComp.trim().equals(componentName.trim()))
					{
						String deleteValue = webServiceIni.getValue("CONFIGURED_OPERATIONS",variable);
						configOprDel.add(variable);
						//webServiceIni.deleteValue("CONFIGURED_OPERATIONS",variable);
						
						StringTokenizer del = new StringTokenizer(deleteValue,",");
						while(del.hasMoreTokens())
						{
							String token = (String)del.nextToken();
							String todelete = variable+":"+token;
							configSoapDel.add(todelete);
							//webServiceIni.deleteValue("CONFIGURED_SOAP_REQUEST",todelete);
						}
					}
				}
				webServiceIni.deleteValues("CONFIGURED_OPERATIONS",configOprDel);
				webServiceIni.deleteValues("CONFIGURED_SOAP_REQUEST",configSoapDel);
				webServiceIni.saveFile();
			}
			String associatedVariables[] = webServiceIni.getVariables("ASSOCIATED_OPERATIONS");
			if(associatedVariables!=null && associatedVariables.length >0)
			{
				Vector associateOprDel = new Vector();
				Vector associateSoapDel = new Vector();
				for(int v=0;v<associatedVariables.length;v++)
				{
					String variable = (String)associatedVariables[v];
					String varComp = variable.substring(0,variable.lastIndexOf(":"));
					if(varComp.trim().equals(componentName.trim()))
					{
						String deleteValue = webServiceIni.getValue("ASSOCIATED_OPERATIONS",variable);
						associateOprDel.add(variable);
						//webServiceIni.deleteValue("ASSOCIATED_OPERATIONS",variable);
						
						StringTokenizer del = new StringTokenizer(deleteValue,",");
						while(del.hasMoreTokens())
						{
							String token = (String)del.nextToken();
							String todelete = variable+":"+token;
							associateSoapDel.add(todelete);
							//webServiceIni.deleteValue("ASSOCIATED_SOAP_REQUEST",todelete);
						}
					}
				}
				webServiceIni.deleteValues("ASSOCIATED_OPERATIONS",associateOprDel);
				webServiceIni.deleteValues("ASSOCIATED_SOAP_REQUEST",associateSoapDel);
				webServiceIni.saveFile();
			}
		}
		webServiceIni.saveFile();
		EgConfigFilesSync.releaseInstance(webServiceIni);
	}

	public static String getString(List list)
	{
		StringBuffer buffer = new StringBuffer(32);

		if (list != null && list.size() > 0)
		{
			for (Iterator i=list.iterator(); i.hasNext(); )
			{
				String line = (String)i.next();
				buffer.append(line);
				buffer.append("^&^");
			}
		}

		/*
		 * Take out the last comma and return the string
		 */
		String string = buffer.toString();
		return string.substring(0, string.length()-3);
	}
	/*
	 * This method is used to get OID values based on component type.
	 * Default OID for network devices is ".1.3.6.1.2.1.1.1".
	 * We are using default OID for not configured component types( under subject called COMPONENTTYPE_OID_MAPPING  in eg_testparam.ini) 
	 * @param componentType
	 * @return String 
	 */
	private String getComponentTypeOID(String componentType)
	{
		IniFile egTestParamIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_testparam.ini");
		String oidForComponentType = egTestParamIni.getValue("COMPONENTTYPE_OID_MAPPING", componentType);
	
		if(StringUtils.isNull(oidForComponentType)) {
			oidForComponentType = ".1.3.6.1.2.1.1.1"; // default OID
		}
		egTestParamIni = null;

		return oidForComponentType;
	}

	private String getRemoteAgentOS(String osName)
	{
		String hostOS = osName;
		if (hostOS.equalsIgnoreCase("2019"))
		{
			hostOS = "Windows2019";
		}
		else if (hostOS.equalsIgnoreCase("2016"))
		{
			hostOS = "Windows2016";
		}
		else if (hostOS.equalsIgnoreCase("2012"))
		{
			hostOS = "Windows2012";
		}
		else if (hostOS.equalsIgnoreCase("w2k"))
		{
			hostOS = "Windows2000";
		}
		else if (hostOS.equalsIgnoreCase("nt"))
		{
			hostOS = "WindowsNT";
		}
		else if (hostOS.equalsIgnoreCase("2003") || hostOS.equalsIgnoreCase("xp"))
		{
			hostOS = "Windows2003";
		}
		else if (hostOS.equalsIgnoreCase("2008") || hostOS.equalsIgnoreCase("Vista"))
		{
			hostOS = "Windows2008";
		}
		else if (hostOS.equalsIgnoreCase("solaris"))
		{
			hostOS = "Solaris";
		}
		else if (hostOS.equalsIgnoreCase("linux"))
		{
			hostOS = "Linux";
		}
		else if (hostOS.equalsIgnoreCase("aix"))
		{
			hostOS = "AIX";
		}
		else if (hostOS.equalsIgnoreCase("hpux"))
		{
			hostOS = "HPUX";
		}
		else if (hostOS.equalsIgnoreCase("tru64"))
		{
			hostOS = "Tru64";
		}
		else if (hostOS.equalsIgnoreCase("other"))
		{
			hostOS = "Other";
		}
		return hostOS;
	}

	private ArrayList arrangeKeyAgentIniOrder(ArrayList paramSetKeys,ArrayList aListResultantTempInLowerCase)
	{
		if (aListResultantTempInLowerCase == null || aListResultantTempInLowerCase.isEmpty())
		{
			return paramSetKeys;
		}

		ArrayList resultList = new ArrayList();
		for (int i=0;i<paramSetKeys.size();i++)
		{
			String strParam = paramSetKeys.get(i).toString();
			if (resultList != null && !resultList.isEmpty())
			{
				ArrayList tmpList = new ArrayList();
				tmpList.addAll(resultList);

				int size = resultList.size();
				boolean isArragePerformed = false;
				for( int res=0;res<size;res++)
				{
					String prevParam = resultList.get(res).toString();
					int prevParamIdx = aListResultantTempInLowerCase.indexOf("-"+prevParam.toLowerCase());
					int currParamIdx = aListResultantTempInLowerCase.indexOf("-"+strParam.toLowerCase());
					if (prevParamIdx == -1 && currParamIdx == -1)
					{
						continue;
					}
					else if (currParamIdx == -1)
					{
						continue;
					}
					else if (prevParamIdx == -1)
					{
						isArragePerformed = true;
						if (!tmpList.contains(strParam))
						{
							tmpList.add(res,strParam);
						}
						continue;
					}

					if (prevParamIdx > currParamIdx)
					{
						isArragePerformed = true;
						if (!tmpList.contains(strParam))
						{
							tmpList.add(res,strParam);
						}
					}
				}

				if (isArragePerformed)
				{
					resultList = new ArrayList();
					resultList.addAll(tmpList);
				}
				else
				{
					if (!resultList.contains(strParam))
					{
						resultList.add(strParam);
					}
				}
			}
			else
			{
				resultList.add(strParam);
			}
		}
		return resultList;
	}

	private boolean checkParamIsUserField(String paramName)
	{
		boolean isUserNameParamExists = false;

		if (paramName == null)
		{
			return isUserNameParamExists;
		}

		if (paramName.toLowerCase().equals("user") ||  
			paramName.toLowerCase().equals("username") ||
			paramName.toLowerCase().equals("user_name") ||
			paramName.toLowerCase().endsWith("user") ||
			paramName.toLowerCase().endsWith("username") ||
			paramName.toLowerCase().endsWith("user_name") ||
			paramName.toLowerCase().indexOf("user") != -1)
		{
			isUserNameParamExists = true;
		}
		return isUserNameParamExists;
	}

	private boolean checkParamIsDomainField(String paramName)
	{
		boolean isDomainParamExists = false;

		if (paramName == null)
		{
			return isDomainParamExists;
		}

		if (paramName.toLowerCase().equals("domain") ||  
			paramName.toLowerCase().equals("domainname") ||
			paramName.toLowerCase().equals("domain_name") ||
			paramName.toLowerCase().endsWith("domain") ||
			paramName.toLowerCase().endsWith("domain_name") ||
			paramName.toLowerCase().endsWith("domainname"))
		{
			isDomainParamExists = true;
		}
		return isDomainParamExists;
	}

	private boolean checkParamIsPasswordField(String paramName)
	{
		boolean isPasswordParamExists = false;

		if (paramName == null)
		{
			return isPasswordParamExists;
		}

		if (paramName.toLowerCase().equals("password") ||  
			paramName.toLowerCase().endsWith("password") ||
			paramName.toLowerCase().indexOf("pass") != -1 ||
			paramName.toLowerCase().indexOf("password") != -1)
		{
			isPasswordParamExists = true;
		}
		return isPasswordParamExists;
	}

	private ArrayList getUpdatedResultantListInLowercase(ArrayList aResultant)
	{
		ArrayList returnList = new ArrayList();
		if (aResultant == null || aResultant.isEmpty())
		{
			return returnList;
		}

		for (int i=0;i<aResultant.size();i++)
		{
			String strResult = aResultant.get(i).toString();
			returnList.add(strResult.toLowerCase());
		}
		return returnList;
	}

	private ArrayList getHiddenPwdProfile(ArrayList aResultant)
	{
		ArrayList returnList = new ArrayList();
		if (aResultant == null || aResultant.isEmpty())
		{
			return returnList;
		}

		boolean modeParamProcess = false;
		boolean measureModeParamProcess = false;
		boolean measurementModeParamProcess = false;
		boolean useSapControlProcess = false;
		int condParamIdx = aResultant.indexOf("-mode");
		if (condParamIdx != -1)
		{
			String modeValue = ((String)aResultant.get(condParamIdx+1)).trim();
			if (modeValue.equalsIgnoreCase("true"))
			{
				returnList.add("mode_true");
				returnList.add("username");
			}
			else
			{
				returnList.add("mode_false");
				returnList.add("Jmx_user");
			}
			return returnList;
		}

		condParamIdx = aResultant.indexOf("-measurement_mode");
		if (condParamIdx != -1)
		{
			String modeValue = ((String)aResultant.get(condParamIdx+1)).trim();
			if (modeValue.equalsIgnoreCase("true"))
			{
				//int modeTrueParamIdx = Arrays.binarySearch(modeTrueToContinue,paramName,String.CASE_INSENSITIVE_ORDER);
				//if (modeTrueParamIdx > -1) continue;
				returnList.add("measurement_mode_true");
				returnList.add("username");


			}
			else
			{
				returnList.add("measurement_mode_false");
				returnList.add("Jmx_user");
			}
			return returnList;
		}

		condParamIdx = aResultant.indexOf("-measure_mode");
		if (condParamIdx != -1)
		{
			String modeValue = ((String)aResultant.get(condParamIdx+1)).trim();
			if (modeValue.equalsIgnoreCase("true"))
			{
				//int modeTrueParamIdx = Arrays.binarySearch(modeTrueToContinue,paramName,String.CASE_INSENSITIVE_ORDER);
				//if (modeTrueParamIdx > -1) continue;
				returnList.add("measure_mode_true");
				returnList.add("JREHome");
			}
			else
			{
				returnList.add("measure_mode_false");
				returnList.add("Jmx_user");
			}
		}

		condParamIdx = aResultant.indexOf("-use_sapcontrol");
		if (condParamIdx != -1)
		{
			String modeValue = ((String)aResultant.get(condParamIdx+1)).trim();
			if (modeValue.equalsIgnoreCase("true"))
			{
				returnList.add("use_sapcontrol_true");
				returnList.add("os_password");
			}
			else
			{
				returnList.add("use_sapcontrol_false");
				returnList.add("sapuser");
			}
		}

		condParamIdx = aResultant.indexOf("-snmpversion");
		if (condParamIdx != -1)
		{
			String snmpVersion = ((String)aResultant.get(condParamIdx+1)).trim();
			if (snmpVersion.equalsIgnoreCase("v3"))
			{
				returnList.add("snmpversion_true");
				returnList.add("username");
			}
			else
			{
				returnList.add("snmpversion_false");
				returnList.add("snmpcommunity");
			}
		}

		return returnList;
	}

	private boolean isMultiUserParamExists(ArrayList aResultant, String[] multiUserReadOnlyParam)
	{
		boolean isParamExists = false;
		if (aResultant == null || multiUserReadOnlyParam == null)
		{
			return isParamExists;
		}

		if (multiUserReadOnlyParam != null && multiUserReadOnlyParam.length > 0)
		{
			for (int mul=0;mul<multiUserReadOnlyParam.length ;mul++ )
			{
				String strMultiUserParam = multiUserReadOnlyParam[mul];
				if (aResultant.contains("-"+strMultiUserParam))
				{
					isParamExists = true;
					break;
				}
			}
		}
		return isParamExists;
	}

	private Hashtable getHttpTestAuditData(ArrayList aResultant)
	{
		Hashtable resultData = new Hashtable();
		if (aResultant == null || aResultant.isEmpty())
		{
			return resultData;
		}

		int index =  aResultant.indexOf("-credentials");
		if(index != -1)
		{
			resultData.put("credentials",aResultant.get(index+1));
		}

		index = aResultant.indexOf("-content");
		if (index != -1)
		{
			resultData.put("content",aResultant.get(index+1));
		}

		index = aResultant.indexOf("-encoding");
		if (index != -1)
		{
			resultData.put("encoding",aResultant.get(index+1));
		}
		
		index = aResultant.indexOf("-privateKey");
		if (index != -1)
		{
			resultData.put("privateKey",aResultant.get(index+1));
		}
	
		index = aResultant.indexOf("-systempropertykey");
		if (index != -1)
		{
			resultData.put("systempropertykey",aResultant.get(index+1));
		}

		index = aResultant.indexOf("-systempropertyvalue");
		if (index != -1)
		{
			resultData.put("systempropertyvalue",aResultant.get(index+1));
		}

		index = aResultant.indexOf("-systempropertyvalue");
		if (index != -1)
		{
			resultData.put("systempropertyvalue",aResultant.get(index+1));
		}
		return resultData;
	}

	private Hashtable getTargetSysPropertyData(ArrayList aResultant,ArrayList aListResultantTempInLowerCase)
	{
		Hashtable resultData = new Hashtable();
		if ((aResultant == null || aResultant.isEmpty()) ||
			(aListResultantTempInLowerCase == null || aListResultantTempInLowerCase.isEmpty()))
		{
			return resultData;
		}

		int sysPropsKeyIdx=0;
		int sysPropsValIdx=0;
		sysPropsKeyIdx = aListResultantTempInLowerCase.indexOf("-systempropskey");
		String keyStr = aResultant.get(sysPropsKeyIdx+1).toString();
		sysPropsValIdx =aListResultantTempInLowerCase.indexOf("-systempropsvalue");
		String valStr = aResultant.get(sysPropsValIdx+1).toString();

		ArrayList aListTgtSysPropKeys = new ArrayList();
		ArrayList aListTgtSysPropValues = new ArrayList();
		StringTokenizer tgtKeyTokens = new StringTokenizer(keyStr,"|");
		StringTokenizer tgtValTokens = new StringTokenizer(valStr,"|");
		while(tgtKeyTokens.hasMoreTokens())
		{
			String skey = tgtKeyTokens.nextToken();
			String sval = tgtValTokens.nextToken();
			aListTgtSysPropKeys.add(skey);
			aListTgtSysPropValues.add(sval);
		}

		if (aListTgtSysPropKeys != null && aListTgtSysPropKeys.size() > 0)
		{
			resultData.put("trgtSysPropKeys",aListTgtSysPropKeys);
		}

		if (aListTgtSysPropValues != null && aListTgtSysPropValues.size() > 0)
		{
			resultData.put("trgtSysPropVals",aListTgtSysPropValues);
		}
		return resultData;
	}

	private String getSelectedPwdProfile(String componentType, String componentName, String testName, String paramName, JSONObject pwdParamSetList, EgPwdProfile pwdProf)
	{
		boolean isSpecificProfSet = false;
		boolean isDefaultProfSet = false;

		String strResult = "none";

		String strSelectedParamSet = pwdParamSetList.get(paramName).toString();
		String mergeString = componentType+":"+componentName+"#^#"+strSelectedParamSet;
		isSpecificProfSet = pwdProf.isTestHasSpecificPwdProfile(mergeString,testName);

		String defaultMergeStr = componentType+"#^#"+strSelectedParamSet;
		isDefaultProfSet = pwdProf.isTestHasDefaultPwdProfile(defaultMergeStr,testName);
		if (!isDefaultProfSet) // for default(:: common tests) profile check 
		{
			defaultMergeStr = testName+"#^#"+strSelectedParamSet;
			isDefaultProfSet = pwdProf.isTestHasDefaultPwdProfile(defaultMergeStr);
		}

		if (isSpecificProfSet)
		{
			strResult = pwdProf.getProfNameForSpecificConfiguration(mergeString,testName);
		}
		else
		{
			if (isDefaultProfSet)
			{
				strResult = pwdProf.getProfNameForDefaultConfiguration(defaultMergeStr,testName);
				if (StringUtils.isNull(strResult)) // for default(:: common tests) profile check 
				{
					defaultMergeStr = testName+"#^#"+strSelectedParamSet;
					strResult = pwdProf.getProfNameForDefaultConfiguration(defaultMergeStr);
				}
			}
		}
		return strResult;
	}
%>



