<%
/*
 *   File		:	EgIncludeComponents.jsp
 *   Purpose	:	Provides a mechanism to include components for a test
 *   Author		:	S.Anand (2009)
 *   UI Design	:	Jaiwin & Krishnamurthi
*/
%>

<%@ include file="../../EgTrackerAJSON.jsp" %>
<%@ page import="java.util.*" %>
<%@ page import="com.eg.EgRoleInfo" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.eg.IniFile" %>
<%@ page import="com.eg.EgURLEncoder"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import= "net.sf.json.*"%>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%!
	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");

	private ArrayList getArrayList(String strValue,String delimiter)
	{
		ArrayList aL = new ArrayList();
		StringTokenizer stTempTokens = new StringTokenizer(strValue,delimiter);
		while (stTempTokens.hasMoreTokens())
		{
			String str = stTempTokens.nextToken().trim();
			aL.add(str);
		}
		return aL;
	}
%>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject hiddenObj = new JSONObject();

	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));

	String componentType = request.getParameter("componentType");
	String componentName = request.getParameter("componentName");
	String pageRefreshed = request.getParameter("pageRefreshed");
	boolean isPageRefreshed = false;
	if (pageRefreshed == null)
	{
		pageRefreshed = "false";
	}
	else
	{
		pageRefreshed = "true";
		isPageRefreshed = true;
	}

	String showUnconfigCompType = request.getParameter("showUnconfigCompType");
	showUnconfigCompType = (showUnconfigCompType == null)?"false":showUnconfigCompType;
	ArrayList filterUnconfigCompList = new ArrayList();

	String managed = null;
	String unmanaged = null;
	if (pageRefreshed != null && pageRefreshed.equals("true"))
	{
		componentName = request.getParameter("mainComponentName");

		managed = request.getParameter("strManage");
		unmanaged = request.getParameter("strunManage");
	}

	String testType = request.getParameter("testType");
	testType = testType != null?testType:"PerformanceTest";
	String testForInclusion = request.getParameter("TestsForInclusion");
	String[] strComponents = ri.getAllServersOfType(componentType);
	List listComponents = Arrays.asList(strComponents);

	String currentComponentPattern = componentType + ":" + componentName;

	IniFile egMgrMiscIni = new com.eg.IniFile (EgInstallInfo.getInstallDir()+"/manager/config/eg_mgrmisc.ini");
	String componentsLimit = egMgrMiscIni.getValue("MISC_ARGS","IncludeExcludeComponentsLimit");
	int limit = 100;
	if (!StringUtils.isNull(componentsLimit))
	{
		limit = Integer.parseInt(componentsLimit);
	}
	rootJson.put("hasMoreComponents",true);
	String query = "";
	//Scenario : Only one component is managed.
	if ((listComponents.size() == 1 && listComponents.contains(currentComponentPattern)) || (listComponents.size() > limit))
	{
		query = "EgIncludeComponentTests.jsp?componentType="+EgURLEncoder.encode(componentType,"UTF-8")+"&componentName="+EgURLEncoder.encode(componentName,"UTF-8")+"&TestsForInclusion="+EgURLEncoder.encode(testForInclusion,"UTF-8")+"&testType="+EgURLEncoder.encode(testType,"UTF-8");
		rootJson.put("hasMoreComponents",false);

	}

	IniFile disableIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_disable.ini");

	boolean isPortRelevantForTest = egSpecs.isPortRelevantForTest(testForInclusion);
	String subject = "";
	if (isPortRelevantForTest)
	{
		subject = componentType;
	}
	else
	{
		subject = "Default_server";
	}

	ArrayList aListTempComponents = new ArrayList(listComponents);
	if (!StringUtils.isNull(showUnconfigCompType) && showUnconfigCompType.equals("true"))
	{
		filterUnconfigCompList = (ArrayList) session.getAttribute("unconfigCompList");
		if (filterUnconfigCompList != null && filterUnconfigCompList.size() > 0)
		{
			if (aListTempComponents != null && aListTempComponents.size() > 0)
			{
				for(int i=0;i<aListTempComponents.size();i++)
				{
					String tempUnconfigComp = (String) aListTempComponents.get(i);
					if (!filterUnconfigCompList.contains(tempUnconfigComp))
					{
						filterUnconfigCompList.remove(tempUnconfigComp);
					}
				}
			}
			aListTempComponents = filterUnconfigCompList;
		}
	}
	ArrayList aListTests = new ArrayList();
	StringTokenizer st = new StringTokenizer(testForInclusion,",");
	while (st.hasMoreTokens())
	{
		String temp = st.nextToken();
		aListTests.add(temp);
	}

	ArrayList aListIncludedComponents=null;
	TreeMap tmapExcludedComps = null;
	TreeMap tmapCompsToBeIncluded = null;

	if (isPageRefreshed)
	{
		if (managed != null && managed.length() > 0)
		{
			tmapCompsToBeIncluded = new TreeMap();
			StringTokenizer stComponents = new StringTokenizer(managed,",");
			while (stComponents.hasMoreTokens())
			{
				String eachComponent = stComponents.nextToken();
				int hashIdx = eachComponent.indexOf("#");
				String strComponent = eachComponent.substring(0,hashIdx);
				String strTest = eachComponent.substring(hashIdx+1);
				ArrayList aListTempComps = (ArrayList)tmapCompsToBeIncluded.get(strTest);
				if (aListTempComps == null)
				{
					aListTempComps = new ArrayList();
					aListTempComps.add(strComponent);

					tmapCompsToBeIncluded.put(strTest,aListTempComps);
				}
				else
				{
					aListTempComps.add(strComponent);
				}
			}
		}

		if (unmanaged != null && unmanaged.length() > 0)
		{
			tmapExcludedComps = new TreeMap();
			StringTokenizer stComponents = new StringTokenizer(unmanaged,",");
			while (stComponents.hasMoreTokens())
			{
				String eachComponent = stComponents.nextToken();
				int hashIdx = eachComponent.indexOf("#");
				String strComponent = eachComponent.substring(0,hashIdx);
				String strTest = eachComponent.substring(hashIdx+1);
				ArrayList aListTempComps = (ArrayList)tmapExcludedComps.get(strTest);
				if (aListTempComps == null)
				{
					aListTempComps = new ArrayList();
					aListTempComps.add(strComponent);

					tmapExcludedComps.put(strTest,aListTempComps);
				}
				else
				{
					aListTempComps.add(strComponent);
				}
			}
		}
	}
	else
	{
		//ensure whether there are more than one components to be excluded.if not donot show this page
		boolean hasMoreThanOneCompToIncl = false;
		int compCount=0;
		int prevCompIdx=-1;
		for (int i=0;i<aListTests.size();i++)
		{
			String strTest = (String)aListTests.get(i);
			ArrayList aListStrExcludedComponents = null;
			ArrayList aListStrMainComponent = null;

			boolean isPortRelevantForStrTest = egSpecs.isPortRelevantForTest(strTest);
			String strSubject = "";
			if (isPortRelevantForStrTest)
			{
				strSubject = componentType;
			}
			else
			{
				strSubject = "Default_server";
			}

			List listVariables = Arrays.asList(disableIni.getVariables(strSubject));
			aListIncludedComponents = new ArrayList();
			for (int j=0;j<aListTempComponents.size();j++)
			{
				String strTempPattern = (String)aListTempComponents.get(j);
				String tempComponent = strTempPattern.substring(strTempPattern.indexOf(":")+1);
				String searchVariable = "";

				if (isPortRelevantForStrTest)
				{
					searchVariable = componentType + ":" + tempComponent;
				}
				else
				{
					searchVariable = "Default_server" + ":" + tempComponent.substring(0,tempComponent.indexOf(":"));
				}

				String strValue = disableIni.getValue(strSubject,searchVariable);
				ArrayList aListResultantTest = getArrayList(strValue,",");
				if (aListResultantTest.contains(strTest))
				{
					if (!hasMoreThanOneCompToIncl)
					{
						if (prevCompIdx == -1)
						{
							compCount++;
						}
						else
						{
							if (j != prevCompIdx)
							{
								compCount++;
							}
						}
						prevCompIdx=j;

						if (compCount > 1)
						{
							hasMoreThanOneCompToIncl = true;
						}
					}

					if (tempComponent.equals(componentName))
					{
						if (aListStrMainComponent == null)
						{
							aListStrMainComponent = new ArrayList();
						}

						aListStrMainComponent.add(componentName);
					}
					else
					{
						if (aListStrExcludedComponents == null)
						{
							aListStrExcludedComponents = new ArrayList();
						}

						aListStrExcludedComponents.add(tempComponent);
					}
				}
			}

			if (aListStrExcludedComponents != null)
			{
				if (tmapExcludedComps == null)
				{
					tmapExcludedComps = new TreeMap();
				}

				tmapExcludedComps.put(strTest,aListStrExcludedComponents);
			}

			if (aListStrMainComponent != null)
			{
				if (tmapCompsToBeIncluded == null)
				{
					tmapCompsToBeIncluded = new TreeMap();
				}

				tmapCompsToBeIncluded.put(strTest,aListStrMainComponent);
			}
		}

		if (!hasMoreThanOneCompToIncl)
		{
			query = "EgIncludeComponentTests.jsp?componentType="+EgURLEncoder.encode(componentType,"UTF-8")+"&componentName="+EgURLEncoder.encode(componentName,"UTF-8")+"&TestsForInclusion="+EgURLEncoder.encode(testForInclusion,"UTF-8")+"&testType="+EgURLEncoder.encode(testType,"UTF-8");
		}

		rootJson.put("hasMoreThanOneCompToIncl",hasMoreThanOneCompToIncl);

	}

	JSONArray selectedTestsArr = new JSONArray();
	JSONObject selectedTestsActualNameObj = new JSONObject();

	int d=0;
	while(d<aListTests.size())
	{
		JSONObject selectedTestsObj = new JSONObject();
		String strTestName1 = "";
		String strTestName2 = "";
		String strTestName = (String)aListTests.get(d);
		int count = d;
		if(!StringUtils.isNull(strTestName))
		{
			selectedTestsActualNameObj.put( _mapping.getTestDescription(strTestName),strTestName);
			strTestName = _mapping.getTestDescription(strTestName);
		}
		else
			strTestName = "";
		count = d+1;
		if(count < aListTests.size())
		{
			strTestName1 = (String)aListTests.get(count);
			if(!StringUtils.isNull(strTestName1))
			{
				selectedTestsActualNameObj.put(_mapping.getTestDescription(strTestName1),strTestName1);
				strTestName1 = _mapping.getTestDescription(strTestName1);
			}
		}
		count = d+2;
		if(count < aListTests.size())
		{
			strTestName2 = (String)aListTests.get(count);
			if(!StringUtils.isNull(strTestName2))
			{
				selectedTestsActualNameObj.put(_mapping.getTestDescription(strTestName2),strTestName2);
				strTestName2 = _mapping.getTestDescription(strTestName2);
			}
		}

		selectedTestsObj.put("Test1",strTestName);
		selectedTestsObj.put("Test2",strTestName1);
		selectedTestsObj.put("Test3",strTestName2);
		selectedTestsArr.add(selectedTestsObj);
		d = count+1;
	}
	rootJson.put("selectedTestsActualNameObj",selectedTestsActualNameObj);
	rootJson.put("selectedTestsArr",selectedTestsArr);
	rootJson.put("fieldTitleComponentType",_mapping.getComponentTypeDescription(componentType)+"&nbsp;components");

	if (tmapCompsToBeIncluded != null)
	{
		JSONArray includeComponentsArr = new JSONArray();
		JSONObject includeComponentsObj = new JSONObject();

		for (int i=0;i<aListTests.size();i++)
		{
			String strTest = (String)aListTests.get(i);
			ArrayList aListResultant = (ArrayList)tmapCompsToBeIncluded.get(strTest);
			if (aListResultant !=  null && aListResultant.size() > 0)
			{
				Collections.sort(aListResultant,String.CASE_INSENSITIVE_ORDER);
				String strLabel = _mapping.getTestDescription(strTest);
				for (int j=0;j<aListResultant.size();j++)
				{
					String strComp = (String)aListResultant.get(j);
					String strDispComp = null;
					if (strComp.indexOf(":NULL") > -1)
					{
						strDispComp = strComp.substring(0,strComp.indexOf(":"));
					}
					else
					{
						strDispComp = strComp;
					}
					includeComponentsObj.put("valueField",strComp+"#"+strTest);
					includeComponentsObj.put("displayField",strDispComp);
					includeComponentsObj.put("groupField",strLabel);
					includeComponentsArr.add(includeComponentsObj);
				}
			}
		}
		rootJson.put("includeComponentsArr",includeComponentsArr);
	}

	if (tmapExcludedComps != null)
	{
		JSONArray excludeComponentsArr = new JSONArray();
		JSONObject excludeComponentsObj = new JSONObject();

		for (int i=0;i<aListTests.size();i++)
		{
			String strTest = (String)aListTests.get(i);
			ArrayList aListResultant = (ArrayList)tmapExcludedComps.get(strTest);
			if (aListResultant != null && aListResultant.size() > 0)
			{
				Collections.sort(aListResultant,String.CASE_INSENSITIVE_ORDER);
				String strLabel = _mapping.getTestDescription(strTest);
				for (int j=0;j<aListResultant.size();j++)
				{
					String strComp = (String)aListResultant.get(j);
					String strDispComp = null;
					if (strComp.indexOf(":NULL") > -1)
					{
						strDispComp = strComp.substring(0,strComp.indexOf(":"));
					}
					else
					{
						strDispComp = strComp;
					}
					excludeComponentsObj.put("valueField",strComp+"#"+strTest);
					excludeComponentsObj.put("displayField",strDispComp);
					excludeComponentsObj.put("groupField",strLabel);
					excludeComponentsArr.add(excludeComponentsObj);
				}
			}
		}
		rootJson.put("excludeComponentsArr",excludeComponentsArr);
	}
	hiddenObj.put("componentType",componentType);
	hiddenObj.put("mainComponentName",componentName);
	hiddenObj.put("testType",testType);
	hiddenObj.put("TestsForInclusion",testForInclusion);
	hiddenObj.put("pageRefreshed","true");
	hiddenObj.put("showPopup",request.getParameter("showPopup"));
	rootJson.put("showUnconfigCompType",showUnconfigCompType);
	rootJson.put("hiddenObjIncludePage",hiddenObj);

	out.println(rootJson.toString());

%>



