Ext.define('SpecificThreshold.controller.Main',{
	extend: 'Ext.app.Controller',
	refs:[
		{selector:'specificthresholds', ref:'specificthresholds'},
		{selector:'configurespecificthresholds', ref:'configurespecificthresholds'},
		{selector:'applythresholds', ref:'applythresholds'},
		{selector:'viewthresholds', ref:'viewthresholds'},
	],
	init:function(){
		me = this,
		this.control({
			'applythresholds':
			{
				'boxready': this.afterApplyMainRender
			},
			'applythresholds combo[id="viewByCombo"]':
			{
				'select': this.applyViewComboChange
			},
			'applythresholds combo[id="serviceCombo"]':
			{
				'select': this.applyServiceComboChange
			},
			'applythresholds button[id="applyOtherCompBtn"]':
			{
				'click': this.applyOtherCompsUpdateData
			},
			'applythresholds button[id="applyBackBtn"]':
			{
				'click': this.applyOtherCompsBack
			},
			'viewthresholds':
			{
				'boxready': this.afterViewMainRender
			},
			'viewthresholds grid[id="measureGrid"]':
			{
				itemmouseenter: this.showModifyTool,
				itemmouseleave: this.hideModifyTool
			},
			'viewthresholds grid[id="noMeasureGrid"]':
			{
				'cellclick': this.viewNoThreshMeasureModify,
			},
			'viewthresholds button[id="deleteBtn"]':
			{
				'click': this.deleteDescriptorSpecificThresholds
			},
			'viewthresholds button[id="viewThreshBackBtn"]':
			{
				'click': this.viewThreshBack
			},
			'viewthresholds button[id="applyToOtherCompBtn"]':
			{
				'click': this.applyToOtherComponents
			},
			'viewthresholds grid[id="specificDescriptorGrid"]':
			{
				'cellclick': this.noThreshMeasureModify
			},
			'specificthresholds':
			{
				'boxready': this.afterMainRender
			},
			'specificthresholds button[id="backbutton"]': {
				'click': this.goToBack
			},
			'specificthresholds combo[id="compTypeCombo"]':
			{
				'select': this.compTypeChange
			},
			'specificthresholds combo[id="compNameCombo"]':
			{
				'select': this.compNameChange
			},
			'specificthresholds button[id="configureGroupPageBtn"]':
			{
				'click': this.gotoGroupThreshPage
			},
			'specificthresholds grid[id="globalTestGrid"]':
			{
				'cellclick': this.noThreshMeasureModify,
			},
			'specificthresholds grid[id="specificDescGrid"]':
			{
				'cellclick': this.noThreshMeasureModify,
			},
			'specificthresholds grid[id="testDescGrid"]':
			{
				'cellclick': this.noThreshMeasureModify,
			},
			'specificthresholds grid[id="specificOrTestGrid"]':
			{
				'cellclick': this.noThreshMeasureModify,
			},
			'specificthresholds button[id="groupTestModifyBtn"]':
			{
				'click': this.callGrpRulePage,
			},
			'specificthresholds button[id="groupTestDescriptorBtn"]':
			{
				'click': this.populateGroupDescriptor,
			},
			'specificthresholds button[id="groupTestModifyRuleBtn"]':
			{
				'click': this.callGrpRulePage,
			},
			'specificthresholds button[id="specificTestModifyBtn"]':
			{
				'click': this.callThreshValPage,
			},
			'specificthresholds button[id="defaultTestModifyBtn"]':
			{
				'click': this.callThreshValPage,
			},
			'specificthresholds button[id="specificTestDescriptorBtn"]':
			{
				'click': this.populateSpecDescriptor,
			},
			'specificthresholds button[id="defaultTestDescriptorBtn"]':
			{
				'click': this.populateDefDescriptor,
			},
			'specificthresholds trigger[id="twoDescriptorTabSearch"]':
			{
				'change': this.filterGrid,
			},
			'specificthresholds trigger[id="oneDescriptorTabSearch"]':
			{
				'change': this.filterGrid,
			},
			'configurespecificthresholds button[id="updateBtn"]':
			{
				'click': this.applyThresholdsData
			},
			'configurespecificthresholds slider[id="relMinCritical"]':
			{
				'drag': this.minRelCriticalSlider,
				'change': this.minRelCriticalSlider,
			},
			'configurespecificthresholds slider[id="relMinMajor"]':
			{
				'drag': this.minRelMajorSlider,
				'change': this.minRelMajorSlider,
			},
			'configurespecificthresholds slider[id="relMinMinor"]':
			{
				'drag': this.minRelMinorSlider,
				'change': this.minRelMinorSlider,
			},
			'configurespecificthresholds slider[id="relMaxCritical"]':
			{
				'drag': this.maxRelCriticalSlider,
				'change': this.maxRelCriticalSlider,
			},
			'configurespecificthresholds slider[id="relMaxMajor"]':
			{
				'drag': this.maxRelMajorSlider,
				'change': this.maxRelMajorSlider,
			},
			'configurespecificthresholds slider[id="relMaxMinor"]':
			{
				'drag': this.maxRelMinorSlider,
				'change': this.maxRelMinorSlider,
			},
			'configurespecificthresholds':
			{
				'boxready': this.configureMainRender,
			},
			'configurespecificthresholds checkbox[id="minStaticCheck"]':
			{
				'change': this.minStaticCheckChange,
			},
			'configurespecificthresholds checkbox[id="minAutoCheck"]':
			{
				'change': this.minAutoCheckChange,
			},
			'configurespecificthresholds checkbox[id="maxStaticCheck"]':
			{
				'change': this.maxStaticCheckChange,
			},
			'configurespecificthresholds checkbox[id="maxAutoCheck"]':
			{
				'change': this.maxAutoCheckChange,
			},
			'configurespecificthresholds combo[id="alarmPolicyCombo"]':
			{
				'select': this.alarmPolicyChange,
			},
			'configurespecificthresholds button[id="configureBackBtn"]':
			{
				'click': this.configureBack,
			},
		});
	},
	applyOtherCompsBack : function()
	{
		var tmpCompType = publicJson['hiddenObj']['componentType'];
		if (tmpCompType != null && !Ext.isEmpty(tmpCompType))
		{
			strCompType = tmpCompType;
		}
		
		tmpCompName = publicJson['hiddenObj']['componentName'];
		if (tmpCompName != null && !Ext.isEmpty(tmpCompName))
		{
			strCompName = tmpCompName;
		}
		tmpTestName = publicJson['hiddenObj']['testName'];
		if (tmpTestName != null && !Ext.isEmpty(tmpTestName))
		{
			strTestName = tmpTestName;
		}
		tmpDescName = publicJson['hiddenObj']['descriptorName'];
		if (tmpDescName != null && !Ext.isEmpty(tmpDescName))
		{
			strDescName = tmpDescName;
		}
		tmpFrom = publicJson['hiddenObj']['from'];
		if (tmpFrom != null && !Ext.isEmpty(tmpFrom))
		{
			from = tmpFrom;
		}
		tmpIsRefine = publicJson['hiddenObj']['isRefine'];
		if (tmpIsRefine != null && !Ext.isEmpty(tmpIsRefine))
		{
			isRefine = tmpIsRefine;
		}
		var homepage = Ext.getCmp('viewPortId');
			homepage.removeAll();
			homepage.add({ xtype : 'viewthresholds' });
	},
	applyOtherCompsUpdateData: function (type)
	{
		var myMask = '';
		var compType = publicJson['hiddenObj']['comptype'];
		var compName = publicJson['hiddenObj']['compname'];
		var test = publicJson['hiddenObj']['test'];
		var descName = publicJson['hiddenObj']['descName'];
		var existCompNameArr = publicJson['existCompNameArr'];
		var selectedComponents = "";
		var associateComp = Ext.getCmp('applyItemSeletor').fromField.store;
		var applyAssociate = '';
		if(associateComp != null && !Ext.isEmpty(associateComp) && associateComp.getCount() == existCompNameArr.length)
		{
			for (var i=0;i<associateComp.getCount() ;i++)
			{
				var allValue = associateComp.getAt(i).get('valueField');
				applyAssociate +=allValue+',';
			}
		}
		else
		{
			if (existCompNameArr != null && !Ext.isEmpty(existCompNameArr))
			{
				var existingComp = Ext.getCmp('applyItemSeletor').getValue();
				if (existingComp != null && !Ext.isEmpty(existingComp))
				{
					for (var i=0; i<existCompNameArr.length; i++)
					{
						var compVal = existCompNameArr[i];
						var isData = false;
						for (var j=0;j<existingComp.length ;j++)
						{
							var allValue = existingComp[j];
							if(compVal == allValue)
							{
								isData = true;
								break;
							}
						}
						if(!isData)
						{
							applyAssociate +=compVal+',';
						}
					}
				}
			}
		}

		if(applyAssociate.length == 0)
		{
			Ext.MessageBox.show({
				title: pageName,
				msg: applyOtherCompAlert,
				icon: 'iconExclamation',
				buttons: Ext.Msg.OK,
			});
		}
		else
		{
			var homepage = Ext.getCmp('viewPortId');
			var myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
			myMask.show();

			if (descName == null || descName == 'undefined')
			{
				descName = 'null';
			}
			if (applyAssociate.length > 0)
			{
				applyAssociate = applyAssociate.substring(0,applyAssociate.length-1);
			}
			var params = "componentType="+encodeURIComponent(compType)+"&componentName="+encodeURIComponent(applyAssociate)+"&testName="+encodeURIComponent(test)+"&descriptorName="+encodeURIComponent(descName)+"&from=specificTest&isApply=true&operation=updateThresholds&parentComp="+encodeURIComponent(compName);

			Ext.Ajax.request({
				url:'SpecificThreshold/data/EgApplySpecificThresholdsForAllComps.jsp?'+params,
				method:'POST',
				scope:this,
				async: false,
				success:function(response)
				{
					myMask.hide();
					Ext.Msg.show({
						title: pageName,
						msg: successAlert,
						icon: 'iconInformation',
						buttons: Ext.Msg.OK,
						fn: function(){
							window.location.href = 'EgSpecificThresh.jsp?server='+encodeURIComponent(compType)+'&compName='+encodeURIComponent(compName)
						}
					});
				}
			});
		}
	},
	applyServiceComboChange: function()
	{
		ea_criteria = Ext.getCmp('viewByCombo').getValue();
		ea_userOption = Ext.getCmp('serviceCombo').getValue();
		var params = this.getHiddenFieldsForApplytoOtherComponent();
		if (ea_userOption != null && !Ext.isEmpty(ea_userOption))
		{
			Ext.Ajax.request({
				url:'SpecificThreshold/data/EgApplyThresholdsToOtherComponentsJson.jsp?'+params+'ea_criteria='+ea_criteria+'&ea_userOption='+ea_userOption,
				method:'POST',
				scope:this,
				success:function(response)
				{
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);

					var dispMsg = publicJson['screenLabels']['disp_msg'];
					var compNameArr = publicJson['compNameArr'];
					var vecUserOptionsArr = publicJson['vecUserOptionsArr'];
					var existCompNameArr = publicJson['existCompNameArr'];
					var selectedViewType = publicJson['selectedViewType'];
					var isSelectedTypeCombo = publicJson['isSelectedTypeCombo'];

					if(dispMsg != null && !Ext.isEmpty(dispMsg))
					{
						Ext.getCmp('dispComponentId').update(dispMsg);
					}
					if (compNameArr != null && !Ext.isEmpty(compNameArr))
					{
						Ext.getCmp('applyItemSeletor').getStore().removeAll();
						if ( Ext.getCmp('applyItemSeletor').toField.store.getCount() >= 1)
						{
							Ext.getCmp('applyItemSeletor').toField.store.removeAll();
						}
						Ext.getCmp('applyItemSeletor').toField.store.add(compNameArr);
					}else
					{
						Ext.getCmp('applyItemSeletor').toField.store.removeAll();
					}
				}
			});
		}
	},
	applyViewComboChange: function()
	{
		ea_criteria = Ext.getCmp('viewByCombo').getValue();
		var params = this.getHiddenFieldsForApplytoOtherComponent();
		if (ea_criteria != null && !Ext.isEmpty(ea_criteria))
		{
			Ext.Ajax.request({
				url:'SpecificThreshold/data/EgApplyThresholdsToOtherComponentsJson.jsp?'+params+'ea_criteria='+ea_criteria,
				method:'POST',
				scope:this,
				success:function(response)
				{
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);

					var dispMsg = publicJson['screenLabels']['disp_msg'];
					var compNameArr = publicJson['compNameArr'];
					var vecUserOptionsArr = publicJson['vecUserOptionsArr'];
					var existCompNameArr = publicJson['existCompNameArr'];
					var selectedViewType = publicJson['selectedViewType'];
					var isSelectedTypeCombo = publicJson['isSelectedTypeCombo'];
					var operationCombo = Ext.getCmp('serviceCombo');
					if(dispMsg != null && !Ext.isEmpty(dispMsg))
					{
						Ext.getCmp('dispComponentId').update(dispMsg);
					}
					if (isSelectedTypeCombo)
					{
						operationCombo.setFieldLabel(ea_criteria);
						operationCombo.show();
						//operationCombo.setDisabled(false);
						operationCombo.getStore().removeAll();
						operationCombo.getStore().loadRawData(vecUserOptionsArr);
						operationCombo.setValue(vecUserOptionsArr[0].valueField);
						operationCombo.fireEvent('select', operationCombo);
					}
					else
					{
						operationCombo.hide();
						//operationCombo.setDisabled(true);
					}
					if (compNameArr != null && !Ext.isEmpty(compNameArr))
					{
						Ext.getCmp('applyItemSeletor').getStore().removeAll();
						if ( Ext.getCmp('applyItemSeletor').toField.store.getCount() >= 1)
						{
							Ext.getCmp('applyItemSeletor').toField.store.removeAll();
						}

						if ( Ext.getCmp('applyItemSeletor').fromField.store.getCount() >= 1)
						{
							Ext.getCmp('applyItemSeletor').fromField.store.removeAll();
						}

						Ext.getCmp('applyItemSeletor').toField.store.add(compNameArr);
					}
				}
			});
		}
	},
	afterApplyMainRender: function()
	{
		var tmpCompType = publicJson['hiddenObj']['componentType'];
		if (tmpCompType != null && !Ext.isEmpty(tmpCompType))
		{
			strCompType = tmpCompType;
		}
		tmpCompName = publicJson['hiddenObj']['componentName'];
		if (tmpCompName != null && !Ext.isEmpty(tmpCompName))
		{
			strCompName = tmpCompName;
		}
		tmpTestName = publicJson['hiddenObj']['testName'];
		if (tmpTestName != null && !Ext.isEmpty(tmpTestName))
		{
			strTestName = tmpTestName;
		}

		from = publicJson['hiddenObj']['from'];
		isRefine = publicJson['hiddenObj']['isRefine'];
		if (isRefine == null || Ext.isEmpty(isRefine) || isRefine == 'undefined')
		{
			isRefine = 'false';
		}

		tmpDescName = publicJson['hiddenObj']['descriptorName'];
		if (tmpDescName != null && !Ext.isEmpty(tmpDescName))
		{
			strDescName = tmpDescName;
		}
			params = 'reqfrom=navlink';
		var qStr = '';
		if (strCompType != null && strCompType != 'undefined' && strCompType.length > 0)
		{
			qStr += 'comptype='+encodeURIComponent(strCompType);
		}
		if (strCompName != null && strCompName != 'undefined' && strCompName.length > 0)
		{
			qStr += '&compname='+encodeURIComponent(strCompName);
		}
		if (strTestName != null && strTestName != 'undefined' && strTestName.length > 0)
		{
			qStr += '&test='+strTestName;
		}
		if (strDescName != null && strDescName != 'undefined' && strDescName.length > 0)
		{
			qStr += '&descName='+encodeURIComponent(strDescName);
		}
		if (from != null && from != 'undefined' && from.length > 0)
		{
			qStr += '&from='+from;
		}
		if (isRefine != null && isRefine != 'undefined' && isRefine.length > 0)
		{
			qStr += '&isRefine='+isRefine;
		}
		
		if (qStr != null && qStr.length > 0)
		{
			params = qStr;
		}
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myMask.show();
		Ext.Ajax.request({
			url:'SpecificThreshold/data/EgApplyThresholdsToOtherComponentsJson.jsp?'+params,
			method:'POST',
			scope:this,
			success:function(response)
			{
				myMask.hide();
				var jsonText = response.responseText;
				publicJson = Ext.decode(jsonText);

				var dispMsg = publicJson['screenLabels']['disp_msg'];
				var viewByComboArr = publicJson['viewByComboArr'];
				var compNameArr = publicJson['compNameArr'];
				var existCompNameArr = publicJson['existCompNameArr'];
				var selectedViewType = publicJson['selectedViewType'];
				var isSelectedTypeCombo = publicJson['isSelectedTypeCombo'];
				var vecUserOptionsArr = publicJson['vecUserOptionsArr'];

				if(dispMsg != null && !Ext.isEmpty(dispMsg))
				{
					Ext.getCmp('dispComponentId').update(dispMsg);
				}
				Ext.getCmp('viewByCombo').getStore().loadRawData(viewByComboArr);
				if (selectedViewType != null && selectedViewType != 'undefined')
				{
					Ext.getCmp('viewByCombo').setValue(selectedViewType);
					Ext.getCmp('viewByCombo').fireEvent('select', Ext.getCmp('viewByCombo'));
				}
				else
				{
					Ext.getCmp('viewByCombo').setValue(compTypeArr[0].valueField);
				}
				
				if (isSelectedTypeCombo)
				{
					Ext.getCmp('serviceCombo').show();
					Ext.getCmp('serviceCombo').getStore().loadRawData(vecUserOptionsArr);
				}
				else
				{
					Ext.getCmp('serviceCombo').hide();
				}
			}
		});
	},
	applyToOtherComponents: function()
	{
		var homepage = Ext.getCmp('viewPortId');
			homepage.removeAll();
			homepage.add({ xtype : 'applythresholds' });
	},
	configureBack : function()
	{
		var tmpCompType = publicJson['hiddenObj']['componentType'];
		if (tmpCompType != null && !Ext.isEmpty(tmpCompType))
		{
			strCompType = tmpCompType;
		}
		
		tmpCompName = publicJson['hiddenObj']['componentName'];
		if (tmpCompName != null && !Ext.isEmpty(tmpCompName))
		{
			strCompName = tmpCompName;
		}
		tmpTestName = publicJson['hiddenObj']['testName'];
		if (tmpTestName != null && !Ext.isEmpty(tmpTestName))
		{
			strTestName = tmpTestName;
		}
		tmpDescName = publicJson['hiddenObj']['descriptorName'];
		if (tmpDescName != null && !Ext.isEmpty(tmpDescName))
		{
			strDescName = tmpDescName;
		}
		from = publicJson['hiddenObj']['from'];
		var homepage = Ext.getCmp('viewPortId');
			homepage.removeAll();
			homepage.add({ xtype : 'viewthresholds' });
	},
	viewThreshBack : function()
	{
		var tmpCompType = publicJson['hiddenObj']['componentType'];
		if (tmpCompType != null && !Ext.isEmpty(tmpCompType))
		{
			strCompType = tmpCompType;
		}
		
		tmpCompName = publicJson['hiddenObj']['componentName'];
		if (tmpCompName != null && !Ext.isEmpty(tmpCompName))
		{
			strCompName = tmpCompName;
		}
		tmpTestName = publicJson['hiddenObj']['testName'];
		if (tmpTestName != null && !Ext.isEmpty(tmpTestName))
		{
			strTestName = tmpTestName;
		}
		from = publicJson['hiddenObj']['from'];
		var homepage = Ext.getCmp('viewPortId');
		if (isFromViewThreshPage == "true")
		{
			this.callViewThreshValPage('specificTestModifyBtn');
		}
		else 
		{
			homepage.removeAll();
			homepage.add({ xtype : 'specificthresholds' });
		}
	},
	getSearchDataArrFormat : function(compStore,findVal) //search function
	{
		var newRecordArr = new Array();
		if (compStore != null && !Ext.isEmpty(compStore))
		{
			for ( var i = 0; i < compStore.length ; i++ )
			{
				var getRecord = compStore[i]['Test1'];
				if ( getRecord.toLowerCase().indexOf(findVal.toLowerCase()) > -1 )
				{
					isRecordFound = true;
					newRecordArr[newRecordArr.length] = getRecord;
				}
				getRecord = compStore[i]['Test2'];
				if ( getRecord.toLowerCase().indexOf(findVal.toLowerCase()) > -1 )
				{
					isRecordFound = true;
					newRecordArr[newRecordArr.length] = getRecord;
				}
				getRecord = compStore[i]['Test3'];
				if ( getRecord.toLowerCase().indexOf(findVal.toLowerCase()) > -1 )
				{
					isRecordFound = true;
					newRecordArr[newRecordArr.length] = getRecord;
				}
			}
		}
		return newRecordArr;
	},
	getSearchStoreData: function(newRecordArr)
	{
		var genStore = new Ext.data.Store({
							fields : ['Test1', 'Test2', 'Test3'],
							data : []                                
						});

		if (newRecordArr != null && !Ext.isEmpty(newRecordArr))
		{
			for ( var d = 0; d < newRecordArr.length ; d+=3 )
			{
				var strDescName1 = "";
				var strDescName2 = "";
				var strDescName = newRecordArr[d];
				var count = d;
				if(strDescName == null || Ext.isEmpty(strDescName))
				{
					strDescName = "";
				}
				count = d+1;
				strDescName1 = newRecordArr[count];
				if(strDescName1 == null || Ext.isEmpty(strDescName1))
				{
					strDescName1 = "";
				}
				count = d+2;
				strDescName2 = newRecordArr[count];
				if(strDescName2 == null || Ext.isEmpty(strDescName2))
				{
					strDescName2 = "";
				}
				genStore.add({
					'Test1': strDescName,
					'Test2': strDescName1,
					'Test3': strDescName2,
				});
			}
		}
		return genStore;
	},
	filterGrid:function(obj)
	{
		var findVal = obj.getValue();
		if (findVal == "" || findVal.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}
		var compStore = publicJson[''];
		var twoDescTab = Ext.getCmp('twoDescriptorTab').isVisible();
		var oneDescTab = Ext.getCmp('oneDescriptorTab').isVisible();
		var isSelfandTestFollow = publicJson['isSelfandTestFollow'];
		var isSelfFollow = publicJson['isSelfFollow'];
		var isTestFollow = publicJson['isTestFollow'];

		var specsDescArr = publicJson['specsDescArr'];
		var testDescArr = publicJson['testDescArr'];
		if (twoDescTab)
		{
			var compStore = '';
			if (isSelfFollow)
			{
				compStore = publicJson['specsDescArr'];
				var compObj = Ext.getCmp('specificDescGrid');
				if ( Ext.isEmpty( obj.getValue()))
				{
					compObj.getStore().loadRawData(compStore);
				}
				else
				{
					var isRecordFound = false;
					var genStore = new Ext.data.Store({
											fields : ['Test1', 'Test2', 'Test3'],
											data : []                                
										});

					var newRecordArr = new Array();
					newRecordArr = this.getSearchDataArrFormat(compStore,findVal);
					if(newRecordArr != null && !Ext.isEmpty(newRecordArr))
					{
						isRecordFound = true;
						genStore = this.getSearchStoreData(newRecordArr);
					}

					if ( isRecordFound )
					{
						compObj.getStore().removeAll();    
						for ( var i = 0; i < genStore.getCount() ; i++ )
						{
							var getRecord = genStore.getAt(i);
							compObj.getStore().add(getRecord);
						}
					}
					else
					{
						compObj.getStore().removeAll();
					}
					obj.focus();
				}
			}
			
			if (isTestFollow)
			{
				compStore = publicJson['testDescArr'];
				var compObj = Ext.getCmp('testDescGrid');
				if ( Ext.isEmpty( obj.getValue() ) )
				{
					compObj.getStore().loadRawData(compStore);
				}
				else
				{
					var isRecordFound = false;
					var genStore = new Ext.data.Store({
											fields : ['Test1', 'Test2', 'Test3'],
											data : []                                
										});

					var newRecordArr = new Array();
					newRecordArr = this.getSearchDataArrFormat(compStore,findVal);
					if(newRecordArr != null && !Ext.isEmpty(newRecordArr))
					{
						isRecordFound = true;
						genStore = this.getSearchStoreData(newRecordArr);
					}
					if ( isRecordFound )
					{
						compObj.getStore().removeAll();    
						for ( var i = 0; i < genStore.getCount() ; i++ )
						{
							var getRecord = genStore.getAt(i);
							compObj.getStore().add(getRecord);
						}
					}
					else
					{
						compObj.getStore().removeAll();
					}
					obj.focus();
				}
			}
		}
		else if (oneDescTab)
		{
			var compStore = '';
			if (isSelfFollow)
			{
				compStore = publicJson['specsDescArr'];
			}
			else if (isTestFollow)
			{
				compStore = publicJson['testDescArr'];
			}
			var compObj = Ext.getCmp('specificOrTestGrid');
			if ( Ext.isEmpty( obj.getValue() ) )
			{
				compObj.getStore().loadRawData(compStore);
			}
			else
			{
				var isRecordFound = false;
				var genStore = new Ext.data.Store({
										fields : ['Test1', 'Test2', 'Test3'],
										data : []                                
									});

				var newRecordArr = new Array();
				newRecordArr = this.getSearchDataArrFormat(compStore,findVal);
				if(newRecordArr != null && !Ext.isEmpty(newRecordArr))
				{
					isRecordFound = true;
					genStore = this.getSearchStoreData(newRecordArr);
				}

				if ( isRecordFound )
				{
					compObj.getStore().removeAll();    
					for ( var i = 0; i < genStore.getCount() ; i++ )
					{
						var getRecord = genStore.getAt(i);
						compObj.getStore().add(getRecord);
					}
				}
				else
				{
					compObj.getStore().removeAll();
				}
				obj.focus();
			}
		}
	},
	afterViewMainRender: function()
	{
		params = '';
		var qStr = '';
		if (strCompType != null && strCompType != 'undefined' && strCompType.length > 0)
		{
			qStr = 'comptype='+encodeURIComponent(strCompType)+'&server='+encodeURIComponent(strCompType);
		}
		if (strCompName != null && strCompName != 'undefined' && strCompName.length > 0)
		{
			qStr += '&compname='+encodeURIComponent(strCompName);
		}
		if (strTestName != null && strTestName != 'undefined' && strTestName.length > 0)
		{
			qStr += '&test='+strTestName;
		}
		if (strDescName != null && strDescName != 'undefined' && strDescName.length > 0)
		{
			qStr += '&descName='+encodeURIComponent(strDescName);
		}
		if (from != null && from != 'undefined' && from.length > 0)
		{
			qStr += '&from='+from;
		}
		if (isRefine != null && isRefine != 'undefined' && isRefine.length > 0)
		{
			qStr += '&isRefine='+isRefine;
		}
		if (comeFrom != null && comeFrom != 'undefined' && comeFrom.length > 0)
		{
			qStr += '&comeFrom='+comeFrom;
		}
		
		if (qStr != null && qStr.length > 0)
		{
			params = qStr;
		}
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myMask.show();
		Ext.Ajax.request({
			url:'SpecificThreshold/data/EgSpecificThresholdsDataJson.jsp?'+params,
			method:'POST',
			scope:this,
			success:function(response)
			{
				myMask.hide();
				var jsonText = response.responseText;
				publicJson = Ext.decode(jsonText);

				var fieldTitleId = publicJson['screenLabels']['disp_msg'];
				var isHostTest = publicJson['isHostTest'];
				var selectedCompType = publicJson['displayCompType'];
				var selectedCompName = publicJson['displayCompName'];
				var selectedTestName = publicJson['displayTestName'];
				var measureThreshValArr = publicJson['measureValArr'];
				var noMeasureThreshValArr = publicJson['noMeasureValArr'];
				var isHasSpecific = publicJson['isHasSpecific'];
				var specificDescListArr = publicJson['specificDescListArr'];
				var isApplyToOtherCompBtn = publicJson['isApplyToOtherCompBtn'];
				var isDeleteBtn = publicJson['isDeleteBtn'];
				var isMonBack = publicJson['isMonBack'];
				if (isMonBack)
				{
					//Ext.getCmp('viewThreshBackBtn').setDisabled(true);
					Ext.getCmp('viewThreshBackBtn').hide();
				}
				else
				{
					Ext.getCmp('viewThreshBackBtn').show();
				}

				if(isHostTest)
				{
					Ext.getCmp('hostTestMsgComponent').show();
				}
				else 
				{
					Ext.getCmp('hostTestMsgComponent').hide();
				}
				Ext.getCmp('fieldTitleId').show();
				Ext.getCmp('fieldTitleId').setTitle(fieldTitleId);
				Ext.getCmp('compTypeDisplayField').setValue(selectedCompType);
				Ext.getCmp('compNameDisplayField').setValue(selectedCompName);
				
				
				if(measureThreshValArr != null &&  !Ext.isEmpty(measureThreshValArr))
				{
					Ext.getCmp('measureGrid').show();
					Ext.getCmp('measureGrid').suspendEvents();
					Ext.getCmp('measureGrid').getStore().removeAll();
					Ext.getCmp('measureGrid').getStore().loadRawData(measureThreshValArr);
					Ext.getCmp('measureGrid').resumeEvents();
					//Ext.getCmp('measureGrid').show();

				}else
				{
					Ext.getCmp('measureGrid').hide();
				}

				if(noMeasureThreshValArr != null && !Ext.isEmpty(noMeasureThreshValArr))
				{
					Ext.getCmp('noMeasureGrid').show();
					Ext.getCmp('noMeasureGrid').suspendEvents();
					Ext.getCmp('noMeasureGrid').getStore().removeAll();
					Ext.getCmp('noMeasureGrid').getStore().loadRawData(noMeasureThreshValArr);
					Ext.getCmp('noMeasureGrid').resumeEvents();
					//Ext.getCmp('noMeasureGrid').show();
				}
				else
				{
					Ext.getCmp('noMeasureGrid').hide();
				}

				if(isDeleteBtn && isApplyToOtherCompBtn)
				{
					Ext.getCmp('deleteBtnContainer').show();
					//Ext.getCmp('applyToOtherCompBtn').setDisabled(true);
				}else
				{
					if(isDeleteBtn && !isApplyToOtherCompBtn)
					{
						Ext.getCmp('deleteBtnContainer').show();
						Ext.getCmp('deleteBtn').setDisabled(false);
						Ext.getCmp('applyToOtherCompBtn').setDisabled(true);
					}

					if (isApplyToOtherCompBtn && !isDeleteBtn)
					{
						Ext.getCmp('deleteBtnContainer').show();
						Ext.getCmp('applyToOtherCompBtn').setDisabled(false);
						Ext.getCmp('deleteBtn').setDisabled(true);
						
					}
					if(!isDeleteBtn && !isApplyToOtherCompBtn)
					{
						Ext.getCmp('deleteBtnContainer').hide();
					}
				}

				if (isHasSpecific)
				{
					Ext.getCmp('specificDescTab').show();

					if(specificDescListArr != null && !Ext.isEmpty(specificDescListArr))
					{
						Ext.getCmp('specificDescriptorGrid').suspendEvents(true);
						Ext.getCmp('specificDescriptorGrid').getStore().removeAll();
						Ext.getCmp('specificDescriptorGrid').getStore().loadRawData(specificDescListArr);
						Ext.getCmp('specificDescriptorGrid').resumeEvents();
						Ext.getCmp('specificDescriptorGrid').show();
					}
					else
					{
						Ext.getCmp('specificDescriptorGrid').hide();
					}
				}
				else
				{
					Ext.getCmp('specificDescTab').hide();
				}
			}
		});
	},
	populateSpecDescriptor: function()
	{
		Ext.getCmp('noDescriptorMsgContainer').hide();
		Ext.getCmp('oneDescriptorTab').hide();
		Ext.getCmp('twoDescriptorTab').hide();

		var compType = Ext.getCmp('compTypeCombo').getValue();
		var compName = Ext.getCmp('compNameCombo').getValue();
		var test;
		var qctr;
		var flag = false;
		var specThreshTests = Ext.getCmp('specificTestMultiSelect').getValue();
		var isSpecificTestSelected = false;
		var specTest = "";
		for (key in specThreshTests )
		{
			var grpTest = specThreshTests[key];
			if(!Ext.isEmpty(grpTest) && grpTest != null && grpTest != 'undefined')
			{
				isSpecificTestSelected = true;
				specTest = grpTest;
			}
		}
		if (!isSpecificTestSelected)
		{
			Ext.Msg.show({
				title: pageName,
				msg: selectSpecificTestAlert,
				icon: 'iconExclamation',
				buttons: Ext.Msg.OK
			});
			return;
		}

		if (specTest != null && specTest != "")
		{
			flag = true;
			test = specTest;
			qctr = "specific";
		}

		var str = "SpecificThreshold/data/EgSpecificThreshJson.jsp?qctr="+qctr+"&server="+encodeURIComponent(compType)+"&compName="+ encodeURIComponent(compName)+"&test="+encodeURIComponent(test)+"&from=specsthreshinfo";
		if (flag)
		{
			Ext.Ajax.request({
				url:str,
				method: 'POST',
				timeout: 600000,
				success: function(response)
				{
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);


					var compTypeArr = publicJson['specCompTypeArr'];
					var compNameArr = publicJson['specCompNameArr'];
					var globalTestArr = publicJson['globalTestsArr'];
					var specificTestArr = publicJson['specTestsArr'];
					var defaultTestArr = publicJson['defaultTestsArr'];
					var compType = publicJson['selectedCompType'];
					var compName = publicJson['selectedCompName'];
					var specificTestName = publicJson['selectedSpecsTest'];
					var groupTestName = publicJson['selectedGroupTest'];
					var defaultTestName = publicJson['selectedTest'];
					Ext.getCmp('compTypeCombo').getStore().loadRawData(compTypeArr);
					if (compType != null && compType != 'undefined')
					{
						Ext.getCmp('compTypeCombo').setValue(compType);
					}
					else
					{
						Ext.getCmp('compTypeCombo').setValue(compTypeArr[0].valueField);
					}
					
					Ext.getCmp('compNameCombo').getStore().loadRawData(compNameArr);
					if (compName != null && compName != 'undefined')
					{
						Ext.getCmp('compNameCombo').setValue(compName);
					}
					else
					{
						Ext.getCmp('compNameCombo').setValue(compNameArr[0].valueField);
					}

					var noDescMsg = publicJson['screenLabels']['No_desc_msg'];
					var isSelfandTestFollow = publicJson['isSelfandTestFollow'];
					var isSelfFollow = publicJson['isSelfFollow'];
					var isTestFollow = publicJson['isTestFollow'];
					var specsDescArr = publicJson['specsDescArr'];
					var testDescArr = publicJson['testDescArr'];
					var isDescSearch = publicJson['isDescSearch'];

					if (!isSelfandTestFollow && !isSelfFollow && !isTestFollow)
					{
						Ext.getCmp('noDescriptorMsgContainer').show();
						Ext.getCmp('noDescLabelId').update(noDescMsg);
					}
					else if (isSelfandTestFollow)
					{
						Ext.getCmp('twoDescriptorTab').show();
						var isSpecificDescSearch = publicJson['isSpecificDescSearch'];
						if(isSpecificDescSearch)
						{
							Ext.getCmp('twoDescriptorTabSearch').show();
						}else
						{
							Ext.getCmp('twoDescriptorTabSearch').hide();
						}

						if (isSelfFollow)
						{
							Ext.getCmp('specificDescGrid').getStore().removeAll();
							Ext.getCmp('specificDescGrid').getStore().loadRawData(specsDescArr);
						}
						if (isTestFollow)
						{
							Ext.getCmp('testDescGrid').getStore().removeAll();
							Ext.getCmp('testDescGrid').getStore().loadRawData(testDescArr);
						}
					}
					else 
					{
						Ext.getCmp('oneDescriptorTab').show();
						if(isDescSearch)
						{
							Ext.getCmp('oneDescriptorTabSearch').show();
						}else
						{
							Ext.getCmp('oneDescriptorTabSearch').hide();
						}
						if (isSelfFollow)
						{
							Ext.getCmp('tabOne').setTitle(tabMsg1);
							Ext.getCmp('specificOrTestGrid').getStore().removeAll();
							Ext.getCmp('specificOrTestGrid').getStore().loadRawData(specsDescArr);
						}
						else if (isTestFollow)
						{
							Ext.getCmp('tabOne').setTitle(tabMsg2);
							Ext.getCmp('specificOrTestGrid').getStore().removeAll();
							Ext.getCmp('specificOrTestGrid').getStore().loadRawData(testDescArr);
						}
					}
				},
				failure: function()
				{
				}
			});
		}
	},
	populateDefDescriptor: function()
	{
		Ext.getCmp('noDescriptorMsgContainer').hide();
		Ext.getCmp('oneDescriptorTab').hide();
		Ext.getCmp('twoDescriptorTab').hide();
		var compType = Ext.getCmp('compTypeCombo').getValue();
		var compName = Ext.getCmp('compNameCombo').getValue();
		var test;
		var qctr;
		var flag = false;
		var defThreshTests = Ext.getCmp('defaultTestMultiSelect').getValue();
		var isDefaultTestSelected = false;
		var defTest = "";
		for (key in defThreshTests )
		{
			var grpTest = defThreshTests[key];
			if(!Ext.isEmpty(grpTest) && grpTest != null && grpTest != 'undefined')
			{
				isDefaultTestSelected = true;
				defTest = grpTest;
			}
		}
		if (!isDefaultTestSelected)
		{
			Ext.Msg.show({
				title: pageName,
				msg: selectDefaultTestAlert,
				icon: 'iconExclamation',
				buttons: Ext.Msg.OK
			});
			return;
		}

		if(defTest != null && defTest != "")
		{
			flag = true;
			test = defTest;
			qctr = "default";
		}

		var str = "SpecificThreshold/data/EgSpecificThreshJson.jsp?qctr="+qctr+"&server="+encodeURIComponent(compType)+"&compName="+ encodeURIComponent(compName)+"&test="+encodeURIComponent(test)+"&from=defthreshinfo";
		if(flag)
		{
			Ext.Ajax.request({
				url:str,
				method: 'POST',
				timeout: 600000,
				success: function(response)
				{
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);

					var compTypeArr = publicJson['specCompTypeArr'];
					var compNameArr = publicJson['specCompNameArr'];
					var globalTestArr = publicJson['globalTestsArr'];
					var specificTestArr = publicJson['specTestsArr'];
					var defaultTestArr = publicJson['defaultTestsArr'];
					var compType = publicJson['selectedCompType'];
					var compName = publicJson['selectedCompName'];
					var specificTestName = publicJson['selectedSpecsTest'];
					var groupTestName = publicJson['selectedGroupTest'];
					var defaultTestName = publicJson['selectedTest'];
					Ext.getCmp('compTypeCombo').getStore().loadRawData(compTypeArr);
					if (compType != null && compType != 'undefined')
					{
						Ext.getCmp('compTypeCombo').setValue(compType);
					}
					else
					{
						Ext.getCmp('compTypeCombo').setValue(compTypeArr[0].valueField);
					}
					
					Ext.getCmp('compNameCombo').getStore().loadRawData(compNameArr);
					if (compName != null && compName != 'undefined')
					{
						Ext.getCmp('compNameCombo').setValue(compName);
					}
					else
					{
						Ext.getCmp('compNameCombo').setValue(compNameArr[0].valueField);
					}

					var noDescMsg = publicJson['screenLabels']['No_desc_msg'];
					var isSelfandTestFollow = publicJson['isSelfandTestFollow'];
					var isSelfFollow = publicJson['isSelfFollow'];
					var isTestFollow = publicJson['isTestFollow'];
					var isDescSearch = publicJson['isDescSearch'];

					var specsDescArr = publicJson['specsDescArr'];
					var testDescArr = publicJson['testDescArr'];

					if (!isSelfandTestFollow && !isSelfFollow && !isTestFollow)
					{
						Ext.getCmp('noDescriptorMsgContainer').show();
						Ext.getCmp('noDescLabelId').update(noDescMsg);
					}
					else if (isSelfandTestFollow)
					{
						Ext.getCmp('twoDescriptorTab').show();
						var isSpecificDescSearch = publicJson['isSpecificDescSearch'];
						if(isSpecificDescSearch)
						{
							Ext.getCmp('twoDescriptorTabSearch').show();
						}else
						{
							Ext.getCmp('twoDescriptorTabSearch').hide();
						}
						if (isSelfFollow)
						{
							Ext.getCmp('specificDescGrid').getStore().removeAll();
							Ext.getCmp('specificDescGrid').getStore().loadRawData(specsDescArr);
						}
						if (isTestFollow)
						{
							Ext.getCmp('testDescGrid').getStore().removeAll();
							Ext.getCmp('testDescGrid').getStore().loadRawData(testDescArr);
						}
					}
					else 
					{
						Ext.getCmp('oneDescriptorTab').show();
						if(isDescSearch)
						{
							Ext.getCmp('oneDescriptorTabSearch').show();
						}else
						{
							Ext.getCmp('oneDescriptorTabSearch').hide();
						}
						if (isSelfFollow)
						{
							Ext.getCmp('tabOne').setTitle(tabMsg1);
							Ext.getCmp('specificOrTestGrid').getStore().removeAll();
							Ext.getCmp('specificOrTestGrid').getStore().loadRawData(specsDescArr);
						}
						else if (isTestFollow)
						{
							Ext.getCmp('tabOne').setTitle(tabMsg2);
							Ext.getCmp('specificOrTestGrid').getStore().removeAll();
							Ext.getCmp('specificOrTestGrid').getStore().loadRawData(testDescArr);
						}
					}
				},
				failure: function()
				{
				}
			});
		}
	},
	callViewThreshValPage: function(btn)
	{
		var compType = publicJson['hiddenObj']['componentType'];
		var compName = publicJson['hiddenObj']['componentName'];
		comeFrom = 'admin';
		strCompType = compType;
		strCompName = compName;
		strDescName = '';
		isFromViewThreshPage = 'false';

		if(btn == 'specificTestModifyBtn' || btn == 'deleteBtn')
		{
			from = 'specificTest';
			isRefine = 'true';
			var specTest = publicJson['hiddenObj']['testName'];
			strTestName = specTest;
			var homepage = Ext.getCmp('viewPortId');
			myMask = new Ext.LoadMask(homepage, {msg:"Updating..."});
			homepage.removeAll();
			myMask.show();
			homepage.add({ xtype : 'viewthresholds' });
			myMask.hide();

		}
	},
	callDescViewThreshValPage : function(type,name)
	{
		var me = this;

		var compType = publicJson['hiddenObj']['componentType'];
		var compName = publicJson['hiddenObj']['componentName'];
		var comp = compType+":"+compName;

		if(type == 'specificDesc')
		{
			strCompType = compType;
			strCompName = compName;
			strTestName = publicJson['hiddenObj']['testName'];
			strDescName = name;
			comeFrom = 'admin';
			isFromViewThreshPage = "true";
			isRefine = '';
			from = 'specificTest';
			var homepage = Ext.getCmp('viewPortId');
			homepage.removeAll();
			homepage.add({ xtype : 'viewthresholds' });
		}
	},
	callDescThreshValPage : function(type,name)
	{
		var me = this;

		var thisForm = document.specsthreshold;
		var compType = Ext.getCmp('compTypeCombo').getValue();
		var compName = Ext.getCmp('compNameCombo').getValue();
		var comp = compType+":"+compName;
		var defThreshTests = Ext.getCmp('defaultTestMultiSelect').getValue();
		var specThreshTests = Ext.getCmp('specificTestMultiSelect').getValue();
		var grpRuleThreshTests = Ext.getCmp('groupTestMultiSelect').getValue();
		var defTest = '';
		var specTest = '';
		var grpRuleTest = '';
		for (key in defThreshTests )
		{
			var grpTest = defThreshTests[key];
			if(!Ext.isEmpty(grpTest) && grpTest != null && grpTest != 'undefined')
			{
				defTest = grpTest;
			}
		}
		for (key in specThreshTests )
		{
			var grpTest = specThreshTests[key];
			if(!Ext.isEmpty(grpTest) && grpTest != null && grpTest != 'undefined')
			{
				specTest = grpTest;
			}
		}
		
		for (key in grpRuleThreshTests )
		{
			var grpTest = grpRuleThreshTests[key];
			if(!Ext.isEmpty(grpTest) && grpTest != null && grpTest != 'undefined')
			{
				grpRuleTest = grpTest;
			}
		}
		if(type == 'specificDesc')
		{
			strCompType = compType;
			strCompName = compName;
			//strTestName = specTest;
			if(defTest != null && defTest != "")
			{
				strTestName = defTest;
				from = "defaultTest";
			}
			else if(grpRuleTest != null && grpRuleTest != "")
			{
				strTestName = grpRuleTest;
				from = "grpRuleTest";
			}
			else
			{
				from="specificTest";
				strTestName = specTest;
			}

			strDescName = name;
			comeFrom = 'admin';
			isRefine = '';
			from = 'specificTest';
			var homepage = Ext.getCmp('viewPortId');
			homepage.removeAll();
			homepage.add({ xtype : 'viewthresholds' });
		}
		else
		{
			strCompType = compType;
			strCompName = compName;
			if(defTest != null && defTest != "")
			{
				strTestName = defTest;
				from = "defaultTest";
			}
			else if(grpRuleTest != null && grpRuleTest != "")
			{
				strTestName = grpRuleTest;
				from = "grpRuleTest";
			}
			else
			{
				from="specificTest";
				strTestName = specTest;
			}

			strDescName = name;
			comeFrom = 'admin';
			isRefine = '';
			var homepage = Ext.getCmp('viewPortId');
			homepage.removeAll();
			homepage.add({ xtype : 'viewthresholds' });
		}
	},
	handleEditIconClick: function(view, rowIndex, colIndex, column, e)
	{
		this.showEditWindow(view.getRecord(view.findTargetByEvent(e)));
	},
	showEditWindow: function(task)
	{
		var measureName = task.get('Measure');
		var thresholds = task.get('Thresholds');
		var alarmPol = task.get('AlarmPolicy');
		if(measureName.lastIndexOf(' ') != -1)
		{
			measureName = measureName.substring(0,measureName.lastIndexOf(' '));
		}
		var measureActualObj = publicJson.measureDataObj;
		hiddenFieldsVal = this.getHiddenFields(measureActualObj[measureName.trim()]);
		var me = this;
		var homepage = Ext.getCmp('viewPortId');
		homepage.removeAll();
		homepage.add({ xtype : 'configurespecificthresholds' });
	},
	showModifyTool: function(view, record, item, index, e)
	{
		var icons = Ext.DomQuery.select('.x-action-col-icon', item);
		/* Ext.each(icons, function(icon){
			Ext.get(icon).removeCls('x-hidden');
		 }); */
	},
	hideModifyTool: function( view, record, item, index, e, eOpts )
	{
		var icons = Ext.DomQuery.select('.x-action-col-icon', item);
		/* Ext.each(icons, function(icon){
			Ext.get(icon).addCls('x-hidden');
		}); */
	},
	deleteDescriptorSpecificThresholds: function()
	{
		me = this;
		var cnfMsg = '';
		
		var tmpCompType = publicJson['hiddenObj']['componentType'];
		if (tmpCompType != null && !Ext.isEmpty(tmpCompType))
		{
			strCompType = tmpCompType;
		}
		
		tmpCompName = publicJson['hiddenObj']['componentName'];
		if (tmpCompName != null && !Ext.isEmpty(tmpCompName))
		{
			strCompName = tmpCompName;
		}
		tmpTestName = publicJson['hiddenObj']['testName'];
		if (tmpTestName != null && !Ext.isEmpty(tmpTestName))
		{
			strTestName = tmpTestName;
		}
		from = publicJson['hiddenObj']['from'];
		tmpDescName = publicJson['hiddenObj']['descriptorName'];
		if (tmpDescName != null && !Ext.isEmpty(tmpDescName))
		{
			strDescName = tmpDescName;
		}
		if(strDescName != "" && !Ext.isEmpty(strDescName))
		{
			cnfMsg = deleteConfirmMsg;
		}
		else
		{
			cnfMsg = deleteSpecTestConfirmMsg;
		}
		Ext.Msg.show({
			title: pageName,
			msg: cnfMsg,
			icon: 'iconConfirmation',
			buttons: Ext.Msg.YESNO,
			fn: function (response) {
				if (response == "yes")
				{
					var test = strTestName;
					var isDescriptor = strDescName;
					me.updateDescriptorThresholds(test,isDescriptor);
				}
			}
		});
	},
	updateDescriptorThresholds: function(test,descriptor)
	{
		var params = "componentType="+encodeURIComponent(strCompType)+"&componentName="+encodeURIComponent(strCompName)+"&testName="+encodeURIComponent(test)+"&descriptorName="+encodeURIComponent(descriptor)+"&from="+from+"&operation=deleteThresholds";

		Ext.Ajax.request({
			url:'SpecificThreshold/data/EgApplySpecificThresholds.jsp?'+params,
			method:'POST',
			scope:this,
			async: false,
			success:function(response)
			{
				var me = this;
				var homepage = Ext.getCmp('viewPortId');
				if (isFromViewThreshPage == 'true')
				{
					this.callViewThreshValPage('deleteBtn');
				}
				else
				{
					homepage.removeAll();
					homepage.add({ xtype : 'specificthresholds' });
				}
			}
		});
	},
	//updateData: function (type)
	//{
		//var flag = this.applyThresholdsData1(type);
		//if (flag)
		//{
			//Ext.Msg.show({
				//title: pageName,
				//msg: successAlert1,
				//icon: 'iconInformation',
				//buttons: Ext.Msg.OK,
				//fn: function (response) {
					//var homepage = Ext.getCmp('viewPortId');
					//from = 'specificTest';
					//myMask = new Ext.LoadMask(homepage, {msg:"Updating..."});
					//homepage.removeAll();
					//myMask.show();
					//homepage.add({ xtype : 'viewthresholds' });
					//myMask.hide()
				//}
			//});
		//}
	//},
	applyThresholdsData: function(type)
	{
		var flag = true;
		var v_testname = publicJson['hiddenObj']['testName'];
		if (v_testname == "null")
		{
			flag = false;
			return false;
		}

		var v_measure =  publicJson['hiddenObj']['measure'];
		if (v_measure == "null")
		{
			flag = false;
			return false;
		}

		var v_policy = "mix";
		var minThreshold = "-1";
		var maxThreshold = "-1";
		var v_alarmPolicy = Ext.getCmp('alarmPolicyCombo').getValue();
		var lastItem = "HML";

		var abs_MinCritical = "-";
		var abs_MinMajor = "-";
		var abs_MinMinor = "-";
		var abs_MinOpt = Ext.getCmp('minStaticCheck').getValue();
		var isNegativeValuesAllowed = publicJson['isNegativeValuesAllowed'];
		if (!abs_MinOpt)
		{
			abs_MinCritical = Ext.getCmp('absMinCritical').getValue();
			abs_MinMajor =  Ext.getCmp('absMinMajor').getValue();
			abs_MinMinor =  Ext.getCmp('absMinMinor').getValue();

			// Negative value check...
			if (!isNegativeValuesAllowed)
			{
				//Invalid threshold entry check...
				if (!checkValidValue(abs_MinCritical))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMinCriticalErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinCritical != "-") 
				{
					if(!checkNonNegativeFormat(abs_MinCritical))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMinCriticalErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinCritical').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MinMajor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMinMajorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMajor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinMajor != "-")
				{
					if(!checkNonNegativeFormat(abs_MinMajor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMinMajorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinMajor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MinMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMinMinorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMinor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinMinor != "-")
				{
					if(!checkNonNegativeFormat(abs_MinMinor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMinMinorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinMinor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				var ret = checkNegativeValue(abs_MinCritical);
				if (ret)
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg5+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}

				ret = checkNegativeValue(abs_MinMajor);
				if (ret)
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg5+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMajor').focus();
						}
					});
					flag = false;
					return false;
				}

				ret = checkNegativeValue(abs_MinMinor);
				if (ret)
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg5+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMinor').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			else
			{
				//Invalid threshold entry check...
				if (!checkValidValue(abs_MinCritical))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMinCriticalErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinCritical != "-") 
				{
					if(!checkNegativeFormat(abs_MinCritical))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMinCriticalErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinCritical').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MinMajor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMinMajorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMajor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinMajor != "-")
				{
					if(!checkNegativeFormat(abs_MinMajor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMinMajorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinMajor').focus();
							}
						});
						flag = false;
						return false;
					}
				}
				if (!checkValidValue(abs_MinMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMinMinorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMinor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MinMinor != "-")
				{
					if(!checkNegativeFormat(abs_MinMinor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMinMinorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMinMinor').focus();
							}
						});
						flag = false;
						return false;
					}
				}
			}

			//check ascending order...
			if (abs_MinCritical != "-" && abs_MinMajor != "-")
			{
				if (parseFloat(abs_MinCritical) >= parseFloat(abs_MinMajor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg7,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			if (abs_MinMajor != "-" && abs_MinMinor != "-")
			{
				if (parseFloat(abs_MinMajor) >= parseFloat(abs_MinMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg7,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinMajor').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			if (abs_MinCritical != "-" && abs_MinMinor != "-")
			{
				if (parseFloat(abs_MinCritical) >= parseFloat(abs_MinMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg7,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMinCritical').focus();
						}
					});
					flag = false;
					return false;
				}
			}
		}

		var rel_MinCritical = "-";
		var rel_MinMajor = "-";
		var rel_MinMinor = "-";
		var minAutoCheck = Ext.getCmp('minAutoCheck').getValue();
		if (!minAutoCheck)
		{
			var v_amount_A = Ext.getCmp('relMinCriticalText').getValue();
			if (v_amount_A != 0)
			{
				if (v_amount_A == 100)
				{
					rel_MinCritical = "sqc";
				}
				else
				{
					rel_MinCritical = (v_amount_A/100) + "*sqc";
				}
			}

			var v_amount_B = Ext.getCmp('relMinMajorText').getValue();
			if (v_amount_B != 0)
			{
				if (v_amount_B == 100)
				{
					rel_MinMajor = "sqc";
				}
				else
				{
					rel_MinMajor = (v_amount_B/100) + "*sqc";
				}
			}

			var v_amount_C = Ext.getCmp('relMinMinorText').getValue();
			if (v_amount_C != 0)
			{
				if (v_amount_C == 100)
				{
					rel_MinMinor = "sqc";
				}
				else
				{
					rel_MinMinor = (v_amount_C/100) + "*sqc";
				}
			}

			//check ascending order...
			var relCri,relMaj,relMin;
			relCri = rel_MinCritical;
			relMaj = rel_MinMajor;
			relMin = rel_MinMinor;
			relCri = relCri.replace(/(\*sqc)/gi,"");
			relCri = relCri.replace(/sqc/g,"1");
			relMaj = relMaj.replace(/(\*sqc)/gi,"");
			relMaj = relMaj.replace(/sqc/g,"1");
			relMin = relMin.replace(/(\*sqc)/gi,"");
			relMin = relMin.replace(/sqc/g,"1");

			if (relCri != "-" && relMaj != "-")
			{
				if (parseFloat(relCri) >= parseFloat(relMaj))
				{
					Ext.Msg.show({ 
						title: pageName,
						msg: errMsg8,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
			if (relMaj != "-" && relMin != "-")
			{
				if (parseFloat(relMaj) >= parseFloat(relMin))
				{
					Ext.Msg.show({ 
						title: pageName,
						msg: errMsg8,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
			if (relCri != "-" && relMin != "-")
			{
				if (parseFloat(relCri) >= parseFloat(relMin))
				{
					Ext.Msg.show({ 
						title: pageName,
						msg: errMsg8,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
		}

		if(abs_MinCritical.indexOf(".") != -1 )
		{
			var abs_MinCriticalDecimal = abs_MinCritical.substring(abs_MinCritical.indexOf(".")+1);
			if (abs_MinCriticalDecimal == "0000" || 
				abs_MinCriticalDecimal == "000" || 
				abs_MinCriticalDecimal == "00" || 
				abs_MinCriticalDecimal == "0" )
			{
				abs_MinCritical = abs_MinCritical.substring(0,abs_MinCritical.indexOf("."));
			}
			else if(abs_MinCriticalDecimal.length > 1)
			{
				if ((abs_MinCriticalDecimal.charAt(3) == "0" && abs_MinCriticalDecimal.charAt(2) == "0") || 
					(abs_MinCriticalDecimal.charAt(3) == "0"))
				{
					abs_MinCritical = abs_MinCritical.substring(0,abs_MinCritical.lastIndexOf("0"));
				}
			}
		}
		if(abs_MinMajor.indexOf(".") != -1 )
		{
			var abs_MinMajorDecimal = abs_MinMajor.substring(abs_MinMajor.indexOf(".")+1);
			if (abs_MinMajorDecimal == "0000" || 
				abs_MinMajorDecimal == "000" || 
				abs_MinMajorDecimal == "00" || 
				abs_MinMajorDecimal == "0")
			{
				abs_MinMajor = abs_MinMajor.substring(0,abs_MinMajor.indexOf("."));
			}
			else if(abs_MinMajorDecimal.length > 1)
			{
				if ((abs_MinMajorDecimal.charAt(3) == "0" && abs_MinMajorDecimal.charAt(2) == "0") ||
					(abs_MinMajorDecimal.charAt(3) == "0"))
				{
					abs_MinMajor = abs_MinMajor.substring(0,abs_MinMajor.lastIndexOf("0"));
				}
			}
		}
		if(abs_MinMinor.indexOf(".") != -1 )
		{
			var abs_MinMinorDecimal = abs_MinMinor.substring(abs_MinMinor.indexOf(".")+1);
			if (abs_MinMinorDecimal == "0000" || 
				abs_MinMinorDecimal == "000" || 
				abs_MinMinorDecimal == "00" || 
				abs_MinMinorDecimal == "0")
			{
				abs_MinMinor = abs_MinMinor.substring(0,abs_MinMinor.indexOf("."));
			}
			else if(abs_MinMinorDecimal.length > 1)
			{
				if ((abs_MinMinorDecimal.charAt(3) == "0" && abs_MinMinorDecimal.charAt(2) == "0") ||
					(abs_MinMinorDecimal.charAt(3) == "0"))
				{
					abs_MinMinor = abs_MinMinor.substring(0,abs_MinMinor.lastIndexOf("0"));
				}
			}
		}

		var minCritical = "-";
		if (abs_MinCritical != "-" && rel_MinCritical != "-")
		{
			if(abs_MinCritical > -1 || abs_MinCritical < 0)
			{
				if(abs_MinCritical.indexOf(".") == 0)
				{
					abs_MinCritical = "0"+abs_MinCritical;
				}
				abs_MinCritical = parseFloat(abs_MinCritical);
				minCritical = abs_MinCritical.toString() + "&" + rel_MinCritical;
			}
			else
			{
				minCritical = rel_MinCritical;
			}
		}
		else if (abs_MinCritical != "-" && rel_MinCritical == "-")
		{
			if(abs_MinCritical > -1 || abs_MinCritical < 0)
			{
				if(abs_MinCritical.indexOf(".") == 0)
				{
					abs_MinCritical = "0"+abs_MinCritical;
				}
				abs_MinCritical = parseFloat(abs_MinCritical);
				minCritical = abs_MinCritical.toString();
			}
			else
			{
				minCritical = "-";
			}
		}
		else if (abs_MinCritical == "-" && rel_MinCritical != "-")
		{
			minCritical = rel_MinCritical;
		}

		var minMajor = "-";
		if (abs_MinMajor != "-" && rel_MinMajor != "-")
		{
			if(abs_MinMajor > -1 || abs_MinMajor < 0)
			{
				if(abs_MinMajor.indexOf(".") == 0)
				{
					abs_MinMajor = "0"+abs_MinMajor;
				}
				abs_MinMajor = parseFloat(abs_MinMajor);
				minMajor = abs_MinMajor.toString() + "&" + rel_MinMajor;
			}
			else
			{
				minMajor = rel_MinMajor;
			}
		}
		else if (abs_MinMajor != "-" && rel_MinMajor == "-")
		{
			if(abs_MinMajor > -1 || abs_MinMajor < 0)
			{
				if(abs_MinMajor.indexOf(".") == 0)
				{
					abs_MinMajor = "0"+abs_MinMajor;
				}
				abs_MinMajor = parseFloat(abs_MinMajor);
				minMajor = abs_MinMajor.toString();
			}
			else
			{
				minMajor = "-";
			}
		}
		else if (abs_MinMajor == "-" && rel_MinMajor != "-")
		{
			minMajor = rel_MinMajor;
		}

		var minMinor = "-";
		if (abs_MinMinor != "-" && rel_MinMinor != "-")
		{
			if(abs_MinMinor > -1 || abs_MinMinor < 0)
			{
				if(abs_MinMinor.indexOf(".") == 0)
				{
					abs_MinMinor = "0"+abs_MinMinor;
				}
				abs_MinMinor = parseFloat(abs_MinMinor);
				minMinor = abs_MinMinor.toString() + "&" + rel_MinMinor;
			}
			else
			{
				minMinor = rel_MinMinor;
			}
		}
		else if (abs_MinMinor != "-" && rel_MinMinor == "-")
		{
			if(abs_MinMinor > -1 || abs_MinMinor < 0)
			{
				if(abs_MinMinor.indexOf(".") == 0)
				{
					abs_MinMinor = "0"+abs_MinMinor;
				}
				abs_MinMinor = parseFloat(abs_MinMinor);
				minMinor = abs_MinMinor.toString();
			}
			else
			{
				minMinor = "-";
			}
		}
		else if (abs_MinMinor == "-" && rel_MinMinor != "-")
		{
			minMinor = rel_MinMinor;
		}

		if (minCritical != "-" || minMajor != "-" || minMinor != "-")
		{
			minThreshold = minCritical + "/" + minMajor + "/" + minMinor
		}

		var abs_MaxCritical = "-";
		var abs_MaxMajor = "-";
		var abs_MaxMinor = "-";
		var abs_MaxOpt = Ext.getCmp('maxStaticCheck').getValue();
		if (!abs_MaxOpt)
		{
			abs_MaxCritical = Ext.getCmp('absMaxCritical').getValue();
			abs_MaxMajor =  Ext.getCmp('absMaxMajor').getValue();
			abs_MaxMinor =  Ext.getCmp('absMaxMinor').getValue();

			// Negative value check...
			if (!isNegativeValuesAllowed)
			{
				//Invalid threshold entry check...
				if (!checkValidValue(abs_MaxCritical))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMaxCriticalErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxCritical != "-")
				{
					if(!checkNonNegativeFormat(abs_MaxCritical))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMaxCriticalErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxCritical').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MaxMajor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMaxMajorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMajor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxMajor != "-")
				{
					if(!checkNonNegativeFormat(abs_MaxMajor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMaxMajorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxMajor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MaxMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMaxMinorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMinor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxMinor != "-")
				{
					if(!checkNonNegativeFormat(abs_MaxMinor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMaxMinorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxMinor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				var ret = checkNegativeValue(abs_MaxCritical);
				if (ret)
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg11+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}

				ret = checkNegativeValue(abs_MaxMajor);
				if (ret)
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg11+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMajor').focus();
						}
					});
					flag = false;
					return false;
				}

				ret = checkNegativeValue(abs_MaxMinor);
				if (ret)
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg11+" \'"+v_measure+"\' "+errMsg6,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMinor').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			else
			{
				if (!checkValidValue(abs_MaxCritical))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMaxCriticalErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxCritical != "-")
				{
					if(!checkNegativeFormat(abs_MaxCritical))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMaxCriticalErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxCritical').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MaxMajor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMaxMajorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMajor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxMajor != "-")
				{
					if(!checkNegativeFormat(abs_MaxMajor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMaxMajorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxMajor').focus();
							}
						});
						flag = false;
						return false;
					}
				}

				if (!checkValidValue(abs_MaxMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: staticMaxMinorErrMsg1,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMinor').focus();
						}
					});
					flag = false;
					return false;
				}
				else if(abs_MaxMinor != "-")
				{
					if(!checkNegativeFormat(abs_MaxMinor))
					{
						Ext.Msg.show({
							title: pageName,
							msg: staticMaxMinorErrMsg1+".<br />"+errMsg1+" : <br />"+"1) "+errMsg2+".<br />"+"2) "+errMsg3+".<br />"+"3) "+errMsg4+".",
							buttons: Ext.Msg.OK,
							icon: 'iconExclamation',
							fn: function() {
								Ext.getCmp('absMaxMinor').focus();
							}
						});
						flag = false;
						return false;
					}
				}
			}
			//check descending order...
			if (abs_MaxCritical != "-" && abs_MaxMajor != "-")
			{
				if (parseFloat(abs_MaxCritical) <= parseFloat(abs_MaxMajor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg9,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			if (abs_MaxMajor != "-" && abs_MaxMinor != "-")
			{
				if (parseFloat(abs_MaxMajor) <= parseFloat(abs_MaxMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg9,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxMajor').focus();
						}
					});
					flag = false;
					return false;
				}
			}
			if (abs_MaxCritical != "-" && abs_MaxMinor != "-")
			{
				if (parseFloat(abs_MaxCritical) <= parseFloat(abs_MaxMinor))
				{
					Ext.Msg.show({
						title: pageName,
						msg: errMsg9,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn: function() {
							Ext.getCmp('absMaxCritical').focus();
						}
					});
					flag = false;
					return false;
				}
			}
		}

		var rel_MaxCritical = "-";
		var rel_MaxMajor = "-";
		var rel_MaxMinor = "-";
		var maxAutoCheck = Ext.getCmp('maxAutoCheck').getValue();
		if (!maxAutoCheck)
		{
			var v_amount_D = Ext.getCmp('relMaxCriticalText').getValue();
			if (v_amount_D != 0)
			{
				if (v_amount_D == 100)
				{
					rel_MaxCritical = "sqc";
				}
				else
				{
					rel_MaxCritical = (v_amount_D/100) + "*sqc";
				}
			}

			var v_amount_E =  Ext.getCmp('relMaxMajorText').getValue();
			if (v_amount_E != 0)
			{
				if (v_amount_E == 100)
				{
					rel_MaxMajor = "sqc";
				}
				else
				{
					rel_MaxMajor = (v_amount_E/100) + "*sqc";
				}
			}

			var v_amount_F = Ext.getCmp('relMaxMinorText').getValue();
			if (v_amount_F != 0)
			{
				if (v_amount_F == 100)
				{
					rel_MaxMinor = "sqc";
				}
				else
				{
					rel_MaxMinor = (v_amount_F/100) + "*sqc";
				}
			}

			//check descending order...
			var relCri,relMaj,relMin;
			relCri = rel_MaxCritical;
			relMaj = rel_MaxMajor;
			relMin = rel_MaxMinor;
			relCri = relCri.replace(/(\*sqc)/gi,"");
			relCri = relCri.replace(/sqc/g,"1");
			relMaj = relMaj.replace(/(\*sqc)/gi,"");
			relMaj = relMaj.replace(/sqc/g,"1");
			relMin = relMin.replace(/(\*sqc)/gi,"");
			relMin = relMin.replace(/sqc/g,"1");

			if (relCri != "-" && relMaj != "-")
			{
				if (parseFloat(relCri) <= parseFloat(relMaj))
				{
					Ext.Msg.show({ 
						title: pageName,
						msg: errMsg10,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
			if (relMaj != "-" && relMin != "-")
			{
				if (parseFloat(relMaj) <= parseFloat(relMin))
				{
					Ext.Msg.show({ 
						title: pageName,
						msg: errMsg10,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
			if (relCri != "-" && relMin != "-")
			{
				if (parseFloat(relCri) <= parseFloat(relMin))
				{
					Ext.Msg.show({ 
						title: pageName,
						msg: errMsg10,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation'
					});
					flag = false;
					return false;
				}
			}
		}

		if(abs_MaxCritical.indexOf(".") != -1 )
		{
			var abs_MaxCriticalDecimal = abs_MaxCritical.substring(abs_MaxCritical.indexOf(".")+1);
			if (abs_MaxCriticalDecimal == "0000" ||
				abs_MaxCriticalDecimal == "000" ||
				abs_MaxCriticalDecimal == "00" ||
				abs_MaxCriticalDecimal == "0")
			{
				abs_MaxCritical = abs_MaxCritical.substring(0,abs_MaxCritical.indexOf("."));
			}
			else if(abs_MaxCriticalDecimal.length > 1)
			{
				if ((abs_MaxCriticalDecimal.charAt(3) == "0" && abs_MaxCriticalDecimal.charAt(2) == "0") ||
					(abs_MaxCriticalDecimal.charAt(3) == "0"))
				{
					abs_MaxCritical = abs_MaxCritical.substring(0,abs_MaxCritical.lastIndexOf("0"));
				}
			}
		}
		if(abs_MaxMajor.indexOf(".") != -1 )
		{
			var abs_MaxMajorDecimal = abs_MaxMajor.substring(abs_MaxMajor.indexOf(".")+1);
			if (abs_MaxMajorDecimal == "0000" || 
				abs_MaxMajorDecimal == "000" || 
				abs_MaxMajorDecimal == "00" ||
				abs_MaxMajorDecimal == "0")
			{
				abs_MaxMajor = abs_MaxMajor.substring(0,abs_MaxMajor.indexOf("."));
			}
			else if(abs_MaxMajorDecimal.length > 1)
			{
				if ((abs_MaxMajorDecimal.charAt(3) == "0" && abs_MaxMajorDecimal.charAt(2) == "0") ||
					(abs_MaxMajorDecimal.charAt(3) == "0"))
				{
					abs_MaxMajor = abs_MaxMajor.substring(0,abs_MaxMajor.lastIndexOf("0"));
				}
			}
		}
		if(abs_MaxMinor.indexOf(".") != -1 )
		{
			var abs_MaxMinorDecimal = abs_MaxMinor.substring(abs_MaxMinor.indexOf(".")+1);
			if (abs_MaxMinorDecimal == "0000" || 
				abs_MaxMinorDecimal == "000" || 
				abs_MaxMinorDecimal == "00" || 
				abs_MaxMinorDecimal == "0")
			{
				abs_MaxMinor = abs_MaxMinor.substring(0,abs_MaxMinor.indexOf("."));
			}
			else if(abs_MaxMinorDecimal.length > 1)
			{
				if ((abs_MaxMinorDecimal.charAt(3) == "0" && abs_MaxMinorDecimal.charAt(2) == "0") ||
					(abs_MaxMinorDecimal.charAt(3) == "0"))
				{
					abs_MaxMinor = abs_MaxMinor.substring(0,abs_MaxMinor.lastIndexOf("0"));
				}
			}
		}

		var maxCritical = "-";
		if (abs_MaxCritical != "-" && rel_MaxCritical != "-")
		{
			if(abs_MaxCritical > -1 || abs_MaxCritical < 0)
			{
				if(abs_MaxCritical.indexOf(".") == 0)
				{
					abs_MaxCritical = "0"+abs_MaxCritical;
				}
				abs_MaxCritical = parseFloat(abs_MaxCritical);
				maxCritical = abs_MaxCritical.toString() + "&" + rel_MaxCritical;
			}
			else
			{
				maxCritical = rel_MaxCritical;
			}
		}
		else if (abs_MaxCritical != "-" && rel_MaxCritical == "-")
		{
			if(abs_MaxCritical > -1 || abs_MaxCritical < 0)
			{
				if(abs_MaxCritical.indexOf(".") == 0)
				{
					abs_MaxCritical = "0"+abs_MaxCritical;
				}
				abs_MaxCritical = parseFloat(abs_MaxCritical);
				maxCritical = abs_MaxCritical.toString();
			}
			else
			{
				maxCritical = "-";
			}
		}
		else if (abs_MaxCritical == "-" && rel_MaxCritical != "-")
		{
			maxCritical = rel_MaxCritical;
		}

		var maxMajor = "-";
		if (abs_MaxMajor != "-" && rel_MaxMajor != "-")
		{
			if(abs_MaxMajor > -1 || abs_MaxMajor < 0)
			{
				if(abs_MaxMajor.indexOf(".") == 0)
				{
					abs_MaxMajor = "0"+abs_MaxMajor;
				}
				abs_MaxMajor = parseFloat(abs_MaxMajor);
				maxMajor = abs_MaxMajor.toString() + "&" + rel_MaxMajor;
			}
			else
			{
				maxMajor = rel_MaxMajor;
			}
		}
		else if (abs_MaxMajor != "-" && rel_MaxMajor == "-")
		{
			if(abs_MaxMajor > -1 || + abs_MaxMajor < 0)
			{
				if(abs_MaxMajor.indexOf(".") == 0)
				{
					abs_MaxMajor = "0"+abs_MaxMajor;
				}
				abs_MaxMajor = parseFloat(abs_MaxMajor);
				maxMajor = abs_MaxMajor.toString();
			}
			else
			{
				maxMajor = "-";
			}
		}
		else if (abs_MaxMajor == "-" && rel_MaxMajor != "-")
		{
			maxMajor = rel_MaxMajor;
		}

		var maxMinor = "-";
		if (abs_MaxMinor != "-" && rel_MaxMinor != "-")
		{
			if(abs_MaxMinor > -1 || abs_MaxMinor < 0)
			{
				if(abs_MaxMinor.indexOf(".") == 0)
				{
					abs_MaxMinor = "0"+abs_MaxMinor;
				}
				abs_MaxMinor = parseFloat(abs_MaxMinor);
				maxMinor = abs_MaxMinor.toString() + "&" + rel_MaxMinor;
			}
			else
			{
				maxMinor = rel_MaxMinor;
			}
		}
		else if (abs_MaxMinor != "-" && rel_MaxMinor == "-")
		{
			if(abs_MaxMinor > -1  || abs_MaxMinor < 0)
			{
				if(abs_MaxMinor.indexOf(".") == 0)
				{
					abs_MaxMinor = "0"+abs_MaxMinor;
				}
				abs_MaxMinor = parseFloat(abs_MaxMinor);
				maxMinor = abs_MaxMinor.toString();
			}
			else
			{
				maxMinor = "-";
			}
		}
		else if (abs_MaxMinor == "-" && rel_MaxMinor != "-")
		{
			maxMinor = rel_MaxMinor;
		}

		if (maxCritical != "-" || maxMajor != "-" || maxMinor != "-")
		{
			maxThreshold = maxCritical + "/" + maxMajor + "/" + maxMinor
		}

		if (flag)
		{
			var myHomeMask = new Ext.LoadMask(Ext.getBody(), {msg:"Updating..."});
			myHomeMask.show();
			var v_threshold = v_measure + ":" + v_policy + ":" + minThreshold + ":" + maxThreshold + ":" + v_alarmPolicy + ":" + lastItem;
			//this.updateThresholds(v_testname,v_threshold);
			strTestName = v_testname;
			var params = '';
			var urlVal = '';
			var compType = publicJson['hiddenObj']['componentType'];
			var compName = publicJson['hiddenObj']['componentName'];
			var descName = publicJson['hiddenObj']['descriptorName'];
			var fromVal = publicJson['hiddenObj']['from'];
			var tmpCompType = publicJson['hiddenObj']['componentType'];
			if (tmpCompType != null && !Ext.isEmpty(tmpCompType))
			{
				strCompType = tmpCompType;
			}
			
			tmpCompName = publicJson['hiddenObj']['componentName'];
			if (tmpCompName != null && !Ext.isEmpty(tmpCompName))
			{
				strCompName = tmpCompName;
			}
			tmpTestName = publicJson['hiddenObj']['testName'];
			if (tmpTestName != null && !Ext.isEmpty(tmpTestName))
			{
				strTestName = tmpTestName;
			}
			from = publicJson['hiddenObj']['from'];
			tmpDescName = publicJson['hiddenObj']['descriptorName'];
			if (tmpDescName != null && !Ext.isEmpty(tmpDescName))
			{
				strDescName = tmpDescName;
			}
			tmpisRefine = publicJson['hiddenObj']['isRefine'];
			if (tmpisRefine != null && !Ext.isEmpty(tmpisRefine))
			{
				isRefine = tmpisRefine;
			}
			else
			{
				isRefine = 'false';
			}

			params = "componentType="+encodeURIComponent(strCompType)+"&componentName="+encodeURIComponent(strCompName)+"&testName="+encodeURIComponent(v_testname)+"&descriptorName="+encodeURIComponent(strDescName)+"&from="+fromVal+"&threshold="+escape(v_threshold)+"&operation=updateThresholds";

			urlVal = 'SpecificThreshold/data/EgApplySpecificThresholds.jsp?'+params;

			Ext.Ajax.request({
				url:urlVal,
				method:'POST',
				timeout: 600000000,
				//async:false,
				scope:this,
				success:function(response)
				{
					var jsonText = response.responseText;
					//publicJson = Ext.decode(jsonText);
					if (response.status == 200 && !Ext.isEmpty(jsonText))
					{
						from = 'specificTest';
						myHomeMask.hide();
						Ext.Msg.show({
							title: pageName,
							msg: successAlert1,
							icon: 'iconInformation',
							buttons: Ext.Msg.OK,
							fn: function (response) {
								var homepage = Ext.getCmp('viewPortId');
								myMask = new Ext.LoadMask(homepage, {msg:"Updating..."});
								homepage.removeAll();
								myMask.show();
								homepage.add({ xtype : 'viewthresholds' });
								myMask.hide();
							}
						});
					}
				},
				failure: function()
				{
					myHomeMask.hide();
					Ext.Msg.show({
						title: pageName,
						msg: 'Updating problem in server side...',
						icon: 'iconExclamation',
						buttons: Ext.Msg.OK
					});
				}
			});
		}
	},
	//updateThresholds: function (v_test,v_threshValue)
	//{
		//strTestName = v_test;
		//var params = '';
		//var urlVal = '';
		//var compType = publicJson['hiddenObj']['componentType'];
		//var compName = publicJson['hiddenObj']['componentName'];
		//var descName = publicJson['hiddenObj']['descriptorName'];
		//var from = publicJson['hiddenObj']['from'];

		//var tmpCompType = publicJson['hiddenObj']['componentType'];
		//if (tmpCompType != null && !Ext.isEmpty(tmpCompType))
		//{
			//strCompType = tmpCompType;
		//}
		
		//tmpCompName = publicJson['hiddenObj']['componentName'];
		//if (tmpCompName != null && !Ext.isEmpty(tmpCompName))
		//{
			//strCompName = tmpCompName;
		//}
		//tmpTestName = publicJson['hiddenObj']['testName'];
		//if (tmpTestName != null && !Ext.isEmpty(tmpTestName))
		//{
			//strTestName = tmpTestName;
		//}
		//from = publicJson['hiddenObj']['from'];
		//tmpDescName = publicJson['hiddenObj']['descriptorName'];
		//if (tmpDescName != null && !Ext.isEmpty(tmpDescName))
		//{
			//strDescName = tmpDescName;
		//}
		//tmpisRefine = publicJson['hiddenObj']['isRefine'];
		//if (tmpisRefine != null && !Ext.isEmpty(tmpisRefine))
		//{
			//isRefine = tmpisRefine;
		//}
		//else
		//{
			//isRefine = 'false';
		//}

		//params = "componentType="+encodeURI(strCompType)+"&componentName="+encodeURI(strCompName)+"&testName="+encodeURIComponent(v_test)+"&descriptorName="+encodeURIComponent(strDescName)+"&from="+from+"&threshold="+escape(v_threshValue)+"&operation=updateThresholds";

		//urlVal = 'SpecificThreshold/data/EgApplySpecificThresholds.jsp?'+params;

		//Ext.Ajax.request({
			//url:urlVal,
			//method:'POST',
			//timeout: 60000,
			//async:false,
			//scope:this,
			//success:function(response)
			//{
				//var jsonText = response.responseText;
				////publicJson = Ext.decode(jsonText);
				//if (response.status == 200 && !Ext.isEmpty(jsonText))
				//{
					//return true;
				//}
			//}
		//});
	//},
	alarmPolicyChange: function()
	{
		var alarmPolicy = Ext.getCmp('alarmPolicyCombo').getValue();
		var tmpDescription = publicJson['alarmPolicyDescriptionObj'][alarmPolicy]
		//Ext.getCmp('alarmDispField').el.update(tmpDescription);
		Ext.getCmp('alarmDispField').setValue(tmpDescription);
	},
	maxStaticFieldChange: function(field){
        var maxStaticCheck = Ext.getCmp('maxStaticCheck').getValue();
            copyField = Ext.getCmp(field.id);

        if (maxStaticCheck) {
            copyField.reset();
        } else {
            copyField.clearInvalid();
        }
    },
	maxAutoFieldChange: function(field){
        var maxAutoCheck = Ext.getCmp('maxAutoCheck').getValue();
            copyField = Ext.getCmp(field.id);

        if (maxAutoCheck) {
            copyField.reset();
        } else {
            copyField.clearInvalid();
        }
    },
	minStaticFieldChange: function(field){
        var minStaticCheck = Ext.getCmp('minStaticCheck').getValue();
            copyField = Ext.getCmp(field.id);

        if (minStaticCheck) {
            copyField.reset();
        } else {
            copyField.clearInvalid();
        }
    },
	minAutoFieldChange: function(field){
        var minAutoCheck = Ext.getCmp('minAutoCheck').getValue();
            copyField = Ext.getCmp(field.id);

        if (minAutoCheck) {
            copyField.reset();
        } else {
            copyField.clearInvalid();
        }
    },
	maxStaticCheckChange: function(box, checked)
	{
		//max static block specific description for BusinessTransTest,KBusinessTransTest
		if (publicJson.isToolTip && !checked)
		{
			Ext.getCmp('absMaxCritical').setFieldLabel('Critical <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
			Ext.getCmp('absMaxMajor').setFieldLabel('Major <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
		}
		else
		{
			Ext.getCmp('absMaxCritical').setFieldLabel(criticalText);
			Ext.getCmp('absMaxMajor').setFieldLabel(majorText);
		}

        var fieldset = box.ownerCt;
        Ext.Array.forEach(fieldset.query('textfield'), this.maxStaticFieldChange, this);
        Ext.Array.forEach(fieldset.query('textfield'), function(field) {
            field.setDisabled(checked);
            if (!Ext.isIE6) {
                field.el.animate({opacity: checked ? 0.3 : 1});
            }
        });

    },
	maxAutoCheckChange: function(box, checked)
	{
		//max static block specific description for BusinessTransTest,KBusinessTransTest
		if (publicJson.isToolTip && !checked)
		{
			Ext.getCmp('relMaxCritical').setFieldLabel('Critical (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
			Ext.getCmp('relMaxMajor').setFieldLabel('Major (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
		}
		else
		{
			Ext.getCmp('relMaxCritical').setFieldLabel(autoCriText);
			Ext.getCmp('relMaxMajor').setFieldLabel(autoMajorText);
		}

        var fieldset = box.ownerCt;
        Ext.Array.forEach(fieldset.query('slider'), this.maxAutoFieldChange, this);
        Ext.Array.forEach(fieldset.query('slider'), function(field) {
            field.setDisabled(checked);
            if (!Ext.isIE6) {
                field.el.animate({opacity: checked ? 0.3 : 1});
            }
        });
        Ext.Array.forEach(fieldset.query('displayfield'), this.minAutoFieldChange, this);
        Ext.Array.forEach(fieldset.query('displayfield'), function(field) {
			if (field.id == 'maxThreshDisplayField')
			{
			}
			else
			{

				field.setDisabled(checked);
				if (!Ext.isIE6) {
					field.el.animate({opacity: checked ? 0.3 : 1});
				}
			}
        });

		//Ext.getCmp('minThreshDisplayField').el.animate({opacity: 1});
    },
	minStaticCheckChange: function(box, checked)
	{
		//min static block specific description for BusinessTransTest,KBusinessTransTest
		if (publicJson.isToolTip && !checked)
		{
			Ext.getCmp('absMinCritical').setFieldLabel('Critical <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
			Ext.getCmp('absMinMajor').setFieldLabel('Major <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
		}
		else
		{
			Ext.getCmp('absMinCritical').setFieldLabel(criticalText);
			Ext.getCmp('absMinMajor').setFieldLabel(majorText);
		}

        var fieldset = box.ownerCt;
        Ext.Array.forEach(fieldset.query('textfield'), this.minStaticFieldChange, this);
        Ext.Array.forEach(fieldset.query('textfield'), function(field) {
            field.setDisabled(checked);
            if (!Ext.isIE6) {
                field.el.animate({opacity: checked ? 0.3 : 1});
            }
       });
	},
	minAutoCheckChange: function(box, checked)
	{
		//min auto block specific description for BusinessTransTest,KBusinessTransTest
		if (publicJson.isToolTip && !checked)
		{
			Ext.getCmp('relMinCritical').setFieldLabel('Critical (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
			Ext.getCmp('relMinMajor').setFieldLabel('Major (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
		}
		else
		{
			Ext.getCmp('relMinCritical').setFieldLabel(autoCriText);
			Ext.getCmp('relMinMajor').setFieldLabel(autoMajorText);
		}

        var fieldset = box.ownerCt;
        Ext.Array.forEach(fieldset.query('slider'), this.minAutoFieldChange, this);
        Ext.Array.forEach(fieldset.query('slider'), function(field) {
            field.setDisabled(checked);
            if (!Ext.isIE6) {
                field.el.animate({opacity: checked ? 0.3 : 1});
            }
        });
        Ext.Array.forEach(fieldset.query('displayfield'), this.minAutoFieldChange, this);
        Ext.Array.forEach(fieldset.query('displayfield'), function(field) {
			if (field.id == 'minThreshDisplayField')
			{
			}
			else
			{
				field.setDisabled(checked);
				if (!Ext.isIE6) {
					field.el.animate({opacity: checked ? 0.3 : 1});
				}
			}
        });
		//Ext.getCmp('minThreshDisplayField').el.animate({opacity: 1});
    },
	getHiddenFieldsForApplytoOtherComponent : function()
	{
		var hiddenFields = publicJson['hiddenObj'];
		var hiddenQstr = '';
		for (key in hiddenFields)
		{
			hiddenQstr += key+'='+encodeURIComponent(hiddenFields[key])+"&";
		}
		return hiddenQstr;
	},
	getHiddenFields : function(measureActualVal)
	{
		var hiddenFields = publicJson['hiddenDataObj'][measureActualVal.trim()];
		var hiddenQstr = '';
		for (key in hiddenFields)
		{
			hiddenQstr += key+'='+encodeURIComponent(hiddenFields[key])+"&";
		}
		return hiddenQstr;
	},
	configureMainRender: function()
	{
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myMask.show();
		var urlVal = 'SpecificThreshold/data/EgConfigureSpecificThresholdsJson.jsp?'+hiddenFieldsVal;
		Ext.Ajax.request({
			url:urlVal,
			method:'POST',
			scope:this,
			success:function(response)
			{
				myMask.hide();
				var jsonText = response.responseText;
				publicJson = Ext.decode(jsonText);
				var testDescription = publicJson['screenLabels']['disp_title'];
				var descComp = Ext.getCmp('testDescriptionId');
				var alarmPolicyCombo = publicJson['alarmPolicyArr'];
				var minThreshObj = publicJson['minThreshObj'];
				var maxThreshObj = publicJson['maxThreshObj'];
				var selectAlarm = publicJson['selectedAlarmType'];
				var selectedAlarmDescription = publicJson['selectedAlarmDescription'];
				var isNegativeValuesAllowed = publicJson['isNegativeValuesAllowed'];
				var displayCompType = publicJson['displayCompType'];
				var displayCompName = publicJson['displayCompName'];
				descComp.update('<left>'+testDescription+'</left>');
				Ext.getCmp('displayCompTypeField').setValue(displayCompType);
				Ext.getCmp('displayCompNameField').setValue(displayCompName);

				var toolTipMsg = publicJson.isToolTip;

				var minStaticOption = minThreshObj.minStaticOption;
				var minStaticBlock = minThreshObj.minStaticBlock;
				if(minStaticOption != null && !Ext.isEmpty(minStaticOption) && minStaticOption == 'selected')
				{
					//min static block specific description for BusinessTransTest,KBusinessTransTest
					if (toolTipMsg)
					{
						Ext.getCmp('absMinCritical').setFieldLabel('Critical <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
						Ext.getCmp('absMinMajor').setFieldLabel('Major <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
					}
					else
					{
						Ext.getCmp('absMinCritical').setFieldLabel(criticalText);
						Ext.getCmp('absMinMajor').setFieldLabel(majorText);
					}

					var absMinCritical = minThreshObj.absMinCritical;
					var absMinMajor = minThreshObj.absMinMajor;
					var absMinMinor = minThreshObj.absMinMinor;
					Ext.getCmp('minStaticCheck').setValue(false);
					Ext.getCmp('absMinCritical').setValue(absMinCritical);
					Ext.getCmp('absMinMajor').setValue(absMinMajor);
					Ext.getCmp('absMinMinor').setValue(absMinMinor);
					
				}

				if (!isNegativeValuesAllowed)
				{
					var minAutomaticOption = minThreshObj.minAutomaticOption;
					var minAutomaticBlock = minThreshObj.minAutomaticBlock;
					if (minAutomaticOption != null && !Ext.isEmpty(minAutomaticOption) && minAutomaticOption == 'selected')
					{
						var relMinCritical = minThreshObj.relMinCritical;
						var relMinMajor = minThreshObj.relMinMajor;
						var relMinMinor = minThreshObj.relMinMinor;
						Ext.getCmp('minAutoCheck').show();
						Ext.getCmp('minAutoFieldContainer').show();
						Ext.getCmp('minAutoCheck').setValue(false);
						Ext.getCmp('relMinCritical').setValue(relMinCritical);
						Ext.getCmp('relMinCriticalText').setValue(relMinCritical);
						Ext.getCmp('relMinMajor').setValue(relMinMajor);
						Ext.getCmp('relMinMajorText').setValue(relMinMajor);
						Ext.getCmp('relMinMinor').setValue(relMinMinor);
						Ext.getCmp('relMinMinorText').setValue(relMinMinor);

						if (toolTipMsg)
						{
							Ext.getCmp('relMinCritical').setFieldLabel('Critical (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
							Ext.getCmp('relMinMajor').setFieldLabel('Major (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
						}
						else
						{
							Ext.getCmp('relMinCritical').setFieldLabel(autoCriText);
							Ext.getCmp('relMinMajor').setFieldLabel(autoMajorText);
						}
					}
				}

				var maxStaticOption = maxThreshObj.maxStaticOption;
				var maxStaticBlock = maxThreshObj.maxStaticBlock;
				if (maxStaticOption != null && !Ext.isEmpty(maxStaticOption) && maxStaticOption == 'selected')
				{
					//max static block specific description for BusinessTransTest,KBusinessTransTest
					if (toolTipMsg)
					{
						Ext.getCmp('absMaxCritical').setFieldLabel('Critical <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
						Ext.getCmp('absMaxMajor').setFieldLabel('Major <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
					}
					else
					{
						Ext.getCmp('absMaxCritical').setFieldLabel(criticalText);
						Ext.getCmp('absMaxMajor').setFieldLabel(majorText);
					}

					var absMaxCritical = maxThreshObj.absMaxCritical;
					var absMaxMajor = maxThreshObj.absMaxMajor;
					var absMaxMinor = maxThreshObj.absMaxMinor;
					Ext.getCmp('maxStaticCheck').setValue(false);
					Ext.getCmp('absMaxCritical').setValue(absMaxCritical);
					Ext.getCmp('absMaxMajor').setValue(absMaxMajor);
					Ext.getCmp('absMaxMinor').setValue(absMaxMinor);
				}

				if (!isNegativeValuesAllowed)
				{
					var maxAutomaticOption = maxThreshObj.maxAutomaticOption;
					var maxAutomaticBlock = maxThreshObj.maxAutomaticBlock;
					if (maxAutomaticOption != null && !Ext.isEmpty(maxAutomaticOption) && maxAutomaticOption == 'selected')
					{
						var relMaxCritical = maxThreshObj.relMaxCritical;
						var relMaxMajor = maxThreshObj.relMaxMajor;
						var relMaxMinor = maxThreshObj.relMaxMinor;
						Ext.getCmp('maxAutoCheck').show();
						Ext.getCmp('maxAutoFieldContainer').show();
						Ext.getCmp('maxAutoCheck').setValue(false);
						Ext.getCmp('relMaxCritical').setValue(relMaxCritical);
						Ext.getCmp('relMaxCriticalText').setValue(relMaxCritical);
						Ext.getCmp('relMaxMajor').setValue(relMaxMajor);
						Ext.getCmp('relMaxMajorText').setValue(relMaxMajor);
						Ext.getCmp('relMaxMinor').setValue(relMaxMinor);
						Ext.getCmp('relMaxMinorText').setValue(relMaxMinor);

						if (toolTipMsg)
						{
							Ext.getCmp('relMaxCritical').setFieldLabel('Critical (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipCritical+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
							Ext.getCmp('relMaxMajor').setFieldLabel('Major (% Tolerance) <img data-qtip="'+publicJson.toolTipMsg.toolTipMajor+'" style="margin-left:5px;vertical-align: middle;" src="/final/images/clear.png" class="iconTooltipHelp"/>');
						}
						else
						{
							Ext.getCmp('relMaxCritical').setFieldLabel(autoCriText);
							Ext.getCmp('relMaxMajor').setFieldLabel(autoMajorText);
						}
					}
				}

				if(alarmPolicyCombo != null && !Ext.isEmpty(alarmPolicyCombo))
				{
					Ext.getCmp('alarmDispField').el.animate({opacity: 1});
					Ext.getCmp('alarmPolicyCombo').getStore().removeAll();
					Ext.getCmp('alarmPolicyCombo').getStore().suspendEvents();
					Ext.getCmp('alarmPolicyCombo').getStore().loadRawData(alarmPolicyCombo);
					Ext.getCmp('alarmPolicyCombo').getStore().resumeEvents();

					if (selectAlarm != null && !Ext.isEmpty(selectAlarm))
					{
						Ext.getCmp('alarmPolicyCombo').setValue(selectAlarm);
					}
					else
					{
						Ext.getCmp('alarmPolicyCombo').setValue(alarmPolicyCombo[0].valueField);
					}
					if (selectedAlarmDescription != null && !Ext.isEmpty(selectedAlarmDescription))
					{
						//alarmDispField.el.update(selectedAlarmDescription);
						Ext.getCmp('alarmDispField').setValue(selectedAlarmDescription);
					}
					else
					{
						var tmpDescription = publicJson['alarmPolicyDescriptionObj'][alarmPolicyCombo[0].valueField]
						//alarmDispField.el.update(tmpDescription);
						Ext.getCmp('alarmDispField').setValue(tmpDescription);
					}
				}
			}
		});
	},
	maxRelCriticalSlider: function()
	{
		Ext.getCmp('relMaxCriticalText').setValue(Ext.getCmp('relMaxCritical').getValue());
	},
	maxRelMajorSlider: function()
	{
		Ext.getCmp('relMaxMajorText').setValue(Ext.getCmp('relMaxMajor').getValue());
	},
	maxRelMinorSlider: function()
	{
		Ext.getCmp('relMaxMinorText').setValue(Ext.getCmp('relMaxMinor').getValue());
	},
	minRelCriticalSlider: function()
	{
		Ext.getCmp('relMinCriticalText').setValue(Ext.getCmp('relMinCritical').getValue());
	},
	minRelMajorSlider: function()
	{
		Ext.getCmp('relMinMajorText').setValue(Ext.getCmp('relMinMajor').getValue());
	},
	minRelMinorSlider: function()
	{
		Ext.getCmp('relMinMinorText').setValue(Ext.getCmp('relMinMinor').getValue());
	},
	callThreshValPage: function(btn)
	{
		var thisForm = document.specsthreshold;
		var compType = Ext.getCmp('compTypeCombo').getValue();
		var compName = Ext.getCmp('compNameCombo').getValue();
		comeFrom = 'admin';
		strCompType = compType;
		strCompName = compName;
		strDescName = '';
		if(btn.id == 'specificTestModifyBtn')
		{
			from = 'specificTest';
			isRefine = 'true';
			var specThreshTests = Ext.getCmp('specificTestMultiSelect').getValue();
			var isSpecificTestSelected = false;
			var specTest = "";
			for (key in specThreshTests )
			{
				var grpTest = specThreshTests[key];
				if(!Ext.isEmpty(grpTest) && grpTest != null && grpTest != 'undefined')
				{
					isSpecificTestSelected = true;
					specTest = grpTest;
				}
			}
			if (!isSpecificTestSelected)
			{
				Ext.Msg.show({ 
					title: pageName,
					msg: selectSpecificTestAlert,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return;
			}
			strTestName = specTest;
			var homepage = Ext.getCmp('viewPortId');
			myMask = new Ext.LoadMask(homepage, {msg:"Updating..."});
			homepage.removeAll();
			myMask.show();
			homepage.add({ xtype : 'viewthresholds' });
			myMask.hide();

		}
		else
		{
			from = 'defaultTest';
			isRefine = '';
			var defThreshTests = Ext.getCmp('defaultTestMultiSelect').getValue();
			var isDefaultTestSelected = false;
			var defTest = "";
			for (key in defThreshTests )
			{
				var grpTest = defThreshTests[key];
				if(!Ext.isEmpty(grpTest) && grpTest != null && grpTest != 'undefined')
				{
					isDefaultTestSelected = true;
					defTest = grpTest;
				}
			}
			if (!isDefaultTestSelected)
			{
				Ext.Msg.show({ 
					title: pageName,
					msg: selectDefaultTestAlert,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation'
				});
				return;
			}
			strTestName = defTest;
			var homepage = Ext.getCmp('viewPortId');
			myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
			homepage.removeAll();
			myMask.show();
			homepage.add({ xtype : 'viewthresholds' });
			myMask.hide();
		}
	},
	callGrpRulePage: function(btn)
	{
		var compType = Ext.getCmp('compTypeCombo').getValue();
		var compName = Ext.getCmp('compNameCombo').getValue();
		var grpThreshTests = Ext.getCmp('groupTestMultiSelect').getValue();
		var isGrpTestSelected = false;
		var testValue = "";

		for (key in grpThreshTests )
		{
			var grpTest = grpThreshTests[key];
			if(!Ext.isEmpty(grpTest) && grpTest != null && grpTest != 'undefined')
			{
				isGrpTestSelected = true;
				testValue = grpTest;
			}
		}
		if (!isGrpTestSelected)
		{
			Ext.Msg.show({ 
				title: pageName,
				msg: selectTestAlert,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
		//EgGroupThreshold.jsp?specthreshpage=yes&test=BufferCacheTest&component=gen_1:NULL&strServer=Generic_server&comeFrom=admin
		//specthreshpage=yes&test=BufferCacheTest&component=gen_1:NULL&strServer=Generic_server&comeFrom=admin
		if(btn.id == 'groupTestModifyRuleBtn')
		{
			window.location.href = "/final/admin/EgGroupThreshold.jsp?specthreshpage=yes&test="+encodeURIComponent(testValue)+"&component="+encodeURIComponent(compName)+"&strServer="+encodeURIComponent(compType)+"&comeFrom=admin"+"&fromWizard="+fromWizard;
		}
		else
		{
			comeFrom = 'admin';
			strCompType = compType;
			strCompName = compName;
			strDescName = '';
			//if(btn.id == 'specificTestModifyBtn')
			{
				from = 'grpRuleTest';
				isRefine = 'true';
				
				strTestName = testValue;
				var homepage = Ext.getCmp('viewPortId');
				myMask = new Ext.LoadMask(homepage, {msg:"Updating..."});
				homepage.removeAll();
				myMask.show();
				homepage.add({ xtype : 'viewthresholds' });
				myMask.hide();
			}
		}
	},
	populateGroupDescriptor: function()
	{
		Ext.getCmp('noDescriptorMsgContainer').hide();
		Ext.getCmp('oneDescriptorTab').hide();
		Ext.getCmp('twoDescriptorTab').hide();
		var compType = Ext.getCmp('compTypeCombo').getValue();
		var compName = Ext.getCmp('compNameCombo').getValue();
		var test;
		var qctr;
		var flag = false;
		var grpThreshTests = Ext.getCmp('groupTestMultiSelect').getValue();
		var isGrpDescriptorSelected = false;
		var defTest = "";
		for (key in grpThreshTests )
		{
			var grpTest = grpThreshTests[key];
			if(!Ext.isEmpty(grpTest) && grpTest != null && grpTest != 'undefined')
			{
				isGrpDescriptorSelected = true;
				defTest = grpTest;
			}
		}
		if (!isGrpDescriptorSelected)
		{
			Ext.Msg.show({
				title: pageName,
				msg: selectTestAlert,
				icon: 'iconExclamation',
				buttons: Ext.Msg.OK
			});
			return;
		}

		if(defTest != null && defTest != "")
		{
			flag = true;
			test = defTest;
			qctr = "group";
		}

		var str = "SpecificThreshold/data/EgSpecificThreshJson.jsp?qctr="+qctr+"&server="+encodeURIComponent(compType)+"&compName="+ encodeURIComponent(compName)+"&test="+encodeURIComponent(test)+"&from=defthreshinfo";
		if(flag)
		{
			Ext.Ajax.request({
				url:str,
				method: 'POST',
				timeout: 600000,
				success: function(response)
				{
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);

					var compTypeArr = publicJson['specCompTypeArr'];
					var compNameArr = publicJson['specCompNameArr'];
					var globalTestArr = publicJson['globalTestsArr'];
					var specificTestArr = publicJson['specTestsArr'];
					var defaultTestArr = publicJson['defaultTestsArr'];
					var compType = publicJson['selectedCompType'];
					var compName = publicJson['selectedCompName'];
					var specificTestName = publicJson['selectedSpecsTest'];
					var groupTestName = publicJson['selectedGroupTest'];
					var defaultTestName = publicJson['selectedTest'];
					Ext.getCmp('compTypeCombo').getStore().loadRawData(compTypeArr);
					if (compType != null && compType != 'undefined')
					{
						Ext.getCmp('compTypeCombo').setValue(compType);
					}
					else
					{
						Ext.getCmp('compTypeCombo').setValue(compTypeArr[0].valueField);
					}
					
					Ext.getCmp('compNameCombo').getStore().loadRawData(compNameArr);
					if (compName != null && compName != 'undefined')
					{
						Ext.getCmp('compNameCombo').setValue(compName);
					}
					else
					{
						Ext.getCmp('compNameCombo').setValue(compNameArr[0].valueField);
					}

					var noDescMsg = publicJson['screenLabels']['No_desc_msg'];
					var isSelfandTestFollow = publicJson['isSelfandTestFollow'];
					var isSelfFollow = publicJson['isSelfFollow'];
					var isTestFollow = publicJson['isTestFollow'];
					var isDescSearch = publicJson['isDescSearch'];

					var specsDescArr = publicJson['specsDescArr'];
					var testDescArr = publicJson['testDescArr'];

					if (!isSelfandTestFollow && !isSelfFollow && !isTestFollow)
					{
						Ext.getCmp('noDescriptorMsgContainer').show();
						Ext.getCmp('noDescLabelId').update(noDescMsg);
					}
					else if (isSelfandTestFollow)
					{
						Ext.getCmp('twoDescriptorTab').show();
						var isSpecificDescSearch = publicJson['isSpecificDescSearch'];
						if(isSpecificDescSearch)
						{
							Ext.getCmp('twoDescriptorTabSearch').show();
						}else
						{
							Ext.getCmp('twoDescriptorTabSearch').hide();
						}
						if (isSelfFollow)
						{
							Ext.getCmp('specificDescGrid').getStore().removeAll();
							Ext.getCmp('specificDescGrid').getStore().loadRawData(specsDescArr);
						}
						if (isTestFollow)
						{
							Ext.getCmp('testDescGrid').getStore().removeAll();
							Ext.getCmp('testDescGrid').getStore().loadRawData(testDescArr);
						}
					}
					else 
					{
						Ext.getCmp('oneDescriptorTab').show();
						if(isDescSearch)
						{
							Ext.getCmp('oneDescriptorTabSearch').show();
						}else
						{
							Ext.getCmp('oneDescriptorTabSearch').hide();
						}
						if (isSelfFollow)
						{
							Ext.getCmp('tabOne').setTitle(tabMsg1);
							Ext.getCmp('specificOrTestGrid').getStore().removeAll();
							Ext.getCmp('specificOrTestGrid').getStore().loadRawData(specsDescArr);
						}
						else if (isTestFollow)
						{
							Ext.getCmp('tabOne').setTitle(tabMsg2);
							Ext.getCmp('specificOrTestGrid').getStore().removeAll();
							Ext.getCmp('specificOrTestGrid').getStore().loadRawData(testDescArr);
						}
					}
				},
				failure: function()
				{
				}
			});
		}
	},
	viewNoThreshMeasureModify: function( grid, td, cellIndex, record, tr, rowIndex, e, eOpts )
	{
		var pos = grid.getSelectionModel().getCurrentPosition();
		record = grid.store.getAt(pos.row);
		colname = grid.getHeaderCt().getHeaderAtIndex(cellIndex).dataIndex;
		cellvalue = record.data[colname];
		actualMeasName = publicJson['measureDataObj'][cellvalue];

		if (actualMeasName != null && actualMeasName != 'undefined' && actualMeasName != '')
		{
			hiddenFieldsVal = this.getHiddenFields(actualMeasName);
			var homepage = Ext.getCmp('viewPortId');
			homepage.removeAll();
			homepage.add({ xtype : 'configurespecificthresholds' });
		}
	},
	noThreshMeasureModify: function( grid, td, cellIndex, record, tr, rowIndex, e, eOpts )
	{
		var pos = grid.getSelectionModel().getCurrentPosition();
		record = grid.store.getAt(pos.row);
		colname = grid.getHeaderCt().getHeaderAtIndex(cellIndex).dataIndex;
		cellvalue = record.data[colname];
		var gridID = grid.ownerCt.getId();
		if (gridID != null && gridID != 'undefined' && gridID == 'globalTestGrid')
		{
			actualGlobalTestName = publicJson['globalTestsActualNameObj'][cellvalue];
		}
		else
		{
			actualGlobalTestName = cellvalue;
		}

		if (actualGlobalTestName != null && actualGlobalTestName != 'undefined' && actualGlobalTestName != '')
		{
			if (gridID != null && gridID != 'undefined' && gridID == 'globalTestGrid')
			{
				var compType = Ext.getCmp('compTypeCombo').getValue();
				var compName = Ext.getCmp('compNameCombo').getValue();
				window.location.href = 'EgDefaultThresh.jsp?componentType='+encodeURIComponent(compType)+'&testName='+actualGlobalTestName+'&from=specificThreshPage&comeFrom=admin&componentName='+encodeURIComponent(compName);
			}
			else if (gridID != null && gridID != 'undefined' && gridID == 'specificDescriptorGrid')
			{
				this.callDescViewThreshValPage('specificDesc',actualGlobalTestName);
			}
			else if (gridID != null && gridID != 'undefined' && gridID == 'specificDescGrid' )
			{
				this.callDescThreshValPage('specificDesc',actualGlobalTestName);
			}
			else if (gridID != null && gridID != 'undefined' && gridID == 'testDescGrid')
			{
				this.callDescThreshValPage('testFollowDesc',actualGlobalTestName);
			}
			else if (gridID != null && gridID != 'undefined' && gridID == 'specificOrTestGrid')
			{
				this.callDescThreshValPage('testFollowDesc',actualGlobalTestName);
			}
		}
	},
	gotoGroupThreshPage: function()
	{
		var compType = Ext.getCmp('compTypeCombo').getValue();
		window.location.href = '/final/admin/EgGroupThreshold.jsp?compType='+encodeURIComponent(compType)+'&test=Groups&serv='+encodeURIComponent(compType)+'&reqFrom=egConThresh&fromSpecs=specificThreshPage&comeFrom=admin&fromWizard='+fromWizard;
	},
	compNameChange: function()
	{
		Ext.getCmp('noDescriptorMsgContainer').hide();
		Ext.getCmp('oneDescriptorTab').hide();
		Ext.getCmp('twoDescriptorTab').hide();

		var compType = Ext.getCmp('compTypeCombo').getValue();
		var compName = Ext.getCmp('compNameCombo').getValue();
		Ext.getCmp('globalTestGrid').hide();
		Ext.getCmp('specificTestMultiSelect').getStore().removeAll();
		Ext.getCmp('defaultTestMultiSelect').getStore().removeAll();
		if (Ext.getCmp('groupTestMultiSelect').getStore().getCount() > 0)
		{
			Ext.getCmp('groupTestMultiSelect').getStore().removeAll();
		}
		//Ext.getCmp('groupTestMultiSelect').setDisabled(true);
		//Ext.getCmp('groupTestModifyBtn').setDisabled(true);

		if ((compType != null && !Ext.isEmpty(compType) && compType != '-1' ) && (compName != null && !Ext.isEmpty(compName) && compName == '-1'))
		{
			compName= 'null';
		}

		strCompType = compType;
		strCompName = compName;
		if ((compType != null && !Ext.isEmpty(compType) && compType != '-1' ) && (compName == null || Ext.isEmpty(compName) || compName == 'null'))
		{
			me.compTypeChange();
		}
		else if (compName != null && !Ext.isEmpty(compName) && compName != 'null')
		{
			Ext.Ajax.request({
				url:'SpecificThreshold/data/EgSpecificThreshJson.jsp?&server='+encodeURIComponent(compType)+'&compName='+encodeURIComponent(compName),
				method:'post',	
				scope:this,
				async: false,
				success:function(response)
				{	
					if(response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						publicJson = Ext.decode(jsonText);
						var globalTestArr = publicJson['globalThreshTestArr'];
						var specificTestArr = publicJson['specTestsArr'];
						var groupTestArr = publicJson['groupTestsArr'];
						var defaultTestArr = publicJson['defaultTestsArr'];
						var compType = publicJson['selectedCompType'];
						var compName = publicJson['selectedCompName'];
						var specificTestName = publicJson['selectedSpecsTest'];
						var groupTestName = publicJson['selectedGroupTest'];
						var defaultTestName = publicJson['selectedTest'];
						var configureGroupPageBtnLabel = publicJson['configureGroupPageBtnLabel'];

						if (!Ext.isEmpty(configureGroupPageBtnLabel) && configureGroupPageBtnLabel.length > 0 ) //compName != null && !Ext.isEmpty(compName) && compName != '-1' )
						{
							Ext.getCmp('configureGroupPageBtn').show();
							Ext.getCmp('configureGroupPageBtn').update(configureGroupPageBtnLabel);
						}
						else
						{
							Ext.getCmp('configureGroupPageBtn').hide();
						}

						if(globalTestArr != null && !Ext.isEmpty(globalTestArr))
						{
							Ext.getCmp('globalTestGrid').suspendEvents();
							//Ext.getCmp('globalTestGrid').getStore().removeAll();
							Ext.getCmp('globalTestGrid').getStore().loadRawData(globalTestArr);
							Ext.getCmp('globalTestGrid').resumeEvents();
							Ext.getCmp('globalTestGrid').show();
						}else
						{
							Ext.getCmp('globalTestGrid').hide();
						}

						if (defaultTestArr != null && !Ext.isEmpty(defaultTestArr))
						{
							Ext.getCmp('defaultTestMultiSelect').getStore().removeAll();
							Ext.getCmp('defaultTestMultiSelect').getStore().loadRawData(defaultTestArr);
							if ((from != null && from == 'defaultTest') && (strTestName != null && !Ext.isEmpty(strTestName)) )
							{
								Ext.getCmp('defaultTestMultiSelect').setValue(strTestName);
							}
						}

						if (groupTestArr != null && !Ext.isEmpty(groupTestArr))
						{
							//Ext.getCmp('groupTestMultiSelect').setDisabled(false);
							//Ext.getCmp('groupTestModifyBtn').setDisabled(false);
							Ext.getCmp('groupTestMultiSelect').getStore().loadRawData(groupTestArr);
							if ((from != null && from == 'groupTest') && (strTestName != null && !Ext.isEmpty(strTestName)) )
							{
								Ext.getCmp('groupTestMultiSelect').setValue(strTestName);
							}
						}
						else
						{
							if (Ext.getCmp('groupTestMultiSelect').getStore().getCount() > 0)
							{
								Ext.getCmp('groupTestMultiSelect').getStore().removeAll();
							}
							//Ext.getCmp('groupTestMultiSelect').setDisabled(true);
							//Ext.getCmp('groupTestModifyBtn').setDisabled(true);
						}

						if(specificTestArr != null && !Ext.isEmpty(specificTestArr))
						{
							Ext.getCmp('specificTestMultiSelect').suspendEvents();
							Ext.getCmp('specificTestMultiSelect').getStore().removeAll();
							Ext.getCmp('specificTestMultiSelect').getStore().loadRawData(specificTestArr);
							Ext.getCmp('specificTestMultiSelect').resumeEvents();
							if((from != null && from == 'specificTest') && (strTestName != null && !Ext.isEmpty(strTestName)))
							{
								Ext.getCmp('specificTestMultiSelect').setValue(strTestName);
							}
						}
					}
				}
			});
		}
	},
	compTypeChange: function()
	{
		Ext.getCmp('noDescriptorMsgContainer').hide();
		Ext.getCmp('oneDescriptorTab').hide();
		Ext.getCmp('twoDescriptorTab').hide();

		var compType = Ext.getCmp('compTypeCombo').getValue();
		strCompType = compType;
		Ext.getCmp('globalTestGrid').hide();
		Ext.getCmp('specificTestMultiSelect').getStore().removeAll();
		Ext.getCmp('defaultTestMultiSelect').getStore().removeAll();
		if (Ext.getCmp('groupTestMultiSelect').getStore().getCount() > 0)
		{
			Ext.getCmp('groupTestMultiSelect').getStore().removeAll();
		}
		//Ext.getCmp('groupTestMultiSelect').setDisabled(true);
		//Ext.getCmp('groupTestModifyBtn').setDisabled(true);
		if (compType != null && !Ext.isEmpty(compType))
		{
			Ext.Ajax.request({
				url:'SpecificThreshold/data/EgSpecificThreshJson.jsp?server='+encodeURIComponent(compType),
				method:'post',	
				scope:this,
				async: false,
				success:function(response)
				{
					if(response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						publicJson = Ext.decode(jsonText);
						var compNameArr = publicJson['specCompNameArr'];
						var configureGroupPageBtnLabel = publicJson['configureGroupPageBtnLabel'];

						if (!Ext.isEmpty(configureGroupPageBtnLabel) && configureGroupPageBtnLabel.length > 0 ) //compName != null && !Ext.isEmpty(compName) && compName != '-1' )
						{
							Ext.getCmp('configureGroupPageBtn').show();
							Ext.getCmp('configureGroupPageBtn').update(configureGroupPageBtnLabel);
						}
						else
						{
							Ext.getCmp('configureGroupPageBtn').hide();
						}
						Ext.getCmp('compNameCombo').suspendEvents();
						Ext.getCmp('compNameCombo').getStore().removeAll();
						Ext.getCmp('compNameCombo').getStore().clearFilter(true);
						Ext.getCmp('compNameCombo').getStore().loadRawData(compNameArr);

						Ext.getCmp('compNameCombo').setValue(compNameArr[0].valueField);
						Ext.getCmp('compNameCombo').resumeEvents();

						if (!Ext.isEmpty(compNameArr[0].valueField) && compNameArr[0].valueField != '-1')
						{
							Ext.getCmp('compNameCombo').fireEvent('select', Ext.getCmp('compNameCombo'));
						}
					}
				}
			});
		}
	},
	afterMainRender: function()
	{
		params = 'reqfrom=navlink';
		var qStr = '';
		if (strCompType != null && strCompType != 'undefined' && strCompType.length > 0)
		{
			qStr += 'server='+encodeURIComponent(strCompType);
		}
		if (strCompName != null && strCompName != 'undefined' && strCompName.length > 0)
		{
			qStr += '&compName='+encodeURIComponent(strCompName);
		}

		if (qStr != null && qStr.length > 0)
		{
			params = qStr;
		}
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myMask.show();
		Ext.Ajax.request({
			url:'SpecificThreshold/data/EgSpecificThreshJson.jsp?'+params,
			method:'POST',
			scope:this,
			success:function(response)
			{
				myMask.hide();
				var jsonText = response.responseText;
				publicJson = Ext.decode(jsonText);

				var compTypeArr = publicJson['specCompTypeArr'];
				var compNameArr = publicJson['specCompNameArr'];
				var compType = publicJson['selectedCompType'];
				var compName = publicJson['selectedCompName'];
				
				Ext.getCmp('compTypeCombo').getStore().removeAll();
				Ext.getCmp('compTypeCombo').getStore().clearFilter(true);
				Ext.getCmp('compTypeCombo').getStore().loadRawData(compTypeArr);
				if (compType != null && compType != 'undefined')
				{
					Ext.getCmp('compTypeCombo').setValue(compType);
					Ext.getCmp('compTypeCombo').fireEvent('select', Ext.getCmp('compTypeCombo'));
				}
				else
				{
					Ext.getCmp('compTypeCombo').setValue(compTypeArr[0].valueField);
				}
				
				Ext.getCmp('compNameCombo').getStore().clearFilter(true);
				Ext.getCmp('compNameCombo').getStore().loadRawData(compNameArr);
				if (compName != null && compName != 'undefined')
				{
					Ext.getCmp('compNameCombo').setValue(compName);
					Ext.getCmp('compNameCombo').fireEvent('select', Ext.getCmp('compNameCombo'));
				}
				else
				{
					Ext.getCmp('compNameCombo').setValue(compNameArr[0].valueField);
				}

				if (!Ext.isEmpty(reqFrom) && reqFrom != undefined && reqFrom == 'compModify')
				{
					Ext.getCmp('backbutton').show();
				}
				else
				{
					Ext.getCmp('backbutton').hide();
				}
			}
		});
		//if (Ext.get('loadmask') != null)
		//{
			//Ext.get('loadmask').remove();
		//}
	},

	goToBack : function()
	{
		var compTypeComboValue = Ext.getCmp('compTypeCombo').getValue();
		if (!Ext.isEmpty(reqFrom) && reqFrom != undefined && reqFrom == 'compModify')
		{
			window.location.href='/final/admin/EgDispServer.jsp?comptype='+encodeURIComponent(compTypeComboValue);
		}
	}
});


function checkValidValue(val)
{
	var regExp = /^(\-)$|^(\-|\-?(([0-9]+\.|\.)?[0-9]+))$/i;
	var ret = regExp.test(val);
	return ret;
}

function checkNegativeValue(val)
{
	if (val == "-")
	{
		val = "0";
	}
	var regExp = /^\-([0-9]+\.|\.)?[0-9]+/;
	var ret = regExp.test(val);
	return ret;
}

function checkNegativeFormat(val)
{
	var regExp= /^(\-{0,1})[0-9]{1,10}(\.[0-9]{1,4})?$/;
	var ret = regExp.test(val);
	return ret;
}

function checkNonNegativeFormat(val)
{
	var regExp= /^[0-9]{0,10}(\.[0-9]{1,4})?$/;
	var ret = regExp.test(val);
	return ret;
}



