Ext.define('SuccessfulLogons.controller.Main',{
	extend:'Ext.app.Controller',
	views:['FormItems','LoginResultPanel','Print','EgInfraDownloader'],

	refs:[
		{selector:'FormItems', ref:'FormItems'},
		{selector:'LoginResultPanel', ref:'LoginResultPanel'},
	],

	init:function(){
		this.buildMainData();
		this.control({
			'logons_widget':
			{
				'afterrender': this.afterMainRender
			},
			'logons_widget button[id="schedule"]':
			{
				'click': this.callSaveSchedule
			},
			'logons_widget button[id="save"]':
			{
				'click': this.savePdf
			},
			'logons_widget button[id="print"]':
			{
				'click': this.printData
			},
			'logons_widget button[id="csv"]':
			{
				'click': this.saveInCSVFormat
			},
			'logons_widget button[id="showbutton"]':
			{
				'click': this.showAgain
			},
			'logons_widget combo[id="timeline"]':
			{
				'select': this.changeTimeline
			},
			'logons_widget combo[id="users"]':
			{
				'select': this.clearResultPanel 
			},
			'logons_widget combo[id="clusterManager"]':
			{
				'select': this.clearResultPanel 
			},
			'logons_widget combo[id="filterBy"]':
			{
				'select': this.clearResultPanel 
			}
		});
	},
	buildMainData: function(){
		var urlStr = "";
		if (reqFrom != null && reqFrom != "" && reqFrom == "auditlog")
		{
			reqFrom = "ownPage";
			urlStr = '/final/servlet/com.eg.AuditServletExtJS?'+queryString+'&jsppage=logons&reqfrom=navlink&submitted=true';
		}
		else
		{
			urlStr = '/final/servlet/com.eg.AuditServletExtJS?jsppage=logons&reqfrom=navlink';
		}

		Ext.Ajax.request({
			url : urlStr,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
			},
			failure : function(response)
			{
				var topWindow = window;
				while(topWindow.parent!=topWindow ||  topWindow.opener!=null)
				{
					mainWindow = topWindow;
					topWindow = (topWindow.parent==topWindow? topWindow.opener:topWindow.parent);
				}
				if(topWindow.location.pathname!="/")
				{
					mainWindow=topWindow;
				}
				mainWindow.location.href="/final/servlet/com.egurkha.Logout?errmsg=1";
				mainWindow.focus();
				//Ext.Msg.alert(pageTitle,could_not_load);
			}
		});
	},
	clearResultPanel : function()
	{
		hideResultPanel();
	},
	afterMainRender : function()
	{
		if(isClusterSupported=="false" && auditLogEnabledForCLI=="false")
		{
			Ext.getCmp('clusterManager').hide();
			Ext.getCmp('filterBy').hide();
		}
		else if(isClusterSupported=="true" && auditLogEnabledForCLI=="true")
		{
			Ext.getCmp('clusterManager').show();
			Ext.getCmp('filterBy').show();
		}
		else if(isClusterSupported=="true")
		{
			Ext.getCmp('clusterManager').show();
			Ext.getCmp('filterBy').hide();
		}
		else
		{
			Ext.getCmp('clusterManager').hide();
			Ext.getCmp('filterBy').show();
		}
		/*Ext.Ajax.request({
			url : '/final/servlet/com.eg.AuditServletExtJS?jsppage=logons&reqfrom=navlink',
			method: 'POST',
			async: true,
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);*/

				var timelineVal = publicJSON['defaults']["timeline"];

				if (timelineVal != "" && timelineVal != undefined && timelineVal != "Any")
				{
					Ext.getCmp('eg_stdate').setDisabled(true);
					Ext.getCmp('starthr').setDisabled(true);
					Ext.getCmp('startmin').setDisabled(true);
					Ext.getCmp('eg_enddate').setDisabled(true);
					Ext.getCmp('endhr').setDisabled(true);
					Ext.getCmp('endmin').setDisabled(true);
					Ext.getCmp('icon_go').hide();
				}
				else
				{
					Ext.getCmp('icon_go').show();
					Ext.getCmp('eg_stdate').setDisabled(false);
					Ext.getCmp('starthr').setDisabled(false);
					Ext.getCmp('startmin').setDisabled(false);
					Ext.getCmp('eg_enddate').setDisabled(false);
					Ext.getCmp('endhr').setDisabled(false);
					Ext.getCmp('endmin').setDisabled(false);
				}

				Ext.getCmp('timeline').getStore().loadRawData(publicJSON['timelinesArray']);
				Ext.getCmp('timeline').setValue(timelineVal);

				Ext.getCmp('eg_stdate').setValue(publicJSON['defaults']["eg_stdate"]);
				Ext.getCmp('starthr').setValue(publicJSON['defaults']["starthr"]);
				Ext.getCmp('startmin').setValue(publicJSON['defaults']["startmin"]);

				Ext.getCmp('eg_enddate').setValue(publicJSON['defaults']["eg_enddate"]);
				Ext.getCmp('endhr').setValue(publicJSON['defaults']["endhr"]);
				Ext.getCmp('endmin').setValue(publicJSON['defaults']["endmin"]);

				Ext.getCmp('users').getStore().loadRawData(publicJSON['userIdsArray']);
				if(publicJSON['selectedUser'] != null && publicJSON['selectedUser'] != 'undefined')
				{
					Ext.getCmp('users').setValue(publicJSON["selectedUser"]);
				}
				else
				{
					Ext.getCmp('users').setValue(publicJSON["defaultuser"]);
				}

				if(publicJSON['nousersavailable'] != null && publicJSON['nousersavailable'] != 'undefined')
				{
					Ext.getCmp('users').setValue(publicJSON["nousersavailable"]);
					disableAll();
				}

				Ext.getCmp('clusterManager').getStore().loadRawData(publicJSON['clusterArray']);
				Ext.getCmp('clusterManager').setValue(publicJSON["defaultClusterManager"]);

				Ext.getCmp('filterBy').getStore().loadRawData(publicJSON['filterByArray']);
				if (publicJSON['selectedFilterBy'] != null && publicJSON['selectedFilterBy'] != undefined)
				{
					Ext.getCmp('filterBy').setValue(publicJSON['selectedFilterBy']);
				}
				else
				{
					Ext.getCmp('filterBy').setValue(publicJSON['defaultFilterBy']);
				}
				if(publicJSON['columns'] != null && publicJSON['columns'] != 'undefined')
				{
					var gridTitle = publicJSON['gridTitle']["title"];
					var cols = publicJSON['columns'];
					var gridArray = publicJSON['rowDataArray'];
					getGridPanel(gridArray,cols,gridTitle);
					if(isSuperManager=='true')
					{
						Ext.getCmp("schedule").hide();
					}
					Ext.getCmp("schedule").setDisabled(false);
					Ext.getCmp("save").setDisabled(false);
					Ext.getCmp("print").setDisabled(false);
					Ext.getCmp("csv").setDisabled(false);
				}
				else
				{
					if(isSuperManager=='true')
					{
						Ext.getCmp("schedule").hide();
					}
					Ext.getCmp("schedule").setDisabled(true);
					Ext.getCmp("save").setDisabled(true);
					Ext.getCmp("print").setDisabled(true);
					Ext.getCmp("csv").setDisabled(true);
				}

				var labels = publicJSON['labels'];

				Ext.getCmp('timeline').setFieldLabel(labels['timeline']);

				Ext.getCmp('eg_stdate').setFieldLabel(labels['eg_stdate']);
				Ext.getCmp('starthr').setFieldLabel(labels['starthr']);
				Ext.getCmp('startmin').setFieldLabel(labels['startmin']);

				Ext.getCmp('eg_enddate').setFieldLabel(labels['eg_enddate']);
				Ext.getCmp('endhr').setFieldLabel(labels['starthr']);
				Ext.getCmp('endmin').setFieldLabel(labels['startmin']);

				Ext.getCmp('users').setFieldLabel(labels['users']);
				Ext.getCmp('clusterManager').setFieldLabel(labels['clusterManager']);
				Ext.getCmp('filterBy').setFieldLabel(labels['filterBy']);

				Ext.getCmp('showbutton').setText(labels['showbutton']);

			/*},
			failure : function(response)
			{
				Ext.Msg.alert(pageTitle,could_not_load);
			}
		});*/
	},
	callSaveSchedule :function(btn)
	{
		if(validateDates())
		{
			var qryString = '/final/admin/saveSchedule.jsp?er_timeline='+Ext.getCmp('timeline').getValue()+'&er_gtype=Logons&er_rtype=Logons&submitted=true&jsppage=logons&submit=true&users='+Ext.getCmp('users').getValue()+'&er_userid='+Ext.getCmp('users').getValue()+'&startdate='+sformattedValue+'&enddate='+eformattedValue+'&eg_timeline='+Ext.getCmp('timeline').getValue()+'&SuccessfulLogons=true';
			if(auditLogEnabledForCLI=="true" && isClusterSupported=="true")
			{
				qryString +='&filterBy='+Ext.getCmp('filterBy').getValue() + '&clusterManager='+Ext.getCmp('clusterManager').getValue();
			}
			else if(auditLogEnabledForCLI=="true")
			{
				qryString +='&filterBy='+Ext.getCmp('filterBy').getValue();
			}
			else if(isClusterSupported=="true")
			{
				qryString +='&clusterManager='+Ext.getCmp('clusterManager').getValue();
			}
			scheduleWindow(qryString);
			Ext.getCmp('scheduleWin').setTitle(scheduleTitle);
		}
	},
	savePdf: function()
	{
		var getSaveObj = Ext.widget('savepdf');
		getSaveObj.savePDF(pdfURLString);
	},
	saveInCSVFormat: function()
	{
		window.location.href="/final/servlet/com.eg.SaveInCSVFormat?user_language="+trackerLanguage;
	},
	printData: function()
	{
		s_username = Ext.getCmp('users').getValue();
		if(s_username == null || s_username=='undefined' || s_username.length==0)
		{
			s_username = '-';
		}
		var printPage = "/final/admin/SuccessfulLogons/data/LogonsPrint.jsp?user="+encodeURIComponent(s_username)+"&printpage=true&frmPage=logons&title=Logons Report&com.eg.CSRF_NONCE="+csrfToken;
		Ext.widget('print').show();
		var printContentDiv = Ext.select('#printContentDiv');
		printContentDiv.set(
		{
			src :  printPage
		});
	},
	changeTimeline :function()
	{
		var obj = Ext.getCmp('timeline');
		if (obj.getValue() == 'Any')
		{
			Ext.getCmp('eg_stdate').setDisabled(false);
			Ext.getCmp('starthr').setDisabled(false);
			Ext.getCmp('startmin').setDisabled(false);
			Ext.getCmp('eg_enddate').setDisabled(false);
			Ext.getCmp('endhr').setDisabled(false);
			Ext.getCmp('endmin').setDisabled(false);
			Ext.getCmp('icon_go').show();
			hideResultPanel();
			disableAll();
		} 
		else
		{
			Ext.getCmp('eg_stdate').setDisabled(true);
			Ext.getCmp('starthr').setDisabled(true);
			Ext.getCmp('startmin').setDisabled(true);
			Ext.getCmp('eg_enddate').setDisabled(true);
			Ext.getCmp('endhr').setDisabled(true);
			Ext.getCmp('endmin').setDisabled(true);
			Ext.getCmp('icon_go').hide();

			var timeline = Ext.getCmp("timeline").getValue();
			var strtdt = Ext.getCmp("eg_stdate").getValue();
			var enddt = Ext.getCmp("eg_enddate").getValue();
			var strthour = Ext.getCmp("starthr").getValue();
			var endhr = Ext.getCmp("endhr").getValue();
			strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
			enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);
			var no_params = "&P0=[" + timeline + "]&P1=[" + strtdt + "]&P2=[" + enddt + "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=[" + dateFormatForTimeline + "]";
			var param = "F=getTime&C=id" + no_params;
			Ext.Ajax.request({
			url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
			params: param,
			scope: this,
			method: 'POST',
			success: function(response) {
					var jsontext = response.responseText;
					var jsonData = Ext.decode(jsontext);
					if(!Ext.isEmpty(jsonData))
					{
						var timedata = jsonData.timeline;
						Ext.getCmp("eg_stdate").setValue(timedata[6]);
						Ext.getCmp("eg_stdate").dataArray = timedata[0];
						Ext.getCmp("eg_enddate").setValue(timedata[7]);
						Ext.getCmp("eg_enddate").dataArray = timedata[1];
						Ext.getCmp("starthr").setValue(timedata[8]);
						Ext.getCmp("starthr").dataArray = timedata[2];
						Ext.getCmp("endhr").setValue(timedata[9]);
						Ext.getCmp("endhr").dataArray = timedata[3];

						Ext.getCmp("startmin").setValue(timedata[10]);
						Ext.getCmp("startmin").dataArray = timedata[11];
						Ext.getCmp("endmin").setValue(timedata[10]);
						Ext.getCmp("endmin").dataArray = timedata[11];
					}
				}
			});
			findUsers();
		}
	},
	showAgain : function()
	{
		if(validateDates())
		{
			var urlStr = '/final/servlet/com.eg.AuditServletExtJS?eg_timeline='+Ext.getCmp('timeline').getValue()+'&submitted=true&jsppage=logons&submit=true&users='+Ext.getCmp('users').getValue()+'&startdate='+sformattedValue+'&enddate='+eformattedValue;
			if(auditLogEnabledForCLI=="true" && isClusterSupported=="true")
			{
				urlStr +='&filterBy='+Ext.getCmp('filterBy').getValue() + '&clusterManager='+Ext.getCmp('clusterManager').getValue();
			}
			else if(auditLogEnabledForCLI=="true")
			{
				urlStr +='&filterBy='+Ext.getCmp('filterBy').getValue();
			}
			else if(isClusterSupported=="true")
			{
				urlStr +='&clusterManager='+Ext.getCmp('clusterManager').getValue();
			}
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Processing...'});
			myMask.show();
			Ext.Ajax.request({
				url :urlStr,
				method: 'POST',
				async: true,
				success: function(response)
				{
					myMask.hide();
					var jsonText = response.responseText;
					publicJSON = Ext.decode(jsonText);
					if(publicJSON['columns'] == null || publicJSON['columns'] == 'undefined')
					{
						hideResultPanel();
						Ext.MessageBox.alert(pageTitle,no_records_found);
					}
					else
					{
						var gridTitle = publicJSON['gridTitle']["title"];
						var cols = publicJSON['columns'];
						var gridArray = publicJSON['rowDataArray'];
						Ext.getCmp('users').getStore().loadRawData(publicJSON['userIdsArray']);
						getGridPanel(gridArray,cols,gridTitle);

						if(isSuperManager=='true')
						{
							Ext.getCmp("schedule").hide();
						}
						Ext.getCmp("schedule").setDisabled(false);
						Ext.getCmp("save").setDisabled(false);
						Ext.getCmp("print").setDisabled(false);
						Ext.getCmp("csv").setDisabled(false);
					}
				},
				failure : function(response)
				{
					myMask.hide();
					//Ext.Msg.alert(pageTitle,'first ' + could_not_load);
					var topWindow = window;
					while(topWindow.parent!=topWindow ||  topWindow.opener!=null)
					{
						mainWindow = topWindow;
						topWindow = (topWindow.parent==topWindow? topWindow.opener:topWindow.parent);
					}
					if(topWindow.location.pathname!="/")
					{
						mainWindow=topWindow;
					}
					mainWindow.location.href="/final/servlet/com.egurkha.Logout?errmsg=1";
					mainWindow.focus();
				}
			});
		}
	}
});

function getGridPanel(gridArray,cols,gridTitle)
{
	var fieldstoStore =  new Array();
	var mainColumnsObjArray =  new Array();

	for (var key in cols)
	{
		var gridColumn = cols[key];
		fieldstoStore.push(key);
		if(key=="Login_time")
		{
			mainColumnsObjArray.push({
				header: gridColumn,
				sortable:true,
				dataIndex: key,
				menuDisabled: true,
				flex:1,
				renderer: Ext.util.Format.dateRenderer(mgrDateFormat+' H:i:s')
			});
		}
		else if(key=="HIDDEN_COLUMN")
		{
			mainColumnsObjArray.push({
				header: 'hiddenCol',
				dataIndex: key,
				hidden:true,
			});
		}
		else if(key=="User_id")
		{
			mainColumnsObjArray.push({
				header: gridColumn,
				sortable:true,
				dataIndex: key,
				menuDisabled: true,
				flex:1,
				renderer: function(value, metaData, record, row, col, store, gridView)
				{
					return '<a id="eg_monlink" href = "javascript:void(0);" onclick="javascript:gotoAuditlogPage('+row+')">'+value+'</a>';
				}
			});
		}
		else
		{
			mainColumnsObjArray.push({
				header: gridColumn,
				sortable:true,
				dataIndex: key,
				menuDisabled: true,
				flex:1,
				renderer: function(value, metaData, record, row, col, store, gridView)
				{
					return value;
				}
			});
		}
	}
	var gridpanel = Ext.widget('detailsgrid',{
		store:new Ext.data.Store({
			fields: fieldstoStore,
			data: gridArray,
			proxy: {
				type: "pagingmemory",
				reader: {
					type: "json"
				}
			},
			autoLoad: true,
			pageSize : 16
		}),
		sortableColumns:true,
		columns:mainColumnsObjArray,
		//title:gridTitle,
		viewConfig: {
			forceFit: true,
			stripeRows : true
		}
	});
	var resultPanelObj = Ext.getCmp('loginresultpanel_in_formitem');
	resultPanelObj.show();
	resultPanelObj.removeAll();
	resultPanelObj.removeCls('dataPanel');
	resultPanelObj.add(gridpanel);
}

function validateDates()
{
	if(Ext.getCmp('timeline').getValue() != "Any")
	{
		return true;
	}
	else
	{
		var st_value = Ext.getCmp('eg_stdate').getValue();
		var st_hr = Ext.getCmp('starthr').getValue();
		var st_min = Ext.getCmp('startmin').getValue();
		var ed_value = Ext.getCmp('eg_enddate').getValue();
		var ed_hr = Ext.getCmp('endhr').getValue();
		var ed_min = Ext.getCmp('endmin').getValue();
		var start_date_check = Ext.Date.format(Ext.getCmp('eg_stdate').getValue(), 'm/d/Y');
		var end_date_check = Ext.Date.format(Ext.getCmp('eg_enddate').getValue(), 'm/d/Y');

		if(!checkExtTime(start_date_check,end_date_check,st_hr,ed_hr,st_min,ed_min))
		{
			sformattedValue = null;
			eformattedValue = null;
			Ext.Msg.alert(pageTitle,dateAlert);
			return false
		}
		else
		{
			sformattedValue = Ext.Date.format(st_value, 'm/d/Y')+ ' ' + st_hr + ':'+ st_min + ':00';
			eformattedValue = Ext.Date.format(ed_value, 'm/d/Y') + ' ' + ed_hr + ':'+ ed_min + ':00';
			return true;
		}
	}
}

function findUsers()
{
	hideResultPanel();
	var urlStr = null;
	var s_timeline = Ext.getCmp('timeline').getValue();
	if(s_timeline=="Any")
		urlStr='/final/servlet/com.eg.AuditServletExtJS?jsppage=logons&eg_timeline=Any';
	else
		urlStr='/final/servlet/com.eg.AuditServletExtJS?jsppage=logons&eg_timeline='+s_timeline;

	if(validateDates())
	{
		urlStr += '&startdate='+sformattedValue+'&enddate='+eformattedValue;
		Ext.Ajax.request({
			url :urlStr,
			method: 'POST',
			async: true,
			success: function(response)
			{
				enableAll();
				Ext.getCmp("users").clearValue();
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);

				Ext.getCmp('users').getStore().loadRawData(publicJSON['userIdsArray']);
				if(publicJSON['selectedUser'] != null && publicJSON['selectedUser'] != 'undefined')
				{
					Ext.getCmp('users').setValue(publicJSON["selectedUser"]);
				}
				else
				{
					Ext.getCmp('users').setValue(publicJSON["defaultuser"]);
				}

				if(publicJSON['nousersavailable'] != null && publicJSON['nousersavailable'] != 'undefined')
				{
					Ext.getCmp('users').setValue(publicJSON["nousersavailable"]);
					disableAll();
				}
				Ext.getCmp('clusterManager').getStore().loadRawData(publicJSON['clusterArray']);
				Ext.getCmp('clusterManager').setValue(publicJSON["defaultClusterManager"]);
				Ext.getCmp('filterBy').getStore().loadRawData(publicJSON['filterByArray']);
				if (publicJSON['selectedFilterBy'] != null && publicJSON['selectedFilterBy'] != undefined)
				{
					Ext.getCmp('filterBy').setValue(publicJSON['selectedFilterBy']);
				}
				else
				{
					Ext.getCmp('filterBy').setValue(publicJSON['defaultFilterBy']);
				}
			},
			failure : function(response)
			{
				var topWindow = window;
				while(topWindow.parent!=topWindow ||  topWindow.opener!=null)
				{
					mainWindow = topWindow;
					topWindow = (topWindow.parent==topWindow? topWindow.opener:topWindow.parent);
				}
				if(topWindow.location.pathname!="/")
				{
					mainWindow=topWindow;
				}
				mainWindow.location.href="/final/servlet/com.egurkha.Logout?errmsg=1";
				mainWindow.focus();
				//Ext.Msg.alert(pageTitle,'second '+could_not_load);
			}
		});
	}
}

function disableAll()
{
	Ext.getCmp("users").setDisabled(true);
	Ext.getCmp("clusterManager").setDisabled(true);
	Ext.getCmp("filterBy").setDisabled(true);
	Ext.getCmp("showbutton").setDisabled(true);
}

function enableAll()
{
	Ext.getCmp("users").setDisabled(false);
	Ext.getCmp("clusterManager").setDisabled(false);
	Ext.getCmp("filterBy").setDisabled(false);
	Ext.getCmp("showbutton").setDisabled(false);
}

function hideResultPanel()
{
	if(isSuperManager=='true')
	{
		Ext.getCmp("schedule").hide();
	}
	Ext.getCmp("schedule").setDisabled(true);
	Ext.getCmp("save").setDisabled(true);
	Ext.getCmp("print").setDisabled(true);
	Ext.getCmp("csv").setDisabled(true);
	Ext.getCmp("loginresultpanel_in_formitem").hide();
}
function gotoAuditlogPage(rowNumber)
{
	var gridStore = Ext.getCmp("detailsgrid").getStore();
	var measure_description = gridStore.getAt(rowNumber).get("HIDDEN_COLUMN");
	window.location.href = measure_description;
}

function doCloseWin()
{
	Ext.getCmp('scheduleWin').destroy();
}