Ext.define('TestConfigParameters.controller.Main',{
	extend:'Ext.app.Controller',

	views: ['FormItems'],

	refs: [
		{
			selector:'formitems',
			ref:'formitems'
		},
		{
			selector:'downloadutils',
			ref:'downloadutils'
		}
	],

	init: function(){
		main = this;
		this.buildFieldData()

		this.control({
			'formitems': {
				'afterrender': this.afterMainRender
			},
			'formitems combo[id="compType"]': {
				'select': this.comboLoad
			},
			'formitems combo[id="compName"]': {
				'select': this.comboNameLoad
			},
			'formitems button[id="submitBTN"]': {
				'click': this.sumbit
			},
			'formitems button[id="saveBTN"]': {
				'click': this.savePdf
			},
			'formitems button[id="saveCSV"]': {
				'click': this.saveCSVFile
			}
		});
	},

	buildFieldData: function() {
		Ext.Ajax.request({
			url: urlParam,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},

	comboLoad: function() {
		Ext.getCmp('saveBTN').setDisabled(true);
		Ext.getCmp('saveCSV').setDisabled(true);
		var x = document.getElementById("loadData");
		var y = (x.contentWindow || x.contentDocument);
		if (y.document)y = y.document;
		if (y.getElementById("main") != null && y.getElementById("main") != undefined)
		{
			y.body.innerHTML = "";
		}
		Ext.select('#loadData').set({src: ''});
		Ext.getCmp('resultContainer').hide();

		var componentType = Ext.getCmp('compType').getValue();
		var qrString = '';

		Ext.Ajax.request({
			url: 'TestConfigParameters/data/EgTestConfigParametersJson.jsp?compType='+encodeURIComponent(componentType),
			method: 'POST',
			success: function ( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );

					var compoName = publicJSON['ComponentName'];

					Ext.getCmp('compName').suspendEvents();
					Ext.getCmp('compName').getStore().removeAll();
					Ext.getCmp('compName').getStore().clearFilter(true);
					Ext.getCmp('compName').getStore().loadRawData(compoName);
					Ext.getCmp('compName').setValue(compoName[0].valueField);
					Ext.getCmp('compName').resumeEvents();
				}
			}
		});
	},

	comboNameLoad: function() {

		Ext.getCmp('saveBTN').setDisabled(true);
		Ext.getCmp('saveCSV').setDisabled(true);
		var x = document.getElementById("loadData");
		var y = (x.contentWindow || x.contentDocument);
		if (y.document)y = y.document;
		if (y.getElementById("main") != null && y.getElementById("main") != undefined)
		{
			y.body.innerHTML = "";
		}
		Ext.select('#loadData').set({src: ''});
		Ext.getCmp('resultContainer').hide();
	},

	sumbit: function(btn) {
		var cmpType = Ext.getCmp('compType').getValue();
		var cmpName = Ext.getCmp('compName').getValue();
		var loading = Ext.getCmp('formitems');
		Ext.getCmp('formitems').setLoading(true, true);
			setTimeout(function (target) {
				target.setLoading(false);
		}, 500, loading); 
		Ext.select('#loadData').set({src: "/final/admin/EgTestConfigParameters.jsp?componentType="+encodeURIComponent(cmpType)+"&componentName="+encodeURIComponent(cmpName)+"&requestFor=PAGE&fromExt=true&date="+new Date().getTime()});
		Ext.getCmp('resultContainer').show();
		Ext.getCmp('loadData').show();

		var hasCmp = publicJSON['hasCmp'];
		if (hasCmp == "Yes")
		{
			Ext.getCmp('saveBTN').setDisabled(false);
			Ext.getCmp('saveCSV').setDisabled(false);
		}
	},

	savePdf : function() {
		var s_qryString = "/final/servlet/com.eg.EgPdfDownloadC?";
		var downloadUtils =  Ext.widget('downloadutils');
		downloadUtils.savePDF(s_qryString);
	},
	
	saveCSVFile: function() {
		window.location.href="/final/servlet/com.eg.SaveInCSVFormat?user_language="+publicJSON['userLanguage']+"&filePrefix=saveCsv";
	},
	initializeFields: function() {
		var me = this;
		var executiveForm = this.getFormitems().getForm();
		if (componType == "null")
		{
			me.setValueWithOptionInList(executiveForm, 'compType', publicJSON['ComponentType'],'');
		}
		else
		{
			me.setValueWithOptionInList(executiveForm, 'compType', publicJSON['ComponentType'],componType);
		}

		if (componName == "null")
		{
			me.setValueWithOptionInList(executiveForm, 'compName', publicJSON['ComponentName'],'');
		}
		else
		{

			me.setValueWithOptionInList(executiveForm, 'compName', publicJSON['ComponentName'],componName);
		}
	},

	setValueWithOptionInList: function(form, fieldName, list, value) {
		form.findField(fieldName).getStore().clearFilter(true);
		form.findField(fieldName).getStore().loadRawData(list);
		form.findField(fieldName).suspendEvents(false);
		var valueAssigned = false;
		if (list.length > 0)
		{
		for(var listCounter = 0 ; listCounter < list.length ; listCounter++){
			if(list[listCounter].valueField == value && !Ext.isEmpty(value) && value != null){
				form.findField(fieldName).setValue(value);
				valueAssigned = true;
			}
		}
		}
		if(!valueAssigned){
			form.findField(fieldName).setValue(list[0].valueField);
		}
		form.findField(fieldName).resumeEvents();
	},

	afterMainRender: function() {
		Ext.getCmp('saveBTN').setDisabled(true);
		Ext.getCmp('saveCSV').setDisabled(true);
		var hasCmp = publicJSON['hasCmp'];
		if (hasCmp == 'Yes')
		{
			this.initializeFields();
			Ext.getCmp('NoCompAvailable').hide();
			Ext.getCmp('mainCtnr').show();
		}
		else
		{
			Ext.getCmp('NoCompAvailable').show();
			Ext.getCmp('mainCtnr').hide();
		}

		if ((componType != null && !Ext.isEmpty(componType)) && (componName != null && !Ext.isEmpty(componName)) && (isBack != null && !Ext.isEmpty(isBack) && isBack == "submit"))
		{
			Ext.getCmp('saveBTN').setDisabled(false);
			Ext.getCmp('saveCSV').setDisabled(false);
			Ext.select('#loadData').set({src: "/final/admin/EgTestConfigParameters.jsp?componentType="+encodeURIComponent(componType)+"&componentName="+encodeURIComponent(componName)+"&requestFor=PAGE&fromExt=true&date="+new Date().getTime()});
		}
	}

});



