Ext.define('TestConfigurationView.controller.Main',{
	extend: 'Ext.app.Controller',
	refs:[
		{selector:'main', ref:'main'}
	],
	init:function(){
		me = this;
		this.control({
			'main':
			{
				'afterrender': this.afterMainRender
			},
			'main combo[id="componentType"]': {
				'select': this.compTypeChangeEvent
			},
			'main combo[id="testType"]': {
				'select': this.testTypeChangeEvent
			},
			'main combo[id="testName"]': {
				'select': this.testNameChangeEvent
			},
			'main  button[id="saveCSVTestStatus"]':
			{
				'click': this.saveInCSVTestStatus
			}
		});
	},

	afterMainRender: function()
	{
		var urlStr = '';
		if (!Ext.isEmpty(compType))
		{
			urlStr = urlStr+'&componentType='+compType;
		}
		if (!Ext.isEmpty(testType))
		{
			urlStr = urlStr+'&testType='+testType;
		}
		if (!Ext.isEmpty(testName))
		{
			urlStr = urlStr+'&testName='+testName;
		}

		Ext.Ajax.request({
			url: 'TestConfigurationView/data/EgTestConfigurationViewJson.jsp?'+urlStr,
			method: 'POST',
			timeout: 120000,
			scope: this,
			success: function(response)
			{
				if (response.status == 200 && !Ext.isEmpty(response.responseText)) 
				{
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);

					var isConfigSupported = publicJson['isConfigSupported'];
					var selectedCompType = publicJson['selectedCompType'];
					var selectedTestType = publicJson['selectedTestType'];
					var testNameStr = publicJson['testName'];
					var componentTypeStr = publicJson['componentType'];

					if (isConfigSupported)
					{
						Ext.getCmp('testType').show();
						if (!Ext.isEmpty(selectedTestType))
						{
							Ext.getCmp('testType').setValue(selectedTestType);
						}
						else
						{
							Ext.getCmp('testType').setValue('PerformanceTest');
						}
					}
					else
					{
						Ext.getCmp('testType').hide();
					}
					Ext.getCmp('componentType').getStore().clearFilter(true);
					Ext.getCmp('componentType').getStore().loadRawData(publicJson['compTypeArr']);
					Ext.getCmp('testName').getStore().clearFilter(true);
					Ext.getCmp('testName').getStore().loadRawData(publicJson['testNameArr']);
					if ( !Ext.isEmpty( selectedCompType ) )
					{
						Ext.getCmp('componentType').setValue(selectedCompType);
						Ext.getCmp('componentType').fireEvent('select', Ext.getCmp('componentType'));
					}
					else
					{
						Ext.getCmp('componentType').setValue(publicJson['compTypeArr'][0].valueField);
						Ext.getCmp('testName').setValue(publicJson['testNameArr'][0].valueField);
					}
					if (Ext.isEmpty(testNameStr)|| testNameStr == '-1' || Ext.isEmpty(componentTypeStr) || componentTypeStr == '-1')
					{
						Ext.getCmp('testStatusTab').hide();
						Ext.getCmp('componentGrid').hide();
						Ext.getCmp('saveCSVTestStatus').disable();
					}
				}
			},
			failure: function()
			{
			}
		});
	},

	compTypeChangeEvent: function()
	{
		var isConfigSupported = publicJson['isConfigSupported'];
		var compTypeVal = Ext.getCmp('componentType').getValue();
		var testTypeVal = '';
		if (isConfigSupported)
		{
			testTypeVal = Ext.getCmp('testType').getValue();
		}
		if(Ext.isEmpty(compTypeVal))
		{
			this.afterMainRender();
		}
		else if(!Ext.isEmpty(compTypeVal))
		{
			if (!Ext.isEmpty(testType))
			{
				testTypeVal = testType;
			}
			if (!Ext.isEmpty(compType) && !Ext.isEmpty(compTypeVal))
			{
				if (compType != compTypeVal)
				{
					testName = '';
				}
			}
			compType = compTypeVal;
			Ext.Ajax.request({
				url:'TestConfigurationView/data/EgTestConfigurationViewJson.jsp?componentType='+encodeURIComponent(compTypeVal)+'&testType='+encodeURIComponent(testTypeVal),
				method:'post',
				scope:this,
				async: false,
				success:function(response)
				{
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					Ext.getCmp('testName').getStore().removeAll();
					Ext.getCmp('testName').getStore().clearFilter(true);
					Ext.getCmp('testName').getStore().loadRawData(publicJson['testNameArr']);
					var selectedTestType = publicJson['selectedTestType'];
					var isConfigSupported = publicJson['isConfigSupported'];
					if (!Ext.isEmpty(testName))
					{
						Ext.getCmp('testName').setValue(testName);
						Ext.getCmp('testName').fireEvent('select', Ext.getCmp('testName'));
					}
					else
					{
						Ext.getCmp('testName').setValue(publicJson['testNameArr'][0].valueField);
					}

					if (isConfigSupported)
					{
						if (!Ext.isEmpty(selectedTestType))
						{
							Ext.getCmp('testType').setValue(selectedTestType);
						}
						else
						{
							Ext.getCmp('testType').setValue('PerformanceTest');
						}
					}

					var testNameStr = publicJson['testName'];
					var componentTypeStr = publicJson['componentType'];
					if (Ext.isEmpty(testNameStr)|| testNameStr == '-1' || Ext.isEmpty(componentTypeStr) || componentTypeStr == '-1')
					{
						Ext.getCmp('testStatusTab').hide();
						Ext.getCmp('componentGrid').hide();
						Ext.getCmp('saveCSVTestStatus').disable();
					}
				}
			});
		}
	},
	testTypeChangeEvent: function()
	{
		var compTypeVal = Ext.getCmp('componentType').getValue();
		var testNameVal = Ext.getCmp('testName').getValue();
		var testTypeVal = Ext.getCmp('testType').getValue();
		
		if(Ext.isEmpty(compTypeVal) && Ext.isEmpty(testNameVal))
		{
			this.afterMainRender();
		}
		else if(!Ext.isEmpty(compTypeVal)  && Ext.isEmpty(testNameVal))
		{
			this.compTypeChangeEvent();
		}
		else
		{
			testType = testTypeVal;
			Ext.Ajax.request({
				url:'TestConfigurationView/data/EgTestConfigurationViewJson.jsp?componentType='+encodeURIComponent(compTypeVal)+'&testType='+encodeURIComponent(testTypeVal),
				method:'post',
				scope:this,
				async:false,
				success:function(response)
				{
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					Ext.getCmp('testName').getStore().removeAll();
					Ext.getCmp('testName').getStore().clearFilter(true);
					Ext.getCmp('testName').getStore().loadRawData(publicJson['testNameArr']);
					var selectedTestName = publicJson['selectedTestName'];
					if ( !Ext.isEmpty( selectedTestName ) )
					{
						Ext.getCmp('testName').setValue(selectedTestName);
						Ext.getCmp('testName').fireEvent('select', Ext.getCmp('testName'));
					}
					else
					{
						Ext.getCmp('testName').setValue(publicJson['testNameArr'][0].valueField);
					}
					Ext.getCmp('testStatusTab').hide();
					Ext.getCmp('componentGrid').hide();
					Ext.getCmp('saveCSVTestStatus').disable();
				}
			});
		}
	},
	testNameChangeEvent: function()
	{
		var isConfigSupported = publicJson['isConfigSupported'];
		var compTypeVal = Ext.getCmp('componentType').getValue();
		var testTypeVal = Ext.getCmp('testType').getValue();
		var testNameVal = Ext.getCmp('testName').getValue();

		var urlValue  = 'TestConfigurationView/data/EgTestConfigurationViewJson.jsp?';
		if(Ext.isEmpty(compTypeVal))
		{
			this.afterMainRender();
		}
		else if(!Ext.isEmpty(compTypeVal) && Ext.isEmpty(testNameVal))
		{
			this.compTypeChangeEvent();
		}
		else
		{
			if (isConfigSupported)
			{
				if (!Ext.isEmpty(testType))
				{
					testTypeVal = testType;
				}
				urlValue += 'componentType='+encodeURIComponent(compTypeVal)+'&testName='+encodeURIComponent(testNameVal)+'&testType='+encodeURIComponent(testTypeVal);
			}
			else
			{
				urlValue  += 'componentType='+encodeURIComponent(compTypeVal)+'&testName='+encodeURIComponent(testNameVal);
			}
			testName = testNameVal;
			Ext.Ajax.request({
				url:urlValue,
				method:'POST',
				scope:this,
				async:false,
				success:function(response)
				{
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					var isConfigSupported = publicJson['isConfigSupported'];
					var testNameStr = publicJson['testName'];
					var componentTypeStr = publicJson['componentType'];
					Ext.getCmp('testStatusTab').hide();
					Ext.getCmp('componentGrid').hide();
					if (Ext.isEmpty(testNameStr)|| testNameStr == '-1' || Ext.isEmpty(componentTypeStr) || componentTypeStr == '-1')
					{
						Ext.getCmp('saveCSVTestStatus').disable();
					}
					else
					{
						Ext.getCmp('saveCSVTestStatus').enable();
					}
					if (!Ext.isEmpty(testNameVal) && testNameVal != '-1')
					{
						me.gotoBuildContainer();
					}
				}
			});
		}
	},

	gotoBuildContainer: function()
	{
		Ext.getCmp('testStatusTab').hide();
		Ext.getCmp('saveCSVTestStatus').disable();
		var testName = publicJson['testName'];
		var componentTypeStr = publicJson['componentType'];
		var testNameStr = publicJson['testName'];
		var agentBasedComponents = publicJson['agentBasedComponents'];
		var agentLessComponents = publicJson['agentLessComponents'];
		var externalComponents = publicJson['externalComponents'];

		var agentBasedLen = agentBasedComponents.length;
		var agentLessLen = agentLessComponents.length;
		var externalAgentLen = externalComponents.length;

		Ext.getCmp('testStatusTab').removeAll();
		Ext.getCmp('componentGrid').removeAll();
		if (agentBasedLen == 0 && agentLessLen == 0)
		{
			Ext.getCmp('testStatusTab').hide();
			Ext.getCmp('componentGrid').show();
		}
		else if (agentBasedLen > 0 && agentLessLen == 0)
		{
			var gridArray = me.loadGrid(agentBasedComponents);
			Ext.getCmp('componentGrid').show();
			Ext.getCmp('saveCSVTestStatus').enable();
			Ext.getCmp('componentGrid').add({
				layout: {
					type: 'vbox',
					align: 'stretch'
				},
				flex: 1,
				items: gridArray
			});
		}
		else if (agentBasedLen == 0 && agentLessLen > 0)
		{
			Ext.getCmp('componentGrid').show();
			Ext.getCmp('saveCSVTestStatus').enable();
			var gridArray = me.loadGrid(agentLessComponents);
			Ext.getCmp('componentGrid').add({
				layout: {
					type: 'vbox',
					align: 'stretch'
				},
				flex: 1,
				items: gridArray
			});
		}
		else if (agentBasedLen > 0 && agentLessLen > 0)
		{
			Ext.getCmp('componentGrid').hide();
			Ext.getCmp('testStatusTab').show();
			var gridArray = me.loadGrid(agentBasedComponents);
			me.createTab(gridArray,'agentBased','Agent based')
			var gridArray1 = me.loadGrid(agentLessComponents);
			me.createTab(gridArray1,'agentLess','Agentless');
		}
		if (externalAgentLen > 0)
		{
			Ext.getCmp('componentGrid').show();
			Ext.getCmp('saveCSVTestStatus').enable();
			var gridArray = me.loadGrid(externalComponents);
			Ext.getCmp('componentGrid').add({
				layout: {
					type: 'vbox',
					align: 'stretch'
				},
				flex: 1,
				items: gridArray
			});
		}
	},

	loadGrid: function(components)
	{
		var activePage = 1;
		var fieldArray = new Array();
		var mainColArray=new Array();
		var fieldColumn = components[0];
		var lockedGridFlag = false;
		var dynWidth = 0;
		var valueCount = 1;
		for (var value in fieldColumn)
		{
			fieldArray.push(value);
			if (valueCount == 1)
			{
				mainColArray.push({
					header: value,
					sortable: true,
					dataIndex: value,
					locked: true,
					width: 220,
					doSort: function(state)
					{
						var ds = this.up('#compGridId').store;
						var field = this.getSortParam();
						ds.sort({
							property: field,
							direction: state,
							sorterFn: function(v1, v2)
							{
								v1 = v1.get(field).toLowerCase();
								v2 = v2.get(field).toLowerCase();

								if(!isNaN(v1) && !isNaN(v2))
								{
									v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
									v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);
									if (state=='ASC')
									{
										v1= isNaN(v1) ? 999999 : v1;
										v2= isNaN(v2) ? 999999 : v2;
									}
									else
									{
										v1= isNaN(v1) ? 0 : v1;
										v2= isNaN(v2) ? 0 : v2;
									}
								}
								else if(!isNaN(new Date(v1)) && !isNaN(new Date(v2)))
								{
									v2=new Date(v2).getTime(); 
									v1=new Date(v1).getTime(); 
								}
								// transform v1 and v2 here
								return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
							}
						});
					},
				});
				valueCount++;
			}
			else
			{
				mainColArray.push({
					header: value,
					sortable: true,
					dataIndex: value,
					minWidth: 200,
					flex: 1
				});
			}
		}

		var isPagingHidden;
		if (components!=undefined && components.length<=pageSize)
		{
			isPagingHidden=true;
		}
		else
		{
			isPagingHidden=false;
		}

		var storeObj = Ext.create('Ext.data.Store', {
			fields: fieldArray,
			proxy: 
			{
				type: 'pagingmemory',
				reader: 
				{
					type: 'json', root: 'data', totalProperty: 'total'
				}
			},
			pageSize: pageSize,
			data: components,
			autoLoad: true
		});

		var gridpanel = Ext.widget('customgrid',
		{
			store: storeObj,
			ui: 'newGridPanel withHeader',
			border: true,
			queryMode: 'local',
			flex: 1,
			margin: '10 10 10 10',
			columns: mainColArray,
			itemId: 'compGridId',
			popUpData: 'noToolTip',
			enableColumnResize: false,
			listeners:{
				sortchange: function(ct, column, e, t, eOpts ){
					this.getStore().loadPage(activePage);
				}
			},
			dockedItems:[{
				xtype: 'pagingtoolbar',
				cls: 'newPagination',
				dock: 'bottom',
				displayInfo: true,
				store: storeObj,
				hidden: isPagingHidden,
				displayMsg: 'Displaying topics {0} - {1} of {2}',
				emptyMsg: "No topics to display",
				listeners: {
					change : function(thisd, params)
					{  
						activePage = params.currentPage;
					}
				}
			}]
		});
		var gridArray = new Array();
		gridArray.push(gridpanel);
		return gridArray;
	},

	createTab: function(gridArray, idVal, title)
	{
		var testStatusTab = Ext.getCmp('testStatusTab');
		testStatusTab.show();
		Ext.getCmp('saveCSVTestStatus').enable();
		testStatusTab.add({
			title: title,
			itemId: idVal,
			layout: {
				type: 'vbox',
				align: 'stretch'
			},
			flex: 1,
			items: gridArray,
			
		});
		testStatusTab.setActiveTab(0);
	},

	saveInCSVTestStatus: function()
	{
		var userLanguage = publicJson['userLanguage'];
		window.location.href="/final/servlet/com.eg.SaveInCSVFormat?user_language="+userLanguage+"&filePrefix=saveCsv";
	}
});



