Ext.define('TestConfigurationView.view.Main',{
	extend: 'Ext.panel.Panel',
	alias: 'widget.main',
	id: 'main',
	title: pageName,
	cls: 'outerpanel',
	margin: '8 8 0 8',

	requires:[
		'Ext.ux.ItemSelectorSm',
		'utilities.ScrollCombo',
		'utilities.CustomGrid',
		'Ext.ux.data.PagingMemoryProxy'
	],

	fieldDefaults: {
		labelAlign: 'top', 
		labelSeparator: ' '
	},

	layout: {
		type: 'vbox',
		align: 'stretch'
	},
	tools: [
		{
			xtype:'button',
			id: 'saveCSVTestStatus',
			iconCls:'iconCsv',
			style:{
				background:'none',border:'0px'
			},
			listeners:{
				afterrender:function(){
					Ext.create("Ext.tip.ToolTip",{
						target:this.id,
						anchor:"top",
						cls:"yellowTip",
						trackMouse:true,
						html:"CSV"
					});
				}
			}
		}
	],

	dockedItems: [{
		xtype: 'toolbar',
		cls:'adminHeadInfoText',
		dock: 'top',
		layout:{pack:'center'},
		width:'100%',
		height: 25,
		padding: 3,
		items: [
			{
				xtype: 'component',
				html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp '+pageDesc+'</center>'
			}
		]
	}],

	items:[
		{
			xtype:'container',
			layout: {
				type: 'vbox',
				align: 'center',
				pack: 'center'
			},
			items:[
				{
					xtype: 'container',
					layout: {
						type: 'hbox',
						pack: 'center'
					},
					margin: '10 10 10 10',
					cls: 'formOuter',
					padding: 5,
					defaults: {
						labelAlign: 'top',
						labelSeparator:' ',
						margin: 5,
						width: 250
					},
					items: [
						{
							xtype: 'scrollcombo',
							cls: 'dropdown',
							id: 'componentType',
							name: 'componentType',
							fieldLabel: cmpType,
							store: new Ext.data.Store(
							{
								fields: ['displayField','valueField'],
								data: []
							}),
							displayField: 'displayField',
							valueField: 'valueField',
							//editable: false,
							queryMode: 'local'
						},
						{
							xtype: 'scrollcombo',
							cls: 'dropdown',
							id: 'testType',
							name: 'testType',
							fieldLabel: tType,
							store: new Ext.data.Store(
							{
								fields: ['displayField','valueField'],
								data: [
									{'displayField':'Performance', 'valueField':'PerformanceTest'},
									{'displayField':'Configuration', 'valueField':'ConfigurationTest'}
								]
							}),
							displayField: 'displayField',
							valueField: 'valueField',
							value: 'PerformanceTest',
							editable: false,
							queryMode: 'local',
							//hidden: true
						},
						{
							xtype: 'scrollcombo',
							cls: 'dropdown',
							id: 'testName',
							name: 'testName',
							fieldLabel: tName,
							store: new Ext.data.Store(
							{
								fields: ['displayField','valueField'],
								data: []
							}),
							displayField: 'displayField',
							valueField: 'valueField',
							//editable: false,
							queryMode: 'local'
						}
					]
				}
			]
		},
		{
			xtype: 'tabpanel',
			cls:'tablayout border_alt',
			style: {'box-shadow': 'none','-webkit-box-shadow': 'none','-moz-box-shadow': 'none'},
			plain: true,
			tabPosition: 'top',
			flex: 1,
			defaults: {
				autoScroll: true
			},
			id: 'testStatusTab',
			margin:10
		},
		{
			xtype: 'panel',
			id: 'componentGrid',
			margin: '0 0 10 0',
			layout: {
				type: 'vbox',
				align: 'stretch'
			},
			flex: 1,
			html: '<table border="0" width="100%" height="300px"><tr><td align="center" valign="middle"><div class="iconInformation"></div><div class="commonErrorMsgText" id="noUsersAlrtDiv">'+noDataFound+'</div></td></tr></table>'
		}
	]
});



