<%@ include file = "../../EgTrackerAJSON.jsp" %>

<%@ page import = "com.eg.EgRoleInfo" %>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgUsersInfo"%>
<%@ page import = "com.eg.EgSpecsInfo" %>
<%@ page import = "com.eg.EgExternalInfo" %>
<%@ page import = "com.eg.EgDiscInfo" %>
<%@ page import = "com.eg.EgCorrectiveScripts" %>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "java.text.*"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter" %>
<%@ page import = "net.sf.json.*"%>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<%
	JSONObject rootJson = new JSONObject();

	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}
	rootJson.put("userLanguage",userLanguage);
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	List listComponentTypes = Arrays.asList(ri.getServerTypes());

	EgDiscInfo discInfo = new EgDiscInfo("manager");
	EgAgentInfo agentInfo = new EgAgentInfo("manager");
	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
	EgExternalInfo externalInfo = new EgExternalInfo("manager");
	EgCorrectiveScripts egCorrectiveScript = new EgCorrectiveScripts();

	String componentType = request.getParameter("componentType");
	componentType = (componentType != null)?componentType:"";

	String testType = request.getParameter("testType");
	testType = (StringUtils.isNull(testType))?"PerformanceTest":testType;

	String pfSelected = "";
	String cfSelected = "";
	if (testType.equalsIgnoreCase("PerformanceTest"))
	{
		pfSelected = "selected";
	}
	else
	{
		cfSelected = "selected";
	}

	String testName = request.getParameter("testName");
	testName = (testName != null)?testName:"";
	testName = testName.trim();

	rootJson.put("componentType",componentType);
	rootJson.put("testName",testName);

	boolean isConfigSupported = EgInstallInfo.isConfigSupported;

	//ensure whether the user is configuration management enabled
	if (_user != null && isConfigSupported)
	{
		EgUserRole userRole = _user.getUserRole();
		isConfigSupported = userRole.hasAnyConfigRole(EgUserPermission.CONFIG);
	}
	rootJson.put("isConfigSupported",isConfigSupported);

	ArrayList aListEnabledTestForCompType = new ArrayList();
	ArrayList aListTempEnabledTests = null;
	if (!componentType.equals("") && !componentType.equals("-1"))
	{
		if (testType.equals("PerformanceTest"))
		{
			aListEnabledTestForCompType = egSpecs.getEnabledTests(componentType,false);
		}
		else
		{
			aListEnabledTestForCompType = egSpecs.getEnabledTests(componentType,true);
		}


		aListTempEnabledTests = new ArrayList(aListEnabledTestForCompType);
		aListEnabledTestForCompType = sorter.getSortedTestList(aListEnabledTestForCompType);
	}

	String selectedCompType = "";
	listComponentTypes = sorter.getSortedCompTypeList(listComponentTypes);
	if (isConfigSupported)
	{
		JSONObject compTypeObj = new JSONObject();
		JSONArray compTypeArr = new JSONArray();

		int compTypeList_len = listComponentTypes.size();
		if (compTypeList_len > 0)
		{
			compTypeObj.put("valueField","-1");
			compTypeObj.put("displayField",_mapping.getTextDescription("admin.common.Choose a component type"));
			compTypeArr.add(compTypeObj);
		}
		else
		{
			compTypeObj.put("valueField","-1");
			compTypeObj.put("displayField",_mapping.getTextDescription("admin.common.Not Applicable"));
			compTypeArr.add(compTypeObj);
		}

		for (int j=0; j<compTypeList_len; j++)
		{
			EgName nameObj = (EgName)listComponentTypes.get(j);
			String actualname = nameObj.getActualName();
			String localname = nameObj.getLocalName();
			compTypeObj.put("valueField",actualname);
			compTypeObj.put("displayField",localname);
			compTypeArr.add(compTypeObj);

			if (actualname.equals(componentType))
			{
				selectedCompType = localname;
				rootJson.put("selectedCompType",actualname);
			}
		}
		rootJson.put("compTypeArr",compTypeArr);

		JSONObject testTypeObj = new JSONObject();
		JSONArray testTypeArr = new JSONArray();
		testTypeObj.put("valueField","PerformanceTest");
		testTypeObj.put("displayField",_mapping.getTextDescription("admin.server.Performance"));
		testTypeArr.add(testTypeObj);
		testTypeObj = new JSONObject();
		testTypeObj.put("valueField","ConfigurationTest");
		testTypeObj.put("displayField",_mapping.getTextDescription("admin.server.Configuration"));
		testTypeArr.add(testTypeObj);
		if (!StringUtils.isNull(pfSelected) && pfSelected.equals("selected"))
		{
			rootJson.put("selectedTestType","PerformanceTest");
		}
		else
		{
			rootJson.put("selectedTestType","ConfigurationTest");
		}
		rootJson.put("testTypeArr",testTypeArr);

		JSONObject testNameObj = new JSONObject();
		JSONArray testNameArr = new JSONArray();
		int testNameList_len = aListEnabledTestForCompType.size();

		if (testNameList_len > 0)
		{
			testNameObj.put("valueField","-1");
			testNameObj.put("displayField",_mapping.getTextDescription("admin.common.Choose a test name"));
			testNameArr.add(testNameObj);
		}
		else
		{
			testNameObj.put("valueField","-1");
			testNameObj.put("displayField",_mapping.getTextDescription("admin.common.Not Applicable"));
			testNameArr.add(testNameObj);
		}

		for (int i=0; i<testNameList_len; i++)
		{
			EgName nameObj = (EgName)aListEnabledTestForCompType.get(i);
			String strTestName = nameObj.getActualName();
			String strTestDisplayValue = nameObj.getLocalName();
			testNameObj.put("valueField",strTestName);
			testNameObj.put("displayField",strTestDisplayValue);
			testNameArr.add(testNameObj);
			if (testName != null && strTestName.equals(testName))
			{
				rootJson.put("selectedTestName",strTestName);
			}
		}
		rootJson.put("testNameArr",testNameArr);
	}
	else
	{
		JSONObject compTypeObj = new JSONObject();
		JSONArray compTypeArr = new JSONArray();

		int compTypeList_len = listComponentTypes.size();

		if (compTypeList_len > 0)
		{
			compTypeObj.put("valueField","-1");
			compTypeObj.put("displayField",_mapping.getTextDescription("admin.common.Choose one"));
			compTypeArr.add(compTypeObj);
		}
		else
		{
			compTypeObj.put("valueField","-1");
			compTypeObj.put("displayField",_mapping.getTextDescription("admin.common.Not Applicable"));
			compTypeArr.add(compTypeObj);
		}

		for (int j=0; j<compTypeList_len; j++)
		{
			EgName nameObj = (EgName)listComponentTypes.get(j);
			String actualname = nameObj.getActualName();
			String localname = nameObj.getLocalName();
			compTypeObj.put("valueField",actualname);
			compTypeObj.put("displayField",localname);
			compTypeArr.add(compTypeObj);

			if (actualname.equals(componentType))
			{
				selectedCompType = localname;
				rootJson.put("selectedCompType",actualname);
			}
		}
		rootJson.put("compTypeArr",compTypeArr);

		JSONObject testNameObj = new JSONObject();
		JSONArray testNameArr = new JSONArray();
		int testNameList_len = aListEnabledTestForCompType.size();

		if (testNameList_len > 0)
		{
			testNameObj.put("valueField","-1");
			testNameObj.put("displayField",_mapping.getTextDescription("admin.common.Choose one"));
			testNameArr.add(testNameObj);
		}
		else
		{
			testNameObj.put("valueField","-1");
			testNameObj.put("displayField",_mapping.getTextDescription("admin.common.Not Applicable"));
			testNameArr.add(testNameObj);
		}

		for (int i=0; i<testNameList_len; i++)
		{
			EgName nameObj = (EgName)aListEnabledTestForCompType.get(i);
			String strTestName = nameObj.getActualName();
			String strTestDisplayValue = nameObj.getLocalName();
			testNameObj.put("valueField",strTestName);
			testNameObj.put("displayField",strTestDisplayValue);
			testNameArr.add(testNameObj);
			if (testName != null && strTestName.equals(testName))
			{
				rootJson.put("selectedTestName",strTestName);
			}
		}
		rootJson.put("testNameArr",testNameArr);
	}

	if (!componentType.equals("") && !componentType.equals("-1") && 
		!testName.equals("") && !testName.equals("-1") && 
		!testType.equals(""))
	{
		JSONArray externalJsonArr = new JSONArray();
		JSONArray remoteJsonArr = new JSONArray();
		JSONArray agentBasedJsonArr = new JSONArray();

		TreeMap agentBasedMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
		TreeMap agentLessMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
		TreeMap externalMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);

		IniFile egAgentIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini");

		String[] compNameArr = discInfo.getAllServersOfType(componentType);
		for (int i=0; i<compNameArr.length; i++)
		{
			String componentStr = compNameArr[i];
			int ser_idx = componentStr.indexOf(":");
			String componentName = componentStr.substring(ser_idx+1);
			int comp_idx = componentName.indexOf(":");
			String nickName = componentName.substring(0,comp_idx);

			List listAgents = getAgents(componentName);
			String agentNickName = getAgentNickName(componentType,testName,listAgents);

			boolean isExternalAgent = egCorrectiveScript.isExternalAgentForComp(nickName, componentType);
			boolean isAgentLessComp = agentInfo.isAgentlessServer(nickName, componentType);
			if (isExternalAgent)
			{
				String[] allVariablesArr = egAgentIni.getVariables(agentNickName);
				String resultantPattern = getResultantPattern(componentType,componentName,testName,nickName,allVariablesArr);

				if (resultantPattern == null)
				{
					continue;
				}

				String valueStr = egAgentIni.getValue(agentNickName, resultantPattern);
				LinkedHashMap paramMap = new LinkedHashMap();
				if (componentName.indexOf(":NULL") != -1)
				{
					paramMap = getModifiedValue(valueStr,nickName,agentNickName);
				}
				else
				{
					paramMap = getModifiedValue(valueStr,componentName,agentNickName);
				}
				externalMap.put(nickName, paramMap);
			}
			else if (isAgentLessComp)
			{
				String[] allVariablesArr = egAgentIni.getVariables(agentNickName);
				String resultantPattern = getResultantPattern(componentType,componentName,testName,nickName,allVariablesArr);

				if (resultantPattern == null)
				{
					continue;
				}

				String valueStr = egAgentIni.getValue(agentNickName, resultantPattern);
				LinkedHashMap paramMap = new LinkedHashMap();
				if (componentName.indexOf(":NULL") != -1)
				{
					paramMap = getModifiedValue(valueStr,nickName,agentNickName);
				}
				else
				{
					paramMap = getModifiedValue(valueStr,componentName,agentNickName);
				}
				agentLessMap.put(nickName, paramMap);
			}
			else
			{
				String[] allVariablesArr = egAgentIni.getVariables(agentNickName);
				String resultantPattern = getResultantPattern(componentType,componentName,testName,nickName,allVariablesArr);
				if (resultantPattern == null)
				{
					continue;
				}
				String valueStr = egAgentIni.getValue(agentNickName, resultantPattern);
				LinkedHashMap paramMap = new LinkedHashMap();
				if (componentName.indexOf(":NULL") != -1)
				{
					paramMap = getModifiedValue(valueStr,nickName,agentNickName);
				}
				else
				{
					paramMap = getModifiedValue(valueStr,componentName,agentNickName);
				}
				agentBasedMap.put(nickName, paramMap);
			}
		}

		int external_id = 1;
		int agentBased_id = 1;
		int agentLess_id = 1;
		String externalColStr = "";
		String agentBasedColStr = "";
		String agentLessColStr = "";
		ArrayList externalList = new ArrayList();
		ArrayList agentBasedList = new ArrayList();
		ArrayList agentLessList = new ArrayList();

		if (externalMap != null && externalMap.size() > 0)
		{
			Iterator externalItr = (Iterator) externalMap.keySet().iterator();
			while (externalItr.hasNext())
			{
				String nickName = (String) externalItr.next();
				LinkedHashMap paramMap = (LinkedHashMap) externalMap.get(nickName);
				JSONObject jsonObj = new JSONObject();
				if (paramMap != null && paramMap.size() > 0)
				{
					String externalValStr = "";
					Iterator itr = (Iterator) paramMap.keySet().iterator();
					while (itr.hasNext())
					{
						String paramNameStr = (String) itr.next();
						if (external_id == 1)
						{
							externalColStr = externalColStr+","+paramNameStr;
						}
						String paramNameVal = (String) paramMap.get(paramNameStr);
						jsonObj.put(paramNameStr,paramNameVal);
						if (paramNameVal.indexOf(",") > -1)
						{
							paramNameVal = "\""+paramNameVal+"\"";
						}
						externalValStr = externalValStr+","+paramNameVal;
					}
					external_id++;
					externalList.add(externalValStr.substring(1));
				}
				externalJsonArr.add(jsonObj);
			}
		}
		else 
		{

			if (agentLessMap != null && agentLessMap.size() > 0)
			{
				Iterator agentLessItr = (Iterator) agentLessMap.keySet().iterator();
				while (agentLessItr.hasNext())
				{
					String nickName = (String) agentLessItr.next();
					LinkedHashMap paramMap = (LinkedHashMap) agentLessMap.get(nickName);
					JSONObject jsonObj = new JSONObject();
					if (paramMap != null && paramMap.size() > 0)
					{
						String agentLessValStr = "";
						Iterator itr = (Iterator) paramMap.keySet().iterator();
						while (itr.hasNext())
						{
							String paramNameStr = (String) itr.next();
							if (agentLess_id == 1)
							{
								agentLessColStr = agentLessColStr+","+paramNameStr;
							}
							String paramNameVal = (String) paramMap.get(paramNameStr);
							jsonObj.put(paramNameStr,paramNameVal);
							if (paramNameVal.indexOf(",") > -1)
							{
								paramNameVal = "\""+paramNameVal+"\"";
							}
							agentLessValStr = agentLessValStr+","+paramNameVal;
						}
						agentLess_id++;
						agentLessList.add(agentLessValStr.substring(1));
					}
					remoteJsonArr.add(jsonObj);
				}
			}

			if (agentBasedMap != null && agentBasedMap.size() > 0)
			{
				Iterator agentBasedItr = (Iterator) agentBasedMap.keySet().iterator();
				while (agentBasedItr.hasNext())
				{
					String nickName = (String) agentBasedItr.next();
					LinkedHashMap paramMap = (LinkedHashMap) agentBasedMap.get(nickName);
					JSONObject jsonObj = new JSONObject();
					if (paramMap != null && paramMap.size() > 0)
					{
						String agentBasedValStr = "";
						Iterator itr = (Iterator) paramMap.keySet().iterator();
						while (itr.hasNext())
						{
							String paramNameStr = (String) itr.next();
							if (agentBased_id == 1)
							{
								agentBasedColStr = agentBasedColStr+","+paramNameStr;
							}
							String paramNameVal = (String) paramMap.get(paramNameStr);
							jsonObj.put(paramNameStr, paramNameVal);
							if (paramNameVal.indexOf(",") > -1)
							{
								paramNameVal = "\""+paramNameVal+"\"";
							}
							agentBasedValStr = agentBasedValStr+","+paramNameVal;
						}
						agentBased_id++;
						agentBasedList.add(agentBasedValStr.substring(1));
					}
					agentBasedJsonArr.add(jsonObj);
				}
			}
		}

		String testTypeDescription = "";
		if (testType.equals("PerformanceTest"))
		{
			testTypeDescription = _mapping.getTextDescription("admin.server.Performance");
		}
		else
		{
			testTypeDescription = _mapping.getTextDescription("admin.server.Configuration");
		}

		String uiFile = "eg_ui.ini";
		String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
		IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
		String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
		SimpleDateFormat formatter = new SimpleDateFormat(currentDateFormat+" "+"HH:mm:ss");
		Date currentDateTime = new Date();
		String dateString = formatter.format(currentDateTime);

		EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(dateString,_user);
		dateString = timeZoneConverter.getDateTime();

		if (dateString != null && dateString.indexOf(",") != -1)
		{
			dateString = dateString.replace(",","");
		}

		List csvData = new ArrayList();
		csvData.add("Test Configuration Report");
		csvData.add("Generated on "+dateString);
		csvData.add("Component type:,"+_mapping.getComponentTypeDescription(componentType));
		csvData.add("Test type:,"+testTypeDescription);
		csvData.add("Test name:,"+_mapping.getTestDescription(testName));

		int externalList_len = externalList.size();
		if (!StringUtils.isNull(externalColStr) && externalList != null && externalList_len > 0)
		{
			csvData.add("");
			csvData.add(externalColStr.substring(1));
			csvData.add("");
			for (int z=0; z<externalList_len; z++)
			{
				String rowValStr = (String) externalList.get(z);
				csvData.add(rowValStr);
			}
		}

		int agentBasedList_len = agentBasedList.size();
		if (!StringUtils.isNull(agentBasedColStr) && agentBasedList != null && agentBasedList_len > 0)
		{
			csvData.add("");
			csvData.add(agentBasedColStr.substring(1));
			csvData.add("");
			for (int z=0; z<agentBasedList_len; z++)
			{
				String rowValStr = (String) agentBasedList.get(z);
				csvData.add(rowValStr);
			}
		}

		int agentLessList_len = agentLessList.size();
		if (!StringUtils.isNull(agentLessColStr) && agentLessList !=null && agentLessList_len > 0)
		{
			csvData.add("");
			csvData.add(agentLessColStr.substring(1));
			csvData.add("");
			for (int z=0; z<agentLessList_len; z++)
			{
				String rowValStr = (String) agentLessList.get(z);
				csvData.add(rowValStr);
			}
		}

		if (csvData != null && csvData.size() > 0)
		{
			session.setAttribute("list",csvData);
			session.setAttribute("isAuditlogCSV","true");
		}
		rootJson.put("agentBasedComponents",agentBasedJsonArr);
		rootJson.put("agentLessComponents",remoteJsonArr);
		rootJson.put("externalComponents",externalJsonArr);
	}

	if (request.getQueryString() != null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgTestConfigurationView.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgTestConfigurationView.jsp");
	}
	out.println(rootJson.toString());
%>

<%!
	private String getResultantPattern(String componentType,String componentName,String testName,String componentNickName,String[] testVariables)
	{
		String tempResultantPattern = null;
		String specificPattern_A = testName + ":" + componentType + ":" + componentName;
		String specificPattern_B = testName + ":" + componentType + ":" + componentNickName;
		String defaultPattern_A = testName + "::" + componentName;
		String defaultPattern_B = testName + "::" + componentNickName;

		List listTestVariables = Arrays.asList(testVariables);
		if(listTestVariables.contains(specificPattern_A))
		{
			tempResultantPattern = specificPattern_A;
		}
		else if(listTestVariables.contains(specificPattern_B))
		{
			tempResultantPattern = specificPattern_B;
		}
		else if(listTestVariables.contains(defaultPattern_A))
		{
			tempResultantPattern = defaultPattern_A;
		}
		else if(listTestVariables.contains(defaultPattern_B))
		{
			tempResultantPattern = defaultPattern_B;
		}

		return tempResultantPattern;
	}

	private LinkedHashMap getModifiedValue(String agentValue,String nickName,String agentNickName)
	{
		String isautoGenerated = "";
		String testArgs = "";
		String testFreq = "";

		StringTokenizer st = new StringTokenizer(agentValue,",");
		while (st.hasMoreTokens())
		{
			isautoGenerated = st.nextToken().trim();
			testArgs = st.nextToken();
			testFreq = st.nextToken();
		}

		if (isautoGenerated.length() > 0)
		{
			if (isautoGenerated.equalsIgnoreCase("-auto"))
			{
				isautoGenerated = "Default";
			}
			else
			{
				isautoGenerated = "Specific";
			}
		}

		if (testFreq.length() > 0)
		{
			testFreq = testFreq.trim();
			int i_freq = Integer.parseInt(testFreq);
			if (i_freq < 61)
			{
				testFreq = Integer.toString(i_freq)+" "+"secs";
			}
			else if (i_freq > 60 && i_freq < 3600)
			{
				testFreq = Integer.toString(i_freq/60)+" "+"mins";
			}
			else
			{
				i_freq = i_freq/3600;
				if (i_freq > 1)
				{
					testFreq = Integer.toString(i_freq)+" "+"hrs";
				}
				else
				{
					testFreq = Integer.toString(i_freq)+" "+"hr";
				}
			}
		}
		LinkedHashMap parameterMap = new LinkedHashMap();
		EgCorrectiveScripts egCorrectiveScript = new EgCorrectiveScripts();
		parameterMap.put("COMPONENT",nickName);
		parameterMap.put("MEASUREMENT HOST",agentNickName);
		parameterMap.put("TEST PERIOD",testFreq);
		parameterMap.put("TEST STATUS",isautoGenerated);
		IniFile mgrmiscIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_mgrmisc.ini");
		ArrayList testParamList = egCorrectiveScript.getParameterList(testArgs, true);
		int testPramList_len = testParamList.size();
		for (int k=0; k<testPramList_len; k=k+2)
		{
			String paramStr = (String) testParamList.get(k);
			paramStr = paramStr.substring(1);
			String excludedParams = mgrmiscIni.getValue("EXCLUDE_TEST_PARAMS", paramStr);
			if (!StringUtils.isNull(excludedParams))
			{
				if (excludedParams.equalsIgnoreCase(paramStr))
				{
					continue;
				}
			}
			String paramValueStr = (String) testParamList.get(k+1);
			if (paramValueStr.indexOf("|") > -1)
			{
				paramValueStr = StringUtils.replace(paramValueStr,"|",",");
				if (paramValueStr.startsWith("\"") && paramValueStr.endsWith("\""))
				{
					paramValueStr = paramValueStr.substring(1,paramValueStr.length()-1);
				}
			}
			else if (paramValueStr.indexOf("#") > -1)
			{
				paramValueStr = StringUtils.replace(paramValueStr,"#",",");
				if (paramValueStr.startsWith("\"") && paramValueStr.endsWith("\""))
				{
					paramValueStr = paramValueStr.substring(1,paramValueStr.length()-1);
				}
			}
			else if (paramValueStr.indexOf("~#~") > -1)
			{
				paramValueStr = StringUtils.replace(paramValueStr,"~#~",";");
				if (paramValueStr.startsWith("\"") && paramValueStr.endsWith("\""))
				{
					paramValueStr = paramValueStr.substring(1,paramValueStr.length()-1);
				}
			}
			parameterMap.put(paramStr.toUpperCase(),paramValueStr);
		}
		return parameterMap;
	}

	private String getAgentNickName(String componentType,String testName,List listAgents)
	{
		EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
		boolean isExternalTest = egSpecs.isExternalTest(testName,componentType);
		int agentList_len = listAgents.size();
		String agentName = null;
		if (isExternalTest)
		{
			//external agent for external test
			if (listAgents != null && agentList_len > 0 )
			{
				agentName = (String)listAgents.get(1);
			}
		}
		else
		{
			//internal agent or remote agent for host level test and application level test.
			if (listAgents != null && agentList_len > 0 )
			{
				agentName = (String)listAgents.get(0);
			}
		}

		return agentName;
	}

	private List getAgents(String componentName)
	{
		List agentsList = new ArrayList();
		EgExternalInfo egExternalInfo = new EgExternalInfo("manager");
		Hashtable internalAgentMap = egExternalInfo.getInternalAgentMap();
		String componentNickName = componentName.substring(0,componentName.indexOf(":"));
		String agentNickName = "";
		boolean isRemote = false;

		//To fetch the exact agent for the selected component - start
		isRemote = egExternalInfo.isRemoteBased(componentNickName);
		if (isRemote)
		{
			//Agentless
			agentNickName = egExternalInfo.getRemoteAgentForHost(componentNickName);
		}
		else
		{
			//Auto or Manual
			String agentName = egExternalInfo.getAgentFor(componentNickName);

			if (agentName != null) //Manual
			{
				if (internalAgentMap != null && internalAgentMap.containsKey(agentName))
				{
					agentNickName = (String)internalAgentMap.get(agentName);
				}
				else
				{
					agentNickName = agentName;
				}
			}
			else //Auto
			{
				agentNickName = componentNickName;
			}
		}

		//adding an internal agent (or) a remote agent
		agentsList.add(agentNickName);
		//To fetch the exact agent for the selected component - end

		//To fetch the external agent for the selected component type - starts
		boolean hasExternalAgent = egExternalInfo.hasExternalAgent(componentNickName);
		if (hasExternalAgent)
		{
			String extAgents[] = egExternalInfo.getExternalAgentsForHost(componentNickName);
			//adding one or more external agent(s)
			agentsList.addAll(Arrays.asList(extAgents));
		}
		//To fetch the external agent for the selected component type - ends

		return agentsList;
	}
%>



