Ext.define('TestDescriptors.controller.Main',{
	extend: 'Ext.app.Controller',
	refs:[
		{selector:'testdescriptors', ref:'testdescriptors'}
	],
	init:function(){
		main = this;
		this.control({
			'testdescriptors':
			{
				'boxready': this.afterMainRender
			},
			'testdescriptors combo[id="compTypeCombo"]':
			{
				'select': this.compTypeComboLoad
			},
			'testdescriptors combo[id="compNameCombo"]':
			{
				'select': this.compNameComboLoad
			},
			'testdescriptors combo[id="testCombo"]':
			{
				'select': this.testNameComboLoad
			},
			'testdescriptors combo[id="timeLineCombo"]':
			{
				'select': this.timeLineComboLoad
			},
			'testdescriptors button[id="disableDeleteBtn"]':
			{
				'click': this.deleteData
			},
			'testdescriptors button[id="updateBtn"]':
			{
				'click': this.updateData
			},
			'testdescriptors trigger[id="strEnabledSearch"]':
			{
				//'change': this.descriptorSearch
				'change': this.textFieldSearch
			},
			'testdescriptors trigger[id="strDisabledSearch"]':
			{
				'change': this.textFieldSearch
			}
		});
	},
	textFieldSearch: function (type) 
	{
		var compTypeVal = Ext.getCmp('compTypeCombo').getValue();
		var compNameVal = Ext.getCmp('compNameCombo').getValue();
		var testNameVal = Ext.getCmp('testCombo').getValue();
		var timeLineVal = Ext.getCmp('timeLineCombo').getValue();

		var strDisabledSearchVal = "";
		var strEnabledSearchVal = "";

		if (compTypeVal == "-1")
		{
			Ext.Msg.show ({
				title: pageName,
				msg: alert1,
				width: alert1.length * 7,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation',
			});
			return false;
		}
		var urlVal = '';
		if (type.id == "strEnabledSearch")
		{
			var strEnabledSearch = Ext.getCmp('strEnabledSearch').getValue();
			if (strEnabledSearch == "" || strEnabledSearch.length == 0)
			{
				Ext.get('MyTrigger_'+type.id+'_0').setStyle('display','none');
				Ext.get('MyTrigger_'+type.id+'_1').setStyle('display','block');
			}
			else
			{
				Ext.get('MyTrigger_'+type.id+'_1').setStyle('display','none');
				Ext.get('MyTrigger_'+type.id+'_0').setStyle('display','block');
			}

			var strDisabledSearch = Ext.getCmp('strDisabledSearch').getValue();
			if(strDisabledSearch != null)
			{
				strDisabledSearchVal = strDisabledSearch;
				if(strDisabledSearchVal == null || strDisabledSearchVal == "undefined" || strDisabledSearchVal == "Search")
				{
					strDisabledSearchVal = "";
				}
			}

			if (strEnabledSearch == null || strEnabledSearch == "" || strEnabledSearch == "Search" || strEnabledSearch == "null" )
			{
				strEnabledSearch = "";
			}

			var itemSelectorObj = Ext.getCmp('testDescItemSelector');
			if (!Ext.isEmpty(itemSelectorObj) && itemSelectorObj.hasOwnProperty('fromField')) 
			{
				itemSelectorObj = itemSelectorObj['fromField'];
			}
			if ( Ext.String.trim(strEnabledSearch).length > 0 && (Ext.String.trim(strEnabledSearch) != ''
				|| Ext.String.trim(strEnabledSearch) != null)) 
			{
					var tmpSearchStr = '';
					for (var d=0;d<strEnabledSearch.length ;d++ )
					{
						var tmp = strEnabledSearch.charAt(d);
						check_char = "+*?$.\\([^".indexOf(tmp);
						if(check_char != -1)
						{
							if (tmp == '+')
							{
								tmpSearchStr = strEnabledSearch.replace(tmp,'\\+');
							}
							else if (tmp == '*')
							{
								tmpSearchStr = strEnabledSearch.replace(tmp,'\\*');
							}
							else if (tmp == '?')
							{
								tmpSearchStr = strEnabledSearch.replace(tmp,'\\?');
							}
							else if (tmp == '\\')
							{
								tmpSearchStr = strEnabledSearch.replace(tmp,'\\\\');
							}
							else if (tmp == '.')
							{
								tmpSearchStr = strEnabledSearch.replace(tmp,'\\.');
							}
							else if (tmp == '^')
							{
								tmpSearchStr = strEnabledSearch.replace(tmp,'\\^');
							}
							else if (tmp == '$')
							{
								tmpSearchStr = strEnabledSearch.replace(tmp,'\\$');
							}
							else if (tmp == '(')
							{
								tmpSearchStr = strEnabledSearch.replace(tmp,'\\(');
							}
							else if (tmp == '[')
							{
								tmpSearchStr = strEnabledSearch.replace(tmp,'\\[');
							}
						}
					}
					if (!Ext.isEmpty(tmpSearchStr))
					{
						strEnabledSearch = tmpSearchStr
					}

				var regex = RegExp(strEnabledSearch, 'i');
				var elementsItems = itemSelectorObj.getStore();
				elementsItems.clearFilter(true);
				elementsItems.filter(new Ext.util.Filter({
					caseSensitive: true,
					filterFn: function (object) 
					{
						var match = false;
						Ext.Object.each(object.data, function (property, value)
						{
							match = match || regex.test(String(value));
						});
						return match;
					}
				}));
			}
			else 
			{
				itemSelectorObj.getStore().clearFilter();
			}
			Ext.getCmp('strEnabledSearch').focus();
		}
		else if(type.id == "strDisabledSearch")
		{
			var strDisabledSearch =  Ext.getCmp('strDisabledSearch').getValue();
			var strEnabledSearch = Ext.getCmp('strEnabledSearch');
			if (strDisabledSearch == "" || strDisabledSearch.length == 0)
			{
				Ext.get('MyTrigger_'+type.id+'_0').setStyle('display','none');
				Ext.get('MyTrigger_'+type.id+'_1').setStyle('display','block');
			}
			else
			{
				Ext.get('MyTrigger_'+type.id+'_1').setStyle('display','none');
				Ext.get('MyTrigger_'+type.id+'_0').setStyle('display','block');
			}

			if(!Ext.isEmpty(strEnabledSearch))
			{
				strEnabledSearchVal = strEnabledSearch.value;
				if(Ext.isEmpty(strEnabledSearchVal) || strEnabledSearchVal == "Search" || strEnabledSearchVal == "")
				{
					strEnabledSearchVal = "";
				}
			}

			if (Ext.isEmpty(strDisabledSearch) || strDisabledSearch == "" || strDisabledSearch == "Search")
			{
				strDisabledSearch = "";
			}

			var itemSelectorObj = Ext.getCmp('testDescItemSelector');
			var avaiableElementsMultiSelect=null;
			if (!Ext.isEmpty(itemSelectorObj) && itemSelectorObj.hasOwnProperty('fromField')) 
			{
				avaiableElementsMultiSelect=itemSelectorObj['toField'];
			}

			if ( Ext.String.trim(strDisabledSearch).length > 0 && 
				(Ext.String.trim(strDisabledSearch) != '' || Ext.String.trim(strDisabledSearch) != null)) 
			{
				var tmpSearchStr = '';
				for (var d=0;d<strDisabledSearch.length ;d++ )
				{
					var tmp = strDisabledSearch.charAt(d);
					check_char = "+*?$.\\^([".indexOf(tmp);
					if(check_char != -1)
					{
					console.log('tmp 11 : '+tmp);
						if (tmp == '+')
						{
							tmpSearchStr = strDisabledSearch.replace(tmp,'\\+');
						}
						else if (tmp == '*')
						{
							tmpSearchStr = strDisabledSearch.replace(tmp,'\\*');
						}
						else if (tmp == '?')
						{
							tmpSearchStr = strDisabledSearch.replace(tmp,'\\?');
						}
						else if (tmp == '\\')
						{
							tmpSearchStr = strDisabledSearch.replace(tmp,'\\\\');
						}
						else if (tmp == '.')
						{
							tmpSearchStr = strDisabledSearch.replace(tmp,'\\.');
						}
						else if (tmp == '^')
						{
							tmpSearchStr = strDisabledSearch.replace(tmp,'\\^');
						}
						else if (tmp == '$')
						{
							tmpSearchStr = strDisabledSearch.replace(tmp,'\\$');
						}
						else if (tmp == '(')
						{
							tmpSearchStr = strDisabledSearch.replace(tmp,'\\(');
						}
						else if (tmp == '[')
						{
							tmpSearchStr = strDisabledSearch.replace(tmp,'\\[');
						}
					}
				}
				if (!Ext.isEmpty(tmpSearchStr))
				{
					strDisabledSearch = tmpSearchStr
				}

				var regex = RegExp(strDisabledSearch, 'i');
				var availableElementsItems = avaiableElementsMultiSelect.getStore();
				availableElementsItems.clearFilter(true);
				availableElementsItems.filter(new Ext.util.Filter({
					caseSensitive: true,
					filterFn: function (object) {
						var match = false;
						Ext.Object.each(object.data, function (property, value) {
							match = match || regex.test(String(value));
						});
						return match;
					}
				}));
			}
			else 
			{
				avaiableElementsMultiSelect.getStore().clearFilter();
			}
			Ext.getCmp('strDisabledSearch').focus();
		}
    },
	descriptorSearch : function(type)
	{
		var compTypeVal = Ext.getCmp('compTypeCombo').getValue();
		var compNameVal = Ext.getCmp('compNameCombo').getValue();
		var testNameVal = Ext.getCmp('testCombo').getValue();
		var timeLineVal = Ext.getCmp('timeLineCombo').getValue();

		var strDisabledSearchVal = "";
		var strEnabledSearchVal = "";

		if (compTypeVal == "-1")
		{
			Ext.Msg.show ({
				title: pageName,
				msg: alert1,
				width: alert1.length * 7,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation',
			});
			return false;
		}
		var urlVal = '';
		if (type.id == "strEnabledSearch")
		{
			var strEnabledSearch = Ext.getCmp('strEnabledSearch').getValue();
			if (strEnabledSearch == "" || strEnabledSearch.length == 0)
			{
				Ext.get('MyTrigger_'+type.id+'_0').setStyle('display','none');
				Ext.get('MyTrigger_'+type.id+'_1').setStyle('display','block');
			}
			else
			{
				Ext.get('MyTrigger_'+type.id+'_1').setStyle('display','none');
				Ext.get('MyTrigger_'+type.id+'_0').setStyle('display','block');
			}
			var strDisabledSearch = Ext.getCmp('strDisabledSearch').getValue();
			if(strDisabledSearch != null)
			{
				strDisabledSearchVal = strDisabledSearch;
				if(strDisabledSearchVal == null || strDisabledSearchVal == "undefined" || strDisabledSearchVal == "Search")
				{
					strDisabledSearchVal = "";
				}
			}
			if (strEnabledSearch == null || strEnabledSearch == "" || strEnabledSearch == "Search" || strEnabledSearch == "null" )
			{
				urlVal = "TestDescriptors/data/EgTestInfoViewJson.jsp?server=" +
				encodeURIComponent(compTypeVal) +"&comp=" +encodeURIComponent(compNameVal) +"&testName="+encodeURIComponent(testNameVal) + "&duration="+timeLineVal+"&strEnabledSearch="+strEnabledSearch+"&strDisabledSearch="+strDisabledSearchVal;
			}
			else
			{
				urlVal = "TestDescriptors/data/EgTestInfoViewJson.jsp?server="+ encodeURIComponent(compTypeVal) +"&comp=" +encodeURIComponent(compNameVal) +"&testName="+encodeURIComponent(testNameVal) + "&duration="+encodeURIComponent(timeLineVal)+"&strEnabledSearch="+strEnabledSearch+"&strDisabledSearch="+strDisabledSearchVal;
			}
		}
		else if(type.id == "strDisabledSearch")
		{
			var strDisabledSearch =  Ext.getCmp('strDisabledSearch').getValue();
			var strEnabledSearch = Ext.getCmp('strEnabledSearch');
			if (strDisabledSearch == "" || strDisabledSearch.length == 0)
			{
				Ext.get('MyTrigger_'+type.id+'_0').setStyle('display','none');
				Ext.get('MyTrigger_'+type.id+'_1').setStyle('display','block');
			}
			else
			{
				Ext.get('MyTrigger_'+type.id+'_1').setStyle('display','none');
				Ext.get('MyTrigger_'+type.id+'_0').setStyle('display','block');
			}
			if(!Ext.isEmpty(strEnabledSearch))
			{
				strEnabledSearchVal = strEnabledSearch.value;
				if(Ext.isEmpty(strEnabledSearchVal) || strEnabledSearchVal == "Search" || strEnabledSearchVal == "")
				{
					strEnabledSearchVal = "";
				}
			}

			if (Ext.isEmpty(strDisabledSearch) || strDisabledSearch == "" || strDisabledSearch == "Search")
			{
				urlVal = "TestDescriptors/data/EgTestInfoViewJson.jsp?server=" +
				encodeURIComponent(compTypeVal) +"&comp=" +encodeURIComponent(compNameVal) +"&testName="+encodeURIComponent(testNameVal) + "&duration="+timeLineVal+"&strEnabledSearch="+strEnabledSearchVal+"&strDisabledSearch="+strDisabledSearch;
			}
			else
			{
				urlVal = "TestDescriptors/data/EgTestInfoViewJson.jsp?server="+ encodeURIComponent(compTypeVal) +"&comp=" +encodeURIComponent(compNameVal) +"&testName="+encodeURIComponent(testNameVal) + "&duration="+encodeURIComponent(timeLineVal)+"&strEnabledSearch="+strEnabledSearchVal+"&strDisabledSearch="+strDisabledSearch;
			}
		}

		Ext.Ajax.request({
			url:urlVal,
			method:'post',
			scope:this,
			success:function(response)
			{	
				var jsonText = response.responseText;
				publicJson = Ext.decode(jsonText);

				var noDescriptorData = publicJson['No_descriptor'];
				var itemSelectorData = publicJson['commonDescListArr'];
				var requestFrom = publicJson['requestFrom'];
				if(requestFrom == 'processUpdated')
				{
					Ext.getCmp('processUpdateContainer').show();
				}
				if(Ext.isEmpty(noDescriptorData))
				{
					var allDescList = publicJson['commonDescListArr'];
					var disableDescList = publicJson['disableDescListObj'];
					if(Ext.isEmpty(disableDescList))
					{
						var disableSearch = publicJson['disable_desc_search'];
						var disableSearchVal = Ext.getCmp('strDisabledSearch').getValue();
						if (Ext.isEmpty(disableSearch) || Ext.isEmpty(disableSearchVal))
						{
							Ext.getCmp('deleteBtnContainer').hide();
						}
					}

					Ext.getCmp('noDataContainer').hide();
					Ext.getCmp('testDescItemSelector').show();
					Ext.getCmp('btnContainer').show();
					Ext.getCmp('testDescItemSelector').getStore().removeAll();
					Ext.getCmp('testDescItemSelector').getStore().loadRawData(allDescList);
					Ext.getCmp('testDescItemSelector').setValue(disableDescList);
				}
				else
				{
					Ext.getCmp('processUpdateContainer').hide();
					Ext.getCmp('testDescItemSelector').hide();
					Ext.getCmp('btnContainer').hide();
					Ext.getCmp('deleteBtnContainer').hide();
					Ext.getCmp('searchContainer').hide();
					Ext.getCmp('noDataContainer').show();
				}
			}
		});
	},
	deleteData: function()
	{
		var me = this;
		var compTypeVal = Ext.getCmp('compTypeCombo').getValue();
		var compNameVal = Ext.getCmp('compNameCombo').getValue();
		var testNameVal = Ext.getCmp('testCombo').getValue();
		var timeLineVal = Ext.getCmp('timeLineCombo').getValue();
		var disableDesc = Ext.getCmp('testDescItemSelector').toField.getSelected();
		var isData = false;
		var itemSelectDisableVal = publicJson['disableDescListObj'];

		//var tmpStore = Ext.getCmp('testDescItemSelector');
		//var fromList = tmpStore.toField.boundList;
		//alert('fromList  : '+fromList);
		//var selectedList = tmpStore.getSelections(fromList);
		//alert('selectedList  : '+selectedList);
		var deldisable = '';
		for (var i=0;i<disableDesc.length ;i++)
		{
			var allValue = disableDesc[i].get('valueField');
			deldisable +=allValue+',';
			
		}
		if (itemSelectDisableVal != null && itemSelectDisableVal != 'undefined')
		{
			for (var i=0;i<disableDesc.length ;i++)
			{
				var disableValue = disableDesc[i].get('valueField')
				for (var j=0;j<itemSelectDisableVal.length ;j++)
				{
					if(disableValue == itemSelectDisableVal[j])
					{
						isData = true;
						break;
					}
				}
			}
		}
		
		if(deldisable == "")
		{
			Ext.MessageBox.show({
				title: pageName,
				msg: alert2,
				width: alert2.length * 7,
				icon: 'iconExclamation',
				buttons: Ext.Msg.OK,
			});
		}
		else if (!isData)
		{
			Ext.MessageBox.show({
				title: pageName,
				msg: alert3,
				icon: 'iconExclamation',
				buttons: Ext.Msg.OK,
				width: alert3.length * 7
			});
		}
		else
		{
			if(deldisable.length > 1)
			{
				deldisable = deldisable.substring(0,deldisable.length-1);
			}
			var qStr = 'server='+encodeURIComponent(compTypeVal)+'&comp='+encodeURIComponent(compNameVal)+'&testName='+encodeURIComponent(testNameVal)+'&duration='+encodeURIComponent(timeLineVal)+'&from=delete';
			Ext.Msg.show({
				title: pageName,
				msg: alert4,
				width: alert4.length * 7,
				icon: 'iconConfirmation',
				buttons: Ext.Msg.YESNO,
				fn: function(response) {
					if (response == "yes")
					{
						Ext.getCmp("disabledDescList").setValue(deldisable);
						var tmpURL = "TestDescriptors/data/Egtestinfoviewp.jsp?"+qStr;
						me.deleteSelectedComponent(tmpURL);
					}
				}
			});
		}
	},
	deleteSelectedComponent : function(tmpURL)
	{
		var me = this;
		var compTypeVal = Ext.getCmp('compTypeCombo').getValue();
		var compNameVal = Ext.getCmp('compNameCombo').getValue();
		var testNameVal = Ext.getCmp('testCombo').getValue();
		var timeLineVal = Ext.getCmp('timeLineCombo').getValue();

		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myMask.show();
		var frmMain = this.getTestdescriptors().getForm();
		var enabledDesc = Ext.getCmp("enabledDescList").getValue();
		var disabledDesc = Ext.getCmp("enabledDescList").getValue();
		var qString = 'server='+encodeURIComponent(compTypeVal)+'&comp=' + compNameVal +'&testName='+ testNameVal +'&duration=' + timeLineVal +'&requestFrom=processUpdated';
		var availSearch = Ext.getCmp("strEnabledSearch").getValue();
		var disableSearch = Ext.getCmp("strDisabledSearch").getValue();
		if(availSearch != null && availSearch != 'undefined')
		{
			qString += '&strEnabledSearch='+availSearch;
		}
		if(disableSearch != null && disableSearch != 'undefined')
		{
			qString += '&strDisabledSearch='+disableSearch;
		}
		if (frmMain.isValid())
		{
			this.getTestdescriptors().submit({
				url: tmpURL,//+'&'+hiddenFields,
				method: 'POST',
				//standardSubmit: true,
				success: function(form, action){
					myMask.hide();
					me.afterDescriptorDeleted(qString);
					Ext.getCmp("disabledDescList").setValue("");
					Ext.getCmp("enabledDescList").setValue("");
				},
				failure: function(form, action) // if result page doest not contain success:true, this method fires
				{
					var jsonText = Ext.decode(action.response.responseText);
					if(jsonText.successUpdate == 'true')
					{
						myMask.hide();
						me.afterDescriptorDeleted(qString);
						Ext.getCmp("disabledDescList").setValue("");
						Ext.getCmp("enabledDescList").setValue("");
					}
					else
					{
						myMask.hide();
						me.afterDescriptorDeleted(qString);
						Ext.getCmp("disabledDescList").setValue("");
						Ext.getCmp("enabledDescList").setValue("");
					}
				}
			});
		}
	},
	afterDescriptorDeleted :  function(qString)
	{
		var urlVal = 'TestDescriptors/data/EgTestInfoViewJson.jsp?'+qString;
		var me = this;
		Ext.Ajax.request({
			url:urlVal,
			method:'post',
			scope:this,
			success:function(response)
			{	
				var jsonText = response.responseText;
				publicJson = Ext.decode(jsonText);

				var noDescriptorData = publicJson['No_descriptor'];
				var itemSelectorData = publicJson['commonDescListArr'];
				var requestFrom = publicJson['requestFrom'];
				if(requestFrom == 'processUpdated')
				{
					Ext.getCmp('processUpdateContainer').show();
				}

				if(noDescriptorData == null || Ext.isEmpty(noDescriptorData))
				{
					var allDescList = publicJson['commonDescListArr'];
					var disableDescList = publicJson['disableDescListObj'];
					if(disableDescList == null || Ext.isEmpty(disableDescList))
					{
						Ext.getCmp('deleteBtnContainer').hide();
					}
					else
					{
						Ext.getCmp('deleteBtnContainer').show();
						Ext.getCmp('availDeleteBtn').hide();
					}
					var availSearch = publicJson['avail_desc_search'];
					var disableSearch = publicJson['disable_desc_search'];
					var isFireEnableSearch = false;
					var isFireDisableSearch = false;

					if (availSearch != null && availSearch != 'undefined' && availSearch == 'true')
					{
						Ext.getCmp('searchContainer').show();
						Ext.getCmp('strEnabledSearch').show();
						isFireEnableSearch = true;
						if (Ext.isEmpty(disableSearch) || availSearch != 'true')
						{
							Ext.getCmp('strDisabledSearch').setValue('');
							Ext.getCmp('strDisabledSearch').hide();
							isFireDisableSearch = false;
						}
					}
					if (disableSearch != null && disableSearch != 'undefined' && disableSearch == 'true')
					{
						Ext.getCmp('searchContainer').show();
						Ext.getCmp('strDisabledSearch').show();
						isFireDisableSearch = true;
						if (Ext.isEmpty(availSearch) || availSearch != 'true')
						{
							Ext.getCmp('strEnabledSearch').setValue('');
							Ext.getCmp('strEnabledSearch').hide();
							isFireEnableSearch = false;
						}
					}

					if((availSearch != null && availSearch != 'true') && (disableSearch != null && disableSearch != 'true'))
					{
						Ext.getCmp('searchContainer').hide();
						Ext.getCmp('strEnabledSearch').hide();
						Ext.getCmp('strDisabledSearch').hide();
						isFireDisableSearch = false;
						isFireEnableSearch = false;
					}

					Ext.getCmp('noDataContainer').hide();
					Ext.getCmp('testDescItemSelector').show();
					Ext.getCmp('btnContainer').show();
					Ext.getCmp('testDescItemSelector').getStore().removeAll();
					Ext.getCmp('testDescItemSelector').getStore().loadRawData(allDescList);
					Ext.getCmp('testDescItemSelector').setValue(disableDescList);

					if (isFireEnableSearch)
					{
						var strEnaFetchValue = Ext.getCmp('strEnabledSearch').getValue();
						if ( !Ext.isEmpty( strEnaFetchValue ) )
						{
							Ext.getCmp('strEnabledSearch').fireEvent('change', Ext.getCmp('strEnabledSearch'));
						}

					}

					if (isFireDisableSearch)
					{
						var strDisFetchValue = Ext.getCmp('strDisabledSearch').getValue();
						if ( !Ext.isEmpty( strDisFetchValue ) )
						{
							Ext.getCmp('strDisabledSearch').fireEvent('change', Ext.getCmp('strDisabledSearch'));
						}
					}
				}
				else
				{
					Ext.getCmp('processUpdateContainer').hide();
					Ext.getCmp('testDescItemSelector').hide();
					Ext.getCmp('btnContainer').hide();
					Ext.getCmp('deleteBtnContainer').hide();
					Ext.getCmp('searchContainer').hide();
					Ext.getCmp('noDataContainer').show();
				}
			}
		});
	},
	afterMainRender: function()
	{
		Ext.Ajax.request({
			url:'TestDescriptors/data/EgTestInfoViewJson.jsp?reqfrom=navlink',
			method:'post',
			scope:this,
			success:function(response)
			{
				var jsonText = response.responseText;
				publicJson = Ext.decode(jsonText);
				var isNoData = publicJson['isNoData'];
				if (isNoData)
				{
					var noDataMsg = publicJson['No_data'];
					Ext.getCmp('comboContainer').hide();
					Ext.getCmp('noDataContainer').show();
					Ext.getCmp('noDataLabel').update(noDataMsg);
				}
				else
				{
					Ext.getCmp('comboContainer').show();
					Ext.getCmp('noDataContainer').hide();

					Ext.getCmp('compTypeCombo').getStore().clearFilter(true);
					Ext.getCmp('compTypeCombo').getStore().loadRawData(publicJson['descCompTypeArr']);
					Ext.getCmp('compNameCombo').getStore().clearFilter(true);
					Ext.getCmp('compNameCombo').getStore().loadRawData(publicJson['descCompNameArr']);
					Ext.getCmp('testCombo').getStore().clearFilter(true);
					Ext.getCmp('testCombo').getStore().loadRawData(publicJson['descTestNameArr']);
					Ext.getCmp('timeLineCombo').getStore().loadRawData(publicJson['descTimeLimitArr']);
					Ext.getCmp('compTypeCombo').setValue(publicJson['descCompTypeArr'][0].valueField);
					Ext.getCmp('compNameCombo').setValue(publicJson['descCompNameArr'][0].valueField);
					Ext.getCmp('testCombo').setValue(publicJson['descTestNameArr'][0].valueField);
					Ext.getCmp('timeLineCombo').setValue(publicJson['selectedTime']);
					Ext.getCmp('timeLineCombo').setDisabled(true);

					Ext.getCmp('strEnabledSearch').setValue('');
					Ext.getCmp('strDisabledSearch').setValue('');

					if ( !Ext.isEmpty( compType ) )
					{
						Ext.getCmp('compTypeCombo').setValue(compType);
						Ext.getCmp('compTypeCombo').fireEvent('select', Ext.getCmp('compTypeCombo'));
					}
					if ( !Ext.isEmpty( comp ) )
					{
						Ext.getCmp('compNameCombo').setValue(comp);
						Ext.getCmp('compNameCombo').fireEvent('select', Ext.getCmp('compNameCombo'));
					}
					if ( !Ext.isEmpty( test ) )
					{
						Ext.getCmp('testCombo').setValue(test);
						Ext.getCmp('testCombo').fireEvent('select', Ext.getCmp('testCombo'));
					}

					//if ( !Ext.isEmpty( duration ) )
					//{
						//Ext.getCmp('timeLineCombo').setValue(duration);
						//console.log(publicJson['descTimeLimitArr']);
						//Ext.getCmp('timeLineCombo').fireEvent('select', Ext.getCmp('timeLineCombo'));
					//}
				}
			}
		});
	},
	compNameComboLoad: function()
	{
		var compTypeVal = Ext.getCmp('compTypeCombo').getValue();
		var compNameVal = Ext.getCmp('compNameCombo').getValue();
		if(Ext.isEmpty(compTypeVal) || (compTypeVal == null || compTypeVal == 'undefined' || compTypeVal == '-1'))
		{
			if(!Ext.getCmp('testDescItemSelector').isHidden())
			{
				Ext.getCmp('testDescItemSelector').hide();
				Ext.getCmp('btnContainer').hide();
				Ext.getCmp('deleteBtnContainer').hide();
				Ext.getCmp('searchContainer').hide();
			}
			Ext.getCmp('processUpdateContainer').hide();
			Ext.getCmp('noDataContainer').hide();
			comp = '';
			test = '';
			this.afterMainRender();
		}
		else if((compTypeVal != null && compTypeVal != 'undefined' && compTypeVal != '-1') && (Ext.isEmpty(compNameVal) || (compNameVal == null || compNameVal == 'undefined' || compNameVal == '-1')))
		{
			Ext.Ajax.request({
				url:'TestDescriptors/data/EgTestInfoViewJson.jsp?server='+encodeURIComponent(compTypeVal),
				method:'post',
				scope:this,
				async:false,
				success:function(response)
				{	
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					Ext.getCmp('compNameCombo').getStore().removeAll();
					Ext.getCmp('compNameCombo').getStore().clearFilter(true);
					Ext.getCmp('compNameCombo').getStore().loadRawData(publicJson['descCompNameArr']);
					Ext.getCmp('testCombo').getStore().removeAll();
					Ext.getCmp('testCombo').getStore().clearFilter(true);
					Ext.getCmp('testCombo').getStore().loadRawData(publicJson['descTestNameArr']);
					Ext.getCmp('timeLineCombo').getStore().removeAll();
					Ext.getCmp('timeLineCombo').getStore().loadRawData(publicJson['descTimeLimitArr']);
					if(!Ext.getCmp('testDescItemSelector').isHidden())
					{
						Ext.getCmp('testDescItemSelector').hide();
						Ext.getCmp('btnContainer').hide();
						Ext.getCmp('deleteBtnContainer').hide();
						Ext.getCmp('searchContainer').hide();
						Ext.getCmp('strEnabledSearch').setValue('');
						Ext.getCmp('strDisabledSearch').setValue('');
					}
					Ext.getCmp('noDataContainer').hide();
					Ext.getCmp('processUpdateContainer').hide();
					Ext.getCmp('compNameCombo').setValue(publicJson['descCompNameArr'][0].valueField);
					Ext.getCmp('testCombo').setValue(publicJson['descTestNameArr'][0].valueField);
					Ext.getCmp('timeLineCombo').setValue(publicJson['selectedTime']);
					Ext.getCmp('timeLineCombo').setDisabled(true);
				}
			});
		}
		else
		{
			Ext.Ajax.request({
				url:'TestDescriptors/data/EgTestInfoViewJson.jsp?server='+encodeURIComponent(compTypeVal)+'&comp='+encodeURIComponent(compNameVal),
				method:'post',
				scope:this,
				async:false,
				success:function(response)
				{	
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					Ext.getCmp('testCombo').getStore().removeAll();
					Ext.getCmp('testCombo').getStore().clearFilter(true);
					Ext.getCmp('testCombo').getStore().loadRawData(publicJson['descTestNameArr']);
					Ext.getCmp('timeLineCombo').getStore().removeAll();
					Ext.getCmp('timeLineCombo').getStore().loadRawData(publicJson['descTimeLimitArr']);
					if(!Ext.getCmp('testDescItemSelector').isHidden())
					{
						Ext.getCmp('testDescItemSelector').hide();
						Ext.getCmp('btnContainer').hide();
						Ext.getCmp('deleteBtnContainer').hide();
						Ext.getCmp('searchContainer').hide();
						Ext.getCmp('strEnabledSearch').setValue('');
						Ext.getCmp('strDisabledSearch').setValue('');
					}
					Ext.getCmp('noDataContainer').hide();
					Ext.getCmp('processUpdateContainer').hide();
					Ext.getCmp('testCombo').setValue(publicJson['descTestNameArr'][0].valueField);
					Ext.getCmp('timeLineCombo').setValue(publicJson['selectedTime']);
					Ext.getCmp('timeLineCombo').setDisabled(true);
				}
			});
		}
	},
	testNameComboLoad: function()
	{
		var compTypeVal = Ext.getCmp('compTypeCombo').getValue();
		var compNameVal = Ext.getCmp('compNameCombo').getValue();
		var testNameVal = Ext.getCmp('testCombo').getValue();
		if(Ext.isEmpty(compTypeVal) || (compTypeVal == null || compTypeVal == 'undefined' || compTypeVal == '-1'))
		{
			if(!Ext.getCmp('testDescItemSelector').isHidden())
			{
				Ext.getCmp('testDescItemSelector').hide();
				Ext.getCmp('btnContainer').hide();
				Ext.getCmp('deleteBtnContainer').hide();
				Ext.getCmp('searchContainer').hide();
			}
			Ext.getCmp('processUpdateContainer').hide();
			Ext.getCmp('noDataContainer').hide();
			comp = '';
			test = '';

			this.afterMainRender();
		}
		else if((compTypeVal != null && compTypeVal != 'undefined' && compTypeVal != '-1') && (Ext.isEmpty(compNameVal) || (compNameVal == null || compNameVal == 'undefined' || compNameVal == '-1')))
		{
			Ext.Ajax.request({
				url:'TestDescriptors/data/EgTestInfoViewJson.jsp?server='+encodeURIComponent(compTypeVal),
				method: 'post',
				scope: this,
				async: false,
				success:function(response)
				{	
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					Ext.getCmp('compNameCombo').getStore().removeAll();
					Ext.getCmp('compNameCombo').getStore().clearFilter(true);
					Ext.getCmp('compNameCombo').getStore().loadRawData(publicJson['descCompNameArr']);
					Ext.getCmp('testCombo').getStore().removeAll();
					Ext.getCmp('testCombo').getStore().clearFilter(true);
					Ext.getCmp('testCombo').getStore().loadRawData(publicJson['descTestNameArr']);
					Ext.getCmp('timeLineCombo').getStore().removeAll();
					Ext.getCmp('timeLineCombo').getStore().loadRawData(publicJson['descTimeLimitArr']);
					if(!Ext.getCmp('testDescItemSelector').isHidden())
					{
						Ext.getCmp('testDescItemSelector').hide();
						Ext.getCmp('btnContainer').hide();
						Ext.getCmp('deleteBtnContainer').hide();
						Ext.getCmp('searchContainer').hide();
					}
					Ext.getCmp('noDataContainer').hide();
					Ext.getCmp('processUpdateContainer').hide();
					Ext.getCmp('compNameCombo').setValue(publicJson['descCompNameArr'][0].valueField);
					Ext.getCmp('testCombo').setValue(publicJson['descTestNameArr'][0].valueField);
					Ext.getCmp('timeLineCombo').setValue(publicJson['selectedTime']);
					Ext.getCmp('timeLineCombo').setDisabled(true);
				}
			});
		}
		else  if((compTypeVal != null && compTypeVal != 'undefined' && compTypeVal != '-1') && (compNameVal != null && compNameVal != 'undefined' && compNameVal != '-1') && (Ext.isEmpty(testNameVal) || (testNameVal == null || testNameVal == 'undefined' || testNameVal == '-1')))
		{
			Ext.Ajax.request({
				url:'TestDescriptors/data/EgTestInfoViewJson.jsp?server='+encodeURIComponent(compTypeVal)+'&comp='+encodeURIComponent(compNameVal),
				method:'post',
				scope:this,
				async: false,
				success:function(response)
				{	
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					Ext.getCmp('testCombo').getStore().removeAll();
					Ext.getCmp('testCombo').getStore().clearFilter(true);
					Ext.getCmp('testCombo').getStore().loadRawData(publicJson['descTestNameArr']);
					Ext.getCmp('timeLineCombo').getStore().removeAll();
					Ext.getCmp('timeLineCombo').getStore().loadRawData(publicJson['descTimeLimitArr']);
					if(!Ext.getCmp('testDescItemSelector').isHidden())
					{
						Ext.getCmp('testDescItemSelector').hide();
						Ext.getCmp('btnContainer').hide();
						Ext.getCmp('deleteBtnContainer').hide();
						Ext.getCmp('searchContainer').hide();
					}
					Ext.getCmp('noDataContainer').hide();
					Ext.getCmp('processUpdateContainer').hide();
					Ext.getCmp('testCombo').setValue(publicJson['descTestNameArr'][0].valueField);
					Ext.getCmp('timeLineCombo').setValue(publicJson['selectedTime']);
					Ext.getCmp('timeLineCombo').setDisabled(true);
				}
			});
		}
		else
		{
			Ext.Ajax.request({
				url:'TestDescriptors/data/EgTestInfoViewJson.jsp?server='+encodeURIComponent(compTypeVal)+'&comp='+encodeURIComponent(compNameVal)+'&testName='+encodeURIComponent(testNameVal),
				method:'post',
				scope:this,
				async: false,
				success:function(response)
				{	
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					Ext.getCmp('timeLineCombo').getStore().removeAll();
					Ext.getCmp('timeLineCombo').getStore().loadRawData(publicJson['descTimeLimitArr']);
					Ext.getCmp('timeLineCombo').setValue(publicJson['selectedTime']);
					Ext.getCmp('timeLineCombo').setDisabled(false);
					var itemSelectorData = publicJson['commonDescListArr'];
					Ext.getCmp('processUpdateContainer').hide();

					if(itemSelectorData != null && itemSelectorData != 'undefined' && itemSelectorData.length > 0)
					{
						Ext.getCmp('testDescItemSelector').show();
						Ext.getCmp('btnContainer').show();
						Ext.getCmp('deleteBtnContainer').hide();
						Ext.getCmp('searchContainer').hide();
						Ext.getCmp('noDataContainer').hide();
						Ext.getCmp('strEnabledSearch').setValue('');
						Ext.getCmp('strDisabledSearch').setValue('');
						Ext.getCmp('strEnabledSearch').hide();
						Ext.getCmp('strDisabledSearch').hide();

						var delBtnEnable = publicJson['enable_delete_btn'];
						var availSearch = publicJson['avail_desc_search'];
						var disableSearch = publicJson['disable_desc_search'];
						var isFireEnableSearch = false;
						var isFireDisableSearch = false;
						if (delBtnEnable != null && delBtnEnable != 'undefined' && delBtnEnable == 'true')
						{
							Ext.getCmp('deleteBtnContainer').show();
							Ext.getCmp('availDeleteBtn').hide();
						}

						if (!Ext.isEmpty(availSearch) && availSearch != 'undefined' && availSearch == 'true')
						{
							Ext.getCmp('searchContainer').show();
							Ext.getCmp('strEnabledSearch').show();
							Ext.getCmp('strDisabledSearch').hide();
							isFireEnableSearch = true;
						}

						if (!Ext.isEmpty(disableSearch) && disableSearch != 'undefined' && disableSearch == 'true')
						{
							Ext.getCmp('searchContainer').show();
							Ext.getCmp('strDisabledSearch').show();
							isFireDisableSearch = true;
							if (!Ext.isEmpty(availSearch) && availSearch != 'true')
							{
								isFireEnableSearch = false;
								Ext.getCmp('strEnabledSearch').hide();
							}
						}
					
						Ext.getCmp('testDescItemSelector').getStore().clearFilter(true);
						Ext.getCmp('testDescItemSelector').getStore().loadRawData(publicJson['commonDescListArr']);
						Ext.getCmp('testDescItemSelector').setValue(publicJson['disableDescListObj']);

						if (isFireEnableSearch)
						{
							var strEnaFetchValue = Ext.getCmp('strEnabledSearch').getValue();
							if ( !Ext.isEmpty( strEnaFetchValue ) )
							{
								Ext.getCmp('strEnabledSearch').fireEvent('change', Ext.getCmp('strEnabledSearch'));
							}

						}

						if (isFireDisableSearch)
						{
							var strDisFetchValue = Ext.getCmp('strDisabledSearch').getValue();
							if ( !Ext.isEmpty( strDisFetchValue ) )
							{
								Ext.getCmp('strDisabledSearch').fireEvent('change', Ext.getCmp('strDisabledSearch'));
							}
						}
					}
					else
					{
						Ext.getCmp('testDescItemSelector').hide();
						Ext.getCmp('btnContainer').hide();
						Ext.getCmp('deleteBtnContainer').hide();
						Ext.getCmp('searchContainer').hide();
						Ext.getCmp('noDataContainer').show();
						Ext.getCmp('strEnabledSearch').setValue('');
						Ext.getCmp('strDisabledSearch').setValue('');
						Ext.getCmp('strEnabledSearch').hide();
						Ext.getCmp('strDisabledSearch').hide();

					}
				}
			});
		}
	},
	compTypeComboLoad: function()
	{
		var compTypeVal = Ext.getCmp('compTypeCombo').getValue();
		if(Ext.isEmpty(compTypeVal) || (compTypeVal == null || compTypeVal == 'undefined' || compTypeVal == '-1'))
		{
			compType = '';
			if(!Ext.getCmp('testDescItemSelector').isHidden())
			{
				Ext.getCmp('testDescItemSelector').hide();
				Ext.getCmp('btnContainer').hide();
				Ext.getCmp('deleteBtnContainer').hide();
				Ext.getCmp('searchContainer').hide();
			}
			Ext.getCmp('processUpdateContainer').hide();
			Ext.getCmp('noDataContainer').hide();
			comp = '';
			test = '';

			this.afterMainRender();
		}
		else if(compTypeVal != null && compTypeVal != 'undefined' && compTypeVal != '-1')
		{
			Ext.Ajax.request({
				url:'TestDescriptors/data/EgTestInfoViewJson.jsp?server='+encodeURIComponent(compTypeVal),
				method:'post',
				scope:this,
				async: false,
				success:function(response)
				{	
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					Ext.getCmp('compNameCombo').getStore().removeAll();
					Ext.getCmp('compNameCombo').getStore().clearFilter(true);
					Ext.getCmp('compNameCombo').getStore().loadRawData(publicJson['descCompNameArr']);
					Ext.getCmp('testCombo').getStore().removeAll();
					Ext.getCmp('testCombo').getStore().clearFilter(true);
					Ext.getCmp('testCombo').getStore().loadRawData(publicJson['descTestNameArr']);
					Ext.getCmp('timeLineCombo').getStore().removeAll();
					Ext.getCmp('timeLineCombo').getStore().loadRawData(publicJson['descTimeLimitArr']);
					if(!Ext.getCmp('testDescItemSelector').isHidden())
					{
						Ext.getCmp('testDescItemSelector').hide();
						Ext.getCmp('btnContainer').hide();
						Ext.getCmp('deleteBtnContainer').hide();
						Ext.getCmp('searchContainer').hide();
					}
					Ext.getCmp('processUpdateContainer').hide();
					Ext.getCmp('noDataContainer').hide();
					Ext.getCmp('compNameCombo').setValue(publicJson['descCompNameArr'][0].valueField);
					Ext.getCmp('testCombo').setValue(publicJson['descTestNameArr'][0].valueField);
					Ext.getCmp('timeLineCombo').setValue(publicJson['selectedTime']);
					Ext.getCmp('timeLineCombo').setDisabled(true);
				}
			});
		}
	},
	timeLineComboLoad: function()
	{
		var compTypeVal = Ext.getCmp('compTypeCombo').getValue();
		var compNameVal = Ext.getCmp('compNameCombo').getValue();
		var testNameVal = Ext.getCmp('testCombo').getValue();
		var timeLineVal = Ext.getCmp('timeLineCombo').getValue();
		Ext.getCmp('processUpdateContainer').hide();

		if(Ext.isEmpty(compTypeVal) || (compTypeVal == null || compTypeVal == 'undefined' || compTypeVal == '-1'))
		{
			if(!Ext.getCmp('testDescItemSelector').isHidden())
			{
				Ext.getCmp('testDescItemSelector').hide();
				Ext.getCmp('btnContainer').hide();
				Ext.getCmp('deleteBtnContainer').hide();
				Ext.getCmp('searchContainer').hide();
			}
			Ext.getCmp('processUpdateContainer').hide();
			Ext.getCmp('noDataContainer').hide();
			this.afterMainRender();
		}
		else
		{
			Ext.Ajax.request({
				url:'TestDescriptors/data/EgTestInfoViewJson.jsp?server='+encodeURIComponent(compTypeVal)+'&comp='+encodeURIComponent(compNameVal)+'&testName='+encodeURIComponent(testNameVal)+"&duration="+encodeURIComponent(timeLineVal),
				method:'post',
				scope:this,
				async:false,
				success:function(response)
				{	
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					var itemSelectorData = publicJson['commonDescListArr'];
					if(itemSelectorData != null && itemSelectorData != 'undefined' && itemSelectorData.length > 0)
					{
						var isFireEnableSearch = false;
						var isFireDisableSearch = false;
						var availSearch = publicJson['avail_desc_search'];
						var disableSearch = publicJson['disable_desc_search'];
						if ( !Ext.isEmpty(availSearch) || !Ext.isEmpty(disableSearch))
						{
							Ext.getCmp('searchContainer').show();
							if (Ext.isEmpty(availSearch) || availSearch != 'true')
							{
								Ext.getCmp('strEnabledSearch').hide();
							}
							else
							{
								Ext.getCmp('strEnabledSearch').show();
								isFireEnableSearch = true;
							}
							
							if (Ext.isEmpty(disableSearch) || disableSearch != 'true')
							{
								Ext.getCmp('strDisabledSearch').hide();
							}
							else
							{
								Ext.getCmp('strDisabledSearch').show();
								isFireDisableSearch = true;
							}
						}
						Ext.getCmp('noDataContainer').hide();
						Ext.getCmp('testDescItemSelector').show();
						Ext.getCmp('btnContainer').show();
						Ext.getCmp('testDescItemSelector').getStore().removeAll();
						Ext.getCmp('testDescItemSelector').getStore().clearFilter(true);
						Ext.getCmp('testDescItemSelector').getStore().loadRawData(publicJson['commonDescListArr']);
						Ext.getCmp('testDescItemSelector').setValue(publicJson['disableDescListObj']);

						if (isFireEnableSearch)
						{
							var strEnaFetchValue = Ext.getCmp('strEnabledSearch').getValue();
							if ( !Ext.isEmpty( strEnaFetchValue ) )
							{
								Ext.getCmp('strEnabledSearch').fireEvent('change', Ext.getCmp('strEnabledSearch'));
							}

						}

						if (isFireDisableSearch)
						{
							var strDisFetchValue = Ext.getCmp('strDisabledSearch').getValue();
							if ( !Ext.isEmpty( strDisFetchValue ) )
							{
								Ext.getCmp('strDisabledSearch').fireEvent('change', Ext.getCmp('strDisabledSearch'));
							}
						}
					}
					else
					{
						Ext.getCmp('testDescItemSelector').hide();
						Ext.getCmp('btnContainer').hide();
						Ext.getCmp('deleteBtnContainer').hide();
						Ext.getCmp('searchContainer').hide();
						Ext.getCmp('noDataContainer').show();
					}
				}
			});
		}
	},
	updateData : function(btn)
	{
		var me = this;
		var compTypeVal = Ext.getCmp('compTypeCombo').getValue();
		var compNameVal = Ext.getCmp('compNameCombo').getValue();
		var testNameVal = Ext.getCmp('testCombo').getValue();
		var timeLineVal = Ext.getCmp('timeLineCombo').getValue();
		Ext.getCmp('processUpdateContainer').hide();

		var strEnabledSearch = Ext.getCmp('strEnabledSearch');
		var strDisabledSearch = Ext.getCmp('strDisabledSearch');
		var isSearchBox = "";
		if (compTypeVal == "-1")
		{
			Ext.Msg.show ({
				title: pageName,
				msg: alert1,
				width: alert1.length * 7,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation',
			});
			return;
		}
		else if (compNameVal == "-1")
		{
			Ext.Msg.show ({
				title: pageName,
				msg: alert5,
				width: alert5.length * 7,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation',
			});
			return;
		}
		else if (testNameVal == "-1")
		{
			Ext.Msg.show ({
				title: pageName,
				msg: alert6,
				width: alert6.length * 7,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation',
			});
			return;
		}
		
		if(strEnabledSearch != null)
		{
			if(strEnabledSearch == null || strEnabledSearch == "undefined" || strEnabledSearch == "null")
			{
				tmpVal = "";
				isSearchBox = "false";
			}
			else
			{
				tmpVal = strEnabledSearch.getValue();
				if(tmpVal == null || tmpVal == "undefined" || tmpVal == "null" || tmpVal == "" || tmpVal == "Search")
				{
					tmpVal = "";
					isSearchBox = "flase";
				}
				else
				{
					isSearchBox = "true";
				}
			}
		}

		var enableDescObj = Ext.getCmp('testDescItemSelector').fromField.store;
		var disableDescObj = Ext.getCmp('testDescItemSelector').toField.store;
		var enable_desc = '';
		var disable_desc = '';
		for (var i=0;i<enableDescObj.getCount();i++ )
		{
			enable_desc += enableDescObj.getAt(i).get('valueField')+',';
		}
		for (var i=0;i<disableDescObj.getCount() ;i++ )
		{
			disable_desc += disableDescObj.getAt(i).get('valueField')+',';
		}


		if(enable_desc.length > 1)
		{
			enable_desc = enable_desc.substring(0,enable_desc.length-1);
		}
		if(disable_desc.length > 1)
		{
			disable_desc = disable_desc.substring(0,disable_desc.length-1);
		}
		Ext.getCmp('enabledDescList').setValue(enable_desc);
		Ext.getCmp('disabledDescList').setValue(disable_desc);

		var flagEnable = false;
		var enableDesc_Only = new Array();
		var newlyEnabledStr = Ext.getCmp('enabledDescList').getValue();
		var EnabledStr = publicJson['checkEnabledDesc'];
		EnabledStr = ","+EnabledStr+",";
		var newlyEnabledDesc="";
		var newlyEnabledDescTokens = newlyEnabledStr.split(",");
		for(i = 0; i < newlyEnabledDescTokens.length; i++)
		{
			newlyEnabledDesc = newlyEnabledDescTokens[i];
			if(EnabledStr.indexOf(","+newlyEnabledDesc+",") == -1)
			{
				enableDesc_Only[i] = newlyEnabledDesc;
				flagEnable = true;
			}
		}
		
		var flagDisable = false;
		var disableaction = "false";
		var disableDesc_Only = new Array();
		var newlyDisabledStr = Ext.getCmp('disabledDescList').getValue();
		var DisabledStr = publicJson['checkDisabledDesc'];
		var newlyDisabledDesc="";
		var newlyDisabledDescTokens = newlyDisabledStr.split(",");
		DisabledStr = ","+DisabledStr+",";
		for(i = 0; i < newlyDisabledDescTokens.length; i++)
		{
			newlyDisabledDesc = newlyDisabledDescTokens[i];
			if(DisabledStr.indexOf(","+newlyDisabledDesc+",") == -1)
			{
				disableDesc_Only[i] = newlyDisabledDesc;
				disableaction = "true";
				flagDisable = true;
			}
		}
		//thisForm.enableDesc_Only.value = enableDesc_Only;
		//thisForm.disableDesc_Only.value = disableDesc_Only;
		if(flagEnable || flagDisable)
		{
			var qStr = 'server='+encodeURIComponent(compTypeVal)+'&comp='+encodeURIComponent(compNameVal)+'&testName='+encodeURIComponent(testNameVal)+'&duration='+encodeURIComponent(timeLineVal)+'&isSearchBox='+isSearchBox+'&disableaction='+disableaction;
			var tmpURL = 'TestDescriptors/data/Egtestinfoviewp.jsp?'+qStr;
			me.updateSelectedDescriptors(tmpURL);
			
		}
		else
		{
			Ext.Msg.show ({
				title: pageName,
				msg: alert7,
				width: alert7.length * 7,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation',
			});
			return;
		}
	},
	updateSelectedDescriptors : function(tmpURL)
	{
		var me = this;
		var compTypeVal = Ext.getCmp('compTypeCombo').getValue();
		var compNameVal = Ext.getCmp('compNameCombo').getValue();
		var testNameVal = Ext.getCmp('testCombo').getValue();
		var timeLineVal = Ext.getCmp('timeLineCombo').getValue();
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		myMask.show();
		var frmMain = this.getTestdescriptors().getForm();
		var enabledDesc = Ext.getCmp("enabledDescList").getValue();
		var disabledDesc = Ext.getCmp("enabledDescList").getValue();
		var availSearch = Ext.getCmp("strEnabledSearch").getValue();
		var disableSearch = Ext.getCmp("strDisabledSearch").getValue();
		var qString = 'server='+encodeURIComponent(compTypeVal)+'&comp=' + encodeURIComponent(compNameVal) +'&testName='+ testNameVal +'&duration=' + timeLineVal+ '&requestFrom=processUpdated';
		if(availSearch != null && availSearch != 'undefined')
		{
			qString += '&strEnabledSearch='+availSearch;
		}
		if(disableSearch != null && disableSearch != 'undefined')
		{
			qString += '&strDisabledSearch='+disableSearch;
		}
		if (frmMain.isValid())
		{
			this.getTestdescriptors().submit({
				url: tmpURL,
				method: 'POST',
				timeout: 9000,
				//standardSubmit: true
				success: function(form, action){
					myMask.hide();
					me.afterDescriptorDeleted(qString);
					Ext.getCmp("disabledDescList").setValue("");
					Ext.getCmp("enabledDescList").setValue("");
				},
				failure: function(form, action) // if result page doest not contain success:true, this method fires
				{
					Ext.getCmp("disabledDescList").setValue("");
					Ext.getCmp("enabledDescList").setValue("");
					myMask.hide();

					 switch (action.failureType) {
						case Ext.form.action.Action.CLIENT_INVALID:
							Ext.Msg.show ({
								title: pageName,
								msg: 'Form fields may not be submitted with invalid values',
								buttons: Ext.MessageBox.OK,
								icon: 'iconExclamation',
							});
							break;
						case Ext.form.action.Action.CONNECT_FAILURE:
							Ext.Msg.show ({
								title: pageName,
								msg: 'Ajax communication failed',
								buttons: Ext.MessageBox.OK,
								icon: 'iconExclamation',
							});
							break;
						case Ext.form.action.Action.SERVER_INVALID:
							Ext.Msg.show ({
								title: action.result.msg,
								msg: 'Ajax communication failed',
								buttons: Ext.MessageBox.OK,
								icon: 'iconExclamation',
							});
				   }
				}
			});
		}
	}
});
