Ext.define('Transactions.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Transactions','TransactionManagement'],
	refs:[
		{selector:'transactionmanagement', ref:'transactionmanagement'},
		{selector:'transactions', ref:'transactions'}
	],
	init:function(){
		appCnt=this;
		this.buildFieldData()

		this.control({
			'transactions':
			{
				'afterrender': this.afterMainRender
			},
			'transactions [id="gridDisplay"]': {
				//'itemmouseenter': this.showActions,
				//'itemmouseleave': this.hideActions
			},
			/*'transactions trigger[name="gridSearch"]': {
				'change': this.mainGridSearch
			},*/
			'transactions combo[id="sitecombo"]':
			{
				'select': this.siteComboLoad
			},
			'transactions button[id="addTransaction"]': {
				'click': this.addTransaction
			},
			'transactionmanagement button[id="addBtn"]':
			{
				'click': this.updation
			},
			'transactionmanagement button[id="backbutton"]':
			{
				'click': this.backbutton
			}
		});
	},
	showActions: function(view, task, node, rowIndex, e){
		var hideIcon = view.getStore().getAt(rowIndex);
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
			Ext.get(icon).removeCls('x-hidden');
		});
	},

	hideActions: function(view, task, node, rowIndex, e){
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
		Ext.get(icon).addCls('x-hidden');
	});
	},
	
	/*mainGridSearch : function(obj){
		var gridsearch = Ext.getCmp('gridSearch').getValue();
		Ext.Ajax.request({
			url: 'Transactions/data/EgConfigTransJson.jsp?egTitleSearchStr='+gridsearch,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
				var value = publicJSON['GridValues'];
				Ext.getCmp('gridDisplay').show();
				//Ext.getCmp('NoExtPresent').hide();
				if (value != null && value.length > 0)
				{
					Ext.getCmp('gridDisplay').store.loadData(publicJSON['GridValues']);
				}
				else
				{
					Ext.getCmp('gridDisplay').store.loadData('');
					Ext.Msg.alert("Message",publicJSON['screenLabels']['searchResult']);
				}
			}
		});
	},*/
	handleDeleteIconClick: function(grid, rowIndex, colIndex){
		btnText = 'Delete';
		var rec = grid.getStore().getAt(rowIndex);
		var deleteUrl = rec.get('DeleteUrl');
		Ext.Msg.confirm(mainPageTitle, publicJSON['screenLabels']['admin.service.DeleteConfirmMessage']+' \''+rec.get('Transactionname')+'\'', function(buttonText) {
			if (buttonText == "yes") 
			{
				Ext.Ajax.request({
					url: deleteUrl,
					method: 'POST',
					async: false,
					success: function( response )
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var jsonText = response.responseText;
							var deleteJson = Ext.decode( jsonText );
							window.location.href = deleteJson['URL'];
						}
					}
				});
			}
		});
	},
	handleDeleteSelected: function(){
		var grid=Ext.getCmp('gridDisplay').getSelectionModel().getSelection();
		var values='';
		var array=new Array();
		var selectedTransactions="";
		if(grid=="")
		{
			Ext.MessageBox.alert(mainPageTitle,publicJSON['screenLabels']['no transaction selected']);
			return false;
		}
		for(var i=0; i < grid.length ; i++)
		{
			values=grid[i];
			id=values.get('Transactionname');
			if(id!=null)
			{
				array.push(id);
			}
		}
		for(var j=0; j < array.length; j++)
		{
			selectedTransactions +=array[j]+",";
		}
		var sitename = Ext.getCmp('sitecombo').getValue();
		Ext.Msg.confirm(mainPageTitle, publicJSON['screenLabels']['admin.service.DeleteSelectedConfirmMessage'], function(buttonText) {
			if (buttonText == "yes") 
			{
				var resultUrl = "Transactions/data/Egconfigtransp.jsp?site="+encodeURIComponent(sitename)+"&trans="+encodeURIComponent(selectedTransactions)+"&mode=del";
				Ext.Ajax.request({
					url: resultUrl,
					method: 'POST',
					async:false,
					success: function( response )
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var myjsonText = response.responseText;
							var myjsonObj = Ext.decode( myjsonText );
							window.location.href = myjsonObj['URL'];
						}
					}
				});
			}
		});
	},

	buildFieldData: function(){
		Ext.Ajax.request({
			url: 'Transactions/data/EgDispSiteTransJson.jsp?reqfrom=navlink',
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	afterMainRender : function()
	{
		if(comeFrom!=null && comeFrom=='resultPage')
		{
			Ext.getCmp('sitecombo').getStore().suspendEvents(true);
			Ext.getCmp('sitecombo').getStore().clearFilter(true);
			Ext.getCmp('sitecombo').getStore().loadRawData(publicJSON['ListOfSites']);
			Ext.getCmp('sitecombo').getStore().resumeEvents();
			this.siteComboLoad();
			return;
		}
		var siteNotFound = publicJSON['NoExtFound'];
		var res = publicJSON['GridValues'];
		if(siteNotFound=='false')
		{
			Ext.getCmp('NoExtPresent').hide();

			Ext.getCmp('sitecombo').getStore().suspendEvents(true);
			Ext.getCmp('sitecombo').getStore().clearFilter(true);
			Ext.getCmp('sitecombo').getStore().loadRawData(publicJSON['ListOfSites']);
			Ext.getCmp('sitecombo').getStore().resumeEvents();
			Ext.getCmp('gridDisplay').getStore().suspendEvents(true);
			Ext.getCmp('gridDisplay').getStore().loadRawData(res);
			Ext.getCmp('gridDisplay').getStore().resumeEvents();
			Ext.getCmp('sitecombo').setValue('-1');
			Ext.getCmp('addTransaction').disable();
		}
		else if(siteNotFound == 'true')
		{
			Ext.getCmp('sitecombo').hide();
			Ext.getCmp('NoExtPresent').show();
			Ext.getCmp('gridDisplay').hide();
		}
	},
	backbutton: function()
	{
		//window.location.href="EgComponentTransactions.jsp";
		var str_sitename = Ext.getCmp('sitename').getValue();
		var qs = "EgComponentTransactions.jsp?site="+encodeURIComponent(str_sitename)+"&comeFrom=resultPage";
		window.location.href=qs;
	},

	siteComboLoad: function()
	{
		var sitename ='';
		if(comeFrom!=null && comeFrom=='resultPage')
		{
			Ext.getCmp('sitecombo').setValue(siteName);
			sitename = siteName;
			comeFrom='';
		}
		else
		{
			sitename = Ext.getCmp('sitecombo').getValue();
		}
		if(sitename=='-1')
		{
			Ext.getCmp('gridDisplay').store.loadData('');
			Ext.getCmp('gridDisplay').getView().emptyText = '<table border="0" height="350px" width="100%"><tr><td align=center valign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+chooseSite+'.</div></td></tr></table>',
			Ext.getCmp('gridDisplay').getView().refresh();
			Ext.getCmp('addTransaction').disable();
			return false;
		}
		else
		{
			Ext.getCmp('addTransaction').enable();
		}
		Ext.Ajax.request({
			url: 'Transactions/data/EgConfigTransJson.jsp?comeFrom=resultPage&site='+encodeURI(sitename),
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );

					var resultsData = publicJSON['GridValues'];
					if (Ext.isEmpty(resultsData))
					{
						if(sitename=='-1')
						{
							Ext.getCmp('gridDisplay').store.loadData('');
							Ext.getCmp('gridDisplay').getView().emptyText = '<table border="0" height="350px" width="100%"><tr><td align=center vlaign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+chooseSite+'.</div></td></tr></table>',
							Ext.getCmp('gridDisplay').getView().refresh();
						}
						else
						{
							Ext.getCmp('gridDisplay').store.loadData('');
							Ext.getCmp('gridDisplay').getView().emptyText = '<table border="0" height="350px" width="100%"><tr><td align=center valign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+noTransMsg+'</div></td></tr></table>',
							Ext.getCmp('gridDisplay').getView().refresh();
						}
					}
					else
					{
						Ext.getCmp('gridDisplay').show();
						Ext.getCmp('gridDisplay').getStore().suspendEvents(true);
						Ext.getCmp('gridDisplay').getStore().loadRawData(resultsData);
						Ext.getCmp('gridDisplay').getStore().resumeEvents();
					}
				}
			}
		});
	},
	addTransaction: function()
	{
		var sitename = Ext.getCmp('sitecombo').getValue();
		if(sitename!='-1')
		{
			var topoController = this.getController('Transactions.controller.ConfigTransControl');
			Ext.getCmp('viewport').removeAll();
			topoController.buildFieldData(sitename);
			Ext.getCmp('viewport').add({xtype: 'transactionmanagement'});
			topoController.afterMainRender(sitename);
		}
	},
	updation: function(btn)
	{
		var topoController = this.getController('Transactions.controller.ConfigTransControl');
		var siteName = Ext.getCmp('sitename').getValue();
		var sub = "true";
		var radioval = "";
		var formflag = "1";
		var transCount = publicJSON['hiddenValues']['trancount'];
		var transList = Ext.getCmp('pageName').getValue();

		var allTransList = publicJSON['hiddenValues']['translist'];
		var trans_arr=allTransList.split(";");
		var transNm=Ext.getCmp('transName').getValue();
		var radios = document.getElementsByName("m");
		for(var i = 0; i < radios.length; i++) {
		   if(radios[i].checked == true) {
			   radioval = radios[i].value;
		   }
		}

		for(var j=0;j < trans_arr.length;j++)
		{
			if(transNm.toLowerCase() == trans_arr[j].toLowerCase())
			{
				formflag = "0";
			}
		}
		var s_spl="`~!@#$%^&*()+={}[]|\\:;\"\'<>,.?\/";
		var s_spl_page="`~!@#$%^()[]{}|;\'\"<>";
		if(formflag == "0")
		{
			Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.service.enter unique name']);
			sub = "false";
			return false;
		}
		if(transNm.length == 0)
		{
			Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.service.enter transaction name']);
			sub = "false";
			return false;
		}
		else
		{
			// For pages Associated
			if(transList.length == 0)
			{
				Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.service.enter pages associated']);
				sub = "false";
				return false;
			}
			else
			{
				if (transList.indexOf(",") > -1) 
				{
					var len = transList.length;
					if (transList.charAt(0) == "," || transList.charAt(len - 1) == ",") 
					{
						Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.service.enter pages associated']);
						sub = "false";
						return false;
					}
				}
				for (i = 0; i < transList.length; i++) 
				{
					var check_char = s_spl_page.indexOf(transList.charAt(i));
					var isDouble = publicJSON['isDouble'];
					if(!isDouble)
					{
						if (transList.charCodeAt(i) > 255) 
						{
							sub = "false";
							Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.service.DBL not allowed']);
							return false;
						}
					}
					if (transList.charAt(i - 1) == " ") 
					{
						sub = "false";
						Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.service.enter transaction name']);
						return false;
					} 
					else if(check_char >= 0)
					{
						sub = "false";
						Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.service.special characters not allowed']);
						return false;
					}
					else if (transList.charAt(i) == " ") 
					{
						sub = "false";
						Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.service.space not allowed']);
						return false;
					}
					else
					{
						sub="true";
					}
				}
			}
			// For transaction name
			for (i = 0; i < transNm.length; i++) 
			{
				var check_char = s_spl.indexOf(transNm.charAt(i));
				var isDouble = publicJSON['isDouble'];
				if(!isDouble)
				{
					if (transNm.charCodeAt(i) > 255) 
					{
						sub = "false";
						Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.service.DBL not allowed']);
						return false;
					}
				}
				if (transNm.charAt(i - 1) == " ") 
				{
					sub = "false";
					Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.service.enter transaction name']);
					return false;
				} 
				else if(check_char >= 0)
				{
					sub = "false";
					Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.service.special characters not allowed']);
					return false;
				}
				else if (transNm.charAt(i) == " ") 
				{
					sub = "false";
					Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.service.space not allowed']);
					return false;
				}
				else
				{
					sub="true";
				}
			}
			// Others
			if(!validateTrans())
			{
				sub = "false";
			}
			else if(radioval=="")
			{
				Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.service.select image']);
				sub = "false";
				return false;
			}
			else if(transCount > 15  || transCount == 15)
			{
				Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.service.transaction cannot exceed 15']);
				sub = "false";
				return false;
			}
			else
			{
				sub="true";
			}
			if(sub=='true')
			{
				var resultUrl = "Transactions/data/Egconfigtransp.jsp?mode=add"+"&site="+encodeURIComponent(siteName)+"&tran="+encodeURIComponent(transNm)+"&tranlist="+encodeURIComponent(transList)+"&m="+radioval;
				Ext.Ajax.request({
					url: resultUrl,
					method: 'POST',
					async: false,
					success: function( response )
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var jsonText = response.responseText;
							var mypublicJSON = Ext.decode( jsonText );
							//window.location.href=mypublicJSON['URL'];
							Ext.Msg.show({
								title : pageTitle,
								msg : publicJSON['screenLabels']['admin.service.successMsg'],
								icon : 'iconInformation',
								buttons : Ext.Msg.OK
							});
							Ext.getCmp('viewport').removeAll();
							topoController.buildFieldData(siteName);
							Ext.getCmp('viewport').add({xtype: 'transactionmanagement'});
							topoController.afterMainRender(siteName);
						}
					}
				});
			}
		}
	}
});

function checkUniquePage(pagename)
{
	var pages = Ext.getCmp('pageName').getValue();
	var pages_list =  pages.split(',');
	var count = 0;

	for(var k=0;k < pages_list.length;k++)
	{
		if(pages_list[k] == pagename)
		{
			count = count + 1;
		}
	}
	if(count > 1)
	{
		return false;
	}
	else
	{
		return true;
	}
}
function validateTrans()
{
	var transname = Ext.getCmp('transName').getValue();
	var pages = Ext.getCmp('pageName').getValue();
	var maxcount = eval(6);
	var check;
	num = 0;
	if(pages.indexOf(",") > -1)
	{
		for(var k=0;k < pages.length;k++)
		{
			if(pages.charAt(k) == ',' && pages.charAt(k + 1) == ',')
			{
				Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.service.noComma']);
				return false;
			}
			else
			{
				continue;
			}
		}
		var pages_list =  pages.split(',');
		if(pages_list.length > maxcount)
		{
			Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.service.MaxPages']);
			return false;
		}
		for(var x=0;x < pages_list.length;x++)
		{
			check = pages_list[x];
			num = 0;
			for(c=0; c < check.length; c++)
			{
				if(check.charAt(c) == '*')
				{
					num++;
				}
			}
			if(num > 6)
			{
				Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.service.MaxPatterns']);
				return false;
			}
			if(!checkUniquePage(pages_list[x]))
			{
				Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.service.unique page name']);
				return false;
			}
			if(pages_list[x].length > 64)
			{
				Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.service.MaxLength']);
				return false;
			}
		}
	}
	else
	{
		for(c=0; c < pages.length; c++)
		{
			if(pages.charAt(c) == '*')
				{
					num++;
				}
		}
		if(num > 6)
		{
			Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.service.MaxPatterns']);
			return false;
		}
		if(pages.length > 64)
		{
			Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.service.MaxLength']);
			return false;
		}
	}
	return true;
}
