Ext.define('Transactions.view.Transactions', {
	extend: 'utilities.innerScrollContainer',
	alias: 'widget.transactions',
	id: 'mainTransactions',
	cls:'outerpanel',
	title: mainPageTitle,
	header:{cls:'textUpper'},
	margin:'8 8 0 8',

	requires: [
		'Ext.ux.CheckColumn',
		'Ext.ux.RowExpander',
		'Ext.grid.*',
		'utilities.innerScrollContainer',
		'utilities.CustomGrid',
		'utilities.ScrollCombo'
	],

	dockedItems: [{
		xtype: 'toolbar',
		dock: 'top',
		cls:'adminHeadInfoText',
		height: 25,
		padding: 3,
		border:true,
		layout:{pack:'center'},
		items: [
			{
				xtype: 'component',
				html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp&nbsp'+pageDescc+'.</center>'
			}
		]
	}],

	items: [
		{
			xtype: 'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			margin: '10 0 5 0',
			items: [
				{
					xtype: 'scrollcombo',
					cls:'dropdown',
					fieldLabel: sitename,
					id:'sitecombo',
					name:'sitecombo',
					labelAlign: 'top',
					labelSeparator: ' ',
					width: 300,
					displayField:'displayField',
					valueField:'valueField',
					queryMode: 'local',
					emptyText:'--Select--',
					parent:this,
					store:new Ext.data.Store({
						fields: ['displayField','valueField'],
						data: []
					})
					//,editable:false
				}
			]
		},
		{
			xtype: 'container',
			id: 'NoExtPresent',
			hidden:true,
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			items: [
				{
					xtype: 'label',
					html: '<table border="0" height="350px" width="100%"><tr><td align=center valign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+noSiteMsg+'</div></td></tr></table>',
				}
			]
		},
		{
			xtype: 'customgrid',
			id: 'gridDisplay',
			cls:'gridSkin',
			store:new Ext.data.Store({
				fields: ['Transactionname','Pagesincluded','DeleteUrl'],
				data: []
			}),
			selModel: {
				selType: 'checkboxmodel',
				mode: 'MULTI',
				checkOnly: true
			},
			viewConfig: {
				deferEmptyText: true
			},
			flex : 1,
			emptyText : '<table border="0" height="350px" width="100%"><tr><td align=center valign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+chooseSite+'.</div></td></tr></table>',
			columns: {
				defaults: {
					sortable: true,
					hideable: false,
					menuDisabled: true,
					draggable: false,
					resizable: false
				},
				items: [
					{
						text: Transactionname,
						dataIndex: 'Transactionname',
						id: 'DispTransactionname',
						flex:1
					},
					{
						text: pages,
						dataIndex: 'Pagesincluded',
						id: 'DispPagesincluded',
						flex:1,
						renderer :function (data, metadata, record, rowIndex, columnIndex, store) 
						{
							var array = data.split(",");
							var resultArray='';
							for(var a=0;a<array.length;a++)
							{
								if(a==0)
									resultArray = array[a];
								else
									resultArray = resultArray+", "+array[a];
							}
							return resultArray;
						}
					},
					{
						header : '<div class="iconDeleteAll" data-qtip="Delete Selected" data-qclass="yellowTip"></div>',
						xtype: 'actioncolumn',
						//cls: 'tasks-icon-column-header tasks-delete-column-header',
						width: 36,
						id: 'DeleteOver',
						//icon: '../../../../resources/images/delete.png',
						iconCls: 'iconDelete',
						//tooltip: 'Delete Selected',
						sortable: false,
						listeners: {
							headerclick: function(g, index, ev) {
								appCnt.handleDeleteSelected();
							}
						},
						renderer: function(value, metaData, record, row, col, store, gridView)
						{
							metaData.tdAttr = "data-qtip='Delete' data-qclass='yellowTip'";
						},
						handler: function(grid, rowIndex, colIndex) {
							appCnt.handleDeleteIconClick(grid, rowIndex, colIndex);
						}
					}
				]
			},
			margin: '5 10 10 10',
			tbar: [
				{
					xtype:'tbfill',
				},
				{
					xtype: 'toolbar',
					ui: 'footer',
					items:[
						{
							xtype: 'button',
							cls: 'button20',
							text: addTrans,
							id: 'addTransaction'
						}
					]
				}
			]
		}
	]

});



