Ext.define('TrapReceiversAndSettings.controller.Main',{
	extend: 'Ext.app.Controller',
	refs:[
		{selector:'snmptrapreceivers', ref:'snmptrapreceivers'},
		{selector:'main', ref:'main'},
		{selector:'egmailalertsuppress', ref:'egmailalertsuppress'}
	],
	init:function(){
		me = this,
		//this.buildFieldData()
		this.control({
			'snmptrapreceivers':
			{
				'boxready': this.buildFieldData
			},
			'snmptrapreceivers combo[id="snmpversioncomboadd"]':
			{
				'change': this.comboLoad
			},
			'snmptrapreceivers button[id="addUpdateBtn"]':
			{
				'click': this.updateData
			},
			'snmptrapreceivers button[id="modifyUpdateBtn"]':
			{
				'click': this.modifyUpdateData
			},
			'snmptrapreceivers radiogroup[id="encryptradioAdd"]':
			{
				'change': this.changeEncryptType
			},
			'snmptrapreceivers radiogroup[id="modifyEncryptFlagRadio"]':
			{
				'change': this.changeModifyEncryptType
			},
			'snmptrapreceivers tabpanel[id="snmp"]':
			{
				'tabchange': this.tabChange
			},
			'snmptrapreceivers button[id="deleteBtn"]':
			{
				'click': this.deleteSnmpMgr
			},
			'snmptrapreceivers combo[id="modifySnmpMgrIpCombo"]':
			{
				'select': this.modifySnmpMgrComboLoad
			},
			'snmptrapreceivers combo[id="modifySnmpVersionCombo"]':
			{
				'select': this.modifySnmpVersionComboLoad
			},
			'snmptrapreceivers button[id="settingsUpdateBtn"]':
			{
				'click': this.settingsUpdateData
			},
			'main':
			{
				'boxready':this.afterMainRender
			},
			'main button[id="backButton"]':
			{
				'click':this.goBack
			},
			'egmailalertsuppress combo[id="filter"]':
			{
				'select':this.popFilterDetails
			},
			'egmailalertsuppress combo[id="CompTypes"]':
			{
				'select':this.popCompTypes
			},
			'egmailalertsuppress combo[id="TestTypes"]':
			{
				'select':this.popTestTypes
			},
			'egmailalertsuppress combo[id="compTypesIn"]':
			{
				'select':this.viewByCriteria
			},
			'egmailalertsuppress combo[id="serseg"]':
			{
				'select':this.changeByServer
			},
			'egmailalertsuppress combo[id="Test"]':
			{
				'select':this.changeByTest
			},
			'egmailalertsuppress multiselectSi[id="compName"]':
			{
				'change':this.changeByComponentName
			},
			'egmailalertsuppress button[id="includeMore"]':
			{
				'click':this.assignAndAddMoreFilters
			},
			'egmailalertsuppress button[id="mailSubmit"]':
			{
				'click':this.submitUserFilterElements
			},
			'egmailalertsuppress button[id="btnViewFilters"]':
			{
				'click':this.viewFilteredElements
			},
			'egmailalertsuppress button[id="componentExpander"]':
			{
				'click':this.showComponentSelector
			},
			'egmailalertsuppress trigger[name="searchbox"]':
			{
				'change': this.egTitleSearch
			}
		});
	},
	goBack : function()
	{
		window.location.href = "/final/admin/EgSnmpConfig.jsp";
	},
	afterMainRender:function()
	{
		//alert("afterMainRender--"+reqFrom)
		var mainObj = Ext.getCmp('main');
		var mailAlertSuppressObj = Ext.getCmp('egmailalertsuppress');
		if (reqFrom != 'navlink' && reqFrom != 'adduser')
		{
			Ext.getCmp('backButton').show();
		}

		var me = this;
		mainObj.setTitle(pageTitle4 +" '"+selectedUserID+"'");
		//if (Ext.isEmpty(mailAlertSuppressObj))
		//{
			//mainObj.removeAll();
			//mainObj.add({xtype : 'egmailalertsuppress'});

		//}
		var tmpUserID = selectedUserID;
		var url = "TrapReceiversAndSettings/data/EgMailAlertSuppressJson.jsp?userID="+encodeURIComponent(tmpUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom+"&date="+new Date().getTime();
		me.updateUserMailSuppressList(url);
		me.updateFilterComponents();
		var isComponentsAssociated = userMailJSON.isComponentsAssociated;
		if (isComponentsAssociated)
		{
			if (mailFilterOption == "Descriptors_Only")
			{
				if (Ext.getCmp('egmailalertsuppress') != undefined)
				{
					Ext.getCmp('filter').hide();
					Ext.getCmp('filterLabelID').show();
					me.showFilterDetails();
					Ext.getCmp('btnViewFilters').setText(pageIntnl97);
				}
			}
			else
			{

				if (Ext.getCmp('egmailalertsuppress') != undefined)
				{
					Ext.getCmp('filter').show();
					Ext.getCmp('filterLabelID').hide();
					Ext.getCmp('btnViewFilters').setText(pageIntnl87);
				}
			}
		}
		me.initUserMailConfigs();
	},
	popFilterDetails : function(obj)
	{
		var me = this;
		var page ="TrapReceiversAndSettings/data/EgMailAlertSuppressJson.jsp?userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
		var selectedOption = obj.getValue();
		if(selectedOption != "-1")
		{
			page = page+"&filterBy="+selectedOption;
			if(selectedOption == "filterByCName" || selectedOption == "filterByDescriptor")
			{
				page = page + "&serverType=-1";
			}
			else if(selectedOption == "filterByLayer" || selectedOption == "filterByTest")
			{
				page = page + "&serverType=filterByAll";
			}
			page = page + "&date="+new Date().getTime();
			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}
					if (!Ext.isEmpty(excludedItems))
					{
						//tmpStore.getStore().loadRawData(excludedItems);
						tmpStore.fromField.store.add(excludedItems);
					}
					if (!Ext.isEmpty(includedItems))
					{
						tmpStore.toField.store.add(includedItems);
					}
					var compTypeContainer = Ext.getCmp('CompTypes');
					var compTypesInCt = Ext.getCmp('compTypesIn');
					var serverTestsOuterCt = Ext.getCmp('serverTestsOuterCt');
					compTypeContainer.hide();
					compTypesInCt.hide();
					serverTestsOuterCt.hide();
					Ext.getCmp('serseg').hide();
					if(selectedOption == "filterByCName" || selectedOption == "filterByLayer" || selectedOption == "filterByTest" || 
						selectedOption == "filterByDescriptor")
					{
						var tmpCompObj = Ext.getCmp('CompTypes');
						var compopnentTypes = userMailJSON['compopnentTypes'];
						tmpCompObj.getStore().loadRawData(compopnentTypes);
						if (selectedOption == "filterByCName" || selectedOption == "filterByDescriptor")
						{
							tmpCompObj.setValue("-1");
						}
						else
						{
							tmpCompObj.setValue("filterByAll");
						}
						if (userMailJSON.isOtherGroupsFound)
						{
							compTypesInCt.getStore().loadRawData(userMailJSON.viewBy);
							compTypesInCt.setValue(userMailJSON.displayText);
							compTypesInCt.show();
							if (compTypesInCt.getValue() != 'cType')
							{
								Ext.getCmp('serseg').show();
							}
						}
						else
						{
							compTypesInCt.hide();
						}

						compTypeContainer.show();
						if (selectedOption == "filterByDescriptor")
						{
							var testObj = Ext.getCmp('Test');
							Ext.getCmp('compName').getStore().removeAll();
							serverTestsOuterCt.show();
							Ext.getCmp('searchbox').setDisabled(true);
							Ext.getCmp('searchbox').setValue('');
							testObj.show();
							testObj.getStore().removeAll();
							testObj.getStore().loadRawData(userMailJSON.testArray);
							testObj.setValue("-1");
						}
					}
					var testTypeObj = Ext.getCmp('TestTypes');
					if(isConfigEnabled == "true")
					{
						if(selectedOption == "filterByTest")
						{
							testTypeObj.show();
							testTypeObj.getStore().removeAll();
							testTypeObj.getStore().loadRawData(userMailJSON.testTypesArr);
							testTypeObj.setValue("performance");
						}
						else
						{
							testTypeObj.hide();
						}
					}
					else
					{
						testTypeObj.hide();
					}
					tmpStore.fromField.getComponent(0).setTitle(userMailJSON['itemTitle1']);
					tmpStore.toField.getComponent(0).setTitle(userMailJSON['itemTitle2']);
				}
			});
		}
		else
		{
			Ext.suspendLayouts();
			var tmpStore = Ext.getCmp('exclude');
			tmpStore.fromField.getComponent(0).setTitle("Excluded from alerts");
			tmpStore.toField.getComponent(0).setTitle("Included for alerts");
			Ext.getCmp('CompTypes').hide();
			Ext.getCmp('compTypesIn').hide();
			Ext.getCmp('serseg').hide();
			Ext.getCmp('serverTestsOuterCt').hide();
			Ext.resumeLayouts(true);
		}
	},
	popCompTypes : function(obj)
	{
		var tmpUserID = publicJSON.userID;
		var filterBy = Ext.getCmp('filter').getValue();
		var serverType = obj.getValue();
		var configTestType = "no";
		if(isConfigEnabled == "true")
		{
			var testType = Ext.getCmp('TestTypes').getValue();
			if(testType == "configuration")
			{
				configTestType = "yes";
			}
		}
		var page = "";
		if (mailFilterOption == "Descriptors_Only")
		{
			page ="TrapReceiversAndSettings/data/EgMailAlertIncludeSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom+"&configTestType="+configTestType;
			page = page + "&filterBy=filterByDescriptor&serverType="+encodeURIComponent(serverType)+"&date="+new Date().getTime();
			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}
					if (!Ext.isEmpty(excludedItems))
					{
						tmpStore.fromField.store.add(excludedItems);
					}
					if (!Ext.isEmpty(includedItems))
					{
						tmpStore.toField.store.add(includedItems);
					}

					var serverTestsOuterCt = Ext.getCmp('serverTestsOuterCt');
					var testCt = Ext.getCmp('Test');
					//if (filterBy == "filterByDescriptor")
					{
						Ext.getCmp('searchbox').setDisabled(true);
						Ext.getCmp('searchbox').setValue('');

						testCt.getStore().removeAll();
						Ext.getCmp('compName').getStore().removeAll();
						testCt.getStore().loadRawData(userMailJSON.testArray);
						testCt.setValue(userMailJSON.selectedDescriptorText);
					}
					if (mailFilterOption == "Descriptors_Only")
					{
						tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
						tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
					}
				}
			});
		}
		else
		{
			page ="TrapReceiversAndSettings/data/EgMailAlertSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy="+filterBy+"&serverType="+encodeURIComponent(serverType)+"&date="+new Date().getTime();
			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}
					if (!Ext.isEmpty(excludedItems))
					{
						tmpStore.fromField.store.add(excludedItems);
					}
					if (!Ext.isEmpty(includedItems))
					{
						tmpStore.toField.store.add(includedItems);
					}

					var serverTestsOuterCt = Ext.getCmp('serverTestsOuterCt');
					var testCt = Ext.getCmp('Test');
					//var serverTestsCt = Ext.getCmp('serverTestsCt');
					if (filterBy == "filterByDescriptor")
					{
						testCt.getStore().removeAll();
						testCt.getStore().loadRawData(userMailJSON.testArray);
						testCt.setValue(userMailJSON.selectedDescriptorText);
						serverTestsOuterCt.show();
						Ext.getCmp('compName').getStore().removeAll();
						Ext.getCmp('searchbox').setDisabled(true);
						Ext.getCmp('searchbox').setValue('');
						testCt.show();
						//serverTestsCt.hide();
					}
					else
					{
						serverTestsOuterCt.hide();
						testCt.hide();
						//serverTestsCt.hide();
					}
					if (mailFilterOption == "Descriptors_Only")
					{
						tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
						tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
					}
				}
			});
		}
	},
	popTestTypes : function(obj)
	{
		updateSettings = false;
		var tmpUserID = Ext.getCmp('uname').getValue();
		var filterBy = Ext.getCmp('filter').getValue();
		var testType = obj.getValue();
		var compTypesIn = Ext.getCmp('compTypesIn').getValue();
		var compTypes = Ext.getCmp('CompTypes').getValue();
		var serseg = Ext.getCmp('serseg').getValue();		
		var configTestType = "no";
		if(testType == "configuration")
		{
			configTestType = "yes";
		}
		var page = "";
		if (mailFilterOption == "Descriptors_Only")
		{
			page ="TrapReceiversAndSettings/data/EgMailAlertIncludeSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom+"&configTestType="+configTestType;
			page = page + "&filterBy=filterByDescriptor&compTypesIn="+encodeURIComponent(compTypesIn)+"&serseg="+encodeURIComponent(serseg)+"&serverType="+encodeURIComponent(compTypes)+"&Test="+encodeURIComponent(viewByTest)+"&date="+new Date().getTime();
		}
		else
		{
			page ="TrapReceiversAndSettings/data/EgMailAlertSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom+"&serverType="+encodeURIComponent(compTypes)+"&configTestType="+configTestType;
			page = page + "&filterBy="+filterBy+"&serverType="+encodeURIComponent(serverType)+"&compTypesIn="+encodeURIComponent(compTypesIn)+"&serseg="+encodeURIComponent(serseg)+"&date="+new Date().getTime();
		}
		Ext.Ajax.request({
			url : page,
			method: 'POST',
			success: function(response)
			{
				userMailJSON = Ext.decode(response.responseText);
				var tmpStore = Ext.getCmp('exclude');
				var includedItems = userMailJSON['includedAlerts'];
				var excludedItems = userMailJSON['excludedAlerts'];
				tmpStore.getStore().removeAll();
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
				if (!Ext.isEmpty(excludedItems))
				{
					tmpStore.fromField.store.add(excludedItems);
				}
				if (!Ext.isEmpty(includedItems))
				{
					tmpStore.toField.store.add(includedItems);
				}
				var serverTestsOuterCt = Ext.getCmp('serverTestsOuterCt');
				var testCt = Ext.getCmp('Test');
				if (filterBy == "filterByDescriptor")
				{
					testCt.getStore().removeAll();
					testCt.getStore().loadRawData(userMailJSON.testArray);
					testCt.setValue(userMailJSON.selectedDescriptorText);
					serverTestsOuterCt.show();
					Ext.getCmp('compName').getStore().removeAll();
					Ext.getCmp('searchbox').setDisabled(true);
					Ext.getCmp('searchbox').setValue('');
					testCt.show();
				}
				else
				{
					serverTestsOuterCt.hide();
					testCt.hide();
				}
				if (mailFilterOption == "Descriptors_Only")
				{
					tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
					tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
				}
			}
		});
	},
	viewByCriteria : function(obj)
	{
		var viewByValue = obj.getValue();
		var filterObj = Ext.getCmp("filter");
		var filterBy = filterObj.getValue();
		var sersegObj = Ext.getCmp('serseg');
		var testCombo = Ext.getCmp('Test');
		var compTypes = Ext.getCmp('CompTypes');
		var page = "";
		var me = this;
		if (mailFilterOption == "Descriptors_Only")
		{
			page ="2:31 TrapReceiversAndSettings/data/EgMailAlertIncludeSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy=filterByDescriptor&compTypesIn="+encodeURIComponent(viewByValue)+"&date="+new Date().getTime();
			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}

					if (viewByValue != 'cType')
					{
						sersegObj.setFieldLabel(userMailJSON.trDisplayText);
						sersegObj.getStore().loadRawData(userMailJSON.viewByType);
						sersegObj.setValue(userMailJSON.selectedGrpText);
						sersegObj.show();
						compTypes.getStore().removeAll();
						compTypes.getStore().loadData([
							{
								'displayField' : 'Not Applicable',
								'valueField' : '-1'
							}
						]);
						testCombo.getStore().removeAll();
						testCombo.getStore().loadData([
							{
								'displayField' : 'Not Applicable',
								'valueField' : '-1'
							}
						]);
						Ext.getCmp('compName').getStore().removeAll();
						Ext.getCmp('searchbox').setDisabled(true);
						Ext.getCmp('searchbox').setValue('');
					}
					else
					{
						me.popFilterDetails(filterObj);
						sersegObj.hide();
					}

					if(compTypes.getStore().getCount() > 0)
					{
						compTypes.setValue(compTypes.getStore().getAt(0));
					}
					if(testCombo.getStore().getCount() > 0)
					{
						testCombo.setValue(testCombo.getStore().getAt(0));
					}

					if (mailFilterOption == "Descriptors_Only")
					{
						tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
						tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
					}
				}
			});
		}
		else
		{
			page ="TrapReceiversAndSettings/data/EgMailAlertSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy="+filterBy+"&compTypesIn="+encodeURIComponent(viewByValue)+"&date="+new Date().getTime();
			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}

					if (viewByValue != 'cType')
					{
						sersegObj.setFieldLabel(userMailJSON.trDisplayText);
						sersegObj.getStore().loadRawData(userMailJSON.viewByType);
						sersegObj.setValue(userMailJSON.selectedGrpText);
						sersegObj.show();
						compTypes.getStore().removeAll();
						compTypes.getStore().loadData([
							{
								'displayField' : 'Not Applicable',
								'valueField' : '-1'
							}
						]);
						testCombo.getStore().removeAll();
						testCombo.getStore().loadData([
							{
								'displayField' : 'Not Applicable',
								'valueField' : '-1'
							}
						]);
						Ext.getCmp('compName').getStore().removeAll();
						Ext.getCmp('searchbox').setDisabled(true);
						Ext.getCmp('searchbox').setValue('');
					}
					else
					{
						me.popFilterDetails(filterObj);
						sersegObj.hide();
					}
					if(compTypes.getStore().getCount() > 0)
					{
						compTypes.setValue(compTypes.getStore().getAt(0));
					}
					if(testCombo.getStore().getCount() > 0)
					{
						testCombo.setValue(testCombo.getStore().getAt(0));
					}
					if (mailFilterOption == "Descriptors_Only")
					{
						tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
						tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
					}
				}
			});
		}
	},
	changeByServer : function(obj)
	{
		var viewByServer = obj.getValue();
		var filterBy = Ext.getCmp('filter').getValue();
		var compTypesIn = Ext.getCmp('compTypesIn').getValue();
		var CompTypesObj = Ext.getCmp('CompTypes');
		var testCombo = Ext.getCmp('Test');
		var page = "";
		if (mailFilterOption == "Descriptors_Only")
		{
			page ="TrapReceiversAndSettings/data/EgMailAlertIncludeSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy=filterByDescriptor&compTypesIn="+encodeURIComponent(compTypesIn)+"&serseg="+encodeURIComponent(viewByServer)+"&date="+new Date().getTime();
		}
		else
		{
			page ="TrapReceiversAndSettings/data/EgMailAlertSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy="+filterBy+"&compTypesIn="+encodeURIComponent(compTypesIn)+"&serseg="+encodeURIComponent(viewByServer)+"&date="+new Date().getTime();
		}

		Ext.Ajax.request({
			url : page,
			method: 'POST',
			success: function(response)
			{
				userMailJSON = Ext.decode(response.responseText);
				var tmpStore = Ext.getCmp('exclude');
				tmpStore.getStore().removeAll();
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
				CompTypesObj.getStore().loadRawData(userMailJSON.compopnentTypes);
				if(viewByServer == "-1")
				{
					CompTypesObj.getStore().removeAll();
					CompTypesObj.getStore().loadData([
						{
							'displayField' : 'Not Applicable',
							'valueField' : '-1'
						}
					]);
				}
				testCombo.getStore().removeAll();
				testCombo.getStore().loadData([
					{
						'displayField' : 'Not Applicable',
						'valueField' : '-1'
					}
				]);
				Ext.getCmp('compName').getStore().removeAll();
				Ext.getCmp('searchbox').setDisabled(true);
				Ext.getCmp('searchbox').setValue('');
				if(CompTypesObj.getStore().getCount() > 0)
				{
					CompTypesObj.setValue(CompTypesObj.getStore().getAt(0));
				}
				if(testCombo.getStore().getCount() > 0)
				{
					testCombo.setValue(testCombo.getStore().getAt(0));
				}
				if (mailFilterOption == "Descriptors_Only")
				{
					tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
					tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
				}
			}
		});
	},
	changeByTest : function(obj)
	{
		var viewByTest = obj.getValue();
		var filterBy = Ext.getCmp('filter').getValue();
		var compTypesIn = Ext.getCmp('compTypesIn').getValue();
		var compTypes = Ext.getCmp('CompTypes').getValue();
		var serseg = Ext.getCmp('serseg').getValue();
		var configTestType = "no";
		if(isConfigEnabled == "true")
		{
			var testType = Ext.getCmp('TestTypes').getValue();
			if(testType == "configuration")
			{
				configTestType = "yes";
			}
		}
		var page = "";
		if (mailFilterOption == "Descriptors_Only")
		{
			page ="TrapReceiversAndSettings/data/EgMailAlertIncludeSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy=filterByDescriptor&compTypesIn="+encodeURIComponent(compTypesIn)+"&serseg="+encodeURIComponent(serseg)+"&serverType="+encodeURIComponent(compTypes)+"&Test="+encodeURIComponent(viewByTest)+"&date="+new Date().getTime();
		}
		else
		{
			page ="TrapReceiversAndSettings/data/EgMailAlertSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom+"&configTestType="+configTestType;
			page = page + "&filterBy="+filterBy+"&compTypesIn="+encodeURIComponent(compTypesIn)+"&serseg="+encodeURIComponent(serseg)+"&serverType="+encodeURIComponent(compTypes)+"&Test="+encodeURIComponent(viewByTest)+"&date="+new Date().getTime();
		}
		
		if (!Ext.isEmpty(viewByTest) && viewByTest == '-1')
		{
			Ext.getCmp('searchbox').setDisabled(true);
			Ext.getCmp('searchbox').setValue('');
		}
		else
		{
			Ext.getCmp('searchbox').setDisabled(false);
			Ext.getCmp('searchbox').setValue('');
		}
		Ext.Ajax.request({
			url : page,
			method: 'POST',
			success: function(response)
			{
				userMailJSON = Ext.decode(response.responseText);
				var tmpStore = Ext.getCmp('exclude');
				tmpStore.getStore().removeAll();
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
				var compNameObj = Ext.getCmp('compName');
				compNameObj.getStore().loadRawData(userMailJSON.compNameArr);
				compNameArrTemp = userMailJSON.compNameArr;
				if (mailFilterOption == "Descriptors_Only")
				{
					tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
					tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
				}
			}
		});
	},
	changeByComponentName : function(obj)
	{
		var compNames = obj.getValue();
		if(compNames == "" || compNames == "-1")
		{
			var excludeItemObj = Ext.getCmp('exclude');
			excludeItemObj.getStore().removeAll();
			if(excludeItemObj.fromField.store.getCount() > 0)
			{
				excludeItemObj.fromField.store.removeAll();
			}
			if(excludeItemObj.toField.store.getCount() > 0)
			{
				excludeItemObj.toField.store.removeAll();
			}
			return;
		}
		var filterBy = Ext.getCmp('filter').getValue();
		var Test = Ext.getCmp('Test').getValue();
		var compTypes = Ext.getCmp('CompTypes').getValue();
		var compTypesInObj = Ext.getCmp('compTypesIn');

		var page = "";
		if (mailFilterOption == "Descriptors_Only")
		{
			page ="TrapReceiversAndSettings/data/EgMailAlertIncludeSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy=filterByDescriptor&compNames="+encodeURIComponent(compNames)+"&serverType="+encodeURIComponent(compTypes)+"&Test="+encodeURIComponent(Test);

			if (userMailJSON.isOtherGroupsFound == true)
			{
				var compTypesIn = compTypesInObj.getValue();
				page = page + "&compTypesIn="+compTypesIn;

				if (compTypesInObj.getValue() != 'cType')
				{
					var sersegObj = Ext.getCmp('serseg');
					if(sersegObj!=null && sersegObj!=undefined)
					{
						var sersegVal = sersegObj.getValue();
						if(sersegVal!=null && sersegVal!=undefined && sersegVal!="")
						{
							page = page + "&serseg="+sersegVal;
						}
					}
				}
			}

			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					if (!Ext.isEmpty(includedItems))
					{
						//tmpStore.fromField.store.add(excludedItems);
						tmpStore.fromField.store.add(includedItems);
					}
					if (!Ext.isEmpty(excludedItems))
					{
						//tmpStore.toField.store.add(includedItems);
						tmpStore.toField.store.add(excludedItems);
					}
					if (mailFilterOption == "Descriptors_Only")
					{
						tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
						tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
					}
				}
			});
		}
		else
		{
			page ="TrapReceiversAndSettings/data/EgMailAlertSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy="+filterBy+"&compNames="+encodeURIComponent(compNames)+"&serverType="+encodeURIComponent(compTypes)+"&Test="+encodeURIComponent(Test);

			if (userMailJSON.isOtherGroupsFound == true)
			{
				var compTypesIn = compTypesInObj.getValue();
				page = page + "&compTypesIn="+compTypesIn;

				if (compTypesInObj.getValue() != 'cType')
				{
					var sersegObj = Ext.getCmp('serseg');
					if(sersegObj!=null && sersegObj!=undefined)
					{
						var sersegVal = sersegObj.getValue();
						if(sersegVal!=null && sersegVal!=undefined && sersegVal!="")
						{
							page = page + "&serseg="+sersegVal;
						}
					}
				}
			}

			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					if (!Ext.isEmpty(excludedItems))
					{
						tmpStore.fromField.store.add(excludedItems);
					}
					if (!Ext.isEmpty(includedItems))
					{
						tmpStore.toField.store.add(includedItems);
					}
					if (mailFilterOption == "Descriptors_Only")
					{
						tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
						tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
					}
				}
			});
		}
	},
	assignAndAddMoreFilters : function(obj)
	{
		var me = this;
		obj.setDisabled(true);

		if (mailFilterOption == "Descriptors_Only")
		{
			var filterBy = Ext.getCmp('filter').getValue();
			var tmpURL = "TrapReceiversAndSettings/data/EgMailAlertIncludeSuppresspJson.jsp?reqfrom="+reqFrom+"&userID="+encodeURIComponent(selectedUserID);
			var compNames = Ext.getCmp("compName").getValue();
			tmpURL = tmpURL + "&compNames="+encodeURIComponent(compNames);

			var tmpStore = Ext.getCmp('exclude');
			var arrInc1 = new Array();
			var arrExc1 = new Array();
			var fromStore = tmpStore.fromField.store;
			var toStore = tmpStore.toField.store;
			for(var z = 0;z<fromStore.getCount();z++)
			{
				var tmpVal = fromStore.getAt(z).get("valueField");
				arrExc1.push(tmpVal);
			}

			for(var z = 0;z<toStore.getCount();z++)
			{
				var tmpVal = toStore.getAt(z).get("valueField");
				arrInc1.push(tmpVal);
			}
			if (arrExc1.length == 0 && arrInc1.length == 0)
			{
				Ext.Msg.alert(pageIntnl82,"Please select the required parameters to Exclude/Include");
				obj.setDisabled(false);
				return;
			}

			me.setFilterValues("addMore");
			var hiddenFieldsKeys = userMailJSON['hiddenFields'];
			var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
			var thisForm = me.getEgmailalertsuppress().getForm();
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show();
			if (thisForm.isValid())
			{
				this.getEgmailalertsuppress().submit({
					url: tmpURL+'&'+hiddenFields,
					method: 'POST',
					//standardSubmit: true,
					success: function(form, action){
						myMask.hide();
						me.showResultText();
					},
					failure: function(form, action) // if result page doest not contain success:true, this method fires
					{
						myMask.hide();
					}
				});
			}
		}
		else
		{
			var filterBy = Ext.getCmp('filter').getValue();
			var tmpURL = "TrapReceiversAndSettings/data/EgMailAlertSuppresspJson.jsp?reqfrom="+reqFrom+"&userID="+encodeURIComponent(selectedUserID);
			if(filterBy == "-1")
			{
				Ext.MessageBox.alert(pageIntnl82,pageIntnl90);
				obj.setDisabled(false);
				return;
			}

			if (filterBy == "filterByDescriptor")
			{
				var compNames = Ext.getCmp("compName").getValue();
				tmpURL = tmpURL + "&compNames="+encodeURIComponent(compNames);
			}
			me.setFilterValues("addMore");
			var hiddenFieldsKeys = userMailJSON['hiddenFields'];
			var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
			var thisForm = me.getEgmailalertsuppress().getForm();
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show();
			if (thisForm.isValid())
			{
				this.getEgmailalertsuppress().submit({
					url: tmpURL+'&'+hiddenFields,
					method: 'POST',
					//standardSubmit: true,
					success: function(form, action){
						myMask.hide();
						me.showResultText();
					},
					failure: function(form, action) // if result page doest not contain success:true, this method fires
					{
						myMask.hide();
					}
				});
			}
		}
		obj.setDisabled(false);
	},
	submitUserFilterElements : function(obj)
	{
		var me = this;
		obj.setDisabled(true);

		if (mailFilterOption == "Descriptors_Only")
		{
			var tmpURL = "TrapReceiversAndSettings/data/EgMailAlertIncludeSuppresspJson.jsp?reqfrom="+reqFrom+"&userID="+encodeURIComponent(selectedUserID);
			me.setFilterValues("finish");

			var tmpStore = Ext.getCmp('exclude');
			var arrInc1 = new Array();
			var arrExc1 = new Array();
			var fromStore = tmpStore.fromField.store;
			var toStore = tmpStore.toField.store;

			for(var z = 0;z<fromStore.getCount();z++)
			{
				var tmpVal = fromStore.getAt(z).get("valueField");
				arrExc1.push(tmpVal);
			}

			for(var z = 0;z<toStore.getCount();z++)
			{
				var tmpVal = toStore.getAt(z).get("valueField");
				arrInc1.push(tmpVal);
			}
			if (arrExc1.length == 0 && arrInc1.length == 0)
			{
				Ext.Msg.alert(pageIntnl82,"Please select the required parameters to Exclude/Include");
				obj.setDisabled(false);
				return;
			}

			var compNames = Ext.getCmp("compName").getValue();
			tmpURL = tmpURL + "&compNames="+encodeURIComponent(compNames);
			var hiddenFieldsKeys = userMailJSON['hiddenFields'];
			var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
			var thisForm = me.getEgmailalertsuppress().getForm();
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show();

			if (thisForm.isValid())
			{
				this.getEgmailalertsuppress().submit({
					url: tmpURL+'&'+hiddenFields,
					method: 'POST',
					//standardSubmit: true,
					success: function(form, action){
						myMask.hide();
						Ext.Msg.show({
							title: pageIntnl82,
							msg: pageIntnl99,
							buttons: Ext.Msg.OK,
							width : 400,
							icon: 'iconInformation',
							fn : function(){
								me.showUserAddForm();
							}
						});
					},
					failure: function(form, action) // if result page doest not contain success:true, this method fires
					{
						myMask.hide();
					}
				});
			}
		}
		else
		{
			var filterBy = Ext.getCmp('filter').getValue();
			var tmpURL = "TrapReceiversAndSettings/data/EgMailAlertSuppresspJson.jsp?reqfrom="+reqFrom+"&userID="+encodeURIComponent(selectedUserID);
			me.setFilterValues("finish");

			if (filterBy == "filterByDescriptor")
			{
				var compNames = Ext.getCmp("compName").getValue();
				tmpURL = tmpURL + "&compNames="+encodeURIComponent(compNames);
			}
			var hiddenFieldsKeys = userMailJSON['hiddenFields'];
			var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
			var thisForm = me.getEgmailalertsuppress().getForm();
			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show();
			if (thisForm.isValid())
			{
				this.getEgmailalertsuppress().submit({
					url: tmpURL+'&'+hiddenFields,
					method: 'POST',
					//standardSubmit: true,
					success: function(form, action){
						myMask.hide();
						Ext.Msg.show({
							title: pageIntnl82,
							msg: pageIntnl99,
							buttons: Ext.Msg.OK,
							width : 400,
							icon: 'iconInformation',
							fn : function(){
								window.location.href="/final/admin/EgSnmpConfig.jsp";
							}
						});
					},
					failure: function(form, action) // if result page doest not contain success:true, this method fires
					{
						myMask.hide();
						window.location.href="/final/admin/EgSnmpConfig.jsp";
					}
				});
			}
		}
		obj.setDisabled(false);
	},
	viewFilteredElements : function()
	{
		var me = this;
		Ext.widget("window",{
			extend: 'Ext.panel.Panel',
			id:'userFilterWindow',
			width: '95%',
			height: 450,
			border : false,
			modal : true,
			autoScroll:true,
			closeAction: 'destory',
			doClose: function() {
				this.destroy();
			},
			listeners : {
				afterrender : function()
				{
					if (mailFilterOption == "Descriptors_Only")
					{
						var title = filterMessage2 + ": "+selectedUserID;
						Ext.getCmp('userFilterWindow').setTitle(title);
						var url = "TrapReceiversAndSettings/data/EgMailAlertIncludeSuppress.jsp?showAssociatedData=yes&selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom+"&date="+new Date().getTime();
						me.updateDescriptorHTMLFiltePanel(url);
					}
					else
					{
						var title = filterMessage + ": "+selectedUserID;
						Ext.getCmp('userFilterWindow').setTitle(title);
						var url = "TrapReceiversAndSettings/data/EgMailAlertSuppress.jsp?showAssociatedData=yes&selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom+"&date="+new Date().getTime();
						me.updateHTMLFilterResultPanel(url);
					}
				}
			},
			items:[
				{
					xtype: 'container',
					id: 'userFilterContainer',
					layout: {
						type: 'vbox',
						pack: 'center',
						align: 'center'
					},
					defaults: {
						margin : 8
					}
				}
			]
		}).show();
	},
	showComponentSelector : function()
	{
		var me = this;
		if (Ext.getCmp('componentWinSelector') == undefined)
		{
			var cloneStore = Ext.getCmp('compName').getStore();
			var expandWindow = Ext.create('Ext.window.Window',{
					title:'Components',
					id : 'componentWinSelector',
					//width:650,
					//height:370,
					doClose: function() {
						this.destroy();
					},
					buttonAlign:'center',
					items:[
						{
							xype:'container',
							cls:'multisearchlist',
							width: 580,
							layout : {
								type : 'hbox',
								pack : 'center'
							},
							margin : '5 5 0 5',
							items:[
							{
								xtype: 'trigger',
								name:'componentSearch',
								id:'componentSearch',
								trigger1Cls: 'x-form-clear-trigger',
								trigger2Cls: 'x-form-search-trigger', 
								cls: 'whitedropdown_search',
								emptyText:'Search',
								margin: '5 5 5 5',
								labelAlign: 'top',
								width: 400,
								getTriggerMarkup: function() {
									var me = this,
										i = 0,
										hideTrigger = (me.readOnly || me.hideTrigger),
										triggerCls,
										triggerBaseCls = me.triggerBaseCls,
										triggerConfigs = [],
										unselectableCls = Ext.dom.Element.unselectableCls,
										style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
										cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

									// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
									// single triggerCls config. Should rethink this, perhaps something more structured like a list of
									// trigger config objects that hold cls, handler, etc.
									// triggerCls is a synonym for trigger1Cls, so copy it.
									if (!me.trigger1Cls) {
										me.trigger1Cls = me.triggerCls;
									}

									// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
									for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {

										if (i == 0)
										{
											triggerConfigs.push({
												tag: 'td',
												role: 'presentation',
												valign: 'top',
												cls: cls,
												id : 'MyTrigger_'+i,
												style: style + "display:none;",
												cn: {
													cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
													role: 'presentation'
												}
											});
										}
										else
										{
											triggerConfigs.push({
												tag: 'td',
												role: 'presentation',
												valign: 'top',
												cls: cls,
												id : 'MyTrigger_'+i,
												style: style,
												cn: {
													cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
													role: 'presentation'
												}
											});
										}
									}
									triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';

									return Ext.DomHelper.markup(triggerConfigs);
								},
								onTrigger1Click : function() { 
									this.reset(); 
								},
								onTriggerClick: function()
								{
									me.egTitleSearch(this.getValue());
								},
								listeners : {
									specialkey: function(field, e)
									{
										// e.HOME, e.END, e.PAGE_UP, e.PAGE_DOWN, // e.TAB, e.ESC, arrow keys: e.LEFT, e.RIGHT, e.UP, e.DOWN 
										if(e.getKey() == e.ENTER) 
										{ 
											me.egTitleSearch(field.getValue());
										}
									}
								}
							}]
						},
						{
							xtype: 'multiselectfieldSi',
							margin : '0 5 5 5',
							autoScroll:true,
							scroll:true,
							name: 'multiselect',
							id: 'componentClonedID',
							store: cloneStore,
							value: Ext.getCmp('compName').getValue(),
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							width: 580,
							height:230
						}
					],
					buttons:[
						{
							text:'Select',
							id: 'expand',
							cls:'button20',
							name: 'expand',
							handler: function()
							{
								if (Ext.getCmp('componentClonedID').getValue() != '' )
								{
									var selectedList = Ext.getCmp('componentClonedID').getValue();
									Ext.getCmp('compName').setValue(selectedList);
									expandWindow.destroy();
								}
							}
						}
					]
			}).show();
		}
	},
	egTitleSearch : function(id)
	{
		var value = id.value;
		var cloneStore = Ext.getCmp('compName').getStore();
		var clonedStore = compNameArrTemp;
		var compNameObj = Ext.getCmp('compName');
		var excludeItemObj = Ext.getCmp('exclude');
		excludeItemObj.getStore().removeAll();
		if(excludeItemObj.fromField.store.getCount() > 0)
		{
			excludeItemObj.fromField.store.removeAll();
		}
		if(excludeItemObj.toField.store.getCount() > 0)
		{
			excludeItemObj.toField.store.removeAll();
		}

		if (Ext.isEmpty(value))
		{
			Ext.get('MyTrigger_searchbox_0').setStyle('display','none');
			Ext.get('MyTrigger_searchbox_1').setStyle('display','block');
			//compNameObj.getStore().clearFilter(true);
			compNameObj.getStore().loadRawData(compNameArrTemp);
		}
		else
		{
			Ext.get('MyTrigger_searchbox_1').setStyle('display','none');
			Ext.get('MyTrigger_searchbox_0').setStyle('display','block');
			//clonedStore.filter('displayField',value);
			var compNameObj = Ext.getCmp('compName');
			var findVal = value;
			var isRecordFound = false;
			//var genStore = new Ext.data.Store({
			//						fields : ['displayField','valueField'],
			//						data : []                                
			//					});
			var genStoreArr = new Array();
			for ( var i = 0; i < clonedStore.length ; i++ )
			{
				var getRecord = clonedStore[i]['displayField'];
				if ( getRecord.toLowerCase().indexOf(findVal.toLowerCase()) > -1 )
				{
					isRecordFound = true;
					genStoreArr.push({
						'displayField': clonedStore[i]['displayField'],
						'valueField': clonedStore[i]['valueField'],
					});
				}
			}

			compNameObj.getStore().removeAll();    
			if ( isRecordFound )
			{
				compNameObj.getStore().loadRawData(genStoreArr);
				//for ( var i = 0; i < genStore.getCount() ; i++ )
				//{
					//var getRecord = genStore.getAt(i);
					//compNameObj.getStore().add(getRecord);
				//}
			}
			else
			{
				compNameObj.store.loadData({
						'displayField': 'No data found',
						'valueField': '-1',
					},true);
			}
			Ext.getCmp('searchbox').focus();
		}
	},
	updateUserMailSuppressList : function(urlStr)
	{
		Ext.Ajax.request({
			url : urlStr,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				userMailJSON = Ext.decode(jsonText);
			}
		});
	},
	updateFilterComponents : function()
	{
		var me = this;
		var elementFilteringTabObj = Ext.getCmp('main');
		var isComponentsAssociated = userMailJSON.isComponentsAssociated;
		if (isComponentsAssociated == true)
		{
			var egmailalertsuppressObj = Ext.getCmp('egmailalertsuppress');
			if (egmailalertsuppressObj == null || egmailalertsuppressObj == 'undefined' || egmailalertsuppressObj == undefined)
			{
				elementFilteringTabObj.removeAll();
				elementFilteringTabObj.add({xtype : 'egmailalertsuppress'});
			}
			Ext.getCmp('filterUserID').setValue(selectedUserID);
		}
		else
		{
			var tmpUserID = userMailJSON['userID'];
			var message = "<div class = \"iconInformation\" style=\"margin:0 auto\"></div><div>No components have been associated for <b>'"+tmpUserID+"'</b></div>";
			elementFilteringTabObj.removeAll();
			elementFilteringTabObj.add({
				xtype : 'panel',
				border : false,
				padding:160,
				style:{'text-align':'center'},
				html:message
			});
		}
	},
	initUserMailConfigs : function()
	{
		var me = this;
		var queryStatus = userMailJSON.requestStatus;
		if (queryStatus == "success")
		{
			var tmpUserID = selectedUserID;
			this.setLangEntries(userMailJSON.langEntries);
			var filters = userMailJSON.filters;
			var isComponentsAssociated = userMailJSON.isComponentsAssociated;
			if (isComponentsAssociated == true)
			{
				var associateObj = Ext.getCmp('filter');
				associateObj.getStore().loadRawData(filters);
				associateObj.setValue("-1");
				Ext.getCmp('CompTypes').hide();
				var tmpStore = Ext.getCmp('exclude');
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
			}
			else
			{
				var elementFilteringTabObj = Ext.getCmp('main');
				var tmpUserID = selectedUserID;
				var message = "<div class = \"iconInformation\" style=\"margin:0 auto\"></div><div>No components have been associated for <b>'"+tmpUserID+"'</b></div>";
				elementFilteringTabObj.removeAll();
				elementFilteringTabObj.add({
					xtype : 'component',
					border : false,
					padding:160,
					style:{'text-align':'center'},
					html:message
				});
			}
		}
		else
		{
			var elementFilteringTabObj = Ext.getCmp('main');
			var message = me.getErrorMessageTemplate(userMailJSON.errors);
			elementFilteringTabObj.removeAll();
			elementFilteringTabObj.add({
				xtype : 'component',
				border : false,
				padding:160,
				style:{'text-align':'center'},
				html:message
			});
		}
	},
	setLangEntries : function(landEntriesJson)
	{
		for (var key in landEntriesJson)
		{
			var tmpObj = Ext.getCmp(key);
			if (tmpObj ==  null || tmpObj == 'undefined')
			{
				continue;
			}
			if (tmpObj.getXType() == "checkboxfield" || tmpObj.getXType() == "radiofield")
			{
				if (tmpObj.boxLabelEl == null || tmpObj.boxLabelEl == undefined || tmpObj.boxLabelEl == 'undefined')
				{
					continue;
				}
				tmpObj.boxLabelEl.update(landEntriesJson[key]);
			}
			else
			{
				tmpObj.setFieldLabel(landEntriesJson[key]);
			}
		}
	},
	buildMainData : function()
	{
		Ext.Ajax.request({
			url : appURL,
			async: false,
			method : 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				publicJSON = Ext.decode(jsonText);
				var isFilterControlEnabled = publicJSON.isFilterControlEnabled;
				if (isFilterControlEnabled)
				{
					mailFilterOption = publicJSON.filterControlDefaultSelection;
				}
			}
		});
	},
	settingsUpdateData: function()
	{
		var QString = this.genQueryString(publicJson['hiddenObj']);
		var qStr = '';
		var snmpMgrSrc = Ext.getCmp('snmpMgrSourceYes').getValue();
		var sendTrapsFor = Ext.getCmp('sendTrapsFor').getValue();
		var logYes = Ext.getCmp('logYes').getValue();
		if(snmpMgrSrc)
		{
			qStr += 'UseIpInSnmpTraps=Yes';
		}
		else
		{
			qStr += 'UseIpInSnmpTraps=No';
		}

		qStr += '&sendTrapsFor='+sendTrapsFor;

		if(logYes)
		{
			qStr += '&logYes=Yes';
			var logSize = Ext.getCmp('logSize').getValue();
			var logfilelimit = Ext.getCmp('logfilelimit').getValue();
			
			if(isAValidNumber(logSize)=="false")
			{
				Ext.Msg.show ({
					title: pageName,
					msg: alert21,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('logSize').focus(true);
					}
				});
				return;
			}
			else
			{
				qStr += '&logSize='+logSize;
			}

			if(isAValidNumber(logfilelimit)=="false")
			{
				Ext.Msg.show ({
					title: pageName,
					msg: alert22,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation',
					fn: function() {
						Ext.getCmp('logfilelimit').focus(true);
					}
				});
				return;
			}
			else
			{
				qStr += '&logfilelimit='+logfilelimit;
			}
			
		}
		else
		{
			qStr += '&logYes=No';
		}
		
		var high = Ext.getCmp('modifyCritical').getValue();
		var medium = Ext.getCmp('modifyMajor').getValue(); 
		var low = Ext.getCmp('modifyMinor').getValue(); 
		var normal = Ext.getCmp('modifyNormal').getValue();

		var alramSelected = false;
		if(high != null && high == true)
		{
			qStr +="&high=HIGH";
			alramSelected = true;
		}
		
		if(medium != null && medium == true)
		{
			alramSelected = true;
			qStr +="&medium=MEDIUM";
		}
		
		if(low != null && low == true)
		{
			alramSelected = true;
			qStr +="&low=LOW";
		}
		if (normal != null && normal == true)
		{
			alramSelected = true;
			qStr +="&normal=NORMAL";
		}
		
		if(!alramSelected)
		{
			Ext.Msg.show ({
				title: pageName,
				msg: alert6,
				width: alert6.length * 7,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation',
			});
			return;
		}

		qStr += QString;
		Ext.Ajax.request({
			url:'TrapReceiversAndSettings/data/Egsnmpconfigp.jsp?from=settings&'+qStr+'&selectTab=settingsnmp',
			method:'post',
			async : false,
			scope:this,
			success:function(response)
			{
				Ext.Msg.show ({
					title: pageName,
					msg: alert2,
					buttons: Ext.MessageBox.OK,
					icon: 'iconInformation'
				});
			}
		});
	},
	showMailFilter : function() {
		//var uName = publicJsonData['hiddenParams']['uname'];
		//var showAlert = publicJsonData['isMailConfigured'];
		//var showMailFilterBtn = publicJsonData['showMailFilterBtn'];

		window.location.href =  "/final/admin/TrapReceiversAndSettings/data/EgMailAlertSuppressJson.jsp?qctr=1&reqfrom=navlink&userID=admin";
	},
	setFilterValues : function(cntValue)
	{
		var hiddenFieldsKeys = userMailJSON['hiddenFields'];
		var hiddenFieldsContainerObj = Ext.getCmp('hiddenFieldsContainer');
		var tmpStore = Ext.getCmp('exclude');
		var arrInc = new Array();
		var arrExc = new Array();
		var fromStore = tmpStore.fromField.store;
		var toStore = tmpStore.toField.store;
		for(var z = 0;z<fromStore.getCount();z++)
		{
			var tmpVal = fromStore.getAt(z).get("valueField");
			arrExc.push(tmpVal);
		}

		for(var z = 0;z<toStore.getCount();z++)
		{
			var tmpVal = toStore.getAt(z).get("valueField");
			arrInc.push(tmpVal);
		}
		if(userMailJSON['excludedBoxHostVal'] && userMailJSON['excludedBoxHostVal'] != undefined)
		{
			var valueHost =userMailJSON['excludedBoxHostVal'];
			if(valueHost !=null && valueHost != "")
			{
				arrExc[arrExc.length] = valueHost;
			}
		}
		if (mailFilterOption == "Descriptors_Only")
		{
			var includedBoxVal = {
				xtype : 'hiddenfield',
				name : 'excludedBoxVal',
				value : arrInc
			}
			var excludedBoxVal = {
				xtype : 'hiddenfield',
				name : 'includedBoxVal',
				value : arrExc
			}
			var tmpActionObj = {
				xtype : 'hiddenfield',
				name : 'control',
				value : cntValue
			}
		}
		else
		{
			var includedBoxVal = {
				xtype : 'hiddenfield',
				name : 'includedBoxVal',
				value : arrInc
			}
			var excludedBoxVal = {
				xtype : 'hiddenfield',
				name : 'excludedBoxVal',
				value : arrExc
			}
			var tmpActionObj = {
				xtype : 'hiddenfield',
				name : 'control',
				value : cntValue
			}
		}
		hiddenFieldsContainerObj.removeAll();
		hiddenFieldsContainerObj.add(includedBoxVal);
		hiddenFieldsContainerObj.add(excludedBoxVal);
		hiddenFieldsContainerObj.add(tmpActionObj);
		//if (!Ext.isEmpty(hiddenFieldsKeys.previousExcVal))
		//{
			var tmpPrevExcValObj = {
				xtype : 'hiddenfield',
				name : 'previousExcVal',
				value : hiddenFieldsKeys.previousExcVal
			}
			hiddenFieldsContainerObj.add(tmpPrevExcValObj);
		//}
	},
	updateHTMLFilterResultPanel : function(urlStr)
	{
		var me = this;
		Ext.Ajax.request({
			url : urlStr,
			method: 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				var userFilterContainerObj = Ext.getCmp('userFilterContainer');
				userFilterContainerObj.update(jsonText);
				Ext.getCmp('userFilterWindow').doLayout();
				delete jsonText;
				delete userFilterContainerObj;
			}
		});
	},
	updateDescriptorHTMLFiltePanel : function(urlStr)
	{
		var me = this;
		Ext.Ajax.request({
			url : urlStr,
			method: 'POST',
			success: function(response)
			{
				var jsonText = response.responseText;
				var userFilterContainerObj = Ext.getCmp('userFilterContainer');
				userFilterContainerObj.update(jsonText);
				Ext.getCmp('userFilterWindow').doLayout();
				delete jsonText;
				delete userFilterContainerObj;
			}
		});
	},
	updateFilterResultPanel2 : function()
	{
		var me = this;
		var userFilterContainerObj = Ext.getCmp('userFilterContainer');
		var filters = userMailJSON.filters;
		userFilterContainerObj.removeAll();
		if (userMailJSON['isFiltersAvailable'] != null && userMailJSON['isFiltersAvailable'] != undefined && userMailJSON['isFiltersAvailable'] == true)
		{
			var excludedElements = userMailJSON.excludedElements;
			var gridHeaderMapping = userMailJSON.gridHeaderMapping;
			for (var key in excludedElements)
			{
				var gridObj = excludedElements[key];
				if (key == "exculdedDescriptor")
				{
					var gridTitle = gridHeaderMapping[key];
					if (gridObj == "" || gridObj.length == 0)
					{
						continue;
					}
					var tmpPanel = {
						xtype : 'panel',
						cls : 'outerpanel',
						border : false,
						width : '95%',
						title : gridTitle,
						html : gridObj
					}
					userFilterContainerObj.add(tmpPanel);
				}
			}
		}
		else
		{
			var message = "<div class = \"iconInformation\" style=\"margin:0 auto\"></div><div>No elements are included for this user</b></div>";
			var tmpPanel = {
				xtype : 'component',
				border : false,
				padding : 120,
				html : message
			}
			userFilterContainerObj.add(tmpPanel);
		}
		Ext.getCmp('userFilterWindow').doLayout();
	},
	getGridPanel : function(gridArray,gridTitle)
	{
		var fieldstoStore =  new Array();
		fieldstoStore.push("compType_1");
		fieldstoStore.push("compType_2");
		fieldstoStore.push("compType_3");
		var mainColumnsObjArray	=  new Array();
		var itemsArray	=  new Array();
		for (var key in fieldstoStore)
		{
			var gridColumn = fieldstoStore[key];
			mainColumnsObjArray.push({
				header: gridColumn,
				dataIndex: gridColumn,
				align:'left',
				flex:1
			});
		}
		var gridpanel = Ext.widget('usergridpanel',{
			store:new Ext.data.Store({
				fields: fieldstoStore,
				data: gridArray
			}),
			sortableColumns:false,
			cls:'gridSkin',
			title : gridTitle,
			width : '95%',
			columns:mainColumnsObjArray,
			viewConfig: {
				forceFit: true,
				stripeRows : false
			},
			sortable: false,
			hideable: false,
			hideHeaders : true
		});
		return gridpanel;
	},
	showComponentSelector : function()
	{
		var me = this;
		if (Ext.getCmp('componentWinSelector') == undefined)
		{
			var cloneStore = Ext.getCmp('compName').getStore();
			var expandWindow = Ext.create('Ext.window.Window',{
					title:'Components',
					id : 'componentWinSelector',
					//width:650,
					//height:370,
					doClose: function() {
						this.destroy();
					},
					buttonAlign:'center',
					items:[
						{
							xype:'container',
							cls:'multisearchlist',
							width: 580,
							layout : {
								type : 'hbox',
								pack : 'center'
							},
							margin : '5 5 0 5',
							items:[
							{
								xtype: 'trigger',
								name:'componentSearch',
								id:'componentSearch',
								trigger1Cls: 'x-form-clear-trigger',
								trigger2Cls: 'x-form-search-trigger', 
								cls: 'whitedropdown_search',
								emptyText:'Search',
								margin: '5 5 5 5',
								labelAlign: 'top',
								width: 400,
								getTriggerMarkup: function() {
									var me = this,
										i = 0,
										hideTrigger = (me.readOnly || me.hideTrigger),
										triggerCls,
										triggerBaseCls = me.triggerBaseCls,
										triggerConfigs = [],
										unselectableCls = Ext.dom.Element.unselectableCls,
										style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
										cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

									// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
									// single triggerCls config. Should rethink this, perhaps something more structured like a list of
									// trigger config objects that hold cls, handler, etc.
									// triggerCls is a synonym for trigger1Cls, so copy it.
									if (!me.trigger1Cls) {
										me.trigger1Cls = me.triggerCls;
									}

									// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
									for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {

										if (i == 0)
										{
											triggerConfigs.push({
												tag: 'td',
												role: 'presentation',
												valign: 'top',
												cls: cls,
												id : 'MyTrigger_'+i,
												style: style + "display:none;",
												cn: {
													cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
													role: 'presentation'
												}
											});
										}
										else
										{
											triggerConfigs.push({
												tag: 'td',
												role: 'presentation',
												valign: 'top',
												cls: cls,
												id : 'MyTrigger_'+i,
												style: style,
												cn: {
													cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
													role: 'presentation'
												}
											});
										}
									}
									triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';

									return Ext.DomHelper.markup(triggerConfigs);
								},
								onTrigger1Click : function() { 
									this.reset(); 
								},
								onTriggerClick: function()
								{
									me.egTitleSearch(this.getValue());
								},
								listeners : {
									specialkey: function(field, e)
									{
										// e.HOME, e.END, e.PAGE_UP, e.PAGE_DOWN, // e.TAB, e.ESC, arrow keys: e.LEFT, e.RIGHT, e.UP, e.DOWN 
										if(e.getKey() == e.ENTER) 
										{ 
											me.egTitleSearch(field.getValue());
										}
									}
								}
							}]
						},
						{
							xtype: 'multiselectfieldSi',
							margin : '0 5 5 5',
							autoScroll:true,
							scroll:true,
							name: 'multiselect',
							id: 'componentClonedID',
							store: cloneStore,
							value: Ext.getCmp('compName').getValue(),
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							width: 580,
							height:230
						}
					],
					buttons:[
						{
							text:'Select',
							id: 'expand',
							cls:'button20',
							name: 'expand',
							handler: function()
							{
								if (Ext.getCmp('componentClonedID').getValue() != '' )
								{
									var selectedList = Ext.getCmp('componentClonedID').getValue();
									Ext.getCmp('compName').setValue(selectedList);
									expandWindow.destroy();
								}
							}
						}
					]
			}).show();
		}
	},
	egTitleSearch : function(id)
	{
		var value = id.value;
		var cloneStore = Ext.getCmp('compName').getStore();
		var clonedStore = compNameArrTemp;
		var compNameObj = Ext.getCmp('compName');
		var excludeItemObj = Ext.getCmp('exclude');
		excludeItemObj.getStore().removeAll();
		if(excludeItemObj.fromField.store.getCount() > 0)
		{
			excludeItemObj.fromField.store.removeAll();
		}
		if(excludeItemObj.toField.store.getCount() > 0)
		{
			excludeItemObj.toField.store.removeAll();
		}

		if (Ext.isEmpty(value))
		{
			Ext.get('MyTrigger_searchbox_0').setStyle('display','none');
			Ext.get('MyTrigger_searchbox_1').setStyle('display','block');
			//compNameObj.getStore().clearFilter(true);
			compNameObj.getStore().loadRawData(compNameArrTemp);
		}
		else
		{
			Ext.get('MyTrigger_searchbox_1').setStyle('display','none');
			Ext.get('MyTrigger_searchbox_0').setStyle('display','block');
			//clonedStore.filter('displayField',value);
			var compNameObj = Ext.getCmp('compName');
			var findVal = value;
			var isRecordFound = false;
			//var genStore = new Ext.data.Store({
			//						fields : ['displayField','valueField'],
			//						data : []                                
			//					});
			var genStoreArr = new Array();
			for ( var i = 0; i < clonedStore.length ; i++ )
			{
				var getRecord = clonedStore[i]['displayField'];
				if ( getRecord.toLowerCase().indexOf(findVal.toLowerCase()) > -1 )
				{
					isRecordFound = true;
					genStoreArr.push({
						'displayField': clonedStore[i]['displayField'],
						'valueField': clonedStore[i]['valueField'],
					});
				}
			}

			compNameObj.getStore().removeAll();    
			if ( isRecordFound )
			{
				compNameObj.getStore().loadRawData(genStoreArr);
				//for ( var i = 0; i < genStore.getCount() ; i++ )
				//{
					//var getRecord = genStore.getAt(i);
					//compNameObj.getStore().add(getRecord);
				//}
			}
			else
			{
				compNameObj.store.loadData({
						'displayField': 'No data found',
						'valueField': '-1',
					},true);
			}
			Ext.getCmp('searchbox').focus();
		}
	},
	popFilterDetails : function(obj)
	{
		var me = this;
		var page ="TrapReceiversAndSettings/data/EgMailAlertSuppressJson.jsp?userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
		var selectedOption = obj.getValue();
		if(selectedOption != "-1")
		{
			page = page+"&filterBy="+selectedOption;
			if(selectedOption == "filterByCName" || selectedOption == "filterByDescriptor")
			{
				page = page + "&serverType=-1";
			}
			else if(selectedOption == "filterByLayer" || selectedOption == "filterByTest")
			{
				page = page + "&serverType=filterByAll";
			}
			page = page + "&date="+new Date().getTime();
			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}
					if (!Ext.isEmpty(excludedItems))
					{
						//tmpStore.getStore().loadRawData(excludedItems);
						tmpStore.fromField.store.add(excludedItems);
					}
					if (!Ext.isEmpty(includedItems))
					{
						tmpStore.toField.store.add(includedItems);
					}
					var compTypeContainer = Ext.getCmp('CompTypes');
					var compTypesInCt = Ext.getCmp('compTypesIn');
					var serverTestsOuterCt = Ext.getCmp('serverTestsOuterCt');
					compTypeContainer.hide();
					compTypesInCt.hide();
					serverTestsOuterCt.hide();
					Ext.getCmp('serseg').hide();
					if(selectedOption == "filterByCName" || selectedOption == "filterByLayer" || selectedOption == "filterByTest" || 
						selectedOption == "filterByDescriptor")
					{
						var tmpCompObj = Ext.getCmp('CompTypes');
						var compopnentTypes = userMailJSON['compopnentTypes'];
						tmpCompObj.getStore().loadRawData(compopnentTypes);
						if (selectedOption == "filterByCName" || selectedOption == "filterByDescriptor")
						{
							tmpCompObj.setValue("-1");
						}
						else
						{
							tmpCompObj.setValue("filterByAll");
						}
						if (userMailJSON.isOtherGroupsFound)
						{
							compTypesInCt.getStore().loadRawData(userMailJSON.viewBy);
							compTypesInCt.setValue(userMailJSON.displayText);
							compTypesInCt.show();
							if (compTypesInCt.getValue() != 'cType')
							{
								Ext.getCmp('serseg').show();
							}
						}
						else
						{
							compTypesInCt.hide();
						}

						compTypeContainer.show();
						if (selectedOption == "filterByDescriptor")
						{
							var testObj = Ext.getCmp('Test');
							Ext.getCmp('compName').getStore().removeAll();
							serverTestsOuterCt.show();
							Ext.getCmp('searchbox').setDisabled(true);
							Ext.getCmp('searchbox').setValue('');
							testObj.show();
							testObj.getStore().removeAll();
							testObj.getStore().loadRawData(userMailJSON.testArray);
							testObj.setValue("-1");
						}
					}
					var testTypeObj = Ext.getCmp('TestTypes');
					if(isConfigEnabled == "true")
					{
						if(selectedOption == "filterByTest")
						{
							testTypeObj.show();
							testTypeObj.getStore().removeAll();
							testTypeObj.getStore().loadRawData(userMailJSON.testTypesArr);
							testTypeObj.setValue("performance");
						}
						else
						{
							testTypeObj.hide();
						}
					}
					else
					{
						testTypeObj.hide();
					}
					tmpStore.fromField.getComponent(0).setTitle(userMailJSON['itemTitle1']);
					tmpStore.toField.getComponent(0).setTitle(userMailJSON['itemTitle2']);
				}
			});
		}
		else
		{
			Ext.suspendLayouts();
			var tmpStore = Ext.getCmp('exclude');
			tmpStore.fromField.getComponent(0).setTitle("Excluded from alerts");
			tmpStore.toField.getComponent(0).setTitle("Included for alerts");
			Ext.getCmp('CompTypes').hide();
			Ext.getCmp('compTypesIn').hide();
			Ext.getCmp('serseg').hide();
			Ext.getCmp('serverTestsOuterCt').hide();
			Ext.resumeLayouts(true);
		}
	},
	showFilterDetails : function(obj)
	{
		var me = this;
		var page ="TrapReceiversAndSettings/data/EgMailAlertIncludeSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&filterBy=filterByDescriptor&reqfrom="+reqFrom;

		Ext.Ajax.request({
			url : page,
			method: 'POST',
			success: function(response)
			{
				userMailJSON = Ext.decode(response.responseText);
				var tmpStore = Ext.getCmp('exclude');
				var includedItems = userMailJSON['includedAlerts'];
				var excludedItems = userMailJSON['excludedAlerts'];
				tmpStore.getStore().removeAll();
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
				if (!Ext.isEmpty(excludedItems))
				{
					tmpStore.fromField.store.add(excludedItems);
				}
				if (!Ext.isEmpty(includedItems))
				{
					tmpStore.toField.store.add(includedItems);
				}
				var compTypeContainer = Ext.getCmp('CompTypes');
				var compTypesInCt = Ext.getCmp('compTypesIn');
				var serverTestsOuterCt = Ext.getCmp('serverTestsOuterCt');
				compTypeContainer.hide();
				compTypesInCt.hide();
				serverTestsOuterCt.hide();
				Ext.getCmp('serseg').hide();
				//if(selectedOption == "filterByCName" || selectedOption == "filterByLayer" || selectedOption == "filterByTest" || 
				//	selectedOption == "filterByDescriptor")
				{
					var tmpCompObj = Ext.getCmp('CompTypes');
					var compopnentTypes = userMailJSON['compopnentTypes'];
					tmpCompObj.getStore().loadRawData(compopnentTypes);
					tmpCompObj.setValue("-1");
					if (userMailJSON.isOtherGroupsFound)
					{
						compTypesInCt.getStore().loadRawData(userMailJSON.viewBy);
						compTypesInCt.setValue(userMailJSON.displayText);
						compTypesInCt.show();
						if (compTypesInCt.getValue() != 'cType')
						{
							Ext.getCmp('serseg').show();
						}
					}
					else
					{
						compTypesInCt.hide();
					}

					compTypeContainer.show();
					var testObj = Ext.getCmp('Test');
					Ext.getCmp('compName').getStore().removeAll();
					serverTestsOuterCt.show();
					testObj.show();
					testObj.getStore().removeAll();
					testObj.getStore().loadRawData(userMailJSON.testArray);
					testObj.setValue("-1");
				}
			}
		});
	},
	viewByCriteria : function(obj)
	{
		var viewByValue = obj.getValue();
		var filterObj = Ext.getCmp("filter");
		var filterBy = filterObj.getValue();
		var sersegObj = Ext.getCmp('serseg');
		var testCombo = Ext.getCmp('Test');
		var compTypes = Ext.getCmp('CompTypes');
		var page = "";
		var me = this;
		if (mailFilterOption == "Descriptors_Only")
		{
			page ="2:31 TrapReceiversAndSettings/data/EgMailAlertIncludeSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy=filterByDescriptor&compTypesIn="+encodeURIComponent(viewByValue)+"&date="+new Date().getTime();
			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}

					if (viewByValue != 'cType')
					{
						sersegObj.setFieldLabel(userMailJSON.trDisplayText);
						sersegObj.getStore().loadRawData(userMailJSON.viewByType);
						sersegObj.setValue(userMailJSON.selectedGrpText);
						sersegObj.show();
						compTypes.getStore().removeAll();
						compTypes.getStore().loadData([
							{
								'displayField' : 'Not Applicable',
								'valueField' : '-1'
							}
						]);
						testCombo.getStore().removeAll();
						testCombo.getStore().loadData([
							{
								'displayField' : 'Not Applicable',
								'valueField' : '-1'
							}
						]);
						Ext.getCmp('compName').getStore().removeAll();
						Ext.getCmp('searchbox').setDisabled(true);
						Ext.getCmp('searchbox').setValue('');
					}
					else
					{
						me.popFilterDetails(filterObj);
						sersegObj.hide();
					}

					if(compTypes.getStore().getCount() > 0)
					{
						compTypes.setValue(compTypes.getStore().getAt(0));
					}
					if(testCombo.getStore().getCount() > 0)
					{
						testCombo.setValue(testCombo.getStore().getAt(0));
					}

					if (mailFilterOption == "Descriptors_Only")
					{
						tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
						tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
					}
				}
			});
		}
		else
		{
			page ="TrapReceiversAndSettings/data/EgMailAlertSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy="+filterBy+"&compTypesIn="+encodeURIComponent(viewByValue)+"&date="+new Date().getTime();
			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}

					if (viewByValue != 'cType')
					{
						sersegObj.setFieldLabel(userMailJSON.trDisplayText);
						sersegObj.getStore().loadRawData(userMailJSON.viewByType);
						sersegObj.setValue(userMailJSON.selectedGrpText);
						sersegObj.show();
						compTypes.getStore().removeAll();
						compTypes.getStore().loadData([
							{
								'displayField' : 'Not Applicable',
								'valueField' : '-1'
							}
						]);
						testCombo.getStore().removeAll();
						testCombo.getStore().loadData([
							{
								'displayField' : 'Not Applicable',
								'valueField' : '-1'
							}
						]);
						Ext.getCmp('compName').getStore().removeAll();
						Ext.getCmp('searchbox').setDisabled(true);
						Ext.getCmp('searchbox').setValue('');
					}
					else
					{
						me.popFilterDetails(filterObj);
						sersegObj.hide();
					}
					if(compTypes.getStore().getCount() > 0)
					{
						compTypes.setValue(compTypes.getStore().getAt(0));
					}
					if(testCombo.getStore().getCount() > 0)
					{
						testCombo.setValue(testCombo.getStore().getAt(0));
					}
					if (mailFilterOption == "Descriptors_Only")
					{
						tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
						tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
					}
				}
			});
		}
	},
	changeByServer : function(obj)
	{
		var viewByServer = obj.getValue();
		var filterBy = Ext.getCmp('filter').getValue();
		var compTypesIn = Ext.getCmp('compTypesIn').getValue();
		var CompTypesObj = Ext.getCmp('CompTypes');
		var testCombo = Ext.getCmp('Test');
		var page = "";
		if (mailFilterOption == "Descriptors_Only")
		{
			page ="TrapReceiversAndSettings/data/EgMailAlertIncludeSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy=filterByDescriptor&compTypesIn="+encodeURIComponent(compTypesIn)+"&serseg="+encodeURIComponent(viewByServer)+"&date="+new Date().getTime();
		}
		else
		{
			page ="TrapReceiversAndSettings/data/EgMailAlertSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy="+filterBy+"&compTypesIn="+encodeURIComponent(compTypesIn)+"&serseg="+encodeURIComponent(viewByServer)+"&date="+new Date().getTime();
		}

		Ext.Ajax.request({
			url : page,
			method: 'POST',
			success: function(response)
			{
				userMailJSON = Ext.decode(response.responseText);
				var tmpStore = Ext.getCmp('exclude');
				tmpStore.getStore().removeAll();
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
				CompTypesObj.getStore().loadRawData(userMailJSON.compopnentTypes);
				if(viewByServer == "-1")
				{
					CompTypesObj.getStore().removeAll();
					CompTypesObj.getStore().loadData([
						{
							'displayField' : 'Not Applicable',
							'valueField' : '-1'
						}
					]);
				}
				testCombo.getStore().removeAll();
				testCombo.getStore().loadData([
					{
						'displayField' : 'Not Applicable',
						'valueField' : '-1'
					}
				]);
				Ext.getCmp('compName').getStore().removeAll();
				Ext.getCmp('searchbox').setDisabled(true);
				Ext.getCmp('searchbox').setValue('');
				if(CompTypesObj.getStore().getCount() > 0)
				{
					CompTypesObj.setValue(CompTypesObj.getStore().getAt(0));
				}
				if(testCombo.getStore().getCount() > 0)
				{
					testCombo.setValue(testCombo.getStore().getAt(0));
				}
				if (mailFilterOption == "Descriptors_Only")
				{
					tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
					tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
				}
			}
		});
	},
	changeByTest : function(obj)
	{
		var viewByTest = obj.getValue();
		var filterBy = Ext.getCmp('filter').getValue();
		var compTypesIn = Ext.getCmp('compTypesIn').getValue();
		var compTypes = Ext.getCmp('CompTypes').getValue();
		var serseg = Ext.getCmp('serseg').getValue();
		var configTestType = "no";
		if(isConfigEnabled == "true")
		{
			var testType = Ext.getCmp('TestTypes').getValue();
			if(testType == "configuration")
			{
				configTestType = "yes";
			}
		}
		var page = "";
		if (mailFilterOption == "Descriptors_Only")
		{
			page ="TrapReceiversAndSettings/data/EgMailAlertIncludeSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy=filterByDescriptor&compTypesIn="+encodeURIComponent(compTypesIn)+"&serseg="+encodeURIComponent(serseg)+"&serverType="+encodeURIComponent(compTypes)+"&Test="+encodeURIComponent(viewByTest)+"&date="+new Date().getTime();
		}
		else
		{
			page ="TrapReceiversAndSettings/data/EgMailAlertSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom+"&configTestType="+configTestType;
			page = page + "&filterBy="+filterBy+"&compTypesIn="+encodeURIComponent(compTypesIn)+"&serseg="+encodeURIComponent(serseg)+"&serverType="+encodeURIComponent(compTypes)+"&Test="+encodeURIComponent(viewByTest)+"&date="+new Date().getTime();
		}
		
		if (!Ext.isEmpty(viewByTest) && viewByTest == '-1')
		{
			Ext.getCmp('searchbox').setDisabled(true);
			Ext.getCmp('searchbox').setValue('');
		}
		else
		{
			Ext.getCmp('searchbox').setDisabled(false);
			Ext.getCmp('searchbox').setValue('');
		}
		Ext.Ajax.request({
			url : page,
			method: 'POST',
			success: function(response)
			{
				userMailJSON = Ext.decode(response.responseText);
				var tmpStore = Ext.getCmp('exclude');
				tmpStore.getStore().removeAll();
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
				var compNameObj = Ext.getCmp('compName');
				compNameObj.getStore().loadRawData(userMailJSON.compNameArr);
				compNameArrTemp = userMailJSON.compNameArr;
				if (mailFilterOption == "Descriptors_Only")
				{
					tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
					tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
				}
			}
		});
	},
	changeByComponentName : function(obj)
	{
		var compNames = obj.getValue();
		if(compNames == "" || compNames == "-1")
		{
			var excludeItemObj = Ext.getCmp('exclude');
			excludeItemObj.getStore().removeAll();
			if(excludeItemObj.fromField.store.getCount() > 0)
			{
				excludeItemObj.fromField.store.removeAll();
			}
			if(excludeItemObj.toField.store.getCount() > 0)
			{
				excludeItemObj.toField.store.removeAll();
			}
			return;
		}
		var filterBy = Ext.getCmp('filter').getValue();
		var Test = Ext.getCmp('Test').getValue();
		var compTypes = Ext.getCmp('CompTypes').getValue();
		var compTypesInObj = Ext.getCmp('compTypesIn');

		var page = "";
		if (mailFilterOption == "Descriptors_Only")
		{
			page ="TrapReceiversAndSettings/data/EgMailAlertIncludeSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy=filterByDescriptor&compNames="+encodeURIComponent(compNames)+"&serverType="+encodeURIComponent(compTypes)+"&Test="+encodeURIComponent(Test);

			if (userMailJSON.isOtherGroupsFound == true)
			{
				var compTypesIn = compTypesInObj.getValue();
				page = page + "&compTypesIn="+compTypesIn;

				if (compTypesInObj.getValue() != 'cType')
				{
					var sersegObj = Ext.getCmp('serseg');
					if(sersegObj!=null && sersegObj!=undefined)
					{
						var sersegVal = sersegObj.getValue();
						if(sersegVal!=null && sersegVal!=undefined && sersegVal!="")
						{
							page = page + "&serseg="+sersegVal;
						}
					}
				}
			}

			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					if (!Ext.isEmpty(includedItems))
					{
						//tmpStore.fromField.store.add(excludedItems);
						tmpStore.fromField.store.add(includedItems);
					}
					if (!Ext.isEmpty(excludedItems))
					{
						//tmpStore.toField.store.add(includedItems);
						tmpStore.toField.store.add(excludedItems);
					}
					if (mailFilterOption == "Descriptors_Only")
					{
						tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
						tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
					}
				}
			});
		}
		else
		{
			page ="TrapReceiversAndSettings/data/EgMailAlertSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy="+filterBy+"&compNames="+encodeURIComponent(compNames)+"&serverType="+encodeURIComponent(compTypes)+"&Test="+encodeURIComponent(Test);

			if (userMailJSON.isOtherGroupsFound == true)
			{
				var compTypesIn = compTypesInObj.getValue();
				page = page + "&compTypesIn="+compTypesIn;

				if (compTypesInObj.getValue() != 'cType')
				{
					var sersegObj = Ext.getCmp('serseg');
					if(sersegObj!=null && sersegObj!=undefined)
					{
						var sersegVal = sersegObj.getValue();
						if(sersegVal!=null && sersegVal!=undefined && sersegVal!="")
						{
							page = page + "&serseg="+sersegVal;
						}
					}
				}
			}

			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					if (!Ext.isEmpty(excludedItems))
					{
						tmpStore.fromField.store.add(excludedItems);
					}
					if (!Ext.isEmpty(includedItems))
					{
						tmpStore.toField.store.add(includedItems);
					}
					if (mailFilterOption == "Descriptors_Only")
					{
						tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
						tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
					}
				}
			});
		}
	},
	popCompTypes : function(obj)
	{
		var tmpUserID = publicJSON.userID;
		var filterBy = Ext.getCmp('filter').getValue();
		var serverType = obj.getValue();
		var configTestType = "no";
		if(isConfigEnabled == "true")
		{
			var testType = Ext.getCmp('TestTypes').getValue();
			if(testType == "configuration")
			{
				configTestType = "yes";
			}
		}
		var page = "";
		if (mailFilterOption == "Descriptors_Only")
		{
			page ="TrapReceiversAndSettings/data/EgMailAlertIncludeSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom+"&configTestType="+configTestType;
			page = page + "&filterBy=filterByDescriptor&serverType="+encodeURIComponent(serverType)+"&date="+new Date().getTime();
			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}
					if (!Ext.isEmpty(excludedItems))
					{
						tmpStore.fromField.store.add(excludedItems);
					}
					if (!Ext.isEmpty(includedItems))
					{
						tmpStore.toField.store.add(includedItems);
					}

					var serverTestsOuterCt = Ext.getCmp('serverTestsOuterCt');
					var testCt = Ext.getCmp('Test');
					//if (filterBy == "filterByDescriptor")
					{
						Ext.getCmp('searchbox').setDisabled(true);
						Ext.getCmp('searchbox').setValue('');

						testCt.getStore().removeAll();
						Ext.getCmp('compName').getStore().removeAll();
						testCt.getStore().loadRawData(userMailJSON.testArray);
						testCt.setValue(userMailJSON.selectedDescriptorText);
					}
					if (mailFilterOption == "Descriptors_Only")
					{
						tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
						tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
					}
				}
			});
		}
		else
		{
			page ="TrapReceiversAndSettings/data/EgMailAlertSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom;
			page = page + "&filterBy="+filterBy+"&serverType="+encodeURIComponent(serverType)+"&date="+new Date().getTime();
			Ext.Ajax.request({
				url : page,
				method: 'POST',
				success: function(response)
				{
					userMailJSON = Ext.decode(response.responseText);
					var tmpStore = Ext.getCmp('exclude');
					var includedItems = userMailJSON['includedAlerts'];
					var excludedItems = userMailJSON['excludedAlerts'];
					tmpStore.getStore().removeAll();
					if(tmpStore.fromField.store.getCount() > 0)
					{
						tmpStore.fromField.store.removeAll();
					}
					if(tmpStore.toField.store.getCount() > 0)
					{
						tmpStore.toField.store.removeAll();
					}
					if (!Ext.isEmpty(excludedItems))
					{
						tmpStore.fromField.store.add(excludedItems);
					}
					if (!Ext.isEmpty(includedItems))
					{
						tmpStore.toField.store.add(includedItems);
					}

					var serverTestsOuterCt = Ext.getCmp('serverTestsOuterCt');
					var testCt = Ext.getCmp('Test');
					//var serverTestsCt = Ext.getCmp('serverTestsCt');
					if (filterBy == "filterByDescriptor")
					{
						testCt.getStore().removeAll();
						testCt.getStore().loadRawData(userMailJSON.testArray);
						testCt.setValue(userMailJSON.selectedDescriptorText);
						serverTestsOuterCt.show();
						Ext.getCmp('compName').getStore().removeAll();
						Ext.getCmp('searchbox').setDisabled(true);
						Ext.getCmp('searchbox').setValue('');
						testCt.show();
						//serverTestsCt.hide();
					}
					else
					{
						serverTestsOuterCt.hide();
						testCt.hide();
						//serverTestsCt.hide();
					}
					if (mailFilterOption == "Descriptors_Only")
					{
						tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
						tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
					}
				}
			});
		}
	},
	popTestTypes : function(obj)
	{
		updateSettings = false;
		var tmpUserID = Ext.getCmp('uname').getValue();
		var filterBy = Ext.getCmp('filter').getValue();
		var testType = obj.getValue();
		var compTypesIn = Ext.getCmp('compTypesIn').getValue();
		var compTypes = Ext.getCmp('CompTypes').getValue();
		var serseg = Ext.getCmp('serseg').getValue();		
		var configTestType = "no";
		if(testType == "configuration")
		{
			configTestType = "yes";
		}
		var page = "";
		if (mailFilterOption == "Descriptors_Only")
		{
			page ="TrapReceiversAndSettings/data/EgMailAlertIncludeSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom+"&configTestType="+configTestType;
			page = page + "&filterBy=filterByDescriptor&compTypesIn="+encodeURIComponent(compTypesIn)+"&serseg="+encodeURIComponent(serseg)+"&serverType="+encodeURIComponent(compTypes)+"&Test="+encodeURIComponent(viewByTest)+"&date="+new Date().getTime();
		}
		else
		{
			page ="TrapReceiversAndSettings/data/EgMailAlertSuppressJson.jsp?selectedTab=4&userID="+encodeURIComponent(selectedUserID)+"&mailFilterOption="+mailFilterOption+"&reqfrom="+reqFrom+"&serverType="+encodeURIComponent(compTypes)+"&configTestType="+configTestType;
			page = page + "&filterBy="+filterBy+"&serverType="+encodeURIComponent(serverType)+"&compTypesIn="+encodeURIComponent(compTypesIn)+"&serseg="+encodeURIComponent(serseg)+"&date="+new Date().getTime();
		}
		Ext.Ajax.request({
			url : page,
			method: 'POST',
			success: function(response)
			{
				userMailJSON = Ext.decode(response.responseText);
				var tmpStore = Ext.getCmp('exclude');
				var includedItems = userMailJSON['includedAlerts'];
				var excludedItems = userMailJSON['excludedAlerts'];
				tmpStore.getStore().removeAll();
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
				if (!Ext.isEmpty(excludedItems))
				{
					tmpStore.fromField.store.add(excludedItems);
				}
				if (!Ext.isEmpty(includedItems))
				{
					tmpStore.toField.store.add(includedItems);
				}
				var serverTestsOuterCt = Ext.getCmp('serverTestsOuterCt');
				var testCt = Ext.getCmp('Test');
				if (filterBy == "filterByDescriptor")
				{
					testCt.getStore().removeAll();
					testCt.getStore().loadRawData(userMailJSON.testArray);
					testCt.setValue(userMailJSON.selectedDescriptorText);
					serverTestsOuterCt.show();
					Ext.getCmp('compName').getStore().removeAll();
					Ext.getCmp('searchbox').setDisabled(true);
					Ext.getCmp('searchbox').setValue('');
					testCt.show();
				}
				else
				{
					serverTestsOuterCt.hide();
					testCt.hide();
				}
				if (mailFilterOption == "Descriptors_Only")
				{
					tmpStore.fromField.getComponent(0).setTitle(pageIntnl95);
					tmpStore.toField.getComponent(0).setTitle(pageIntnl96);
				}
			}
		});
	},
	updateResultPanel : function()
	{
		var isElementsAssociated = userElementJSON.isElementsAssociated;
		var userAssociationContainer = Ext.getCmp('userAssociationContainer');
		var elementassociationcontainer = Ext.getCmp('elementassociationcontainer');
		userAssociationContainer.removeAll();
		if (isElementsAssociated == true)
		{
			
			userAssociationContainer.add(
				{
				xtype : 'componentgroupedsummarygrid',
				store: new Ext.data.Store({
					fields: ['col_1', 'category','col_2','col_3'],
					groupField: 'category',
					data: userElementJSON.userTableData,
				})
			});
			userAssociationContainer.doLayout();
			Ext.getCmp('Expand').show();
		}
		else
		{
			Ext.getCmp('Expand').hide();
			var message = "<div class = \"iconInformation\" style=\"margin:12% auto auto auto\"></div><div>"+intnlLabel5+".</div>";
			var tmpPanel = {
				xtype : 'component',
				width : '100%',
				border : false,
				style:{'text-align':'center'},
				html : message
			}
			userAssociationContainer.add(tmpPanel);
		}
	},
	getHiddenFields : function(hiddenFields)
	{
		var hiddenQstr = "";
		for (key in hiddenFields)
		{
			if ((key == 'previousSelectedValue' || key == 'previousVMs' || key == 'previouscomponents' || key == 'previoussegments' || key == 'previousservicegroup' || key == 'previousservices' || key == 'previouszones' || key == 'previousExcVal') && !Ext.isEmpty(key))
			{
				continue;
			}

			if (key == "vsTypes")
			{
				continue;
			}
			hiddenQstr += key+'='+encodeURIComponent(hiddenFields[key])+"&";
		}
		return hiddenQstr;
	},

	updateFilterComponents : function()
	{
		var me = this;
		var elementFilteringTabObj = Ext.getCmp('main');
		var isComponentsAssociated = userMailJSON.isComponentsAssociated;
		if (isComponentsAssociated == true)
		{
			var egmailalertsuppressObj = Ext.getCmp('egmailalertsuppress');
			if (egmailalertsuppressObj == null || egmailalertsuppressObj == 'undefined' || egmailalertsuppressObj == undefined)
			{
				elementFilteringTabObj.removeAll();
				elementFilteringTabObj.add({xtype : 'egmailalertsuppress'});
			}
			Ext.getCmp('filterUserID').setValue(selectedUserID);
		}
		else
		{
			var tmpUserID = userMailJSON['userID'];
			var message = "<div class = \"iconInformation\" style=\"margin:0 auto\"></div><div>No components have been associated for <b>'"+tmpUserID+"'</b></div>";
			elementFilteringTabObj.removeAll();
			elementFilteringTabObj.add({
				xtype : 'panel',
				border : false,
				padding:160,
				style:{'text-align':'center'},
				html:message
			});
		}
	},
	setLangEntries : function(landEntriesJson)
	{
		for (var key in landEntriesJson)
		{
			var tmpObj = Ext.getCmp(key);
			if (tmpObj ==  null || tmpObj == 'undefined')
			{
				continue;
			}
			if (tmpObj.getXType() == "checkboxfield" || tmpObj.getXType() == "radiofield")
			{
				if (tmpObj.boxLabelEl == null || tmpObj.boxLabelEl == undefined || tmpObj.boxLabelEl == 'undefined')
				{
					continue;
				}
				tmpObj.boxLabelEl.update(landEntriesJson[key]);
			}
			else
			{
				tmpObj.setFieldLabel(landEntriesJson[key]);
			}
		}
	},
	initUserMailConfigs : function()
	{
		var me = this;
		var queryStatus = userMailJSON.requestStatus;
		if (queryStatus == "success")
		{
			var tmpUserID = selectedUserID;
			this.setLangEntries(userMailJSON.langEntries);
			var filters = userMailJSON.filters;
			var isComponentsAssociated = userMailJSON.isComponentsAssociated;
			if (isComponentsAssociated == true)
			{
				var associateObj = Ext.getCmp('filter');
				associateObj.getStore().loadRawData(filters);
				associateObj.setValue("-1");
				Ext.getCmp('CompTypes').hide();
				var tmpStore = Ext.getCmp('exclude');
				if(tmpStore.fromField.store.getCount() > 0)
				{
					tmpStore.fromField.store.removeAll();
				}
				if(tmpStore.toField.store.getCount() > 0)
				{
					tmpStore.toField.store.removeAll();
				}
			}
			else
			{
				var elementFilteringTabObj = Ext.getCmp('main');
				var tmpUserID = selectedUserID;
				var message = "<div class = \"iconInformation\" style=\"margin:0 auto\"></div><div>No components have been associated for <b>'"+tmpUserID+"'</b></div>";
				elementFilteringTabObj.removeAll();
				elementFilteringTabObj.add({
					xtype : 'component',
					border : false,
					padding:160,
					style:{'text-align':'center'},
					html:message
				});
			}
		}
		else
		{
			var elementFilteringTabObj = Ext.getCmp('main');
			var message = me.getErrorMessageTemplate(userMailJSON.errors);
			elementFilteringTabObj.removeAll();
			elementFilteringTabObj.add({
				xtype : 'component',
				border : false,
				padding:160,
				style:{'text-align':'center'},
				html:message
			});
		}
	},
	getErrorMessageTemplate :function(tmpObj)
	{
		var tmpTable = '<div class="x-table"><table cellspacing="0" width="100%" cellpadding="5" border="0" align="center" class="x-grid-table" style="border:1px solid #c3c3c3"><thead><tr class="x-grid-row"><th class=" x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner">Error</div></td></tr></thead>'
		for (var key in tmpObj)
		{
			if (key == "title") continue ;
			var errorMessage = tmpObj[key];
			tmpTable = tmpTable + '<tr class="x-grid-row"><td class=" x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner" >'+errorMessage+'</div></td></tr>';
		}
		tmpTable = tmpTable + '</table></div>';
		return tmpTable;
	},
	updateFilterResultPanel : function()
	{
				var me = this;
		var userFilterContainerObj = Ext.getCmp('userFilterContainer');
		var filters = userMailJSON.filters;
		userFilterContainerObj.removeAll();
		if (userMailJSON['isFiltersAvailable'] != null && userMailJSON['isFiltersAvailable'] != undefined && userMailJSON['isFiltersAvailable'] == true)
		{
			var excludedElements = userMailJSON.excludedElements;
			var gridHeaderMapping = userMailJSON.gridHeaderMapping;
			for (var key in excludedElements)
			{
				var gridObj = excludedElements[key];
				if (key == "excludedComponents" || key == "allExcludedLayersByType" || key == "exculdedTestsForAllTypes" || key == "exculdedDescriptor")
				{
					var gridTitle = gridHeaderMapping[key];
					if (gridObj == "" || gridObj.length == 0)
					{
						continue;
					}
					var tmpPanel = {
						xtype : 'panel',
						cls : 'outerpanel',
						border : false,
						width : '95%',
						title : gridTitle,
						html : gridObj
					}
					userFilterContainerObj.add(tmpPanel);
				}
				else
				{
					var gridTitle = gridHeaderMapping[key];
					if (Ext.isEmpty(gridObj))
					{
						continue;
					}
					var tmpResult = me.getGridPanel(gridObj,gridTitle);
					userFilterContainerObj.add(tmpResult);
				}
			}
			userFilterContainerObj.doLayout();
		}
		else
		{
			var message = "<div class = \"iconInformation\" style=\"margin:0 auto\"></div><div>No elements are excluded for this user</b></div>";
			var tmpPanel = {
				xtype : 'component',
				border : false,
				padding : 120,
				html : message
			}
			userFilterContainerObj.add(tmpPanel);
		}
		Ext.getCmp('userFilterWindow').doLayout();
	},
	showResultText : function()
	{
		if (Ext.getCmp('resultCt') == null || Ext.getCmp('resultCt') == undefined)
		{
			var panelAbsolute = Ext.create('Ext.container.Container',{
				floatable : true,
				floating:true,
				id : 'resultCt',
				width : 380,
				items : [
					{
						xtype : 'component',
						padding :0,
						margin:5,
						cls : 'popupAlertUser',
						html  : '<table border="0" width="100%"><tr><td><div class="iconRight" style="margin:4px;float:left"></div><div style="margin:4px;float:left">Changes have been updated successfully.</div><div class="iconClosePopup" style="float:right;margin:4px"></div><td></tr></table>',
					}
				]
			});
			var VWidth = Ext.Element.getViewportWidth();
			panelAbsolute.showAt(VWidth-410,85);
			Ext.select('.iconClosePopup').on('click',function(){
				panelAbsolute.destroy();
			},this);

			var task = new Ext.util.DelayedTask(function(){
				panelAbsolute.destroy();
			});
			task.delay(2000);
		}
	},
	settingsUpdateData_old: function()
	{
		var QString = this.genQueryString(publicJson['hiddenObj']);
		var qStr = '';
		var snmpMgrSrc = Ext.getCmp('snmpMgrSourceYes').getValue();
		var snmpMgrTrapMetrics = Ext.getCmp('snmpMgrTrapMetricsYes').getValue();
		var snmpMgrSystems = Ext.getCmp('snmpMgrSystemsYes').getValue();
		if(snmpMgrSrc)
		{
			qStr += 'UseIpInSnmpTraps=Yes';
		}
		else
		{
			qStr += 'UseIpInSnmpTraps=No';
		}

		if(snmpMgrTrapMetrics)
		{
			qStr += '&SnmpIndividualTraps=Yes';
		}
		else
		{
			qStr += '&SnmpIndividualTraps=No';
		}
		if(snmpMgrSystems)
		{
			qStr += '&SnmpSystemTraps=Yes';
		}
		else
		{
			qStr += '&SnmpSystemTraps=No';
		}

		var sysStateChkPeriod = Ext.getCmp('snmpMgrFreqState').getValue();
		if(isAValidNumber(Ext.getCmp('snmpMgrFreqState').getValue())=="false")
		{
			Ext.Msg.show ({
				title: pageName,
				msg: alert1,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation',
				fn: function() {
					Ext.getCmp('snmpMgrFreqState').focus(true);
				}
			});
			return;
		}
		else
		{
			qStr += '&SystemStateCheckPeriod='+sysStateChkPeriod;
		}
		qStr += QString;
		Ext.Ajax.request({
			url:'TrapReceiversAndSettings/data/Egsnmpconfigp.jsp?from=settings&'+qStr+'&selectTab=settingsnmp',
			method:'post',
			async : false,
			scope:this,
			success:function(response)
			{
				Ext.Msg.show ({
					title: pageName,
					msg: alert2,
					buttons: Ext.MessageBox.OK,
					icon: 'iconInformation'
				});
			}
		});
	},
	modifySnmpVersionComboLoad: function()
	{
		var snmpMgrIp = Ext.getCmp('modifySnmpMgrIpCombo').getValue();
		var snmpMgrPort = Ext.getCmp('modifySnmpMgrPort').getValue();
		var snmpVersion = Ext.getCmp('modifySnmpVersionCombo').getValue();
		var tt_traps = publicJson['hiddenObj']['$_ttflag'];
		Ext.Ajax.request({
				url:'TrapReceiversAndSettings/data/EgSnmpTrapReceiverConfigJson.jsp?snmp_version='+snmpVersion+'&snmp_manager='+snmpMgrIp+'&snmp_port='+snmpMgrPort+'&ini=false&from=verChange&changeSnmp=Modify&$_ttflag='+tt_traps,
				method:'post',	
				scope:this,
				async: false,
				success:function(response)
				{	
					if(response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						publicJson = Ext.decode(jsonText);
					}
				}
			});
		this.modifyLoadData();
	},
	modifySnmpMgrComboLoad: function()
	{
		var snmpMgrIp = Ext.getCmp('modifySnmpMgrIpCombo').getValue();
		if (snmpMgrIp != null && !Ext.isEmpty(snmpMgrIp))
		{
			Ext.Ajax.request({
				url:'TrapReceiversAndSettings/data/EgSnmpTrapReceiverConfigJson.jsp?snmp_manager='+snmpMgrIp+'&changeSnmp=Modify&ini=false&from=mgrChange',
				method:'post',	
				scope:this,
				async: false,
				success:function(response)
				{	
					if(response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						publicJson = Ext.decode(jsonText);
					}
				}
			});
		}
		this.modifyLoadData();
	},
	deleteSnmpMgr: function()
	{
		var snmpMgrIps = Ext.getCmp('delSnmpMultiSelect').getValue();
		if(!Ext.isEmpty(snmpMgrIps) && snmpMgrIps != undefined)
		{
			snmpMgrIps = snmpMgrIps.toString().trim();
		}
		if(Ext.isEmpty(snmpMgrIps) || snmpMgrIps == undefined)
		{
			Ext.Msg.show ({
				title: pageName,
				msg: alert3,
				buttons: Ext.MessageBox.OK,
				icon: 'iconExclamation'
			});
			return;
		}

		if(snmpMgrIps != null && snmpMgrIps.length > 0 )
		{
			Ext.Msg.show ({
				title: pageName,
				msg: alert4,
				buttons: Ext.MessageBox.YESNO,
				icon: 'iconConfirmation',
				fn: function(response) {
					if(response == 'yes')
					{
						Ext.Ajax.request({
							url:'TrapReceiversAndSettings/data/Egsnmpconfigp.jsp?selectTab=deletesnmp&from=delete&disable=true&comeFrom=new&snmpMgrIP='+snmpMgrIps,
							method:'post',
							async : false,
							scope:this,
							success:function(response)
							{
								Ext.Msg.show ({
									title: pageName,
									msg: alert5,
									buttons: Ext.MessageBox.OK,
									icon: 'iconInformation',
									fn: function(response) {
										Ext.Ajax.request({
											url:'TrapReceiversAndSettings/data/EgSnmpTrapReceiverConfigJson.jsp?changeSnmp=Delete&selectTab=deletesnmp',
											method:'post',	
											scope:this,
											async: false,
											success:function(response)
											{	
												if(response.status == 200 && !Ext.isEmpty(response.responseText))
												{
													var jsonText = response.responseText;
													publicJson = Ext.decode(jsonText);
													var isSnmpItemAvailable = publicJson['isSnmpItemAvailable'];
													if (!isSnmpItemAvailable)
													{
														Ext.getCmp('deleteSnmpContainer').hide();
														Ext.getCmp('deleteBtn').hide();
														Ext.getCmp('noDelSnmpMgrContainer').show();
														var noDataMsg = publicJson['No_data'];
														Ext.getCmp('noDelSNMPMgrLabel').update(noDataMsg);
													}
													else
													{
														Ext.getCmp('deleteSnmpContainer').show();
														Ext.getCmp('deleteBtn').show();

														Ext.getCmp('noDelSnmpMgrContainer').hide();
														Ext.getCmp('delSnmpMultiSelect').getStore().removeAll();
														Ext.getCmp('delSnmpMultiSelect').getStore().loadRawData(publicJson['snmpManagerListObj']);
													}
												}
											}
										});
									}
								});
							}
						});
					}
				}
			});
		}
	},
	modifyLoadData: function()
	{
		Ext.getCmp('modifySnmpMgrIpCombo').getStore().removeAll();
		Ext.getCmp('modifySnmpMgrIpCombo').getStore().loadRawData(publicJson['snmpManagerListObj']);
		var defaultValue = publicJson['selectedSnmpMgrValues'];
		var isSnmpItemAvailable = publicJson['isSnmpItemAvailable'];
		if (defaultValue != null && !Ext.isEmpty(defaultValue))
		{
			Ext.getCmp('modifyComponentsContainer').show();
			Ext.getCmp('modifyBtnContainer').show();
			Ext.getCmp('noSnmpMgrContainer').hide();
			var params = defaultValue.split('~|~');
			for(var i=0;i<params.length;)
			{
				Ext.getCmp('modifySnmpMgrIpCombo').setValue(params[i]);
				Ext.getCmp('modifySnmpMgrPort').setValue(params[i+1]);
				Ext.getCmp('modifySnmpVersionCombo').setValue(params[i+2]);
				if(params[i+2] == 'v3')
				{
					Ext.getCmp('modifySnmpMgrCommunity').hide();
					if(params[i+3] != null && !Ext.isEmpty(params[i+3]))
					{
						Ext.getCmp('modifyEngineId').show();
						Ext.getCmp('modifyEngineId').setValue(params[i+3]);
					}
					else
					{
						Ext.getCmp('modifyEngineId').show();
						Ext.getCmp('modifyEngineId').reset();
					}

					if(params[i+4] != null && !Ext.isEmpty(params[i+4]))
					{
						Ext.getCmp('modifyUserName').show();
						Ext.getCmp('modifyUserName').setValue(params[i+4]);
					}
					else
					{
						Ext.getCmp('modifyUserName').show();
						Ext.getCmp('modifyUserName').reset();
					}

					if (params[i+5] != null && !Ext.isEmpty(params[i+5]))
					{
						Ext.getCmp('modifyAuthPwd').show();
						Ext.getCmp('modifyAuthPwd').setValue(params[i+5]);
					}
					else
					{
						Ext.getCmp('modifyAuthPwd').show();
						Ext.getCmp('modifyAuthPwd').reset();
					}

					if (params[i+5] != null && !Ext.isEmpty(params[i+5]))
					{
						Ext.getCmp('modifyAuthConPwd').show();
						Ext.getCmp('modifyAuthConPwd').setValue(params[i+5]);
					}
					else
					{
						Ext.getCmp('modifyAuthConPwd').show();
						Ext.getCmp('modifyAuthConPwd').reset();
					}

					if(params[i+6] != null && !Ext.isEmpty(params[i+6]))
					{
						Ext.getCmp('modifyAuthTypeCombo').show();
						Ext.getCmp('modifyAuthTypeCombo').setValue(params[i+6]);
					}
					else
					{
						Ext.getCmp('modifyAuthTypeCombo').show();
						Ext.getCmp('modifyAuthTypeCombo').setValue('MD5');
					}
					var encryptFlag = params[i+7];
					Ext.getCmp('modifyEncryptFlagRadio').show();
					//Ext.getCmp('modifyTTTraps').show();
					//Ext.getCmp('modifyAlarm').show();
					if(encryptFlag == 'Yes')
					{
						Ext.getCmp('modifyEncryptFlagYes').setValue(true);
						Ext.getCmp('modifyEncryptTypeCombo').show();
						Ext.getCmp('modifyEncryptTypeCombo').setValue(params[i+8]);
						Ext.getCmp('modifyEncryptTypePwd').show();
						Ext.getCmp('modifyEncryptTypePwd').setValue(params[i+9]);
						Ext.getCmp('modifyEncryptTypeConPwd').show();
						Ext.getCmp('modifyEncryptTypeConPwd').setValue(params[i+9]);
						var tttrapsVal = params[i+10];
						//if(tttrapsVal == 'Yes')
						//{
							//Ext.getCmp('modifyTTTrapYes').setValue(true);
						//}
						//else
						//{
							//Ext.getCmp('modifyTTTrapNo').setValue(true);
						//}
						var alarmsArr = params[i+11].split(',');
						for(var j=0;j<alarmsArr.length;)
						{
							var alarmHigh = alarmsArr[j];
							var alarmMajor = alarmsArr[j+1];
							var alarmLow = alarmsArr[j+2];
							var alarmNormal = alarmsArr[j+3];
							if(alarmHigh.indexOf('checked') > -1)
							{
								Ext.getCmp('modifyCritical').setValue(true);
							}
							else
							{
								Ext.getCmp('modifyCritical').setValue(false);
							}

							if(alarmMajor.indexOf('checked') > -1)
							{
								Ext.getCmp('modifyMajor').setValue(true);
							}
							else
							{
								Ext.getCmp('modifyMajor').setValue(false);
							}

							if(alarmLow.indexOf('checked') > -1)
							{
								Ext.getCmp('modifyMinor').setValue(true);
							}
							else
							{
								Ext.getCmp('modifyMinor').setValue(false);
							}

							if(alarmNormal.indexOf('checked') > -1)
							{
								Ext.getCmp('modifyNormal').setValue(true);
							}
							else
							{
								Ext.getCmp('modifyNormal').setValue(false);
							}
							j=alarmsArr.length+1;
						}
					}
					else
					{
						Ext.getCmp('modifyEncryptFlagNo').setValue(true);
						Ext.getCmp('modifyEncryptTypeCombo').hide();
						Ext.getCmp('modifyEncryptTypePwd').hide();
						Ext.getCmp('modifyEncryptTypeConPwd').hide();
						var tttrapsVal = params[i+8];
						//if(tttrapsVal == 'Yes')
						//{
							//Ext.getCmp('modifyTTTrapYes').setValue(true);
						//}
						//else
						//{
							//Ext.getCmp('modifyTTTrapNo').setValue(true);
						//}

						var alarmsArr = params[i+9].split(',');
						for(var j=0;j<alarmsArr.length;)
						{
							var alarmHigh = alarmsArr[j];
							var alarmMajor = alarmsArr[j+1];
							var alarmLow = alarmsArr[j+2];
							var alarmNormal = alarmsArr[j+3];
							
							if(alarmHigh.indexOf('checked') > -1)
							{
								Ext.getCmp('modifyCritical').setValue(true);
							}
							else
							{
								Ext.getCmp('modifyCritical').setValue(false);
							}

							if(alarmMajor.indexOf('checked') > -1)
							{
								Ext.getCmp('modifyMajor').setValue(true);
							}
							else
							{
								Ext.getCmp('modifyMajor').setValue(false);
							}

							if(alarmLow.indexOf('checked') > -1)
							{
								Ext.getCmp('modifyMinor').setValue(true);
							}
							else
							{
								Ext.getCmp('modifyMinor').setValue(false);
							}

							if(alarmNormal.indexOf('checked') > -1)
							{
								Ext.getCmp('modifyNormal').setValue(true);
							}
							else
							{
								Ext.getCmp('modifyNormal').setValue(false);
							}
							j=alarmsArr.length+1;
						}
					}
				}
				else
				{
					Ext.getCmp('modifyEngineId').hide();
					Ext.getCmp('modifyUserName').hide();
					Ext.getCmp('modifyAuthPwd').hide();
					Ext.getCmp('modifyAuthConPwd').hide();
					Ext.getCmp('modifyAuthTypeCombo').hide();
					Ext.getCmp('modifyEncryptFlagRadio').hide();
					Ext.getCmp('modifyEncryptTypeCombo').hide();
					Ext.getCmp('modifyEncryptTypePwd').hide();
					Ext.getCmp('modifyEncryptTypeConPwd').hide();
					Ext.getCmp('modifySnmpMgrCommunity').show();
					Ext.getCmp('modifySnmpMgrCommunity').setValue(params[i+3]);
					var tttrapsVal = params[i+4];
					//if(tttrapsVal == 'Yes')
					//{
						//Ext.getCmp('modifyTTTrapYes').setValue(true);
					//}
					//else
					//{
						//Ext.getCmp('modifyTTTrapNo').setValue(true);
					//}
					var alarmsArr = params[i+5].split(',');
					for(var j=0;j<alarmsArr.length;)
					{
						var alarmHigh = alarmsArr[j];
						var alarmMajor = alarmsArr[j+1];
						var alarmLow = alarmsArr[j+2];
						var alarmNormal = alarmsArr[j+3];
						if(alarmHigh.indexOf('checked') > -1)
						{
							Ext.getCmp('modifyCritical').setValue(true);
						}
						else
						{
							Ext.getCmp('modifyCritical').setValue(false);
						}
						if(alarmMajor.indexOf('checked') > -1)
						{
							Ext.getCmp('modifyMajor').setValue(true);
						}
						else
						{
							Ext.getCmp('modifyMajor').setValue(false);
						}
						if(alarmLow.indexOf('checked') > -1)
						{
							Ext.getCmp('modifyMinor').setValue(true);
						}
						else
						{
							Ext.getCmp('modifyMinor').setValue(false);
						}
						if(alarmNormal.indexOf('checked') > -1)
						{
							Ext.getCmp('modifyNormal').setValue(true);
						}
						else
						{
							Ext.getCmp('modifyNormal').setValue(false);
						}
						j=alarmsArr.length+1;
					}
				}
				i = params.length + 1;
			}
		}
		else
		{
			Ext.getCmp('modifyComponentsContainer').hide();
			Ext.getCmp('modifyBtnContainer').hide();
			Ext.getCmp('noSnmpMgrContainer').show();
			var noDataMsg = publicJson['No_data'];
			Ext.getCmp('noSNMPMgrLabel').update(noDataMsg);

		}
	},
	tabChange: function(type)
	{

		var selectTab = Ext.getCmp('snmp').getActiveTab().getItemId();
		if(selectTab == 'addsnmp')
		{
			this.buildFieldData('Add',selectTab);
			this.refreshAddTab();
		}
		else if (selectTab == 'modifysnmp')
		{
			this.buildFieldData('Modify',selectTab);
			this.modifyLoadData();
		}
		else if (selectTab == 'deletesnmp')
		{
			this.buildFieldData('Delete',selectTab);
			var isSnmpItemAvailable = publicJson['isSnmpItemAvailable'];
			if (!isSnmpItemAvailable)
			{
				Ext.getCmp('deleteSnmpContainer').hide();
				Ext.getCmp('deleteBtn').hide();

				Ext.getCmp('noDelSnmpMgrContainer').show();
				var noDataMsg = publicJson['No_data'];
				Ext.getCmp('noDelSNMPMgrLabel').update(noDataMsg);
			}
			else
			{
				Ext.getCmp('deleteSnmpContainer').show();
				Ext.getCmp('deleteBtn').show();
				Ext.getCmp('noDelSnmpMgrContainer').hide();
				Ext.getCmp('delSnmpMultiSelect').getStore().loadRawData(publicJson['snmpManagerListObj']);
			}
		}
		else if (selectTab == 'viewsnmp')
		{
			this.buildFieldData('View',selectTab);
			Ext.getCmp('snmpViewGrid').getStore().loadRawData(publicJson['gridViewArr']);
		}
		else if (selectTab == 'settingssnmp')
		{
			this.buildSettingsFieldData();
		}
		else if (selectTab == 'mailfilter')
		{
			this.afterMainRender();
		}
	},
	tabChangeAfterModifyMgr: function(obj,snmpMgrIp)
	{

		var selectTab = Ext.getCmp('snmp').getActiveTab().getItemId();
		if(selectTab == 'addsnmp')
		{
			this.buildFieldData('Add',selectTab);
			this.refreshAddTab();
		}
		else if (selectTab == 'modifysnmp')
		{
			this.buildFieldData('Modify',selectTab,snmpMgrIp);
			this.modifyLoadData();
		}
		else if (selectTab == 'deletesnmp')
		{
			this.buildFieldData('Delete',selectTab);
			var isSnmpItemAvailable = publicJson['isSnmpItemAvailable'];
			if (!isSnmpItemAvailable)
			{
				Ext.getCmp('deleteSnmpContainer').hide();
				Ext.getCmp('deleteBtn').hide();

				Ext.getCmp('noDelSnmpMgrContainer').show();
				var noDataMsg = publicJson['No_data'];
				Ext.getCmp('noDelSNMPMgrLabel').update(noDataMsg);
			}
			else
			{
				Ext.getCmp('deleteSnmpContainer').show();
				Ext.getCmp('deleteBtn').show();
				Ext.getCmp('noDelSnmpMgrContainer').hide();
				Ext.getCmp('delSnmpMultiSelect').getStore().loadRawData(publicJson['snmpManagerListObj']);
			}
		}
		else if (selectTab == 'viewsnmp')
		{
			this.buildFieldData('View',selectTab);
			Ext.getCmp('snmpViewGrid').getStore().loadRawData(publicJson['gridViewArr']);
		}
		else if (selectTab == 'settingssnmp')
		{
			this.buildSettingsFieldData();
		}
	},
	buildSettingsFieldData: function()
	{
		Ext.Ajax.request({
			url:'TrapReceiversAndSettings/data/EgSnmpConfigSettingsJson.jsp?',
			method:'post',
			scope:this,
			async: false,
			success:function(response)
			{	
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					var useIpSnmpTraps = publicJson['RESULT_OBJ']['useIpInSnmpTraps'];
					var snmpIndividualTraps = publicJson['RESULT_OBJ']['snmpIndividualTraps'];
					var snmpSystemTraps = publicJson['RESULT_OBJ']['snmpSystemTraps'];
					var systemStateCheckPeriod = publicJson['RESULT_OBJ']['systemStateCheckPeriod'];
					var sendTrapArr = publicJson['sendTrapArr'];
					var sendTrap = publicJson['sendTrap'];
					var trapLog = publicJson['trapLog'];
					var trapLogSize = publicJson['trapLogSize'];
					var trapLogFileLimit = publicJson['trapLogFileLimit'];
					var trapAlertList = publicJson['trapAlertList'];
					if(useIpSnmpTraps != null && useIpSnmpTraps != 'undefined' && (useIpSnmpTraps == 'Yes' || useIpSnmpTraps == 'yes'))
					{
						Ext.getCmp('snmpMgrSourceYes').setValue(true);
					}
					else
					{
						Ext.getCmp('snmpMgrSourceNo').setValue(true);
					}

					if(trapAlertList != undefined && trapAlertList != null && !Ext.isEmpty(trapAlertList))
					{
						if(trapAlertList.indexOf('HIGH') != -1)
							Ext.getCmp('modifyCritical').setValue(true);
						if(trapAlertList.indexOf('MEDIUM') != -1)
							Ext.getCmp('modifyMajor').setValue(true);
						if(trapAlertList.indexOf('LOW') != -1)
							Ext.getCmp('modifyMinor').setValue(true);
						if(trapAlertList.indexOf('NORMAL') != -1)
							Ext.getCmp('modifyNormal').setValue(true);
					}

					if(sendTrapArr != undefined && sendTrapArr != null && !Ext.isEmpty(sendTrapArr))
					{
						var st = Ext.getCmp('sendTrapsFor');
						st.getStore().loadRawData(sendTrapArr);
						st.setValue(sendTrap);
					}

					if(trapLog != null && trapLog != 'undefined' && (trapLog == 'Yes' || trapLog == 'yes'))
					{
						Ext.getCmp('logYes').setValue(true);
						Ext.getCmp('logSize').setValue(trapLogSize);
						Ext.getCmp('logfilelimit').setValue(trapLogFileLimit);
					}
					else
					{
						Ext.getCmp('logNo').setValue(true);
					}

					/*if(snmpIndividualTraps != null && snmpIndividualTraps != 'undefined' && (snmpIndividualTraps == 'Yes' || snmpIndividualTraps == 'yes'))
					{
						Ext.getCmp('snmpMgrTrapMetricsYes').setValue(true);
					}
					else
					{
						Ext.getCmp('snmpMgrTrapMetricsNo').setValue(true);
					}
					
					if(snmpSystemTraps != null && snmpSystemTraps != 'undefined' && (snmpSystemTraps == 'yes' || snmpSystemTraps == 'Yes'))
					{
						Ext.getCmp('snmpMgrSystemsYes').setValue(true);
					}
					else
					{
						Ext.getCmp('snmpMgrSystemsNo').setValue(true);
					}
					Ext.getCmp('snmpMgrFreqState').setValue(systemStateCheckPeriod);*/
				}
			}
		});
	},
	buildFieldData: function(tabType,selectTab,snmpMgrIP)
	{
		if(Ext.isEmpty(tabType) || Ext.isObject(tabType))
		{
			tabType = 'Add';
		}

		var qString = 'changeSnmp='+tabType+'&selectTab='+selectTab;

		if(!Ext.isEmpty(snmpMgrIP))
		{
			qString += '&snmp_manager='+snmpMgrIP;
		}

		Ext.Ajax.request({
			url:'TrapReceiversAndSettings/data/EgSnmpTrapReceiverConfigJson.jsp?'+qString,
			method:'post',	
			scope:this,
			async: false,
			success:function(response)
			{	
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					var snmpTypeSelected = publicJson['snmpTypeSelected'];
					/*if (snmpTypeSelected == 'Add' )
					{
						if (Ext.getCmp('alarmCheckGrpAdd').isHidden())
						{
							Ext.getCmp('alarmCheckGrpAdd').show()
						}
					}
					else
					{
						if (Ext.getCmp('modifyAlarm').isHidden())
						{
							Ext.getCmp('modifyAlarm').show()
						}
					}*/
				}
			}
		});
	},
	changeModifyEncryptType: function()
	{
		var selectEncryptYesVal = Ext.getCmp('modifyEncryptFlagYes').getValue();
		var selectEncryptNoVal = Ext.getCmp('modifyEncryptFlagNo').getValue();
		if(selectEncryptYesVal)
		{
			Ext.getCmp('modifyEncryptFlagYes').setValue(true);
			Ext.getCmp('modifyEncryptTypeCombo').show();
			Ext.getCmp('modifyEncryptTypePwd').show();
			Ext.getCmp('modifyEncryptTypeConPwd').show();
			Ext.getCmp('modifyEncryptTypeCombo').reset();
			Ext.getCmp('modifyEncryptTypePwd').reset();
			Ext.getCmp('modifyEncryptTypeConPwd').reset();
		}
		else
		{
			Ext.getCmp('modifyEncryptFlagNo').setValue(true);
			Ext.getCmp('modifyEncryptTypeCombo').hide();
			Ext.getCmp('modifyEncryptTypePwd').hide();
			Ext.getCmp('modifyEncryptTypeConPwd').hide();
		}
	},
	changeEncryptType: function()
	{
		var selectEncryptFlagYesAdd = Ext.getCmp('encryptradioYesAdd').getValue();
		var selectEncryptNoVal = Ext.getCmp('encryptradioNoAdd').getValue();
		if(selectEncryptFlagYesAdd)
		{
			Ext.getCmp('encryptradioYesAdd').setValue(true);
			Ext.getCmp('snmpMgrEncryptTypeComboAdd').show();
			Ext.getCmp('snmpMgrEncryptPwdAdd').show();
			Ext.getCmp('snmpMgrEncryptConPwdAdd').show();
			Ext.getCmp('snmpMgrEncryptTypeComboAdd').reset();
			Ext.getCmp('snmpMgrEncryptPwdAdd').reset();
			Ext.getCmp('snmpMgrEncryptConPwdAdd').reset();
		}
		else
		{
			Ext.getCmp('encryptradioNoAdd').setValue(true);
			Ext.getCmp('snmpMgrEncryptTypeComboAdd').hide();
			Ext.getCmp('snmpMgrEncryptPwdAdd').hide();
			Ext.getCmp('snmpMgrEncryptConPwdAdd').hide();
		}
		//Ext.getCmp('ttTrapsAdd').reset();
		Ext.getCmp('alarmCheckGrpAdd').reset();

	},
	comboLoad: function()
	{
		var versionType = Ext.getCmp('snmpversioncomboadd').getValue();
		if(versionType != null && versionType != 'undefined' && versionType == 'v3')
		{
			Ext.getCmp('snmpMgrCommunityAdd').hide();
			Ext.getCmp('encryptradioAdd').show();
			Ext.getCmp('encryptradioAdd').reset();
			Ext.getCmp('snmpMgrEngineIdAdd').show();
			Ext.getCmp('snmpMgrEngineIdAdd').reset();
			Ext.getCmp('snmpMgrUserNameAdd').show();
			Ext.getCmp('snmpMgrUserNameAdd').reset();
			Ext.getCmp('snmpMgrAuthPwdAdd').show();
			Ext.getCmp('snmpMgrAuthPwdAdd').reset();
			Ext.getCmp('snmpMgrAuthConPwdAdd').show();
			Ext.getCmp('snmpMgrAuthConPwdAdd').reset();
			Ext.getCmp('snmpauthtypecomboadd').show();
			Ext.getCmp('snmpauthtypecomboadd').reset();
			//Ext.getCmp('snmpauthtypecomboadd').getView().refresh();
			//Ext.getCmp('encryptradioAdd').reset();
			//Ext.getCmp('ttTrapsAdd').show();
			//Ext.getCmp('ttTrapsAdd').reset();
			Ext.getCmp('alarmCheckGrpAdd').reset();

		}
		else
		{
			Ext.getCmp('encryptradioAdd').hide();
			Ext.getCmp('snmpMgrEngineIdAdd').hide();
			Ext.getCmp('snmpMgrUserNameAdd').hide();
			Ext.getCmp('snmpMgrAuthPwdAdd').hide();
			Ext.getCmp('snmpMgrAuthConPwdAdd').hide();
			Ext.getCmp('snmpauthtypecomboadd').hide();
			Ext.getCmp('snmpMgrEncryptTypeComboAdd').hide();
			Ext.getCmp('snmpMgrEncryptPwdAdd').hide();
			Ext.getCmp('snmpMgrEncryptConPwdAdd').hide();

			Ext.getCmp('snmpMgrCommunityAdd').show();
			Ext.getCmp('snmpMgrCommunityAdd').reset();
			//Ext.getCmp('ttTrapsAdd').reset();
			Ext.getCmp('alarmCheckGrpAdd').reset();
		}
	},
	modifyUpdateData: function()
	{
		var selectTab = Ext.getCmp('snmp').getActiveTab().getItemId();
		var mode='';
		
		if (!Ext.isEmpty(selectTab) && selectTab == 'modifysnmp')
		{
			mode= 'modify';
		}

		if (!Ext.isEmpty(selectTab) && selectTab == 'modifysnmp')
		{
			var queryStr = this.genQueryString(publicJson['hiddenObj']);
			var isValidData = true;
			var snmpMgrIp = Ext.getCmp('modifySnmpMgrIpCombo').getValue();  
			var snmpMgrPort = Ext.getCmp('modifySnmpMgrPort').getValue();
			var snmpVersion = Ext.getCmp('modifySnmpVersionCombo').getValue();
			var snmpCommunity = '';
			var snmpEngineId = '';
			var snmpUserName = '';
			var snmpAuthPwd = '';
			var snmpAuthType = '';
			var snmpEncryptFlag = '';
			var snmpEncryptType = '';
			var snmpEncryptPwd = '';
			var high = '';
			var medium = '';
			var normal = '';
			var low = '';
			var tttraps = '';
			if(isValidData)
			{
				//isValidData = this.validateSnmpMgrPortField(snmpMgrPort);
				snmpPortValue = Ext.getCmp('modifySnmpMgrPort').getValue();
				if(!checkblank(snmpPortValue))
				{
					Ext.Msg.show ({
						title: pageName,
						msg: alert10,
						buttons: Ext.MessageBox.OK,
						icon: 'iconExclamation',
						fn: function(btn) {
							Ext.getCmp('modifySnmpMgrPort').focus(true);
						}
					});
					isValidData = false;
				}
				else if(snmpPortValue > 99999)
				{
					Ext.Msg.show ({
						title: pageName,
						msg: alert12,
						buttons: Ext.MessageBox.OK,
						icon: 'iconExclamation',
						fn: function(btn) {
							Ext.getCmp('modifySnmpMgrPort').focus(true);
						}
					});
					isValidData =  false;
				}
				else if((!checknumber("+",snmpPortValue)) || snmpPortValue == 0)
				{
					Ext.Msg.show ({
						title: pageName,
						msg: alert13,
						buttons: Ext.MessageBox.OK,
						icon: 'iconExclamation',
						fn: function(btn) {
							Ext.getCmp('modifySnmpMgrPort').focus(true);
						}
					});
					isValidData = false;
				}
				else if(!checkfordecimal(snmpPortValue))
				{
					Ext.Msg.show ({
						title: pageName,
						msg: alert19,
						buttons: Ext.MessageBox.OK,
						icon: 'iconExclamation',
						fn: function(btn) {
							Ext.getCmp('modifySnmpMgrPort').focus(true);
						}
					});
					isValidData = false;
				}
			}

			var qStr = "&snmpMgrIP="+snmpMgrIp+"&snmpmanagerport="+snmpMgrPort+"&snmpversion="+snmpVersion;
			if(snmpVersion != null && snmpVersion != 'undefined' && snmpVersion == 'v3')
			{
				snmpEngineId = Ext.getCmp('modifyEngineId').getValue();  //request.getParameter("engineid");
				snmpUserName = Ext.getCmp('modifyUserName').getValue(); //strUserName=request.getParameter("username");
				snmpAuthPwd = Ext.getCmp('modifyAuthPwd').getValue(); //strAuthPwd=request.getParameter("authendicationpassword");
				snmpAuthType = Ext.getCmp('modifyAuthTypeCombo').getValue(); //strAuthType=request.getParameter("authendicationtype");
				snmpEncryptFlag = Ext.getCmp('modifyEncryptFlagYes').getValue(); //request.getParameter("encryptflag");
				if(isValidData)
				{
					//isValidData = this.validateSnmpMgrEngineIdField(snmpEngineId);
					if(snmpEngineId !=null && !checkblank(snmpEngineId))
					{
						Ext.Msg.show ({
							title: pageName,
							msg: alert10,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
							fn: function(btn) {
								Ext.getCmp('modifyEngineId').focus(true);
							}
						});
						isValidData = false;
					}
					else if(snmpEngineId !=null && !checkspecialnomess(snmpEngineId,"`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/"))
					{
						Ext.Msg.show ({
							title: pageName,
							msg: alert17,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
							fn: function(btn) {
								Ext.getCmp('modifyEngineId').focus(true);
							}
						});
						isValidData = false;
					}
				}
				if(isValidData)
				{
					//isValidData = this.validateSnmpMgrUserNameField(snmpUserName);
					if(snmpUserName !=null && !checkblank(snmpUserName))
					{
						Ext.Msg.show ({
							title: pageName,
							msg: alert10,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
							fn: function(btn) {
								Ext.getCmp('modifyUserName').focus(true);
							}
						});
						isValidData = false;
					}
					else if(snmpUserName !=null && !checkspecialnomess(snmpUserName,"@*+=|:;\"\'<>\/[]?,"))
					{
						Ext.Msg.show ({
							title: pageName,
							msg: alert17,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
							fn: function(btn) {
								Ext.getCmp('modifyUserName').focus(true);
							}
						});
						isValidData = false;
					}
					else if(snmpUserName !=null && trim(snmpUserName) == "")
					{
						Ext.Msg.show ({
							title: pageName,
							msg: alert10,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
							fn: function(btn) {
								Ext.getCmp('modifyUserName').focus(true);
							}
						});
						isValidData = false;
					}
					else if(snmpUserName !=null && snmpUserName.indexOf("..") > -1)
					{
						Ext.Msg.show ({
							title: pageName,
							msg: alert20,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
							fn: function(btn) {
								Ext.getCmp('modifyUserName').focus(true);
							}
						});
						isValidData = false;
					}
					else if(snmpUserName !=null && snmpUserName.indexOf("  ") > -1)
					{
						Ext.Msg.show ({
							title: pageName,
							msg: alert21,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
							fn: function(btn) {
								Ext.getCmp('modifyUserName').focus(true);
							}
						});
						isValidData = false;
					}
				}
				if(isValidData)
				{
					//isValidData = this.validateSnmpMgrAuthPwdField(snmpAuthPwd,Ext.getCmp('modifyVerThreeAuthConPwd').getValue());
					var val1 = snmpAuthPwd;
					var val2 = Ext.getCmp('modifyAuthConPwd').getValue();
					if(val1 !=null && !checkblank(val1))
					{
						Ext.Msg.show ({
							title: pageName,
							msg: alert10,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
							fn: function(btn) {
								Ext.getCmp('modifyAuthPwd').focus(true);
							}
						});
						isValidData = false;
					}
					else if(val2 !=null && !checkblank(val2))
					{
						Ext.Msg.show ({
							title: pageName,
							msg: alert10,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
							fn: function(btn) {
								Ext.getCmp('modifyAuthConPwd').focus(true);
							}
						});
						isValidData = false;
					}
					else if(val1 !=null && val2 !=null && val1 != val2 )
					{
						Ext.Msg.show ({
							title: pageName,
							msg: alert16,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
							fn: function(btn) {
								Ext.getCmp('modifyAuthConPwd').reset();
								Ext.getCmp('modifyAuthConPwd').focus(true);
							}
						});
						isValidData = false;
					}
				}
				qStr +="&engineid="+snmpEngineId+"&username="+snmpUserName+"&authendicationpassword="+snmpAuthPwd+"&authendicationtype="+snmpAuthType;
				if(snmpEncryptFlag == true)
				{

					encryptflag = 'true';
					snmpEncryptType = Ext.getCmp('modifyEncryptTypeCombo').getValue(); //request.getParameter("encrypttype");
					snmpEncryptPwd = Ext.getCmp('modifyEncryptTypePwd').getValue(); //request.getParameter("encryptpassword");
					if(isValidData)
					{
						//isValidData = this.validateSnmpMgrEncryptPwdField(snmpEncryptPwd,Ext.getCmp('modifyEncryptTypeConPwd').getValue());
						var val1 = snmpEncryptPwd;
						var val2 = Ext.getCmp('modifyEncryptTypeConPwd').getValue();
						if(val1!=null && !checkblank(val1))
						{
							Ext.Msg.show ({
								title: pageName,
								msg: alert10,
								buttons: Ext.MessageBox.OK,
								icon: 'iconExclamation',
								fn: function(btn) {
									Ext.getCmp('modifyEncryptTypePwd').focus(true);
								}
							});
							isValidData = false;
						}
						else if(val2 !=null && !checkblank(val2))
						{
							Ext.Msg.show ({
								title: pageName,
								msg: alert10,
								buttons: Ext.MessageBox.OK,
								icon: 'iconExclamation',
								fn: function(btn) {
									Ext.getCmp('modifyEncryptTypeConPwd').focus(true);
								}
							});
							isValidData = false;
						}
						else if(val1 !=null && val2 !=null && val1 != val2 )
						{
							Ext.Msg.show ({
								title: pageName,
								msg: alert16,
								buttons: Ext.MessageBox.OK,
								icon: 'iconExclamation',
								fn: function(btn) {
									Ext.getCmp('modifyEncryptTypeConPwd').reset();
									Ext.getCmp('modifyEncryptTypeConPwd').focus(true);
								}
							});
							isValidData = false;
						}
					}
					qStr += "&encryptflag="+snmpEncryptFlag+"&encrypttype="+snmpEncryptType+"&encryptpassword="+snmpEncryptPwd;
					high = Ext.getCmp('modifyCritical').getValue(); // request.getParameter("high");
					medium = Ext.getCmp('modifyMajor').getValue(); //request.getParameter("medium");
					low = Ext.getCmp('modifyMinor').getValue(); //request.getParameter("low");
					normal = Ext.getCmp('modifyNormal').getValue(); //request.getParameter("normal");
					//tttraps =  Ext.getCmp('modifyTTTrapYes').getValue();
				}
				else
				{
					encryptflag = 'false';
					qStr += "&encryptflag="+snmpEncryptFlag;
					high = Ext.getCmp('modifyCritical').getValue(); // request.getParameter("high");
					medium = Ext.getCmp('modifyMajor').getValue(); //request.getParameter("medium");
					low = Ext.getCmp('modifyMinor').getValue(); //request.getParameter("low");
					normal = Ext.getCmp('modifyNormal').getValue(); //request.getParameter("normal");
					//tttraps =  Ext.getCmp('modifyTTTrapYes').getValue();
				}
			}
			else
			{
				snmpCommunity = Ext.getCmp('modifySnmpMgrCommunity').getValue(); 
				if(isValidData)
				{
					//isValidData = this.validateSnmpMgrCommunityField(snmpCommunity,'modify');
					if(snmpCommunity != null && !checkblank(snmpCommunity))
					{
						Ext.Msg.show ({
							title: pageName,
							msg: alert10,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
							fn: function(btn) {
								Ext.getCmp('snmpMgrCommunityAdd').focus(true);
							}
						});
						isValidData = false;
					}
					else if (snmpCommunity != null && 
							(!checkspecialnomess(snmpCommunity,"\"") || 
							!checkspecialnomess(snmpCommunity,"|") || 
							!checkspecialnomess(snmpCommunity,"<") || 
							!checkspecialnomess(snmpCommunity,">")))
					{
						Ext.Msg.show ({
							title: pageName,
							msg: _snmpcomma,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
							fn: function(btn) {
								Ext.getCmp('snmpMgrCommunityAdd').focus(true);
							}
						});
						isValidData = false;
					}
					else if (snmpCommunity != null && (snmpCommunity.indexOf("-")== 0 || 
							snmpCommunity.charAt(snmpCommunity.length-1) == '-'))
					{
						Ext.Msg.show ({
							title: pageName,
							msg: alert14,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
							fn: function(btn) {
								Ext.getCmp('snmpMgrCommunityAdd').focus(true);
							}
						});
						isValidData = false;
					}
					else if(snmpCommunity != null && !validateSingleByte(snmpCommunity))
					{
						Ext.Msg.show ({
							title: pageName,
							msg: alert15,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
							fn: function(btn) {
								Ext.getCmp('snmpMgrCommunityAdd').focus(true);
							}
						});
						isValidData = false;
					}
				}

				qStr += "&snmpcommunity="+snmpCommunity;
				//high = Ext.getCmp('modifyCritical').getValue(); // request.getParameter("high");
				//medium = Ext.getCmp('modifyMajor').getValue(); //request.getParameter("medium");
				//low = Ext.getCmp('modifyMinor').getValue(); //request.getParameter("low");
				//normal = Ext.getCmp('modifyNormal').getValue(); //request.getParameter("normal");
				//tttraps =  Ext.getCmp('modifyTTTrapYes').getValue();

			}
			/*var alramSelected = false;
			if(high != null && high == true)
			{
				qStr +="&high=HIGH";
				alramSelected = true;
			}
			
			if(medium != null && medium == true)
			{
				alramSelected = true;
				qStr +="&medium=MEDIUM";
			}
			
			if(low != null && low == true)
			{
				alramSelected = true;
				qStr +="&low=LOW";
			}
			if (normal != null && normal == true)
			{
				alramSelected = true;
				qStr +="&normal=NORMAL";
			}*/

			//var sendTTraps = '';
			//if(tttraps == true)
			//{
				//sendTTraps = 'Yes';
			//}
			//else
			//{
				//sendTTraps = 'No';
			//}

			//qStr += "&$_ttflag="+sendTTraps;
			var alramSelected = true;
			if(isValidData)
			{
				if(!alramSelected)
				{
					Ext.Msg.show ({
						title: pageName,
						msg: alert6,
						width: alert6.length * 7,
						buttons: Ext.MessageBox.OK,
						icon: 'iconExclamation',
					});
					return;
				}
			}
			if(isValidData)// && tttraps)
			{
				qStr += queryStr;
				//Ext.MessageBox.alert(pageName,alert7,function(btn) {
					Ext.Ajax.request({
						url:'TrapReceiversAndSettings/data/Egsnmpconfigp.jsp?from='+mode+qStr,
						method:'post',
						async : false,
						scope:this,
						success:function(response)
						{
							Ext.Msg.show ({
								title: pageName,
								msg: alert8,
								buttons: Ext.MessageBox.OK,
								icon: 'iconInformation',
								fn: function(btn) {
									me.tabChangeAfterModifyMgr('modifysnmp',snmpMgrIp);
								}
							});
						}
					});
				//});
			}
			else
			{
				qStr += queryStr;
				if(isValidData == true)
				{
					this.call(mode,qStr);
				}
			}
		}
	},
	genQueryString: function( Arr )
	{
		var qStr = '';
		for ( var key in Arr )
		{
			qStr += '&'+key+'='+encodeURIComponent(Arr[key]);
		}
		return qStr;
	},
	updateData: function(btn)
	{
		var selectTab = Ext.getCmp('snmp').getActiveTab().getItemId();
		var mode='';
		if ( selectTab == 'addsnmp')
		{
			mode='add';
		}
		else if ( selectTab == 'modifysnmp')
		{
			mode= 'modify';
		}
		else if ( selectTab == 'settingssnmp')
		{
			mode = 'settings';
		}

		if( mode == 'add')
		{
			var isValidData = true;
			var snmpMgrIp = Ext.getCmp('snmpMgrIpAdd').getValue();  
			var snmpMgrPort = Ext.getCmp('snmpMgrPortAdd').getValue();
			var snmpVersion = Ext.getCmp('snmpversioncomboadd').getValue();
			var snmpCommunity = '';
			var snmpEngineId = '';
			var snmpUserName = '';
			var snmpAuthPwd = '';
			var snmpAuthType = '';
			var snmpEncryptFlag = '';
			var snmpEncryptType = '';
			var snmpEncryptPwd = '';
			var high = '';
			var medium = '';
			var normal = '';
			var low = '';
			var tttraps = '';
			//isValidData = this.validateSnmpMgrIpField(Ext.getCmp('snmpMgrIpAdd').getValue());
			var snmpIPValue = Ext.getCmp('snmpMgrIpAdd').getValue();
			if(Ext.isEmpty(snmpIPValue))
			{
				Ext.Msg.show ({
					title: pageName,
					msg: alert10,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation',
					fn: function(btn) {
						Ext.getCmp('snmpMgrIpAdd').focus(true);
					}
				});
				isValidData = false;
			}
			else if(checkHostname())
			{
				Ext.Msg.show ({
					title: pageName,
					msg: alert11,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation',
					fn: function(btn) {
						Ext.getCmp('snmpMgrIpAdd').focus(true);
					}
				});
				isValidData = false;
			}
			else if (!checkspace(snmpIPValue))
			{
				Ext.Msg.show ({
					title: pageName,
					msg: alert18,
					buttons: Ext.MessageBox.OK,
					icon: 'iconExclamation',
					fn: function(btn) {
						Ext.getCmp('snmpMgrIpAdd').focus(true);
					}
				});
				isValidData = false;
			}

			if(isValidData)
			{
				//isValidData = this.validateSnmpMgrPortField(Ext.getCmp('snmpMgrPortAdd').getValue());
				snmpPortValue = Ext.getCmp('snmpMgrPortAdd').getValue();
				if(!checkblank(snmpPortValue))
				{
					Ext.Msg.show ({
						title: pageName,
						msg: alert10,
						buttons: Ext.MessageBox.OK,
						icon: 'iconExclamation',
						fn: function(btn) {
							Ext.getCmp('snmpMgrPortAdd').focus(true);
						}
					});
					isValidData = false;
				}
				else if(snmpPortValue > 99999)
				{
					Ext.Msg.show ({
						title: pageName,
						msg: alert12,
						buttons: Ext.MessageBox.OK,
						icon: 'iconExclamation',
						fn: function(btn) {
							Ext.getCmp('snmpMgrPortAdd').focus(true);
						}
					});
					isValidData =  false;
				}
				else if((!checknumber("+",snmpPortValue)) || snmpPortValue == 0)
				{
					Ext.Msg.show ({
						title: pageName,
						msg: alert13,
						buttons: Ext.MessageBox.OK,
						icon: 'iconExclamation',
						fn: function(btn) {
							Ext.getCmp('snmpMgrPortAdd').focus(true);
						}
					});
					isValidData = false;
				}
				else if(!checkfordecimal(snmpPortValue))
				{
					Ext.Msg.show ({
						title: pageName,
						msg: alert19,
						buttons: Ext.MessageBox.OK,
						icon: 'iconExclamation',
						fn: function(btn) {
							Ext.getCmp('snmpMgrPortAdd').focus(true);
						}
					});
					isValidData = false;
				}
			}

			var qStr = "&snmpMgrIP="+snmpMgrIp+"&snmpmanagerport="+snmpMgrPort+"&snmpversion="+snmpVersion;
			if(snmpVersion != null && snmpVersion != 'undefined' && snmpVersion == 'v3')
			{
				snmpEngineId = Ext.getCmp('snmpMgrEngineIdAdd').getValue();  //request.getParameter("engineid");
				snmpUserName = Ext.getCmp('snmpMgrUserNameAdd').getValue(); //strUserName=request.getParameter("username");
				snmpAuthPwd = Ext.getCmp('snmpMgrAuthPwdAdd').getValue(); //strAuthPwd=request.getParameter("authendicationpassword");
				snmpAuthType = Ext.getCmp('snmpauthtypecomboadd').getValue(); //strAuthType=request.getParameter("authendicationtype");
				snmpEncryptFlag = Ext.getCmp('encryptradioYesAdd').getValue(); //request.getParameter("encryptflag");
				if(isValidData)
				{
					//isValidData = this.validateSnmpMgrEngineIdField(snmpEngineId);

					if(snmpEngineId !=null && !checkblank(snmpEngineId))
					{
						Ext.Msg.show ({
							title: pageName,
							msg: alert10,
							width: alert10.length * 7,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
							fn: function(btn) {
								Ext.getCmp('snmpMgrEngineIdAdd').focus(true);
							}
						});
						isValidData = false;
					}
					else if(snmpEngineId !=null && !checkspecialnomess(snmpEngineId,"`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/"))
					{
						Ext.Msg.show ({
							title: pageName,
							msg: alert17,
							width: alert17.length * 7,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
							fn: function(btn) {
								Ext.getCmp('snmpMgrEngineIdAdd').focus(true);
							}
						});
						isValidData = false;
					}
				}

				if(isValidData)
				{
					//isValidData = this.validateSnmpMgrUserNameField(snmpUserName);
					if(snmpUserName !=null && !checkblank(snmpUserName))
					{
						Ext.Msg.show ({
							title: pageName,
							msg: alert10,
							width: alert10.length * 7,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
							fn: function(btn) {
								Ext.getCmp('snmpMgrUserNameAdd').focus(true);
							}
						});
						isValidData = false;
					}
					else if(snmpUserName !=null && !checkspecialnomess(snmpUserName,"@*+=|:;\"\'<>\/[]?,"))
					{
						Ext.Msg.show ({
							title: pageName,
							msg: alert17,
							width: alert17.length * 7,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
							fn: function(btn) {
								Ext.getCmp('snmpMgrUserNameAdd').focus(true);
							}
						});
						isValidData = false;
					}
					else if(snmpUserName !=null && trim(snmpUserName) == "")
					{
						Ext.Msg.show ({
							title: pageName,
							msg: alert10,
							width: alert10.length * 7,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
							fn: function(btn) {
								Ext.getCmp('snmpMgrUserNameAdd').focus(true);
							}
						});
						isValidData = false;
					}
					else if(snmpUserName !=null && snmpUserName.indexOf("..") > -1)
					{
						Ext.Msg.show ({
							title: pageName,
							msg: alert20,
							width: alert20.length * 7,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
							fn: function(btn) {
								Ext.getCmp('snmpMgrUserNameAdd').focus(true);
							}
						});
						isValidData = false;
					}
					else if(snmpUserName !=null && snmpUserName.indexOf("  ") > -1)
					{
						Ext.Msg.show ({
							title: pageName,
							msg: alert21,
							width: alert21.length * 7,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
							fn: function(btn) {
								Ext.getCmp('snmpMgrUserNameAdd').focus(true);
							}
						});
						isValidData = false;
					}
				}
				if(isValidData)
				{
					//isValidData = this.validateSnmpMgrAuthPwdField(snmpAuthPwd,Ext.getCmp('snmpMgrAuthConPwdAdd').getValue());
					var val1 = snmpAuthPwd;
					var val2 = Ext.getCmp('snmpMgrAuthConPwdAdd').getValue();
					if(val1 !=null && !checkblank(val1))
					{
						Ext.Msg.show ({
							title: pageName,
							msg: alert10,
							width: alert10.length * 7,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
							fn: function(btn) {
								Ext.getCmp('snmpMgrAuthPwdAdd').focus(true);
							}
						});
						isValidData = false;
					}
					else if(val2 !=null && !checkblank(val2))
					{
						Ext.Msg.show ({
							title: pageName,
							msg: alert10,
							width: alert10.length * 7,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
							fn: function(btn) {
								Ext.getCmp('snmpMgrAuthConPwdAdd').focus(true);
							}
						});
						isValidData = false;
					}
					else if(val1 !=null && val2 !=null && val1 != val2 )
					{
						Ext.Msg.show ({
							title: pageName,
							msg: alert16,
							width: alert16.length * 7,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
							fn: function(btn) {
								Ext.getCmp('snmpMgrAuthConPwdAdd').reset();
								Ext.getCmp('snmpMgrAuthConPwdAdd').focus(true);
							}
						});
						isValidData = false;
					}
				}
				qStr +="&engineid="+snmpEngineId+"&username="+snmpUserName+"&authendicationpassword="+snmpAuthPwd+"&authendicationtype="+snmpAuthType;
				if(snmpEncryptFlag == true)
				{

					encryptflag = 'true';
					snmpEncryptType = Ext.getCmp('snmpMgrEncryptTypeComboAdd').getValue(); //request.getParameter("encrypttype");
					snmpEncryptPwd = Ext.getCmp('snmpMgrEncryptPwdAdd').getValue(); //request.getParameter("encryptpassword");
					if(isValidData)
					{
						//isValidData = this.validateSnmpMgrEncryptPwdField(snmpEncryptPwd,Ext.getCmp('snmpMgrEncryptConPwdAdd').getValue());
						var val1 = snmpEncryptPwd;
						var val2 = Ext.getCmp('snmpMgrEncryptConPwdAdd').getValue();
						if(val1!=null && !checkblank(val1))
						{
							Ext.Msg.show ({
								title: pageName,
								msg: alert10,
								width: alert10.length * 7,
								buttons: Ext.MessageBox.OK,
								icon: 'iconExclamation',
								fn: function(btn) {
									Ext.getCmp('snmpMgrEncryptPwdAdd').focus(true);
								}
							});
							isValidData = false;
						}
						else if(val2 !=null && !checkblank(val2))
						{
							Ext.Msg.show ({
								title: pageName,
								msg: alert10,
								width: alert10.length * 7,
								buttons: Ext.MessageBox.OK,
								icon: 'iconExclamation',
								fn: function(btn) {
									Ext.getCmp('snmpMgrEncryptConPwdAdd').focus(true);
								}
							});
							isValidData = false;
						}
						else if(val1 !=null && val2 !=null && val1 != val2 )
						{
							Ext.Msg.show ({
								title: pageName,
								msg: alert16,
								width: alert16.length * 7,
								buttons: Ext.MessageBox.OK,
								icon: 'iconExclamation',
								fn: function(btn) {
									Ext.getCmp('snmpMgrEncryptConPwdAdd').reset();
									Ext.getCmp('snmpMgrEncryptConPwdAdd').focus(true);
								}
							});
							isValidData = false;
						}
					}
					qStr += "&encryptflag="+snmpEncryptFlag+"&encrypttype="+snmpEncryptType+"&encryptpassword="+snmpEncryptPwd;
				}
				else
				{
					encryptflag = 'false';
					qStr += "&encryptflag="+snmpEncryptFlag;
				}
			}
			else
			{
				snmpCommunity = Ext.getCmp('snmpMgrCommunityAdd').getValue(); 
				if(isValidData)
				{
					//isValidData = this.validateSnmpMgrCommunityField(Ext.getCmp('snmpMgrCommunityAdd').getValue(),'add');

					if(snmpCommunity != null && !checkblank(snmpCommunity))
					{
						Ext.Msg.show ({
							title: pageName,
							msg: alert10,
							width: alert10.length * 7,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
							fn: function(btn) {
								Ext.getCmp('snmpMgrCommunityAdd').focus(true);
							}
						});
						isValidData = false;
					}
					else if (snmpCommunity != null && 
							(!checkspecialnomess(snmpCommunity,"\"") || 
							!checkspecialnomess(snmpCommunity,"|") || 
							!checkspecialnomess(snmpCommunity,"<") || 
							!checkspecialnomess(snmpCommunity,">")))
					{
						Ext.Msg.show ({
							title: pageName,
							msg: _snmpcomma,
							width: _snmpcomma.length * 7,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
							fn: function(btn) {
								Ext.getCmp('snmpMgrCommunityAdd').focus(true);
							}
						});
						isValidData = false;
					}
					else if (snmpCommunity != null && (snmpCommunity.indexOf("-")== 0 || 
							snmpCommunity.charAt(snmpCommunity.length-1) == '-'))
					{
						Ext.Msg.show ({
							title: pageName,
							msg: alert14,
							width: alert14.length * 7,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
							fn: function(btn) {
								Ext.getCmp('snmpMgrCommunityAdd').focus(true);
							}
						});
						isValidData = false;
					}
					else if(snmpCommunity != null && !validateSingleByte(snmpCommunity))
					{
						Ext.Msg.show ({
							title: pageName,
							msg: alert15,
							width: alert15.length * 7,
							buttons: Ext.MessageBox.OK,
							icon: 'iconExclamation',
							fn: function(btn) {
								Ext.getCmp('snmpMgrCommunityAdd').focus(true);
							}
						});
						isValidData = false;
					}
				}

				qStr += "&snmpcommunity="+snmpCommunity;
			}
			
			/*high = Ext.getCmp('criticalAdd').getValue(); 
			medium = Ext.getCmp('majorAdd').getValue();
			low = Ext.getCmp('minorAdd').getValue(); 
			normal = Ext.getCmp('normalAdd').getValue(); 
			//tttraps = Ext.getCmp('trapYesAdd').getValue();

			var alramSelected = false;
			if(high != null && high == true)
			{
				qStr +="&high=HIGH";
				alramSelected = true;
			}
			
			if(medium != null && medium == true)
			{
				alramSelected = true;
				qStr +="&medium=MEDIUM";
			}
			
			if(low != null && low == true)
			{
				alramSelected = true;
				qStr +="&low=LOW";
			}
			if (normal != null && normal == true)
			{
				alramSelected = true;
				qStr +="&normal=NORMAL";
			}*/

			//var sendTTraps = '';
			//if(tttraps == true)
			//{
				//sendTTraps = 'Yes';
			//}
			//else
			//{
				//sendTTraps = 'No';
			//}
			
			var alramSelected = true;
			//qStr += "&$_ttflag="+sendTTraps;
			if(isValidData)
			{
				if(!alramSelected)
				{
					Ext.Msg.show ({
						title: pageName,
						msg: alert6,
						width: alert6.length * 7,
						buttons: Ext.MessageBox.OK,
						icon: 'iconExclamation',
					});
					return;
				}
			}
			if(isValidData)// && tttraps)
			{
				//Ext.MessageBox.alert(pageName,alert7,function(btn)
				//{
					{
						Ext.Ajax.request({
						url:'TrapReceiversAndSettings/data/Egsnmpconfigp.jsp?from='+mode+qStr+'&selectTab=addsnmp',
						method:'post',
						async : false,
						scope:this,
						success:function(response)
						{
							Ext.Msg.show ({
								title: pageName,
								msg: alert9,
								width: alert9.length * 7,
								buttons: Ext.MessageBox.OK,
								icon: 'iconInformation',
								fn: function(btn) {
									me.buildFieldData('addsnmp');
									Ext.getCmp('snmpMgrIpAdd').reset(); 
									Ext.getCmp('snmpMgrPortAdd').reset(); 
									Ext.getCmp('snmpversioncomboadd').setValue('v1');
									Ext.getCmp('snmpMgrCommunityAdd').reset();
									//Ext.getCmp('ttTrapsAdd').reset();
									//Ext.getCmp('alarmCheckGrpAdd').reset();
								}
							});
						}});
					}
				//});
			}
			else
			{
				if(isValidData == true)
				{
					this.call(mode,qStr);
				}
			}
		}
	},
	call : function(mode,qStr)
	{
		Ext.Ajax.request({
			url:'TrapReceiversAndSettings/data/Egsnmpconfigp.jsp?from='+mode+qStr,
			method:'post',
			async : false,
			scope:this,
			success:function(response)
			{	
				if(mode == 'add')
				{
					Ext.Msg.show ({
						title: pageName,
						msg: alert9,
						width: alert9.length * 7,
						buttons: Ext.MessageBox.OK,
						icon: 'iconInformation',
						fn: function(btn) {
							me.refreshAddTab();
						}
					});
				}
				else
				{
					Ext.Msg.show ({
						title: pageName,
						msg: alert8,
						width: alert8.length * 7,
						buttons: Ext.MessageBox.OK,
						icon: 'iconInformation',
						fn: function(btn) {
							me.tabChange('modifysnmp');
						}
					});
				}
			}
		});
	},
	refreshAddTab: function()
	{
		Ext.getCmp('snmpMgrIpAdd').reset(); 
		Ext.getCmp('snmpMgrPortAdd').reset(); 
		Ext.getCmp('snmpversioncomboadd').reset();
		Ext.getCmp('snmpversioncomboadd').setValue('v1');
		Ext.getCmp('snmpMgrCommunityAdd').reset();
		//Ext.getCmp('ttTrapsAdd').reset();
		//Ext.getCmp('alarmCheckGrpAdd').reset();
	}
});

function checkHostname()
{
	var snmpMgrIP = Ext.getCmp('snmpMgrIpAdd').getValue();
	var comps_associated = publicJson['hiddenObj']['comps_associated'];
	var temp_comps_associated = comps_associated.split(",");
	var comps_associated_flag = false;
	for(i=0;i<temp_comps_associated.length;i++)
	{
		if(temp_comps_associated[i] == snmpMgrIP)
		{
			comps_associated_flag = true;
			break;
		}
	}

	if(comps_associated_flag)
	{
		return comps_associated_flag;
	}
}

function isAValidNumber(val)
{
	validFigures = '0123456789';
	if( (val == null ) || val.toString().indexOf("0")==0)
		return "false";
	if(val.length==0)
		return "false";
	for (i=0; i<val.length; i++)
	{
		if (validFigures.indexOf(val.charAt(i),0) == -1) 
		{
			return "false";
		}
	}
	return "true";
}

function checkspace(field)
{
	var s_val;
	if(typeof(field)=='object')
	{
		s_val = field.value;
	}
	else
	{
		s_val = field;
	}
	for(count = 0; count < s_val.length; count++)
	{
		if(s_val.charAt(count) == ' ')
		{
			return false;
		}
	}
	return true;
}

function checkfordecimal(field)
{
	var num = '';
	if(typeof(field)=='object')
	{
		num = field.value;
	}
	else
	{
		num = field;
	}
	if(num.indexOf(".") > -1)
	{
		return false;
	}
	return true;
}



