var isConfigSupported;
var selectedTestTypes;
Ext.define('UpgradeEnableDeleteTests.controller.Main',{
	extend:'Ext.app.Controller',
	views:['AddNewTest'],
	requires:['UpgradeEnableDeleteTests.view.AddNewTest'],
	refs:[{selector : 'addnewtest', ref : 'addnewtest'}],
	init:function(){
		ctrler = this;
		this.buildMainData()
		this.control({
			'addnewtest':
			{
				'afterrender': this.afterMainRender
			},
			'addnewtest combo[id="compTypes"]':
			{
				'change':this.compTypeSelection
			},
			'addnewtest combo[id="testTypes"]':
			{
				'change':this.testTypesSelection
			},
			'addnewtest button[id="EnableBtn"]':
			{
				'click':this.enableBtn
			},
			'addnewtest button[id="delBtn"]':
			{
				'click':this.deleteBtn
			}
		});
		},
	buildMainData: function()
	{
		Ext.Ajax.request(
		{
			url: 'UpgradeEnableDeleteTests/data/EgUpgradeEnableDeleteTestsJson.jsp',
			method: 'POST',
			async:false,
			success: function(response)
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	afterMainRender: function()
	{
		var egMgrIniRecords = publicJSON['componentTypeArr'];
		if(egMgrIniRecords.length == 1)
		{
			var mainContainerObj = Ext.getCmp('addnewtestval');
			var EmptyMsgWindow = Ext.create('Ext.container.Container',{
				id : 'emptyMsgContainer',
				layout: {
					type: 'vbox',
					pack: 'center',
					align: 'center'
				},
				items: [
					{
						xtype: 'label',
						html: '<table border="0" height="400" width="100%"><tr><td align=center valign=middle><div class="iconInformation"></div><div class="commonErrorMsgText">'+emptyMsg+'</div></td></tr></table>'
					}
				]
			});
			mainContainerObj.removeAll();
			mainContainerObj.add(EmptyMsgWindow);
		}
		else
		{
			var compTypesObj = Ext.getCmp('compTypes');
			compTypesObj.clearValue();
			compTypesObj.getStore().clearFilter(true);
			compTypesObj.getStore().loadRawData(publicJSON['componentTypeArr']);
			compTypesObj.setRawValue(publicJSON['initCompSelect']);

			isConfigSupported = publicJSON['isConfigSupported'];

			if (isConfigSupported)
			{
				var testTypeObj = Ext.getCmp('testTypes');
				testTypeObj.show();
				testTypeObj.clearValue();
				testTypeObj.getStore().clearFilter(true);
				testTypeObj.getStore().loadRawData(publicJSON['testTypeArr']);
				testTypeObj.setRawValue(publicJSON['initTestType']);
				selectedTestTypes = "PerformanceTest";
			}
			else
			{
				Ext.getCmp('testTypes').hide();
			}
			Ext.getCmp('newTest').hide();
			Ext.getCmp('newTestHidden').show();
			Ext.getCmp('delTest').hide();
			Ext.getCmp('deleteTestHidden').show();
		}
	},
	compTypeSelection:function()
	{
		var me = this;
		var selectedCType = Ext.getCmp('compTypes').getValue();
		var url = 'UpgradeEnableDeleteTests/data/EgUpgradeEnableDeleteTestsJson.jsp?&selectedCType='+selectedCType+'&selectedTestTypes='+selectedTestTypes;
		me.getData(url);
	},
	testTypesSelection: function()
	{
		var me = this;
		var selectedCType = Ext.getCmp('compTypes').getValue();
		selectedTestTypes = Ext.getCmp('testTypes').getValue();
		if (selectedTestTypes == null || Ext.isEmpty(selectedTestTypes))
		{
			selectedTestTypes = "PerformanceTest";
		}
		var url = 'UpgradeEnableDeleteTests/data/EgUpgradeEnableDeleteTestsJson.jsp?&selectedCType='+selectedCType+'&selectedTestTypes='+selectedTestTypes;
		me.getData(url);
	},
	getData: function(urlStr)
	{
		Ext.Ajax.request(
		{
			url : urlStr,
			method: 'POST',
			async: false,
			success: function(response)
			{
				var jsonText = response.responseText;
				jsonDataHolder = Ext.decode(jsonText);
			},
			failure : function(response)
			{
			}
		});
		var newTestobj = Ext.getCmp('newTest');
		var delTestobj = Ext.getCmp('delTest');
		var newTestStoreValues = jsonDataHolder['newTestArr'];
		var delTestStoreValues = jsonDataHolder['delTestArr'];
		var selectionModelNewTestObj = newTestobj.getSelectionModel();
		var selectionModelDelTestObj = delTestobj.getSelectionModel();

		if (newTestStoreValues == "")
		{
			newTestobj.hide();
			Ext.getCmp('newTestHidden').show();
		}
		else
		{
			newTestobj.show();
			Ext.getCmp('newTestHidden').hide();
			selectionModelNewTestObj.deselectAll(true);
			newTestobj.getStore().clearFilter(true);
			newTestobj.getStore().loadRawData(jsonDataHolder['newTestArr']);
		}

		if (delTestStoreValues == "")
		{
			delTestobj.hide();
			Ext.getCmp('deleteTestHidden').show();
		}
		else
		{
			delTestobj.show();
			Ext.getCmp('deleteTestHidden').hide();
			selectionModelDelTestObj.deselectAll(true);
			delTestobj.getStore().clearFilter(true);
			delTestobj.getStore().loadRawData(jsonDataHolder['delTestArr']);
		}
	},
	testDescription: function(grid, rowIndex, colIndex)
	{
		var me = this;
		var obj = grid.getStore().getAt(rowIndex);
		var testName = obj.get('valueField');
		var a = "UpgradeEnableDeleteTests/data/EgUpgradeHelpJson.jsp?&selectedTestTypes=" + testName ;
		Ext.Ajax.request({
				url: a,
				method: "POST",
				async: false,
				success: function(h) {
						var i = h.responseText;
						jsonDataHolder = Ext.decode(i);
				},
				failure: function(h) {}
		});
		var s_id = jsonDataHolder["s_id"];
		var s_test = jsonDataHolder["s_test"];
		var path =  "EgM"+ s_id + ".html"
		var testPath = "test="+s_test;
		if(s_id != null && s_id != "NOT_FOUND")
		{
			var e = Ext.create("Ext.window.Window", {
				title: 'Test and Measure Details',
				width:800,        	          
				height:450,
				layout: {
					pack: "center",
					autoScroll:true,
				},
				items: [{
					xtype: "label",
					html: '<iframe src="../../final/eghelp/'+path+'?'+testPath+'&from=layermodel"  width="100%" height="100%" scrolling="yes" ></iframe>'
				}]
			});
			e.show();
		}
		else if (s_id == "NOT_FOUND")
		{
			var d = Ext.create("Ext.window.Window", {
				title: 'Test and Measure Details',
				width:800,        	          
				height:450,
				layout: {
					pack: "center",
					autoScroll:true,
				},
				items: [{
					xtype: "label",
					html: '<iframe src="../../final/eghelp/EgMerr.html"  width="100%" height="100%" scrolling="yes" ></iframe>'
				}]
			});
			d.show();
		}
	},
	enableBtn:function()
	{
		var me = this;
		var valMsg = "";
		var resMsg = "";

		var selectedCType = Ext.getCmp('compTypes').getValue();
		selectedTestTypes = Ext.getCmp('testTypes').getValue();
		if (selectedTestTypes == null || Ext.isEmpty(selectedTestTypes))
		{
			selectedTestTypes = "PerformanceTest";
		}

		if (selectedTestTypes.toLowerCase() == "performance")
		{
			selectedTestTypes = "PerformanceTest";
		}
	
		var viewStoreObj = Ext.getCmp('newTest');
		var storeObj = viewStoreObj.getStore();
		var noOfRecords = storeObj.getCount();
		var selectionModelObj = viewStoreObj.getSelectionModel();

		if(noOfRecords > 0)
		{
			var testSelected = false;
			var testName = "";
			var exportData = "";
			var selectedTest = selectionModelObj.getSelection();

			if(selectedTest.length > 0)
			{
				testSelected = true;
			}
			else
			{
				Ext.MessageBox.show(
				{
					title : pageTitle,
					msg :validationMsg05,
					icon : 'iconInformation',
					buttons : Ext.Msg.OK,
					width : 300
				});
			}
			if(testSelected)
			{
				for(var i = 0;i< selectedTest.length; i++)
				{
					var exportTest = selectedTest[i];
					testName = exportTest.get('valueField');
					if (i == (selectedTest.length - 1))
					{
						exportData += testName;
					}
					else
					{
						exportData += testName + ",";
					}
				}
				if (selectedTest.length == 1)
				{
					valMsg = validationMsg01;
				}
				else
				{
					valMsg = validationMsg02;
				}
				if (exportData != "")
				{
					Ext.MessageBox.show({
						title : pageTitle,
						msg : valMsg,
						buttons: Ext.Msg.YESNO,
						icon : 'iconInformation',
						width : 300,
						fn : function(btn)
						{ 
							if (btn == 'yes')
							{
								var urlStr = 'UpgradeEnableDeleteTests/data/EgupgradeenabledeletetestspJson.jsp?&selectedCType='+selectedCType+'&selectedTestTypes='+selectedTestTypes+'&newTestTypes='+exportData;
								Ext.Ajax.request({
									url : urlStr,
									method: 'POST',
									async: false,
									success: function( response )
									{
										var jsonText = response.responseText;
										publicJSON = Ext.decode(jsonText);
										if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
										{
											var resultStatus = publicJSON['requestStatus'];
											if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
											{
												var resultStatus = publicJSON['result'];
												if (selectedTest.length == 1)
												{
													resMsg = resultStatus['message1'];
												}
												else
												{
													resMsg = resultStatus['message2'];
												}
												Ext.MessageBox.show(
												{
													title : pageTitle,
													msg : resMsg,
													icon : 'iconInformation',
													buttons : Ext.Msg.OK,
													width : 300,
													fn : function(btn)
													{
														Ext.Ajax.request({
															url: 	'UpgradeEnableDeleteTests/data/EgUpgradeEnableDeleteTestsJson.jsp?&selectedCType='+selectedCType+'&selectedTestTypes='+selectedTestTypes,
															method: 'POST',
															success: function( response )
															{
																if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
																{
																	var jsonText = response.responseText;
																	publicJSON = Ext.decode( jsonText );
																}
																selectionModelObj.deselectAll(true);
																viewStoreObj.getStore().clearFilter(true);
																viewStoreObj.getStore().loadRawData(publicJSON['newTestArr']);

																var storeValNew = publicJSON['newTestArr'];
																var storeValDel = publicJSON['delTestArr'];
																
																if (storeValNew == "" && storeValDel == "")
																{
																	me.afterMainRender();
																}
																else if (storeValNew == "")
																{
																	viewStoreObj.hide();
																	Ext.getCmp('newTestHidden').show();
																}
																else
																{
																	viewStoreObj.show();
																	Ext.getCmp('newTestHidden').hide();
																}
															}
														});
													}
												});
											}
										}
									}
								});
							}
						}
					});
				}
			}
		}
	},
	deleteBtn : function()
	{
		var me = this;
		var valMsg = "";
		var resMsg = "";
		var viewStoreObj2 = Ext.getCmp('delTest');
		var selectedCType = Ext.getCmp('compTypes').getValue();
		selectedTestTypes = Ext.getCmp('testTypes').getValue();
		if (selectedTestTypes == null || Ext.isEmpty(selectedTestTypes))
		{
			selectedTestTypes = "PerformanceTest";
		}
		if (selectedTestTypes.toLowerCase() == "performance")
		{
			selectedTestTypes = "PerformanceTest";
		}

		var storeObj2 = viewStoreObj2.getStore();
		var noOfRecords2 = storeObj2.getCount();
		var selectionModelObj2 = viewStoreObj2.getSelectionModel();

		if(noOfRecords2 > 0)
		{
			var testSelected = false;
			var testName = "";
			var exportData = "";
			var selectedTest = selectionModelObj2.getSelection();

			if(selectedTest.length > 0)
			{
				testSelected = true;
			}
			else
			{
				Ext.MessageBox.show(
				{
					title : pageTitle,
					msg :validationMsg06,
					icon : 'iconInformation',
					buttons : Ext.Msg.OK,
					width : 300
				});
			}
			if(testSelected)
			{
				for(var i = 0;i< selectedTest.length; i++)
				{
					var exportTest = selectedTest[i];
					testName = exportTest.get('valueField');
					if (i == (selectedTest.length - 1))
					{
						exportData += testName;
					}
					else
					{
						exportData += testName + ",";
					}
				}
				if (selectedTest.length == 1)
				{
					valMsg = validationMsg03;
				}
				else
				{
					valMsg = validationMsg04;
				}
				if (exportData != "")
				{
					Ext.MessageBox.show({
						title : pageTitle,
						msg : valMsg,
						buttons: Ext.Msg.YESNO,
						icon : 'iconInformation',
						width : 300,
						fn : function(btn)
						{ 
							if (btn == 'yes')
							{
								var url = 'UpgradeEnableDeleteTests/data/EgupgradeenabledeletetestspJson.jsp?&selectedCType='+selectedCType+'&selectedTestTypes='+selectedTestTypes+'&delTestTypes='+exportData;
								Ext.Ajax.request(
								{
									url : url,
									method: 'POST',
									async: false,
									success: function( response )
									{
										var jsonText = response.responseText;
										publicJSON = Ext.decode(jsonText);
										if ( !Ext.isEmpty( jsonText ) && response.status == 200 )
										{
											var resultStatus = publicJSON['requestStatus'];
											if (resultStatus == "success" || resultStatus.indexOf("success") != -1)
											{
												var resultStatus = publicJSON['result'];
												if (selectedTest.length == 1)
												{
													resMsg = resultStatus['message3'];
												}
												else
												{
													resMsg = resultStatus['message4'];
												}
												Ext.MessageBox.show(
												{
													title : pageTitle,
													msg : resMsg,
													buttons: Ext.Msg.OK,
													icon : 'iconInformation',
													width : 300,
													fn : function(btn)
													{ 
														Ext.Ajax.request({
															url: 	'UpgradeEnableDeleteTests/data/EgUpgradeEnableDeleteTestsJson.jsp?&selectedCType='+selectedCType+'&selectedTestTypes='+selectedTestTypes,
															method: 'POST',
															success: function( response )
															{
																if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
																{
																	var jsonText = response.responseText;
																	publicJSON = Ext.decode( jsonText );
																}
																selectionModelObj2.deselectAll(true);
																viewStoreObj2.getStore().clearFilter(true);
																viewStoreObj2.getStore().loadRawData(publicJSON['delTestArr']);

																var storeValDel = publicJSON['delTestArr'];
																var storeValnew = publicJSON['newTestArr'];
																
																	
																if (storeValDel == "" && storeValnew == "")
																{
																	me.afterMainRender();
																}
																else if (storeValDel == "")
																{
																	viewStoreObj2.hide();
																	Ext.getCmp('deleteTestHidden').show();
																}
																else
																{
																	viewStoreObj2.show();
																	Ext.getCmp('deleteTestHidden').hide();
																}
															}
														});
													}
												});
											}
										}
									}
								});
							}
						}
					});
				}
			}
		}
	}
});
