var totalMonitorsCount, basicMonitorsCount, networkMonitorsCount, userBasedCount, usersTotCount, isUserBasedLic;
Ext.define('UserLicense.controller.Main', {
	extend : 'Ext.app.Controller',
	views : ['UserLicense'],
	requires : ['Ext.ux.TreePicker'],
	refs : [
		{
			selector : 'userlicense', 
			ref : 'userlicense'
		},
	],
	init :function() 
	{
		ctrler = this;
		this.buildFieldData();
		this.control({
			'userlicense': {
				'afterrender': this.afterMainRender
			},
			'userlicense trigger[id="searchBoxMSP"]': {
				"change": this.searchOrgsAndUsers
			},
			'userlicense button[id="setAllToDefaultBtnMSP"]': {
				'click': this.setAllUsersToDefaultSettings
			}
		});
	},
	buildFieldData: function()
	{
		Ext.Ajax.request({
			url : 'UserLicense/data/UserLicenseJSON.jsp',
			method : 'POST',
			async : false,
			success : function( response ){
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) {
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	getData : function(url, params)
	{
		Ext.Ajax.request(
		{
			url : url,
			method : "POST",
			async : false,
			params : {
				'searchStr' : params
			},
			success : function (response)
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) {
					var jsonText = response.responseText;
					jsonDataHolder = Ext.decode(jsonText);
				}
			},
			failure: function (b)
			{}
		});
	},
	afterMainRender : function()
	{
		var me = this;
		totalMonitorsCount = publicJSON.totalMonitorsCount;
		basicMonitorsCount = publicJSON.basicMonitorsCount;
		networkMonitorsCount = publicJSON.networkMonitorsCount;
		userBasedCount = publicJSON.userBasedCount;
		usersTotCount = publicJSON.usersTotCount;
		isUserBasedLic = ((publicJSON.isMgrUsedBased != undefined || publicJSON.isMgrUsedBased != "") && publicJSON.isMgrUsedBased == "true");
		me.loadUserTreeView();
	},
	loadUserTreeView : function()
	{
		var disableDelAllBtn = publicJSON.disableDelAllBtn;
		var isUsersCreated = publicJSON['isUsersCreated'];
		if (isUsersCreated != false)
		{
			var rootData = {
				text: 'Choose Organization / Organizational Unit / User',
				id: '-1',
				name: '-1',
				expanded: true,
				children:publicJSON['exportDataArr']
			};
			var userLicenseListObj = Ext.getCmp('unameTree');
			userLicenseListObj.setRootNode(rootData);
			userLicenseListObj.show();
			Ext.getCmp('emptyCont').hide();

			if (isUserBasedLic)
			{
				userLicenseListObj.columns[7].show();

				if (publicJSON.isMgrConcUserBased)
				{
					UserBased = concurrentUsers;
				}
				else if (publicJSON.isMgrNamedUserBased)
				{
					UserBased = namedUsers;
				}
				userLicenseListObj.columns[7].setText(UserBased);
				userLicenseListObj.getView().refresh();
			}
			else if(!isUserBasedLic)
			{
				userLicenseListObj.columns[7].setText(UserBased);
				userLicenseListObj.columns[7].hide();
			}
		}
		else
		{
			Ext.getCmp('unameTree').hide();
			Ext.getCmp('emptyCont').show();
		}

		if(disableDelAllBtn)
		{
			Ext.getCmp('setAllToDefaultBtnMSP').setDisabled(true);
		}
		else
		{
			Ext.getCmp('setAllToDefaultBtnMSP').setDisabled(false);
		}
	},
	showEgOrgLicenseWindow: function(nodeId)
	{
		var storeObj = Ext.getCmp("unameTree").getStore().getNodeById(nodeId);
		var uname = storeObj.get("UserID");
		var me = this;
		Ext.widget('window', {
			extend: 'Ext.window.Window',
			title: popTitle+" "+uname,
			id : 'egorglicense',
			closeAction: 'destory',
			modal: true,
			ghost:false,
			doClose: function() {
				this.destroy();
			},
			dockedItems: [
				{
					dock: 'bottom',
					layout:{
						type:'hbox',
						align:'stretch',
						pack:'center'
					},
					border:false,
					padding : '10 0 5 0',
					items: [
						{
							xtype: 'button',
							text: updateBtn,
							width: 80,
							cls: 'quickMenuWhiteButton',
							id: 'updateEgOrgLicense',
							name: 'updateEgOrgLicense',
							handler: function()
							{
								me.egOrgsLicenseUpdate("modify", nodeId);
							}
						}
					]
				}
			],
			items : [
				{
					xtype: 'container',
					layout: {
						type: 'vbox',
						align: 'stretch'
					},
					defaults: {
						labelSeparator: ' ',
						margin: 8
					},
					margin: 5,
					border: true,
					style: 'border: 1px solid lightgrey',
					items: [
						{
							xtype: 'displayfield',
							fieldLabel: userName,
							labelWidth: 120,
							value: "",
							id:'egOrgLicenseName',
							name:'egOrgLicName',
							hidden:true
						},
						{
							xtype: 'fieldcontainer',
							fieldLabel: 'Attribute',
							labelWidth: 150,
							layout: {
								type: 'hbox',
								pack: 'start'
							},
							defaults: {
								labelSeparator: ''
							},
							items: [
								{
									xtype: 'label',
									text: 'License limit',
									width: 120
								},
								{
									xtype: 'label',
									text: 'License consumed',
									width: 120,
									margin: '0 0 0 20'
								},
								{
									xtype: 'label',
									text: 'Org/OU License limit',
									width: 120,
									margin: '0 0 0 20'
								}
							]
						},
						{
							xtype: 'fieldcontainer',
							fieldLabel: totalMonitors,
							labelWidth: 150,
							layout: {
								type: 'hbox',
								pack: 'start'
							},
							defaults: {
								labelSeparator: ''
							},
							items: [
								{
									xtype: 'textfield',
									cls:'textbox',
									id:'egOrgTotalMonitors',
									name:'egOrgTotalMonitors',
									width: 120,
									listeners:{
										'change' : function(obj){
											me.validateBasicCountAndChangePremCount('total');
										}
									},
									margin: '0 5 0 0'
								},
								{
									xtype: 'label',
									id:'egUsedTotalMonitorsCount',
									width: 120,
									margin: '0 0 0 15'
								},
								{
									xtype: 'label',
									id:'egOrgTotalMonitorsCount',
									width: 120,
									margin: '0 0 0 20'
								}
							]
						},
						{
							xtype: 'fieldcontainer',
							fieldLabel: basicMonitors,
							labelWidth: 150,
							layout: {
								type: 'hbox',
								pack: 'start'
							},
							defaults: {
								labelSeparator: ''
							},
							items: [
								{
									xtype: 'textfield',
									cls:'textbox',
									id:'egOrgBasicMonitors',
									name:'egOrgBasicMonitors',
									width: 120,
									listeners:{
										'change' : function(obj){
											me.validateBasicCountAndChangePremCount('basic');
										}
									}
								},
								{
									xtype: 'label',
									id:'egUsedBasicMonitorsCount',
									width: 120,
									margin: '0 0 0 20'
								},
								{
									xtype: 'label',
									id:'egOrgBasicMonitorsCount',
									width: 120,
									margin: '0 0 0 20'
								}
							]
						},
						{
							xtype: 'fieldcontainer',
							fieldLabel: premiumMonitors + '&nbsp;<img data-qtip="'+licenseMsg+'.'+'" style="vertical-align: top;" src="/final/images/clear.png" class="iconTooltipHelp"/>',
							labelWidth: 150,
							layout: {
								type: 'hbox',
								pack: 'start'
							},
							defaults: {
								labelSeparator: ''
							},
							items: [
								{
									xtype: 'label',
									id:'egOrgPremMonitors',
									width: 120
								},
								{
									xtype: 'label',
									id:'egUsedPremMonitorsCount',
									width: 120,
									margin: '0 0 0 20'
								},
								{
									xtype: 'label',
									id:'egOrgPremMonitorsCount',
									width: 120,
									margin: '0 0 0 20'
								}
							]
						},
						{
							xtype: 'fieldcontainer',
							fieldLabel: networkDevices,
							labelWidth: 150,
							layout: {
								type: 'hbox',
								pack: 'start'
							},
							defaults: {
								labelSeparator: ''
							},
							items: [
								{
									xtype: 'textfield',
									cls:'textbox',
									id:'egOrgNetworkDevices',
									name:'egOrgNetworkDevices',
									width: 120
								},
								{
									xtype: 'label',
									id:'egUsedNetworkDevicesCount',
									width: 120,
									margin: '0 0 0 20'
								},
								{
									xtype: 'label',
									id:'egOrgNetworkDevicesCount',
									width: 120,
									margin: '0 0 0 20'
								}
							]
						},
						{
							xtype: 'fieldcontainer',
							id: 'egOrgBasedCnt',
							hidden: true,
							labelWidth: 150,
							layout: {
								type: 'hbox',
								pack: 'start'
							},
							defaults: {
								labelSeparator: ''
							},
							items: [
								{
									xtype: 'textfield',
									cls:'textbox',
									id:'egOrgBased',
									name:'egOrgBased',
									width: 120
								},
								{
									xtype: 'label',
									id:'egUsedBasedCount',
									width: 120,
									margin: '0 0 0 20'
								},
								{
									xtype: 'label',
									id:'egOrgBasedCount',
									width: 120,
									margin: '0 0 0 20'
								}
							]
						},
						{
							xtype: 'fieldcontainer',
							fieldLabel: UserCount,
							labelWidth: 150,
							layout: {
								type: 'hbox',
								pack: 'start'
							},
							defaults: {
								labelSeparator: ''
							},
							items: [
								{
									xtype: 'textfield',
									cls:'textbox',
									id:'egOrgUsersCount',
									name:'egOrgUsersCount',
									width: 120
								},
								{
									xtype: 'label',
									id:'egUsedUsersTotCount',
									width: 120,
									margin: '0 0 0 20'
								},
								{
									xtype: 'label',
									id:'egOrgUsersTotCount',
									width: 120,
									margin: '0 0 0 20'
								}
							]
						},
					]
				}
			]
		}).show();

		//var uname = storeObj.get("UserID");
		var tot_mon = storeObj.get("TotalMonitors");
		var basic_mon = storeObj.get("BasicMonitors");
		var prem_mon = storeObj.get("PremiumMonitors");
		var network_dev = storeObj.get("NetworkDevices");
		var user_cnt = storeObj.get("UserCount");

		//gettting & setting user/organizational unit specific license count
		var userTotalMonitor = tot_mon.substring(0,tot_mon.indexOf("#"));
		var userBasicMonitor = basic_mon.substring(0,basic_mon.indexOf("#"));
		var userPremMonitor = prem_mon.substring(0,prem_mon.indexOf("#"));
		var userNetworkDev = network_dev.substring(0,network_dev.indexOf("#"));
		var userTotCount = user_cnt.substring(0,user_cnt.indexOf("#"));

		userTotalMonitor = (userTotalMonitor == "-") ? "-1" : userTotalMonitor;
		userBasicMonitor = (userBasicMonitor == "-") ? "-1" : userBasicMonitor;
		userPremMonitor = (userPremMonitor == "-") ? "-1" : userPremMonitor;
		userNetworkDev = (userNetworkDev == "-") ? "-1" : userNetworkDev;
		userTotCount = (userTotCount == "-") ? "-1" : userTotCount;
		
		Ext.getCmp('egOrgLicenseName').setValue(uname);
		Ext.getCmp('egOrgTotalMonitors').setValue(userTotalMonitor);
		Ext.getCmp('egOrgBasicMonitors').setValue(userBasicMonitor);
		Ext.getCmp('egOrgPremMonitors').update(userPremMonitor);
		Ext.getCmp('egOrgNetworkDevices').setValue(userNetworkDev);
		Ext.getCmp('egOrgUsersCount').setValue(userTotCount);

		//gettting & setting organizational unit/organization specific license count
		var orgTotalMonCount = tot_mon.substring(tot_mon.indexOf("#")+1);
		var orgBasicMonCount = basic_mon.substring(basic_mon.indexOf("#")+1);
		var orgPremMonCount = prem_mon.substring(prem_mon.indexOf("#")+1);
		var orgNtwDevCount = network_dev.substring(network_dev.indexOf("#")+1);
		var orgUsrtotCount = user_cnt.substring(user_cnt.indexOf("#")+1);

		Ext.getCmp('egOrgTotalMonitorsCount').update(orgTotalMonCount);
		Ext.getCmp('egOrgBasicMonitorsCount').update(orgBasicMonCount);
		Ext.getCmp('egOrgPremMonitorsCount').update(orgPremMonCount);
		Ext.getCmp('egOrgNetworkDevicesCount').update(orgNtwDevCount);
		Ext.getCmp('egOrgUsersTotCount').update(orgUsrtotCount);

		//getting selected OU's used count
		var usedCountDetails = this.getUsedCountDetails(uname);
		var toMonUsedCount = "", premMonUsedCount = "", basMonUsedCount = "", ntwDevUsedCount = "", usrTotUsedCount = "";
		if (usedCountDetails)
		{
			toMonUsedCount = usedCountDetails[0];
			premMonUsedCount = usedCountDetails[1];
			basMonUsedCount = usedCountDetails[2];
			ntwDevUsedCount = usedCountDetails[3];
			usrTotUsedCount = usedCountDetails[4];
			Ext.getCmp('egUsedTotalMonitorsCount').update(toMonUsedCount);
			Ext.getCmp('egUsedBasicMonitorsCount').update(basMonUsedCount);
			Ext.getCmp('egUsedPremMonitorsCount').update(premMonUsedCount);
			Ext.getCmp('egUsedNetworkDevicesCount').update(ntwDevUsedCount);
			Ext.getCmp('egUsedUsersTotCount').update(usrTotUsedCount);
		}

		if ((publicJSON.isMgrUsedBased != undefined || publicJSON.isMgrUsedBased != "") && publicJSON.isMgrUsedBased == "true")
		{
			var user_based = storeObj.get("UserBased");
			Ext.getCmp('egOrgBasedCnt').show();
			if (publicJSON.isMgrConcUserBased)
			{
				Ext.getCmp('egOrgBasedCnt').setFieldLabel(concurrentUsers);
			}
			else if (publicJSON.isMgrNamedUserBased)
			{
				Ext.getCmp('egOrgBasedCnt').setFieldLabel(namedUsers);
			}
			var orgUserBasedCount = user_based.substring(user_based.indexOf("#")+1);
			Ext.getCmp('egOrgBasedCount').update(orgUserBasedCount);
			Ext.getCmp('egUsedBasedCount').update('-');

			var userBasedCount = user_based.substring(0,user_based.indexOf("#"));
			userBasedCount = (userBasedCount == "-") ? "-1" : userBasedCount;
			Ext.getCmp('egOrgBased').setValue(userBasedCount);
		}
		else
		{
			Ext.getCmp('egOrgBasedCnt').hide();
		}
	},
	loadEgOrgLicenseWindow: function(nodeId, userNames, totMon, basicMon, networkDev, usersBased, usersCnt)
	{
		this.buildFieldData();
		this.afterMainRender();
		var storeObj = Ext.getCmp("unameTree").getStore().getNodeById(nodeId);
		var isUsersCreated = publicJSON['isUsersCreated'];
		if (isUsersCreated != false)
		{
			var uname = storeObj.get("UserID");
			var tot_mon = storeObj.get("TotalMonitors");
			var basic_mon = storeObj.get("BasicMonitors");
			var network_dev = storeObj.get("NetworkDevices");
			var user_based = storeObj.get("UserBased");
			var user_count = storeObj.get("UserCount");
			tot_mon = (tot_mon == "-") ? "-1" : tot_mon;
			basic_mon = (basic_mon == "-") ? "-1" : basic_mon;
			network_dev = (network_dev == "-") ? "-1" : network_dev;
			user_count = (user_count == "-") ? "-1" : user_count;

			if (tot_mon.indexOf("#"))
			{
				tot_mon = tot_mon.substring(0,tot_mon.indexOf("#"));
				basic_mon = basic_mon.substring(0,basic_mon.indexOf("#"));
				network_dev = network_dev.substring(0,network_dev.indexOf("#"));
				user_count = user_count.substring(0,user_count.indexOf("#"));
			}
			userNames.setValue(uname);
			totMon.setValue(tot_mon);
			basicMon.setValue(basic_mon);
			networkDev.setValue(network_dev);
			usersCnt.setValue(user_count);

			if (isUserBasedLic)
			{
				user_based = (user_based == "-") ? "-1" : user_based;
				user_based = user_based.substring(0,user_based.indexOf("#"));
				usersBased.setValue(user_based);
			}
		}
	},
	egOrgsLicenseUpdate : function(action, nodeId)
	{
		var url = "";
		var me = this;
		var actionFlag = true;
		var selTab = "userWiseView";
		var userNames = Ext.getCmp('egOrgLicenseName');
		var totMon = Ext.getCmp('egOrgTotalMonitors');
		var basicMon = Ext.getCmp('egOrgBasicMonitors');
		var networkDev = Ext.getCmp('egOrgNetworkDevices');
		var usersBased = Ext.getCmp('egOrgBased');
		var usersCnt = Ext.getCmp('egOrgUsersCount');
		var userNamesVal = "", userLicenseCounts = "", orgLicenseCounts = "", childLicenseCounts = "";
		var totMonVal = "", basicMonVal = "", networkDevVal = "", usersBasedVal = "", usersCntVal = "";
		var orgTotMonVal = "", orgBasicMonVal = "", orgNetworkDevVal = "", orgUsersBasedVal = "", orgUsersCntVal = "";
		var childTotMonVal = 0, childBasicMonVal = 0, childNetworkDevVal = 0, childUsersBasedVal = 0, childUsersCntVal = 0;
		var isProceed = false;
		var isUserBasedLic = ((publicJSON.isMgrUsedBased != undefined || publicJSON.isMgrUsedBased != "") && publicJSON.isMgrUsedBased == "true");
		
		if (action == "setDefault")
		{
			var storeObj = Ext.getCmp("unameTree").getStore().getNodeById(nodeId);
			userNamesVal = storeObj.get('UserID');
			totMonVal = storeObj.get('TotalMonitors');
			basicMonVal = storeObj.get('BasicMonitors');
			networkDevVal = storeObj.get('NetworkDevices');
			if (isUserBasedLic)
			{
				usersBasedVal = storeObj.get('UserBased');
			}
			usersCntVal = storeObj.get('UserCount');
			isProceed = true;
		}
		else if (action == "modify")
		{
			userNamesVal = userNames.getValue();
			totMonVal = totMon.getValue();
			basicMonVal = basicMon.getValue();
			networkDevVal = networkDev.getValue();
			if (isUserBasedLic)
			{
				usersBasedVal = usersBased.getValue();
			}
			usersCntVal = usersCnt.getValue();

			var storeObj = Ext.getCmp("unameTree").getStore().getNodeById(nodeId);
			if (storeObj.hasChildNodes())
			{
				var childElemLen = storeObj.childNodes.length;
				for (var i=0; i<childElemLen; i++)
				{
					childElem = storeObj.childNodes[i];
					var noSpecificLic = childElem.get('disableDelete');
					if (noSpecificLic)
					{
						continue;
					}
					var tempTotMonVal = childElem.get('TotalMonitors');
					var tempBasicMonVal = childElem.get('BasicMonitors');
					var tempNetworkDevVal = childElem.get('NetworkDevices');
					var tempUsersCntVal = childElem.get('UserCount');

					tempTotMonVal = tempTotMonVal.substring(0,tempTotMonVal.indexOf("#"));
					tempBasicMonVal = tempBasicMonVal.substring(0,tempBasicMonVal.indexOf("#"));
					tempNetworkDevVal = tempNetworkDevVal.substring(0,tempNetworkDevVal.indexOf("#"));
					tempUsersCntVal = tempUsersCntVal.substring(0,tempUsersCntVal.indexOf("#"));

					childTotMonVal = (parseInt(tempTotMonVal) > childTotMonVal) ? tempTotMonVal : childTotMonVal;
					childBasicMonVal = (parseInt(tempBasicMonVal) > childBasicMonVal) ? tempBasicMonVal : childBasicMonVal;
					childNetworkDevVal = (parseInt(tempNetworkDevVal) > childNetworkDevVal) ? tempNetworkDevVal : childNetworkDevVal;
					childUsersCntVal = (parseInt(tempUsersCntVal) > childUsersCntVal) ? tempUsersCntVal : childUsersCntVal;
					if (isUserBasedLic)
					{
						var tempUsersBasedVal = childElem.get('UserBased');
						tempUsersBasedVal = tempUsersBasedVal.substring(0,tempUsersBasedVal.indexOf("#"));
						childUsersBasedVal = (parseInt(tempUsersBasedVal) > childUsersBasedVal) ? tempUsersBasedVal : childUsersBasedVal;
					}
				}
			}
		}

		if (totMonVal.indexOf("#") != -1)
		{
			orgTotMonVal = totMonVal.substring(totMonVal.indexOf("#")+1);
			orgBasicMonVal = basicMonVal.substring(basicMonVal.indexOf("#")+1);
			orgNetworkDevVal = networkDevVal.substring(networkDevVal.indexOf("#")+1);
			orgUsersCntVal = usersCntVal.substring(usersCntVal.indexOf("#")+1);

			totMonVal = totMonVal.substring(0,totMonVal.indexOf("#"));
			basicMonVal = basicMonVal.substring(0,basicMonVal.indexOf("#"));
			networkDevVal = networkDevVal.substring(0,networkDevVal.indexOf("#"));
			usersCntVal = usersCntVal.substring(0,usersCntVal.indexOf("#"));

			if (isUserBasedLic)
			{
				orgUsersBasedVal = usersBasedVal.substring(usersBasedVal.indexOf("#")+1);
				usersBasedVal = usersBasedVal.substring(0,usersBasedVal.indexOf("#"));
			}
		}
		else
		{
			orgTotMonVal = document.getElementById('egOrgTotalMonitorsCount').innerHTML;
			orgBasicMonVal = document.getElementById('egOrgBasicMonitorsCount').innerHTML;
			orgNetworkDevVal = document.getElementById('egOrgNetworkDevicesCount').innerHTML;
			orgUsersCntVal = document.getElementById('egOrgUsersTotCount').innerHTML;
			if (isUserBasedLic)
			{
				orgUsersBasedVal = document.getElementById('egOrgBasedCount').innerHTML;
			}
		}

		var orgPremMonVal = "";
		if (orgTotMonVal.toLowerCase() == "unlimited" || orgTotMonVal == "-1" || basicMonVal.toLowerCase() == "unlimited" || basicMonVal == "-1")
		{
			orgPremMonVal = "unlimited";
		}
		else
		{
			var tmVal = parseInt(orgTotMonVal);
			var bmVal = parseInt(basicMonVal);
			orgPremMonVal = (tmVal - bmVal);
		}

		totMonVal = checkMonitorsValue(orgTotMonVal,totMonVal,false);
		basicMonVal = checkMonitorsValue(totMonVal+"#"+orgPremMonVal,basicMonVal,true);
		networkDevVal = checkMonitorsValue(orgNetworkDevVal,networkDevVal,false);
		if (isUserBasedLic)
		{
			usersBasedVal = checkMonitorsValue(orgUsersBasedVal,usersBasedVal,false);
		}
		usersCntVal = checkMonitorsValue(orgUsersCntVal,usersCntVal,false);

		if(action == "reset")
		{
			actionFlag = false;
		}
		else if(action == "modify")
		{
			orgLicenseCounts = orgTotMonVal + "#" + orgBasicMonVal + "#" + orgNetworkDevVal + "#";
			orgLicenseCounts += (isUserBasedLic) ? (orgUsersBasedVal + "#" + orgUsersCntVal) : ("0#" + orgUsersCntVal);

			userLicenseCounts = totMonVal + "#" + basicMonVal + "#" + networkDevVal + "#";
			userLicenseCounts += (isUserBasedLic) ? (usersBasedVal + "#" + usersCntVal) : ("0#" + usersCntVal);

			childLicenseCounts = childTotMonVal + "#" + childBasicMonVal + "#" + childNetworkDevVal + "#";
			childLicenseCounts += (isUserBasedLic) ? (childUsersBasedVal + "#" + childUsersCntVal) : ("0#" + childUsersCntVal);

			isProceed = me.egOrgLicenseValidation(totMon, basicMon, networkDev, usersBased, usersCnt, userLicenseCounts, orgLicenseCounts, childLicenseCounts);
		}
		if (isProceed && actionFlag)
		{
			var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			url = "UserLicense/data/UserLicenseJSONp.jsp?from="+selTab+"&userName="+encodeURIComponent(userNamesVal)+"&totalMonitors="+totMonVal+"&basicMonitors="+basicMonVal+"&networkDevices="+networkDevVal+"&userBased="+usersBasedVal+"&userLicSpecific=yes&action="+action+"&usersTotCount="+usersCntVal;
			if (action == "setDefault")
			{
				Ext.Msg.show({
					title : popTitle2,
					msg : updateSingleRowActnMsg+" '"+userNamesVal+"'?",
					buttons : Ext.Msg.YESNO,
					icon : 'iconConfirmation',
					width : 350,
					fn : function(response) {
						if (response === 'yes') {
							tmpMask.show();
							Ext.Ajax.request({
								url : url,
								method : 'POST',
								success : function( response ) {
									if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) {
										tmpMask.hide();
										var jsonText = response.responseText;
										publicJSON = Ext.decode(jsonText);
										me.buildFieldData();
										me.afterMainRender();
										Ext.Msg.show({
											title : pageTitle,
											msg : intnlLabel10,
											buttons : Ext.Msg.YES,
											icon : 'iconInformation',
											width : 350,
											fn : function(response) {
												if (response === 'yes') {}
											}
										});
									}
								},
								failure : function()
								{
									tmpMask.hide();
								}
							});
						}
					}
				});
			}
			else
			{
				tmpMask.show();
				Ext.Ajax.request({
					url : url,
					method : 'POST',
					success : function( response ) {
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) {
							tmpMask.hide();
							var jsonText = response.responseText;
							publicJSON = Ext.decode(jsonText);
							me.loadEgOrgLicenseWindow(nodeId, userNames, totMon, basicMon, networkDev, usersBased, usersCnt);
							Ext.Msg.show({
								title : pageTitle,
								msg : intnlLabel8,
								buttons : Ext.Msg.YES,
								icon : 'iconInformation',
								width : 350,
								fn : function(response) {
									if (response === 'yes') {
										var contObj = Ext.getCmp('egorglicense');
										if(contObj != undefined)
										{
											contObj.destroy();
										}
									}
								}
							});
						}
					},
					failure : function()
					{
						tmpMask.hide();
					}
				});
			}
		}
		else if(!actionFlag)
		{
			me.loadEgOrgLicenseWindow(nodeId, userNames, totMon, basicMon, networkDev, usersBased, usersCnt);
		}
	},
	setAllUsersToDefaultSettings : function()
	{
		var me = this;
		var selTab = "userWiseView";
		var url = "UserLicense/data/UserLicenseJSONp.jsp?from="+selTab+"&resetAllToDefault=yes";
		var tmpMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
		Ext.Msg.show({
			title : pageTitle,
			msg : updateMultipleActnMsg+"?",
			buttons : Ext.Msg.YESNO,
			icon : 'iconConfirmation',
			width : 350,
			fn : function(response) {
				if (response === 'yes')
				{
					tmpMask.show();
					Ext.Ajax.request({
						url : url,
						method : 'POST',
						success : function( response ) {
							if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) {
								tmpMask.hide();
								var jsonText = response.responseText;
								publicJSON = Ext.decode(jsonText);
								Ext.Msg.show({
									title : pageTitle,
									msg : intnlLabel9,
									buttons : Ext.Msg.OK,
									icon : 'iconInformation',
									width : 350,
									fn : function(btn) {
										if (btn == 'ok'){
											me.buildFieldData();
											me.afterMainRender();
										 }
									}
								});
							}
						}
					});
				}
			}
		});
	},
	egOrgLicenseValidation : function(totMon, basicMon, networkDev, usersBased, usersCount, userLicenseCounts, orgLicenseCounts, childLicenseCounts)
	{
		var userNameObj = Ext.getCmp("egOrgLicenseName");
		var isUserBasedLic = ((publicJSON.isMgrUsedBased != undefined || publicJSON.isMgrUsedBased != "") && publicJSON.isMgrUsedBased == "true");

		//current user values
		var totMonVal = "", premMonVal = "", basicMonVal = "", networkDevVal = "", usersBasedVal = "", usersCountVal = "";
		if (userLicenseCounts != "" && userLicenseCounts.length > 0)
		{
			var licCntArr = userLicenseCounts.split("#");
			if (licCntArr.length == 5)
			{
				totMonVal = licCntArr[0];
				basicMonVal = licCntArr[1];
				networkDevVal = licCntArr[2];
				usersBasedVal = licCntArr[3];
				usersCountVal = licCntArr[4];
			}
			if (totMonVal.toString().toLowerCase() == "unlimited" || totMonVal.toString() == "-1" || basicMonVal.toString().toLowerCase() == "unlimited" || basicMonVal.toString() == "-1")
			{
				premMonVal = "unlimited";
			}
			else
			{
				var tMCount = parseInt(totMonVal);
				var bMCount = parseInt(basicMonVal);
				premMonVal = (totMonVal - basicMonVal);
			}
		}
		//current user's OU values
		var toMonCount = 0, premMonCount = 0, basMonCount = 0, ntwDevCount = 0, usrBasedCount = 0, usrTotCount = 0;
		if (orgLicenseCounts != "" && orgLicenseCounts.length > 0)
		{
			var licCntArr = orgLicenseCounts.split("#");
			if (licCntArr.length == 5)
			{
				toMonCount = licCntArr[0];
				basMonCount = licCntArr[1];
				ntwDevCount = licCntArr[2];
				usrBasedCount = licCntArr[3];
				usrTotCount = licCntArr[4];
			}
			if (toMonCount.toString().toLowerCase() == "unlimited" || toMonCount.toString() == "-1" || basMonCount.toString().toLowerCase() == "unlimited" || basMonCount.toString() == "-1")
			{
				premMonCount = "unlimited";
			}
			else
			{
				var tMCount = parseInt(toMonCount);
				var bMCount = parseInt(basMonCount);
				premMonCount = (toMonCount - basMonCount);
			}
		}
		//current user's immediate child vlaues
		var childTotMonCount = 0, childPremMonCount = 0, childBasMonCount = 0, childNtwDevCount = 0, childUsrBasedCount = 0, childUsrTotCount = 0;
		if (childLicenseCounts != "" && childLicenseCounts.length > 0)
		{
			var licCntArr = childLicenseCounts.split("#");
			if (licCntArr.length == 5)
			{
				childTotMonCount = licCntArr[0];
				childBasMonCount = licCntArr[1];
				childNtwDevCount = licCntArr[2];
				childUsrBasedCount = licCntArr[3];
				childUsrTotCount = licCntArr[4];
			}
			if (childTotMonCount.toString().toLowerCase() == "unlimited" || childTotMonCount.toString() == "-1" || childBasMonCount.toString().toLowerCase() == "unlimited" || childBasMonCount.toString() == "-1")
			{
				childPremMonCount = "unlimited";
			}
			else
			{
				var tMCount = parseInt(childTotMonCount);
				var bMCount = parseInt(childBasMonCount);
				childPremMonCount = (childTotMonCount - childBasMonCount);
			}
		}

		var userName = "";
		if(userNameObj != null && userNameObj != undefined)
		{
			userName = userNameObj.getValue();
			if(userName === undefined || userName == "-1" || userName == "/")
			{
				Ext.Msg.alert(pageTitle,intnlLabel6,function(btn){
					if (btn == 'ok'){
						userNameObj.focus(true);
					 }
				});
				return false;
			}
		}

		//getting selected OU's used count
		var usedCountDetails = this.getUsedCountDetails(userName);
		var toMonUsedCount = "", premMonUsedCount = "", basMonUsedCount = "", ntwDevUsedCount = "", usrTotUsedCount = "";
		if (usedCountDetails)
		{
			toMonUsedCount = usedCountDetails[0];
			premMonUsedCount = usedCountDetails[1];
			basMonUsedCount = usedCountDetails[2];
			ntwDevUsedCount = usedCountDetails[3];
			usrTotUsedCount = usedCountDetails[4];
		}

		var totalMonCheckVal = checkMonitorsValueExtjs(toMonCount,totMonVal,childTotMonCount,toMonUsedCount);
		var basicMonCheckVal = checkBasicMonitorsValueExtjs(toMonCount,premMonCount,basMonCount,totMonVal,basicMonVal,childBasMonCount,basMonUsedCount,premMonUsedCount);
		var networkMonCheckVal = checkMonitorsValueExtjs(ntwDevCount,networkDevVal,childNtwDevCount,ntwDevUsedCount);
		var userCountCheckVal = checkMonitorsValueExtjs(usrTotCount,usersCountVal,childUsrTotCount,usrTotUsedCount);

		var splChar = "`~!@#$%^&*()_+=[]{}|\\:;\"\'<>?\/";
		if (!checkblank(totMonVal))
		{
			Ext.Msg.alert(pageTitle,intnlLabel1,function(btn){
				if (btn == 'ok'){
					totMon.focus();
				 }
			});
			return false;
		}
		else if(checkspaceExtjs(totMonVal) != '0')
		{
			Ext.Msg.alert(pageTitle,validationMsg1,function(btn){
				if (btn == 'ok'){
					totMon.focus(true);
				 }
			});
			return false;
		}
		else if(checkSpecialExtjs(totMonVal,splChar) != '0')
		{
			Ext.Msg.alert(pageTitle,validationMsg2,function(btn){
				if (btn == 'ok'){
					totMon.focus(true);
				 }
			});
			return false;
		}
		else if(checkAlpha(totMonVal))
		{
			Ext.Msg.alert(pageTitle,_checkAlpha,function(btn){
				if (btn == 'ok'){
					totMon.focus(true);
				}
			});
			return false;
		}
		else if(!checkDecimalExtjs(totMonVal))
		{
			Ext.Msg.alert(pageTitle,_checkfordecimal,function(btn){
				if (btn == 'ok'){
					totMon.focus(true);
				}
			});
			return false;
		}
		else if(!checkHypenValueExtjs(totMonVal))
		{
			Ext.Msg.alert(pageTitle,_checkfordecimal,function(btn){
				if (btn == 'ok'){
					totMon.focus(true);
				}
			});
			return false;
		}
		else if(totalMonCheckVal == 1)
		{
			Ext.Msg.alert(pageTitle,validationMsg9,function(btn){
				if (btn == 'ok'){
					totMon.focus(true);
				}
			});
			return false;
		}
		else if(totalMonCheckVal == 2)
		{
			Ext.Msg.alert(pageTitle,validationMsg4,function(btn){
				if (btn == 'ok'){
					totMon.focus(true);
				}
			});
			return false;
		}
		else if(totalMonCheckVal == 3)
		{
			Ext.Msg.alert(pageTitle,validationMsg19+" ("+toMonUsedCount+").",function(btn){
				if (btn == 'ok'){
					totMon.focus(true);
				}
			});
			return false;
		}

		if (!checkblank(basicMonVal))
		{
			Ext.Msg.alert(pageTitle,intnlLabel2,function(btn){
				if (btn == 'ok'){
					basicMon.focus(true);
				 }
			});
			return false;
		}
		else if(checkspaceExtjs(basicMonVal) != '0')
		{
			Ext.Msg.alert(pageTitle,validationMsg1,function(btn){
				if (btn == 'ok'){
					basicMon.focus(true);
				 }
			});
			return false;
		}
		else if(checkSpecialExtjs(basicMonVal,splChar) != '0')
		{
			Ext.Msg.alert(pageTitle,validationMsg2,function(btn){
				if (btn == 'ok'){
					basicMon.focus(true);
				 }
			});
			return false;
		}
		else if(checkAlpha(basicMonVal))
		{
			Ext.Msg.alert(pageTitle,_checkAlpha,function(btn){
				if (btn == 'ok'){
					basicMon.focus(true);
				}
			});
			return false;
		}
		else if(!checkDecimalExtjs(basicMonVal))
		{
			Ext.Msg.alert(pageTitle,_checkfordecimal,function(btn){
				if (btn == 'ok'){
					basicMon.focus(true);
				}
			});
			return false;
		}
		else if(!checkHypenValueExtjs(basicMonVal))
		{
			Ext.Msg.alert(pageTitle,_checkfordecimal,function(btn){
				if (btn == 'ok'){
					basicMon.focus(true);
				}
			});
			return false;
		}
		else if(basicMonCheckVal != 0)
		{
			if(basicMonCheckVal == 1)
			{
				Ext.Msg.alert(pageTitle,validationMsg16,function(btn){
					if (btn == 'ok'){
						basicMon.focus(true);
					}
				});
				return false;
			}
			else if(basicMonCheckVal == 2)
			{
				Ext.Msg.alert(pageTitle,validationMsg10,function(btn){
					if (btn == 'ok'){
						basicMon.focus(true);
					}
				});
				return false;
			}
			else if(basicMonCheckVal == 3)
			{
				Ext.Msg.alert(pageTitle,validationMsg9,function(btn){
					if (btn == 'ok'){
						basicMon.focus(true);
					}
				});
				return false;
			}
			else if(basicMonCheckVal == 4)
			{
				Ext.Msg.alert(pageTitle,validationMsg5,function(btn){
					if (btn == 'ok'){
						basicMon.focus(true);
					}
				});
				return false;
			}
			else if(basicMonCheckVal == 5)
			{
				Ext.Msg.alert(pageTitle,validationMsg20+" ("+basMonUsedCount+").",function(btn){
					if (btn == 'ok'){
						basicMon.focus(true);
					}
				});
				return false;
			}
			else if(basicMonCheckVal == 6)
			{
				Ext.Msg.alert(pageTitle,validationMsg24+". "+validationMsg25+" "+basicMonVal+".",function(btn){
					if (btn == 'ok'){
						basicMon.focus(true);
					}
				});
				return false;
			}
		}
		var totMonInt = parseInt(totMonVal);
		var basicMonInt = parseInt(basicMonVal);
		if (totMonInt != -1 && totMonInt < basicMonInt)
		{
			Ext.Msg.alert(pageTitle,validationMsg17,function(btn){
				if (btn == 'ok'){
					basicMon.focus(true);
				 }
			});
			return false;
		}

		if (!checkblank(networkDevVal))
		{
			Ext.Msg.alert(pageTitle,intnlLabel3,function(btn){
				if (btn == 'ok'){
					networkDev.focus(true);
				 }
			});
			return false;
		}
		else if(checkspaceExtjs(networkDevVal) != '0')
		{
			Ext.Msg.alert(pageTitle,validationMsg1,function(btn){
				if (btn == 'ok'){
					networkDev.focus(true);
				 }
			});
			return false;
		}
		else if(checkSpecialExtjs(networkDevVal,splChar) != '0')
		{
			Ext.Msg.alert(pageTitle,validationMsg2,function(btn){
				if (btn == 'ok'){
					networkDev.focus(true);
				 }
			});
			return false;
		}
		else if(checkAlpha(networkDevVal))
		{
			Ext.Msg.alert(pageTitle,_checkAlpha,function(btn){
				if (btn == 'ok'){
					networkDev.focus(true);
				}
			});
			return false;
		}
		else if(!checkDecimalExtjs(networkDevVal))
		{
			Ext.Msg.alert(pageTitle,_checkfordecimal,function(btn){
				if (btn == 'ok'){
					networkDev.focus(true);
				}
			});
			return false;
		}
		else if(!checkHypenValueExtjs(networkDevVal))
		{
			Ext.Msg.alert(pageTitle,_checkfordecimal,function(btn){
				if (btn == 'ok'){
					networkDev.focus(true);
				}
			});
			return false;
		}
		else if(networkMonCheckVal == 1)
		{
			Ext.Msg.alert(pageTitle,validationMsg11,function(btn){
				if (btn == 'ok'){
					networkDev.focus(true);
				}
			});
			return false;
		}
		else if(networkMonCheckVal == 2)
		{
			Ext.Msg.alert(pageTitle,validationMsg6,function(btn){
				if (btn == 'ok'){
					networkDev.focus(true);
				}
			});
			return false;
		}
		else if(networkMonCheckVal == 3)
		{
			Ext.Msg.alert(pageTitle,validationMsg22+" ("+ntwDevUsedCount+").",function(btn){
				if (btn == 'ok'){
					networkDev.focus(true);
				}
			});
			return false;
		}

		if (isUserBasedLic)
		{
			var initLabelUsers = "";
			var valMsgUsers = "", valMsgUsers2 = "";
			if (publicJSON.isMgrConcUserBased)
			{
				initLabelUsers = intnlLabel4;
				valMsgUsers = validationMsg12;
				valMsgUsers2 = validationMsg7;
			}
			else if (publicJSON.isMgrNamedUserBased)
			{
				initLabelUsers = intnlLabel5;
				valMsgUsers = validationMsg13;
				valMsgUsers2 = validationMsg8;
			}
			var userBasedCheckVal = checkMonitorsValueExtjs(usrBasedCount,usersBasedVal,childUsrBasedCount);

			if (!checkblank(usersBasedVal))
			{
				Ext.Msg.alert(pageTitle,initLabelUsers,function(btn){
					if (btn == 'ok'){
						usersBased.focus(true);
					 }
				});
				return false;
			}
			else if(checkspaceExtjs(usersBasedVal) != '0')
			{
				Ext.Msg.alert(pageTitle,validationMsg1,function(btn){
					if (btn == 'ok'){
						usersBased.focus(true);
					 }
				});
				return false;
			}
			else if(checkSpecialExtjs(usersBasedVal,splChar) != '0')
			{
				Ext.Msg.alert(pageTitle,validationMsg2,function(btn){
					if (btn == 'ok'){
						usersBased.focus(true);
					 }
				});
				return false;
			}
			else if(checkAlpha(usersBasedVal))
			{
				Ext.Msg.alert(pageTitle,_checkAlpha,function(btn){
					if (btn == 'ok'){
						usersBased.focus(true);
					}
				});
				return false;
			}
			else if(!checkDecimalExtjs(usersBasedVal))
			{
				Ext.Msg.alert(pageTitle,_checkfordecimal,function(btn){
					if (btn == 'ok'){
						usersBased.focus(true);
					}
				});
				return false;
			}
			else if(!checkHypenValueExtjs(usersBasedVal))
			{
				Ext.Msg.alert(pageTitle,_checkfordecimal,function(btn){
					if (btn == 'ok'){
						usersBased.focus(true);
					}
				});
				return false;
			}
			else if(userBasedCheckVal == 1)
			{
				Ext.Msg.alert(pageTitle,valMsgUsers,function(btn){
					if (btn == 'ok'){
						usersBased.focus(true);
					}
				});
				return false;
			}
			else if(userBasedCheckVal == 2)
			{
				Ext.Msg.alert(pageTitle,valMsgUsers2,function(btn){
					if (btn == 'ok'){
						usersBased.focus(true);
					}
				});
				return false;
			}
		}

		if (!checkblank(usersCountVal))
		{
			Ext.Msg.alert(pageTitle,intnlLabel7,function(btn){
				if (btn == 'ok'){
					usersCount.focus(true);
				 }
			});
			return false;
		}
		else if(checkspaceExtjs(usersCountVal) != '0')
		{
			Ext.Msg.alert(pageTitle,validationMsg1,function(btn){
				if (btn == 'ok'){
					usersCount.focus(true);
				 }
			});
			return false;
		}
		else if(checkSpecialExtjs(usersCountVal,splChar) != '0')
		{
			Ext.Msg.alert(pageTitle,validationMsg2,function(btn){
				if (btn == 'ok'){
					usersCount.focus(true);
				 }
			});
			return false;
		}
		else if(checkAlpha(usersCountVal))
		{
			Ext.Msg.alert(pageTitle,_checkAlpha,function(btn){
				if (btn == 'ok'){
					usersCount.focus(true);
				}
			});
			return false;
		}
		else if(!checkDecimalExtjs(usersCountVal))
		{
			Ext.Msg.alert(pageTitle,_checkfordecimal,function(btn){
				if (btn == 'ok'){
					usersCount.focus(true);
				}
			});
			return false;
		}
		else if(!checkHypenValueExtjs(usersCountVal))
		{
			Ext.Msg.alert(pageTitle,_checkfordecimal,function(btn){
				if (btn == 'ok'){
					usersCount.focus(true);
				}
			});
			return false;
		}
		else if(userCountCheckVal == 1)
		{
			Ext.Msg.alert(pageTitle,validationMsg15,function(btn){
				if (btn == 'ok'){
					usersCount.focus(true);
				}
			});
			return false;
		}
		else if(userCountCheckVal == 2)
		{
			Ext.Msg.alert(pageTitle,validationMsg14,function(btn){
				if (btn == 'ok'){
					usersCount.focus(true);
				}
			});
			return false;
		}
		else if(userCountCheckVal == 3)
		{
			Ext.Msg.alert(pageTitle,validationMsg23+" ("+usrTotUsedCount+").",function(btn){
				if (btn == 'ok'){
					usersCount.focus(true);
				}
			});
			return false;
		}
		return true;
	},
	validateBasicCountAndChangePremCount : function(from)
	{
		var currTotMonVal = Ext.getCmp('egOrgTotalMonitors').getValue();
		var usedTotMonVal = document.getElementById('egUsedTotalMonitorsCount').innerHTML;
		var currBasicMonVal = Ext.getCmp('egOrgBasicMonitors').getValue();
		var usedBasicMonVal = document.getElementById('egUsedBasicMonitorsCount').innerHTML;
		var usedPremMonVal = document.getElementById('egUsedPremMonitorsCount').innerHTML;
		var premObj = Ext.getCmp('egOrgPremMonitors');
		if (currBasicMonVal == "-")
		{
			premObj.update("-1");
		}
		else if (currTotMonVal == "-1" || currBasicMonVal == "-1")
		{
			premObj.update("-1");
		}
		else if (currTotMonVal.toLowerCase() == "unlimited" || isNaN(currBasicMonVal) || currBasicMonVal.toLowerCase() == "unlimited")
		{
			premObj.update("Unlimited");
		}
		else
		{
			if (from == 'basic')
			{			
				var premVal = currTotMonVal - currBasicMonVal;
				premVal = (premVal < 0) ? 0 :premVal;
				premObj.update(premVal);
				if ((premVal.toString() != "-1" && premVal.toString().toLowerCase() != "unlimited") && (premVal < usedPremMonVal))
				{
					Ext.Msg.alert(pageTitle,validationMsg24+". "+validationMsg25+" "+currBasicMonVal+".",function(btn){
						if (btn == 'ok'){
							Ext.getCmp('egOrgBasicMonitors').focus();
						}
					});
					return false;
				}
			}
		}
	},
	getUsedCountDetails : function(userName)
	{
		var resultArr = new Array();
		if (!userName)
		{
			return resultArr;
		}
		var url = 'UserLicense/data/UserLicenseJSON.jsp?from=user&userName='+userName;
		Ext.Ajax.request({
			url : url,
			method : "POST",
			async : false,
			success : function (response)
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) {
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					var usedLicCountDetails = publicJSON.usedLicCountDetails;
					if (usedLicCountDetails)
					{
						resultArr = usedLicCountDetails.split("#");
					}
				}
			},
			failure: function (b)
			{}
		});
		return resultArr;
	}
});

function checkAlpha(fieldValue)
{
	var flag = false;
	var s_check_str = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
	var s_check_str2 = "unlimited";
	if((fieldValue.toLowerCase()) == s_check_str2)
	{
		flag = false;
	}
	else
	{
		for(var i=0;i < fieldValue.length;i++)
		{
			if(s_check_str.indexOf(fieldValue.charAt(i)) > -1)
			{
				flag = true;
				break;
			}
		}
	}
	return flag;
}
function checkHypenValueExtjs(fieldValue)
{
	var hyphen = "-";
	var flag = true;
	if (fieldValue.length == 2 && fieldValue.indexOf("-1") != -1)
	{
		flag = true;
	}
	else
	{
		for (var c = 0; c < fieldValue.length; c++)
		{
			var value = fieldValue.charAt(c);
			if (value.indexOf(hyphen) != -1)
			{
				flag = false;
				break;
			}
		}
	}
  return flag;
}
function checkDecimalExtjs(fieldValue)
{
	var value = fieldValue+"";
	if (value.indexOf(".") > -1)
	{
		return false;
	}
	return true;
}
function checkMonitorsValue(totalVal,givenVal,isBasicMon)
{
	var un_limited = "unlimited";
	totalValue = totalVal+"";
	totalValue = totalValue.toLowerCase();
	givenValue = givenVal+"";
	givenValue = givenValue.toLowerCase();
	var premValue = "";
	if (totalValue.indexOf("#") > -1)
	{
		premValue = totalValue.substring(totalValue.indexOf("#")+1);
		totalValue = totalValue.substring(0,totalValue.indexOf("#"));
	}
	var totValue = parseInt(totalValue);
	var preValue = parseInt(premValue);
	var givValue = parseInt(givenValue);

	if (isBasicMon)
	{
		if(totalValue == un_limited || totalValue == "-1" || givenValue == un_limited || givenValue == "-1")
		{
			return "-1";
		}
		else if (totValue == 0 && preValue == 0)
		{
			return 0;
		}
		else
		{
			return givenValue;
		}
	}
	else
	{
		if((totalValue == un_limited || totalValue == "-1") && (givenValue == un_limited || givenValue == "-1"))
		{
			return "-1";
		}
		else if (totValue == 0)
		{
			return 0;
		}
		else
		{
			return givenValue;
		}
	}
}
function checkMonitorsValueExtjs(totalVal,givenVal,childVal,usedVal)
{
	totalVal = totalVal+"";
	totalVal = totalVal.toLowerCase();
	givenVal = givenVal+"";
	givenVal = givenVal.toLowerCase();
	childVal = childVal+"";
	childVal = childVal.toLowerCase();
	usedVal = usedVal+"";
	usedVal = usedVal.toLowerCase();
	var un_limited = "unlimited";
	if(((totalVal == un_limited || totalVal == "-1") && (childVal && childVal == un_limited || childVal == "-1")) || (givenVal == un_limited || givenVal == "-1"))
	{
		return 0;
	}
	var totalValue = parseInt(totalVal);
	var givenValue = parseInt(givenVal);
	var childValue = parseInt(childVal);
	var usedValue = parseInt(usedVal);
	if ((totalVal != "-1" && totalVal != unlimited) && (givenValue > totalValue))
	{
		return 1;
	}
	else if (givenValue < childValue)
	{
		return 2;
	}
	else if (givenValue < usedValue)
	{
		return 3;
	}
	else
	{
		return 0;
	}
}
function checkBasicMonitorsValueExtjs(totalVal,premVal,basicVal,givtotVal,givBasicVal,childBasicVal,usedBasicVal,usedPremVal)
{
	totalVal = totalVal+"";
	totalVal = totalVal.toLowerCase();
	givtotVal = givtotVal+"";
	givtotVal = givtotVal.toLowerCase();
	givBasicVal = givBasicVal+"";
	givBasicVal = givBasicVal.toLowerCase();
	childBasicVal = childBasicVal+"";
	childBasicVal = childBasicVal.toLowerCase();
	usedBasicVal = usedBasicVal+"";
	usedBasicVal = usedBasicVal.toLowerCase();
	usedPremVal = usedPremVal+"";
	usedPremVal = usedPremVal.toLowerCase();
	var un_limited = "unlimited";
	if(((totalVal == un_limited || totalVal == "-1") && (childBasicVal && childBasicVal == un_limited || childBasicVal == "-1")) || (givBasicVal == un_limited || givBasicVal == "-1"))
	{
		return 0;
	}
	var totalValue = parseInt(totalVal);
	var premValue = parseInt(premVal);
	var basicValue = parseInt(basicVal);
	var givenTotValue = parseInt(givtotVal);
	var givenBasValue = parseInt(givBasicVal);
	var givenPremValue = (givenTotValue > -1) ? (givenTotValue - givenBasValue) : -1;
	var childValue = parseInt(childBasicVal);
	var usedBasicValue = parseInt(usedBasicVal);
	var usedPremValue = parseInt(usedPremVal);
	if (totalValue == 0 && premValue == 0)
	{
		return 1;
	}
	else if (givenBasValue > basicValue)
	{
		return 2;
	}
	else if ((totalVal != "-1" && totalVal != unlimited) && (givenBasValue > totalValue))
	{
		return 3;
	}
	else if (givenBasValue < childValue)
	{
		return 4;
	}
	else if (givenBasValue < usedBasicValue)
	{
		return 5;
	}
	else if ((givenPremValue.toString() != "-1" && givenPremValue.toString().toLowerCase() != unlimited) && (givenPremValue < usedPremValue))
	{
		return 6;
	}
	else
	{
		return 0;
	}
}

