Ext.define('UserLicense.view.UserLicense',
{
	extend: 'Ext.form.Panel',
	alias: 'widget.userlicense',
	cls: 'outerpanel',
	id: 'mainUser',
	title: mainPageTitle,
	margin:'8 8 0 8',
	scroll : false,
	autoScroll : false,
	layout: {
		type: 'vbox',
		align: 'stretch'
	},

	dockedItems: [{
		xtype: 'toolbar',
		cls:'adminHeadInfoText',
		dock: 'top',
		height: 25,
		border:true,
		padding: 3,
		layout:{pack:'center'},
		items:[
			{
				xtype: 'component',
				html: '<center><img src="/final/images/spacer.gif" class="iconAdminInfo" valign="middle" style="margin-right:2px"/>&nbsp'+pageDesc+'.</center>'
			}
		]
	}],

	flex: 1,
	items:[
		{
			xtype: 'container',
			layout: {
				type: 'vbox',
				align: 'stretch'
			},
			margin: 10,
			flex: 1,
			items: [
				{
					xtype: 'treepanel',
					id: 'unameTree',
					name: 'unameTree',
					flex: 1,
					frame: false,
					border:false,
					autoShow: true,
					autoScroll: true,
					scroll: true,
					store: Ext.create('Ext.data.TreeStore', {fields: [{name: 'UserID', sortType:Ext.data.SortTypes.asUCString},'role','TotalMonitors','PremiumMonitors', 'BasicMonitors', 'NetworkDevices', 'UserBased', 'UserCount', 'disableModify', 'disableDelete'],
						sorters: [{
							property: 'UserID',
							direction: 'ASC' 
						}]
					}),
					rootVisible: false,
					useArrows:false,
					emptyText : LoadSearchAlert,
					columns: [
						{
							xtype: 'treecolumn',
							dataIndex: 'UserID',
							flex: 3,
							text: orgUnitName,
							renderer: function (e, b, a, g, d, c, f)
							{
								var nodeId = a.data["UserID"];
								b.tdAttr = "data-qtip='"+nodeId+"' data-qclass='yellowTip'";
								return nodeId;
							}
						},
						{
							xtype: "actioncolumn",
							width: 31,
							id: "modifyIconMsp",
							sortable: false,
							draggable: false,
							resizable: false,
							renderer: function (e, b, a, g, d, c, f)
							{
								b.tdAttr = "data-qtip='Configure license limit' data-qclass='yellowTip'";
								var disableModify = a.data["disableModify"];
								var nodeId = a.data["UserID"];
								var result = '<div class="iconModifyDisabled"></div>';
								if(!disableModify)
								{
									result = "<div style='cursor:pointer' onclick=\"javascript:ctrler.showEgOrgLicenseWindow('"+nodeId+"')\" class='iconModify'></div>";
								}
								return result;
							}
						},
						{
							xtype: "actioncolumn",
							width: 31,
							sortable: false,
							draggable: false,
							resizable: false,
							id: "setToDefaultEgUserLicense",
							renderer: function (e, b, a, g, d, c, f)
							{
								var nodeId = a.data["UserID"];
								b.tdAttr = "data-qtip='Delete license limit' data-qclass='yellowTip'";
								var value = a.data["TotalMonitors"];
								var disableDelete = a.data["disableDelete"];
								if(disableDelete || value != null && value.length == 0)
								{
									return '<div class="iconDeleteDisabled"></div>';
								}
								else
								{
									return "<div style='cursor:pointer' onclick=\"javascript:ctrler.egOrgsLicenseUpdate('setDefault','"+nodeId+"')\" class='iconDelete'></div>";
								}
							},
						},
						{
							text: totalMonitors,
							dataIndex: "TotalMonitors",
							id: "totMonMspId",
							flex: 1,
							renderer: function(e, b, a, g, d, c, f)
							{
								var value = e;
								value = (value.indexOf("#") > -1) ? value.substring(0,value.indexOf("#")) : value;
								return value;
							}
						},
						{
							text: basicMonitors,
							dataIndex: "BasicMonitors",
							id: "basicMspId",
							flex: 1,
							renderer: function(e, b, a, g, d, c, f)
							{
								var value = e;
								value = (value.indexOf("#") > -1) ? value.substring(0,value.indexOf("#")) : value;
								return value;
							}
						},
						{
							text: premiumMonitors,
							dataIndex: "PremiumMonitors",
							id: "premiumMspId",
							flex: 1,
							renderer: function(e, b, a, g, d, c, f)
							{
								var value = e;
								value = (value.indexOf("#") > -1) ? value.substring(0,value.indexOf("#")) : value;
								return value;
							}
						},
						{
							text: networkDevices,
							dataIndex: "NetworkDevices",
							id: "networkMspId",
							flex: 1,
							renderer: function(e, b, a, g, d, c, f)
							{
								var value = e;
								value = (value.indexOf("#") > -1) ? value.substring(0,value.indexOf("#")) : value;
								return value;
							}
						},
						{
							text: UserBased,
							dataIndex: 'UserBased',
							id: "userBasedMspId",
							flex: 1,
							renderer: function(e, b, a, g, d, c, f)
							{
								var value = e;
								value = (value.indexOf("#") > -1) ? value.substring(0,value.indexOf("#")) : value;
								return value;
							}
						},
						{
							text: UserCount,
							dataIndex: 'UserCount',
							id: "userCountMspId",
							flex: 1,
							renderer: function(e, b, a, g, d, c, f)
							{
								var value = e;
								value = (value.indexOf("#") > -1) ? value.substring(0,value.indexOf("#")) : value;
								return value;
							}
						}
					],
					tbar: [
						{ 
							xtype: 'tbfill' 
						},
						{
							xtype: 'trigger',
							name:'searchbox',
							id:'searchbox',
							trigger1Cls: 'x-form-clear-trigger',
							trigger2Cls: 'x-form-search-trigger', 
							cls: 'whitedropdown_search',
							emptyText: searchLbl,
							onTrigger1Click: function() {
								this.reset();
							},
							onTrigger2Click: function() {
								egTitleSearch();
							},
							listeners :
							{
								change : function(field, newVal)
								{
									egTitleSearch();
								},
								specialkey: function(field, e){
									// e.HOME, e.END, e.PAGE_UP, e.PAGE_DOWN,
									// e.TAB, e.ESC, arrow keys: e.LEFT, e.RIGHT, e.UP, e.DOWN
									if (e.getKey() == e.ENTER) {
										egTitleSearch();
									}
								}
							},
							getTriggerMarkup: function() {
								var me = this,
								i = 0,
								hideTrigger = (me.readOnly || me.hideTrigger),
								triggerCls,
								triggerBaseCls = me.triggerBaseCls,
								triggerConfigs = [],
								unselectableCls = Ext.dom.Element.unselectableCls,
								style = 'width:' + me.triggerWidth-20 + 'px;' + (hideTrigger ? 'display:none;' : ''),
								cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
								// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
								// single triggerCls config. Should rethink this, perhaps something more structured like a list of
								// trigger config objects that hold cls, handler, etc.
								// triggerCls is a synonym for trigger1Cls, so copy it.
								if (!me.trigger1Cls) {
									me.trigger1Cls = me.triggerCls;
								}
								// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
								for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
									if (i == 0)
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'MyTrigger_'+me.id+'_'+i,
											style: style + "display:none;",
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										});
									}
									else
									{
										triggerConfigs.push({
											tag: 'td',
											role: 'presentation',
											valign: 'top',
											cls: cls,
											id : 'MyTrigger_'+me.id+'_'+i,
											style: style,
											cn: {
												cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
												role: 'presentation'
											}
										});
									}
								}
								triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
								return Ext.DomHelper.markup(triggerConfigs);
							},
							disabled: false
						},
						{
							xtype: 'toolbar',
							ui: 'footer',
							items:[
								{
									xtype: 'button',
									text: deleteAllBtn,
									cls:'button20',
									id: 'setAllToDefaultBtnMSP',
									tooltip: 'Delete license limit for all'
								}
							]
						},
						{
							xtype: 'button',
							id : 'nodeExpand',
							iconCls: 'iconExpandAll',
							hidden:true,
							tooltip: 'Expand all',
							style: {
								background: 'none',
								border: '0px'
							},
							listeners: {
								'click':function(obj){
									this.hide();
									Ext.getCmp('nodeCollapse').show();
									Ext.getCmp('unameTree').expandAll();
								}
							}
						},
						{
							xtype:'button',
							id :'nodeCollapse',
							iconCls: 'iconCollapseAll',
							hidden:false,
							tooltip: 'Collapse all',
							style: {
								background: 'none',
								border: '0px'
							},
							listeners:{
								'click':function(obj){
									this.hide();
									Ext.getCmp('nodeExpand').show();
									Ext.getCmp('unameTree').collapseAll();
								}
							}
						}
					],
					listeners: {
						afterrender : function()
						{
							Ext.getCmp('unameTree').addCls("gridSkin");
						}
					},
					clearFilter: function() {
						var view = this.getView();
						if (this.getRootNode())
						{
							this.getRootNode().cascadeBy(function(tree, view){
								var uiNode = view.getNodeByRecord(this);

								if(uiNode) {
									Ext.get(uiNode).setDisplayed('table-row');
								}
							}, null, [this, view]);

							//No data found message removal
							var elemNoData = Ext.getElementById('noDataFound');
							if (elemNoData)
							{
								elemNoData.style.display = "none";
							}
						}
					},
					filterBy: function(text, by) {
						this.clearFilter();

						var view = this.getView(),
							me = this,
							nodesAndParents = [];

						// Find the nodes which match the search term, expand them.
						// Then add them and their parents to nodesAndParents.
						if (this.getRootNode())
						{
							this.getRootNode().cascadeBy(function(tree, view){
								var currNode = this;
								if(currNode && currNode.data[by] && currNode.data[by].toString().toLowerCase().indexOf(text.toLowerCase()) > -1) {
									me.expandPath(currNode.getPath());

									while(currNode.parentNode) {
										nodesAndParents.push(currNode.id);
										currNode = currNode.parentNode;
									}
								}
							}, null, [me, view]);

							// Hide all of the nodes which aren't in nodesAndParents
							this.getRootNode().cascadeBy(function(tree, view){
								var uiNode = view.getNodeByRecord(this);
								if(uiNode && !Ext.Array.contains(nodesAndParents, this.id) && this.data.id != -1) {
									Ext.get(uiNode).setDisplayed('none');
								}
								
							}, null, [me, view]);

							//No data found message show
							if(Ext.isEmpty(nodesAndParents))
							{
								var elemNoData = Ext.getElementById('noDataFound');
								if (elemNoData == null || elemNoData === undefined)
								{
									Ext.DomHelper.append(Ext.get(view.id), {
										tag: 'div',
										style:{'height':'100%','width':'100%','textAlign':'center','display': 'table'}, 
										cls: 'new-div-cls', 
										id: 'noDataFound',
										html:LoadSearchAlert
									});
								}
								else
								{
									elemNoData.style.display = "table";
								}
							}
						}
					},
				},
				{
					xtype:"container",
					id: 'emptyCont',
					html:LoadAlert1
				}
			]
		}
	]
});

function egTitleSearch()
{
	var obj = Ext.getCmp("unameTree");
	var egTitleSearchStr = Ext.getCmp('searchbox').getValue();
	var firstId = 'MyTrigger_searchbox_0';
	var secondId = 'MyTrigger_searchbox_1';

	if (egTitleSearchStr == "" || egTitleSearchStr .length == 0)
	{
		Ext.get(firstId).setStyle('display','none');
		Ext.get(secondId).setStyle('display','block');
	}
	else
	{
		Ext.get(secondId).setStyle('display','none');
		Ext.get(firstId).setStyle('display','block');
	}
	if(egTitleSearchStr==null || egTitleSearchStr=="")
	{
		Ext.getCmp('unameTree').filterBy(egTitleSearchStr, 'UserID');
		//No data found message removal
		var elemNoData = Ext.getElementById('noDataFound');
		if (elemNoData)
		{
			elemNoData.style.display = "none";
		}
	}
	else
	{
		Ext.getCmp('unameTree').filterBy(egTitleSearchStr, 'UserID');
	}
}

