Ext.define('UserProfile.controller.Main', {
    extend: 'Ext.app.Controller',
    views: ['Main'],
    refs: [{
        selector: 'main',
        ref: 'main'
    }, {
        selector: 'userdetails',
        ref: 'userdetails'
    }, {
        selector: 'alarmssettings',
        ref: 'alarmssettings'
    }, {
        selector: 'monitorsettings',
        ref: 'monitorsettings'
    },{
		selector:'dailyemailsettings',
		ref:'dailyemailsettings'
	}],
    init: function () {
		thisCtrl = this;
        this.control({

            'main': {
				'afterrender': this.userProfileDefaultLoad
            },
            'alarmssettings button[action=view]': {
                click: this.viewData
            },
           /*'alarmssettings button[id=high]': {
                click: this.checkAlarmType
            },
            'alarmssettings button[id=medium]': {
                click: this.checkAlarmType
            },
            'alarmssettings button[id=low]': {
                click: this.checkAlarmType
            },*/
			 'monitorsettings button[action=daily_mail]': {
                click: this.openDailyMail
            },
            'monitorsettings button[action=save]': {
                click: this.saveData
            },
            'monitorsettings button[action=mailFilter]': {
                click: this.showMailFilter
            },
            'monitorsettings combo[id=loginpage]': {
                select: this.loginLogo
            },
            'monitorsettings combo[id=monitorpage]': {
                select: this.monitorLogo
            },
            'monitorsettings combo[id=reporter]': {
                select: this.reporterLogo
            },
            'monitorsettings combo[id=configuration]': {
                select: this.configLogo
            },
            'monitorsettings button[action="loginFile"]': {
                click: this.showuploadlogin
            },
            'monitorsettings button[action="monitorFile"]': {
                click: this.showuploadmon
            },
            'monitorsettings button[action="reportFile"]': {
                click: this.showuploadreport
            },
            'monitorsettings button[action="configFile"]': {
                click: this.showuploadconfig
            },
            'monitorsettings checkbox[id="apply"]': {
                change: this.applyToModule
            },
            'alarmssettings radio[id="htmode"]': {
                change: this.setMeasureInMailMode
            },
			'userdetails textfield[id="newPwd"]':
			{
				'change': this.passStrength
            },
			'alarmssettings radio[id="isnew"]': {
                change: this.setDDInMailMode
            },
			'dailyemailsettings scrollcombo[id="applied_by"]':{
				'change':this.loadDmsDetails
			},
			'dailyemailsettings scrollcombo[id="temp_name"]':{
				'select':this.loadEmailTypes
			},
			'dailyemailsettings button[id="sm_button"]':{
				'click':this.insertDmdDeatils
			},
			'dailyemailsettings multiselectfield[id="el_component"]':{
				'change':this.loadDmsCompDetails
			},
			// 2fa
			'monitorsettings radio[id="enable2FAYesFlag"]': {
				change: this.show2FAOTPModeCnt
			},
			// 2fa
			'monitorsettings checkbox[id="defaulttimeZone"]': {
                		'change': this.setDefaulttimeZone
            		},
        });
    },
	setDefaulttimeZone:function(checkbox)
	{
		var timeZoneCombo=Ext.getCmp('timeZone');
		timeZoneCombo.getStore().loadRawData('');
		timeZoneCombo.getStore().loadRawData(publicJsonData['timeZone']);
		if(checkbox != null && checkbox != undefined && checkbox != 'undefined' && checkbox.checked )
		{
			var managerTimeZone = publicJsonData['managerTimeZone'];
			if(managerTimeZone != '' && managerTimeZone != null && managerTimeZone != undefined && managerTimeZone != 'undefined')
			{			
				timeZoneCombo.setValue(publicJsonData['managerTimeZone']);
				timeZoneCombo.setDisabled(true);
			}
		}
		else if(!checkbox.checked)
		{			
			timeZoneCombo.setValue(publicJsonData['selectedTimeZone']);
			timeZoneCombo.setDisabled(false);
		}
	},
	insertDmdDeatils:function(){

		var schedName = Ext.getCmp('schedName').getValue();
		if(schedName == null || schedName == undefined || schedName=="")
		{
			Ext.MessageBox.show({
				title : pageTitle,
				msg : 'Enter a report Name',
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING,
			});
			return;
		}

		var appliesTo = Ext.getCmp('appliesTo').getValue();
		if(appliesTo == null || appliesTo == undefined || appliesTo=="" || appliesTo=="-1")
		{
			Ext.MessageBox.show({
				title : pageTitle,
				msg : 'Select valid Applies To ',
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING,
			});
			return;
		}
		
		if(appliesTo == 'Components')
		{
			var compObj = Ext.getCmp('el_component').getValue();
			if(compObj == null || compObj == undefined || compObj=="" || compObj.length == 0)
			{
				Ext.MessageBox.show({
					title : pageTitle,
					msg : 'Select valid '+appliesTo,
					buttons : Ext.MessageBox.OK,
					icon : Ext.MessageBox.WARNING,
				});
				return;
			}
		}
		else
		{
			var applied_by = Ext.getCmp('applied_by').getValue();
			if(applied_by == null || applied_by == undefined || applied_by=="" || applied_by.indexOf("All") !=-1 || applied_by.indexOf("Select") != -1)
			{
				Ext.MessageBox.show({
					title : pageTitle,
					msg : 'Select valid '+appliesTo,
					buttons : Ext.MessageBox.OK,
					icon : Ext.MessageBox.WARNING,
				});
				return;
			}
		}

		var temp_name = Ext.getCmp('temp_name').getValue();
		if(temp_name == null || temp_name == undefined || temp_name=="" || temp_name.toLowerCase().indexOf("select a template") != -1)
		{
			Ext.MessageBox.show({
				title : pageTitle,
				msg : 'Select valid Template Name',
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING,
			});
			return;
		}

		var email_type = Ext.getCmp('email_type').getValue();
		if(email_type == null || email_type == undefined || email_type=="" || email_type.toLowerCase().indexOf("select a email type") != -1)
		{
			Ext.MessageBox.show({
				title : pageTitle,
				msg : 'Select valid Email Type',
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING,
			});
			return;
		}
		
		var mailIdVal = Ext.getCmp('mailId').getValue();
		
		if(mailIdVal == null || mailIdVal == undefined || mailIdVal=="")
		{
			Ext.MessageBox.show({
				title : pageTitle,
				msg : 'Enter a valid Mail ID',
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING,
			});
			return;
		}

		if(!mailIdValidate(mailIdVal)){
			Ext.MessageBox.show({
				title : pageTitle,
				msg : 'Enter a valid Mail ID',
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING,
			});
			return;
		}
		var mail_type = Ext.getCmp('mail_type').getValue();
		
		var app_value = appliesTo+":"+applied_by;
		if(appliesTo == 'Components')
		{
			var compObj = Ext.getCmp('el_component').getValue();
			var selectedVal = '';
			for (var a in compObj )
			{
				selectedVal +=","+compObj[a];
			}
			if(selectedVal.indexOf(",")==0)
				selectedVal = selectedVal.substring(1);
			
			app_value = appliesTo+":"+selectedVal;
		}

		var timeval=Ext.getCmp('sc_hr').getValue()+":"+Ext.getCmp('sc_min').getValue();
		
		var op = 'add';
		var op_type=Ext.getCmp('sm_button').getText();
		if(op_type.indexOf("Update") != -1)
			op="edit";

		var url='/final/admin/UserProfile/data/userProfileDailyMail.jsp?insertDms=true&op='+op+'&schedName='+encodeURI(schedName)+'&temp_name='+encodeURI(temp_name)+'&app_value='+encodeURI(app_value)+'&mailIdVal='+encodeURI(mailIdVal)+'&email_type='+email_type+'&timeval='+encodeURI(timeval)+"&mail_type="+encodeURI(mail_type);
		Ext.Ajax.request({
			url: url,
			scope: this,
			success: function (response) {
				if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					if(jsonData.status == 'success'){
						Ext.MessageBox.show({
							title : pageTitle,
							msg : 'Schedule Updated Successfully..',
							buttons : Ext.MessageBox.OK,
							icon : Ext.MessageBox.WARNING,
						});
						var tempGrid = Ext.getCmp('listGrid');
						var grid = jsonData.grid;
						var dbGridStore=Ext.create('Ext.data.Store',{
							fields:grid.fields,
							autoDestroy:true,
							proxy: {
								type: 'memory',
								reader: {
									type: 'json',
									root:'items'
								}
							},
							data:grid.data
						});
						tempGrid.reconfigure(dbGridStore,grid.columns);
						
						Ext.getCmp('sm_button').setText('<span class="font_bold"> Add </span>');
						Ext.getCmp('schedName').reset();
						//Ext.getCmp('dms_container_in').setDisabled(true);
						var appliesTo =  Ext.getCmp('appliesTo');
						appliesTo.reset();
						Ext.getCmp('applied_by').reset();
						Ext.getCmp('el_component').reset();
						Ext.getCmp('temp_name').reset();
						Ext.getCmp('email_type').reset();
						Ext.getCmp('sc_hr').reset();
						Ext.getCmp('sc_min').reset();
						Ext.getCmp('mailId').reset();

						Ext.getCmp('sc_hr').setValue("00");
						Ext.getCmp('sc_min').setValue("00");

						var value1 = appliesTo.getStore().getAt(1).get('valueField');
						appliesTo.setValue(value1);

					}else{
						Ext.MessageBox.show({
							title : pageTitle,
							msg : jsonData.status,
							buttons : Ext.MessageBox.OK,
							icon : Ext.MessageBox.WARNING,
						});
						return;
					}
				}
				editSuspend=false;
				if(editGridName != null && editGridName != undefined && editGridName != '' && jsonData.state != undefined && jsonData.state=='true')
				{
					deleteGridRow(editGridName);
					editGridName = undefined;
				}
			}
		});
	},
	loadEmailTypes:function(combo){
		//alert('dasad'+editValueSuspend)
		//if(editValueSuspend)
		//	return;
		var val = combo.getValue();
		if(val != undefined && val != null && val != -1){
			var value= combo.getValue();
			var appliesTo = Ext.getCmp('appliesTo').getValue();
			var applied_by = Ext.getCmp('applied_by').getValue();
			var addParam="&appliesTo="+appliesTo+"&applied_by="+applied_by;
			Ext.Ajax.request({
				url:'/final/admin/UserProfile/data/userProfileDailyMail.jsp?loadEmailTemplateTypes=true&template='+value+addParam,
				scope:this,
				success: function (response) {
					if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						if(jsonData != undefined && jsonData.elements != undefined && jsonData.elements.length > 0){
							var el = jsonData.elements;
							Ext.getCmp('email_type').getStore().loadRawData(el);
							var value1 = Ext.getCmp('email_type').getStore().getAt(0).get('valueField');
							Ext.getCmp('email_type').setValue(value1);

							if(el.length == 1)
								Ext.getCmp('email_type').setDisabled(true);
							else
								Ext.getCmp('email_type').setDisabled(false);

						}
					}
				}
			});
		}
	},
	loadDmsCompDetails:function(combo){
		if(editValueSuspend)
			return;
		try
		{
			var compObj = Ext.getCmp('el_component').getValue();
			var appliesTo = Ext.getCmp('appliesTo').getValue();
			if(!Ext.isEmpty(compObj))
			{
				var value = compObj[0];
				var email_type = value.substring(0,value.indexOf(":"));
				Ext.getCmp('email_type').setValue(email_type);
				Ext.getCmp('email_type').setDisabled(true);
				Ext.getCmp('email_type').setVisible(false);
				Ext.getCmp('dms_container_in').updateLayout();

				var span_el = document.getElementById('view_temp_id');
			
				Ext.Ajax.request({
					url:'/final/admin/UserProfile/data/userProfileDailyMail.jsp?loadTemplates=true&appliesTo='+appliesTo+'&value='+value,
					scope:this,
					success: function (response) {
						if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
							var jsonText = response.responseText;
							var jsonData = Ext.decode(jsonText);
							if(jsonData != undefined && jsonData.elements != undefined){
								var elements = jsonData.elements;
								Ext.getCmp('temp_name').getStore().loadRawData(elements);
								var value1 = Ext.getCmp('temp_name').getStore().getAt(0).get('valueField');
								Ext.getCmp('temp_name').setValue(value1);
								//span_el.style.display='inline-block';
								this.loadEmailTypes(Ext.getCmp('temp_name'));
							}else{
								//span_el.style.display='none';
								Ext.getCmp('temp_name').getStore().loadRawData('');
								Ext.getCmp('temp_name').setRawValue('Select a template');
								Ext.getCmp('email_type').getStore().loadRawData('');
								Ext.getCmp('email_type').setRawValue('Select a email type');
								Ext.getCmp('email_type').setDisabled(false);
								//if(value.toLowerCase().indexOf('please') ==-1)
								//	Ext.Msg.alert('','Predefined templates are not available for this type.' );
							}
						}
					},
					failure:function(){

					}
				});
			}
		}
		catch (e)
		{
		}
		
	},
	loadDmsDetails:function(combo){
		if(editValueSuspend)
			return;
		var val = combo.getValue();
		if(val != undefined && val != null && val != -1){
			var value= combo.getValue();
			if(value=='All')
				return;
			var rawvalue= combo.getRawValue();
			var appliesTo = Ext.getCmp('appliesTo').getValue();
			
			if(appliesTo != null && appliesTo != undefined && appliesTo=='ComponentType')
			{
				Ext.getCmp('email_type').setValue(value);
				Ext.getCmp('email_type').setDisabled(true);
				Ext.getCmp('email_type').setVisible(false);
				Ext.getCmp('dms_container_in').updateLayout();
			}
			else
			{
				Ext.getCmp('email_type').setVisible(true);
				Ext.getCmp('dms_container_in').updateLayout();
			}


			var span_el = document.getElementById('view_temp_id');
			
			Ext.Ajax.request({
				url:'/final/admin/UserProfile/data/userProfileDailyMail.jsp?loadTemplates=true&appliesTo='+appliesTo+'&value='+value,
				scope:this,
				success: function (response) {
					if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						if(jsonData != undefined && jsonData.elements != undefined){
							var elements = jsonData.elements;
							Ext.getCmp('temp_name').getStore().loadRawData(elements);
							var value1 = Ext.getCmp('temp_name').getStore().getAt(0).get('valueField');
							Ext.getCmp('temp_name').setValue(value1);
							//span_el.style.display='inline-block';
							this.loadEmailTypes(Ext.getCmp('temp_name'));
						}else{
							//span_el.style.display='none';
							Ext.getCmp('temp_name').getStore().loadRawData('');
							Ext.getCmp('temp_name').setRawValue('Select a template');
							Ext.getCmp('email_type').getStore().loadRawData('');
							Ext.getCmp('email_type').setRawValue('Select a email type');
							Ext.getCmp('email_type').setDisabled(false);
							//if(value.toLowerCase().indexOf('please') ==-1)
							//	Ext.Msg.alert('','Predefined templates are not available for this type.' );
						}
					}
				},
				failure:function(){

				}
			});
		}
	},
	openDailyMail:function(combo){
		var dew = Ext.getCmp('dailyEmailWin');
		if(dew == null || dew == undefined){
			try
			{
				Ext.Ajax.request({
					url:'/final/admin/UserProfile/data/userProfileDailyMail.jsp?loadAll=true',
					scope:this,
					success: function (response) {
						if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
							var jsonText = response.responseText;
							var jsonData = Ext.decode(jsonText);
							Ext.create('UserProfile.view.dailyEmailWin').show();
							Ext.getCmp('applied_by').reset();
							Ext.getCmp('temp_name').reset();
							Ext.getCmp('email_type').reset();

							if(jsonData != undefined && jsonData.data != undefined){
								Ext.getCmp('dailyemailsettings').data=jsonData;
								var data =jsonData.data;
								var allInfo =jsonData.allInfo;
								if(allInfo.hr != null && allInfo.hr !=undefined)
									Ext.getCmp('sc_hr').getStore().loadRawData(allInfo.hr);
								if(allInfo.min != null && allInfo.min !=undefined)
									Ext.getCmp('sc_min').getStore().loadRawData(allInfo.min);
								
								Ext.getCmp('sc_hr').setValue('00');
								Ext.getCmp('sc_min').setValue('00');

								var combo = data['final'];
								if(combo != null && combo != undefined && combo.length > 0){
									var appliesTo = Ext.getCmp('appliesTo');
									if(appliesTo != null && appliesTo != undefined ){
										appliesTo.getStore().loadRawData(combo);
										var value1 = appliesTo.getStore().getAt(1).get('valueField');
										appliesTo.setValue(value1);
									}
								}
								
								var mail_type = Ext.getCmp('mail_type');
								if(mail_type != null && appliesTo != undefined ){
									mail_type.getStore().loadRawData(jsonData.type);
									var value1 = mail_type.getStore().getAt(0).get('valueField');
									mail_type.setValue(value1);
								}

								var tempGrid = Ext.getCmp('listGrid');
								var grid = jsonData.grid;
								var dbGridStore=Ext.create('Ext.data.Store',{
									fields:grid.fields,
									autoDestroy:true,
									proxy: {
										type: 'memory',
										reader: {
											type: 'json',
											root:'items'
										}
									},
									data:grid.data
								});
								tempGrid.reconfigure(dbGridStore,grid.columns);
							}
						}
					}
				});
			}
			catch (e)
			{
			}
		}
	},
	setDDInMailMode : function() {
		var typeVal = Ext.getCmp('isnew').getValue();
		if(typeVal == true || typeVal == 'true')
			Ext.getCmp('ddmail').setVisible(true);
		else
			Ext.getCmp('ddmail').setVisible(false);


	},
	showMailFilter : function() {
		var uName = publicJsonData['hiddenParams']['uname'];
		var showAlert = publicJsonData['isMailConfigured'];
		var showMailFilterBtn = publicJsonData['showMailFilterBtn'];

		window.location.href =  "EgMailAlertFilter.jsp?qctr=1&username="+encodeURIComponent(uName)+"&showAlert="+showAlert
	},
	passStrength: function()
	{
		var pwdLength = publicJsonData.pwdLength;
		var pwdComplexityLength = publicJsonData.pwdComplexityCount;
		if (pwdLength == "" || pwdLength < 2)
		{
			pwdLength = 8;
		}
		else if(pwdLength != "" && pwdLength < pwdComplexityLength)
		{
			pwdLength = pwdComplexityLength;
		}
		var loginPassword = Ext.getCmp('newPwd').getValue();
		var regExp = /^(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?=.*[^\da-zA-Z]).+$/;
		var regExp2 = /^(?=.*\d)(?=.*[a-zA-Z])(?=.*[^\da-zA-Z]).+$/;
		var regExp3 = /^(?=.*\d)(?=.*[a-zA-Z]).+$/;
		if (loginPassword.length >= pwdLength && regExp.test(loginPassword))
		{
			Ext.getCmp('passScore').setText(passStr+': '+Strong);
		}
		else if(loginPassword.length >= pwdLength && loginPassword.match(regExp2))
		{
			Ext.getCmp('passScore').setText(passStr+': '+Good);
		}
		else if(loginPassword.length >= pwdLength && loginPassword.match(regExp3))
		{
			Ext.getCmp('passScore').setText(passStr+': '+Fair);
		}
		else if (loginPassword.length == 0)
		{
			Ext.getCmp('passScore').setText(passLabel1+" "+pwdLength+" "+passLabel2);
		}
		else
		{
			Ext.getCmp('passScore').setText(passStr+': '+Weak);
		}
	},
	pwdComplexityCheck : function(loginPassword)
	{
		var _start = "^";
		var _mid = "";
		var _end = ".+$";
		var result = "";
		var dot = ".";
		var brk = "<br/>";
		var pwdComplexity = publicJsonData.pwdComplexity;
		if(pwdComplexity != null && pwdComplexity != undefined)
		{
			if(pwdComplexity.indexOf(",") > -1)
			{
				result = "false#";
				var pwdComplexVal = pwdComplexity.split(",");
				for(var k=0; k<pwdComplexVal.length; k++)
				{
					var temp = pwdComplexVal[k].toLowerCase().trim();
					if(temp == "lc")
					{
						_mid += "(?=.*[a-z])";
						result += brk+(k+1)+dot+" "+alertForPwdComplexity1;
					}
					else if(temp == "uc")
					{
						_mid += "(?=.*[A-Z])";
						result += brk+(k+1)+dot+" "+alertForPwdComplexity2;
					}
					else if(temp == "dg")
					{
						_mid += "(?=.*[0-9])";
						result += brk+(k+1)+dot+" "+alertForPwdComplexity3;
					}
					else if(temp == "sp")
					{
						_mid += "(?=.*[^0-9a-zA-Z])";
						result += brk+(k+1)+dot+" "+alertForPwdComplexity4;
					}
				}
			}
			else
			{
				result = "false#";
				var temp = pwdComplexity.toString().toLowerCase().trim();
				if(temp == "lc")
				{
					_mid += "(?=.*[a-z])";
					result +=  alertForPwdComplexity1;
				}
				else if(temp == "uc")
				{
					_mid += "(?=.*[A-Z])";
					result +=  alertForPwdComplexity2;
				}
				else if(temp == "dg")
				{
					_mid += "(?=.*[0-9])";
					result +=  alertForPwdComplexity3;
				}
				else if(temp == "sp")
				{
					_mid += "(?=.*[^0-9a-zA-Z])";
					result +=  alertForPwdComplexity4;
				}
			}
			var regExp = new RegExp(_start + _mid + _end);
			if(regExp.test(loginPassword))
			{
				result = "true";
			}
		}
		return result;
	},
	userProfileDefaultLoad: function () {
		this.getUserdetails().loadDefaultData();
		this.getAlarmssettings().loadalrmData();
		this.getMonitorsettings().loadmonitorData();
		//this.checkAlarms();
		this.hideCustomLogo();
		this.applyToModule();
		var pwdLength = publicJsonData.pwdLength;
		var pwdComplexityLength = publicJsonData.pwdComplexityCount;
		if (pwdLength == "" || pwdLength < 2)
		{
			pwdLength = 8;
		}
		else if(pwdLength != "" && pwdLength < pwdComplexityLength)
		{
			pwdLength = pwdComplexityLength;
		}
		Ext.getCmp('passScore').setText(passLabel1+" "+pwdLength+" "+passLabel2);
		if (publicJsonData.showMailFilterBtn)
		{
			Ext.getCmp('mailFilterBtn').show();
		}
		else
		{
			Ext.getCmp('mailFilterBtn').hide();
		}
		
		try
		{
			var dmsData = publicJsonData.dmsSchedules;
			var compObj = Ext.getCmp('emailType');
			if(compObj != null && compObj != undefined && dmsData != null && dmsData != undefined && dmsData.length > 0){
				compObj.getStore().loadRawData(dmsData);
				compObj.setValue("-1");
			}
		}
		catch (e)
		{
		}

	},

    checkAlarmType: function (button) {

        var highstate = Ext.getCmp('high').pressed;
        var mediumstate = Ext.getCmp('medium').pressed;
        var lowstate = Ext.getCmp('low').pressed;

        if (highstate == false && mediumstate == false && lowstate == false) {
            Ext.getCmp('isnew').setValue(false);
            Ext.getCmp('iscomp').setValue(false);
            Ext.getCmp('htmode').setValue(false);
            Ext.getCmp('txtmode').setValue(false);
        }


    },

    checkAlarms: function () {

        if (Ext.getCmp('high').pressed != null && Ext.getCmp('medium').pressed != null && Ext.getCmp('low').pressed != null && Ext.getCmp('isnew').checked != null && Ext.getCmp('iscomp').checked != null) {
            if (!Ext.getCmp('high').pressed && !Ext.getCmp('medium').pressed && !Ext.getCmp('low').pressed) {
                Ext.getCmp('isnew').setValue(true);
                Ext.getCmp('htmode').setValue(true);
            }
        }
    },

    setMeasureInMailMode: function () {
        var htmodeVal = Ext.getCmp('htmode').getValue();
        var messagemodeObj = Ext.getCmp('measuremode');
        if (htmodeVal == true) {
            messagemodeObj.getStore().loadRawData(publicJsonData['reportOptionsht']);
        } else {
            messagemodeObj.getStore().loadRawData(publicJsonData['reportOptionstxt']);
            messagemodeObj.setValue("No");

        }
    },

    hideCustomLogo: function () {
        var loginLo = publicJsonData['loginChk'];
        var monLo = publicJsonData['monLo'];
        var reportLo = publicJsonData['reportLo'];
        var configLo = publicJsonData['configLo'];

        if (loginLo == "d") {
            var loginFile = Ext.getCmp('loginFile');
            loginFile.hide();
        }
        if (monLo == "d") {
            var monitorFile = Ext.getCmp('monitorFile');
            monitorFile.hide();
        }
        if (reportLo == "d") {
            var reportFile = Ext.getCmp('reportFile');
            reportFile.hide();
        }
        if (configLo == "d") {
            var configFile = Ext.getCmp('configFile');
            configFile.hide();
        }
    },
    applyToModule: function () {


        var logoCheck = Ext.getCmp('apply').checked;

        if (logoCheck == true && (publicJsonData['hasAdminTab']==true || publicJsonData['hasMonitorTab']==true)) {
            var reporter = Ext.getCmp('reporter');
            reporter.hide();
            var reportFile = Ext.getCmp('reportFile');
            reportFile.hide();
            var configuration = Ext.getCmp('configuration');
            configuration.hide();
            var configFile = Ext.getCmp('configFile');
            configFile.hide();
        } else {
			Ext.getCmp('reporter_container').show();
            if(publicJsonData['hasReporterTab']==true){
            var reporter = Ext.getCmp('reporter');
            reporter.show();
				var reportLo = publicJsonData['reportLo'];
				if (reportLo != "d") {
					Ext.getCmp('reportFile').show();
			}	
			}	
			if(publicJsonData['hasConfigTab']==true){
            var configuration = Ext.getCmp('configuration');
            configuration.show();
				var configLo = publicJsonData['configLo'];
				if (configLo != "d") {
					Ext.getCmp('configFile').show();
				}
			}
        }
    },

    loginLogo: function (perform) {

        var perform = Ext.getCmp('loginpage').getValue();
       // var loginFile = Ext.getCmp('loginFile');
        if (perform == "Default") {


            Ext.getCmp('loginFile').hide();

        } else {

            Ext.getCmp('loginFile').show();
        }
    },
    monitorLogo: function (perform) {
        var perform = Ext.getCmp('monitorpage').getValue();
        if (perform == "Default") {

  Ext.getCmp('monitorFile').hide();


        } else {
		Ext.getCmp('monitorFile').show();

        }
    },
    reporterLogo: function (perform) {
        var perform = Ext.getCmp('reporter').getValue();

        if (perform == "Default") {
  Ext.getCmp('reportFile').hide();


        } else {
		Ext.getCmp('reportFile').show();

        }
    },
    configLogo: function (perform) {
        var perform = Ext.getCmp('configuration').getValue();


        if (perform == "Default") {

             Ext.getCmp('configFile').hide();

        } else {
			Ext.getCmp('configFile').show();

        }
    },

    viewData: function () {

        var command = Ext.getCmp('Cmd').getValue();

        if (command == "") {
            Ext.Msg.show({
                title: pageTitle,
                msg: 'command field is empty',
                buttons: Ext.Msg.OK,
                icon: Ext.Msg.WARNING
            });


        } else {
            var me = this;
            Ext.widget('window', {
                //title: 'Edit Command',
                closeAction: 'destroy',
                width: 400,
                height: 300,
				padding:'5 10 10 10',
                id: 'ecmd',
                name: 'ecmd',
				title:'command',
                resizable: 'false',
				buttonAlign:'center',
				modal:true,
				listeners: {
					show: function(win) {
					if (this.modal) {
						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.fly(dom[0]);
						el.addCls('windowModal');
					}
					},
					 hide:  function(win) {
					if (this.modal) {
						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.fly(dom[0]);
						el.removeCls('windowModal');
					}
					},
					afterrender: function () {
						Ext.EventManager.onWindowResize(function () {
							var me = this;
							me.center();
						}, this);
					}
				},
                items: [{
                    //fieldLabel: 'Command',
                    labelSeparator: '',
                    xtype: 'textareafield',
                    width: '100%',
                    height: 234,
                    id: 'commd',
					margin:0,
                    name: 'commd',
                    labelAlign: 'top',
                    cls: 'text-area',
				}],
				buttons:[{
                    xtype: 'button',
                    text: 'Apply',
                    id: 'app',
                    name: 'app',
                    action: 'app',
                    cls:'quickMenuWhiteButton',
                    align: 'center',
					handler: function (button, e)
					{
						var customscrpt = Ext.getCmp('commd').getValue();
						var comd = Ext.getCmp('Cmd');
						comd.setValue(customscrpt);

						button.up('.window').close();
					}
                }]

            }).show()
            Ext.getCmp('commd').setValue(command);
        }
    },   
    
	showuploadlogin: function (button) 
	{
		var me = this;
		Ext.widget('window', {
			title: 'Files to be uploaded',
			id: 'file',
			name: 'file',
			width: 350,
			height: 200,
			padding:'5 10 10 10',
			resizable: 'false',
			modal:true,
			listeners: {
				show: function(win) 
				{
					if (this.modal) {

						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.fly(dom[0]);
						el.addCls('windowModal');
					}
				},
				hide:  function(win) 
				{
					if (this.modal) {
						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.fly(dom[0]);
						el.removeCls('windowModal');
					}
				},
				afterrender: function () 
				{
					Ext.EventManager.onWindowResize(function () {
						var me = this;
						me.center();
					}, this);
				}
			},
			items: [
				{
					xtype: 'form',
					id: 'uploadform',
					name: 'uploadform',
					margin:10,
					items: [
						{
							xtype: 'fileuploadfield',
							cls: 'fileupload',
							id: 'FILE_0',
							name: 'FILE_0',
							labelSeparator: '',
							emptyText: 'Select a image to upload...',
							fieldLabel: 'Custom Logo',
							labelAlign: 'top',
							width: 290,
							buttonText: 'Browse',
						}, 
						{
							xtype: 'container',
							margin: '15 0 0 0',
							html: '<b>Specifications:</b> Type:GIF, JPEG, PNG, JPG;  Size:200KB;  Resolution:115x36pixels',
						}, 
						{
							xtype : 'hiddenfield',
							id : 'fileUploadURL'
						},
						{
							xtype : 'container',
							id : 'hiddenFieldsContainer'
						},
						{
							xtype: 'button',
							text: 'Upload',
							id: 'upload',
							name: 'upload',
							action: 'upload',
							cls: 'button20',
							align: 'center',
							margin: '15 0 0 140',
							handler: function (button, e) 
							{
								var form = Ext.getCmp('uploadform').getForm().findField('FILE_0').getValue()
								var fileUpload = 'yes';
								var fileExtension = form.substring((form.indexOf('.'))+1,form.length);
								var fileExt = 'gif/jpg/jpeg/png';
								var isUpload = false;
								var fromPage = "EgConfigLogoMsg.jsp";
								var uploadFor = "login";
								var caption_array = publicJsonData['caption_array'];
								var test = publicJsonData['test'];
								var installDir = publicJsonData['installDir'];
								var isDouble = publicJsonData['isDouble'];

								for (i = 0; i <= (form.length) - 1; i++)
								{
									if (isDouble == "false") 
									{
										if (!validateSingleByte(form)) {
											Ext.Msg.show({
												title: pageTitle,
												msg: fileDBL,
												buttons: Ext.Msg.OK,
												icon: Ext.Msg.WARNING
											});
											return false;
										}
									}
									if (form[i].length > 0)
									{
										isUpload = true;
									}
									if (fileExtension != 'gif' && fileExtension != 'jpg' && fileExtension != 'jpeg' && fileExtension != 'png') {

										if (caption_array.length > 1) 
										{
											Ext.Msg.show({
												title: pageTitle,
												msg: fileexten,
												buttons: Ext.Msg.OK,
												icon: Ext.Msg.WARNING
											});
											return false;
										} 
										else 
										{
											Ext.Msg.show({

												title: pageTitle,
												msg: fileNotWithReqExt + ": '" +fileExt+ "'",
												buttons: Ext.Msg.OK,
												icon: Ext.Msg.WARNING
											});
											return false;
										}
									}
								}

								var newFileName = 'manager/tomcat/webapps/final/admin/eg_images/logologin.'+fileExtension;
								var urlForFile = "../servlet/com.eg.EgFileUpload?title=Uploading Logo Files&dispCaption=Custom Logo&requestFrom=EgConfigLogoMsg.jsp&uploadFor=login&uploadDir="+newFileName+"&fileExt="+fileExtension+"&fileUpload="+fileUpload;
								logoPath = "manager/tomcat/webapps/final/admin/eg_images/";
								var uploadFor = "login";
								var uname = tempJsonData['UserId'];
								if (uname != '' && uname != undefined) 
								{
									var logoname = uname + "_" + uploadFor + "."+fileExtension;
									if (uname.indexOf("/") > -1 || uname.indexOf("(") > -1)
									{
										var domainName = uname.substring(0, uname.indexOf("/"));
										var userName = uname.substring(uname.indexOf("/") + 1, uname.length);
										if (userName.indexOf("(") > -1) 
										{
											userName = userName.substring(0, userName.indexOf("(") - 1);
										}
										if(domainName==null || domainName == "" )
										{
											logoname =  userName + "_" + uploadFor + "."+fileExtension;
										}
										else
										{
											logoname = domainName.toLowerCase() + "_" + userName + "_" + uploadFor + "."+fileExtension;
										}
									}
								}
								logoPath = logoPath+logoname;

								var fileuploadObj = Ext.getCmp('hiddenFieldsContainer');
								fileuploadObj.removeAll();
								var tmpHiddenElement = {
									xtype: 'hiddenfield',
									name : 'FILE_0_dstFile',
									value : logoPath
								}
								fileuploadObj.add(tmpHiddenElement);

								if (isUpload)
								{
									var uploadform = Ext.getCmp('uploadform');
									uploadform.submit({
										url: urlForFile,
										method: 'POST',
										success: function (form, action) 
										{
											Ext.Msg.alert('Status', 'Request has been processed successfully');

											tempJsonData.hiddenParams["loginImageStatus"] = "Uploaded";
											tempJsonData.hiddenParams["loginImageUploadStatusForAudit"] = "yes";

											button.up('.window').close();
										},
										failure: function (form, action) 
										{
											Ext.Msg.alert('Failed', 'failure');
										}
									});
								} 
								else 
								{
									Ext.Msg.show({
										title: pageTitle,
										msg: nofileselect,
										buttons: Ext.Msg.OK,
										icon: Ext.Msg.WARNING
									});
									return false;
								}
							}
						}
					],
					listeners: {
						afterrender: function () 
						{
							me.windowupload();
						},
					}
				}
			]
		}).show()
    },

	showuploadmon: function (button) 
	{
		var me = this;
		Ext.widget('window', {
			title: 'Files to be uploaded',
			id: 'file1',
			name: 'file1',
			width: 350,
			height: 200,
			padding:'5 10 10 10',
			resizable: 'false',
			modal:true,
			listeners: {
				show: function(win) 
				{
					if (this.modal) {

						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.fly(dom[0]);
						el.addCls('windowModal');
					}
				},
				hide:  function(win) 
				{
					if (this.modal) {
						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.fly(dom[0]);
						el.removeCls('windowModal');
					}
				},
				afterrender: function () 
				{
					Ext.EventManager.onWindowResize(function () {
						var me = this;
						me.center();
					}, this);
				}
			},
			items: [
				{
					xtype: 'form',
					id: 'uploadform',
					name: 'uploadform',
					margin:10,
					items: [
						{
							xtype: 'fileuploadfield',
							cls: 'fileupload',
							id: 'FILE_0',
							name: 'FILE_0',
							labelSeparator: '',
							emptyText: 'Select a image to upload...',
							fieldLabel: 'Custom Logo',
							labelAlign: 'top',
							width: 290,
							buttonText: 'Browse',
						}, 
						{
							xtype: 'container',
							margin: '15 0 0 0',
							html: '<b>Specifications:</b> Type:GIF, JPEG, PNG, JPG;  Size:200KB;  Resolution:115x36pixels',
						}, 
						{
							xtype : 'hiddenfield',
							id : 'fileUploadURL'
						},
						{
							xtype : 'container',
							id : 'hiddenFieldsContainer'
						},
						{
							xtype: 'button',
							text: 'Upload',
							id: 'upload',
							name: 'upload',
							action: 'upload',
							cls: 'button20',
							align: 'center',
							margin: '15 0 0 140',
							handler: function (button, e) 
							{
								var form = Ext.getCmp('uploadform').getForm().findField('FILE_0').getValue();
								var fileExtension = form.substring((form.indexOf('.'))+1,form.length);
								var fileUpload = 'yes';
								var fileExt = 'gif/jpg/jpeg/png';
								var isUpload = false;
								var fromPage = "EgConfigLogoMsg.jsp";
								var uploadFor = "monitor";
								var caption_array = publicJsonData['caption_array'];
								var test = publicJsonData['test'];
								var installDir = publicJsonData['installDir'];
								var isDouble = publicJsonData['isDouble'];

								for (i = 0; i <= (form.length) - 1; i++)
								{
									if (isDouble == "false") 
									{
										if (!validateSingleByte(form)) {
											Ext.Msg.show({
												title: pageTitle,
												msg: fileDBL,
												buttons: Ext.Msg.OK,
												icon: Ext.Msg.WARNING
											});
											return false;
										}
									}
									if (form[i].length > 0)
									{
										isUpload = true;
									}
									if (fileExtension != 'gif' && fileExtension != 'jpg' && fileExtension != 'jpeg' && fileExtension != 'png') {

										if (caption_array.length > 1) 
										{
											Ext.Msg.show({
												title: pageTitle,
												msg: fileexten,
												buttons: Ext.Msg.OK,
												icon: Ext.Msg.WARNING
											});
											return false;
										} 
										else 
										{
											Ext.Msg.show({

												title: pageTitle,
												msg: fileNotWithReqExt + ": '" +fileExt+ "'",
												buttons: Ext.Msg.OK,
												icon: Ext.Msg.WARNING
											});
											return false;
										}
									}
								}

								var newFileName = 'manager/tomcat/webapps/final/monitor/eg_images/logomonitor.'+fileExtension;
								var urlForFile = "../servlet/com.eg.EgFileUpload?title=Uploading Logo Files&dispCaption=Custom Logo&requestFrom=EgConfigLogoMsg.jsp&uploadFor=monitor&uploadDir="+newFileName+"&fileExt="+fileExtension+"&fileUpload="+fileUpload;
								logoPath = "manager/tomcat/webapps/final/monitor/eg_images/";
								var uploadFor = "monitor";
								var uname = tempJsonData['UserId'];
								if (uname != '' && uname != undefined) 
								{
									var logoname = uname + "_" + uploadFor + "."+fileExtension;
									if (uname.indexOf("/") > -1 || uname.indexOf("(") > -1)
									{
										var domainName = uname.substring(0, uname.indexOf("/"));
										var userName = uname.substring(uname.indexOf("/") + 1, uname.length);
										if (userName.indexOf("(") > -1) 
										{
											userName = userName.substring(0, userName.indexOf("(") - 1);
										}
										if(domainName==null || domainName == "" )
										{
											logoname =  userName + "_" + uploadFor + "."+fileExtension;
										}
										else
										{
											logoname = domainName.toLowerCase() + "_" + userName + "_" + uploadFor + "."+fileExtension;
										}
									}
								}
								logoPath = logoPath+logoname;

								var fileuploadObj = Ext.getCmp('hiddenFieldsContainer');
								fileuploadObj.removeAll();
								var tmpHiddenElement = {
									xtype: 'hiddenfield',
									name : 'FILE_0_dstFile',
									value : logoPath
								}
								fileuploadObj.add(tmpHiddenElement);

								if (isUpload)
								{
									var uploadform = Ext.getCmp('uploadform');
									uploadform.submit({
										url: urlForFile,
										method: 'POST',
										success: function (form, action) 
										{
											Ext.Msg.alert('Status', 'Request has been processed successfully');

											tempJsonData.hiddenParams["monitorImageStatus"] = "Uploaded";
											tempJsonData.hiddenParams["monitorImageUploadStatusForAudit"] = "yes";

											button.up('.window').close();
										},
										failure: function (form, action) 
										{
											Ext.Msg.alert('Failed', 'failure');
										}
									});
								} 
								else 
								{
									Ext.Msg.show({
										title: pageTitle,
										msg: nofileselect,
										buttons: Ext.Msg.OK,
										icon: Ext.Msg.WARNING
									});
									return false;
								}
							}
						}
					],
					listeners: {
						afterrender: function () 
						{
							me.windowupload();
						},
					}
				}
			]
		}).show()
	},

	showuploadreport: function (button) 
	{
		var me = this;
		Ext.widget('window', {
			title: 'Files to be uploaded',
			id: 'file1',
			name: 'file1',
			width: 350,
			height: 200,
			padding:'5 10 10 10',
			resizable: 'false',
			modal:true,
			listeners: {
				show: function(win) 
				{
					if (this.modal) 
					{
						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.fly(dom[0]);
						el.addCls('windowModal');
					}
				},
				hide:  function(win) 
				{
					if (this.modal) 
					{
						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.fly(dom[0]);
						el.removeCls('windowModal');
					}
				},
				afterrender: function () 
				{
					Ext.EventManager.onWindowResize(function () {
						var me = this;
						me.center();
					}, this);
				}
			},
			items: [
				{
					xtype: 'form',
					id: 'uploadform',
					name: 'uploadform',
					margin:10,
					items: [
						{
							xtype: 'fileuploadfield',
							cls: 'fileupload',
							id: 'FILE_0',
							name: 'FILE_0',
							labelSeparator: '',
							emptyText: 'Select a image to upload...',
							fieldLabel: 'Custom Logo',
							labelAlign: 'top',
							width: 290,
							buttonText: 'Browse',
						}, 
						{
							xtype: 'container',
							margin: '15 0 0 0',
							html: '<b>Specifications:</b> Type:GIF, JPEG, PNG, JPG;  Size:200KB;  Resolution:115x36pixels',
						}, 
						{
							xtype : 'hiddenfield',
							id : 'fileUploadURL'
						},
						{
							xtype : 'container',
							id : 'hiddenFieldsContainer'
						},
						{
							xtype: 'button',
							text: 'Upload',
							id: 'upload',
							name: 'upload',
							action: 'upload',
							cls: 'button20',
							align: 'center',
							margin: '15 0 0 140',
							handler: function (button, e) 
							{
								var form = Ext.getCmp('uploadform').getForm().findField('FILE_0').getValue()
								var fileExtension = form.substring((form.indexOf('.'))+1,form.length);
								var fileUpload = 'yes';
								var fileExt = 'gif/jpg/jpeg/png';
								var isUpload = false;
								var fromPage = "EgConfigLogoMsg.jsp";
								var uploadFor = "reporter";
								var caption_array = publicJsonData['caption_array'];
								var test = publicJsonData['test'];
								var installDir = publicJsonData['installDir'];
								var isDouble = publicJsonData['isDouble'];
								var isDomainUser1 = publicJsonData['isDomainUser'];
								for (i = 0; i <= (form.length) - 1; i++) 
								{
									if (!isDomainUser1 && isDouble == "false") 
									{
										if (!validateSingleByte(form)) 
										{
											Ext.Msg.show({
												title: pageTitle,
												msg: fileDBL,
												buttons: Ext.Msg.OK,
												icon: Ext.Msg.WARNING
											});
											return false;
										}
									}
									if (form[i].length > 0)
									{
										isUpload = true;
									}
									if (fileExtension != 'gif' && fileExtension != 'jpg' && fileExtension != 'jpeg' && fileExtension != 'png') 
									{
										if (caption_array.length > 1) 
										{
											Ext.Msg.show({
												title: pageTitle,
												msg: fileexten,
												buttons: Ext.Msg.OK,
												icon: Ext.Msg.WARNING
											});
											return false;
										} 
										else 
										{
											Ext.Msg.show({

												title: pageTitle,
												msg: fileNotWithReqExt + ": '" +fileExt+ "'",
												buttons: Ext.Msg.OK,
												icon: Ext.Msg.WARNING
											});
											return false;
										}
									}
								}

								var newFileName = 'manager/tomcat/webapps/final/reporter/images/logoreporter.'+fileExtension;
								var urlForFile = "../servlet/com.eg.EgFileUpload?title=Uploading Logo Files&dispCaption=Custom Logo&requestFrom=EgConfigLogoMsg.jsp&uploadFor=reporter&uploadDir="+newFileName+"&fileExt="+fileExtension+"&fileUpload="+fileUpload;                                 
								logoPath = "manager/tomcat/webapps/final/reporter/images/";
								var uploadFor = "reporter";
								var uname = tempJsonData['UserId'];
								if (uname != '' && uname != undefined) 
								{
									var logoname = uname + "_" + uploadFor + "."+fileExtension;
									if (uname.indexOf("/") > -1 || uname.indexOf("(") > -1)
									{
										var domainName = uname.substring(0, uname.indexOf("/"));
										var userName = uname.substring(uname.indexOf("/") + 1, uname.length);
										if (userName.indexOf("(") > -1) 
										{
											userName = userName.substring(0, userName.indexOf("(") - 1);
										}
										if(domainName==null || domainName == "" )
										{
											logoname =  userName + "_" + uploadFor + "."+fileExtension;
										}
										else
										{
											logoname = domainName.toLowerCase() + "_" + userName + "_" + uploadFor + "."+fileExtension;
										}
									}
								}
								logoPath = logoPath+logoname;

								var fileuploadObj = Ext.getCmp('hiddenFieldsContainer');
								fileuploadObj.removeAll();
								var tmpHiddenElement = {
									xtype: 'hiddenfield',
									name : 'FILE_0_dstFile',
									value : logoPath
								}
								fileuploadObj.add(tmpHiddenElement);

								if (isUpload) 
								{
									var uploadform = Ext.getCmp('uploadform');
									uploadform.submit({
										url: urlForFile,
										method: 'POST',
										success: function (form, action) 
										{
											Ext.Msg.alert('Status', 'Request has been processed successfully');
											tempJsonData.hiddenParams["reporterImageStatus"] = "Uploaded";
											tempJsonData.hiddenParams["reporterImageUploadStatusForAudit"] = "yes";
											button.up('.window').close();
										},
										failure: function (form, action) 
										{
											Ext.Msg.alert('Failed', 'failure');
										}
									});
								} 
								else 
								{
									Ext.Msg.show({
										title: pageTitle,
										msg: nofileselect,
										buttons: Ext.Msg.OK,
										icon: Ext.Msg.WARNING
									});
									return false;
								}
							}
						}
					],
					listeners: {
						afterrender: function () {
							me.windowupload();
						},
					}
				}
			]
			
		}).show()
	},

	showuploadconfig: function (button) 
	{
		var me = this;
		Ext.widget('window', {
			title: 'Files to be uploaded',
			id: 'file1',
			name: 'file1',
			width: 350,
			height: 200,
			padding:'5 10 10 10',
			resizable: 'false',
			modal:true,
			listeners: {
				show: function(win) 
				{
					if (this.modal) 
					{
						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.fly(dom[0]);
						el.addCls('windowModal');
					}
				},
				hide:  function(win) 
				{
					if (this.modal) 
					{
						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.fly(dom[0]);
						el.removeCls('windowModal');
					}
				},
				afterrender: function () 
				{
					Ext.EventManager.onWindowResize(function () {
						var me = this;
						me.center();
					}, this);
				}
			},
			items: [
				{
					xtype: 'form',
					id: 'uploadform',
					name: 'uploadform',
					margin:10,
					items: [
						{
							xtype: 'fileuploadfield',
							cls: 'fileupload',
							id: 'FILE_0',
							name: 'FILE_0',
							labelSeparator: '',
							emptyText: 'Select a image to upload...',
							fieldLabel: 'Custom Logo',
							labelAlign: 'top',
							width: 290,
							buttonText: 'Browse',
						}, 
						{
							xtype: 'container',
							margin: '15 0 0 0',
							html: '<b>Specifications:</b> Type:GIF, JPEG, PNG, JPG;  Size:200KB;  Resolution:115x36pixels',
						}, 
						{
							xtype : 'hiddenfield',
							id : 'fileUploadURL'
						},
						{
							xtype : 'container',
							id : 'hiddenFieldsContainer'
						},
						{
							xtype: 'button',
							text: 'Upload',
							id: 'upload',
							name: 'upload',
							action: 'upload',
							cls: 'button20',
							align: 'center',
							margin: '15 0 0 140',
							handler: function (button, e) 
							{
								var form = Ext.getCmp('uploadform').getForm().findField('FILE_0').getValue()
								var fileExtension = form.substring((form.indexOf('.'))+1,form.length);
								var fileUpload = 'yes';
								var fileExt = 'gif/jpg/jpeg/png';
								var isUpload = false;
								var fromPage = "EgConfigLogoMsg.jsp";
								var uploadFor = "config";
								var caption_array = publicJsonData['caption_array'];
								var test = publicJsonData['test'];
								var installDir = publicJsonData['installDir'];
								var isDouble = publicJsonData['isDouble'];
								var isDomainUser1 = publicJsonData['isDomainUser'];
								for (i = 0; i <= (form.length) - 1; i++) 
								{
									if (!isDomainUser1 && isDouble == "false") 
									{
										if (!validateSingleByte(form)) 
										{
											Ext.Msg.show({
												title: pageTitle,
												msg: fileDBL,
												buttons: Ext.Msg.OK,
												icon: Ext.Msg.WARNING
											});
											return false;
										}
									}
									if (form[i].length > 0)
									{
										isUpload = true;
									}
									if (fileExtension != 'gif' && fileExtension != 'jpg' && fileExtension != 'jpeg' && fileExtension != 'png') 
									{
										if (caption_array.length > 1) 
										{
											Ext.Msg.show({
												title: pageTitle,
												msg: fileexten,
												buttons: Ext.Msg.OK,
												icon: Ext.Msg.WARNING
											});
											return false;
										} 
										else 
										{
											Ext.Msg.show({

												title: pageTitle,
												msg: fileNotWithReqExt + ": '" +fileExt+ "'",
												buttons: Ext.Msg.OK,
												icon: Ext.Msg.WARNING
											});
											return false;
										}
									}
								}

								var newFileName = 'manager/tomcat/webapps/final/config/images/logoconfig.'+fileExtension;
								var urlForFile = "../servlet/com.eg.EgFileUpload?title=Uploading Logo Files&dispCaption=Custom Logo&requestFrom=EgConfigLogoMsg.jsp&uploadFor=config&uploadDir="+newFileName+"&fileExt="+fileExtension+"&fileUpload="+fileUpload;                                 
								logoPath = "manager/tomcat/webapps/final/config/images/";
								var uploadFor = "config";
								var uname = tempJsonData['UserId'];
								if (uname != '' && uname != undefined) 
								{
									var logoname = uname + "_" + uploadFor + "."+fileExtension;
									if (uname.indexOf("/") > -1 || uname.indexOf("(") > -1)
									{
										var domainName = uname.substring(0, uname.indexOf("/"));
										var userName = uname.substring(uname.indexOf("/") + 1, uname.length);
										if (userName.indexOf("(") > -1) 
										{
											userName = userName.substring(0, userName.indexOf("(") - 1);
										}
										if(domainName==null || domainName == "" )
										{
											logoname =  userName + "_" + uploadFor + "."+fileExtension;
										}
										else
										{
											logoname = domainName.toLowerCase() + "_" + userName + "_" + uploadFor + "."+fileExtension;
										}
									}
								}
								logoPath = logoPath+logoname;

								var fileuploadObj = Ext.getCmp('hiddenFieldsContainer');
								fileuploadObj.removeAll();
								var tmpHiddenElement = {
									xtype: 'hiddenfield',
									name : 'FILE_0_dstFile',
									value : logoPath
								}
								fileuploadObj.add(tmpHiddenElement);

								if (isUpload) 
								{
									var uploadform = Ext.getCmp('uploadform');
									uploadform.submit({
										url: urlForFile,
										method: 'POST',
										success: function (form, action) 
										{
											Ext.Msg.alert('Status', 'Request has been processed successfully');
											tempJsonData.hiddenParams["configMgmtImageStatus"] = "Uploaded";
											tempJsonData.hiddenParams["configMgmtImageUploadStatusForAudit"] = "yes";
											button.up('.window').close();
										},
										failure: function (form, action) 
										{
											Ext.Msg.alert('Failed', 'failure');
										}
									});
								} 
								else 
								{
									Ext.Msg.show({
										title: pageTitle,
										msg: nofileselect,
										buttons: Ext.Msg.OK,
										icon: Ext.Msg.WARNING
									});
									return false;
								}
							}
						}
					],
					listeners: {
						afterrender: function () {
							me.windowupload();
						},
					}
				}
			]
			
		}).show()
    },

    windowupload: function () {
        var me = Ext.getCmp('uploadform');
        //var a=me.getForm();
        var a = me.getForm();
        var hiddenParams = publicJsonData.hiddenParams;
        for (var hiddenParam in hiddenParams) {
            if (!a.findField("'" + hiddenParam + "'")) {
                me.add({
                    xtype: 'hidden',
                    name: hiddenParam,
                    value: hiddenParams[hiddenParam]
                });
            } else {
                a.findField("'" + hiddenParam + "'")
                    .setValue(hiddenParams[hiddenParam]);
            }
        }
    },

    saveData: function (button) {
		var me = this;
		var oldPwdObj = Ext.getCmp('oldPwd').getValue();
		var str_upass = Ext.getCmp('newPwd').getValue();
        var confPwdObj = Ext.getCmp('confPwd').getValue();
        var tomailStr = Ext.getCmp('To').getValue();
        var ccmailStr = Ext.getCmp('CC').getValue();
        var bccmailStr = Ext.getCmp('BCC').getValue();
        var customScript = Ext.getCmp('Cmd').getValue();
        var measuremode = Ext.getCmp('measuremode').getValue();
        var monhomepage = Ext.getCmp('monhomepage').getValue();
		var oldPwd_Obj = Ext.getCmp('oldPwd');
		var str_upass_obj = Ext.getCmp('newPwd');
        var confPwd_Obj = Ext.getCmp('confPwd');
        var tomailStr_obj = Ext.getCmp('To');
        var ccmailStr_obj  = Ext.getCmp('CC');
        var bccmailStr_obj  = Ext.getCmp('BCC');
        var customScript_obj  = Ext.getCmp('Cmd');

	var timeZone = Ext.getCmp('timeZone').getValue();
	var userDateFormat = Ext.getCmp('userDateFormat').getValue();

	

	var eGTvModeScn =tempJsonData.hiddenParams["$_eGTVModesupportedscreens"];

		if(publicJsonData['isAlarmViewerUser']=='true'){
			if(monhomepage!='Current Alarms'){
				Ext.Msg.show({
					title: pageTitle,
					msg: monhomepageAlrt,
	                buttons: Ext.Msg.OK,
		            icon: Ext.Msg.WARNING
				});
			    Ext.getCmp('monhomepage').focus();
				return;
			}
		}
        var frequency = Ext.getCmp('frequency').getValue();
        var userLanguage = Ext.get('flagID').getValue();
       /* var userAdminSkin = Ext.getCmp('adminskin').getValue();
        var monitorsk = Ext.getCmp('monitorskin').getValue();
        var reportskin = Ext.getCmp('reportskin').getValue();
        var userConfigSkin = Ext.getCmp('configskin').getValue();*/

		var userAdminSkin = Ext.getCmp('adminskin-themeLight').getText();
		var monitorsk = Ext.getCmp('monitorskin-themeLight').getText();
		var reportskin = Ext.getCmp('reportskin-themeLight').getText();
		var userConfigSkin = Ext.getCmp('configskin-themeLight').getText();
		if (userAdminSkin == "Light") {
			userAdminSkin = "Light";
		} else {
			userAdminSkin = "Dark";
		}

		if (monitorsk == "Light") {
			monitorsk = "Light";
		} else {
			monitorsk = "Dark";
		}

		 if (reportskin == "Light") {
			reportskin = "Light";
		} else {
			reportskin = "Dark";
		}

		if (reportskin == "Light") {
			reportskin = "Light";
		} else {
			reportskin = "Dark";
		}
		if (userConfigSkin == "Light") {
			userConfigSkin = "Light";
		} else {
			userConfigSkin = "Dark";
		}

        var high = Ext.getCmp('high').pressed;

        if (high == true) {
            high = "H";
        } else {
            high = "null";
        }

        var medium = Ext.getCmp('medium').pressed;

        if (medium == true) {
            medium = "I";
        } else {
            medium = "null";
        }

        var low = Ext.getCmp('low').pressed;

        if (low == true) {
            low = "L";
        } else {
            low = "null";
        }


        var ddInMailMode = Ext.getCmp('ddmailyes').pressed;

        if (ddInMailMode == true) {
            ddInMailMode = "Yes";
        } else {
            ddInMailMode = "No";
        }


       var checkedDeleteYes = Ext.getCmp('alarmdelyes').pressed;

        if (checkedDeleteYes == true) {
            checkedDeleteYes = "true";
        } else {
            checkedDeleteYes = "false";
        }



        var checkedAckYes = Ext.getCmp('alarmackyes').pressed;

        if (checkedAckYes == true) {
            checkedAckYes = "true";
        } else {
            checkedAckYes = "false";
        }


        var logoCheck = Ext.getCmp('apply').checked;


        if (logoCheck == true) {
            logoCheck = "yes";
        } else {
            logoCheck = null;
        }


        var notify = Ext.getCmp('isnew').checked;

        if (notify == true) {
            notify = "N";
        } else {
		notify = Ext.getCmp('iscomp').checked;
		if (notify == true) {
			notify = "C";
		}
       }


        var msgmode = Ext.getCmp('htmode').checked;

        if (msgmode == true) {
            msgmode = "HTML";
        } else {
            msgmode = Ext.getCmp('txtmode').checked;
	    if (msgmode == true) {
	    	msgmode = "T";
	    }
	 }


        var sub = true;
        var checkToStr = '';
        var new_pwd = true;
		var regExp1=/^(\+\d\d)?[0-9]+$/g;
		var reg3 = /(((([\+]?([0-9]){4,15})|([\_\#]?([a-zA-Z0-9]+[\ \_\.\-\&\#]?)*[a-zA-Z0-9])+)\@[a-zA-Z0-9][\w\.-]*[a-zA-Z0-9]\.[a-zA-Z][a-zA-Z\.]*[a-zA-Z])|((\+\d\d)?[0-9]+))/g

	// for include [#and-] fix in email-By Dhinakar on 11-3-2014

		var isDouble = publicJsonData['isDouble'];
        if (isDouble == "false")
            new_pwd = validateSingleByte(str_upass);

        if (tomailStr != null && tomailStr != "undefined") {
            checkToStr = Ext.getCmp('To').getValue();
            if (checkToStr == null) {
                checkToStr = "";
            }
        }
        var checkCcStr = '';
        if (ccmailStr != null && ccmailStr != "undefined") {
            checkCcStr = Ext.getCmp('CC').getValue();
        }
        var checkBccStr = '';
        if (bccmailStr != null && bccmailStr != "undefined") {
            checkBccStr = Ext.getCmp('BCC').getValue();
        }
        if (frequency != null && frequency != "undefined") {
            checkRefFreq = Ext.getCmp('frequency').getValue();
        }
        var checkScptStr = '';
        if (customScript != null && customScript != "undefined") {
            checkScptStr = Ext.getCmp('Cmd').getValue();
        }
        //var high1 = '';
        var showPref = true;


        /*if (showPref == "true") {
            if (high1 != null && Ext.getCmp('high') != null)
                high1 = Ext.getCmp('high');
            var medium1 = Ext.getCmp('medium');
            var low1 = Ext.getCmp('low');
			var notify1=Ext.getCmp('type');
			var mesgmode=Ext.getCmp('mode');
			for(i=0; i<notify1.length; i++)
		   {
			if(notify[i].checked)
			{
				radioval=notify[i].getValue();
			}
		  }
		  for(j=0; j<msgmode.length; j++)
		  {
			if(msgmode[j].checked)
			{
				mesgmode=msgmode[j].getValue();
			}
		 }

        }*/
		var isDomainUser = publicJsonData['isDomainUser'];
		var pwdLength = publicJsonData['pwdLength'];
		var pwdComplexity = "true";
		var pwdComplexityLength = publicJsonData['pwdComplexityCount'];
		if(isDomainUser!=null && isDomainUser=="false")
		{
			pwdComplexity = me.pwdComplexityCheck(str_upass);
		}
		if (pwdLength == "" || pwdLength < 2)
		{
			pwdLength = 8;
		}
		else if(pwdLength != "" && pwdLength < pwdComplexityLength)
		{
			pwdLength = pwdComplexityLength;
		}
		var domainUsr=false;
		if(isDomainUser!=null && isDomainUser=="true")
			domainUsr = true;

        if (!domainUsr && Ext.isEmpty(oldPwdObj) && Ext.isEmpty(str_upass) && Ext.isEmpty(confPwdObj)) {
			sub = true;
		}
		else if (!domainUsr && Ext.isEmpty(oldPwdObj)) {

            Ext.Msg.show({
                title: pageTitle,
                msg: oldpwd,
                buttons: Ext.Msg.OK,
                icon: Ext.Msg.WARNING
            });

            oldPwd_Obj.focus();
            sub = false;
            return;
		}
		else if (!domainUsr && Ext.isEmpty(str_upass)) {
            Ext.Msg.show({
                title: pageTitle,
                msg: password,
                buttons: Ext.Msg.OK,
                icon: Ext.Msg.WARNING
            });

            str_upass_obj.focus();
            sub = false;
            return;
        } else if (!domainUsr && Ext.isEmpty(confPwdObj)) {
            Ext.Msg.show({
                title: pageTitle,
                msg: cpwd,
                buttons: Ext.Msg.OK,
                icon: Ext.Msg.WARNING
            });
            confPwd_Obj.focus();
            sub = false;
            return;
        } else if (!domainUsr && (!Ext.isEmpty(str_upass) && !Ext.isEmpty(confPwdObj) && str_upass != confPwdObj)) {
            Ext.Msg.show({
                title: pageTitle,
                msg: pwdmatch,
                buttons: Ext.Msg.OK,
                icon: Ext.Msg.WARNING
            });
            confPwd_Obj.focus();
            sub = false;
            return;
        }else if(!checkloginpass(str_upass))
		{
            str_upass_obj.focus();
            sub = false;
            return;
		}else if (!domainUsr && (!Ext.isEmpty(str_upass) && (str_upass).length < pwdLength)) {
            Ext.Msg.show({
                title: pageTitle,
                msg: passLabel1+" "+pwdLength+" "+passLabel2,
                buttons: Ext.Msg.OK,
                icon: Ext.Msg.WARNING
            });
            str_upass_obj.focus();
            sub = false;
            return;
        } 
	/*
	 * Password complexity validation - STARTS
	 * by Meena.V
	 */
	else if(!domainUsr && (!Ext.isEmpty(str_upass) && pwdComplexity.indexOf("false") > -1))
	{
		var resMsg = pwdComplexity.substring(pwdComplexity.indexOf("false#")+6);
		Ext.Msg.show({
			title: pageTitle,
			msg: alertForPwdComplexity5+". "+passLabel1+" "+resMsg+".",
			width : 400,
			buttons: Ext.Msg.OK,
			icon: Ext.Msg.WARNING,
			fn : function(btn){
				str_upass_obj.focus();
			}
		});
		sub = false;
		return;
	}
	/*
	 * Password complexity validation - ENDS
	 */ 
	else if (!domainUsr && !new_pwd) {
            Ext.Msg.show({
                title: pageTitle,
                msg: pwdbyte,
                buttons: Ext.Msg.OK,
                icon: Ext.Msg.WARNING
            });
            str_upass_obj.focus();
            sub = false;
            return;

        }



        var toMailResult = validateEmail(tomailStr);
        var ccMailResult = validateEmail(ccmailStr);
        var bccMailResult = validateEmail(bccmailStr);

        var toMobResult = (tomailStr).match(regExp1);
        var ccMobResult = (ccmailStr).match(regExp1);
        var bccMobResult = (bccmailStr).match(regExp1);

        var toResult = (tomailStr).match(reg3);
        var ccResult = (ccmailStr).match(reg3);
        var bccResult = (bccmailStr).match(reg3);


        if ((checkToStr != "") && (toMailResult == false && toMobResult == null) && (toResult != tomailStr)) {
            Ext.Msg.show({
                title: pageTitle,
                msg: tomailid,
                buttons: Ext.Msg.OK,
                icon: Ext.Msg.WARNING
            });
            tomailStr_obj.focus();
           // sub = false;
            return;
        }
        if (!checkspecial(customScript, "@*+=[]|;\"\'<>?`")) {
            customScript_obj.focus();
            sub = false;
            return;
        }
        if (!validateSingleByte(tomailStr)) {
            Ext.Msg.show({
                title: pageTitle,
                msg: tomailiddbl,
                buttons: Ext.Msg.OK,
                icon: Ext.Msg.WARNING
            });
            tomailStr_obj.focus();
            //sub = false;
            return;
        }

        if ((checkCcStr != "") && (ccMailResult == null || ccMailResult == false) && ccMobResult == null && (ccResult != ccmailStr)) {
            Ext.Msg.show({
                title: pageTitle,
                msg: ccmailid,
                buttons: Ext.Msg.OK,
                icon: Ext.Msg.WARNING
            });
            ccmailStr_obj.focus();
            //sub = false;
            return;
        }
        if ((checkCcStr != "") && !validateSingleByte(ccmailStr)) {
            Ext.Msg.show({
                title: pageTitle,
                msg: ccmailiddbl,
                buttons: Ext.Msg.OK,
                icon: Ext.Msg.WARNING
            });
            ccmailStr_obj.focus();
            //sub = false;
            return;
        }
        if ((checkBccStr != "") && (bccMailResult == null || bccMailResult == false) && bccMobResult == null && bccResult != bccmailStr) {
            Ext.Msg.show({
                title: pageTitle,
                msg: bccmailid,
                buttons: Ext.Msg.OK,
                icon: Ext.Msg.WARNING
            });
            bccmailStr_obj.focus();
            //sub = false;
            return;
        }
        if ((checkBccStr != "") && !validateSingleByte(bccmailStr)) {
            Ext.Msg.show({
                title: pageTitle,
                msg: bccmailiddbl,
                buttons: Ext.Msg.OK,
                icon: Ext.Msg.WARNING
            });
            bccmailStr_obj.focus();
           // sub = false;
            return;
        }



        if (!sub || checkScptStr != "") {

            if (Ext.getCmp('high').pressed == false && Ext.getCmp('medium').pressed == false && Ext.getCmp('low').pressed == false) {
                Ext.Msg.show({
                    title: pageTitle,
                    msg: typealarm,
                    buttons: Ext.Msg.OK,
                    icon: Ext.Msg.WARNING
                });
                sub = false;
                return;
            } else if (Ext.getCmp('isnew').checked == false && Ext.getCmp('iscomp').checked == false) {
                Ext.Msg.show({
                    title: pageTitle,
                    msg: notification,
                    buttons: Ext.Msg.OK,
                    icon: Ext.Msg.WARNING
                });
                sub = false;
                return;
            } else if (Ext.getCmp('htmode').checked == false && Ext.getCmp('txtmode').checked == false) {
                Ext.Msg.show({
                    title: pageTitle,
                    msg: messagemode,
                    buttons: Ext.Msg.OK,
                    icon: Ext.Msg.WARNING
                });
                sub = false;
                return;
            }
        }
        if (checkRefFreq != null && checkRefFreq != "undefined" && Ext.getCmp('frequency').isHidden()==false) {
            if (sub && this.isAValidNumber(checkRefFreq)) {
                sub = true;
            } else {
                Ext.getCmp('frequency').focus();
                sub = false;
                return;
            }


        }


        if (sub) {
            if ((checkToStr == "" && checkToStr.length == 0) && (checkCcStr != "" && checkCcStr.length > 0)) {
                Ext.Msg.show({
                    title: pageTitle,
                    msg: tomailid,
                    buttons: Ext.Msg.OK,
                    icon: Ext.Msg.WARNING
                });
                tomailStr_obj.focus();
                sub = false;
                return;

            }
            if ((checkToStr == "" && checkToStr.length == 0) && (checkBccStr != "" && checkBccStr.length > 0)) {
                Ext.Msg.show({
                    title: pageTitle,
                    msg: tomailid,
                    buttons: Ext.Msg.OK,
                    icon: Ext.Msg.WARNING
                });
                tomailStr_obj.focus();
                sub = false;
                return;
            }
            if ((Ext.getCmp('high') != null && Ext.getCmp('high') != '' && Ext.getCmp('high').pressed) || (Ext.getCmp('medium') != null && Ext.getCmp('medium') != '' && Ext.getCmp('medium').pressed) || (Ext.getCmp('low') != null && Ext.getCmp('low') != '' && Ext.getCmp('low').pressed)) {
				var orStr = " or ";
				var sep="'";
				var msgStr = userIDValidationMsg43+sep+userIDValidationMsg44+sep+orStr+sep+userIDValidationMsg45+sep +".";
				if (!Ext.isEmpty(enableCommand) && enableCommand.toLowerCase() == 'no')
				{
					msgStr = tomailid;
				}
                if ((checkToStr == "" && checkToStr.length == 0) && (checkScptStr == "" && checkScptStr.length == 0)) {
                    Ext.Msg.show({
                        title: pageTitle,
                        msg: msgStr,
                        buttons: Ext.Msg.OK,
                        icon: Ext.Msg.WARNING
                    });
                    tomailStr_obj.focus();
                    sub = false;
                    return;
                }
            }




        }


        var $_pwd = tempJsonData.hiddenParams["$_pwd"];
        var $_high = tempJsonData.hiddenParams["$_high"];
        var $_medium = tempJsonData.hiddenParams["$_medium"];
        var $_low = tempJsonData.hiddenParams["$_low"];
        var $_tomailid = tempJsonData.hiddenParams["$_tomailid"];
        var $_ccmailid = tempJsonData.hiddenParams["$_ccmailid"];
        var $_bccmailid = tempJsonData.hiddenParams["$_bccmailid"];
        var $_measure_in_mail_mode = tempJsonData.hiddenParams["$_measure_in_mail_mode"];
        var $_dd_in_mail_mode = tempJsonData.hiddenParams["$_dd_in_mail_mode"];
        var $_notify = tempJsonData.hiddenParams["$_notify"];
        var $_msgmode = tempJsonData.hiddenParams["$_msgmode"];
        var $_alarm_delete = tempJsonData.hiddenParams["$_alarm_delete"];
        var $_alarm_ack = tempJsonData.hiddenParams["$_alarm_ack"];
        var $_adminSkin = tempJsonData.hiddenParams["$_adminSkin"];
        var $_monitorSkin = tempJsonData.hiddenParams["$_monitorSkin"];
        var $_reporterSkin = tempJsonData.hiddenParams["$_reporterSkin"];
        var $_configurationSkin = tempJsonData.hiddenParams["$_configurationSkin"];
        var loginImageStatus = tempJsonData.hiddenParams["loginImageStatus"];
        var monitorImageStatus = tempJsonData.hiddenParams["monitorImageStatus"];
        var reporterImageStatus = tempJsonData.hiddenParams["reporterImageStatus"];
        var configMgmtImageStatus = tempJsonData.hiddenParams["configMgmtImageStatus"];
        var loginImageUploadStatusForAudit = tempJsonData.hiddenParams["loginImageUploadStatusForAudit"];
        var monitorImageUploadStatusForAudit = tempJsonData.hiddenParams["monitorImageUploadStatusForAudit"];
        var reporterImageUploadStatusForAudit = tempJsonData.hiddenParams["reporterImageUploadStatusForAudit"];
        var configMgmtImageUploadStatusForAudit = tempJsonData.hiddenParams["configMgmtImageUploadStatusForAudit"];
        var $_languageName = tempJsonData.hiddenParams["$_languageName"];
        var $_refreshFreq = tempJsonData.hiddenParams["$_refreshFreq"];
        var $_monitorHomePage = tempJsonData.hiddenParams["$_monitorHomePage"];
        var escmailid = tempJsonData.hiddenParams["escmailid"];
	var escmailid2 = tempJsonData.hiddenParams["escmailid2"];
	var escmailid3 = tempJsonData.hiddenParams["escmailid3"];
	var escmailid4 = tempJsonData.hiddenParams["escmailid4"];
	var escmailid5 = tempJsonData.hiddenParams["escmailid5"];
        var size = tempJsonData.hiddenParams["size"];
        var name = tempJsonData.hiddenParams["name"];
        var val = tempJsonData.hiddenParams["val"];
        var entry = tempJsonData.hiddenParams["entry"];


		  var loginLogo1 = Ext.getCmp('loginpage').getValue();
		var monitorLogo1 = Ext.getCmp('monitorpage').getValue();
		var reporterLogo1 = Ext.getCmp('reporter').getValue()
		var configLogo1 = Ext.getCmp('configuration').getValue();

            //if user logo are changed to default , we change the hidden value during onsubmit

            if (loginLogo1 == "Default") {
                loginImageStatus = '';
                loginImageUploadStatusForAudit = 'no';
            }
            if (monitorLogo1 == "Default") {
                monitorImageStatus = '';
                monitorImageUploadStatusForAudit = 'no';
            }
            if (reporterLogo1 == "Default") {
                reporterImageStatus = '';
                reporterImageUploadStatusForAudit = 'no';
            }
            if (configLogo1 == "Default") {
                configMgmtImageStatus = '';
                configMgmtImageUploadStatusForAudit = 'no';
            }

            if (Ext.getCmp('apply').checked && (publicJsonData['hasAdminTab']==true || publicJsonData['hasMonitorTab']==true)) {
                reporterImageStatus = '';
                reporterImageUploadStatusForAudit = 'no';
                configMgmtImageStatus = '';
                configMgmtImageUploadStatusForAudit = 'no';
            }

	    /**************Following code for creating query string for TV Mode to both addmore and save button ****************/
		var monitorHomeOptRadioGrpObj=Ext.getCmp('userProf_monitorHomeOpt');
		
		var monitorHomeOpt = '';
		if(!Ext.isEmpty(monitorHomeOptRadioGrpObj))
		{
			var monitorHomeOptObj = monitorHomeOptRadioGrpObj.getChecked();
			monitorHomeOpt=monitorHomeOptObj[0].inputValue;
		}
		

        var qryString = "$_ccmailid=Mail ID / Mobile No  Cc$" + encodeURIComponent($_ccmailid) +
            "&$_alarm_ack=Allow alarm acknowledgement$" + $_alarm_ack +
            "&$_adminSkin=Admin Skin$" + $_adminSkin +
            "&monitorImageStatus=" + monitorImageStatus +
            "&configMgmtImageStatus=" + configMgmtImageStatus +
            "&$_pwd=Password$" + $_pwd +
            "&oldpwd=" +encodeURIComponent(oldPwdObj) +
            "&$_bccmailid=Mail ID / Mobile No  Bcc$" +encodeURIComponent($_bccmailid)  +
            "&$_alarm_delete=Allow delete alarms$" + $_alarm_delete +
            "&$_tomailid=Mail ID / Mobile No To$" + encodeURIComponent($_tomailid) +
            "&$_languageName=Language$" + $_languageName +
            "&alarm_ack=" + checkedAckYes +
            "&reporterImageUploadStatusForAudit=" + reporterImageUploadStatusForAudit +
            "&escmailid=" + encodeURIComponent(escmailid) +"&escmailid2=" + encodeURIComponent(escmailid2) +"&escmailid3=" + encodeURIComponent(escmailid3) +"&escmailid4=" + encodeURIComponent(escmailid4) +"&escmailid5=" + encodeURIComponent(escmailid5) +
            "&msgmode=" + msgmode +
            "&$_medium=" + $_medium +
            "&alarm_delete=" + checkedDeleteYes +
            "&loginImageStatus=" + loginImageStatus +
            "&adminSkin=" + userAdminSkin +
            "&configurationSkin=" + userConfigSkin +
            "&ccmailid=" + encodeURIComponent(ccmailStr) +
            "&$_monitorHomePage=Monitor Home Page$" + $_monitorHomePage +
            "&configMgmtImageUploadStatusForAudit=" + configMgmtImageUploadStatusForAudit +
            "&languageName=" + userLanguage +
            "&size=" + encodeURIComponent(size)  +
            "&$_reporterSkin=Reporter Skin$" + $_reporterSkin +
            "&$_monitorSkin=Monitor Skin$" + $_monitorSkin +
            "&logoCheck=" + logoCheck +
            "&$_refreshFreq=Refresh Frequency$" + $_refreshFreq +
            "&$_msgmode=" + $_msgmode +
            "&$_low=" + $_low +
            "&low=" + low +
            "&$_measure_in_mail_mode=Include measure details in mail alert$" + encodeURIComponent($_measure_in_mail_mode) +
            "&monitorImageUploadStatusForAudit=" + monitorImageUploadStatusForAudit +
            "&measure_in_mail_mode=" + measuremode +
            "&reporterImageStatus=" + reporterImageStatus +
            "&$_high=" + $_high +
            "&monitorSkin=" + monitorsk +
            "&notify=" + notify +
            "&cpwd=" + confPwdObj +
            "&bccmailid=" + encodeURIComponent(bccmailStr) +
            "&reporterSkin=" + reportskin +
            "&monitorHomePage=" + monhomepage +
            "&monitorHomePageOption=" + monitorHomeOpt +
            "&medium=" + medium +
            "&$_dd_in_mail_mode=Include detailed diagnosis in mail alerts$" +encodeURIComponent($_dd_in_mail_mode)  +
            "&$_configurationSkin=Configuration Management Skin$" + $_configurationSkin +
            "&pwd=" + encodeURIComponent(str_upass) +
            "&dd_in_mail_mode=" +encodeURIComponent(ddInMailMode)  +
            "&$_notify=" + $_notify +
            "&customScript=" + customScript +
            "&entry=" + entry +
            "&entry=" + entry +
            "&tomailid=" + encodeURIComponent(tomailStr) +
            "&high=" + high +
            "&refreshFreq=" + frequency +
            "&loginImageUploadStatusForAudit=" + loginImageUploadStatusForAudit +
	       /* "&TVModuleScreens=" +encodeURIComponent(TVMode)+"&tvModeTimeFrequency="+tvModeTimeFrequency+ */"&timeZone=" + timeZone +
		"&userDateFormat=" + userDateFormat;

		 /************** 2fa - starts here ****************/
		var isAdminEnabled2FA = publicJsonData.isAdminEnabled2FA;

		if (!Ext.isEmpty(isAdminEnabled2FA) && (isAdminEnabled2FA.toLowerCase() == "true" || isAdminEnabled2FA.toLowerCase() == "yes"))
		{
			var is2FAEnabled = Ext.getCmp('enable2FAYesFlag').getGroupValue();

			var twoFAOTPModeVal = Ext.getCmp('mail').getGroupValue();
			var twoFAEnableFlagVal = '';

			if (!Ext.isEmpty(is2FAEnabled) && is2FAEnabled.toLowerCase() == "yes")
			{
				twoFAEnableFlagVal = "yes";
				var tomailVal = Ext.getCmp('To').getValue();
				if (Ext.isEmpty(tomailVal) || Ext.String.trim(tomailVal).length == 0)
				{
					Ext.Msg.show
					({
						title : pageTitle,
						msg : toMailIDAlertMsg+".",
						buttons : Ext.Msg.OK,
						icon : 'iconExclamation',
						fn: function(btn)
						{
							Ext.getCmp('To').focus();
						}
					});
					return;
				}
				qryString += "&tomailVal="+tomailVal;
			}
			else
			{
				twoFAEnableFlagVal = "no";
				twoFAOTPModeVal = "mail";
			}
			qryString += "&twofaEnableFlagVal=" + twoFAEnableFlagVal + "&twofaOTPModeFlagVal=" + twoFAOTPModeVal;
		}
		var reloadManager=false;
		if(monitorHomeOpt!=null && monitorHomeOpt=='dynamic')
		{
			var previousSelectedOption=Ext.getCmp('monhomepage').previousSelectedOption;
		
			if(monhomepage!=null && monhomepage!=previousSelectedOption)
			{
				reloadManager=true;
			}
		}
		else 
		{
			if(monhomepage!=null && monhomepage!=$_monitorHomePage)
			{
				reloadManager=true;
			}
		}
		/************** 2fa - ends here ****************/

			alarmLoadMask1.show();
			Ext.Ajax.request({
				url:'/final/admin/UserProfile/data/userProfilep.jsp',
				params : qryString,
				method:'POST',
				timeout:120000,
				scope:this,
				success:function(response)
				{
					var jsonText = response.responseText;
					var publicJson = Ext.decode(jsonText);
					if (publicJson['Msg']=='User profile settings updated successfully')
					{
						Ext.Msg.show({
							title:publicJson['Title'],
							msg:publicJson['Msg'],
							buttons: Ext.Msg.OK,
							icon: "iconInformation",
							fn: function (buttonId) 
							{
								if (buttonId == "ok") 
								{
									if (isLSPortalUser != null && isLSPortalUser == true && sendUserDataToCMS != null && sendUserDataToCMS == 'true' && oldPwdObj != str_upass)
									{
										jQuery.ajax({
											type: "POST",
											url: "https://www.eginnovations.com/solutions/product_pw_change.php",
											 data: {
												'Email': userID,
												'New_Password': str_upass
											},
											cache: false,
											success: function(result)
											{
												if((publicJsonData['selectedTimeZone']!=timeZone) || (publicJsonData['selectedDateFormat']!=userDateFormat) || (publicJsonData['userLanguage']!=userLanguage) || (publicJsonData['userAdminSkin'] != userAdminSkin) || (publicJsonData['userMonitorSkin'] != monitorsk) || (publicJsonData['userReporterSkin'] != reportskin) || (publicJsonData['userConfigSkin'] != userConfigSkin))
												{
													if(fromSm == "yes")
													{
														window.parent.location.href = smIndexPage+"&comeFrom=profile"+"&newwindow=yes";
														return;
													}
													else
													{
														if(reloadManager)
														{
															window.parent.location.href ='/final/egIndex.jsp?entry=monitor&displayTab=all&uname=&integritycheckviolated=false';
															return;
														}
														else
														{
															window.parent.refreshEgIndexPage("userprofile_monitor_homepage");
															/*if(isElementsDataSwapped) // || (TVMode[0]!== "" && TVMode.length!= 0)
															{
																window.parent.refreshEgIndexPage("userprofile_monitor_homepage");
															}*/
															//window.parent.location.href=window.parent.location.href+"&comeFrom=profile";
															//return;
														}
													}
												}
												else
												{
													if(reloadManager)
													{
														window.parent.location.href ='/final/egIndex.jsp?entry=monitor&displayTab=all&uname=&integritycheckviolated=false';
														return;
													}
													else
													{
														window.parent.refreshEgIndexPage("userprofile_monitor_homepage");
													}
												}
											},
											error: function(error)
											{
												if(reloadManager)
												{
													window.parent.location.href ='/final/egIndex.jsp?entry=monitor&displayTab=all&uname=&integritycheckviolated=false';
													return;
												}
												console.log(error);
											}
										});
									}
									else
									{
										if((publicJsonData['selectedTimeZone']!=timeZone) || (publicJsonData['selectedDateFormat']!=userDateFormat) || (publicJsonData['userLanguage']!=userLanguage) || (publicJsonData['userAdminSkin'] != userAdminSkin) || (publicJsonData['userMonitorSkin'] != monitorsk) || (publicJsonData['userReporterSkin'] != reportskin) || (publicJsonData['userConfigSkin'] != userConfigSkin))
										{
											if(fromSm == "yes")
											{
												window.parent.location.href = smIndexPage+"&comeFrom=profile"+"&newwindow=yes";
												return;
											}
											else
											{
												if(reloadManager)
												{
													window.parent.location.href ='/final/egIndex.jsp?entry=monitor&displayTab=all&uname=&integritycheckviolated=false';
													return;
												}
												else
												{
													window.parent.refreshEgIndexPage("userprofile_monitor_homepage");
													//if(isElementsDataSwapped) // || (TVMode[0]!== "" && TVMode.length!= 0)
													//{
														//window.parent.refreshEgIndexPage("userprofile_monitor_homepage");
													//}
													//window.parent.location.href=window.parent.location.href+"&comeFrom=profile";
													//return;
												}
											}
										}
										else
										{
											if(reloadManager)
											{
												window.parent.location.href ='/final/egIndex.jsp?entry=monitor&displayTab=all&uname=&integritycheckviolated=false';
												return;
											}
											else
											{
												window.parent.refreshEgIndexPage("userprofile_monitor_homepage");
											}
										}
									}
								}
							}
						});
					}
					else
					{
						Ext.Msg.show({
							title:publicJson['Title'],
							msg:publicJson['Msg'],
							buttons: Ext.Msg.OK,
							icon: Ext.Msg.WARNING,
						});
					}
					alarmLoadMask1.hide();
				}
			});
    },

    isAValidNumber: function (val) {
        validFigures = '0123456789';
        if (val == "") {
            Ext.Msg.show({
                title: pageTitle,
                msg: frequency,
                buttons: Ext.Msg.OK,
                icon: Ext.Msg.WARNING
            });
            return false;
        }
        for (i = 0; i < val.length; i++) {
            if (validFigures.indexOf(val.charAt(i), 0) == -1) {
                Ext.Msg.show({
                    title: pageTitle,
                    msg: frequency,
                    buttons: Ext.Msg.OK,
                    icon: Ext.Msg.WARNING
                });
                return false;
            }
        }
        if (parseInt(val) >= 30) {
            return true;
        } else {
            Ext.Msg.show({
                title: pageTitle,
                msg: frequency,
                buttons: Ext.Msg.OK,
                icon: Ext.Msg.WARNING
            });
            return false;
        }
    },

	show2FAOTPModeCnt: function()
	{
		var twoFAEnableFlag = Ext.getCmp('enable2FAYesFlag').getGroupValue();
		if (!Ext.isEmpty(twoFAEnableFlag) && twoFAEnableFlag.toLowerCase() == "yes")
		{
			Ext.getCmp('twoFAOTPMode').show();
		}
		else
		{
			Ext.getCmp('twoFAOTPMode').hide();
		}
	}
});




