Ext.define('UserProfile.view.MonitorSettings', {
	extend: 'Ext.panel.Panel',
	alias: 'widget.monitorsettings',
	id:'monitorsettings',
	//requires:['Ext.ux.FillSlider'],
	requires: ['Ext.ux.form.MultiSelect', 'Ext.ux.form.ItemSelector','UserProfile.view.toggleButton','UserProfile.view.SecuritySettings'],
	layout: 'column',
	columnWidth:1,
	initComponent: function () {
		this.buttonAlign = 'center';
		this.callParent()
	},
	items: [{
			xtype: 'panel',
			columnWidth: .42,
			cls:'userProfileOuter',
			bodyPadding:10,
			height:210,
			margin:'5 10 5 10',
			layout: 'column',
			hidden: hideUserSettings,
			items:[{
				xtype:'container',
				//layout: 'vbox',
				//flex:0.6,
				margin:'0 0 0 10',
				columnWidth:.6,
				defaults: {anchor: '90%'},

				layout: 'anchor',
				items: [
					{
				xtype:'fieldset',
				columnWidth:1,
				title: setMonHomeTitle,
				id:'monHomeField',
				collapsible: false,
				style:{"box-shadow":"none","background":"none"},
				margin:'0 0 0 0',
				defaults: {anchor: '100%'},
				layout: 'anchor',
				items :[
				{
					xtype: 'radiogroup',
					column: 2,
					labelAlign: 'left',
					//      height: 20,
				//	fieldLabel: 'Monitor Home Page',
					id: 'userProf_monitorHomeOpt',
					name: 'userProf_monitorHomeOpt',
					//hidden: true,
					//width:180,
					items: [{
						boxLabel: defaultTitle,
						name: 'selectedMonHomeOpt',
						inputValue: 'default',
						cls: 'radiobt',
						width:80,
					}, {
						boxLabel: domDashbTitle,
						name: 'selectedMonHomeOpt',
						inputValue: 'dynamic',
						cls: 'radiobt',
						width:150,
					}]
				},{
					xtype:'scrollcombo',
					//fieldLabel:'Monitor Home',
					labelAlign:'top',
					labelSeparator : "",
					margin:'0 0 0 0',
					cls: 'dropdown24',
					id: 'monhomepage',
					forceSelection:false,
					editable:false,
					//width:180,
					name: 'monhomepage',
					vertical: true,
					hidden:(!hasMonitorTab),
					store: Ext.data.Store
					(
						{
							fields: ['displayField','valueField'],
							data : []
						}
					),
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local',
					listeners : {
						'afterrender' : function(comboObj)
						{
							comboObj.previousSelectedOption=comboObj.getValue();
						}
					}
				}]
			},


				{
					xtype: 'container',
					layout:{type:'hbox',align:'stretch'},
					//width: 230,
					defaults:{
						margin:'12 10 10 2',
					},
					items: [
					{
						xtype: 'slider',
												fieldLabel: '<span class="font_bold"> '+refFreqTitle+' </span><span><div id="refquency" style="display: inline ; float:right ; font-size:12px"></div></span>',
						labelSeparator: '',
						labelAlign: 'top',
						animate:false,
						//width: 250,
						minValue: 30,
						id: 'frequency',
						name: 'frequency',
						value:20,
						useTips:false,
						maxValue: 300,
					//margin: '12 5 10 2',
						width: 200,
						plugins:['fillslider'],
						listeners :{
							change : function(select,thumb,newval,oldval){
															//Ext.getCmp('frequencyText').setValue(newval.value+" Secs");
															Ext.get('refquency').update(newval.value+" Secs");
							}
						}
											}/*,{
						xtype: "displayfield",
						id: "frequencyText",
						width:150,
						fieldLabel: "",
						style:{
							'margin': '24px 20px 0px 20px',
							'font-weight':'bold !important',
						},
						listeners:{
							'afterrender': function () {
								var frequencydis = publicJsonData['refreshFreq'];
								Ext.getCmp('frequencyText').setValue(frequencydis+" Secs");
							}
						}
											}*/]
				}]
			},{
						xtype:'container',
						layout:'vbox',
						//hidden:isDefaultUser,
						//flex:0.4,
						columnWidth:.4,
						items:[
							 {
								 xtype:'container',
								 layout:
								 {
									 type:'hbox'
								 },
								 items:[
									{
									 	html:timeZoneTitle
									},
									{
										xtype:'checkbox',
										cls:'checkbt',
										id: 'defaulttimeZone',
										name: 'defaulttimeZone',
										labelSeparator:'',
										labelAlign: 'top',
										margin: '0 0 4 40',
										width:60,
										boxLabel : defaultTitle								
									 }
								 ]
							 },
							 {
								xtype:'scrollcombo',
								id: 'timeZone',
								name: 'timeZone',
								labelSeparator:'',
								labelAlign: 'top',
								margin: '0 0 0 0',
								width:170,
								//cls: 'dropdown',
								editable : false,
								fieldLabel : '',
								store: new Ext.data.Store({
									fields : ['displayField', 'valueField'],
									data : []
								}),
								displayField : 'displayField',
								valueField : 'valueField',
								queryMode : 'local',
								disabled : false
							},
							{
								xtype:'scrollcombo',
								id: 'userDateFormat',
								name: 'userDateFormat',
								labelSeparator:'',
								labelAlign: 'top',
								margin: '15 0 0 0',
								width:170,
								//cls: 'dropdown',
								editable : false,
								fieldLabel : dateFromatTitle,
								store: new Ext.data.Store({
									fields : ['displayField', 'valueField'],
									data : []
								}),
								displayField : 'displayField',
								valueField : 'valueField',
								queryMode : 'local',
								disabled : false
							},{
								xtype: 'combo',
								cls: 'dropdown24 flag',
								width: 170,
								margin: '10 0 0 0',
								typeAhead: false,
								labelAlign: 'top',
								fieldLabel:'<span class="font_bold"> '+langTitle+'</span>',
								id: 'language',
								name: 'language',
								labelSeparator: '',
								displayField: 'displayField',
								valueField: 'valueField',
								queryMode: 'local',
								store: new Ext.data.Store({
									fields: ['displayField', 'valueField'],
									data: []
								}),
								displayTpl: Ext.create('Ext.XTemplate', ['<tpl for=".">',
									'<div>',
									'<img src="/final/images/flag/{valueField}.png" align="top" />',
									'<span>{displayField} <input type="text" id="flagID" style="display:none" value={valueField} /><span>',
									'</div>',
									'</tpl>'
								]),
								listConfig: {
								// Custom rendering template for each item
									getInnerTpl: function () {
									return '<div >' +
										'<img src="/final/images/flag/{valueField}.png" align="top"  />' +
										'<span>{displayField}<span>' +
										'</div>';
									}
								},
								fieldSubTpl: [
									'<div class="{hiddenDataCls}" role="presentation"></div>',
									'<li id="{id}" type="{type}" ',
									'<tpl if="size">size="{size}" </tpl>',
									'<tpl if="tabIdx">tabIndex="{tabIdx}" </tpl>',
									'<div class="{fieldCls} {typeCls}" autocomplete="off"></div>',
									'<div class="{clearCls}" role="presentation"></div>',
									'</li>', {
										compiled: true,
										disableFormats: true
									}
								],

								setRawValue: function (value) {
									var me = this;
									value = Ext.value(value, '');
									me.rawValue = value;
									if (me.inputEl) {
										me.inputEl.dom.innerHTML = value;
									}
									return value;
								}
							}
						]
					}]
			},{
				xtype: 'panel',
				columnWidth: .58,
				margin:'5 10 10 0',
				bodyPadding:20,
				height:210,
				cls:'userProfileOuter',
				id:'skin_id',
				layout:{
					align: 'stretch',
					type:'vbox',
					pack:'start'
				},
				hidden: hideThemes,
				items: [{
					xtype: 'label',
					html: '<span class="font_bold">'+themeTitle+'</span>',
					style: {
						'font-size': '14px',
						//'margin-left':'137px'
					}
				},{
					xtype: 'container',
					// width: '100%',
					//margin: '21px 128px 0px',
					margin:'10 0 0 0',
					layout: 'column',
					defaults:{
						columnWidth:.24,
					},
					items:[
					{
						xtype:'container',
						items:[{
							xtype: 'label',
							text: adminLogo,
							margin:'0 0 10 0',
							id:'textadmin'
						},{
							xtype: 'container',
							cls: 'skinAdminDark',
							margin:'10px 0px 8px 0px',
							id:'skinadminimage'

						},/*{
							xtype: 'scrollcombo',
							labelAlign: 'left',
							margin:'5 0 0 0',
							fieldLabel: '',
							cls: 'dropdown',
							id: 'adminskin',
							name: 'adminskin',
							width: 95,
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							store: new Ext.data.Store({
								fields: ['displayField', 'valueField'],
								data: []
							})
						},*/{
							xtype: 'container', //Switch button
							//height: 24,
							margin:'0 0 0 3',
							layout: {
								type: 'hbox',
								align: 'stretch'
							},
						//	cls: 'switch_buttons',
							//width: 71,
							id: 'adminskinCon',
							items: [{
								border: false,
								flex: 1,
								style: {
									//'position': 'relative'
								},
								buttons: [
									{
									xtype: 'tooglebutton',
									id: 'adminskin-themeLight',
									config: {
										light: 'LIGHT',
										Dark: 'DARK'
									},
									chkPress: function(bt) {
											var btnball = Ext.get(bt.id).select('.switchMe');
											if (!Ext.isEmpty(btnball)) {
												if (bt.pressed == false) {
													btnball.animate({
														duration: 150,
														to: {
															left: bt.getWidth() - 23
														}
													});
													bt.setText(this.getLight());
													bt.setTextAlign('left');
													$('#skinadminimage').animate({'background-position':'0px 0px'},250,'linear');
													
													Ext.getCmp('skinadminimage').removeCls('skinAdminDark');
													/*$('.skinAdminDark').fadeOut(250,function(){
														Ext.getCmp('skinadminimage').removeCls('skinAdminDark');
														Ext.getCmp('skinadminimage').addCls('skinAdminLight');
														$('.skinAdminLight').fadeIn(250);
													})*/
													Ext.getCmp('skinadminimage').addCls('skinAdminLight');
													//Ext.getCmp('skinadminimage').fadeId({opacity:1 , easing:'easeOut' , duration:1000});
													//Ext.getCmp('skinadminimage').el.setStyle({'background':'url(../images/Light/skin-img.png)'})
													 
												} else {
													btnball.animate({
														duration: 150,
														to: {
															
															left: 0
															
														}
													});
													bt.setText(this.getDark());
													bt.setTextAlign('right');
													$('#skinadminimage').animate({backgroundPosition:'-120px 0px'},250,'linear');
													//Ext.getCmp('skinadminimage').el.setStyle({'background':'url(../images/Dark/skin-img.png)'})
													Ext.getCmp('skinadminimage').removeCls('skinAdminLight');
													Ext.getCmp('skinadminimage').addCls('skinAdminDark');
												}
											}
										}
								}]
							}]
						}]
					},{
						xtype: 'container',
						items: [{
							xtype: 'label',
							text: monitorLogo,
							margin:'0 0 10 0',
							id:'textmonitor'
						},{
							xtype: 'container',
							cls: 'skinMonitorDark',
							margin:'10px 0px 8px 0px',
							id:'skinmonitorimage'
						},/*{
							xtype: 'scrollcombo',
							labelAlign: 'left',
							fieldLabel: '',
							cls: 'dropdown',
							id: 'monitorskin',
							name: 'monitorskin',
							width: 95,
							margin: '5 0 0 0',
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							store: new Ext.data.Store({
								fields: ['displayField', 'valueField'],
								data: []
							})
						},*/{xtype: 'container', //Switch button
							//height: 24,
							margin:'0 0 0 3',
							layout: {
								type: 'hbox',
								align: 'stretch'
							},
						//	cls: 'switch_buttons',
							//width: 71,
							id: 'monitorskinCon',
							items: [{
								border: false,
								flex: 1,
								style: {
									//'position': 'relative'
								},
								buttons: [
									{
									xtype: 'tooglebutton',
									id: 'monitorskin-themeLight',
									config: {
										light: 'LIGHT',
										Dark: 'DARK'
									},
									chkPress: function(bt) {
											var btnball = Ext.get(bt.id).select('.switchMe');
											if (!Ext.isEmpty(btnball)) {
												if (bt.pressed == false) {
													btnball.animate({
														duration: 150,
														to: {
															left: bt.getWidth() - 23
														}
													});
													bt.setText(this.getLight());
													bt.setTextAlign('left');
													$('#skinmonitorimage').animate({'background-position':'-240px 0px'},250,'linear');
													Ext.getCmp('skinmonitorimage').removeCls('skinMonitorDark');
													Ext.getCmp('skinmonitorimage').addCls('skinMonitorLight');
													 
												} else {
													btnball.animate({
														duration: 150,
														to: {
															left: 0
														}
													});
													bt.setText(this.getDark());
													bt.setTextAlign('right');
													$('#skinmonitorimage').animate({'background-position':'-360px 0px'},250,'linear');
													Ext.getCmp('skinmonitorimage').removeCls('lightTheme');
													Ext.getCmp('skinmonitorimage').addCls('skinMonitorDark');
												}
											}
										}
								}]
							}]
						}]
					},{
						xtype: 'container',
						hidden: hideInSuperManager,
						items: [{
							xtype: 'label',
							text: reporterLogo,
							id:'textreport'
						},{
							xtype: 'container',
							cls: 'skinReporterDark',
							id:'skinreportimage',
							margin:'10px 0px 8px 0px'
						},/*{
							xtype: 'scrollcombo',
							labelAlign: 'left',
							fieldLabel: '',
							cls: 'dropdown',
							id: 'reportskin',
							name: 'reportskin',
							width: 95,
							margin: '5 0 0 0',
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							store: new Ext.data.Store({
								fields: ['displayField', 'valueField'],
								data: []
							})
						},*/{
							xtype: 'container', //Switch button
							//height: 24,
							margin:'0 0 0 3',
							layout: {
								type: 'hbox',
								align: 'stretch'
							},
						//	cls: 'switch_buttons',
							//width: 71,
							id: 'reportskinCon',
							items: [{
								border: false,
								flex: 1,
								style: {
									//'position': 'relative'
								},
								buttons: [
									{
									xtype: 'tooglebutton',
									id: 'reportskin-themeLight',
									config: {
										light: 'LIGHT',
										Dark: 'DARK'
									},
									chkPress: function(bt) {
											var btnball = Ext.get(bt.id).select('.switchMe');
											if (!Ext.isEmpty(btnball)) {
												if (bt.pressed == false) {
													btnball.animate({
														duration: 150,
														to: {
															left: bt.getWidth() - 23
														}
													});
													bt.setText(this.getLight());
													bt.setTextAlign('left');
													$('#skinreportimage').animate({'background-position':'-480px 0px'},250,'linear');
													Ext.getCmp('skinreportimage').removeCls('skinReporterDark');
													Ext.getCmp('skinreportimage').addCls('skinReporterLight');
													 
												} else {
													btnball.animate({
														duration: 150,
														to: {
															
															left: 0
															
														}
													});
													bt.setText(this.getDark());
													bt.setTextAlign('right');
													$('#skinreportimage').animate({'background-position':'-600px 0px'},250,'linear');
													Ext.getCmp('skinreportimage').removeCls('skinReporterLight');
													Ext.getCmp('skinreportimage').addCls('skinReporterDark');
												}
											}
										}
								}]
							}]
						}]
					},{
						xtype: 'container',
						hidden: hideInSuperManager,
						items: [{
							xtype: 'label',
							text: configLogo,
							margin:'0px 0px 10px 0px',
							id:'textconfig'
						},{
							xtype: 'container',
							cls: 'skinConfigDark',
							margin:'10px 0px 8px 0px',
							id:'skinconfigimage'
						},/*{
							xtype: 'scrollcombo',
							labelAlign: 'left',
							fieldLabel: '',
							cls: 'dropdown',
							id: 'configskin',
							name: 'configskin',
							width: 95,
							margin: '5 0 0 0',
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							store: new Ext.data.Store({
								fields: ['displayField', 'valueField'],
								data: []
							})
						},*/{
							xtype: 'container', //Switch button
							//height: 24,
							margin:'0 0 0 3',
							layout: {
								type: 'hbox',
								align: 'stretch'
							},
						//	cls: 'switch_buttons',
							//width: 71,
							id: 'configskinCon',
							items: [{
								border: false,
								flex: 1,
								style: {
									//'position': 'relative'
								},
								buttons: [
									{
									xtype: 'tooglebutton',
									id: 'configskin-themeLight',
									config: {
										light: 'LIGHT',
										Dark: 'DARK'
									},
									chkPress: function(bt) {
											var btnball = Ext.get(bt.id).select('.switchMe');
											if (!Ext.isEmpty(btnball)) {
												if (bt.pressed == false) {
													btnball.animate({
														duration: 150,
														to: {
															left: bt.getWidth() - 23
														}
													});
													bt.setText(this.getLight());
													bt.setTextAlign('left');
													$('#skinconfigimage').animate({'background-position':'-720px 0px'},250,'linear');
													Ext.getCmp('skinconfigimage').removeCls('skinConfigDark');
													Ext.getCmp('skinconfigimage').addCls('skinConfigLight');
													 
												} else {
													btnball.animate({
														duration: 150,
														to: {
															
															left: 0
															
														}
													});
													bt.setText(this.getDark());
													bt.setTextAlign('right');
													$('#skinconfigimage').animate({'background-position':'-840px 0px'},250,'linear');
													Ext.getCmp('skinconfigimage').removeCls('skinConfigLight');
													Ext.getCmp('skinconfigimage').addCls('skinConfigDark');
												}
											}
										}
								}]
							}]
						}]
					}]
				}]
			},{
				xtype: 'panel',
				layout: 'column',
				columnWidth:1,
				margin:'0 10 10 10',
				bodyPadding:20,
				cls:'userProfileOuter',
				id:'admin_monitorcontainer',
				items: [
				{
					xtype:'container',
					columnWidth:1,
					style:{'margin-bottom':'10px'},
					html:'<span class="font_bold12">'+personalLogoLbl+'</span>',
				},{
					xtype: 'container',
					columnWidth:.3,
					layout: 'hbox',
					hidden: hideLoginPgLogoSettings,
					items: [{
						xtype: 'scrollcombo',
						labelAlign: 'top',
						fieldLabel: '<span class="font_bold11">'+loginPageLogo+'</span>',
						cls: 'dropdown',
						id: 'loginpage',
						name: 'loginpage',
						labelSeparator: '',
						width: 120,
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local',
						store: new Ext.data.Store({
							fields: ['displayField', 'valueField'],
							data: []
						})
					},{
						xtype: 'button',
						margin: '20 20 0 10',
						id: 'loginFile',
						action: 'loginFile',
						padding: '0 0 0 0',
						cls: 'button20',
						text: 'Upload'
					}]
				},{
					xtype: 'container',
					columnWidth:.5,
					layout: 'hbox',
					items: [
					{
						xtype: 'scrollcombo',
						labelAlign: 'top',
						fieldLabel: '<span class="font_bold11">'+adminMonLbl+'</span>',
						cls: 'dropdown',
						id: 'monitorpage',
						name: 'monitorpage',
						labelSeparator: '',
						width: 120,
						displayField: 'displayField',
						valueField: 'valueField',
						queryMode: 'local',
						store: new Ext.data.Store({
							fields: ['displayField', 'valueField'],
							data: []
						})
					},{
						xtype: 'button',
						margin: '21 10 0 10',
						padding: '0 0 0 0',
						text: 'Upload',
						cls: 'button20',
						id: 'monitorFile',
						action: 'monitorFile'

					},{
						xtype: 'container',
						width: 150,
						columnWidth:.30,
						id:'apply_container',
						layout: 'hbox',
						margin:'20 10 0 10',
						hidden: hideInSuperManager,
						items: [
						{
							xtype: 'checkbox',
							labelSeparator: '',
							id: 'apply',
							name: 'apply',
							cls: 'checkbt',
							handler: function () {
								var checkbox = Ext.getCmp('apply');
									if(checkbox.checked == true) {
										Ext.getCmp('reporter_container').hide();
									}
									else
									{
												if(publicJsonData['hasReporterTab']==true){
													Ext.getCmp('reporterContainer').show();	
												}	
												if(publicJsonData['hasConfigTab']==true){
													Ext.getCmp('configContainer').show();
												}
									}
								}
						},{
							xtype: 'label',
							text: applyModLbl,
							id:'applytoother',
							width: 160,
							margin:0
						}]
					}]
				},{
					xtype: 'container',
					layout: 'column',
					columnWidth:1,
					id:'reporter_container',
					 //cls:'reportercontainer_css',
					items: [
					{
						columnWidth:.3,
						margin:'10 10 0 0',
						xtype:'container',
						id: 'reporterContainer',
						//hidden:true,
						items:[{
							xtype: 'scrollcombo',
							labelAlign: 'top',
							fieldLabel: 'Reporter',
							cls: 'dropdown fontnormal_css',
							id: 'reporter',
							name: 'reporter',
							width: 120,
							labelSeparator: '',
							//labelWidth: 220,
							style: {
								'float': 'left'
							},
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							store: new Ext.data.Store({
								fields: ['displayField', 'valueField'],
								data: []
							})
						},{
							xtype: 'button',
							margin:'21 10 0 10',
							id: 'reportFile',
							action: 'reportFile',
							cls: 'button20',
							text: 'Upload'
						//width: 30,
						}]
					},{
						columnWidth:.5,
						margin:'10 10 0 0',
						xtype:'container',
						id: 'configContainer',
						//hidden:true,
						items:[{
							xtype: 'scrollcombo',
							labelAlign: 'top',
							fieldLabel: 'Configuration',
							cls: 'dropdown fontnormal_css',
							id: 'configuration',
							name: 'configuration',
							style: {
								'float': 'left',
							},
							labelSeparator: '',
							//labelWidth: 220,
							width: 120,
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							store: new Ext.data.Store({
								fields: ['displayField', 'valueField'],
								data: []
							})
						},{
							xtype: 'button',
							margin:'21 10 0 10',
							cls: 'button20',
							text: 'Upload',
							id: 'configFile',
							action: 'configFile'
						}]
					}]
				}]
			},{
				xtype:'securitysettings'
			}],
			buttons: [
				{
					xtype: 'button',
					action: 'save',
					text: savLbl,
					cls: 'button20',
					id: 'save',
					name: 'save',
					margin: '0px 0px 25px 0px'
				},
				{
					xtype:'container',
					width:10,
					margin:'0 5 0 0',
					cls:'userProfileSeparator',
					padding:0,
					height:'auto'
				 },
				{
					xtype: 'button',
					action: 'daily_mail',
					text: configDMLbl,
					cls: 'button20',
					id: 'daily_mail',
					name: 'daily_mail',
					margin: '0px 0px 25px 0px'
				},
				{
					xtype: 'button',
					action: 'mailFilter',
					text: 'Mail/SMS Filters',
					cls: 'button20',
					id: 'mailFilterBtn',
					name: 'mailFilterBtn',
					hidden: true,
					margin: '0px 0px 25px 10px'
				}
				
			],

	loadmonitorData: function () {
		/*var adminskincombo = Ext.getCmp('adminskin');
		adminskincombo.getStore().loadRawData(publicJsonData['reportOptions1']);
		if(publicJsonData['reportOptions1']==null)
		{
			Ext.getCmp('textadmin').disable();
				Ext.getCmp('skinadminimage').disable();
			adminskincombo.disable();
	   }else{
			adminskincombo.setValue(publicJsonData['userAdminSkin']);
		adminskincombo.setEditable(false);
		}

		var monitorskincombo = Ext.getCmp('monitorskin');
		monitorskincombo.getStore().loadRawData(publicJsonData['reportOptions2']);
		if(publicJsonData['reportOptions2']==null)
		{
			Ext.getCmp('textmonitor').disable();
				Ext.getCmp('skinmonitorimage').disable();
			monitorskincombo.disable();
	   }else{
		monitorskincombo.setValue(publicJsonData['userMonitorSkin']);
		monitorskincombo.setEditable(false);}

	   var reportskincombo = Ext.getCmp('reportskin');
		reportskincombo.getStore().loadRawData(publicJsonData['reportOptions3']);
		if(publicJsonData['reportOptions3']==null)
		{
			Ext.getCmp('textreport').disable();
				Ext.getCmp('skinreportimage').disable();
			reportskincombo.disable();
	   }else{
		reportskincombo.setValue(publicJsonData['userReporterSkin']);
		reportskincombo.setEditable(false);}

		var configskincombo = Ext.getCmp('configskin');
		configskincombo.getStore().loadRawData(publicJsonData['reportOptions4']);
		if(publicJsonData['reportOptions4']==null)
		{
			Ext.getCmp('textconfig').disable();
				Ext.getCmp('skinconfigimage').disable();
			configskincombo.disable();
	   }else{
		configskincombo.setValue(publicJsonData['userConfigSkin']);
		configskincombo.setEditable(false);}*/

		// ****Switch button for skin****
		if(publicJsonData['reportOptions1']==null)
		{
			Ext.getCmp('adminskin-themeLight').setText('Light');
		    Ext.getCmp('adminskin-themeLight').setTextAlign('left');
		    Ext.get('adminskin-themeLight').select('.switchMe').animate({duration: 150,to: {left: Ext.get('adminskin-themeLight').getWidth() - 23}});
		    $('#skinadminimage').animate({'background-position':'0px 0px'},250,'linear');
			Ext.getCmp('skinadminimage').disable();
			Ext.getCmp('adminskin-themeLight').disable();
	   }
	   else
		{
			 if(publicJsonData['userAdminSkin']=='Light')
			  {				  
				   Ext.getCmp('adminskin-themeLight').setText('Light');
				   Ext.getCmp('adminskin-themeLight').setTextAlign('left');
				   Ext.get('adminskin-themeLight').select('.switchMe').animate({duration: 150,to: {left: Ext.get('adminskin-themeLight').getWidth() - 23}});
				   $('#skinadminimage').animate({'background-position':'0px 0px'},250,'linear');
			 }
			 else
			{				
				 Ext.getCmp('adminskin-themeLight').setText('Dark');
				 Ext.getCmp('adminskin-themeLight').setTextAlign('right');
				 Ext.get('adminskin-themeLight').select('.switchMe').animate({duration: 150,to: {left: 0}});
				 $('#skinadminimage').animate({backgroundPosition:'-120px 0px'},250,'linear');
				 Ext.getCmp('adminskin-themeLight').toggle(true); 
			 }
		}

		if(publicJsonData['reportOptions2']==null)
		{
			Ext.getCmp('monitorskin-themeLight').setText('Light');
		    Ext.getCmp('monitorskin-themeLight').setTextAlign('left');
		    Ext.get('monitorskin-themeLight').select('.switchMe').animate({duration: 150,to: {left: Ext.get('monitorskin-themeLight').getWidth() - 23}});
		    $('#skinmonitorimage').animate({'background-position':'-240px 0px'},250,'linear');
			Ext.getCmp('skinmonitorimage').disable();
			Ext.getCmp('monitorskin-themeLight').disable();
	   }
	   else
		{
			 if(publicJsonData['userMonitorSkin']=='Light')
			  {				  
				   Ext.getCmp('monitorskin-themeLight').setText('Light');
				   Ext.getCmp('monitorskin-themeLight').setTextAlign('left');
				   Ext.get('monitorskin-themeLight').select('.switchMe').animate({duration: 150,to: {left: Ext.get('monitorskin-themeLight').getWidth() - 23}});
				   $('#skinmonitorimage').animate({'background-position':'-240px 0px'},250,'linear');
			 }
			 else
			{				
				 Ext.getCmp('monitorskin-themeLight').setText('Dark');
				 Ext.getCmp('monitorskin-themeLight').setTextAlign('right');
				 Ext.get('monitorskin-themeLight').select('.switchMe').animate({duration: 150,to: {left: 0}});
				 $('#skinmonitorimage').animate({'background-position':'-360px 0px'},250,'linear');
				 Ext.getCmp('monitorskin-themeLight').toggle(true); 
			}
		}

		if(publicJsonData['reportOptions3']==null)
		{
			Ext.getCmp('reportskin-themeLight').setText('Light');
			Ext.getCmp('reportskin-themeLight').setTextAlign('left');
			Ext.get('reportskin-themeLight').select('.switchMe').animate({duration: 150,to: {left: Ext.get('reportskin-themeLight').getWidth() - 23}});
			Ext.getCmp('skinreportimage').disable();
			Ext.getCmp('reportskin-themeLight').disable();
	   }
	   else
		{
			 if(publicJsonData['userReporterSkin']=='Light')
			  {
				   Ext.getCmp('reportskin-themeLight').setText('Light');
				   Ext.getCmp('reportskin-themeLight').setTextAlign('left');
				   Ext.get('reportskin-themeLight').select('.switchMe').animate({duration: 150,to: {left: Ext.get('reportskin-themeLight').getWidth() - 23}});
				   $('#skinreportimage').animate({'background-position':'-480px 0px'},250,'linear');				   
			 }
			 else
			{
				 Ext.getCmp('reportskin-themeLight').setText('Dark');
				 Ext.getCmp('reportskin-themeLight').setTextAlign('right');
				 Ext.get('reportskin-themeLight').select('.switchMe').animate({duration: 150,to: {left: 0}});
				 $('#skinreportimage').animate({'background-position':'-600px 0px'},250,'linear');
				 Ext.getCmp('reportskin-themeLight').toggle(true); 
			 }
		}

		if(publicJsonData['reportOptions4']==null)
		{
		   Ext.getCmp('skinconfigimage').disable();
		   Ext.getCmp('configskin-themeLight').setText('Light');
		   Ext.getCmp('configskin-themeLight').setTextAlign('left');
		   Ext.get('configskin-themeLight').select('.switchMe').animate({duration: 150,to: {left: Ext.get('configskin-themeLight').getWidth() - 23}});
		   Ext.getCmp('configskin-themeLight').disable();
	   }
	   else
		{
			 if(publicJsonData['userConfigSkin']=='Light')
			  {
				   Ext.getCmp('configskin-themeLight').setText('Light');
				   Ext.getCmp('configskin-themeLight').setTextAlign('left');
				   Ext.get('configskin-themeLight').select('.switchMe').animate({duration: 150,to: {left: Ext.get('configskin-themeLight').getWidth() - 23}});
				   $('#skinconfigimage').animate({'background-position':'-720px 0px'},250,'linear');
			 }
			 else
			{
				 Ext.getCmp('configskin-themeLight').setText('Dark');
				 Ext.getCmp('configskin-themeLight').setTextAlign('right');
				 Ext.get('configskin-themeLight').select('.switchMe').animate({duration: 150,to: {left: 0}});
				 $('#skinconfigimage').animate({'background-position':'-840px 0px'},250,'linear');
				 Ext.getCmp('configskin-themeLight').toggle(true); 
			 }
		}
		/* HKT Theme Changes starts*/
		var disableSkinAndLogoSettingsVal=publicJsonData['disableSkinAndLogoSettings'];
		var disableSkinAndLogoSettings=false;
		if(disableSkinAndLogoSettingsVal!=null && (disableSkinAndLogoSettingsVal==true || disableSkinAndLogoSettingsVal=="true"))
		{
			disableSkinAndLogoSettings=true;
		}
		if(disableSkinAndLogoSettings==true)
		{
			var skinAdminImage=Ext.getCmp('skinadminimage');
			if(!Ext.isEmpty(skinAdminImage))
			{
				skinAdminImage.disable();
			}
			var adminThemeLight=Ext.getCmp('adminskin-themeLight');
			if(!Ext.isEmpty(adminThemeLight))
			{
				adminThemeLight.disable();
			}
			var skinMonitorImage=Ext.getCmp('skinmonitorimage')
			if(!Ext.isEmpty(skinMonitorImage))
			{
				skinMonitorImage.disable();
			}
			var monitorThemeLight=Ext.getCmp('monitorskin-themeLight');
			if(!Ext.isEmpty(monitorThemeLight))
			{
				monitorThemeLight.disable();
			}
			var skinReporterImage=Ext.getCmp('skinreportimage')
			if(!Ext.isEmpty(skinReporterImage))
			{
				skinReporterImage.disable();
			}
			var reporterThemeLight=Ext.getCmp('reportskin-themeLight');
			if(!Ext.isEmpty(reporterThemeLight))
			{
				reporterThemeLight.disable();
			}
			var skinConfigImage=Ext.getCmp('skinconfigimage')
			if(!Ext.isEmpty(skinConfigImage))
			{
				skinConfigImage.disable();
			}
			var configThemeLight=Ext.getCmp('configskin-themeLight');
			if(!Ext.isEmpty(configThemeLight))
			{
				configThemeLight.disable();
			}
		}
		var disableLogoSettingsVal=publicJsonData['disableLogoSettings'];
		var disableLogoSettings=false;
		if(disableLogoSettingsVal!=null && (disableLogoSettingsVal==true || disableLogoSettingsVal=="true"))
		{
			disableLogoSettings=true;
		}
		/*  HKT Theme changes ends*/
		var loginpagecombo = Ext.getCmp('loginpage');
		if(disableLogoSettings==true || disableSkinAndLogoSettings==true)
		{
			if(!Ext.isEmpty(loginpagecombo))
			{
				loginpagecombo.disable();
			}
		}
		loginpagecombo.getStore().loadRawData(publicJsonData['reportOptions5']);
		var loginchk = publicJsonData['loginChk'];
		if (loginchk == "d") {
			loginpagecombo.setValue("Default");
		} else {
			loginpagecombo.setValue("Custom");
		}
		if(publicJsonData['disableLogoforOtherModule']==true){
			Ext.getCmp('apply_container').hide();
		}
		loginpagecombo.setEditable(false);

		var monitorpagecombo = Ext.getCmp('monitorpage');
		if(publicJsonData['hasAdminTab']==true || publicJsonData['hasMonitorTab']==true){
			if(publicJsonData['hasAdminTab']=='false' || publicJsonData['hasAdminTab']==false){
				monitorpagecombo.setFieldLabel('<span class="font_bold11">'+monitorLogo+'</span>');
			}else if(publicJsonData['hasMonitorTab']=='false' || publicJsonData['hasMonitorTab']==false){
				monitorpagecombo.setFieldLabel('<span class="font_bold11">'+adminLogo+'</span>');
			}
		monitorpagecombo.getStore().loadRawData(publicJsonData['reportOptions6']);
		var monchk = publicJsonData['monLo'];
		if (monchk == "d") {
			monitorpagecombo.setValue("Default");
		} else {
			monitorpagecombo.setValue("Custom");
		}
		monitorpagecombo.setEditable(false);
		}else{
			monitorpagecombo.hide();
			Ext.getCmp('apply_container').hide();			
			if(publicJsonData['hasReporterTab']==true){
				Ext.getCmp('reporterContainer').show();	
			}	
			if(publicJsonData['hasConfigTab']==true){
				Ext.getCmp('configContainer').show();
			}			
		}
		if(disableLogoSettings==true || disableSkinAndLogoSettings==true)
		{
			if(!Ext.isEmpty(monitorpagecombo))
			{
				monitorpagecombo.disable();
			}
			var monitorLogoUploadCtrlObj=Ext.getCmp('monitorFile');
			if(!Ext.isEmpty(monitorLogoUploadCtrlObj))
			{
				monitorLogoUploadCtrlObj.disable();
			}
		}
		var reporterpagecombo = Ext.getCmp('reporter');
		if(publicJsonData['hasReporterTab']==true){
		reporterpagecombo.getStore().loadRawData(publicJsonData['reporterOptions']);
		var reportLo = publicJsonData['reportLo'];
		if (reportLo == "d") {
			reporterpagecombo.setValue("Default");
		} else {
			reporterpagecombo.setValue("Custom");
		}
		reporterpagecombo.setEditable(false);
		}else{
			reporterpagecombo.hide();
			Ext.getCmp('reportFile').hide();            
		}
		if(disableLogoSettings==true || disableSkinAndLogoSettings==true)
		{
			if(!Ext.isEmpty(reporterpagecombo))
			{
				reporterpagecombo.disable();
			}
			var reporterLogoUploadCtrlObj=Ext.getCmp('reportFile');
			if(!Ext.isEmpty(reporterLogoUploadCtrlObj))
			{
				reporterLogoUploadCtrlObj.disable();
			}
			var apply_containerObj=Ext.getCmp('apply_container');
			if(!Ext.isEmpty(apply_containerObj))
			{
				apply_containerObj.disable();
				apply_containerObj.hide();
			}
		}
		var configurationpagecombo = Ext.getCmp('configuration');
		if(publicJsonData['hasConfigTab']==true){
		configurationpagecombo.getStore().loadRawData(publicJsonData['configOptions']);
		var configLo = publicJsonData['configLo'];
		if (configLo == "d") {
			configurationpagecombo.setValue("Default");
		} else {
			configurationpagecombo.setValue("Custom");
		}
		configurationpagecombo.setEditable(false);
		}else{
			configurationpagecombo.hide();
			Ext.getCmp('configFile').hide();
		}
		if(disableLogoSettings==true || disableSkinAndLogoSettings==true)
		{
			if(!Ext.isEmpty(configurationpagecombo))
			{
				configurationpagecombo.disable();
			}
			var configurationLogoUploadCtrlObj=Ext.getCmp('configFile');
			if(!Ext.isEmpty(configurationLogoUploadCtrlObj))
			{
				configurationLogoUploadCtrlObj.disable();
			}
		}

		var languagecombo = Ext.getCmp('language');
		languagecombo.getStore().loadRawData(publicJsonData['reportOptions7']);
		languagecombo.setValue(publicJsonData['userLanguage']);
		languagecombo.setEditable(false);

		var monhomecombo = Ext.getCmp('monhomepage');
		/*monhomecombo.getStore().loadRawData(publicJsonData['monhomearray']);
		monhomecombo.setValue(publicJsonData['monHomePage']);
		monhomecombo.setEditable(false);*/
		var monitorHomePageSelection=publicJsonData['monitorHomePageSelection'];

		var monitorHomeOptRadioGrpObj=Ext.getCmp('userProf_monitorHomeOpt');
		if(!Ext.isEmpty(monitorHomeOptRadioGrpObj))
		{

			monitorHomeOptRadioGrpObj.suspendEvents(false);
			monitorHomeOptRadioGrpObj.setValue({
				selectedMonHomeOpt: monitorHomePageSelection
			});
			monitorHomeOptRadioGrpObj.resumeEvents();
			monitorHomeOptRadioGrpObj.on('change',function(){
				var monitorHomeOptObj = monitorHomeOptRadioGrpObj.getChecked();
				var monitorHomeOpt = monitorHomeOptObj[0].inputValue;
				if(monitorHomeOpt!=null && monitorHomeOpt=='dynamic')
				{
					monhomecombo.getStore().removeAll();
					monhomecombo.getStore().loadRawData(publicJsonData['monitoringDomains']);
					monhomecombo.setValue(publicJsonData['selectedMonitorDomain']);
					monhomecombo.previousSelectedOption=publicJsonData['selectedMonitorDomain'];
				}
				else
				{
					monhomecombo.getStore().removeAll();
					monhomecombo.getStore().loadRawData(publicJsonData['monhomearray']);
					monhomecombo.setValue(publicJsonData['monHomePage']);
					monhomecombo.previousSelectedOption='';
				}
			});
		}
		var selectedMonHomePageOpt=publicJsonData['selectedMonitorDomain'];
		if(monitorHomePageSelection!=null && monitorHomePageSelection=='dynamic')
		{
			monhomecombo.getStore().removeAll();
			monhomecombo.getStore().loadRawData(publicJsonData['monitoringDomains']);
			monhomecombo.setValue(publicJsonData['selectedMonitorDomain']);
			monhomecombo.previousSelectedOption=publicJsonData['selectedMonitorDomain'];
		}
		else
		{
			monhomecombo.getStore().removeAll();
			monhomecombo.getStore().loadRawData(publicJsonData['monhomearray']);
			monhomecombo.setValue(publicJsonData['monHomePage']);
			monhomecombo.previousSelectedOption='';
		}

		try
		{
			if(!Ext.isEmpty(publicJsonData.isonlyVM) && ( publicJsonData.isonlyVM == 'true' || publicJsonData.isonlyVM == true))
				Ext.getCmp("monHomeField").hide();
		}
		catch (e)
		{
		}

		var applymodules = publicJsonData['logoCheck'];

		if (applymodules == "difference") {
			Ext.getCmp('apply').setValue(false);
		} else {
			Ext.getCmp('apply').setValue(true);
		}

		var refresh = publicJsonData['refreshFreq'];
		var slider = Ext.getCmp('frequency');
		slider.reset();
		slider.setValue(refresh);
		// Fix to hide combo if monitor Tab is not available
		if(hasMonitorTab == false)
		{
			monhomecombo.hide();
			slider.hide();
		}

        var timeZoneCombo=Ext.getCmp('timeZone');
		timeZoneCombo.getStore().loadRawData(publicJsonData['timeZone']);
		timeZoneCombo.setValue(publicJsonData['selectedTimeZone']);
		var userDateFormat = Ext.getCmp('userDateFormat');
		userDateFormat.getStore().loadRawData(publicJsonData['userDateFormat']);
		userDateFormat.setValue(publicJsonData['selectedDateFormat']);
		var TvModeArray = publicJsonData.MonitorScreensForTvMode;
		var ListOfScreens = publicJsonData.ListOfScreens;
		
		//if(publicJsonData['isAlarmViewerUser']=='true'){
			//Ext.getCmp('hideThisPanel').hide();
		//}

		// 2fa - starts here
		var isAdminEnabled2FA = publicJsonData.isAdminEnabled2FA;
		var isUsrEnabled2FA = publicJsonData.isUsrEnabled2FA;
		var tfaUserOTPMode = publicJsonData.tfaUserOTPMode;
		var disable2FAFlag = publicJsonData.disable2FAFlag;

		if (!Ext.isEmpty(isAdminEnabled2FA) && (isAdminEnabled2FA.toLowerCase() == "true" || isAdminEnabled2FA.toLowerCase() == "yes"))
		{
			Ext.getCmp('securitysettings').show();

			if (!Ext.isEmpty(disable2FAFlag) && disable2FAFlag.toLowerCase() == "yes") //disable2FAFlag=yes|true means Admin made 2FA compulsory.
			{
				Ext.getCmp('is2FAEnabled').setDisabled(true);
				//Ext.getCmp('is2FAEnabled').setValue(true);
				Ext.getCmp('enable2FAYesFlag').setValue(true);
			}
			else // 2FA is optional
			{
				Ext.getCmp('is2FAEnabled').setDisabled(false);
				if (!Ext.isEmpty(isUsrEnabled2FA) && (isUsrEnabled2FA.toLowerCase() == "true" || isUsrEnabled2FA.toLowerCase() == "yes"))
				{
					Ext.getCmp('enable2FAYesFlag').setValue(true);
				}
				else
				{
					Ext.getCmp('enable2FAYesFlag').setValue(false);
				}
			}


			var twoFAEnableFlag = Ext.getCmp('enable2FAYesFlag').getGroupValue();
			if (!Ext.isEmpty(twoFAEnableFlag) && twoFAEnableFlag.toLowerCase() == "yes")
			{
				Ext.getCmp('twoFAOTPMode').show();
				if (!Ext.isEmpty(tfaUserOTPMode) && tfaUserOTPMode.toLowerCase() == "mail")
				{
					Ext.getCmp('mail').setValue(true);
				}
				else if (!Ext.isEmpty(tfaUserOTPMode) && tfaUserOTPMode.toLowerCase() == "sms")
				{
					Ext.getCmp('sms').setValue(true);
				}
				else if (!Ext.isEmpty(tfaUserOTPMode) && tfaUserOTPMode.toLowerCase() == "ga")
				{
					Ext.getCmp('ga').setValue(true);
				}
			}
			else
			{
				Ext.getCmp('twoFAOTPMode').hide();
			}
		}
		else
		{
			Ext.getCmp('securitysettings').hide();
			Ext.getCmp('enable2FAYesFlag').setValue(false);
		}


		// 2fa - ends here

	}
});