Ext.define('UserProfile.view.UserDetails', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.userdetails',
	id:'userdetails',
    //bodyPadding: 7,
    layout: 'column',
	cls:'userProfileOuter',
	columnWidth:1,
    defaults: {
		 margin: '10 20 10 20'
    },
    items: [{
        xtype: 'container',
		columnWidth:.40,
        style: {
            'font-weight': 'bold'
        },
        items: [
		{
			xtype:'container',
			layout:'vbox',
			items:[{
				xtype: 'label',
				cls:'font_bold',
				id: 'userIdLbl',
				name: 'userIdLbl',
				margin:'0 0 5 0'
				},
				{
					xtype: 'label',
					id: 'userDetails1Lbl',
					name: 'userDetails1Lbl'
				}]
		}]

    }, {
        fieldLabel: 'Existing Password',
		labelClsExtra:'font_bold',
        xtype: 'textfield',
        //allowBlank: false,
        id: 'oldPwd',
        name: 'oldPwd',
		columnWidth:.20,
        labelSeparator: '',
        labelAlign: 'top',
        cls: 'textbox', // size
        inputType: 'password'
    },
	{
		xtype: 'fieldcontainer',
		fieldLabel: 'New Password',
		labelClsExtra:'font_bold',
		labelSeparator: '',
		labelAlign: 'top',
		id : 'pasCont',
		layout: {
			type: 'vbox',
			pack: 'start',
			align: 'stretch'
		},
		columnWidth:.20,
		items: [
			{
				xtype: 'textfield',
				//allowBlank: false,
				id: 'newPwd',
				name: 'newPwd',
				cls: 'textbox',
				inputType: 'password',
				listeners:{
					blur :function()
					{
						Ext.getCmp('passScore').hide();
					},
					focus:function()
					{
						if(publicJsonData['editMailID']){
							Ext.getCmp('passScore').show();
						}
					}
				}
			},
			{
				xtype:'label',
				id: 'passScore',
				name: 'passScore',
				//text: passLabel,
				textAlign: 'left',
				cls: 'font_normal9',
				hidden:true
			}
		]
	},
	{
        fieldLabel: 'Confirm New Password',
		labelClsExtra:'font_bold',
        xtype: 'textfield',
        //allowBlank: false,
		id: 'confPwd',
        name: 'confPwd',
		columnWidth:.20,
        labelSeparator: '',
        labelAlign: 'top',
        cls: 'textbox', // size
        inputType: 'password'

    }],
    loadDefaultData: function () {
        var userIdLbl = Ext.getCmp('userIdLbl');
        userIdLbl.setText(publicJsonData['screenLabels']['admin.profile.User Id']);


        var userDetails1Lbl = Ext.getCmp('userDetails1Lbl');
        userDetails1Lbl.setText(publicJsonData['UserId']);
        //userDetails1Lbl.(publicJsonData['user_Expiry']);

		var isDomainUser = publicJsonData['isDomainUser'];
		
		var oldPwdObj = Ext.getCmp('oldPwd');
		var newPwdObj = Ext.getCmp('pasCont');
		var confPwdObj = Ext.getCmp('confPwd');
		if(isDomainUser!=null && isDomainUser=="true")
		{
			oldPwdObj.hide();
			newPwdObj.hide();
			confPwdObj.hide();
		}
		else
		{	
			var isMailEditable = publicJsonData['editMailID'];						
			oldPwdObj.setFieldLabel(publicJsonData['screenLabels']['admin.profile.Existing Password']);

			
			//newPwdObj.setValue(publicJsonData['newPwd']);
			newPwdObj.setFieldLabel(publicJsonData['screenLabels']['admin.profile.New Password']);

			
			confPwdObj.setFieldLabel(publicJsonData['screenLabels']['admin.profile.Confirm New Password']);
			//confPwdObj.setValue(publicJsonData['newPwd']);
			if(!isMailEditable){
				oldPwdObj.setReadOnly(true);
				Ext.getCmp('newPwd').setReadOnly(true);
				confPwdObj.setReadOnly(true);
			}
		}
    }
})