Ext.define('UserProfile.view.dailyEmailSettings', {
	extend: 'Ext.panel.Panel',
    alias: 'widget.dailyemailsettings',
	id:'dailyemailsettings',
    bodyPadding: 10,
	//margin:'10 10 10 10',
    //layout: 'column',
    requires: ['utilities.CommonPanel','Ext.ux.form.MultiSelectSI','Ext.ux.form.ItemSelectorSI','utilities.ScrollCombo','utilities.ErUtils','utilities.Multiselector','utilities.CustomTrigger',],
	cls:'userProfileOuter',
	//columnWidth:1,
	height:490,
	width:770,
	layout:'vbox',
	scroll:true,
	autoScroll:true,
	data:'',
    listeners: {
		'beforerender':function(){
			editSuspend=false;
		}
    },
	items:[
		{
			xtype: 'panel',
			columnWidth:.9,
			id:'dms_panel',
			layout:'vbox',
			border:true,
			items:[
				{
					xtype:'container',
					//columnWidth:0.4,
					//margin:'0 10 0 0',
					layout:'vbox',
					items:[
						/*{
							xtype:'label',
							text:'Daily Emailer Settings :',
							style:{'font-size':'12px','font-weight':'bold'}
						},
						{
							xtype:'container',
							width:'auto',
							height:10
						},*/
						{
							xtype: 'textfield',
							//margin: '0 40 10 0',
							id: 'schedName',
							name: 'schedName',
							width:'auto',
							labelAlign: 'top',
							fieldLabel: '<span class="font_bold">Report Name</span>',
							cls: 'textbox',
							allowBlank:false,
							maxLength:50,
							enforceMaxLength:true,
							width: 190,
							listeners : {
								'blur':function(){
									if(!editSuspend){
										if(Ext.isEmpty(this.value))
											return;
										var va=  validateChar(this.value);
										if(va == null)
										{
											Ext.MessageBox.show({
												title : 'Alert',
												msg : 'Schedule Already Exists',
												buttons : Ext.MessageBox.OK,
												icon : Ext.MessageBox.WARNING,
											});
											//Ext.getCmp('dms_container_in').setDisabled(true);
											return;
										}
										else if(!va)
										{
											Ext.MessageBox.show({
												title : 'Alert',
												msg : 'Special characters not Allowed',
												buttons : Ext.MessageBox.OK,
												icon : Ext.MessageBox.WARNING,
											});
											//Ext.getCmp('dms_container_in').setDisabled(true);
											return;
										}
										//Ext.getCmp('dms_container_in').setDisabled(false);
										//Ext.getCmp('appliesTo').setValue("-1");
										Ext.getCmp('sc_hr').setValue("00");
										Ext.getCmp('sc_min').setValue("00");
									}
								}
							}
						}
					]
				},
				{
					xtype:'container',
					id:'dms_container_in',
					layout: {
						type: 'table',
						columns: 3
					},
					//disabled:true,
					height:'auto',
					items:[
						{
							xtype:'scrollcombo',
							labelAlign: 'top',
							fieldLabel: '<span class="font_bold">Report for</span>',
							cls: 'dropdown',
							labelSeparator: '',
							id: 'appliesTo',
							name: 'appliesTo',
							margin: '0 40 10 0',
							forceSelection:false,
							//labelWidth: 150,
							//width: 'auto',
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							store: new Ext.data.Store({
								fields: ['displayField', 'valueField'],
								data: []
							}),
							listeners : {
								'change':function(){
									var val = this.getValue();
									var valRaw = this.getRawValue();
									if(val != '-1')
									{
										var data;
										try
										{
											data = Ext.getCmp('dailyemailsettings').data.data;
										}
										catch (e)
										{
										}
										
										if(val == 'ComponentType' || val == 'Components')
											Ext.getCmp('email_type').setVisible(false);
										else
											Ext.getCmp('email_type').setVisible(true);
										
										if(data != null && data != undefined && data[val] != undefined){
											var el = data[val];
											if(val == 'Components')
											{
												Ext.getCmp('comp_container').setVisible(true);
												Ext.getCmp('applied_by').setVisible(false);
												Ext.getCmp('comp_type_for').getStore().loadRawData(data['ComponentType']);
											}
											else
											{
												Ext.getCmp('comp_container').setVisible(false);
												Ext.getCmp('applied_by').setVisible(true);
												Ext.getCmp('applied_by').getStore().loadRawData(el);
												var value1 = Ext.getCmp('applied_by').getStore().getAt(0).get('valueField');
												Ext.getCmp('applied_by').setValue(value1);
												Ext.getCmp('applied_by').setFieldLabel('<span class="font_bold"> '+valRaw+' </span>');
											}
										}
									}
									else
										Ext.getCmp('applied_by').getStore().loadRawData();

									Ext.getCmp('temp_name').getStore().loadRawData('');
									Ext.getCmp('temp_name').setRawValue('Select a template');
									Ext.getCmp('email_type').getStore().loadRawData('');
									Ext.getCmp('email_type').setRawValue('Select a email type');
									Ext.getCmp('email_type').setDisabled(false);

									try
									{
										//var span_el = document.getElementById('view_temp_id');
										//span_el.style.display='none';
									}
									catch (e)
									{
									}

								}
							}
						},
						{
							xtype: 'container',
							layout: 'hbox',
							margin: '0 40 10 0',
							id:'comp_container',
							hidden:true,
							items: [{
								xtype: 'container',
								width: 220,
								margin: 0,
								items: [
									{
										xtype:'scrollcombo',
										margin: '0 40 10 0',
										labelAlign: 'top',
										fieldLabel: '<span class="font_bold"> Components </span>',
										cls: 'dropdown',
										labelSeparator: '',
										id: 'comp_type_for',
										name: 'comp_type_for',
										width: 220,
										forceSelection:false,
										value:'Please select',
										displayField: 'displayField',
										valueField: 'valueField',
										queryMode: 'local',
										store: new Ext.data.Store({
											fields: ['displayField', 'valueField'],
											data: []
										}),
										listeners : {
											'select':function(){
												var val = this.getValue();
												Ext.Ajax.request({
													url:'/final/admin/UserProfile/data/userProfileDailyMail.jsp?getComponents=true&comp_type='+val,
													scope:this,
													success: function (response) {
														if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
															var jsonText = response.responseText;
															var jsonData = Ext.decode(jsonText);
															compRawData = jsonData['data'];
															Ext.getCmp('el_component').getStore().loadRawData(jsonData['data']);
														}
													}
												});
											}
										}
									},
									{
										xype: 'container',
										cls: 'multisearchlist',
										items: [{
											xtype: 'customtrigger',
											emptyText: 'Search Components',
											id: 'compSearch',
											cls: 'whitedropdown_search',
											listeners:
											{
												'change':function(obj)
												{
													if (Ext.isEmpty(this.erUtils))
													{
														this.erUtils = Ext.widget("erutils");
													}
													this.erUtils.filterComboStore(obj,Ext.getCmp("el_component"),compRawData);
												}
											}
										}]
									}, 
									{
										width: 220,
										xtype: 'multiselectfield',
										autoScroll: false,
										scroll: false,
										height: 90,
										labelAlign: 'left',
										allowBlank: false,
										id: 'el_component',
										name: 'el_component',
										store: new Ext.data.Store({
											fields: ['displayField', 'valueField'],
											data: []
										}),
										displayField: 'displayField',
										valueField: 'valueField',
										queryMode: 'local'
									}
								]
							}, 
							{
								xtype: 'container',
								margin: '50 0 0 5',
								items: [{
									xtype: 'button',
									iconCls: 'iconMultiselectExpand',
									id: 'expandSelector',
									name: 'expandSelector',
									listeners: {
										afterrender: function() {
											Ext.create('Ext.tip.ToolTip', {
												target: this.id,
												anchor: 'top',
												cls: 'yellowTip',
												trackMouse: true,
												html: 'Expand'
											});
										},
										'click':function(btn)
										{
											if (Ext.isEmpty(this.erUtils))
											{
												this.erUtils = Ext.widget("erutils");
											}
											this.erUtils.expandMultiComboButton(Ext.getCmp('el_component'),'Components List',btn);
										}
									},
									style: {
										background: 'none',
										border: '0px'
									}
								}]
							}]
						},
						{
							xtype:'scrollcombo',
							margin: '0 40 10 0',
							labelAlign: 'top',
							fieldLabel: '<span class="font_bold"> All </span>',
							cls: 'dropdown',
							labelSeparator: '',
							id: 'applied_by',
							name: 'applied_by',
							forceSelection:false,
							//labelWidth: 150,
							//width: 'auto',
							//value:'--select--',
							value:'Please select',
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							store: new Ext.data.Store({
								fields: ['displayField', 'valueField'],
								data: []
							}),
						},
						{
							xtype:'scrollcombo',
							margin: '0 40 10 0',
							labelAlign: 'top',
							//fieldLabel: '<span class="font_bold">Template Name</span><span onclick="viewTemplate()" style="display:none;margin-left: 10px;" id="view_temp_id" class="iconDetailedList"></span>',
							fieldLabel: '<a class="font_bold" >Template Name</a><div border="0" style="border:none !important;vertical-align:middle;display:none;margin-right:10px;margin-top:-2px;margin-left:5px;" onclick="viewTemplate()" id="view_temp_id" class="iconDetailedList"></div>',
							cls: 'dropdown',
							labelSeparator: '',
							id: 'temp_name',
							name: 'temp_name',
							forceSelection:false,
							//labelWidth: 150,
							//width: 'auto',
							//value:'--select--',
							value:'Select a template',
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							store: new Ext.data.Store({
								fields: ['displayField', 'valueField'],
								data: []
							}),
							listeners:{
								'change':function(){
									/*try
									{
										var temp_name = this.getValue();
										var span_el = document.getElementById('view_temp_id');
										if(!Ext.isEmpty(temp_name) && temp_name.indexOf('Select') == -1)
											span_el.style.display='inline-block';
										else
											span_el.style.display='none';
									}
									catch (e)
									{
									}*/
									
								}
							}							
						},
						{
							xtype:'scrollcombo',
							margin: '0 40 10 0',
							labelAlign: 'top',
							fieldLabel: '<span class="font_bold"> Component Type </span>',
							cls: 'dropdown',
							labelSeparator: '',
							id: 'email_type',
							name: 'email_type',
							forceSelection:false,
							//labelWidth: 150,
							//width: 'auto',
							//value:'--select--',
							hidden:true,
							value:'Select a email type',
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							store: new Ext.data.Store({
								fields: ['displayField', 'valueField'],
								data: []
							}),
						},
						{
							xtype:'scrollcombo',
							margin: '0 40 10 0',
							labelAlign: 'top',
							fieldLabel: '<span class="font_bold">Hr</span>',
							cls: 'dropdown',
							labelSeparator: '',
							id: 'sc_hr',
							name: 'sc_hr',
							forceSelection:false,
							//labelWidth: 150,
							//width: 'auto',
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							store: new Ext.data.Store({
								fields: ['displayField', 'valueField'],
								data: []
							}),
						},
						{
							xtype:'scrollcombo',
							margin: '0 40 10 0',
							labelAlign: 'top',
							fieldLabel: '<span class="font_bold">Min</span>',
							cls: 'dropdown',
							labelSeparator: '',
							id: 'sc_min',
							name: 'sc_min',
							forceSelection:false,
							//labelWidth: 150,
							//width: 'auto',
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							store: new Ext.data.Store({
								fields: ['displayField', 'valueField'],
								data: []
							}),
						},
						{
							xtype:'scrollcombo',
							margin: '0 40 10 0',
							labelAlign: 'top',
							fieldLabel: '<span class="font_bold">Type</span>',
							cls: 'dropdown',
							labelSeparator: '',
							id: 'mail_type',
							name: 'mail_type',
							forceSelection:false,
							//labelWidth: 150,
							//width: 'auto',
							displayField: 'displayField',
							valueField: 'valueField',
							queryMode: 'local',
							store: new Ext.data.Store({
								fields: ['displayField', 'valueField'],
								data: []
							}),
						},
						{
							xtype: 'textfield',
							//margin: '0 40 10 0',
							id: 'mailId',
							name: 'mailId',
							width: 190,
							//vtype: 'email',
							labelAlign: 'top',
							fieldLabel: '<span class="font_bold">Email</span>',
							cls: 'textbox',
							//width: 150,
						}
					]
				},
				{
					xtype:'container',
					height:'auto',
					width:'auto',
					align:'center',
					margin: '15 0 0 330',
					items:[{
						xtype: 'button',
						margin: 'auto',
						align:'center',
						id: 'sm_button',
						name: 'sm_button',
						text: '<span class="font_bold">Add</span>',
						cls: 'button20',
						width: 'auto',
					}]
				},
				
			]
		},
		{
			xtype:'container',
			height:10,
			width:'auto'
		},
		{
			xtype: 'grid',
			columns: [{}],
			store: Ext.create('Ext.data.ArrayStore', {}),
			title:'Configured Reports',
			stateful: true,
			layout:'fit',
			//border:true,
			width:'97%',
			height:210,
			autoScroll:'true',
			id:'listGrid',
			itemId:'listGrid',
			cls:'gridSkin',
			listeners:{
				'afterrender':function(){
					try
					{
						
					}
					catch (e)
					{
					}
					
				}
			}
		}
			

	]
});

function viewTemplate(){
	try
	{
		var temp_name = Ext.getCmp('temp_name').getValue();
		var email_type = Ext.getCmp('email_type').getValue();
		var appliesTo = Ext.getCmp('appliesTo').getValue();
		var applied_by = Ext.getCmp('applied_by').getValue();
		if(!Ext.isEmpty(temp_name) && temp_name.indexOf('-select-') == -1){
			Ext.Ajax.request({
				url:'/final/admin/UserProfile/data/userProfileDailyMail.jsp?viewTemplateConfig=true&template='+temp_name+'&email_type='+email_type+'&appliesTo='+appliesTo+'&applied_by='+applied_by,
				scope:this,
				success: function (response) {
					//alert("sdf")
					if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						if(!Ext.isEmpty(jsonData)){
							if(!Ext.isEmpty(Ext.getCmp('panelConfigWin')))
								Ext.getCmp('panelConfigWin').destroy();
							
							Ext.create('UserProfile.view.panelConfigWin',{
								data:jsonData
							}).show();
						}
					}
				}
			});
		}
	}
	catch (e)
	{
		alert(e)
	}
	
}

function viewGridTemplate(temp_name,email_type,appliesTo,applied_by){
	try
	{
		if(!Ext.isEmpty(temp_name) && temp_name.indexOf('-select-') == -1){
			Ext.Ajax.request({
				url:'/final/admin/UserProfile/data/userProfileDailyMail.jsp?viewTemplateConfig=true&template='+temp_name+'&email_type='+email_type+'&appliesTo='+appliesTo+'&applied_by='+applied_by,
				scope:this,
				success: function (response) {
					//alert("sdf")
					if (response.status == 200 && !Ext.isEmpty(response.responseText)) {
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						if(!Ext.isEmpty(jsonData)){
							if(!Ext.isEmpty(Ext.getCmp('panelConfigWin')))
								Ext.getCmp('panelConfigWin').destroy();

							Ext.create('UserProfile.view.panelConfigWin',{
								data:jsonData
							}).show();
						}
					}
				}
			});
		}
	}
	catch (e)
	{
		alert(e)
	}
	
}