Ext.define('ViewSchedule.controller.ViewScheduleController',{
	extend:'Ext.app.Controller',
	views:['Main','ScheduleConfig'],
	refs:[
		{selector:'main',ref:'main'},
		{selector:'scheduleconfiggrid',ref:'scheduleconfiggrid'}
	],
	searchTask: new Ext.util.DelayedTask(function(){
		appConstants.appObj.getController('ViewScheduleController').doFilter();
	}),
	init:function(){
		appConstants.appObj=this;
		this.control(
		{
			'main':
			{
				'afterrender':this.afterMainRender
			},
			'scheduleconfiggrid textfield[name="livesearch"]':
			{
				change:this.typewatch
			},
			'scheduleconfiggrid':{
				'afterrender':this.getHei
			},
			'scheduleconfiggrid button[name="DeleteAll"]':
			{
				'click' : this.deleteSchedules
			}
		});
	},
	getHei:function(){
			Ext.getCmp('scheduleConfigGrid').setHeight(Ext.getCmp('optionsscheduleconfig').body.getHeight()-10);
	},
	deleteSchedules : function()
	{
		var grid = Ext.getCmp("scheduleConfigGrid");
		var favoriteListGridStore = grid.getStore();
		var noOfrecords = favoriteListGridStore.getCount();
		var selectionModelObj = grid.getSelectionModel();
		if ( noOfrecords > 0 )
		{
			var schSelected=false;
			if(selectionModelObj.getSelection().length>0)
				schSelected=true;
			if(schSelected){

				Ext.Msg.show({
					title:scheduleLabel,
					msg:conformMsg+'?',
					buttons: Ext.Msg.YESNO,
					icon: Ext.Msg.QUESTION,
					fn:function(buttonId)
					{
						if(buttonId =="yes")
						{
							var sch_id="";
							var sch_name="";
							var mid = "";

							var selected = selectionModelObj.getSelection();

							if(selected.length>0)
							{
								for(var i=0;i<selected.length;i++)
								{
									if(i!=0) {
										 sch_name+=",";
									         sch_id += ",";
									}
									var recOrg = selected[i];
									sch_id += recOrg.get('sch_id');
									mid +='&mid='+encodeURIComponent(recOrg.get('sch_id'));
									sch_name += recOrg.get('scheduleName');
									grid.store.remove(recOrg);
								}
							}
							document.location = "/final/servlet/com.eg.AdminScheduler?fromNavLink="+fromNavLink+"&cmd=Delete&id="+encodeURIComponent(sch_id)+"&sch_name="+encodeURIComponent(sch_name)+mid;
						}
					}
				});
			}
			else{
				Ext.Msg.show({
				title:scheduleLabel,
				 msg: scheduleAlertMsg,
				buttons: Ext.Msg.OK,
				icon: Ext.Msg.WARNING
			 });
			return;
			}
		}
	},
	typewatch:function(field, event){
  		 this.searchTask.delay(10);
	},
	doFilter:function(){

		var field=Ext.getCmp('livesearch');
		var dummyArray=Ext.getCmp('scheduleConfigGrid').dummyArray;
		var dataArray=Ext.getCmp('scheduleConfigGrid').dataArray;
		if(Ext.String.trim(field.value).length > 0 && (Ext.String.trim(field.value) != '' || Ext.String.trim(field.value) != null))
		{
			Ext.getCmp('scheduleConfigGrid').getStore().removeAll();
			var regex = RegExp(field.value, 'i');
			dataArray.splice(0, dataArray.length);
			for(var key in dummyArray)
			{
				var match = false;
				var obj=dummyArray[key];
				Ext.Object.each(obj, function (property, value) {
					match =match || regex.test(String(value));
				});
				if(match)
					dataArray.push(obj);
			}
			Ext.getCmp('scheduleConfigGrid').getStore().load();
		}
		else
		{
			Ext.getCmp('scheduleConfigGrid').getStore().removeAll();
			dataArray.splice(0, dataArray.length);
			for(var key in dummyArray)
			{
				var obj=dummyArray[key];
				dataArray.push(obj);
			}
			Ext.getCmp('scheduleConfigGrid').getStore().loadRawData(dataArray);
			Ext.getCmp('scheduleConfigGrid').getStore().load();
		}
		field.focus();
		field.toggleTriggger();
	},
	loadMask: function()
	{
		initLoadMask.show();
	},
	afterMainRender:function()
	{
		var me = this;
		Ext.Ajax.request({
			url: '/final/servlet/com.eg.AdminScheduler',
			method: 'POST',
			params: defaultQStr,
			success: function( response )
			{
				try
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						if ( !Ext.isEmpty( jsonText ) )
						{
							var jsonData = Ext.decode( jsonText );
							publicJsonData = jsonData;
							if ( !Ext.isEmpty( publicJsonData ) )
							{
								try
								{
									var  rootJson = publicJsonData['rootJson'];
									var screenLabels = rootJson['screenLabels'];
									me.getMain().setTitle(screenLabels['reporter.common.SCHEDULES']);
									var resultpanel = Ext.getCmp("resultPanel");

									var scheduleGridData = rootJson['scheduleListJson'];
									if(!Ext.isEmpty(scheduleGridData))
									{
										var recordsPerPage =rootJson['recordsPerPage'];
										resultpanel.add({
											xtype: 'scheduleconfiggrid',
											dataArray :scheduleGridData,
											pageLimit : recordsPerPage,
											screenLabels : screenLabels
										});
										Ext.getCmp('livesearch').focus(true, 500);
									}
									else
									{
										var errorMsg = rootJson.screenLabels['errorMsg'];
										if(!Ext.isEmpty(errorMsg))
										{
											resultpanel.add({
											xtype:'panel',
											height:550,
											style:{'text-align':'center','padding':'200px 0px'},
											html:'<div class = "iconExclamation" style="margin:0 auto"></div><div>'+errorMsg+'</div>'
										});
										}
									}
									resultpanel.doLayout();
								}
								catch (e)
								{
									alert('Error in afterMainRender---->'+e);
								}
							}
						}
					}
				}
				catch(e)
				{
					alert(e);
				}
			}
		});
	}
});

function doCloseWin()
{
	Ext.getCmp('scheduleWin').destroy();
}



