Ext.define('ViewSchedule.view.ScheduleConfig',{
	extend:'utilities.CustomGrid',
	alias:'widget.scheduleconfiggrid',
	id:'scheduleConfigGrid',
	cls:'gridSkin favapp',
	border:false,
	screenLabels:null,
	dataArray : null,
	dummyArray : null,
	pageLimit: 2,
	activePage:1,
	margin:'5',
	title: configSchedule,

	requires:[
		'Ext.ux.grid.FiltersFeature',
		'Ext.ux.data.PagingMemoryProxy',
		'utilities.CustomGrid'
	],

	viewConfig: {
		emptyText : '<table width="100%"><tr><td align="center" valign="middle"><div class="iconExclamation" style="margin:18% auto 0% auto"></div><div style="font-size:12px">'+emptyText+'<div></td></tr></table>'
	},

	initComponent: function(){
		var filters = {
			ftype: 'filters',
			encode: false,
			local: true,
			filters: [
				{
					dataIndex:'scheduleName',
					type : 'string'
				},
				{
					dataIndex:'reportName',
					type : 'string'
					
				},
				{
					dataIndex:'mailFrequency',
					type : 'string'
				},
				{
					dataIndex:'printFrequency',
					type : 'string'
				},
				{
					dataIndex:'creationTime',
					type : 'string'
				}
			]
		};

		this.features= [filters];
		this.addListener('viewready',this.showGridCellToolTip,this);
		this.selModel  = new Ext.selection.CheckboxModel({
			checkOnly: true,
			width:45,
			injectCheckbox: 'first'
		});

		this.dummyArray=this.dataArray.slice();
		this.store = Ext.create('Ext.data.Store', {
			fields: ['sch_id','scheduleName','scheduleUrl','reportName','mailFrequency','printFrequency','creationTime'],
			proxy : {
				type : 'pagingmemory',
				reader : {
					type : 'json'
				}
			},
			pageSize:17,
			autoLoad : true,
			data : this.dataArray,
			//remoteSort: true,
			id: 'tmpStore'
		});

		this.columns = [
			{
				dataIndex:'scheduleName',
				header:this.screenLabels["reporter.common.SCHEDULE NAME"],
				sortable :true,
				flex:2,
				renderer :function(value, metaData, record, row, col, store, gridView)
				{
					var dispVal = value;
					var hrefUrl = record.get('scheduleUrl');
					if(!Ext.isEmpty(hrefUrl) && hrefUrl!="-")
					{
						hrefUrl+='&showSchWindow=no&redirected_csrfToken='+csrfToken;
						dispVal = '<a href="'+hrefUrl+'">'+value+'</a>';
					}
					return dispVal;
				}
			},
			{
				dataIndex:'reportName',
				header:this.screenLabels["reporter.common.REPORT TYPE"],
				flex:2,
				sortable :true,
				renderer :function(value, metaData, record, row, col, store, gridView)
				{
					return value;
				}
			},
			{
				dataIndex:'mailFrequency',
				header:this.screenLabels["reporter.common.MAIL"],
				flex:0.4,
				sortable :false,
				align:'center',
				renderer :function(value, metaData, record, row, col, store, gridView)
				{
					return value;
				}
			},
			{
				dataIndex:'printFrequency',
				header:this.screenLabels["reporter.common.PRINT"],
				flex:0.4,
				sortable :false,
				align:'center',
				hidden: true,
				renderer :function(value, metaData, record, row, col, store, gridView)
				{
					return value;
				}
			},
			{
				dataIndex:'creationTime',
				header:this.screenLabels["reporter.common.CREATION TIME"],
				flex:0.75,
				sortable :false,
				align:'center',
				renderer :function(value, metaData, record, row, col, store, gridView)
				{
					return value;
				}
			}
		];

		var meGrid = this;

		this.dockedItems = [
			{
				xtype:'pagingtoolbar',
				cls:'pagingtoolbar',
				dock: 'bottom',
				displayInfo: true,
				cls:'pagingtoolbar',
				id:'schedulePaging',
				name:'schedulePaging',
				pageSize:this.pageLimit,
				store: this.store,
				displayInfo: true,
				beforePageText : pageLabel,
				afterPageText  : ofLabel+' {0}',
				displayMsg: topicsLabel1+' {0} - {1} '+ofLabel+' {2}',
				emptyMsg: topicsLabel2,
				listeners: {
					change : function(thisd, params)
					{
						if(!Ext.isEmpty(params))
						{
							meGrid.activePage = params.currentPage;
						}
						else
						{
							meGrid.activePage=0;
						}
					}
				}
			}
		]

		this.callParent();
	},

	listeners:{
		sortchange:function(ct, column, e, t, eOpts ){
			this.getStore().loadPage(this.activePage);
		}
	},

	tools: [
		{
			xtype:'customtrigger',
			id :'livesearch',
			name: 'livesearch',
			enableKeyEvents: true
		},
		{
			xtype : 'button',
			id : 'DeleteAll',
			cls:'button20',
			name : 'DeleteAll',
			margin:'0 0 0 10',
			text : deleteLabel,
			style:{'text-align':'right'}
		}
	]
});



