Ext.define('ViewThreshold.controller.Main',{
	extend: 'Ext.app.Controller',
	refs:[
		{selector:'threshview', ref:'threshview'},
		{selector:'print', ref:'print'},
		{selector:'downloadutils', ref:'downloadutils'}
	],
	init:function(){
		main = this;
		this.control({
			'threshview':
			{
				'afterrender': this.afterMainRender
			},
			'threshview combo[id="compTypeCombo"]':
			{
				'select': this.compTypeComboLoad
			},
			'threshview combo[id="compNameCombo"]':
			{
				'select': this.compNameComboLoad
			},
			'threshview combo[id="testCombo"]':
			{
				'select': this.testNameComboLoad
			},
			'threshview combo[id="threshTypeCombo"]':
			{
				'select': this.threshTypeComboLoad
			},
			'threshview button[id="submitBtn"]':
			{
				'click': this.updateData
			},
			'threshview button[id="saveBtn"]':
			{
				'click': this.savePdf
			},
			'threshview button[id="printBtn"]':
			{
				'click': this.printData
			},
			'threshview button[id="csvBtn"]':
			{
				'click': this.csvData
			}
		});
	},
	afterMainRender: function()
	{
		Ext.getCmp('saveBtn').setDisabled(true);
		Ext.getCmp('printBtn').setDisabled(true);
		Ext.getCmp('csvBtn').setDisabled(true);

		if(Ext.getCmp('resultPanel').isVisible())
		{
			Ext.getCmp('resultPanel').hide();
		}
		//if(Ext.getCmp('pdfUtilContainer').isVisible())
		//{
			//Ext.getCmp('pdfUtilContainer').hide();
		//}

		Ext.Ajax.request({
			url:'ViewThreshold/data/EgThreshDetailViewJson.jsp?reqfrom=navlink',
			method:'post',
			scope:this,
			success:function(response)
			{
				var jsonText = response.responseText;
				publicJson = Ext.decode(jsonText);
				var isSubmitDisabled = publicJson['isSubmitDisabled'];
				if (isSubmitDisabled)
				{
					Ext.getCmp('submitBtn').setDisabled(true);
				}
				else
				{
					Ext.getCmp('submitBtn').setDisabled(false);
				}
				Ext.getCmp('compTypeCombo').getStore().clearFilter(true);
				Ext.getCmp('compTypeCombo').getStore().loadRawData(publicJson['threshCompTypeArr']);
				Ext.getCmp('compNameCombo').getStore().clearFilter(true);
				Ext.getCmp('compNameCombo').getStore().loadRawData(publicJson['threshCompNameArr']);
				Ext.getCmp('testCombo').getStore().clearFilter(true);
				Ext.getCmp('testCombo').getStore().loadRawData(publicJson['threshTestNameArr']);
				Ext.getCmp('threshTypeCombo').getStore().loadRawData(publicJson['threshTypeArr']);
				Ext.getCmp('compTypeCombo').setValue(publicJson['threshCompTypeArr'][0].valueField);
				Ext.getCmp('compNameCombo').setValue(publicJson['threshCompNameArr'][0].valueField);
				Ext.getCmp('testCombo').setValue(publicJson['threshTestNameArr'][0].valueField);
				Ext.getCmp('threshTypeCombo').setValue(publicJson['threshTypeArr'][0].valueField);
				if ( !Ext.isEmpty( compType ) )
				{
					Ext.getCmp('compTypeCombo').setValue(compType);
					Ext.getCmp('compTypeCombo').fireEvent('select', Ext.getCmp('compTypeCombo'));
				}
				if ( !Ext.isEmpty( comp ) )
				{
					Ext.getCmp('compNameCombo').setValue(comp);
					Ext.getCmp('compNameCombo').fireEvent('select', Ext.getCmp('compNameCombo'));
				}
				if ( !Ext.isEmpty( test ) )
				{
					Ext.getCmp('testCombo').setValue(test);
					Ext.getCmp('testCombo').fireEvent('select', Ext.getCmp('testCombo'));
				}
				if ( !Ext.isEmpty( typeThresh ) )
				{
					Ext.getCmp('threshTypeCombo').setValue(typeThresh);
					Ext.getCmp('threshTypeCombo').fireEvent('select', Ext.getCmp('threshTypeCombo'));
				}
			}
		});
	},
	compNameComboLoad: function()
	{
		Ext.getCmp('saveBtn').setDisabled(true);
		Ext.getCmp('printBtn').setDisabled(true);
		Ext.getCmp('csvBtn').setDisabled(true);

		if(Ext.getCmp('resultPanel').isVisible())
		{
			Ext.getCmp('resultPanel').hide();
		}
		//if(Ext.getCmp('pdfUtilContainer').isVisible())
		//{
			//Ext.getCmp('pdfUtilContainer').hide();
		//}

		var compTypeVal = Ext.getCmp('compTypeCombo').getValue();
		var compNameVal = Ext.getCmp('compNameCombo').getValue();

		if((compTypeVal == null || compTypeVal == 'undefined' || compTypeVal == '-1'))
		{
			this.afterMainRender();
		}
		else if((compTypeVal != null && !Ext.isEmpty(compTypeVal) && compTypeVal != '-1') && (Ext.isEmpty(compNameVal) || compNameVal == '-1'))
		{
			Ext.Ajax.request({
				url:'ViewThreshold/data/EgThreshDetailViewJson.jsp?eg_compType='+encodeURIComponent(compTypeVal),
				method:'post',
				scope:this,
				async:false,
				success:function(response)
				{	
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					Ext.getCmp('compNameCombo').getStore().clearFilter(true);
					Ext.getCmp('compNameCombo').getStore().removeAll();
					Ext.getCmp('compNameCombo').getStore().loadRawData(publicJson['threshCompNameArr']);
					Ext.getCmp('testCombo').getStore().clearFilter(true);
					Ext.getCmp('testCombo').getStore().removeAll();
					Ext.getCmp('testCombo').getStore().loadRawData(publicJson['threshTestNameArr']);
					Ext.getCmp('threshTypeCombo').getStore().removeAll();
					Ext.getCmp('threshTypeCombo').getStore().loadRawData(publicJson['threshTypeArr']);
					Ext.getCmp('compNameCombo').setValue(publicJson['threshCompNameArr'][0].valueField);
					Ext.getCmp('testCombo').setValue(publicJson['threshTestNameArr'][0].valueField);
					Ext.getCmp('threshTypeCombo').setValue(publicJson['threshTypeArr'][0].valueField);
				}
			});
		}
		else
		{
			Ext.Ajax.request({
				url:'ViewThreshold/data/EgThreshDetailViewJson.jsp?eg_compType='+encodeURIComponent(compTypeVal)+'&eg_host='+encodeURIComponent(compNameVal),
				method:'post',
				scope:this,
				async:false,
				success:function(response)
				{	
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					Ext.getCmp('testCombo').getStore().clearFilter(true);
					Ext.getCmp('testCombo').getStore().removeAll();
					Ext.getCmp('testCombo').getStore().loadRawData(publicJson['threshTestNameArr']);
					Ext.getCmp('threshTypeCombo').getStore().removeAll();
					Ext.getCmp('threshTypeCombo').getStore().loadRawData(publicJson['threshTypeArr']);
					Ext.getCmp('testCombo').setValue(publicJson['threshTestNameArr'][0].valueField);
					Ext.getCmp('threshTypeCombo').setValue(publicJson['threshTypeArr'][0].valueField);
				}
			});
		}
	},
	testNameComboLoad: function()
	{
		Ext.getCmp('saveBtn').setDisabled(true);
		Ext.getCmp('printBtn').setDisabled(true);
		Ext.getCmp('csvBtn').setDisabled(true);

		if(Ext.getCmp('resultPanel').isVisible())
		{
			Ext.getCmp('resultPanel').hide();
		}
		//if(Ext.getCmp('pdfUtilContainer').isVisible())
		//{
			//Ext.getCmp('pdfUtilContainer').hide();
		//}

		var compTypeVal = Ext.getCmp('compTypeCombo').getValue();
		var compNameVal = Ext.getCmp('compNameCombo').getValue();
		var testNameVal = Ext.getCmp('testCombo').getValue();

		if(compTypeVal == null || Ext.isEmpty(compTypeVal))
		{
			this.afterMainRender();
		}
		else if((compTypeVal != null && !Ext.isEmpty(compTypeVal) && compTypeVal != '-1') && (Ext.isEmpty(compNameVal) || compNameVal == '-1'))
		{
			Ext.Ajax.request({
				url:'ViewThreshold/data/EgThreshDetailViewJson.jsp?eg_compType='+encodeURIComponent(compTypeVal),
				method: 'post',
				scope: this,
				async: false,
				success:function(response)
				{	
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					Ext.getCmp('compNameCombo').getStore().clearFilter(true);
					Ext.getCmp('compNameCombo').getStore().removeAll();
					Ext.getCmp('compNameCombo').getStore().loadRawData(publicJson['threshCompNameArr']);
					Ext.getCmp('testCombo').getStore().clearFilter(true);
					Ext.getCmp('testCombo').getStore().removeAll();
					Ext.getCmp('testCombo').getStore().loadRawData(publicJson['threshTestNameArr']);
					Ext.getCmp('threshTypeCombo').getStore().removeAll();
					Ext.getCmp('threshTypeCombo').getStore().loadRawData(publicJson['threshTypeArr']);
					
					Ext.getCmp('compNameCombo').setValue(publicJson['threshCompNameArr'][0].valueField);
					Ext.getCmp('testCombo').setValue(publicJson['threshTestNameArr'][0].valueField);
					Ext.getCmp('threshTypeCombo').setValue(publicJson['threshTypeArr'][0].valueField);
				}
			});
		}
		else  if((!Ext.isEmpty(compTypeVal) && compTypeVal != '-1') && (!Ext.isEmpty(compNameVal) && compNameVal != '-1') && (Ext.isEmpty(testNameVal) || testNameVal == '-1'))
		{
			Ext.Ajax.request({
				url:'ViewThreshold/data/EgThreshDetailViewJson.jsp?eg_compType='+encodeURIComponent(compTypeVal)+'&eg_host='+encodeURIComponent(compNameVal),
				method:'post',
				scope:this,
				async: false,
				success:function(response)
				{	
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					Ext.getCmp('testCombo').getStore().clearFilter(true);
					Ext.getCmp('testCombo').getStore().removeAll();
					Ext.getCmp('testCombo').getStore().loadRawData(publicJson['threshTestNameArr']);
					Ext.getCmp('threshTypeCombo').getStore().removeAll();
					Ext.getCmp('threshTypeCombo').getStore().loadRawData(publicJson['threshTypeArr']);
					
					Ext.getCmp('testCombo').setValue(publicJson['threshTestNameArr'][0].valueField);
					Ext.getCmp('threshTypeCombo').setValue(publicJson['threshTypeArr'][0].valueField);
				}
			});
		}
		else
		{
			Ext.Ajax.request({
				url:'ViewThreshold/data/EgThreshDetailViewJson.jsp?eg_compType='+encodeURIComponent(compTypeVal)+'&eg_host='+encodeURIComponent(compNameVal)+'&eg_test='+testNameVal,
				method:'post',
				scope:this,
				async: false,
				success:function(response)
				{	
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					Ext.getCmp('threshTypeCombo').getStore().removeAll();
					Ext.getCmp('threshTypeCombo').getStore().loadRawData(publicJson['threshTypeArr']);
					Ext.getCmp('threshTypeCombo').setValue(publicJson['threshTypeArr'][0].valueField);
				}
			});
		}
	},
	compTypeComboLoad: function()
	{
		Ext.getCmp('saveBtn').setDisabled(true);
		Ext.getCmp('printBtn').setDisabled(true);
		Ext.getCmp('csvBtn').setDisabled(true);

		if(Ext.getCmp('resultPanel').isVisible())
		{
			Ext.getCmp('resultPanel').hide();
		}
		//if(Ext.getCmp('pdfUtilContainer').isVisible())
		//{
			//Ext.getCmp('pdfUtilContainer').hide();
		//}

		var compTypeVal = Ext.getCmp('compTypeCombo').getValue();
		if((compTypeVal == null || compTypeVal == 'undefined' || compTypeVal == '-1'))
		{
			this.afterMainRender();
		}
		else if(compTypeVal != null && compTypeVal != 'undefined' && compTypeVal != '-1')
		{
			Ext.Ajax.request({
				url:'ViewThreshold/data/EgThreshDetailViewJson.jsp?eg_compType='+encodeURIComponent(compTypeVal),
				method:'post',
				scope:this,
				async: false,
				success:function(response)
				{	
					var jsonText = response.responseText;
					publicJson = Ext.decode(jsonText);
					Ext.getCmp('compNameCombo').getStore().clearFilter(true);
					Ext.getCmp('compNameCombo').getStore().removeAll();
					Ext.getCmp('compNameCombo').getStore().loadRawData(publicJson['threshCompNameArr']);
					Ext.getCmp('testCombo').getStore().clearFilter(true);
					Ext.getCmp('testCombo').getStore().removeAll();
					Ext.getCmp('testCombo').getStore().loadRawData(publicJson['threshTestNameArr']);
					Ext.getCmp('threshTypeCombo').getStore().removeAll();
					Ext.getCmp('threshTypeCombo').getStore().loadRawData(publicJson['threshTypeArr']);
					
					Ext.getCmp('compNameCombo').setValue(publicJson['threshCompNameArr'][0].valueField);
					Ext.getCmp('testCombo').setValue(publicJson['threshTestNameArr'][0].valueField);
					Ext.getCmp('threshTypeCombo').setValue(publicJson['threshTypeArr'][0].valueField);
				}
			});
		}
	},
	threshTypeComboLoad: function()
	{
		Ext.getCmp('saveBtn').setDisabled(true);
		Ext.getCmp('printBtn').setDisabled(true);
		Ext.getCmp('csvBtn').setDisabled(true);

		var compTypeVal = Ext.getCmp('compTypeCombo').getValue();
		var compNameVal = Ext.getCmp('compNameCombo').getValue();
		var testNameVal = Ext.getCmp('testCombo').getValue();
		var threshTypeVal = Ext.getCmp('threshTypeCombo').getValue();
		if(Ext.getCmp('resultPanel').isVisible())
		{
			Ext.getCmp('resultPanel').hide();
		}
		//if(Ext.getCmp('pdfUtilContainer').isVisible())
		//{
			//Ext.getCmp('pdfUtilContainer').hide();
		//}

		Ext.Ajax.request({
			url:'ViewThreshold/data/EgThreshDetailViewJson.jsp?eg_compType='+encodeURIComponent(compTypeVal)+'&eg_host='+encodeURIComponent(compNameVal)+'&eg_test='+encodeURIComponent(testNameVal)+"&eg_threshType="+encodeURIComponent(threshTypeVal),
			method:'post',
			scope:this,
			async:false,
			success:function(response)
			{	
				var jsonText = response.responseText;
				publicJson = Ext.decode(jsonText);
			}
		});
	},
	updateData : function(btn)
	{

		var me = this;
		var compTypeVal = Ext.getCmp('compTypeCombo').getValue();
		var compNameVal = Ext.getCmp('compNameCombo').getValue();
		var testNameVal = Ext.getCmp('testCombo').getValue();
		var threshTypeVal = Ext.getCmp('threshTypeCombo').getValue();
		var url = "ViewThreshold/data/EgThreshDetailViewJson.jsp?";
		var pdf = "true";

		if (compTypeVal == "-1")
		{
			Ext.Msg.show({
				title: pageName,
				msg: selCTypeMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
		else if (compNameVal == "-1")
		{
			Ext.Msg.show({
				title: pageName,
				msg: selCNameMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
		else if (testNameVal == "-1")
		{
			Ext.Msg.show({
				title: pageName,
				msg: selTNameMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}
		else if (threshTypeVal == "-1")
		{
			Ext.Msg.show({
				title: pageName,
				msg: selTTypeMsg,
				buttons: Ext.Msg.OK,
				icon: 'iconExclamation'
			});
			return;
		}

		url = url+"fin=yes&onSubmit=true&eg_host="+encodeURIComponent(compNameVal)+"&eg_compType="+encodeURIComponent(compTypeVal)+"&eg_threshType="+encodeURIComponent(threshTypeVal)+"&PDF="+pdf+"&eg_test="+encodeURIComponent(testNameVal)+"&fromCT=false";
		var homepage = Ext.getCmp('viewportId');
		myMask = new Ext.LoadMask(homepage, {msg:"Loading..."});
		myMask.show();
		Ext.Ajax.request({
			url: url,
			method: 'POST',
			timeout: 120000,
			scope: this,
			success: function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					if (!Ext.isEmpty(jsonData))
					{
						//if(Ext.getCmp('pdfUtilContainer').isHidden())
						//{
							//Ext.getCmp('pdfUtilContainer').show();
							//Ext.getCmp('pdfUtilContainer').removeAll();
						//}
						if(Ext.getCmp('resultPanel').isHidden())
						{
							Ext.getCmp('resultPanel').show();
							Ext.getCmp('resultPanel').removeAll();
						}

						myMask.hide();
						var tableHtmlForm = jsonData['tableHtmlForm'];
						//var pdfUtilities = jsonData['pdfUtilities'];
						var isNoData = jsonData['isNoData'];
						if (!isNoData)
						{
							Ext.getCmp('saveBtn').setDisabled(false);
							Ext.getCmp('printBtn').setDisabled(false);
							Ext.getCmp('csvBtn').setDisabled(false);
						}
						
						//Ext.getCmp('pdfUtilContainer').update(pdfUtilities);
						Ext.getCmp('resultPanel').removeAll();
						Ext.getCmp('resultPanel').update(tableHtmlForm);
						Ext.getCmp('resultPanel').doLayout();
					}
				}
			}
		});
	},
	printData : function()
	{
		Ext.widget('print',{
			bodyStyle: {
				background: '#fff'
			}
		}).show();
		var printContentDiv = Ext.select('#printContentDiv');
		printContentDiv.set({
			src : "ViewThreshold/data/EgPrintThreshDetailView.jsp?print=printpage&com.eg.CSRF_NONCE="+csrfToken
		});
	},
	savePdf : function()
	{
		var s_qryString = "/final/servlet/com.eg.EgPdfDownloadC?";
		var downloadUtils =  Ext.widget('downloadutils');
		downloadUtils.savePDF(s_qryString);
	},
	csvData: function()
	{
		//var s_qryString = "/final/servlet/com.eg.EgCSVController?";
		//var erUtils =  Ext.widget('downloadutils');
		//erUtils.savePDF(s_qryString);
		
		var saveQString="../servlet/com.eg.EgCSVController";
		window.location=saveQString;

	}
});
