Ext.define('ViewThreshold.view.ThreshView', {
	extend: 'Ext.form.Panel',
	alias: 'widget.threshview',
	cls:'outerpanel',
	title: pageName,
	id: 'threshviewID',
	margin: '8 8 0 8',
	layout: {
		type: 'vbox',
		align: 'stretch'
	},
	requires : [
		'utilities.ScrollCombo',

	],
	scroll:true,
	actoScroll:false,
	header:{cls:'zonereporthead'},
	tools: [
		{
			xtype: 'container',
			margin: '0 1px 0 1px',
			itemId:'saveTool',
			items: [
				{
					xtype: 'button',
					iconCls: 'iconPdf',
					id: 'saveBtn',
					 listeners: {
                    afterrender: function () {
                        Ext.create('Ext.tip.ToolTip', {
                            target: this.id,
                            anchor: 'top',
                            cls: 'yellowTip',
                            trackMouse: true,
                            html: 'Save'
                        });
                    }
                },
					style: {
						background: 'none',
						border: '0px'
					}
				}
			]
		},{
			xtype:'tbseparator'
		},
		{
			xtype: 'container',
			margin: '0 1px 0 1px',
			itemId:'printTool',
			items: [
				{
					xtype: 'button',
					iconCls: 'iconPrinter',
					id: 'printBtn',
					listeners: {
                    afterrender: function () {
                        Ext.create('Ext.tip.ToolTip', {
                            target: this.id,
                            anchor: 'top',
                            cls: 'yellowTip',
                            trackMouse: true,
                            html: 'Print'
                        });
                    }
                },
					style: {
						background: 'none',
						border: '0px'
					}
				}
			]
		},{
			xtype:'tbseparator'
		},
		{
			xtype: 'container',
			margin: '0 1px 0 1px',
			itemId:'csvTool',
			items: [
				{
					xtype: 'button',
					iconCls: 'iconCsv',
					id: 'csvBtn',
					listeners: {
                    afterrender: function () {
                        Ext.create('Ext.tip.ToolTip', {
                            target: this.id,
                            anchor: 'top',
                            cls: 'yellowTip',
                            trackMouse: true,
                            html: 'CSV'
                        });
                    }
                },
					style: {
						background: 'none',
						border: '0px'
					}
				}
			]
		}
	],
dockedItems: [{
		xtype: 'toolbar',
		dock: 'top',
		cls:'adminHeadInfoText',
		height: 25,
		padding: 3,
		border:true,
		layout:{pack:'center'},
		items: [
			{
			xtype: 'component',
			html: '<center><img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="iconAdminInfo" valign="middle" >&nbsp;&nbsp;'+pageDesc+'.</center>',


		}

		]
	}],
	items: [
		{
			xtype:'container',
			padding:10,
			layout:{type:'vbox',pack:'center',align:'center'},
			items: [
				{
					xtype:'container',
					cls:'formOuter',
					layout: {
								type: 'vbox',
								pack: 'center',
								align:'center'
							},
					items:[
						{
							xtype: 'container',
							padding:10,
							layout: {
								type: 'hbox',
								pack: 'center'
							},
							items: [
								{
									xtype: 'scrollcombo',
									id: 'compTypeCombo',
									fieldLabel: label1,
									labelAlign: 'top',
									labelSeparator: ' ',
									width: 220,
									displayField: 'displayField',
									valueField: 'valueField',
									queryMode:'local',
									//editable: false,
									store: new Ext.data.Store(
										{
											fields: ['displayField','valueField'],
											data: []
										}
									)
								},
								{
									xtype: 'scrollcombo',
									id: 'compNameCombo',
									fieldLabel: label4,
									labelAlign: 'top',
									labelSeparator: ' ',
									width: 220,
									margin: '0 0 0 20',
									displayField: 'displayField',
									valueField: 'valueField',
									queryMode:'local',
									//editable: false,
									store: new Ext.data.Store(
										{
											fields: ['displayField','valueField'],
											data: []
										}
									)
								},
								{
									xtype: 'scrollcombo',
									id: 'testCombo',
									fieldLabel: label2,
									labelAlign: 'top',
									labelSeparator: ' ',
									width: 220,
									margin: '0 0 0 20',
									displayField: 'displayField',
									valueField: 'valueField',
									queryMode:'local',
									//editable: false,
									store: new Ext.data.Store(
										{
											fields: ['displayField','valueField'],
											data: []
										}
									)
								},
								{
									xtype: 'scrollcombo',
									id: 'threshTypeCombo',
									fieldLabel: label3,
									labelAlign: 'top',
									labelSeparator: ' ',
									width: 180,
									margin: '0 0 0 20',
									displayField: 'displayField',
									valueField: 'valueField',
									queryMode:'local',
									editable: false,
									store: new Ext.data.Store(
									{
										fields: ['displayField','valueField'],
										data: []
									})
								}
							]
						},
						{
							xtype: 'container',
							layout: {
								type: 'hbox',
								pack: 'center',
								align:'center'
							},
							id: 'noDataContainer',
							margin:'0 0 10 0',
							items: [
								{
									xtype: 'button',
									id: 'submitBtn',
									cls:'button20',
									text: label5,
									width: 80,
								}
							]
						}
					]
				},
				//{
					//xtype: 'container',
					//id: 'pdfUtilContainer',
					//align: 'right',
					//hidden:true,
					////style: {'border' :'1px solid red'},
					//margin:'0 0 5 0',
					//width:'100%',
					//html: ''
				//},

			]
		},{
					xtype: 'container',
					flex:1,
					//frame:true,
					scroll:true,
					autoScroll:true,
					id: 'resultPanel',
					align: 'center',
					hidden:true,
					cls:'containerShadow',
					itemId: 'resultPanel',
					margin:'10 10 10 10',
					padding:10,
					width:'100%',
					html: ''
				}
	]
});



