Ext.define('Zones.controller.ConfigZoneControl',{
	extend:'Ext.app.Controller',
	views:['ComponentZone'],
	refs:[
		{selector:'componentzone', ref:'componentzone'},
	],
	init:function(){
		//this.buildFieldData()
		ctrl = this;
		this.control({
			'componentzone':
			{
				'afterrender': this.afterMainRender
			}
		});
	},
	buildFieldData: function(mode,zoneName){
		Ext.Ajax.request({
			url: 'Zones/data/EgConfigZoneJson.jsp?mode='+mode+'&zone='+encodeURIComponent(zoneName),
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	initializeFields: function(elementType){
		var me=this;
		var executiveForm = this.getComponentzone().getForm();
		var screenLabels = publicJSON['screenLabels'];
		if (elementType == "null")
		{
			me.setValueWithOptionInList(executiveForm, 'elementType', publicJSON['TypeOfElements'],'');
		}
		else
		{
			me.setValueWithOptionInList(executiveForm, 'elementType', publicJSON['TypeOfElements'],elementType);
		}
	},

	setValueWithOptionInList: function(form, fieldName, list, value) {
		form.findField(fieldName).getStore().loadRawData(list);
		form.findField(fieldName).suspendEvents(false);
		var valueAssigned = false;
		if (list.length > 0)
		{
		for(var listCounter = 0 ; listCounter < list.length ; listCounter++){
			if(list[listCounter].valueField == value && !Ext.isEmpty(value) && value != null){
				form.findField(fieldName).setValue(value);
				valueAssigned = true;
			}
		}
		}
		if(!valueAssigned){
			form.findField(fieldName).setValue(list[0].valueField);
		}
		form.findField(fieldName).resumeEvents();
	},

	afterMainRender : function(mode,zoneName,elementType)
	{
		var ZoneController = this.getController('Zones.controller.Main');
		var me=this;
		var executiveForm = this.getComponentzone().getForm();
		this.initializeFields(elementType);
		var modifyZoneName=zoneName;
		if(mode!=null && mode=="modify")
		{
			modifyZoneName = zoneName;
			Ext.getCmp('zonecombo').show(true);
			Ext.getCmp('zonecombo').getStore().suspendEvents(true);
			Ext.getCmp('zonecombo').getStore().loadRawData(publicJSON['ExistingZoneNames']);
			Ext.getCmp('zonecombo').getStore().resumeEvents();
			Ext.getCmp('zonecombo').setValue(zoneName);
			Ext.getCmp('zonename').hide();
			//Ext.getCmp('addLocation').setDisabled(false);
		}
		else if(mode=="add")
		{
			Ext.getCmp('zonename').show(true);
			Ext.getCmp('zonecombo').hide();
			//Ext.getCmp('addLocation').setDisabled(true);
		}

//		var autoAssociate = publicJSON['association'];
//		if(autoAssociate!=null && autoAssociate=='checked')
//		{
//			Ext.getCmp('association').setValue(true);
//		}
//		else
//		{
//			Ext.getCmp('association').setValue(false);
//		}
		if(mode == "modify")
		{
			var element = Ext.getCmp('elementType').getValue();
			if(element == "Component")
			{
				element = Ext.getCmp('componentType').getValue();
			}
		}
		Ext.Ajax.request({
			url: 'Zones/data/EgConfigZoneJson.jsp?zone='+encodeURIComponent(modifyZoneName)+"&mode="+mode+"&comptype="+encodeURIComponent(element)+"&qctr=1"+"&modifyassociate=true",
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
				
				Ext.getCmp('updateBTN').setText(publicJSON['screenLabels']['admin.common.buttonText']);
				Ext.getCmp('addLocation').setText(publicJSON['screenLabels']['geographicLocation']);
				Ext.getCmp('imagecombo').getStore().suspendEvents(true);
				Ext.getCmp('imagecombo').getStore().loadRawData(publicJSON['imageArray']);
				Ext.getCmp('imagecombo').getStore().resumeEvents();
				Ext.getCmp('imagecombo').setValue("serviceOthersSmall");

				var chosenCType = Ext.getCmp('componentType').getValue();
				var availabelitemselectHosts = Ext.getCmp('itemselectHosts').getValue();

				if (Ext.isEmpty(chosenCType) || Ext.isEmpty(availabelitemselectHosts))
				{
					Ext.getCmp('itemselectHosts').getStore().suspendEvents(true);
					Ext.getCmp('itemselectHosts').getStore().loadRawData(publicJSON['itemSelectorValue']);
					Ext.getCmp('itemselectHosts').getStore().resumeEvents();
					Ext.getCmp('itemselectHosts').setValue(publicJSON['availableElementsArr']);

					Ext.getCmp('componentType').getStore().suspendEvents(true);
					Ext.getCmp('componentType').getStore().clearFilter(true);
					Ext.getCmp('componentType').getStore().loadRawData(publicJSON['TypeOfComponent']);
					Ext.getCmp('componentType').getStore().resumeEvents();
					Ext.getCmp('componentType').setValue('-1');
				}
				else if (chosenCType == '-1')
				{
					Ext.getCmp('itemselectHosts').getStore().suspendEvents(true);
					Ext.getCmp('itemselectHosts').getStore().loadRawData(publicJSON['itemSelectorValue']);
					Ext.getCmp('itemselectHosts').getStore().resumeEvents();
					Ext.getCmp('itemselectHosts').setValue(publicJSON['availableElementsArr']);
				}
				else
				{
					ZoneController.comboLoad(Ext.getCmp('componentType'));
				}

				$('#'+Ext.getCmp('imagecombo').inputEl.id).removeClass().addClass('serviceOthersSmall');

				if(mode=='modify')
				{
					Ext.getCmp('imagecombo').setValue(publicJSON['selectedImage']);
					$('#'+Ext.getCmp('imagecombo').inputEl.id).removeClass().addClass(publicJSON['selectedImage']);
				}
				if(publicJSON['mapEnabled'])
					Ext.getCmp('addLocation').show();
				else
					Ext.getCmp('addLocation').hide();

				Ext.getCmp('zonefor').getStore().suspendEvents(true);
				Ext.getCmp('zonefor').getStore().loadRawData(publicJSON['zoneTypeArray']);
				Ext.getCmp('zonefor').getStore().resumeEvents();

				Ext.getCmp('zonefor').setValue(publicJSON['zoneFor']);
			}
		});
		Ext.getCmp('zonename').focus();
	}
});



