Ext.define('Zones.controller.Main',{
	extend:'Ext.app.Controller',
	views:['ComponentZones','ComponentZone','RenameZone','GMPanel'],
	refs:[
		{selector:'componentzones', ref:'componentzones'},
		{selector:'componentzone', ref:'componentzone'},
		{selector:'renamezone', ref:'renamezone'},
		{selector:'gmpanel', ref:'gmpanel'},
	],
	init:function(){
		appCnt = this;
		this.buildFieldData()

		this.control({
			'componentzones':
			{
				'afterrender': this.afterMainRender
			},
			'componentzones trigger[name="gridSearch"]': {
				'change': this.mainGridSearch
			},
			'componentzones [id="gridDisplay"]': {
				//'itemmouseenter': this.showActions,
				//'itemmouseleave': this.hideActions
			},
			'componentzones button[id="addZone"]': {
				'click': this.addZone
			},
			'componentzone combo[id="elementType"]':
			{
				'select': this.comboLoad
			},
			'componentzone combo[id="componentType"]':
			{
				'select': this.comboLoad
			},
			'componentzone combo[id="zonecombo"]':
			{
				'select': this.comboLoad
			},
//			'componentzone checkbox[id="association"]':
//			{
//				'change': this.checkClicked
//			},
			'componentzone button[id="updateBTN"]':
			{
				'click': this.updation
			},
			'componentzone button[id="backbutton"]':
			{
				'click': this.backbutton
			},
			'componentzone button[id="addLocation"]':
			{
				'click': this.addLocation
			},
			'renamezone button[id="renameBTN"]':
			{
				'click': this.renameZone
			},
			'componentzone textfield[id="zonename"]':
			{
				'blur': this.validateName
			}
		});
	},
	validateName: function()
	{
		var zoneName = Ext.getCmp('zonename').getValue();
		if(zoneName != null && zoneName.trim().length > 0)
		{
			if(this.specialCharacterCheck(zoneName))
			{
				Ext.Msg.show({
					title : pageTitle,
					msg : publicJSON['screenLabels']['admin.common.special characters not allowed']+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function()
					{
						Ext.getCmp('zonename').focus();
					}
				});
				return false;
			}
		}
	},
	specialCharacterCheck: function(text)
	{
		var s_spl = "`~!$%^*()+={}[]|\\:;\"\'<>,?\/&";
		try
		{
			for(count = 0; count < text.length; count++)
			{
				var check_char = s_spl.indexOf(text.charAt(count));
				if(check_char >= 0)
					return true;
			}
		}
		catch (e)
		{
		}
		return false;
	},
	expandAllRows:function()
	{
		var titlesGrid = Ext.getCmp('gridDisplay');
		var store = titlesGrid.getStore();
		var expander = titlesGrid.getPlugin('rowexpanderDiv');
		for(var i = 0; i < store.getCount(); i++) {
			var record = store.getAt(i);
			if(!expander.recordsExpanded[record.internalId]){
				expander.toggleRow(i);
			}
		}
	},
	collapseAllRows: function()
	{
		var titlesGrid = Ext.getCmp('gridDisplay');
		var store = titlesGrid.getStore();
		var expander = titlesGrid.getPlugin('rowexpanderDiv');
		for(var i = 0; i < store.getCount(); i++) {
			var record = store.getAt(i);
			if(expander.recordsExpanded[record.internalId]){
				expander.toggleRow(i);
			}
		}
	},
	backbutton: function()
	{
		if(returnToMain=='true')
		{
			if (!Ext.isEmpty(mainUrl))
			{
				if (mainUrl.indexOf('.jsp?') != -1)
				{
					mainUrl += '&fromWizard='+fromWizard
				}
				else
				{
					mainUrl += '?fromWizard='+fromWizard
				}
			}

			window.location.href=mainUrl;
			if(comeFrom==null || comeFrom=='' || comeFrom=='null' || comeFrom!='topology')
				return false;
		}
		if(comeFrom!=null && comeFrom!='' && comeFrom!='null')
		{
			if(comeFrom=='topology')
			{
				var url = "EgComponentSegments.jsp?qctr=0&segment="+segmentFromTopology+"&mode=modify"+"&zone="+encodeURIComponent(zoneName)+"&returnTo=segments"+"&returnToMain="+returnToMain+"&mainUrl="+mainUrl+"&fromWizard="+fromWizard;
				window.location.href=url;
			}
			else if (comeFrom =='userpage')
			{
				window.location.href = backHref + "&username="+username + "&selectedTab=3"+"&fromWizard="+fromWizard;
			} 
			else if (comeFrom == 'comp_mng_umng')
			{
				window.location.href = "EgConfigEnv.jsp?srvtype="+comptype+"&activeCompTypes="+activeCompTypes+"&fromWizard="+fromWizard;
				return;
			}
			else if (comeFrom == 'agg_mng_umng')
			{
				window.location.href = "aggConfigEnv.jsp?srvtype="+comptype+"&activeCompTypes="+activeCompTypes+"&fromWizard="+fromWizard;
				return;
			}
			else if (comeFrom == 'discovery_mng_umng')
			{
				window.location.href = "EgDiscoveryPane.jsp?server="+comptype+"&activeCompTypes="+activeCompTypes+"&selectedNode=node11"+"&fromWizard="+fromWizard;
				return;
			}
			else if (comeFrom == 'comp_add_modify')
			{
				window.location.href = "EgDispServer.jsp?comptype="+comptype+"&activeCompTypes="+activeCompTypes+"&fromWizard="+fromWizard;
				return;
			}
			else if (comeFrom == 'comp_add_mod_new')
			{
				window.location.href = "EgAdminOperations.jsp?server="+comptype+"&fromAction="+fromAction+"&classify="+classify;
				return;
			}
		}
		else
			window.location.href="EgComponentZones.jsp?reqFrom=navlink&fromWizard="+fromWizard;
	},

	showActions: function(view, task, node, rowIndex, e){
		var hideIcon = view.getStore().getAt(rowIndex);
		var isDisabled = hideIcon.get('isDisabled');
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
		if (isDisabled == 'true')
		{
			Ext.get(icons[0]).removeCls('x-hidden');
		}
		else
		{
			Ext.get(icon).removeCls('x-hidden');
		}
	});
	},

	hideActions: function(view, task, node, rowIndex, e){
		var icons = Ext.DomQuery.select('.x-action-col-icon', node);
		Ext.each(icons, function(icon){
		Ext.get(icon).addCls('x-hidden');
	});
	},
	handleRenameIconClick: function(grid, rowIndex, colIndex){
		btnText = 'Rename';
		var rec = grid.getStore().getAt(rowIndex);
		var zoneName = rec.get('Zonename');
		this.showEditWindow(zoneName);
	},
	showEditWindow: function(zoneName){
		Ext.widget('renamezone').show();
		Ext.getCmp('currentname').setValue(zoneName);

		Ext.Ajax.request({
			url: 'Zones/data/renamehelpJson.jsp',
			method: 'POST'
		});
	},
	renameZone:function()
	{
		var old_name=Ext.getCmp('currentname').getValue();
		var new_name=Ext.getCmp('newname').getValue();
		var doubleByteName=true;

		if(new_name=='' || new_name.length ==0)
		{
			Ext.Msg.alert(renameTitle,publicJSON['screenLabels']['admin.common.field value cannot be blank']);
			return;
		}
		else if(old_name==new_name)
		{
			Ext.Msg.alert(renameTitle,publicJSON['screenLabels']['sameName']);
			return;
		}
		else if(new_name.toLowerCase() == "all" || new_name.toLowerCase() == "default")
		{
			Ext.Msg.alert(renameTitle,zoneAlert1);
			return false;
		}
		var s_spl = "`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/";
		var isDouble = publicJSON['isDouble'];
		for(count = 0; count < new_name.length; count++)
		{
			var check_char = s_spl.indexOf(new_name.charAt(count));
			if(!isDouble)
			{
				var charValue=new_name.charCodeAt(count);
				if(charValue>255)
				{
					Ext.Msg.alert(renameTitle,publicJSON['screenLabels']['admin.common.DBL not allowed']);
					return false;
				}
			}
			if(new_name.charAt(count) == ' ')
			{
				Ext.Msg.alert(renameTitle,publicJSON['screenLabels']['admin.common.space not allowed']);
				return false;
			}
			else if(check_char >= 0)
			{
				Ext.Msg.alert(renameTitle,publicJSON['screenLabels']['admin.common.special characters not allowed']);
				return false;
			}
		}
		var renameUrl = "Zones/data/renameJson.jsp?rename=Zone&old_name="+encodeURIComponent(old_name)+"&new_name="+encodeURIComponent(new_name);
		Ext.Ajax.request({
			url: renameUrl,
			method: 'POST',
			async:false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var myjsonText = response.responseText;
					renameJSON = Ext.decode(response.responseText);
					if(renameJSON.renamed)
					{
						window.location.href="EgComponentZones.jsp?fromWizard="+fromWizard;
					}
					else
					{
						Ext.Msg.alert(renameJSON.rename,renameJSON.message);

					}
				}
			},
			failure: function(james)
			{
				alert('failure is called');
			}
		});

	},
	handleEditIconClick: function(grid, rowIndex, colIndex){
		btnText = 'Edit';
		var rec =  Ext.getCmp("gridDisplay").getStore().getAt(rowIndex);
		var zoneName = rec.get('Zonename');
		var configGroupController = this.getController('Zones.controller.ConfigZoneControl');
		var elementType = publicJSON['elementType'];
		Ext.getCmp('viewport').removeAll();
		configGroupController.buildFieldData("modify",zoneName);
		Ext.getCmp('viewport').add({xtype: 'componentzone'});
		configGroupController.afterMainRender("modify",zoneName,elementType);
		if(publicJSON['mapEnabled'])
			Ext.getCmp('addLocation').show();
		else
			Ext.getCmp('addLocation').hide();

		Ext.getCmp("zonename").disable();
	},

	handleDeleteIconClick: function(grid, rowIndex, colIndex){
		var DispValues = Ext.getCmp('gridDisplay').getStore().getAt(rowIndex);
		var zoneName = DispValues.get('Zonename');
		var message = deleteConform1 + " '" + zoneName + "' "+deleteConform2;
		Ext.Msg.confirm(mainPageTitle, message, function(buttonText) {
			if (buttonText == "yes")
			{
				var resultUrl = "Zones/data/EgconfigzonepJson.jsp?deleteZones="+encodeURIComponent(zoneName)+"&mode=delete&reqfrom=navlink";
				Ext.Ajax.request({
					url: resultUrl,
					method: 'POST',
					async:false,
					success: function( response )
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var jsonText = response.responseText;
							var jsonObj = Ext.decode( jsonText );
							window.location.href=jsonObj['ForwardPageTo']+"?fromWizard="+fromWizard;
						}
					}
				});
			}
		});
	},

	handleDeleteSelected: function(){
		var grid=Ext.getCmp('gridDisplay').getSelectionModel().getSelection();
		var values='';
		var array=new Array();
		var selectedZones="";
		if(grid=="")
		{
			Ext.MessageBox.alert(mainPageTitle,publicJSON['screenLabels']['no zone selected']);
			return false;
		}
		for(var i=0; i < grid.length ; i++)
		{
			values=grid[i];
			id=values.get('Zonename');
			if(id!=null)
			{
				array.push(id);
			}
		}
		for(var j=0; j < array.length; j++)
		{
			selectedZones +=array[j]+",";
		}
		Ext.Msg.confirm(mainPageTitle, publicJSON['screenLabels']['deleteforSelectedMessage'], function(buttonText) {
			if (buttonText == "yes")
			{
				var resultUrl = "Zones/data/EgconfigzonepJson.jsp?deleteZones="+encodeURIComponent(selectedZones)+"&mode=delete&reqfrom=navlink";
				Ext.Ajax.request({
					url: resultUrl,
					method: 'POST',
					async:false,
					success: function( response )
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var jsonText = response.responseText;
							var jsonObj = Ext.decode( jsonText );

							window.location.href=jsonObj['ForwardPageTo']+"?fromWizard="+fromWizard;
						}
					}
				});
			}
		});
	},
	buildFieldData: function(){
		Ext.Ajax.request({
			url: 'Zones/data/EgDispZonesJson.jsp?reqfrom=navlink&fromWizard='+fromWizard,
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
			}
		});
	},
	afterMainRender : function()
	{
		//if(comeFrom!=null)
		//{
			if(returnToMain=='true' || comeFrom=='topology' || comeFrom == 'userpage' || comeFrom == 'comp_mng_umng' || comeFrom == 'agg_mng_umng' || comeFrom == 'discovery_mng_umng' || comeFrom == 'comp_add_modify' ||  comeFrom == 'comp_add_mod_new')
			{
				var configGroupController = this.getController('Zones.controller.ConfigZoneControl');
				Ext.getCmp('viewport').removeAll();
				configGroupController.buildFieldData("modify",zoneName);
				Ext.getCmp('viewport').add({xtype: 'componentzone'});
				configGroupController.afterMainRender("modify",zoneName,elementType);
				Ext.getCmp("zonename").disable();
				return;
			}
		//}
		var resultsData = publicJSON['gridValues'];
		Ext.getCmp('gridDisplay').show();
		Ext.getCmp('gridDisplay').getStore().suspendEvents(true);
		Ext.getCmp('gridDisplay').getStore().loadRawData(resultsData);
		Ext.getCmp('gridDisplay').getStore().resumeEvents();

		if(publicJSON['disableAddZone'] === "true")
		{
			Ext.getCmp('NoExtPresent').show();
			Ext.getCmp('gridDisplay').hide();
		}
		else
		{
			Ext.getCmp('NoExtPresent').hide();
			Ext.getCmp('gridDisplay').show();
		}

		var noExtFound = publicJSON['NoExtFound'];
		if (noExtFound == "true")
		{
			Ext.getCmp('gridSearch').disable();
		}
		else
		{
			Ext.getCmp('gridSearch').enable();
		}
	},
	mainGridSearch : function(obj){
		var gridsearch = Ext.getCmp('gridSearch').getValue();
		if (gridsearch == "" || gridsearch.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}
		Ext.Ajax.request({
			url: 'Zones/data/EgDispZonesJson.jsp?egTitleSearchStr='+encodeURIComponent(gridsearch)+'&fromWizard='+fromWizard,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}
				var value = publicJSON['gridValues'];
				Ext.getCmp('gridDisplay').show();
				if (value != null && value.length > 0)
				{
					Ext.getCmp('gridDisplay').store.loadData(publicJSON['gridValues']);
				}
				else
				{
					Ext.getCmp('gridDisplay').store.loadData('');
					Ext.getCmp('gridDisplay').getView().emptyText='<table border="0" height="350px" width="100%"><tr><td align=center vlaign=top><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+publicJSON['screenLabels']['searchResult']+'.</div></td></tr></table>';
					Ext.getCmp('gridDisplay').getView().refresh();
				}
			}
		});
	},
	addZone : function()
	{
		var configGroupController = this.getController('Zones.controller.ConfigZoneControl');
		Ext.getCmp('viewport').removeAll();
		configGroupController.buildFieldData("add","","-1");
		Ext.getCmp('viewport').add({xtype: 'componentzone'});
		configGroupController.afterMainRender("add","","-1");
	},

	comboLoad: function(combo)
	{
		var mode = publicJSON['addModifyMode'];
		var fieldId = combo.getId();
		var zone = '';
		if(mode=="add")
			zone = Ext.getCmp('zonename').getValue();
		else
			zone = Ext.getCmp('zonecombo').getValue();
		var element = Ext.getCmp('elementType').getValue();

		if(element.toLowerCase() == 'component')
		{
			if(Ext.getCmp('componentType').isVisible())
			{
				element = Ext.getCmp('componentType').getValue();
			}
			else
			{
				Ext.getCmp('componentType').show();
				Ext.getCmp('componentType').enable();
				Ext.getCmp('componentType').getStore().suspendEvents(true);
				Ext.getCmp('componentType').getStore().clearFilter(true);
				Ext.getCmp('componentType').getStore().loadRawData(publicJSON['TypeOfComponent']);
				Ext.getCmp('componentType').getStore().resumeEvents();
				Ext.getCmp('componentType').setValue('-1');
			}
		}
		else
		{
			Ext.getCmp('componentType').hide();
			Ext.getCmp('componentType').disable();
		}
		if(fieldId=='zonecombo')
		{
			element='';
		}

		Ext.Ajax.request({
			url: 'Zones/data/EgConfigZoneJson.jsp?zone='+encodeURIComponent(zone)+"&mode="+mode+"&comptype="+encodeURIComponent(element)+"&qctr=1"+"&validate=true",
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
				}

				var isValidName = publicJSON['screenLabels']['isValid']; 
				if(isValidName=="false")
				{
					Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.ErroInAddingZone']);
					Ext.getCmp('elementType').setValue('-1');
//					Ext.getCmp('zonefor').setValue('Monitor and Reporter');
					return;
				}else
				{
					Ext.getCmp('itemselectHosts').getStore().suspendEvents(true);
					Ext.getCmp('itemselectHosts').getStore().loadRawData(publicJSON['itemSelectorValue']);
					Ext.getCmp('itemselectHosts').getStore().resumeEvents();
					Ext.getCmp('itemselectHosts').setValue(publicJSON['availableElementsArr']);
					Ext.getCmp('addLocation').setText(publicJSON['screenLabels']['geographicLocation']);
					if(fieldId=='zonecombo')
					{
						Ext.getCmp('elementType').getStore().suspendEvents(true);
						Ext.getCmp('elementType').getStore().clearFilter(true);
						Ext.getCmp('elementType').getStore().loadRawData(publicJSON['TypeOfElements']);
						Ext.getCmp('elementType').getStore().resumeEvents();
						Ext.getCmp('elementType').setValue('-1');
						
						if(element.toLowerCase() == 'component')
						{
							if(Ext.getCmp('componentType').isVisible())
							{
								element = Ext.getCmp('componentType').getValue();
							}
							else
							{
								Ext.getCmp('componentType').show();
								Ext.getCmp('componentType').enable();
								Ext.getCmp('componentType').getStore().suspendEvents(true);
								Ext.getCmp('componentType').getStore().clearFilter(true);
								Ext.getCmp('componentType').getStore().loadRawData(publicJSON['TypeOfComponent']);
								Ext.getCmp('componentType').getStore().resumeEvents();
								Ext.getCmp('componentType').setValue('-1');
							}
						}
						else
						{
							Ext.getCmp('componentType').hide();
							Ext.getCmp('componentType').disable();
						}
					}
					else if (fieldId=='componentType')
					{
						Ext.getCmp('componentType').getStore().suspendEvents(true);
						Ext.getCmp('componentType').getStore().clearFilter(true);
						Ext.getCmp('componentType').getStore().loadRawData(publicJSON['TypeOfComponent']);
						Ext.getCmp('componentType').getStore().resumeEvents();
					}
					if(mode=='modify')
					{
						Ext.getCmp('imagecombo').setValue(publicJSON['selectedImage']);
						$('#'+Ext.getCmp('imagecombo').inputEl.id).removeClass().addClass(publicJSON['selectedImage']);

						Ext.getCmp('zonefor').getStore().suspendEvents(true);
						Ext.getCmp('zonefor').getStore().loadRawData(publicJSON['zoneTypeArray']);
						Ext.getCmp('zonefor').getStore().resumeEvents();

						Ext.getCmp('zonefor').setValue(publicJSON['zoneFor']);
					}
				}
			}
		});
	},
//	checkClicked: function()
//	{
//		var mode = publicJSON['addModifyMode'];
//		var zone = '';
//		if(mode=="add")
//			zone = Ext.getCmp('zonename').getValue();
//		else
//			zone = Ext.getCmp('zonecombo').getValue();
//
//		var element = Ext.getCmp('elementType').getValue();
//		var association = Ext.getCmp('association').getValue();
//		var str='checked';
//		if(association)
//			str='checked';
//		else
//			str='null';

//		var queryString = 'Zones/data/EgConfigZoneJson.jsp?zone='+encodeURIComponent(zone)+"&mode="+mode+"&comptype="+encodeURIComponent(element)+"&qctr=1"+"&association="+str+"&modifyassociate=true";
//		if(mode=='modify')
//			queryString = queryString+"&validate=true";
//		Ext.Ajax.request({
//			url:queryString,
//			method: 'POST',
//			success: function( response )
//			{
//				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
//				{
//					var jsonText = response.responseText;
//					publicJSON = Ext.decode( jsonText );
//				}
//			Ext.getCmp('itemselectHosts').getStore().suspendEvents(true);
//			Ext.getCmp('itemselectHosts').getStore().loadRawData(publicJSON['itemSelectorValue']);
//			Ext.getCmp('itemselectHosts').getStore().resumeEvents();
//			Ext.getCmp('itemselectHosts').setValue(publicJSON['availableElementsArr']);
//			}
//		});
//	},
	updation: function()
	{
		var configGroupController = this.getController('Zones.controller.ConfigZoneControl');
		var mode = publicJSON['addModifyMode'];
		var isDouble = publicJSON['isDouble'];
		var zonename = '';
		var assocaitedHostCount = Ext.getCmp('itemselectHosts').fromField.getStore().getCount();
		if(mode=="add")
			zonename = Ext.getCmp('zonename').getValue();
		else
			zonename = Ext.getCmp('zonecombo').getValue();

		var zoneFor = Ext.getCmp('zonefor').getValue();
		var s_spl = "`~!$%^*()+={}[]|\\:;\"\'<>,?\/&";

		if(zonename!=null)
		{
			for(count = 0; count < zonename.length; count++)
			{
				var check_char = s_spl.indexOf(zonename.charAt(count));
				if(zonename.charAt(count) == ' ')
				{
					Ext.Msg.show({
						title : pageTitle,
						msg : publicJSON['screenLabels']['admin.common.space not allowed']+'.',
						icon : 'iconExclamation',
						buttons : Ext.Msg.OK,
						fn : function()
						{
							Ext.getCmp('zonename').focus();
						}
					});
					return false;
				}
				else if(check_char >= 0)
				{
					Ext.Msg.show({
						title : pageTitle,
						msg : publicJSON['screenLabels']['admin.common.special characters not allowed']+'.',
						icon : 'iconExclamation',
						buttons : Ext.Msg.OK,
						fn : function()
						{
							Ext.getCmp('zonename').focus();
						}
					});
					return false;
				}
				else if(!isDouble)
				{
					var charValue=zonename.charCodeAt(count);
					if(charValue>255)
					{
						Ext.Msg.show({
							title : pageTitle,
							msg : publicJSON['screenLabels']['admin.common.DBL not allowed']+'.',
							icon : 'iconExclamation',
							buttons : Ext.Msg.OK,
							fn : function()
							{
								Ext.getCmp('zonename').focus();
							}
						});
						return false;
					}
				}
			}
		}

		if (zonename==null || zonename.length == 0)
		{
			Ext.Msg.show({
				title : pageTitle,
				msg : publicJSON['screenLabels']['admin.common.Please enter a name']+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function()
				{
					Ext.getCmp('zonename').focus();
				}
			});
		}
		else if(assocaitedHostCount == null || assocaitedHostCount == undefined || assocaitedHostCount == 0)
		{
			Ext.Msg.show({
				title : pageTitle,
				msg : publicJSON['screenLabels']['admin.common.Please choose a component']+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function()
				{
					if(mode.toLowerCase() == "modify")
					{
						Ext.getCmp('itemselectHosts').getStore().suspendEvents(true);
						Ext.getCmp('itemselectHosts').getStore().loadRawData(publicJSON['itemSelectorValue']);
						Ext.getCmp('itemselectHosts').getStore().resumeEvents();
						Ext.getCmp('itemselectHosts').setValue(publicJSON['availableElementsArr']);
					}
					return false;
				}
			});
		}
		else if(zonename.toLowerCase() == 'all' || zonename.toLowerCase() == 'default')
		{
			Ext.Msg.show({
				title : pageTitle,
				msg : zoneAlert1+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function()
				{
					Ext.getCmp('zonename').focus();
				}
			});
			return false;
		}
		else if(zoneFor == null || zoneFor == undefined || zoneFor == "-1")
		{
			Ext.Msg.alert(pageTitle,zoneAlert2);
		}
		else
		{
			var unmanagedHostList = Ext.getCmp('itemselectHosts').getValue();
			var comp_type = Ext.getCmp('elementType').getValue();

			var Arr = new Array();
			for (var i=0;i<Ext.getCmp('itemselectHosts').getStore().getCount();i++)
			{
				var allValue = Ext.getCmp('itemselectHosts').getStore().getAt(i).get('valueField');
				var isData = false;
				for (var j=0;j<unmanagedHostList.length ;j++ )
				{
					if (allValue == unmanagedHostList[j])
					{
						isData = true;
						break;
					}
				}
				if (!isData)
				{
					Arr[Arr.length]=allValue;
				}
			}
			var tempmanagedHostList = Arr;
			var managedHostList = tempmanagedHostList.toString();
			var isValidate="false";
			if(!(managedHostList==""))
			{
				isValidate="true";
			}
//			var str='';
//			var association = Ext.getCmp('association').getValue();
//			if(association)
//				str='checked';
//			else
//				str='null';

			var imageName = Ext.getCmp('imagecombo').getValue();
			if(imageName==null || imageName=='-1' || imageName.length==0)
			{
				Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.choose an image']);
				return false;
			}
			Ext.Ajax.request({
				url: 'Zones/data/EgConfigZoneJson.jsp',
				params: "zone="+encodeURIComponent(zonename)+"&mode="+mode+"&validate="+isValidate+"&comptype="+encodeURIComponent(comp_type)+"&qctr=1"+"&modifyassociate=true",
				method: 'POST',
				success: function( response )
				{
					var jsonObj='';
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						jsonObj = Ext.decode( jsonText );
						var isValidName = jsonObj['screenLabels']['isValid'];
						if(isValidName=="false")
						{
							Ext.Msg.alert(pageTitle,jsonObj['screenLabels']['admin.common.ErroInAddingZone']);
							return;
						}
						else
						{
							if(managedHostList=="")
							{
								Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.Please choose a component']);
								return;
							}
							var oldZoneName='';
							if(mode!=null && mode=="modify")
							{
								oldZoneName = publicJSON['oldZoneName'];
							}
							var latitude = jsonObj['latitude'];
							var longitude = jsonObj['longitude'];
							var hiddenProcessObj = Ext.getCmp('hiddenprocesscontainer');
							hiddenProcessObj.removeAll();
							var temp = {
								xtype: 'hiddenfield',
								name: 'chosenHosts',
								id: 'chosenHosts',
								value: managedHostList
							};
							hiddenProcessObj.add(temp);

							//var resultUrl  = updateUrl+"&zone="+encodeURIComponent(zonename)+"&mode="+mode+"&comp_type="+encodeURIComponent(comp_type)+"&longitude="+longitude+"&latitude="+latitude+"&oldZoneName="+encodeURIComponent(oldZoneName)+'&imageName='+imageName+'&zoneFor='+zoneFor;

							var hiddenSrvObj = Ext.getCmp('componentzone').getForm();

							if (hiddenSrvObj.isValid())
							{
								var myMask = new Ext.LoadMask(Ext.getCmp('componentzone'), {msg: 'Updating...'});
								myMask.show();

								hiddenSrvObj.submit({
									url: 'Zones/data/EgconfigzonepJson.jsp?',
									params: "zone="+encodeURIComponent(zonename)+"&mode="+mode+"&comp_type="+encodeURIComponent(comp_type)+"&longitude="+longitude+"&latitude="+latitude+"&oldZoneName="+encodeURIComponent(oldZoneName)+'&imageName='+imageName+'&zoneFor='+zoneFor,
									method: 'POST',
									success: function(form,action )
									{
										myMask.hide();
										if ( action.response.status == 200 && !Ext.isEmpty( action.response.responseText ) )
										{
											var mjsonText = action.response.responseText;
											var mjsonObj = Ext.decode( mjsonText );
											if(mode=='add')
											{
												//window.location.href=mjsonObj['ForwardPageTo'];
												Ext.Msg.show({
													title : pageTitle,
													msg : "Zone '"+zonename+"' "+jsonObj['screenLabels']['admin.common.added successfully'],
													icon : 'iconInformation',
													buttons : Ext.Msg.OK
												});
											}
											else
											{
												Ext.Msg.show({
													title : pageTitle,
													msg : "Zone '"+zonename+"' "+jsonObj['screenLabels']['admin.common.updated successfully'],
													icon : 'iconInformation',
													buttons : Ext.Msg.OK
												});
											}
											var elementType = comp_type;
											configGroupController.buildFieldData("modify",zonename);
											configGroupController.afterMainRender("modify",zonename,comp_type);
										}
										hiddenProcessObj.removeAll();
									},
									failure: function(form,action)
									{
										myMask.hide();
										hiddenProcessObj.removeAll();
										configGroupController.buildFieldData("modify",zonename);
										configGroupController.afterMainRender("modify",zonename,comp_type);
										var mjsonText = action.response.responseText;
										var mjsonObj = Ext.decode( mjsonText );
										Ext.Msg.show({
											title : pageTitle,
											msg : mjsonObj['screenLabels']['admin.common.ErrorInRemovingComponents'],
											icon : 'iconError',
											buttons : Ext.Msg.OK
										});
									}
								});
							}
							else
							{
								Ext.Msg.show({
									title : pageTitle,
									msg : 'Form data is invalid',
									icon : 'iconError',
									buttons : Ext.Msg.OK
								});
							}
						}
					}
				}
			});
		}
	},
	addLocation:function()
	{
		isGeoLocNotThere = false;
		var mode = publicJSON['addModifyMode'];
		var zoomLevel=1;
		var Arr = new Array();
		var unmanagedHostList = Ext.getCmp('itemselectHosts').getValue();
		for (var i=0;i<Ext.getCmp('itemselectHosts').getStore().getCount();i++)
		{
			var allValue = Ext.getCmp('itemselectHosts').getStore().getAt(i).get('valueField');
			var isData = false;
			for (var j=0;j<unmanagedHostList.length ;j++ )
			{
				if (allValue == unmanagedHostList[j])
				{
					isData = true;
					break;
				}
			}
			if (!isData)
			{
				Arr[Arr.length]=allValue;
			}
		}
		var tempmanagedHostList = Arr;
		var managedHostList = tempmanagedHostList.toString();

		//var compCount = Ext.getCmp('itemselectHosts').getStore().getCount();
		if(managedHostList.length==0)
		{
			if(mode=="add")
			{
				var zonename = Ext.getCmp('zonename').getValue();
				if(zonename=='' || zonename==null)
				{
					Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.Please enter a name']);
					return;
				}
			}
			Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.Please associate element']);
			return;
		}
		if(mode=='add')
		{
			Ext.Msg.alert(pageTitle,publicJSON['screenLabels']["admin.common.Please add zone"]);
			return false;
		}
		
		var latValue=publicJSON['latitude'];
		var lngValue=publicJSON['longitude'];
		if(latValue==null || latValue=='')
			latValue=31.952162;
		if(lngValue==null || lngValue=='')
			lngValue=7.03125;

		var myGoogleMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Google Maps is being loaded. Please wait...'});
		myGoogleMask.show(); 
		
		var googleUrl = myScheme+'://maps.google.com/maps/api/js?sensor=false&key='+google_map_key;
		var dummyUrl = myScheme+"://www.google.com/jsapi";

		jQuery.ajax({
			url: dummyUrl,
			dataType: "script",
			timeout: (5 * 1000),
			async:true,
			cache: true
			}).done(function() {
				if(status != null && status == 'unloaded')
				{
					jQuery.ajax({
						url: googleUrl,
						dataType: "script",
						timeout: (5 * 1000),
						async:true,
						cache: true
						}).done(function() {
							myGoogleMask.hide(); 
							var mapwin = Ext.widget('gmpanel');
							mapwin.add({
								xtype: 'gmappanel',
								id:'mygooglemap',
								zoom: zoomLevel,
								gmapType: 'map',
								mapConfOpts: ['enableScrollWheelZoom','enableDoubleClickZoom','enableDragging'],
								mapControls: ['GSmallMapControl','GMapTypeControl','NonExistantControl'],
								center: new google.maps.LatLng(31.952162,7.03125),
								markers: [
									{
										lat: latValue,
										lng: lngValue,
										marker: {title: 'Boston Museum of Fine Arts'}
									}
								]
							});
							mapwin.show();
							status = "loaded";
					}).fail(function() {
						myGoogleMask.hide(); 
						Ext.Msg.alert(pageTitle,"Oops, we are not able to reach Google Maps!");
						status = "unloaded";
					});
				}
				else
				{
					myGoogleMask.hide(); 
					var mapwin = Ext.widget('gmpanel');
					mapwin.add({
						xtype: 'gmappanel',
						id:'mygooglemap',
						zoom: zoomLevel,
						gmapType: 'map',
						mapConfOpts: ['enableScrollWheelZoom','enableDoubleClickZoom','enableDragging'],
						mapControls: ['GSmallMapControl','GMapTypeControl','NonExistantControl'],
						center: new google.maps.LatLng(31.952162,7.03125),
						markers: [
							{
								lat: latValue,
								lng: lngValue,
								marker: {title: 'Boston Museum of Fine Arts'}
							}
						]
					});
					mapwin.show();
				}
			}).fail(function() {
				myGoogleMask.hide(); 
				Ext.Msg.alert(pageTitle,"Oops, we are not able to reach Google Maps! Please check your internet connection");
				status = "unloaded";
			});
		
		var viewPort = Ext.ComponentQuery.query('viewport')[0];
		/*viewPort.on('resize', function(vp, width, height) {
			var me = this,
					winWidth = me.getWidth(),
					winHeight = me.getHeight(),
					left = (width -winWidth) / 2,
					top = (height -winHeight) / 2;
				me.setPosition(left, top);

		}, mapwin);*/

		Ext.Ajax.request({
			url: 'Zones/data/zonemaphelpJson.jsp',
			method: 'POST',
			async: false
		});
	}
});

function updateLocationClick()
{
	var imageName = Ext.getCmp('imagecombo').getValue();
	if(imageName==null || imageName=='-1' || imageName.length==0)
	{
		Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.common.choose an image']);
		return false;
	}
	var mode = publicJSON['addModifyMode'];
	var zonename = '';
	if(mode=="add")
		zonename = Ext.getCmp('zonename').getValue();
	else
		zonename = Ext.getCmp('zonecombo').getValue();

	var updateUrl = 'Zones/data/EgconfigzonepJson.jsp?';
	var unmanagedHostList = Ext.getCmp('itemselectHosts').getValue();
	var comp_type = Ext.getCmp('elementType').getValue();

	var Arr = new Array();
	for (var i=0;i<Ext.getCmp('itemselectHosts').getStore().getCount();i++)
	{
		var allValue = Ext.getCmp('itemselectHosts').getStore().getAt(i).get('valueField');
		var isData = false;
		for (var j=0;j<unmanagedHostList.length ;j++ )
		{
			if (allValue == unmanagedHostList[j])
			{
				isData = true;
				break;
			}
		}
		if (!isData)
		{
			Arr[Arr.length]=allValue;
		}
	}
	var tempmanagedHostList = Arr;
	var managedHostList = tempmanagedHostList.toString();

//	var association = Ext.getCmp('association').getValue();
//	if(association=='true')
//		association='checked';
//	else
//		association='unchecked';

	var latitudePrev=publicJSON['latitude'];
	var longitudePrev=publicJSON['longitude'];
	var latitude = Ext.getCmp('hidden_field_lat').getValue();
	var longitude = Ext.getCmp('hidden_field_lng').getValue();

	if(latitude=='value from hidden field')
	{
		latitude=latitudePrev;
	}
	if(longitude=='value from hidden field')
	{
		longitude=longitudePrev;
	}


	var resultUrl  = updateUrl+"&zone="+encodeURIComponent(zonename)+"&mode=addGeoLocation&isGeoLocNotThere="+isGeoLocNotThere+"&comp_type="+encodeURIComponent(comp_type)+"&longitude="+longitude+"&latitude="+latitude+"&requestFrom=updateLocation"+"&latitude_prev="+latitudePrev+"&longitude_prev="+longitudePrev+"&imageName="+imageName;
	//window.location.href = resultUrl;
	Ext.Ajax.request({
		url: resultUrl,
		method: 'POST',
		async:false,
		success: function( response )
		{
			if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
			{
				Ext.getCmp('gmapwin').close();
				Ext.Ajax.request({
					url: 'Zones/data/EgConfigZoneJson.jsp?zone='+encodeURIComponent(zonename)+"&mode="+mode+"&comptype="+encodeURIComponent(comp_type)+"&qctr=1",
					method: 'POST',
					success: function( response )
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var jsonText = response.responseText;
							publicJSON = Ext.decode( jsonText );
						}
						Ext.getCmp('itemselectHosts').getStore().suspendEvents(true);
						Ext.getCmp('itemselectHosts').getStore().loadRawData(publicJSON['itemSelectorValue']);
						Ext.getCmp('itemselectHosts').getStore().resumeEvents();
						Ext.getCmp('itemselectHosts').setValue(publicJSON['availableElementsArr']);
						Ext.getCmp('addLocation').setText(publicJSON['screenLabels']['geographicLocation']);
					}
				});
			}
		}
	});



}

function removeLocationClick()
{
	var imageName = Ext.getCmp('imagecombo').getValue();
	var mode = publicJSON['addModifyMode'];
	var zonename = '';
	if(mode=="add")
		zonename = Ext.getCmp('zonename').getValue();
	else
		zonename = Ext.getCmp('zonecombo').getValue();

	var updateUrl = 'Zones/data/EgconfigzonepJson.jsp?';
	var unmanagedHostList = Ext.getCmp('itemselectHosts').getValue();
	var comp_type = Ext.getCmp('elementType').getValue();

	var Arr = new Array();
	for (var i=0;i<Ext.getCmp('itemselectHosts').getStore().getCount();i++)
	{
		var allValue = Ext.getCmp('itemselectHosts').getStore().getAt(i).get('valueField');
		var isData = false;
		for (var j=0;j<unmanagedHostList.length ;j++ )
		{
			if (allValue == unmanagedHostList[j])
			{
				isData = true;
				break;
			}
		}
		if (!isData)
		{
			Arr[Arr.length]=allValue;
		}
	}
	var tempmanagedHostList = Arr;
	var managedHostList = tempmanagedHostList.toString();

//	var association = Ext.getCmp('association').getValue();
//	if(association=='true')
//		association='checked';
//	else
//		association='unchecked';

	var latitude="null";
	var longitude="null";

	var latitudePrev = Ext.getCmp('hidden_field_lat').getValue();
	var longitudePrev = Ext.getCmp('hidden_field_lng').getValue();

	Ext.getCmp('hidden_field_lat').setValue(latitude);
	Ext.getCmp('hidden_field_lng').setValue(longitude);

	var resultUrl  = updateUrl+"&zone="+encodeURIComponent(zonename)+"&mode=removeGeoLocation&comp_type="+encodeURIComponent(comp_type)+"&longitude="+longitude+"&latitude="+latitude+"&requestFrom=updateLocation"+"&imageName="+imageName;//+"&latitude_prev="+latitudePrev+"&longitude_prev="+longitudePrev;
	//window.location.href=resultUrl;
	Ext.Ajax.request({
		url: resultUrl,
		method: 'POST',
		async:false,
		success: function( response )
		{
			if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
			{
				Ext.getCmp('gmapwin').close();
				Ext.Ajax.request({
					url: 'Zones/data/EgConfigZoneJson.jsp?zone='+encodeURIComponent(zonename)+"&mode="+mode+"&comptype="+encodeURIComponent(comp_type)+"&qctr=1",
					method: 'POST',
					success: function( response )
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var jsonText = response.responseText;
							publicJSON = Ext.decode( jsonText );
						}
						Ext.getCmp('itemselectHosts').getStore().suspendEvents(true);
						Ext.getCmp('itemselectHosts').getStore().loadRawData(publicJSON['itemSelectorValue']);
						Ext.getCmp('itemselectHosts').getStore().resumeEvents();
						Ext.getCmp('itemselectHosts').setValue(publicJSON['availableElementsArr']);
						Ext.getCmp('addLocation').setText(publicJSON['screenLabels']['geographicLocation']);
					}
				});
			}
		}
	});
}

function GoBtnClick(btn)
{
	var getaddress = Ext.getCmp('address').getValue();
	var mapOptions = Ext.getCmp('mygooglemap').getMapOptions();
	var mapObject = Ext.getCmp('mygooglemap').getMap();
	var centerObject = Ext.getCmp('mygooglemap').getCenter();
	var domObject = Ext.getCmp('mygooglemap').getDomObject();
	var geocoder = new google.maps.Geocoder();

	var request = {address: getaddress};
	var callBack = function(geocoderResults, geocoderStatus) {
		if(geocoderStatus === 'OK') {
			var location = geocoderResults[0].geometry.location;
			var latLng = new google.maps.LatLng(location.lat(), location.lng());

			Ext.getCmp('hidden_field_lat').setValue(location.lat());
			Ext.getCmp('hidden_field_lng').setValue(location.lng());
			Ext.getCmp('mygooglemap').hideMarkers();
			Ext.getCmp('gmapwin').close();
			var latValue=location.lat();
			var lngValue=location.lng();
			if(latValue==null || latValue=='')
				latValue=31.952162;
			if(lngValue==null || lngValue=='')
				lngValue=7.03125;
			var locationNotExist=false;
			if(publicJSON['latitude']==null || publicJSON['latitude']=='' )
			{
				publicJSON['latitude'] = latValue;
				publicJSON['longitude'] = lngValue;
				locationNotExist=true;
				isGeoLocNotThere = true;
			}

			var mapwin = Ext.widget('gmpanel');
			Ext.getCmp('address').setValue(getaddress);
			mapwin.add({
				xtype: 'gmappanel',
				id:'mygooglemap',
				zoom: 14,
				gmapType: 'map',
				mapConfOpts: ['enableScrollWheelZoom','enableDoubleClickZoom','enableDragging'],
				mapControls: ['GSmallMapControl','GMapTypeControl','NonExistantControl'],
				center: new google.maps.LatLng(location.lat(),location.lng()),
				markers: [
					{
						lat: latValue,
						lng: lngValue,
						marker: {title: getaddress}
					}
				]
			});
			mapwin.show();
			Ext.getCmp('mygooglemap').setMapType(mapObject.mapTypeId);
			var viewPort = Ext.ComponentQuery.query('viewport')[0];
			/*viewPort.on('resize', function(vp, width, height) {
				var me = this,
					winWidth = me.getWidth(),
					winHeight = me.getHeight(),
					left = (width -winWidth) / 2,
					top = (height -winHeight) / 2;

				me.setPosition(left, top);
			}, mapwin);*/
		}
		Ext.Ajax.request({
			url: 'Zones/data/zonemaphelpJson.jsp',
			method: 'POST',
			async: false
		});
	}
	geocoder.geocode(request,callBack);
}

function forAddingMarker(location)
{
	var marker = new google.maps.Marker({
		position: location,
		lat: location.lat(),
		lng: location.lng()
	});
	var zoomLevel = Ext.getCmp('mygooglemap').getZoomLevel(marker);
	Ext.getCmp('hidden_field_lat').setValue(location.lat());
	Ext.getCmp('hidden_field_lng').setValue(location.lng());
	var mapObject = Ext.getCmp('mygooglemap').getMap();
	Ext.getCmp('mygooglemap').hideMarkers();
	Ext.getCmp('gmapwin').close();
	var mapwin;
	var latValue=location.lat();
	var lngValue=location.lng();

	if(latValue==null || latValue=='')
		latValue=31.952162;
	if(lngValue==null || lngValue=='')
		lngValue=7.03125;
	var locationNotExist=false;
	if(publicJSON['latitude']==null || publicJSON['latitude']=='' )
	{
		publicJSON['latitude'] = latValue;
		publicJSON['longitude'] = lngValue;
		locationNotExist=true;
	}
	if(!mapwin){
		mapwin = Ext.create('Ext.Window', {
			layout: 'fit',
			title: 'Geographic location',
			id:'gmapwin',
			padding:'5 10 10 10',
			doClose: function() {
				Ext.Ajax.request({
					url: 'Zones/data/EgConfigZoneJson.jsp?mode='+mode,
					method: 'POST'
				});
				if(locationNotExist)
				{
					publicJSON['latitude'] = null;
					publicJSON['longitude'] = null;
				}
				this.destroy();
			},
			closeAction: 'destroy',
			width:650,
			height:450,
			border: false,
			//x: 40,
			//y: 60,
			dockedItems: [
				{
					xtype: 'toolbar',
					dock: 'top',
					cls: 'testConfigToolbarBg',
					ui: 'footer',
					margin: 0,
					padding: '5 0 5 0',
					layout:{pack:'left'},
					items: [
					{
						xtype: 'textfield',
						cls:'textbox',
						fieldLabel: 'Address',
						id:'address',
						name:'address',
						labelWidth: 50,
						labelPad:10,
						width:400
					},
					{
						xtype : 'button',
						cls:'button20',
						id : 'goBtn',
						text : 'GO',
						listeners:{
                			'click':GoBtnClick
                		}
					}
					]
				},{
					xtype: 'toolbar',
					dock: 'bottom',
					ui: 'footer',
					margin: 0,
					padding: '10 0 0 0',
					layout:{pack:'center'},
					items: [
					{
						text: 'Update',
						cls:'quickMenuWhiteButton',
						name: 'update',
						id:'locUpdateBtn',
						listeners:{
                			click:updateLocationClick
                		}
					},
					{
						text: 'Remove',
						cls:'quickMenuWhiteButton',
						name: 'remove',
						id:'locRemoveBtn',
						margin: '0 0 0 10',
						listeners:{
                			click:removeLocationClick
                		}
					}]
				}],
			items:{
				xtype: 'gmappanel',
				id:'mygooglemap',
				zoom: zoomLevel,
				gmapType: 'map',
				mapConfOpts: ['enableScrollWheelZoom','enableDoubleClickZoom','enableDragging'],
				mapControls: ['GSmallMapControl','GMapTypeControl','NonExistantControl'],
				center: new google.maps.LatLng(location.lat(),location.lng()),
				markers: [
					{
						lat: latValue,
						lng: lngValue,
						marker: {title: 'Boston Museum of Fine Arts'},
						listeners: {
							click: function(e){
							   // Ext.Msg.alert({title: 'Its fine', text: 'and its art.'});
							}
						}
					}
				]
			}
		});
	}
	mapwin.show();
	Ext.getCmp('mygooglemap').setMapType(mapObject.mapTypeId);
	var viewPort = Ext.ComponentQuery.query('viewport')[0];
	/*viewPort.on('resize', function(vp, width, height) {
		var me = this,
			winWidth = me.getWidth(),
			winHeight = me.getHeight(),
			left = (width -winWidth) / 2,
			top = (height -winHeight) / 2;

		me.setPosition(left, top);
	}, mapwin);*/

	Ext.Ajax.request({
	url: 'Zones/data/zonemaphelpJson.jsp',
	method: 'POST',
	async: false
	});
}
