Ext.define('Zones.view.GMPanel', {
	extend: 'Ext.window.Window',
	alias: 'widget.gmpanel',
	layout: 'fit',
	title: 'Geographic location',
	id:'gmapwin',
	padding:'5 10 10 10',
	doClose: function() {
		Ext.Ajax.request({
			url:'Zones/data/EgConfigZoneJson.jsp?mode='+mode,
			method:'POST'
		});
		this.destroy();
	},
	closeAction: 'destroy',
	width:650,
	height:450,
	border: false,
	dockedItems: [
	{
		xtype: 'toolbar',
		dock: 'top',
		cls: 'testConfigToolbarBg',
		ui: 'footer',
		margin: 0,
		padding: '5 0 5 0',
		layout:{pack:'left'},
		items: [
		{
			xtype: 'textfield',
			cls:'textbox',
			fieldLabel: 'Address',
			id:'address',
			name:'address',
			value:'',
			labelWidth: 50,
			labelPad:10,
			width:400,
			listeners:{
				specialkey: function (f,e) {
					if (e.getKey() == e.ENTER) { 
							Ext.getCmp('goBtn').focus();
					}
				}
			}
		},
		{
			xtype : 'button',
			cls:'button20',
			id : 'goBtn',
			text : 'GO',
			listeners:{
				'click':GoBtnClick
			}
		}
		]
	},
	{
		xtype: 'toolbar',
		dock: 'bottom',
		ui: 'footer',
		margin: 0,
		padding: '10 0 0 0',
		layout:{pack:'center'},
		items: [
		{
			text: 'Update',
			cls:'quickMenuWhiteButton',
			name: 'update',
			id:'locUpdateBtn',
			listeners:{
				click:updateLocationClick
			}
		},
		{
			text: 'Remove',
			cls:'quickMenuWhiteButton',
			name: 'remove',
			id:'locRemoveBtn',
			margin: '0 0 0 10',
			listeners:{
				click:removeLocationClick
			}
		}]
	}]
});