<%
/**********************************************************************************
*	Name			:	EgConfigZoneJson.jsp
*	Purpose			:	Modifying zones
*	design Changes	:	Jaiwin
*	Last Modified	:	July-23-2007		N.Gokulanand	For zone map changes.
***********************************************************************************/
%>
<%@ include file="../../EgTrackerAJSON.jsp" %>
<%//@ page errorPage="EgProbs.jsp"%>
<%@ page import="java.util.StringTokenizer"%>
<%@ page import="java.util.ArrayList"%>
<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgTopoInfo" %>
<%@ page import = "com.eg.EgGroupInfoAdmin" %>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgViewInfo" %>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "net.sf.json.*"%>

<%@ page import = "egurkha.config.EcUserData"%>
<%@ page import = "com.egurkha.EgUserRole"%>
<%@ page import = "com.eg.EgRoleInfo" %>
<%@ page import = "egurkha.EgDbAdapterUI"%>
<%@ page import = "com.eg.EgDbAdapterTypeUI"%>
<%@ page import = "java.sql.*"%>

<jsp:useBean id="zoneinfo" scope="page" class="egurkha.ZoneInfoBeanAdmin"/>
<%
	boolean isDouble=EgDbInfo.doubleByteEnabled;
%>
<%
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	
	rootJson.put("isDouble",isDouble);
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	
	//user specific work - start
	String s_arr1[] = null;
	ArrayList userSpecificComp = new ArrayList();
	ArrayList userSpecificCompType = new ArrayList();
	//user specific work - end

	EgViewInfo egviewinfo = new EgViewInfo("manager");
	String zoneName = request.getParameter("zone");
	String latitude = "null";
	String longitude = "null";
	boolean mapEnabled = false;
	IniFile uiIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_ui.ini");
	String mapLicense = uiIni.getValue("ZONE_MAP","mapEnabled");
	mapEnabled = (mapLicense != null && mapLicense.equalsIgnoreCase("yes"));
	IniFile topoIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini");
	String coordinate = topoIni.getValue("ZONE_LOCATION",zoneName);
	StringTokenizer st = new StringTokenizer(coordinate, "|");
	int tokenCount = 0;
	while(st.hasMoreTokens())
	{
		String thisToken = st.nextToken();
		switch(tokenCount)
		{
			case 0:
				latitude = thisToken;
			break;
			case 1:
				longitude = thisToken;
			break;
		}
		tokenCount++;
	}
	if(request.getParameter("latitude") != null && request.getParameter("longitude") != null)
	{
		latitude = request.getParameter("latitude");
		longitude = request.getParameter("longitude");
	}
	rootJson.put("latitude",latitude);
	rootJson.put("longitude",longitude);

	EgGroupInfoAdmin groupinfo = new EgGroupInfoAdmin();
	EgTopoInfo topoinfo = groupinfo.getTopoInfoObject();//new EgTopoInfo("manager");
	EgDiscInfo discinfo = new EgDiscInfo("manager");
	IniFile topologyIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_topology.ini");
	ArrayList managedHosts = new ArrayList();
	ArrayList managedZones = new ArrayList();
	ArrayList managedServices = new ArrayList();
	ArrayList managedSegments = new ArrayList();
	ArrayList managedGroups = new ArrayList();
	ArrayList allComponentTypes = new ArrayList();
	ArrayList minusHosts = new ArrayList();
	ArrayList allComponents = new ArrayList();

	String [] zones = groupinfo.getZoneNames();
	String [] groups = groupinfo.getGroupNames();
	String mode = request.getParameter("mode");
	String q_ctr = request.getParameter("qctr");
//	String association = request.getParameter("association"); //this is the association flag

	//user specific work - start
	ArrayList userSpecZoneList = new ArrayList();
	String sql_query = "";
	ResultSet rs = null;
	String con_status = "";
	EgDbAdapterUI egDb;

	String session_userId = (String)session.getAttribute("sess_userid");
	String userIdForZoneList = session_userId;

	EgUserRole userRole = _user.getUserRole();
	boolean hasAllComponentAccess = userRole.hasAllComponentAccess();

	if(!hasAllComponentAccess)
	{
		EgRoleInfo ri = EgRoleInfo.getInstance(_user);
		String[] ComponentsType = ri.getServerTypes();
		if(ComponentsType!=null && ComponentsType.length >0 )
		{
			for(int z=0;z<ComponentsType.length;z++)
			{
				s_arr1 = ri.getAllServersOfType(ComponentsType[z]);
				
				if(s_arr1!=null && s_arr1.length>0)
				{
					for (int count=0; count<s_arr1.length; count++)
					{
						String compType = s_arr1[count].toString();
						userSpecificComp.add(compType);
					}
				}
			}
		}

		egDb = EgDbAdapterTypeUI.getObject();
		con_status = egDb.setConnection();

		//groups
		try
		{
			if(con_status.equals("CONNECTED"))
			{
				sql_query = "SELECT GROUP_NAME FROM USER_GROUP WHERE USER_ID='" + userIdForZoneList + "' ";
				rs = egDb.SelectExec(sql_query);
				while(rs.next())
				{
					String grpName = rs.getString("GROUP_NAME");
					userSpecificComp.add("Group:"+grpName+":NULL");
				}
			}
		}
		catch(Exception e1)
		{
			out.println(e1.getMessage());
		}
		finally
		{
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
		}

		//segement
		try
		{
			if(con_status.equals("CONNECTED"))
			{
				sql_query = "SELECT SEG_NAME FROM USER_SEG WHERE USER_ID='" + userIdForZoneList + "' ";
				rs = egDb.SelectExec(sql_query);
				while(rs.next())
				{
					String seg_Name = rs.getString("SEG_NAME");
					userSpecificComp.add("Segment:"+seg_Name+":NULL");
				}
			}
		}
		catch(Exception e1)
		{
			out.println(e1.getMessage());
		}
		finally
		{
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
		}

		//service
		try
		{
			if(con_status.equals("CONNECTED"))
			{
				sql_query = "SELECT SITE_NAME FROM USER_SITE WHERE USER_ID='" + userIdForZoneList + "' ";
				rs = egDb.SelectExec(sql_query);
				while(rs.next())
				{
					String site_Name = rs.getString("SITE_NAME");
					userSpecificComp.add("Service:"+site_Name+":NULL");
				}
			}
		}
		catch(Exception e1)
		{
			out.println(e1.getMessage());
		}
		finally
		{
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
		}

		//zone
		try
		{
			if(con_status.equals("CONNECTED"))
			{
				sql_query = "SELECT ZONE_NAME FROM USER_ZONE WHERE USER_ID='" + userIdForZoneList + "' ";
				rs = egDb.SelectExec(sql_query);
				while(rs.next())
				{
					String zone_Name = rs.getString("ZONE_NAME");
					userSpecZoneList.add(zone_Name);
					userSpecificComp.add("Zone:"+zone_Name+":NULL");
				}
			}
		}
		catch(Exception e1)
		{
			out.println(e1.getMessage());
		}
		finally
		{
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
		}
		egDb.releaseConnection(false);
		EgDbAdapterTypeUI.releaseObject(egDb);
		
		ArrayList comps = groupinfo.getAllElementsUnderZone(zoneName, true);
		for (int i=0;i<comps.size() ;i++ )
		{
			String thisName = (String)comps.get(i);
			String type = null;
			if(thisName != null && thisName.indexOf(":") > 0)
			{
				type = thisName.substring(0, thisName.indexOf(":"));
			}
			else
			{
				continue;
			}
			if (!userSpecificComp.contains(thisName))
			{
				userSpecificComp.add(thisName);
			}
		}
		if(userSpecificComp!=null && userSpecificComp.size()>0)
		{
			for(int i=0;i<userSpecificComp.size();i++)
			{
				String thisComponent = (String)userSpecificComp.get(i);
				if (zoneName != null && zoneName.length() > 0)
				{
					if (thisComponent.indexOf("Zone:"+zoneName+":NULL") != -1)
					{
						continue;
					}
				}
				String thisType = thisComponent.substring(0,thisComponent.indexOf(":"));
				if(thisType!=null && !userSpecificCompType.contains(thisType))
				{
					userSpecificCompType.add(thisType);
				}
				
			}
		}
	}
	//user specific work - end

	String comp_type = "";
	String [] services = topoinfo.getWebSites();
	String [] allSegments = topoinfo.getSegmentNames();
	String modifyassociate=request.getParameter("modifyassociate");
	IniUI  iniUI = IniUI.getInstance();
	String validate = request.getParameter("validate");
	if(validate==null) 
		validate="false";
	boolean isValidZoneName=true;

	if(zoneName!=null && zoneName.length()>0 && validate.equalsIgnoreCase("true"))
	{
		if(IniUI.isEgReservedKeyword(zoneName))
		{
			/* code for auditlog starts */
			//auditLogThread.setValue("Description",group + " group has not been created as the name is eG defined keyword");
			//auditLogThread.sendItToDB();
			isValidZoneName=false;
			
			screenLabels.put("isValid","false");
			screenLabels.put("admin.common.ErroInAddingZone","'"+zoneName +"' "+_mapping.getTextDescription("admin.error.is an eG defined keyword")+". "+_mapping.getTextDescription("admin.error.Choose another name"));

		}
		if(!mode.equalsIgnoreCase("modify"))
		{
			IniFile topoIni_1 = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini");
			String[] strSubArr = topoIni_1.getVariables("LIST_OF_ZONES");
			if(strSubArr == null)
				return;
			boolean zoneExists=false;
			for(int i=0; i<strSubArr.length; i++)
			{
				if(zoneName.equalsIgnoreCase(strSubArr[i]))
				{
					zoneExists = true;
					break;
				}
			}
			if(zoneExists)
			{
				/* code for auditlog starts */
				//auditLogThread.setValue("Description",group + " group has not been created as it already exists");
				//auditLogThread.sendItToDB();
				/* code for auditlog ends */
				isValidZoneName=false;

				screenLabels.put("isValid","false");
				screenLabels.put("admin.common.ErroInAddingZone","'"+zoneName +"'"+" "+_mapping.getTextDescription("admin.error.already exists")+". "+_mapping.getTextDescription("admin.error.Choose another name"));

			}
		}
	}

	IniFile topoIniWr = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini");
	if(zoneName!=null && !zoneName.equals("null") && modifyassociate!=null && modifyassociate.equals("true") && isValidZoneName && validate.equalsIgnoreCase("true"))
	{
		AuditLogThread auditLogThread = new AuditLogThread();	
		auditLogThread.setValue("Category","Admin");
		auditLogThread.setValue("User_id",_user.getLoginID());
		auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
		auditLogThread.setValue("Session_id",session.getId());
		auditLogThread.setValue("Module","Zones");
		auditLogThread.setValue("Activity", "Zone Configuration");
//		if(association!=null && association.equals("checked"))
//		{
//			//auditLogThread.setPreviousValue("Auto association","Disabled");
//			//auditLogThread.setCurrentValue("Auto association","Enabled");
//			topoIniWr.setValue("ZONE_ASSOCIATION",zoneName,"checked");
//		}
//		else
//		{
//			//auditLogThread.setPreviousValue("Auto association","Enabled");
//			//auditLogThread.setCurrentValue("Auto association","Disabled");
//			topoIniWr.setValue("ZONE_ASSOCIATION",zoneName, "null");
//		}
		//auditLogThread.setValue("Description","Zone "+zoneName+" has been modified");*/
		//auditLogThread.sendItToDB();
		topoIniWr.saveFile();
	}
	EgConfigFilesSync.releaseInstance(topoIniWr);
	topoIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini");
//	String checking = topoIni.getValue("ZONE_ASSOCIATION", zoneName);
//	if (!(checking==null) && !(checking.equals("")))
//		association = checking;
//	
//	if(association==null)
//		association="checked";
//
//	rootJson.put("association",association);
	if(q_ctr!=null&&q_ctr.equals("1"))
	{
		comp_type=request.getParameter("comptype");
		allComponents = zoneinfo.getUnManagedZoneElements(zoneName, comp_type, true);
	}
	rootJson.put("elementType",comp_type);

	// For Type of Elements
	JSONArray cbArray = new JSONArray();
	JSONObject cbObject = new JSONObject();

	allComponentTypes = zoneinfo.getAllCompTypes(zoneName);
	ArrayList serverList = new ArrayList(allComponentTypes);
	String userLanguage = _user.getLanguage();
	if (userLanguage == null)
		userLanguage = iniUI.getDefaultLanguage();
				
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	serverList = sorter.getSortedCompTypeList(serverList);

	ArrayList elements = new ArrayList();
	cbObject.put("displayField","Choose one");
	cbObject.put("valueField","-1");
	cbArray.add(cbObject);
	ArrayList allComp = null;
	for (int i=0; i<serverList.size(); i++)
	{
		//String thisType = (String) allComponentTypes.get(i);
		EgName nameObj = (EgName)serverList.get(i);
		String tmpVal = nameObj.getActualName();
		String tmpDis = nameObj.getLocalName();
		//user specific work - start

		if(!hasAllComponentAccess /* || session_userId.equalsIgnoreCase("egenterprise")*/)
		{
			if(!userSpecificCompType.contains(tmpVal))
			{
				continue;
			}
		}
		allComp = zoneinfo.getUnManagedZoneElements(zoneName, tmpVal, true);
		int contain = 0;
		if(!hasAllComponentAccess /* || session_userId.equalsIgnoreCase("egenterprise")*/)
		{
			for (int j=0; j< allComp.size(); j++)
			{
				if(userSpecificComp.contains((String)allComp.get(j)))
				{
					contain++;
				}
			}
			if (contain <= 0)
			{
				continue;
			}
		}
		
		//user specific work - end
		if(!tmpVal.equals("Group") && !tmpVal.equals("Segment") && !tmpVal.equals("Service") && !tmpVal.equals("Zone"))
		{
			if(!elements.contains("Component"))
			{
				cbObject.put("displayField","Component");
				cbObject.put("valueField","Component");
				cbArray.add(cbObject);
				elements.add("Component");
			}
		}
		else
		{
			cbObject.put("displayField",tmpDis);
			cbObject.put("valueField",tmpVal);
			cbArray.add(cbObject);
		}
	}
	rootJson.put("TypeOfElements",cbArray);

	// For Component type
	JSONArray ctArray = new JSONArray();
	JSONObject ctObject = new JSONObject();

	ArrayList types = new ArrayList();
	ctObject.put("displayField","Choose one");
	ctObject.put("valueField","-1");
	ctArray.add(ctObject);
	for (int i=0; i<serverList.size(); i++)
	{
		//String thisType = (String) allComponentTypes.get(i);
		EgName nameObj = (EgName)serverList.get(i);
		String tmpVal = nameObj.getActualName();
		String tmpDis = nameObj.getLocalName();
		//user specific work - start
		if(!hasAllComponentAccess /* || session_userId.equalsIgnoreCase("egenterprise")*/)
		{
			if(!userSpecificCompType.contains(tmpVal))
			{
				continue;
			}
		}
		allComp = zoneinfo.getUnManagedZoneElements(zoneName, tmpVal, true);
		int contain = 0;
		if(!hasAllComponentAccess /* || session_userId.equalsIgnoreCase("egenterprise")*/)
		{
			for (int j=0; j< allComp.size(); j++)
			{
				if(userSpecificComp.contains((String)allComp.get(j)))
				{
					contain++;
				}
			}
			if (contain <= 0)
			{
				continue;
			}
		}
		//user specific work - end
		if(!tmpVal.equals("Group") && !tmpVal.equals("Segment") && !tmpVal.equals("Service") && !tmpVal.equals("Zone"))
		{
			ctObject.put("displayField",tmpDis);
			ctObject.put("valueField",tmpVal);
			ctArray.add(ctObject);
		}
	}
	rootJson.put("TypeOfComponent",ctArray);
	
	/** For map changes */
	rootJson.put("mapEnabled",mapEnabled);
	if(mapEnabled)
	{
		if(latitude.equals("null") || longitude.equals("null"))
		{
			screenLabels.put("geographicLocation",_mapping.getTextDescription("admin.zone.Add geographic location"));
		}
		else
		{
			screenLabels.put("geographicLocation",_mapping.getTextDescription("admin.zone.Change / Remove geographic location"));
		}
	}
	/* map changes end */
	
	/* For ItemSelector */
	JSONArray commonElements = new JSONArray();
	JSONArray availableElementsArr = new JSONArray();
	JSONArray associatedElementsArr = new JSONArray();
	JSONObject commonObject = new JSONObject();
	
	// Elements Associated
	String result = "";
	ArrayList mHosts = zoneinfo.getAllElementsUnderZone(zoneName);
	managedHosts = zoneinfo.getManagedZoneElements(zoneName, false);
	Collections.sort(managedHosts);
	StringBuffer prevVal = new StringBuffer();
	for(int x=0;x < managedHosts.size();x++)
	{
		String thisComponent = (String)managedHosts.get(x);
		result+=thisComponent;
		if (!((x+1)==managedHosts.size()))
			result+=",";

		String thisType = thisComponent.substring(0, thisComponent.indexOf(":"));
		String thisName = thisComponent.substring(thisComponent.indexOf(":")+1, thisComponent.lastIndexOf(":"));
		String thisPort = thisComponent.substring(thisComponent.lastIndexOf(":")+1);

		if (thisType.equals("Zone"))
		{
			managedZones.add(thisComponent);
			thisType = " ["+thisType+"] ";
		}
		else if (thisType.equals("Segment"))
		{
			managedSegments.add(thisComponent);
			thisType = " ["+thisType+"] ";
		}
		else if (thisType.equals("Service"))
		{
			managedServices.add(thisComponent);
			thisType = " ["+thisType+"] ";
		}
		else if (thisType.equals("Group"))
		{
			managedGroups.add(thisComponent);
			thisType = " ["+thisType+"] ";
		}else
		{
			thisType = ":"+_mapping.getComponentTypeDescription(thisType);
		}
		prevVal.append(thisComponent);
		if ((x+1)<managedHosts.size())
			prevVal.append(",");

		String thisDispString = thisName+(!thisPort.equals("NULL")?":"+thisPort:"")+thisType;
		//out.println("<option value=" + thisComponent + ">" + thisDispString + "</option>");

		associatedElementsArr.add(thisComponent);
		
		commonObject.put("displayField",thisDispString);
		commonObject.put("valueField",thisComponent);
		commonElements.add(commonObject);
	}
	
	// Elements available
	if (allComponents != null && !allComponents.isEmpty())
	{
		Collections.sort(allComponents,String.CASE_INSENSITIVE_ORDER);
	}
	for (int i=0; i<allComponents.size(); i++)
	{
		String thisComponent = (String)allComponents.get(i);
		String thisType = thisComponent.substring(0, thisComponent.indexOf(":"));
		String thisName = thisComponent.substring(thisComponent.indexOf(":")+1, thisComponent.lastIndexOf(":"));
		String thisPort = thisComponent.substring(thisComponent.lastIndexOf(":")+1);
		String thisDispString = thisName+(!thisPort.equals("NULL")?":"+thisPort:"");

		availableElementsArr.add(thisComponent);
		// user specific work - start
		if(!hasAllComponentAccess /* || session_userId.equalsIgnoreCase("egenterprise")*/)
		{
			if(!userSpecificComp.contains(thisComponent))
			{
				continue;
			}
		}
		// user specific work - end
		commonObject.put("displayField",thisDispString);
		commonObject.put("valueField",thisComponent);
		commonElements.add(commonObject);
	}

	if (managedHosts.size() > 0)
	{
		managedHosts.removeAll(managedZones);
		managedHosts.removeAll(managedSegments);
		managedHosts.removeAll(managedServices);
		managedHosts.removeAll(managedGroups);
		ArrayList masters = groupinfo.getMainZoneList(zoneName, false);
		ArrayList slaves = groupinfo.getSubZoneList(zoneName, false);
		
		StringBuffer mastersBuff = new StringBuffer();
		StringBuffer managedZonesBuff = new StringBuffer();
		StringBuffer managedServicesBuff = new StringBuffer();
		StringBuffer managedSegmentsBuff = new StringBuffer();
		StringBuffer managedGroupsBuff = new StringBuffer();
		StringBuffer managedHostsBuff = new StringBuffer();

		if(masters != null)
			if (masters.size()>0)
			{
				int size = masters.size();
				for(int x=0; x<size; x++)
				{
					mastersBuff.append(masters.get(x));
					if(size != (x+1))
						mastersBuff.append(",");
				}
			}
		if(managedZones != null)
			if (managedZones.size()>0)
			{
				int size = managedZones.size();
				for(int x=0; x<size; x++)
				{
					String thisZone = (String)managedZones.get(x);
					String thisDispString = thisZone.substring(thisZone.indexOf(":")+1, thisZone.lastIndexOf(":"));
					managedZonesBuff.append(thisDispString);
					if(size != (x+1))
						managedZonesBuff.append(",");
				}
			}
		if (managedServices.size()>0)
		{
			int size = managedServices.size();
			int displayLength = 30;
			for(int x=0; x<size; x++)
			{
				String thisService = (String)managedServices.get(x);
				String thisDispString = thisService.substring(thisService.indexOf(":")+1, thisService.lastIndexOf(":"));
				managedServicesBuff.append(StringUtils.egSubString(thisDispString,displayLength));
				if(size != (x+1))
					managedServicesBuff.append(",");
			}
		}
		if (managedSegments.size()>0)
		{
			int size = managedSegments.size();
			int displayLength = 30;
			for(int x=0; x<size; x++)
			{
				String thisSegment = (String)managedSegments.get(x);
				String thisDispString = thisSegment.substring(thisSegment.indexOf(":")+1, thisSegment.lastIndexOf(":"));
				managedSegmentsBuff.append(StringUtils.egSubString(thisDispString,displayLength));
				if(size != (x+1))
					managedSegmentsBuff.append(",");
			}
		}
		if (managedGroups.size()>0)
		{
			int size = managedGroups.size();
			for(int x=0; x<size; x++)
			{
				String thisSrv =(String)managedGroups.get(x);
				String thisDispString=thisSrv.substring(thisSrv.indexOf(":")+1, thisSrv.lastIndexOf(":"));
				managedGroupsBuff.append(thisDispString);
				if(size != (x+1))
					managedGroupsBuff.append(",");
			}
		}
		if (managedHosts.size()>0)
		{
			int size = managedHosts.size();
			for(int x=0; x<size; x++)
			{
				String thisHost = (String)managedHosts.get(x);
				String thisType = thisHost.substring(0, thisHost.indexOf(":"));
				String thisName = thisHost.substring(thisHost.indexOf(":")+1, thisHost.lastIndexOf(":"));
				String thisPort = thisHost.substring(thisHost.lastIndexOf(":")+1);
				String thisDispString = thisName+(!thisPort.equals("NULL")?":"+thisPort:"")+":"+thisType;
				String finalDisplayString=thisName+(!thisPort.equals("NULL")?":"+thisPort:"")+":";
				if(thisType.startsWith("Agg_"))
				{
					String str = finalDisplayString+thisType;
					managedHostsBuff.append(str);
					if(size != (x+1))
						managedHostsBuff.append(",");
				}
			}
		}
	}

   String viewpresent="no";
   Vector viewzone=egviewinfo.getviewsforzone(zoneName);
   if(viewzone.isEmpty())
      viewpresent="no";
      else
	     viewpresent="Yes";

	/*Vector sess_vec = new Vector();
	sess_vec.addElement("Configure zones");
	sess_vec.addElement("EgConfigZone.jsp?comptype=" +EgURLEncoder.encode(comp_type,"UTF-8") + "&qctr=1&zone="+EgURLEncoder.encode(zoneName,"UTF-8"));
	sess_vec.addElement("All elements cannot be removed from the zone");	
	sess_vec.addElement("All elements cannot be removed from the zone.");
	sess_vec.addElement("Hence this operation cannot be performed.");
	session.putValue("vec_Errors",sess_vec);*/

	String queryString = request.getQueryString();

	String Qstring="";
	if(queryString!=null)
	{
		StringTokenizer strtok = new StringTokenizer(queryString,"&");
		while(strtok.hasMoreTokens())
		{
			String param = strtok.nextToken();
			int ind = param.indexOf("=");
			if (ind < 0)
				continue;
			String reqparam =param.substring(0,ind);
			String value = param.substring(ind+1);
			if(reqparam!=null&&reqparam.equals("zone"))
			{
				value=com.eg.EgURLEncoder.encode(request.getParameter(reqparam), "UTF-8");
			}
			
			Qstring=Qstring+reqparam+"="+value+"&";
		}
	}
	/*if(Qstring!=null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgComponentZones.jsp?"+Qstring+"&zone="+zoneName+"&association="+association);
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgComponentZones.jsp");
	}*/

	if(mode.equals("add"))
	{
		screenLabels.put("admin.common.buttonText",_mapping.getTextDescription("admin.common.Add"));
	}
	else if(mode.equals("modify"))
	{
		screenLabels.put("admin.common.buttonText",_mapping.getTextDescription("admin.common.Update"));
	}
	
	//Alert message for Validations
	screenLabels.put("admin.common.Please enter a name",_mapping.getTextDescription("admin.common.Please enter a zone name"));
	screenLabels.put("admin.common.Please choose a component",_mapping.getTextDescription("admin.common.Please associate atleast one component to a zone"));
	screenLabels.put("admin.common.space not allowed",_mapping.getTextDescription("admin.common.Space is not allowed in Zone name "));
	screenLabels.put("admin.common.special characters not allowed",_mapping.getTextDescription("admin.common.Special characters are not allowed in Zone name"));
	screenLabels.put("admin.common.DBL not allowed",_mapping.getTextDescription("admin.zone.Zone name is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte"));
	screenLabels.put("admin.common.choose an image",_mapping.getTextDescription("admin.common.Please choose an image"));
	screenLabels.put("admin.common.added successfully",_mapping.getTextDescription("admin.common.has been added successfully"));
	screenLabels.put("admin.common.updated successfully",_mapping.getTextDescription("admin.common.has been updated successfully"));
	screenLabels.put("admin.common.Please associate element",_mapping.getTextDescription("admin.common.Please associate an element and try again"));
	screenLabels.put("admin.common.Please add zone",_mapping.getTextDescription("admin.common.Please add the zone and try again"));

	rootJson.put("updateUrl","EgconfigzonepExt.jsp?");
	//rootJson.put("updateUrl","Egconfigzonep.jsp?");

	// To get all available Zone names
	JSONArray zArray = new JSONArray();
	JSONObject zObject = new JSONObject();

	/*cbObject.put("displayField",_mapping.getTextDescription("admin.server.Choose One"));
	cbObject.put("valueField","-1");
	cbArray.add(cbObject);*/

	if(mode!=null && mode.equalsIgnoreCase("modify"))
	{
		String strVarArr[] = groupinfo.getZoneNames();
		if (strVarArr==null)
			strVarArr=new String[0];
		Arrays.sort(strVarArr,String.CASE_INSENSITIVE_ORDER);
		for(int i=0;i<strVarArr.length;i++)
		{
			String str = strVarArr[i];
			//user specific work - start
			//if (user_id.equals((String)session.getAttribute("sess_userid")))
			{
				if(!hasAllComponentAccess /* || session_userId.equalsIgnoreCase("egenterprise")*/)
				{
					if(userSpecZoneList!=null && !userSpecZoneList.contains(str))
					{
						continue;
					}
				}
			}
			//user specific work - end
			zObject.put("displayField",str);
			zObject.put("valueField",str);
			zArray.add(zObject);
		}
	}
	rootJson.put("ExistingZoneNames",zArray);

	rootJson.put("screenLabels",screenLabels);
	rootJson.put("itemSelectorValue",commonElements);
	rootJson.put("associatedElementsArr",associatedElementsArr);
	rootJson.put("availableElementsArr",availableElementsArr);
	rootJson.put("addModifyMode",mode);
	rootJson.put("ZoneName",zoneName);
	rootJson.put("oldZoneName",zoneName);
	
	// For Image Display
	JSONArray imageArray = new JSONArray();
	JSONObject imageObject = new JSONObject();
	String imageVariable[]=null;
	imageVariable = uiIni.getVariables("ZONE_IMAGE_MAPPING");
	
	//Hashtable classImage = new Hashtable();
	if(imageVariable!=null && imageVariable.length>0)
	{
		for(int i=0; i<imageVariable.length;i++)
		{
			String displayText=imageVariable[i];
			String imgClassName = uiIni.getValue("ZONE_IMAGE_MAPPING",displayText);
			imageObject.put("abbr",imgClassName);
			imageObject.put("name",displayText);
			imageArray.add(imageObject);
			//classImage.put(imgClassName,displayText);
		}
	}
	rootJson.put("imageArray",imageArray);

	// For Zone Type 
	JSONArray zoneTypeArray = new JSONArray();
	JSONObject zoneTypeObject = new JSONObject();

	zoneTypeObject.put("displayField","Monitor and Reporter");
	zoneTypeObject.put("valueField","Monitor and Reporter");
	zoneTypeArray.add(zoneTypeObject);

	zoneTypeObject.put("displayField","Monitor");
	zoneTypeObject.put("valueField","Monitor");
	zoneTypeArray.add(zoneTypeObject);

	zoneTypeObject.put("displayField","Reporter");
	zoneTypeObject.put("valueField","Reporter");
	zoneTypeArray.add(zoneTypeObject);

	rootJson.put("zoneTypeArray",zoneTypeArray);

	String zoneFor = "Monitor and Reporter";
	String[] entireZones = topoIni.getVariables("ZONE_FOR");
	for(int i = 0; i < entireZones.length; i++)
	{
		String z = entireZones[i];
		if(z.equals(zoneName))
		{
			zoneFor = topoIni.getValue("ZONE_FOR",z);
		}
	}
	rootJson.put("zoneFor",zoneFor);

	if(mode.equalsIgnoreCase("modify"))
	{
		String ImageForThisSer = topoIni.getValue("ZONE_DISPLAY_IMAGE",zoneName);
		//String imgValue = (String)classImage.get(ImageForThisSer);
		rootJson.put("selectedImage",ImageForThisSer);
	}
	out.println(rootJson.toString());
%>
