<!DOCTYPE html>

<%@ include file = "EgTrackerA.jsp" %>
<%@ page errorPage = "EgProbs.jsp" %>
<%@ page import="com.eg.*" %>
<%@ page import = "com.eg.EgInvBean" %>
<%@ page import = "com.eg.EgDiscInfo" %>
<%@ page import="com.eg.EgDbInfo"%>
<%@ page import = "com.eg.EgServicesInfo"%>
<%@ page import="com.eg.AgentConfig" %>
<%@ page import="com.eg.EgInfrastructure" %>
<%@ page import="com.eg.EgRoleInfo" %>
<%@ page import="com.egurkha.ini.IniUI" %>
<%@ page import="com.eg.MappingNameSorter" %>
<%@ page import="com.eg.EgName" %>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import="com.egurkha.util.StringUtils"%>


<%@ taglib prefix = "egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	String print = (String) request.getParameter("print");
%>

<html>
<head>

<title>Component Details</title>
<meta charset="utf-8">

<%
	if (print!=null && print.equalsIgnoreCase("printpage"))
	{
%>
<link rel="stylesheet" type="text/css" href="/final/styles/eGLightTheme.css" />
<link rel="stylesheet" type="text/css" href="/final/styles/eGLightThemeIcons.css" />
<%
	}
%>

<style>

@media print {body {-webkit-print-color-adjust: exact;}}

@font-face{font-family:'LucidaGrandeRegular';src:url('../fonts/6216/6216.woff') format('woff')}
@font-face{font-family:'LucidaGrandeBold';src:url('../fonts/6215/6215.woff') format('woff')}

body{;font-size:11px;line-height:1.5em;color:#2a292a;}
header{;font-size:15px;}
.formLabel {;font-size:12px;}
.formValue {font-weight:500;font-size:12px;}
b{font-weight:500;font-size:11px;}
table tr td{;font-size:11px;padding:4px;}

.printTable{border: 1px solid #c3c3c3; border-collapse: collapse;}
.printTable tr td{border: 1px solid #c3c3c3;}

.printTableHeader{font-weight:500;border: 1px solid #c3c3c3;text-align:center;background-color:#cdcdcd;padding:4px;}
.printTableHeader2{font-weight:500;border: 1px solid #c3c3c3;text-align:left;background-color:#cdcdcd;padding:4px;}

</style>
<script language="JavaScript">
	function printData()
	{
		window.print();
	}
</script>
</head>

<%!
	String[] criterias = {"Zone","Service","Segment","Component"};
	int compTypeLength = 25;
%>

<%
	User user = registry.getUser(session.getId());
	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	EgDiscInfo discInfo = new EgDiscInfo("manager");
	EgServicesInfo servicesInfo = new EgServicesInfo("manager");
	boolean isAllowHostName = servicesInfo.isAllowHostNames();
	EgInvBean invBean = new EgInvBean();
	AgentConfig agentConfig = AgentConfig.getAgentConfig();
	TreeMap allCompFields = new TreeMap();
	allCompFields = invBean.getAllFieldForManagedServer(); //contains all fields for a component name
	String sortBy = null;
	sortBy = (String)session.getAttribute("sortBy");
	String sortDataBy = null;
	String number[]={"0","1"};
	if (StringUtils.isNull(sortBy))
	{
		sortBy=number[0];
	}
	if(sortBy.equalsIgnoreCase("0"))
	{
		sortDataBy = "Nick name";
	}
	else if(sortBy.equalsIgnoreCase("1"))
	{
		sortDataBy = "Component type";
	}
	else if(sortBy.equalsIgnoreCase("2"))
	{
		sortDataBy = "Operating system";
	}

	EgInfrastructure egInfrastructure = null;
	List listManagedComponents = ri.getAllServers();
	Hashtable serviceHt = new Hashtable();
	Hashtable segmentHt = new Hashtable();
	Hashtable zoneHt = new Hashtable();

	if (listManagedComponents != null && listManagedComponents.size() > 0)
	{
		Iterator itr = listManagedComponents.iterator();
		while(itr.hasNext())
		{
			String comp = (String)itr.next();
			if(comp.startsWith("Agg_"))
			{
				continue;
			}
			itr.remove();
		}
	}

	ArrayList aListManagedComponents = null;
	ArrayList aListManagedComponentTypes = new ArrayList();
	boolean hasManagedComponents = false;
	if (listManagedComponents != null && listManagedComponents.size() > 0)
	{
		hasManagedComponents = true;
	}
	aListManagedComponents = (ArrayList) session.getAttribute("aListManagedComponents");

	TreeMap tmapComponents = null;
	TreeMap tmapComponentsCount = null;
	TreeMap tmapItInfrastructureCount = null;
	TreeMap tmapItInfrastructureClassificationCount = null;

	boolean showHorizontal = false;
	boolean showcomponentTypeWise = false;
	boolean showcomponentNameWise = false;

	//for zone,service,segment
	ArrayList aListCriterias = null;
	ArrayList aListUserOptions = null;
	ArrayList aListAssociatedComponents = null;

	String viewIn = null;
	String viewAs = null;
	String ea_criteria = null;
	String ea_criteriaPrevious = null;
	String ea_userOption = null;

	if (hasManagedComponents)
	{
		ea_criteria = (String)session.getAttribute("ea_criteria");
		ea_userOption = (String)session.getAttribute("ea_userOption");
		viewIn = (String) session.getAttribute("viewIn");
		viewAs = (String)session.getAttribute("viewAs");
		
		if (ea_criteria == null)
		{
			ea_criteria = "Component";
		}
		if (viewAs == null || viewAs.equals(""))
		{
			viewAs = "categoryWise";
		}

		aListCriterias = new ArrayList();
		for (int i=0;i<criterias.length;i++)
		{
			String criteria = criterias[i];
			aListCriterias.add(criteria);
		}

		EgGroupInfo egGroupInfo = new EgGroupInfo();
		EgTopoInfo egTopoInfo = egGroupInfo.getTopoInfoObject();
		Vector vecUserAssociatedComponents = new Vector(user.getServers(false));
		if(vecUserAssociatedComponents != null && vecUserAssociatedComponents.size() > 0)
		{
			Iterator itr = vecUserAssociatedComponents.iterator();
			while(itr.hasNext())
			{
				String comp = (String)itr.next();
				if(comp.startsWith("Agg_"))
				{
					continue;
				}
				itr.remove();
			}
		}

		if (ea_criteria.equalsIgnoreCase(criterias[0]))
		{
			ArrayList aListComponentsFromZone = new ArrayList();
			List zoneList = user.getZones();
			if(zoneList != null && !zoneList.isEmpty())
			{
				Iterator zoneItr = zoneList.iterator();
				while(zoneItr.hasNext())
				{
					String strZone = (String) zoneItr.next();
					ArrayList aggCompList_zone = egGroupInfo.getAllComponentsUnderZone(strZone,true);
					if(aggCompList_zone != null && !aggCompList_zone.isEmpty())
					{
						Iterator aggCompList_zone_itr = aggCompList_zone.iterator();
						while(aggCompList_zone_itr.hasNext())
						{
							String member = (String) aggCompList_zone_itr.next();
							if(member.startsWith("Agg_"))
							{
								continue;
							}
							aggCompList_zone_itr.remove();
						}
					}
					if(aggCompList_zone == null || aggCompList_zone.isEmpty())
					{
						zoneItr.remove();
					}
					else
					{
						zoneHt.put(strZone,aggCompList_zone);
					}
				}
			}
			if (zoneList != null && !zoneList.isEmpty())
			{
				aListUserOptions = new ArrayList(zoneList);
				for (int i=0;i<aListUserOptions.size();i++)
				{
					String strZone = (String)aListUserOptions.get(i);
					ArrayList thisZoneComps = (ArrayList) zoneHt.get(strZone);
					if(thisZoneComps != null)
					{
						aListComponentsFromZone.addAll(thisZoneComps);
					}
				}
			}

			if (aListComponentsFromZone != null && !aListComponentsFromZone.isEmpty())
			{
				boolean defaultZoneExists = false;
				for (int i=0;i<vecUserAssociatedComponents.size();i++)
				{
					String component = (String)vecUserAssociatedComponents.get(i);
					if (!aListComponentsFromZone.contains(component))
					{
						defaultZoneExists = true;
						break;
					}
				}
				if (defaultZoneExists)
				{
					aListUserOptions.add(0,"--Default--");
				}
			}
			else
			{
				if (vecUserAssociatedComponents != null && !vecUserAssociatedComponents.isEmpty())
				{
					aListUserOptions = new ArrayList();
					aListUserOptions.add("--Default--");
				}
			}

			if (aListUserOptions != null && !aListUserOptions.isEmpty())
			{
				Collections.sort(aListUserOptions,String.CASE_INSENSITIVE_ORDER);
			}
			if (ea_userOption == null && aListUserOptions != null && !aListUserOptions.isEmpty())
			{
				ea_userOption = (String)aListUserOptions.get(0);
			}

			if (ea_userOption != null)
			{
				if (!ea_userOption.equalsIgnoreCase("--Default--"))
				{
					if(zoneHt.containsKey(ea_userOption))
					{
						ArrayList thisZoneComps = (ArrayList) zoneHt.get(ea_userOption);
						if(thisZoneComps != null)
						{
							aListAssociatedComponents = new ArrayList();
							aListAssociatedComponents.addAll(thisZoneComps);
						}
					}
				}
				else
				{
					for (int i=0;i<vecUserAssociatedComponents.size();i++)
					{
						String userComponent = (String)vecUserAssociatedComponents.get(i);
						int index = aListComponentsFromZone.indexOf(userComponent);
						if (index == -1)
						{
							if (aListAssociatedComponents == null)
							{
								aListAssociatedComponents = new ArrayList();
							}
							aListAssociatedComponents.add(userComponent);
						}
					}
				}
			}

			if (aListAssociatedComponents != null && aListAssociatedComponents.size() > 0)
			{
				aListManagedComponents = aListAssociatedComponents;
			}
		}
		else if (ea_criteria.equalsIgnoreCase(criterias[1]))
		{
			List serviceList = new ArrayList();
			serviceList.addAll(user.getServices());
			ArrayList aListSites = new ArrayList();
			aListSites.addAll(user.getSites());
			aListSites.removeAll(serviceList);
			serviceList.addAll(aListSites);
			if (serviceList != null && !serviceList.isEmpty())
			{
				Iterator serviceItr = serviceList.iterator();
				while(serviceItr.hasNext())
				{
					String strService = (String) serviceItr.next();
					Vector aggCompList_service = egTopoInfo.getAssociatesForSite(strService);
					if(aggCompList_service != null && !aggCompList_service.isEmpty())
					{
						Iterator aggCompList_service_itr = aggCompList_service.iterator();
						while(aggCompList_service_itr.hasNext())
						{
							String member = (String) aggCompList_service_itr.next();
							if(member.startsWith("Agg_"))
							{
								continue;
							}
							aggCompList_service_itr.remove();
						}
					}
					if(aggCompList_service == null || aggCompList_service.isEmpty())
					{
						serviceItr.remove();
					}
					else
					{
						serviceHt.put(strService,aggCompList_service);
					}
				}
			}
			
			if (serviceList != null && !serviceList.isEmpty())
			{
				aListUserOptions = new ArrayList(serviceList);
			}

			if (aListUserOptions != null && !aListUserOptions.isEmpty())
			{
				Collections.sort(aListUserOptions,String.CASE_INSENSITIVE_ORDER);
			}
			if (ea_userOption == null && aListUserOptions != null && !aListUserOptions.isEmpty())
			{
				ea_userOption = (String)aListUserOptions.get(0);
			}

			if (ea_userOption != null)
			{
				Vector vecServiceComponents = egTopoInfo.getAssociatesForSite(ea_userOption);
				if (vecServiceComponents != null)
				{
					aListAssociatedComponents = new ArrayList(vecServiceComponents);
				}
			}

			if (aListAssociatedComponents != null && aListAssociatedComponents.size() > 0)
			{
				aListManagedComponents = aListAssociatedComponents;
			}
		}
		else if (ea_criteria.equalsIgnoreCase(criterias[2]))
		{
			List segmentList = user.getSegments();
			if (segmentList != null && !segmentList.isEmpty())
			{
				Iterator segmentItr = segmentList.iterator();
				while(segmentItr.hasNext())
				{
					String strSegment = (String) segmentItr.next();
					Vector aggCompList_segment = egTopoInfo.getAssociatesForSegment(strSegment,2);
					if(aggCompList_segment != null && !aggCompList_segment.isEmpty())
					{
						Iterator aggCompList_segment_itr = aggCompList_segment.iterator();
						while(aggCompList_segment_itr.hasNext())
						{
							String member = (String) aggCompList_segment_itr.next();
							if(member.startsWith("Agg_"))
							{
								continue;
							}
							aggCompList_segment_itr.remove();
						}
					}
					if(aggCompList_segment == null || aggCompList_segment.isEmpty())
					{
						segmentItr.remove();
					}
					else
					{
						segmentHt.put(strSegment,aggCompList_segment);
					}
				}
			}
			if (segmentList != null && !segmentList.isEmpty())
			{
				aListUserOptions = new ArrayList(segmentList);
			}

			if (aListUserOptions != null && !aListUserOptions.isEmpty())
			{
				Collections.sort(aListUserOptions,String.CASE_INSENSITIVE_ORDER);
			}
			if (ea_userOption == null && aListUserOptions != null && !aListUserOptions.isEmpty())
			{
				ea_userOption = (String)aListUserOptions.get(0);
			}

			if (ea_userOption != null)
			{
				Vector vecSegmentComponents = egTopoInfo.getAssociatesForSegment(ea_userOption,2);
				if (vecSegmentComponents != null)
				{
					aListAssociatedComponents = new ArrayList(vecSegmentComponents);
				}
			}

			if (aListAssociatedComponents != null && aListAssociatedComponents.size() > 0)
			{
				aListManagedComponents = aListAssociatedComponents;
			}
		}
		else if (ea_criteria.equalsIgnoreCase(criterias[3]))
		{
			aListManagedComponents = new ArrayList(listManagedComponents);
		}
		
		if(aListManagedComponents != null && aListManagedComponents.size()>0)
		{
			for(int a=0;a<aListManagedComponents.size();a++)
			{
				String str = (String)aListManagedComponents.get(a);
				if(!str.startsWith("Agg_"))
				{
					aListManagedComponents.remove(str);
				}
			}
		}

		TreeMap tmapTempComponents = new TreeMap();
		ArrayList aListTempComponentTypes = new ArrayList();
		if (aListManagedComponents != null)
		{
			int compSize = aListManagedComponents.size();
			for (int i=0;i<compSize;i++)
			{
				String pattern = (String)aListManagedComponents.get(i);
				int tempColonIdx = pattern.indexOf(":");
				String tempCompType = pattern.substring(0,tempColonIdx);
				String tempComponent = pattern.substring(tempColonIdx+1);
				ArrayList aListTemp = (ArrayList)tmapTempComponents.get(tempCompType);
				if (aListTemp == null)
				{
					aListTemp = new ArrayList();
					aListTemp.add(tempComponent);
					tmapTempComponents.put(tempCompType,aListTemp);
					aListTempComponentTypes.add(tempCompType);
				}
				else
				{
					aListTemp.add(tempComponent);
				}
			}
		}

		if (aListManagedComponents != null)
		{
			egInfrastructure = new EgInfrastructure(aListManagedComponents);
			tmapComponents = egInfrastructure.getComponents();
			tmapComponentsCount = egInfrastructure.getComponentsCount();
			tmapItInfrastructureCount = egInfrastructure.getItInfrastructureDisplayOrder();
			tmapItInfrastructureClassificationCount = egInfrastructure.getItInfrastructureClassificationCount();
			if (viewAs.equalsIgnoreCase("componentTypeWise"))
			{
				showcomponentTypeWise = true;
			}
			else if(viewAs.equalsIgnoreCase("componentNameWise"))
			{
				showcomponentNameWise = true;
			}
			else
			{
				showHorizontal = true;
			}
		}
	}

	EgDbInfo dbInfo = new EgDbInfo("manager");
	String fontStyle = "";
	if (dbInfo.doubleByteEnabled || !userLanguage.equals("en_US"))
	{
		fontStyle = "multi_font";
	}

	String logo=iniUI.getMonitorHomeLogo();
	if(iniUI.isHKTThemeEnabled())
	{
		logo = iniUI.getHKTReporterLogo();
	}
%>
<body  style="padding:10px;background-color:#ffffff">
<form action='aggComponentDetailsPrint.jsp' style="margin:0px">
<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center">
	<tr>
		<td>
			<table cellpadding="0" cellspacing="0" border="0" width="100%" align="center">
				<tr>
					<td style="padding:5px 10px 10px 10px"><img src='<%=logo%>' border="0" /></td>
				</tr>
			</table>
			<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center"  style="border-bottom:1px solid #999;">
				<tr>
					<td style="padding:2px">
						<div style="float:left" > <header><egui:intnl text="admin.infrastructure.COMPONENT DETAILS REPORT"/> </header></div>
<%
	if (print!=null && print.equalsIgnoreCase("printpage"))
	{
%>
						<div style="float:right"><img class="iconPrinter mouse" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" border="0" onClick="javascript:printData()" alt='<egui:intnl text="reporter.common.PRINT"/>' title='<egui:intnl text="reporter.common.PRINT"/>'/></div>
<%
	}
%>
					</td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td>
			<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center" style="border-bottom:1px solid #ccc;">
				<tr>
					<td class="formLabel" width="100%" align="center">&nbsp;<egui:intnl text="admin.infrastructure.Total managed aggregate components"/>&nbsp;:&nbsp;<span class="formValue"><%=aListManagedComponents.size()%></span></td>
				</tr>
			</table>
		</td>
	</tr>
</table>

<%
	if (aListManagedComponents != null && !aListManagedComponents.isEmpty())
	{
		if (showHorizontal)
		{
%>
<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center"  style="border-bottom:1px solid #ccc;">
	<tr>
		<td class="formLabel" align="center"><egui:intnl text="admin.infrastructure.Category and Component Types"/></td>
	</tr>
</table><br/>
<%
			Iterator itrItInfrastructureCount = tmapItInfrastructureCount.keySet().iterator();
			while (itrItInfrastructureCount.hasNext())
			{
				Integer intCountObj = (Integer)itrItInfrastructureCount.next();
				ArrayList aListServerCategory = (ArrayList)tmapItInfrastructureCount.get(intCountObj);
				for (int z=0;z<aListServerCategory.size();z++)
				{
					String strServerCategory = (String)aListServerCategory.get(z);
					TreeMap tmapClassification = (TreeMap)tmapItInfrastructureClassificationCount.get(strServerCategory);
					Iterator itrClassification = tmapClassification.keySet().iterator();
					ArrayList aListResultantServers = new ArrayList();
					while (itrClassification.hasNext())
					{
						Integer intCountObj1 = (Integer)itrClassification.next();
						String strCountObj1 = intCountObj1.toString();
						ArrayList aListServers = (ArrayList)tmapClassification.get(intCountObj1);
						for (int k=0;k<aListServers.size();k++)
						{
							String strServer = (String)aListServers.get(k);
							aListResultantServers.add(strServer + "#" + strCountObj1);
						}
					}
					String displayName = _mapping.getTextDescription("admin.category."+strServerCategory) + " " + _mapping.getTextDescription("admin.common.AGGREGATES");
%>
<table align="center" border="0" width="100%" class="printTable" cellpadding="0" cellspacing="0"><col width="33%"><col width="33%"><col width="33%">
	<tr>
		<td width="100%" align="left"  class="printTableHeader2" colspan="3"><%=displayName%>&nbsp;&nbsp;(<%=intCountObj%>)</td>
	</tr>
<%
					for (int i=0;i<aListResultantServers.size();i=i+3)
					{
%>
	<tr>
<%
						for (int j=i;j<i+3;j++)
						{
							if (j < aListResultantServers.size())
							{
								String strDetail = (String)aListResultantServers.get(j);
								int hashIdx = strDetail.indexOf("#");
								String strServer = strDetail.substring(0,hashIdx);
								String strCount = strDetail.substring(hashIdx+1);
%>
		<td width="33%"><%=_mapping.getComponentTypeDescription(strServer)%>&nbsp;&nbsp;(<%=strCount%>)</td>
<%
							}
							else
							{
%>
		<td width="33%">&nbsp;</td>
<%
							}
						}
%>
	</tr>
<%
					}
%>
</table><br/>
<%
				}
			}
		}
		else
		{
%>
<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center"  style="border-bottom:1px solid #ccc;">
	<tr>
		<td class="formLabel" align="center">
<%
			if (showcomponentNameWise)
			{
%>
			<egui:intnl text="admin.infrastructure.Managed aggregate component details"/>
<%
			}
			else
			{
%>
			<egui:intnl text="admin.infrastructure.Aggregate Component types and Aggregate Components"/>
<%
			}
%>
		</td>
	</tr>
</table><br/>
<%
			if (showcomponentNameWise)
			{
%>
<table align="center" border="0" cellpadding="0" cellspacing="0" width="100%" style="table-layout:fixed" class="printTable">
	<thead>
	<tr>
		<td class="printTableHeader" nowrap style="width:160px;"><egui:intnl text="admin.infrastructure.Nick name"/></td>
		<td class="printTableHeader" nowrap style="width:160px;"><egui:intnl text="admin.infrastructure.Component type"/></td>
	</thead>
	<tbody>
<%
				TreeMap tempAllManagedComp = new TreeMap();
				Hashtable portNType = new Hashtable();
				String serverType = "";
				List serverTypes = null;
				if (aListManagedComponents != null)
				{
					int compSize = aListManagedComponents.size();
					for (int i=0;i<compSize;i++)
					{
						String pattern = (String)aListManagedComponents.get(i);
						int tempColonIdx = pattern.indexOf(":");
						String tempCompType = pattern.substring(0,tempColonIdx);
						String tempComponent = pattern.substring(tempColonIdx+1);
						String tempCompwithoutPort = tempComponent.substring(0,tempComponent.indexOf(":"));
						serverTypes = discInfo.getServerTypesForNick(tempCompwithoutPort);
						if (serverTypes != null && serverTypes.size() > 0)
						{
							portNType = new Hashtable();
							Iterator itrServerTypes = serverTypes.iterator();
							while (itrServerTypes.hasNext())
							{
								serverType = (String)itrServerTypes.next();
								List portList = discInfo.getPort(serverType,tempCompwithoutPort);
								for(int j=0;j<portList.size();j++)
								{
									String tempPort = (String) portList.get(j);
									String serverTypeAndPort = serverType+"#"+tempPort;
									String compTypeAndNick = serverType+":"+tempCompwithoutPort+":"+tempPort;
									if(aListManagedComponents.contains(compTypeAndNick))
									{
										portNType.put(serverTypeAndPort,serverTypeAndPort);
									}
								}
							}
						}
						tempAllManagedComp.put(tempCompwithoutPort,portNType);
					}
				}
				Iterator iterAll = tempAllManagedComp.keySet().iterator();
				ArrayList nickNameList = new ArrayList();
				while(iterAll.hasNext())
				{
					String tempKeys = (String) iterAll.next();
					if(!allCompFields.containsKey(tempKeys))
					{
						continue;
					}
					else
					{
						nickNameList.add(tempKeys);
					}
				}
				Collections.sort(nickNameList,String.CASE_INSENSITIVE_ORDER);
				Iterator itrNickName = nickNameList.iterator();
				String [] agentDetails = {"Agent IP/Nickname","AutoUpgrade","LastUpgradedPackage","LastUpgradedTime","HostName","OS","Version","JRE Version","StartupTime","Debug Mode"};
				if(sortDataBy!=null && sortDataBy.equalsIgnoreCase("Nick name"))
				{
					while (itrNickName.hasNext())
					{
						String s_nick = (String) itrNickName.next();
						Hashtable ht_agentDetails = new Hashtable();
						Hashtable ht_IpValueDetails = new Hashtable();
						ht_IpValueDetails = discInfo.getNickIpMap();
						String allDataForAgent = agentConfig.getAgentDetails(s_nick);
						String s_hostIporName = (String) ht_IpValueDetails.get(s_nick);
						if(s_hostIporName.equalsIgnoreCase("0.0.0.0"))
						{
							s_hostIporName = "-";
						}
						if(allDataForAgent != null && !allDataForAgent.equals("") && !allDataForAgent.equalsIgnoreCase("None"))
						{
							StringTokenizer st = new StringTokenizer(allDataForAgent, ",");
							int count = 1;
							while(st.hasMoreTokens())
							{
								ht_agentDetails.put(agentDetails[count++], st.nextToken());
							}
						}

						Hashtable h_portNType = (Hashtable) allCompFields.get(s_nick);
						Hashtable h_allData = (Hashtable) tempAllManagedComp.get(s_nick);

						Hashtable tempHashtable = new Hashtable();
						String hostName = "-";
						String OSname = "-";

						if(ht_agentDetails != null && ht_agentDetails.size() > 0)
						{
							hostName = (String)ht_agentDetails.get("HostName");
							OSname = (String)ht_agentDetails.get("OS");
						}
						int allCompFieldSize = h_portNType.size();
						int allDataSize = h_allData.size();
						if(allCompFieldSize != allDataSize)
						{
							Iterator itrHashPortNType = h_portNType.keySet().iterator();
							while(itrHashPortNType.hasNext())
							{
								String tempKey = (String) itrHashPortNType.next();
								String tempVal = (String) h_portNType.get(tempKey);
								if(h_allData.containsValue(tempKey))
								{
									tempHashtable.put(tempKey,tempVal);
								}
							}
							h_portNType = new Hashtable(tempHashtable);
						}
						Iterator itrForPortNType = h_portNType.keySet().iterator();
						allCompFieldSize = h_portNType.size();
						if (allCompFieldSize == 1)
						{
							String s_compType = (String) itrForPortNType.next();
							String s_port = "";
							String s_sid = "-";
							String compType = s_compType.substring(0,s_compType.indexOf("#"));
							compType = _mapping.getComponentTypeDescription(compType);
							String s_val = (String) h_portNType.get(s_compType);
							String s_ip = s_val.substring(0,s_val.indexOf("#"));
							if(s_val.indexOf(":") !=-1)
							{
								s_port = s_val.substring(s_val.indexOf("#")+1,s_val.indexOf(":"));
								s_sid = s_val.substring(s_val.indexOf(":")+1);
							}
							else
							{
								s_port = s_val.substring(s_val.indexOf("#")+1);
							}
							if (s_port.equalsIgnoreCase("NULL"))
								s_port = "-";
%>
	<tr>
		<td><%=s_nick = StringUtils.split(s_nick,40)%></td>
		<td><%=compType%></td>
	</tr>
<%
						}
						else
						{
							boolean s_nickMultiple = false;
							int multiVal = 0;
							int multiHashVal = h_portNType.size();
							while (itrForPortNType.hasNext())
							{
								multiVal++;
								String s_compType = (String) itrForPortNType.next();
								String s_port = "";
								String s_sid = "-";
								String compType = s_compType.substring(0,s_compType.indexOf("#"));
								compType = _mapping.getComponentTypeDescription(compType);
								String s_val = (String) h_portNType.get(s_compType);
								String s_ip = s_val.substring(0,s_val.indexOf("#"));
								if(s_val.indexOf(":") !=-1)
								{
									s_port = s_val.substring(s_val.indexOf("#")+1,s_val.indexOf(":"));
									s_sid = s_val.substring(s_val.indexOf(":")+1);
								}
								else
								{
									s_port = s_val.substring(s_val.indexOf("#")+1);
								}
								if (s_port.equalsIgnoreCase("NULL"))
								{
									s_port = "-";
								}
%>
	<tr>
<%
								if(!s_nickMultiple)
								{
									s_nickMultiple = true;
%>
		<td ><%=s_nick = StringUtils.split(s_nick,40)%></td>
<%
								}
								else
								{
									if(multiVal != multiHashVal)
									{
%>
		<td>&nbsp;</td>
		<td>&nbsp;</td>
		<td>&nbsp;</td>
		<td>&nbsp;</td>
<%
									}
									else
									{
%>
		<td>&nbsp;</td>
		<td>&nbsp;</td>
		<td>&nbsp;</td>
		<td>&nbsp;</td>
<%
									}
								}
%>
		<td align="left"><%=compType%></td>
<%
							}
%>
	</tr>
<%
						}
					}
				}
				else if(sortDataBy!=null && sortDataBy.equalsIgnoreCase("Component type"))
				{
					Vector v_components = discInfo.getAllManagedComponents();
					StringTokenizer st_token= null;
					ArrayList sortCtypeAllData = new ArrayList();
					ArrayList sortCompType = new ArrayList();
					for(int i=0;i < v_components.size();i++)
					{
						String vecComp = v_components.elementAt(i).toString();
						StringTokenizer srtTempCompType = new StringTokenizer(vecComp,",");
						sortCompType.add(srtTempCompType.nextToken());
					}
					sortCompType = sorter.getSortedCompTypeList(sortCompType);
					int len = sortCompType.size();
					for(int i=0;i < v_components.size();i++)
					{
						String allData = "";
						String host = null;
						String s_component = null;
						String srtTempDis = "";
						Hashtable ht_agentDetails = new Hashtable();
						Hashtable ht_IpValueDetails = new Hashtable();

						s_component= v_components.elementAt(i).toString();
						st_token = new StringTokenizer(s_component,",");
						int count=st_token.countTokens();
						String sid ="-";
						if (count >=4)
						{
							String ctype = st_token.nextToken();
							String tComp = _mapping.getComponentTypeDescription(ctype);
							String ip = st_token.nextToken();
							host = st_token.nextToken();
							for(int k=0;k<len;k++)
							{
								EgName nameObj = (EgName)sortCompType .get(k);
								String tmpVal = nameObj.getActualName();	
								String tmpDis = nameObj.getLocalName();
								if(tmpDis.equalsIgnoreCase(tComp))
								{
									srtTempDis = tmpDis;
									break;
								}
								else 
								{
									continue;
								}
							}
							String port = st_token.nextToken();
							if (count == 5)
							{
								sid = st_token.nextToken();
							}
							String localVar="";
							if(!sid.equalsIgnoreCase("-"))
							{
								localVar = ctype+":"+host+":"+port+":"+sid;
							}
							else
							{
								localVar = ctype+":"+host+":"+port;
							}
							if(aListManagedComponents != null)
							{
								for(int al=0;al<aListManagedComponents.size();al++)
								{
									if(aListManagedComponents.contains(localVar))
									{
										ht_IpValueDetails = discInfo.getNickIpMap();
										String allDataForAgent = agentConfig.getAgentDetails(host);
										if(allDataForAgent != null && !allDataForAgent.equals("") && !allDataForAgent.equalsIgnoreCase("None"))
										{
											StringTokenizer st = new StringTokenizer(allDataForAgent, ",");
											int cnt = 1;
											while(st.hasMoreTokens())
											{
												ht_agentDetails.put(agentDetails[cnt++], st.nextToken());
											}
										}
										String hostName = "-";
										String OSname = "-";

										if(ht_agentDetails != null && ht_agentDetails.size() > 0)
										{
											hostName = (String)ht_agentDetails.get("HostName");
											OSname = (String)ht_agentDetails.get("OS");
										}
										allData = srtTempDis+"#"+host+"#"+ip+"#"+port+"#"+sid+"#"+hostName+"#"+OSname;
										sortCtypeAllData.add(allData);
										break;

									}
									else
									{
										continue;
									}
								}
							}
						}
					}
					Collections.sort(sortCtypeAllData,String.CASE_INSENSITIVE_ORDER);
					StringTokenizer st = null;
					for(int data=0;data<sortCtypeAllData.size();data++)
					{
						String dispData = (String) sortCtypeAllData.get(data);
						st = new StringTokenizer(dispData,"#");
						String s_type = st.nextToken();
						String s_nickName = st.nextToken();
						String s_ip = st.nextToken();
						String s_port = st.nextToken();
						String s_sid = st.nextToken();
						String s_hostName = st.nextToken();
						String s_Osname = st.nextToken();
						if(s_ip.equalsIgnoreCase("0.0.0.0"))
						{
							s_ip = "-";
						}
						if(s_port.equalsIgnoreCase("NULL"))
						{
							s_port = "-";
						}
%>
	<tr>
		<td><%=s_nickName = StringUtils.split(s_nickName,40)%></td>
		<td><%=s_type%></td>
	</tr>
<%
					}
				}
				else if(sortDataBy!=null && sortDataBy.equalsIgnoreCase("Operating system"))
				{
					Vector v_components = discInfo.getAllManagedComponents();
					StringTokenizer st_token= null;
					ArrayList sortOsAllData = new ArrayList();
					ArrayList sortCompType = new ArrayList();
					for(int i=0;i < v_components.size();i++)
					{
						String vecComp = v_components.elementAt(i).toString();
						StringTokenizer srtTempCompType = new StringTokenizer(vecComp,",");
						sortCompType.add(srtTempCompType.nextToken());
					}
					sortCompType = sorter.getSortedCompTypeList(sortCompType);
					int len = sortCompType.size();
					for(int i=0;i < v_components.size();i++)
					{
						String allData = "";
						String host = null;
						String s_component = null;
						String srtTempDis = "";
						Hashtable ht_agentDetails = new Hashtable();
						Hashtable ht_IpValueDetails = new Hashtable();
						s_component= v_components.elementAt(i).toString();
						st_token = new StringTokenizer(s_component,",");
						int count=st_token.countTokens();
						String sid ="-";
						if (count >=4)
						{
							String ctype = st_token.nextToken();
							String tComp = _mapping.getComponentTypeDescription(ctype);
							String ip = st_token.nextToken();
							host = st_token.nextToken();
							for(int k=0;k<len;k++)
							{
								EgName nameObj = (EgName)sortCompType .get(k);
								String tmpVal = nameObj.getActualName();	
								String tmpDis = nameObj.getLocalName();
								if(tmpDis.equalsIgnoreCase(tComp))
								{
									srtTempDis = tmpDis;
									break;
								}
								else 
								{
									continue;
								}
							}
							String port = st_token.nextToken();
							if (count == 5)
							{
								sid = st_token.nextToken();
							}
							String localVar="";
							if(!sid.equalsIgnoreCase("-"))
							{
								localVar = ctype+":"+host+":"+port+":"+sid;
							}
							else
							{
								localVar = ctype+":"+host+":"+port;
							}
							if(aListManagedComponents != null)
							{
								for(int al=0;al<aListManagedComponents.size();al++)
								{
									if(aListManagedComponents.contains(localVar))
									{
										ht_IpValueDetails = discInfo.getNickIpMap();
										String allDataForAgent = agentConfig.getAgentDetails(host);
										String s_hostIporName = (String) ht_IpValueDetails.get(host);
										if(allDataForAgent != null && !allDataForAgent.equals("") && !allDataForAgent.equalsIgnoreCase("None"))
										{
											StringTokenizer st = new StringTokenizer(allDataForAgent, ",");
											int cnt = 1;
											while(st.hasMoreTokens())
											{
												ht_agentDetails.put(agentDetails[cnt++], st.nextToken());
											}
										}
										String hostName = "-";
										String OSname = "-";

										if(ht_agentDetails != null && ht_agentDetails.size() > 0)
										{
											hostName = (String)ht_agentDetails.get("HostName");
											OSname = (String)ht_agentDetails.get("OS");
										}
										allData = OSname+"#"+hostName+"#"+srtTempDis+"#"+host+"#"+ip+"#"+port+"#"+sid;
										sortOsAllData.add(allData);
										break;
									}
									else
									{
										continue;
									}
								}
							}
						}
					}
					Collections.sort(sortOsAllData,String.CASE_INSENSITIVE_ORDER);
					StringTokenizer st = null;
					for(int data=0;data<sortOsAllData.size();data++)
					{
						String dispData = (String) sortOsAllData.get(data);
						st = new StringTokenizer(dispData,"#");
						String s_Osname = st.nextToken();
						String s_hostName = st.nextToken();
						String s_type = st.nextToken();
						String s_nickName = st.nextToken();
						String s_ip = st.nextToken();
						String s_port = st.nextToken();
						String s_sid = st.nextToken();
						if(s_ip.equalsIgnoreCase("0.0.0.0"))
						{
							s_ip = "-";
						}
						if(s_port.equalsIgnoreCase("NULL"))
						{
							s_port = "-";
						}
%>
	<tr>
		<td><%=s_nickName = StringUtils.split(s_nickName,40)%></td>
		<td><%=s_type%></td>
	</tr>
<%
					}
				}
%>
	</tbody>
</table><br/>
<%
			}
			else
			{
				Iterator itrComponentsCount = tmapComponentsCount.keySet().iterator();
				while (itrComponentsCount.hasNext())
				{
					Integer intCountObj = (Integer)itrComponentsCount.next();
					ArrayList aListComponentTypes = (ArrayList)tmapComponentsCount.get(intCountObj);
					aListComponentTypes = sorter.getSortedCompTypeList(aListComponentTypes);
					for (int i=0;i<aListComponentTypes.size();i++)
					{
						EgName nameObj = (EgName)aListComponentTypes.get(i);
						String strCompType = nameObj.getActualName();
						String strCompTypeDisplayName = nameObj.getLocalName();
						ArrayList aListComponents = (ArrayList)tmapComponents.get(strCompType);
						boolean isOracleServer = false;
						if (strCompType.equals("Oracle_server"))
						{
							isOracleServer = true;
						}
%>
<table align="center" border="0" width="100%" class="printTable" cellpadding="0" cellspacing="0"><col width="33%"><col width="33%"><col width="33%">
	<tr>
		<td width="100%" align="left"  class="printTableHeader2" colspan="3"><%=strCompTypeDisplayName%>&nbsp;&nbsp;(<%=intCountObj.intValue()%>)</td>
	</tr>
<%
						for (int j=0;j<aListComponents.size();j=j+3)
						{
%>
	<tr>
<%
							for (int k=j;k<j+3;k++)
							{
								if (k < aListComponents.size())
								{
									String strComponent = (String)aListComponents.get(k);
									String strCompDisplay = null;
									if (strComponent.indexOf(":NULL") > -1)
									{
										strCompDisplay = strComponent.substring(0,strComponent.indexOf(":NULL"));
									}
									else
									{
										strCompDisplay = strComponent;
									}

									if (isOracleServer)
									{
										strComponent = strComponent.substring(0,strComponent.lastIndexOf(":"));
									}
										
%>
		<td valign="top" style="width:250px;"><%=strCompDisplay = StringUtils.split(strCompDisplay,40)%></td>
<%
								}
								else
								{
%>
		<td valign="top" style="width:250px;">&nbsp;</td>
<%
								}
							}
%>
	</tr>
<%
						}
%>
</table><br/>
<%
					}
				}
			}
		}
	}
%>
</form>
</body>
</html>



