<%
/*******************************************************************************
*   Name                        :   egPrintMaintenanceAnalysisData.jsp
*   Purpose                 :   print page for Maintenance Analysis
*   Version                     :   4.3
*   Created                 :   15.09.2008
*   Author                      :   Antony & Team
*   Design Changes  :   Jaiwin
*******************************************************************************/
%>
<%@ taglib prefix = "egui" uri = "../WEB-INF/eg-taglib.tld"%>
<%@ include file = "EgTrackerA.jsp" %>
<%@ page import = "com.egurkha.admin.*" %>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.pdfmaker.*"%>
<%@ page import="com.eg.* "%>
<%@ page import = "egurkha.reporter.ErUtils" %>
<%@ page import = "java.util.*" %>
<%@ page import="java.text.SimpleDateFormat"%>
<%@ page import = "com.eg.EgRoleInfo"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import="com.eg.EgDbInfo"%>
<%@ page import="com.egurkha.User"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%  
try
{
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	IniUI iniUI = IniUI .getInstance();
    //String homepageLogo=iniUI.getMonitorHomeLogo().trim();
	String homepageLogo=iniUI.getMonitorHomeLogo();
	String  option=request.getParameter("option");
	String element=request.getParameter("element");
	String testElement=request.getParameter("testElement");
	String descElement=request.getParameter("descElement");
	String day=request.getParameter("day");
	String startDate=request.getParameter("startDate");
	String startHr=request.getParameter("startHr");
	String endDate=request.getParameter("endDate");
	String endHr=request.getParameter("endHr");
	String timePeriod=request.getParameter("timePeriod");
	String compName="";
	if(session.getAttribute("paramForAnalysis")!=null) 
	{
		session.removeAttribute("paramForAnalysis");
	}
	String tmp=(String)request.getQueryString();
	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");
	String htmlFileName =mngrIProc+"/final/admin/getAnalysisData.jsp;jsessionid="+session.getId()+"?"+tmp+"&print=pdfpage";
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	EgMaintenanceUtility egM=new EgMaintenanceUtility();
	//session.setAttribute("PDF_URL",htmlFileName);
	session.setAttribute("REPORT_NAME","Maintenance_policy");
	//session.setAttribute("paramForAnalysis",tmp);
	session.setAttribute("paramforTab",request.getQueryString());
	String query="option="+option+"&element="+element+"&testElement="+testElement;
	Hashtable  hostsUnderMaintenance=new Hashtable();
	Hashtable  componentsUnderMaintenance=new Hashtable();
	Hashtable  testsUnderMaintenance=new Hashtable();
	Hashtable  hostTestsUnderMaintenance=new Hashtable();
	Hashtable  componentTestsUnderMaintenance=new Hashtable();
	//*******for Descriptor and descriptors for component*********
	Hashtable descriptorUnderMaintenance=new Hashtable();
	Hashtable componentDescriptorUnderMaintenance=new Hashtable();
	//************************************************************
	Hashtable  analysisData=new Hashtable();
	Hashtable tmp_analysisData = new Hashtable();
	String dispTitle="";
	String columnName="";
	Vector data=null;
	boolean isData=false;
		int dataSize=0;
	String userID = _user.getLoginID();
	EgRoleInfo roleInfo = EgRoleInfo.getInstance(sessionID,userID);
	String elementDisplay = element; // Limited admin
	elementDisplay = egM.getPolicyDisplayName(elementDisplay,!roleInfo.hasAllComponentAccess());
	
	if(option!=null && option.equals("All")) 
	{
		hostsUnderMaintenance=egM.getAllHostsUnderMaintenance();
		componentsUnderMaintenance=egM.getAllComponentsUnderMaintenance();
		testsUnderMaintenance=egM.getAllTestsUnderMaintenance();
		hostTestsUnderMaintenance=egM.getAllHostTestsUnderMaintenance();
		componentTestsUnderMaintenance=egM.getAllComponentTestsUnderMaintenance();

		/*****************************************/
		descriptorUnderMaintenance=egM.getAllDescriptorsUnderMaintenance();
		componentDescriptorUnderMaintenance=egM.getAllComponentDescriptorsUnderMaintenance();
		/*****************************************/
		data=new Vector();
		data.add(hostsUnderMaintenance);
		data.add(componentsUnderMaintenance);
		data.add(testsUnderMaintenance);
		data.add(hostTestsUnderMaintenance);
		data.add(componentTestsUnderMaintenance);
		/*******************************************/
		data.add(descriptorUnderMaintenance);
		data.add(componentDescriptorUnderMaintenance);
		/*******************************************/
		if(hostsUnderMaintenance.size()>0 || componentsUnderMaintenance.size()>0 || testsUnderMaintenance.size()>0 || hostTestsUnderMaintenance.size()>0 || componentTestsUnderMaintenance.size()>0 || descriptorUnderMaintenance.size()>0 || componentDescriptorUnderMaintenance.size()>0)
			isData=true;
	}
	else if(option!=null && option.equals("Component")) 
	{
		if(element!=null && element.equals("All Components"))
		{
			analysisData=egM.getAllComponentsUnderMaintenance();
		}
		else 
		{
			analysisData=egM.getMaintenanceInfoForElement(element);
		}
		dispTitle="Components Under Maintenance";
		columnName="Component Name";
	} 
	else if(option!=null && option.equals("Host")) 
	{
		if(element!=null && element.equals("All Hosts"))
			analysisData=egM.getAllHostsUnderMaintenance();
		else
			analysisData=egM.getMaintenanceInfoForElement(element);
		dispTitle="Hosts Under Maintenance";
		columnName="Host Name";
	}
	else if(option!=null && option.equals("Test")) 
	{
		if(element!=null && element.equals("All Tests"))
			analysisData=egM.getAllTestsUnderMaintenance();
		else
			analysisData=egM.getMaintenanceInfoForElement("#"+element);
		dispTitle="Tests Under Maintenance";
		columnName="Test Name";
	}
	else if(option!=null && option.equals("Test For Host")) 
	{
		if(element!=null && element.equals("All Tests"))
			analysisData=egM.getAllHostTestsUnderMaintenance();
		else
		{
			analysisData=egM.getMaintenanceInfoForElement(testElement,element);
		}
		dispTitle="Host Tests Under Maintenance";
		columnName="Test Name";
	}
	else if(option!=null && option.equals("Test  For Component")) 
	{
		if(element!=null && element.equals("All Tests"))
		{
			analysisData=egM.getAllComponentTestsUnderMaintenance();
		}
		else
		{
			if(testElement!=null && testElement.indexOf(":")==-1)
			{
				testElement=testElement+":NULL";
			}
			analysisData=egM.getMaintenanceInfoForElement(testElement,element);
		}
		dispTitle="Component Tests Under Maintenance";
		columnName="Test Name";
	}
	else if(option!=null && option.equals("Policy")) 
	{
		hostsUnderMaintenance=egM.getAllHostsUnderMaintenanceForPolicy(element);
		componentsUnderMaintenance=egM.getAllComponentsUnderMaintenanceForPolicy(element);
		testsUnderMaintenance=egM.getAllTestsUnderMaintenanceForPolicy(element);
		hostTestsUnderMaintenance=egM.getAllHostTestsUnderMaintenanceForPolicy(element);
		componentTestsUnderMaintenance=egM.getAllComponentTestsUnderMaintenanceForPolicy(element);
		descriptorUnderMaintenance=egM.getAllDescriptorsUnderMaintenanceForPolicy(element);
		componentDescriptorUnderMaintenance=egM.getAllDescriptorForComponentUnderMaintenanceForPolicy(element);
		data=new Vector();
		data.add(hostsUnderMaintenance);
		data.add(componentsUnderMaintenance);
		data.add(testsUnderMaintenance);
		data.add(hostTestsUnderMaintenance);
		data.add(componentTestsUnderMaintenance);
		data.add(descriptorUnderMaintenance);
		data.add(componentDescriptorUnderMaintenance);
			
		if(hostsUnderMaintenance.size()>0 || componentsUnderMaintenance.size()>0 || testsUnderMaintenance.size()>0 || hostTestsUnderMaintenance.size()>0 || componentTestsUnderMaintenance.size()>0 || descriptorUnderMaintenance.size()>0 || componentDescriptorUnderMaintenance.size()>0)
			isData=true;
	}
	else    if(option!=null && option.equals("Time Constraints")) 
	{
		data=new Vector();
		if(element!=null&& element.equals("FDM")) 
		{
			data=egM.getMaintenanceDetailsForFDM();
		}
		else if(element!=null&& element.equals("LDM")) 
		{
			data=egM.getMaintenanceDetailsForLDM();
		}
		else if(element!=null&& element.equals("*")) 
		{
			data=egM.getMaintenanceDetailsForDaily();
		}
		else if(element!=null&& element.equals("Day of Week")) 
		{
			data=egM.getMaintenanceDetailsForDay(day);
		}
		else if(element!=null&& element.equals("Date")) 
		{
			data=egM.getMaintenanceDetailsForTimePeriod(startDate,startHr,endDate,endHr);
		}
		if(data!=null && data.size()>0)
			isData=true;
	}
	else if(option!=null && option.equals("Descriptor"))
	{
		if(element!=null && element.equals("All Descriptors"))
		{
			analysisData=egM.getAllDescriptorsUnderMaintenance();
		}
		else
		{
			analysisData=egM.getMaintenanceInfoForElement("#"+element);
		}
		dispTitle="Descriptors Under Maintenance";
		columnName="Descriptors";
	}
	else if(option!=null && option.equals("Descriptor For Component"))
	{
		if(element!=null && element.equals("All Descriptor Comp"))
		{
			analysisData=egM.getAllComponentDescriptorsUnderMaintenance();
		}
		else
		{
			analysisData=egM.getMaintenanceInfoForElementDesc(element,descElement);
		}
		dispTitle="Descriptor For Component Under Maintenance";
		columnName="Descriptors";
	}
	EgDbInfo dbInfo = new EgDbInfo("manager");
	String fontStyleDblSingl="";
	if((dbInfo.doubleByteEnabled))
	{
		fontStyleDblSingl = "multi_font";
	}
	else
	{
		fontStyleDblSingl = "";
	}
%>
<html>
	<head>
		<title>Maintenance Analysis</title>
		<egui:skin ui="admin"/>
	<script>
function printData()
{
	window.print();
}
	</script>
	</head>
	<body style="margin:10px">

<%
		Hashtable HostData=new Hashtable();
		Hashtable CompData=new Hashtable();
		Hashtable TestData=new Hashtable();
		Hashtable HostTestData=new Hashtable();
		Hashtable CompTestData=new Hashtable();
		/**************************************/
		Hashtable descriptorData=new Hashtable();
		Hashtable compDescData=new Hashtable();
		/**************************************/
		int noOfElemenstAssociated=0;
		String sumelement="";
		if(element!=null && option.equals("Time Constraints") && element.equalsIgnoreCase("fdm"))
		{
			sumelement="First Day of the Month";
		}
		else if(element!=null && option.equals("Time Constraints") && element.equalsIgnoreCase("ldm"))
		{
			sumelement="Last Day of the Month";
		}
		else if(element!=null && option.equals("Time Constraints") && element.equalsIgnoreCase("*"))
		{
			sumelement="Daily";
		}
		else if(element!=null && option.equals("Time Constraints") && element.equalsIgnoreCase("date"))
		{
			startDate=StringUtils.replace(startDate,',',' ');
			endDate=StringUtils.replace(endDate,',',' ');
			sumelement="From " +startDate+" To "+ endDate;
		}
		else if(element!=null && option.equals("Time Constraints") && element.equalsIgnoreCase("day of week"))
		{
			sumelement=egM.DayForDescription(day);
		}
		else
		{
			sumelement=elementDisplay;
		}


		String elementForTitle=sumelement;
		if(data!=null && data.size()>0) 
		{
			HostData=(Hashtable)data.get(0);
			CompData=(Hashtable)data.get(1);
			TestData=(Hashtable)data.get(2);
			HostTestData=(Hashtable)data.get(3);
			CompTestData=(Hashtable)data.get(4);
			/********************************/
			descriptorData=(Hashtable)data.get(5);
			compDescData=(Hashtable)data.get(6);
			/********************************/

			if(HostData!=null && HostData.size()>0)
				noOfElemenstAssociated++;

			if(CompData!=null && CompData.size()>0)
				noOfElemenstAssociated++;

			if(TestData!=null && TestData.size()>0)
				noOfElemenstAssociated++;

			if(HostTestData!=null && HostTestData.size()>0)
				noOfElemenstAssociated++;

			if(CompTestData!=null && CompTestData.size()>0)
				noOfElemenstAssociated++;
			/*************************************************/
			if(descriptorData!=null && descriptorData.size()>0)
				noOfElemenstAssociated++;

			if(compDescData!=null && compDescData.size()>0)
				noOfElemenstAssociated++;
			/*************************************************/
		}
		else if(analysisData!=null &&  analysisData.size()>0)
		{
			if(option!=null && option.equalsIgnoreCase("Host"))
			{
				HostData=analysisData;
			}
			else if(option!=null && option.equalsIgnoreCase("Component"))
			{
				CompData=analysisData;
			}
			else if(option!=null && option.equalsIgnoreCase("Test"))
			{
				TestData=analysisData;
				elementForTitle=_mapping.getTestDescription(element);
			}
			else if(option!=null && option.equalsIgnoreCase("Test For Host"))
			{
				HostTestData=analysisData;
				elementForTitle=_mapping.getTestDescription(element);
			}
			else if(option!=null && option.equalsIgnoreCase("Test  For Component"))
			{
				CompTestData=analysisData;
				elementForTitle=_mapping.getTestDescription(element);
			}
			else if(option!=null && option.equalsIgnoreCase("Descriptor"))
			{
				descriptorData=analysisData;
				elementForTitle=_mapping.getTestDescription(element);
			}
			else if(option!=null && option.equalsIgnoreCase("Descriptor For Component"))
			{
				compDescData=analysisData;
				elementForTitle=_mapping.getTestDescription(element);
			}
		}
		

		if(HostData.keySet().size()>0 || CompData.keySet().size()>0 || TestData.keySet().size()>0 || HostTestData.keySet().size()>0 || CompTestData.keySet().size()>0 || descriptorData.keySet().size()>0 || compDescData.keySet().size()>0)
		{
				String sumtitle ="";
			if(element!=null && option.equals("Time Constraints") && element.equalsIgnoreCase("date"))
			{
				sumtitle = _mapping.getTextDescription("admin.mpolicy.Maintenance Summary");
			}
			else
			{
				sumtitle = _mapping.getTextDescription("admin.mpolicy.Maintenance Summary for ");
			}
			if(option!=null && option.equals("All"))
			{
				elementForTitle="All";
			}
%>
		<table width="100%" cellpadding="0" cellspacing="0" border="0" >
			<tr>
				<td width="100%">
						<table cellspacing="0" cellpadding="3" width="100%" border="0">
							<tr>
								<td align="left" width="20%" valign="bottom">
<%
			if(!StringUtils.isNull(homepageLogo))
			{	
%>
								     <img src="<%=homepageLogo.trim()%>" border="0"></td>
<%
		    }
%>
								<input type="hidden" id="datasize" name="datasize" value="<%=dataSize%>">
								<th class="cellbgdark" width="58%" id="cellborder1"><span class="<%=fontStyleDblSingl%>">&nbsp;<egui:intnl text="admin.maintenance.MAINTENANCE ANALYSIS REPORT"/> &nbsp;</span></th>
								<td>
									<table width="60%" border="0" cellspacing="0" cellpadding="0" align="left">
										<tr>
											<td height="10px">&nbsp;</td>
										</tr>
										<tr>
											<th align="right"><img class="mouse" src="/final/admin/eg_images/<%=admin_Skin%>/print_audit.gif" border="0" alt="PRINT" onClick="javascript:printData();"></th>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td>&nbsp;</td>
							</tr>
						</table>
				</td>
			</tr>
		</table>
<%
			if((option!=null && (option.equals("All") || option.equals("Policy") || option.equals("Time Constraints"))) || (element!=null && (element.equals("All Elements") || element.equals("All Hosts") || element.equals("All Components") || element.equals("All Tests") || element.equals("All Descriptors") || element.equals("All Descriptor Comp")))) 
			{
%>

		<table width="100%"  cellpadding="0" cellspacing="0" border="0"  align="center">
			<tr>
				<td height="20px">
					<table width="100%" border="0" cellpadding="0" cellspacing="0"  height="20">
						<tr>
							<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
							<td width="100%" align="left" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px" class="eg_75bold"><span class="<%=fontStyleDblSingl%>"><%=sumtitle%><%= (elementForTitle==null?" All Elements":" "+elementForTitle)%> </span></td>
							<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td> 
					<table width="100%" border="0" cellpadding="0" cellspacing="0"  ><col width="50%"><col width="50%">
						<tr>
							<td  class="table_head linebottom" style="padding-top-width:0px" align="left"  height="20px"><egui:intnl text="admin.mpolicy.Elements Under Maintenance"/></td>
							<td class="table_head linebottomleft" style="padding-top-width:0px" align="left"  height="20px" ><egui:intnl text="admin.mpolicy.Count"/></td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td width="100%" >
					<table width="100%" border="0" cellpadding="4" cellspacing="0"  class="tableborder_ad"><col width="50%"><col width="50%">
						
<%
			if(HostData.keySet().size()>0)
			{
%>
						<tr>
							<td class="tdborder_ad"><egui:intnl text="admin.mpolicy.Host"/> </td>
							<td class="tdborder_ad">
<%			if(noOfElemenstAssociated>1)
				{
%>
							<%=HostData.keySet().size()%>
<%
				}
				else
				{
%>
							<%=HostData.keySet().size()%>
<%
				}
%>
							</td>
						</tr>
<%
			}
			if(CompData.keySet().size()>0)
			{
%>
						<tr>
							<td class="tdborder_ad"><egui:intnl text="admin.mpolicy.Component"/></td>
							<td class="tdborder_ad">
<%			if(noOfElemenstAssociated>1)
				{
%>
							<%=CompData.keySet().size()%>
<%
				}
				else
				{
%>
							<%=CompData.keySet().size()%>
<%
				}
%>
							</td>
						</tr>
<%
			}
			if(TestData.keySet().size()>0)
			{
%>
						<tr>
							<td class="tdborder_ad"><egui:intnl text="admin.mpolicy.Test"/></td>
							<td class="tdborder_ad">
<%			if(noOfElemenstAssociated>1)
				{
%>
							<%=TestData.keySet().size()%>
<%
				}
				else
				{
%>
							<%=TestData.keySet().size()%>
<%
				}
%>
							</td>
						</tr>
<%
			}
			if(HostTestData.keySet().size()>0)
			{
%>
						<tr>
							<td class="tdborder_ad"><egui:intnl text="admin.mpolicy.Host/Test"/></td>
							<td class="tdborder_ad">
<%			if(noOfElemenstAssociated>1)
				{
%>
							<%=HostTestData.keySet().size()%>
<%
				}
				else
				{
%>
							<%=HostTestData.keySet().size()%>
<%
				}
%>
							</td>
						</tr>
<%
			}
			if(CompTestData.keySet().size()>0)
			{
%>
						<tr>
							<td class="tdborder_ad"><egui:intnl text="admin.mpolicy.Component/Test"/></td>
							<td class="tdborder_ad">
<%			if(noOfElemenstAssociated>1)
				{
%>
							<%=CompTestData.keySet().size()%>
<%
				}
				else
				{
%>
							<%=CompTestData.keySet().size()%>
<%
				}
%>
							</td>
						</tr>
<%
			}
			if(descriptorData.keySet().size()>0)
			{
%>
						<tr>
							<td class="tdborder_ad"><egui:intnl text="admin.mpolicy.Descriptors"/></td>
							<td class="tdborder_ad">
<%				if(noOfElemenstAssociated>1)
				{
%>
							<%=descriptorData.keySet().size()%>
<%
				}
				else
				{
%>
							<%=descriptorData.keySet().size()%>
<%
				}
%>
							</td>
						</tr>
<%
			}
			if(compDescData.keySet().size()>0)
			{
%>
						<tr>
							<td class="tdborder_ad"><egui:intnl text="admin.mpolicy.Descriptor For Component"/></td>
							<td class="tdborder_ad">

<%				
				if(noOfElemenstAssociated>1)
				{
%>
							<%=compDescData.keySet().size()%>
<%
				}
				else
				{
%>
							<%=compDescData.keySet().size()%>
<%
				}
%>
							</td>
						</tr>
<%
			}
%>
					</table>
				</td>
			</tr>
		</table>
		<br>
<%
			}
			else if(element!=null && !element.equals("All Hosts") && !element.equals("All Components") && !element.equals("All Tests"))
			{
				boolean isActive=false;
				if(option!=null && option.equals("Test  For Component")  ||  option.equals("Test For Host") || option.equals("Descriptor For Component"))
				{
					if(option.equals("Descriptor For Component"))
					{
						isActive=egM.isServerElementInUnderMintenance("Test For Host",element,descElement);
					}
					else
					{
						isActive=egM.isServerElementInUnderMintenance("Test For Host",testElement,element);
					}
				}
				else if(option!=null && (option.equals("Test") || option.equals("Descriptor")))
				{
					isActive=egM.isServerElementInUnderMintenance("Test",element);
				}
				else
				{
					isActive=egM.isServerElementInUnderMintenance("Host",element);
				}

							String mstatustitle="";
							String melement=element;
							if(melement.endsWith(":NULL"))
							{
								melement = melement.substring(0,melement.indexOf(":NULL"));
							}

							if(option!=null && option.equals("Host"))
							{
								mstatustitle="Quick Maintenance Details For Host";
							}
							else if(option!=null && option.equals("Component"))
							{
								mstatustitle="Quick Maintenance Details For Component";
							}
							else if(option!=null && option.equals("Test"))
							{
								mstatustitle="Quick Maintenance Details For Test";
								melement=_mapping.getTestDescription(element);
							}
							else if(option!=null && option.equals("Test For Host"))
							{
								mstatustitle="Quick Maintenance Details For Host Test";
								melement=_mapping.getTestDescription(element);
							}
							else if(option!=null && option.equals("Test  For Component"))
							{
								mstatustitle="Quick Maintenance Details For Component Test";
								melement=_mapping.getTestDescription(element);
							}
							else if(option!=null && option.equals("Descriptor"))
							{
								mstatustitle="Quick Maintenance Details For Descriptor";
								String elem="";
								if(element!=null && element.indexOf(":")>0)
								{
									elem=element.substring(element.indexOf(":")+1);
								}
								melement=elem;
							}
							else if(option!=null && option.equals("Descriptor For Component"))
							{
								mstatustitle="Quick Maintenance Details For Descriptor For Component";
								String descElem="";
								if(element!=null && element.indexOf(":")>0)
								{
									descElem=descElement.substring(descElement.indexOf(":")+1);
								}
								melement=descElem;
							}
%>
		<table  cellpadding="0" cellspacing="0" border="0"  align="center" width="100%">
			<tr>
				<td height="20px" width="100%">
					<table width="100%" border="0" cellpadding="0" cellspacing="0"  height="20">
						<tr>
							<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
							<td width="100%" align="left" id="eg_subheadbg" nowrap style="border-left-width:0px;border-right-width:0px" class="eg_75bold"><egui:intnl text="<%="admin.mpolicy."+mstatustitle%>"/> - <span class="<%=fontStyleDblSingl%>"><%=melement%></span></td>
							<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td>
					<table width="100%" border="0" align="left" cellpadding="4" cellspacing="0"  height="20">
					<col width="50%"><col width="50%">
						<tr>
								<td class="table_head " style="border-right-width:0px" valign="top" align="left" colspan="2"><span class="<%=fontStyleDblSingl%>"><%=melement%></span></td>
						<tr>
						<tr>
								<td style="text-align:left;border-left-width:1px;" class="cell_border4" align="left"  height="20px"><%=_mapping.getTextDescription("admin.mpolicy.Status")%></td>
								<td class="cell_border4 " valign="top" align="left">
<%									if(isActive) 
									{
%>
										<egui:intnl text="admin.mpolicy.Active"/>
<%
									} 
									else 
									{
%>
										<egui:intnl text="admin.mpolicy.Inactive"/>
<%
									}
%>
								</td>
						</tr>
						</table>
					</td>
				</tr>
			</table>

<%			}
		}

		if(option!=null && !option.equals("All") &&  !option.equals("Time Constraints") && !option.equals("Policy"))
		{
			if(analysisData!=null && analysisData.size()>0) 
			{
				if(element!=null && (element.equals("All Hosts") || element.equals("All Components") || element.equals("All Tests") || element.equals("All Descriptors") || element.equals("All Descriptor Comp")))
				{

		Vector analysisDataKey=new Vector();
		Hashtable mappedAnalysisData=new Hashtable();
		Hashtable mappedkeys=new Hashtable();
		if(analysisData!=null)
		{
			Iterator mappitr=analysisData.keySet().iterator();
			while(mappitr.hasNext()) 
			{
				String mapkey=(String)mappitr.next();
				String dispval="";
				if(option!=null && !option.equals("Test  For Component")  &&  !option.equals("Test For Host") && !option.equalsIgnoreCase("Descriptor For Component")) 
				{
					Hashtable mapval=(Hashtable)analysisData.get(mapkey);
					if(option!=null && option.equals("Host") || option.equals("Component") || option.equals("Descriptor"))
					{
//						dispval=_mapping.getComponentTypeDescription(mapkey);
						dispval=mapkey;
					}
					else
					{
						dispval=_mapping.getTestDescription(mapkey);
					}
					mappedAnalysisData.put(dispval,mapval);
					mappedkeys.put(dispval,mapkey);
				}
				else
				{
					if(option.equals("Descriptor For Component"))
					{
						dispval=mapkey;
					}
					else
					{
						dispval=_mapping.getTestDescription(mapkey);
					}
					Vector mapvalvec=(Vector)analysisData.get(mapkey);
					mappedAnalysisData.put(dispval,mapvalvec);
					mappedkeys.put(dispval,mapkey);
				}
			}
		}
		analysisDataKey.addAll(mappedAnalysisData.keySet());
		Collections.sort(analysisDataKey,String.CASE_INSENSITIVE_ORDER);
		Iterator htr=analysisDataKey.iterator();
		Hashtable value=null;
		Vector  hashValue=null;
		Iterator itr=null;
		Hashtable timeDur=null;

%>

		<table id="rsTable" width="100%" border="0" align="center" cellpadding="0" cellspacing="0" >
<%
		if(option!=null && option.equals("Test  For Component") || option.equals("Test For Host") || option.equals("Descriptor For Component")) 
		{
			String colTitle="";
			if(option.equals("Test  For Component")) 
			{
				colTitle="Component";
			}
			else if(option.equals("Descriptor For Component"))
			{
				colTitle="Component";
			} 
			else
			{
				colTitle="Host";
			}
%>
			<tr>
				<td colspan="3" height="20" align="center" style="padding:0px">
					<table width="100%" border="0" cellpadding="0" cellspacing="0"  height="20">
						<tr>
							<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
							<td width="100%" align="left" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px"><strong><egui:intnl text="<%="admin.mpolicy."+dispTitle%>"/> </strong></td>
							<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td colspan="3" class="space8 linesquare">
			<table width="100%" border="0" align="left" cellpadding="4" cellspacing="0" class="tableborder_ad" style="border-top-width:0px">
			
<%
			if(timePeriod!=null && timePeriod.equals("true")) 
			{
%>
					<col width="30%"><col width="30%"><col width="60px"><col width="40%">
					<tr>
					<td class="cell_border3" align="left" ><egui:intnl text="<%="admin.mpolicy."+columnName%>"/></td>
					<td class="cell_border3" align="left" ><egui:intnl text="<%="admin.mpolicy."+colTitle%>"/></td>
					<td class="cell_border3" align="left" ><egui:intnl text="admin.mpolicy.Status"/></td>
					<td class="cell_border3" align="left" ><egui:intnl text="admin.mpolicy.Timeline"/></td>
					</tr>
<%
			} 
			else
			{
%>
					<col width="50%"><col width="50%">
					
<%
						while(htr.hasNext()) 
						{
							String dispkey=(String)htr.next();
							String key=(String)mappedkeys.get(dispkey);
							String tnam=key;
							String dispMsg="";
							String disp="";
							String policyName="-";
							String GroupName="-";
							if(dispkey!=null && dispkey.indexOf(":")>-1 && !option.equals("Component"))
							{
								if(dispkey.indexOf("$")>0 && dispkey.indexOf("&")>0)
								{
									disp=dispkey.substring(dispkey.indexOf(":")+1,dispkey.indexOf("&"));
									GroupName=dispkey.substring(dispkey.indexOf("&")+1,dispkey.indexOf("$"));
									policyName=dispkey.substring(dispkey.indexOf("$")+1);
								}
								else if(dispkey.indexOf("$")>0)
								{
									disp=dispkey.substring(dispkey.indexOf(":")+1,dispkey.indexOf("$"));
									policyName=dispkey.substring(dispkey.indexOf("$")+1);
								}
								else if(dispkey.indexOf("&")>0)
								{
									disp=dispkey.substring(dispkey.indexOf(":")+1,dispkey.indexOf("&"));
									GroupName=dispkey.substring(dispkey.indexOf("&")+1);
								}
								else
								{
									disp=dispkey.substring(dispkey.indexOf(":")+1);
								}
							}
							else
							{
								if(dispkey.indexOf("$")>0 && dispkey.indexOf("&")>0)
								{
									disp=dispkey.substring(0,dispkey.indexOf("&"));
									GroupName=dispkey.substring(dispkey.indexOf("&")+1,dispkey.indexOf("$"));
									policyName=dispkey.substring(dispkey.indexOf("$")+1);
								}
								else if(dispkey.indexOf("$")>0)
								{
									disp=dispkey.substring(0,dispkey.indexOf("$"));
									policyName=dispkey.substring(dispkey.indexOf("$")+1);
								}
								else if(dispkey.indexOf("&")>0)
								{
									disp=dispkey.substring(0,dispkey.indexOf("&"));
									GroupName=dispkey.substring(dispkey.indexOf("&")+1);
								}
								else
								{
									disp=dispkey;
								}
								if(disp.endsWith(":NULL"))
								{
									disp= disp.substring(0,disp.indexOf(":NULL"));
								}
							}
%>
							<tr>
								<td class="table_head <%=fontStyleDblSingl%>" valign="top" style="text-align:left;" colspan="2"><%=disp%></td>
								
							</tr>
<%
	if(policyName!=null && !policyName.equals("-"))
	{
%>
							<tr>
								<td class="cell_border3" align="left" style="text-align:left;width:60px"><egui:intnl text="admin.mpolicy.PolicyName"/></td>
								<td class="cell_border3 <%=fontStyleDblSingl%>" valign="top"><%=policyName%></td>
							</tr>
<%
	}
	String cellborder3="cell_border3";
	String cellborder4="cell_border4";
	if(GroupName!=null && !GroupName.equals("-"))
	{
		cellborder4="cell_border3";
		cellborder3="cell_border4";
%>
							<tr>
								<td class="cell_border4" align="left" style="text-align:left;width:60px"><egui:intnl text="admin.mpolicy.GroupName"/></td>
								<td class="cell_border4 <%=fontStyleDblSingl%>" valign="top"><%=GroupName%></td>
							</tr>
							
<%
	}
						hashValue=(Vector)analysisData.get(key);
						Vector  comps=(Vector)hashValue.get(0);
%>
							<tr>
								<td class="<%=cellborder4%>" align="left" valign="top" ><egui:intnl text="<%="admin.mpolicy."+colTitle%>"/></td>
<%
						if(comps!=null && comps.size()>0)
						{
%>
								<td valign="top" class="<%=cellborder4%>" >
									<table border="0" cellpadding="0" cellspacing="0">
<%
									for(int c=0;c<comps.size();c++) 
									{
										String host=(String)comps.get(c);
										if(host.endsWith(":NULL"))
										{
											host = host.substring(0,host.indexOf(":NULL"));
										}
										if(element!=null && (element.equals("All Tests") || element.equals("All Descriptor Comp"))) 
										{
%>
									<tr><td><%=host%></td> </tr>
<%
										}
										else
										{
											if(testElement.equals(host)) 
											{
												key=host+"#"+key;
%>
									<tr><td valign="top"><%=host%> </td></tr>
<%
											}
										}
									}
%>
									</table>
								</td>
<%
						}
%>
							</tr>
							<tr>
								<td class="<%=cellborder3%>" align="left" ><egui:intnl text="admin.mpolicy.Status"/></td>
								<td class="<%=cellborder3%>" valign="top" align="left">
<%
									boolean isActive=false;
									if(tnam!=null && !tnam.equals("") && (option.equals("Test For Host") || option.equals("Test  For Component") &&  option.equals("Descriptor For Component"))&& tnam.indexOf("#")>0 && element!=null && (!element.equals("All Tests") || !element.equals("All Descriptor Comp")))
									{
										tnam=tnam.substring(tnam.indexOf("#")+1,tnam.length());
									}
									String testName=request.getParameter("element");
									String hostName=request.getParameter("testElement");

									if(testName!=null && !testName.equals("") && element!=null && !element.equals("All Tests") && !element.equals("All Descriptor Comp"))
									{
										String host=(String)comps.get(0);

										isActive=egM.isServerElementInUnderMintenance("Test For Host",hostName,testName);
										tnam=hostName+"#"+testName;
									}
									else
									{
										isActive=egM.isServerElementInUnderMintenance("Test For Host",tnam);
									}

									if(isActive) 
									{
%>
									<egui:intnl text="admin.mpolicy.Active"/>
<%
									}
									else
									{
%>
									<egui:intnl text="admin.mpolicy.Inactive"/>
<%
									}

									timeDur=(Hashtable)hashValue.get(1);
									itr=timeDur.keySet().iterator();
								
%>
								</td>
							</tr>
							<tr>
								<td class="<%=cellborder4%>" align="left" style="width:60px"><egui:intnl text="admin.mpolicy.TimeLine"/></td>
								<td class="<%=cellborder4%>"  valign="top" style="padding:0px">
									<table width="100%"  border="0" align="center" cellpadding="4" cellspacing="0">
									<col width="60%"><col width="40%">
<%
										Vector timeColumn=new Vector();
										String timeKey="";
										while(itr.hasNext()) 
										{
											timeKey=(String)itr.next();
											timeColumn.add(timeKey);
										}
										String dispCol="";
										for(int i=0;i<timeColumn.size();i++) 
										{
											String colName=(String)timeColumn.get(i);
											String cellborder="border-bottom-width:1px";
											if(timeColumn.size()==1)
											{
												cellborder="border-bottom-width:0px";
											}
											else if(i==timeColumn.size()-1)
											{
												cellborder="border-bottom-width:0px";
											}
											if(colName.equals("FDM"))
											{
												dispCol="First Day Of Month";
											}
											else if(colName.equals("LDM")) 
											{
												dispCol="Last Day Of Month";
											}
											else if(colName.equals("*")) 
											{
												dispCol="Daily";
											}
											else if(colName.equals("Sun") || colName.equals("Mon") || colName.equals("Tue") || colName.equals("Wed") || colName.equals("Thu") || colName.equals("Fri") || colName.equals("Sat")) 
											{
												dispCol=egM.DayForDescription(colName);
											} 
											else 
											{
												dispCol=colName.replace('|','-');
											}
%>
										<tr>
<%
											if(i%2==0) 
											{
%>
											<td class="linebottomright" style="<%=cellborder%>"><span class="<%=fontStyleDblSingl%>">&nbsp;<%=dispCol%>&nbsp;</span></td>
											<td class="linebottomright" style="<%=cellborder%>" >
<%
											} 
											else
											{
%>
											<td class="linebottomright" style="<%=cellborder%>"><span class="<%=fontStyleDblSingl%>">&nbsp;<%=dispCol%>&nbsp;</span></td>
											<td class="linebottomright" style="<%=cellborder%>">
<%
											}
%>
												<table width="100%"  border="0" align="center" cellpadding="0" cellspacing="0">
<%
													Vector  timeVal=(Vector)timeDur.get(colName);
													if(timeVal!=null && timeVal.size()>0) 
													{
														for(int j=0;j<timeVal.size();j++) 
														{
															String time=(String)    timeVal.get(j);
															String startTime=time.substring(0,time.indexOf("-"));
															String endTime=time.substring(time.indexOf("-")+1,time.length());
															String timeMsg=startTime+"-"+endTime;
%>
													<tr>
														<td><span class="<%=fontStyleDblSingl%>">&nbsp;<%=timeMsg%>&nbsp;</span></td>
													</tr>
<%
														}
													}
%>
												</table>
											</td>
										</tr>
<%
										}
%>
									</table>
								</td>
							</tr>
							<tr>
								<td class="<%=cellborder3%>" align="left" style="width:100px"><egui:intnl text="admin.mpolicy.NextScheduleDate"/></td>
								<td  valign="top" class="<%=cellborder3%>" rowspan="0">
<%
								if(key.indexOf("$")>-1 && key.indexOf("&")>-1)
								{
									key=key.substring(0,key.indexOf("&"));
								}
								else if(key.indexOf("$")>-1)
								{
									key=key.substring(0,key.indexOf("$"));
								}
								else if(key.indexOf("&")>-1)
								{
									key=key.substring(0,key.indexOf("&"));
								}
								Vector elementNames=new Vector();
								Hashtable dates=new Hashtable();
								Vector elementnames=new Vector();
								elementnames=egM.getAssociatedHostsOrComponentsForTests(key);
								dates=egM.getNextScheduleTimeForHosttestOrComponenttest(key,elementnames);
								if(dates!=null && dates.size()==0)
								{
									if(comps!=null && comps.size()>0) 
									{
										for(int c=0;c<comps.size();c++) 
										{
											String host=(String)comps.get(c);

										elementNames.add(host);
										dates=egM.getUnplannedNextScheduleTimeForHosttestOrComponenttest(key,elementNames);

										}
									}
								}
								if(dates!=null && dates.size()>0)  
								{
										SimpleDateFormat simpleDateFmt=new SimpleDateFormat(currentDateFormat+" "+"H:mm");
										Date startDate1=(Date)dates.keySet().iterator().next();
										Date endDate1=(Date)dates.get(startDate1);
										if(endDate1.before(new Date()) || endDate1.equals(new Date()))
										{
											out.println("Completed");
										}
										else if(startDate1.getDate()==endDate1.getDate() && startDate1.getMonth()==endDate1.getMonth() && startDate1.getYear()==endDate1.getYear()) 
										{
											SimpleDateFormat simpleDateFmt1=new SimpleDateFormat("H:mm");
											out.println(simpleDateFmt.format(startDate1)+"-"+simpleDateFmt1.format(endDate1));
										}
										else
										{
											out.println(simpleDateFmt.format(startDate1)+"-"+simpleDateFmt.format(endDate1));
										}
								}
%>
								</td>
							</tr>
						<tr>
								<td style="height:10px;padding:0px;border-left-width:0px;border-right-width:0px"><img src="/final/admin/eg_images/spacer.gif" height="10"></td>
							</tr>	
<%
						}
%>
<%
				}
%>
			
<%
			if(timePeriod!=null && timePeriod.equals("true")) 
			{
%>
			<tr>
				<td class="table_head linebottom" align="center">&nbsp;</td>
				<td class="table_head linebottomright" align="center">&nbsp;</td>
				<td class="table_head" align="center" style="padding:0px">
					<table width="100%" border="0" cellpadding="2" cellspacing="0">
						<col width="60%"><col width="40%">
						<tr>
							<td class="table_head lineright" align="center"><egui:intnl text="admin.mpolicy.Time Constraints"/></td>
							<td class="table_head lineright" align="center"><egui:intnl text="admin.mpolicy.Time Period"/></td>
						</tr>
					</table>
				</td>
			</tr>
<%
			}
		}
		else
		{
%>          <tr>
				<td colspan="3" height="20" align="center" style="padding:0px">
					<table width="100%" border="0" cellpadding="0" cellspacing="0"  height="20">
						<tr>
							<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
							<td width="100%" align="left" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px"><strong><egui:intnl text="<%="admin.mpolicy."+dispTitle%>"/> </strong></td>
							<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td colspan="2" class="space8 linesquare">
					<table width="100%" border="0" align="left" cellpadding="4" cellspacing="0"  style="border-top-width:0px">
<%
						if(timePeriod!=null && timePeriod.equals("true")) 
						{
%>
						<col width="60%"><col width="40%">
						<tr>
						<td align="left" class="table_header" style="padding:2px"><egui:intnl text="<%="admin.mpolicy."+columnName%>"/>&nbsp;</td>
						<td align="left" width="100%"><egui:intnl text="admin.mpolicy.Timeline"/></td>
<%
						}
						else
						{
%>
						<col width="50%"><col width="50px">
						
<%
						while(htr.hasNext()) 
						{
							String dispkey=(String)htr.next();
							String key=(String)mappedkeys.get(dispkey);
							String tnam=key;
							String dispMsg="";
							String disp="";
							String policyName="-";
							String groupName="-";
							if(dispkey!=null && dispkey.indexOf(":")>-1 && !option.equals("Component"))
							{
								if(dispkey.indexOf("$")>0 && dispkey.indexOf("&")>0)
								{
									disp=dispkey.substring(dispkey.indexOf(":")+1,dispkey.indexOf("&"));
									groupName=dispkey.substring(dispkey.indexOf("&")+1,dispkey.indexOf("$"));
									policyName=dispkey.substring(dispkey.indexOf("$")+1);
								}
								else if(dispkey.indexOf("$")>0)
								{
									disp=dispkey.substring(dispkey.indexOf(":")+1,dispkey.indexOf("$"));
									policyName=dispkey.substring(dispkey.indexOf("$")+1);
								}
								else if(dispkey.indexOf("&")>0)
								{
									disp=dispkey.substring(dispkey.indexOf(":")+1,dispkey.indexOf("&"));
									groupName=dispkey.substring(dispkey.indexOf("&")+1);
								}
								else
								{
									disp=dispkey.substring(dispkey.indexOf(":")+1);
								}
							}
							else
							{
								if(dispkey.indexOf("$")>0 && dispkey.indexOf("&")>0)
								{
									disp=dispkey.substring(0,dispkey.indexOf("&"));
									groupName=dispkey.substring(dispkey.indexOf("&")+1,dispkey.indexOf("$"));
									policyName=dispkey.substring(dispkey.indexOf("$")+1);
								}
								else if(dispkey.indexOf("$")>0)
								{
									disp=dispkey.substring(0,dispkey.indexOf("$"));
									policyName=dispkey.substring(dispkey.indexOf("$")+1);
								}
								else if(dispkey.indexOf("&")>0)
								{
									disp=dispkey.substring(0,dispkey.indexOf("&"));
									groupName=dispkey.substring(dispkey.indexOf("&")+1);
								}
								else
								{
									disp=dispkey;
								}
								if(disp.endsWith(":NULL"))
								{
									disp= disp.substring(0,disp.indexOf(":NULL"));
								}
							}
%>
							<tr>
								<td class="table_head <%=fontStyleDblSingl%>" style="text-align:left;padding:2px" valign="top" colspan="2"><%=disp%></td>
							</tr>
<%
	if(policyName!=null && !policyName.equals("-"))
	{
%>
							<tr>
								<td class="cell_border3" align="left" style="border-left-width:1px;border-right-width:0px"><egui:intnl text="admin.mpolicy.PolicyName"/></td>
								<td class="cell_border3 <%=fontStyleDblSingl%>" valign="top" style="border-left-width:1px"><%=policyName%></td>
							</tr>
<%
	}
	String cellborder3="cell_border3";
	String cellborder4="cell_border4";

	if(groupName!=null && !groupName.equals("-"))
	{
		cellborder4="cell_border3";
		cellborder3="cell_border4";
%>
							<tr>
								<td class="cell_border4" align="left" style="border-left-width:1px;border-right-width:0px"><egui:intnl text="admin.mpolicy.GroupName"/></td>
								<td class="cell_border4 <%=fontStyleDblSingl%>" valign="top" style="border-left-width:1px"><%=groupName%></td>
							</tr>
<%
	}
%>

<%
								boolean isActive=false;
								if(option!=null && option.equals("Test") || option.equals("Descriptor"))
								{
									isActive=egM.isServerElementInUnderMintenance("Test",disp);
								}
								else
								{
									isActive=egM.isServerElementInUnderMintenance("Host",disp);
								}
	
%>
							<tr>
								<td class="<%=cellborder4%>" align="left" style="border-left-width:1px;border-right-width:0px"><egui:intnl text="admin.mpolicy.Status"/></td>
<%
									if(isActive) 
									{
%>
									<td class="<%=cellborder4%>" valign="top" align="left" style="border-left-width:1px;border-right-width:0px">
										<egui:intnl text="admin.mpolicy.Active"/>
									</td>
<%
									}
									else
									{
%>
									<td class="<%=cellborder4%>" valign="top" align="left" style="border-left-width:1px;border-right-width:0px">
											<egui:intnl text="admin.mpolicy.Inactive"/>
									</td>
<%
									}
%>
							</tr>

<%
							timeDur=(Hashtable)analysisData.get(key);
							itr=timeDur.keySet().iterator();
						
%>
							<tr>
								<td class="<%=cellborder3%>" align="left" style="border-left-width:1px;border-right-width:0px"><egui:intnl text="admin.mpolicy.TimeLine"/></td>
								<td class="<%=cellborder3%>" valign="top"  align="left" style="border-left-width:1px;padding:0px">
									<table width="100%"  border="0" align="center" cellpadding="0" cellspacing="0" ><col width="60%"><col width="40%">
<%
										Vector timeColumn=new Vector();
										String timeKey="";
										while(itr.hasNext()) 
										{
											timeKey=(String)itr.next();
											timeColumn.add(timeKey);
										}
										String dispCol="";
										for(int i=0;i<timeColumn.size();i++) 
										{
											String colName=(String)timeColumn.get(i);
											String cellborder="border-bottom-width:1px";
											if(timeColumn.size()==1)
											{
												cellborder="border-bottom-width:0px";
											}
											else if(i==timeColumn.size()-1)
											{
												cellborder="border-bottom-width:0px";
											}
											if(colName.equals("FDM"))
											{
												dispCol="First Day Of Month";
											}
											else if(colName.equals("LDM")) 
											{
												dispCol="Last Day Of Month";
											}
											else if(colName.equals("*")) 
											{
												dispCol="Daily";
											}
											else if(colName.equals("Sun") || colName.equals("Mon") || colName.equals("Tue") || colName.equals("Wed") || colName.equals("Thu") || colName.equals("Fri") || colName.equals("Sat")) 
											{
												dispCol=egM.DayForDescription(colName);
											} 
											else 
											{
												dispCol=colName.replace('|','-');
											}
%>
										<tr>
<%
											if(i%2==0) 
											{
%>
											<td class="<%=cellborder3%>" style="<%=cellborder%>"><span class="<%=fontStyleDblSingl%>">&nbsp;<%=dispCol%>&nbsp;</span></td>
											<td class="<%=cellborder3%>" style="<%=cellborder%>">
<%
											} 
											else
											{
%>
											<td class="<%=cellborder3%>" style="<%=cellborder%>"><span class="<%=fontStyleDblSingl%>">&nbsp;<%=dispCol%>&nbsp;</td>
											<td class="<%=cellborder3%>" style="<%=cellborder%>">
<%
										}
%>
											<table width="100%"  border="0" align="center" cellpadding="4" cellspacing="0">
<%
												Vector  timeVal=(Vector)timeDur.get(colName);
												if(timeVal!=null && timeVal.size()>0) 
												{
													for(int j=0;j<timeVal.size();j++) 
													{
														String time=(String)    timeVal.get(j);
														String startTime=time.substring(0,time.indexOf("-"));
														String endTime=time.substring(time.indexOf("-")+1,time.length());
														String timeMsg=startTime+"-"+endTime;
%>
												<tr>
													<td><span class="<%=fontStyleDblSingl%>">&nbsp;<%=timeMsg%>&nbsp;</td>
												</tr>
<%
													}
												}
%>
											</table>
										</td>
									</tr>
<%
									}
%>
									</table>
								</td>
							</tr>
							<tr>
								<td class="<%=cellborder4%>" align="left" style="border-left-width:1px;border-right-width:0px"><egui:intnl text="admin.mpolicy.NextScheduleDate"/></td>
								<td  valign="top" class="<%=cellborder4%>" style="border-left-width:1px;border-right-width:0px" rowspan="0" align="left">
<%
								if(key.indexOf("$")>-1 && key.indexOf("&")>-1)
								{
									key=key.substring(0,key.indexOf("&"));
								}
								else if(key.indexOf("$")>-1)
								{
									key=key.substring(0,key.indexOf("$"));
								}
								else if(key.indexOf("&")>-1)
								{
									key=key.substring(0,key.indexOf("&"));
								}
								Hashtable dates=new Hashtable();
								
								if(option.equals("Test") || option.equals("Descriptor"))
								{
										dates=egM.getNextScheduleTimeForTest(key);
										if(dates!=null && dates.size()==0)
										{	
											dates=egM.getUnplannedNextScheduleTimeForTest(key);
										}
								}
								else if(option.equals("Host") || option.equals("Components") || option.equals("Component"))
								{
										dates=egM.getNextScheduleTimeForHost(key);
										if(dates!=null && dates.size()==0)
										{
											dates=egM.getUnplannedNextScheduleTimeForHost(key);
										}
								}

								if(dates!=null && dates.size()>0)  
								{
										SimpleDateFormat simpleDateFmt=new SimpleDateFormat(currentDateFormat+" "+"H:mm");
										Date startDate1=(Date)dates.keySet().iterator().next();
										Date endDate1=(Date)dates.get(startDate1);
										if(endDate1.before(new Date()) || endDate1.equals(new Date()))
										{
											out.println("Completed");
										}
										else if(startDate1.getDate()==endDate1.getDate() && startDate1.getMonth()==endDate1.getMonth() && startDate1.getYear()==endDate1.getYear()) 
										{
											SimpleDateFormat simpleDateFmt1=new SimpleDateFormat("H:mm");
											out.println(simpleDateFmt.format(startDate1)+"-"+simpleDateFmt1.format(endDate1));
										}
										else
										{
											out.println(simpleDateFmt.format(startDate1)+"-"+simpleDateFmt.format(endDate1));
										}
								}
%>
								</td>
							</tr>
							<tr>
							<td style="height:10px;padding:0px"><img src="/final/admin/eg_images/spacer.gif" height="10"></td>
							</tr>	
													
						
<%
							}
							if(timePeriod!=null && timePeriod.equals("true")) 
							{
%>
							<tr>
								<td class="table_head linebottomright" align="center"></td>
								<td class="table_head linebottomright" align="center" style="padding:0px">
									<table width="100%" border="0" cellpadding="2" cellspacing="0">
										<col width="60%"><col width="40%">
										<tr>
											<td class="table_head lineright" align="center"><egui:intnl text="admin.mpolicy.Time Constraints"/></td>
											<td class="table_head lineright" align="center"><egui:intnl text="admin.mpolicy.Time Period"/></td>
										</tr>
									</table>
								</td>
							</tr>
<%
							}
						}
		}

%>
					</table>
				</td>
			</tr>
		</table>
<%
				}
				else if(element!=null && !element.equals("All Hosts") && !element.equals("All Components") && !element.equals("All Tests"))
				{
							String mdetailtitle="";
							boolean isElementUnderPlannedMaintenance=false;
							boolean isElementUnderUnPlannedMaintenance=false;
							Hashtable details=new Hashtable();
							Hashtable details1=new Hashtable();
							Vector unplannedpoldetails=new Vector();
							String dispMsg="",undispMsg="";
/*
							String uiFile = "eg_ui.ini";
							String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
							IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
							String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
*/
							String melement=element;

							if(option!=null && option.equals("Host"))
							{
								mdetailtitle="Maintenance Details For Host";
							}
							else if(option!=null && option.equals("Component"))
							{
								mdetailtitle="Maintenance Details For Component";
							}
							else if(option!=null && option.equals("Test"))
							{
								mdetailtitle="Maintenance Details For Test";
								melement=_mapping.getTestDescription(element);
							}
							else if(option!=null && option.equals("Test For Host"))
							{
								mdetailtitle="Maintenance Details For Host Test";
								melement=_mapping.getTestDescription(element);
							}
							else if(option!=null && option.equals("Test  For Component"))
							{
								mdetailtitle="Maintenance Details For Component Test";
								melement=_mapping.getTestDescription(element);
							}
							else if(option!=null && option.equals("Descriptor"))
							{
								mdetailtitle="Maintenance Details For Descriptors";
								melement=_mapping.getTestDescription(element);
							}
							else if(option!=null && option.equals("Descriptor For Component"))
							{
								mdetailtitle="Maintenance Details For Descriptor For Component";
								melement=_mapping.getTestDescription(element);
							}
							if(testElement==null)
							{	
								testElement="";
							}

							if(option!=null &&  (option.equals("Test For Host") || option.equals("Test  For Component") || option.equals("Descriptor For Component")))
							{
								if(option.equals("Descriptor For Component"))
								{
									isElementUnderPlannedMaintenance=egM.isElementUnderPlannedMaintenance(element,option,descElement);
									isElementUnderUnPlannedMaintenance=egM.isElementUnderUnPlannedMaintenance(element,option,descElement);

								}
								else
								{

									isElementUnderPlannedMaintenance=egM.isElementUnderPlannedMaintenance(testElement,option,element);
									isElementUnderUnPlannedMaintenance=egM.isElementUnderUnPlannedMaintenance(testElement,option,element);
								}
							}
							else
							{
								String strelement=element;
								if(option!=null && (option.equals("Test") || option.equals("Descriptor")))
								{
									strelement="#"+element;
								}
								isElementUnderPlannedMaintenance=egM.isElementUnderPlannedMaintenance(strelement,option,"");
								isElementUnderUnPlannedMaintenance=egM.isElementUnderUnPlannedMaintenance(strelement,option,"");
							}


							if(element!=null && !option.equals("Test For Host") && !option.equals("Test  For Component") && !option.equals("Descriptor For Component"))
							{
								String detelement=element;
								if(option!=null && (option.equals("Test")|| option.equals("Descriptor")))
								{
									detelement="#"+element;
								}
								if(isElementUnderPlannedMaintenance)
								{
										details=egM.getPolicyGroupDetails(detelement,"");
								}
								if(isElementUnderUnPlannedMaintenance)
								{
										unplannedpoldetails=egM.getUnplannedPolicyDetails(detelement,"");
								}
							}
							if(option.equals("Test For Host") || option.equals("Test  For Component") || option.equals("Descriptor For Component") &&element!=null && !element.equals("")) 
							{
								if(option.equals("Descriptor For Component"))
								{
									if(isElementUnderPlannedMaintenance)
									{
										details=egM.getPolicyGroupDetails(element,descElement);
									}
									if(isElementUnderUnPlannedMaintenance)
									{
								//		details1=egM.getUnplannedPolicyDetails(element,testName);
										unplannedpoldetails=egM.getUnplannedPolicyDetails(element,descElement);
									}
								}
								else
								{
									if(isElementUnderPlannedMaintenance)
									{
										details=egM.getPolicyGroupDetails(testElement,element);
									}
									if(isElementUnderUnPlannedMaintenance)
									{
								//		details1=egM.getUnplannedPolicyDetails(element,testName);
										unplannedpoldetails=egM.getUnplannedPolicyDetails(testElement,element);
									}
								}
							}

								String op="";
								if(option!=null && option.equals("Components")) 
								{
									op=_mapping.getTextDescription("admin.mpolicy.Component");
								}
								else if(option!=null && option.equals("Test For Host")) 
								{
									op=_mapping.getTextDescription("admin.mpolicy.Host Test");
								}
								else if(option!=null && option.equals("Test  For Component")) 
								{
									op=_mapping.getTextDescription("admin.mpolicy.Component Test");
								}
								else if(option!=null && option.equals("Descriptor"))
								{
									op=_mapping.getTextDescription("admin.mpolicy.Descriptors");
								}
								else if(option!=null && option.equals("Descriptor For Component"))
								{
									op=_mapping.getTextDescription("admin.mpolicy.Descriptor For Component");
								}
								else
								{
									op=option;
								}

								if(isElementUnderPlannedMaintenance && isElementUnderUnPlannedMaintenance)
								{
									dispMsg=_mapping.getTextDescription("admin.mpolicy.Policy Group Details for")+" "+op;
									undispMsg=_mapping.getTextDescription("admin.mpolicy.Quick Maintenance Details for")+" "+op;;
								}
								else  if(isElementUnderPlannedMaintenance)
								{
									dispMsg=_mapping.getTextDescription("admin.mpolicy.Policy Group Details for")+" "+op;
								}
								else	if(isElementUnderUnPlannedMaintenance)
								{
									undispMsg=_mapping.getTextDescription("admin.mpolicy.Quick Maintenance Details for")+" "+op;
								}

							if(element!=null &&element.equals("")) 
							{
								if(element.indexOf("#")==0) 
								{
									element=element.substring(element.indexOf("#")+1,element.length());
								}
								if(option.equals("Test For Host") || option.equals("Test  For Component") || option.equals("Test") || option.equals("Descriptor For Component")) 
								{
									dispMsg=dispMsg+" "+"'"+_mapping.getTestDescription(element)+"'";
									undispMsg=undispMsg+" "+"'"+_mapping.getTestDescription(element)+"'";
								}
								else
								{
										dispMsg=dispMsg+" "+"'"+element+"'";
										undispMsg=undispMsg+" "+"'"+element+"'";
								}
							}
%>

		
<%
							if(isElementUnderUnPlannedMaintenance)
							{
%>
		<table width="100%"  border="0" align="center" cellpadding="4" cellspacing="0" ><col width="50%"><col width="50%">
<%
								boolean displaySchedule=true;
								for(int i=0;i<unplannedpoldetails.size();i++)
								{
									String key=(String)unplannedpoldetails.get(i);
									String displayKey = key; // Limited admin
									displayKey = egM.getPolicyDisplayName(displayKey,!roleInfo.hasAllComponentAccess());
%>
			<tr>
				<td valign="top" class="cell_border3" align="left" style=";border-left-width:1px;"><egui:intnl text="admin.mpolicy.Policy Name"/></td>
				<td valign="top" class="cell_border3 <%=fontStyleDblSingl%>" style="border-right-width:1px"><%=displayKey%></td>
			</tr>
			<tr>
				<td valign="top" class="cell_border4" align="left" style=";border-left-width:1px;"><egui:intnl text="admin.mpolicy.Timeline"/></td>
				<td valign="top" class="cell_border4" style="border-right-width:1px">
					<table cellpadding="2" cellspacing="0" border="0" width="100%">
					<col width="200"><col width="120">
<%
									Hashtable timeDetails=egM.getUnplannedMaintenancePolicyTimeLines(key);
									Iterator itr=timeDetails.keySet().iterator();
									while(itr.hasNext()) 
									{
										String timeKey=(String)itr.next();
										Vector timeVal=(Vector)timeDetails.get(timeKey);
%>
						<tr>
							<td><%=timeKey%></td>
							<td>
								<table cellpadding="0px" cellspacing="0px" border="0" width="100%">
<%
										for(int k=0;k<timeVal.size();k++) 
										{
											String time=(String)timeVal.get(k);
%>
									<tr>
										<td><%=time%></td>
									</tr>
<%
										}
%>
								</table>
							</td>
						</tr>
<%
									}
%>	
					</table>
				</td>
			</tr>
<%
									Hashtable dates=new Hashtable();
									if(option.equals("Test") || option.equals("Descriptor"))
									{
										dates=egM.getUnplannedNextScheduleTimeForTest(element);
									} 
									else if(option.equals("Test For Host") || option.equals("Test  For Component") || option.equals("Descriptor For Component"))
									{
										Vector elementNames=new Vector();
										if(option.equals("Descriptor For Component"))
										{
											elementNames.add(element);

											dates=egM.getUnplannedNextScheduleTimeForHosttestOrComponenttest(descElement,elementNames);

										}
										else
										{
											elementNames.add(testElement);
											dates=egM.getUnplannedNextScheduleTimeForHosttestOrComponenttest(element,elementNames);
										}
									}
									else if(option.equals("Host") || option.equals("Components") || option.equals("Component"))
									{
										dates=egM.getUnplannedNextScheduleTimeForHost(element);
									}
									if(dates!=null && dates.size()>0)  
									{
										SimpleDateFormat simpleDateFmt=new SimpleDateFormat(currentDateFormat+" "+"H:mm");
										Date startDate1=(Date)dates.keySet().iterator().next();
										Date endDate1=(Date)dates.get(startDate1);
										if(displaySchedule) 
										{
%>
			<tr>
				<td valign="top" class="cell_border3" align="left" style="border-left-width:1px;"><egui:intnl text="admin.mpolicy.Next Schedule Date"/></td>
				<td  valign="top" class="cell_border3" rowspan="<%=unplannedpoldetails.size()%>" style=";border-right-width:1px;">
<%
											if(endDate1.before(new Date()) || endDate1.equals(new Date()))
											{
												out.println("Completed");
											}
											else if(startDate1.getDate()==endDate1.getDate() && startDate1.getMonth()==endDate1.getMonth() && startDate1.getYear()==endDate1.getYear()) 
											{
												SimpleDateFormat simpleDateFmt1=new SimpleDateFormat("H:mm");
												out.println(simpleDateFmt.format(startDate1)+"-"+simpleDateFmt1.format(endDate1));
											}
											else
											{
												out.println(simpleDateFmt.format(startDate1)+"-"+simpleDateFmt.format(endDate1));
											}
											displaySchedule=false;

%>
				</td>
			</tr>
<%										}

									}
%>
			
		</table>
<%								}
							}
							if(isElementUnderPlannedMaintenance)
							{
%>
		<br>
		<table width="100%"  border="0" align="center" cellpadding="4" cellspacing="0" class="line square2"><col width="50%"><col width="50%">
<%							if(isElementUnderPlannedMaintenance && isElementUnderUnPlannedMaintenance)
								{
%>
			<tr>
				<td colspan="3" class="eg_blankspace" height="8px">&nbsp;</td>
			</tr>
<%
								}
%>
			<tr>
				<td  colspan="4" style="padding:0px">
					<table width="100%" border="0" cellpadding="0" cellspacing="0"  height="20">
						<tr>
							<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
							<td width="100%" align="left" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px"><strong><%=dispMsg%></strong></td>
							<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
						</tr>
					</table>
				</td>
			</tr>
<%							Iterator htr=details.keySet().iterator();
								boolean displaySchedule=true;
								while(htr.hasNext())
								{
									String key=(String)htr.next();
									Vector value=(Vector)details.get(key);
%>
			<tr>
				<td valign="top" class="cell_border4" align="left" width="50%"><egui:intnl text="admin.mpolicy.Group Name"/></td>
				<td valign="top" class="cell_border4 <%=fontStyleDblSingl%>" style="border-top-width:0px" width="50%"><%=key%></td>
			</tr>
			
				
<%
									StringBuffer sb=new StringBuffer();
									for(int i=0;i<value.size();i++) 
									{
										String policy=(String)value.get(i);
										sb.append(policy);
										if(i<value.size()-1)
											sb.append(",");
									}
%>
			<tr>
				<td valign="top" class="cell_border3" align="left"><egui:intnl text="admin.mpolicy.Policy Name"/></td>
				<td valign="top" class="cell_border3 <%=fontStyleDblSingl%>"> <span style="line-height:12pt;"><%=sb.toString()%> </span></td>
			</tr>
			<tr>
				<td valign="top" class="cell_border4" align="left"><egui:intnl text="admin.mpolicy.Timeline"/></td>
				<td class="cell_border4">
					<table cellpadding="2px" cellspacing="0px" border="0" width="100%" class="tableborder_ad" style="border-bottom-width:0px"><col width="170px"><col width="110px">
<%								for(int i=0;i<value.size();i++) 
								{
									String policy=(String)value.get(i);
									Hashtable timeDetails=egM.getPolicyTimeLines(policy);
									Iterator itr=timeDetails.keySet().iterator();
									while(itr.hasNext()) 
									{
										String timeKey=(String)itr.next();
										Vector timeVal=(Vector)timeDetails.get(timeKey);
%>
						<tr>
							<td class=" cell_border4"><%=timeKey%></td>
							<td class=" cell_border4">
								<table cellpadding="0px" cellspacing="0px" border="0" width="100%">
<%
										for(int k=0;k<timeVal.size();k++) 
										{
											String time=(String)timeVal.get(k);
%>
									<tr>
										<td><%=time%></td>
									</tr>
<%
										}
%>
								</table>
							</td>
						</tr>
<%
									}
								}
%>	
					</table>
				</td>
			</tr>
<%
%>
			
<%
								Hashtable dates=new Hashtable();
								if(option.equals("Test") || option.equals("Descriptor"))
								{
									dates=egM.getNextScheduleTimeForTest(element);
								} 
								else if(option.equals("Test For Host") || option.equals("Test  For Component") || option.equals("Descriptor For Component"))
								{
									if(option.equals("Descriptor For Component"))
									{
										Vector elementnames=new Vector();
										elementnames=egM.getAssociatedHostsOrComponentsForTests(descElement);
										 dates=egM.getNextScheduleTimeForHosttestOrComponenttest(descElement,elementnames);
									}
									else
									{
										Vector elementNames=new Vector();
										elementNames.add(testElement);
										dates=egM.getNextScheduleTimeForHosttestOrComponenttest(element,elementNames);
									}
								}
								else if(option.equals("Host") || option.equals("Components")  || option.equals("Component"))
								{
									dates=egM.getNextScheduleTimeForHost(element);
								}
								if(dates!=null) 
								{
									SimpleDateFormat simpleDateFmt=new SimpleDateFormat(currentDateFormat+" "+"H:mm");
									Date startDate2=(Date)dates.keySet().iterator().next();
									Date endDate2=(Date)dates.get(startDate2);
									if(displaySchedule) {
%>
			<tr>
				<td valign="top" class="cell_border3" align="left"><egui:intnl text="admin.mpolicy.Next Schedule Date"/></td>
				<td  valign="top" class="cell_border3" rowspan="<%=details.size()%>" style="border-top-width:0px">
<%
									if(endDate2.before(new Date()) || endDate2.equals(new Date()))
									{
										out.println("Completed");
									}
									else if(startDate2.getDate()==endDate2.getDate() && startDate2.getMonth()==endDate2.getMonth() && startDate2.getYear()==endDate2.getYear()) 
									{
										SimpleDateFormat simpleDateFmt1=new SimpleDateFormat("H:mm");
										out.println(simpleDateFmt.format(startDate2)+"-"+simpleDateFmt1.format(endDate2));
									}
									else
									{
										out.println(simpleDateFmt.format(startDate2)+"-"+simpleDateFmt.format(endDate2));
									}
									displaySchedule=false;
%>
								</td>
<%
									}
								}
%>
			</tr>
				</table>
<%
								}
							}
%>
<%				}
	} 
	else 
	{
%>
		<table align="center" width="80%" cellpadding="0" cellspacing="0" border="0" valign="middle" height="200">
			<tr>
				<td align="center"  width="100%"  valign="bottom"><img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif">
				</td>
			</tr>
			<tr>
				<td align="center" width="100%" valign="top">
					<egui:intnl text="admin.mpolicy.No Data Found"/>
				</td>
			</tr>
		</table>
		<input type="hidden" id="printData" name="printData" value="noData" />
		<input type="hidden" id="pdfData" name="pdfData" value="noData" />
		<input type="hidden" id="csvData" name="csvData" value="noData" />
<%
	}
}
else
{
	if(isData)
	{
		if(data!=null && data.size()>0)
		{
%>
		<table  width="100%"  border="0" align="center" cellpadding="0" cellspacing="0" >
		<col width="50%"><col width="50%">
<%
			for(int k=0;k<data.size();k++) 
			{
				Hashtable temp1=(Hashtable)data.get(k);
				Hashtable mappedAnalysisData=new Hashtable();
				Hashtable mappedkeys=new Hashtable();
				if(temp1!=null)
				{
					Iterator mappitr=temp1.keySet().iterator();
					while(mappitr.hasNext()) 
					{
						String mapkey=(String)mappitr.next();
						String dispval="";
						if(k!=3 && k!=4 && k!=6)
						{
							Hashtable mapval=(Hashtable)temp1.get(mapkey);
							if(k!=3 && k!=4 && k!=2)
							{
								dispval=mapkey;//_mapping.getComponentTypeDescription(mapkey);
							}
							else
							{
								dispval=_mapping.getTestDescription(mapkey);
							}
							mappedAnalysisData.put(dispval,mapval);
							mappedkeys.put(dispval,mapkey);
						}
						else
						{
							if(k==6)
							{
								dispval=mapkey;
							}
							else
							{
								dispval=_mapping.getTestDescription(mapkey);
							}
							Vector mapvalvec=(Vector)temp1.get(mapkey);
							mappedAnalysisData.put(dispval,mapvalvec);
							mappedkeys.put(dispval,mapkey);
						}
					}
				}
				temp1=mappedAnalysisData;
				TreeMap temp=new TreeMap(temp1);
				String tableTitle="";
				String colName="";
				String dataOptionName="";
				String bookMark="";
				String divname="";
				if(colName!=null && !colName.equals("")) 
				{
					divname=colName.substring(0,4)+"div";
				}
				Vector keys=new Vector();
				keys.addAll(temp.keySet());
				Collections.sort(keys,String.CASE_INSENSITIVE_ORDER);
				Iterator itr1=keys.iterator();
				Vector  hashValue1=null;
				Iterator itr2=null;
				Hashtable timeDur1=null;
				int hCount=0;
				int cCount=0;
				int testCount=0;
				int htCount=0;
				int ctCount=0;
				int descCount=0;
				int cdCount=0;
				while(itr1.hasNext())
				{
					String dispallkey=(String)itr1.next();
					String allkey=(String)mappedkeys.get(dispallkey);
					String dispMsg1="";
					String dispStr="";
					String tmpOption="";
					if(k==0) 
					{
						tmpOption="Host";
						tableTitle="Hosts Under Maintenance";
						colName="Host Name";
						dataOptionName="Host";
						bookMark="hostBookMark";
						String policyName="-";
						String groupName="-";
						if(hCount<=0)
						{
%>
			<tr>
				<td colspan="2" align="center" width="100%" >
					<table id="<%=bookMark%>" width="100%" border="0" cellpadding="0" cellspacing="0" height="20">
						<tr>
							<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
							<td width="100%" align="left" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px">
							<strong><egui:intnl text="<%="admin.mpolicy."+tableTitle%>"/></td>
							<!-- <td height="20" style="width:20px" align="center" id="eg_subheadbg"><img id="arrowImg" src="/final/admin/eg_images/down.gif" onclick="showContents('<%//=divname%>',this);"></td> -->
							<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
						</tr>
					</table>
				</td>
			</tr>
<%
						}
						
%>
			<tr>
<%
						String cellstyle="padding-bottom:8px;border-bottom-width:1px;border-top-width:0px;";
						if(itr1.hasNext())
						{
							 cellstyle="padding-bottom:0px;border-bottom-width:0px;border-top-width:0px;";
						}

%>
				<td colspan="2" width="100%" class="space8 linesquare" style="<%=cellstyle%>">
					<table  id="<%=divname%>" width="100%"  border="0" align="left" cellpadding="4" cellspacing="0" style="table-layout:fixed">
<%
						if(allkey.indexOf("$")>-1 && allkey.indexOf("&")>-1)
						{
							dispStr=allkey.substring(0,allkey.indexOf("&"));
							groupName=allkey.substring(allkey.indexOf("&")+1,allkey.indexOf("$"));
							policyName=allkey.substring(allkey.indexOf("$")+1);
						}
						else if(allkey.indexOf("$")>-1)
						{
							dispStr=allkey.substring(0,allkey.indexOf("$"));
							policyName=allkey.substring(allkey.indexOf("$")+1);
						}
						else if(allkey.indexOf("&")>-1)
						{
							dispStr=allkey.substring(0,allkey.indexOf("&"));
							groupName=allkey.substring(allkey.indexOf("&")+1);
						}
						else
						{
							dispStr=allkey;
						}
						if(dispStr.endsWith(":NULL"))
						{
							dispStr = dispStr.substring(0,dispStr.indexOf(":NULL"));
						}
%>
						<tr>
							<td colspan="2" class="table_head" align="left" width="50%" style="text-align:left;"><span class="<%=fontStyleDblSingl%>">&nbsp;<%=dispStr%>&nbsp;</span></td>
						</tr>
<%
	if(policyName!=null && !policyName.equals("-"))
	{
%>
						<tr>
							<td class="cell_border3"  align="left" style="border-left-width:1px;border-right-width:0px" width="50%"><egui:intnl text="admin.mpolicy.PolicyName"/></td>
							<td class="cell_border3 <%=fontStyleDblSingl%>" style="border-left-width:1px"><%=policyName%>
							</td>
						</tr>
<%
	}

	String cellborder3="cell_border3";
	String cellborder4="cell_border4";
	if(groupName!=null && !groupName.equals("-"))
	{
		cellborder4="cell_border3";
		cellborder3="cell_border4";
%>
						<tr>
							<td class="cell_border4"  align="left"style="border-left-width:1px;border-right-width:0px" ><egui:intnl text="admin.mpolicy.GroupName"/></td>
							<td class="cell_border4 <%=fontStyleDblSingl%>" style="border-left-width:1px"><%=groupName%>
							</td>
						</tr>
<%
	}
%>
						<tr>
							<td class="<%=cellborder4%>"  align="left" style="border-left-width:1px;border-right-width:0px"><egui:intnl text="admin.mpolicy.Status"/></td>
							<td class="<%=cellborder4%>" valign="top" style="border-top-width:0px;border-left-width:1px" align="left">
<%
								boolean isActive=false;
								isActive=egM.isServerElementInUnderMintenance("Host",dispStr);
								if(isActive)
								{
										out.println("Active");
								}
								else
								{
										out.println("Inactive");
								}
%>
							</td>
						</tr>
<%
						timeDur1=(Hashtable)temp.get(dispallkey);
						itr2=timeDur1.keySet().iterator();
						Hashtable tmptable=new Hashtable(temp);
						if(allkey.indexOf("$")>-1 && allkey.indexOf("&")>-1)
						{
							allkey=allkey.substring(0,allkey.indexOf("&"));
						}
						else if(allkey.indexOf("$")>-1)
						{
							allkey=allkey.substring(0,allkey.indexOf("$"));
						}
						else if(allkey.indexOf("&")>-1)
						{
							allkey=allkey.substring(0,allkey.indexOf("&"));
						}
						String nextSchDate=getNextScheduleDateForCsv(tmpOption,tmptable,allkey, dispallkey,egM,currentDateFormat);
%>
			<tr>
				<td colspan="2" style="padding:0px;" >
					<table  id="" width="100%"  border="0" align="center" cellpadding="0" cellspacing="0">
						<tr>
							<td class="<%=cellborder3%>"  style="border-left-width:1px;padding-left:3px;border-right-width:0px" align="left" ><egui:intnl text="admin.mpolicy.TimeLine"/></td>
							<td class="<%=cellborder3%>" valign="top" width="50%" style="border-left-width:1px;padding:0px;border-right-width:0px;padding-left:0px">
								<table width="100%"  border="0" align="left" cellpadding="0" cellspacing="0" >
									<col width="50%"><col width="50%">
<%
						String timeLine=getTimeLineForCsv(tmptable,dispallkey,egM);
						String dispCol1="";
						String timeMsg1="";
						if(timeLine!=null && timeLine.indexOf(",")>0)
						{
							StringTokenizer st=new StringTokenizer(timeLine,",");
							
							while(st.hasMoreTokens())
							{
								int noOfTokens=st.countTokens();
								String tok=st.nextToken();
								dispCol1=tok.substring(0,tok.indexOf(" "));
								timeMsg1=tok.substring(tok.indexOf(" ")+1);
								String cellborder="border-bottom-width:1px";
								if(noOfTokens==1)
								{
									cellborder="border-bottom-width:0px";
								}
%>
									<tr>
										<td valign="top"  width="50%" align="left" class="<%=cellborder3%>" style="<%=cellborder%>"><span class="<%=fontStyleDblSingl%>">&nbsp;<%=dispCol1%>&nbsp;</span></td>
										<td valign="top"  width="50%" class="<%=cellborder3%>" style="<%=cellborder%>">
											<table width="100%"  border="0" align="center" cellpadding="2" 	cellspacing="0">
												<tr>
													<td><span class="<%=fontStyleDblSingl%>">&nbsp;<%=timeMsg1%>&nbsp;</span></td>
												</tr>
											</table>
										</td>
									</tr>
<%

							}
						}
						else
						{
							dispCol1=timeLine.substring(0,timeLine.lastIndexOf(" "));
							timeMsg1=timeLine.substring(timeLine.lastIndexOf(" ")+1);
%>
									<tr>
										<td valign="top"  width="50%"><span class="<%=fontStyleDblSingl%>">&nbsp;<%=dispCol1%>&nbsp;</span></td>
										<td valign="top"  width="50%">

											<table width="100%"  border="0" align="left" cellpadding="0" 	cellspacing="0">

												<tr>
													<td><span class="<%=fontStyleDblSingl%>">&nbsp;<%=timeMsg1%>&nbsp;</span></td>
												</tr>

											</table>
										</td>
									</tr>
<%
						}
%>
								</table>
							</td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td class="<%=cellborder4%>" style="padding-left:3px;border-left-width:1px;border-right-width:0px" class="<%=cellborder4%>">
					<egui:intnl text="admin.mpolicy.NextScheduleDate"/></td>
				<td class="<%=cellborder4%>" style="border-left-width:1px">
								<table  id="" width="100%"  border="0" align="center" cellpadding="2" cellspacing="0">
									<tr>
										<!-- <td align="left"></td> -->
										<td  valign="top" rowspan="0" >
<%
								out.println(nextSchDate);
%>
										</td>
									</tr>
								</table>
				</td>
			</tr>
					</table>
				</td>
			</tr>

<%
						hCount++;
					}
					else if(k==1)
					{
						tmpOption="Component";
						tableTitle="Components  Under Maintenance";
						colName="Component Name";
						dataOptionName="Components";
						bookMark="componentBookMark";
						String disp="";
						String policyName="-";
						String groupName="-";
						if(dispallkey.indexOf("$")>-1 && dispallkey.indexOf("&")>-1)
						{
							disp=dispallkey.substring(0,dispallkey.indexOf("&"));
							groupName=dispallkey.substring(dispallkey.indexOf("&")+1,dispallkey.indexOf("$"));
							policyName=dispallkey.substring(dispallkey.indexOf("$")+1);
						}
						else if(dispallkey.indexOf("$")>-1)
						{
							disp=dispallkey.substring(0,dispallkey.indexOf("$"));
							policyName=dispallkey.substring(dispallkey.indexOf("$")+1);
						}
						else if(dispallkey.indexOf("&")>-1)
						{
							disp=dispallkey.substring(0,dispallkey.indexOf("&"));
							groupName=dispallkey.substring(dispallkey.indexOf("&")+1);
						}
						else
						{
							disp=dispallkey;
						}
						//component under maintenance
						if(disp.endsWith(":NULL"))
						{
							disp = disp.substring(0,disp.indexOf(":NULL"));
						}
						if(disp!=null)
							dispStr=disp;
						if(cCount==0)
						{

%>
			<tr>
				<td colspan="2" height="20" align="center" width="100%" style="padding-top:20px">
					<table id="<%=bookMark%>" width="100%" border="0" cellpadding="0" cellspacing="0" height="20">
						<tr>
							<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
							<td width="100%" align="left" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px">
							<strong><egui:intnl text="<%="admin.mpolicy."+tableTitle%>"/></td>
							<!-- <td height="20" style="width:20px" align="center" id="eg_subheadbg"><img id="arrowImg" src="/final/admin/eg_images/down.gif" onclick="showContents('<%//=divname%>',this);"></td> -->
							<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
						</tr>
					</table>
				</td>
			</tr>
<%
						}
						String cellstyle="padding-bottom:8px;border-bottom-width:1px;border-top-width:0px;";
						if(itr1.hasNext())
						{
							 cellstyle="padding-bottom:0px;border-bottom-width:0px;border-top-width:0px;";
						}
%>
			<tr>
				<td colspan="2" width="100%" class="space8 linesquare" style="<%=cellstyle%>">
					<table id="<%=divname%>" width="100%" border="0" align="left" cellpadding="4" cellspacing="0" style="table-layout:fixed">
						<tr>
							<td colspan="2" class="table_head <%=fontStyleDblSingl%>"  width="50%" align="left"  style="text-align:left;"><%=disp%></td>
						</tr>
<%
	if(policyName!=null && !policyName.equals("-"))
	{
%>
						<tr>
							<td class="cell_border3"  align="left" style="border-left-width:1px;border-right-width:0px" width="50%"><egui:intnl text="admin.mpolicy.PolicyName"/></td>
							<td class="cell_border3 <%=fontStyleDblSingl%>" style="border-left-width:1px"><%=policyName%>
							</td>
						</tr>
<%
	}
	String cellborder3="cell_border3";
	String cellborder4="cell_border4";
	if(groupName!=null && !groupName.equals("-"))
	{
		cellborder4="cell_border3";
		cellborder3="cell_border4";
%>
						<tr>
							<td class="cell_border4"  align="left"style="border-left-width:1px;border-right-width:0px" ><egui:intnl text="admin.mpolicy.GroupName"/></td>
							<td class="cell_border4 <%=fontStyleDblSingl%>" style="border-left-width:1px"><%=groupName%>
							</td>
						</tr>
<%
	}
%>
						<tr>
							<td class="<%=cellborder4%>" style="border-left-width:1px;border-right-width:0px" align="left" ><egui:intnl text="admin.mpolicy.Status"/></td>
							<td class="<%=cellborder4%>" style="border-left-width:1px">
<%
								boolean isActive=false;
								if(k==5)
								{
									isActive=egM.isServerElementInUnderMintenance("Test",disp);
								}
								else
								{
									isActive=egM.isServerElementInUnderMintenance("Host",disp);
								}
								if(isActive)
								{
										out.println("Active");
								}
								else
								{
										out.println("Inactive");
								}
%>
							</td>
						</tr>
<%
						timeDur1=(Hashtable)temp.get(dispallkey);
						itr2=timeDur1.keySet().iterator();
						Hashtable tmptable=new Hashtable(temp);
						if(allkey.indexOf("$")>-1 && allkey.indexOf("&")>-1)
						{
							allkey=allkey.substring(0,allkey.indexOf("&"));
						}
						else if(allkey.indexOf("$")>-1)
						{
							allkey=allkey.substring(0,allkey.indexOf("$"));
						}
						else if(allkey.indexOf("&")>-1)
						{
							allkey=allkey.substring(0,allkey.indexOf("&"));
						}
						String nextSchDate=getNextScheduleDateForCsv(tmpOption,tmptable,allkey, dispallkey,egM,currentDateFormat);
%>
			<tr>
				<td style="border-left-width:1px;padding-left:3px;border-right-width:0px" class="<%=cellborder3%>" >
					<egui:intnl text="admin.mpolicy.TimeLine"/>
				</td>
				<td class="<%=cellborder3%>" valign="top" width="50%" style="padding-left:0px;border-left-width:1px;">
					<table width="100%" align="left" cellpadding="0" cellspacing="0" >
						<col width="50%"><col width="50%">
<%
						String timeLine=getTimeLineForCsv(tmptable,dispallkey,egM);
						String dispCol1="";
						String timeMsg1="";
						if(timeLine!=null && timeLine.indexOf(",")>0)
						{
							StringTokenizer st=new StringTokenizer(timeLine,",");
							

							while(st.hasMoreTokens())
							{
								int noOfTokens=st.countTokens();
								String tok=st.nextToken();
								dispCol1=tok.substring(0,tok.indexOf(" "));
								timeMsg1=tok.substring(tok.indexOf(" ")+1);
								String cellborder="border-bottom-width:1px";
								if(noOfTokens==1)
								{
									cellborder="border-bottom-width:0px";
								}
%>
									<tr>
										<td valign="top"  style="padding-left:0px" width="50%" align="left" class="<%=cellborder3%>" style="<%=cellborder%>"><span class="<%=fontStyleDblSingl%>"><%=dispCol1%>&nbsp;</span></td>
										<td valign="top"  width="50%" class="<%=cellborder3%>" style="<%=cellborder%>">

											<table width="100%"  border="0" align="center" cellpadding="4" 	cellspacing="0">

												<tr>
													<td><span class="<%=fontStyleDblSingl%>">&nbsp;<%=timeMsg1%>&nbsp;</span></td>
												</tr>

											</table>
										</td>
									</tr>
<%
							}
						}
						else
						{
							dispCol1=timeLine.substring(0,timeLine.lastIndexOf(" "));
							timeMsg1=timeLine.substring(timeLine.lastIndexOf(" ")+1);

							String cellborder="border-bottom-width:0px";
%>
									<tr>
										<td valign="top"  width="50%" class="<%=cellborder3%>" style="<%=cellborder%>"><span class="<%=fontStyleDblSingl%>">&nbsp;<%=dispCol1%>&nbsp;</span></td>
										<td valign="top"  width="50%" class="<%=cellborder3%>" style="<%=cellborder%>">

											<table width="100%"  border="0" align="left" cellpadding="0" 	cellspacing="0">

												<tr>
													<td><span class="<%=fontStyleDblSingl%>">&nbsp;<%=timeMsg1%>&nbsp;</span></td>
												</tr>

											</table>
										</td>
									</tr>
<%
						}
%>
								</table>
				</td>
			</tr>
			<tr>
				<td style="padding-left:3px;border-left-width:1px;border-right-width:0px" class="<%=cellborder4%>">
					<egui:intnl text="admin.mpolicy.NextScheduleDate"/>
				</td>
				<td class="<%=cellborder4%>" style="border-left-width:1px;">
						<table  id="" width="100%"  border="0" align="center" cellpadding="0" cellspacing="0">
							<tr>
								<!-- <td align="left"></td> -->
								<td  valign="top" >
<%
						out.println(nextSchDate);
%>
								</td>
							</tr>
						</table>
							
				</td>
			</tr>
			</table>
		</td>
	</tr>
			
<%
						cCount++;
					}
					else if(k==2) 
					{
						tmpOption="Test";
						tableTitle="Tests  Under Maintenance";
						colName="Test Name";
						dataOptionName="Test";
						bookMark="testBookMark";
						String policyName="-";
						String groupName="-";
						String displayStr="";

						if(dispallkey.indexOf("$")>-1 && dispallkey.indexOf("&")>-1)
						{
							displayStr=dispallkey.substring(0,dispallkey.indexOf("&"));
							groupName=dispallkey.substring(dispallkey.indexOf("&")+1,dispallkey.indexOf("$"));
							policyName=dispallkey.substring(dispallkey.indexOf("$")+1);
						}
						else if(dispallkey.indexOf("$")>-1)
						{
							displayStr=dispallkey.substring(0,dispallkey.indexOf("$"));
							policyName=dispallkey.substring(dispallkey.indexOf("$")+1);
						}
						else if(dispallkey.indexOf("&")>-1)
						{
							displayStr=dispallkey.substring(0,dispallkey.indexOf("&"));
							groupName=dispallkey.substring(dispallkey.indexOf("&")+1);
						}
						else
						{
							displayStr=dispallkey;
						}
						if(displayStr!=null)
							dispStr=displayStr;
						if(testCount==0)
						{
%>
			<tr>
				<td colspan="2" height="20" align="center" width="100%" style="padding-top:20px">
					<table id="<%=bookMark%>" width="100%" border="0" cellpadding="0" cellspacing="0" height="20">
						<tr>
							<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
							<td width="100%" align="left" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px">
							<strong><egui:intnl text="<%="admin.mpolicy."+tableTitle%>"/></td>
							<!-- <td height="20" style="width:20px" align="center" id="eg_subheadbg"><img id="arrowImg" src="/final/admin/eg_images/down.gif" onclick="showContents('<%//=divname%>',this);"></td> -->
							<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
						</tr>
					</table>
				</td>
			</tr>
<%
						}
						String cellstyle="padding-bottom:8px;border-bottom-width:1px;border-top-width:0px;";
						if(itr1.hasNext())
						{
							 cellstyle="padding-bottom:0px;border-bottom-width:0px;border-top-width:0px;";
						}
%>
			<tr>
				<td colspan="2" width="100%" class="space8 linesquare" style="<%=cellstyle%>">
					<table   id="<%=divname%>" width="100%"  border="0" align="left" cellpadding="4" cellspacing="0" style="table-layout:fixed">
						<tr>
							<td class="table_head <%=fontStyleDblSingl%>" colspan="2" valign="top" style="text-align:left;" width="50%"><%=displayStr%></td>
						</tr>
<%
	if(policyName!=null && !policyName.equals("-"))
	{
%>
						<tr>
							<td class="cell_border3"  align="left" style="border-left-width:1px;border-right-width:0px" width="50%"><egui:intnl text="admin.mpolicy.PolicyName"/></td>
							<td class="cell_border3 <%=fontStyleDblSingl%>" style="border-left-width:1px"><%=policyName%>
							</td>
						</tr>
<%
	}
	String cellborder3="cell_border3";
	String cellborder4="cell_border4";
	if(groupName!=null && !groupName.equals("-"))
	{
		cellborder4="cell_border3";
		cellborder3="cell_border4";
%>
						<tr>
							<td class="cell_border4"  align="left"style="border-left-width:1px;border-right-width:0px" ><egui:intnl text="admin.mpolicy.GroupName"/></td>
							<td class="cell_border4 <%=fontStyleDblSingl%>" style="border-left-width:1px"><%=groupName%>
							</td>
						</tr>
<%
	}
%>
						<tr>
							<td class="<%=cellborder4%>"  align="left" style="border-left-width:1px;border-right-width:0px"><egui:intnl text="admin.mpolicy.Status"/></td>
							<td class="<%=cellborder4%>" style="border-left-width:1px">
<%
								boolean isActive=false;
								if(k==2)
								{
								isActive=egM.isServerElementInUnderMintenance("Test",displayStr);
								}
								else
								{
								isActive=egM.isServerElementInUnderMintenance("Test For Host",displayStr);
								}
								if(isActive)
								{
										out.println("Active");
								}
								else
								{
										out.println("Inactive");
								}
%>
							</td>
						</tr>
						<tr>
							<td class="<%=cellborder3%>"  style="border-left-width:1px;border-right-width:0px" align="left"><egui:intnl text="admin.mpolicy.TimeLine" /></td>
							<td class="<%=cellborder3%>" valign="top" style="padding:0px;border-left-width:1px;border-top-width:0px;">
								<table width="100%"  border="0" align="left" cellpadding="0" cellspacing="0" >
									<col width="50%"><col width="50%">
<%
										Vector timeColumn1=new Vector();
										String timeKey1="";
										timeDur1=(Hashtable)temp.get(dispallkey);
										itr2=timeDur1.keySet().iterator();
										while(itr2.hasNext())
										{
											timeKey1=(String)itr2.next();
											timeColumn1.add(timeKey1);
										}
											String dispCol1="";
											for(int m=0;m<timeColumn1.size();m++)
											{
												String colName1=(String)timeColumn1.get(m);

												String cellborder="border-bottom-width:1px";
												if(timeColumn1.size()==1)
												{
													cellborder="border-bottom-width:0px";
												}
												if(colName1.equals("FDM"))
												{
													dispCol1="First Day Of Month";
												}
												else if(colName1.equals("LDM"))
												{
													dispCol1="Last Day Of Month";
												}
												else if(colName1.equals("*"))
												{
													dispCol1="Daily";
												}
												else if(colName1.equals("Sun") || colName1.equals("Mon") || colName1.equals("Tue") || colName1.equals("Wed") || colName1.equals("Thu") || colName1.equals("Fri") || colName1.equals("Sat"))
												{
													dispCol1=egM.DayForDescription(colName1);
												}
												else
												{
													dispCol1=colName1.replace('|','-');
											
												}
%>
												<tr>
<%
												if(m%2==0)
												{
%>
													<td style="padding-left:0px;" align="left" width="50%" class="<%=cellborder3%>" style="<%=cellborder%>"><span class="<%=fontStyleDblSingl%>">&nbsp;<%=dispCol1%>&nbsp;</span></td>
													<td width="50%" align="left" class="<%=cellborder3%>" style="<%=cellborder%>">
<%
												}
												else
												{
%>
													<td width="50%" align="left" class="<%=cellborder3%>" style="<%=cellborder%>"><span class="<%=fontStyleDblSingl%>" >&nbsp;<%=dispCol1%>&nbsp;</span></td>
													<td width="60%" align="left" class="<%=cellborder3%>" style="<%=cellborder%>">
<%
												}
%>
														<table width="100%"  border="0" align="center" cellpadding="4" cellspacing="0" >
<%
															Vector  timeVal1=(Vector)timeDur1.get(colName1);
															if(timeVal1!=null && timeVal1.size()>0)
															{
																for(int n=0;n<timeVal1.size();n++)
																{
																String time1=(String)   timeVal1.get(n);
																String startTime1=time1.substring(0,time1.indexOf("-"));
																String endTime1=time1.substring(time1.indexOf("-")+1,time1.length());
																String timeMsg1=startTime1+"-"+endTime1;
%>
															<tr>
																<td><span class="<%=fontStyleDblSingl%>">&nbsp;<%=timeMsg1%>&nbsp;</span></td>
															</tr>
<%
																	}
															}
%>
														</table>
													</td>
												</tr>
<%
											}
%>
								</table>
							</td>
						</tr>
						<tr>
							<td class="<%=cellborder4%>"  style="border-left-width:1px;border-right-width:0px" align="left"><egui:intnl text="admin.mpolicy.NextScheduleDate"/></td>
							<td  valign="top" class="<%=cellborder4%>" rowspan="0" style="border-left-width:1px;border-top-width:0px">
<%
								Hashtable dates=new Hashtable();
								
								dates=egM.getNextScheduleTimeForTest(dispStr);
								if(dates!=null && dates.size()==0)
									dates=egM.getUnplannedNextScheduleTimeForTest(dispStr);
								
								if(dates!=null && dates.size()>0)  
								{
									SimpleDateFormat simpleDateFmt=new SimpleDateFormat(currentDateFormat+" "+"H:mm");
									Date startDate1=(Date)dates.keySet().iterator().next();
									Date endDate1=(Date)dates.get(startDate1);
									if(endDate1.before(new Date()) || endDate1.equals(new Date()))
									{
										out.println("Completed");
									}
									else if(startDate1.getDate()==endDate1.getDate() && startDate1.getMonth()==endDate1.getMonth() && startDate1.getYear()==endDate1.getYear()) 
									{
										SimpleDateFormat simpleDateFmt1=new SimpleDateFormat("H:mm");
										out.println(simpleDateFmt.format(startDate1)+"-"+simpleDateFmt1.format(endDate1));
									}
									else
									{
										out.println(simpleDateFmt.format(startDate1)+"-"+simpleDateFmt.format(endDate1));
									}
								}
					
%>
								
							</td>
						</tr>
					</table>
					
				</td>
			</tr>
<%
						testCount++;
					}
					else if(k==3) 
					{
						
						tmpOption="Test For Host";
						tableTitle="Host Tests  Under Maintenance";
						colName="Test Name";
						dataOptionName="Test For Host";
						bookMark="hostTestBookMark";
						String cname="";
						String policyName="-";
						String groupName="-";
						if(k==3) 
						{
							cname="Host";
						}
						else
						{
							cname="Component";
						}
						hashValue1=(Vector)temp.get(dispallkey);
						Vector  comps1=(Vector)hashValue1.get(0);
						
						String cellborder3="cell_border3";
						String cellborder4="cell_border4";
						
						if(comps1!=null && comps1.size()>0)
						{
							String disp1="";
							if(dispallkey!=null && dispallkey.indexOf(":")>-1)
							{
								if(dispallkey.indexOf("$")>-1 && dispallkey.indexOf("&")>-1)
								{
									disp1=dispallkey.substring(0,dispallkey.indexOf("&"));
									groupName=dispallkey.substring(dispallkey.indexOf("&")+1,dispallkey.indexOf("$"));
									policyName=dispallkey.substring(dispallkey.indexOf("$")+1);
								}
								else if(dispallkey.indexOf("$")>-1)
								{
									disp1=dispallkey.substring(dispallkey.indexOf(":")+1,dispallkey.indexOf("$"));
									policyName=dispallkey.substring(dispallkey.indexOf("$")+1);
								}
								else if(dispallkey.indexOf("&")>-1)
								{
									disp1=dispallkey.substring(dispallkey.indexOf(":")+1,dispallkey.indexOf("&"));
									groupName=dispallkey.substring(dispallkey.indexOf("&")+1);
								}
								else
								{
									disp1=dispallkey.substring(dispallkey.indexOf(":")+1);
								}
							}
							else
							{
								if(dispallkey.indexOf("$")>-1 && dispallkey.indexOf("&")>-1)
								{
									disp1=dispallkey.substring(0,dispallkey.indexOf("$"));
									groupName=dispallkey.substring(dispallkey.indexOf("&")+1,dispallkey.indexOf("$"));
									policyName=dispallkey.substring(dispallkey.indexOf("$")+1);
								}
								else if(dispallkey.indexOf("$")>-1)
								{
									disp1=dispallkey.substring(0,dispallkey.indexOf("$"));
									policyName=dispallkey.substring(dispallkey.indexOf("$")+1);
								}
								else if(dispallkey.indexOf("&")>-1)
								{
									disp1=dispallkey.substring(0,dispallkey.indexOf("&"));
									groupName=dispallkey.substring(dispallkey.indexOf("&")+1);
								}
								else
								{
									disp1=dispallkey;
								}
							}
							if(disp1!=null)
								dispStr=disp1;
							if(htCount==0)
							{
%>
			<tr>
				<td colspan="3" height="20" align="center" width="100%" style="padding-top:10px">
					<table  id="<%=bookMark%>" width="100%" border="0" cellpadding="0" cellspacing="0" height="20">
						<tr>
							<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
							<td width="100%" align="left" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px">
							<strong><egui:intnl text="<%="admin.mpolicy."+tableTitle%>"/></td>
							<!-- <td height="20" style="width:20px" align="center" id="eg_subheadbg"><img src="/final/admin/eg_images/down.gif" onclick="showContents('<%//=cname+"tests"%>',this);"></td> -->
							<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
						</tr>
					</table>
				</td>
			</tr>
<%
							}
							String cellstyle="padding-bottom:8px;border-bottom-width:1px;border-top-width:0px;";
							if(itr1.hasNext())
							{
							cellstyle="padding-bottom:0px;border-bottom-width:0px;border-top-width:0px;";
							}
%>
			<tr>
				<td colspan="2" width="100%" class="space8 linesquare" style="<%=cellstyle%>">
					<table  id="<%=cname+"tests"%>" width="100%"  border="0" align="left" cellpadding="4" cellspacing="0" style="table-layout:fixed">
						<tr>
							<td class="table_head <%=fontStyleDblSingl%>" colspan="2" align="left" style="text-align:left;padding:2px;border-right-width:0px" width="50%"><%=disp1%></td>
						</tr>
						<tr>
							<td class="cell_border3 <%=fontStyleDblSingl%>" style="border-left-width:1px;border-right-width:0px" align="left"><%=cname%></td>
							<td class="cell_border3" style="border-left-width:1px">
								<table cellpadding="0" cellspacing="0" border="0" >
<%
								for(int c1=0;c1<comps1.size();c1++)
								{
									String host1=(String)comps1.get(c1);
									if(host1.endsWith(":NULL"))
										host1=host1.substring(0,host1.lastIndexOf(":"));
%>
									<tr><td valign="top" class="<%=fontStyleDblSingl%>"><%=host1%></td></tr>
<%
								}
%>
								</table>
							</td>
						</tr>
<%
	if(policyName!=null && !policyName.equals("-"))
	{
%>
						<tr>
							<td class="cell_border4"  align="left" style="border-left-width:1px;border-right-width:0px"><egui:intnl text="admin.mpolicy.PolicyName"/></td>
							<td class="cell_border4 <%=fontStyleDblSingl%>" style="border-left-width:1px"><%=policyName%>
							</td>
						</tr>
<%
	}
	if(groupName!=null && !groupName.equals("-"))
	{
		cellborder4="cell_border3";
		cellborder3="cell_border4";
%>
						<tr>
							<td class="cell_border4"  align="left"style="border-left-width:1px;border-right-width:0px" ><egui:intnl text="admin.mpolicy.GroupName"/></td>
							<td class="cell_border4 <%=fontStyleDblSingl%>" style="border-left-width:1px"><%=groupName%>
							</td>
						</tr>
<%
	}
%>
						<tr>
							<td class="<%=cellborder3%>" align="left" style="border-left-width:1px;border-right-width:0px"><egui:intnl text="admin.mpolicy.Status"/></td>
							<td class="<%=cellborder3%>" style="border-left-width:1px">
<%
								boolean isActive=egM.isServerElementInUnderMintenance("Test For Host",disp1);
								if(isActive)
								{
										out.println("Active");
								}
								else
								{
										out.println("Inactive");
								}
							}
							timeDur1=(Hashtable)hashValue1.get(1);
							itr2=timeDur1.keySet().iterator();
%>
							</td>
						</tr>
<%
						timeDur1=(Hashtable)hashValue1.get(1);
						itr2=timeDur1.keySet().iterator();
						Hashtable tmptable=new Hashtable(temp);
						String nextSchDate=getNextScheduleDateForCsv(tmpOption,tmptable,dispStr, dispallkey,egM,currentDateFormat);
%>
			<tr>
				<td class="<%=cellborder4%>" style="border-left-width:1px;border-right-width:0px">
					<egui:intnl text="admin.mpolicy.TimeLine"/>
				</td>
				<td class="<%=cellborder4%>" style="padding-left:0px;border-left-width:1px" valign="top" width="50%">
								<table width="100%"  border="0" align="center" cellpadding="0" cellspacing="0" >
									<col width="50%"><col width="50%">
<%
						String timeLine=getTimeLineForCsv(tmptable,dispallkey,egM);
						String dispCol1="";
						String timeMsg1="";
						if(timeLine!=null && timeLine.indexOf(",")>0)
						{
							StringTokenizer st=new StringTokenizer(timeLine,",");
							
							while(st.hasMoreTokens())
							{
								String tok=st.nextToken();
								dispCol1=tok.substring(0,tok.indexOf(" "));
								timeMsg1=tok.substring(tok.indexOf(" ")+1);
%>
									<tr>
										<td valign="top"  width="50%" class="<%=cellborder4%>"><span class="<%=fontStyleDblSingl%>">&nbsp;<%=dispCol1%>&nbsp;</span></td>
										<td valign="top"  width="50%" class="<%=cellborder4%>">

											<table width="100%"  border="0" align="left" cellpadding="0" 	cellspacing="0">

												<tr>
													<td><span class="<%=fontStyleDblSingl%>">&nbsp;<%=timeMsg1%>&nbsp;</span></td>
												</tr>

											</table>
										</td>
									</tr>
<%
							}
						}
						else
						{
							dispCol1=timeLine.substring(0,timeLine.lastIndexOf(" "));
							timeMsg1=timeLine.substring(timeLine.lastIndexOf(" ")+1);
%>
									<tr>
										<td valign="top"  width="50%"><span class="<%=fontStyleDblSingl%>">&nbsp;<%=dispCol1%>&nbsp;</span></td>
										<td valign="top"  width="50%">

											<table width="100%"  border="0" align="center" cellpadding="0" 	cellspacing="0">

												<tr>
													<td><span class="<%=fontStyleDblSingl%>">&nbsp;<%=timeMsg1%>&nbsp;</span></td>
												</tr>

											</table>
										</td>
									</tr>
<%
						}
%>
								</table>

				</td>
			</tr>
			<tr>
				<td class="<%=cellborder3%>" style="border-left-width:1px;border-right-width:0px">
					<egui:intnl text="admin.mpolicy.NextScheduleDate"/>
				</td>
				<td  valign="top" class="<%=cellborder3%>" style="border-left-width:1px" rowspan="0">
<%
								out.println(nextSchDate);
%>
				</td>
			</tr>
					</table>
				</td>
			</tr>
<%
						htCount++;
					}
					else if(k==4) 
					{
						tmpOption="Test  For Component";
						tableTitle="Component Tests  Under Maintenance";
						colName="Test Name";
						dataOptionName="Test  For Component";
						bookMark="componentTestBookMark";
						String cname="";
						String policyName="-";
						String groupName="-";
						if(k==3) 
						{
							cname="Host";
						}
						else
						{
							cname="Component";
						}
						hashValue1=(Vector)temp.get(dispallkey);
						Vector  comps1=(Vector)hashValue1.get(0);

						String cellborder3="cell_border4";
						String cellborder4="cell_border3";

						if(comps1!=null && comps1.size()>0)
						{
							String disp1="";
							if(dispallkey!=null && dispallkey.indexOf(":")>-1)
							{
								if(dispallkey.indexOf("$")>-1 && dispallkey.indexOf("&")>-1)
								{
									disp1=dispallkey.substring(0,dispallkey.indexOf("&"));
									groupName=dispallkey.substring(dispallkey.indexOf("&")+1,dispallkey.indexOf("$"));
									policyName=dispallkey.substring(dispallkey.indexOf("$")+1);
								}
								else if(dispallkey.indexOf("$")>-1)
								{
									disp1=dispallkey.substring(dispallkey.indexOf(":")+1,dispallkey.indexOf("$"));
									policyName=dispallkey.substring(dispallkey.indexOf("$")+1);
								}
								else if(dispallkey.indexOf("&")>-1)
								{
									disp1=dispallkey.substring(dispallkey.indexOf(":")+1,dispallkey.indexOf("&"));
									groupName=dispallkey.substring(dispallkey.indexOf("&")+1);
								}
								else
								{
									disp1=dispallkey.substring(dispallkey.indexOf(":")+1);
								}
							}
							else
							{
								if(dispallkey.indexOf("$")>-1 && dispallkey.indexOf("&")>-1)
								{
									disp1=dispallkey.substring(0,dispallkey.indexOf("$"));
									groupName=dispallkey.substring(dispallkey.indexOf("&")+1,dispallkey.indexOf("$"));
									policyName=dispallkey.substring(dispallkey.indexOf("$")+1);
								}
								else if(dispallkey.indexOf("$")>-1)
								{
									disp1=dispallkey.substring(0,dispallkey.indexOf("$"));
									policyName=dispallkey.substring(dispallkey.indexOf("$")+1);
								}
								else if(dispallkey.indexOf("&")>-1)
								{
									disp1=dispallkey.substring(0,dispallkey.indexOf("&"));
									groupName=dispallkey.substring(dispallkey.indexOf("&")+1);
								}
								else
								{
									disp1=dispallkey;
								}
							}
							if(disp1!=null)
								dispStr=disp1;
							if(ctCount==0)
							{
%>
			<tr>
				<td colspan="3" height="20" align="center" width="100%" style="padding-top:10px">
					<table  id="<%=bookMark%>" width="100%" border="0" cellpadding="0" cellspacing="0" height="20">
						<tr>
							<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
							<td width="100%" align="left" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px">
							<strong><egui:intnl text="<%="admin.mpolicy."+tableTitle%>"/></td>
							<!-- <td height="20" style="width:20px" align="center" id="eg_subheadbg"><img src="/final/admin/eg_images/down.gif" onclick="showContents('<%//=cname+"tests"%>',this);"></td> -->
							<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
						</tr>
					</table>
				</td>
			</tr>
<%
							}
							String cellstyle="padding-bottom:8px;border-bottom-width:1px;border-top-width:0px;";
							if(itr1.hasNext())
							{
							cellstyle="padding-bottom:0px;border-bottom-width:0px;border-top-width:0px;";
							}
%>
			<tr>
				<td colspan="2" width="100%" class="space8 linesquare" style="<%=cellstyle%>">
					<table  id="<%=cname+"tests"%>" width="100%"  border="0" align="left" cellpadding="4" cellspacing="0" style="table-layout:fixed">
						<tr>
							<td class="table_head <%=fontStyleDblSingl%>" colspan="2" align="left" style="text-align:left;padding:2px;" width="50%"><%=disp1%></td>
						</tr>
						<tr>
							<td class="cell_border3 <%=fontStyleDblSingl%>" align="left" style="border-left-width:1px;border-right-width:0px"><%=cname%></td>
							<td class="cell_border3" style="border-left-width:1px;">
								<table cellpadding="0" cellspacing="0" border="0" >
<%
								
								for(int c1=0;c1<comps1.size();c1++)
								{
									String host1=(String)comps1.get(c1);

									if(host1.endsWith(":NULL"))
										host1=host1.substring(0,host1.lastIndexOf(":"));
%>
									<tr><td valign="top" class="<%=fontStyleDblSingl%>"><%=host1%>
									</td></tr>
<%
								}
%>
								</table>
							</td>
						</tr>
<%
	if(policyName!=null && !policyName.equals("-"))
	{
%>
						<tr>
							<td class="cell_border4"  style="border-left-width:1px;border-right-width:0px" align="left"><egui:intnl text="admin.mpolicy.PolicyName"/></td>
							<td class="cell_border4 <%=fontStyleDblSingl%>" style="border-left-width:1px"><%=policyName%>
							</td>
						</tr>
<%
	}
	if(groupName!=null && !groupName.equals("-"))
	{
		cellborder4="cell_border3";
		cellborder3="cell_border4";
%>
						<tr>
							<td class="cell_border3"  align="left"style="border-left-width:1px;border-right-width:0px" ><egui:intnl text="admin.mpolicy.GroupName"/></td>
							<td class="cell_border3 <%=fontStyleDblSingl%>" style="border-left-width:1px"><%=groupName%>
							</td>
						</tr>
<%
	}
%>
						<tr>
							<td class="<%=cellborder4%>" align="left" style="border-left-width:1px;border-right-width:0px"><egui:intnl text="admin.mpolicy.Status"/></td>
							<td class="<%=cellborder4%>" style="border-left-width:1px">
<%
								boolean isActive=egM.isServerElementInUnderMintenance("Test For Host",disp1);
								if(isActive)
								{
										out.println("Active");
								}
								else
								{
										out.println("Inactive");
								}
						}
							timeDur1=(Hashtable)hashValue1.get(1);
							itr2=timeDur1.keySet().iterator();
%>
							</td>
						</tr>
						<%
						timeDur1=(Hashtable)hashValue1.get(1);
						itr2=timeDur1.keySet().iterator();
						Hashtable tmptable=new Hashtable(temp);
						String nextSchDate=getNextScheduleDateForCsv(tmpOption,tmptable,dispStr, dispallkey,egM,currentDateFormat);
%>
			<tr>
				<td class="<%=cellborder3%>" style="border-left-width:1px;border-right-width:0px">
					<egui:intnl text="admin.mpolicy.TimeLine"/>
				</td>
				<td class="<%=cellborder3%>" style="padding-left:0px;border-left-width:1px" valign="top" width="50%">
								<table width="100%"  border="0" align="center" cellpadding="0" cellspacing="0" >
									<col width="50%"><col width="50%">
<%
						String timeLine=getTimeLineForCsv(tmptable,dispallkey,egM);
						String dispCol1="";
						String timeMsg1="";
						if(timeLine!=null && timeLine.indexOf(",")>0)
						{
							StringTokenizer st=new StringTokenizer(timeLine,",");
							
							while(st.hasMoreTokens())
							{
								String tok=st.nextToken();
								dispCol1=tok.substring(0,tok.indexOf(" "));
								timeMsg1=tok.substring(tok.indexOf(" ")+1);
%>
									<tr>
										<td valign="top"  width="50%" class="<%=cellborder3%>"><span class="<%=fontStyleDblSingl%>">&nbsp;<%=dispCol1%>&nbsp;</span></td>
										<td valign="top"  width="50%" class="<%=cellborder3%>">

											<table width="100%"  border="0" align="left" cellpadding="0" 	cellspacing="0">

												<tr>
													<td><span class="<%=fontStyleDblSingl%>">&nbsp;<%=timeMsg1%>&nbsp;</span></td>
												</tr>

											</table>
										</td>
									</tr>
<%
							}
						}
						else
						{
							dispCol1=timeLine.substring(0,timeLine.lastIndexOf(" "));
							timeMsg1=timeLine.substring(timeLine.lastIndexOf(" ")+1);
%>
									<tr>
										<td valign="top"  width="50%"><span class="<%=fontStyleDblSingl%>">&nbsp;<%=dispCol1%>&nbsp;</span></td>
										<td valign="top"  width="50%">

											<table width="100%"  border="0" align="center" cellpadding="0" 	cellspacing="0">

												<tr>
													<td><span class="<%=fontStyleDblSingl%>">&nbsp;<%=timeMsg1%>&nbsp;</span></td>
												</tr>

											</table>
										</td>
									</tr>
<%
						}
%>
								</table>
				</td>
			</tr>
			<tr>
				<td class="<%=cellborder4%>" style="border-left-width:1px;border-right-width:0px">
					<egui:intnl text="admin.mpolicy.NextScheduleDate"/>
				</td>
				<td  valign="top" class="<%=cellborder4%>" style="border-left-width:1px" rowspan="0">
<%
								out.println(nextSchDate);
%>

				</td>
			</tr>
			</table>
		</td>
	</tr>
<%
						ctCount++;
					}
					else if(k==5)
					{
						tmpOption="Descriptor";
						tableTitle="Descriptors Under Maintenance";
						colName="Descriptors";
						dataOptionName="Descriptor";
						bookMark="componentTestBookMark";
						String policyName="-";
						String groupName="-";
						String disp="";
						if(dispallkey.indexOf("$")>-1 && dispallkey.indexOf("&")>-1)
						{
							disp=dispallkey.substring(0,dispallkey.indexOf("&"));
							groupName=dispallkey.substring(dispallkey.indexOf("&")+1,dispallkey.indexOf("$"));
							policyName=dispallkey.substring(dispallkey.indexOf("$")+1);
						}
						else if(dispallkey.indexOf("$")>-1)
						{
							disp=dispallkey.substring(dispallkey.indexOf(":")+1,dispallkey.indexOf("$"));
							policyName=dispallkey.substring(dispallkey.indexOf("$")+1);
						}
						else if(dispallkey.indexOf("&")>-1)
						{
							disp=dispallkey.substring(dispallkey.indexOf(":")+1,dispallkey.indexOf("&"));
							groupName=dispallkey.substring(dispallkey.indexOf("&")+1);
						}
						else
						{
							disp=dispallkey.substring(dispallkey.indexOf(":")+1);
						}
						//component under maintenance
						if(disp.endsWith(":NULL"))
						{
							disp = disp.substring(0,disp.indexOf(":NULL"));
						}
						if(disp!=null)
							dispStr=disp;
						if(descCount==0)
						{
%>
			<tr>
				<td colspan="3" height="20" align="center" width="100%" style="padding-top:20px">
					<table id="<%=bookMark%>" width="100%" border="0" cellpadding="0" cellspacing="0" style="height:20px">
						<tr>
							<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
							<td width="100%" align="left" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px">
							<strong><egui:intnl text="<%="admin.mpolicy."+tableTitle%>"/></td>
							<!-- <td height="20" style="width:20px" align="center" id="eg_subheadbg"><img id="arrowImg" src="/final/admin/eg_images/down.gif" onclick="showContents('<%//=divname%>',this);"></td> -->
							<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
						</tr>
					</table>
				</td>
			</tr>
<%
						}
							String cellstyle="padding-bottom:8px;border-bottom-width:1px;border-top-width:0px;";
							if(itr1.hasNext())
							{
							cellstyle="padding-bottom:0px;border-bottom-width:0px;border-top-width:0px;";
							}
%>
			<tr>
				<td colspan="2" width="100%" class="space8 linesquare" style="<%=cellstyle%>">
					<table   id="<%=divname%>" width="100%"  border="0" align="left" cellpadding="4" cellspacing="0" style="table-layout:fixed">
						<tr>

							<td class="table_head <%=fontStyleDblSingl%>" colspan="2" align="left" style="text-align:left;padding:2px;" width="50%"><%=disp%></td>
						</tr>
<%
	if(policyName!=null && !policyName.equals("-"))
	{
%>
						<tr>
							<td class="cell_border3"  align="left" style="border-left-width:1px;border-right-width:0px"><egui:intnl text="admin.mpolicy.PolicyName"/></td>
							<td class="cell_border3 <%=fontStyleDblSingl%>" style="border-left-width:1px;"><%=policyName%>
							</td>
						</tr>
<%
	}
	String cellborder3="cell_border3";
	String cellborder4="cell_border4";
	if(groupName!=null && !groupName.equals("-"))
	{
		cellborder4="cell_border3";
		cellborder3="cell_border4";

%>
						<tr>
							<td class="cell_border4"  align="left"style="border-left-width:1px;border-right-width:0px" ><egui:intnl text="admin.mpolicy.GroupName"/></td>
							<td class="cell_border4 <%=fontStyleDblSingl%>" style="border-left-width:1px"><%=groupName%>
							</td>
						</tr>
<%
	}
%>
						<tr>
							<td class="<%=cellborder4%>"  align="left" style="border-left-width:1px;border-right-width:0px"><egui:intnl text="admin.mpolicy.Status"/></td>
							<td class="<%=cellborder4%>" style="border-left-width:1px">
<%
								boolean isActive=false;
								if(k==5)
								{
									isActive=egM.isServerElementInUnderMintenance("Test",disp);
								}
								else
								{
									isActive=egM.isServerElementInUnderMintenance("Host",disp);
								}
								if(isActive)
								{
										out.println("Active");
								}
								else
								{
										out.println("Inactive");
								}
%>
							</td>
						</tr>
						<%
						timeDur1=(Hashtable)temp.get(dispallkey);
						itr2=timeDur1.keySet().iterator();
						Hashtable tmptable=new Hashtable(temp);
						if(allkey.indexOf("$")>-1 && allkey.indexOf("&")>-1)
						{
							allkey=allkey.substring(0,allkey.indexOf("&"));
						}
						else if(allkey.indexOf("$")>-1)
						{
							allkey=allkey.substring(0,allkey.indexOf("$"));
						}
						else if(allkey.indexOf("&")>-1)
						{
							allkey=allkey.substring(0,allkey.indexOf("&"));
						}
						String nextSchDate=getNextScheduleDateForCsv(tmpOption,tmptable,allkey, dispallkey,egM,currentDateFormat);
%>
			<tr>
				<td class="<%=cellborder3%>" style="padding-left:3px;border-left-width:1px;border-right-width:0px" >
					<egui:intnl text="admin.mpolicy.TimeLine"/>
				</td>
				<td class="<%=cellborder3%>" width="50%" style="text-align:left;padding:0px;border-left-width:1px;">
								<table width="100%"  border="0" align="left" cellpadding="4" cellspacing="0" >
									<col width="50%"><col width="50%">
<%
						String timeLine=getTimeLineForCsv(tmptable,dispallkey,egM);
						String dispCol1="";
						String timeMsg1="";
						if(timeLine!=null && timeLine.indexOf(",")>0)
						{
							StringTokenizer st=new StringTokenizer(timeLine,",");
							
							while(st.hasMoreTokens())
							{
								String tok=st.nextToken();
								dispCol1=tok.substring(0,tok.indexOf(" "));
								timeMsg1=tok.substring(tok.indexOf(" ")+1);
								int noOfTokens=st.countTokens();
								String cellborder="border-bottom-width:1px";
								if(noOfTokens==1)
								{
									cellborder="border-bottom-width:0px";
								}
								
%>
									<tr>
										<td style="padding-left:0px;text-align:left" valign="top" width="50%" align="left" class="<%=cellborder3%>"  style="<%=cellborder%>"><span class="<%=fontStyleDblSingl%>" ><%=dispCol1%></span></td>
										<td valign="top"  width="50%" class="<%=cellborder3%>" style="<%=cellborder%>">
											<table width="100%"  border="0" align="left" cellpadding="0" cellspacing="0">

												<tr>
													<td><span class="<%=fontStyleDblSingl%>">&nbsp;<%=timeMsg1%>&nbsp;</span></td>
												</tr>

											</table>
										</td>
									</tr>
<%
							}
						}
						else
						{
							dispCol1=timeLine.substring(0,timeLine.lastIndexOf(" "));
							timeMsg1=timeLine.substring(timeLine.lastIndexOf(" ")+1);
							String cellborder="border-bottom-width:0px";
%>
									<tr>
										<td valign="top"  width="50%" class="<%=cellborder3%>" style="<%=cellborder%>"><span class="<%=fontStyleDblSingl%>">&nbsp;<%=dispCol1%>&nbsp;</span></td>
										<td valign="top"  width="50%" class="<%=cellborder3%>" style="<%=cellborder%>">

											<table width="100%"  border="0" align="left" cellpadding="0" 	cellspacing="0">

												<tr>
													<td><span class="<%=fontStyleDblSingl%>">&nbsp;<%=timeMsg1%>&nbsp;</span></td>
												</tr>

											</table>
										</td>
									</tr>
<%
						}
%>
								</table>
				</td>
			</tr>
			<tr>
				<td class="<%=cellborder4%>" style="border-left-width:1px;border-right-width:0px">
					<egui:intnl text="admin.mpolicy.NextScheduleDate"/></td>
				<td class="<%=cellborder4%>" style="border-left-width:1px;">
								<table  id="" width="100%"  border="0" align="center" cellpadding="2" cellspacing="0">
									<tr>
										<!-- <td align="left"></td> -->
										<td  valign="top" rowspan="0" >
<%
								out.println(nextSchDate);
%>
										</td>
									</tr>
								</table>
					</td>
				</tr>
		</table>
		
	</td>
</tr>
<%
							descCount++;
					}
					else if(k==6)
					{
						tmpOption="Descriptor For Component";
						tableTitle="Descriptors For Component Under Maintenance";
						colName="Descriptors";
						dataOptionName="Descriptor For Component";
						bookMark="componentTestBookMark";
						String cname="";
						String policyName="-";
						String groupName="-";
						if(k==3) 
						{
							cname="Host";
						}
						else
						{
							cname="Component";
						}
						hashValue1=(Vector)temp.get(dispallkey);
						Vector  comps1=(Vector)hashValue1.get(0);

						String cellborder3="cell_border3";
						String cellborder4="cell_border4";

						if(comps1!=null && comps1.size()>0)
						{
							String disp1="";
							if(dispallkey!=null && dispallkey.indexOf(":")>-1)
							{
								if(dispallkey.indexOf("$")>-1 && dispallkey.indexOf("&")>-1)
								{
									disp1=dispallkey.substring(0,dispallkey.indexOf("&"));
									groupName=dispallkey.substring(dispallkey.indexOf("&")+1,dispallkey.indexOf("$"));
									policyName=dispallkey.substring(dispallkey.indexOf("$")+1);
								}
								else if(dispallkey.indexOf("$")>-1)
								{
									disp1=dispallkey.substring(dispallkey.indexOf(":")+1,dispallkey.indexOf("$"));
									dispStr=dispallkey.substring(0,dispallkey.indexOf("$"));
									policyName=dispallkey.substring(dispallkey.indexOf("$")+1);
								}
								else if(dispallkey.indexOf("&")>-1)
								{
									disp1=dispallkey.substring(dispallkey.indexOf(":")+1,dispallkey.indexOf("&"));
									dispStr=dispallkey.substring(0,dispallkey.indexOf("$"));
									groupName=dispallkey.substring(dispallkey.indexOf("&")+1);
								}
								else
								{
									disp1=dispallkey.substring(dispallkey.indexOf(":")+1);
								}
							}
							else
							{
								if(dispallkey.indexOf("$")>-1 && dispallkey.indexOf("&")>-1)
								{
									disp1=dispallkey.substring(0,dispallkey.indexOf("$"));
									groupName=dispallkey.substring(dispallkey.indexOf("&")+1,dispallkey.indexOf("$"));
									policyName=dispallkey.substring(dispallkey.indexOf("$")+1);
								}
								else if(dispallkey.indexOf("$")>-1)
								{
									disp1=dispallkey.substring(0,dispallkey.indexOf("$"));
									policyName=dispallkey.substring(dispallkey.indexOf("$")+1);
								}
								else if(dispallkey.indexOf("&")>-1)
								{
									disp1=dispallkey.substring(0,dispallkey.indexOf("&"));
									groupName=dispallkey.substring(dispallkey.indexOf("&")+1);
								}
								else
								{
									disp1=dispallkey;
								}
							}
							if(cdCount==0)
							{
%>
			<tr>
				<td colspan="3" height="20" align="center" width="100%" style="padding-top:20px">
					<table  id="<%=bookMark%>" width="100%" border="0" cellpadding="0" cellspacing="0" height="20">
						<tr>
							<td id="subhead_left" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
							<td width="100%" align="left" id="eg_subheadbg" style="border-left-width:0px;border-right-width:0px">
							<strong><egui:intnl text="<%="admin.mpolicy."+tableTitle%>"/></td>
							<!-- <td height="20" style="width:20px" align="center" id="eg_subheadbg"><img src="/final/admin/eg_images/down.gif" onclick="showContents('<%//=cname+"tests"%>',this);"></td> -->
							<td id="subhead_right" width="7"> <img src="/final/admin/eg_images/spacer.gif" border="0" width="7"> </td>
						</tr>
					</table>
				</td>
			</tr>
<%
								}
							String cellstyle="padding-bottom:8px;border-bottom-width:1px;border-top-width:0px;";
							if(itr1.hasNext())
							{
							cellstyle="padding-bottom:0px;border-bottom-width:0px;border-top-width:0px;";
							}
%>
			<tr>
				<td colspan="2" width="100%" class="space8 linesquare" style="<%=cellstyle%>">
					<table  id="<%=cname+"tests"%>" width="100%"  border="0" align="left" cellpadding="4" cellspacing="0" style="table-layout:fixed">
						<tr>
							<td class="table_head <%=fontStyleDblSingl%>" colspan="2" align="left" style="text-align:left;padding:2px;" valign="top" width="50%"><%=disp1%></td>
						</tr>
						<tr>
							<td class="cell_border3 <%=fontStyleDblSingl%>" align="left"  style="border-left-width:1px;border-right-width:0px"><%=cname%></td>
							<td class="cell_border3" style="border-left-width:1px">
								<table cellpadding="0" cellspacing="0" border="0" >
<%
								for(int c1=0;c1<comps1.size();c1++)
								{
									String host1=(String)comps1.get(c1);
									if(host1.endsWith(":NULL"))
										host1=host1.substring(0,host1.lastIndexOf(":"));
%>
									<tr><td valign="top" class="<%=fontStyleDblSingl%>"><%=host1%></td></tr>
<%
								}
%>
								</table>
							</td>
						</tr>
<%
	if(policyName!=null && !policyName.equals("-"))
	{
%>
						<tr>
							<td class="cell_border4"  align="left" style="border-left-width:1px;border-right-width:0px"><egui:intnl text="admin.mpolicy.PolicyName"/></td>
							<td class="cell_border4 <%=fontStyleDblSingl%>" style="border-left-width:1px"><%=policyName%>
							</td>
						</tr>
<%
	}
	if(groupName!=null && !groupName.equals("-"))
	{
	cellborder4="cell_border3";
		cellborder3="cell_border4";
%>
						<tr>
							<td class="cell_border4"  align="left"style="border-left-width:1px;border-right-width:0px" ><egui:intnl text="admin.mpolicy.GroupName"/></td>
							<td class="cell_border4 <%=fontStyleDblSingl%>" style="border-left-width:1px"><%=groupName%>
							</td>
						</tr>
<%
	}
%>
						<tr>
							<td class="<%=cellborder3%>" align="left" style="border-left-width:1px;border-right-width:0px" ><egui:intnl text="admin.mpolicy.Status"/></td>
							<td class="<%=cellborder3%>" style="border-left-width:1px">
<%
								boolean isActive=egM.isServerElementInUnderMintenance("Test For Host",disp1);
								if(isActive)
								{
										out.println("Active");
								}
								else
								{
										out.println("Inactive");
								}
							}
							timeDur1=(Hashtable)hashValue1.get(1);
							itr2=timeDur1.keySet().iterator();
%>
							</td>
						</tr>
<%
						timeDur1=(Hashtable)hashValue1.get(1);
						itr2=timeDur1.keySet().iterator();
						Hashtable tmptable=new Hashtable(temp);
						String nextSchDate=getNextScheduleDateForCsv(tmpOption,tmptable,dispStr, dispallkey,egM,currentDateFormat);
%>
			<tr>
				<td class="<%=cellborder4%>" style="border-left-width:1px;border-right-width:0px">
					<egui:intnl text="admin.mpolicy.TimeLine"/>
				</td>
				<td class="<%=cellborder4%>" style="padding:0px;border-left-width:1px" width="50%">
					<table width="100%"  border="0" align="center" cellpadding="0" cellspacing="0" >
						<col width="50%"><col width="50%">
<%
						String timeLine=getTimeLineForCsv(tmptable,dispallkey,egM);
						String dispCol1="";
						String timeMsg1="";
						if(timeLine!=null && timeLine.indexOf(",")>0)
						{
							StringTokenizer st=new StringTokenizer(timeLine,",");
							
							while(st.hasMoreTokens())
							{
								String tok=st.nextToken();
								dispCol1=tok.substring(0,tok.indexOf(" "));
								timeMsg1=tok.substring(tok.indexOf(" ")+1);
								int noOfTokens=st.countTokens();
								String cellborder="border-bottom-width:1px";
								if(noOfTokens==1)
								{
									cellborder="border-bottom-width:0px";
								}
%>
							<tr>
								<td width="50%" style="text-align:left" class="<%=cellborder4%>"><span class="<%=fontStyleDblSingl%>">&nbsp;<%=dispCol1%>&nbsp;</span></td>
								<td width="50%" class="<%=cellborder4%>" style="<%=cellborder%>">

									<table width="100%"  border="0" align="left" cellpadding="4" 	cellspacing="0">

										<tr>
											<td><span class="<%=fontStyleDblSingl%>">&nbsp;<%=timeMsg1%>&nbsp;</span></td>
										</tr>

									</table>
								</td>
							</tr>
<%
							}
						}
						else
						{
							dispCol1=timeLine.substring(0,timeLine.lastIndexOf(" "));
							timeMsg1=timeLine.substring(timeLine.lastIndexOf(" ")+1);
%>
							<tr>
								<td width="50%" class="<%=cellborder4%>"><span class="<%=fontStyleDblSingl%>">&nbsp;<%=dispCol1%>&nbsp;</span></td>
								<td width="50%" class="<%=cellborder4%>">

									<table width="100%"  border="0" align="center" cellpadding="4" 	cellspacing="0">

										<tr>
											<td><span class="<%=fontStyleDblSingl%>">&nbsp;<%=timeMsg1%>&nbsp;</span></td>
										</tr>

									</table>
								</td>
							</tr>
<%
						}
%>
					</table>
				</td>
			</tr>
			<tr>
				<td class="<%=cellborder3%>" style="border-left-width:1px;border-right-width:0px">
					<egui:intnl text="admin.mpolicy.NextScheduleDate"/>
				</td>
				<td  valign="top" class="<%=cellborder3%>" style="border-left-width:1px" rowspan="0">
<%
								out.println(nextSchDate);
%>
				</td>
			</tr>
					</table>
				</td>
			</tr>
<%
					cdCount++;
					}
				}
			}
%>
		</table>
<%
		}
	}
	else
	{
		
%>
		<table align="center" width="80%" cellpadding="0" cellspacing="0" border="0" valign="middle" height="200">
			<tr>
				<td align="center"  width="100%"  valign="bottom"><img src="/final/admin/eg_images/<%=admin_Skin%>/exclamation-icon.gif">
				</td>
			</tr>
			<tr>
				<td align="center" width="100%" valign="top">
					<egui:intnl text="admin.mpolicy.No Data Found"/>
				</td>
			</tr>
		</table>
		<input type="hidden" id="printData" name="printData" value="noData" />
		<input type="hidden" id="pdfData" name="pdfData" value="noData" />
		<input type="hidden" id="csvData" name="csvData" value="noData" />
		<script language="javascript">
				window.parent.document.getElementById("hid3").value="false";
		</script>
	
<%
	}
}
}
catch(Exception e)
{
	e.printStackTrace();
}
%>
<%!
	public String getTimeLineForCsv(Hashtable timeVal,String displayName,EgMaintenanceUtility egM)
	{
		StringBuffer timeString=new StringBuffer();
		Iterator itr2=null;
		Object timeDur=(Object)timeVal.get(displayName);
		Hashtable timeDur1=null;
		if(timeDur instanceof Hashtable)
		{
			timeDur1=(Hashtable)timeDur;
		}
		else if(timeDur instanceof Vector)
		{
			Vector tmp=(Vector)timeDur;
			timeDur1=(Hashtable)tmp.get(1);
		}
		if(timeDur1!=null)
		{
			itr2=timeDur1.keySet().iterator();
			Vector timeColumn1=new Vector();
			String timeKey1="";
			while(itr2.hasNext())
			{
				timeKey1=(String)itr2.next();
				timeColumn1.add(timeKey1);
			}
			String dispCol1="";
			for(int m=0;m<timeColumn1.size();m++)
			{
				String colName1=(String)timeColumn1.get(m);
				if(colName1.equals("FDM"))
				{
					dispCol1="First Day Of Month";
				}
				else if(colName1.equals("LDM"))
				{
					dispCol1="Last Day Of Month";
				}
				else if(colName1.equals("*"))
				{
					dispCol1="Daily";
				}
				else if(colName1.equals("Sun") || colName1.equals("Mon") || colName1.equals("Tue") || colName1.equals("Wed") || colName1.equals("Thu") || colName1.equals("Fri") || colName1.equals("Sat"))
				{
					dispCol1=egM.DayForDescription(colName1);
				}
				else
				{
					dispCol1=colName1.replace('|','-');
				}
				
				timeString.append(dispCol1);
				Vector  timeVal1=(Vector)timeDur1.get(colName1);
				if(timeVal1!=null && timeVal1.size()>0)
				{
					for(int n=0;n<timeVal1.size();n++)
					{
						String time1=(String)   timeVal1.get(n);
						String startTime1=time1.substring(0,time1.indexOf("-"));
						String endTime1=time1.substring(time1.indexOf("-")+1,time1.length());
						String timeMsg1=startTime1+"-"+endTime1;
						timeString.append(" ");
						timeString.append(timeMsg1);
					}
				}
				if(timeColumn1.size()>1)
					timeString.append(",");
			}
		}
		return timeString.toString();
	}
	public String getNextScheduleDateForCsv(String option,Hashtable temp,String allkey,String dispallkey,EgMaintenanceUtility egM,String currentDateFormat)
	{
		StringBuffer nextTimeStr=new StringBuffer();
		Hashtable dates=new Hashtable();
		if(option !=null && option.equals("Test For Host") || option.equals("Test  For Component") || option.equals("Descriptor For Component"))
		{
			Vector elementNames=new Vector();
			Vector elementnames=new Vector();
			Vector hashValue1=new Vector();
			elementnames=egM.getAssociatedHostsOrComponentsForTests(allkey);
			dates=egM.getNextScheduleTimeForHosttestOrComponenttest(allkey,elementnames);
			if(dates!=null && dates.size()==0)
			{
				hashValue1=(Vector)temp.get(dispallkey);
				Vector  comps1=(Vector)hashValue1.get(0);
				if(comps1!=null && comps1.size()>0)
				{
					if(comps1.size()==1)
					{
						String host1=(String)comps1.get(0);
						elementNames.add(host1);
						dates=egM.getUnplannedNextScheduleTimeForHosttestOrComponenttest(allkey,elementNames);
					}
					else
					{
						for(int c1=0;c1<comps1.size();c1++)
						{
							String host1=(String)comps1.get(c1);
							elementNames.add(host1);
							dates=egM.getUnplannedNextScheduleTimeForHosttestOrComponenttest(allkey,elementNames);
						}
					}
				}
			}
		}
		else if(option!=null && option.equals("Host") || option.equals("Component") || option.equals("Test") || option.equals("Descriptor"))
		{
			if(option.equals("Test"))
			{
				dates=egM.getNextScheduleTimeForTest(allkey);
				if(dates!=null && dates.size()==0)
					dates=egM.getUnplannedNextScheduleTimeForTest(allkey);
				
			}
			else
			{
				dates=egM.getNextScheduleTimeForHost(allkey);
				if(dates!=null && dates.size()==0)
				{
					if(option.equals("Descriptor"))
					{
						
						String modKey="#"+allkey;
						dates=egM.getUnplannedNextScheduleTimeForTest(allkey);
					}
					else
					{
						dates=egM.getUnplannedNextScheduleTimeForHost(allkey);
					}
					if(dates.size()==0)  
						dates=egM.getNextScheduleTimeForHost(allkey);
				}
			}
		}
		if(dates!=null && dates.size()>0)  
		{
			SimpleDateFormat simpleDateFmt=new SimpleDateFormat(currentDateFormat+" "+"H:mm");
			Date startDate1=(Date)dates.keySet().iterator().next();
			Date endDate1=(Date)dates.get(startDate1);
			if(endDate1.before(new Date()) || endDate1.equals(new Date()))
			{
				nextTimeStr.append("Completed");
			}
			else if(startDate1.getDate()==endDate1.getDate() && startDate1.getMonth()==endDate1.getMonth() && startDate1.getYear()==endDate1.getYear()) 
			{
				SimpleDateFormat simpleDateFmt1=new SimpleDateFormat("H:mm");
				nextTimeStr.append(simpleDateFmt.format(startDate1)+"-"+simpleDateFmt1.format(endDate1));
			}
			else
			{
				nextTimeStr.append(simpleDateFmt.format(startDate1)+"-"+simpleDateFmt.format(endDate1));
			}
		}
		return nextTimeStr.toString();
	}
%>
</body>
</html>

