/*
 *     @example
 *     Ext.create('Ext.data.Store', {
 *         storeId:'tmpstore',
 *         fields:['UserID', 'UserRegistrationDate', 'UserValidityDate','UserIP'],
 *         data:[
 *             {UserID:"krishnamoorthi", UserRegistrationDate:"Dec 06, 2013 11:15:25", UserValidityDate:"Dec 06, 2013 11:15:25",UserIP:"192.168.10.2"},
 *             {UserID:"nagaraj", UserRegistrationDate:"Dec 06, 2013 11:15:25", UserValidityDate:"Dec 06, 2013 11:15:25",UserIP:"192.168.10.2"},
 *             {UserID:"inba", UserRegistrationDate:"Dec 06, 2013 11:15:25", UserValidityDate:"Dec 06, 2013 11:15:25",UserIP:"192.168.10.2"},
 *             {UserID:"sasi", UserRegistrationDate:"Dec 06, 2013 11:15:25", UserValidityDate:"Dec 06, 2013 11:15:25",UserIP:"192.168.10.2"},
 *             {UserID:"saranya", UserRegistrationDate:"Dec 06, 2013 11:15:25", UserValidityDate:"Dec 06, 2013 11:15:25",UserIP:"192.168.10.2"},
 *             {UserID:"abdul", UserRegistrationDate:"Dec 06, 2013 11:15:25", UserValidityDate:"Dec 06, 2013 11:15:25",UserIP:"192.168.10.2"}
 *         ]
 *     });
 *
 *     Ext.create('Ext.grid.Panel', {
 *         title: 'CUSTOM COLUMN SORTING EXAMPLE',
 *         id : 'myGrid',
 *         store: Ext.data.StoreManager.lookup('tmpstore'),
 *         columns: [
 *             {text: 'User Name',  dataIndex:'UserID'},
 *             {
 *               text: 'User registration date',  
 *               dataIndex:'UserRegistrationDate',
 *               doSort: function(state) {
 *                   var ds = this.up('tablepanel').store;
 *                   var field = this.getSortParam();
 *                   customDateSorting(ds,state,field,userDateFormat);
 *                   Ext.getCmp('myGrid').getView().refresh();
 *                   var cssClassName = "x-column-header-sort-"+state;
 *                   this.addCls(cssClassName);
 *               }
 *             },
 *             {
 *               text: 'User validity date',  
 *               dataIndex:'UserValidityDate',
 *               doSort: function(state) {
 *                   var ds = this.up('tablepanel').store;
 *                   var field = this.getSortParam();
 *                   customDateSorting(ds,state,field,userDateFormat);
 *                   Ext.getCmp('myGrid').getView().refresh();
 *                   var cssClassName = "x-column-header-sort-"+state;
 *                   this.addCls(cssClassName);
 *               }
 *             },
 *             {
 *               text: 'User IP',  
 *               dataIndex:'UserIP',
 *               doSort: function(state) {
 *                   var ds = this.up('tablepanel').store;
 *                   var field = this.getSortParam();
 *                   customIPv4Sorting(ds,state,field);
 *                   Ext.getCmp('myGrid').getView().refresh();
 *                   var cssClassName = "x-column-header-sort-"+state;
 *                   this.addCls(cssClassName);
 *               }
 *             },
 *         ],
 *         width: 400,
 *         forceFit: true,
 *         renderTo: Ext.getBody()
 *     });
 */


//------------------------------------------------------------------
// customIPSorting (gridstore,sort_type,columndataindex)
// returns sorted grid data.
// ------------------------------------------------------------------
function customIPv4Sorting(store,state,field)
{
	if (store.getCount() > 1)
	{
		// Do Sorting
		var longData = new Array();
		var StringData = new Array();
		var tmpArr = new Array();
		var tmpArr2 = new Array();

		for (var i = 0;i<store.getCount();i++)
		{
			var strHost = store.getAt(i).get(field);
			var ipcharLong = removeDots(strHost);
			
			if (isNaN(ipcharLong))
			{
				tmpArr2.push(store.getAt(i));
				StringData.push(store.getAt(i).get(field));
			}
			else
			{
				tmpArr.push(store.getAt(i));
				longData.push(store.getAt(i).get(field));
			}
		}

		if (longData.length > 1)
		{
			if (state.toLowerCase() == "asc")
			{
				tmpArr = sortIPV4StackInAcending(longData,tmpArr);
			}
			else
			{
				tmpArr = sortIPV4StackInDecending(longData,tmpArr);
			}
		}

		if (StringData.length > 1)
		{
			tmpArr2 = StringSort(StringData,tmpArr2,state);
		}

		if (state.toLowerCase() == "asc")
		{
			appendData(tmpArr,tmpArr2);
			loadArrData(tmpArr,store,field);
		}
		else
		{
			appendData(tmpArr2,tmpArr);
			loadArrData(tmpArr2,store,field);
		}
		tmpArr = new Array();
		tmpArr2 = new Array();

	} // Do not sort if data is 1 or less
}

//------------------------------------------------------------------
// customIPSorting (gridstore,sort_type,columndataindex,current_user_dateformt)
// return sorted grid data.
// add time "HH:mm:ss" with current user date format
// if you use this method,It is recommended that you should include date.js in the jsp page.
// ------------------------------------------------------------------
function customDateSorting(store,state,field,user_dateformat)
{
	if (store.getCount() > 1)
	{
		// Do Sorting
		var StringData = new Array();
		var dateArr = new Array();
		var tmpArr2 = new Array();
		var tmpArr3 = new Array();

		for (var i = 0;i<store.getCount();i++)
		{
			var strHost = store.getAt(i).get(field);
			var ipcharLong = removeDots(strHost);
			
			if (isDate(strHost,user_dateformat))
			{
				tmpArr3.push(store.getAt(i));
				dateArr.push(store.getAt(i).get(field));
			}
			else if (isNaN(ipcharLong))
			{
				tmpArr2.push(store.getAt(i));
				StringData.push(store.getAt(i).get(field));
			}
		}

		if (StringData.length > 1)
		{
			tmpArr2 = StringSort(StringData,tmpArr2,state);
		}

		if (dateArr.length > 1)
		{
			tmpArr3 = sortDate(dateArr,tmpArr3,state,user_dateformat);
		}

		if (state.toLowerCase() == "asc")
		{
			appendData(tmpArr3,tmpArr2);
			loadArrData(tmpArr3,store,field);
		}
		else
		{
			appendData(tmpArr2,tmpArr3);
			loadArrData(tmpArr2,store,field);
		}
		tmpArr2 = new Array();
		tmpArr3 = new Array();

	} // Do not sort if data is 1 or less
}

function appendData(store,storeToAppend)
{
	for (var i = 0;i<storeToAppend.length;i++)
	{
		store[store.length++] = storeToAppend[i];
	}
}

function loadArrData(tmpArr,store,field)
{
	store.suspendEvents();
	for (var i = 0;i<tmpArr.length;i++)
	{
		//console.log(tmpArr[i].get(field));
		store.insert(i,tmpArr[i]);
		//store.add(tmpArr[i]);
	}
	store.resumeEvents();
}

function StringSort(StringData,tmpArr2,state)
{
	for (var j = 0;j<StringData.length;j++)
	{
		for (var k = 1;k<StringData.length-j;k++)
		{
			if (state.toLowerCase() == "asc")
			{
				if (compareData(StringData[k-1],StringData[k]) > 0)
				{
					var tmp = StringData[k];
					StringData[k] = StringData[k-1];
					StringData[k-1] = tmp;

					var tmpChar = tmpArr2[k];
					tmpArr2[k] = tmpArr2[k-1];
					tmpArr2[k-1] = tmpChar;
				}
			}
			else
			{
				if (compareData(StringData[k-1],StringData[k]) < 0)
				{
					var tmp = StringData[k];
					StringData[k] = StringData[k-1];
					StringData[k-1] = tmp;

					var tmpChar = tmpArr2[k];
					tmpArr2[k] = tmpArr2[k-1];
					tmpArr2[k-1] = tmpChar;
				}
			}
		}
	}
	return tmpArr2;
}

function sortDate(dateArr,tmpArr3,state,user_dateformat)
{
	for (var j = 0;j<dateArr.length;j++)
	{
		for (var k = 1;k<dateArr.length-j;k++)
		{
			if (state.toLowerCase() == "asc")
			{
				if (compareDate(dateArr[k-1],dateArr[k],user_dateformat) > 0)
				{
					var tmp = dateArr[k];
					dateArr[k] = dateArr[k-1];
					dateArr[k-1] = tmp;

					var tmpChar = tmpArr3[k];
					tmpArr3[k] = tmpArr3[k-1];
					tmpArr3[k-1] = tmpChar;
				}
			}
			else
			{
				if (compareDate(dateArr[k-1],dateArr[k],user_dateformat) < 0)
				{
					var tmp = dateArr[k];
					dateArr[k] = dateArr[k-1];
					dateArr[k-1] = tmp;

					var tmpChar = tmpArr3[k];
					tmpArr3[k] = tmpArr3[k-1];
					tmpArr3[k-1] = tmpChar;
				}
			}
		}
	}
	return tmpArr3;
}

function compareDate(v1,v2,user_dateformat)
{
	v1 = getDateFromFormat(v1,user_dateformat);
	v2 = getDateFromFormat(v2,user_dateformat);
	if(v1 == v2)
		return 0;
	if(v1 > v2)
	{
		return 1;
	}
	return -1;
}

function sortIPV4StackInAcending(longData,tmpArr)
{
	for (var j = 0;j<longData.length;j++)
	{
		for (var k = 1;k<longData.length-j;k++)
		{
			if (ipV4Comparator(longData[k-1],longData[k]) > 0)
			{
				var tmp = longData[k];
				longData[k] = longData[k-1];
				longData[k-1] = tmp;

				var tmpChar = tmpArr[k];
				tmpArr[k] = tmpArr[k-1];
				tmpArr[k-1] = tmpChar;
			}
		}
	}
	return tmpArr;
}

function sortIPV4StackInDecending(longData,tmpArr)
{
	for (var j = 0;j<longData.length;j++)
	{
		for (var k = 1;k<longData.length-j;k++)
		{
			if (ipV4Comparator(longData[k-1],longData[k]) < 0)
			{
				var tmp = longData[k];
				longData[k] = longData[k-1];
				longData[k-1] = tmp;

				var tmpChar = tmpArr[k];
				tmpArr[k] = tmpArr[k-1];
				tmpArr[k-1] = tmpChar;
			}
		}
	}
	return tmpArr;
}

function removeDots(source)
{
	var i = 0;
	while(true)
	{
		i = source.indexOf(".",0);
		if(i==-1) break;
		source=source.substring(0,i)+source.substring(i+1,source.length);
	}
	return source;
}

function compareData(v1,v2)
{
	if(!isNaN(v1) && !isNaN(v2))
	{
		v1=parseFloat(v1);
		v2=parseFloat(v2);
		if(v1 == v2)
		{
			return 0;
		}
		if(v1 > v2)
		{
			return 1
		}
	}
	else
	{
		v1= v1.toUpperCase();
		v2= v2.toUpperCase();
		if(v1 == v2)
			return 0;
		if(v1 > v2)
			return 1
	}
	return -1;
}


function ipV4Comparator(ip1,ip2)
{
	//-1,0,1
	ip1 += ".";
	ip2 += ".";
	while (ip1.indexOf(".") > -1 && ip2.indexOf(".") > -1 )
	{
		var tmpIP1 = ip1.substring(0,ip1.indexOf("."));
		var tmpIP2 = ip2.substring(0,ip2.indexOf("."));

		ip1 = ip1.substring(ip1.indexOf(".")+1);
		ip2 = ip2.substring(ip2.indexOf(".")+1);

		var ipTok1 = parseInt(tmpIP1);
		var ipTok2 = parseInt(tmpIP2);
		if (ipTok1 < ipTok2)
		{
			return -1;
		}
		else if(ipTok1 > ipTok2)
		{
			return 1;
		}
		else
		{
			continue;
		}
	}
	return 0;
}


function getFormatedIPV6Address(address){

	var stdForm = "";
	address=address.trim();
	var splitted=address.split(":");
	for(var i = 0;i<splitted.length;i++){
		var str = splitted[i];
		if(str == ""){
			for(var j=0;j<8-splitted.length;j++){
				stdForm = stdForm+"0000:";
			}
		}else{
			while(str.length != 4) str="0"+str;
			stdForm = stdForm + str+":";
		}
	}
	return stdForm.substring(0, stdForm.length-1);
}



