/*--------------------------------------------------|
| dTree 2.05 | www.destroydrop.com/javascript/tree/ |
|---------------------------------------------------|
| Copyright (c) 2002-2003 Geir Landr?               |
|                                                   |
| This script can be used freely as long as all     |
| copyright messages are intact.                    |
|                                                   |
| Updated: 17.04.2003                               |
|--------------------------------------------------*/

/***********************************************************************************
*		Name				:	MaintenaceTree.js
*		Purpose				:	This is the template to Create a Tree
*		Version				:	4.3
*		CreationDate		:	12/09/2008
*		Author				:	Simeon.D
***********************************************************************************/

function menu_onmousemove()
{
	if(navigator.appName=="Microsoft Internet Explorer")
	{
		var menu=document.getElementById("menu");
		menu.style.visibility='visible';
		menu.style.display='block';
	}
	else
	{
		var menu=document.getElementById("menu");
		menu.style.visibility='visible';
		menu.style.display='block';
	}
}

function menu_onmouseout()
{
	closeMenu();
}

function showMenu(event)
{
	var menu=window.parent.document.getElementById("menu");
	var DiscoveryView=document.getElementById("DiscoveryView");
	if(navigator.appName=="Microsoft Internet Explorer")
	{
		event=window.event;

		var windowHeight=document.body.clientHeight+document.body.scrollTop;
		var divLocation=event.clientY+50;
		if(windowHeight<divLocation)
		{
			menu.style.top=(event.clientY)-30;
		}
		else
		{
			menu.style.top=(event.clientY)+30;
		}

		menu.style.left=(event.clientX)+10;
		menu.style.visibility='visible';
		menu.style.display='block';
	}
	else
	{
		var windowHeight=document.body.clientHeight+document.body.scrollTop;
		var divLocation=event.clientY+50;
		
		if(windowHeight<divLocation)
		{
			menu.style.top=(event.clientY)-30;
		}
		else
		{
			menu.style.top=(event.clientY)+30;
		}
		menu.style.left=(event.clientX)+10;
		menu.style.visibility='visible';
		menu.style.display='block';
	}
}

function menu_onclick(event)
{
	var hidd=this.getElementsByTagName("input");
	var aTag=this.getElementsByTagName("a");
	var DiscoveryView=window.parent.document.getElementById("DiscoveryView");
	if(hidd!=null && hidd.length>1)
	{
		/*
		if(hidd[1].value=='Delete PolicyGroup')
		{
		}
		else if(hidd[1].value=='Delete IndependentPolicy')
		{
		}
		else if(hidd[1].value=='Delete All Policies')
		{
		}
		else if(hidd[1].value=='Delete Policy')
		{
		}
		else if(hidd[1].value=='Disassociate Policy')
		{
		}
		*/
	}
	else
	{
		DiscoveryView.src=hidd[0].value;
	}
	closeMenu();
}

function closeTreeWindowFromMenu()
{
	var treeViewTd=window.parent.document.getElementById("treeViewTd");
	var treeViewExpandTD=window.parent.document.getElementById("MaintananceTree").contentWindow.document.getElementById("treeViewExpandTD");
	var expandImg=window.parent.document.getElementById("expand");
	if(treeViewTd.style.display=="none")
	{
		expandImg.src="/final/admin/eg_images/blue/split_left.gif";
		treeViewTd.style.display='block';
	}
	else
	{
		expandImg.src="/final/admin/eg_images/blue/split_right.gif";
		treeViewTd.style.display='none';
	}
}

function closeMenu()
{
	var menu=window.parent.document.getElementById("menu");
	menu.style.display='none';
}

function showalert(event)
{
	
	if(navigator.appName=="Microsoft Internet Explorer")
	{
		event=window.event;
		var alertMenu=document.getElementById("alertMenu");
		alertMenu.style.left=(event.clientX)+document.body.scrollLeft+20;
		alertMenu.style.top=(event.clientY)+document.body.scrollTop+10;
		alertMenu.style.visibility='visible';
		alertMenu.style.display='block';
	}
	else
	{
		var alertMenu=window.parent.document.getElementById("alertMenu");
		alertMenu.style.left=(event.clientX)+document.body.scrollLeft+20;
		alertMenu.style.top=(event.clientY)+document.body.scrollTop+10;
		alertMenu.style.visibility='visible';
		alertMenu.style.display='block';
	}
}


function menu_onmouseover()
{
	if(this.style!=null)
	{
		this.className="tree_over_border tree_font";
	}
	
}

function menu_onmouseout()
{
	if(this.style!=null)
	{
		this.className="eg_whitebg tree_font";
	}
}

function context()
{
	return false;
}

function customContextMenu(thisObj,event)
{
	var openNodeId=window.parent.document.getElementById("openNodeId");
	var hiddenElement=thisObj.getElementsByTagName("input");
	var data=hiddenElement[0].value.split("#");
	var str=''; 
	var nodeType=data[0];
	var name=data[1];
	var id=data[2];
	var pId=data[3];
	var parentName=data[4];
	var totalNoNodes=Number(data[5]);
	try
	{
		for(var n=0;n<totalNoNodes;n++)
		{
			var node=document.getElementById("nodeATag"+n);
			if(node!=null)
				node.className='eg_adminlink';
		}
	}
	catch(ex)
	{}
	//This is for Highlight the selected node
	var aTagObj=document.getElementById("nodeATag"+id);
	var selectedNode=window.parent.document.getElementById("selectedNode");
	if(aTagObj!=null && aTagObj!='undefined')
	{
		aTagObj.className='nodeSel';
		if(selectedNode!=null)
		{
			selectedNode.value="nodeATag"+id;
		}
	}

	// This is for menus
	if(nodeType=='1')
	{
		str='<table border="0" style="width:160px;height="100%" border-bottom-width:0px" class="tree_border" cellpadding="0" cellspacing="0">';
		str+='<tr><td rowspan="3" width="16px" class="tree_bgimage"></td><td width="140px" >';
		str+='<table width="100%" cellpadding="4" cellspacing="0" border="0">';
		str+='<tr><span><td class="eg_treelink"><input type="hidden" value="/final/admin/EgChangePorts.jsp?from=add"></input><a class="eg_adminlink" href="#">Add</a></td></span></tr>';
		str+='<tr><span><td class="eg_treelink"><input type="hidden" value="/final/admin/EgChangePorts.jsp?from=modify"></input><a class="eg_adminlink" href="#">Modify</a></td></span></tr>';
		str+='<tr ><span><td class="eg_treelink"><input type="hidden" value="/final/admin/EgChangePorts.jsp?from=delete"></input><a class="eg_adminlink" href="#">Delete</a></td></span></tr>';
		str+='</table></td></tr>';
		str+='</table>'
	}
	var menu=window.parent.document.getElementById("menu");
	menu.innerHTML=str;
	var menuSpan = menu.getElementsByTagName('span');
	if(navigator.appName=="Microsoft Internet Explorer")
	{
		for(i=0;i<menuSpan.length;i++)
		{
			menuSpan[i].oncontextmenu=context;
			var aTag=menuSpan[i].getElementsByTagName('a');
			var hidd=menuSpan[i].getElementsByTagName('input');
			menuSpan[i].onclick = menu_onclick;
			
			var tdTag=menuSpan[i].getElementsByTagName("td");
			for(j=0;j<tdTag.length;j++)
			{
				tdTag[j].onmouseover=menu_onmouseover;
				tdTag[j].onmouseout=menu_onmouseout;
			}
		}
	}
	else
	{
		var tdTag = menu.getElementsByTagName('td');
		for(i=0;i<tdTag.length;i++)
		{
			tdTag[i].oncontextmenu=context;
			if(i>1)
			{
				tdTag[i].onclick = menu_onclick;
				tdTag[i].onmouseover=menu_onmouseover;
				tdTag[i].onmouseout=menu_onmouseout;
			}
		}
	}
	if(nodeType!=0)
	{
		showMenu(event);
	}
		return false;
}

function isNetscape() 
{
   // get browser info. 
   appName= navigator.appName;
   appLongVer = navigator.appVersion;
   appVer = appLongVer.substring(0, 1); 

   // check for Navigator ver 4+. 
   if ((appName == "Netscape") && (appVer >= 4)) return true;
   return false;
}


function linkOnclick(url,id,nodeId,noOfNodes)
{
	var target=window.parent.document.getElementById(id);
	var isvirtualConfigured = document.getElementById("v_info");
	if(target!=null && target!="undefined")
	{
		if (nodeId == 8)
		{
			var isvirtualConfiguredval = "";
			if (isvirtualConfigured != null && isvirtualConfigured != "undefined")
			{
				isvirtualConfiguredval = isvirtualConfigured.value;
			}
			if (isvirtualConfiguredval == "no")
			{
				var discoveryNotifications = window.parent.document.getElementById("discoveryNotifications");
				var notifyHeading = window.parent.document.getElementById("notifyHeading");
				var actValue = document.getElementById("actValue");
				//var notifyMessage = window.parent.document.getElementById("notifyMessage");
				if (actValue.value == "cloud")
				{
					notifyHeading.innerHTML = "<i><b>No public clouds have been configured in the eG Enterprise system.</b></i>";
					//notifyMessage.innerHTML = "<b>Please Click on the configure icon to configure public clouds, else click on start discovery to discover your infrastructure.</b>";
					var ip_settings = window.parent.document.getElementById("ip_settings");
					var rowSet = window.parent.document.getElementById("rowSet");
					if (!isNetscape())
					{
						ip_settings.style.display = "none";
						rowSet.style.display = "block";
					}
					else
					{
						ip_settings.style.display = "none";
						rowSet.style.display = "table-row";
					}
				}
				else if (actValue.value == "ip")
				{
					var notifyMessage = window.parent.document.getElementById("notifyMessage");
					var ip_settings = window.parent.document.getElementById("ip_settings");
					var rowSet = window.parent.document.getElementById("rowSet");
					notifyHeading.innerHTML = "<i><b>IP range has not been configured for manager discovery.</b></i>";
					//notifyMessage.innerHTML = "<b>Please Click on the configure icon to configure IP range for discovery.</b>";
					if (!isNetscape())
					{
						ip_settings.style.display = "block";
						rowSet.style.display = "none";
					}
					else
					{
						ip_settings.style.display = "table-row";
						rowSet.style.display = "none";
					}
				}
				else if (actValue.value == "virtual")
				{
					notifyHeading.innerHTML = "<i><b>No virtual platforms have been configured in the eG Enterprise system.</b></i>";
					var ip_settings = window.parent.document.getElementById("ip_settings");
					var rowSet = window.parent.document.getElementById("rowSet");
					if (!isNetscape())
					{
						ip_settings.style.display = "none";
						rowSet.style.display = "block";
					}
					else
					{
						ip_settings.style.display = "none";
						rowSet.style.display = "table-row";
					}
				}
				discoveryNotifications.style.display = "block";
			}
			else
			{
				target.src=url;
			}
		}
		else
		{
			target.src=url;
		}
	}
	for(var n=0;n<noOfNodes;n++)
	{
		var node=document.getElementById("nodeATag"+n);
		if(node!=null)
			node.className='eg_adminlink';
	}

	var aTagObj=document.getElementById("nodeATag"+nodeId);
	var selectedNode=window.parent.document.getElementById("selectedNode");
	if(aTagObj!=null && aTagObj!='undefined')
	{
		aTagObj.className='nodeSel';
		if(selectedNode!=null && selectedNode!='undefined')
		{
			selectedNode.value="nodeATag"+id;
		}
	}
}

// Node object
function Node(id, pid, name, url, title, target, icon, iconOpen, open,nodeType,noOfPolicies,singlePolicyGroups) {
	this.id = id;
	this.pid = pid;
	this.name = name;
	this.url = url;
	this.title = title;
	this.target = target;
	this.icon = icon;
	this.iconOpen = iconOpen;
	this._io = open || false;
	this._is = false;
	this._ls = false;
	this._hc = false;
	this._ai = 0;
	this._p;
	this.nodeType=nodeType;
	this.noOfPolicies=noOfPolicies;
	this.singlePolicyGroups=singlePolicyGroups;
};

// Tree object
function dTree(objName) {
	this.config = {
		target					: null,
		folderLinks				: true,
		useSelection			: true,
		useCookies				: true,
		useLines				: true,
		useIcons				: true,
		useStatusText			: false,
		closeSameLevel			: false,
		inOrder					: false
	}

	this.icon = {
		root					: '/final/admin/eg_images/maintenancepolicy.gif',
		folder					: '/final/admin/eg_images/tree/folder.gif',
		folderOpen				: '/final/admin/eg_images/tree/folderopen.gif',
		node					: '/final/admin/eg_images/tree/page.gif',
		empty					: '/final/admin/eg_images/tree/empty.gif',
		line					: '/final/admin/eg_images/tree/line.gif',
		join					: '/final/admin/eg_images/tree/join.gif',
		joinBottom				: '/final/admin/eg_images/tree/joinbottom.gif',
		plus					: '/final/admin/eg_images/tree/plus.gif',
		plusBottom				: '/final/admin/eg_images/tree/plusbottom.gif',
		minus					: '/final/admin/eg_images/tree/minus.gif',
		minusBottom				: '/final/admin/eg_images/tree/minusbottom.gif',
		nlPlus					: '/final/admin/eg_images/tree/nolines_plus.gif',
		nlMinus					: '/final/admin/eg_images/tree/nolines_minus.gif'
	};

	this.obj = objName;
	this.aNodes = [];
	this.aIndent = [];
	this.root = new Node(-1);
	this.selectedNode = null;
	this.selectedFound = false;
	this.completed = false;
};

discoveryDescription = new Array()
discoveryDescription[0] = "";
discoveryDescription[1] = "";
discoveryDescription[2] = "";
discoveryDescription[3] = "General settings for discovery";
discoveryDescription[4] = "Virtual platforms setting for discovery";
discoveryDescription[5] = "Public clouds setting for discovery";
discoveryDescription[6] = "";
discoveryDescription[7] = "Enable/Disable the manager discovery";
discoveryDescription[8] = "Start the manager discovery";
discoveryDescription[9] = "Stop the manager discovery";
discoveryDescription[10] = "Manage infrastructure components";
discoveryDescription[11] = "Agent Discovery";
discoveryDescription[12] = "";
discoveryDescription[13] = "General settings for agent discovery";
discoveryDescription[14] = "";
discoveryDescription[15] = "Enable/Disable the agent discovery";
// Adds a new node to the node array
dTree.prototype.add = function(id, pid, name, url, title, target, icon, iconOpen, open,nodeType,noOfPolicies,singlePolicyGroups) 
{
	this.aNodes[this.aNodes.length] = new Node(id, pid, name, url, title, target, icon, iconOpen, open,nodeType,noOfPolicies,singlePolicyGroups);
	
	var treeRefreshDiv=window.parent.document.getElementById("treeRefreshDiv");
	var str='';
	var n=this.aNodes.length-1;
};

// Open/close all nodes
dTree.prototype.openAll = function() {
	this.oAll(true);
};

dTree.prototype.closeAll = function() {
	this.oAll(false);
};

// Outputs the tree to the page
dTree.prototype.toString = function() {
	var str = '<div class="dtree">\n';
	if (document.getElementById) 
	{
		if (this.config.useCookies) this.selectedNode = this.getSelected();
			str += this.addNode(this.root);
	}
	else 
		str += 'Browser not supported.';
	str += '</div>';
	if (!this.selectedFound) this.selectedNode = null;
	this.completed = true;
	return str;
};

// Creates the tree structure
dTree.prototype.addNode = function(pNode) {
	var str = '';
	var n=0;
	if (this.config.inOrder) n = pNode._ai;
	for (n; n<this.aNodes.length; n++) {
		if (this.aNodes[n].pid == pNode.id) {
			var cn = this.aNodes[n];
			cn._p = pNode;
			cn._ai = n;
			this.setCS(cn);
			if (!cn.target && this.config.target) cn.target = this.config.target;
			if (cn._hc && !cn._io && this.config.useCookies) cn._io = this.isOpen(cn.id);
			if (!this.config.folderLinks && cn._hc) cn.url = null;
			if (this.config.useSelection && cn.id == this.selectedNode && !this.selectedFound) {
					cn._is = true;
					this.selectedNode = n;
					this.selectedFound = true;

			}
			str += this.node(cn, n);
			if (cn._ls) break;
		}
	}
	return str;
};

// Creates the node icon, url and text
dTree.prototype.node = function(node, nodeId)
{
	var nodeType=node.nodeType+"";
	var nodename=node.name;
	var type=node.nodeType;
	var parentNode=this.aNodes[node.pid];
	var parentName="";
	if(parentNode!=null && parentNode!="undefined")
	{
		parentName=parentNode.name;
	}
	//var str = '<div class="dTreeNode" style="font-size:7.5pt;color:#000000">' + this.indent(node, nodeId);
	var str = '<div class="dTreeNode" style="font-size:7.5pt;color:#000000" oncontextmenu="return false;">' + this.indent(node, nodeId);
	if (this.config.useIcons) 
	{
		if (!node.icon) node.icon = (this.root.id == node.pid) ? this.icon.root : ((node._hc) ? this.icon.folder : this.icon.node);
		if (!node.iconOpen) node.iconOpen = (node._hc) ? this.icon.folderOpen : this.icon.node;
		/*
		if (this.root.id == node.pid) 
		{
			node.icon = this.icon.root;
			node.iconOpen = this.icon.root;
		}
		*/
		str += '<img  border="0" id="i' + this.obj + nodeId + '" src="' + ((node._io) ? node.iconOpen : node.icon) + '" alt="" />';
	}
	if(nodeType=='-1')
	{
		str +='<span  oncontextmenu = "customContextMenu(this,event);"><input type="hidden" value="'+nodeType+'#'+nodename+'#'+nodeId+'#'+node.pid+'#'+parentName+'#'+this.aNodes.length+'"/>'+node.name+'</span>';
	}
	else
	{
		str +='<span oncontextmenu = "customContextMenu(this,event);" title="'+discoveryDescription[nodeId]+'"><input type="hidden" value="'+nodeType+'#'+nodename+'#'+nodeId+'#'+node.pid+'#'+parentName+'#'+this.aNodes.length+'"/><a id="nodeATag'+nodeId+'" class="eg_adminlink" href=javascript:linkOnclick("'+node.url+'","'+node.target+'",'+nodeId+','+this.aNodes.length+')>'+node.name+'</a></span>';
	}

	str += '</div>';
	if (node._hc) {
		str += '<div style="border:0px solid #ff0000;" id="d' + this.obj + nodeId + '" class="clip" style="display:' + ((this.root.id == node.pid || node._io) ? 'block' : 'none') + ';">';
		str += this.addNode(node);
		str += '</div>';
	}
	this.aIndent.pop();
	return str;
};

// Adds the empty and line icons
dTree.prototype.indent = function(node, nodeId) {
	var str = '';
	if (this.root.id != node.pid) {
		for (var n=0; n<this.aIndent.length; n++)
			str += '<img src="' + ( (this.aIndent[n] == 1 && this.config.useLines) ? this.icon.line : this.icon.empty ) + '" alt="" />';
		(node._ls) ? this.aIndent.push(0) : this.aIndent.push(1);
		if (node._hc) {
			str += '<a class="eg_adminlink" href="javascript: ' + this.obj + '.o(' + nodeId + ');"><img border="0" id="j'  + this.obj + nodeId + '" src="';
			if (!this.config.useLines) str += (node._io) ? this.icon.nlMinus : this.icon.nlPlus;
			else str += ( (node._io) ? ((node._ls && this.config.useLines) ? this.icon.minusBottom : this.icon.minus) : ((node._ls && this.config.useLines) ? this.icon.plusBottom : this.icon.plus ) );
			str += '" alt="" /></a>';
		} else str += '<img src="' + ( (this.config.useLines) ? ((node._ls) ? this.icon.joinBottom : this.icon.join ) : this.icon.empty) + '" alt="" />';
	}
	return str;
};

// Checks if a node has any children and if it is the last sibling
dTree.prototype.setCS = function(node) {
	var lastId;
	for (var n=0; n<this.aNodes.length; n++) {
		if (this.aNodes[n].pid == node.id) node._hc = true;
		if (this.aNodes[n].pid == node.pid) lastId = this.aNodes[n].id;
	}
	if (lastId==node.id) node._ls = true;
};

// Returns the selected node
dTree.prototype.getSelected = function() {
	var sn = this.getCookie('cs' + this.obj);
	return (sn) ? sn : null;
};

dTree.prototype.highlightNodeByProcess=function(name)
{
	//if(process=="start")
	if(true)
	{
		var treeSelectionDiv=window.parent.document.getElementById("treeSelectionDiv");
		if(treeSelectionDiv!=null)
		{
			var hiddenElements=treeSelectionDiv.getElementsByTagName("input");
			for(var i=0;i<hiddenElements.length;i++)
			{
				var nodeName=hiddenElements[i].value;
				var node=document.getElementById(nodeName);
				node.className='eg_adminlink';
			}
			treeSelectionDiv.innerHTML="";
		}
		for (var n=0;n<this.aNodes.length ;n++ )
		{
			if(this.aNodes[n].name==name)
			{
				var node=document.getElementById("nodeATag"+n);
				node.className='nodeSel';
				//This is for Highlight the selected node
				var treeSelectionDiv=window.parent.document.getElementById("treeSelectionDiv");
				var aTagObj=document.getElementById("nodeATag"+n);
				if(aTagObj!=null && aTagObj!='undefined')
				{
					aTagObj.className='nodeSel';
					if(treeSelectionDiv!=null)
					{
						treeSelectionDiv.innerHTML+='<input type="hidden" value="nodeATag'+n+'">';
						break;
					}
				}
			}
		}
	}
}

// Highlights the selected node
dTree.prototype.s = function(id) {
	var eRoot = document.getElementById("s" + this.obj + 0);
	eRoot.className = "node";
	if (!this.config.useSelection) return;
	var cn = this.aNodes[id];
	if (cn._hc && !this.config.folderLinks) return;
	if (this.selectedNode != id) {
		if (this.selectedNode || this.selectedNode==0) {
			eOld = document.getElementById("s" + this.obj + this.selectedNode);
			eOld.className = "node";
		}
		eNew = document.getElementById("s" + this.obj + id);
		eNew.className = "nodeSel";
		this.selectedNode = id;
		if (this.config.useCookies) this.setCookie('cs' + this.obj, cn.id);
	}
};



// Toggle Open or close
dTree.prototype.o = function(id) 
{
	try
	{
		var cn = this.aNodes[id];
		var treeIdValue=window.parent.document.getElementById("opentree"+id);
		if(treeIdValue!=null)
		{
			treeIdValue.value=""+(!cn._io);
		}

		this.nodeStatus(!cn._io, id, cn._ls);
		cn._io = !cn._io;
		if (this.config.closeSameLevel) this.closeLevel(cn);
		if (this.config.useCookies) this.updateCookie();

		var openNodeId=window.parent.document.getElementById("openNodeId");
		if(cn._io)
		{
			openNodeId.value=id;
		}
	}
	catch(ex)
	{}
};



// Open or close all nodes
dTree.prototype.oAll = function(status) {
	for (var n=0; n<this.aNodes.length; n++) 
		{
			try
			{
				if (this.aNodes[n]._hc && this.aNodes[n].pid != this.root.id) 
				{
					this.nodeStatus(status, n, this.aNodes[n]._ls)
					this.aNodes[n]._io = status;
				}
			}
			catch(Ex)
			{}
	}
};



// Opens the tree to a specific node
dTree.prototype.openTo = function(nId, bSelect, bFirst) {
	if (!bFirst) {
		for (var n=0; n<this.aNodes.length; n++) {
			if (this.aNodes[n].id == nId) {
				nId=n;
				break;
			}
		}
	}
	var cn=this.aNodes[nId];
	if (cn.pid==this.root.id || !cn._p) return;
	cn._io = true;
	cn._is = bSelect;
	if (this.completed && cn._hc) this.nodeStatus(true, cn._ai, cn._ls);
	if (this.completed && bSelect) this.s(cn._ai);
	else if (bSelect) this._sn=cn._ai;
	this.openTo(cn._p._ai, false, true);
};



// Closes all nodes on the same level as certain node

dTree.prototype.closeLevel = function(node) {
	for (var n=0; n<this.aNodes.length; n++) {
		if (this.aNodes[n].pid == node.pid && this.aNodes[n].id != node.id && this.aNodes[n]._hc) {
			this.nodeStatus(false, n, this.aNodes[n]._ls);
			this.aNodes[n]._io = false;
			this.closeAllChildren(this.aNodes[n]);
		}
	}
}

// Closes all children of a node
dTree.prototype.closeAllChildren = function(node) {
	for (var n=0; n<this.aNodes.length; n++) {
		if (this.aNodes[n].pid == node.id && this.aNodes[n]._hc) {
			if (this.aNodes[n]._io) this.nodeStatus(false, n, this.aNodes[n]._ls);
			this.aNodes[n]._io = false;
			this.closeAllChildren(this.aNodes[n]);		
		}
	}
}

// Change the status of a node(open or closed)
dTree.prototype.nodeStatus = function(status, id, bottom) 
{
	try
	{
		eDiv	= document.getElementById('d' + this.obj + id);
		eJoin	= document.getElementById('j' + this.obj + id);
		if (this.config.useIcons) {
			eIcon	= document.getElementById('i' + this.obj + id);
			eIcon.src = (status) ? this.aNodes[id].iconOpen : this.aNodes[id].icon;
		}
		eJoin.src = (this.config.useLines)?
		((status)?((bottom)?this.icon.minusBottom:this.icon.minus):((bottom)?this.icon.plusBottom:this.icon.plus)):
		((status)?this.icon.nlMinus:this.icon.nlPlus);
		eDiv.style.display = (status) ? 'block': 'none';
	}
	catch(Ex)
	{}
};

// [Cookie] Clears a cookie
dTree.prototype.clearCookie = function() {
	var now = new Date();
	var yesterday = new Date(now.getTime() - 1000 * 60 * 60 * 24);
	this.setCookie('co'+this.obj, 'cookieValue', yesterday);
	this.setCookie('cs'+this.obj, 'cookieValue', yesterday);
};

// [Cookie] Sets value in a cookie
dTree.prototype.setCookie = function(cookieName, cookieValue, expires, path, domain, secure) {
	document.cookie =
		escape(cookieName) + '=' + escape(cookieValue)
		+ (expires ? '; expires=' + expires.toGMTString() : '')
		+ (path ? '; path=' + path : '')
		+ (domain ? '; domain=' + domain : '')
		+ (secure ? '; secure' : '');
};

// [Cookie] Gets a value from a cookie
dTree.prototype.getCookie = function(cookieName) {
	var cookieValue = '';
	var posName = document.cookie.indexOf(escape(cookieName) + '=');
	if (posName != -1) {
		var posValue = posName + (escape(cookieName) + '=').length;
		var endPos = document.cookie.indexOf(';', posValue);
		if (endPos != -1) cookieValue = unescape(document.cookie.substring(posValue, endPos));
		else cookieValue = unescape(document.cookie.substring(posValue));
	}
	return (cookieValue);
};

// [Cookie] Returns ids of open nodes as a string
dTree.prototype.updateCookie = function() {
	var str = '';
	for (var n=0; n<this.aNodes.length; n++) {
		if (this.aNodes[n]._io && this.aNodes[n].pid != this.root.id) {
			if (str) str += '.';
			str += this.aNodes[n].id;
		}
	}
	this.setCookie('co' + this.obj, str);
};


// [Cookie] Checks if a node id is in a cookie
dTree.prototype.isOpen = function(id) {
	var aOpen = this.getCookie('co' + this.obj).split('.');
	for (var n=0; n<aOpen.length; n++)
		if (aOpen[n] == id) return true;
	return false;
};

// If Push and pop is not implemented by the browser
if (!Array.prototype.push) {
	Array.prototype.push = function array_push() {
		for(var i=0;i<arguments.length;i++)
			this[this.length]=arguments[i];
		return this.length;
	}
};

if (!Array.prototype.pop) {
	Array.prototype.pop = function array_pop() {
		lastElement = this[this.length-1];
		this.length = Math.max(this.length-1,0);
		return lastElement;
	}
};

dTree.prototype.selectRoot = function() {
	var eId  = document.getElementById("s" + this.obj + 0);
	eId.className = "nodeSel";
};