/*--------------------------------------------------|
| dTree 2.05 | www.destroydrop.com/javascript/tree/ |
|---------------------------------------------------|
| Copyright (c) 2002-2003 Geir Landr?               |
|                                                   |
| This script can be used freely as long as all     |
| copyright messages are intact.                    |
|                                                   |
| Updated: 17.04.2003                               |
|--------------------------------------------------*/

function closeTreeWindowFromMenu()
{
	var treeViewTd=window.parent.document.getElementById("treeViewTd");
	var treeViewExpandTD=window.parent.document.getElementById("AuthenticationTree").contentWindow.document.getElementById("treeViewExpandTD");
	var expandImg=window.parent.document.getElementById("expand");
	if(treeViewTd.style.display=="none")
	{
		expandImg.src="/final/admin/eg_images/blue/split_left.gif";
		treeViewTd.style.display='block';
	}
	else
	{
		expandImg.src="/final/admin/eg_images/blue/split_right.gif";
		treeViewTd.style.display='none';
	}
}

function showalert(event)
{
	
	if(navigator.appName=="Microsoft Internet Explorer")
	{
		event=window.event;
		var alertMenu=document.getElementById("alertMenu");
		alertMenu.style.left=(event.clientX)+document.body.scrollLeft+20;
		alertMenu.style.top=(event.clientY)+document.body.scrollTop+10;
		alertMenu.style.visibility='visible';
		alertMenu.style.display='block';
	}
	else
	{
		var alertMenu=window.parent.document.getElementById("alertMenu");
		alertMenu.style.left=(event.clientX)+document.body.scrollLeft+20;
		alertMenu.style.top=(event.clientY)+document.body.scrollTop+10;
		alertMenu.style.visibility='visible';
		alertMenu.style.display='block';
	}
}


function menu_onmouseover()
{
	if(this.style!=null)
	{
		this.className="tree_over_border tree_font";
	}
	
}

function menu_onmouseout()
{
	if(this.style!=null)
	{
		this.className="eg_whitebg tree_font";
	}
}

function context()
{
	return false;
}

function linkOnclick(url,id,nodeId,noOfNodes)
{
	var d=new dTree('d');
	var csrfToken = document.getElementById("csrfToken").value;
	var item="";
	myArray = window.parent.groupArray;
	if (myArray != null && myArray.length > 0)
	{
		for (i=0;i<myArray.length;i++)
		{
			if (i == 0)
			{
				item = item + myArray[i];
			}
			else
			{
				item = item +"|#|"+myArray[i];
			}
		}
	}
	url = encodeURI(url);
	url = url +"&checkedGroups="+encodeURIComponent(item);
	if (csrfToken != null && csrfToken != 'undefined')
	{
		url = url +"&com.eg.CSRF_NONCE="+csrfToken;
	}

	var target=window.parent.document.getElementById(id);
	if(target!=null && target!="undefined")
	{
		target.src=url;
	}
	for(var n=0;n<noOfNodes;n++)
	{
		var node=document.getElementById("nodeATag"+n);
		if(node!=null)
			node.className='eg_adminlink';
	}

	var aTagObj=document.getElementById("nodeATag"+nodeId);
	var selectedNode=window.parent.document.getElementById("selectedNode");
	if(aTagObj!=null && aTagObj!='undefined')
	{
		aTagObj.className='nodeSel';
		if(selectedNode!=null && selectedNode!='undefined')
		{
			selectedNode.value="nodeATag"+id;
		}
	}
}

// Node object
function Node(id, pid, name, url, title, target, icon, iconOpen, open,nodeType,noOfPolicies,singlePolicyGroups) {
	this.id = id;
	this.pid = pid;
	this.name = name;
	this.url = url;
	this.title = title;
	this.target = target;
	this.icon = icon;
	this.iconOpen = iconOpen;
	this._io = open || false;
	this._is = false;
	this._ls = false;
	this._hc = false;
	this._ai = 0;
	this._p;
	this.nodeType=nodeType;
	this.noOfPolicies=noOfPolicies;
	this.singlePolicyGroups=singlePolicyGroups;
};

// Tree object
function dTree(objName) {
	this.config = {
		target					: null,
		folderLinks				: true,
		useSelection			: true,
		useCookies				: true,
		useLines				: true,
		useIcons				: true,
		useStatusText			: false,
		closeSameLevel			: false,
		inOrder					: false
	}
	this.icon = {
		root					: '/final/admin/eg_images/maintenancepolicy.gif',
		folder					: '/final/admin/eg_images/tree/folder.gif',
		folderOpen				: '/final/admin/eg_images/tree/folderopen.gif',
		node					: '/final/admin/eg_images/tree/page.gif',
		empty					: '/final/admin/eg_images/tree/empty.gif',
		line					: '/final/admin/eg_images/tree/line.gif',
		join					: '/final/admin/eg_images/tree/join.gif',
		joinBottom				: '/final/admin/eg_images/tree/joinbottom.gif',
		plus					: '/final/admin/eg_images/tree/plus.gif',
		plusBottom				: '/final/admin/eg_images/tree/plusbottom.gif',
		minus					: '/final/admin/eg_images/tree/minus.gif',
		minusBottom				: '/final/admin/eg_images/tree/minusbottom.gif',
		nlPlus					: '/final/admin/eg_images/tree/nolines_plus.gif',
		nlMinus					: '/final/admin/eg_images/tree/nolines_minus.gif'
	};

	this.obj = objName;
	this.aNodes = [];
	this.aIndent = [];
	this.root = new Node(-1);
	this.selectedNode = null;
	this.selectedFound = false;
	this.completed = false;
};

// Adds a new node to the node array
dTree.prototype.add = function(id, pid, name, url, title, target, icon, iconOpen, open,nodeType,noOfPolicies,singlePolicyGroups) 
{
	this.aNodes[this.aNodes.length] = new Node(id, pid, name, url, title, target, icon, iconOpen, open,nodeType,noOfPolicies,singlePolicyGroups);
	var treeRefreshDiv=window.parent.document.getElementById("treeRefreshDiv");
	var str='';
	var n=this.aNodes.length-1;
};

// Open/close all nodes
dTree.prototype.openAll = function() {
	this.oAll(true);
};

dTree.prototype.closeAll = function() {
	this.oAll(false);
};

// Outputs the tree to the page
dTree.prototype.toString = function() {
	var str = '<div class="dtree">\n';
	if (document.getElementById) 
	{
		if (this.config.useCookies) this.selectedNode = this.getSelected();
			str += this.addNode(this.root);
	}
	else 
		str += 'Browser not supported.';
	str += '</div>';
	if (!this.selectedFound) this.selectedNode = null;
	this.completed = true;
	return str;
};

// Creates the tree structure
dTree.prototype.addNode = function(pNode) {
	var str = '';
	var n=0;
	if (this.config.inOrder) n = pNode._ai;
	for (n; n<this.aNodes.length; n++) {
		if (this.aNodes[n].pid == pNode.id) {
			var cn = this.aNodes[n];
			cn._p = pNode;
			cn._ai = n;
			this.setCS(cn);
			if (!cn.target && this.config.target) cn.target = this.config.target;
			if (cn._hc && !cn._io && this.config.useCookies) cn._io = this.isOpen(cn.id);
			if (!this.config.folderLinks && cn._hc) cn.url = null;
			if (this.config.useSelection && cn.id == this.selectedNode && !this.selectedFound) {
					cn._is = true;
					this.selectedNode = n;
					this.selectedFound = true;

			}
			str += this.node(cn, n);
			if (cn._ls) break;
		}
	}
	return str;
};

// Creates the node icon, url and text
dTree.prototype.node = function(node, nodeId)
{
	var nodeType=node.nodeType+"";
	var nodename=node.name;
	var type=node.nodeType;
	var parentNode=this.aNodes[node.pid];
	var parentName="";
	if(parentNode!=null && parentNode!="undefined")
	{
		parentName=parentNode.name;
	}
	//var str = '<div class="dTreeNode" style="font-size:7.5pt;color:#000000">' + this.indent(node, nodeId);
	//var str = '<div class="dTreeNode" style="font-size:7.5pt;color:#000000" oncontextmenu="return false;">';
	var str = '<div class="dTreeNode" style="font-size:7.5pt;color:#000000" oncontextmenu="return false;">' + this.indent(node, nodeId);
	if (this.config.useIcons) 
	{
		if (!node.icon) node.icon = (this.root.id == node.pid) ? this.icon.root : ((node._hc) ? this.icon.folder : this.icon.node);
		if (!node.iconOpen) node.iconOpen = (node._hc) ? this.icon.folderOpen : this.icon.node;
		/*
		if (this.root.id == node.pid) 
		{
			node.icon = this.icon.root;
			node.iconOpen = this.icon.root;
		}
		*/
		str += '<img  border="0" id="i' + this.obj + nodeId + '" src="' + ((node._io) ? node.iconOpen : node.icon) + '" alt="" />';
	}
	if(nodeType=='-1')
	{
		str +='<span><input type="hidden" value="'+nodeType+'#'+nodename+'#'+nodeId+'#'+node.pid+'#'+parentName+'#'+this.aNodes.length+'"/>'+node.name+'</span>';
	}
	else
	{
		str +='<span><input type="hidden" value="'+nodeType+'#'+nodename+'#'+nodeId+'#'+node.pid+'#'+parentName+'#'+this.aNodes.length+'"/><a id="nodeATag'+nodeId+'" class="eg_adminlink" href=javascript:linkOnclick("'+node.url+'","'+node.target+'",'+nodeId+','+this.aNodes.length+')>'+node.name+'</a></span>';
	}

	str += '</div>';
	if (node._hc) {
		str += '<div style="border:0px solid #ff0000;" id="d' + this.obj + nodeId + '" class="clip" style="display:' + ((this.root.id == node.pid || node._io) ? 'block' : 'none') + ';">';
		str += this.addNode(node);
		str += '</div>';
	}
	this.aIndent.pop();
	return str;
};

// Adds the empty and line icons
dTree.prototype.indent = function(node, nodeId) {
	var str = '';
	if (this.root.id != node.pid) {
		for (var n=0; n<this.aIndent.length; n++)
			str += '<img src="' + ( (this.aIndent[n] == 1 && this.config.useLines) ? this.icon.line : this.icon.empty ) + '" alt="" />';
		(node._ls) ? this.aIndent.push(0) : this.aIndent.push(1);
		if (node._hc) {
			//str += '<a class="eg_adminlink" href="javascript: ' + this.obj + '.o(' + nodeId + ');"><img border="0" id="j'  + this.obj + nodeId + '" src="';
			str += '<a class="eg_adminlink" id="anchorTag'+nodeId+'" name="anchorTag'+nodeId+'" href="javascript:void(0)" onclick="javascript: ' + this.obj + '.o(' + nodeId + ',this,event);"><img border="0" id="j'  + this.obj + nodeId + '" src="';
			//str += '<a class="eg_adminlink" href="javascript: ' + this.obj + '.o(' + nodeId + ',this,event);"><img border="0" id="j'  + this.obj + nodeId + '" src="';
			if (!this.config.useLines) str += (node._io) ? this.icon.nlMinus : this.icon.nlPlus;
			else str += ( (node._io) ? ((node._ls && this.config.useLines) ? this.icon.minusBottom : this.icon.minus) : ((node._ls && this.config.useLines) ? this.icon.plusBottom : this.icon.plus ) );
			str += '" alt="" /></a>';
		} else str += '<img src="' + ( (this.config.useLines) ? ((node._ls) ? this.icon.joinBottom : this.icon.join ) : this.icon.empty) + '" alt="" />';
	}
	return str;
};

// Checks if a node has any children and if it is the last sibling
dTree.prototype.setCS = function(node) {
	var lastId;
	for (var n=0; n<this.aNodes.length; n++) {
		if (this.aNodes[n].pid == node.id) node._hc = true;
		if (this.aNodes[n].pid == node.pid) lastId = this.aNodes[n].id;
	}
	if (lastId==node.id) node._ls = true;
};

// Returns the selected node
dTree.prototype.getSelected = function() {
	var sn = this.getCookie('cs' + this.obj);
	return (sn) ? sn : null;
};

dTree.prototype.highlightNodeByProcess=function(name)
{
	//if(process=="start")
	if(true)
	{
		var treeSelectionDiv=window.parent.document.getElementById("treeSelectionDiv");
		if(treeSelectionDiv!=null)
		{
			var hiddenElements=treeSelectionDiv.getElementsByTagName("input");
			for(var i=0;i<hiddenElements.length;i++)
			{
				var nodeName=hiddenElements[i].value;
				var node=document.getElementById(nodeName);
				node.className='eg_adminlink';
			}
			treeSelectionDiv.innerHTML="";
		}
		for (var n=0;n<this.aNodes.length ;n++ )
		{
			if(this.aNodes[n].name==name)
			{
				var node=document.getElementById("nodeATag"+n);
				node.className='nodeSel';
				//This is for Highlight the selected node
				var treeSelectionDiv=window.parent.document.getElementById("treeSelectionDiv");
				var aTagObj=document.getElementById("nodeATag"+n);
				if(aTagObj!=null && aTagObj!='undefined')
				{
					aTagObj.className='nodeSel';
					if(treeSelectionDiv!=null)
					{
						treeSelectionDiv.innerHTML+='<input type="hidden" value="nodeATag'+n+'">';
						break;
					}
				}
			}
		}
	}
}

// Highlights the selected node
dTree.prototype.s = function(id) {
	var eRoot = document.getElementById("s" + this.obj + 0);
	eRoot.className = "node";
	if (!this.config.useSelection) return;
	var cn = this.aNodes[id];
	if (cn._hc && !this.config.folderLinks) return;
	if (this.selectedNode != id) {
		if (this.selectedNode || this.selectedNode==0) {
			eOld = document.getElementById("s" + this.obj + this.selectedNode);
			eOld.className = "node";
		}
		eNew = document.getElementById("s" + this.obj + id);
		eNew.className = "nodeSel";
		this.selectedNode = id;
		if (this.config.useCookies) this.setCookie('cs' + this.obj, cn.id);
	}
};



// Toggle Open or close
dTree.prototype.o = function(id,thisObj,e)
{
	try
	{
		var cn = this.aNodes[id];
		var domURL = cn.url;
		var isDomainOU = false;
		if (domURL.indexOf("EgListDomainOUs.jsp") != -1)
		{
			isDomainOU = true;
		}
		var treeIdValue=window.parent.document.getElementById("opentree"+id);
		if(treeIdValue!=null)
		{
			treeIdValue.value=""+(!cn._io);
		}
		this.nodeStatus(!cn._io, id, cn._ls);
		cn._io = !cn._io;
		if (this.config.closeSameLevel) this.closeLevel(cn);
		if (this.config.useCookies) this.updateCookie();

		var openNodeId=window.parent.document.getElementById("openNodeId");
		if(cn._io)
		{
			openNodeId.value=id;
		}
		var tmpID = document.getElementById('d' + this.obj + id);
		var isNodeOpened = tmpID.style.display;
		if (isNodeOpened != "none")
		{
			if (cn.pid == 0)
			{
				getChildrens(cn.name,cn.id,thisObj,e,id,isDomainOU);
			}
		}
	}
	catch(ex)
	{
		var tmpID = document.getElementById('d' + this.obj + id);
		var isNodeOpened = tmpID.style.display;
		if (isNodeOpened != "none")
		{
			var domURL = cn.url;
			var isDomainOU = false;
			if (domURL.indexOf("EgListDomainOUs.jsp") != -1)
			{
				isDomainOU = true;
			}
			if (cn.pid == 0)
			{
				getChildrens(cn.name,cn.id,thisObj,e,id,isDomainOU);
			}
		}
	}
};



// Open or close all nodes
dTree.prototype.oAll = function(status) {
	for (var n=0; n<this.aNodes.length; n++) 
		{
			try
			{
				if (this.aNodes[n]._hc && this.aNodes[n].pid != this.root.id) 
				{
					this.nodeStatus(status, n, this.aNodes[n]._ls)
					this.aNodes[n]._io = status;
				}
			}
			catch(Ex)
			{}
	}
};



// Opens the tree to a specific node
dTree.prototype.openTo = function(nId, bSelect, bFirst) {
	if (!bFirst) {
		for (var n=0; n<this.aNodes.length; n++) {
			if (this.aNodes[n].id == nId) {
				nId=n;
				break;
			}
		}
	}
	var cn=this.aNodes[nId];
	if (cn.pid==this.root.id || !cn._p) return;
	cn._io = true;
	cn._is = bSelect;
	if (this.completed && cn._hc) this.nodeStatus(true, cn._ai, cn._ls);
	if (this.completed && bSelect) this.s(cn._ai);
	else if (bSelect) this._sn=cn._ai;
	this.openTo(cn._p._ai, false, true);
};



// Closes all nodes on the same level as certain node

dTree.prototype.closeLevel = function(node) {
	for (var n=0; n<this.aNodes.length; n++) {
		if (this.aNodes[n].pid == node.pid && this.aNodes[n].id != node.id && this.aNodes[n]._hc) {
			this.nodeStatus(false, n, this.aNodes[n]._ls);
			this.aNodes[n]._io = false;
			this.closeAllChildren(this.aNodes[n]);
		}
	}
}

// Closes all children of a node
dTree.prototype.closeAllChildren = function(node) {
	for (var n=0; n<this.aNodes.length; n++) {
		if (this.aNodes[n].pid == node.id && this.aNodes[n]._hc) {
			if (this.aNodes[n]._io) this.nodeStatus(false, n, this.aNodes[n]._ls);
			this.aNodes[n]._io = false;
			this.closeAllChildren(this.aNodes[n]);		
		}
	}
}

// Change the status of a node(open or closed)
dTree.prototype.nodeStatus = function(status, id, bottom) 
{
	try
	{
		eDiv	= document.getElementById('d' + this.obj + id);
		eJoin	= document.getElementById('j' + this.obj + id);
		if (this.config.useIcons) {
			eIcon	= document.getElementById('i' + this.obj + id);
			eIcon.src = (status) ? this.aNodes[id].iconOpen : this.aNodes[id].icon;
		}
		eJoin.src = (this.config.useLines)?
		((status)?((bottom)?this.icon.minusBottom:this.icon.minus):((bottom)?this.icon.plusBottom:this.icon.plus)):
		((status)?this.icon.nlMinus:this.icon.nlPlus);
		eDiv.style.display = (status) ? 'block': 'none';
	}
	catch(Ex)
	{}
};

// [Cookie] Clears a cookie
dTree.prototype.clearCookie = function() {
	var now = new Date();
	var yesterday = new Date(now.getTime() - 1000 * 60 * 60 * 24);
	this.setCookie('co'+this.obj, 'cookieValue', yesterday);
	this.setCookie('cs'+this.obj, 'cookieValue', yesterday);
};

// [Cookie] Sets value in a cookie
dTree.prototype.setCookie = function(cookieName, cookieValue, expires, path, domain, secure) {
	document.cookie =
		escape(cookieName) + '=' + escape(cookieValue)
		+ (expires ? '; expires=' + expires.toGMTString() : '')
		+ (path ? '; path=' + path : '')
		+ (domain ? '; domain=' + domain : '')
		+ (secure ? '; secure' : '');
};

// [Cookie] Gets a value from a cookie
dTree.prototype.getCookie = function(cookieName) {
	var cookieValue = '';
	var posName = document.cookie.indexOf(escape(cookieName) + '=');
	if (posName != -1) {
		var posValue = posName + (escape(cookieName) + '=').length;
		var endPos = document.cookie.indexOf(';', posValue);
		if (endPos != -1) cookieValue = unescape(document.cookie.substring(posValue, endPos));
		else cookieValue = unescape(document.cookie.substring(posValue));
	}
	return (cookieValue);
};

// [Cookie] Returns ids of open nodes as a string
dTree.prototype.updateCookie = function() {
	var str = '';
	for (var n=0; n<this.aNodes.length; n++) {
		if (this.aNodes[n]._io && this.aNodes[n].pid != this.root.id) {
			if (str) str += '.';
			str += this.aNodes[n].id;
		}
	}
	this.setCookie('co' + this.obj, str);
};


// [Cookie] Checks if a node id is in a cookie
dTree.prototype.isOpen = function(id) {
	var aOpen = this.getCookie('co' + this.obj).split('.');
	for (var n=0; n<aOpen.length; n++)
		if (aOpen[n] == id) return true;
	return false;
};

// If Push and pop is not implemented by the browser
if (!Array.prototype.push) {
	Array.prototype.push = function array_push() {
		for(var i=0;i<arguments.length;i++)
			this[this.length]=arguments[i];
		return this.length;
	}
};

if (!Array.prototype.pop) {
	Array.prototype.pop = function array_pop() {
		lastElement = this[this.length-1];
		this.length = Math.max(this.length-1,0);
		return lastElement;
	}
};

dTree.prototype.selectRoot = function() {
	var eId  = document.getElementById("s" + this.obj + 0);
	eId.className = "nodeSel";
};

function getChildrens(seletedNode,seletedNodeId,thisObj,e,id,isDomainOU)
{
	var csrfToken = document.getElementById("csrfToken").value;
	var tagID = "anchorTag"+id;
	var position = getMousePosition(e);

	var url = "/final/servlet/com.egurkha.GroupSearch?requestStr=findChildrens&seletedNode="+encodeURIComponent(seletedNode)+"&seletedNodeId="+seletedNodeId+"&positionX="+position.x+"&positionY="+position.y+"&tagID="+tagID+"&date="+encodeURIComponent(filterEncode(new Date()));
	if (isDomainOU)
	{
		url += "&fromOUs=true";
	}
	
	if (csrfToken != null && csrfToken != 'undefined')
	{
		url += "&com.eg.CSRF_NONCE="+csrfToken;
	}
	var domainTree = document.getElementById("domainTree");
	domainTree.method = "POST";
	domainTree.action = url;
	domainTree.submit();
}

function getMousePosition(e) {

	var position = new Object();
	var isIE = document.all ? true : false;
	var _x;
	var _y;
	if (!isIE) {
		_x = e.pageX;
		_y = e.pageY;
	}
	if (isIE) {
		_x = event.clientX + document.body.scrollLeft;
		_y = event.clientY + document.body.scrollTop;
	}
	posX = _x;
	posY = _y;
	position.x = posX;
	position.y = posY;
	return position;
}

function loadTree(seletedNode)
{
	var url = "/final/servlet/com.egurkha.GroupSearch?requestStr=findChildrens&seletedNode="+encodeURIComponent(seletedNode);
	if (window.XMLHttpRequest)
	{// code for IE7+, Firefox, Chrome, Opera, Safari
		xmlhttp=new XMLHttpRequest();
	}
	else
	{// code for IE6, IE5
		xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
	}
	xmlhttp.onreadystatechange=state_Change_Ajax;
	xmlhttp.open("GET",url,false);
	xmlhttp.send();
}

function state_Change_Ajax()
{
	var sourcePageDiv = document.getElementById("sourcePageDiv");
	var idObj1 = window.document.getElementById("treeLoad");
	idObj1.style.display="block";
	if (xmlhttp.readyState == 4)
	{
		try
		{
			if (xmlhttp.status == 200)
			{
				val = xmlhttp.responseText;
				sourcePageDiv.innerHTML = val;
				sourcePageDiv.style.visibility = "visible";
				sourcePageDiv.style.display = "block";
			}
		}
		catch (error)
		{
		}
	}
}

function filterEncode(text)
{
	text = text.toString();

	//['%;()=]
	var filterEncodeChar = ['[',']','(',')','=','&','%','\''];
	var filterDecodeText = ['|lsbr|','|rsbr|','|lbr|','|rbr|','|eq|','|ampsnd|','|per|','|squot|'];
	try
	{
		if(text != null && text != undefined && text != '' && text.length != 0 )
		{
			for(var a in filterEncodeChar)
			{
				var encode_char = filterEncodeChar[a];
				var decode_char = filterDecodeText[a];
				do
				{
					text=text.replace(encode_char,decode_char);
				}
				while (text.indexOf(encode_char)>-1);
			}
		}
	}
	catch (e)
	{
		console.log('Exception ',e);
	}
	return text;
}

function filterDecode(text)
{
	text = text.toString();

	//['%;()=]
	var filterEncodeChar = ['[',']','(',')','=','&','%','\''];
	var filterDecodeText = ['|lsbr|','|rsbr|','|lbr|','|rbr|','|eq|','|ampsnd|','|per|','|squot|'];
	try
	{
		if(text != null && text != undefined && text != '' && text.length != 0 )
		{
			for(var a in filterEncodeChar)
			{
				var encode_char = filterEncodeChar[a];
				var decode_char = filterDecodeText[a];
				do
				{
					text=text.replace(decode_char,encode_char);
				}
				while (text.indexOf(decode_char)>-1);
			}
		}
	}
	catch (e)
	{
		console.log('exception ',e);
	}
	return text;
}



