Ext.define('HelpApp.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Main'],
	refs: [{selector:'main',ref:'main'}] ,
	init:function()
	{
		getController= this;
		this.control({
			'main' :
			{
				'boxready' : this.afterMainRender
			},
			'main trigger[id="helpSearch"]':
			{
				'keyup': this.search
			},
			'main button[id="back"]':
			{
				'click': this.goBack
			}
		});
	},
	goBack: function()
	{

		Ext.getCmp('helpSearch').setValue('');
		this.search();
	},
	search: function( obj )
	{
		var searchLinkObj = Ext.get('searchLinks');
		var searchResObj = Ext.get('searchResults');
		var searchText = Ext.getCmp('helpSearch').getValue();
		if ( !Ext.isEmpty( searchText ) )
		{
			//Ext.getCmp('backContainer').show();
			searchLinkObj.hide();
			searchResObj.show();
			var cnt = 0;
			var genHTML = '<div style="border:0px solid green"><ul><li  class="accordionHead1"><div style="border:0px solid red;display:block;width:240px;">Search Result For \''+searchText+'\'</div></li>';
			var searchPresent = false;
			if ( bufferSearchArr[searchText] != undefined )
			{
				var bSearchArr = bufferSearchArr[searchText];
				for ( var key in bSearchArr )
				{
					var text = bSearchArr[key];
					var link = key;
					searchPresent = true;
					genHTML += '<li id="searchResLink'+cnt+'" class="accordionChild1">'
							  +'<div class="nochild" id="searchResults" ><a href="javascript:void(0);" onclick="javascript:openHelpPage(\''+link+'\');selectSearchLink(\'searchResLink'+cnt+'\');" title="'+text+'">'+text+'</a></div>'
							  +'</li>'
							  +'</ul>';
					cnt++;
				}
			}
			else
			{
				var tmpBufferRes = new Array();
				for ( var key in searchArr )
				{
					var text = searchArr[key];
					var link = key;
					if ( text.toLowerCase().indexOf(searchText.toLowerCase()) > -1 )
					{
						searchPresent = true;

						genHTML += '<li id="searchResLink'+cnt+'" class="accordionChild1">'
								  +'<div class="nochild" id="searchResults"><a href="javascript:void(0);" onclick="javascript:openHelpPage(\''+link+'\');selectSearchLink(\'searchResLink'+cnt+'\');" title="'+text+'">'+text+'</a></div>'
								  +'</li>'
								  +'</ul>';
						tmpBufferRes[link] = text;
					}
					cnt++;
				}
				if ( bufferSearchArr[searchText] == undefined )
				{
					bufferSearchArr[searchText] = tmpBufferRes;
				}
			}
			if ( !searchPresent )
			{
				genHTML = '<ul><li  class="accordionHead1"><div style="border:0px solid red;display:block;width:240px;">Search Result For \''+searchText+'\'</div></li></ul><div style="text-align:center;padding-top:70%;height:480px;"><div class=iconExclamation style="margin-left: 125px;"></div><div>No match found for &nbsp;<b>\''+searchText+'\'</b>.</div></div>';
			}
			genHTML +='</div>';
			searchResObj.update(genHTML);
			$('#searchLinks').css({'display':'none'});

		}
		else
		{
			searchLinkObj.show();
			searchResObj.update('');
			searchResObj.hide();
			Ext.getCmp('backContainer').hide();
			if ( !Ext.isEmpty( lastOpenedPage ) )
			{
				openHelpPage( lastOpenedPage );
				markPreviousOne();
			}
		}
		Ext.getCmp('left-win').doLayout();
	},
	afterMainRender: function()
	{
		if ( !Ext.isEmpty( publicJSON ) )
		{
			this.loadHelpIndexData( publicJSON );
		}
	},
	loadHelpIndexData: function( jsonData )
	{
		var helpAppObj = Ext.getCmp('left-win');
		var centerRegionTitle = Ext.getCmp('canterRegion');

		helpAppObj.removeAll();
		var pageId = '';
		var helpPageURL = '';
		Ext.Ajax.request(
		{
			url: pageURL,
			method: 'GET',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode( jsonText );
					if ( !Ext.isEmpty( jsonData ) )
					{
						pageId = jsonData['PAGE_ID'];
						helpPageURL = jsonData['PAGE_URL'];
						lastOpenedPage = pageURL;

						//centerRegionTitle.setTitle(moduleName);
					}
				}
			}
		});

		var iframeObj = Ext.select('#target-win');
		iframeObj.set({
			src: helpPageURL
		});
		if ( !Ext.isEmpty( jsonData ) )
		{
			searchArr = new Array();
			var subjects = jsonData['SUBJECTS'];
			var genHtml = '<div id="searchHeaders"><div id="searchResults" style="visibility:hidden;display:none;"></div><div id="searchLinks" style=""><div style="" id="helpHeaders"><ul>';
			var subjectHTML = '';
			var openOuterPanel = '';
			var openInnerPanel = '';
			var linkCnt = 0;
			var childLinkId = 0;
			pageSelected = new Array();
			for ( var i = 0;i < subjects.length; i++ )
			{
				var subjectName = subjects[i]['SUBJECT_NAME'];
				var headers = subjects[i]['HEADERS'];
				genHtml += '<li  class="accordionHead1"><a href="javascript:void(0);" id="header'+i+'" class="helpToggleRightarrow" onclick="javascript:hideMe(\'subject'+i+'\',this);" title="'+subjectName+'"><div style="border:0px solid red;display:block;width:240px;">'+subjectName+'</div> </a> </div></li><li id="subject'+i+'" style="display:none;visibility:hidden;border:0px solid black">';

				for ( var j = 0; j < headers.length; j++ )
				{
					var isInnerTreePresent = ( headers[j]['INNER_TREE_PRESENT'] == 'yes' )?true:false;
					var headerName = headers[j]['TEXT'];
					if ( isInnerTreePresent )
					{
						headerName = '<div class="accordionHead2" ><a id="header'+j+'" href="javascript:void(0);" onclick="javascript:hideMe(\'child'+(childLinkId)+'\',this);" title="'+headerName+'" class="helpsubToggleRightarrow"><span>'+headerName+'</span></a></div>';
						var innerTree = headers[j]['INNER_TREE'];
						var innerTreeHtml = '<ul id="child'+(childLinkId)+'" style="display:none;border:0px solid blue">';
						for ( var k = 0; k < innerTree.length; k++ )
						{
							var innerLink = innerTree[k]['LINK'];
							var innerText = innerTree[k]['TEXT'];
							var getPageId = innerLink.substring( innerLink.indexOf('=') + 1 );
							var selectedColor = '';
							var selectedFontColor = '';
							var borderColor = '';
							if ( getPageId == pageId )
							{
								if(helpskin=="Light")
								{
									openOuterPanel = 'subject'+i;
									openInnerPanel = 'child'+childLinkId;
									selectedColor = '93c5e9';
									borderColor = '6ab0e2';
									selectedFontColor = 'ffffff';
									pageSelected[pageSelected.length] = 'link'+linkCnt;
									prevHeaderSelection = 'subject'+i;
									prevSubHeaderSelection = 'child'+childLinkId;
									prevLinkIsInner = 'true';
								}
								else
								{
									openOuterPanel = 'subject'+i;
									openInnerPanel = 'child'+childLinkId;
									selectedColor = '4c4c4c';
									borderColor = '4c4c4c';
									selectedFontColor = 'ffffff';
									pageSelected[pageSelected.length] = 'link'+linkCnt;
									prevHeaderSelection = 'subject'+i;
									prevSubHeaderSelection = 'child'+childLinkId;
									prevLinkIsInner = 'true';
								}
							}
							searchArr[innerLink] =  innerText;
							innerTreeHtml += '<li class="accordionChild1" id="link'+(linkCnt)+'" style="background:#'+selectedColor+';padding-left:15px;border-top:1px solid #'+borderColor+';border-bottom:1px solid #'+borderColor+'"><a href="javascript:void(0);"  style="color:#'+selectedFontColor+'" onclick="javascript:openHelpPage(\''+innerLink+'\');selectMe('+linkCnt+', \'true\');" title="'+innerText+'" id="innerlink'+(linkCnt)+'">'+innerText+'</a></li>';
							linkCnt++;
						}
						childLinkId++;
						innerTreeHtml +='</ul>';
						genHtml += '<div class="nochild" style="border:0px solid yellow;"><a href="javascript:void(0);" class="noChildlink" id="innerTreeHtml'+(linkCnt)+'">'+headerName+'</a>'+innerTreeHtml+'</div>';
					}
					else
					{
						var headerLink = headers[j]['LINK'];
						var getPageId = headerLink.substring( headerLink.indexOf('=') + 1 );
						var selectedColor = '';
						var selectedFontColor = '';
						var borderColor = '';
						if ( getPageId == pageId )
						{
							if(helpskin=="Light")
							{
								openOuterPanel = 'subject'+i;
								selectedColor = '93c5e9';
								borderColor = '6ab0e2';
								selectedFontColor = 'ffffff';
								pageSelected[pageSelected.length] = 'link'+linkCnt;
								prevLinkIsInner = 'false';
								prevHeaderSelection = 'subject'+i;
							}
							else
							{
								openOuterPanel = 'subject'+i;
								selectedColor = '4c4c4c';
								borderColor = '4c4c4c';
								selectedFontColor = 'ffffff';
								pageSelected[pageSelected.length] = 'link'+linkCnt;
								prevLinkIsInner = 'false';
								prevHeaderSelection = 'subject'+i;
							}
						}
						searchArr[headerLink] =  headerName;
						genHtml += '<div class="nochild accordionChild" id="link'+(linkCnt)+'" style="background:#'+selectedColor+';border-top:1px solid #'+borderColor+';border-bottom:1px solid #'+borderColor+'"><a href="javascript:void(0);"  style="color:#'+selectedFontColor+'" onclick="javascript:openHelpPage(\''+headerLink+'\');selectMe('+linkCnt+',\'false\');" title="'+headerName+'" >'+headerName+'</a></div>';
						linkCnt++;
					}
				}
				genHtml +='</li>';
			}
			genHtml +='</ul></div></div>';
			helpAppObj.add(
					{
					xtype:'panel',
					scroll: true,
					frame:false,
					margin:0,
					padding:0,
					id:'p1',
					layout:'fit',
					cls:'helpPagebg',
					autoScroll: true,
					/*
					listeners:
					{
						afterlayout:function()
						{
							$(function()
							{
								var pane = $('#searchHeaders');
								$('#searchHeaders').height(480);
								pane.jScrollPane();
								var api = pane.data('jsp');
								api.reinitialise();
								var totalWidth = $('#p1-body').outerWidth(true); //width fix
								$('#p1-body .jspPane').width(totalWidth - ($('#p1-body .jspVerticalBar').width()));  //width fix
							});
						}
					},*/
					html:genHtml
				});
			if ( !Ext.isEmpty( openOuterPanel ) )
			{
				hideMe(openOuterPanel,this);


			}
			if ( !Ext.isEmpty( openInnerPanel ) )
			{
				hideMe(openInnerPanel,this);
			}
		}
		helpAppObj.doLayout();
	}
});