Ext.define('HelpApp.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Main'],
	refs: [{selector:'main',ref:'main'}] ,
	init:function(){
		this.control({
			'main' : {
				'afterrender' : this.afterMainRender
			}
		});
	},
	afterMainRender: function()
	{
		if ( !Ext.isEmpty( publicJSON ) )
		{
			this.loadHelpIndexData( publicJSON );
		}
	},
	loadHelpIndexData: function( jsonData )
	{
		var helpAppObj = Ext.getCmp('left-win');
		helpAppObj.removeAll();
		if ( !Ext.isEmpty( jsonData ) )
		{
			var subjects = jsonData['SUBJECTS'];
			var subArr = new Array();
			for ( var i = 0;i < subjects.length; i++ )
			{
				var sbjName = subjects[i]['SUBJECT_NAME'];
				var headers = subjects[i]['HEADERS'];
				var headerArr = new Array();
				var enableAccordion = false;
				for ( var j = 0; j < headers.length; j++ )
				{
					var isInnerTreePresent = (headers[j]['INNER_TREE_PRESENT'] == 'yes' )?true:false;
					var headerName = headers[j]['TEXT'];
					var innerTreeArr = new Array();
					if ( isInnerTreePresent )
					{
						enableAccordion = true;
						headerName = '<b>'+headerName+'</b>';
						var innerTree = headers[j]['INNER_TREE'];
						for ( var k = 0; k < innerTree.length; k++ )
						{
							var innerLink = innerTree[k]['LINK'];
							var innerText = innerTree[k]['TEXT'];
							innerTreeArr.push({
								xtype:'panel',
								title:innerText,
								baseCls:'dummyCls',
								
								html: '<ul><li><a href="javascript:void(0);" onclick="javascript:openHelpPage(\''+innerLink+'\')">'+innerText+'</a></li></ul>'
							});
						}
					}
					else
					{
						var headerLink = headers[j]['LINK'];
						headerName = '<a href="javascript:void(0);" onclick="javascript:openHelpPage(\''+headerLink+'\');">'+headerName+'</a>';
						
					}
					if ( isInnerTreePresent )
					{
						headerArr.push(
							{
								xtype:'panel',
								title: headerName,
								baseCls:'dummyCls',
								hideCollapseTool: false,
								items: innerTreeArr
							});
					}
					else
					{
						headerArr.push(
							{
								xtype:'panel',
								title: headerName,
								hideCollapseTool: true,
								baseCls:'dummyCls'
							});
					}
				}
				subArr.push(
							{
								xtype:'panel',
								scroll: true,
								autoScroll: true,
								title:sbjName,
								cls:'block1',
								layout:{
									type: 'accordion',
									height:200,
									titleCollapse: false,
									animate: true,
									activeOnTop: true
									},
								items: headerArr
							}
					);
			}
			helpAppObj.add(
				{
					xtype:'panel',
					layout:
					{
						type: 'accordion',
						titleCollapse: false,
						animate: true,
						activeOnTop: true
					},
					items:subArr
				});
		}
		helpAppObj.doLayout();
	}
});