function validateAppServerCredentailsValue(configurationType,urlForAppServerValidation,params,from,componentType,testName,multiUserMode,allowHostName,requiredParamNames,formObj)
{
	var fieldsArr = formObj.getFields().items;

	var wsdlurl = Ext.getCmp("WSDL_URL");
	if(wsdlurl!=undefined && wsdlurl!=null && wsdlurl!='')
	{
		var urlValue = wsdlurl.getValue();
		if(urlValue.indexOf("$unconfigured")>-1)
		{
			Ext.Msg.show({
				title: pageName,
				msg: enterWsdl,
				buttons: Ext.Msg.OK,
				icon: Ext.Msg.WARNING,
			});
			return false;
		}
		else if(urlValue =='')
		{
			Ext.Msg.show({
				title: pageName,
				msg: enterWsdl,
				buttons: Ext.Msg.OK,
				icon: Ext.Msg.WARNING,
			});
			return false;
		}
	}

//	var xenValidation = document.getElementById("username");
//	var xenname = "";
//	var xenpassword = "";
//	var xenValidationURL = "";
//	if (xenValidation != null && xenValidation != "undefined")
//	{
//		xenname = window.document.getElementById("username").value;
//		xenpassword = window.document.getElementById("password").value;
//		xenValidationURL = xenValidationURL+"&xenMobileUserName="+xenname+"&xenMobilePassword="+xenpassword;
//	}

	var allowToUpdate = true;
	var numOfProcess = ""; // Added for ProcessTest
	var numOfUsers = ""; // Added for ProcessTest
	var credentialValue = "";
	var parameters="";
	var tcKeywords="";
	var doubleQuotesParams="";
	var userArr = "";
	var passArr = "";
	var hminvar = "";
	var domainCount=0;
	var credentialParamCase="";
	var defaultValueFound = false;

	if (!Ext.isEmpty(formObj.findField('allowedParams').getValue()))
	{
		parameters = formObj.findField('allowedParams').getValue();
	}
	if(!Ext.isEmpty(formObj.findField('strTcKeywords').getValue()))
	{
		tcKeywords = formObj.findField('strTcKeywords').getValue();
		tcKeywords = tcKeywords.split(",");
	}
	if(!Ext.isEmpty(formObj.findField('strDoubleQuotesParams').getValue()))
	{
		doubleQuotesParams = formObj.findField('strDoubleQuotesParams').getValue();
		doubleQuotesParams = doubleQuotesParams.split(",");
	}

	var paramWithValue="";
	for(j=0; j <fieldsArr.length; j++)
	{
		if (fieldsArr[j].xtype == 'radiofield' )
		{
			continue;
		}

		var paramName = "";
		var paramNameLowerCase = "";

		var paramId = fieldsArr[j].id;
		var paramIdLowerCase = paramId.toLowerCase();

		var paramValue = fieldsArr[j].getValue();

		if (fieldsArr[j].xtype == 'radiogroup')
		{
			var radioId = fieldsArr[j].id;
			var radioIdParam = radioId.substring(0,radioId.lastIndexOf("_"));
			//Ext.getCmp(radioIdParam);
			//if(Ext.getCmp(radioIdParam) == undefined)
			//{
				//continue;
			//}

			paramName = radioIdParam;
			paramNameLowerCase = paramName.toLowerCase();
			
			var radioIdValue = Ext.getCmp(radioIdParam+"1").getValue();
			if (radioIdValue)
			{
				paramValue = "true";
			}
			else
			{
				paramValue = "false";
			}
		}
		else
		{
			paramName = fieldsArr[j].name;
			paramNameLowerCase = paramName.toLowerCase();
		}
		
		if(paramNameLowerCase=="uname")
			paramNameLowerCase="esx_user";

		if(paramNameLowerCase=="pass")
			paramNameLowerCase="esx_password";

		if(paramNameLowerCase=="ipadd")
			paramNameLowerCase="host";

		if (typeof paramValue == 'string')
		{
			paramValue = trim(paramValue);
		}

		if(paramId  == "" || paramId  == null || (requiredParamNames!=null && (requiredParamNames.indexOf(","+paramNameLowerCase+",")==-1 && requiredParamNames.indexOf(paramNameLowerCase+",")==-1 && requiredParamNames.indexOf(","+paramNameLowerCase)==-1)))
		{
			if (paramId.indexOf("confirmpassword") == -1)
			{
				continue;
			}
		}
		var paramIdValue = Ext.getCmp(paramId).getValue();
		if (typeof paramIdValue == 'string')
		{
			paramIdValue = trim(paramIdValue);
		}

		if (Ext.isEmpty(paramIdValue))
		{
			paramIdValue = '';
		}

		if(fieldsArr[j].disabled)
		{
			continue;
		}

		if (configurationType == 'specificConfiguration')
		{
			var paramval = paramIdValue.toString().toLowerCase();
			var tcKey = "";
			var tcKeyWordCaught =  false;
			for (var z=0;z<tcKeywords.length;z++)
			{
				tcKey = tcKeywords[z].toLowerCase();
				if (paramval.indexOf(tcKey) != -1)
				{
					tcKeyWordCaught = true;
					Ext.Msg.show({
						title: pageName,
						msg: _tcKeyword,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}
				if (tcKey.indexOf(":") != -1 )
				{
					var splitKey = tcKey.split(":");
					var key1 = "";
					for(var i =0 ; i < splitKey.length;i++)
					{
						key1 = splitKey[i]+"";
						if (paramval.indexOf(key1) != -1)
						{
							tcKeyWordCaught = true;
							Ext.Msg.show({
								title: pageName,
								msg: _tcKeyword,
								buttons: Ext.Msg.OK,
								icon: Ext.Msg.WARNING,
								fn: function() {
									Ext.getCmp(paramId).focus();
								}
							});
							break;
						}
					}
					if(tcKeyWordCaught)
					{
						allowToUpdate = false;
						Ext.getCmp(paramId).focus();
						break;
					}
				}
			}

			if(!allowToUpdate)
			{
				break;
			}
		}

		if (fieldsArr[j].xtype == "text")
		{
			//new code starts
			if (paramValue == "")
			{
				Ext.Msg.show({
					title: pageName,
					msg: _checkempty,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING,
					fn: function() {
						Ext.getCmp(paramId).focus();
					}
				});
				allowToUpdate = false;
				break;
			}
			//else if(paramValue == "$unconfigured")
			//{
			//	alert(_tcKeyword);
			//	allowToUpdate = false;
			//	thisForm[j].focus();
			//	break;
			//}
			//else if(!checkHyphenText(paramValue,paramNameLowerCase))
			//{
			//	allowToUpdate = false;
			//	thisForm[j].focus();
			//	break;
			//}
			else if(paramNameLowerCase != "servicename" && 
					paramNameLowerCase != "snmpcommunity" && 
					paramNameLowerCase != "process" && 
					paramNameLowerCase != "targetdirs" && 
					paramNameLowerCase != "user" && 
					paramNameLowerCase != "admin_user" && 
					paramNameLowerCase != "esx_user" && 
					paramNameLowerCase != "object_name" && 
					paramNameLowerCase != "uname" &&
					paramValue.indexOf("$") > -1)
			{
				Ext.Msg.show({
					title: pageName,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING,
					fn: function() {
						Ext.getCmp(paramId.trim()).focus();
					}
				});
				allowToUpdate = false;
				break;
			}
			else if (paramNameLowerCase == "user" || paramNameLowerCase == "uname")
			{
				var pattern = "@*+=|:;\"\'<>\/[]?";
				if (testName != "CtxAuthTest" && testName != "WinAuthTest" && testName != "TermAuthTest")
				{
					pattern = pattern + ",";
				}
				if (!checkspecialnomess(paramValue,pattern))
				{
					Ext.Msg.show({
						title: pageName,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}
				else if(paramIdValue.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: pageName,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}
				else if(paramIdValue.indexOf("  ") > -1)
				{
					Ext.Msg.show({
						title: pageName,
						msg: _checkSpaces,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}
				numOfUsers = paramIdValue.split(',');
			}
			else if(paramNameLowerCase == "domain")
			{
				if (!checkDomain(paramIdValue,multiUserMode))
				{
					allowToUpdate = false;
					Ext.getCmp(paramId).focus();
					break;
				}
			}
			else if(paramNameLowerCase == "admin_user")
			{
				var pattern = "@*+=|:;\"\'<>\/[]?";
				//Should not allow comma for Single user tests. For example, ADServerTest
				if (multiUserMode == "false")
				{
					pattern = pattern + ",";
				}
				if (!checkspecialnomess(paramIdValue,pattern))
				{
					Ext.Msg.show({
						title: pageName,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}
				else if(paramIdValue.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: pageName,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}
				else if(paramIdValue.indexOf("  ") > -1)
				{
					Ext.Msg.show({
						title: pageName,
						msg: _checkSpaces,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}
			}
			else if(paramNameLowerCase == "esx_user" || 
					paramNameLowerCase == "xen_user" || 
					paramNameLowerCase == "xen_pool_user" || 
					paramNameLowerCase == "console_user" || 
					paramNameLowerCase == "username" || 
					paramNameLowerCase == "userNames" || 
					paramNameLowerCase == "proxyusername" || 
					paramNameLowerCase == "hmc_user")
			{
				if (!checkSpecial(paramIdValue,"@*+=|:;\"\'<>,\/[]?"))
				{
					allowToUpdate = false;
					break;
				}
				else if(paramIdValue.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: pageName,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}
				else if(paramIdValue.indexOf("  ") > -1)
				{
					Ext.Msg.show({
						title: pageName,
						msg: _checkSpaces,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}
			}
			else if(paramNameLowerCase == "snmpcommunity")
			{
				if (paramIdValue.indexOf("\"") > -1 || paramIdValue.indexOf("|") > -1)
				{
					Ext.Msg.show({
						title: pageName,
						msg: _snmpcomma,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}
			}
			else if(paramNameLowerCase == "criticalerrorcodes" || 
					paramNameLowerCase == "majorerrorcodes" || 
					paramNameLowerCase == "minorerrorcodes")
			{
				var tempParamValue = paramValue.toLowerCase();
				var maxValue = "";
				if (testName == "FcDetailsTest")
				{
					maxValue = 131;
				}
				else
				{
					maxValue = 12;
				}
				if (!checkSpecial(paramValue,"`~!@#$%^&*()+={}[]|:;\"\'<>_?\/\\"))
				{
					allowToUpdate = false;
					break;
				}
				else if (tempParamValue.indexOf(",") > -1)
				{
					if (tempParamValue.indexOf(",") == 0 || 
						tempParamValue.lastIndexOf(",") == tempParamValue.length-1 || 
						tempParamValue.indexOf(",,") > -1)
					{
						Ext.Msg.show({
							title: pageName,
							msg: _validValue,
							buttons: Ext.Msg.OK,
							icon: Ext.Msg.WARNING,
							fn: function() {
								Ext.getCmp(paramId).focus();
							}
						});
						allowToUpdate = false;
						break;
					}
					else
					{
						var tempValues = tempParamValue.split(",");
						var foundInValidData = false;
						for (var i=0; i<tempValues.length; i++)
						{
							var strValue = tempValues[i];
							var isNumber = checkNumerical(strValue);
							if (isNumber)
							{
								if (parseInt(strValue) < 1 || parseInt(strValue) > maxValue)
								{
									foundInValidData = true;
									break;
								}
							}
							else
							{
								foundInValidData = true;
								break;
							}
						}

						if (foundInValidData)
						{
							if (maxValue == 131)
							{
								Ext.Msg.show({
									title: pageName,
									msg: _oneToOneThirtyOne,
									buttons: Ext.Msg.OK,
									icon: Ext.Msg.WARNING
								});
							}
							else
							{
								Ext.Msg.show({
									title: pageName,
									msg: _oneToTwelve,
									buttons: Ext.Msg.OK,
									icon: Ext.Msg.WARNING
								});
							}
							allowToUpdate = false;
							Ext.getCmp(paramId).focus();
							break;
						}
					}
				}
				else
				{
					var isNumber = checkNumerical(tempParamValue);
					if (isNumber)
					{
						if (parseInt(tempParamValue) < 1 || parseInt(tempParamValue) > maxValue)
						{
							if (maxValue == 131)
							{
								Ext.Msg.show({
									title: pageName,
									msg: _oneToOneThirtyOne,
									buttons: Ext.Msg.OK,
									icon: Ext.Msg.WARNING
								});
							}
							else
							{
								Ext.Msg.show({
									title: pageName,
									msg: _oneToTwelve,
									buttons: Ext.Msg.OK,
									icon: Ext.Msg.WARNING
								});
							}
							allowToUpdate = false;
							Ext.getCmp(paramId).focus();
							break;
						}
					}
					else
					{
						if (defaultValueFound && tempParamValue == "default")
						{
							Ext.Msg.show({
								title: pageName,
								msg: _assignDefault,
								buttons: Ext.Msg.OK,
								icon: Ext.Msg.WARNING,
								fn: function() {
									Ext.getCmp(paramId).focus();
								}
							});
							allowToUpdate = false;
							break;
						}

						if (tempParamValue == "default")
						{
							defaultValueFound = true;
						}

						if (tempParamValue != "none" && tempParamValue != "default")
						{
							Ext.Msg.show({
								title: pageName,
								msg: _validValue,
								buttons: Ext.Msg.OK,
								icon: Ext.Msg.WARNING,
								fn: function() {
									Ext.getCmp(paramId).focus();
								}
							});
							allowToUpdate = false;
							break;
						}
					}
				}
			}
			else if(paramNameLowerCase == "handle_growth_limit" && !checkNumerical(paramIdValue))
			{
				Ext.Msg.show({
					title: pageName,
					msg: _checkfordecimal,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING,
					fn: function() {
						Ext.getCmp(paramId).focus();
					}
				});
				allowToUpdate = false;
				break;
			}
			else if(paramNameLowerCase == "elapsed_time" && !checkNumerical(paramValue))
			{
				alert(_checkfordecimal);
				Ext.Msg.show({
					title: pageName,
					msg: _checkfordecimal,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING,
					fn: function() {
						Ext.getCmp(paramId).focus();
					}
				});
				allowToUpdate = false;
				break;
			}
			else if(paramNameLowerCase == "object_name" && !checkspecialnomess(paramValue,"`~!@%^&*()+=-{}[]|:;\"\'<>?\/\\"))
			{
				Ext.Msg.show({
					title: pageName,
					msg: _checkforobjectname,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING,
					fn: function() {
						Ext.getCmp(paramId).focus();
					}
				});
				allowToUpdate = false;
				break;
			}
			else if((testName != "MsSqlNetTest" && testName != "MsSqlTest") && (paramNameLowerCase == "database" || paramNameLowerCase == "instance") && !checkspecialnomess(paramValue,","))
			{
				Ext.Msg.show({
					title: pageName,
					msg: _multipleDB,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING,
					fn: function() {
						Ext.getCmp(paramId).focus();
					}
				});
				allowToUpdate = false;
				break;
			}
			else if(paramNameLowerCase == "packetsize" || 
				paramNameLowerCase == "packetcount" || 
				paramNameLowerCase == "timeout" || 
				paramNameLowerCase == "webserverport" || 
				paramNameLowerCase == "receiveport" || 
				paramNameLowerCase == "adminport" || 
				paramNameLowerCase == "targetport" || 
				paramNameLowerCase == "jmx_remote_port" || 
				paramNameLowerCase == "appport" || 
				paramNameLowerCase == "connectorport" || 
				paramNameLowerCase == "uploadsize" || 
				paramNameLowerCase == "downloadsize" ||
				paramNameLowerCase == "top_n_tables")
			{
				if ((!checknumber("+",paramIdValue)) || paramIdValue == 0)
				{
					Ext.Msg.show({
						title: pageName,
						msg: _checkInt,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}

				if (!checkfordecimal(paramIdValue))
				{
					Ext.getCmp(paramId).focus();
					allowToUpdate = false;
					break;
				}
			}
			else if(paramNameLowerCase == "snmpport")
			{
				if (((!checknumber("+",paramIdValue)) || paramIdValue == 0) && (paramIdValue.toLowerCase() != "none"))
				{
					Ext.Msg.show({
						title: pageName,
						msg: _valInt,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}

				if (!checkfordecimal(paramIdValue))
				{
					Ext.getCmp(paramId).focus();
					allowToUpdate = false;
					break;
				}
			}
			else if(paramNameLowerCase == "duration")
			{
				if (!checknumber("+",paramIdValue))
				{
					Ext.Msg.show({
						title: pageName,
						msg: _checkInt,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}

				if (!checkfordecimal(paramIdValue))
				{
					Ext.getCmp(paramId).focus();
					allowToUpdate = false;
					break;
				}
			}
			else if(paramNameLowerCase == "logtype" && !checkAlphabet(paramIdValue.replace(/ /g,'')))
			{
				Ext.Msg.show({
					title: pageName,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING,
					fn: function() {
						Ext.getCmp(paramId).focus();
					}
				});
				allowToUpdate = false;
				break;
			}
			else if(paramNameLowerCase == "ddFreq" && !DDFrequencyCheck(paramIdValue))
			{
				Ext.Msg.show({
					title: pageName,
					msg: _validDDPattern,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING,
					fn: function() {
						Ext.getCmp(paramId).focus();
					}
				});
				allowToUpdate = false;
				break;
			}
			else if(paramNameLowerCase == "webport")
			{
				if (!checkNumerical(paramIdValue))
				{
					Ext.Msg.show({
						title: pageName,
						msg: _checkfordecimal,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}
			}
			else if(paramNameLowerCase == "fromid" || paramNameLowerCase == "toid")
			{
				var regExp = /([a-zA-Z0-9]+[\ \_\.\-]?)*[a-zA-Z0-9]\@[a-zA-Z0-9][\w\.-]*[a-zA-Z0-9]\.[a-zA-Z][a-zA-Z\.]*[a-zA-Z]/g;
				var result=paramIdValue.match(regExp);
				if (result == null || result != paramIdValue)
				{
					Ext.Msg.show({
						title: pageName,
						msg: _checkmail,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}
			}
			else if(paramNameLowerCase == "url" || paramNameLowerCase == "wsdl_url")
			{
				if (paramIdValue.indexOf(":") == -1)
				{
					Ext.Msg.show({
						title: pageName,
						msg: _checkurl,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}

				if (paramIdValue.charAt(0) == "," || paramIdValue.charAt(paramIdValue.length -1) == "," || paramIdValue.indexOf(",,") > -1)
				{
					Ext.Msg.show({
						title: pageName,
						msg: _invalidUrl,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}

				if (testName =="HttpTest" || testName=="HttpPostTest" || testName =="WebServiceTest" )
				{
					if (!validateUrl(paramId,paramValue))
					{
						Ext.getCmp(paramId).focus();
						allowToUpdate = false;
						break;
					}
				}
				else
				{
					if (!validateSingleUrl(paramId,paramValue))
					{
						Ext.Msg.show({
							title: pageName,
							msg: _invalidUrl,
							buttons: Ext.Msg.OK,
							icon: Ext.Msg.WARNING,
							fn: function() {
								Ext.getCmp(paramId).focus();
							}
						});
						allowToUpdate = false;
						break;
					}
				}
			}
			else if(paramNameLowerCase == "websites")
			{
				if (!checkSpecial(paramIdValue,"\\\/?;:@&-+$|\'<>\""))
				{
					allowToUpdate = false;
					break;
				}
				else if(paramIdValue.charAt(0) == "," || paramIdValue.charAt(paramIdValue.length -1) == "," || paramIdValue.indexOf(",,") > -1)
				{
					Ext.Msg.show({
						title: pageName,
						msg: _invalidWebsite,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}
			}
			else if(paramNameLowerCase == "servername" || paramNameLowerCase == "server")
			{
				if (testName == "Tomcat_Processes_ex") //Ngee Ann Polytechnic (Colon as separator)
				{
					if (!checkSpecial(paramValue,"`~!@#$%^&*()+={}[]|;,\"\'<>?\/\\"))
					{
						allowToUpdate = false;
						break;
					}
				}
				else
				{
					if (!checkSpecial(paramValue,"`~!@#$%^&*()+={}[]|:;,\"\'<>?\/\\"))
					{
						allowToUpdate = false;
						break;
					}
				}
			}
			else if(paramNameLowerCase == "homedir")
			{
				if (!checkSpecial(paramValue,"*?\"\'<>|"))
				{
					allowToUpdate = false;
					break;
				}
			}
			else if(paramNameLowerCase == "weblogicjarlocation")
			{
				if (!checkSpecial(paramValue,"*?\"\'<>|"))
				{
					allowToUpdate = false;
					break;
				}
			}
			else if(paramNameLowerCase == "version")
			{
				if (paramValue != "none")
				{
					if (!checkFloatingNumber(paramValue))
					{
						Ext.Msg.show({
							title: pageName,
							msg: _invalidVersion,
							buttons: Ext.Msg.OK,
							icon: Ext.Msg.WARNING,
							fn: function() {
								Ext.getCmp(paramId).focus();
							}
						});
						allowToUpdate = false;
						break;
					}
					else if(paramValue.indexOf("..") > -1)
					{
						Ext.Msg.show({
							title: pageName,
							msg: _invalidVersion,
							buttons: Ext.Msg.OK,
							icon: Ext.Msg.WARNING,
							fn: function() {
								Ext.getCmp(paramId).focus();
							}
						});
						allowToUpdate = false;
						break;
					}
				}
			}
			else if(paramNameLowerCase == "hmc_server")
			{
				if (!validateIp(paramIdValue))
				{
					Ext.getCmp(paramId).focus();
					allowToUpdate = false;
					break;
				}
			}
			else if(paramNameLowerCase == "logfilepath" &&
				((testName =="AGateServerTest") || (testName=="AGateTransTest") ||
				(testName == "AGateAccessTest") || (testName == "AGateStatusTest")))
			{
				allowChars="$`!@#%^&*()+{}[]|;\"\'<>?";
				var parameter=parameters.split(",");
				for (var p = 0;p<parameter.length;p++ )
				{
					parameter[p].replace(/^\s*/, '').replace(/\s*$/, '');
					if (parameter[p].toUpperCase() == paramId.toUpperCase())
					{
						allowChars="`!@#%^&*()+{}[]|;\"\'<>?";
						break;
					}
				}

				if(!checkspecialnomess(paramIdValue,allowChars))
				{
					Ext.Msg.show({
						title: pageName,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}
			}
			else if(paramNameLowerCase == "content")
			{
				//credentials validation must be under hidden.will not encounter under type text
				if (!contentvalidation(paramIdValue,"text",paramName))
				{
					Ext.getCmp(paramId).focus();
					allowToUpdate = false;
					break;
				}
			}
			else if((paramNameLowerCase == "filepath" || 
				paramNameLowerCase == "navisecclipath") && 
				!checkSpecial(paramIdValue,"*?<>|\""))
			{
				allowToUpdate = false;
				break;
			}
			else if((paramNameLowerCase == "xen_ps_console_file_path" || paramNameLowerCase == "java_home" || paramNameLowerCase == "citrixhome") && 
				!checkSpecial(paramIdValue,"`!#^&+={}[]|\"\'<>?"))
			{
				allowToUpdate = false;
				break;
			}
			else if(paramNameLowerCase =="recordpattern" 
				&& !checkSpecial(paramIdValue,"`!#^&()+[]|\'?"))
			{
				allowToUpdate = false;
				break;
			}
			else if(paramNameLowerCase =="script" 
				&& !checkSpecial(paramIdValue,"`!#^&()+{}[]|\"\'<>?"))
			{
				allowToUpdate = false;
				break;
			}
			else if((paramNameLowerCase == "hostd_patterns" || paramNameLowerCase == "messages_patterns") 
				&& !checkSpecial(paramIdValue,"`!#^&()+{}|\"\'<>?"))
			{
				allowToUpdate = false;
				break;
			}
			else if(paramNameLowerCase == "proxyport")
			{
				if ((!checknumber("+",paramIdValue) || paramIdValue == 0) && (paramIdValue != "none"))
				{
					Ext.Msg.show({
						title: pageName,
						msg: _checkproxy,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}

				if (!checkfordecimal(paramIdValue))
				{
					Ext.getCmp(paramId).focus();
					allowToUpdate = false;
					break;
				}
			}
			else if(paramNameLowerCase == "port")
			{
				if ((!checknumber("+",paramIdValue) || paramIdValue == 0) && (paramIdValue != "NULL"))
				{
					Ext.Msg.show({
						title: pageName,
						msg: _checkport,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}
				if (paramIdValue > 99999)
				{
					Ext.Msg.show({
						title: pageName,
						msg: _validatePort,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}
				if (!checkfordecimal(paramIdValue))
				{
					Ext.getCmp(paramId).focus();
					allowToUpdate = false;
					break;
				}
			}
			else if (paramNameLowerCase == "proxyhost" || 
					paramNameLowerCase == "targets" || 
					paramNameLowerCase == "host" || 
					paramNameLowerCase == "receivehost" || 
					paramNameLowerCase == "eventhost" ||
					paramNameLowerCase == "ipAdd"
					)
			{
				if(paramNameLowerCase == "host" 
				|| paramNameLowerCase == "proxyhost" 
				|| paramNameLowerCase == "receivehost"
				|| paramNameLowerCase == "eventhost"
				|| paramNameLowerCase == "ipAdd")
				{
					var alphabets = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
					var checkCharacter = "";
					var temp = false;
					for(var m=0; m<paramIdValue.length; m++)
					{
						checkCharacter = alphabets.indexOf(paramIdValue.charAt(m))
						//Returns value 1 if thecharacter listed is found
						if(checkCharacter >= 1)
						{
							temp = true;
							break;
						}
					}
					if (paramNameLowerCase == "host" || paramNameLowerCase == "ipAdd") 
					{
						if(allowHostName=="false" && temp) 
						{
							Ext.Msg.show({
								title: pageName,
								msg: _valIp,
								buttons: Ext.Msg.OK,
								icon: Ext.Msg.WARNING,
								fn: function() {
									Ext.getCmp(paramId).focus();
								}
							});
							allowToUpdate = false;
							break;
						}
					}
					if(temp)
					{
						//Hostname should not have space
						if (!checkspace(paramIdValue))
						{
							Ext.getCmp(paramId).focus();
							allowToUpdate = false;
							break;
						}
						//Checks for dots before & after hostname as well as dots in consecutive positions.
						if (!checkdots(paramIdValue))
						{
							Ext.Msg.show({
								title: pageName,
								msg: _checkHost,
								buttons: Ext.Msg.OK,
								icon: Ext.Msg.WARNING,
								fn: function() {
									Ext.getCmp(paramId).focus();
								}
							});
							allowToUpdate = false;
							break;
						}
					}
					else if(!validateIp(paramIdValue))
					{
						Ext.getCmp(paramId).focus();
						allowToUpdate = false;
						break;
					}

					if(!checkspecialnomess(paramIdValue,"`~!@#%^&*()+={}[]|\\;\"\'<>,?") //removed slash(/) for AWS_EC2_Region component
						|| paramIdValue.indexOf("$") > 0)
					{
						Ext.Msg.show({
							title: pageName,
							msg: _checkspecial,
							buttons: Ext.Msg.OK,
							icon: Ext.Msg.WARNING,
							fn: function() {
								Ext.getCmp(paramId).focus();
							}
						});
						allowToUpdate = false;
						break;
					}
				}
				else
				{
					if(paramNameLowerCase == "targets" && !checkspace(paramIdValue))
					{
						Ext.getCmp(paramId).focus();
						allowToUpdate = false;
						break;
					}
					else if(!checkspecialnomess(paramIdValue,"`~!@#%^&*()+={}[]|\\;\"\'<>?")
						|| paramIdValue.indexOf("$") > 0)
					{
						Ext.Msg.show({
							title: pageName,
							msg: _checkspecial,
							buttons: Ext.Msg.OK,
							icon: Ext.Msg.WARNING,
							fn: function() {
								Ext.getCmp(paramId).focus();
							}
						});
						allowToUpdate = false;
						break;
					}
				}
			}
			//check for logFile 
			else if(paramNameLowerCase == "logfile")
			{
				if(!checkspecialnomess(paramIdValue,"`~!#%^&*()+{}[]|;\"\'<>?")
					|| paramIdValue.indexOf("$") > 0)
				{
					Ext.Msg.show({
						title: pageName,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}
			}
			else if(paramNameLowerCase == "process")
			{
				if(paramIdValue.indexOf(":") == -1)
				{
					if(testName == "TermAppTest")
					{
						if((paramIdValue.toUpperCase() != "NONE") && (paramIdValue.toUpperCase() != "ALL") && (paramIdValue.toUpperCase() != "AUTO")) 
						{
							Ext.Msg.show({
								title: pageName,
								msg: _processvalidation,
								buttons: Ext.Msg.OK,
								icon: Ext.Msg.WARNING,
								fn: function() {
									Ext.getCmp(paramId).focus();
								}
							});
							allowToUpdate = false;
							break;
						}
					}
					else if(paramIdValue.toUpperCase() != "NONE" && paramIdValue!= "(EG_RUNTIME)")
					{
						Ext.Msg.show({
							title: pageName,
							msg: _processvalidation,
							buttons: Ext.Msg.OK,
							icon: Ext.Msg.WARNING,
							fn: function() {
								Ext.getCmp(paramId).focus();
							}
						});
						allowToUpdate = false;
						break;

						var textvalTemp = paramIdValue.replace(/~/g,'');
						if(!processvalidation(textvalTemp,"text"))
						{
							Ext.getCmp(paramId).focus();
							allowToUpdate = false;
							break;
						}
					}
				}
				numOfProcess = paramIdValue.split(',');// Added for ProcessTest
			}
			else if(paramNameLowerCase == "pidfile")
			{
				if(!checkspace(paramIdValue))
				{
					Ext.getCmp(paramId).focus();
					allowToUpdate = false;
					break;
				}
				else if(paramIdValue.toUpperCase() != "NONE")
				{
					if(!processvalidation(paramIdValue,thisForm[j].type))
					{
						Ext.getCmp(paramId).focus();
						allowToUpdate = false;
						break;
					}
				}
			}
			else if(paramNameLowerCase == "content")
			{
				if(paramIdValue.indexOf(":") == -1)
				{
					Ext.Msg.show({
						title: pageName,
						msg: _contentvalidation,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}
			}
			else if(paramNameLowerCase == "search")
			{
				if(!checkSpecial(paramIdValue,"`~!@#%^&*()+-{}[]|:;\"\'<>?")
					|| paramIdValue.indexOf("$") > 0)
				{
					allowToUpdate = false;
					break;
				}
				if(!checkcomma(paramIdValue))
				{
					Ext.Msg.show({
						title: pageName,
						msg: _checkcomma,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}
			}
			else if(paramNameLowerCase == "senduser")
			{
				if(!checkSpecial(paramIdValue,"*+=[]|:;\"\'<>,\/?"))
				{
					allowToUpdate = false;
					break;
				}
			}
			else if(paramNameLowerCase == "receiveuser")
			{
				if(!checkSpecial(paramIdValue,"*+=[]|:;\"\'<>,\/?"))
				{
					allowToUpdate = false;
					break;
				}
			}
			else if(paramNameLowerCase == "eventsrc")
			{
				if(!checkSpecial(paramIdValue,"`~!#%^&*()={}[]|\\:;\"\'<>?\/")
					|| paramIdValue.indexOf("$") > 0)
				{
					allowToUpdate = false;
					break;
				}
				else if(!checkcomma(paramIdValue))
				{
					Ext.Msg.show({
						title: pageName,
						msg: _checkcomma,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}
			}
			//Check for cookiefile, postarguments, snmpcommunity, user, info
			else if((testName == "CtxAuthTest") || (testName == "WinAuthTest") || (testName == "TermAuthTest") || (testName == "SlowTransTest"))
			{
				var pattern = "";
				if(paramNameLowerCase == "user")
				{
					pattern = "@*+=|:;\"\'<>\/[]?";
				}
				else if(paramNameLowerCase == "pattern")
				{
					pattern = "$|\"\'";
				}
				else if(paramNameLowerCase == "name")
				{
					pattern = "$@*.+=|:;\"\'<>\/[]?\\&";
				}
				else
				{
					pattern = "`~!@#%^&*()+={}[]|\\:;\"\'<>?\/";
				}

				if(!checkSpecial(paramIdValue,pattern))
				{
					allowToUpdate = false;
					break;
				}
				else if(((paramIdValue.substring(paramIdValue.length-1, 
					paramIdValue.length)) == ",") ||
					(paramIdValue.charAt(0) == ","))
				{
					Ext.Msg.show({
						title: pageName,
						msg: _valComma,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}
				else if(paramNameLowerCase == "name")
				{
					var arrParam = paramIdValue.split(",");
					for(var i = 0; i < arrParam.length; i++)
					{
						if (!nonNumeric(arrParam[i]))
						{
							Ext.getCmp(paramId).focus();
							allowToUpdate = false;
							break;
						}
					}
					if(allowToUpdate == false)
					{
						break;
					}
					if(!checkspace(paramIdValue))
					{
						Ext.getCmp(paramId).focus();
						allowToUpdate = false;
						break;
					}
				}
				else if(paramNameLowerCase == "pattern")
				{
					var regColon = /(;)$/gi;
					if(paramIdValue.match(regColon) != null)
					{
						Ext.Msg.show({
							title: pageName,
							msg: _invalidPattern,
							buttons: Ext.Msg.OK,
							icon: Ext.Msg.WARNING,
							fn: function() {
								Ext.getCmp(paramId).focus();
							}
						});
						allowToUpdate = false;
						break;
					}
					else if(!checkspace(paramIdValue))
					{
						Ext.getCmp(paramId).focus();
						allowToUpdate = false;
						break;
					}
					else if (paramIdValue.indexOf(";;") > -1)
					{
						Ext.Msg.show({
							title: pageName,
							msg: _checkSemiColons,
							buttons: Ext.Msg.OK,
							icon: Ext.Msg.WARNING,
							fn: function() {
								Ext.getCmp(paramId).focus();
							}
						});
						allowToUpdate = false;
						break;
					}
					else if (paramIdValue.indexOf("..") > -1)
					{
						Ext.Msg.show({
							title: pageName,
							msg: _checkdots,
							buttons: Ext.Msg.OK,
							icon: Ext.Msg.WARNING,
							fn: function() {
								Ext.getCmp(paramId).focus();
							}
						});
						allowToUpdate = false;
						break;
					}
				}
				else if(paramNameLowerCase == "threshold_value")
				{
					var regNum = /([0-9]+\.|\.)?[0-9]+/gi;
					if(!checkspace(paramIdValue))
					{
						Ext.getCmp(paramId).focus();
						allowToUpdate = false;
						break;
					}
					else if((paramIdValue.match(regNum) == null) ||  (paramIdValue.match(regNum) != paramIdValue))
					{
						Ext.Msg.show({
							title: pageName,
							msg: _numeralOnly,
							buttons: Ext.Msg.OK,
							icon: Ext.Msg.WARNING,
							fn: function() {
								Ext.getCmp(paramId).focus();
							}
						});
						allowToUpdate = false;
						break;
					}
				}
				else
				{
					userArr = paramIdValue.split(',');
				}
			}
			else if(testName == 'AlertLogTest' && paramNameLowerCase == "searchpattern")
			{
				//new code test st
				allowChars="$`#^&=[]|\"\'<>";
				var parameter=parameters.split(",");
				for (parameterCount=0;parameterCount<parameter.length;parameterCount++ )
				{
					parameter[parameterCount].replace(/^\s*/, '').replace(/\s*$/, '');
					if ((parameter[parameterCount].toUpperCase())==(paramId).toUpperCase())
					{
						allowChars="`#^&=[]|\"\'<>";
						break;
					}
				}

				if(!checkSpecial(paramIdValue,allowChars))
				{
					allowToUpdate = false;
					break;
				}
			}
			else if(paramNameLowerCase == "command")
			{
				var s_command = paramIdValue.toUpperCase();
				if(s_command != "")
				{
					if(!(s_command == "GET" || s_command == "POST"))
					{
						Ext.Msg.show({
							title: pageName,
							msg: _checkMethod,
							buttons: Ext.Msg.OK,
							icon: Ext.Msg.WARNING,
							fn: function() {
								Ext.getCmp(paramId).focus();
							}
						});
						allowToUpdate = false;
						break;
					}
				}
			}
			else if(paramNameLowerCase == "cmd")
			{
				var s_cmd = paramIdValue.toLowerCase();
				if(!(s_cmd == "get" || s_cmd =="put"))
				{
					Ext.Msg.show({
						title: pageName,
						msg: _valMethod,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}
			}
			else if(paramNameLowerCase == "protocol")
			{
				var s_protocol = paramIdValue.toLowerCase();
				if(s_protocol != "")
				{
					if(!(s_protocol == "imap" || s_protocol == "pop3"))
					{
						Ext.Msg.show({
							title: pageName,
							msg: _validProtocol,
							buttons: Ext.Msg.OK,
							icon: Ext.Msg.WARNING,
							fn: function() {
								Ext.getCmp(paramId).focus();
							}
						});
						allowToUpdate = false;
						break;
					}
				}
			}
		}

		//Password validations
		if (fieldsArr[j].inputType == 'password')
		{
			var pattern = "";
			if((testName == "CtxAuthTest") || (testName == "WinAuthTest") || (testName == "TermAuthTest"))
			{
				pattern = ",|";
			}
			//else
			//{
			//	pattern = "|";
			//}
			if(paramIdValue == "")
			{
				Ext.Msg.show({
					title: pageName,
					msg: _checkempty,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING
				});
				allowToUpdate = false;
				break;
			}
			if(!checkspecialnomess(paramIdValue,pattern))
			{
				if ((testName == "CtxAuthTest") || 
					(testName == "WinAuthTest") || 
					(testName == "TermAuthTest"))
				{
					Ext.Msg.show({
						title: pageName,
						msg: _notAllowCharInPasswd,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING
					});
				}
				//else
				//{
				//	alert(_notAllowCharInPwd);
				//}
				Ext.getCmp(paramId).focus();
				allowToUpdate = false;
				break;
			}
			if(!checkForPassValidity(paramIdValue))
			{
				Ext.getCmp(paramId).focus();
				allowToUpdate = false;
				break;
			}
			if((testName == "CtxAuthTest") || (testName == "WinAuthTest") || (testName == "TermAuthTest"))
			{
				if(((paramIdValue.substring(paramIdValue.length-1, 
				paramIdValue.length)) == ",") ||
				(paramIdValue.charAt(0) == ","))
				{
					Ext.Msg.show({
						title: pageName,
						msg: _valComma,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING
					});
					allowToUpdate = false;
					break;
				}
				else
				{
					passArr = fieldsArr[j].value.split("#~#");
				}
			}
			if(paramId.indexOf("confirmpassword")>-1)
			{
				var pwd = fieldsArr[j-1].value;
				var cpwd = fieldsArr[j].value;
				if(cpwd != pwd)
				{
					Ext.Msg.show({
						title: pageName,
						msg: _isPassword,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function()
						{
							Ext.getCmp(paramId).setValue("");

							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}
			}
		}

		//Text area validations - starts
		if (fieldsArr[j].xtype == "textarea" )
		{
			var checkHyphenValidation = true;
			for (var z=0;z<doubleQuotesParams.length;z++)
			{
				if (doubleQuotesParams[z] == paramNameLowerCase)
				{
					checkHyphenValidation = false;
					break;
				}
			}

			if (paramValue == "")
			{
				Ext.Msg.show({
					title: pageName,
					msg: _checkempty,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING,
					fn: function() {
						Ext.getCmp(paramId).focus();
					}
				});
				allowToUpdate = false;
				break;
			}
			//else if(paramValue == "$unconfigured")
			//{
			//	alert(_tcKeyword);
			//	allowToUpdate = false;
			//	thisForm[j].focus();
			//	break;
			//}
			//else if(!checkHyphenText(paramValue,paramNameLowerCase))
			//{
			//	allowToUpdate = false;
			//	thisForm[j].focus();
			//	break;
			//}
			else if(paramNameLowerCase != "servicename" && 
					paramNameLowerCase != "snmpcommunity" && 
					paramNameLowerCase != "process" && 
					paramNameLowerCase != "targetdirs" && 
					paramNameLowerCase != "user" && 
					paramNameLowerCase != "admin_user" && 
					paramNameLowerCase != "esx_user" && 
					paramNameLowerCase != "object_name" && 
					paramValue.indexOf("$") > -1)
			{
				Ext.Msg.show({
					title: pageName,
					msg: _checkspecial,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING,
					fn: function() {
						Ext.getCmp(paramId).focus();
					}
				});
				allowToUpdate = false;
			}
			else if (paramNameLowerCase == "filter")
			{
				var filtersArr = new Array();
				var tempGlobalsplit=paramValue.split(";");
				var tempFilters = "";
				for(var k=0;k<tempGlobalsplit.length;k++)
				{
					if(tempGlobalsplit[k] != "")
					{
						var mysplit=tempGlobalsplit[k].split(":");
						if(mysplit.length == 7)
						{
							for(var m=0;m<mysplit.length;m++)
							{
								if(mysplit[m] != "")
								{
									if (m>0) continue;
									tempFilters = tempFilters + mysplit[m] + ",";
								}
							}
						}
					}
				}

				if (tempFilters != "")
				{
					tempFilters = tempFilters.substring(0,tempFilters.length-1);
					filtersArr = tempFilters.split(",");
				}

				var globalsplit=paramValue.split(";");
				for(var k=0;k<globalsplit.length;k++)
				{
					if(globalsplit[k] != "")
					{
						var mysplit=globalsplit[k].split(":");
						if(mysplit.length == 7)
						{
							for(var m=0;m<mysplit.length;m++)
							{
								if(mysplit[m] != "")
								{
									if(m==0)
									{
										var myhypen="-";
										var mycomma=",";
										var reg_expression = /[`~!@#$%^&()|{ }/+=.?\\\"\'><,\:\;]/;
										var policyNameresult=reg_expression.test(mysplit[m]);
										var mylen=mysplit[m].length;
										if(policyNameresult)
										{
											Ext.Msg.show({
												title: pageName,
												msg: _policySplChar,
												buttons: Ext.Msg.OK,
												icon: Ext.Msg.WARNING,
												fn: function() {
													Ext.getCmp(paramId).focus();
												}
											});
											allowToUpdate = false;
											return;
										}
										if(mysplit[m].charAt(0)==myhypen||mysplit[m].charAt(mylen-1)==myhypen)
										{
											Ext.Msg.show({
												title: pageName,
												msg: _policyHypen,
												buttons: Ext.Msg.OK,
												icon: Ext.Msg.WARNING,
												fn: function() {
													Ext.getCmp(paramId).focus();
												}
											});
											allowToUpdate = false;
											return;
										}
										if ((trim(mysplit[m])).toLowerCase() == "all")
										{
											if (mysplit[m] != "all")
											{
												Ext.Msg.show({
													title: pageName,
													msg: _allInFilter,
													buttons: Ext.Msg.OK,
													icon: Ext.Msg.WARNING,
													fn: function() {
														Ext.getCmp(paramId).focus();
													}
												});
												allowToUpdate = false;
												return;
											}
										}
										var n = 0;
										for(var i=0;i<filtersArr.length;i++)
										{
											var strFilter = filtersArr[i];
											if (mysplit[m] == strFilter)
											{
												n = n+1;
											}

											if (n > 1)
											{
												Ext.Msg.show({
													title: pageName,
													msg: _policyFilter + " '" + mysplit[m] + "' " + _duplicated,
													buttons: Ext.Msg.OK,
													icon: Ext.Msg.WARNING,
													fn: function() {
														Ext.getCmp(paramId).focus();
													}
												});
												allowToUpdate = false;
												return;
											}
										}
									}
									else if (m==1 || m==2)
									{
										mycomma=",";
										if(mysplit[m].indexOf(",") == 0||mysplit[m].lastIndexOf(",") ==(mysplit[m].length-1))
										{
											Ext.Msg.show({
												title: pageName,
												msg: _eventSrcComma,
												buttons: Ext.Msg.OK,
												icon: Ext.Msg.WARNING,
												fn: function() {
													Ext.getCmp(paramId).focus();
												}
											});
											allowToUpdate = false;
											return;
										}
										if(mysplit[m].indexOf(",,")>0)
										{
											Ext.Msg.show({
												title: pageName,
												msg: _eventSrcConsComma,
												buttons: Ext.Msg.OK,
												icon: Ext.Msg.WARNING,
												fn: function() {
													Ext.getCmp(paramId).focus();
												}
											});
											allowToUpdate = false;
											return;
										}
									}
									else if (m==3 || m==4)
									{
										var eventid_regexp=/^[0-9,]+$/;
										var allowme1="all";
										var allowme2="none";
										mycomma=",";
										var eventidConsec=(mysplit[m].charAt(mysplit[m].search(mycomma))==mysplit[m].charAt(mysplit[m].search(mycomma)+1));
										var eventidresult=eventid_regexp.test(mysplit[m]);
										if(!(eventidresult)&&(mysplit[m]!=allowme1)&&(mysplit[m]!=allowme2))
										{
											Ext.Msg.show({
												title: pageName,
												msg: _eventIDNumOnly,
												buttons: Ext.Msg.OK,
												icon: Ext.Msg.WARNING,
												fn: function() {
													Ext.getCmp(paramId).focus();
												}
											});
											allowToUpdate = false;
											return;
										}
										if(mysplit[m].indexOf(",")==0||mysplit[m].lastIndexOf(",")==(mysplit[m].length-1))
										{
											Ext.Msg.show({
												title: pageName,
												msg: _eventIDComma,
												buttons: Ext.Msg.OK,
												icon: Ext.Msg.WARNING,
												fn: function() {
													Ext.getCmp(paramId).focus();
												}
											});
											allowToUpdate = false;
											return;
										}
										if(mysplit[m].indexOf(",,")>0)
										{
											Ext.Msg.show({
												title: pageName,
												msg: _eventIDConsComma,
												buttons: Ext.Msg.OK,
												icon: Ext.Msg.WARNING,
												fn: function() {
													Ext.getCmp(paramId).focus();
												}
											});
											allowToUpdate = false;
											return;
										}
									}
									else if (m==5 || m==6)
									{
										mycomma=",";
										if(mysplit[m].indexOf(",")==0||mysplit[m].lastIndexOf(",")==(mysplit[m].length-1))
										{
											if (testName == 'AppEvtLogTest' || 
												testName == 'SystemEvtLogTest')
											{
												Ext.Msg.show({
													title: pageName,
													msg: _eventDescComma,
													buttons: Ext.Msg.OK,
													icon: Ext.Msg.WARNING
												});
											}
											else
											{
												Ext.Msg.show({
													title: pageName,
													msg: _eventUserComma,
													buttons: Ext.Msg.OK,
													icon: Ext.Msg.WARNING
												});
											}
											Ext.getCmp(paramId).focus();
											allowToUpdate = false;
											return;
										}
										if(mysplit[m].indexOf(",,")>0)
										{
											if (testName == 'AppEvtLogTest' || 
												testName == 'SystemEvtLogTest')
											{
												Ext.Msg.show({
													title: pageName,
													msg: _eventDescConsComma,
													buttons: Ext.Msg.OK,
													icon: Ext.Msg.WARNING
												});
											}
											else
											{
												Ext.Msg.show({
													title: pageName,
													msg: _eventUserConsComma,
													buttons: Ext.Msg.OK,
													icon: Ext.Msg.WARNING
												});
											}
											Ext.getCmp(paramId).focus();
											allowToUpdate = false;
											return;
										}
									}
								}
								else
								{
									Ext.Msg.show({
										title: pageName,
										msg: _validPattern,
										buttons: Ext.Msg.OK,
										icon: Ext.Msg.WARNING,
										fn: function() {
											Ext.getCmp(paramId).focus();
										}
									});
									allowToUpdate = false;
									return;
								}
							}
						}
						else
						{
							Ext.Msg.show({
								title: pageName,
								msg: _validPattern,
								buttons: Ext.Msg.OK,
								icon: Ext.Msg.WARNING,
								fn: function() {
									Ext.getCmp(paramId).focus();
								}
							});
							allowToUpdate = false;
							return;
						}
					}
					else
					{
						Ext.Msg.show({
							title: pageName,
							msg: _validPattern,
							buttons: Ext.Msg.OK,
							icon: Ext.Msg.WARNING,
							fn: function() {
								Ext.getCmp(paramId).focus();
							}
						});
						allowToUpdate = false;
						return;
					}
				}
			}
			else if (paramNameLowerCase == "searchpattern")
			{
				var searchPatternArr = new Array();
				var tempGlobalsplit=paramValue.split(",");
				for(var k=0;k<tempGlobalsplit.length;k++)
				{
					var strSearchPattern = tempGlobalsplit[k];
					while (strSearchPattern.charAt(0) == ' ')
					{
						strSearchPattern = strSearchPattern.substring(1,strSearchPattern.length);
					}
					while (strSearchPattern.charAt(strSearchPattern.length-1)==' ')
					{
						strSearchPattern = strSearchPattern.substring(0,strSearchPattern.length-1);
					}

					if (strSearchPattern == "")
					{
						Ext.Msg.show({
							title: pageName,
							msg: _invalidSearchPattern,
							buttons: Ext.Msg.OK,
							icon: Ext.Msg.WARNING,
							fn: function() {
								Ext.getCmp(paramId).focus();
							}
						});
						allowToUpdate = false;
						return;
					}
					else if (strSearchPattern.indexOf(":") == -1 || 
							strSearchPattern.indexOf("::") > -1)
					{
						Ext.Msg.show({
							title: pageName,
							msg: _invalidSearchPattern,
							buttons: Ext.Msg.OK,
							icon: Ext.Msg.WARNING,
							fn: function() {
								Ext.getCmp(paramId).focus();
							}
						});
						allowToUpdate = false;
						return;
					}
					else
					{
						var searchPart1 = strSearchPattern.substring(0,strSearchPattern.indexOf(":"));
						var searchPart2 = strSearchPattern.substring(strSearchPattern.indexOf(":")+1);
						if (searchPart1 == "" || searchPart2 == "")
						{
							Ext.Msg.show({
								title: pageName,
								msg: _invalidSearchPattern,
								buttons: Ext.Msg.OK,
								icon: Ext.Msg.WARNING,
								fn: function() {
									Ext.getCmp(paramId).focus();
								}
							});
							allowToUpdate = false;
							return;
						}
						else if (searchPart2.indexOf(":") > -1)
						{
							Ext.Msg.show({
								title: pageName,
								msg: _invalidSearchPattern,
								buttons: Ext.Msg.OK,
								icon: Ext.Msg.WARNING,
								fn: function() {
									Ext.getCmp(paramId).focus();
								}
							});
							allowToUpdate = false;
							return;
						}
					}
				}
			}
			else if (testName == 'AlertLogTest' && paramName == "searchpattern")
			{
				//new code test st for alert log
				if(!checkSpecial(paramIdValue,"`#^&=[]|\"\'<>"))
				{
					allowToUpdate = false;
					break;
				}
			}
			else if(testName.indexOf("Http") > -1 || testName.indexOf("WebService") > -1)
			{
				//new code test end for alert log
				if(paramNameLowerCase != "content" && paramNameLowerCase != "url")
				{
					if(!checkspace(paramIdValue))
					{
						Ext.getCmp(paramId).focus();
						allowToUpdate = false;
						break;
					}
				}
				if(paramNameLowerCase == "content")
				{
					if(!contentvalidation(paramIdValue,fieldsArr[j].xtype,"content"))
					{
						Ext.getCmp(paramId).focus();
						allowToUpdate = false;
						break;
					}
				}
				if(thisForm[j].name == "credentials")
				{
					if(!contentvalidation(paramIdValue,fieldsArr[j].xtype,"credentials"))
					{
						Ext.getCmp(paramId).focus();
						allowToUpdate = false;
						break;
					}
				}
			}
			else if(paramNameLowerCase == "process")
			{
				var textvalTemp = paramIdValue.replace(/~/g,'');
				if(textvalTemp.toUpperCase() != "NONE")
				{
					if(!processvalidation(textvalTemp,"textarea"))
					{
						Ext.getCmp(paramId).focus();
						allowToUpdate = false;
						break;
					}
				}

				var procArr = paramIdValue.split(",");
				var regRep = /(:)(.)+/;
				var procNames = "";
				var str = "";
				for(var i= 0; i < procArr.length; i++)
				{
					str = procArr[i].replace(regRep,"");
					var subStr = procNames.substring(procNames.lastIndexOf((","+str))); // Substring from last index to length of the string (default)

					if((subStr  == (","+str)) || (procNames.indexOf((","+str)+",") != -1 ) )
					{
						Ext.Msg.show({
							title: pageName,
							msg: _uniqueName,
							buttons: Ext.Msg.OK,
							icon: Ext.Msg.WARNING,
							fn: function() {
								Ext.getCmp(paramId).focus();
							}
						});
						allowToUpdate = false;
						break;
					}
					procNames = procNames +","+str;
				}
				
				numOfProcess = fieldsArr[j].value.split(',');// Added for ProcessTest
			}
			else if(paramNameLowerCase == "servicename")
			{
				if (thisForm.delimiter != null && thisForm.delimiter != undefined && thisForm.delimiterMask != null && thisForm.delimiterMask != undefined)
				{
					var delimiter = thisForm.delimiter.value;
					var delimiterMask = thisForm.delimiterMask.value;
					while (paramIdValue.indexOf(delimiter) != -1)
					{
						paramIdValue = paramIdValue.replace(delimiter,delimiterMask);
					}
				}
				if(!checkSpecial(paramIdValue,"|\""))
				{
					allowToUpdate = false;
					break;
				}
				if(!checkcomma(paramIdValue))
				{
					Ext.Msg.show({
						title: pageName,
						msg: _checkService,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}
			}
			else if(paramNameLowerCase == "pidfile")
			{
				if(!checkspace(paramIdValue))
				{
					Ext.getCmp(paramId).focus();
					allowToUpdate = false;
					break;
				}
				if(paramIdValue.toUpperCase() != "NONE")
				{
					if(!processvalidation(paramIdValue,fieldsArr[j].xtype))
					{
						Ext.getCmp(paramId).focus();
						allowToUpdate = false;
						break;
					}
				}
			}
			else if(paramNameLowerCase == "targets")
			{
				if(!checkspace(paramIdValue))
				{
					Ext.getCmp(paramId).focus();
					allowToUpdate = false;
					break;
				}
			}
			else if((testName == "CtxAuthTest") || (testName == "WinAuthTest") || (testName == "TermAuthTest"))
			{
				var pattern = "";
				if(fieldsArr[j].name == "user")
				{
					pattern = "@*+=|:;\"\'<>\/[]?";
				}
				else
				{
					pattern = "`~!@#%^&*()+={}[]|\\:;\"\'<>?\/";
				}

				if(!checkSpecial(paramIdValue,pattern) 
					|| paramIdValue.indexOf("$") > 0)
				{
					Ext.getCmp(paramId).focus();
					allowToUpdate = false;
					break;
				}
				else if(((paramIdValue.substring(paramIdValue.length-1, 
					paramIdValue.length)) == ",") ||
					(paramIdValue.charAt(0) == ","))
				{
					Ext.Msg.show({
						title: pageName,
						msg: _valComma,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}
				else
				{
					userArr = paramIdValue.split(',');
				}
			}

			if(paramNameLowerCase == "user")
			{
				numOfUsers = paramIdValue.split(',');
			}
		}
		//Text area validations - ends

		if (fieldsArr[j].xtype == "multiselectSi" || fieldsArr[j].xtype == "multiselect" )
		{
			if (paramName == "filter_combo" && Ext.getCmp('filter').isDisabled() )
			{
				var count = 0;
				var tempFilter = fieldsArr[j].value;
				//var tempFilter = Ext.getCmp(tempFilterId).getValue();

				if (!Ext.isEmpty(tempFilter))
				{
					for(i=0; i<tempFilter.length; i++)
					{
						if(!Ext.isEmpty(tempFilter[i]))
						{
							count++;
							break;
						}
					}
				}
				if (count == 0)
				{
					Ext.Msg.show({
						title: pageName,
						msg: _checkPolicy,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
				}
			}
		}

		if (fieldsArr[j].xtype == "combo")
		{
			if (paramName=="executiontime")
			{
				hminvar = fieldsArr[j].value;
			}

			if (hminvar!="hourly")
			{
				if (paramName=="agenthour" )
				{
					hourmin = fieldsArr[j].value;
				}

				if (paramName=="agentmin")
				{
					hourmin = hourmin+":"+fieldsArr[j].value;
				}
			}

			if (paramName == "virtual_center")
			{
				if (fieldsArr[j].value=='Other')
				{
					Ext.Msg.show({
						title: pageName,
						msg: _virtualCenterCheck,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}
			}
			else if (paramName == "management_server")
			{
				if(fieldsArr[j].value=='Other')
				{
					Ext.Msg.show({
						title: pageName,
						msg: _hmcCheck,
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}
			}
		}
		if(paramNameLowerCase == "serverids")
		{
			if(paramValue.indexOf(",") > -1) {
				paramValue = paramValue.replace(/,/g,"$");
			}
		}
		if (fieldsArr[j].name == "credentialUserCount")
		{
			credentialParamCase = fieldsArr[j+1].name;
		}
		if(paramNameLowerCase!=null && paramNameLowerCase=="componentcredentialsneededtodovalidation")
		{
			paramWithValue=paramWithValue+"|#|"+paramValue;
		}
		else
		{
			if (paramNameLowerCase == 'encryptpasswordconfirmpassword' || paramNameLowerCase == 'authpassconfirmpassword')
			{
				continue;
			}
			paramWithValue=paramWithValue+"|#|-"+paramNameLowerCase+":"+paramValue;
		}
	}

	if(paramWithValue!=null && paramWithValue.indexOf("|#|")==0)
	{
		paramWithValue=paramWithValue.substring(3,paramWithValue.length);
	}

	if (Ext.getCmp('credentialUserCount') != undefined && Ext.getCmp('credentialUserCount') != "" && Ext.getCmp('credentialUserCount') != null)
	{
		var credentialUserCount = Ext.getCmp('credentialUserCount').getValue();

		for (var i=0;i<credentialUserCount;i++)
		{
			var userParam = "user" + "#" + i;
			var passwordParam = "pass" + "#" + i;
			credentialValue += ",";
			credentialValue += Ext.getCmp(userParam+"").getValue() + ":" + Ext.getCmp(passwordParam+"").getValue();
		}
	}
	else
	{
		if(Ext.getCmp('credentials') != null && Ext.getCmp('credentials') != undefined)
		{
			credentialValue = Ext.getCmp('credentials').getValue();
		}
	}
	return allowToUpdate+"*"+paramWithValue;
}



