function validateParams(serverType,formObj)
{
	var fieldsArr = formObj.getFields().items;

	//for (var i in fieldsArr)
	//{
		//console.log(fieldsArr[i].id);
	//}

	var allowToUpdate = true;

	var parameters="";

	for(j=0; j <fieldsArr.length; j++)
	{
		if (fieldsArr[j].xtype == 'radiogroup' || fieldsArr[j].xtype =='hiddenfield' )
		{
			continue;
		}

		var paramName = fieldsArr[j].name;
		var paramNameLowerCase = paramName.toLowerCase();
		var paramValue = fieldsArr[j].getValue();

		if (typeof paramValue == 'string')
		{
			paramValue = trim(paramValue);
		}

		var paramId = fieldsArr[j].id;
		var paramIdLowerCase = paramId.toLowerCase();
		if(Ext.isEmpty(paramId) || fieldsArr[j].disabled)
		{
			continue;
		}

		var paramIdValue = Ext.getCmp(paramId).getValue();
		if (typeof paramIdValue == 'string')
		{
			paramIdValue = trim(paramIdValue);
		}

		if (Ext.isEmpty(paramIdValue))
		{
			paramIdValue = '';
		}

		if (fieldsArr[j].xtype == "textfield" && fieldsArr[j].inputType != 'password')
		{
			if (paramValue == "")
			{
				Ext.Msg.show({
					title: pageName,
					msg: _checkempty,
					buttons: Ext.Msg.OK,
					icon: 'gen-warning size32 color-warning',
					fn: function() {
						Ext.getCmp(paramId).focus();
					}
				});
				allowToUpdate = false;
				break;
			}
			else if (paramNameLowerCase == "user")
			{
				var pattern = "@*+=|:;\"\'<>\/[]?,";
				if (!checkspecialnomess(paramValue,pattern))
				{
					Ext.Msg.show({
						title: pageName,
						msg: _checkspecial,
						buttons: Ext.Msg.OK,
						icon: 'gen-warning size32 color-warning',
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}
				else if(paramIdValue.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: pageName,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'gen-warning size32 color-warning',
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}
				else if(paramIdValue.indexOf("  ") > -1)
				{
					Ext.Msg.show({
						title: pageName,
						msg: _checkSpaces,
						buttons: Ext.Msg.OK,
						icon: 'gen-warning size32 color-warning',
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}
			}
			else if(paramNameLowerCase == "domain")
			{
				if (!checkDomain(paramIdValue,"false"))
				{
					allowToUpdate = false;
					Ext.getCmp(paramId).focus();
					break;
				}
			}
			else if(paramNameLowerCase == "username")
			{
				var splChars = "|:;\"\'<>,\/[]?";
				if (!checkSpecial(paramIdValue,splChars,paramId))
				{
					allowToUpdate = false;
					break;
				}
				else if(paramIdValue.indexOf("..") > -1)
				{
					Ext.Msg.show({
						title: pageName,
						msg: _checkdots,
						buttons: Ext.Msg.OK,
						icon: 'gen-warning size32 color-warning',
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}
				else if(paramIdValue.indexOf("  ") > -1)
				{
					Ext.Msg.show({
						title: pageName,
						msg: _checkSpaces,
						buttons: Ext.Msg.OK,
						icon: 'gen-warning size32 color-warning',
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}
			}
			else if(paramNameLowerCase == "snmpcommunity")
			{
				if (paramIdValue.indexOf("\"") > -1 || paramIdValue.indexOf("|") > -1)
				{
					Ext.Msg.show({
						title: pageName,
						msg: _snmpcomma,
						buttons: Ext.Msg.OK,
						icon: 'gen-warning size32 color-warning',
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}
			}
			else if(paramNameLowerCase == "snmpport")
			{
				if (((!checknumber("+",paramIdValue)) || paramIdValue == 0) && (paramIdValue.toLowerCase() != "none"))
				{
					Ext.Msg.show({
						title: pageName,
						msg: _valInt,
						buttons: Ext.Msg.OK,
						icon: 'gen-warning size32 color-warning',
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}

				if (!checkfordecimal(paramIdValue))
				{
					Ext.getCmp(paramId).focus();
					allowToUpdate = false;
					break;
				}
			}
			else if (paramNameLowerCase == "jmx_remote_port")
			{
				if ((!checknumber("+",paramIdValue)) || paramIdValue == 0)
				{
					Ext.Msg.show({
						title: pageName,
						msg: _checkInt,
						buttons: Ext.Msg.OK,
						icon: 'gen-warning size32 color-warning',
						fn: function() {
							Ext.getCmp(paramId).focus();
						}
					});
					allowToUpdate = false;
					break;
				}

				if (!checkfordecimal(paramIdValue))
				{
					Ext.getCmp(paramId).focus();
					allowToUpdate = false;
					break;
				}
			}
			else if(paramNameLowerCase == "process")
			{
				if(paramIdValue.indexOf(":") == -1)
				{
					if(paramIdValue.toUpperCase() != "NONE" && paramIdValue!= "(EG_RUNTIME)")
					{
						Ext.Msg.show({
							title: pageName,
							msg: _processvalidation,
							buttons: Ext.Msg.OK,
							icon: 'gen-warning size32 color-warning',
							fn: function() {
								Ext.getCmp(paramId).focus();
							}
						});
						allowToUpdate = false;
						break;

						var textvalTemp = paramIdValue.replace(/~/g,'');

						var checkProcess = processvalidation(textvalTemp,paramId);
						if(!checkProcess.success)
						{
							Ext.Msg.show({
								title: pageName,
								msg: checkProcess.msg,
								buttons: Ext.Msg.OK,
								icon: 'gen-warning size32 color-warning',
								fn: function() {
									Ext.getCmp(paramId).focus();
								}
							});
							allowToUpdate = false;
							break;
						}
					}
				}
			}
		}

		//Password validations
		if (fieldsArr[j].xtype == "textfield" && fieldsArr[j].inputType == 'password')
		{
			if(paramIdValue == "")
			{
				Ext.Msg.show({
					title: pageName,
					msg: _checkempty,
					buttons: Ext.Msg.OK,
					icon: 'gen-warning size32 color-warning',
					fn: function() {
						Ext.getCmp(paramId).focus();
					}
				});
				allowToUpdate = false;
				break;
			}

			if(!checkForPassValidity(paramIdValue))
			{
				Ext.getCmp(paramId).focus();
				allowToUpdate = false;
				break;
			}
		}

		//Text area validations
		if (fieldsArr[j].xtype == "textarea")
		{
			if(paramNameLowerCase == "process")
			{
				var textvalTemp = paramIdValue.replace(/~/g,'');
				if(textvalTemp.toUpperCase() != "NONE")
				{
					if(!checkSpecial(paramIdValue,"|#\"",paramId))
					{
						allowToUpdate = false;
						break;
					}
					var checkProcess = processvalidation(textvalTemp,paramId);
					if(!checkProcess.success)
					{
						Ext.Msg.show({
							title: pageName,
							msg: checkProcess.msg,
							buttons: Ext.Msg.OK,
							icon: 'gen-warning size32 color-warning',
							fn: function() {
								Ext.getCmp(paramId).focus();
							}
						});
						allowToUpdate = false;
						break;
					}
				}
				if(!isDoubleByteMgr && !validateSingleByte(paramIdValue))
				{
					Ext.Msg.show({
						title: pageName,
						msg: patternErrorMsg3,
						buttons: Ext.Msg.OK,
						icon: 'gen-warning size32 color-warning',
						fn: function() {
							Ext.getCmp(paramId).focus(false,200);
						}
					});
					allowToUpdate = false;
					break;
				}
				var procArr = paramIdValue.split(",");
				var regRep = /(:)(.)+/;
				var procNames = "";
				var str = "";
				for(var i= 0; i < procArr.length; i++)
				{
					str = procArr[i].replace(regRep,"").toLowerCase();
					var subStr = procNames.substring(procNames.lastIndexOf((","+str))); // Substring from last index to length of the string (default)

					if((subStr  == (","+str)) || (procNames.indexOf((","+str)+",") != -1 ) )
					{
						Ext.Msg.show({
							title: pageName,
							msg: _uniqueName,
							buttons: Ext.Msg.OK,
							icon: 'gen-warning size32 color-warning',
							fn: function() {
								Ext.getCmp(paramId).focus();
							}
						});
						allowToUpdate = false;
						break;
					}
					procNames = procNames +","+str;
				}
				
				numOfProcess = fieldsArr[j].value.split(',');// Added for ProcessTest
			}
		}
	}

	return allowToUpdate;
}



