<%
/****************************************************************************
*	Name			:	metricCatalog.jsp
*	Purpose			:	Used to view the threshold values and alarm policy for the selected component type and test.
						(one of the menu in EgToolKit.jsp)
******************************************************************************/
%>

<%@ page errorPage="EgProbs.jsp"%>

<%@ page import = "java.io.File"%>
<%@ page import = "java.io.BufferedWriter"%>
<%@ page import = "java.io.FileWriter"%>
<%@ page import = "java.io.ByteArrayOutputStream"%>
<%@ page import = "java.io.FileInputStream"%>
<%@ page import = "java.io.IOException"%>
<%@ page import="com.eg.EgConMonHelper"%>

<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page import = "com.eg.EgInstallInfo" %> 
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.EgSpecsInfo" %>
<%@ page import = "com.eg.EgThresholdInfo"%>
<%@ page import = "com.eg.EgTablesInfo"%>
<%@ page import = "com.egurkha.util.StringUtils"%>

<%@ page import="java.util.*" %>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import="com.eg.EgName"%>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	String tempStr = request.getParameter("temp");

	if(tempStr == null )
	{
		String sessionInUse = request.getParameter("sessionInUse");
		String pwd = request.getParameter("pwd");
		String authenticated = (String)session.getAttribute("authenticated");
		if (authenticated == null)
		{
			// Direct access from the browser address bar or from inside the toolkit via the tool
			if (pwd == null)
			{
				if (sessionInUse == null)
				{
					response.sendRedirect(request.getContextPath()+"/toolkitlogin?comeFrom=MetricsCatalog");
				}
				else
				{
%>
				<script>
					window.parent.location.href ="/final/toolkitlogin";
				</script>
<%
				}
			}
			else
			{
				// Direct access from the browser address bar
				if (!pwd.equals(EgConMonHelper.executePwd))
				{
					response.sendRedirect(request.getContextPath()+"/toolkitlogin?comeFrom=MetricsCatalog");
				}
				else
				{
					session.setAttribute("reqFrom","MetricsCatalog");
					String redirectURL = request.getContextPath()+"/toolkit";
					response.sendRedirect(redirectURL);
				}
			}
		}
		else
		{ 
			// Direct access from the browser address bar and session in use
			if (sessionInUse == null)
			{
				response.sendRedirect(request.getContextPath()+"/toolkit");
			}
		}
		session.setAttribute("reqFrom","MetricsCatalog");

		String comeFrom = request.getParameter("comeFrom");
		if (!StringUtils.isNull(comeFrom) && comeFrom.equals("MetricsCatalog"))
		{
			session.setAttribute("treeViewSrc","MetricsCatalog");
		}
	}
%>

<html>
	<head>
			<title>Metrics Catalog</title>
	</head>

	<style>
		.evenRow
		{
			background-color: rgb(216,216,216);
		}
		table.DataTable td
		{
			padding: 5px;
			width: 150px;
		}

	</style>
	<script language="javascript" src="/final/admin/eg_scripts/timeout.js"></script>
	<script>
		function validateForm()
		{
			var server = document.forms["form1"]["serverList"].value;
			var option = document.forms["form1"]["testNameOption"].value;

			if(server == "-1" || server == null)
			{
				alert("Please select the Server Type");
				return false;
			}
			else if(option == "-1" || option== null)
			{
				alert("Please select the Test Name");
				return false;
			}
			else
			{
				return true;
			}
		}

		function ReloadPage()
		{
			document.form1.submit();  
		}
	</script>

<link rel="stylesheet" href="eg_styles/eg_adminstyle.css" />

<body>

<%
	String serverType = (String) request.getParameter("serverList");
	String option = (String) request.getParameter("testNameOption");

	EgDiscInfo s2 = new EgDiscInfo("manager");
	String serverTypes[] = s2.getServerTypes();

	MappingNameSorter sorter = new MappingNameSorter("en_US");
	List listComponentTypes = Arrays.asList(serverTypes);
	listComponentTypes = sorter.getSortedCompTypeList(listComponentTypes);

	EgSpecsInfo specsInfo = new EgSpecsInfo ("manager");
	EgMappingInfo egMap = new EgMappingInfo("en_US");

	String tests[] = null;
	ArrayList aListTests = null;
	boolean testAvailable = false;
%>

	<div class="main" align = "center">
		<form name="form1" method="post" action="metricsCatalog.jsp">
			<input type="hidden" name="temp" value = "temp"/>
			<br>
			<table class="formTable" border="1" cellspacing="2" cellpadding="4" width="50%">
				<tr>
					<td width="50%" align="center"><b>Component Type</b></td>
					<td width="50%" align="center"><b>Test Name</b></td>
				</tr>
				<tr>
					<td width="50%" align="center">
						<select name="serverList" onchange="javascript:ReloadPage()" style="width: 300px">
							<option value="-1">Please select the component type</option>
<%
	//EgName class is used to hold name and its localised name.
	for (int j=0; j<listComponentTypes.size(); j++)
	{
		EgName nameObj = (EgName)listComponentTypes.get(j);
		String actualname = nameObj.getActualName();
		String localname = nameObj.getLocalName();
		if (actualname.equals(serverType))
		{
%>
			<option value="<%=actualname%>" selected><%=localname%></option>
<%
		}
		else
		{
%>
			<option value="<%=actualname%>"><%=localname%></option>
<%
		}
	}
	session.setAttribute("pageReload","true");
%>
						</select>
					</td>
					<td width="50%" align="center">
						<select name = "testNameOption" onchange="javascript:ReloadPage()" style="width: 300px">
							<option value="-1">Please select a test</option>
<%
	if(option != null && option.equals("all"))
	{
		testAvailable = true;
%>
							<option value="all" selected>All</option>
<%
	}
	else
	{
%>
							<option value="all">All</option>
<%
	}
	if(serverType!=null)
	{
		tests = specsInfo.getTestsForServer(serverType);
		if (tests != null)
		{
			aListTests = new ArrayList(Arrays.asList(tests));
			aListTests = sorter.getSortedTestList(aListTests);
			for (int i=0;i<aListTests.size();i++)
			{
				EgName name = (EgName)aListTests.get(i);
				String enableVal = name.getActualName();
				String enableDis = name.getLocalName();

				if (enableVal.endsWith("_cf"))
				{
					continue;
				}

				if (option != null && option.equals(enableVal))
				{
					testAvailable = true;
%>
							<option value="<%=enableVal%>" selected><%=enableDis%></option>
<%
				}
				else
				{
%>
							<option value="<%=enableVal%>"><%=enableDis%></option>
<%
				}
			}
		}
	}
%>
						</select>
					</td>
				</tr>
			</table>
		</form>
		<!-- form ends -->
<%
	if(serverType == null || serverType.equals("-1") || option == null || option.equals("-1") || !testAvailable)
	{
		return;
	}
%>
		<table class="DataTable" style="border:0px solid" width="95%">
			<tr><td><div align="right"><a href="downloadFile.jsp">Download as CSV file</a></div></td></tr>
		</table>
<%
	try
	{
		String outfilePath = EgInstallInfo.getInstallDir()+"/tmp/Catalog.csv";
		File outputFile = new File(outfilePath);
		if(!outputFile.exists())
		{
			outputFile.createNewFile();
		}
		BufferedWriter bw = new BufferedWriter(new FileWriter(outputFile));
		bw.write("Component Type : "+egMap.getComponentTypeDescription(serverType)+ " (" + serverType + ")");
		bw.newLine();
		bw.newLine();
		if(option.equalsIgnoreCase("all"))	//To display All tests for the selected component
		{
			for (int i=0;i<aListTests.size();i++)
			{
				EgName name = (EgName)aListTests.get(i);
				String enableVal = name.getActualName();
				String enableDis = name.getLocalName();

				if (enableVal.endsWith("_cf"))  // exclude config tests, if available
				{
					continue;
				}
%>
		<table class="DataTable" border="1" width="95%">
			<tr>
				<td colspan="7">
					<div align="left"><b><%=enableDis%>&nbsp;(<%=enableVal%>)</b></div>
				</td>
			</tr>
			<tr>
				<th rowspan="2">Measure</th>
				<th rowspan="2">Unit</th>
				<th colspan="5">Threshold</th>
			</tr>
			<tr>
				<th>Min/Max</th>
				<th>Critical</th>
				<th>Major</th>
				<th>Minor</th>
				<th>Alarm Policy</th>
			</tr>
<%
				bw.write("Test Name : " + enableDis + " (" + enableVal + ")");
				bw.newLine();
				bw.write("Measure,Unit,Threshold,,,,");
				bw.newLine();
				bw.write(",,Min/Max,Critical,Major,Minor,Alarm Policy");
				bw.newLine();

				EgThresholdInfo thresholdInfo = new EgThresholdInfo("manager");
				EgTablesInfo tablesInfo = new EgTablesInfo("manager");
				String measure[] = thresholdInfo.getMeasurementsForTest(enableVal);
				for (int j=0; j<measure.length; j++)
				{
					String measureName = egMap.getMeasureDescription(enableVal, measure[j]);
					String unit = tablesInfo.getUnitForMeasure(enableVal,measure[j]);
					if(unit == null || unit.length()==0)
					{
						unit = "-";
					}
					String thresholds[] = thresholdInfo.getThresholdAttributes (enableVal,measure[j]);
					String rest = "";
					if (thresholds != null && thresholds.length > 0)
					{
						for (int k=0; k<thresholds.length; k++)
						{
							if (thresholds[k].equals("-1"))
								thresholds[k] = "";
							else if (thresholds[k].equals("relative"))
								thresholds[k] = "auto";
							else if (thresholds[k].equals("absolute"))
								thresholds[k] = "fixed";
							else if (thresholds[k].equals("NONE"))
								thresholds[k] = "none";
							if (k == 0)
								rest += thresholds[k];
							else
								rest += ","+thresholds[k];
						}
						rest = rest.substring(rest.indexOf(",")+1);
					}
					bw.write(measureName+","+unit+",");

					if(j%2 == 0)
					{
%>
			<tr class="evenRow">
<%
					}
					else
					{
%>
			<tr>
<%
					}
%>
				<td rowspan="2"><%=measureName%></td><td rowspan="2"><%=unit%></td>
<%
					if(rest != null && rest.length()>0)
					{
						String minThresh = rest.substring(0,rest.indexOf(","));
						rest = rest.substring(rest.indexOf(",")+1);
						String maxThresh = rest.substring(0,rest.indexOf(","));
						rest = rest.substring(rest.indexOf(",")+1);
						String policyThresh = rest.substring(0);
						if(minThresh.indexOf("/")>-1)
						{
							String min_max = "min";
							bw.write("Min,");
%>
				<td>Min</td>
<%
							while(minThresh.indexOf("/")>-1)
							{
								String value = minThresh.substring(0,minThresh.indexOf("/"));
								if(value.indexOf("*")>-1 && value.indexOf("&")>-1)
								{
									double doubleVal = Double.parseDouble(value.substring(value.indexOf("&")+1,value.indexOf("*")))*100;
									value = min_max+"("+value.substring(0,value.indexOf("&"))+", "+Math.round(doubleVal)+"% of auto)";
								}
								else if(value.indexOf("*")>-1)
								{
									double doubleVal = Double.parseDouble(value.substring(0,value.indexOf("*")))*100;
									value = Math.round(doubleVal)+"% of auto";
								}
								bw.write("\""+value+"\",");
%>
				<td><%=value%></td>
<%
								minThresh = minThresh.substring(minThresh.indexOf("/")+1);
							}

							if(minThresh.indexOf("*")>-1 && minThresh.indexOf("&")>-1)
							{
								double doubleVal = Double.parseDouble(minThresh.substring(minThresh.indexOf("&")+1,minThresh.indexOf("*")))*100;
								minThresh = min_max+"("+minThresh.substring(0,minThresh.indexOf("&"))+", "+Math.round(doubleVal)+"% of auto)";
							}
							else if(minThresh.indexOf("*")>-1)
							{
								double doubleVal = Double.parseDouble(minThresh.substring(0,minThresh.indexOf("*")))*100;
								minThresh = Math.round(doubleVal)+"% of auto";
							}
							bw.write("\""+minThresh+"\",");
%>
				<td><%=minThresh%></td>
<%
						}
						else
						{
							bw.write("Min,-,-,-,");
%>
				<td>Min</td>
				<td>-</td>
				<td>-</td>
				<td>-</td>
<%
						}
						bw.write(policyThresh);
						bw.newLine();
%>
				<td rowspan="2"><%=policyThresh%></td>
			</tr>
<%
						bw.write(",,");
						if(j%2 == 0)
						{
%>
			<tr class="evenRow">
<%
						}
						else
						{
%>
			<tr>
<%
						}
						if(maxThresh.indexOf("/")>-1)
						{
							String min_max = "max";
							bw.write("Max,");
%>
				<td>Max</td>
<%
							while(maxThresh.indexOf("/")>-1)
							{
								String value = maxThresh.substring(0,maxThresh.indexOf("/"));
								if(value.indexOf("*")>-1 && value.indexOf("&")>-1)
								{
									double doubleVal = Double.parseDouble(value.substring(value.indexOf("&")+1,value.indexOf("*")))*100;
									value = min_max+"("+value.substring(0,value.indexOf("&"))+", "+Math.round(doubleVal)+"% of auto)";
								}
								else if(value.indexOf("*")>-1)
								{
									double doubleVal = Double.parseDouble(value.substring(0,value.indexOf("*")))*100;
									value = Math.round(doubleVal)+"% of auto";
								}
								bw.write("\""+value+"\",");
%>
				<td><%=value%></td>
<%
								maxThresh = maxThresh.substring(maxThresh.indexOf("/")+1);
							}
							if(maxThresh.indexOf("*")>-1 && maxThresh.indexOf("&")>-1)
							{
								double doubleVal = Double.parseDouble(maxThresh.substring(maxThresh.indexOf("&")+1,maxThresh.indexOf("*")))*100;
								maxThresh = min_max+"("+maxThresh.substring(0,maxThresh.indexOf("&"))+", "+Math.round(doubleVal)+"% of auto)";
							}
							else if(maxThresh.indexOf("*")>-1)
							{
								double doubleVal = Double.parseDouble(maxThresh.substring(0,maxThresh.indexOf("*")))*100;
								maxThresh = Math.round(doubleVal)+"% of auto";
							}
							bw.write("\""+maxThresh+"\",");
%>
				<td><%=maxThresh%></td>
<%
						}
						else
						{
							bw.write("Max,-,-,-,");
%>
				<td>Max</td>
				<td>-</td>
				<td>-</td>
				<td>-</td>
<%
						}
						bw.newLine();
%>
			</tr>
<%
					}
				}
				bw.newLine();
%>
		</table>
		<br>
<%
			}
		}
		else	// To display the value for selected test
		{
%>
		<table class="DataTable" border="1" width="95%">
			<tr>
				<td colspan="7">
					<div align="left"><b><%=egMap.getTestDescription(option)%>&nbsp;(<%=option%>)</b></div>
				</td>
			</tr>
			<tr>
				<th rowspan="2">Measure</th>
				<th rowspan="2">Unit</th>
				<th colspan="5">Threshold</th>
			</tr>
			<tr>
				<th>Min/Max</th>
				<th>Critical</th>
				<th>Major</th>
				<th>Minor</th>
				<th>Alarm Policy</th>
			</tr>
<%
			bw.write("Test Name : "+egMap.getTestDescription(option)+" ("+option+")");
			bw.newLine();
			bw.write("Measure,Unit,Threshold,,,,");
			bw.newLine();
			bw.write(",,Min/Max,Critical,Major,Minor,Alarm Policy");
			bw.newLine();

			EgThresholdInfo thresholdInfo = new EgThresholdInfo("manager");
			EgTablesInfo tablesInfo = new EgTablesInfo ("manager");
			String measure[] = thresholdInfo.getMeasurementsForTest(option);
			for (int j=0; j<measure.length; j++)
			{
				String measureName = egMap.getMeasureDescription(option, measure[j]);
				String unit = tablesInfo.getUnitForMeasure(option,measure[j]);
				if(unit == null || unit.length()==0)
					unit = "-";

				String thresholds[] = thresholdInfo.getThresholdAttributes (option,measure[j]);
				String rest = "";
				if (thresholds != null && thresholds.length > 0)
				{
					for (int k=0; k<thresholds.length; k++)
					{
						if (thresholds[k].equals("-1"))
							thresholds[k] = "";
						else if (thresholds[k].equals("relative"))
							thresholds[k] = "auto";
						else if (thresholds[k].equals("absolute"))
							thresholds[k] = "fixed";
						else if (thresholds[k].equals("NONE"))
							thresholds[k] = "none";
						if (k == 0)
							rest += thresholds[k];
						else
							rest += ","+thresholds[k];
					}
					rest = rest.substring(rest.indexOf(",")+1);
				}
				bw.write(measureName+","+unit+",");

				if(j%2 == 0)
				{
%>
			<tr class="evenRow">
<%
				}
				else
				{
%>
			<tr>
<%
				}
%>
				<td rowspan="2"><%=measureName%></td><td rowspan="2"><%=unit%></td>
<%
				if(rest != null && rest.length()>0)
				{
					String minThresh = rest.substring(0,rest.indexOf(","));
					rest = rest.substring(rest.indexOf(",")+1);
					String maxThresh = rest.substring(0,rest.indexOf(","));
					rest = rest.substring(rest.indexOf(",")+1);
					String policyThresh = rest.substring(0);

					if(minThresh.indexOf("/")>-1)
					{
						String min_max = "min";
						bw.write("Min,");
%>
				<td>Min</td>
<%
						while(minThresh.indexOf("/")>-1)
						{
							String value = minThresh.substring(0,minThresh.indexOf("/"));
							if(value.indexOf("*")>-1 && value.indexOf("&")>-1)
							{
								double doubleVal = Double.parseDouble(value.substring(value.indexOf("&")+1,value.indexOf("*")))*100;
								value = min_max+"("+value.substring(0,value.indexOf("&"))+", "+Math.round(doubleVal)+"% of auto)";
							}
							else if(value.indexOf("*")>-1)
							{
								double doubleVal = Double.parseDouble(value.substring(0,value.indexOf("*")))*100;
								value = Math.round(doubleVal)+"% of auto";
							}
							bw.write("\""+value+"\",");
%>
				<td><%=value%></td>
<%
							minThresh = minThresh.substring(minThresh.indexOf("/")+1);
						}
						if(minThresh.indexOf("*")>-1 && minThresh.indexOf("&")>-1)
						{
							double doubleVal = Double.parseDouble(minThresh.substring(minThresh.indexOf("&")+1,minThresh.indexOf("*")))*100;
							minThresh = min_max+"("+minThresh.substring(0,minThresh.indexOf("&"))+", "+Math.round(doubleVal)+"% of auto)";
						}
						else if(minThresh.indexOf("*")>-1)
						{
							double doubleVal = Double.parseDouble(minThresh.substring(0,minThresh.indexOf("*")))*100;
							minThresh = Math.round(doubleVal)+"% of auto";
						}
						bw.write("\""+minThresh+"\",");
%>
				<td><%=minThresh%></td>
<%
					}
					else
					{
						bw.write("Min,-,-,-,");
%>
				<td>Min</td>
				<td>-</td>
				<td>-</td>
				<td>-</td>
<%
					}
					bw.write(policyThresh);
					bw.newLine();
%>
				<td rowspan="2"><%=policyThresh%></td>
			</tr>
<%
					bw.write(",,");
					if(j%2 == 0)
					{
%>
			<tr class="evenRow">
<%
					}
					else
					{
%>
			<tr>
<%
					}
					if(maxThresh.indexOf("/")>-1)
					{
						String min_max = "max";
						bw.write("Max,");
%>
				<td>Max</td>
<%
						while(maxThresh.indexOf("/")>-1)
						{
							String value = maxThresh.substring(0,maxThresh.indexOf("/"));
							if(value.indexOf("*")>-1 && value.indexOf("&")>-1)
							{
								double doubleVal = Double.parseDouble(value.substring(value.indexOf("&")+1,value.indexOf("*")))*100;
								value = min_max+"("+value.substring(0,value.indexOf("&"))+", "+Math.round(doubleVal)+"% of auto)";
							}
							else if(value.indexOf("*")>-1)
							{
								double doubleVal = Double.parseDouble(value.substring(0,value.indexOf("*")))*100;
								value = Math.round(doubleVal)+"% of auto";
							}
							bw.write("\""+value+"\",");
%>
				<td><%=value%></td>
<%
							maxThresh = maxThresh.substring(maxThresh.indexOf("/")+1);
						}
						if(maxThresh.indexOf("*")>-1 && maxThresh.indexOf("&")>-1)
						{
							double doubleVal = Double.parseDouble(maxThresh.substring(maxThresh.indexOf("&")+1,maxThresh.indexOf("*")))*100;
							maxThresh = min_max+"("+maxThresh.substring(0,maxThresh.indexOf("&"))+", "+Math.round(doubleVal)+"% of auto)";
						}
						else if(maxThresh.indexOf("*")>-1)
						{
							double doubleVal = Double.parseDouble(maxThresh.substring(0,maxThresh.indexOf("*")))*100;
							maxThresh = Math.round(doubleVal)+"% of auto";
						}
						bw.write("\""+maxThresh+"\",");
%>
				<td><%=maxThresh%></td>
<%
					}
					else
					{
						bw.write("Max,-,-,-,");
%>
				<td>Max</td>
				<td>-</td>
				<td>-</td>
				<td>-</td>
<%
					}
					bw.newLine();
%>
			</tr>
<%
				}
			}
%>
		</table>
		<br>
<%
		}
		if(bw != null)
		{
			bw.close();
		}

		FileInputStream fis = new FileInputStream(outputFile);
		ByteArrayOutputStream bos = new ByteArrayOutputStream();
		byte[] buf = new byte[1024];
		try
		{
			for (int readNum; (readNum = fis.read(buf)) != -1;)
			{
				bos.write(buf, 0, readNum);
			}
		}
		catch (IOException ex)
		{
			ex.printStackTrace();
		}
		byte[] bytes = bos.toByteArray();

		if(fis!=null)
		{
			fis.close();
		}
		session.setAttribute("FileToDownload",bytes);
	}
	catch(Exception e)
	{
		e.printStackTrace();
	}
%>
	</div> <!-- end of "main" div-->
</body>
</html>



