Ext.define('BoxView.controller.Main',{
	extend : 'Ext.app.Controller',
	views : [
		'Main',
		'ErrorContainer',
		'FormItems',
		'configutilities.Tools',
		'configutilities.PrintPreview',
		'configutilities.SendMail'
	],
	refs : [
		{
			selector : 'main',
			ref : 'main'
		},
		{
			selector : 'formitems', 
			ref : 'formitems'
		},
		{
			selector : 'tools', 
			ref : 'tools'
		},
		{
			selector : 'errorcontainer', 
			ref : 'errorcontainer'
		}
	],

	init : function()
	{
		thisCtrl = this;
		this.buildFieldData()
		this.control({
			'main' :{
				'afterrender' : this.afterMainRender
			},
			'formitems combobox[id="ec_criteria"]' :{
				'select' : this.getInformations
			},
			'formitems combobox[id="ec_userOption"]' :{
				'select' : this.getInformations
			},
			'formitems trigger[id="searchId"]' :{
				'keydown' : this.searchName
			},
			'formitems combo[id="systemName"]' :{
				'select' : this.onSystemNameChange
			},
			'formitems button[id="submit"]' :{
				'click' : this.getSystemDetails
			},
			'tools' :{
				'afterrender' : this.loadTools
			},
			'tools button[id="saveBtn"]' : {
				'click' : this.saveAsPDF
			},
			'tools button[id="printBtn"]' : {
				'click' : this.printData
			},
			'tools button[id="csvBtn"]' : {
				'click' : this.saveAsCSV
			},
			'tools button[id="mailBtn"]' : {
				'click' : this.sendMail
			},
			'tools button[id="scheduleBtn"]' : {
				'click' : this.setschedule
			},
			'main #backBtnMain': {
				'click': this.forwardRequestedURI
			}
		});
	},


	buildFieldData : function()
	{
		Ext.Ajax.request({
			url		: config.urls.servletURL,
			params	: queryString+"&needData=yes",
			method	: 'POST',
			async	: false,
			success	: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) ) 
				{
					var jsonText = response.responseText;
					publicJSON = Ext.decode( jsonText );
					hiddenFieldsKeys = publicJSON['hiddenFields'];
					backOperation = publicJSON['backOption'];
				}
			}
		});
	},

	
	afterMainRender : function()
	{
		me = this;

		if(strRequestFrom != null && (strRequestFrom == "saveSchedule" || strRequestFrom == "BoxView")) //request from BoxView
		{
			var ec_userOption = me.getFormitems().getComponent('infoCont').getComponent('ec_userOption');
			var ec_criteria = me.getFormitems().getComponent('infoCont').getComponent('ec_criteria');
			var systemName = me.getFormitems().getComponent('infoCont').getComponent('systemName');
			var sysValue = systemName.getValue();
			ec_criteria.getStore().loadRawData(publicJSON['viewByList']);
			ec_criteria.setValue(publicJSON.selectedEcOpt);

			var searchObj = me.getFormitems().getComponent('infoCont').getComponent('searchId');

			if (publicJSON.selectedEcOpt != 'Component')
			{
				ec_userOption.getStore().loadRawData(publicJSON['specViewByList']);
				if(publicJSON.selectedUserOption != "" && publicJSON.selectedUserOption != undefined)
				{
					ec_userOption.setValue(publicJSON.selectedUserOption);
				}
				else
				{
					ec_userOption.setValue(publicJSON.specViewByList[0].valueField);
				}
				ec_userOption.setFieldLabel(publicJSON.specViewByTitle);
				ec_userOption.show();
			}
			else
			{
				ec_userOption.hide();
			}

			if(publicJSON.searchValue != null && publicJSON.searchValue != undefined)
			{
				searchObj.setValue(publicJSON.searchValue);
			}

			systemName.getStore().loadRawData(publicJSON['sysList']);

			if(publicJSON['selectedOS'] != "" && publicJSON['selectedOS'] != undefined)
			{
				systemName.setValue(publicJSON['selectedOS']);
			}
			else
			{
				systemName.setValue(publicJSON['sysList'][0].valueField);
			}

			if(publicJSON['selectedOS'] != "" && publicJSON['selectedOS'] != undefined)
			{
				me.setToolsState(true,true,true,true,true,false);
			}
			else if(publicJSON['sysList'][0].valueField != "" && publicJSON['sysList'][0].valueField != "-1")
			{
				me.setToolsState(true,true,true,true,true,false);
			}
			else
			{
				me.setToolsState(true,true,true,true,true,true);
			}

			if ((strRequestFrom != null && strRequestFrom == "saveSchedule"))
			{
				Ext.getCmp('backBtnMain').show();
				Ext.getCmp('bkSeperator').show();
				Ext.getCmp('submit').setText('Save');
			}

			if (!Ext.isEmpty(isOwnPageRequest) && isOwnPageRequest.toLowerCase() == 'yes')
			{
				me.getSystemDetails("fromOtherPage");
			}
		}
		else // request from other pages
		{
			Ext.getCmp('formitems').hide();
			Ext.getCmp('backBtnMain').show();
			Ext.getCmp('bkSeperator').show();
			Ext.getCmp('scheduleTool').hide();
			Ext.getCmp('schSep').hide();
			me.getSystemDetails("fromOtherPage");
		}
	},

	loadTools : function()
	{
		thisCtrl.getTools().loadIcon(
			true, //save
			true, //print
			true, //mail
			true, //csv
			true, //booklet
			true //schedule
		);
	},


	saveAsPDF : function(obj)
	{
		//var getSaveObj = Ext.widget('savepdf');
		//getSaveObj.savePDF(config.urls.pdfURL);
		downloadAsPDF(config.urls.pdfURL);
	},

	printData : function()
	{
		if(strRequestFrom == "BoxView")
		{
			var criteria = Ext.getCmp('ec_criteria').getValue();
			var sysNameValue = Ext.getCmp('systemName').getValue();
			var userOption = Ext.getCmp('ec_userOption').getValue();
			var userName = '';
			var userLanguage = '';

			var urlStr = "/final/config/BoxView/data/BoxViewJson.jsp";

			Ext.Ajax.request(
				{
					url : urlStr,
					//params : {
						//'systemName' : sysNameValue,
						//'ec_criteria' : criteria,
						//'ec_userOption' : userOption
					//},
					scope : this,
					method : 'POST',
					success: function(response)
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);

						userName = jsonData.userName;
						userLanguage = jsonData.userLanguage;

						var printPage = "/final/config/EcPrintDataReport.jsp?printData=yes&userName="+ userName + "&user_language=" + userLanguage + + "&ec_criteria=" + criteria + "&ec_userOption=" + userOption + "&ec_forPDF=No&selection_check=System&ec_type=INVENTORY&ec_trgttype=REPORT_BY_SYSTEM&ec_system=" + sysNameValue + "&systemName=" +sysNameValue;

						Ext.widget('print',{title : config.title.mainPageTitle}).show();
						var printContentDiv = Ext.select('#printContentDiv');
						printContentDiv.set({
							src: printPage
						});
					},
					failure : function(response)
					{
						console.log(response.responseText);
					}
				}
			);
		}
		else //request from other pages
		{
			var printQueryStr = publicJSON.printQueryStr;
			Ext.widget('print',{title : config.title.mainPageTitle}).show();
			var printContentDiv = Ext.select('#printContentDiv');
			printContentDiv.set({
				src: printQueryStr
			});

		}
		
	},

	saveAsCSV : function()
	{
		me = this;
		var ec_criteria = Ext.getCmp('ec_criteria').getValue();
		var ec_userOption = "";
		if (ec_criteria != 'Component')
		{
			 ec_userOption = Ext.getCmp('ec_userOption').getValue();
		}
		var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
		var urlStr = '../servlet/com.eg.EcCSVController';
		me.getFormitems().submit({
			url: urlStr,
			params: 'ec_criteria='+ec_criteria+'&ec_userOption='+ec_userOption+'&'+hiddenFields,
			standardSubmit : true,
			method: 'POST'
		});
	},

	sendMail : function()
	{
		Ext.widget('sendmail').show();
	},


	setschedule : function()
	{
		var op = "schedule";
		var me = this;

		var ec_criteria = Ext.getCmp('ec_criteria').getValue();
		var ec_userOption = Ext.getCmp('ec_userOption').getValue();
		var systemName = Ext.getCmp('systemName').getValue();
		var searchVal = Ext.getCmp('searchId').getValue();
		var hiddenFields = me.getHiddenFields(hiddenFieldsKeys);


		if (op == "schedule")
		{
			if (strRequestFrom != null && strRequestFrom == "saveSchedule")
			{
				var checkFlag = me.checkFormValidation();
				if (checkFlag == false)
				{
					return false;
				}
				me.getFormitems().submit({
					url: '/final/config/EcSaveScheduleNew.jsp',
					params :"id="+id+"&ec_criteria="+ec_criteria+"&system="+systemName+"&"+hiddenFields+"&searchName="+searchVal,
					standardSubmit : true,
					method: 'POST'
				});
			}
			else
			{
				var urlStr =  "/final/config/EcSaveScheduleNew.jsp?showWindow=yes&id="+id+"&request_from=BoxView&ec_criteria="+ec_criteria+"&system="+systemName+"&"+hiddenFields+"&searchName="+searchVal+"&com.eg.CSRF_NONCE="+csrfToken;
				scheduleWindow(urlStr);
			}
		}
		else if(op =="favorite")
		{
			window.location.href = "/final/config/EcSaveFavorite.jsp";
		}
		else
		{
			Ext.MessageBox.alert(config.title.mainPageTitle,".Illegal Access");
			return false;
		}
	},

	
	setToolsState : function(save,print,mail,csv,booklet,schedule)
	{
		var saveObj =me.getTools().getComponent('saveTool');
		var printObj =me.getTools().getComponent('printTool');
		var mailObj =me.getTools().getComponent('mailTool');
		var csvObj =me.getTools().getComponent('csvTool');
		var scheduleToolObj = me.getTools().getComponent('scheduleTool');
		var combineBookletObj = me.getTools().getComponent('bookletTool');

		if (!Ext.isEmpty(saveObj)) {
			saveObj.setDisabled(save);
		}
		if (!Ext.isEmpty(printObj)) {
			printObj.setDisabled(print);
		}
		if (!Ext.isEmpty(mailObj)) {
			mailObj.setDisabled(mail);
		}
		if (!Ext.isEmpty(csvObj)) {
			csvObj.setDisabled(csv);
		}
		if (!Ext.isEmpty(combineBookletObj)) {
			combineBookletObj.setDisabled(booklet);
		}
		if (!Ext.isEmpty(scheduleToolObj)) {
			scheduleToolObj.setDisabled(schedule);
		}
	},


	getInformations : function()
	{
		var hiddenFields = this.getHiddenFields(hiddenFieldsKeys);
		var ec_userOption = me.getFormitems().getComponent('infoCont').getComponent('ec_userOption');
		var ec_criteria = me.getFormitems().getComponent('infoCont').getComponent('ec_criteria');
		var systemName = me.getFormitems().getComponent('infoCont').getComponent('systemName');
		var sysValue = systemName.getValue();
		var searchId = me.getFormitems().getComponent('infoCont').getComponent('searchId');

		Ext.getCmp('hiddenPanel').hide();
		Ext.getCmp('searchId').setValue('');

		systemName.setDisabled(true);
		searchId.setDisabled(true);


		this.getFormitems().submit({
			url : config.urls.configServletURL,
			params :hiddenFields+"&cmd=BoxView&needData=yes&request_from="+strRequestFrom+"&id="+id,
			method : 'POST',
			success : function(form, action){

				var publicJSON = Ext.decode(action.response.responseText);
				hiddenFieldsKeys = publicJSON.hiddenFields;

				ec_criteria.getStore().loadRawData(publicJSON.viewByList);
				ec_criteria.setValue(publicJSON.selectedEcOpt);

				if (publicJSON.selectedEcOpt != 'Component')
				{
					ec_userOption.getStore().loadRawData(publicJSON.specViewByList);
					ec_userOption.setFieldLabel(publicJSON.specViewByTitle);
					ec_userOption.setValue(publicJSON['selectedUserOption']);
					ec_userOption.show();
				}
				else
				{
					ec_userOption.hide();
				}
				systemName.getStore().removeAll();
				systemName.getStore().loadRawData(publicJSON['sysList']);
				if(publicJSON['selectedOS'] != "" && publicJSON['selectedOS'] != undefined)
				{
					systemName.setValue(publicJSON['selectedOS']);
				}
				else
				{
					systemName.setValue(publicJSON['sysList'][0].valueField);
				}
				delete publicJSON;
				systemName.setDisabled(false);
				searchId.setDisabled(false);
				me.setToolsState(true,true,true,true,true,true);
			},
			failure: function(form, action) // if result page doest not contain success:true, this method fires
			{
				Ext.MessageBox.alert("Ajax Failed","Error in updating details");
			}
		});
	},


	
	getHiddenFields : function(hiddenFields)
	{
		var hiddenQstr = "";
		for (key in hiddenFields)
		{
			hiddenQstr += key+'='+hiddenFields[key]+"&";
		}
		return hiddenQstr;
	},

	showSrchIcon : function()
	{
		Ext.get('MyTrigger_0').setStyle('display','none');
		Ext.get('MyTrigger_1').setStyle('display','block');
		this.searchName();
	},

	searchName : function()
	{
		var hiddenFieldsKeys = publicJSON.hiddenFields;
		var hiddenFields = this.getHiddenFields(hiddenFieldsKeys);
		var egTitleSearchStr = Ext.getCmp('searchId').getValue();
		var ec_criteria = Ext.getCmp('ec_criteria').getValue();
		var ec_userOption = Ext.getCmp('ec_userOption').getValue();
		var systemName = me.getFormitems().getComponent('infoCont').getComponent('systemName');
		var sysValue = systemName.getValue();

		Ext.getCmp('hiddenPanel').hide();

		if (egTitleSearchStr == "" || egTitleSearchStr.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}

		var sub = checkspecial(egTitleSearchStr,"`~!@#$%^&*()+={}[]|\\;\"\'<>,?\/");
		if(!sub)
		{
			Ext.getCmp('searchId').focus();
			return;
		}

		var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
		myMask.show();

		this.getFormitems().submit({
			url: config.urls.configServletURL,
			params : "&cmd=BoxView&needData=yes&searchValue="+encodeURIComponent(egTitleSearchStr)+"&ec_criteria="+ec_criteria+"&ec_userOption="+encodeURIComponent(ec_userOption)+"&request_from="+strRequestFrom+"&id="+id,
			method: 'POST',
			success: function(form,action)
			{
				myMask.hide();
				var jsonData = Ext.decode(action.response.responseText);
				hiddenFieldsKeys = jsonData['hiddenFields'];
				systemName.getStore().removeAll();
				systemName.getStore().loadRawData(jsonData['sysList']);
				if (publicJSON['selectedOS'] != "" && publicJSON['selectedOS'] != undefined)
				{
					systemName.setValue(publicJSON['selectedOS']);
				}
				else
				{
					systemName.setValue(publicJSON['sysList'][0].valueField);
				}

				var selSysName = publicJSON['selectedOS'];

				if (selSysName != null && selSysName != "" && selSysName != undefined)
				{
					if ((sysValue == '-1') || (sysValue == 'Not Applicable'))
					{
						me.setToolsState(true,true,true,true,true,true);
					}
					else
					{
						me.setToolsState(false,false,false,false,false,false);
					}
				}
				else
				{
					me.setToolsState(true,true,true,true,true,true);
				}
			},
			failure: function(form, action) // if result page doest not contain success:true, this method fires
			{
				myMask.hide();
				Ext.MessageBox.alert("Ajax Failed","Error in updating details");
			}
		});
	},


	onSystemNameChange : function()
	{
		var systemName = me.getFormitems().getComponent('infoCont').getComponent('systemName');
		var sysValue = systemName.getValue();
		Ext.getCmp('hiddenPanel').hide();

		if((sysValue == '-1') || (sysValue == 'Not Applicable'))
		{
			me.setToolsState(true,true,true,true,true,true);
		}
		else
		{
			me.setToolsState(true,true,true,true,true,false);
		}
	},


	getSystemDetails : function(from)
	{
		if(from == "fromOtherPage")//reqFrom other page
		{
			var me = this;
			hiddenFieldsKeys = publicJSON.hiddenFields;
			var hiddenFields = this.getHiddenFields(hiddenFieldsKeys);
			var egTitleSearchStr = searchValue;
			
			var ec_criteria = ec_criteria;
			var ec_userOption = ec_userOption;
			var systemNameValue = systemName;

			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
			myMask.show();

			this.getFormitems().submit({
				url: config.urls.servletURL,
				params :queryString+"&needData=yes",
				method: 'POST',
				success: function(form,action)
				{
					myMask.hide();

					var jsonData = Ext.decode(action.response.responseText);
					hiddenFieldsKeys = jsonData['hiddenFields'];
					var details = jsonData['details'];
					var columnNames = jsonData['ColumnNames'];
					var gridTitle1 = jsonData['gridTitle'];
					var gridData = jsonData.gridData;
					var gridTitle2 = 'SYSTEM INFORMATION';
					var hasConfigDetails = jsonData['hasConfigDetails'];

					if (jsonData.errorText != null && jsonData.errorText != undefined)
					{
						Ext.getCmp('hiddenPanel').hide();
						me.getErrorcontainer().update('<table border="0" height="400px" width="100%"><tr><td align=center valign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+jsonData.errorText+'.</div></td></tr></table>');
						me.getErrorcontainer().show();
					}

					else
					{
						me.getErrorcontainer().hide();
						Ext.getCmp('hiddenPanel').show();
						if(systemNameValue == "All" && hasConfigDetails)
						{
							Ext.getCmp('formitems').collapse();
							var widhtForAllCol = 180;
							var columnCntArr = jsonData['columnCntArr'];
							columnCntArr.push('hidden_href');

							var columnsArray = new Array();
							var storeArray = new Array();
							Ext.getCmp('hiddenPanel').removeAll();

							var store = new Ext.data.Store({
								fields : columnCntArr,
								data: [],
							});

							/** Setting column names **/	

							for(var j=0;j<columnNames.length;j++)
							{
								var colName = "col_"+j;
								if(colName == "col_0")
								{
									columnsArray.push({
										text : "",
										dataIndex : colName,
										renderer : function(value, metaData, record, rowIndex, colIndex, store, view) 
										{
											var tmpTag = '<div class="iconConfigSystem"></div><a id="mouse" href="'+record.get("hidden_href")+'">'+value+'</a>';
											return tmpTag;
										},
										width : 180,
										locked : true
									});
								}
								else
								{
									columnsArray.push({
										text : "",
										dataIndex : colName,
										tdCls:'wrap-text',
										width : widhtForAllCol
									});
								}
							}

							columnsArray.push({
								text : 'hidden_href',
								dataIndex : 'hidden_href',
								hidden : true
							});

							Ext.getCmp('hiddenPanel').setTitle(gridTitle2);
							Ext.getCmp('hiddenPanel').getHeader().show();

							var mainGrid = Ext.create('Ext.grid.Panel',
							{
								cls:'gridSkin gridskin_config',
								id : 'gridskin_config',
								forceFit : true,
								store: new Ext.data.Store({
									fields : columnCntArr,
									data : []
								}),
								flex : 1,
								//bodyPadding : 10,
								queryMode: 'local',
								scroll : true,
								autoScroll: true,
								viewConfig: {
									deferEmptyText: true
								},
								//title : gridTitle2,
								emptyText:  '<table align="center" height="150"><tr><td align="center"> <img src="/final/config/images/spacer.gif" class="iconInformation"> <div class="commonErrorMsgText" id="noCompAlrtDiv">No data found for the selected system/combination</div> </td></tr></table>',
								columns : {
									defaults: {
										sortable: true,
										hideable: false,
										menuDisabled: true,
										draggable: false,
										resizable: false
									},
									items: columnsArray
								}
							});

							if(columnNames.length >= 5)
							{
								for(var i=1;i<columnNames.length;i++)
								{
									var col = mainGrid.columns[i];
									delete col.flex;
									col.width = 200;
								}
								mainGrid.doLayout();
							}
							else if(columnNames.length == 2 || columnNames.length == 3 || columnNames.length == 4)
							{
								for(var i=1;i<columnNames.length;i++)
								{
									var col = mainGrid.columns[i];
									if (col.flex) 
									{
										delete col.flex;
										col.width = 200;
									}
									else 
									{
										col.flex = 1;
									}  
								}
								mainGrid.doLayout();
							}
							Ext.getCmp('hiddenPanel').layout = 'fit';
							Ext.getCmp('hiddenPanel').add(mainGrid);
							Ext.getCmp('hiddenPanel').doLayout();


							for(var i=0;i<columnNames.length;i++)
							{
								mainGrid.columns[i].text = columnNames[i];
							}

							for (var i=0; i<gridData.length; i++)
							{
								for(var j=0;j<=gridData[i].measures.length;j++)
								{
									if(j == gridData[i].measures.length)
									{
										var value = new Object();
										value = gridData[i].measures[j-1];
										var url = new Object();
										url = gridData[i].hidden_href;;
										value['hidden_href'] = url; // adding url to value
										storeArray.push(value);
									}
								}
							}
							store.add(storeArray);
							mainGrid.reconfigure(store,columnsArray);

							if(gridData == "")
							{
								me.setToolsState(true,true,true,true,true,true);
							}
							else
							{
								me.setToolsState(false,false,false,false,false,false);
							}
						}
						else
						{
							Ext.getCmp('hiddenPanel').removeAll();
							var tableCont = Ext.create('Ext.container.Container',{
								flex:1,
								frame:true,
								align: 'center',
								//margin: '0 10 10 10',
								html: ''
							});

							Ext.getCmp('hiddenPanel').setTitle(gridTitle2);
							Ext.getCmp('hiddenPanel').getHeader().hide();
							if(details != "" && details != undefined)
							{
								var tableHtmlData = jsonData['tableHtmlData'];
								tableCont.removeAll();
								tableCont.update(tableHtmlData);
								tableCont.doLayout();
								Ext.getCmp('hiddenPanel').add(tableCont);
							}

							/* Create dynamic grid to set the column header dynamically */
							var mainGrid = Ext.create('Ext.grid.Panel',
							{
								cls:'gridSkin_expander',
								id:'noShadowGrid',
								store: new Ext.data.Store({
									fields : ['column_1','column_2','column_3','hidden_url_1','hidden_url_2','hidden_url_3','compType'],
									data : [],
									groupField : 'compType',
									sortOnLoad : false
								}),
								features: [{
									ftype: 'grouping',
									id : 'groupingId',
									groupHeaderTpl: [
										'{name:this.formatHeader}',
										{
											formatHeader: function(name) {
												return name;
											}
										}
									],
									hideGroupedHeader: false,
									startCollapsed: false,
								}],
								tools: [
									{
										xtype:'button',
										id :'tc',
										name :'tc',
										iconCls: 'iconCollapseAll',
										pressedCls:'iconExpandAll',
										enableToggle : true,
										style: {
											background: 'none',
											border: '0px'
										},
										listeners:{
											'toggle':function(obj, pressed, eOpts){
												var thisGrid = Ext.getCmp('noShadowGrid'),
												groupingFeature = thisGrid.view.getFeature('groupingId');
												if(pressed)
												{
													groupingFeature.collapseAll();
													obj.setIconCls('iconExpandAll');
												}
												else
												{
													groupingFeature.expandAll();
													obj.setIconCls('iconCollapseAll');
												}
												thisGrid.doLayout();
											}
										}
									}
								],
								margin : '0 0 10 0',
								queryMode: 'local',
								autoScroll: true,
								viewConfig: {
									cls:'gridSkin_expander_view',
									deferEmptyText: true
								},
								hideHeaders : true,
								title : '<span>'+(config.title.compMngOn).toUpperCase()+' '+gridTitle1+'</span>',
								emptyText:  '<table align="center" height="150"><tr><td align="center"> <img src="/final/config/images/spacer.gif" class="iconExclamation"> <div class="commonErrorMsgText" id="noCompAlrtDiv">No data found for the selected system/combination</div> </td></tr></table>',
								columns : {
									defaults: {
										sortable: true,
										hideable: false,
										menuDisabled: true,
										draggable: false,
										resizable: false
									},
									items: [
										{
											header : '',
											dataIndex: 'column_1',
											flex : 1,
											renderer : function(value, metaData, record, rowIndex, colIndex, store, view) {
												if(value != null && value != "" && value != undefined)
												{
													return '<img src="../images/clear.png" class="iconConfigSystem" style="vertical-align:baseline;" /><a href="'+record.get("hidden_url_1")+'" target="main" class="eg_monlink" style="vertical-align:text-bottom">' + value + '</a>';
												}
												else
												{
													metaData.tdCls += "OStable_emptytd";
													return '&nbsp';
												}
											}
										},
										{
											header : '',
											dataIndex: 'column_2',
											flex : 1,
											renderer : function(value, metaData, record, rowIndex, colIndex, store, view) {
												if(value != null && value != "" && value != undefined)
												{
													return '<img src="../images/clear.png" class="iconConfigSystem" style="vertical-align:baseline;" /><a href="'+record.get("hidden_url_2")+'" target="main" class="eg_monlink" style="vertical-align:text-bottom">' + value + '</a>';
												}
												else
												{
													metaData.tdCls += "OStable_emptytd";
													return '&nbsp';
												}
											}
										},
										{
											header : '',
											dataIndex: 'column_3',
											flex : 1,
											renderer : function(value, metaData, record, rowIndex, colIndex, store, view) {
												if(value != null && value != "" && value != undefined)
												{
													return '<img src="../images/clear.png" class="iconConfigSystem" style="vertical-align:baseline;" /><a href="'+record.get("hidden_url_3")+'" target="main" class="eg_monlink" style="vertical-align:text-bottom">' + value + '</a>';
												}
												else
												{
													metaData.tdCls += "OStable_emptytd";
													return '&nbsp';
												}
											}
										}
									]
								}
							});
							//console.log(mainGrid.columns[0].text); // gets the header of the 1st column
							Ext.getCmp('hiddenPanel').add(mainGrid);
							mainGrid.getStore().loadRawData(jsonData.gridData);

							if(gridData == "")
							{
								me.setToolsState(true,true,true,true,true,true);
							}
							else
							{
								me.setToolsState(false,false,false,false,false,false);
							}
						}
					}
				},
				failure: function(form, action) // if result page doest not contain success:true, this method fires
				{
					myMask.hide();
					Ext.MessageBox.alert("Ajax Failed","Error in updating details");
				}
			});
		}
		else //reqFrom boxview
		{
			var me = this;
			hiddenFieldsKeys = publicJSON.hiddenFields;
			var hiddenFields = this.getHiddenFields(hiddenFieldsKeys);
			var egTitleSearchStr = Ext.getCmp('searchId').getValue();
			
			var ec_criteria = Ext.getCmp('ec_criteria').getValue();
			var ec_userOption = Ext.getCmp('ec_userOption').getValue();
			var systemNameValue = me.getFormitems().getComponent('infoCont').getComponent('systemName').getValue();

			if (strRequestFrom != null && strRequestFrom == "saveSchedule")
			{
				me.setschedule();
			}
			else
			{
				var checkFlag = me.checkFormValidation();
				if (checkFlag == false)
				{
					return false;
				}
				var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Loading...'});
				myMask.show();

				this.getFormitems().submit({
					url: config.urls.servletURL,
					params :"cmd=BoxView&needData=yes&request_from="+strRequestFrom+"&searchValue="+encodeURIComponent(egTitleSearchStr)+"&systemName="+encodeURIComponent(systemNameValue)+"&ec_criteria="+ec_criteria+"&ec_userOption="+encodeURIComponent(ec_userOption),
					method: 'POST',
					success: function(form,action)
					{
						myMask.hide();

						var jsonData = Ext.decode(action.response.responseText);
						publicJSON = jsonData;
						hiddenFieldsKeys = jsonData['hiddenFields'];
						var details = jsonData['details'];
						var columnNames = jsonData['ColumnNames'];
						var gridTitle1 = jsonData['gridTitle'];
						var gridData = jsonData.gridData;
						var gridTitle2 = 'SYSTEM INFORMATION';
						var hasConfigDetails = jsonData['hasConfigDetails'];

						if (jsonData.errorText != null && jsonData.errorText != undefined)
						{
							Ext.getCmp('hiddenPanel').hide();
							me.getErrorcontainer().update('<table border="0" height="400px" width="100%"><tr><td align=center valign=middle><img src="/final/images/spacer.gif" class="iconInformation" valign="middle" /><div class="commonErrorMsgText">'+jsonData.errorText+'.</div></td></tr></table>');
							me.getErrorcontainer().show();
						}

						else
						{
							me.getErrorcontainer().hide();
							Ext.getCmp('hiddenPanel').show();
							if(systemNameValue == "All" && hasConfigDetails) // All option
							{
								Ext.getCmp('formitems').collapse();
								var widhtForAllCol = 180;
								var columnCntArr = jsonData['columnCntArr'];
								columnCntArr.push('hidden_href');

								var columnsArray = new Array();
								var storeArray = new Array();
								Ext.getCmp('hiddenPanel').removeAll();

								var store = new Ext.data.Store({
									fields : columnCntArr,
									data: []
								});

								/** Adding columns to the grid **/

								for(var j=0;j<columnNames.length;j++)
								{
									var colName = "col_"+j;
									if(colName == "col_0")
									{
										columnsArray.push({
											text : "",
											dataIndex : colName,
											renderer : function(value, metaData, record, rowIndex, colIndex, store, view) 
											{
												var tmpTag = '<img src="/final/images/clear.png" class="iconConfigSystem" style="vertical-align: text-bottom;" /><a  href="'+record.get("hidden_href")+'">'+value+'</a>';
												return tmpTag;
											},
											width : 180,
											locked : true
										});
									}
									else
									{
										columnsArray.push({
											text : "",
											dataIndex : colName,
											tdCls:'wrap-text',
											width : widhtForAllCol
										});
									}
								}

								columnsArray.push({
									text : 'hidden_href',
									dataIndex : 'hidden_href',
									hidden : true
								});

								/** Creating grid ***/
								Ext.getCmp('hiddenPanel').setTitle(gridTitle2);
								Ext.getCmp('hiddenPanel').getHeader().show();

								var mainGrid = Ext.create('Ext.grid.Panel',
								{
									cls:'gridSkin gridSkin_locking  gridSkin_config',
									id : 'gridskin_config',
									store: store,
									//margin : 10,
									//bodyPadding:10,
									queryMode: 'local',
									scroll : true,
									autoScroll: true,
									viewConfig: {
										deferEmptyText: true
									},
									//title : gridTitle2,
									emptyText:  '<table align="center" height="150"><tr><td align="center"> <img src="/final/config/images/spacer.gif" class="iconInformation"> <div class="commonErrorMsgText" id="noCompAlrtDiv">No data found for the selected system/combination</div> </td></tr></table>',
									columns : {
										defaults: {
											sortable: true,
											hideable: false,
											menuDisabled: true,
											draggable: false,
											resizable: false
										},
										items: columnsArray
									}
								});

								/// Setting width and flex to the grid columns

								if(columnNames.length >= 5)
								{
									for(var i=1;i<columnNames.length;i++)
									{
										var col = mainGrid.columns[i];
										delete col.flex;
										col.width = 200;
									}
									mainGrid.doLayout();
								}
								else if(columnNames.length == 2 || columnNames.length == 3 || columnNames.length == 4)
								{
									for(var i=1;i<columnNames.length;i++)
									{
										var col = mainGrid.columns[i];
										if (col.flex) 
										{
											delete col.flex;
											col.width = 200;
										}
										else 
										{
											col.flex = 1;
										}
									}
									mainGrid.doLayout();
								}
								Ext.getCmp('hiddenPanel').layout = 'fit';
								Ext.getCmp('hiddenPanel').add(mainGrid);
								Ext.getCmp('hiddenPanel').doLayout();

								/** Setting column names **/

								for(var i=0;i<columnNames.length;i++)
								{
									mainGrid.columns[i].text = columnNames[i];
									mainGrid.columns[i].height = 25;
									mainGrid.columns[i].cls = ('boxViewLockedGridHeader');
								}

								// data is added to the grid

								for (var i=0; i<gridData.length; i++)
								{
									for(var j=0;j<=gridData[i].measures.length;j++)
									{
										if(j == gridData[i].measures.length)
										{
											var value = new Object();
											value = gridData[i].measures[j-1];
											var url = new Object();
											url = gridData[i].hidden_href;;
											value['hidden_href'] = url; // adding url to value
											storeArray.push(value);
										}
									}
								}

								store.add(storeArray);
								mainGrid.reconfigure(store,columnsArray);

								if(gridData == "")
								{
									me.setToolsState(true,true,true,true,true,true);
								}
								else
								{
									me.setToolsState(false,false,false,false,false,false);
								}
							}
							else
							{
								Ext.getCmp('formitems').collapse();
								Ext.getCmp('hiddenPanel').removeAll();
								var tableCont = Ext.create('Ext.container.Container',{
									flex:1,
									frame:true,
									align: 'center',
									//margin: '0 10 10 10',
									html: ''
								});

								Ext.getCmp('hiddenPanel').setTitle(gridTitle2);
								Ext.getCmp('hiddenPanel').getHeader().hide();

								if(details != "" && details != undefined)
								{
									var tableHtmlData = jsonData['tableHtmlData'];
									tableCont.removeAll();
									tableCont.update(tableHtmlData);
									tableCont.doLayout();
									Ext.getCmp('hiddenPanel').add(tableCont);
								}

								var mainGrid = Ext.create('Ext.grid.Panel',
								{
									cls:'gridSkin_expander',
									id:'noShadowGrid',
									store: new Ext.data.Store({
										fields : ['column_1','column_2','column_3','hidden_url_1','hidden_url_2','hidden_url_3','compType'],
										data : [],
										groupField : 'compType'
									}),
									features: [{
										ftype: 'grouping',
										id : 'groupingId',
										groupHeaderTpl: [
											'{name:this.formatHeader}',
											{
												formatHeader: function(name) {
													return name;
												}
											}
										],
										hideGroupedHeader: false,
										startCollapsed: false,
									}],
									tools: [
										{
											xtype:'button',
											id :'tc',
											name :'tc',
											iconCls: 'iconCollapseAll',
											pressedCls:'iconExpandAll',
											enableToggle : true,
											style: {
												background: 'none',
												border: '0px'
											},
											listeners:{
												'toggle':function(obj, pressed, eOpts){
													var thisGrid = Ext.getCmp('noShadowGrid'),
													groupingFeature = thisGrid.view.getFeature('groupingId');
													if(pressed)
													{
														groupingFeature.collapseAll();
														obj.setIconCls('iconExpandAll');
													}
													else
													{
														groupingFeature.expandAll();
														obj.setIconCls('iconCollapseAll');
													}
													thisGrid.doLayout();
												}
											}
										}
									],
									margin : '0 0 10 0',
									queryMode: 'local',
									//scroll : true,
									layout : 'fit',
									autoScroll: true,
									viewConfig: {
										cls:'gridSkin_expander_view',
										deferEmptyText: true
									},
									hideHeaders : true,
									title : '<span>'+(config.title.compMngOn).toUpperCase()+' '+gridTitle1+'</span>',
									emptyText:  '<table align="center" height="150"><tr><td align="center"> <img src="/final/config/images/spacer.gif" class="iconExclamation"> <div class="commonErrorMsgText" id="noCompAlrtDiv">No data found for the selected system/combination</div> </td></tr></table>',
									columns : {
										defaults: {
											sortable: true,
											hideable: false,
											menuDisabled: true,
											draggable: false,
											resizable: false
										},
										items: [
											{
												header : '',
												dataIndex: 'column_1',
												flex : 1,
												renderer : function(value, metaData, record, rowIndex, colIndex, store, view) {
													if(value != null && value != "" && value != undefined)
													{
														return '<img src="../images/clear.png" class="iconConfigSystem" style="vertical-align:baseline;" /><a href="'+record.get("hidden_url_1")+'" target="main" class="eg_monlink" style="vertical-align:text-bottom">' + value + '</a>';
													}
													else
													{
														metaData.tdCls += "OStable_emptytd";
														return '&nbsp';
													}
												}
											},
											{
												header : '',
												dataIndex: 'column_2',
												flex : 1,
												renderer : function(value, metaData, record, rowIndex, colIndex, store, view) {
													if(value != null && value != "" && value != undefined)
													{
														return '<img src="../images/clear.png" class="iconConfigSystem" style="vertical-align:baseline;" /><a href="'+record.get("hidden_url_2")+'" target="main" class="eg_monlink" style="vertical-align:text-bottom">' + value + '</a>';
													}
													else
													{
														metaData.tdCls += "OStable_emptytd";
														return '&nbsp';
													}
												}
											},
											{
												header : '',
												dataIndex: 'column_3',
												flex : 1,
												renderer : function(value, metaData, record, rowIndex, colIndex, store, view) {
													if(value != null && value != "" && value != undefined)
													{
														return '<img src="../images/clear.png" class="iconConfigSystem" style="vertical-align:baseline;" /><a href="'+record.get("hidden_url_3")+'" target="main" class="eg_monlink" style="vertical-align:text-bottom">' + value + '</a>';
													}
													else
													{
														metaData.tdCls += "OStable_emptytd";
														return '&nbsp';
													}
												}
											}
										]
									}
								});
								Ext.getCmp('hiddenPanel').layout = 'auto';
								Ext.getCmp('hiddenPanel').add(mainGrid);
								mainGrid.getStore().loadRawData(jsonData.gridData);

								if(gridData == "")
								{
									me.setToolsState(true,true,true,true,true,true);
								}
								else
								{
									me.setToolsState(false,false,false,false,false,false);
								}
							}
						}
					},
					failure: function(form, action) // if result page doest not contain success:true, this method fires
					{
						myMask.hide();
						Ext.MessageBox.alert("Ajax Failed","Error in updating details");
					}
				});
			}
		}
	},

	forwardRequestedURI : function()
	{
		var me = this;
		if(backOperation.SearchPage != undefined && backOperation.SearchPage)
		{
			var urlStr = "../servlet/com.eg.EcConfigurationServletNew";
			me.getFormitems().submit({
				url: urlStr,
				params : "ec_rtype=Search&request_from=SystemPage&pageFrom=applink&com.eg.CSRF_NONCE="+csrfToken,
				standardSubmit : true,
				method: 'POST'
			});
		}
		else if(backOperation.InventoryByCompType != undefined && backOperation.InventoryByCompType)
		{
			var urlStr = '../servlet/com.eg.EcConfigurationServletNew';
			me.getFormitems().submit({
				url: urlStr,
				params : 'cmd=CompTypeInventory&componentType='+backOperation.compType+'&ec_criteria='+backOperation.ec_criteria+'&ec_userOption='+encodeURIComponent(backOperation.ec_userOption)+"&pageFrom=applink&com.eg.CSRF_NONCE="+csrfToken,
				standardSubmit : true,
				method: 'POST'
			});
		}
		else if(backOperation.IBOS != undefined && backOperation.IBOS)
		{
			var urlStr = '../servlet/com.eg.EcConfigurationServletNew';
			me.getFormitems().submit({
				url: urlStr,
				params : 'cmd=OSInventory&componentType='+backOperation.compType+'&ec_criteria='+backOperation.ec_criteria+'&ec_userOption='+encodeURIComponent(backOperation.ec_userOption)+"&pageFrom=applink&com.eg.CSRF_NONCE="+csrfToken,
				standardSubmit : true,
				method: 'POST'
			});
		}
		else if(backOperation.saveSchedule != undefined && backOperation.saveSchedule)
		{
			var me = this;
			hiddenFields = me.getHiddenFields(hiddenFieldsKeys);
			var urlStr = '/final/config/EcSaveScheduleNew.jsp';
			me.getFormitems().submit({
				url: urlStr,
				params : 'request_from='+strRequestFrom+'&id='+id+'&'+hiddenFields+"&pageFrom=applink&com.eg.CSRF_NONCE="+csrfToken,
				standardSubmit : true,
				method: 'POST'
			});
		}
		else if(backOperation.diskCapacity != undefined && backOperation.diskCapacity)
		{
			var urlStr = '../servlet/com.eg.EcConfigurationServletNew';

			me.getFormitems().submit({
				url: urlStr,
				params : 'cmd=DiskCapacity&rangeOption='+backOperation.rangeOption+'&startRange='+backOperation.startRange+'&endRange='+backOperation.endRange+'&ec_criteria='+backOperation.ec_criteria+'&ec_userOption='+encodeURIComponent(backOperation.ec_userOption)+"&pageFrom=applink&com.eg.CSRF_NONCE="+csrfToken,
				standardSubmit : true,
				method: 'POST'
			});
		}
		else if(backOperation.ramCapacity != undefined && backOperation.ramCapacity)
		{
			var urlStr = '../servlet/com.eg.EcConfigurationServletNew';

			me.getFormitems().submit({
				url: urlStr,
				params : 'cmd=RAMCapacity&rangeOption='+backOperation.rangeOption+'&startRange='+backOperation.startRange+'&endRange='+backOperation.endRange+'&ec_criteria='+backOperation.ec_criteria+'&ec_userOption='+encodeURIComponent(backOperation.ec_userOption)+"&pageFrom=applink&com.eg.CSRF_NONCE="+csrfToken,
				standardSubmit : true,
				method: 'POST'
			});
		}
		else if(backOperation.servicePackDistribution != undefined && backOperation.servicePackDistribution)
		{
			var urlStr = '../servlet/com.eg.EcConfigurationServletNew';

			me.getFormitems().submit({
				url: urlStr,
				params : 'ec_rtype=ServicePack&request_from=BoxView&osName='+backOperation.osName+'&spVersion='+backOperation.spVersion+'&ec_criteria='+backOperation.ec_criteria+'&ec_userOption='+encodeURIComponent(backOperation.ec_userOption)+"&pageFrom=applink&com.eg.CSRF_NONCE="+csrfToken,
				standardSubmit : true,
				method: 'POST'
			});
		}
		else if(backOperation.systemManufacturer != undefined && backOperation.systemManufacturer)
		{
			var urlStr = '../servlet/com.eg.EcConfigurationServletNew';

			me.getFormitems().submit({
				url: urlStr,
				params : 'ec_rtype=SystemManufacturer&manufacturer='+backOperation.manufacturer+'&ec_criteria='+backOperation.ec_criteria+'&ec_userOption='+encodeURIComponent(backOperation.ec_userOption)+"&pageFrom=applink&com.eg.CSRF_NONCE="+csrfToken,
				standardSubmit : true,
				method: 'POST'
			});
		}
		else if(backOperation.processor != undefined && backOperation.processor)
		{
			var urlStr = '../servlet/com.eg.EcConfigurationServletNew';

			me.getFormitems().submit({
				url: urlStr,
				params : 'ec_rtype=Processor&processorFamily='+backOperation.processorFamily+'&ec_criteria='+backOperation.ec_criteria+'&ec_userOption='+encodeURIComponent(backOperation.ec_userOption)+"&pageFrom=applink&com.eg.CSRF_NONCE="+csrfToken,
				standardSubmit : true,
				method: 'POST'
			});
		}
		else if(backOperation.ipAddress != undefined && backOperation.ipAddress)
		{
			var urlStr = '../servlet/com.eg.EcConfigurationServletNew';

			me.getFormitems().submit({
				url: urlStr,
				params : 'cmd=IPAddress&osName='+backOperation.osName+'&ec_criteria='+backOperation.ec_criteria+'&ec_userOption='+encodeURIComponent(backOperation.ec_userOption)+"&pageFrom=applink&com.eg.CSRF_NONCE="+csrfToken,
				standardSubmit : true,
				method: 'POST'
			});
		}
		else if(backOperation.gateway != undefined && backOperation.gateway)
		{
			var urlStr = '../servlet/com.eg.EcConfigurationServletNew';

			me.getFormitems().submit({
				url: urlStr,
				params : 'cmd=DefaultGateway&ipAddress='+backOperation.ipAddr+'&ec_criteria='+backOperation.ec_criteria+'&ec_userOption='+encodeURIComponent(backOperation.ec_userOption)+"&pageFrom=applink&com.eg.CSRF_NONCE="+csrfToken,
				standardSubmit : true,
				method: 'POST'
			});
		}
		else if(backOperation.softwareAvailability != undefined && backOperation.softwareAvailability)
		{
			var urlStr = '../servlet/com.eg.EcConfigurationServletNew';

			me.getFormitems().submit({
				url: urlStr,
				params : 'cmd=Availability&view=Software&softwareName='+backOperation.softwareName+'&countChoice='+backOperation.countChoice+'&osName='+backOperation.osName+'&testName='+backOperation.testName+'&ec_criteria='+backOperation.ec_criteria+'&ec_userOption='+encodeURIComponent(backOperation.ec_userOption)+"&request_from=SoftwareAvailability&pageFrom=applink&com.eg.CSRF_NONCE="+csrfToken,
				standardSubmit : true,
				method: 'POST'
			});
		}
		else if(backOperation.hotfixAvailabilty != undefined && backOperation.hotfixAvailabilty)
		{
			var urlStr = '../servlet/com.eg.EcConfigurationServletNew';

			me.getFormitems().submit({
				url: urlStr,
				params : 'cmd=Availability&view=Hotfix&softwareName='+backOperation.softwareName+'&viewCount='+backOperation.viewCount+'&osName='+backOperation.osName+'&testName='+backOperation.testName+'&ec_criteria='+backOperation.ec_criteria+'&ec_userOption='+encodeURIComponent(backOperation.ec_userOption)+"&request_from=HotfixAvailability&pageFrom=applink&com.eg.CSRF_NONCE="+csrfToken,
				standardSubmit : true,
				method: 'POST'
			});
		}
		else if(backOperation.historyBack != undefined && backOperation.historyBack)
		{
			window.history.back();
		}
	},


	checkFormValidation : function()
	{
		var ec_criteria = Ext.getCmp('ec_criteria').getValue();
		var ec_userOption = Ext.getCmp('ec_userOption').getValue();
		var systemNameValue = me.getFormitems().getComponent('infoCont').getComponent('systemName').getValue();


		var tempCriteria = "";
		var tempUserOption = "";

		if (ec_criteria != null && ec_criteria != undefined)
		{
			tempCriteria = ec_criteria;
		}
		if (ec_userOption != null && ec_userOption != undefined)
		{
			tempUserOption = ec_userOption;
		}

		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
		{
			if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
			{
				if (tempCriteria == "Zone")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorZone);
					return false;
				}
				else if (tempCriteria == "Service")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorService);
					return false;
				}
				else if (tempCriteria == "Segment")
				{
					Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorSegment);
					return false;
				}
			}
		}

		if((systemNameValue == '-1') || (systemNameValue == 'Not Applicable'))
		{
			Ext.MessageBox.alert(config.title.mainPageTitle,config.msgs.errorSys);
			return false;
		}
	}
	
});


function doCloseWin()
{
	Ext.getCmp('scheduleWin').destroy();
}




