Ext.define('BoxView.view.FormItems', {
	extend : 'Ext.form.Panel',
	alias : 'widget.formitems',
	id : 'formitems',
	cls:'formOuter accordionArrow',
	margin: '8 5 5 5',

	requires : [
		'utilities.ScrollCombo'
	],
	collapsible: true,
	items : [
		{
			xtype : 'container',
			id : 'infoCont',
			margin : 10,
			layout : {
				type : 'hbox',
				pack : 'center',
				align : 'center'
			},
			defaults : {
				labelSeparator : '',
				labelAlign : 'top'
			},
			items : [
				{
					xtype:'combo',
					cls: 'dropdown',
					width: 130,
					editable : false,
					fieldLabel:config.title.viewByTitle,
					name: 'ec_criteria',
					id: 'ec_criteria',
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField : 'displayField',
					valueField : 'valueField',
					queryMode : 'local',
					margin: '0 0 0 10'
				},
				{
					xtype:'scrollcombo',
					width : 200,
					cls: 'dropdown',
					fieldLabel:'Zone',
					id: 'ec_userOption',
					name: 'ec_userOption',
					store: new Ext.data.Store({
						fields : ['displayField', 'valueField'],
						data : []
					}),
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local',
					hidden: true,
					margin: '0 0 0 10'
				},
				{
					xtype : 'trigger',
					cls :'whitedropdown_search',
					fieldLabel : config.title.srchTitle,
					id : 'searchId',
					trigger1Cls : 'x-form-clear-trigger',
					trigger2Cls : 'x-form-search-trigger',
					emptyText : 'Search',
					margin: '0 0 0 10',
					hidden : true,

					onTrigger1Click : function() {
						this.reset();
						thisCtrl.showSrchIcon();
					},
					onTrigger2Click : function() {
						thisCtrl.searchName(this.getValue());
					},
					getTriggerMarkup : function() {
						var me = this,
						i = 0,
						hideTrigger = (me.readOnly || me.hideTrigger),
						triggerCls,
						triggerBaseCls = me.triggerBaseCls,
						triggerConfigs = [],
						unselectableCls = Ext.dom.Element.unselectableCls,
						style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
						cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

						if (!me.trigger1Cls) {
							me.trigger1Cls = me.triggerCls;
						}

						for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++)
						{
							if (i == 0)
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style + "display:none;",
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i,
										triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
							else
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+i,
									style: style,
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
						}
						triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-last';
						return Ext.DomHelper.markup(triggerConfigs);
					}
				},
				{
					xtype : 'scrollcombo',
					cls: 'dropdown',
					fieldLabel : config.title.sysTitle,
					id : 'systemName',
					itemId : 'systemName',
					name : 'systemName',
					store :  new Ext.data.Store(
					{
						fields: ['displayField','valueField'],
						data: []
					}),
					queryMode : 'local',
					displayField :'displayField',
					valueField : 'valueField',
					margin: '0 0 0 10',
					width : 250
				},
				{
					xtype : 'button',
					text : config.title.submitTitle,
					action : 'submit',
					id : 'submit',
					cls: 'button20',
					margin: '20 0 0 10',
					width: 80
				}
			]
		}
	],
	listeners:
	{
		afterrender:function(panel)
		{
			var headerObj = Ext.getCmp("formitems_header");
			headerObj.removeCls("x-panel-header-default");
		},
		collapse: function()
		{
			var titleStr = '';
			var selectedEcOpt = publicJSON.selectedEcOpt;
			var selectedUserOptionText = publicJSON.selectedUserOption;
			var selectedOsName = Ext.getCmp("systemName").getValue();

			if (selectedEcOpt != null &&  selectedEcOpt != "-1")
			{
				if (selectedEcOpt == "Component")
				{
					titleStr = '<span class="formSelectionName" style="font-weight:normal;">View By</span> - <span class="formSelectionValue">'+selectedEcOpt+'</span>';
				}
				else
				{
					if (selectedUserOptionText != null && selectedUserOptionText != "-1")
					{
						titleStr = '<span class="formSelectionName" style="font-weight:normal;">View By</span> - <span class="formSelectionValue">'+selectedEcOpt+'</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="formSelectionName" style="font-weight:normal;">'+selectedEcOpt+'</span> - <span class="formSelectionValue">'+selectedUserOptionText+'</span>';
					}
					else
					{
						titleStr = '<span class="formSelectionName" style="font-weight:normal;">View By</span> - <span class="formSelectionValue">'+selectedEcOpt+'</span>';
					}
				}
			}

			if (selectedOsName != null && selectedOsName != "-1" && selectedOsName != undefined)
			{
				titleStr = titleStr + '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="formSelectionName" style="font-weight:normal;">System</span> - <span class="formSelectionValue">'+selectedOsName+'</span>';
			}
			Ext.getCmp("formitems").setTitle(titleStr);
		},
		expand: function()
		{
			Ext.getCmp("formitems").setTitle('');
		}
	}
});




